<?php

namespace Drupal\transform_api\EventSubscriber;

use Drupal\Core\EventSubscriber\CustomPageExceptionHtmlSubscriber;
use Drupal\transform_api\Routing\TransformRouteEnhancer;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Event\ExceptionEvent;

/**
 * Exception subscriber for handling custom JSON error pages.
 */
class CustomPageExceptionTransformSubscriber extends CustomPageExceptionHtmlSubscriber {

  /**
   * {@inheritdoc}
   */
  protected static function getPriority() {
    return 10;
  }

  /**
   * {@inheritdoc}
   */
  protected function getHandledFormats() {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function on403(ExceptionEvent $event) {
    $request = $event->getRequest();
    if (TransformRouteEnhancer::isTransformRequest($request)) {
      $custom_403_path = $this->configFactory->get('system.site')->get('page.403');
      if (!empty($custom_403_path)) {
        $custom_403_path .= '?' . $request->getQueryString();
        $this->makeSubrequestToCustomPath($event, $custom_403_path, Response::HTTP_FORBIDDEN);
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function on404(ExceptionEvent $event) {
    $request = $event->getRequest();
    if (TransformRouteEnhancer::isTransformRequest($request)) {
      $custom_404_path = $this->configFactory->get('system.site')->get('page.404');
      if (!empty($custom_404_path)) {
        $custom_404_path .= '?' . $request->getQueryString();
        $this->makeSubrequestToCustomPath($event, $custom_404_path, Response::HTTP_NOT_FOUND);
      }
    }
  }

}
