<?php

namespace Drupal\transform_api\Transform;

use Drupal\transform_api\TransformationTypeInterface;

/**
 * Base class for transforms with a transform type plugin.
 */
abstract class PluginTransformBase extends TransformBase {

  /**
   * The plugin belonging to this transform.
   *
   * @var \Drupal\transform_api\TransformationTypeInterface
   */
  protected TransformationTypeInterface $plugin;

  /**
   * Return the plugin belonging to this transform.
   *
   * @return \Drupal\transform_api\TransformationTypeInterface
   *   The plugin belonging to this transform.
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   */
  protected function getPlugin(): TransformationTypeInterface {
    if (empty($this->plugin)) {
      /** @var \Drupal\transform_api\TransformationTypeManager $transformationTypeManager */
      $transformationTypeManager = \Drupal::service('plugin.manager.transform_api.transformation_type');
      $this->plugin = $transformationTypeManager->createInstance($this->getTransformType(), $this->getValues());
    }
    return $this->plugin;
  }

  /**
   * {@inheritDoc}
   *
   * @throws \Drupal\Component\Plugin\Exception\PluginException
   */
  public function transform() {
    return $this->getPlugin()->transform($this);
  }

}
