<?php

namespace Drupal\transform_api\Transform;

/**
 * A transform for request paths.
 */
class RequestPathTransform extends PluginTransformBase {

  /**
   * Construct a RequestPathTransform.
   *
   * @param string $url
   *   Url that needs to be transformed.
   * @param array $regions
   *   (Optional) Only transform these regions, otherwise transform them all.
   */
  public function __construct($url, array $regions = []) {
    $this->values = [
      'url' => $url,
      'regions' => $regions,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getTransformType() {
    return 'request_path';
  }

}
