<?php

namespace Drupal\transform_api;

/**
 * Contains all events thrown in the transform api module.
 */
final class TransformEvents {

  /**
   * The MAIN_CONTENT event occurs when the transforming the main content.
   *
   * This is usually done through the SystemMainTransformBlock transform block.
   *
   * This event allows you to adapt different types of main content to be
   * transformed often through a new TransformType.
   *
   * @Event("Symfony\Component\HttpKernel\Event\ViewEvent")
   */
  public const MAIN_CONTENT = 'transform_api.main_content';

}
