# Total Translation Export: Technical Details

## Exported files layout
For a english to german translated site, `drush tex` command exports these files:
- custom-strings.de.po # Here's translations of your custom strings.
- custom-translated-contrib-strings.de.po # Here's your overrides of contrib strings.
- adjustments/
  - custom-strings.untranslatable.pot # Here you add the clutter you don't want to translate.
- already-done/
  - contrib-translated-common-strings.de._po # Your custom strings that are identical to contrib ones and already translated there.
- templates/
  - custom-strings.all-with-origins.pot # Here you can look up where a string comes from.
  - custom-strings.translatable.pot # A template with all strings to start a new language.

## How it's done in detail
- For total control of contrib translations, run `drush bliss:translations-dir-init` or `drush tdi`,
  which configures the core translation directory (containing shipped translations for core and contrib)
  to be `../translations`.
  You can change that directory or even omit that step, but this is the well-tested configuration.
  This way, **all translation changes** take the way over a git commit.
- To export custom and config translations, run `drush bliss:translations-extract` or `drush tex`, which
  - extracts all translatable strings from `modules/custom/*` code (via potx module)
  - extracts all config translatable strings
  - tracks all locations where these strings come from
  - exports all translations and separates custom / contrib translatable strings, and customized / shipped translations
  - writes all that info into a structured set of files
- You can then (see file list below)
  - find all custom and config translatable strings and translations in `../translations/custom`
  - add and update translations
  - mark strings as untranslatable
- To re-import your translations, run `drush bliss:translations-import` or `drush tim`
  (make it part of your deployment workflow!).
- For developers: Translation extraction has an extension API. See it in action in `TranslationExtractionHooksBase` and its inheritors.

### custom-strings.all-with-origins.pot
All translatable strings and where they have been found. It contains entries like so:
```
#: File:modules/custom/c4c/src/Plugin/Block/C4cCheckoutProgressBlock.php:19
#: Config:block.block.c4ccheckoutprogress:settings.label
msgid "CrowdPower Checkout"
msgstr ""
```

### custom-strings.translatable.pot
All translatable strings without translations (pot = template). It contains entries like so:
```
msgid "CrowdPower Checkout"
msgstr ""
```

### custom-strings.XX.po
All custom translations of custom strings. It contains entries like so:
```
msgid "CrowdPower Checkout"
msgstr "CrowdPower Vertragsformular"
```

### custom-translated-contrib-strings.XX.po
If you change a translation from a contrib module, it gets an invisible "customized" mark and populates this file.
It contains entries like so:
```
msgid "Annymous user"
msgstr "Wer zum Geier?"
```

Note: Additionally, "vanished" translatable strings (deleted from code or config) end up here, because the module
does not find them (anymore) in custom strings and "thinks" they must be contrib strings.
(Due to core limitations, a fix needs scanning all module translation files. Patch appreciated.)

### contrib-translated-common-strings.XX._po
Does your custom code or config use a "common" translatable string like "Depth", i.e. one that is already used
in core or contrib and translated there (and does not have a customized translation)? Here they are, just for your info, enlightenment, and to have "total translation control".
(The "_po" extension means "do not import". The translations contained in this file are already contained in module
or core po files and imported from there.)

It contains entries like so:
```
msgid "Depth"
msgstr "Tiefe"
```

Note: Due to translation server limitations (no untranslated strings provided), this does not common strings with no shipped translation. Help with an upstream solution appreciated.

### adjustments/custom-strings.untranslatable.pot
- As "adjustments" signals, this file is filed by **you**.
- Any string added here is excluded from translations export and does not clutter up the other translation files.
- This is useful for
  - config strings that are not really translatable,
  - or for admin-facing custom strings that you never want to translate.
- It contains entries like so:

```
msgid "%"
msgstr ""

msgid ", "
msgstr ""

msgid "Hello admin, my old friend!"
msgstr ""
```

## Core limitation: Untranslated contrib strings
The *total translation control* that the above yields, has one blind spot:
If a contrib module has a translatable string with no translation, TranslationBliss can not know.

This is because the Drupal community translation server does not provide info about such untranslated strings
(and extracting core and all modules ourselves would take ages).
A translation server update feature request may pave the way to improve this.
Help appreciated.

