# Translate from any language

## The pain

Drupal is built for having source strings (code or config) in american english.
For some folks though it is more natural to maintain wording and glossary in their native tongue.
Or a project started monolingual, and the need for multilingual comes later.
Or a project is started in english for fear it someday might need translations.

Suffer no more. You can start any project in your native tongue, and add translations later.

## How to install and use: Translation of non-english source strings

### As a php developer, translate non-english code strings to any language
- Needs the base module (API and Drush commands), install with `drush en translation_bliss`
- In your code, e.g. instead of `$this->t('Sausage')`, use `$this->tFrom('de', 'Schnitzel')` (of course you are free to create even more concise methods like `$this->tDe('Schnitzel')`)
- See source code and usage in `SrcLangTest` and `SrcLangStringTranslationTrait`.

### As a site builder, translate non-english config strings to any language
- This comes for free with the *Simplified and unified config translations* module.
- Enable with `drush en translation_bliss_config`

### How it works
- Non-english translatable config strings get a "srclang" context prefix like so:
```
msgctxt "[srclang=de]"
msgid "Schnitzel"
msgstr ""
```
- If they have a context, it is preserved:
```
msgctxt "[srclang=de]Neuseeland"
msgid "Kiwi"
msgstr ""
```
