# Simplified and unified config translation

## The pain

## How to install
- Enable with `drush en translation_bliss_config`

## How to use **instead of** core config_translation module
- After installation, every translatable config string is automatically translated with the corresponding interface translation. It's as simple as that!

## How to use **in addition to** core config_translation module

- If you don't like the automatic UI translation of a config string, override it with config_translation.

## How to switch over
- For legacy sites: Existing language overrides for core and contrib are not needed anymore, you can and should delete the content of the config/sync/language directory.

## Non-english config
- You get translation of non-english config for free via srclang context prefixes.

## The problems with config_translation

- Core config_translation has 2 completely different config regimes:
  - Custom config: You have to translate every config string on its own. No help from existing UI translations.
  - "Shipped" config: Every config that comes from a module's config/install, is "shipped". Its translations are synced back and forth with UI translations, i.e.:
    - If you change a UI translation, ALL matching shipped config translations are updated.
    - If you change a shipped config string translation, the corresponding UI translation is updated.
  - Some pain points of this:
    - For the config/sync/language directory, there is no easy way to review your manually translated config, because you can't tell it from the bulk of auto-synced shipped config.
    - If you "feature" some config to mymodule/config/install, its behavior wrt translation changes completely, because after that it is shipped config.

## The profits of Translation Bliss

- All config now profits from interface translations.
- Overriding individual config strings is still possible though.
- Which results in a small, reviewable custom-strings.xx.po (see translation export), and possibly a small, reviewable config/sync/language/xx.
- If a config is "featured" to config/sync, nothing changes.

