# Translation Owner Manager

**Version**: 1.x  
**Requires**: Drupal 10, Drush 12.5+  
**License**: GPL-2.0-or-later  

---

## Overview

The **Translation Owner Manager** module provides tools to manage the ownership (UID) of translated nodes in Drupal. It is particularly useful for content managers or developers who need to bulk edit or programmatically update the owner of translated content.

This module includes Drush commands for streamlined command-line execution.

---

## Features

- **Drush Commands**:
  - Update the owner (UID) of a single node translation.
  - Perform bulk updates of translation owners using a CSV file.
  - Robust error handling that continues processing even when individual nodes fail.
  - Generates detailed CSV reports with success/failure status for each processed node.
- Fully compatible with **Drush 12.5** and PHP 8.

---

## Requirements

- Drupal 10 or later.
- Drush 12.5 or later.
- PHP 8.0 or later.

---

## Installation

1. Download the module via Composer:
   ```bash
   composer require drupal/translation_owner
   ```

2. Enable the module:
   ```bash
   drush en translation_owner
   ```

3. Clear Drush cache to register the commands:
   ```bash
   drush cache:clear drush
   ```

---

## Usage

### Single Translation Update

To update the owner (UID) of a specific node translation, use the following Drush command:

```bash
drush translation-owner:update-uid <nid> <langcode> <new_uid>
```

**Example**:
```bash
drush translation-owner:update-uid 113486 fr 28716
```

This updates the French translation of node `113486` to have user ID `28716` as its owner.

---

### Bulk Translation Update

To update multiple translations via a CSV file:

1. Prepare a CSV file with the following structure:
   ```
   nid,langcode,new_uid
   123,en,5
   456,fr,8
   ```

2. Run the bulk update command:
   ```bash
   drush translation-owner:bulk-update /path/to/file.csv
   ```

**Note**: The CSV file must contain a header row with `nid`, `langcode`, and `new_uid` columns.

### Report Generation

The bulk update command automatically generates a timestamped CSV report in the same directory as the input file. The report contains four columns:
- `nid`: Node ID
- `langcode`: Language code  
- `new_uid`: New user ID
- `status`: SUCCESS or FAILED

Example report file: `translation_owner_report_2025-08-16_14-30-45.csv`

---

## Command Aliases

For convenience, the following aliases are available:

- `translation-owner:update-uid`: Aliases `tou`, `translation-owner-update`.
- `translation-owner:bulk-update`: Aliases `toub`, `translation-owner-bulk`.

---

## Developer Notes

### Extending the Module

If you wish to extend the module or integrate it with custom workflows:
- Commands are defined in the `\Drupal\translation_owner\Drush\Commands\TranslationOwnerCommands` class.
- Dependencies are injected via the `drush.services.yml` file.
- The module includes robust error handling for path/pathauto related issues.

### Debugging

If commands do not appear, ensure you clear Drush cache:
```bash
drush cache:clear drush
```

---

## Support

This module is maintained by the Drupal community. Please report issues in the [Drupal.org issue queue](https://www.drupal.org/project/issues/translation_owner).
