# Translation Owner Manager

**Version**: 1.x  
**Requires**: Drupal 9 or 10, Drush 11+  
**License**: GPL-2.0-or-later  

---

## Overview

The **Translation Owner Manager** module provides tools to manage the ownership (UID) of translated nodes in Drupal. It is particularly useful for content managers or developers who need to bulk edit or programmatically update the owner of translated content.

This module includes Drush commands for streamlined command-line execution.

---

## Features

- **Drush Commands**:
  - Update the owner (UID) of a single node translation.
  - Perform bulk updates of translation owners using a CSV file.
- Fully compatible with **Drush 11** and PHP 8.

---

## Requirements

- Drupal 9.4 or later.
- Drush 11 or later.
- PHP 8.0 or later.

---

## Installation

1. Download the module via Composer:
   ```bash
   composer require drupal/translation_owner
   ```

2. Enable the module:
   ```bash
   drush en translation_owner
   ```

3. Clear Drush cache to register the commands:
   ```bash
   drush cache:clear drush
   ```

---

## Usage

### Single Translation Update

To update the owner (UID) of a specific node translation, use the following Drush command:

```bash
drush translation-owner:update-uid <nid> <langcode> <new_uid>
```

**Example**:
```bash
drush translation-owner:update-uid 113486 fr 28716
```

This updates the French translation of node `113486` to have user ID `28716` as its owner.

---

### Bulk Translation Update

To update multiple translations via a CSV file:

1. Prepare a CSV file with the following structure:
   ```
   nid,langcode,new_uid
   123,en,5
   456,fr,8
   ```

2. Run the bulk update command:
   ```bash
   drush translation-owner:bulk-update /path/to/file.csv
   ```

**Note**: The CSV file must contain a header row with `nid`, `langcode`, and `new_uid` columns.

---

## Command Aliases

For convenience, the following aliases are available:

- `translation-owner:update-uid`: Aliases `tou`, `translation-owner-update`.
- `translation-owner:bulk-update`: Aliases `toub`, `translation-owner-bulk`.

---

## Developer Notes

### Extending the Module

If you wish to extend the module or integrate it with custom workflows:
- Commands are defined in the `\Drupal\translation_owner\Commands\TranslationOwnerCommands` class.
- Dependencies are injected via the `translation_owner.services.yml` file.

### Debugging

If commands do not appear, ensure you clear Drush cache:
```bash
drush cache:clear drush
```

---

## Support

This module is maintained by the Drupal community. Please report issues in the [Drupal.org issue queue](https://www.drupal.org/project/issues/translation_owner).
