<?php

/**
 * @file
 * Bootstrap file for PHPUnit tests.
 */

// Set the default timezone to avoid warnings.
date_default_timezone_set('UTC');

// Mock Drupal's dt() function for tests.
if (!function_exists('dt')) {
  function dt($message, array $context = []) {
    return strtr($message, $context);
  }
}

// Autoload Composer dependencies if available.
$autoloader = NULL;
if (file_exists(__DIR__ . '/../vendor/autoload.php')) {
  $autoloader = include_once __DIR__ . '/../vendor/autoload.php';
}
elseif (file_exists(__DIR__ . '/../../../../autoload.php')) {
  $autoloader = include_once __DIR__ . '/../../../../autoload.php';
}

if (!$autoloader) {
  throw new \Exception('Could not find autoloader. Run "composer install".');
}