# Translation Parse (TransParse)

A Drupal 10+ module that automatically scans the active theme for translatable
strings as also as all the Node labels and makes them available in Drupal's
Translation UI (`/admin/config/regional/translate`).

By default, these strings are only available on the Translation UI only when we
visit each (node) page on the related language.
This module is like a "string translation warmer".

## Features

- **Automatic String Detection**: Scans Twig templates for `|t` filters and `{% trans %}` blocks.
- **Field Label Extraction**: Extracts field labels, descriptions, and placeholders from all entity types (node, block_content, group, taxonomy_term, paragraph) and field_group labels.
- **Drush Integration**: Easy-to-use Drush commands for scanning and cache management.
- **Multi-language Support**: Works with all the enabled languages on the site.
- **Performance**: Caches scan results for fast repeated access.

## Limitations

- At the moment we parse only the active theme. Support for custom paths can be added.
- Only scans Twig templates and field configurations. Other sources (e.g., custom modules) are not scanned.
- Does not automatically translate strings; it only makes them available in the Translation UI.

## Usage

### Initial scan

After enabling the module, run your first scan:

```bash
drush transparse:scan
```

This will:
- Scan all Twig templates in the active theme
- Extract field labels from all entity type configurations
- Extract field_group labels from display modes
- Register all found strings with Drupal's translation system

### Drush options

**Basic scan:**
```bash
drush transparse:scan
```

**Force fresh scan (clear cache):**
```bash
drush transparse:scan --force
```

**Verbose output (show all strings):**
```bash
drush transparse:scan --verbose
```

**Scan specific directory:**
```bash
drush transparse:scan --path=web/themes/custom/MYTHEME/templates/override/content
```

**Clear cache only:**
```bash
drush transparse:clear-cache
```

### Drush command aliases

For convenience, you can use these shorter aliases:

- `drush tps` - Same as `transparse:scan`
- `drush tpc` - Same as `transparse:clear-cache`

## Managing translations

After running the scan, translations are available in the Drupal UI:

1. Navigate to: **Admin > Configuration > Regional and language > User interface translation**
2. Filter by "transparse" context to see only strings from this module
3. Add translations for any of the enabled languages.

## What gets scanned

### Twig Templates
The module extracts strings from:
- `{{ 'text'|t }}` - Standard translation filter
- `{% trans %}...{% endtrans %}` - Translation blocks
- `alt={{"text"|t}}` - Alt attribute translations
- `title="{{ 'text'|t }}"` - Title attribute translations

### Field Configurations
The module extracts from all entity types (node, block_content, group, taxonomy_term, paragraph):
- Field labels
- Field descriptions
- Field placeholder text
- Field storage allowed values (for list fields)

### Field Groups
The module extracts from field_group module configurations:
- Field group labels from form display modes
- Field group labels from view display modes

## Configuration

The module works out of the box with sensible defaults, but can be configured:

### Theme Path
The module automatically uses the active default theme from your Drupal site configuration. No manual configuration needed.

## Workflow for adding new fields

When you add new fields or update templates:

1. **Add your field/template** with translatable strings using `|t` or `{% trans %}`
2. **Run the scan**:
   ```bash
   drush transparse:scan --force
   ```
3. **Verify in Translation UI**: Check that new strings appear
4. **Add translations**: Translate for all enabled languages

That's it! No code changes needed.

## Example Output

```
$ drush transparse:scan --verbose

Starting translation string scan...

Scan complete!

Summary:
  Total strings found: 152
  Strings registered: 152

Breakdown by type:
  Twig |t filters: 89
  {% trans %} blocks: 12
  Twig alt attributes: 8
  Twig title attributes: 15
  Field labels: 245
  Field descriptions: 35
  Field placeholders: 4
  Field group labels: 24
  Field storage allowed values: 90

Twig Filter:
  - "Skip to main content" [html.html.twig]
  - "Filters" [form--views-exposed-form.html.twig]
  - "Pagination" [views-show-more-pager.html.twig]

...

Go to the Translation UI (/admin/config/regional/translate).
Tip: Filter by "transparse" context to see only these strings.
```

### Cache Management

- **Cache ID**: `transparse:strings`
- **Tags**: `['transparse']`
- **Backend**: Default cache backend
- **Invalidation**: Automatic on `--force` or manual via `transparse:clear-cache`

## Troubleshooting

### Strings not appearing in the Translation UI

1. Run scan with force flag: `drush transparse:scan --force`
2. Clear all caches: `drush cr`
3. Check that locale module is enabled: `drush en locale`

### Module not finding strings

1. Verify path is correct: `drush transparse:scan --path=web/themes/custom/mytheme`
2. Check file permissions on theme directory
3. Run with verbose flag to see what's being found: `drush transparse:scan --verbose`

### Performance issues

The module caches results. If scans are slow:
1. Use the cache: Don't always use `--force`
2. Scan specific directories when possible
3. Results are cached permanently until cleared or forced

## Extending the parser

To add new string extraction patterns, override the Service CLass `TranslationParser.php`.
Add new regex patterns in the `scanTwigFiles()` or `scanFieldConfigs()` methods.

## Credits

This module was developed with the help of [Cline](https://cline.bot) inside PHPStorm IDE.
