# Transparse Module Testing

This directory contains tests for the Transparse module.

## Test Types

1. **Unit Tests** - Test individual components in isolation
2. **Kernel Tests** - Test module integration with Drupal core
3. **Functional Tests** - Test user-facing functionality

## Running Tests

From the Drupal root directory, run:

```bash
# Run all tests
../vendor/bin/phpunit -c web/modules/custom/transparse/phpunit.xml.dist

# Run specific test suites
../vendor/bin/phpunit -c web/modules/custom/transparse/phpunit.xml.dist --testsuite unit
../vendor/bin/phpunit -c web/modules/custom/transparse/phpunit.xml.dist --testsuite kernel
../vendor/bin/phpunit -c web/modules/custom/transparse/phpunit.xml.dist --testsuite functional

# Run specific test files
../vendor/bin/phpunit -c web/modules/custom/transparse/phpunit.xml.dist web/modules/custom/transparse/tests/src/Unit/TranslationParserTest.php
```

## Test Dependencies

The tests require the following development dependencies:

- `mikey179/vfsstream` - For virtual filesystem testing
- Drupal core testing framework
- Drush testing traits (for Drush command tests)

Install dependencies with:

```bash
composer install
```

## Writing New Tests

1. Place unit tests in `tests/src/Unit`
2. Place kernel tests in `tests/src/Kernel`
3. Place functional tests in `tests/src/Functional`
4. Update `phpunit.xml.dist` to include new test files if needed
5. Follow Drupal coding standards and PHPUnit best practices

## Test Coverage

Current tests cover:
- Service instantiation
- Module installation
- Help page functionality
- Drush command availability
- Basic file scanning functionality (stubbed)

Additional tests needed:
- Actual string parsing validation
- Field configuration parsing
- Cache functionality
- String registration with locale module