<?php

namespace Drupal\Tests\transparse\Functional;

use Drupal\Tests\BrowserTestBase;
use Drush\TestTraits\DrushTestTrait;

/**
 * Tests the Transparse Drush commands.
 *
 * @group transparse
 */
class TransparseCommandsTest extends BrowserTestBase {

  use DrushTestTrait;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = ['transparse'];

  /**
   * Tests the scan command.
   */
  public function testScanCommand() {
    $this->drush('transparse:scan');
    $this->assertStringContainsString('Starting translation string scan...', $this->getOutput());
    $this->assertStringContainsString('Scan complete!', $this->getOutput());
  }

  /**
   * Tests the clear-cache command.
   */
  public function testClearCacheCommand() {
    $this->drush('transparse:clear-cache');
    $this->assertStringContainsString('Translation string cache cleared successfully.', $this->getOutput());
  }

  /**
   * Tests the command aliases.
   */
  public function testCommandAliases() {
    // Test tps alias.
    $this->drush('tps');
    $this->assertStringContainsString('Starting translation string scan...', $this->getOutput());

    // Test tpc alias.
    $this->drush('tpc');
    $this->assertStringContainsString('Translation string cache cleared successfully.', $this->getOutput());
  }

}
