<?php

namespace Drupal\Tests\transparse\Kernel;

use Drupal\KernelTests\KernelTestBase;
use org\bovigo\vfs\vfsStream;

/**
 * Advanced tests for the TranslationParser service.
 *
 * @group transparse
 */
class TranslationParserAdvancedTest extends KernelTestBase {

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = ['transparse', 'locale', 'language', 'system', 'field'];

  /**
   * The translation parser service.
   *
   * @var \Drupal\transparse\Service\TranslationParser
   */
  protected $translationParser;

  /**
   * Virtual file system directory.
   *
   * @var \org\bovigo\vfs\vfsStreamDirectory
   */
  protected $vfsRoot;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->translationParser = \Drupal::service('transparse.translation_parser');
    $this->vfsRoot = vfsStream::setup('theme');
  }

  /**
   * Tests the clearCache method.
   */
  public function testClearCache() {
    // This is a basic test that would need expansion.
    $this->translationParser->clearCache();
    $this->assertTrue(TRUE, 'Cache clearing did not cause fatal errors.');
  }

  /**
   * Tests scanning with an invalid path.
   */
  public function testScanWithInvalidPath() {
    // Test scanning with a path that doesn't exist.
    $result = $this->translationParser->scanTheme('/invalid/path/that/does/not/exist');
    $this->assertIsArray($result);
  }

}
