Overview

    The Trash Manager module adds a soft-delete mechanism to Drupal.
    Whenever a content entity is deleted (nodes, taxonomy terms, users, media, etc.), the module stores a snapshot of the entity’s data in a custom database table instead of fully removing it.

    Administrators can then:

    View all deleted items in a dedicated Trash Manager page

    Filter deleted items by entity type (Node, User, Media, Taxonomy, etc.)

    Restore deleted entities

    Permanently remove items from the Trash Manager

    This module is intended as a safety net to protect against accidental content deletion.

Features

    Stores deleted Drupal content entities (nodes, users, taxonomy terms, media…)

    Restore deleted items with one click

    Permanently delete items from the Trash Manager

    Dropdown filter to view by entity type

    Automatically saves:

    entity type

    bundle

    label

    original entity ID

    full serialized entity data

    timestamp of deletion

    Integrates with Drupal’s entity deletion hooks

    Automatically cleans up database table on module uninstall

Installation

    Download the module from https://www.drupal.org/project/trash_manager
    
    Enable the module:

    drush en trash_manager -y


    Visit the Trash Manager interface:

    /admin/content/trash-manager

Usage

    Viewing Deleted Items

    Navigate to:

    Admin/Content/Trash Manager


    You’ll see a table listing deleted entities, including:

    Type

    Label

    Bundle

    Deletion timestamp

    Action buttons

    Restoring an Entity

    Click the Restore button next to any deleted item.
    The entity is re-created in Drupal using sanitized data to avoid ID/UUID conflicts.

    Deleting Permanently

    Click Delete Permanently to remove the stored snapshot forever.
