<?php

namespace Drupal\trash_manager\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;
use Drupal\Core\Link;
use Drupal\trash_manager\Form\TrashManagerFilterForm;

class TrashManagerController extends ControllerBase {

  public function overview() {
    $type_filter = \Drupal::request()->query->get('type');

    $header = [
      'type' => 'Type',
      'label' => 'Label',
      'bundle' => 'Bundle',
      'deleted' => 'Deleted',
      'ops' => 'Operations',
    ];

    $rows = [];
    $db = \Drupal::database();
    $query = $db->select('trash_manager_deleted_item', 'r')
      ->fields('r');

    // Apply filter if user selected a type
    if (!empty($type_filter)) {
      $query->condition('entity_type', $type_filter);
    }

    $result = $query->execute();

    foreach ($result as $item) {
      $restore_link = Link::fromTextAndUrl('Restore',
        Url::fromRoute('trash_manager.restore', ['item' => $item->id])
      )->toRenderable();

      $restore_link['#attributes'] = [
        'class' => ['button', 'button--small', 'button--success'],
        'style' => 'margin-right: 5px;',
      ];

      $delete_link = Link::fromTextAndUrl('Delete Permanently',
        Url::fromRoute('trash_manager.delete_permanently', ['item' => $item->id])
      )->toRenderable();

      $delete_link['#attributes'] = [
        'class' => ['button', 'button--small', 'button--danger'],
      ];

      $rows[] = [
        'type' => $item->entity_type,
        'label' => $item->label,
        'bundle' => $item->bundle,
        'deleted' => date('Y-m-d H:i', $item->deleted),
        'ops' => [
          'data' => [
            '#type' => 'container',
            '#attributes' => ['class' => ['operations']],
            'restore_link' => $restore_link,
            'delete_link' => $delete_link,
          ],
        ],
      ];
    }

    return [
      'filter_form' => $this->formBuilder()->getForm(TrashManagerFilterForm::class),
      'table' => [
        '#type' => 'table',
        '#header' => $header,
        '#rows' => $rows,
        '#empty' => 'Trash Manager bin is empty.',
        '#attributes' => ['style' => 'margin-top: 20px;'],
      ],
    ];
  }
}
