<?php

namespace Drupal\trash_manager\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 *
 */
class DeletePermanentlyForm extends ConfirmFormBase {

  protected $item;

  /**
   *
   */
  public function getFormId() {
    return 'trash_manager_delete_permanent_form';
  }

  /**
   *
   */
  public function buildForm(array $form, FormStateInterface $form_state, $item = NULL) {
    $this->item = $item;
    return parent::buildForm($form, $form_state);
  }

  /**
   *
   */
  public function getQuestion() {
    return $this->t('Delete this item permanently?');
  }

  /**
   *
   */
  public function getCancelUrl() {
    return Url::fromRoute('trash_manager.overview');
  }

  /**
   *
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    \Drupal::database()->delete('trash_manager_deleted_item')
      ->condition('id', $this->item)
      ->execute();

    $this->messenger()->addWarning('Item permanently removed.');
    $form_state->setRedirect('trash_manager.overview');
  }

}
