<?php

namespace Drupal\trash_manager\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 *
 */
class RestoreForm extends ConfirmFormBase {

  protected $item;

  /**
   *
   */
  public function getFormId() {
    return 'trash_manager_restore_form';
  }

  /**
   *
   */
  public function buildForm(array $form, FormStateInterface $form_state, $item = NULL) {
    $this->item = \Drupal::database()
      ->select('trash_manager_deleted_item', 'r')
      ->fields('r')
      ->condition('id', $item)
      ->execute()
      ->fetch();

    return parent::buildForm($form, $form_state);
  }

  /**
   *
   */
  public function getQuestion() {
    return $this->t('Restore %label?', ['%label' => $this->item->label]);
  }

  /**
   *
   */
  public function getCancelUrl() {
    return Url::fromRoute('trash_manager.overview');
  }

  /**
   * Recursively remove keys that cause ID conflicts in restored data.
   */
  protected function cleanupEntityData(array &$data) {
    $keys_to_unset = ['nid', 'vid', 'uuid', 'revision_id', 'id'];

    foreach ($keys_to_unset as $key) {
      if (isset($data[$key])) {
        unset($data[$key]);
      }
    }
    // Recursively clean nested arrays (e.g., revisions, translations)
    foreach ($data as &$value) {
      if (is_array($value)) {
        $this->cleanupEntityData($value);
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $data = unserialize($this->item->data);

    // Clean IDs recursively.
    $this->cleanupEntityData($data);

    // For taxonomy_term entities, set the 'vid' key explicitly.
    if ($this->item->entity_type === 'taxonomy_term' && empty($data['vid']) && !empty($this->item->bundle)) {
      $data['vid'] = $this->item->bundle;
    }

    $storage = \Drupal::entityTypeManager()->getStorage($this->item->entity_type);

    $entity = $storage->create($data);
    $entity->save();

    \Drupal::database()->delete('trash_manager_deleted_item')
      ->condition('id', $this->item->id)
      ->execute();

    $this->messenger()->addStatus($this->t('Item restored.'));
    $form_state->setRedirect('trash_manager.overview');
  }

}
