<?php

namespace Drupal\trash_manager\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

class TrashManagerFilterForm extends FormBase {

  public function getFormId() {
    return 'trash_manager_filter_form';
  }

  public function buildForm(array $form, FormStateInterface $form_state) {
    $current_type = \Drupal::request()->query->get('type');

    $form['type'] = [
      '#type' => 'select',
      '#title' => $this->t('Filter by entity type'),
      '#options' => [
        '' => $this->t('- All -'),
        'node' => $this->t('Nodes'),
        'media' => $this->t('Media'),
        'taxonomy_term' => $this->t('Taxonomy terms'),
        'user' => $this->t('Users'),
      ],
      '#default_value' => $current_type ?: '',
      '#attributes' => [
        'onchange' => "this.form.submit()",
      ],
    ];

    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Apply'),
      '#attributes' => ['class' => ['button', 'button--primary']],
    ];

    return $form;
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    $type = $form_state->getValue('type');

    $params = [];
    if (!empty($type)) {
      $params['type'] = $type;
    }

    $form_state->setRedirect('trash_manager.overview', [], ['query' => $params]);
  }
}
