<?php

namespace Drupal\trinion_bpmn_import\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Routing\Access\AccessInterface;
use Drupal\node\Entity\Node;
use Drupal\taxonomy\Entity\Term;
use Drupal\user\Entity\User;
use Symfony\Component\Routing\Route;

/**
 * Проверка доступа к утверждению документа
 */
class BusinessProcessOperatorChecker implements AccessInterface {

  /**
   * Access callback.
   */
  public function access(Route $route, Node $node) {
    return AccessResult::allowedIf(in_array($node->id(), self::getStartAllowedNodes()));
  }

  public static function getStartAllowedNodes() {
    $nids = [];
    if ($user_id = \Drupal::currentUser()->id()) {
      $user = User::load($user_id);
      foreach ($user->get('field_tbi_biznes_process_rol') as $role) {
        $query = \Drupal::entityQuery('node')
          ->condition('field_tbi_mesto_sobytiya', 'startEvent')
          ->condition('field_tbi_biznes_process_rol', $role->getString())
          ->condition('field_tbi_tip_sobytiya', NULL, 'IS NULL');
        if ($start_node = $query->accessCheck()->execute()) {
          $start_node = Node::load(reset($start_node));
          $nids[] = $start_node->get('field_tbi_shablon_biznes_process')->getString();
        }
      }
    }
    return $nids;
  }

  public static function getAllowedNodes() {
    $nids = [];
    if ($user_id = \Drupal::currentUser()->id()) {
      $user = User::load($user_id);
      foreach ($user->get('field_tbi_biznes_process_rol') as $role) {
        $query = \Drupal::entityQuery('node')
          ->condition('field_tbi_biznes_process_rol', $role->getString());
        if ($start_node = $query->accessCheck()->execute()) {
          $start_node = Node::load(reset($start_node));
          $nids[] = $start_node->get('field_tbi_shablon_biznes_process')->getString();
        }
      }
    }
    return array_unique($nids);
  }
}
