<?php

declare(strict_types=1);

namespace Drupal\trinion_bpmn_import\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Datetime\DrupalDateTime;
use Drupal\datetime\Plugin\Field\FieldType\DateTimeItemInterface;
use Drupal\node\Entity\Node;

/**
 * Returns responses for Trinion BPMN inport routes.
 */
final class BusinessProcessController extends ControllerBase {

  public function start(Node $node) {
    $query = \Drupal::entityQuery('node')
      ->condition('field_tbi_mesto_sobytiya', 'startEvent')
      ->condition('field_tbi_shablon_biznes_process', $node->get('field_tbi_shablon_biznes_process')->getString());
    $res = $query->accessCheck()->execute();
    if ($res) {
      $next = $this->getNextElement(reset($res));
      if ($next) {
        $this->goToElement($node, $next);
      }
      else
        \Drupal::messenger()->addError(t('Undefined next element'));
    }
  }

  public function run(Node $node, $flow = NULL) {
    $token = $node->get('field_tbi_token')->first()->entity;
    if ($token->hasField('field_tbi_poluchatel_soobsh') && $next_bp = $token->get('field_tbi_poluchatel_soobsh')->first()) {
      $next_bp_tpl = $next_bp->entity;
      $bp_data = [
        'type' => 'biznes_process',
        'uid' => \Drupal::currentUser()->id(),
        'status' => 1,
        'field_tbi_nazvanie' => $next_bp_tpl->label() . ' from nid ' . $token->id(),
        'field_tbi_shablon_biznes_process' => $next_bp_tpl->id(),
      ];
      if ($next = $this->getNextElement($node->get('field_tbi_token')->getString())) {
        $bp_data['field_tbi_poluchatel_soobsh'] = $next;
        $bp_data['field_tbi_biznes_process'] = $node->id();
      }
      $bp = Node::create($bp_data);

      $bp->save();
      \Drupal::messenger()->addMessage(t('Business process %bp was started', ['%bp' => $next_bp_tpl->label()]));
    }
    else {
      if (is_null($flow)) {
        $next = $this->getNextElement($node->get('field_tbi_token')->getString());
      } else {
        $flow = Node::load($flow);
        $next = $flow->get('field_tbi_ishodyashchaya_ssylka')->getString();
      }
      if ($next) {
        $this->goToElement($node, $next);
      } else {
        if ($node->hasField('field_tbi_poluchatel_soobsh') &&
          ($next_bp_node = $node->get('field_tbi_poluchatel_soobsh')->first()) &&
          ($next_bp = $node->get('field_tbi_biznes_process')->first())
        ) {
          $src_el = $this->getPrevElement($next_bp_node->entity->id());
          if ($task_nid = $this->getTaskByElement($next_bp->entity, $src_el)) {
            $task = Node::load($task_nid);
            $task->field_tz_status_zadachi = \Drupal::config('trinion_zadachnik.settings')->get('status_vipolnenae_tid');
            $task->save();
          }

          $this->goToElement($next_bp->entity, $next_bp_node->entity->id());
        }
        elseif ($dependent_processes = $this->checkNeedRunDependentProcess($node)) {
          foreach ($dependent_processes as $dependent_process) {
            $bp_name = $dependent_process->get('field_tbi_shablon_biznes_process')->first()->entity->label();
            $bp_data = [
              'type' => 'biznes_process',
              'uid' => \Drupal::currentUser()->id(),
              'status' => 1,
              'field_tbi_nazvanie' => $bp_name,
              'field_tbi_shablon_biznes_process' => $dependent_process->get('field_tbi_shablon_biznes_process')->getString(),
            ];

            $bp = Node::create($bp_data);

            $bp->save();
            \Drupal::messenger()->addMessage(t('Business process %bp was started', ['%bp' => $bp_name]));
          }
        }
        else {
          \Drupal::messenger()->addError(t('Undefined next element'));
        }
      }
    }
  }

  public function getNextElement($nid) {
    $query = \Drupal::entityQuery('node')
      ->condition('field_tbi_vhodyashchaya_ssylka', $nid);
    $res = $query->accessCheck()->execute();
    if ($res) {
      $flow = Node::load(reset($res));
      return $flow->get('field_tbi_ishodyashchaya_ssylka')->getString();
    }
  }

  public function getPrevElement($nid) {
    $query = \Drupal::entityQuery('node')
      ->condition('field_tbi_ishodyashchaya_ssylka', $nid);
    $res = $query->accessCheck()->execute();
    if ($res) {
      $flow = Node::load(reset($res));
      return $flow->get('field_tbi_vhodyashchaya_ssylka')->getString();
    }
  }

  public function getNextFlows($nid) {
    $query = \Drupal::entityQuery('node')
      ->condition('field_tbi_vhodyashchaya_ssylka', $nid);
    $res = $query->accessCheck()->execute();
    return $res;
  }

  public function goToElement(Node $node, $next) {
    $next_node = Node::load($next);
    if ($next_node->bundle() == 'trinion_bpmn_sobytie') {
      if ($next_node->get('field_tbi_mesto_sobytiya')->getString() == 'endEvent') {
        if ($next_node->get('field_tbi_poluchatel_soobsh')->getString() == '')
          $node->field_tbi_zavershen = 1;
      }
    }
    $node->field_tbi_token = $next;
    $node->save();

    $title = $next_node->get('field_tbi_title')->getString();
    if (empty($title))
      $title = $next_node->label();

    if ($next_node->hasField('field_tbi_description')) {

      if ($desc = $next_node->get('field_tbi_description')->first())
        $text = $desc->getValue()['value'];
      else
        $text = '';

    }
    else
      $text = '';
    $resposible = array_values(\Drupal::service('trinion_bpmn_import.helper')->getUsersByRole($next_node->get('field_tbi_biznes_process_rol')->getString()));

    $zadacha = \Drupal::service('trinion_zadachnik.helper')->createTask($text, $title, $resposible);
    $zadacha->field_tbi_biznes_process = $node->id();
    $zadacha->field_tbi_ishodniy_element = $next_node->id();

    if ($ex_time = $next_node->get('field_tbi_vr_vypolneniya_zadachi')->getString()) {
      $date = new DrupalDateTime(date('Y-m-d\tH:i:s', strtotime($ex_time . ' hours')));
      $date->setTimezone(new \DateTimezone(DateTimeItemInterface::STORAGE_TIMEZONE));
      $time = $date->format(DateTimeItemInterface::DATETIME_STORAGE_FORMAT);

      $zadacha->field_tz_vrem_vypoleniya_zadachi = $time;
    }

    $zadacha->save();
  }

  public function getTaskByElement(Node $node, $element) {
    $query = \Drupal::entityQuery('node')
      ->condition('field_tbi_biznes_process', $node->id())
      ->condition('field_tbi_ishodniy_element', $element);
    $res = $query->accessCheck()->execute();
    return reset($res);
  }

  public function checkNeedRunDependentProcess(Node $node) {
    $query = \Drupal::entityQuery('node')
      ->condition('field_tbi_trebuemye_dlya_zapuska', $node->get('field_tbi_shablon_biznes_process')->getString());
    $res = $query->accessCheck()->execute();
    $dependent_processes = [];
    if ($res) {
      foreach ($res as $nid) {
        $dependent_process = Node::load($nid);
        $all_finished = TRUE;
        foreach ($dependent_process->get('field_tbi_trebuemye_dlya_zapuska') as $parent_process) {
          $query = \Drupal::entityQuery('node')
            ->condition('field_tbi_proekt', $node->get('field_tbi_proekt')->getString())
            ->condition('field_tbi_shablon_biznes_process', $parent_process->entity->id())
            ->condition('field_tbi_zavershen', 1);
          $res_finished = $query->accessCheck()->execute();
          if (empty($res_finished)) {
            $all_finished= FALSE;
            break;
          }
        }
        if ($all_finished)
          $dependent_processes[] = $dependent_process;
      }
    }
    return $dependent_processes;
  }
}
