<?php

declare(strict_types=1);

namespace Drupal\trinion_bpmn_import\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\node\Entity\Node;

/**
 * Returns responses for Trinion BPMN import routes.
 */
final class ProjectGraphController extends ControllerBase {

  /**
   * Builds the response.
   */
  public function __invoke(Node $node): array {
    $nodes = $this->getNodes($node);
    $edges = $this->getEdges($nodes);
    $nodes = $this->getPositions($nodes, $edges);
    $build['content'] = [
      '#theme' => 'tbi_project_graph',
      '#nodes' => $nodes,
      '#edges' => $edges,
    ];
//    dump($build);exit;
    return $build;
  }

  public function getTitle(Node $node) {
    return $node->label();
  }

  public function getNodes(Node $project) {
    $nodes = [];
    if ($project_template = $project->get('field_tbi_shablon_proekta')->getString()) {
      $query = \Drupal::entityQuery('node')
        ->condition('type', 'shablon_biznes_processa')
        ->condition('field_tbi_shablon_proekta', $project_template);
      $res = $query->accessCheck()->execute();
      $nodes = [];
      foreach ($res as $nid) {
        $node = Node::load($nid);
        $nodes[$nid] = [
          'node' => $node,
        ];
      }
    }
    return $nodes;
  }

  public function getEdges($nodes) {
    $edges = [];
    foreach ($nodes as $node) {
      $bp_id = $node['node']->id();
      $query = \Drupal::entityQuery('node')
        ->condition('type', 'trinion_bpmn_sobytie')
        ->condition('field_tbi_trebuemye_dlya_zapuska', $bp_id);
      $res = $query->accessCheck()->execute();
      foreach ($res as $nid) {
        $target_node = Node::load($nid)->get('field_tbi_shablon_biznes_process')->getString();
        if (isset($nodes[$bp_id]))
          $edges[] = [
            'source' => $bp_id,
            'target' => $target_node,
          ];
      }
    }
    return $edges;
  }

  public function getPositions($nodes, $edges) {
    $weights = [];

    foreach ($edges as $edge) {
      if (isset($nodes[$edge['source']])) {
        $weights[$edge['source']] = 0;
      }
    }

    foreach ($weights as $nid => $weight) {
      foreach ($edges as $edge) {
        if ($edge['source'] == $nid) {
          $weights[$edge['target']] = $weight + 1;
        }
      }
    }
//    dump(array_search(0, $weights));
    foreach (array_unique($weights) as $weight) {
      $count = 0;
      foreach ($weights as $nid => $weight2) {
        if ($weight == $weight2)
          $count++;
      }
      $top_dir = TRUE;
      foreach ($weights as $nid => $weight2) {

        $nt = $nb = 0;
        if ($weight == $weight2) {
          if ($count == 1)
            $nodes[$nid]['y'] = 0;
          else {
            if ($count % 2 == 0) {
              if (!$top_dir) {
                $nt++;
                $nodes[$nid]['y'] = $nt;
              }
              else {
                $nb++;
                $nodes[$nid]['y'] = $nb * -1;
              }
              $top_dir = !$top_dir;

//              if ($top_dir) {
//                $nodes[$nid]['y'] = $n;
//              }
            }
          }
        }
      }
//      dump($weight . ':' . $count);
    }

//    foreach ($weights as $nid => $weight) {
//      $found = [];
//      foreach ($weights as $nid2 => $weight2) {
//        if ($weight == $weight2) {
//          if (!isset($found[$nid])) {
////            $nodes[$nid]['dir'] = 't';
//            $found[$nid] = ['num' => 0,];
//          }
//          $found[$nid]['num']++;
////          if ($found[$nid]['num'] > 1)
////            $nodes[$nid]['dir'] = $nodes[$nid]['dir'] == 'b' ? 't' : 'b';
//        }
//      }
////      $nodes[$nid]['count_par'] = $found[$nid];
//      dump($found);
//    }

//    dump($weights);
    foreach ($nodes as $nid => $val) {
      $nodes[$nid]['x'] = $weights[$nid];
    }

    return $nodes;
  }
}
