<?php

declare(strict_types=1);

namespace Drupal\trinion_bpmn_import\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\node\Entity\Node;

/**
 * Returns responses for Trinion BPMN inport routes.
 */
final class SvgController extends ControllerBase {

  public function getProcessedSvg(Node $node) {
    /** @var \SimpleXMLElement $xml */
    $svg_url = $node->get('field_tbi_import_file_svg')->first()->entity->getFileUri();
    $string = file_get_contents($svg_url);
    $string = str_replace('xmlns=', 'ns=', $string);
    $xml = simplexml_load_string($string);
    $xml_str = $xml->asXML();

    $query = \Drupal::entityQuery('node')
      ->condition('type', ['bpmn_zadacha', 'trinion_bpmn_sobytie', 'bpmn_shlyuz'], 'IN')
      ->condition('field_tbi_shablon_biznes_process', $node->id());
    $res = $query->accessCheck()->execute();
    foreach ($res as $nid) {
      $xml_str = $this->insertLink($xml, $nid, $xml_str);
    }

    return $xml_str;
  }

  public function getProcessedRunSvg(Node $shablon, Node $node) {
    /** @var \SimpleXMLElement $xml */
    $svg_url = $shablon->get('field_tbi_import_file_svg')->first()->entity->getFileUri();
    $string = file_get_contents($svg_url);
    $string = str_replace('xmlns=', 'ns=', $string);
    $xml = simplexml_load_string($string);
    $xml_str = $xml->asXML();

    $token_nid = $node->get('field_tbi_token')->getString();
//    $query = \Drupal::entityQuery('node')
//      ->condition('type', ['bpmn_zadacha', 'trinion_bpmn_sobytie', 'bpmn_shlyuz'], 'IN')
//      ->condition('field_tbi_shablon_biznes_process', $shablon->id());
//    $res = $query->accessCheck()->execute();
//    dump($res);exit;
//    foreach ($res as $nid) {
      $xml_str = $this->tokenDraw($xml, $token_nid, $xml_str);
//    }

    return $xml_str;
  }

  public function insertLink($xml, $nid, $xml_str) {
    $node_element = Node::load($nid);
    $elemen_id = $node_element->get('field_tbi_id')->getString();
    $old_el = $xml->xpath('//g[@data-element-id="' . $elemen_id . '"]')[0];
    $old_el_xml = dom_import_simplexml($old_el);

    $replace = new \SimpleXMLElement('<xml></xml>');

    $link = $replace->addChild('a',);
    $link->addAttribute('href', '/node/' . $nid . '/edit');

    /** @var \DOMElement $new_el_xml */
    $new_el_xml = dom_import_simplexml($link);
    $new_el_xml->appendChild($new_el_xml->ownerDocument->importNode($old_el_xml, true));

    $xml_str = str_replace($old_el->asXML(), $new_el_xml->ownerDocument->saveXML($new_el_xml), $xml_str);
    return $xml_str;
  }

  public function tokenDraw($xml, $nid, $xml_str) {
    $node_element = Node::load($nid);
    $elemen_id = $node_element->get('field_tbi_id')->getString();
    $el = $xml->xpath('//g[@data-element-id="' . $elemen_id . '"]/g[@class="djs-visual"]/*[1]')[0];
    $new_style = (string)$el->attributes()['style'];
    $new_style = preg_replace('/fill: .*?;/', 'fill: #c3c3c3;', $new_style);
    $el->attributes()['style'] = $new_style;
    return $xml->asXML();
  }

}
