<?php

declare(strict_types=1);

namespace Drupal\trinion_bpmn_import\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\node\Entity\Node;
use Drupal\trinion_bpmn_import\Controller\BusinessProcessController;

final class BpmnTaskForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'trinion_bpmn_import_bpmn_task';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $task = $form_state->getBuildInfo()['args'][0];
    $field_tbi_ishodniy_element = $task->get('field_tbi_ishodniy_element')->first()->entity;
    if (is_null($field_tbi_ishodniy_element))
      return [];
    $form['actions'] = [
      '#type' => 'actions',
      '#no-mt' => TRUE,
    ];

    $form['#action'] = '/node/' . $task->id();

    $element_bundle = $field_tbi_ishodniy_element->bundle();
    if ($time = $task->get('field_tz_vrem_vypoleniya_zadachi')->getString()) {
      $start_date = new \DateTime('now');
      $diff = $start_date->diff(new \DateTime($time));
      $time = [];
      if ($diff->y)
        $time[] = t('%years years', ['%years' => $diff->y]);
      if ($diff->m)
        $time[] = t('%months months', ['%months' => $diff->m]);
      if ($diff->d)
        $time[] = t('%days days', ['%days' => $diff->d]);
      if ($diff->h)
        $time[] = t('%hours hours', ['%hours' => $diff->h]);
      if ($diff->i)
        $time[] = t('%minutes minutes', ['%minutes' => $diff->i]);
      $form['counter'] = [
        '#markup' => implode(' ', $time),
      ];
    }
    if ($element_bundle == 'bpmn_zadacha' || $element_bundle == 'trinion_bpmn_sobytie') {
      $form['actions'][] = [
        '#type' => 'submit',
        '#value' => t('Complete task'),
        '#custom_suggestion' => 'approve_btn',
      ];
    }
    elseif ($element_bundle == 'bpmn_shlyuz') {
      $bp = new BusinessProcessController();
      foreach ($bp->getNextFlows($field_tbi_ishodniy_element->id()) as $flow_nid) {
        $flow = Node::load($flow_nid);
        $form['actions'][$flow_nid] = [
          '#type' => 'submit',
          '#value' => $flow->label(),
        ];
      }
    }

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $task = $form_state->getBuildInfo()['args'][0];
    $src_el = $task->get('field_tbi_ishodniy_element')->first()->entity;
    if ($src_el->bundle() == 'bpmn_shlyuz') {
      $flow_nid = str_replace('edit-', '', $form_state->getTriggeringElement()['#id']);
      $flow = Node::load($flow_nid);
      $text = t('Task completed. Selected option: %selected_option', ['%selected_option' => $flow->label()]);
      \Drupal::service('trinion_zadachnik.helper')->createComment($task->id(), $text);
    }
    else
      $flow_nid = NULL;
    if ($src_el->hasField('field_tbi_poluchatel_soobsh') && $src_el->get('field_tbi_poluchatel_soobsh')->getString())
      $task->field_tz_status_zadachi = \Drupal::config('trinion_zadachnik.settings')->get('status_v_rabote_tid');
    else
      $task->field_tz_status_zadachi = \Drupal::config('trinion_zadachnik.settings')->get('status_vipolnenae_tid');
    $task->save();
    $bp_controller = new \Drupal\trinion_bpmn_import\Controller\BusinessProcessController();
    $bp_controller->run($task->get('field_tbi_biznes_process')->first()->entity, $flow_nid);
  }
}
