<?php

namespace Drupal\trinion_tp\Controller;

use Dompdf\Dompdf;
use Drupal\Core\Controller\ControllerBase;
use Drupal\node\Entity\Node;

/**
 * PDF счет покупателя
 */
class PDFSchetKlienta extends ControllerBase {

  /**
   * Builds the response.
   */
  public function build(Node $node, $save_to_file = FALSE) {
    $build['content'] = [
      '#theme' => 'schet_klienta_pdf',
      "#node" => $node,
      "#root_path" => \Drupal::service('file_system')->realpath(''),
    ];
    $html = \Drupal::service('renderer')->render($build);

    $dompdf = new Dompdf();
    $dompdf->loadHtml($html);
    $options = $dompdf->getOptions();
    $options->set('chroot', DRUPAL_ROOT);
    $dompdf->setOptions($options);
    $dompdf->render();
    if ($save_to_file) {
      $output = $dompdf->output();
      $file_name = \Drupal::service('file_system')->getTempDirectory() . '/invoice_' . $node->label() . '.pdf';
      file_put_contents($file_name, $output);
      return $file_name;
    }
    else
      $dompdf->stream("schet-klienta.pdf", ["Attachment" => false]);
    return ['#cache' => ['max-age' => 0]];
  }
}

