<?php

namespace Drupal\trinion_tp\Controller;

use Dompdf\Dompdf;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\AlertCommand;
use Drupal\Core\Ajax\RedirectCommand;
use Drupal\Core\Controller\ControllerBase;
use Drupal\node\Entity\Node;

/**
 * Создание Счета покупателя
 */
class SozdanieSchetaKlienta extends ControllerBase {

  /**
   * Builds the response.
   */
  public function build(Node $node) {
//    if ($this->checkExistNomer($values['zakaz_num'])) {
//      \Drupal::messenger()->addWarning('Заказ клиента с таким номером уже есть в этом году');
//    }
    $response = new AjaxResponse();
    if ($node->get('field_tp_utverzhdeno')->getString()) {
      $schet = $this->createSchet($node);
      $response->addCommand(new RedirectCommand('/node/' . $schet->id()));
    }
    else
      $response->addCommand(new AlertCommand('Заказ не утверждён'));

    return $response;
  }

  /**
   * Создание счета на основе Заказа клиента
   */
  public function createSchet(Node $node) {
    $uid = \Drupal::currentUser()->id();
    $schet_data = [
      'type' => 'schet',
      'title' => $this->getNomer(),
      'uid' => $uid,
      'status' => 1,
      'field_tp_zakaz_klienta' => ['target_id' => $node->id()],
    ];
    foreach ($node->getFields() as $field_name => $f) {
      if (strpos($field_name, 'field_') === 0) {
        if ($field_name == 'field_tp_zakaz_dlya') {
          $schet_data['field_tp_schet_dlya'] = $node->get($field_name)->getValue();
        }
        elseif ($field_name == 'field_tp_stroki') {
          foreach ($node->get($field_name) as $stroka_uit) {
            /** @var Node $new_stroka */
            $new_stroka = clone $stroka_uit->entity->createDuplicate();
            $new_stroka->created = time();
            $new_stroka->uid = $uid;
            $new_stroka->save();
            $schet_data[$field_name][] = ['target_id' => $new_stroka->id()];
          }
        }
        else
          $schet_data[$field_name] = $node->get($field_name)->getValue();
      }
    }
    $schet_data['field_tp_utverzhdeno'] = 0;
    $schet = Node::create($schet_data);
    $schet->save();
    return $schet;
  }

  public function checkExistNomer($nomer) {
    $query = \Drupal::database()->select('node_field_data', 'n')
      ->condition('n.type', 'schet')
      ->condition('n.title', $nomer);
    $query->join('node__field_tp_data', 'd', 'd.entity_id = n.nid');
    $query->condition('d.field_tp_data_value', date('Y') . '-00-00', '>=');
    $query->condition('d.field_tp_data_value', date('Y') . '-12-31', '<=');
    $query->addField('n', 'title');
    return $query->countQuery()->execute()->fetchField();
  }

  public function getNomer() {
    return \Drupal::service('trinion_tp.helper')->getNextDocumentNumber('schet');
  }
}

