<?php

namespace Drupal\trinion_tp\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Site\Settings;
use Drupal\trinion_tp\Controller\PDFSchetKlienta;

/**
 * Send Invoice
 */
class OtpravitSchetForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'trinion_tp_otpravka_formi';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['email'] = [
      '#type' => 'email',
      '#title' => t('Email'),
      '#required' => TRUE,
    ];
    $form['message'] = [
      '#type' => 'text_format',
      '#title' => t('Message'),
      '#required' => TRUE,
    ];

    $invoice = \Drupal::routeMatch()->getParameter('node');
    if ($company = $invoice->get('field_tp_schet_dlya')->first()) {
      $company = $company->entity;
      $form['email']['#default_value'] = $company->get('field_tl_email')->getString();
    }

    $form['actions'] = [
      '#type' => 'actions',
    ];
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => t('Send'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $invoice = \Drupal::routeMatch()->getParameter('node');
    $subject = t('Invoice № ' . $invoice->label());
    $body = $form_state->getValue('message')['value'];
    $to = $form_state->getValue('email');
    $uid = \Drupal::currentUser()->id();
    $kompaniya_nid = $invoice->get('field_tp_schet_dlya')->getString();
    \Drupal::service('trinion_mail.mails')->saveOutgoingMail($subject, $body, $to, $uid, $kompaniya_nid);
    $pdf = new PDFSchetKlienta();
    $file = $pdf->build($invoice, TRUE);
    $mailManager = \Drupal::service('plugin.manager.mail');
    $langcode = \Drupal::currentUser()->getPreferredLangcode();
    $params = [
      'body' => $body,
      'subject' => $subject,
      'attachments' => [
        [
          'filepath' => $file,
          'filename' => 'invoice_' . $invoice->label() . '.pdf',
          'filemime' => 'application/pdf'
        ]
      ]
    ];
    $mailManager->mail('trinion_tp', 'trinion_tp_otpravka_scheta', $to, $langcode, $params, NULL, TRUE);
    $form_state->setRedirect('entity.node.canonical', ['node' => $invoice->id()]);
  }
}
