<?php
namespace Drupal\trinion_zadachnik\Controller;

use Drupal\Component\Utility\Unicode;
use Drupal\node\Entity\Node;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class StartTaskAutocomplete {
  public function autocomplete(Request $request) {
    $query = \Drupal::entityQuery('node')
      ->condition('type', 'zadacha')
      ->condition('field_tz_otvetstvennyy', \Drupal::currentUser()->id())
      ->condition('field_tz_status_zadachi', \Drupal::config('trinion_zadachnik.settings')->get('status_zakrita_tid'), '!=')
      ->condition('field_tz_tema', $request->get('q'), 'CONTAINS');
    $query->range(0, 10);
    $query->sort('nid', 'DESC');
    $res = $query->accessCheck()->execute();
    $matches = [];
    foreach (Node::loadMultiple($res) as $task) {
      $label = '#' . $task->label() . '. ' . Unicode::truncate($task->get('field_tz_tema')->getString(), 50, TRUE, TRUE);
      $value = $label . ' (' . $task->id() . ')';
      $matches[] = ['value' => $value, 'label' => $label];
    }
    return new JsonResponse($matches);
  }
}
