<?php

namespace Drupal\trinion_zadachnik\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\node\Entity\Node;

/**
 * Time record form
 */
class TimeRecordForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'trinion_zadachnik_time_record';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $zadachnik_helper = \Drupal::service('trinion_zadachnik.helper');
    $open_time_record = $zadachnik_helper->getOpenTimeRecord();
    if ($open_time_record = reset($open_time_record)) {
      $open_time_record = Node::load($open_time_record);
      $time = $zadachnik_helper->calculateTaskTimeRecordsTotal($open_time_record->get('field_tz_zadacha')->getString());
      $task = $open_time_record->get('field_tz_zadacha')->first()->entity;
      $form['#task'] = $task;

      $start_date = new \DateTime($open_time_record->get('field_tz_vremya_nachala_zadachi')->getString());
      $date = new \Drupal\Core\Datetime\DrupalDateTime('+' . $time . ' minutes');
      $date->setTimezone(new \DateTimezone(\Drupal\datetime\Plugin\Field\FieldType\DateTimeItemInterface::STORAGE_TIMEZONE));
      $end_date = $date->format(\Drupal\datetime\Plugin\Field\FieldType\DateTimeItemInterface::DATETIME_STORAGE_FORMAT);
      $end_date = new \DateTime($end_date);
      $diff = $start_date->diff($end_date);
      $time = [];
      if ($diff->y)
        $time[] = t('%years years', ['%years' => $diff->y]);
      if ($diff->m)
        $time[] = t('%months months', ['%months' => $diff->m]);
      if ($diff->d)
        $time[] = t('%days days', ['%days' => $diff->d]);
      if ($diff->h)
        $time[] = t('%hours hours', ['%hours' => $diff->h]);
      if ($diff->i)
        $time[] = t('%minutes minutes', ['%minutes' => $diff->i]);
      if ($diff->s)
        $time[] = t('%seconds seconds', ['%seconds' => $diff->s]);
      $form['#counter'] = implode(' ', $time);
      if (empty($form['#counter'])) {
        $form['#counter'] = t('%seconds second', ['%seconds' => 1]);
      }

      $form['open_time_record'] = [
        '#type' => 'hidden',
        '#default_value' => $open_time_record->id(),
      ];
      $form['stop'] = [
        '#type' => 'submit',
        '#value' => t('Stop'),
        '#attributes' => ['class' => ['primary']],
      ];
    }
    else {
      $form['task'] = [
        '#type' => 'textfield',
        '#placeholder' => t('Task'),
        '#autocomplete_route_name' => 'trinion_zadachnik.start_task.autocomplete',
        '#weight' => -1,
        '#theme_wrappers' => [],
      ];
      $form['start'] = [
        '#type' => 'submit',
        '#value' => t('Start'),
        '#attributes' => ['class' => ['primary']],
        '#no-mt' => TRUE,
      ];
    }
    return $form;
  }

  public function validateForm(array &$form, FormStateInterface $form_state) {
    if ($form_state->getTriggeringElement()['#id'] == 'edit-start') {
      if (preg_match('/\((\d+)\)\s*$/', $form_state->getValue('task'), $match)) {
        if ($node = Node::load($match[1])) {
          if ($node->get('field_tz_otvetstvennyy')->getString() == \Drupal::currentUser()->id())
            if ($node->get('field_tz_status_zadachi')->getString() != \Drupal::config('trinion_zadachnik.settings')->get('status_zakrita_tid')) {
              $form_state->set('task_nid', $match[1]);
              return TRUE;
            }
        }
      }
      $form_state->setError($form['task'], t('You cannot take on this task.'));
    }
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $trigger_element = $form_state->getTriggeringElement()['#id'];
    $date = new \Drupal\Core\Datetime\DrupalDateTime('now');
    $date->setTimezone(new \DateTimezone(\Drupal\datetime\Plugin\Field\FieldType\DateTimeItemInterface::STORAGE_TIMEZONE));
    $time = $date->format(\Drupal\datetime\Plugin\Field\FieldType\DateTimeItemInterface::DATETIME_STORAGE_FORMAT);
    if ($trigger_element == 'edit-stop') {
      $open_time_record = Node::load($form_state->getValue('open_time_record'));
      $diff = strtotime($time) - strtotime($open_time_record->get('field_tz_vremya_nachala_zadachi')->getString());
      $open_time_record->field_tz_vrem_vypoleniya_zadachi = $time;
      $open_time_record->field_tz_timer = 'finished';
      $open_time_record->field_tz_kolichestvo_minut = round($diff / 60);
      $open_time_record->save();
    }
    elseif ($trigger_element == 'edit-start') {
      $uid = \Drupal::currentUser()->id();
      $node = Node::create([
        'type' => 'stroka_vremeni',
        'uid' => $uid,
        'status' => 1,
        'field_tz_data' => date('Y-m-d', strtotime($time)),
        'field_tz_vremya_nachala_zadachi' => $time,
        'field_tz_zadacha' => (int)$form_state->get('task_nid'),
        'field_tz_polzovatel' => $uid,
        'field_tz_kolichestvo_minut' => 0,
        'field_tz_timer' => 'active',
      ]);
      $node->save();
    }
  }
}
