<?php

namespace Drupal\trinion_zadachnik_crm\Plugin\Action;

use Drupal\Component\Utility\Unicode;
use Drupal\Core\Access\AccessResult;
use Drupal\Core\Datetime\DrupalDateTime;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginFormInterface;
use Drupal\Core\Render\Markup;
use Drupal\Core\Session\AccountInterface;
use Drupal\node\Entity\Node;
use Drupal\views_bulk_operations\Action\ViewsBulkOperationsActionBase;
use Drupal\views_bulk_operations\Action\ViewsBulkOperationsPreconfigurationInterface;

/**
 * @Action(
 *   id = "invoice_from_tasks",
 *   label = @Translation("Invoice from tasks"),
 *   type = "",
 *   confirm = TRUE,
 *   api_version = "1",
 * )
 */
class ViewsBulkOperationInvoiceFromTasksAction extends ViewsBulkOperationsActionBase {

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    return;
  }

  public function executeMultiple(array $objects) {
    $customers = [];
    foreach ($objects as $object) {
      $customers[$object->get('field_tz_proekt')->first()->entity->get('field_tzc_klient')->getString()][] = $object;
    }
    $uid = \Drupal::currentUser()->id();
    $now = DrupalDateTime::createFromTimestamp(time());
    $now->setTimezone(new \DateTimeZone('UTC'));
    $crm_zadachnik_settings = \Drupal::config('trinion_zadachnik_crm.settings');
    $crm_settings = \Drupal::config('trinion_zadachnik_crm.settings');
    foreach ($customers as $customer_id => $tasks) {
      $schet_data = [
        'type' => 'schet',
        'title' => \Drupal::service('trinion_tp.helper')->getNextDocumentNumber('schet'),
        'uid' => $uid,
        'status' => 1,
        'field_tp_schet_dlya' => $customer_id,
        'field_tp_data' => $now->format('Y-m-d\TH:i:s'),
        'field_tp_otvetstvennyy' => $uid,
        'field_tp_organizaciya' => $crm_settings->get('default_organization'),
      ];
      foreach ($tasks as $object) {
        $tovar = $crm_zadachnik_settings->get('task_tovar_nid');
        $tovar = Node::load($tovar);
        $task_id = $object->id();
        $rate = \Drupal::service('trinion_zadachnik_crm.helper')->getHourlyRateByUserAndCustomer($uid, $customer_id);

        if ($rate)
          $sum = (\Drupal::service('trinion_zadachnik.helper')->calculateTaskTimeRecordsTotal($task_id) / 60) * $rate->get('field_tzc_stavka')->getString();
        else
          $sum = 0;

        $item_data = [
          'type' => 'tp_stroka_dokumenta_uit',
          'status' => 1,
          'uid' => $uid,
          'field_tp_kolichestvo' => 1,
          'title' => Unicode::truncate($object->get('field_tz_tema')->getString(), 200, TRUE),
          'field_tp_opisanie' => '#' . $object->label() . ' ' . $object->get('field_tz_tema')->getString(),
          'field_tp_artikul' => $tovar->get('field_tp_artikul')->getString(),
          'field_tp_tovar' => $tovar->id(),
          'field_tp_cena' => $sum,
          'field_tzc_zadacha' => $task_id,
        ];
        if ($edinica = $tovar->get('field_tp_edinica_izmereniya')->getString())
          $item_data['field_tp_edinica_izmereniya'] = $edinica;
        $item = Node::create($item_data);
        $item->save();
        $schet_data['field_tp_stroki'][] = $item->id();
      }
      $schet = Node::create($schet_data);
      $schet->save();
    }
  }

  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    $form['list']['#access'] = FALSE;
    $not_approve_tasks = $approve_tasks = [];
    $vbo_form_state = $form_state->get('views_bulk_operations');
    foreach ($form_state->get('views_bulk_operations')['list'] as $key => $item) {
      $node = Node::load($item[0]);
      $customer = $node->get('field_tz_proekt')->first()->entity->get('field_tzc_klient')->getString();
      if ($customer && $node->get('field_tz_status_zadachi')->getString() == \Drupal::config('trinion_zadachnik.settings')->get('status_vipolnenae_tid')) {
        $approve_tasks[] = $node->label();
      }
      else {
        if (empty($customer)) {
          \Drupal::messenger()->addError(t('Task %task, customer is not defined', ['%task' => $node->label()]));
        }
        else {
          \Drupal::messenger()->addError(t('Task %task, status is not Completed', ['%task' => $node->label()]));
        }
        unset($vbo_form_state['list'][$key]);
        $not_approve_tasks[] = $node->label();
      }
    }
    if ($approve_tasks) {
      $form['approved_tasks'] = [
        '#theme' => 'item_list',
        '#items' => $approve_tasks,
        '#title' => t('The tasks from which the invoice will be created'),
      ];
    }
    else {
      \Drupal::messenger()->addError(t('There is no tasks to create invoice.'));
    }
    $form_state->set('views_bulk_operations', $vbo_form_state);
    if ($not_approve_tasks)
      $form['not_approved_tasks'] = [
        '#theme' => 'item_list',
        '#items' => $not_approve_tasks,
        '#title' => t('Tasks for which it is impossible to create an invoice'),
      ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function access($object, ?AccountInterface $account = NULL, $return_as_object = FALSE) {
    return AccessResult::allowed();
  }
}
