<?php

namespace Drupal\trinion_zadachnik_crm;

use Drupal\node\Entity\Node;
use Drupal\taxonomy\Entity\Term;
use Drupal\user\Entity\User;

class TrinionHelper {
  public function getHourlyRateByUserAndCustomer($user_id, $customer_id) {
    if ($company = Node::load($customer_id) ) {
      if ($rate = $company->get('field_tzc_hourly_rate')->getString()) {
        $rate = Term::load($rate);
      }
    }
    if (empty($rate)) {
      $user = User::load($user_id);
      if ($rate = $user->get('field_tzc_hourly_rate')->getString()) {
        $rate = Term::load($rate);
      }
    }
    return $rate ?? FALSE;
  }
}
