--
-- Note by Lacey-anne Sanderson:
-- File contains the SO schema.
--
CREATE SCHEMA so;
SET search_path=so,public,pg_catalog;

--- ************************************************
--- *** relation: region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence_feature with an extent greate ***
--- *** r than zero. A nucleotide region is comp ***
--- *** osed of bases and a polypeptide region i ***
--- *** s composed of amino acids.               ***
--- ************************************************
---

CREATE VIEW region AS
  SELECT
    feature_id AS region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'biomaterial_region' OR cvterm.name = 'experimental_feature' OR cvterm.name = 'biological_region' OR cvterm.name = 'topologically_defined_region' OR cvterm.name = 'reagent' OR cvterm.name = 'engineered_region' OR cvterm.name = 'PCR_product' OR cvterm.name = 'clone' OR cvterm.name = 'rescue_region' OR cvterm.name = 'oligo' OR cvterm.name = 'clone_insert' OR cvterm.name = 'cloned_region' OR cvterm.name = 'databank_entry' OR cvterm.name = 'RAPD' OR cvterm.name = 'genomic_clone' OR cvterm.name = 'cDNA_clone' OR cvterm.name = 'tiling_path_clone' OR cvterm.name = 'validated_cDNA_clone' OR cvterm.name = 'invalidated_cDNA_clone' OR cvterm.name = 'three_prime_RACE_clone' OR cvterm.name = 'chimeric_cDNA_clone' OR cvterm.name = 'genomically_contaminated_cDNA_clone' OR cvterm.name = 'polyA_primed_cDNA_clone' OR cvterm.name = 'partially_processed_cDNA_clone' OR cvterm.name = 'engineered_rescue_region' OR cvterm.name = 'aptamer' OR cvterm.name = 'probe' OR cvterm.name = 'tag' OR cvterm.name = 'ss_oligo' OR cvterm.name = 'ds_oligo' OR cvterm.name = 'DNAzyme' OR cvterm.name = 'synthetic_oligo' OR cvterm.name = 'DNA_aptamer' OR cvterm.name = 'RNA_aptamer' OR cvterm.name = 'microarray_oligo' OR cvterm.name = 'SAGE_tag' OR cvterm.name = 'STS' OR cvterm.name = 'EST' OR cvterm.name = 'engineered_tag' OR cvterm.name = 'five_prime_EST' OR cvterm.name = 'three_prime_EST' OR cvterm.name = 'UST' OR cvterm.name = 'RST' OR cvterm.name = 'three_prime_UST' OR cvterm.name = 'five_prime_UST' OR cvterm.name = 'three_prime_RST' OR cvterm.name = 'five_prime_RST' OR cvterm.name = 'primer' OR cvterm.name = 'sequencing_primer' OR cvterm.name = 'forward_primer' OR cvterm.name = 'reverse_primer' OR cvterm.name = 'ASPE_primer' OR cvterm.name = 'dCAPS_primer' OR cvterm.name = 'RNAi_reagent' OR cvterm.name = 'DNA_constraint_sequence' OR cvterm.name = 'morpholino_oligo' OR cvterm.name = 'PNA_oligo' OR cvterm.name = 'LNA_oligo' OR cvterm.name = 'TNA_oligo' OR cvterm.name = 'GNA_oligo' OR cvterm.name = 'R_GNA_oligo' OR cvterm.name = 'S_GNA_oligo' OR cvterm.name = 'cloned_cDNA_insert' OR cvterm.name = 'cloned_genomic_insert' OR cvterm.name = 'engineered_insert' OR cvterm.name = 'BAC_cloned_genomic_insert' OR cvterm.name = 'engineered_gene' OR cvterm.name = 'engineered_plasmid' OR cvterm.name = 'engineered_rescue_region' OR cvterm.name = 'engineered_transposable_element' OR cvterm.name = 'engineered_foreign_region' OR cvterm.name = 'engineered_tag' OR cvterm.name = 'engineered_insert' OR cvterm.name = 'targeting_vector' OR cvterm.name = 'engineered_foreign_gene' OR cvterm.name = 'engineered_fusion_gene' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'engineered_episome' OR cvterm.name = 'gene_trap_construct' OR cvterm.name = 'promoter_trap_construct' OR cvterm.name = 'enhancer_trap_construct' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'engineered_foreign_gene' OR cvterm.name = 'engineered_foreign_repetitive_element' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'match_part' OR cvterm.name = 'assembly_component' OR cvterm.name = 'conserved_region' OR cvterm.name = 'match' OR cvterm.name = 'remark' OR cvterm.name = 'reading_frame' OR cvterm.name = 'consensus_region' OR cvterm.name = 'low_complexity_region' OR cvterm.name = 'assembly' OR cvterm.name = 'transcribed_fragment' OR cvterm.name = 'transcribed_cluster' OR cvterm.name = 'high_identity_region' OR cvterm.name = 'mathematically_defined_repeat' OR cvterm.name = 'experimentally_defined_binding_region' OR cvterm.name = 'contig' OR cvterm.name = 'read' OR cvterm.name = 'restriction_fragment' OR cvterm.name = 'golden_path_fragment' OR cvterm.name = 'tiling_path_fragment' OR cvterm.name = 'gap' OR cvterm.name = 'sonicate_fragment' OR cvterm.name = 'paired_end_fragment' OR cvterm.name = 'read_pair' OR cvterm.name = 'contig_read' OR cvterm.name = 'BAC_end' OR cvterm.name = 'dye_terminator_read' OR cvterm.name = 'pyrosequenced_read' OR cvterm.name = 'ligation_based_read' OR cvterm.name = 'polymerase_synthesis_read' OR cvterm.name = 'PAC_end' OR cvterm.name = 'YAC_end' OR cvterm.name = 'clone_end' OR cvterm.name = 'RFLP_fragment' OR cvterm.name = 'tiling_path_clone' OR cvterm.name = 'coding_conserved_region' OR cvterm.name = 'nc_conserved_region' OR cvterm.name = 'RR_tract' OR cvterm.name = 'homologous_region' OR cvterm.name = 'centromere_DNA_Element_I' OR cvterm.name = 'centromere_DNA_Element_II' OR cvterm.name = 'centromere_DNA_Element_III' OR cvterm.name = 'X_element' OR cvterm.name = 'U_box' OR cvterm.name = 'regional_centromere_central_core' OR cvterm.name = 'syntenic_region' OR cvterm.name = 'paralogous_region' OR cvterm.name = 'orthologous_region' OR cvterm.name = 'nucleotide_match' OR cvterm.name = 'protein_match' OR cvterm.name = 'expressed_sequence_match' OR cvterm.name = 'cross_genome_match' OR cvterm.name = 'translated_nucleotide_match' OR cvterm.name = 'primer_match' OR cvterm.name = 'EST_match' OR cvterm.name = 'cDNA_match' OR cvterm.name = 'UST_match' OR cvterm.name = 'RST_match' OR cvterm.name = 'sequence_difference' OR cvterm.name = 'experimental_result_region' OR cvterm.name = 'polypeptide_sequencing_information' OR cvterm.name = 'possible_base_call_error' OR cvterm.name = 'possible_assembly_error' OR cvterm.name = 'assembly_error_correction' OR cvterm.name = 'base_call_error_correction' OR cvterm.name = 'overlapping_feature_set' OR cvterm.name = 'no_output' OR cvterm.name = 'overlapping_EST_set' OR cvterm.name = 'non_adjacent_residues' OR cvterm.name = 'non_terminal_residue' OR cvterm.name = 'sequence_conflict' OR cvterm.name = 'sequence_uncertainty' OR cvterm.name = 'contig_collection' OR cvterm.name = 'ORF' OR cvterm.name = 'blocked_reading_frame' OR cvterm.name = 'mini_gene' OR cvterm.name = 'rescue_mini_gene' OR cvterm.name = 'consensus_mRNA' OR cvterm.name = 'sequence_assembly' OR cvterm.name = 'fragment_assembly' OR cvterm.name = 'supercontig' OR cvterm.name = 'contig' OR cvterm.name = 'tiling_path' OR cvterm.name = 'virtual_sequence' OR cvterm.name = 'golden_path' OR cvterm.name = 'ultracontig' OR cvterm.name = 'expressed_sequence_assembly' OR cvterm.name = 'fingerprint_map' OR cvterm.name = 'STS_map' OR cvterm.name = 'RH_map' OR cvterm.name = 'unigene_cluster' OR cvterm.name = 'CHiP_seq_region' OR cvterm.name = 'sequence_secondary_structure' OR cvterm.name = 'linkage_group' OR cvterm.name = 'polypeptide' OR cvterm.name = 'deletion' OR cvterm.name = 'origin_of_replication' OR cvterm.name = 'recombination_feature' OR cvterm.name = 'CpG_island' OR cvterm.name = 'pseudogene' OR cvterm.name = 'binding_site' OR cvterm.name = 'pseudogenic_region' OR cvterm.name = 'cap' OR cvterm.name = 'intergenic_region' OR cvterm.name = 'oligo_U_tail' OR cvterm.name = 'polyA_sequence' OR cvterm.name = 'repeat_region' OR cvterm.name = 'insertion' OR cvterm.name = 'gene' OR cvterm.name = 'repeat_unit' OR cvterm.name = 'QTL' OR cvterm.name = 'chromosome_part' OR cvterm.name = 'gene_member_region' OR cvterm.name = 'transcript_region' OR cvterm.name = 'polypeptide_region' OR cvterm.name = 'gene_component_region' OR cvterm.name = 'mobile_genetic_element' OR cvterm.name = 'replicon' OR cvterm.name = 'base' OR cvterm.name = 'amino_acid' OR cvterm.name = 'genetic_marker' OR cvterm.name = 'sequence_motif' OR cvterm.name = 'restriction_enzyme_recognition_site' OR cvterm.name = 'restriction_enzyme_single_strand_overhang' OR cvterm.name = 'epigenetically_modified_region' OR cvterm.name = 'open_chromatin_region' OR cvterm.name = 'gene_group' OR cvterm.name = 'substitution' OR cvterm.name = 'inversion' OR cvterm.name = 'retron' OR cvterm.name = 'G_quartet' OR cvterm.name = 'base_pair' OR cvterm.name = 'RNA_sequence_secondary_structure' OR cvterm.name = 'DNA_sequence_secondary_structure' OR cvterm.name = 'pseudoknot' OR cvterm.name = 'WC_base_pair' OR cvterm.name = 'sugar_edge_base_pair' OR cvterm.name = 'Hoogsteen_base_pair' OR cvterm.name = 'reverse_Hoogsteen_base_pair' OR cvterm.name = 'wobble_base_pair' OR cvterm.name = 'stem_loop' OR cvterm.name = 'tetraloop' OR cvterm.name = 'i_motif' OR cvterm.name = 'recoding_pseudoknot' OR cvterm.name = 'H_pseudoknot' OR cvterm.name = 'D_loop' OR cvterm.name = 'ARS' OR cvterm.name = 'oriT' OR cvterm.name = 'amplification_origin' OR cvterm.name = 'oriV' OR cvterm.name = 'oriC' OR cvterm.name = 'recombination_hotspot' OR cvterm.name = 'haplotype_block' OR cvterm.name = 'sequence_rearrangement_feature' OR cvterm.name = 'iDNA' OR cvterm.name = 'specific_recombination_site' OR cvterm.name = 'chromosome_breakage_sequence' OR cvterm.name = 'internal_eliminated_sequence' OR cvterm.name = 'macronucleus_destined_segment' OR cvterm.name = 'recombination_feature_of_rearranged_gene' OR cvterm.name = 'site_specific_recombination_target_region' OR cvterm.name = 'recombination_signal_sequence' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_feature' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_segment' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_gene_cluster' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_spacer' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_segment' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_gene_cluster' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_signal_feature' OR cvterm.name = 'D_gene' OR cvterm.name = 'V_gene' OR cvterm.name = 'J_gene' OR cvterm.name = 'C_gene' OR cvterm.name = 'D_J_C_cluster' OR cvterm.name = 'J_C_cluster' OR cvterm.name = 'J_cluster' OR cvterm.name = 'V_cluster' OR cvterm.name = 'V_J_cluster' OR cvterm.name = 'V_J_C_cluster' OR cvterm.name = 'C_cluster' OR cvterm.name = 'D_cluster' OR cvterm.name = 'D_J_cluster' OR cvterm.name = 'three_prime_D_spacer' OR cvterm.name = 'five_prime_D_spacer' OR cvterm.name = 'J_spacer' OR cvterm.name = 'V_spacer' OR cvterm.name = 'VD_gene' OR cvterm.name = 'DJ_gene' OR cvterm.name = 'VDJ_gene' OR cvterm.name = 'VJ_gene' OR cvterm.name = 'DJ_J_cluster' OR cvterm.name = 'VDJ_J_C_cluster' OR cvterm.name = 'VDJ_J_cluster' OR cvterm.name = 'VJ_C_cluster' OR cvterm.name = 'VJ_J_C_cluster' OR cvterm.name = 'VJ_J_cluster' OR cvterm.name = 'D_DJ_C_cluster' OR cvterm.name = 'D_DJ_cluster' OR cvterm.name = 'D_DJ_J_C_cluster' OR cvterm.name = 'D_DJ_J_cluster' OR cvterm.name = 'V_DJ_cluster' OR cvterm.name = 'V_DJ_J_cluster' OR cvterm.name = 'V_VDJ_C_cluster' OR cvterm.name = 'V_VDJ_cluster' OR cvterm.name = 'V_VDJ_J_cluster' OR cvterm.name = 'V_VJ_C_cluster' OR cvterm.name = 'V_VJ_cluster' OR cvterm.name = 'V_VJ_J_cluster' OR cvterm.name = 'V_D_DJ_C_cluster' OR cvterm.name = 'V_D_DJ_cluster' OR cvterm.name = 'V_D_DJ_J_C_cluster' OR cvterm.name = 'V_D_DJ_J_cluster' OR cvterm.name = 'V_D_J_C_cluster' OR cvterm.name = 'V_D_J_cluster' OR cvterm.name = 'DJ_C_cluster' OR cvterm.name = 'DJ_J_C_cluster' OR cvterm.name = 'VDJ_C_cluster' OR cvterm.name = 'V_DJ_C_cluster' OR cvterm.name = 'V_DJ_J_C_cluster' OR cvterm.name = 'V_VDJ_J_C_cluster' OR cvterm.name = 'V_VJ_J_C_cluster' OR cvterm.name = 'J_gene_recombination_feature' OR cvterm.name = 'D_gene_recombination_feature' OR cvterm.name = 'V_gene_recombination_feature' OR cvterm.name = 'heptamer_of_recombination_feature_of_vertebrate_immune_system_gene' OR cvterm.name = 'nonamer_of_recombination_feature_of_vertebrate_immune_system_gene' OR cvterm.name = 'five_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_heptamer' OR cvterm.name = 'five_prime_D_heptamer' OR cvterm.name = 'J_heptamer' OR cvterm.name = 'V_heptamer' OR cvterm.name = 'three_prime_D_nonamer' OR cvterm.name = 'five_prime_D_nonamer' OR cvterm.name = 'J_nonamer' OR cvterm.name = 'V_nonamer' OR cvterm.name = 'integration_excision_site' OR cvterm.name = 'resolution_site' OR cvterm.name = 'inversion_site' OR cvterm.name = 'inversion_site_part' OR cvterm.name = 'attI_site' OR cvterm.name = 'attP_site' OR cvterm.name = 'attB_site' OR cvterm.name = 'attL_site' OR cvterm.name = 'attR_site' OR cvterm.name = 'attC_site' OR cvterm.name = 'attCtn_site' OR cvterm.name = 'loxP_site' OR cvterm.name = 'dif_site' OR cvterm.name = 'FRT_site' OR cvterm.name = 'IRLinv_site' OR cvterm.name = 'IRRinv_site' OR cvterm.name = 'processed_pseudogene' OR cvterm.name = 'non_processed_pseudogene' OR cvterm.name = 'pseudogene_by_unequal_crossing_over' OR cvterm.name = 'nuclear_mt_pseudogene' OR cvterm.name = 'cassette_pseudogene' OR cvterm.name = 'duplicated_pseudogene' OR cvterm.name = 'unitary_pseudogene' OR cvterm.name = 'protein_binding_site' OR cvterm.name = 'epitope' OR cvterm.name = 'nucleotide_binding_site' OR cvterm.name = 'metal_binding_site' OR cvterm.name = 'ligand_binding_site' OR cvterm.name = 'protein_protein_contact' OR cvterm.name = 'nucleotide_to_protein_binding_site' OR cvterm.name = 'nuclease_binding_site' OR cvterm.name = 'TF_binding_site' OR cvterm.name = 'histone_binding_site' OR cvterm.name = 'insulator_binding_site' OR cvterm.name = 'enhancer_binding_site' OR cvterm.name = 'restriction_enzyme_binding_site' OR cvterm.name = 'nuclease_sensitive_site' OR cvterm.name = 'homing_endonuclease_binding_site' OR cvterm.name = 'nuclease_hypersensitive_site' OR cvterm.name = 'group_1_intron_homing_endonuclease_target_region' OR cvterm.name = 'DNAseI_hypersensitive_site' OR cvterm.name = 'miRNA_target_site' OR cvterm.name = 'DNA_binding_site' OR cvterm.name = 'primer_binding_site' OR cvterm.name = 'polypeptide_DNA_contact' OR cvterm.name = 'polypeptide_metal_contact' OR cvterm.name = 'polypeptide_calcium_ion_contact_site' OR cvterm.name = 'polypeptide_cobalt_ion_contact_site' OR cvterm.name = 'polypeptide_copper_ion_contact_site' OR cvterm.name = 'polypeptide_iron_ion_contact_site' OR cvterm.name = 'polypeptide_magnesium_ion_contact_site' OR cvterm.name = 'polypeptide_manganese_ion_contact_site' OR cvterm.name = 'polypeptide_molybdenum_ion_contact_site' OR cvterm.name = 'polypeptide_nickel_ion_contact_site' OR cvterm.name = 'polypeptide_tungsten_ion_contact_site' OR cvterm.name = 'polypeptide_zinc_ion_contact_site' OR cvterm.name = 'polypeptide_ligand_contact' OR cvterm.name = 'decayed_exon' OR cvterm.name = 'pseudogenic_exon' OR cvterm.name = 'pseudogenic_transcript' OR cvterm.name = 'pseudogenic_rRNA' OR cvterm.name = 'pseudogenic_tRNA' OR cvterm.name = 'long_terminal_repeat' OR cvterm.name = 'engineered_foreign_repetitive_element' OR cvterm.name = 'inverted_repeat' OR cvterm.name = 'direct_repeat' OR cvterm.name = 'non_LTR_retrotransposon_polymeric_tract' OR cvterm.name = 'dispersed_repeat' OR cvterm.name = 'tandem_repeat' OR cvterm.name = 'X_element_combinatorial_repeat' OR cvterm.name = 'Y_prime_element' OR cvterm.name = 'telomeric_repeat' OR cvterm.name = 'nested_repeat' OR cvterm.name = 'centromeric_repeat' OR cvterm.name = 'five_prime_LTR' OR cvterm.name = 'three_prime_LTR' OR cvterm.name = 'solo_LTR' OR cvterm.name = 'terminal_inverted_repeat' OR cvterm.name = 'five_prime_terminal_inverted_repeat' OR cvterm.name = 'three_prime_terminal_inverted_repeat' OR cvterm.name = 'target_site_duplication' OR cvterm.name = 'CRISPR' OR cvterm.name = 'satellite_DNA' OR cvterm.name = 'microsatellite' OR cvterm.name = 'minisatellite' OR cvterm.name = 'dinucleotide_repeat_microsatellite_feature' OR cvterm.name = 'trinucleotide_repeat_microsatellite_feature' OR cvterm.name = 'tetranucleotide_repeat_microsatellite_feature' OR cvterm.name = 'nested_tandem_repeat' OR cvterm.name = 'regional_centromere_inner_repeat_region' OR cvterm.name = 'regional_centromere_outer_repeat_region' OR cvterm.name = 'transgenic_insertion' OR cvterm.name = 'duplication' OR cvterm.name = 'tandem_duplication' OR cvterm.name = 'direct_tandem_duplication' OR cvterm.name = 'inverted_tandem_duplication' OR cvterm.name = 'nuclear_gene' OR cvterm.name = 'mt_gene' OR cvterm.name = 'plastid_gene' OR cvterm.name = 'nucleomorph_gene' OR cvterm.name = 'plasmid_gene' OR cvterm.name = 'proviral_gene' OR cvterm.name = 'transposable_element_gene' OR cvterm.name = 'silenced_gene' OR cvterm.name = 'engineered_gene' OR cvterm.name = 'foreign_gene' OR cvterm.name = 'fusion_gene' OR cvterm.name = 'recombinationally_rearranged_gene' OR cvterm.name = 'gene_with_trans_spliced_transcript' OR cvterm.name = 'gene_with_polycistronic_transcript' OR cvterm.name = 'rescue_gene' OR cvterm.name = 'post_translationally_regulated_gene' OR cvterm.name = 'negatively_autoregulated_gene' OR cvterm.name = 'positively_autoregulated_gene' OR cvterm.name = 'translationally_regulated_gene' OR cvterm.name = 'epigenetically_modified_gene' OR cvterm.name = 'transgene' OR cvterm.name = 'predicted_gene' OR cvterm.name = 'protein_coding_gene' OR cvterm.name = 'retrogene' OR cvterm.name = 'ncRNA_gene' OR cvterm.name = 'cryptic_gene' OR cvterm.name = 'gene_with_non_canonical_start_codon' OR cvterm.name = 'gene_cassette' OR cvterm.name = 'kinetoplast_gene' OR cvterm.name = 'maxicircle_gene' OR cvterm.name = 'minicircle_gene' OR cvterm.name = 'cryptogene' OR cvterm.name = 'apicoplast_gene' OR cvterm.name = 'ct_gene' OR cvterm.name = 'chromoplast_gene' OR cvterm.name = 'cyanelle_gene' OR cvterm.name = 'leucoplast_gene' OR cvterm.name = 'proplastid_gene' OR cvterm.name = 'endogenous_retroviral_gene' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'gene_silenced_by_DNA_modification' OR cvterm.name = 'gene_silenced_by_RNA_interference' OR cvterm.name = 'gene_silenced_by_histone_modification' OR cvterm.name = 'gene_silenced_by_DNA_methylation' OR cvterm.name = 'gene_silenced_by_histone_methylation' OR cvterm.name = 'gene_silenced_by_histone_deacetylation' OR cvterm.name = 'engineered_foreign_gene' OR cvterm.name = 'engineered_fusion_gene' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'engineered_foreign_gene' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'engineered_fusion_gene' OR cvterm.name = 'recombinationally_inverted_gene' OR cvterm.name = 'recombinationally_rearranged_vertebrate_immune_system_gene' OR cvterm.name = 'gene_with_dicistronic_transcript' OR cvterm.name = 'gene_with_dicistronic_primary_transcript' OR cvterm.name = 'gene_with_dicistronic_mRNA' OR cvterm.name = 'wild_type_rescue_gene' OR cvterm.name = 'gene_rearranged_at_DNA_level' OR cvterm.name = 'maternally_imprinted_gene' OR cvterm.name = 'paternally_imprinted_gene' OR cvterm.name = 'allelically_excluded_gene' OR cvterm.name = 'floxed_gene' OR cvterm.name = 'gene_with_polyadenylated_mRNA' OR cvterm.name = 'gene_with_mRNA_with_frameshift' OR cvterm.name = 'gene_with_edited_transcript' OR cvterm.name = 'gene_with_recoded_mRNA' OR cvterm.name = 'gene_with_stop_codon_read_through' OR cvterm.name = 'gene_with_mRNA_recoded_by_translational_bypass' OR cvterm.name = 'gene_with_transcript_with_translational_frameshift' OR cvterm.name = 'gene_with_stop_codon_redefined_as_pyrrolysine' OR cvterm.name = 'gene_with_stop_codon_redefined_as_selenocysteine' OR cvterm.name = 'gRNA_gene' OR cvterm.name = 'miRNA_gene' OR cvterm.name = 'scRNA_gene' OR cvterm.name = 'snoRNA_gene' OR cvterm.name = 'snRNA_gene' OR cvterm.name = 'SRP_RNA_gene' OR cvterm.name = 'stRNA_gene' OR cvterm.name = 'tmRNA_gene' OR cvterm.name = 'tRNA_gene' OR cvterm.name = 'rRNA_gene' OR cvterm.name = 'piRNA_gene' OR cvterm.name = 'RNase_P_RNA_gene' OR cvterm.name = 'RNase_MRP_RNA_gene' OR cvterm.name = 'lincRNA_gene' OR cvterm.name = 'telomerase_RNA_gene' OR cvterm.name = 'cryptogene' OR cvterm.name = 'gene_with_start_codon_CUG' OR cvterm.name = 'chromosome_arm' OR cvterm.name = 'chromosome_band' OR cvterm.name = 'interband' OR cvterm.name = 'chromosomal_regulatory_element' OR cvterm.name = 'chromosomal_structural_element' OR cvterm.name = 'introgressed_chromosome_region' OR cvterm.name = 'matrix_attachment_site' OR cvterm.name = 'centromere' OR cvterm.name = 'telomere' OR cvterm.name = 'point_centromere' OR cvterm.name = 'regional_centromere' OR cvterm.name = 'transcript' OR cvterm.name = 'regulatory_region' OR cvterm.name = 'polycistronic_transcript' OR cvterm.name = 'transcript_with_translational_frameshift' OR cvterm.name = 'primary_transcript' OR cvterm.name = 'mature_transcript' OR cvterm.name = 'transcript_bound_by_nucleic_acid' OR cvterm.name = 'transcript_bound_by_protein' OR cvterm.name = 'enzymatic_RNA' OR cvterm.name = 'trans_spliced_transcript' OR cvterm.name = 'monocistronic_transcript' OR cvterm.name = 'aberrant_processed_transcript' OR cvterm.name = 'edited_transcript' OR cvterm.name = 'processed_transcript' OR cvterm.name = 'alternatively_spliced_transcript' OR cvterm.name = 'dicistronic_transcript' OR cvterm.name = 'polycistronic_primary_transcript' OR cvterm.name = 'polycistronic_mRNA' OR cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'protein_coding_primary_transcript' OR cvterm.name = 'nc_primary_transcript' OR cvterm.name = 'polycistronic_primary_transcript' OR cvterm.name = 'monocistronic_primary_transcript' OR cvterm.name = 'mini_exon_donor_RNA' OR cvterm.name = 'antisense_primary_transcript' OR cvterm.name = 'capped_primary_transcript' OR cvterm.name = 'pre_edited_mRNA' OR cvterm.name = 'scRNA_primary_transcript' OR cvterm.name = 'rRNA_primary_transcript' OR cvterm.name = 'tRNA_primary_transcript' OR cvterm.name = 'snRNA_primary_transcript' OR cvterm.name = 'snoRNA_primary_transcript' OR cvterm.name = 'tmRNA_primary_transcript' OR cvterm.name = 'SRP_RNA_primary_transcript' OR cvterm.name = 'miRNA_primary_transcript' OR cvterm.name = 'tasiRNA_primary_transcript' OR cvterm.name = 'rRNA_small_subunit_primary_transcript' OR cvterm.name = 'rRNA_large_subunit_primary_transcript' OR cvterm.name = 'alanine_tRNA_primary_transcript' OR cvterm.name = 'arginine_tRNA_primary_transcript' OR cvterm.name = 'asparagine_tRNA_primary_transcript' OR cvterm.name = 'aspartic_acid_tRNA_primary_transcript' OR cvterm.name = 'cysteine_tRNA_primary_transcript' OR cvterm.name = 'glutamic_acid_tRNA_primary_transcript' OR cvterm.name = 'glutamine_tRNA_primary_transcript' OR cvterm.name = 'glycine_tRNA_primary_transcript' OR cvterm.name = 'histidine_tRNA_primary_transcript' OR cvterm.name = 'isoleucine_tRNA_primary_transcript' OR cvterm.name = 'leucine_tRNA_primary_transcript' OR cvterm.name = 'lysine_tRNA_primary_transcript' OR cvterm.name = 'methionine_tRNA_primary_transcript' OR cvterm.name = 'phenylalanine_tRNA_primary_transcript' OR cvterm.name = 'proline_tRNA_primary_transcript' OR cvterm.name = 'serine_tRNA_primary_transcript' OR cvterm.name = 'threonine_tRNA_primary_transcript' OR cvterm.name = 'tryptophan_tRNA_primary_transcript' OR cvterm.name = 'tyrosine_tRNA_primary_transcript' OR cvterm.name = 'valine_tRNA_primary_transcript' OR cvterm.name = 'pyrrolysine_tRNA_primary_transcript' OR cvterm.name = 'selenocysteine_tRNA_primary_transcript' OR cvterm.name = 'methylation_guide_snoRNA_primary_transcript' OR cvterm.name = 'rRNA_cleavage_snoRNA_primary_transcript' OR cvterm.name = 'C_D_box_snoRNA_primary_transcript' OR cvterm.name = 'H_ACA_box_snoRNA_primary_transcript' OR cvterm.name = 'U14_snoRNA_primary_transcript' OR cvterm.name = 'stRNA_primary_transcript' OR cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'mRNA' OR cvterm.name = 'ncRNA' OR cvterm.name = 'mRNA_with_frameshift' OR cvterm.name = 'monocistronic_mRNA' OR cvterm.name = 'polycistronic_mRNA' OR cvterm.name = 'exemplar_mRNA' OR cvterm.name = 'capped_mRNA' OR cvterm.name = 'polyadenylated_mRNA' OR cvterm.name = 'trans_spliced_mRNA' OR cvterm.name = 'edited_mRNA' OR cvterm.name = 'consensus_mRNA' OR cvterm.name = 'recoded_mRNA' OR cvterm.name = 'mRNA_with_minus_1_frameshift' OR cvterm.name = 'mRNA_with_plus_1_frameshift' OR cvterm.name = 'mRNA_with_plus_2_frameshift' OR cvterm.name = 'mRNA_with_minus_2_frameshift' OR cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'mRNA_recoded_by_translational_bypass' OR cvterm.name = 'mRNA_recoded_by_codon_redefinition' OR cvterm.name = 'scRNA' OR cvterm.name = 'rRNA' OR cvterm.name = 'tRNA' OR cvterm.name = 'snRNA' OR cvterm.name = 'snoRNA' OR cvterm.name = 'small_regulatory_ncRNA' OR cvterm.name = 'RNase_MRP_RNA' OR cvterm.name = 'RNase_P_RNA' OR cvterm.name = 'telomerase_RNA' OR cvterm.name = 'vault_RNA' OR cvterm.name = 'Y_RNA' OR cvterm.name = 'rasiRNA' OR cvterm.name = 'SRP_RNA' OR cvterm.name = 'guide_RNA' OR cvterm.name = 'antisense_RNA' OR cvterm.name = 'siRNA' OR cvterm.name = 'stRNA' OR cvterm.name = 'class_II_RNA' OR cvterm.name = 'class_I_RNA' OR cvterm.name = 'piRNA' OR cvterm.name = 'lincRNA' OR cvterm.name = 'tasiRNA' OR cvterm.name = 'rRNA_cleavage_RNA' OR cvterm.name = 'small_subunit_rRNA' OR cvterm.name = 'large_subunit_rRNA' OR cvterm.name = 'rRNA_18S' OR cvterm.name = 'rRNA_16S' OR cvterm.name = 'rRNA_5_8S' OR cvterm.name = 'rRNA_5S' OR cvterm.name = 'rRNA_28S' OR cvterm.name = 'rRNA_23S' OR cvterm.name = 'rRNA_25S' OR cvterm.name = 'rRNA_21S' OR cvterm.name = 'alanyl_tRNA' OR cvterm.name = 'asparaginyl_tRNA' OR cvterm.name = 'aspartyl_tRNA' OR cvterm.name = 'cysteinyl_tRNA' OR cvterm.name = 'glutaminyl_tRNA' OR cvterm.name = 'glutamyl_tRNA' OR cvterm.name = 'glycyl_tRNA' OR cvterm.name = 'histidyl_tRNA' OR cvterm.name = 'isoleucyl_tRNA' OR cvterm.name = 'leucyl_tRNA' OR cvterm.name = 'lysyl_tRNA' OR cvterm.name = 'methionyl_tRNA' OR cvterm.name = 'phenylalanyl_tRNA' OR cvterm.name = 'prolyl_tRNA' OR cvterm.name = 'seryl_tRNA' OR cvterm.name = 'threonyl_tRNA' OR cvterm.name = 'tryptophanyl_tRNA' OR cvterm.name = 'tyrosyl_tRNA' OR cvterm.name = 'valyl_tRNA' OR cvterm.name = 'pyrrolysyl_tRNA' OR cvterm.name = 'arginyl_tRNA' OR cvterm.name = 'selenocysteinyl_tRNA' OR cvterm.name = 'U1_snRNA' OR cvterm.name = 'U2_snRNA' OR cvterm.name = 'U4_snRNA' OR cvterm.name = 'U4atac_snRNA' OR cvterm.name = 'U5_snRNA' OR cvterm.name = 'U6_snRNA' OR cvterm.name = 'U6atac_snRNA' OR cvterm.name = 'U11_snRNA' OR cvterm.name = 'U12_snRNA' OR cvterm.name = 'C_D_box_snoRNA' OR cvterm.name = 'H_ACA_box_snoRNA' OR cvterm.name = 'U14_snoRNA' OR cvterm.name = 'U3_snoRNA' OR cvterm.name = 'methylation_guide_snoRNA' OR cvterm.name = 'pseudouridylation_guide_snoRNA' OR cvterm.name = 'miRNA' OR cvterm.name = 'RNA_6S' OR cvterm.name = 'CsrB_RsmB_RNA' OR cvterm.name = 'DsrA_RNA' OR cvterm.name = 'OxyS_RNA' OR cvterm.name = 'RprA_RNA' OR cvterm.name = 'RRE_RNA' OR cvterm.name = 'spot_42_RNA' OR cvterm.name = 'tmRNA' OR cvterm.name = 'GcvB_RNA' OR cvterm.name = 'MicF_RNA' OR cvterm.name = 'ribozyme' OR cvterm.name = 'trans_spliced_mRNA' OR cvterm.name = 'monocistronic_primary_transcript' OR cvterm.name = 'monocistronic_mRNA' OR cvterm.name = 'edited_transcript_by_A_to_I_substitution' OR cvterm.name = 'edited_mRNA' OR cvterm.name = 'transcription_regulatory_region' OR cvterm.name = 'translation_regulatory_region' OR cvterm.name = 'recombination_regulatory_region' OR cvterm.name = 'replication_regulatory_region' OR cvterm.name = 'terminator' OR cvterm.name = 'TF_binding_site' OR cvterm.name = 'polyA_signal_sequence' OR cvterm.name = 'gene_group_regulatory_region' OR cvterm.name = 'transcriptional_cis_regulatory_region' OR cvterm.name = 'splicing_regulatory_region' OR cvterm.name = 'cis_regulatory_frameshift_element' OR cvterm.name = 'intronic_regulatory_region' OR cvterm.name = 'bacterial_terminator' OR cvterm.name = 'eukaryotic_terminator' OR cvterm.name = 'rho_dependent_bacterial_terminator' OR cvterm.name = 'rho_independent_bacterial_terminator' OR cvterm.name = 'terminator_of_type_2_RNApol_III_promoter' OR cvterm.name = 'operator' OR cvterm.name = 'bacterial_RNApol_promoter' OR cvterm.name = 'bacterial_terminator' OR cvterm.name = 'bacterial_RNApol_promoter_sigma_70' OR cvterm.name = 'bacterial_RNApol_promoter_sigma54' OR cvterm.name = 'rho_dependent_bacterial_terminator' OR cvterm.name = 'rho_independent_bacterial_terminator' OR cvterm.name = 'promoter' OR cvterm.name = 'insulator' OR cvterm.name = 'CRM' OR cvterm.name = 'promoter_targeting_sequence' OR cvterm.name = 'ISRE' OR cvterm.name = 'bidirectional_promoter' OR cvterm.name = 'RNA_polymerase_promoter' OR cvterm.name = 'RNApol_I_promoter' OR cvterm.name = 'RNApol_II_promoter' OR cvterm.name = 'RNApol_III_promoter' OR cvterm.name = 'bacterial_RNApol_promoter' OR cvterm.name = 'Phage_RNA_Polymerase_Promoter' OR cvterm.name = 'RNApol_II_core_promoter' OR cvterm.name = 'RNApol_III_promoter_type_1' OR cvterm.name = 'RNApol_III_promoter_type_2' OR cvterm.name = 'RNApol_III_promoter_type_3' OR cvterm.name = 'bacterial_RNApol_promoter_sigma_70' OR cvterm.name = 'bacterial_RNApol_promoter_sigma54' OR cvterm.name = 'SP6_RNA_Polymerase_Promoter' OR cvterm.name = 'T3_RNA_Polymerase_Promoter' OR cvterm.name = 'T7_RNA_Polymerase_Promoter' OR cvterm.name = 'locus_control_region' OR cvterm.name = 'enhancer' OR cvterm.name = 'silencer' OR cvterm.name = 'enhancer_bound_by_factor' OR cvterm.name = 'shadow_enhancer' OR cvterm.name = 'splice_enhancer' OR cvterm.name = 'intronic_splice_enhancer' OR cvterm.name = 'exonic_splice_enhancer' OR cvterm.name = 'attenuator' OR cvterm.name = 'exon' OR cvterm.name = 'edited_transcript_feature' OR cvterm.name = 'mature_transcript_region' OR cvterm.name = 'primary_transcript_region' OR cvterm.name = 'exon_region' OR cvterm.name = 'anchor_binding_site' OR cvterm.name = 'coding_exon' OR cvterm.name = 'noncoding_exon' OR cvterm.name = 'interior_exon' OR cvterm.name = 'exon_of_single_exon_gene' OR cvterm.name = 'interior_coding_exon' OR cvterm.name = 'five_prime_coding_exon' OR cvterm.name = 'three_prime_coding_exon' OR cvterm.name = 'three_prime_noncoding_exon' OR cvterm.name = 'five_prime_noncoding_exon' OR cvterm.name = 'pre_edited_region' OR cvterm.name = 'editing_block' OR cvterm.name = 'editing_domain' OR cvterm.name = 'unedited_region' OR cvterm.name = 'mRNA_region' OR cvterm.name = 'tmRNA_region' OR cvterm.name = 'guide_RNA_region' OR cvterm.name = 'tRNA_region' OR cvterm.name = 'riboswitch' OR cvterm.name = 'ribosome_entry_site' OR cvterm.name = 'UTR' OR cvterm.name = 'CDS' OR cvterm.name = 'five_prime_open_reading_frame' OR cvterm.name = 'UTR_region' OR cvterm.name = 'CDS_region' OR cvterm.name = 'translational_frameshift' OR cvterm.name = 'recoding_stimulatory_region' OR cvterm.name = 'internal_ribosome_entry_site' OR cvterm.name = 'Shine_Dalgarno_sequence' OR cvterm.name = 'kozak_sequence' OR cvterm.name = 'internal_Shine_Dalgarno_sequence' OR cvterm.name = 'five_prime_UTR' OR cvterm.name = 'three_prime_UTR' OR cvterm.name = 'internal_UTR' OR cvterm.name = 'untranslated_region_polycistronic_mRNA' OR cvterm.name = 'edited_CDS' OR cvterm.name = 'CDS_fragment' OR cvterm.name = 'CDS_independently_known' OR cvterm.name = 'CDS_predicted' OR cvterm.name = 'orphan_CDS' OR cvterm.name = 'CDS_supported_by_sequence_similarity_data' OR cvterm.name = 'CDS_supported_by_domain_match_data' OR cvterm.name = 'CDS_supported_by_EST_or_cDNA_data' OR cvterm.name = 'upstream_AUG_codon' OR cvterm.name = 'AU_rich_element' OR cvterm.name = 'Bruno_response_element' OR cvterm.name = 'iron_responsive_element' OR cvterm.name = 'coding_start' OR cvterm.name = 'coding_end' OR cvterm.name = 'codon' OR cvterm.name = 'recoded_codon' OR cvterm.name = 'start_codon' OR cvterm.name = 'stop_codon' OR cvterm.name = 'stop_codon_read_through' OR cvterm.name = 'stop_codon_redefined_as_pyrrolysine' OR cvterm.name = 'stop_codon_redefined_as_selenocysteine' OR cvterm.name = 'non_canonical_start_codon' OR cvterm.name = 'four_bp_start_codon' OR cvterm.name = 'CTG_start_codon' OR cvterm.name = 'plus_1_translational_frameshift' OR cvterm.name = 'plus_2_translational_frameshift' OR cvterm.name = 'internal_Shine_Dalgarno_sequence' OR cvterm.name = 'SECIS_element' OR cvterm.name = 'three_prime_recoding_site' OR cvterm.name = 'five_prime_recoding_site' OR cvterm.name = 'stop_codon_signal' OR cvterm.name = 'three_prime_stem_loop_structure' OR cvterm.name = 'flanking_three_prime_quadruplet_recoding_signal' OR cvterm.name = 'three_prime_repeat_recoding_signal' OR cvterm.name = 'distant_three_prime_recoding_signal' OR cvterm.name = 'UAG_stop_codon_signal' OR cvterm.name = 'UAA_stop_codon_signal' OR cvterm.name = 'UGA_stop_codon_signal' OR cvterm.name = 'tmRNA_coding_piece' OR cvterm.name = 'tmRNA_acceptor_piece' OR cvterm.name = 'anchor_region' OR cvterm.name = 'template_region' OR cvterm.name = 'anticodon_loop' OR cvterm.name = 'anticodon' OR cvterm.name = 'CCA_tail' OR cvterm.name = 'DHU_loop' OR cvterm.name = 'T_loop' OR cvterm.name = 'splice_site' OR cvterm.name = 'intron' OR cvterm.name = 'clip' OR cvterm.name = 'TSS' OR cvterm.name = 'transcription_end_site' OR cvterm.name = 'spliced_leader_RNA' OR cvterm.name = 'rRNA_primary_transcript_region' OR cvterm.name = 'spliceosomal_intron_region' OR cvterm.name = 'intron_domain' OR cvterm.name = 'miRNA_primary_transcript_region' OR cvterm.name = 'outron' OR cvterm.name = 'cis_splice_site' OR cvterm.name = 'trans_splice_site' OR cvterm.name = 'cryptic_splice_site' OR cvterm.name = 'five_prime_cis_splice_site' OR cvterm.name = 'three_prime_cis_splice_site' OR cvterm.name = 'recursive_splice_site' OR cvterm.name = 'canonical_five_prime_splice_site' OR cvterm.name = 'non_canonical_five_prime_splice_site' OR cvterm.name = 'canonical_three_prime_splice_site' OR cvterm.name = 'non_canonical_three_prime_splice_site' OR cvterm.name = 'trans_splice_acceptor_site' OR cvterm.name = 'trans_splice_donor_site' OR cvterm.name = 'SL1_acceptor_site' OR cvterm.name = 'SL2_acceptor_site' OR cvterm.name = 'SL3_acceptor_site' OR cvterm.name = 'SL4_acceptor_site' OR cvterm.name = 'SL5_acceptor_site' OR cvterm.name = 'SL6_acceptor_site' OR cvterm.name = 'SL7_acceptor_site' OR cvterm.name = 'SL8_acceptor_site' OR cvterm.name = 'SL9_acceptor_site' OR cvterm.name = 'SL10_accceptor_site' OR cvterm.name = 'SL11_acceptor_site' OR cvterm.name = 'SL12_acceptor_site' OR cvterm.name = 'five_prime_intron' OR cvterm.name = 'interior_intron' OR cvterm.name = 'three_prime_intron' OR cvterm.name = 'twintron' OR cvterm.name = 'UTR_intron' OR cvterm.name = 'autocatalytically_spliced_intron' OR cvterm.name = 'spliceosomal_intron' OR cvterm.name = 'mobile_intron' OR cvterm.name = 'endonuclease_spliced_intron' OR cvterm.name = 'five_prime_UTR_intron' OR cvterm.name = 'three_prime_UTR_intron' OR cvterm.name = 'group_I_intron' OR cvterm.name = 'group_II_intron' OR cvterm.name = 'group_III_intron' OR cvterm.name = 'group_IIA_intron' OR cvterm.name = 'group_IIB_intron' OR cvterm.name = 'U2_intron' OR cvterm.name = 'U12_intron' OR cvterm.name = 'archaeal_intron' OR cvterm.name = 'tRNA_intron' OR cvterm.name = 'five_prime_clip' OR cvterm.name = 'three_prime_clip' OR cvterm.name = 'major_TSS' OR cvterm.name = 'minor_TSS' OR cvterm.name = 'transcribed_spacer_region' OR cvterm.name = 'internal_transcribed_spacer_region' OR cvterm.name = 'external_transcribed_spacer_region' OR cvterm.name = 'intronic_splice_enhancer' OR cvterm.name = 'branch_site' OR cvterm.name = 'polypyrimidine_tract' OR cvterm.name = 'internal_guide_sequence' OR cvterm.name = 'mirtron' OR cvterm.name = 'pre_miRNA' OR cvterm.name = 'miRNA_stem' OR cvterm.name = 'miRNA_loop' OR cvterm.name = 'miRNA_antiguide' OR cvterm.name = 'noncoding_region_of_exon' OR cvterm.name = 'coding_region_of_exon' OR cvterm.name = 'three_prime_coding_exon_noncoding_region' OR cvterm.name = 'five_prime_coding_exon_noncoding_region' OR cvterm.name = 'five_prime_coding_exon_coding_region' OR cvterm.name = 'three_prime_coding_exon_coding_region' OR cvterm.name = 'mature_protein_region' OR cvterm.name = 'immature_peptide_region' OR cvterm.name = 'compositionally_biased_region_of_peptide' OR cvterm.name = 'polypeptide_structural_region' OR cvterm.name = 'polypeptide_variation_site' OR cvterm.name = 'peptide_localization_signal' OR cvterm.name = 'cleaved_peptide_region' OR cvterm.name = 'hydrophobic_region_of_peptide' OR cvterm.name = 'polypeptide_conserved_region' OR cvterm.name = 'active_peptide' OR cvterm.name = 'polypeptide_domain' OR cvterm.name = 'membrane_structure' OR cvterm.name = 'extramembrane_polypeptide_region' OR cvterm.name = 'intramembrane_polypeptide_region' OR cvterm.name = 'polypeptide_secondary_structure' OR cvterm.name = 'polypeptide_structural_motif' OR cvterm.name = 'intrinsically_unstructured_polypeptide_region' OR cvterm.name = 'cytoplasmic_polypeptide_region' OR cvterm.name = 'non_cytoplasmic_polypeptide_region' OR cvterm.name = 'membrane_peptide_loop' OR cvterm.name = 'transmembrane_polypeptide_region' OR cvterm.name = 'asx_motif' OR cvterm.name = 'beta_bulge' OR cvterm.name = 'beta_bulge_loop' OR cvterm.name = 'beta_strand' OR cvterm.name = 'peptide_helix' OR cvterm.name = 'polypeptide_nest_motif' OR cvterm.name = 'schellmann_loop' OR cvterm.name = 'serine_threonine_motif' OR cvterm.name = 'serine_threonine_staple_motif' OR cvterm.name = 'polypeptide_turn_motif' OR cvterm.name = 'catmat_left_handed_three' OR cvterm.name = 'catmat_left_handed_four' OR cvterm.name = 'catmat_right_handed_three' OR cvterm.name = 'catmat_right_handed_four' OR cvterm.name = 'alpha_beta_motif' OR cvterm.name = 'peptide_coil' OR cvterm.name = 'beta_bulge_loop_five' OR cvterm.name = 'beta_bulge_loop_six' OR cvterm.name = 'antiparallel_beta_strand' OR cvterm.name = 'parallel_beta_strand' OR cvterm.name = 'left_handed_peptide_helix' OR cvterm.name = 'right_handed_peptide_helix' OR cvterm.name = 'alpha_helix' OR cvterm.name = 'pi_helix' OR cvterm.name = 'three_ten_helix' OR cvterm.name = 'polypeptide_nest_left_right_motif' OR cvterm.name = 'polypeptide_nest_right_left_motif' OR cvterm.name = 'schellmann_loop_seven' OR cvterm.name = 'schellmann_loop_six' OR cvterm.name = 'asx_turn' OR cvterm.name = 'beta_turn' OR cvterm.name = 'gamma_turn' OR cvterm.name = 'serine_threonine_turn' OR cvterm.name = 'asx_turn_left_handed_type_one' OR cvterm.name = 'asx_turn_left_handed_type_two' OR cvterm.name = 'asx_turn_right_handed_type_two' OR cvterm.name = 'asx_turn_right_handed_type_one' OR cvterm.name = 'beta_turn_left_handed_type_one' OR cvterm.name = 'beta_turn_left_handed_type_two' OR cvterm.name = 'beta_turn_right_handed_type_one' OR cvterm.name = 'beta_turn_right_handed_type_two' OR cvterm.name = 'beta_turn_type_six' OR cvterm.name = 'beta_turn_type_eight' OR cvterm.name = 'beta_turn_type_six_a' OR cvterm.name = 'beta_turn_type_six_b' OR cvterm.name = 'beta_turn_type_six_a_one' OR cvterm.name = 'beta_turn_type_six_a_two' OR cvterm.name = 'gamma_turn_classic' OR cvterm.name = 'gamma_turn_inverse' OR cvterm.name = 'st_turn_left_handed_type_one' OR cvterm.name = 'st_turn_left_handed_type_two' OR cvterm.name = 'st_turn_right_handed_type_one' OR cvterm.name = 'st_turn_right_handed_type_two' OR cvterm.name = 'coiled_coil' OR cvterm.name = 'helix_turn_helix' OR cvterm.name = 'natural_variant_site' OR cvterm.name = 'mutated_variant_site' OR cvterm.name = 'alternate_sequence_site' OR cvterm.name = 'signal_peptide' OR cvterm.name = 'transit_peptide' OR cvterm.name = 'nuclear_localization_signal' OR cvterm.name = 'endosomal_localization_signal' OR cvterm.name = 'lysosomal_localization_signal' OR cvterm.name = 'nuclear_export_signal' OR cvterm.name = 'nuclear_rim_localization_signal' OR cvterm.name = 'cleaved_initiator_methionine' OR cvterm.name = 'intein' OR cvterm.name = 'propeptide_cleavage_site' OR cvterm.name = 'propeptide' OR cvterm.name = 'cleaved_for_gpi_anchor_region' OR cvterm.name = 'lipoprotein_signal_peptide' OR cvterm.name = 'n_terminal_region' OR cvterm.name = 'c_terminal_region' OR cvterm.name = 'central_hydrophobic_region_of_signal_peptide' OR cvterm.name = 'polypeptide_domain' OR cvterm.name = 'polypeptide_motif' OR cvterm.name = 'polypeptide_repeat' OR cvterm.name = 'biochemical_region_of_peptide' OR cvterm.name = 'polypeptide_conserved_motif' OR cvterm.name = 'post_translationally_modified_region' OR cvterm.name = 'conformational_switch' OR cvterm.name = 'molecular_contact_region' OR cvterm.name = 'polypeptide_binding_motif' OR cvterm.name = 'polypeptide_catalytic_motif' OR cvterm.name = 'histone_modification' OR cvterm.name = 'histone_methylation_site' OR cvterm.name = 'histone_acetylation_site' OR cvterm.name = 'histone_ubiqitination_site' OR cvterm.name = 'histone_acylation_region' OR cvterm.name = 'H4K20_monomethylation_site' OR cvterm.name = 'H2BK5_monomethylation_site' OR cvterm.name = 'H3K27_methylation_site' OR cvterm.name = 'H3K36_methylation_site' OR cvterm.name = 'H3K4_methylation_site' OR cvterm.name = 'H3K79_methylation_site' OR cvterm.name = 'H3K9_methylation_site' OR cvterm.name = 'H3K27_monomethylation_site' OR cvterm.name = 'H3K27_trimethylation_site' OR cvterm.name = 'H3K27_dimethylation_site' OR cvterm.name = 'H3K36_monomethylation_site' OR cvterm.name = 'H3K36_dimethylation_site' OR cvterm.name = 'H3K36_trimethylation_site' OR cvterm.name = 'H3K4_monomethylation_site' OR cvterm.name = 'H3K4_trimethylation' OR cvterm.name = 'H3K4_dimethylation_site' OR cvterm.name = 'H3K79_monomethylation_site' OR cvterm.name = 'H3K79_dimethylation_site' OR cvterm.name = 'H3K79_trimethylation_site' OR cvterm.name = 'H3K9_trimethylation_site' OR cvterm.name = 'H3K9_monomethylation_site' OR cvterm.name = 'H3K9_dimethylation_site' OR cvterm.name = 'H3K9_acetylation_site' OR cvterm.name = 'H3K14_acetylation_site' OR cvterm.name = 'H3K18_acetylation_site' OR cvterm.name = 'H3K23_acylation site' OR cvterm.name = 'H3K27_acylation_site' OR cvterm.name = 'H4K16_acylation_site' OR cvterm.name = 'H4K5_acylation_site' OR cvterm.name = 'H4K8_acylation site' OR cvterm.name = 'H2B_ubiquitination_site' OR cvterm.name = 'H4K_acylation_region' OR cvterm.name = 'polypeptide_metal_contact' OR cvterm.name = 'protein_protein_contact' OR cvterm.name = 'polypeptide_ligand_contact' OR cvterm.name = 'polypeptide_DNA_contact' OR cvterm.name = 'polypeptide_calcium_ion_contact_site' OR cvterm.name = 'polypeptide_cobalt_ion_contact_site' OR cvterm.name = 'polypeptide_copper_ion_contact_site' OR cvterm.name = 'polypeptide_iron_ion_contact_site' OR cvterm.name = 'polypeptide_magnesium_ion_contact_site' OR cvterm.name = 'polypeptide_manganese_ion_contact_site' OR cvterm.name = 'polypeptide_molybdenum_ion_contact_site' OR cvterm.name = 'polypeptide_nickel_ion_contact_site' OR cvterm.name = 'polypeptide_tungsten_ion_contact_site' OR cvterm.name = 'polypeptide_zinc_ion_contact_site' OR cvterm.name = 'non_transcribed_region' OR cvterm.name = 'gene_fragment' OR cvterm.name = 'TSS_region' OR cvterm.name = 'gene_segment' OR cvterm.name = 'pseudogenic_gene_segment' OR cvterm.name = 'mobile_intron' OR cvterm.name = 'extrachromosomal_mobile_genetic_element' OR cvterm.name = 'integrated_mobile_genetic_element' OR cvterm.name = 'natural_transposable_element' OR cvterm.name = 'viral_sequence' OR cvterm.name = 'natural_plasmid' OR cvterm.name = 'phage_sequence' OR cvterm.name = 'ds_RNA_viral_sequence' OR cvterm.name = 'ds_DNA_viral_sequence' OR cvterm.name = 'ss_RNA_viral_sequence' OR cvterm.name = 'negative_sense_ssRNA_viral_sequence' OR cvterm.name = 'positive_sense_ssRNA_viral_sequence' OR cvterm.name = 'ambisense_ssRNA_viral_sequence' OR cvterm.name = 'transposable_element' OR cvterm.name = 'proviral_region' OR cvterm.name = 'integron' OR cvterm.name = 'genomic_island' OR cvterm.name = 'integrated_plasmid' OR cvterm.name = 'cointegrated_plasmid' OR cvterm.name = 'retrotransposon' OR cvterm.name = 'DNA_transposon' OR cvterm.name = 'foreign_transposable_element' OR cvterm.name = 'transgenic_transposable_element' OR cvterm.name = 'natural_transposable_element' OR cvterm.name = 'engineered_transposable_element' OR cvterm.name = 'nested_transposon' OR cvterm.name = 'LTR_retrotransposon' OR cvterm.name = 'non_LTR_retrotransposon' OR cvterm.name = 'LINE_element' OR cvterm.name = 'SINE_element' OR cvterm.name = 'terminal_inverted_repeat_element' OR cvterm.name = 'foldback_element' OR cvterm.name = 'conjugative_transposon' OR cvterm.name = 'helitron' OR cvterm.name = 'p_element' OR cvterm.name = 'MITE' OR cvterm.name = 'insertion_sequence' OR cvterm.name = 'polinton' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'prophage' OR cvterm.name = 'pathogenic_island' OR cvterm.name = 'metabolic_island' OR cvterm.name = 'adaptive_island' OR cvterm.name = 'symbiosis_island' OR cvterm.name = 'cryptic_prophage' OR cvterm.name = 'defective_conjugative_transposon' OR cvterm.name = 'plasmid' OR cvterm.name = 'chromosome' OR cvterm.name = 'vector_replicon' OR cvterm.name = 'maxicircle' OR cvterm.name = 'minicircle' OR cvterm.name = 'viral_sequence' OR cvterm.name = 'engineered_plasmid' OR cvterm.name = 'episome' OR cvterm.name = 'natural_plasmid' OR cvterm.name = 'engineered_episome' OR cvterm.name = 'gene_trap_construct' OR cvterm.name = 'promoter_trap_construct' OR cvterm.name = 'enhancer_trap_construct' OR cvterm.name = 'engineered_episome' OR cvterm.name = 'mitochondrial_chromosome' OR cvterm.name = 'chloroplast_chromosome' OR cvterm.name = 'chromoplast_chromosome' OR cvterm.name = 'cyanelle_chromosome' OR cvterm.name = 'leucoplast_chromosome' OR cvterm.name = 'macronuclear_chromosome' OR cvterm.name = 'micronuclear_chromosome' OR cvterm.name = 'nuclear_chromosome' OR cvterm.name = 'nucleomorphic_chromosome' OR cvterm.name = 'DNA_chromosome' OR cvterm.name = 'RNA_chromosome' OR cvterm.name = 'apicoplast_chromosome' OR cvterm.name = 'double_stranded_DNA_chromosome' OR cvterm.name = 'single_stranded_DNA_chromosome' OR cvterm.name = 'linear_double_stranded_DNA_chromosome' OR cvterm.name = 'circular_double_stranded_DNA_chromosome' OR cvterm.name = 'linear_single_stranded_DNA_chromosome' OR cvterm.name = 'circular_single_stranded_DNA_chromosome' OR cvterm.name = 'single_stranded_RNA_chromosome' OR cvterm.name = 'double_stranded_RNA_chromosome' OR cvterm.name = 'linear_single_stranded_RNA_chromosome' OR cvterm.name = 'circular_single_stranded_RNA_chromosome' OR cvterm.name = 'linear_double_stranded_RNA_chromosome' OR cvterm.name = 'circular_double_stranded_RNA_chromosome' OR cvterm.name = 'YAC' OR cvterm.name = 'BAC' OR cvterm.name = 'PAC' OR cvterm.name = 'cosmid' OR cvterm.name = 'phagemid' OR cvterm.name = 'fosmid' OR cvterm.name = 'lambda_vector' OR cvterm.name = 'plasmid_vector' OR cvterm.name = 'targeting_vector' OR cvterm.name = 'phage_sequence' OR cvterm.name = 'ds_RNA_viral_sequence' OR cvterm.name = 'ds_DNA_viral_sequence' OR cvterm.name = 'ss_RNA_viral_sequence' OR cvterm.name = 'negative_sense_ssRNA_viral_sequence' OR cvterm.name = 'positive_sense_ssRNA_viral_sequence' OR cvterm.name = 'ambisense_ssRNA_viral_sequence' OR cvterm.name = 'modified_RNA_base_feature' OR cvterm.name = 'inosine' OR cvterm.name = 'seven_methylguanine' OR cvterm.name = 'ribothymidine' OR cvterm.name = 'modified_adenosine' OR cvterm.name = 'modified_cytidine' OR cvterm.name = 'modified_guanosine' OR cvterm.name = 'modified_uridine' OR cvterm.name = 'modified_inosine' OR cvterm.name = 'methylinosine' OR cvterm.name = 'one_methylinosine' OR cvterm.name = 'one_two_prime_O_dimethylinosine' OR cvterm.name = 'two_prime_O_methylinosine' OR cvterm.name = 'one_methyladenosine' OR cvterm.name = 'two_methyladenosine' OR cvterm.name = 'N6_methyladenosine' OR cvterm.name = 'two_prime_O_methyladenosine' OR cvterm.name = 'two_methylthio_N6_methyladenosine' OR cvterm.name = 'N6_isopentenyladenosine' OR cvterm.name = 'two_methylthio_N6_isopentenyladenosine' OR cvterm.name = 'N6_cis_hydroxyisopentenyl_adenosine' OR cvterm.name = 'two_methylthio_N6_cis_hydroxyisopentenyl_adenosine' OR cvterm.name = 'N6_glycinylcarbamoyladenosine' OR cvterm.name = 'N6_threonylcarbamoyladenosine' OR cvterm.name = 'two_methylthio_N6_threonyl_carbamoyladenosine' OR cvterm.name = 'N6_methyl_N6_threonylcarbamoyladenosine' OR cvterm.name = 'N6_hydroxynorvalylcarbamoyladenosine' OR cvterm.name = 'two_methylthio_N6_hydroxynorvalyl_carbamoyladenosine' OR cvterm.name = 'two_prime_O_ribosyladenosine_phosphate' OR cvterm.name = 'N6_N6_dimethyladenosine' OR cvterm.name = 'N6_2_prime_O_dimethyladenosine' OR cvterm.name = 'N6_N6_2_prime_O_trimethyladenosine' OR cvterm.name = 'one_two_prime_O_dimethyladenosine' OR cvterm.name = 'N6_acetyladenosine' OR cvterm.name = 'three_methylcytidine' OR cvterm.name = 'five_methylcytidine' OR cvterm.name = 'two_prime_O_methylcytidine' OR cvterm.name = 'two_thiocytidine' OR cvterm.name = 'N4_acetylcytidine' OR cvterm.name = 'five_formylcytidine' OR cvterm.name = 'five_two_prime_O_dimethylcytidine' OR cvterm.name = 'N4_acetyl_2_prime_O_methylcytidine' OR cvterm.name = 'lysidine' OR cvterm.name = 'N4_methylcytidine' OR cvterm.name = 'N4_2_prime_O_dimethylcytidine' OR cvterm.name = 'five_hydroxymethylcytidine' OR cvterm.name = 'five_formyl_two_prime_O_methylcytidine' OR cvterm.name = 'N4_N4_2_prime_O_trimethylcytidine' OR cvterm.name = 'seven_deazaguanosine' OR cvterm.name = 'one_methylguanosine' OR cvterm.name = 'N2_methylguanosine' OR cvterm.name = 'seven_methylguanosine' OR cvterm.name = 'two_prime_O_methylguanosine' OR cvterm.name = 'N2_N2_dimethylguanosine' OR cvterm.name = 'N2_2_prime_O_dimethylguanosine' OR cvterm.name = 'N2_N2_2_prime_O_trimethylguanosine' OR cvterm.name = 'two_prime_O_ribosylguanosine_phosphate' OR cvterm.name = 'wybutosine' OR cvterm.name = 'peroxywybutosine' OR cvterm.name = 'hydroxywybutosine' OR cvterm.name = 'undermodified_hydroxywybutosine' OR cvterm.name = 'wyosine' OR cvterm.name = 'methylwyosine' OR cvterm.name = 'N2_7_dimethylguanosine' OR cvterm.name = 'N2_N2_7_trimethylguanosine' OR cvterm.name = 'one_two_prime_O_dimethylguanosine' OR cvterm.name = 'four_demethylwyosine' OR cvterm.name = 'isowyosine' OR cvterm.name = 'N2_7_2prirme_O_trimethylguanosine' OR cvterm.name = 'queuosine' OR cvterm.name = 'epoxyqueuosine' OR cvterm.name = 'galactosyl_queuosine' OR cvterm.name = 'mannosyl_queuosine' OR cvterm.name = 'seven_cyano_seven_deazaguanosine' OR cvterm.name = 'seven_aminomethyl_seven_deazaguanosine' OR cvterm.name = 'archaeosine' OR cvterm.name = 'dihydrouridine' OR cvterm.name = 'pseudouridine' OR cvterm.name = 'five_methyluridine' OR cvterm.name = 'two_prime_O_methyluridine' OR cvterm.name = 'five_two_prime_O_dimethyluridine' OR cvterm.name = 'one_methylpseudouridine' OR cvterm.name = 'two_prime_O_methylpseudouridine' OR cvterm.name = 'two_thiouridine' OR cvterm.name = 'four_thiouridine' OR cvterm.name = 'five_methyl_2_thiouridine' OR cvterm.name = 'two_thio_two_prime_O_methyluridine' OR cvterm.name = 'three_three_amino_three_carboxypropyl_uridine' OR cvterm.name = 'five_hydroxyuridine' OR cvterm.name = 'five_methoxyuridine' OR cvterm.name = 'uridine_five_oxyacetic_acid' OR cvterm.name = 'uridine_five_oxyacetic_acid_methyl_ester' OR cvterm.name = 'five_carboxyhydroxymethyl_uridine' OR cvterm.name = 'five_carboxyhydroxymethyl_uridine_methyl_ester' OR cvterm.name = 'five_methoxycarbonylmethyluridine' OR cvterm.name = 'five_methoxycarbonylmethyl_two_prime_O_methyluridine' OR cvterm.name = 'five_methoxycarbonylmethyl_two_thiouridine' OR cvterm.name = 'five_aminomethyl_two_thiouridine' OR cvterm.name = 'five_methylaminomethyluridine' OR cvterm.name = 'five_methylaminomethyl_two_thiouridine' OR cvterm.name = 'five_methylaminomethyl_two_selenouridine' OR cvterm.name = 'five_carbamoylmethyluridine' OR cvterm.name = 'five_carbamoylmethyl_two_prime_O_methyluridine' OR cvterm.name = 'five_carboxymethylaminomethyluridine' OR cvterm.name = 'five_carboxymethylaminomethyl_two_prime_O_methyluridine' OR cvterm.name = 'five_carboxymethylaminomethyl_two_thiouridine' OR cvterm.name = 'three_methyluridine' OR cvterm.name = 'one_methyl_three_three_amino_three_carboxypropyl_pseudouridine' OR cvterm.name = 'five_carboxymethyluridine' OR cvterm.name = 'three_two_prime_O_dimethyluridine' OR cvterm.name = 'five_methyldihydrouridine' OR cvterm.name = 'three_methylpseudouridine' OR cvterm.name = 'five_taurinomethyluridine' OR cvterm.name = 'five_taurinomethyl_two_thiouridine' OR cvterm.name = 'five_isopentenylaminomethyl_uridine' OR cvterm.name = 'five_isopentenylaminomethyl_two_thiouridine' OR cvterm.name = 'five_isopentenylaminomethyl_two_prime_O_methyluridine' OR cvterm.name = 'catalytic_residue' OR cvterm.name = 'modified_amino_acid_feature' OR cvterm.name = 'alanine' OR cvterm.name = 'valine' OR cvterm.name = 'leucine' OR cvterm.name = 'isoleucine' OR cvterm.name = 'proline' OR cvterm.name = 'tryptophan' OR cvterm.name = 'phenylalanine' OR cvterm.name = 'methionine' OR cvterm.name = 'glycine' OR cvterm.name = 'serine' OR cvterm.name = 'threonine' OR cvterm.name = 'tyrosine' OR cvterm.name = 'cysteine' OR cvterm.name = 'glutamine' OR cvterm.name = 'asparagine' OR cvterm.name = 'lysine' OR cvterm.name = 'arginine' OR cvterm.name = 'histidine' OR cvterm.name = 'aspartic_acid' OR cvterm.name = 'glutamic_acid' OR cvterm.name = 'selenocysteine' OR cvterm.name = 'pyrrolysine' OR cvterm.name = 'modified_glycine' OR cvterm.name = 'modified_L_alanine' OR cvterm.name = 'modified_L_asparagine' OR cvterm.name = 'modified_L_aspartic_acid' OR cvterm.name = 'modified_L_cysteine' OR cvterm.name = 'modified_L_glutamic_acid' OR cvterm.name = 'modified_L_threonine' OR cvterm.name = 'modified_L_tryptophan' OR cvterm.name = 'modified_L_glutamine' OR cvterm.name = 'modified_L_methionine' OR cvterm.name = 'modified_L_isoleucine' OR cvterm.name = 'modified_L_phenylalanine' OR cvterm.name = 'modified_L_histidine' OR cvterm.name = 'modified_L_serine' OR cvterm.name = 'modified_L_lysine' OR cvterm.name = 'modified_L_leucine' OR cvterm.name = 'modified_L_selenocysteine' OR cvterm.name = 'modified_L_valine' OR cvterm.name = 'modified_L_proline' OR cvterm.name = 'modified_L_tyrosine' OR cvterm.name = 'modified_L_arginine' OR cvterm.name = 'heritable_phenotypic_marker' OR cvterm.name = 'DArT_marker' OR cvterm.name = 'nucleotide_motif' OR cvterm.name = 'DNA_motif' OR cvterm.name = 'RNA_motif' OR cvterm.name = 'PSE_motif' OR cvterm.name = 'CAAT_signal' OR cvterm.name = 'minus_10_signal' OR cvterm.name = 'minus_35_signal' OR cvterm.name = 'DRE_motif' OR cvterm.name = 'E_box_motif' OR cvterm.name = 'INR1_motif' OR cvterm.name = 'GAGA_motif' OR cvterm.name = 'octamer_motif' OR cvterm.name = 'retinoic_acid_responsive_element' OR cvterm.name = 'promoter_element' OR cvterm.name = 'DCE_SI' OR cvterm.name = 'DCE_SII' OR cvterm.name = 'DCE_SIII' OR cvterm.name = 'minus_12_signal' OR cvterm.name = 'minus_24_signal' OR cvterm.name = 'GC_rich_promoter_region' OR cvterm.name = 'DMv4_motif' OR cvterm.name = 'DMv5_motif' OR cvterm.name = 'DMv3_motif' OR cvterm.name = 'DMv2_motif' OR cvterm.name = 'DPE1_motif' OR cvterm.name = 'DMv1_motif' OR cvterm.name = 'NDM2_motif' OR cvterm.name = 'NDM3_motif' OR cvterm.name = 'core_promoter_element' OR cvterm.name = 'regulatory_promoter_element' OR cvterm.name = 'INR_motif' OR cvterm.name = 'DPE_motif' OR cvterm.name = 'BREu_motif' OR cvterm.name = 'TATA_box' OR cvterm.name = 'A_box' OR cvterm.name = 'B_box' OR cvterm.name = 'C_box' OR cvterm.name = 'MTE' OR cvterm.name = 'BREd_motif' OR cvterm.name = 'DCE' OR cvterm.name = 'intermediate_element' OR cvterm.name = 'RNA_polymerase_II_TATA_box' OR cvterm.name = 'RNA_polymerase_III_TATA_box' OR cvterm.name = 'A_box_type_1' OR cvterm.name = 'A_box_type_2' OR cvterm.name = 'proximal_promoter_element' OR cvterm.name = 'distal_promoter_element' OR cvterm.name = 'RNA_internal_loop' OR cvterm.name = 'A_minor_RNA_motif' OR cvterm.name = 'RNA_junction_loop' OR cvterm.name = 'hammerhead_ribozyme' OR cvterm.name = 'asymmetric_RNA_internal_loop' OR cvterm.name = 'symmetric_RNA_internal_loop' OR cvterm.name = 'K_turn_RNA_motif' OR cvterm.name = 'sarcin_like_RNA_motif' OR cvterm.name = 'RNA_hook_turn' OR cvterm.name = 'blunt_end_restriction_enzyme_cleavage_site' OR cvterm.name = 'sticky_end_restriction_enzyme_cleavage_site' OR cvterm.name = 'modified_base' OR cvterm.name = 'epigenetically_modified_gene' OR cvterm.name = 'histone_modification' OR cvterm.name = 'methylated_base_feature' OR cvterm.name = 'methylated_C' OR cvterm.name = 'methylated_A' OR cvterm.name = 'gene_rearranged_at_DNA_level' OR cvterm.name = 'maternally_imprinted_gene' OR cvterm.name = 'paternally_imprinted_gene' OR cvterm.name = 'allelically_excluded_gene' OR cvterm.name = 'histone_methylation_site' OR cvterm.name = 'histone_acetylation_site' OR cvterm.name = 'histone_ubiqitination_site' OR cvterm.name = 'histone_acylation_region' OR cvterm.name = 'H4K20_monomethylation_site' OR cvterm.name = 'H2BK5_monomethylation_site' OR cvterm.name = 'H3K27_methylation_site' OR cvterm.name = 'H3K36_methylation_site' OR cvterm.name = 'H3K4_methylation_site' OR cvterm.name = 'H3K79_methylation_site' OR cvterm.name = 'H3K9_methylation_site' OR cvterm.name = 'H3K27_monomethylation_site' OR cvterm.name = 'H3K27_trimethylation_site' OR cvterm.name = 'H3K27_dimethylation_site' OR cvterm.name = 'H3K36_monomethylation_site' OR cvterm.name = 'H3K36_dimethylation_site' OR cvterm.name = 'H3K36_trimethylation_site' OR cvterm.name = 'H3K4_monomethylation_site' OR cvterm.name = 'H3K4_trimethylation' OR cvterm.name = 'H3K4_dimethylation_site' OR cvterm.name = 'H3K79_monomethylation_site' OR cvterm.name = 'H3K79_dimethylation_site' OR cvterm.name = 'H3K79_trimethylation_site' OR cvterm.name = 'H3K9_trimethylation_site' OR cvterm.name = 'H3K9_monomethylation_site' OR cvterm.name = 'H3K9_dimethylation_site' OR cvterm.name = 'H3K9_acetylation_site' OR cvterm.name = 'H3K14_acetylation_site' OR cvterm.name = 'H3K18_acetylation_site' OR cvterm.name = 'H3K23_acylation site' OR cvterm.name = 'H3K27_acylation_site' OR cvterm.name = 'H4K16_acylation_site' OR cvterm.name = 'H4K5_acylation_site' OR cvterm.name = 'H4K8_acylation site' OR cvterm.name = 'H2B_ubiquitination_site' OR cvterm.name = 'H4K_acylation_region' OR cvterm.name = 'operon' OR cvterm.name = 'mating_type_region' OR cvterm.name = 'gene_array' OR cvterm.name = 'gene_subarray' OR cvterm.name = 'gene_cassette_array' OR cvterm.name = 'regulon' OR cvterm.name = 'sequence_length_variation' OR cvterm.name = 'MNP' OR cvterm.name = 'SNV' OR cvterm.name = 'complex_substitution' OR cvterm.name = 'simple_sequence_length_variation' OR cvterm.name = 'SNP' OR cvterm.name = 'point_mutation' OR cvterm.name = 'transition' OR cvterm.name = 'transversion' OR cvterm.name = 'pyrimidine_transition' OR cvterm.name = 'purine_transition' OR cvterm.name = 'C_to_T_transition' OR cvterm.name = 'T_to_C_transition' OR cvterm.name = 'C_to_T_transition_at_pCpG_site' OR cvterm.name = 'A_to_G_transition' OR cvterm.name = 'G_to_A_transition' OR cvterm.name = 'pyrimidine_to_purine_transversion' OR cvterm.name = 'purine_to_pyrimidine_transversion' OR cvterm.name = 'C_to_A_transversion' OR cvterm.name = 'C_to_G_transversion' OR cvterm.name = 'T_to_A_transversion' OR cvterm.name = 'T_to_G_transversion' OR cvterm.name = 'A_to_C_transversion' OR cvterm.name = 'A_to_T_transversion' OR cvterm.name = 'G_to_C_transversion' OR cvterm.name = 'G_to_T_transversion' OR cvterm.name = 'flanking_region' OR cvterm.name = 'repeat_component' OR cvterm.name = 'transposable_element_flanking_region' OR cvterm.name = 'five_prime_flanking_region' OR cvterm.name = 'three_prime_flanking_region' OR cvterm.name = 'non_LTR_retrotransposon_polymeric_tract' OR cvterm.name = 'LTR_component' OR cvterm.name = 'repeat_fragment' OR cvterm.name = 'transposon_fragment' OR cvterm.name = 'U5_LTR_region' OR cvterm.name = 'R_LTR_region' OR cvterm.name = 'U3_LTR_region' OR cvterm.name = 'three_prime_LTR_component' OR cvterm.name = 'five_prime_LTR_component' OR cvterm.name = 'U5_five_prime_LTR_region' OR cvterm.name = 'R_five_prime_LTR_region' OR cvterm.name = 'U3_five_prime_LTR_region' OR cvterm.name = 'R_three_prime_LTR_region' OR cvterm.name = 'U3_three_prime_LTR_region' OR cvterm.name = 'U5_three_prime_LTR_region' OR cvterm.name = 'R_five_prime_LTR_region' OR cvterm.name = 'U5_five_prime_LTR_region' OR cvterm.name = 'U3_five_prime_LTR_region' OR cvterm.name = 'region';

--- ************************************************
--- *** relation: sequence_secondary_structure ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A folded sequence.                       ***
--- ************************************************
---

CREATE VIEW sequence_secondary_structure AS
  SELECT
    feature_id AS sequence_secondary_structure_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'G_quartet' OR cvterm.name = 'base_pair' OR cvterm.name = 'RNA_sequence_secondary_structure' OR cvterm.name = 'DNA_sequence_secondary_structure' OR cvterm.name = 'pseudoknot' OR cvterm.name = 'WC_base_pair' OR cvterm.name = 'sugar_edge_base_pair' OR cvterm.name = 'Hoogsteen_base_pair' OR cvterm.name = 'reverse_Hoogsteen_base_pair' OR cvterm.name = 'wobble_base_pair' OR cvterm.name = 'stem_loop' OR cvterm.name = 'tetraloop' OR cvterm.name = 'i_motif' OR cvterm.name = 'recoding_pseudoknot' OR cvterm.name = 'H_pseudoknot' OR cvterm.name = 'sequence_secondary_structure';

--- ************************************************
--- *** relation: g_quartet ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** G-quartets are unusual nucleic acid stru ***
--- *** ctures consisting of a planar arrangemen ***
--- *** t where each guanine is hydrogen bonded  ***
--- *** by hoogsteen pairing to another guanine  ***
--- *** in the quartet.                          ***
--- ************************************************
---

CREATE VIEW g_quartet AS
  SELECT
    feature_id AS g_quartet_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'G_quartet';

--- ************************************************
--- *** relation: interior_coding_exon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW interior_coding_exon AS
  SELECT
    feature_id AS interior_coding_exon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'interior_coding_exon';

--- ************************************************
--- *** relation: satellite_dna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The many tandem repeats (identical or re ***
--- *** lated) of a short basic repeating unit;  ***
--- *** many have a base composition or other pr ***
--- *** operty different from the genome average ***
--- ***  that allows them to be separated from t ***
--- *** he bulk (main band) genomic DNA.         ***
--- ************************************************
---

CREATE VIEW satellite_dna AS
  SELECT
    feature_id AS satellite_dna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'microsatellite' OR cvterm.name = 'minisatellite' OR cvterm.name = 'dinucleotide_repeat_microsatellite_feature' OR cvterm.name = 'trinucleotide_repeat_microsatellite_feature' OR cvterm.name = 'tetranucleotide_repeat_microsatellite_feature' OR cvterm.name = 'satellite_DNA';

--- ************************************************
--- *** relation: pcr_product ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region amplified by a PCR reaction.    ***
--- ************************************************
---

CREATE VIEW pcr_product AS
  SELECT
    feature_id AS pcr_product_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RAPD' OR cvterm.name = 'PCR_product';

--- ************************************************
--- *** relation: read_pair ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** One of a pair of sequencing reads in whi ***
--- *** ch the two members of the pair are relat ***
--- *** ed by originating at either end of a clo ***
--- *** ne insert.                               ***
--- ************************************************
---

CREATE VIEW read_pair AS
  SELECT
    feature_id AS read_pair_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'read_pair';

--- ************************************************
--- *** relation: protein_coding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW protein_coding AS
  SELECT
    feature_id AS protein_coding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'intein_containing' OR cvterm.name = 'protein_coding';

--- ************************************************
--- *** relation: non_protein_coding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW non_protein_coding AS
  SELECT
    feature_id AS non_protein_coding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'miRNA_encoding' OR cvterm.name = 'rRNA_encoding' OR cvterm.name = 'scRNA_encoding' OR cvterm.name = 'snoRNA_encoding' OR cvterm.name = 'snRNA_encoding' OR cvterm.name = 'SRP_RNA_encoding' OR cvterm.name = 'stRNA_encoding' OR cvterm.name = 'tmRNA_encoding' OR cvterm.name = 'tRNA_encoding' OR cvterm.name = 'gRNA_encoding' OR cvterm.name = 'C_D_box_snoRNA_encoding' OR cvterm.name = 'H_ACA_box_snoRNA_encoding' OR cvterm.name = 'non_protein_coding';

--- ************************************************
--- *** relation: scrna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The primary transcript of any one of sev ***
--- *** eral small cytoplasmic RNA molecules pre ***
--- *** sent in the cytoplasm and sometimes nucl ***
--- *** eus of a eukaryote.                      ***
--- ************************************************
---

CREATE VIEW scrna_primary_transcript AS
  SELECT
    feature_id AS scrna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'scRNA_primary_transcript';

--- ************************************************
--- *** relation: scrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A small non coding RNA sequence, present ***
--- ***  in the cytoplasm.                       ***
--- ************************************************
---

CREATE VIEW scrna AS
  SELECT
    feature_id AS scrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'scRNA';

--- ************************************************
--- *** relation: inr_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence element characteristic of som ***
--- *** e RNA polymerase II promoters required f ***
--- *** or the correct positioning of the polyme ***
--- *** rase for the start of transcription. Ove ***
--- *** rlaps the TSS. The mammalian consensus s ***
--- *** equence is YYAN(T|A)YY; the Drosophila c ***
--- *** onsensus sequence is TCA(G|T)t(T|C). In  ***
--- *** each the A is at position +1 with respec ***
--- *** t to the TSS. Functionally similar to th ***
--- *** e TATA box element.                      ***
--- ************************************************
---

CREATE VIEW inr_motif AS
  SELECT
    feature_id AS inr_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'INR_motif';

--- ************************************************
--- *** relation: dpe_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence element characteristic of som ***
--- *** e RNA polymerase II promoters; Positione ***
--- *** d from +28 to +32 with respect to the TS ***
--- *** S (+1). Experimental results suggest tha ***
--- *** t the DPE acts in conjunction with the I ***
--- *** NR_motif to provide a binding site for T ***
--- *** FIID in the absence of a TATA box to med ***
--- *** iate transcription of TATA-less promoter ***
--- *** s. Consensus sequence (A|G)G(A|T)(C|T)(G ***
--- *** |A|C).                                   ***
--- ************************************************
---

CREATE VIEW dpe_motif AS
  SELECT
    feature_id AS dpe_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DPE_motif';

--- ************************************************
--- *** relation: breu_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence element characteristic of som ***
--- *** e RNA polymerase II promoters, located i ***
--- *** mmediately upstream of some TATA box ele ***
--- *** ments at -37 to -32 with respect to the  ***
--- *** TSS (+1). Consensus sequence is (G|C)(G| ***
--- *** C)(G|A)CGCC. Binds TFIIB.                ***
--- ************************************************
---

CREATE VIEW breu_motif AS
  SELECT
    feature_id AS breu_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'BREu_motif';

--- ************************************************
--- *** relation: pse_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence element characteristic of the ***
--- ***  promoters of snRNA genes transcribed by ***
--- ***  RNA polymerase II or by RNA polymerase  ***
--- *** III. Located between -45 and -60 relativ ***
--- *** e to the TSS. The human PSE_motif consen ***
--- *** sus sequence is TCACCNTNA(C|G)TNAAAAG(T| ***
--- *** G).                                      ***
--- ************************************************
---

CREATE VIEW pse_motif AS
  SELECT
    feature_id AS pse_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'PSE_motif';

--- ************************************************
--- *** relation: linkage_group ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A group of loci that can be grouped in a ***
--- ***  linear order representing the different ***
--- ***  degrees of linkage among the genes conc ***
--- *** erned.                                   ***
--- ************************************************
---

CREATE VIEW linkage_group AS
  SELECT
    feature_id AS linkage_group_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'linkage_group';

--- ************************************************
--- *** relation: rna_internal_loop ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of double stranded RNA where th ***
--- *** e bases do not conform to WC base pairin ***
--- *** g. The loop is closed on both sides by c ***
--- *** anonical base pairing. If the interrupti ***
--- *** on to base pairing occurs on one strand  ***
--- *** only, it is known as a bulge.            ***
--- ************************************************
---

CREATE VIEW rna_internal_loop AS
  SELECT
    feature_id AS rna_internal_loop_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'asymmetric_RNA_internal_loop' OR cvterm.name = 'symmetric_RNA_internal_loop' OR cvterm.name = 'K_turn_RNA_motif' OR cvterm.name = 'sarcin_like_RNA_motif' OR cvterm.name = 'RNA_internal_loop';

--- ************************************************
--- *** relation: asymmetric_rna_internal_loop ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An internal RNA loop where one of the st ***
--- *** rands includes more bases than the corre ***
--- *** sponding region on the other strand.     ***
--- ************************************************
---

CREATE VIEW asymmetric_rna_internal_loop AS
  SELECT
    feature_id AS asymmetric_rna_internal_loop_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'K_turn_RNA_motif' OR cvterm.name = 'sarcin_like_RNA_motif' OR cvterm.name = 'asymmetric_RNA_internal_loop';

--- ************************************************
--- *** relation: a_minor_rna_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region forming a motif, composed of ad ***
--- *** enines, where the minor groove edges are ***
--- ***  inserted into the minor groove of anoth ***
--- *** er helix.                                ***
--- ************************************************
---

CREATE VIEW a_minor_rna_motif AS
  SELECT
    feature_id AS a_minor_rna_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'A_minor_RNA_motif';

--- ************************************************
--- *** relation: k_turn_rna_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The kink turn (K-turn) is an RNA structu ***
--- *** ral motif that creates a sharp (~120 deg ***
--- *** ree) bend between two continuous helices ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW k_turn_rna_motif AS
  SELECT
    feature_id AS k_turn_rna_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'K_turn_RNA_motif';

--- ************************************************
--- *** relation: sarcin_like_rna_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A loop in ribosomal RNA containing the s ***
--- *** ites of attack for ricin and sarcin.     ***
--- ************************************************
---

CREATE VIEW sarcin_like_rna_motif AS
  SELECT
    feature_id AS sarcin_like_rna_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'sarcin_like_RNA_motif';

--- ************************************************
--- *** relation: symmetric_rna_internal_loop ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An internal RNA loop where the extent of ***
--- ***  the loop on both stands is the same siz ***
--- *** e.                                       ***
--- ************************************************
---

CREATE VIEW symmetric_rna_internal_loop AS
  SELECT
    feature_id AS symmetric_rna_internal_loop_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'symmetric_RNA_internal_loop';

--- ************************************************
--- *** relation: rna_junction_loop ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW rna_junction_loop AS
  SELECT
    feature_id AS rna_junction_loop_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNA_hook_turn' OR cvterm.name = 'RNA_junction_loop';

--- ************************************************
--- *** relation: rna_hook_turn ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW rna_hook_turn AS
  SELECT
    feature_id AS rna_hook_turn_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNA_hook_turn';

--- ************************************************
--- *** relation: base_pair ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW base_pair AS
  SELECT
    feature_id AS base_pair_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'WC_base_pair' OR cvterm.name = 'sugar_edge_base_pair' OR cvterm.name = 'Hoogsteen_base_pair' OR cvterm.name = 'reverse_Hoogsteen_base_pair' OR cvterm.name = 'wobble_base_pair' OR cvterm.name = 'base_pair';

--- ************************************************
--- *** relation: wc_base_pair ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The canonical base pair, where two bases ***
--- ***  interact via WC edges, with glycosidic  ***
--- *** bonds oriented cis relative to the axis  ***
--- *** of orientation.                          ***
--- ************************************************
---

CREATE VIEW wc_base_pair AS
  SELECT
    feature_id AS wc_base_pair_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'WC_base_pair';

--- ************************************************
--- *** relation: sugar_edge_base_pair ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A type of non-canonical base-pairing.    ***
--- ************************************************
---

CREATE VIEW sugar_edge_base_pair AS
  SELECT
    feature_id AS sugar_edge_base_pair_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'sugar_edge_base_pair';

--- ************************************************
--- *** relation: aptamer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** DNA or RNA molecules that have been sele ***
--- *** cted from random pools based on their ab ***
--- *** ility to bind other molecules.           ***
--- ************************************************
---

CREATE VIEW aptamer AS
  SELECT
    feature_id AS aptamer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DNA_aptamer' OR cvterm.name = 'RNA_aptamer' OR cvterm.name = 'aptamer';

--- ************************************************
--- *** relation: dna_aptamer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** DNA molecules that have been selected fr ***
--- *** om random pools based on their ability t ***
--- *** o bind other molecules.                  ***
--- ************************************************
---

CREATE VIEW dna_aptamer AS
  SELECT
    feature_id AS dna_aptamer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DNA_aptamer';

--- ************************************************
--- *** relation: rna_aptamer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** RNA molecules that have been selected fr ***
--- *** om random pools based on their ability t ***
--- *** o bind other molecules.                  ***
--- ************************************************
---

CREATE VIEW rna_aptamer AS
  SELECT
    feature_id AS rna_aptamer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNA_aptamer';

--- ************************************************
--- *** relation: morpholino_oligo ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Morpholino oligos are synthesized from f ***
--- *** our different Morpholino subunits, each  ***
--- *** of which contains one of the four geneti ***
--- *** c bases (A, C, G, T) linked to a 6-membe ***
--- *** red morpholine ring. Eighteen to 25 subu ***
--- *** nits of these four subunit types are joi ***
--- *** ned in a specific order by non-ionic pho ***
--- *** sphorodiamidate intersubunit linkages to ***
--- ***  give a Morpholino.                      ***
--- ************************************************
---

CREATE VIEW morpholino_oligo AS
  SELECT
    feature_id AS morpholino_oligo_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'morpholino_oligo';

--- ************************************************
--- *** relation: riboswitch ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A riboswitch is a part of an mRNA that c ***
--- *** an act as a direct sensor of small molec ***
--- *** ules to control their own expression. A  ***
--- *** riboswitch is a cis element in the 5' en ***
--- *** d of an mRNA, that acts as a direct sens ***
--- *** or of metabolites.                       ***
--- ************************************************
---

CREATE VIEW riboswitch AS
  SELECT
    feature_id AS riboswitch_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'riboswitch';

--- ************************************************
--- *** relation: matrix_attachment_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A DNA region that is required for the bi ***
--- *** nding of chromatin to the nuclear matrix ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW matrix_attachment_site AS
  SELECT
    feature_id AS matrix_attachment_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'matrix_attachment_site';

--- ************************************************
--- *** relation: locus_control_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A DNA region that includes DNAse hyperse ***
--- *** nsitive sites located 5' to a gene that  ***
--- *** confers the high-level, position-indepen ***
--- *** dent, and copy number-dependent expressi ***
--- *** on to that gene.                         ***
--- ************************************************
---

CREATE VIEW locus_control_region AS
  SELECT
    feature_id AS locus_control_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'locus_control_region';

--- ************************************************
--- *** relation: match_part ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A part of a match, for example an hsp fr ***
--- *** om blast is a match_part.                ***
--- ************************************************
---

CREATE VIEW match_part AS
  SELECT
    feature_id AS match_part_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'match_part';

--- ************************************************
--- *** relation: genomic_clone ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A clone of a DNA region of a genome.     ***
--- ************************************************
---

CREATE VIEW genomic_clone AS
  SELECT
    feature_id AS genomic_clone_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'genomic_clone';

--- ************************************************
--- *** relation: processed_pseudogene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A pseudogene where by an mRNA was retrot ***
--- *** ransposed. The mRNA sequence is transcri ***
--- *** bed back into the genome, lacking intron ***
--- *** s and promoters, but often including a p ***
--- *** olyA tail.                               ***
--- ************************************************
---

CREATE VIEW processed_pseudogene AS
  SELECT
    feature_id AS processed_pseudogene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'processed_pseudogene';

--- ************************************************
--- *** relation: pseudogene_by_unequal_crossing_over ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A pseudogene caused by unequal crossing  ***
--- *** over at recombination.                   ***
--- ************************************************
---

CREATE VIEW pseudogene_by_unequal_crossing_over AS
  SELECT
    feature_id AS pseudogene_by_unequal_crossing_over_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pseudogene_by_unequal_crossing_over';

--- ************************************************
--- *** relation: probe ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A DNA sequence used experimentally to de ***
--- *** tect the presence or absence of a comple ***
--- *** mentary nucleic acid.                    ***
--- ************************************************
---

CREATE VIEW probe AS
  SELECT
    feature_id AS probe_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'microarray_oligo' OR cvterm.name = 'probe';

--- ************************************************
--- *** relation: aneuploid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A kind of chromosome variation where the ***
--- ***  chromosome complement is not an exact m ***
--- *** ultiple of the haploid number.           ***
--- ************************************************
---

CREATE VIEW aneuploid AS
  SELECT
    feature_id AS aneuploid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'hyperploid' OR cvterm.name = 'hypoploid' OR cvterm.name = 'aneuploid';

--- ************************************************
--- *** relation: hyperploid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A kind of chromosome variation where the ***
--- ***  chromosome complement is not an exact m ***
--- *** ultiple of the haploid number as extra c ***
--- *** hromosomes are present.                  ***
--- ************************************************
---

CREATE VIEW hyperploid AS
  SELECT
    feature_id AS hyperploid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'hyperploid';

--- ************************************************
--- *** relation: hypoploid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A kind of chromosome variation where the ***
--- ***  chromosome complement is not an exact m ***
--- *** ultiple of the haploid number as some ch ***
--- *** romosomes are missing.                   ***
--- ************************************************
---

CREATE VIEW hypoploid AS
  SELECT
    feature_id AS hypoploid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'hypoploid';

--- ************************************************
--- *** relation: operator ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A regulatory element of an operon to whi ***
--- *** ch activators or repressors bind thereby ***
--- ***  effecting translation of genes in that  ***
--- *** operon.                                  ***
--- ************************************************
---

CREATE VIEW operator AS
  SELECT
    feature_id AS operator_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'operator';

--- ************************************************
--- *** relation: nuclease_binding_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A binding site that, of a nucleotide mol ***
--- *** ecule, that interacts selectively and no ***
--- *** n-covalently with polypeptide residues o ***
--- *** f a nuclease.                            ***
--- ************************************************
---

CREATE VIEW nuclease_binding_site AS
  SELECT
    feature_id AS nuclease_binding_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'restriction_enzyme_binding_site' OR cvterm.name = 'nuclease_sensitive_site' OR cvterm.name = 'homing_endonuclease_binding_site' OR cvterm.name = 'nuclease_hypersensitive_site' OR cvterm.name = 'group_1_intron_homing_endonuclease_target_region' OR cvterm.name = 'DNAseI_hypersensitive_site' OR cvterm.name = 'nuclease_binding_site';

--- ************************************************
--- *** relation: compound_chromosome_arm ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW compound_chromosome_arm AS
  SELECT
    feature_id AS compound_chromosome_arm_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'compound_chromosome_arm';

--- ************************************************
--- *** relation: restriction_enzyme_binding_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A binding site that, in the nucleotide m ***
--- *** olecule, interacts selectively and non-c ***
--- *** ovalently with polypeptide residues of a ***
--- ***  restriction enzyme.                     ***
--- ************************************************
---

CREATE VIEW restriction_enzyme_binding_site AS
  SELECT
    feature_id AS restriction_enzyme_binding_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'restriction_enzyme_binding_site';

--- ************************************************
--- *** relation: d_intrachr_transposition ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An intrachromosomal transposition whereb ***
--- *** y a translocation in which one of the fo ***
--- *** ur broken ends loses a segment before re ***
--- *** -joining.                                ***
--- ************************************************
---

CREATE VIEW d_intrachr_transposition AS
  SELECT
    feature_id AS d_intrachr_transposition_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'deficient_intrachromosomal_transposition';

--- ************************************************
--- *** relation: d_interchr_transposition ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An interchromosomal transposition whereb ***
--- *** y a translocation in which one of the fo ***
--- *** ur broken ends loses a segment before re ***
--- *** -joining.                                ***
--- ************************************************
---

CREATE VIEW d_interchr_transposition AS
  SELECT
    feature_id AS d_interchr_transposition_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'deficient_interchromosomal_transposition';

--- ************************************************
--- *** relation: free_chromosome_arm ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome structure variation whereby ***
--- ***  an arm exists as an individual chromoso ***
--- *** me element.                              ***
--- ************************************************
---

CREATE VIEW free_chromosome_arm AS
  SELECT
    feature_id AS free_chromosome_arm_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'free_chromosome_arm';

--- ************************************************
--- *** relation: gene_to_gene_feature ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW gene_to_gene_feature AS
  SELECT
    feature_id AS gene_to_gene_feature_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'overlapping' OR cvterm.name = 'inside_intron' OR cvterm.name = 'five_prime_three_prime_overlap' OR cvterm.name = 'five_prime_five_prime_overlap' OR cvterm.name = 'three_prime_three_prime_overlap' OR cvterm.name = 'three_prime_five_prime_overlap' OR cvterm.name = 'antisense' OR cvterm.name = 'inside_intron_antiparallel' OR cvterm.name = 'inside_intron_parallel' OR cvterm.name = 'gene_to_gene_feature';

--- ************************************************
--- *** relation: overlapping ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a gene that has  ***
--- *** a sequence that overlaps the sequence of ***
--- ***  another gene.                           ***
--- ************************************************
---

CREATE VIEW overlapping AS
  SELECT
    feature_id AS overlapping_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inside_intron' OR cvterm.name = 'five_prime_three_prime_overlap' OR cvterm.name = 'five_prime_five_prime_overlap' OR cvterm.name = 'three_prime_three_prime_overlap' OR cvterm.name = 'three_prime_five_prime_overlap' OR cvterm.name = 'antisense' OR cvterm.name = 'inside_intron_antiparallel' OR cvterm.name = 'inside_intron_parallel' OR cvterm.name = 'overlapping';

--- ************************************************
--- *** relation: inside_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a gene when it  ***
--- *** is located within the intron of another  ***
--- *** gene.                                    ***
--- ************************************************
---

CREATE VIEW inside_intron AS
  SELECT
    feature_id AS inside_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inside_intron_antiparallel' OR cvterm.name = 'inside_intron_parallel' OR cvterm.name = 'inside_intron';

--- ************************************************
--- *** relation: inside_intron_antiparallel ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a gene when it  ***
--- *** is located within the intron of another  ***
--- *** gene and on the opposite strand.         ***
--- ************************************************
---

CREATE VIEW inside_intron_antiparallel AS
  SELECT
    feature_id AS inside_intron_antiparallel_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inside_intron_antiparallel';

--- ************************************************
--- *** relation: inside_intron_parallel ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a gene when it  ***
--- *** is located within the intron of another  ***
--- *** gene and on the same strand.             ***
--- ************************************************
---

CREATE VIEW inside_intron_parallel AS
  SELECT
    feature_id AS inside_intron_parallel_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inside_intron_parallel';

--- ************************************************
--- *** relation: five_prime_three_prime_overlap ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a gene when the ***
--- ***  five prime region overlaps with another ***
--- ***  gene's 3' region.                       ***
--- ************************************************
---

CREATE VIEW five_prime_three_prime_overlap AS
  SELECT
    feature_id AS five_prime_three_prime_overlap_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_three_prime_overlap';

--- ************************************************
--- *** relation: five_prime_five_prime_overlap ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a gene when the ***
--- ***  five prime region overlaps with another ***
--- ***  gene's five prime region.               ***
--- ************************************************
---

CREATE VIEW five_prime_five_prime_overlap AS
  SELECT
    feature_id AS five_prime_five_prime_overlap_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_five_prime_overlap';

--- ************************************************
--- *** relation: three_prime_three_prime_overlap ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a gene when the ***
--- ***  3' region overlaps with another gene's  ***
--- *** 3' region.                               ***
--- ************************************************
---

CREATE VIEW three_prime_three_prime_overlap AS
  SELECT
    feature_id AS three_prime_three_prime_overlap_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_three_prime_overlap';

--- ************************************************
--- *** relation: three_prime_five_prime_overlap ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a gene when the ***
--- ***  3' region overlaps with another gene's  ***
--- *** 5' region.                               ***
--- ************************************************
---

CREATE VIEW three_prime_five_prime_overlap AS
  SELECT
    feature_id AS three_prime_five_prime_overlap_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_five_prime_overlap';

--- ************************************************
--- *** relation: antisense ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region sequence that is complementary  ***
--- *** to a sequence of messenger RNA.          ***
--- ************************************************
---

CREATE VIEW antisense AS
  SELECT
    feature_id AS antisense_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'antisense';

--- ************************************************
--- *** relation: polycistronic_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transcript that is polycistronic.      ***
--- ************************************************
---

CREATE VIEW polycistronic_transcript AS
  SELECT
    feature_id AS polycistronic_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'dicistronic_transcript' OR cvterm.name = 'polycistronic_primary_transcript' OR cvterm.name = 'polycistronic_mRNA' OR cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'polycistronic_transcript';

--- ************************************************
--- *** relation: dicistronic_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transcript that is dicistronic.        ***
--- ************************************************
---

CREATE VIEW dicistronic_transcript AS
  SELECT
    feature_id AS dicistronic_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'dicistronic_transcript';

--- ************************************************
--- *** relation: operon_member ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW operon_member AS
  SELECT
    feature_id AS operon_member_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'operon_member';

--- ************************************************
--- *** relation: gene_array_member ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW gene_array_member AS
  SELECT
    feature_id AS gene_array_member_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'operon_member' OR cvterm.name = 'gene_cassette_member' OR cvterm.name = 'gene_subarray_member' OR cvterm.name = 'member_of_regulon' OR cvterm.name = 'cassette_array_member' OR cvterm.name = 'gene_array_member';

--- ************************************************
--- *** relation: macronuclear_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW macronuclear_sequence AS
  SELECT
    feature_id AS macronuclear_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'macronuclear_sequence';

--- ************************************************
--- *** relation: micronuclear_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW micronuclear_sequence AS
  SELECT
    feature_id AS micronuclear_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'micronuclear_sequence';

--- ************************************************
--- *** relation: nuclear_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene from nuclear sequence.            ***
--- ************************************************
---

CREATE VIEW nuclear_gene AS
  SELECT
    feature_id AS nuclear_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'nuclear_gene';

--- ************************************************
--- *** relation: mt_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene located in mitochondrial sequence ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW mt_gene AS
  SELECT
    feature_id AS mt_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'kinetoplast_gene' OR cvterm.name = 'maxicircle_gene' OR cvterm.name = 'minicircle_gene' OR cvterm.name = 'cryptogene' OR cvterm.name = 'mt_gene';

--- ************************************************
--- *** relation: kinetoplast_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene located in kinetoplast sequence.  ***
--- ************************************************
---

CREATE VIEW kinetoplast_gene AS
  SELECT
    feature_id AS kinetoplast_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'maxicircle_gene' OR cvterm.name = 'minicircle_gene' OR cvterm.name = 'cryptogene' OR cvterm.name = 'kinetoplast_gene';

--- ************************************************
--- *** relation: plastid_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene from plastid sequence.            ***
--- ************************************************
---

CREATE VIEW plastid_gene AS
  SELECT
    feature_id AS plastid_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'apicoplast_gene' OR cvterm.name = 'ct_gene' OR cvterm.name = 'chromoplast_gene' OR cvterm.name = 'cyanelle_gene' OR cvterm.name = 'leucoplast_gene' OR cvterm.name = 'proplastid_gene' OR cvterm.name = 'plastid_gene';

--- ************************************************
--- *** relation: apicoplast_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene from apicoplast sequence.         ***
--- ************************************************
---

CREATE VIEW apicoplast_gene AS
  SELECT
    feature_id AS apicoplast_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'apicoplast_gene';

--- ************************************************
--- *** relation: ct_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene from chloroplast sequence.        ***
--- ************************************************
---

CREATE VIEW ct_gene AS
  SELECT
    feature_id AS ct_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'ct_gene';

--- ************************************************
--- *** relation: chromoplast_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene from chromoplast_sequence.        ***
--- ************************************************
---

CREATE VIEW chromoplast_gene AS
  SELECT
    feature_id AS chromoplast_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'chromoplast_gene';

--- ************************************************
--- *** relation: cyanelle_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene from cyanelle sequence.           ***
--- ************************************************
---

CREATE VIEW cyanelle_gene AS
  SELECT
    feature_id AS cyanelle_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cyanelle_gene';

--- ************************************************
--- *** relation: leucoplast_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A plastid gene from leucoplast sequence. ***
--- ************************************************
---

CREATE VIEW leucoplast_gene AS
  SELECT
    feature_id AS leucoplast_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'leucoplast_gene';

--- ************************************************
--- *** relation: proplastid_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene from proplastid sequence.         ***
--- ************************************************
---

CREATE VIEW proplastid_gene AS
  SELECT
    feature_id AS proplastid_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'proplastid_gene';

--- ************************************************
--- *** relation: nucleomorph_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene from nucleomorph sequence.        ***
--- ************************************************
---

CREATE VIEW nucleomorph_gene AS
  SELECT
    feature_id AS nucleomorph_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'nucleomorph_gene';

--- ************************************************
--- *** relation: plasmid_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene from plasmid sequence.            ***
--- ************************************************
---

CREATE VIEW plasmid_gene AS
  SELECT
    feature_id AS plasmid_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'plasmid_gene';

--- ************************************************
--- *** relation: proviral_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene from proviral sequence.           ***
--- ************************************************
---

CREATE VIEW proviral_gene AS
  SELECT
    feature_id AS proviral_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'endogenous_retroviral_gene' OR cvterm.name = 'proviral_gene';

--- ************************************************
--- *** relation: endogenous_retroviral_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A proviral gene with origin endogenous r ***
--- *** etrovirus.                               ***
--- ************************************************
---

CREATE VIEW endogenous_retroviral_gene AS
  SELECT
    feature_id AS endogenous_retroviral_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'endogenous_retroviral_gene';

--- ************************************************
--- *** relation: transposable_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transposon or insertion sequence. An e ***
--- *** lement that can insert in a variety of D ***
--- *** NA sequences.                            ***
--- ************************************************
---

CREATE VIEW transposable_element AS
  SELECT
    feature_id AS transposable_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'retrotransposon' OR cvterm.name = 'DNA_transposon' OR cvterm.name = 'foreign_transposable_element' OR cvterm.name = 'transgenic_transposable_element' OR cvterm.name = 'natural_transposable_element' OR cvterm.name = 'engineered_transposable_element' OR cvterm.name = 'nested_transposon' OR cvterm.name = 'LTR_retrotransposon' OR cvterm.name = 'non_LTR_retrotransposon' OR cvterm.name = 'LINE_element' OR cvterm.name = 'SINE_element' OR cvterm.name = 'terminal_inverted_repeat_element' OR cvterm.name = 'foldback_element' OR cvterm.name = 'conjugative_transposon' OR cvterm.name = 'helitron' OR cvterm.name = 'p_element' OR cvterm.name = 'MITE' OR cvterm.name = 'insertion_sequence' OR cvterm.name = 'polinton' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'transposable_element';

--- ************************************************
--- *** relation: expressed_sequence_match ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A match to an EST or cDNA sequence.      ***
--- ************************************************
---

CREATE VIEW expressed_sequence_match AS
  SELECT
    feature_id AS expressed_sequence_match_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'EST_match' OR cvterm.name = 'cDNA_match' OR cvterm.name = 'UST_match' OR cvterm.name = 'RST_match' OR cvterm.name = 'expressed_sequence_match';

--- ************************************************
--- *** relation: clone_insert_end ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The end of the clone insert.             ***
--- ************************************************
---

CREATE VIEW clone_insert_end AS
  SELECT
    feature_id AS clone_insert_end_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'clone_insert_end';

--- ************************************************
--- *** relation: polypeptide ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence of amino acids linked by pept ***
--- *** ide bonds which may lack appreciable ter ***
--- *** tiary structure and may not be liable to ***
--- ***  irreversible denaturation.              ***
--- ************************************************
---

CREATE VIEW polypeptide AS
  SELECT
    feature_id AS polypeptide_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide';

--- ************************************************
--- *** relation: chromosome_arm ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of the chromosome between the c ***
--- *** entromere and the telomere. Human chromo ***
--- *** somes have two arms, the p arm (short) a ***
--- *** nd the q arm (long) which are separated  ***
--- *** from each other by the centromere.       ***
--- ************************************************
---

CREATE VIEW chromosome_arm AS
  SELECT
    feature_id AS chromosome_arm_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'chromosome_arm';

--- ************************************************
--- *** relation: sequencing_primer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW sequencing_primer AS
  SELECT
    feature_id AS sequencing_primer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'sequencing_primer';

--- ************************************************
--- *** relation: mrna_with_frameshift ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An mRNA with a frameshift.               ***
--- ************************************************
---

CREATE VIEW mrna_with_frameshift AS
  SELECT
    feature_id AS mrna_with_frameshift_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mRNA_with_minus_1_frameshift' OR cvterm.name = 'mRNA_with_plus_1_frameshift' OR cvterm.name = 'mRNA_with_plus_2_frameshift' OR cvterm.name = 'mRNA_with_minus_2_frameshift' OR cvterm.name = 'mRNA_with_frameshift';

--- ************************************************
--- *** relation: sequence_feature ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An extent of biological sequence.        ***
--- ************************************************
---

CREATE VIEW sequence_feature AS
  SELECT
    feature_id AS sequence_feature_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'region' OR cvterm.name = 'junction' OR cvterm.name = 'sequence_alteration' OR cvterm.name = 'biomaterial_region' OR cvterm.name = 'experimental_feature' OR cvterm.name = 'biological_region' OR cvterm.name = 'topologically_defined_region' OR cvterm.name = 'reagent' OR cvterm.name = 'engineered_region' OR cvterm.name = 'PCR_product' OR cvterm.name = 'clone' OR cvterm.name = 'rescue_region' OR cvterm.name = 'oligo' OR cvterm.name = 'clone_insert' OR cvterm.name = 'cloned_region' OR cvterm.name = 'databank_entry' OR cvterm.name = 'RAPD' OR cvterm.name = 'genomic_clone' OR cvterm.name = 'cDNA_clone' OR cvterm.name = 'tiling_path_clone' OR cvterm.name = 'validated_cDNA_clone' OR cvterm.name = 'invalidated_cDNA_clone' OR cvterm.name = 'three_prime_RACE_clone' OR cvterm.name = 'chimeric_cDNA_clone' OR cvterm.name = 'genomically_contaminated_cDNA_clone' OR cvterm.name = 'polyA_primed_cDNA_clone' OR cvterm.name = 'partially_processed_cDNA_clone' OR cvterm.name = 'engineered_rescue_region' OR cvterm.name = 'aptamer' OR cvterm.name = 'probe' OR cvterm.name = 'tag' OR cvterm.name = 'ss_oligo' OR cvterm.name = 'ds_oligo' OR cvterm.name = 'DNAzyme' OR cvterm.name = 'synthetic_oligo' OR cvterm.name = 'DNA_aptamer' OR cvterm.name = 'RNA_aptamer' OR cvterm.name = 'microarray_oligo' OR cvterm.name = 'SAGE_tag' OR cvterm.name = 'STS' OR cvterm.name = 'EST' OR cvterm.name = 'engineered_tag' OR cvterm.name = 'five_prime_EST' OR cvterm.name = 'three_prime_EST' OR cvterm.name = 'UST' OR cvterm.name = 'RST' OR cvterm.name = 'three_prime_UST' OR cvterm.name = 'five_prime_UST' OR cvterm.name = 'three_prime_RST' OR cvterm.name = 'five_prime_RST' OR cvterm.name = 'primer' OR cvterm.name = 'sequencing_primer' OR cvterm.name = 'forward_primer' OR cvterm.name = 'reverse_primer' OR cvterm.name = 'ASPE_primer' OR cvterm.name = 'dCAPS_primer' OR cvterm.name = 'RNAi_reagent' OR cvterm.name = 'DNA_constraint_sequence' OR cvterm.name = 'morpholino_oligo' OR cvterm.name = 'PNA_oligo' OR cvterm.name = 'LNA_oligo' OR cvterm.name = 'TNA_oligo' OR cvterm.name = 'GNA_oligo' OR cvterm.name = 'R_GNA_oligo' OR cvterm.name = 'S_GNA_oligo' OR cvterm.name = 'cloned_cDNA_insert' OR cvterm.name = 'cloned_genomic_insert' OR cvterm.name = 'engineered_insert' OR cvterm.name = 'BAC_cloned_genomic_insert' OR cvterm.name = 'engineered_gene' OR cvterm.name = 'engineered_plasmid' OR cvterm.name = 'engineered_rescue_region' OR cvterm.name = 'engineered_transposable_element' OR cvterm.name = 'engineered_foreign_region' OR cvterm.name = 'engineered_tag' OR cvterm.name = 'engineered_insert' OR cvterm.name = 'targeting_vector' OR cvterm.name = 'engineered_foreign_gene' OR cvterm.name = 'engineered_fusion_gene' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'engineered_episome' OR cvterm.name = 'gene_trap_construct' OR cvterm.name = 'promoter_trap_construct' OR cvterm.name = 'enhancer_trap_construct' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'engineered_foreign_gene' OR cvterm.name = 'engineered_foreign_repetitive_element' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'match_part' OR cvterm.name = 'assembly_component' OR cvterm.name = 'conserved_region' OR cvterm.name = 'match' OR cvterm.name = 'remark' OR cvterm.name = 'reading_frame' OR cvterm.name = 'consensus_region' OR cvterm.name = 'low_complexity_region' OR cvterm.name = 'assembly' OR cvterm.name = 'transcribed_fragment' OR cvterm.name = 'transcribed_cluster' OR cvterm.name = 'high_identity_region' OR cvterm.name = 'mathematically_defined_repeat' OR cvterm.name = 'experimentally_defined_binding_region' OR cvterm.name = 'contig' OR cvterm.name = 'read' OR cvterm.name = 'restriction_fragment' OR cvterm.name = 'golden_path_fragment' OR cvterm.name = 'tiling_path_fragment' OR cvterm.name = 'gap' OR cvterm.name = 'sonicate_fragment' OR cvterm.name = 'paired_end_fragment' OR cvterm.name = 'read_pair' OR cvterm.name = 'contig_read' OR cvterm.name = 'BAC_end' OR cvterm.name = 'dye_terminator_read' OR cvterm.name = 'pyrosequenced_read' OR cvterm.name = 'ligation_based_read' OR cvterm.name = 'polymerase_synthesis_read' OR cvterm.name = 'PAC_end' OR cvterm.name = 'YAC_end' OR cvterm.name = 'clone_end' OR cvterm.name = 'RFLP_fragment' OR cvterm.name = 'tiling_path_clone' OR cvterm.name = 'coding_conserved_region' OR cvterm.name = 'nc_conserved_region' OR cvterm.name = 'RR_tract' OR cvterm.name = 'homologous_region' OR cvterm.name = 'centromere_DNA_Element_I' OR cvterm.name = 'centromere_DNA_Element_II' OR cvterm.name = 'centromere_DNA_Element_III' OR cvterm.name = 'X_element' OR cvterm.name = 'U_box' OR cvterm.name = 'regional_centromere_central_core' OR cvterm.name = 'syntenic_region' OR cvterm.name = 'paralogous_region' OR cvterm.name = 'orthologous_region' OR cvterm.name = 'nucleotide_match' OR cvterm.name = 'protein_match' OR cvterm.name = 'expressed_sequence_match' OR cvterm.name = 'cross_genome_match' OR cvterm.name = 'translated_nucleotide_match' OR cvterm.name = 'primer_match' OR cvterm.name = 'EST_match' OR cvterm.name = 'cDNA_match' OR cvterm.name = 'UST_match' OR cvterm.name = 'RST_match' OR cvterm.name = 'sequence_difference' OR cvterm.name = 'experimental_result_region' OR cvterm.name = 'polypeptide_sequencing_information' OR cvterm.name = 'possible_base_call_error' OR cvterm.name = 'possible_assembly_error' OR cvterm.name = 'assembly_error_correction' OR cvterm.name = 'base_call_error_correction' OR cvterm.name = 'overlapping_feature_set' OR cvterm.name = 'no_output' OR cvterm.name = 'overlapping_EST_set' OR cvterm.name = 'non_adjacent_residues' OR cvterm.name = 'non_terminal_residue' OR cvterm.name = 'sequence_conflict' OR cvterm.name = 'sequence_uncertainty' OR cvterm.name = 'contig_collection' OR cvterm.name = 'ORF' OR cvterm.name = 'blocked_reading_frame' OR cvterm.name = 'mini_gene' OR cvterm.name = 'rescue_mini_gene' OR cvterm.name = 'consensus_mRNA' OR cvterm.name = 'sequence_assembly' OR cvterm.name = 'fragment_assembly' OR cvterm.name = 'supercontig' OR cvterm.name = 'contig' OR cvterm.name = 'tiling_path' OR cvterm.name = 'virtual_sequence' OR cvterm.name = 'golden_path' OR cvterm.name = 'ultracontig' OR cvterm.name = 'expressed_sequence_assembly' OR cvterm.name = 'fingerprint_map' OR cvterm.name = 'STS_map' OR cvterm.name = 'RH_map' OR cvterm.name = 'unigene_cluster' OR cvterm.name = 'CHiP_seq_region' OR cvterm.name = 'sequence_secondary_structure' OR cvterm.name = 'linkage_group' OR cvterm.name = 'polypeptide' OR cvterm.name = 'deletion' OR cvterm.name = 'origin_of_replication' OR cvterm.name = 'recombination_feature' OR cvterm.name = 'CpG_island' OR cvterm.name = 'pseudogene' OR cvterm.name = 'binding_site' OR cvterm.name = 'pseudogenic_region' OR cvterm.name = 'cap' OR cvterm.name = 'intergenic_region' OR cvterm.name = 'oligo_U_tail' OR cvterm.name = 'polyA_sequence' OR cvterm.name = 'repeat_region' OR cvterm.name = 'insertion' OR cvterm.name = 'gene' OR cvterm.name = 'repeat_unit' OR cvterm.name = 'QTL' OR cvterm.name = 'chromosome_part' OR cvterm.name = 'gene_member_region' OR cvterm.name = 'transcript_region' OR cvterm.name = 'polypeptide_region' OR cvterm.name = 'gene_component_region' OR cvterm.name = 'mobile_genetic_element' OR cvterm.name = 'replicon' OR cvterm.name = 'base' OR cvterm.name = 'amino_acid' OR cvterm.name = 'genetic_marker' OR cvterm.name = 'sequence_motif' OR cvterm.name = 'restriction_enzyme_recognition_site' OR cvterm.name = 'restriction_enzyme_single_strand_overhang' OR cvterm.name = 'epigenetically_modified_region' OR cvterm.name = 'open_chromatin_region' OR cvterm.name = 'gene_group' OR cvterm.name = 'substitution' OR cvterm.name = 'inversion' OR cvterm.name = 'retron' OR cvterm.name = 'G_quartet' OR cvterm.name = 'base_pair' OR cvterm.name = 'RNA_sequence_secondary_structure' OR cvterm.name = 'DNA_sequence_secondary_structure' OR cvterm.name = 'pseudoknot' OR cvterm.name = 'WC_base_pair' OR cvterm.name = 'sugar_edge_base_pair' OR cvterm.name = 'Hoogsteen_base_pair' OR cvterm.name = 'reverse_Hoogsteen_base_pair' OR cvterm.name = 'wobble_base_pair' OR cvterm.name = 'stem_loop' OR cvterm.name = 'tetraloop' OR cvterm.name = 'i_motif' OR cvterm.name = 'recoding_pseudoknot' OR cvterm.name = 'H_pseudoknot' OR cvterm.name = 'D_loop' OR cvterm.name = 'ARS' OR cvterm.name = 'oriT' OR cvterm.name = 'amplification_origin' OR cvterm.name = 'oriV' OR cvterm.name = 'oriC' OR cvterm.name = 'recombination_hotspot' OR cvterm.name = 'haplotype_block' OR cvterm.name = 'sequence_rearrangement_feature' OR cvterm.name = 'iDNA' OR cvterm.name = 'specific_recombination_site' OR cvterm.name = 'chromosome_breakage_sequence' OR cvterm.name = 'internal_eliminated_sequence' OR cvterm.name = 'macronucleus_destined_segment' OR cvterm.name = 'recombination_feature_of_rearranged_gene' OR cvterm.name = 'site_specific_recombination_target_region' OR cvterm.name = 'recombination_signal_sequence' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_feature' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_segment' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_gene_cluster' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_spacer' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_segment' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_gene_cluster' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_signal_feature' OR cvterm.name = 'D_gene' OR cvterm.name = 'V_gene' OR cvterm.name = 'J_gene' OR cvterm.name = 'C_gene' OR cvterm.name = 'D_J_C_cluster' OR cvterm.name = 'J_C_cluster' OR cvterm.name = 'J_cluster' OR cvterm.name = 'V_cluster' OR cvterm.name = 'V_J_cluster' OR cvterm.name = 'V_J_C_cluster' OR cvterm.name = 'C_cluster' OR cvterm.name = 'D_cluster' OR cvterm.name = 'D_J_cluster' OR cvterm.name = 'three_prime_D_spacer' OR cvterm.name = 'five_prime_D_spacer' OR cvterm.name = 'J_spacer' OR cvterm.name = 'V_spacer' OR cvterm.name = 'VD_gene' OR cvterm.name = 'DJ_gene' OR cvterm.name = 'VDJ_gene' OR cvterm.name = 'VJ_gene' OR cvterm.name = 'DJ_J_cluster' OR cvterm.name = 'VDJ_J_C_cluster' OR cvterm.name = 'VDJ_J_cluster' OR cvterm.name = 'VJ_C_cluster' OR cvterm.name = 'VJ_J_C_cluster' OR cvterm.name = 'VJ_J_cluster' OR cvterm.name = 'D_DJ_C_cluster' OR cvterm.name = 'D_DJ_cluster' OR cvterm.name = 'D_DJ_J_C_cluster' OR cvterm.name = 'D_DJ_J_cluster' OR cvterm.name = 'V_DJ_cluster' OR cvterm.name = 'V_DJ_J_cluster' OR cvterm.name = 'V_VDJ_C_cluster' OR cvterm.name = 'V_VDJ_cluster' OR cvterm.name = 'V_VDJ_J_cluster' OR cvterm.name = 'V_VJ_C_cluster' OR cvterm.name = 'V_VJ_cluster' OR cvterm.name = 'V_VJ_J_cluster' OR cvterm.name = 'V_D_DJ_C_cluster' OR cvterm.name = 'V_D_DJ_cluster' OR cvterm.name = 'V_D_DJ_J_C_cluster' OR cvterm.name = 'V_D_DJ_J_cluster' OR cvterm.name = 'V_D_J_C_cluster' OR cvterm.name = 'V_D_J_cluster' OR cvterm.name = 'DJ_C_cluster' OR cvterm.name = 'DJ_J_C_cluster' OR cvterm.name = 'VDJ_C_cluster' OR cvterm.name = 'V_DJ_C_cluster' OR cvterm.name = 'V_DJ_J_C_cluster' OR cvterm.name = 'V_VDJ_J_C_cluster' OR cvterm.name = 'V_VJ_J_C_cluster' OR cvterm.name = 'J_gene_recombination_feature' OR cvterm.name = 'D_gene_recombination_feature' OR cvterm.name = 'V_gene_recombination_feature' OR cvterm.name = 'heptamer_of_recombination_feature_of_vertebrate_immune_system_gene' OR cvterm.name = 'nonamer_of_recombination_feature_of_vertebrate_immune_system_gene' OR cvterm.name = 'five_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_heptamer' OR cvterm.name = 'five_prime_D_heptamer' OR cvterm.name = 'J_heptamer' OR cvterm.name = 'V_heptamer' OR cvterm.name = 'three_prime_D_nonamer' OR cvterm.name = 'five_prime_D_nonamer' OR cvterm.name = 'J_nonamer' OR cvterm.name = 'V_nonamer' OR cvterm.name = 'integration_excision_site' OR cvterm.name = 'resolution_site' OR cvterm.name = 'inversion_site' OR cvterm.name = 'inversion_site_part' OR cvterm.name = 'attI_site' OR cvterm.name = 'attP_site' OR cvterm.name = 'attB_site' OR cvterm.name = 'attL_site' OR cvterm.name = 'attR_site' OR cvterm.name = 'attC_site' OR cvterm.name = 'attCtn_site' OR cvterm.name = 'loxP_site' OR cvterm.name = 'dif_site' OR cvterm.name = 'FRT_site' OR cvterm.name = 'IRLinv_site' OR cvterm.name = 'IRRinv_site' OR cvterm.name = 'processed_pseudogene' OR cvterm.name = 'non_processed_pseudogene' OR cvterm.name = 'pseudogene_by_unequal_crossing_over' OR cvterm.name = 'nuclear_mt_pseudogene' OR cvterm.name = 'cassette_pseudogene' OR cvterm.name = 'duplicated_pseudogene' OR cvterm.name = 'unitary_pseudogene' OR cvterm.name = 'protein_binding_site' OR cvterm.name = 'epitope' OR cvterm.name = 'nucleotide_binding_site' OR cvterm.name = 'metal_binding_site' OR cvterm.name = 'ligand_binding_site' OR cvterm.name = 'protein_protein_contact' OR cvterm.name = 'nucleotide_to_protein_binding_site' OR cvterm.name = 'nuclease_binding_site' OR cvterm.name = 'TF_binding_site' OR cvterm.name = 'histone_binding_site' OR cvterm.name = 'insulator_binding_site' OR cvterm.name = 'enhancer_binding_site' OR cvterm.name = 'restriction_enzyme_binding_site' OR cvterm.name = 'nuclease_sensitive_site' OR cvterm.name = 'homing_endonuclease_binding_site' OR cvterm.name = 'nuclease_hypersensitive_site' OR cvterm.name = 'group_1_intron_homing_endonuclease_target_region' OR cvterm.name = 'DNAseI_hypersensitive_site' OR cvterm.name = 'miRNA_target_site' OR cvterm.name = 'DNA_binding_site' OR cvterm.name = 'primer_binding_site' OR cvterm.name = 'polypeptide_DNA_contact' OR cvterm.name = 'polypeptide_metal_contact' OR cvterm.name = 'polypeptide_calcium_ion_contact_site' OR cvterm.name = 'polypeptide_cobalt_ion_contact_site' OR cvterm.name = 'polypeptide_copper_ion_contact_site' OR cvterm.name = 'polypeptide_iron_ion_contact_site' OR cvterm.name = 'polypeptide_magnesium_ion_contact_site' OR cvterm.name = 'polypeptide_manganese_ion_contact_site' OR cvterm.name = 'polypeptide_molybdenum_ion_contact_site' OR cvterm.name = 'polypeptide_nickel_ion_contact_site' OR cvterm.name = 'polypeptide_tungsten_ion_contact_site' OR cvterm.name = 'polypeptide_zinc_ion_contact_site' OR cvterm.name = 'polypeptide_ligand_contact' OR cvterm.name = 'decayed_exon' OR cvterm.name = 'pseudogenic_exon' OR cvterm.name = 'pseudogenic_transcript' OR cvterm.name = 'pseudogenic_rRNA' OR cvterm.name = 'pseudogenic_tRNA' OR cvterm.name = 'long_terminal_repeat' OR cvterm.name = 'engineered_foreign_repetitive_element' OR cvterm.name = 'inverted_repeat' OR cvterm.name = 'direct_repeat' OR cvterm.name = 'non_LTR_retrotransposon_polymeric_tract' OR cvterm.name = 'dispersed_repeat' OR cvterm.name = 'tandem_repeat' OR cvterm.name = 'X_element_combinatorial_repeat' OR cvterm.name = 'Y_prime_element' OR cvterm.name = 'telomeric_repeat' OR cvterm.name = 'nested_repeat' OR cvterm.name = 'centromeric_repeat' OR cvterm.name = 'five_prime_LTR' OR cvterm.name = 'three_prime_LTR' OR cvterm.name = 'solo_LTR' OR cvterm.name = 'terminal_inverted_repeat' OR cvterm.name = 'five_prime_terminal_inverted_repeat' OR cvterm.name = 'three_prime_terminal_inverted_repeat' OR cvterm.name = 'target_site_duplication' OR cvterm.name = 'CRISPR' OR cvterm.name = 'satellite_DNA' OR cvterm.name = 'microsatellite' OR cvterm.name = 'minisatellite' OR cvterm.name = 'dinucleotide_repeat_microsatellite_feature' OR cvterm.name = 'trinucleotide_repeat_microsatellite_feature' OR cvterm.name = 'tetranucleotide_repeat_microsatellite_feature' OR cvterm.name = 'nested_tandem_repeat' OR cvterm.name = 'regional_centromere_inner_repeat_region' OR cvterm.name = 'regional_centromere_outer_repeat_region' OR cvterm.name = 'transgenic_insertion' OR cvterm.name = 'duplication' OR cvterm.name = 'tandem_duplication' OR cvterm.name = 'direct_tandem_duplication' OR cvterm.name = 'inverted_tandem_duplication' OR cvterm.name = 'nuclear_gene' OR cvterm.name = 'mt_gene' OR cvterm.name = 'plastid_gene' OR cvterm.name = 'nucleomorph_gene' OR cvterm.name = 'plasmid_gene' OR cvterm.name = 'proviral_gene' OR cvterm.name = 'transposable_element_gene' OR cvterm.name = 'silenced_gene' OR cvterm.name = 'engineered_gene' OR cvterm.name = 'foreign_gene' OR cvterm.name = 'fusion_gene' OR cvterm.name = 'recombinationally_rearranged_gene' OR cvterm.name = 'gene_with_trans_spliced_transcript' OR cvterm.name = 'gene_with_polycistronic_transcript' OR cvterm.name = 'rescue_gene' OR cvterm.name = 'post_translationally_regulated_gene' OR cvterm.name = 'negatively_autoregulated_gene' OR cvterm.name = 'positively_autoregulated_gene' OR cvterm.name = 'translationally_regulated_gene' OR cvterm.name = 'epigenetically_modified_gene' OR cvterm.name = 'transgene' OR cvterm.name = 'predicted_gene' OR cvterm.name = 'protein_coding_gene' OR cvterm.name = 'retrogene' OR cvterm.name = 'ncRNA_gene' OR cvterm.name = 'cryptic_gene' OR cvterm.name = 'gene_with_non_canonical_start_codon' OR cvterm.name = 'gene_cassette' OR cvterm.name = 'kinetoplast_gene' OR cvterm.name = 'maxicircle_gene' OR cvterm.name = 'minicircle_gene' OR cvterm.name = 'cryptogene' OR cvterm.name = 'apicoplast_gene' OR cvterm.name = 'ct_gene' OR cvterm.name = 'chromoplast_gene' OR cvterm.name = 'cyanelle_gene' OR cvterm.name = 'leucoplast_gene' OR cvterm.name = 'proplastid_gene' OR cvterm.name = 'endogenous_retroviral_gene' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'gene_silenced_by_DNA_modification' OR cvterm.name = 'gene_silenced_by_RNA_interference' OR cvterm.name = 'gene_silenced_by_histone_modification' OR cvterm.name = 'gene_silenced_by_DNA_methylation' OR cvterm.name = 'gene_silenced_by_histone_methylation' OR cvterm.name = 'gene_silenced_by_histone_deacetylation' OR cvterm.name = 'engineered_foreign_gene' OR cvterm.name = 'engineered_fusion_gene' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'engineered_foreign_gene' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'engineered_fusion_gene' OR cvterm.name = 'recombinationally_inverted_gene' OR cvterm.name = 'recombinationally_rearranged_vertebrate_immune_system_gene' OR cvterm.name = 'gene_with_dicistronic_transcript' OR cvterm.name = 'gene_with_dicistronic_primary_transcript' OR cvterm.name = 'gene_with_dicistronic_mRNA' OR cvterm.name = 'wild_type_rescue_gene' OR cvterm.name = 'gene_rearranged_at_DNA_level' OR cvterm.name = 'maternally_imprinted_gene' OR cvterm.name = 'paternally_imprinted_gene' OR cvterm.name = 'allelically_excluded_gene' OR cvterm.name = 'floxed_gene' OR cvterm.name = 'gene_with_polyadenylated_mRNA' OR cvterm.name = 'gene_with_mRNA_with_frameshift' OR cvterm.name = 'gene_with_edited_transcript' OR cvterm.name = 'gene_with_recoded_mRNA' OR cvterm.name = 'gene_with_stop_codon_read_through' OR cvterm.name = 'gene_with_mRNA_recoded_by_translational_bypass' OR cvterm.name = 'gene_with_transcript_with_translational_frameshift' OR cvterm.name = 'gene_with_stop_codon_redefined_as_pyrrolysine' OR cvterm.name = 'gene_with_stop_codon_redefined_as_selenocysteine' OR cvterm.name = 'gRNA_gene' OR cvterm.name = 'miRNA_gene' OR cvterm.name = 'scRNA_gene' OR cvterm.name = 'snoRNA_gene' OR cvterm.name = 'snRNA_gene' OR cvterm.name = 'SRP_RNA_gene' OR cvterm.name = 'stRNA_gene' OR cvterm.name = 'tmRNA_gene' OR cvterm.name = 'tRNA_gene' OR cvterm.name = 'rRNA_gene' OR cvterm.name = 'piRNA_gene' OR cvterm.name = 'RNase_P_RNA_gene' OR cvterm.name = 'RNase_MRP_RNA_gene' OR cvterm.name = 'lincRNA_gene' OR cvterm.name = 'telomerase_RNA_gene' OR cvterm.name = 'cryptogene' OR cvterm.name = 'gene_with_start_codon_CUG' OR cvterm.name = 'chromosome_arm' OR cvterm.name = 'chromosome_band' OR cvterm.name = 'interband' OR cvterm.name = 'chromosomal_regulatory_element' OR cvterm.name = 'chromosomal_structural_element' OR cvterm.name = 'introgressed_chromosome_region' OR cvterm.name = 'matrix_attachment_site' OR cvterm.name = 'centromere' OR cvterm.name = 'telomere' OR cvterm.name = 'point_centromere' OR cvterm.name = 'regional_centromere' OR cvterm.name = 'transcript' OR cvterm.name = 'regulatory_region' OR cvterm.name = 'polycistronic_transcript' OR cvterm.name = 'transcript_with_translational_frameshift' OR cvterm.name = 'primary_transcript' OR cvterm.name = 'mature_transcript' OR cvterm.name = 'transcript_bound_by_nucleic_acid' OR cvterm.name = 'transcript_bound_by_protein' OR cvterm.name = 'enzymatic_RNA' OR cvterm.name = 'trans_spliced_transcript' OR cvterm.name = 'monocistronic_transcript' OR cvterm.name = 'aberrant_processed_transcript' OR cvterm.name = 'edited_transcript' OR cvterm.name = 'processed_transcript' OR cvterm.name = 'alternatively_spliced_transcript' OR cvterm.name = 'dicistronic_transcript' OR cvterm.name = 'polycistronic_primary_transcript' OR cvterm.name = 'polycistronic_mRNA' OR cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'protein_coding_primary_transcript' OR cvterm.name = 'nc_primary_transcript' OR cvterm.name = 'polycistronic_primary_transcript' OR cvterm.name = 'monocistronic_primary_transcript' OR cvterm.name = 'mini_exon_donor_RNA' OR cvterm.name = 'antisense_primary_transcript' OR cvterm.name = 'capped_primary_transcript' OR cvterm.name = 'pre_edited_mRNA' OR cvterm.name = 'scRNA_primary_transcript' OR cvterm.name = 'rRNA_primary_transcript' OR cvterm.name = 'tRNA_primary_transcript' OR cvterm.name = 'snRNA_primary_transcript' OR cvterm.name = 'snoRNA_primary_transcript' OR cvterm.name = 'tmRNA_primary_transcript' OR cvterm.name = 'SRP_RNA_primary_transcript' OR cvterm.name = 'miRNA_primary_transcript' OR cvterm.name = 'tasiRNA_primary_transcript' OR cvterm.name = 'rRNA_small_subunit_primary_transcript' OR cvterm.name = 'rRNA_large_subunit_primary_transcript' OR cvterm.name = 'alanine_tRNA_primary_transcript' OR cvterm.name = 'arginine_tRNA_primary_transcript' OR cvterm.name = 'asparagine_tRNA_primary_transcript' OR cvterm.name = 'aspartic_acid_tRNA_primary_transcript' OR cvterm.name = 'cysteine_tRNA_primary_transcript' OR cvterm.name = 'glutamic_acid_tRNA_primary_transcript' OR cvterm.name = 'glutamine_tRNA_primary_transcript' OR cvterm.name = 'glycine_tRNA_primary_transcript' OR cvterm.name = 'histidine_tRNA_primary_transcript' OR cvterm.name = 'isoleucine_tRNA_primary_transcript' OR cvterm.name = 'leucine_tRNA_primary_transcript' OR cvterm.name = 'lysine_tRNA_primary_transcript' OR cvterm.name = 'methionine_tRNA_primary_transcript' OR cvterm.name = 'phenylalanine_tRNA_primary_transcript' OR cvterm.name = 'proline_tRNA_primary_transcript' OR cvterm.name = 'serine_tRNA_primary_transcript' OR cvterm.name = 'threonine_tRNA_primary_transcript' OR cvterm.name = 'tryptophan_tRNA_primary_transcript' OR cvterm.name = 'tyrosine_tRNA_primary_transcript' OR cvterm.name = 'valine_tRNA_primary_transcript' OR cvterm.name = 'pyrrolysine_tRNA_primary_transcript' OR cvterm.name = 'selenocysteine_tRNA_primary_transcript' OR cvterm.name = 'methylation_guide_snoRNA_primary_transcript' OR cvterm.name = 'rRNA_cleavage_snoRNA_primary_transcript' OR cvterm.name = 'C_D_box_snoRNA_primary_transcript' OR cvterm.name = 'H_ACA_box_snoRNA_primary_transcript' OR cvterm.name = 'U14_snoRNA_primary_transcript' OR cvterm.name = 'stRNA_primary_transcript' OR cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'mRNA' OR cvterm.name = 'ncRNA' OR cvterm.name = 'mRNA_with_frameshift' OR cvterm.name = 'monocistronic_mRNA' OR cvterm.name = 'polycistronic_mRNA' OR cvterm.name = 'exemplar_mRNA' OR cvterm.name = 'capped_mRNA' OR cvterm.name = 'polyadenylated_mRNA' OR cvterm.name = 'trans_spliced_mRNA' OR cvterm.name = 'edited_mRNA' OR cvterm.name = 'consensus_mRNA' OR cvterm.name = 'recoded_mRNA' OR cvterm.name = 'mRNA_with_minus_1_frameshift' OR cvterm.name = 'mRNA_with_plus_1_frameshift' OR cvterm.name = 'mRNA_with_plus_2_frameshift' OR cvterm.name = 'mRNA_with_minus_2_frameshift' OR cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'mRNA_recoded_by_translational_bypass' OR cvterm.name = 'mRNA_recoded_by_codon_redefinition' OR cvterm.name = 'scRNA' OR cvterm.name = 'rRNA' OR cvterm.name = 'tRNA' OR cvterm.name = 'snRNA' OR cvterm.name = 'snoRNA' OR cvterm.name = 'small_regulatory_ncRNA' OR cvterm.name = 'RNase_MRP_RNA' OR cvterm.name = 'RNase_P_RNA' OR cvterm.name = 'telomerase_RNA' OR cvterm.name = 'vault_RNA' OR cvterm.name = 'Y_RNA' OR cvterm.name = 'rasiRNA' OR cvterm.name = 'SRP_RNA' OR cvterm.name = 'guide_RNA' OR cvterm.name = 'antisense_RNA' OR cvterm.name = 'siRNA' OR cvterm.name = 'stRNA' OR cvterm.name = 'class_II_RNA' OR cvterm.name = 'class_I_RNA' OR cvterm.name = 'piRNA' OR cvterm.name = 'lincRNA' OR cvterm.name = 'tasiRNA' OR cvterm.name = 'rRNA_cleavage_RNA' OR cvterm.name = 'small_subunit_rRNA' OR cvterm.name = 'large_subunit_rRNA' OR cvterm.name = 'rRNA_18S' OR cvterm.name = 'rRNA_16S' OR cvterm.name = 'rRNA_5_8S' OR cvterm.name = 'rRNA_5S' OR cvterm.name = 'rRNA_28S' OR cvterm.name = 'rRNA_23S' OR cvterm.name = 'rRNA_25S' OR cvterm.name = 'rRNA_21S' OR cvterm.name = 'alanyl_tRNA' OR cvterm.name = 'asparaginyl_tRNA' OR cvterm.name = 'aspartyl_tRNA' OR cvterm.name = 'cysteinyl_tRNA' OR cvterm.name = 'glutaminyl_tRNA' OR cvterm.name = 'glutamyl_tRNA' OR cvterm.name = 'glycyl_tRNA' OR cvterm.name = 'histidyl_tRNA' OR cvterm.name = 'isoleucyl_tRNA' OR cvterm.name = 'leucyl_tRNA' OR cvterm.name = 'lysyl_tRNA' OR cvterm.name = 'methionyl_tRNA' OR cvterm.name = 'phenylalanyl_tRNA' OR cvterm.name = 'prolyl_tRNA' OR cvterm.name = 'seryl_tRNA' OR cvterm.name = 'threonyl_tRNA' OR cvterm.name = 'tryptophanyl_tRNA' OR cvterm.name = 'tyrosyl_tRNA' OR cvterm.name = 'valyl_tRNA' OR cvterm.name = 'pyrrolysyl_tRNA' OR cvterm.name = 'arginyl_tRNA' OR cvterm.name = 'selenocysteinyl_tRNA' OR cvterm.name = 'U1_snRNA' OR cvterm.name = 'U2_snRNA' OR cvterm.name = 'U4_snRNA' OR cvterm.name = 'U4atac_snRNA' OR cvterm.name = 'U5_snRNA' OR cvterm.name = 'U6_snRNA' OR cvterm.name = 'U6atac_snRNA' OR cvterm.name = 'U11_snRNA' OR cvterm.name = 'U12_snRNA' OR cvterm.name = 'C_D_box_snoRNA' OR cvterm.name = 'H_ACA_box_snoRNA' OR cvterm.name = 'U14_snoRNA' OR cvterm.name = 'U3_snoRNA' OR cvterm.name = 'methylation_guide_snoRNA' OR cvterm.name = 'pseudouridylation_guide_snoRNA' OR cvterm.name = 'miRNA' OR cvterm.name = 'RNA_6S' OR cvterm.name = 'CsrB_RsmB_RNA' OR cvterm.name = 'DsrA_RNA' OR cvterm.name = 'OxyS_RNA' OR cvterm.name = 'RprA_RNA' OR cvterm.name = 'RRE_RNA' OR cvterm.name = 'spot_42_RNA' OR cvterm.name = 'tmRNA' OR cvterm.name = 'GcvB_RNA' OR cvterm.name = 'MicF_RNA' OR cvterm.name = 'ribozyme' OR cvterm.name = 'trans_spliced_mRNA' OR cvterm.name = 'monocistronic_primary_transcript' OR cvterm.name = 'monocistronic_mRNA' OR cvterm.name = 'edited_transcript_by_A_to_I_substitution' OR cvterm.name = 'edited_mRNA' OR cvterm.name = 'transcription_regulatory_region' OR cvterm.name = 'translation_regulatory_region' OR cvterm.name = 'recombination_regulatory_region' OR cvterm.name = 'replication_regulatory_region' OR cvterm.name = 'terminator' OR cvterm.name = 'TF_binding_site' OR cvterm.name = 'polyA_signal_sequence' OR cvterm.name = 'gene_group_regulatory_region' OR cvterm.name = 'transcriptional_cis_regulatory_region' OR cvterm.name = 'splicing_regulatory_region' OR cvterm.name = 'cis_regulatory_frameshift_element' OR cvterm.name = 'intronic_regulatory_region' OR cvterm.name = 'bacterial_terminator' OR cvterm.name = 'eukaryotic_terminator' OR cvterm.name = 'rho_dependent_bacterial_terminator' OR cvterm.name = 'rho_independent_bacterial_terminator' OR cvterm.name = 'terminator_of_type_2_RNApol_III_promoter' OR cvterm.name = 'operator' OR cvterm.name = 'bacterial_RNApol_promoter' OR cvterm.name = 'bacterial_terminator' OR cvterm.name = 'bacterial_RNApol_promoter_sigma_70' OR cvterm.name = 'bacterial_RNApol_promoter_sigma54' OR cvterm.name = 'rho_dependent_bacterial_terminator' OR cvterm.name = 'rho_independent_bacterial_terminator' OR cvterm.name = 'promoter' OR cvterm.name = 'insulator' OR cvterm.name = 'CRM' OR cvterm.name = 'promoter_targeting_sequence' OR cvterm.name = 'ISRE' OR cvterm.name = 'bidirectional_promoter' OR cvterm.name = 'RNA_polymerase_promoter' OR cvterm.name = 'RNApol_I_promoter' OR cvterm.name = 'RNApol_II_promoter' OR cvterm.name = 'RNApol_III_promoter' OR cvterm.name = 'bacterial_RNApol_promoter' OR cvterm.name = 'Phage_RNA_Polymerase_Promoter' OR cvterm.name = 'RNApol_II_core_promoter' OR cvterm.name = 'RNApol_III_promoter_type_1' OR cvterm.name = 'RNApol_III_promoter_type_2' OR cvterm.name = 'RNApol_III_promoter_type_3' OR cvterm.name = 'bacterial_RNApol_promoter_sigma_70' OR cvterm.name = 'bacterial_RNApol_promoter_sigma54' OR cvterm.name = 'SP6_RNA_Polymerase_Promoter' OR cvterm.name = 'T3_RNA_Polymerase_Promoter' OR cvterm.name = 'T7_RNA_Polymerase_Promoter' OR cvterm.name = 'locus_control_region' OR cvterm.name = 'enhancer' OR cvterm.name = 'silencer' OR cvterm.name = 'enhancer_bound_by_factor' OR cvterm.name = 'shadow_enhancer' OR cvterm.name = 'splice_enhancer' OR cvterm.name = 'intronic_splice_enhancer' OR cvterm.name = 'exonic_splice_enhancer' OR cvterm.name = 'attenuator' OR cvterm.name = 'exon' OR cvterm.name = 'edited_transcript_feature' OR cvterm.name = 'mature_transcript_region' OR cvterm.name = 'primary_transcript_region' OR cvterm.name = 'exon_region' OR cvterm.name = 'anchor_binding_site' OR cvterm.name = 'coding_exon' OR cvterm.name = 'noncoding_exon' OR cvterm.name = 'interior_exon' OR cvterm.name = 'exon_of_single_exon_gene' OR cvterm.name = 'interior_coding_exon' OR cvterm.name = 'five_prime_coding_exon' OR cvterm.name = 'three_prime_coding_exon' OR cvterm.name = 'three_prime_noncoding_exon' OR cvterm.name = 'five_prime_noncoding_exon' OR cvterm.name = 'pre_edited_region' OR cvterm.name = 'editing_block' OR cvterm.name = 'editing_domain' OR cvterm.name = 'unedited_region' OR cvterm.name = 'mRNA_region' OR cvterm.name = 'tmRNA_region' OR cvterm.name = 'guide_RNA_region' OR cvterm.name = 'tRNA_region' OR cvterm.name = 'riboswitch' OR cvterm.name = 'ribosome_entry_site' OR cvterm.name = 'UTR' OR cvterm.name = 'CDS' OR cvterm.name = 'five_prime_open_reading_frame' OR cvterm.name = 'UTR_region' OR cvterm.name = 'CDS_region' OR cvterm.name = 'translational_frameshift' OR cvterm.name = 'recoding_stimulatory_region' OR cvterm.name = 'internal_ribosome_entry_site' OR cvterm.name = 'Shine_Dalgarno_sequence' OR cvterm.name = 'kozak_sequence' OR cvterm.name = 'internal_Shine_Dalgarno_sequence' OR cvterm.name = 'five_prime_UTR' OR cvterm.name = 'three_prime_UTR' OR cvterm.name = 'internal_UTR' OR cvterm.name = 'untranslated_region_polycistronic_mRNA' OR cvterm.name = 'edited_CDS' OR cvterm.name = 'CDS_fragment' OR cvterm.name = 'CDS_independently_known' OR cvterm.name = 'CDS_predicted' OR cvterm.name = 'orphan_CDS' OR cvterm.name = 'CDS_supported_by_sequence_similarity_data' OR cvterm.name = 'CDS_supported_by_domain_match_data' OR cvterm.name = 'CDS_supported_by_EST_or_cDNA_data' OR cvterm.name = 'upstream_AUG_codon' OR cvterm.name = 'AU_rich_element' OR cvterm.name = 'Bruno_response_element' OR cvterm.name = 'iron_responsive_element' OR cvterm.name = 'coding_start' OR cvterm.name = 'coding_end' OR cvterm.name = 'codon' OR cvterm.name = 'recoded_codon' OR cvterm.name = 'start_codon' OR cvterm.name = 'stop_codon' OR cvterm.name = 'stop_codon_read_through' OR cvterm.name = 'stop_codon_redefined_as_pyrrolysine' OR cvterm.name = 'stop_codon_redefined_as_selenocysteine' OR cvterm.name = 'non_canonical_start_codon' OR cvterm.name = 'four_bp_start_codon' OR cvterm.name = 'CTG_start_codon' OR cvterm.name = 'plus_1_translational_frameshift' OR cvterm.name = 'plus_2_translational_frameshift' OR cvterm.name = 'internal_Shine_Dalgarno_sequence' OR cvterm.name = 'SECIS_element' OR cvterm.name = 'three_prime_recoding_site' OR cvterm.name = 'five_prime_recoding_site' OR cvterm.name = 'stop_codon_signal' OR cvterm.name = 'three_prime_stem_loop_structure' OR cvterm.name = 'flanking_three_prime_quadruplet_recoding_signal' OR cvterm.name = 'three_prime_repeat_recoding_signal' OR cvterm.name = 'distant_three_prime_recoding_signal' OR cvterm.name = 'UAG_stop_codon_signal' OR cvterm.name = 'UAA_stop_codon_signal' OR cvterm.name = 'UGA_stop_codon_signal' OR cvterm.name = 'tmRNA_coding_piece' OR cvterm.name = 'tmRNA_acceptor_piece' OR cvterm.name = 'anchor_region' OR cvterm.name = 'template_region' OR cvterm.name = 'anticodon_loop' OR cvterm.name = 'anticodon' OR cvterm.name = 'CCA_tail' OR cvterm.name = 'DHU_loop' OR cvterm.name = 'T_loop' OR cvterm.name = 'splice_site' OR cvterm.name = 'intron' OR cvterm.name = 'clip' OR cvterm.name = 'TSS' OR cvterm.name = 'transcription_end_site' OR cvterm.name = 'spliced_leader_RNA' OR cvterm.name = 'rRNA_primary_transcript_region' OR cvterm.name = 'spliceosomal_intron_region' OR cvterm.name = 'intron_domain' OR cvterm.name = 'miRNA_primary_transcript_region' OR cvterm.name = 'outron' OR cvterm.name = 'cis_splice_site' OR cvterm.name = 'trans_splice_site' OR cvterm.name = 'cryptic_splice_site' OR cvterm.name = 'five_prime_cis_splice_site' OR cvterm.name = 'three_prime_cis_splice_site' OR cvterm.name = 'recursive_splice_site' OR cvterm.name = 'canonical_five_prime_splice_site' OR cvterm.name = 'non_canonical_five_prime_splice_site' OR cvterm.name = 'canonical_three_prime_splice_site' OR cvterm.name = 'non_canonical_three_prime_splice_site' OR cvterm.name = 'trans_splice_acceptor_site' OR cvterm.name = 'trans_splice_donor_site' OR cvterm.name = 'SL1_acceptor_site' OR cvterm.name = 'SL2_acceptor_site' OR cvterm.name = 'SL3_acceptor_site' OR cvterm.name = 'SL4_acceptor_site' OR cvterm.name = 'SL5_acceptor_site' OR cvterm.name = 'SL6_acceptor_site' OR cvterm.name = 'SL7_acceptor_site' OR cvterm.name = 'SL8_acceptor_site' OR cvterm.name = 'SL9_acceptor_site' OR cvterm.name = 'SL10_accceptor_site' OR cvterm.name = 'SL11_acceptor_site' OR cvterm.name = 'SL12_acceptor_site' OR cvterm.name = 'five_prime_intron' OR cvterm.name = 'interior_intron' OR cvterm.name = 'three_prime_intron' OR cvterm.name = 'twintron' OR cvterm.name = 'UTR_intron' OR cvterm.name = 'autocatalytically_spliced_intron' OR cvterm.name = 'spliceosomal_intron' OR cvterm.name = 'mobile_intron' OR cvterm.name = 'endonuclease_spliced_intron' OR cvterm.name = 'five_prime_UTR_intron' OR cvterm.name = 'three_prime_UTR_intron' OR cvterm.name = 'group_I_intron' OR cvterm.name = 'group_II_intron' OR cvterm.name = 'group_III_intron' OR cvterm.name = 'group_IIA_intron' OR cvterm.name = 'group_IIB_intron' OR cvterm.name = 'U2_intron' OR cvterm.name = 'U12_intron' OR cvterm.name = 'archaeal_intron' OR cvterm.name = 'tRNA_intron' OR cvterm.name = 'five_prime_clip' OR cvterm.name = 'three_prime_clip' OR cvterm.name = 'major_TSS' OR cvterm.name = 'minor_TSS' OR cvterm.name = 'transcribed_spacer_region' OR cvterm.name = 'internal_transcribed_spacer_region' OR cvterm.name = 'external_transcribed_spacer_region' OR cvterm.name = 'intronic_splice_enhancer' OR cvterm.name = 'branch_site' OR cvterm.name = 'polypyrimidine_tract' OR cvterm.name = 'internal_guide_sequence' OR cvterm.name = 'mirtron' OR cvterm.name = 'pre_miRNA' OR cvterm.name = 'miRNA_stem' OR cvterm.name = 'miRNA_loop' OR cvterm.name = 'miRNA_antiguide' OR cvterm.name = 'noncoding_region_of_exon' OR cvterm.name = 'coding_region_of_exon' OR cvterm.name = 'three_prime_coding_exon_noncoding_region' OR cvterm.name = 'five_prime_coding_exon_noncoding_region' OR cvterm.name = 'five_prime_coding_exon_coding_region' OR cvterm.name = 'three_prime_coding_exon_coding_region' OR cvterm.name = 'mature_protein_region' OR cvterm.name = 'immature_peptide_region' OR cvterm.name = 'compositionally_biased_region_of_peptide' OR cvterm.name = 'polypeptide_structural_region' OR cvterm.name = 'polypeptide_variation_site' OR cvterm.name = 'peptide_localization_signal' OR cvterm.name = 'cleaved_peptide_region' OR cvterm.name = 'hydrophobic_region_of_peptide' OR cvterm.name = 'polypeptide_conserved_region' OR cvterm.name = 'active_peptide' OR cvterm.name = 'polypeptide_domain' OR cvterm.name = 'membrane_structure' OR cvterm.name = 'extramembrane_polypeptide_region' OR cvterm.name = 'intramembrane_polypeptide_region' OR cvterm.name = 'polypeptide_secondary_structure' OR cvterm.name = 'polypeptide_structural_motif' OR cvterm.name = 'intrinsically_unstructured_polypeptide_region' OR cvterm.name = 'cytoplasmic_polypeptide_region' OR cvterm.name = 'non_cytoplasmic_polypeptide_region' OR cvterm.name = 'membrane_peptide_loop' OR cvterm.name = 'transmembrane_polypeptide_region' OR cvterm.name = 'asx_motif' OR cvterm.name = 'beta_bulge' OR cvterm.name = 'beta_bulge_loop' OR cvterm.name = 'beta_strand' OR cvterm.name = 'peptide_helix' OR cvterm.name = 'polypeptide_nest_motif' OR cvterm.name = 'schellmann_loop' OR cvterm.name = 'serine_threonine_motif' OR cvterm.name = 'serine_threonine_staple_motif' OR cvterm.name = 'polypeptide_turn_motif' OR cvterm.name = 'catmat_left_handed_three' OR cvterm.name = 'catmat_left_handed_four' OR cvterm.name = 'catmat_right_handed_three' OR cvterm.name = 'catmat_right_handed_four' OR cvterm.name = 'alpha_beta_motif' OR cvterm.name = 'peptide_coil' OR cvterm.name = 'beta_bulge_loop_five' OR cvterm.name = 'beta_bulge_loop_six' OR cvterm.name = 'antiparallel_beta_strand' OR cvterm.name = 'parallel_beta_strand' OR cvterm.name = 'left_handed_peptide_helix' OR cvterm.name = 'right_handed_peptide_helix' OR cvterm.name = 'alpha_helix' OR cvterm.name = 'pi_helix' OR cvterm.name = 'three_ten_helix' OR cvterm.name = 'polypeptide_nest_left_right_motif' OR cvterm.name = 'polypeptide_nest_right_left_motif' OR cvterm.name = 'schellmann_loop_seven' OR cvterm.name = 'schellmann_loop_six' OR cvterm.name = 'asx_turn' OR cvterm.name = 'beta_turn' OR cvterm.name = 'gamma_turn' OR cvterm.name = 'serine_threonine_turn' OR cvterm.name = 'asx_turn_left_handed_type_one' OR cvterm.name = 'asx_turn_left_handed_type_two' OR cvterm.name = 'asx_turn_right_handed_type_two' OR cvterm.name = 'asx_turn_right_handed_type_one' OR cvterm.name = 'beta_turn_left_handed_type_one' OR cvterm.name = 'beta_turn_left_handed_type_two' OR cvterm.name = 'beta_turn_right_handed_type_one' OR cvterm.name = 'beta_turn_right_handed_type_two' OR cvterm.name = 'beta_turn_type_six' OR cvterm.name = 'beta_turn_type_eight' OR cvterm.name = 'beta_turn_type_six_a' OR cvterm.name = 'beta_turn_type_six_b' OR cvterm.name = 'beta_turn_type_six_a_one' OR cvterm.name = 'beta_turn_type_six_a_two' OR cvterm.name = 'gamma_turn_classic' OR cvterm.name = 'gamma_turn_inverse' OR cvterm.name = 'st_turn_left_handed_type_one' OR cvterm.name = 'st_turn_left_handed_type_two' OR cvterm.name = 'st_turn_right_handed_type_one' OR cvterm.name = 'st_turn_right_handed_type_two' OR cvterm.name = 'coiled_coil' OR cvterm.name = 'helix_turn_helix' OR cvterm.name = 'natural_variant_site' OR cvterm.name = 'mutated_variant_site' OR cvterm.name = 'alternate_sequence_site' OR cvterm.name = 'signal_peptide' OR cvterm.name = 'transit_peptide' OR cvterm.name = 'nuclear_localization_signal' OR cvterm.name = 'endosomal_localization_signal' OR cvterm.name = 'lysosomal_localization_signal' OR cvterm.name = 'nuclear_export_signal' OR cvterm.name = 'nuclear_rim_localization_signal' OR cvterm.name = 'cleaved_initiator_methionine' OR cvterm.name = 'intein' OR cvterm.name = 'propeptide_cleavage_site' OR cvterm.name = 'propeptide' OR cvterm.name = 'cleaved_for_gpi_anchor_region' OR cvterm.name = 'lipoprotein_signal_peptide' OR cvterm.name = 'n_terminal_region' OR cvterm.name = 'c_terminal_region' OR cvterm.name = 'central_hydrophobic_region_of_signal_peptide' OR cvterm.name = 'polypeptide_domain' OR cvterm.name = 'polypeptide_motif' OR cvterm.name = 'polypeptide_repeat' OR cvterm.name = 'biochemical_region_of_peptide' OR cvterm.name = 'polypeptide_conserved_motif' OR cvterm.name = 'post_translationally_modified_region' OR cvterm.name = 'conformational_switch' OR cvterm.name = 'molecular_contact_region' OR cvterm.name = 'polypeptide_binding_motif' OR cvterm.name = 'polypeptide_catalytic_motif' OR cvterm.name = 'histone_modification' OR cvterm.name = 'histone_methylation_site' OR cvterm.name = 'histone_acetylation_site' OR cvterm.name = 'histone_ubiqitination_site' OR cvterm.name = 'histone_acylation_region' OR cvterm.name = 'H4K20_monomethylation_site' OR cvterm.name = 'H2BK5_monomethylation_site' OR cvterm.name = 'H3K27_methylation_site' OR cvterm.name = 'H3K36_methylation_site' OR cvterm.name = 'H3K4_methylation_site' OR cvterm.name = 'H3K79_methylation_site' OR cvterm.name = 'H3K9_methylation_site' OR cvterm.name = 'H3K27_monomethylation_site' OR cvterm.name = 'H3K27_trimethylation_site' OR cvterm.name = 'H3K27_dimethylation_site' OR cvterm.name = 'H3K36_monomethylation_site' OR cvterm.name = 'H3K36_dimethylation_site' OR cvterm.name = 'H3K36_trimethylation_site' OR cvterm.name = 'H3K4_monomethylation_site' OR cvterm.name = 'H3K4_trimethylation' OR cvterm.name = 'H3K4_dimethylation_site' OR cvterm.name = 'H3K79_monomethylation_site' OR cvterm.name = 'H3K79_dimethylation_site' OR cvterm.name = 'H3K79_trimethylation_site' OR cvterm.name = 'H3K9_trimethylation_site' OR cvterm.name = 'H3K9_monomethylation_site' OR cvterm.name = 'H3K9_dimethylation_site' OR cvterm.name = 'H3K9_acetylation_site' OR cvterm.name = 'H3K14_acetylation_site' OR cvterm.name = 'H3K18_acetylation_site' OR cvterm.name = 'H3K23_acylation site' OR cvterm.name = 'H3K27_acylation_site' OR cvterm.name = 'H4K16_acylation_site' OR cvterm.name = 'H4K5_acylation_site' OR cvterm.name = 'H4K8_acylation site' OR cvterm.name = 'H2B_ubiquitination_site' OR cvterm.name = 'H4K_acylation_region' OR cvterm.name = 'polypeptide_metal_contact' OR cvterm.name = 'protein_protein_contact' OR cvterm.name = 'polypeptide_ligand_contact' OR cvterm.name = 'polypeptide_DNA_contact' OR cvterm.name = 'polypeptide_calcium_ion_contact_site' OR cvterm.name = 'polypeptide_cobalt_ion_contact_site' OR cvterm.name = 'polypeptide_copper_ion_contact_site' OR cvterm.name = 'polypeptide_iron_ion_contact_site' OR cvterm.name = 'polypeptide_magnesium_ion_contact_site' OR cvterm.name = 'polypeptide_manganese_ion_contact_site' OR cvterm.name = 'polypeptide_molybdenum_ion_contact_site' OR cvterm.name = 'polypeptide_nickel_ion_contact_site' OR cvterm.name = 'polypeptide_tungsten_ion_contact_site' OR cvterm.name = 'polypeptide_zinc_ion_contact_site' OR cvterm.name = 'non_transcribed_region' OR cvterm.name = 'gene_fragment' OR cvterm.name = 'TSS_region' OR cvterm.name = 'gene_segment' OR cvterm.name = 'pseudogenic_gene_segment' OR cvterm.name = 'mobile_intron' OR cvterm.name = 'extrachromosomal_mobile_genetic_element' OR cvterm.name = 'integrated_mobile_genetic_element' OR cvterm.name = 'natural_transposable_element' OR cvterm.name = 'viral_sequence' OR cvterm.name = 'natural_plasmid' OR cvterm.name = 'phage_sequence' OR cvterm.name = 'ds_RNA_viral_sequence' OR cvterm.name = 'ds_DNA_viral_sequence' OR cvterm.name = 'ss_RNA_viral_sequence' OR cvterm.name = 'negative_sense_ssRNA_viral_sequence' OR cvterm.name = 'positive_sense_ssRNA_viral_sequence' OR cvterm.name = 'ambisense_ssRNA_viral_sequence' OR cvterm.name = 'transposable_element' OR cvterm.name = 'proviral_region' OR cvterm.name = 'integron' OR cvterm.name = 'genomic_island' OR cvterm.name = 'integrated_plasmid' OR cvterm.name = 'cointegrated_plasmid' OR cvterm.name = 'retrotransposon' OR cvterm.name = 'DNA_transposon' OR cvterm.name = 'foreign_transposable_element' OR cvterm.name = 'transgenic_transposable_element' OR cvterm.name = 'natural_transposable_element' OR cvterm.name = 'engineered_transposable_element' OR cvterm.name = 'nested_transposon' OR cvterm.name = 'LTR_retrotransposon' OR cvterm.name = 'non_LTR_retrotransposon' OR cvterm.name = 'LINE_element' OR cvterm.name = 'SINE_element' OR cvterm.name = 'terminal_inverted_repeat_element' OR cvterm.name = 'foldback_element' OR cvterm.name = 'conjugative_transposon' OR cvterm.name = 'helitron' OR cvterm.name = 'p_element' OR cvterm.name = 'MITE' OR cvterm.name = 'insertion_sequence' OR cvterm.name = 'polinton' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'prophage' OR cvterm.name = 'pathogenic_island' OR cvterm.name = 'metabolic_island' OR cvterm.name = 'adaptive_island' OR cvterm.name = 'symbiosis_island' OR cvterm.name = 'cryptic_prophage' OR cvterm.name = 'defective_conjugative_transposon' OR cvterm.name = 'plasmid' OR cvterm.name = 'chromosome' OR cvterm.name = 'vector_replicon' OR cvterm.name = 'maxicircle' OR cvterm.name = 'minicircle' OR cvterm.name = 'viral_sequence' OR cvterm.name = 'engineered_plasmid' OR cvterm.name = 'episome' OR cvterm.name = 'natural_plasmid' OR cvterm.name = 'engineered_episome' OR cvterm.name = 'gene_trap_construct' OR cvterm.name = 'promoter_trap_construct' OR cvterm.name = 'enhancer_trap_construct' OR cvterm.name = 'engineered_episome' OR cvterm.name = 'mitochondrial_chromosome' OR cvterm.name = 'chloroplast_chromosome' OR cvterm.name = 'chromoplast_chromosome' OR cvterm.name = 'cyanelle_chromosome' OR cvterm.name = 'leucoplast_chromosome' OR cvterm.name = 'macronuclear_chromosome' OR cvterm.name = 'micronuclear_chromosome' OR cvterm.name = 'nuclear_chromosome' OR cvterm.name = 'nucleomorphic_chromosome' OR cvterm.name = 'DNA_chromosome' OR cvterm.name = 'RNA_chromosome' OR cvterm.name = 'apicoplast_chromosome' OR cvterm.name = 'double_stranded_DNA_chromosome' OR cvterm.name = 'single_stranded_DNA_chromosome' OR cvterm.name = 'linear_double_stranded_DNA_chromosome' OR cvterm.name = 'circular_double_stranded_DNA_chromosome' OR cvterm.name = 'linear_single_stranded_DNA_chromosome' OR cvterm.name = 'circular_single_stranded_DNA_chromosome' OR cvterm.name = 'single_stranded_RNA_chromosome' OR cvterm.name = 'double_stranded_RNA_chromosome' OR cvterm.name = 'linear_single_stranded_RNA_chromosome' OR cvterm.name = 'circular_single_stranded_RNA_chromosome' OR cvterm.name = 'linear_double_stranded_RNA_chromosome' OR cvterm.name = 'circular_double_stranded_RNA_chromosome' OR cvterm.name = 'YAC' OR cvterm.name = 'BAC' OR cvterm.name = 'PAC' OR cvterm.name = 'cosmid' OR cvterm.name = 'phagemid' OR cvterm.name = 'fosmid' OR cvterm.name = 'lambda_vector' OR cvterm.name = 'plasmid_vector' OR cvterm.name = 'targeting_vector' OR cvterm.name = 'phage_sequence' OR cvterm.name = 'ds_RNA_viral_sequence' OR cvterm.name = 'ds_DNA_viral_sequence' OR cvterm.name = 'ss_RNA_viral_sequence' OR cvterm.name = 'negative_sense_ssRNA_viral_sequence' OR cvterm.name = 'positive_sense_ssRNA_viral_sequence' OR cvterm.name = 'ambisense_ssRNA_viral_sequence' OR cvterm.name = 'modified_RNA_base_feature' OR cvterm.name = 'inosine' OR cvterm.name = 'seven_methylguanine' OR cvterm.name = 'ribothymidine' OR cvterm.name = 'modified_adenosine' OR cvterm.name = 'modified_cytidine' OR cvterm.name = 'modified_guanosine' OR cvterm.name = 'modified_uridine' OR cvterm.name = 'modified_inosine' OR cvterm.name = 'methylinosine' OR cvterm.name = 'one_methylinosine' OR cvterm.name = 'one_two_prime_O_dimethylinosine' OR cvterm.name = 'two_prime_O_methylinosine' OR cvterm.name = 'one_methyladenosine' OR cvterm.name = 'two_methyladenosine' OR cvterm.name = 'N6_methyladenosine' OR cvterm.name = 'two_prime_O_methyladenosine' OR cvterm.name = 'two_methylthio_N6_methyladenosine' OR cvterm.name = 'N6_isopentenyladenosine' OR cvterm.name = 'two_methylthio_N6_isopentenyladenosine' OR cvterm.name = 'N6_cis_hydroxyisopentenyl_adenosine' OR cvterm.name = 'two_methylthio_N6_cis_hydroxyisopentenyl_adenosine' OR cvterm.name = 'N6_glycinylcarbamoyladenosine' OR cvterm.name = 'N6_threonylcarbamoyladenosine' OR cvterm.name = 'two_methylthio_N6_threonyl_carbamoyladenosine' OR cvterm.name = 'N6_methyl_N6_threonylcarbamoyladenosine' OR cvterm.name = 'N6_hydroxynorvalylcarbamoyladenosine' OR cvterm.name = 'two_methylthio_N6_hydroxynorvalyl_carbamoyladenosine' OR cvterm.name = 'two_prime_O_ribosyladenosine_phosphate' OR cvterm.name = 'N6_N6_dimethyladenosine' OR cvterm.name = 'N6_2_prime_O_dimethyladenosine' OR cvterm.name = 'N6_N6_2_prime_O_trimethyladenosine' OR cvterm.name = 'one_two_prime_O_dimethyladenosine' OR cvterm.name = 'N6_acetyladenosine' OR cvterm.name = 'three_methylcytidine' OR cvterm.name = 'five_methylcytidine' OR cvterm.name = 'two_prime_O_methylcytidine' OR cvterm.name = 'two_thiocytidine' OR cvterm.name = 'N4_acetylcytidine' OR cvterm.name = 'five_formylcytidine' OR cvterm.name = 'five_two_prime_O_dimethylcytidine' OR cvterm.name = 'N4_acetyl_2_prime_O_methylcytidine' OR cvterm.name = 'lysidine' OR cvterm.name = 'N4_methylcytidine' OR cvterm.name = 'N4_2_prime_O_dimethylcytidine' OR cvterm.name = 'five_hydroxymethylcytidine' OR cvterm.name = 'five_formyl_two_prime_O_methylcytidine' OR cvterm.name = 'N4_N4_2_prime_O_trimethylcytidine' OR cvterm.name = 'seven_deazaguanosine' OR cvterm.name = 'one_methylguanosine' OR cvterm.name = 'N2_methylguanosine' OR cvterm.name = 'seven_methylguanosine' OR cvterm.name = 'two_prime_O_methylguanosine' OR cvterm.name = 'N2_N2_dimethylguanosine' OR cvterm.name = 'N2_2_prime_O_dimethylguanosine' OR cvterm.name = 'N2_N2_2_prime_O_trimethylguanosine' OR cvterm.name = 'two_prime_O_ribosylguanosine_phosphate' OR cvterm.name = 'wybutosine' OR cvterm.name = 'peroxywybutosine' OR cvterm.name = 'hydroxywybutosine' OR cvterm.name = 'undermodified_hydroxywybutosine' OR cvterm.name = 'wyosine' OR cvterm.name = 'methylwyosine' OR cvterm.name = 'N2_7_dimethylguanosine' OR cvterm.name = 'N2_N2_7_trimethylguanosine' OR cvterm.name = 'one_two_prime_O_dimethylguanosine' OR cvterm.name = 'four_demethylwyosine' OR cvterm.name = 'isowyosine' OR cvterm.name = 'N2_7_2prirme_O_trimethylguanosine' OR cvterm.name = 'queuosine' OR cvterm.name = 'epoxyqueuosine' OR cvterm.name = 'galactosyl_queuosine' OR cvterm.name = 'mannosyl_queuosine' OR cvterm.name = 'seven_cyano_seven_deazaguanosine' OR cvterm.name = 'seven_aminomethyl_seven_deazaguanosine' OR cvterm.name = 'archaeosine' OR cvterm.name = 'dihydrouridine' OR cvterm.name = 'pseudouridine' OR cvterm.name = 'five_methyluridine' OR cvterm.name = 'two_prime_O_methyluridine' OR cvterm.name = 'five_two_prime_O_dimethyluridine' OR cvterm.name = 'one_methylpseudouridine' OR cvterm.name = 'two_prime_O_methylpseudouridine' OR cvterm.name = 'two_thiouridine' OR cvterm.name = 'four_thiouridine' OR cvterm.name = 'five_methyl_2_thiouridine' OR cvterm.name = 'two_thio_two_prime_O_methyluridine' OR cvterm.name = 'three_three_amino_three_carboxypropyl_uridine' OR cvterm.name = 'five_hydroxyuridine' OR cvterm.name = 'five_methoxyuridine' OR cvterm.name = 'uridine_five_oxyacetic_acid' OR cvterm.name = 'uridine_five_oxyacetic_acid_methyl_ester' OR cvterm.name = 'five_carboxyhydroxymethyl_uridine' OR cvterm.name = 'five_carboxyhydroxymethyl_uridine_methyl_ester' OR cvterm.name = 'five_methoxycarbonylmethyluridine' OR cvterm.name = 'five_methoxycarbonylmethyl_two_prime_O_methyluridine' OR cvterm.name = 'five_methoxycarbonylmethyl_two_thiouridine' OR cvterm.name = 'five_aminomethyl_two_thiouridine' OR cvterm.name = 'five_methylaminomethyluridine' OR cvterm.name = 'five_methylaminomethyl_two_thiouridine' OR cvterm.name = 'five_methylaminomethyl_two_selenouridine' OR cvterm.name = 'five_carbamoylmethyluridine' OR cvterm.name = 'five_carbamoylmethyl_two_prime_O_methyluridine' OR cvterm.name = 'five_carboxymethylaminomethyluridine' OR cvterm.name = 'five_carboxymethylaminomethyl_two_prime_O_methyluridine' OR cvterm.name = 'five_carboxymethylaminomethyl_two_thiouridine' OR cvterm.name = 'three_methyluridine' OR cvterm.name = 'one_methyl_three_three_amino_three_carboxypropyl_pseudouridine' OR cvterm.name = 'five_carboxymethyluridine' OR cvterm.name = 'three_two_prime_O_dimethyluridine' OR cvterm.name = 'five_methyldihydrouridine' OR cvterm.name = 'three_methylpseudouridine' OR cvterm.name = 'five_taurinomethyluridine' OR cvterm.name = 'five_taurinomethyl_two_thiouridine' OR cvterm.name = 'five_isopentenylaminomethyl_uridine' OR cvterm.name = 'five_isopentenylaminomethyl_two_thiouridine' OR cvterm.name = 'five_isopentenylaminomethyl_two_prime_O_methyluridine' OR cvterm.name = 'catalytic_residue' OR cvterm.name = 'modified_amino_acid_feature' OR cvterm.name = 'alanine' OR cvterm.name = 'valine' OR cvterm.name = 'leucine' OR cvterm.name = 'isoleucine' OR cvterm.name = 'proline' OR cvterm.name = 'tryptophan' OR cvterm.name = 'phenylalanine' OR cvterm.name = 'methionine' OR cvterm.name = 'glycine' OR cvterm.name = 'serine' OR cvterm.name = 'threonine' OR cvterm.name = 'tyrosine' OR cvterm.name = 'cysteine' OR cvterm.name = 'glutamine' OR cvterm.name = 'asparagine' OR cvterm.name = 'lysine' OR cvterm.name = 'arginine' OR cvterm.name = 'histidine' OR cvterm.name = 'aspartic_acid' OR cvterm.name = 'glutamic_acid' OR cvterm.name = 'selenocysteine' OR cvterm.name = 'pyrrolysine' OR cvterm.name = 'modified_glycine' OR cvterm.name = 'modified_L_alanine' OR cvterm.name = 'modified_L_asparagine' OR cvterm.name = 'modified_L_aspartic_acid' OR cvterm.name = 'modified_L_cysteine' OR cvterm.name = 'modified_L_glutamic_acid' OR cvterm.name = 'modified_L_threonine' OR cvterm.name = 'modified_L_tryptophan' OR cvterm.name = 'modified_L_glutamine' OR cvterm.name = 'modified_L_methionine' OR cvterm.name = 'modified_L_isoleucine' OR cvterm.name = 'modified_L_phenylalanine' OR cvterm.name = 'modified_L_histidine' OR cvterm.name = 'modified_L_serine' OR cvterm.name = 'modified_L_lysine' OR cvterm.name = 'modified_L_leucine' OR cvterm.name = 'modified_L_selenocysteine' OR cvterm.name = 'modified_L_valine' OR cvterm.name = 'modified_L_proline' OR cvterm.name = 'modified_L_tyrosine' OR cvterm.name = 'modified_L_arginine' OR cvterm.name = 'heritable_phenotypic_marker' OR cvterm.name = 'DArT_marker' OR cvterm.name = 'nucleotide_motif' OR cvterm.name = 'DNA_motif' OR cvterm.name = 'RNA_motif' OR cvterm.name = 'PSE_motif' OR cvterm.name = 'CAAT_signal' OR cvterm.name = 'minus_10_signal' OR cvterm.name = 'minus_35_signal' OR cvterm.name = 'DRE_motif' OR cvterm.name = 'E_box_motif' OR cvterm.name = 'INR1_motif' OR cvterm.name = 'GAGA_motif' OR cvterm.name = 'octamer_motif' OR cvterm.name = 'retinoic_acid_responsive_element' OR cvterm.name = 'promoter_element' OR cvterm.name = 'DCE_SI' OR cvterm.name = 'DCE_SII' OR cvterm.name = 'DCE_SIII' OR cvterm.name = 'minus_12_signal' OR cvterm.name = 'minus_24_signal' OR cvterm.name = 'GC_rich_promoter_region' OR cvterm.name = 'DMv4_motif' OR cvterm.name = 'DMv5_motif' OR cvterm.name = 'DMv3_motif' OR cvterm.name = 'DMv2_motif' OR cvterm.name = 'DPE1_motif' OR cvterm.name = 'DMv1_motif' OR cvterm.name = 'NDM2_motif' OR cvterm.name = 'NDM3_motif' OR cvterm.name = 'core_promoter_element' OR cvterm.name = 'regulatory_promoter_element' OR cvterm.name = 'INR_motif' OR cvterm.name = 'DPE_motif' OR cvterm.name = 'BREu_motif' OR cvterm.name = 'TATA_box' OR cvterm.name = 'A_box' OR cvterm.name = 'B_box' OR cvterm.name = 'C_box' OR cvterm.name = 'MTE' OR cvterm.name = 'BREd_motif' OR cvterm.name = 'DCE' OR cvterm.name = 'intermediate_element' OR cvterm.name = 'RNA_polymerase_II_TATA_box' OR cvterm.name = 'RNA_polymerase_III_TATA_box' OR cvterm.name = 'A_box_type_1' OR cvterm.name = 'A_box_type_2' OR cvterm.name = 'proximal_promoter_element' OR cvterm.name = 'distal_promoter_element' OR cvterm.name = 'RNA_internal_loop' OR cvterm.name = 'A_minor_RNA_motif' OR cvterm.name = 'RNA_junction_loop' OR cvterm.name = 'hammerhead_ribozyme' OR cvterm.name = 'asymmetric_RNA_internal_loop' OR cvterm.name = 'symmetric_RNA_internal_loop' OR cvterm.name = 'K_turn_RNA_motif' OR cvterm.name = 'sarcin_like_RNA_motif' OR cvterm.name = 'RNA_hook_turn' OR cvterm.name = 'blunt_end_restriction_enzyme_cleavage_site' OR cvterm.name = 'sticky_end_restriction_enzyme_cleavage_site' OR cvterm.name = 'modified_base' OR cvterm.name = 'epigenetically_modified_gene' OR cvterm.name = 'histone_modification' OR cvterm.name = 'methylated_base_feature' OR cvterm.name = 'methylated_C' OR cvterm.name = 'methylated_A' OR cvterm.name = 'gene_rearranged_at_DNA_level' OR cvterm.name = 'maternally_imprinted_gene' OR cvterm.name = 'paternally_imprinted_gene' OR cvterm.name = 'allelically_excluded_gene' OR cvterm.name = 'histone_methylation_site' OR cvterm.name = 'histone_acetylation_site' OR cvterm.name = 'histone_ubiqitination_site' OR cvterm.name = 'histone_acylation_region' OR cvterm.name = 'H4K20_monomethylation_site' OR cvterm.name = 'H2BK5_monomethylation_site' OR cvterm.name = 'H3K27_methylation_site' OR cvterm.name = 'H3K36_methylation_site' OR cvterm.name = 'H3K4_methylation_site' OR cvterm.name = 'H3K79_methylation_site' OR cvterm.name = 'H3K9_methylation_site' OR cvterm.name = 'H3K27_monomethylation_site' OR cvterm.name = 'H3K27_trimethylation_site' OR cvterm.name = 'H3K27_dimethylation_site' OR cvterm.name = 'H3K36_monomethylation_site' OR cvterm.name = 'H3K36_dimethylation_site' OR cvterm.name = 'H3K36_trimethylation_site' OR cvterm.name = 'H3K4_monomethylation_site' OR cvterm.name = 'H3K4_trimethylation' OR cvterm.name = 'H3K4_dimethylation_site' OR cvterm.name = 'H3K79_monomethylation_site' OR cvterm.name = 'H3K79_dimethylation_site' OR cvterm.name = 'H3K79_trimethylation_site' OR cvterm.name = 'H3K9_trimethylation_site' OR cvterm.name = 'H3K9_monomethylation_site' OR cvterm.name = 'H3K9_dimethylation_site' OR cvterm.name = 'H3K9_acetylation_site' OR cvterm.name = 'H3K14_acetylation_site' OR cvterm.name = 'H3K18_acetylation_site' OR cvterm.name = 'H3K23_acylation site' OR cvterm.name = 'H3K27_acylation_site' OR cvterm.name = 'H4K16_acylation_site' OR cvterm.name = 'H4K5_acylation_site' OR cvterm.name = 'H4K8_acylation site' OR cvterm.name = 'H2B_ubiquitination_site' OR cvterm.name = 'H4K_acylation_region' OR cvterm.name = 'operon' OR cvterm.name = 'mating_type_region' OR cvterm.name = 'gene_array' OR cvterm.name = 'gene_subarray' OR cvterm.name = 'gene_cassette_array' OR cvterm.name = 'regulon' OR cvterm.name = 'sequence_length_variation' OR cvterm.name = 'MNP' OR cvterm.name = 'SNV' OR cvterm.name = 'complex_substitution' OR cvterm.name = 'simple_sequence_length_variation' OR cvterm.name = 'SNP' OR cvterm.name = 'point_mutation' OR cvterm.name = 'transition' OR cvterm.name = 'transversion' OR cvterm.name = 'pyrimidine_transition' OR cvterm.name = 'purine_transition' OR cvterm.name = 'C_to_T_transition' OR cvterm.name = 'T_to_C_transition' OR cvterm.name = 'C_to_T_transition_at_pCpG_site' OR cvterm.name = 'A_to_G_transition' OR cvterm.name = 'G_to_A_transition' OR cvterm.name = 'pyrimidine_to_purine_transversion' OR cvterm.name = 'purine_to_pyrimidine_transversion' OR cvterm.name = 'C_to_A_transversion' OR cvterm.name = 'C_to_G_transversion' OR cvterm.name = 'T_to_A_transversion' OR cvterm.name = 'T_to_G_transversion' OR cvterm.name = 'A_to_C_transversion' OR cvterm.name = 'A_to_T_transversion' OR cvterm.name = 'G_to_C_transversion' OR cvterm.name = 'G_to_T_transversion' OR cvterm.name = 'flanking_region' OR cvterm.name = 'repeat_component' OR cvterm.name = 'transposable_element_flanking_region' OR cvterm.name = 'five_prime_flanking_region' OR cvterm.name = 'three_prime_flanking_region' OR cvterm.name = 'non_LTR_retrotransposon_polymeric_tract' OR cvterm.name = 'LTR_component' OR cvterm.name = 'repeat_fragment' OR cvterm.name = 'transposon_fragment' OR cvterm.name = 'U5_LTR_region' OR cvterm.name = 'R_LTR_region' OR cvterm.name = 'U3_LTR_region' OR cvterm.name = 'three_prime_LTR_component' OR cvterm.name = 'five_prime_LTR_component' OR cvterm.name = 'U5_five_prime_LTR_region' OR cvterm.name = 'R_five_prime_LTR_region' OR cvterm.name = 'U3_five_prime_LTR_region' OR cvterm.name = 'R_three_prime_LTR_region' OR cvterm.name = 'U3_three_prime_LTR_region' OR cvterm.name = 'U5_three_prime_LTR_region' OR cvterm.name = 'R_five_prime_LTR_region' OR cvterm.name = 'U5_five_prime_LTR_region' OR cvterm.name = 'U3_five_prime_LTR_region' OR cvterm.name = 'clone_insert_end' OR cvterm.name = 'clone_insert_start' OR cvterm.name = 'exon_junction' OR cvterm.name = 'insertion_site' OR cvterm.name = 'polyA_site' OR cvterm.name = 'deletion_junction' OR cvterm.name = 'chromosome_breakpoint' OR cvterm.name = 'splice_junction' OR cvterm.name = 'trans_splice_junction' OR cvterm.name = 'restriction_enzyme_cleavage_junction' OR cvterm.name = 'transposable_element_insertion_site' OR cvterm.name = 'inversion_breakpoint' OR cvterm.name = 'translocation_breakpoint' OR cvterm.name = 'insertion_breakpoint' OR cvterm.name = 'deletion_breakpoint' OR cvterm.name = 'blunt_end_restriction_enzyme_cleavage_junction' OR cvterm.name = 'single_strand_restriction_enzyme_cleavage_site' OR cvterm.name = 'five_prime_restriction_enzyme_junction' OR cvterm.name = 'three_prime_restriction_enzyme_junction' OR cvterm.name = 'deletion' OR cvterm.name = 'translocation' OR cvterm.name = 'insertion' OR cvterm.name = 'copy_number_variation' OR cvterm.name = 'UPD' OR cvterm.name = 'structural_alteration' OR cvterm.name = 'substitution' OR cvterm.name = 'indel' OR cvterm.name = 'inversion' OR cvterm.name = 'transgenic_insertion' OR cvterm.name = 'duplication' OR cvterm.name = 'tandem_duplication' OR cvterm.name = 'direct_tandem_duplication' OR cvterm.name = 'inverted_tandem_duplication' OR cvterm.name = 'copy_number_gain' OR cvterm.name = 'copy_number_loss' OR cvterm.name = 'maternal_uniparental_disomy' OR cvterm.name = 'paternal_uniparental_disomy' OR cvterm.name = 'complex_structural_alteration' OR cvterm.name = 'sequence_length_variation' OR cvterm.name = 'MNP' OR cvterm.name = 'SNV' OR cvterm.name = 'complex_substitution' OR cvterm.name = 'simple_sequence_length_variation' OR cvterm.name = 'SNP' OR cvterm.name = 'point_mutation' OR cvterm.name = 'transition' OR cvterm.name = 'transversion' OR cvterm.name = 'pyrimidine_transition' OR cvterm.name = 'purine_transition' OR cvterm.name = 'C_to_T_transition' OR cvterm.name = 'T_to_C_transition' OR cvterm.name = 'C_to_T_transition_at_pCpG_site' OR cvterm.name = 'A_to_G_transition' OR cvterm.name = 'G_to_A_transition' OR cvterm.name = 'pyrimidine_to_purine_transversion' OR cvterm.name = 'purine_to_pyrimidine_transversion' OR cvterm.name = 'C_to_A_transversion' OR cvterm.name = 'C_to_G_transversion' OR cvterm.name = 'T_to_A_transversion' OR cvterm.name = 'T_to_G_transversion' OR cvterm.name = 'A_to_C_transversion' OR cvterm.name = 'A_to_T_transversion' OR cvterm.name = 'G_to_C_transversion' OR cvterm.name = 'G_to_T_transversion' OR cvterm.name = 'sequence_feature';

--- ************************************************
--- *** relation: transposable_element_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene encoded within a transposable ele ***
--- *** ment. For example gag, int, env and pol  ***
--- *** are the transposable element genes of th ***
--- *** e TY element in yeast.                   ***
--- ************************************************
---

CREATE VIEW transposable_element_gene AS
  SELECT
    feature_id AS transposable_element_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'transposable_element_gene';

--- ************************************************
--- *** relation: primer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An oligo to which new deoxyribonucleotid ***
--- *** es can be added by DNA polymerase.       ***
--- ************************************************
---

CREATE VIEW primer AS
  SELECT
    feature_id AS primer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'sequencing_primer' OR cvterm.name = 'forward_primer' OR cvterm.name = 'reverse_primer' OR cvterm.name = 'ASPE_primer' OR cvterm.name = 'dCAPS_primer' OR cvterm.name = 'primer';

--- ************************************************
--- *** relation: proviral_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A viral sequence which has integrated in ***
--- *** to a host genome.                        ***
--- ************************************************
---

CREATE VIEW proviral_region AS
  SELECT
    feature_id AS proviral_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'prophage' OR cvterm.name = 'proviral_region';

--- ************************************************
--- *** relation: methylated_c ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A methylated deoxy-cytosine.             ***
--- ************************************************
---

CREATE VIEW methylated_c AS
  SELECT
    feature_id AS methylated_c_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'methylated_C';

--- ************************************************
--- *** relation: edited ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence that  ***
--- *** is modified by editing.                  ***
--- ************************************************
---

CREATE VIEW edited AS
  SELECT
    feature_id AS edited_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'edited';

--- ************************************************
--- *** relation: transcript_with_translational_frameshift ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transcript with a translational frames ***
--- *** hift.                                    ***
--- ************************************************
---

CREATE VIEW transcript_with_translational_frameshift AS
  SELECT
    feature_id AS transcript_with_translational_frameshift_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transcript_with_translational_frameshift';

--- ************************************************
--- *** relation: regulated ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a sequence that ***
--- ***  is regulated.                           ***
--- ************************************************
---

CREATE VIEW regulated AS
  SELECT
    feature_id AS regulated_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transcriptionally_regulated' OR cvterm.name = 'post_translationally_regulated' OR cvterm.name = 'translationally_regulated' OR cvterm.name = 'imprinted' OR cvterm.name = 'transcriptionally_constitutive' OR cvterm.name = 'transcriptionally_induced' OR cvterm.name = 'transcriptionally_repressed' OR cvterm.name = 'autoregulated' OR cvterm.name = 'positively_autoregulated' OR cvterm.name = 'negatively_autoregulated' OR cvterm.name = 'silenced' OR cvterm.name = 'silenced_by_DNA_modification' OR cvterm.name = 'silenced_by_RNA_interference' OR cvterm.name = 'silenced_by_histone_modification' OR cvterm.name = 'silenced_by_DNA_methylation' OR cvterm.name = 'silenced_by_histone_methylation' OR cvterm.name = 'silenced_by_histone_deacetylation' OR cvterm.name = 'negatively_autoregulated' OR cvterm.name = 'positively_autoregulated' OR cvterm.name = 'post_translationally_regulated_by_protein_stability' OR cvterm.name = 'post_translationally_regulated_by_protein_modification' OR cvterm.name = 'maternally_imprinted' OR cvterm.name = 'paternally_imprinted' OR cvterm.name = 'regulated';

--- ************************************************
--- *** relation: protein_coding_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript that, at least in p ***
--- *** art, encodes one or more proteins.       ***
--- ************************************************
---

CREATE VIEW protein_coding_primary_transcript AS
  SELECT
    feature_id AS protein_coding_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pre_edited_mRNA' OR cvterm.name = 'protein_coding_primary_transcript';

--- ************************************************
--- *** relation: forward_primer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A single stranded oligo used for polymer ***
--- *** ase chain reaction.                      ***
--- ************************************************
---

CREATE VIEW forward_primer AS
  SELECT
    feature_id AS forward_primer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'forward_primer';

--- ************************************************
--- *** relation: rna_sequence_secondary_structure ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A folded RNA sequence.                   ***
--- ************************************************
---

CREATE VIEW rna_sequence_secondary_structure AS
  SELECT
    feature_id AS rna_sequence_secondary_structure_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'stem_loop' OR cvterm.name = 'tetraloop' OR cvterm.name = 'RNA_sequence_secondary_structure';

--- ************************************************
--- *** relation: transcriptionally_regulated ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a gene that is r ***
--- *** egulated at transcription.               ***
--- ************************************************
---

CREATE VIEW transcriptionally_regulated AS
  SELECT
    feature_id AS transcriptionally_regulated_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transcriptionally_constitutive' OR cvterm.name = 'transcriptionally_induced' OR cvterm.name = 'transcriptionally_repressed' OR cvterm.name = 'autoregulated' OR cvterm.name = 'positively_autoregulated' OR cvterm.name = 'negatively_autoregulated' OR cvterm.name = 'silenced' OR cvterm.name = 'silenced_by_DNA_modification' OR cvterm.name = 'silenced_by_RNA_interference' OR cvterm.name = 'silenced_by_histone_modification' OR cvterm.name = 'silenced_by_DNA_methylation' OR cvterm.name = 'silenced_by_histone_methylation' OR cvterm.name = 'silenced_by_histone_deacetylation' OR cvterm.name = 'negatively_autoregulated' OR cvterm.name = 'positively_autoregulated' OR cvterm.name = 'transcriptionally_regulated';

--- ************************************************
--- *** relation: transcriptionally_constitutive ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Expressed in relatively constant amounts ***
--- ***  without regard to cellular environmenta ***
--- *** l conditions such as the concentration o ***
--- *** f a particular substrate.                ***
--- ************************************************
---

CREATE VIEW transcriptionally_constitutive AS
  SELECT
    feature_id AS transcriptionally_constitutive_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transcriptionally_constitutive';

--- ************************************************
--- *** relation: transcriptionally_induced ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An inducer molecule is required for tran ***
--- *** scription to occur.                      ***
--- ************************************************
---

CREATE VIEW transcriptionally_induced AS
  SELECT
    feature_id AS transcriptionally_induced_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'positively_autoregulated' OR cvterm.name = 'transcriptionally_induced';

--- ************************************************
--- *** relation: transcriptionally_repressed ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A repressor molecule is required for tra ***
--- *** nscription to stop.                      ***
--- ************************************************
---

CREATE VIEW transcriptionally_repressed AS
  SELECT
    feature_id AS transcriptionally_repressed_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'negatively_autoregulated' OR cvterm.name = 'silenced' OR cvterm.name = 'silenced_by_DNA_modification' OR cvterm.name = 'silenced_by_RNA_interference' OR cvterm.name = 'silenced_by_histone_modification' OR cvterm.name = 'silenced_by_DNA_methylation' OR cvterm.name = 'silenced_by_histone_methylation' OR cvterm.name = 'silenced_by_histone_deacetylation' OR cvterm.name = 'transcriptionally_repressed';

--- ************************************************
--- *** relation: silenced_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that is silenced.                 ***
--- ************************************************
---

CREATE VIEW silenced_gene AS
  SELECT
    feature_id AS silenced_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_silenced_by_DNA_modification' OR cvterm.name = 'gene_silenced_by_RNA_interference' OR cvterm.name = 'gene_silenced_by_histone_modification' OR cvterm.name = 'gene_silenced_by_DNA_methylation' OR cvterm.name = 'gene_silenced_by_histone_methylation' OR cvterm.name = 'gene_silenced_by_histone_deacetylation' OR cvterm.name = 'silenced_gene';

--- ************************************************
--- *** relation: gene_silenced_by_dna_modification ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that is silenced by DNA modificat ***
--- *** ion.                                     ***
--- ************************************************
---

CREATE VIEW gene_silenced_by_dna_modification AS
  SELECT
    feature_id AS gene_silenced_by_dna_modification_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_silenced_by_DNA_methylation' OR cvterm.name = 'gene_silenced_by_DNA_modification';

--- ************************************************
--- *** relation: gene_silenced_by_dna_methylation ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that is silenced by DNA methylati ***
--- *** on.                                      ***
--- ************************************************
---

CREATE VIEW gene_silenced_by_dna_methylation AS
  SELECT
    feature_id AS gene_silenced_by_dna_methylation_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_silenced_by_DNA_methylation';

--- ************************************************
--- *** relation: post_translationally_regulated ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a gene that is r ***
--- *** egulated after it has been translated.   ***
--- ************************************************
---

CREATE VIEW post_translationally_regulated AS
  SELECT
    feature_id AS post_translationally_regulated_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'post_translationally_regulated_by_protein_stability' OR cvterm.name = 'post_translationally_regulated_by_protein_modification' OR cvterm.name = 'post_translationally_regulated';

--- ************************************************
--- *** relation: translationally_regulated ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a gene that is r ***
--- *** egulated as it is translated.            ***
--- ************************************************
---

CREATE VIEW translationally_regulated AS
  SELECT
    feature_id AS translationally_regulated_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'translationally_regulated';

--- ************************************************
--- *** relation: reverse_primer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A single stranded oligo used for polymer ***
--- *** ase chain reaction.                      ***
--- ************************************************
---

CREATE VIEW reverse_primer AS
  SELECT
    feature_id AS reverse_primer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'reverse_primer';

--- ************************************************
--- *** relation: epigenetically_modified ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** This attribute describes a gene where he ***
--- *** ritable changes other than those in the  ***
--- *** DNA sequence occur. These changes includ ***
--- *** e: modification to the DNA (such as DNA  ***
--- *** methylation, the covalent modification o ***
--- *** f cytosine), and post-translational modi ***
--- *** fication of histones.                    ***
--- ************************************************
---

CREATE VIEW epigenetically_modified AS
  SELECT
    feature_id AS epigenetically_modified_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'imprinted' OR cvterm.name = 'allelically_excluded' OR cvterm.name = 'rearranged_at_DNA_level' OR cvterm.name = 'maternally_imprinted' OR cvterm.name = 'paternally_imprinted' OR cvterm.name = 'epigenetically_modified';

--- ************************************************
--- *** relation: imprinted ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Imprinted genes are epigenetically modif ***
--- *** ied genes that are expressed monoallelic ***
--- *** ally according to their parent of origin ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW imprinted AS
  SELECT
    feature_id AS imprinted_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'maternally_imprinted' OR cvterm.name = 'paternally_imprinted' OR cvterm.name = 'imprinted';

--- ************************************************
--- *** relation: maternally_imprinted ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The maternal copy of the gene is modifie ***
--- *** d, rendering it transcriptionally silent ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW maternally_imprinted AS
  SELECT
    feature_id AS maternally_imprinted_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'maternally_imprinted';

--- ************************************************
--- *** relation: paternally_imprinted ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The paternal copy of the gene is modifie ***
--- *** d, rendering it transcriptionally silent ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW paternally_imprinted AS
  SELECT
    feature_id AS paternally_imprinted_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'paternally_imprinted';

--- ************************************************
--- *** relation: allelically_excluded ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Allelic exclusion is a process occurring ***
--- ***  in diploid organisms, where a gene is i ***
--- *** nactivated and not expressed in that cel ***
--- *** l.                                       ***
--- ************************************************
---

CREATE VIEW allelically_excluded AS
  SELECT
    feature_id AS allelically_excluded_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'allelically_excluded';

--- ************************************************
--- *** relation: gene_rearranged_at_dna_level ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An epigenetically modified gene, rearran ***
--- *** ged at the DNA level.                    ***
--- ************************************************
---

CREATE VIEW gene_rearranged_at_dna_level AS
  SELECT
    feature_id AS gene_rearranged_at_dna_level_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_rearranged_at_DNA_level';

--- ************************************************
--- *** relation: ribosome_entry_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Region in mRNA where ribosome assembles. ***
--- ************************************************
---

CREATE VIEW ribosome_entry_site AS
  SELECT
    feature_id AS ribosome_entry_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'internal_ribosome_entry_site' OR cvterm.name = 'Shine_Dalgarno_sequence' OR cvterm.name = 'kozak_sequence' OR cvterm.name = 'internal_Shine_Dalgarno_sequence' OR cvterm.name = 'ribosome_entry_site';

--- ************************************************
--- *** relation: attenuator ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence segment located within the fi ***
--- *** ve prime end of an mRNA that causes prem ***
--- *** ature termination of translation.        ***
--- ************************************************
---

CREATE VIEW attenuator AS
  SELECT
    feature_id AS attenuator_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'attenuator';

--- ************************************************
--- *** relation: terminator ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The sequence of DNA located either at th ***
--- *** e end of the transcript that causes RNA  ***
--- *** polymerase to terminate transcription.   ***
--- ************************************************
---

CREATE VIEW terminator AS
  SELECT
    feature_id AS terminator_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'bacterial_terminator' OR cvterm.name = 'eukaryotic_terminator' OR cvterm.name = 'rho_dependent_bacterial_terminator' OR cvterm.name = 'rho_independent_bacterial_terminator' OR cvterm.name = 'terminator_of_type_2_RNApol_III_promoter' OR cvterm.name = 'terminator';

--- ************************************************
--- *** relation: dna_sequence_secondary_structure ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A folded DNA sequence.                   ***
--- ************************************************
---

CREATE VIEW dna_sequence_secondary_structure AS
  SELECT
    feature_id AS dna_sequence_secondary_structure_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'i_motif' OR cvterm.name = 'DNA_sequence_secondary_structure';

--- ************************************************
--- *** relation: assembly_component ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of known length which may be us ***
--- *** ed to manufacture a longer region.       ***
--- ************************************************
---

CREATE VIEW assembly_component AS
  SELECT
    feature_id AS assembly_component_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'contig' OR cvterm.name = 'read' OR cvterm.name = 'restriction_fragment' OR cvterm.name = 'golden_path_fragment' OR cvterm.name = 'tiling_path_fragment' OR cvterm.name = 'gap' OR cvterm.name = 'sonicate_fragment' OR cvterm.name = 'paired_end_fragment' OR cvterm.name = 'read_pair' OR cvterm.name = 'contig_read' OR cvterm.name = 'BAC_end' OR cvterm.name = 'dye_terminator_read' OR cvterm.name = 'pyrosequenced_read' OR cvterm.name = 'ligation_based_read' OR cvterm.name = 'polymerase_synthesis_read' OR cvterm.name = 'PAC_end' OR cvterm.name = 'YAC_end' OR cvterm.name = 'clone_end' OR cvterm.name = 'RFLP_fragment' OR cvterm.name = 'tiling_path_clone' OR cvterm.name = 'assembly_component';

--- ************************************************
--- *** relation: recoded_codon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A codon that has been redefined at trans ***
--- *** lation. The redefinition may be as a res ***
--- *** ult of translational bypass, translation ***
--- *** al frameshifting or stop codon readthrou ***
--- *** gh.                                      ***
--- ************************************************
---

CREATE VIEW recoded_codon AS
  SELECT
    feature_id AS recoded_codon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'stop_codon_read_through' OR cvterm.name = 'stop_codon_redefined_as_pyrrolysine' OR cvterm.name = 'stop_codon_redefined_as_selenocysteine' OR cvterm.name = 'recoded_codon';

--- ************************************************
--- *** relation: capped ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing when a sequence, ***
--- ***  usually an mRNA is capped by the additi ***
--- *** on of a modified guanine nucleotide at t ***
--- *** he 5' end.                               ***
--- ************************************************
---

CREATE VIEW capped AS
  SELECT
    feature_id AS capped_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'capped';

--- ************************************************
--- *** relation: exon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of the transcript sequence with ***
--- *** in a gene which is not removed from the  ***
--- *** primary RNA transcript by RNA splicing.  ***
--- ************************************************
---

CREATE VIEW exon AS
  SELECT
    feature_id AS exon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'coding_exon' OR cvterm.name = 'noncoding_exon' OR cvterm.name = 'interior_exon' OR cvterm.name = 'exon_of_single_exon_gene' OR cvterm.name = 'interior_coding_exon' OR cvterm.name = 'five_prime_coding_exon' OR cvterm.name = 'three_prime_coding_exon' OR cvterm.name = 'three_prime_noncoding_exon' OR cvterm.name = 'five_prime_noncoding_exon' OR cvterm.name = 'exon';

--- ************************************************
--- *** relation: supercontig ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** One or more contigs that have been order ***
--- *** ed and oriented using end-read informati ***
--- *** on. Contains gaps that are filled with N ***
--- *** 's.                                      ***
--- ************************************************
---

CREATE VIEW supercontig AS
  SELECT
    feature_id AS supercontig_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'supercontig';

--- ************************************************
--- *** relation: contig ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A contiguous sequence derived from seque ***
--- *** nce assembly. Has no gaps, but may conta ***
--- *** in N's from unavailable bases.           ***
--- ************************************************
---

CREATE VIEW contig AS
  SELECT
    feature_id AS contig_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'contig';

--- ************************************************
--- *** relation: read ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence obtained from a single sequen ***
--- *** cing experiment. Typically a read is pro ***
--- *** duced when a base calling program interp ***
--- *** rets information from a chromatogram tra ***
--- *** ce file produced from a sequencing machi ***
--- *** ne.                                      ***
--- ************************************************
---

CREATE VIEW read AS
  SELECT
    feature_id AS read_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'read_pair' OR cvterm.name = 'contig_read' OR cvterm.name = 'BAC_end' OR cvterm.name = 'dye_terminator_read' OR cvterm.name = 'pyrosequenced_read' OR cvterm.name = 'ligation_based_read' OR cvterm.name = 'polymerase_synthesis_read' OR cvterm.name = 'PAC_end' OR cvterm.name = 'YAC_end' OR cvterm.name = 'clone_end' OR cvterm.name = 'read';

--- ************************************************
--- *** relation: clone ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A piece of DNA that has been inserted in ***
--- ***  a vector so that it can be propagated i ***
--- *** n a host bacterium or some other organis ***
--- *** m.                                       ***
--- ************************************************
---

CREATE VIEW clone AS
  SELECT
    feature_id AS clone_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'genomic_clone' OR cvterm.name = 'cDNA_clone' OR cvterm.name = 'tiling_path_clone' OR cvterm.name = 'validated_cDNA_clone' OR cvterm.name = 'invalidated_cDNA_clone' OR cvterm.name = 'three_prime_RACE_clone' OR cvterm.name = 'chimeric_cDNA_clone' OR cvterm.name = 'genomically_contaminated_cDNA_clone' OR cvterm.name = 'polyA_primed_cDNA_clone' OR cvterm.name = 'partially_processed_cDNA_clone' OR cvterm.name = 'clone';

--- ************************************************
--- *** relation: yac ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Yeast Artificial Chromosome, a vector co ***
--- *** nstructed from the telomeric, centromeri ***
--- *** c, and replication origin sequences need ***
--- *** ed for replication in yeast cells.       ***
--- ************************************************
---

CREATE VIEW yac AS
  SELECT
    feature_id AS yac_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'YAC';

--- ************************************************
--- *** relation: bac ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Bacterial Artificial Chromosome, a cloni ***
--- *** ng vector that can be propagated as mini ***
--- *** -chromosomes in a bacterial host.        ***
--- ************************************************
---

CREATE VIEW bac AS
  SELECT
    feature_id AS bac_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'BAC';

--- ************************************************
--- *** relation: pac ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The P1-derived artificial chromosome are ***
--- ***  DNA constructs that are derived from th ***
--- *** e DNA of P1 bacteriophage. They can carr ***
--- *** y large amounts (about 100-300 kilobases ***
--- *** ) of other sequences for a variety of bi ***
--- *** oengineering purposes. It is one type of ***
--- ***  vector used to clone DNA fragments (100 ***
--- *** - to 300-kb insert size; average, 150 kb ***
--- *** ) in Escherichia coli cells.             ***
--- ************************************************
---

CREATE VIEW pac AS
  SELECT
    feature_id AS pac_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'PAC';

--- ************************************************
--- *** relation: plasmid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A self replicating, using the hosts cell ***
--- *** ular machinery, often circular nucleic a ***
--- *** cid molecule that is distinct from a chr ***
--- *** omosome in the organism.                 ***
--- ************************************************
---

CREATE VIEW plasmid AS
  SELECT
    feature_id AS plasmid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_plasmid' OR cvterm.name = 'episome' OR cvterm.name = 'natural_plasmid' OR cvterm.name = 'engineered_episome' OR cvterm.name = 'gene_trap_construct' OR cvterm.name = 'promoter_trap_construct' OR cvterm.name = 'enhancer_trap_construct' OR cvterm.name = 'engineered_episome' OR cvterm.name = 'plasmid';

--- ************************************************
--- *** relation: cosmid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A cloning vector that is a hybrid of lam ***
--- *** bda phages and a plasmid that can be pro ***
--- *** pagated as a plasmid or packaged as a ph ***
--- *** age,since they retain the lambda cos sit ***
--- *** es.                                      ***
--- ************************************************
---

CREATE VIEW cosmid AS
  SELECT
    feature_id AS cosmid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cosmid';

--- ************************************************
--- *** relation: phagemid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A plasmid which carries within its seque ***
--- *** nce a bacteriophage replication origin.  ***
--- *** When the host bacterium is infected with ***
--- ***  "helper" phage, a phagemid is replicate ***
--- *** d along with the phage DNA and packaged  ***
--- *** into phage capsids.                      ***
--- ************************************************
---

CREATE VIEW phagemid AS
  SELECT
    feature_id AS phagemid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'phagemid';

--- ************************************************
--- *** relation: fosmid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A cloning vector that utilizes the E. co ***
--- *** li F factor.                             ***
--- ************************************************
---

CREATE VIEW fosmid AS
  SELECT
    feature_id AS fosmid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'fosmid';

--- ************************************************
--- *** relation: deletion ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The point at which one or more contiguou ***
--- *** s nucleotides were excised.              ***
--- ************************************************
---

CREATE VIEW deletion AS
  SELECT
    feature_id AS deletion_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'deletion';

--- ************************************************
--- *** relation: methylated_a ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A modified RNA base in which adenine has ***
--- ***  been methylated.                        ***
--- ************************************************
---

CREATE VIEW methylated_a AS
  SELECT
    feature_id AS methylated_a_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'methylated_A';

--- ************************************************
--- *** relation: splice_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Consensus region of primary transcript b ***
--- *** ordering junction of splicing. A region  ***
--- *** that overlaps exactly 2 base and adjacen ***
--- *** t_to splice_junction.                    ***
--- ************************************************
---

CREATE VIEW splice_site AS
  SELECT
    feature_id AS splice_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cis_splice_site' OR cvterm.name = 'trans_splice_site' OR cvterm.name = 'cryptic_splice_site' OR cvterm.name = 'five_prime_cis_splice_site' OR cvterm.name = 'three_prime_cis_splice_site' OR cvterm.name = 'recursive_splice_site' OR cvterm.name = 'canonical_five_prime_splice_site' OR cvterm.name = 'non_canonical_five_prime_splice_site' OR cvterm.name = 'canonical_three_prime_splice_site' OR cvterm.name = 'non_canonical_three_prime_splice_site' OR cvterm.name = 'trans_splice_acceptor_site' OR cvterm.name = 'trans_splice_donor_site' OR cvterm.name = 'SL1_acceptor_site' OR cvterm.name = 'SL2_acceptor_site' OR cvterm.name = 'SL3_acceptor_site' OR cvterm.name = 'SL4_acceptor_site' OR cvterm.name = 'SL5_acceptor_site' OR cvterm.name = 'SL6_acceptor_site' OR cvterm.name = 'SL7_acceptor_site' OR cvterm.name = 'SL8_acceptor_site' OR cvterm.name = 'SL9_acceptor_site' OR cvterm.name = 'SL10_accceptor_site' OR cvterm.name = 'SL11_acceptor_site' OR cvterm.name = 'SL12_acceptor_site' OR cvterm.name = 'splice_site';

--- ************************************************
--- *** relation: five_prime_cis_splice_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Intronic 2 bp region bordering the exon, ***
--- ***  at the 5' edge of the intron. A splice_ ***
--- *** site that is downstream_adjacent_to exon ***
--- ***  and starts intron.                      ***
--- ************************************************
---

CREATE VIEW five_prime_cis_splice_site AS
  SELECT
    feature_id AS five_prime_cis_splice_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'canonical_five_prime_splice_site' OR cvterm.name = 'non_canonical_five_prime_splice_site' OR cvterm.name = 'five_prime_cis_splice_site';

--- ************************************************
--- *** relation: three_prime_cis_splice_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Intronic 2 bp region bordering the exon, ***
--- ***  at the 3' edge of the intron. A splice_ ***
--- *** site that is upstream_adjacent_to exon a ***
--- *** nd finishes intron.                      ***
--- ************************************************
---

CREATE VIEW three_prime_cis_splice_site AS
  SELECT
    feature_id AS three_prime_cis_splice_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'canonical_three_prime_splice_site' OR cvterm.name = 'non_canonical_three_prime_splice_site' OR cvterm.name = 'three_prime_cis_splice_site';

--- ************************************************
--- *** relation: enhancer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A cis-acting sequence that increases the ***
--- ***  utilization of (some) eukaryotic promot ***
--- *** ers, and can function in either orientat ***
--- *** ion and in any location (upstream or dow ***
--- *** nstream) relative to the promoter.       ***
--- ************************************************
---

CREATE VIEW enhancer AS
  SELECT
    feature_id AS enhancer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'enhancer_bound_by_factor' OR cvterm.name = 'shadow_enhancer' OR cvterm.name = 'enhancer';

--- ************************************************
--- *** relation: enhancer_bound_by_factor ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An enhancer bound by a factor.           ***
--- ************************************************
---

CREATE VIEW enhancer_bound_by_factor AS
  SELECT
    feature_id AS enhancer_bound_by_factor_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'enhancer_bound_by_factor';

--- ************************************************
--- *** relation: promoter ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A regulatory_region composed of the TSS( ***
--- *** s) and binding sites for TF_complexes of ***
--- ***  the basal transcription machinery.      ***
--- ************************************************
---

CREATE VIEW promoter AS
  SELECT
    feature_id AS promoter_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'bidirectional_promoter' OR cvterm.name = 'RNA_polymerase_promoter' OR cvterm.name = 'RNApol_I_promoter' OR cvterm.name = 'RNApol_II_promoter' OR cvterm.name = 'RNApol_III_promoter' OR cvterm.name = 'bacterial_RNApol_promoter' OR cvterm.name = 'Phage_RNA_Polymerase_Promoter' OR cvterm.name = 'RNApol_II_core_promoter' OR cvterm.name = 'RNApol_III_promoter_type_1' OR cvterm.name = 'RNApol_III_promoter_type_2' OR cvterm.name = 'RNApol_III_promoter_type_3' OR cvterm.name = 'bacterial_RNApol_promoter_sigma_70' OR cvterm.name = 'bacterial_RNApol_promoter_sigma54' OR cvterm.name = 'SP6_RNA_Polymerase_Promoter' OR cvterm.name = 'T3_RNA_Polymerase_Promoter' OR cvterm.name = 'T7_RNA_Polymerase_Promoter' OR cvterm.name = 'promoter';

--- ************************************************
--- *** relation: rnapol_i_promoter ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A DNA sequence in eukaryotic DNA to whic ***
--- *** h RNA polymerase I binds, to begin trans ***
--- *** cription.                                ***
--- ************************************************
---

CREATE VIEW rnapol_i_promoter AS
  SELECT
    feature_id AS rnapol_i_promoter_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNApol_I_promoter';

--- ************************************************
--- *** relation: rnapol_ii_promoter ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A DNA sequence in eukaryotic DNA to whic ***
--- *** h RNA polymerase II binds, to begin tran ***
--- *** scription.                               ***
--- ************************************************
---

CREATE VIEW rnapol_ii_promoter AS
  SELECT
    feature_id AS rnapol_ii_promoter_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNApol_II_core_promoter' OR cvterm.name = 'RNApol_II_promoter';

--- ************************************************
--- *** relation: rnapol_iii_promoter ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A DNA sequence in eukaryotic DNA to whic ***
--- *** h RNA polymerase III binds, to begin tra ***
--- *** nscription.                              ***
--- ************************************************
---

CREATE VIEW rnapol_iii_promoter AS
  SELECT
    feature_id AS rnapol_iii_promoter_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNApol_III_promoter_type_1' OR cvterm.name = 'RNApol_III_promoter_type_2' OR cvterm.name = 'RNApol_III_promoter_type_3' OR cvterm.name = 'RNApol_III_promoter';

--- ************************************************
--- *** relation: caat_signal ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Part of a conserved sequence located abo ***
--- *** ut 75-bp upstream of the start point of  ***
--- *** eukaryotic transcription units which may ***
--- ***  be involved in RNA polymerase binding;  ***
--- *** consensus=GG(C|T)CAATCT.                 ***
--- ************************************************
---

CREATE VIEW caat_signal AS
  SELECT
    feature_id AS caat_signal_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'CAAT_signal';

--- ************************************************
--- *** relation: gc_rich_promoter_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A conserved GC-rich region located upstr ***
--- *** eam of the start point of eukaryotic tra ***
--- *** nscription units which may occur in mult ***
--- *** iple copies or in either orientation; co ***
--- *** nsensus=GGGCGG.                          ***
--- ************************************************
---

CREATE VIEW gc_rich_promoter_region AS
  SELECT
    feature_id AS gc_rich_promoter_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'GC_rich_promoter_region';

--- ************************************************
--- *** relation: tata_box ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A conserved AT-rich septamer found about ***
--- ***  25-bp before the start point of many eu ***
--- *** karyotic RNA polymerase II transcript un ***
--- *** its; may be involved in positioning the  ***
--- *** enzyme for correct initiation; consensus ***
--- *** =TATA(A|T)A(A|T).                        ***
--- ************************************************
---

CREATE VIEW tata_box AS
  SELECT
    feature_id AS tata_box_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNA_polymerase_II_TATA_box' OR cvterm.name = 'RNA_polymerase_III_TATA_box' OR cvterm.name = 'TATA_box';

--- ************************************************
--- *** relation: minus_10_signal ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A conserved region about 10-bp upstream  ***
--- *** of the start point of bacterial transcri ***
--- *** ption units which may be involved in bin ***
--- *** ding RNA polymerase; consensus=TAtAaT. T ***
--- *** his region is associated with sigma fact ***
--- *** or 70.                                   ***
--- ************************************************
---

CREATE VIEW minus_10_signal AS
  SELECT
    feature_id AS minus_10_signal_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'minus_10_signal';

--- ************************************************
--- *** relation: minus_35_signal ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A conserved hexamer about 35-bp upstream ***
--- ***  of the start point of bacterial transcr ***
--- *** iption units; consensus=TTGACa or TGTTGA ***
--- *** CA. This region is associated with sigma ***
--- ***  factor 70.                              ***
--- ************************************************
---

CREATE VIEW minus_35_signal AS
  SELECT
    feature_id AS minus_35_signal_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'minus_35_signal';

--- ************************************************
--- *** relation: cross_genome_match ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A nucleotide match against a sequence fr ***
--- *** om another organism.                     ***
--- ************************************************
---

CREATE VIEW cross_genome_match AS
  SELECT
    feature_id AS cross_genome_match_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cross_genome_match';

--- ************************************************
--- *** relation: operon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A group of contiguous genes transcribed  ***
--- *** as a single (polycistronic) mRNA from a  ***
--- *** single regulatory region.                ***
--- ************************************************
---

CREATE VIEW operon AS
  SELECT
    feature_id AS operon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'operon';

--- ************************************************
--- *** relation: clone_insert_start ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The start of the clone insert.           ***
--- ************************************************
---

CREATE VIEW clone_insert_start AS
  SELECT
    feature_id AS clone_insert_start_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'clone_insert_start';

--- ************************************************
--- *** relation: retrotransposon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transposable element that is incorpora ***
--- *** ted into a chromosome by a mechanism tha ***
--- *** t requires reverse transcriptase.        ***
--- ************************************************
---

CREATE VIEW retrotransposon AS
  SELECT
    feature_id AS retrotransposon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'LTR_retrotransposon' OR cvterm.name = 'non_LTR_retrotransposon' OR cvterm.name = 'LINE_element' OR cvterm.name = 'SINE_element' OR cvterm.name = 'retrotransposon';

--- ************************************************
--- *** relation: translated_nucleotide_match ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A match against a translated sequence.   ***
--- ************************************************
---

CREATE VIEW translated_nucleotide_match AS
  SELECT
    feature_id AS translated_nucleotide_match_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'translated_nucleotide_match';

--- ************************************************
--- *** relation: dna_transposon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transposon where the mechanism of tran ***
--- *** sposition is via a DNA intermediate.     ***
--- ************************************************
---

CREATE VIEW dna_transposon AS
  SELECT
    feature_id AS dna_transposon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'terminal_inverted_repeat_element' OR cvterm.name = 'foldback_element' OR cvterm.name = 'conjugative_transposon' OR cvterm.name = 'helitron' OR cvterm.name = 'p_element' OR cvterm.name = 'MITE' OR cvterm.name = 'insertion_sequence' OR cvterm.name = 'polinton' OR cvterm.name = 'DNA_transposon';

--- ************************************************
--- *** relation: non_transcribed_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of the gene which is not transc ***
--- *** ribed.                                   ***
--- ************************************************
---

CREATE VIEW non_transcribed_region AS
  SELECT
    feature_id AS non_transcribed_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'non_transcribed_region';

--- ************************************************
--- *** relation: u2_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A major type of spliceosomal intron spli ***
--- *** ced by the U2 spliceosome, that includes ***
--- ***  U1, U2, U4/U6 and U5 snRNAs.            ***
--- ************************************************
---

CREATE VIEW u2_intron AS
  SELECT
    feature_id AS u2_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U2_intron';

--- ************************************************
--- *** relation: primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transcript that in its initial state r ***
--- *** equires modification to be functional.   ***
--- ************************************************
---

CREATE VIEW primary_transcript AS
  SELECT
    feature_id AS primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'protein_coding_primary_transcript' OR cvterm.name = 'nc_primary_transcript' OR cvterm.name = 'polycistronic_primary_transcript' OR cvterm.name = 'monocistronic_primary_transcript' OR cvterm.name = 'mini_exon_donor_RNA' OR cvterm.name = 'antisense_primary_transcript' OR cvterm.name = 'capped_primary_transcript' OR cvterm.name = 'pre_edited_mRNA' OR cvterm.name = 'scRNA_primary_transcript' OR cvterm.name = 'rRNA_primary_transcript' OR cvterm.name = 'tRNA_primary_transcript' OR cvterm.name = 'snRNA_primary_transcript' OR cvterm.name = 'snoRNA_primary_transcript' OR cvterm.name = 'tmRNA_primary_transcript' OR cvterm.name = 'SRP_RNA_primary_transcript' OR cvterm.name = 'miRNA_primary_transcript' OR cvterm.name = 'tasiRNA_primary_transcript' OR cvterm.name = 'rRNA_small_subunit_primary_transcript' OR cvterm.name = 'rRNA_large_subunit_primary_transcript' OR cvterm.name = 'alanine_tRNA_primary_transcript' OR cvterm.name = 'arginine_tRNA_primary_transcript' OR cvterm.name = 'asparagine_tRNA_primary_transcript' OR cvterm.name = 'aspartic_acid_tRNA_primary_transcript' OR cvterm.name = 'cysteine_tRNA_primary_transcript' OR cvterm.name = 'glutamic_acid_tRNA_primary_transcript' OR cvterm.name = 'glutamine_tRNA_primary_transcript' OR cvterm.name = 'glycine_tRNA_primary_transcript' OR cvterm.name = 'histidine_tRNA_primary_transcript' OR cvterm.name = 'isoleucine_tRNA_primary_transcript' OR cvterm.name = 'leucine_tRNA_primary_transcript' OR cvterm.name = 'lysine_tRNA_primary_transcript' OR cvterm.name = 'methionine_tRNA_primary_transcript' OR cvterm.name = 'phenylalanine_tRNA_primary_transcript' OR cvterm.name = 'proline_tRNA_primary_transcript' OR cvterm.name = 'serine_tRNA_primary_transcript' OR cvterm.name = 'threonine_tRNA_primary_transcript' OR cvterm.name = 'tryptophan_tRNA_primary_transcript' OR cvterm.name = 'tyrosine_tRNA_primary_transcript' OR cvterm.name = 'valine_tRNA_primary_transcript' OR cvterm.name = 'pyrrolysine_tRNA_primary_transcript' OR cvterm.name = 'selenocysteine_tRNA_primary_transcript' OR cvterm.name = 'methylation_guide_snoRNA_primary_transcript' OR cvterm.name = 'rRNA_cleavage_snoRNA_primary_transcript' OR cvterm.name = 'C_D_box_snoRNA_primary_transcript' OR cvterm.name = 'H_ACA_box_snoRNA_primary_transcript' OR cvterm.name = 'U14_snoRNA_primary_transcript' OR cvterm.name = 'stRNA_primary_transcript' OR cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'primary_transcript';

--- ************************************************
--- *** relation: ltr_retrotransposon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A retrotransposon flanked by long termin ***
--- *** al repeat sequences.                     ***
--- ************************************************
---

CREATE VIEW ltr_retrotransposon AS
  SELECT
    feature_id AS ltr_retrotransposon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'LTR_retrotransposon';

--- ************************************************
--- *** relation: intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of a primary transcript that is ***
--- ***  transcribed, but removed from within th ***
--- *** e transcript by splicing together the se ***
--- *** quences (exons) on either side of it.    ***
--- ************************************************
---

CREATE VIEW intron AS
  SELECT
    feature_id AS intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_intron' OR cvterm.name = 'interior_intron' OR cvterm.name = 'three_prime_intron' OR cvterm.name = 'twintron' OR cvterm.name = 'UTR_intron' OR cvterm.name = 'autocatalytically_spliced_intron' OR cvterm.name = 'spliceosomal_intron' OR cvterm.name = 'mobile_intron' OR cvterm.name = 'endonuclease_spliced_intron' OR cvterm.name = 'five_prime_UTR_intron' OR cvterm.name = 'three_prime_UTR_intron' OR cvterm.name = 'group_I_intron' OR cvterm.name = 'group_II_intron' OR cvterm.name = 'group_III_intron' OR cvterm.name = 'group_IIA_intron' OR cvterm.name = 'group_IIB_intron' OR cvterm.name = 'U2_intron' OR cvterm.name = 'U12_intron' OR cvterm.name = 'archaeal_intron' OR cvterm.name = 'tRNA_intron' OR cvterm.name = 'intron';

--- ************************************************
--- *** relation: non_ltr_retrotransposon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A retrotransposon without long terminal  ***
--- *** repeat sequences.                        ***
--- ************************************************
---

CREATE VIEW non_ltr_retrotransposon AS
  SELECT
    feature_id AS non_ltr_retrotransposon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'LINE_element' OR cvterm.name = 'SINE_element' OR cvterm.name = 'non_LTR_retrotransposon';

--- ************************************************
--- *** relation: five_prime_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW five_prime_intron AS
  SELECT
    feature_id AS five_prime_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_intron';

--- ************************************************
--- *** relation: interior_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW interior_intron AS
  SELECT
    feature_id AS interior_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'interior_intron';

--- ************************************************
--- *** relation: three_prime_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW three_prime_intron AS
  SELECT
    feature_id AS three_prime_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_intron';

--- ************************************************
--- *** relation: rflp_fragment ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A DNA fragment used as a reagent to dete ***
--- *** ct the polymorphic genomic loci by hybri ***
--- *** dizing against the genomic DNA digested  ***
--- *** with a given restriction enzyme.         ***
--- ************************************************
---

CREATE VIEW rflp_fragment AS
  SELECT
    feature_id AS rflp_fragment_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RFLP_fragment';

--- ************************************************
--- *** relation: line_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A dispersed repeat family with many copi ***
--- *** es, each from 1 to 6 kb long. New elemen ***
--- *** ts are generated by retroposition of a t ***
--- *** ranscribed copy. Typically the LINE cont ***
--- *** ains 2 ORF's one of which is reverse tra ***
--- *** nscriptase, and 3'and 5' direct repeats. ***
--- ************************************************
---

CREATE VIEW line_element AS
  SELECT
    feature_id AS line_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'LINE_element';

--- ************************************************
--- *** relation: coding_exon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An exon whereby at least one base is par ***
--- *** t of a codon (here, 'codon' is inclusive ***
--- ***  of the stop_codon).                     ***
--- ************************************************
---

CREATE VIEW coding_exon AS
  SELECT
    feature_id AS coding_exon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'interior_coding_exon' OR cvterm.name = 'five_prime_coding_exon' OR cvterm.name = 'three_prime_coding_exon' OR cvterm.name = 'coding_exon';

--- ************************************************
--- *** relation: five_prime_coding_exon_coding_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The sequence of the five_prime_coding_ex ***
--- *** on that codes for protein.               ***
--- ************************************************
---

CREATE VIEW five_prime_coding_exon_coding_region AS
  SELECT
    feature_id AS five_prime_coding_exon_coding_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_coding_exon_coding_region';

--- ************************************************
--- *** relation: three_prime_coding_exon_coding_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The sequence of the three_prime_coding_e ***
--- *** xon that codes for protein.              ***
--- ************************************************
---

CREATE VIEW three_prime_coding_exon_coding_region AS
  SELECT
    feature_id AS three_prime_coding_exon_coding_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_coding_exon_coding_region';

--- ************************************************
--- *** relation: noncoding_exon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An exon that does not contain any codons ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW noncoding_exon AS
  SELECT
    feature_id AS noncoding_exon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_noncoding_exon' OR cvterm.name = 'five_prime_noncoding_exon' OR cvterm.name = 'noncoding_exon';

--- ************************************************
--- *** relation: translocation ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of nucleotide sequence that has ***
--- ***  translocated to a new position.         ***
--- ************************************************
---

CREATE VIEW translocation AS
  SELECT
    feature_id AS translocation_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'translocation';

--- ************************************************
--- *** relation: five_prime_coding_exon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The 5' most coding exon.                 ***
--- ************************************************
---

CREATE VIEW five_prime_coding_exon AS
  SELECT
    feature_id AS five_prime_coding_exon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_coding_exon';

--- ************************************************
--- *** relation: interior_exon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An exon that is bounded by 5' and 3' spl ***
--- *** ice sites.                               ***
--- ************************************************
---

CREATE VIEW interior_exon AS
  SELECT
    feature_id AS interior_exon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'interior_exon';

--- ************************************************
--- *** relation: three_prime_coding_exon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The coding exon that is most 3-prime on  ***
--- *** a given transcript.                      ***
--- ************************************************
---

CREATE VIEW three_prime_coding_exon AS
  SELECT
    feature_id AS three_prime_coding_exon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_coding_exon';

--- ************************************************
--- *** relation: utr ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Messenger RNA sequences that are untrans ***
--- *** lated and lie five prime or three prime  ***
--- *** to sequences which are translated.       ***
--- ************************************************
---

CREATE VIEW utr AS
  SELECT
    feature_id AS utr_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_UTR' OR cvterm.name = 'three_prime_UTR' OR cvterm.name = 'internal_UTR' OR cvterm.name = 'untranslated_region_polycistronic_mRNA' OR cvterm.name = 'UTR';

--- ************************************************
--- *** relation: five_prime_utr ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region at the 5' end of a mature trans ***
--- *** cript (preceding the initiation codon) t ***
--- *** hat is not translated into a protein.    ***
--- ************************************************
---

CREATE VIEW five_prime_utr AS
  SELECT
    feature_id AS five_prime_utr_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_UTR';

--- ************************************************
--- *** relation: three_prime_utr ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region at the 3' end of a mature trans ***
--- *** cript (following the stop codon) that is ***
--- ***  not translated into a protein.          ***
--- ************************************************
---

CREATE VIEW three_prime_utr AS
  SELECT
    feature_id AS three_prime_utr_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_UTR';

--- ************************************************
--- *** relation: sine_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A repetitive element, a few hundred base ***
--- ***  pairs long, that is dispersed throughou ***
--- *** t the genome. A common human SINE is the ***
--- ***  Alu element.                            ***
--- ************************************************
---

CREATE VIEW sine_element AS
  SELECT
    feature_id AS sine_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'SINE_element';

--- ************************************************
--- *** relation: simple_sequence_length_variation ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW simple_sequence_length_variation AS
  SELECT
    feature_id AS simple_sequence_length_variation_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'simple_sequence_length_variation';

--- ************************************************
--- *** relation: terminal_inverted_repeat_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A DNA transposable element defined as ha ***
--- *** ving termini with perfect, or nearly per ***
--- *** fect short inverted repeats, generally 1 ***
--- *** 0 - 40 nucleotides long.                 ***
--- ************************************************
---

CREATE VIEW terminal_inverted_repeat_element AS
  SELECT
    feature_id AS terminal_inverted_repeat_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'MITE' OR cvterm.name = 'insertion_sequence' OR cvterm.name = 'polinton' OR cvterm.name = 'terminal_inverted_repeat_element';

--- ************************************************
--- *** relation: rrna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a ribosoma ***
--- *** l RNA.                                   ***
--- ************************************************
---

CREATE VIEW rrna_primary_transcript AS
  SELECT
    feature_id AS rrna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_small_subunit_primary_transcript' OR cvterm.name = 'rRNA_large_subunit_primary_transcript' OR cvterm.name = 'rRNA_primary_transcript';

--- ************************************************
--- *** relation: trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a transfer ***
--- ***  RNA (SO:0000253).                       ***
--- ************************************************
---

CREATE VIEW trna_primary_transcript AS
  SELECT
    feature_id AS trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'alanine_tRNA_primary_transcript' OR cvterm.name = 'arginine_tRNA_primary_transcript' OR cvterm.name = 'asparagine_tRNA_primary_transcript' OR cvterm.name = 'aspartic_acid_tRNA_primary_transcript' OR cvterm.name = 'cysteine_tRNA_primary_transcript' OR cvterm.name = 'glutamic_acid_tRNA_primary_transcript' OR cvterm.name = 'glutamine_tRNA_primary_transcript' OR cvterm.name = 'glycine_tRNA_primary_transcript' OR cvterm.name = 'histidine_tRNA_primary_transcript' OR cvterm.name = 'isoleucine_tRNA_primary_transcript' OR cvterm.name = 'leucine_tRNA_primary_transcript' OR cvterm.name = 'lysine_tRNA_primary_transcript' OR cvterm.name = 'methionine_tRNA_primary_transcript' OR cvterm.name = 'phenylalanine_tRNA_primary_transcript' OR cvterm.name = 'proline_tRNA_primary_transcript' OR cvterm.name = 'serine_tRNA_primary_transcript' OR cvterm.name = 'threonine_tRNA_primary_transcript' OR cvterm.name = 'tryptophan_tRNA_primary_transcript' OR cvterm.name = 'tyrosine_tRNA_primary_transcript' OR cvterm.name = 'valine_tRNA_primary_transcript' OR cvterm.name = 'pyrrolysine_tRNA_primary_transcript' OR cvterm.name = 'selenocysteine_tRNA_primary_transcript' OR cvterm.name = 'tRNA_primary_transcript';

--- ************************************************
--- *** relation: alanine_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding alanyl tRN ***
--- *** A.                                       ***
--- ************************************************
---

CREATE VIEW alanine_trna_primary_transcript AS
  SELECT
    feature_id AS alanine_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'alanine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: arg_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding arginyl tR ***
--- *** NA (SO:0000255).                         ***
--- ************************************************
---

CREATE VIEW arg_trna_primary_transcript AS
  SELECT
    feature_id AS arg_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'arginine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: asparagine_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding asparaginy ***
--- *** l tRNA (SO:0000256).                     ***
--- ************************************************
---

CREATE VIEW asparagine_trna_primary_transcript AS
  SELECT
    feature_id AS asparagine_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'asparagine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: aspartic_acid_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding aspartyl t ***
--- *** RNA (SO:0000257).                        ***
--- ************************************************
---

CREATE VIEW aspartic_acid_trna_primary_transcript AS
  SELECT
    feature_id AS aspartic_acid_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'aspartic_acid_tRNA_primary_transcript';

--- ************************************************
--- *** relation: cysteine_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding cysteinyl  ***
--- *** tRNA (SO:0000258).                       ***
--- ************************************************
---

CREATE VIEW cysteine_trna_primary_transcript AS
  SELECT
    feature_id AS cysteine_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cysteine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: glutamic_acid_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding glutaminyl ***
--- ***  tRNA (SO:0000260).                      ***
--- ************************************************
---

CREATE VIEW glutamic_acid_trna_primary_transcript AS
  SELECT
    feature_id AS glutamic_acid_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'glutamic_acid_tRNA_primary_transcript';

--- ************************************************
--- *** relation: glutamine_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding glutamyl t ***
--- *** RNA (SO:0000260).                        ***
--- ************************************************
---

CREATE VIEW glutamine_trna_primary_transcript AS
  SELECT
    feature_id AS glutamine_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'glutamine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: glycine_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding glycyl tRN ***
--- *** A (SO:0000263).                          ***
--- ************************************************
---

CREATE VIEW glycine_trna_primary_transcript AS
  SELECT
    feature_id AS glycine_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'glycine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: histidine_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding histidyl t ***
--- *** RNA (SO:0000262).                        ***
--- ************************************************
---

CREATE VIEW histidine_trna_primary_transcript AS
  SELECT
    feature_id AS histidine_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'histidine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: isoleucine_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding isoleucyl  ***
--- *** tRNA (SO:0000263).                       ***
--- ************************************************
---

CREATE VIEW isoleucine_trna_primary_transcript AS
  SELECT
    feature_id AS isoleucine_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'isoleucine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: leucine_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding leucyl tRN ***
--- *** A (SO:0000264).                          ***
--- ************************************************
---

CREATE VIEW leucine_trna_primary_transcript AS
  SELECT
    feature_id AS leucine_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'leucine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: lysine_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding lysyl tRNA ***
--- ***  (SO:0000265).                           ***
--- ************************************************
---

CREATE VIEW lysine_trna_primary_transcript AS
  SELECT
    feature_id AS lysine_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'lysine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: methionine_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding methionyl  ***
--- *** tRNA (SO:0000266).                       ***
--- ************************************************
---

CREATE VIEW methionine_trna_primary_transcript AS
  SELECT
    feature_id AS methionine_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'methionine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: phe_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding phenylalan ***
--- *** yl tRNA (SO:0000267).                    ***
--- ************************************************
---

CREATE VIEW phe_trna_primary_transcript AS
  SELECT
    feature_id AS phe_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'phenylalanine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: proline_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding prolyl tRN ***
--- *** A (SO:0000268).                          ***
--- ************************************************
---

CREATE VIEW proline_trna_primary_transcript AS
  SELECT
    feature_id AS proline_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'proline_tRNA_primary_transcript';

--- ************************************************
--- *** relation: serine_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding seryl tRNA ***
--- ***  (SO:000269).                            ***
--- ************************************************
---

CREATE VIEW serine_trna_primary_transcript AS
  SELECT
    feature_id AS serine_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'serine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: thr_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding threonyl t ***
--- *** RNA (SO:000270).                         ***
--- ************************************************
---

CREATE VIEW thr_trna_primary_transcript AS
  SELECT
    feature_id AS thr_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'threonine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: try_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding tryptophan ***
--- *** yl tRNA (SO:000271).                     ***
--- ************************************************
---

CREATE VIEW try_trna_primary_transcript AS
  SELECT
    feature_id AS try_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tryptophan_tRNA_primary_transcript';

--- ************************************************
--- *** relation: tyrosine_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding tyrosyl tR ***
--- *** NA (SO:000272).                          ***
--- ************************************************
---

CREATE VIEW tyrosine_trna_primary_transcript AS
  SELECT
    feature_id AS tyrosine_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tyrosine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: valine_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding valyl tRNA ***
--- ***  (SO:000273).                            ***
--- ************************************************
---

CREATE VIEW valine_trna_primary_transcript AS
  SELECT
    feature_id AS valine_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'valine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: snrna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a small nu ***
--- *** clear RNA (SO:0000274).                  ***
--- ************************************************
---

CREATE VIEW snrna_primary_transcript AS
  SELECT
    feature_id AS snrna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'snRNA_primary_transcript';

--- ************************************************
--- *** relation: snorna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a small nu ***
--- *** cleolar mRNA (SO:0000275).               ***
--- ************************************************
---

CREATE VIEW snorna_primary_transcript AS
  SELECT
    feature_id AS snorna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'methylation_guide_snoRNA_primary_transcript' OR cvterm.name = 'rRNA_cleavage_snoRNA_primary_transcript' OR cvterm.name = 'C_D_box_snoRNA_primary_transcript' OR cvterm.name = 'H_ACA_box_snoRNA_primary_transcript' OR cvterm.name = 'U14_snoRNA_primary_transcript' OR cvterm.name = 'snoRNA_primary_transcript';

--- ************************************************
--- *** relation: mature_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transcript which has undergone the nec ***
--- *** essary modifications, if any, for its fu ***
--- *** nction. In eukaryotes this includes, for ***
--- ***  example, processing of introns, cleavag ***
--- *** e, base modification, and modifications  ***
--- *** to the 5' and/or the 3' ends, other than ***
--- ***  addition of bases. In bacteria function ***
--- *** al mRNAs are usually not modified.       ***
--- ************************************************
---

CREATE VIEW mature_transcript AS
  SELECT
    feature_id AS mature_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mRNA' OR cvterm.name = 'ncRNA' OR cvterm.name = 'mRNA_with_frameshift' OR cvterm.name = 'monocistronic_mRNA' OR cvterm.name = 'polycistronic_mRNA' OR cvterm.name = 'exemplar_mRNA' OR cvterm.name = 'capped_mRNA' OR cvterm.name = 'polyadenylated_mRNA' OR cvterm.name = 'trans_spliced_mRNA' OR cvterm.name = 'edited_mRNA' OR cvterm.name = 'consensus_mRNA' OR cvterm.name = 'recoded_mRNA' OR cvterm.name = 'mRNA_with_minus_1_frameshift' OR cvterm.name = 'mRNA_with_plus_1_frameshift' OR cvterm.name = 'mRNA_with_plus_2_frameshift' OR cvterm.name = 'mRNA_with_minus_2_frameshift' OR cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'mRNA_recoded_by_translational_bypass' OR cvterm.name = 'mRNA_recoded_by_codon_redefinition' OR cvterm.name = 'scRNA' OR cvterm.name = 'rRNA' OR cvterm.name = 'tRNA' OR cvterm.name = 'snRNA' OR cvterm.name = 'snoRNA' OR cvterm.name = 'small_regulatory_ncRNA' OR cvterm.name = 'RNase_MRP_RNA' OR cvterm.name = 'RNase_P_RNA' OR cvterm.name = 'telomerase_RNA' OR cvterm.name = 'vault_RNA' OR cvterm.name = 'Y_RNA' OR cvterm.name = 'rasiRNA' OR cvterm.name = 'SRP_RNA' OR cvterm.name = 'guide_RNA' OR cvterm.name = 'antisense_RNA' OR cvterm.name = 'siRNA' OR cvterm.name = 'stRNA' OR cvterm.name = 'class_II_RNA' OR cvterm.name = 'class_I_RNA' OR cvterm.name = 'piRNA' OR cvterm.name = 'lincRNA' OR cvterm.name = 'tasiRNA' OR cvterm.name = 'rRNA_cleavage_RNA' OR cvterm.name = 'small_subunit_rRNA' OR cvterm.name = 'large_subunit_rRNA' OR cvterm.name = 'rRNA_18S' OR cvterm.name = 'rRNA_16S' OR cvterm.name = 'rRNA_5_8S' OR cvterm.name = 'rRNA_5S' OR cvterm.name = 'rRNA_28S' OR cvterm.name = 'rRNA_23S' OR cvterm.name = 'rRNA_25S' OR cvterm.name = 'rRNA_21S' OR cvterm.name = 'alanyl_tRNA' OR cvterm.name = 'asparaginyl_tRNA' OR cvterm.name = 'aspartyl_tRNA' OR cvterm.name = 'cysteinyl_tRNA' OR cvterm.name = 'glutaminyl_tRNA' OR cvterm.name = 'glutamyl_tRNA' OR cvterm.name = 'glycyl_tRNA' OR cvterm.name = 'histidyl_tRNA' OR cvterm.name = 'isoleucyl_tRNA' OR cvterm.name = 'leucyl_tRNA' OR cvterm.name = 'lysyl_tRNA' OR cvterm.name = 'methionyl_tRNA' OR cvterm.name = 'phenylalanyl_tRNA' OR cvterm.name = 'prolyl_tRNA' OR cvterm.name = 'seryl_tRNA' OR cvterm.name = 'threonyl_tRNA' OR cvterm.name = 'tryptophanyl_tRNA' OR cvterm.name = 'tyrosyl_tRNA' OR cvterm.name = 'valyl_tRNA' OR cvterm.name = 'pyrrolysyl_tRNA' OR cvterm.name = 'arginyl_tRNA' OR cvterm.name = 'selenocysteinyl_tRNA' OR cvterm.name = 'U1_snRNA' OR cvterm.name = 'U2_snRNA' OR cvterm.name = 'U4_snRNA' OR cvterm.name = 'U4atac_snRNA' OR cvterm.name = 'U5_snRNA' OR cvterm.name = 'U6_snRNA' OR cvterm.name = 'U6atac_snRNA' OR cvterm.name = 'U11_snRNA' OR cvterm.name = 'U12_snRNA' OR cvterm.name = 'C_D_box_snoRNA' OR cvterm.name = 'H_ACA_box_snoRNA' OR cvterm.name = 'U14_snoRNA' OR cvterm.name = 'U3_snoRNA' OR cvterm.name = 'methylation_guide_snoRNA' OR cvterm.name = 'pseudouridylation_guide_snoRNA' OR cvterm.name = 'miRNA' OR cvterm.name = 'RNA_6S' OR cvterm.name = 'CsrB_RsmB_RNA' OR cvterm.name = 'DsrA_RNA' OR cvterm.name = 'OxyS_RNA' OR cvterm.name = 'RprA_RNA' OR cvterm.name = 'RRE_RNA' OR cvterm.name = 'spot_42_RNA' OR cvterm.name = 'tmRNA' OR cvterm.name = 'GcvB_RNA' OR cvterm.name = 'MicF_RNA' OR cvterm.name = 'mature_transcript';

--- ************************************************
--- *** relation: mrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Messenger RNA is the intermediate molecu ***
--- *** le between DNA and protein. It includes  ***
--- *** UTR and coding sequences. It does not co ***
--- *** ntain introns.                           ***
--- ************************************************
---

CREATE VIEW mrna AS
  SELECT
    feature_id AS mrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mRNA_with_frameshift' OR cvterm.name = 'monocistronic_mRNA' OR cvterm.name = 'polycistronic_mRNA' OR cvterm.name = 'exemplar_mRNA' OR cvterm.name = 'capped_mRNA' OR cvterm.name = 'polyadenylated_mRNA' OR cvterm.name = 'trans_spliced_mRNA' OR cvterm.name = 'edited_mRNA' OR cvterm.name = 'consensus_mRNA' OR cvterm.name = 'recoded_mRNA' OR cvterm.name = 'mRNA_with_minus_1_frameshift' OR cvterm.name = 'mRNA_with_plus_1_frameshift' OR cvterm.name = 'mRNA_with_plus_2_frameshift' OR cvterm.name = 'mRNA_with_minus_2_frameshift' OR cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'mRNA_recoded_by_translational_bypass' OR cvterm.name = 'mRNA_recoded_by_codon_redefinition' OR cvterm.name = 'mRNA';

--- ************************************************
--- *** relation: tf_binding_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of a nucleotide molecule that b ***
--- *** inds a Transcription Factor or Transcrip ***
--- *** tion Factor complex [GO:0005667].        ***
--- ************************************************
---

CREATE VIEW tf_binding_site AS
  SELECT
    feature_id AS tf_binding_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'TF_binding_site';

--- ************************************************
--- *** relation: orf ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The in-frame interval between the stop c ***
--- *** odons of a reading frame which when read ***
--- ***  as sequential triplets, has the potenti ***
--- *** al of encoding a sequential string of am ***
--- *** ino acids. TER(NNN)nTER.                 ***
--- ************************************************
---

CREATE VIEW orf AS
  SELECT
    feature_id AS orf_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mini_gene' OR cvterm.name = 'rescue_mini_gene' OR cvterm.name = 'ORF';

--- ************************************************
--- *** relation: transcript_attribute ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW transcript_attribute AS
  SELECT
    feature_id AS transcript_attribute_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'edited' OR cvterm.name = 'capped' OR cvterm.name = 'mRNA_attribute' OR cvterm.name = 'trans_spliced' OR cvterm.name = 'alternatively_spliced' OR cvterm.name = 'monocistronic' OR cvterm.name = 'polycistronic' OR cvterm.name = 'polyadenylated' OR cvterm.name = 'exemplar' OR cvterm.name = 'frameshift' OR cvterm.name = 'recoded' OR cvterm.name = 'minus_1_frameshift' OR cvterm.name = 'minus_2_frameshift' OR cvterm.name = 'plus_1_frameshift' OR cvterm.name = 'plus_2_framshift' OR cvterm.name = 'codon_redefined' OR cvterm.name = 'recoded_by_translational_bypass' OR cvterm.name = 'translationally_frameshifted' OR cvterm.name = 'minus_1_translationally_frameshifted' OR cvterm.name = 'plus_1_translationally_frameshifted' OR cvterm.name = 'dicistronic' OR cvterm.name = 'transcript_attribute';

--- ************************************************
--- *** relation: foldback_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transposable element with extensive se ***
--- *** condary structure, characterized by larg ***
--- *** e modular imperfect long inverted repeat ***
--- *** s.                                       ***
--- ************************************************
---

CREATE VIEW foldback_element AS
  SELECT
    feature_id AS foldback_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'foldback_element';

--- ************************************************
--- *** relation: flanking_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The sequences extending on either side o ***
--- *** f a specific region.                     ***
--- ************************************************
---

CREATE VIEW flanking_region AS
  SELECT
    feature_id AS flanking_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transposable_element_flanking_region' OR cvterm.name = 'five_prime_flanking_region' OR cvterm.name = 'three_prime_flanking_region' OR cvterm.name = 'flanking_region';

--- ************************************************
--- *** relation: chromosome_variation ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW chromosome_variation AS
  SELECT
    feature_id AS chromosome_variation_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'assortment_derived_variation' OR cvterm.name = 'chromosome_number_variation' OR cvterm.name = 'chromosome_structure_variation' OR cvterm.name = 'assortment_derived_duplication' OR cvterm.name = 'assortment_derived_deficiency_plus_duplication' OR cvterm.name = 'assortment_derived_deficiency' OR cvterm.name = 'assortment_derived_aneuploid' OR cvterm.name = 'aneuploid' OR cvterm.name = 'polyploid' OR cvterm.name = 'hyperploid' OR cvterm.name = 'hypoploid' OR cvterm.name = 'autopolyploid' OR cvterm.name = 'allopolyploid' OR cvterm.name = 'free_chromosome_arm' OR cvterm.name = 'chromosomal_transposition' OR cvterm.name = 'aneuploid_chromosome' OR cvterm.name = 'intrachromosomal_mutation' OR cvterm.name = 'interchromosomal_mutation' OR cvterm.name = 'chromosomal_duplication' OR cvterm.name = 'compound_chromosome' OR cvterm.name = 'autosynaptic_chromosome' OR cvterm.name = 'complex_chromosomal_mutation' OR cvterm.name = 'uncharacterised_chromosomal_mutation' OR cvterm.name = 'intrachromosomal_transposition' OR cvterm.name = 'interchromosomal_transposition' OR cvterm.name = 'deficient_intrachromosomal_transposition' OR cvterm.name = 'inverted_intrachromosomal_transposition' OR cvterm.name = 'uninverted_intrachromosomal_transposition' OR cvterm.name = 'unoriented_intrachromosomal_transposition' OR cvterm.name = 'deficient_interchromosomal_transposition' OR cvterm.name = 'inverted_interchromosomal_transposition' OR cvterm.name = 'uninverted_interchromosomal_transposition' OR cvterm.name = 'unoriented_interchromosomal_transposition' OR cvterm.name = 'inversion_derived_aneuploid_chromosome' OR cvterm.name = 'chromosomal_deletion' OR cvterm.name = 'chromosomal_inversion' OR cvterm.name = 'intrachromosomal_duplication' OR cvterm.name = 'ring_chromosome' OR cvterm.name = 'chromosome_fission' OR cvterm.name = 'deficient_intrachromosomal_transposition' OR cvterm.name = 'inversion_derived_bipartite_deficiency' OR cvterm.name = 'inversion_derived_deficiency_plus_duplication' OR cvterm.name = 'inversion_derived_deficiency_plus_aneuploid' OR cvterm.name = 'deficient_translocation' OR cvterm.name = 'deficient_inversion' OR cvterm.name = 'inverted_ring_chromosome' OR cvterm.name = 'pericentric_inversion' OR cvterm.name = 'paracentric_inversion' OR cvterm.name = 'inversion_cum_translocation' OR cvterm.name = 'bipartite_inversion' OR cvterm.name = 'inverted_intrachromosomal_transposition' OR cvterm.name = 'deficient_inversion' OR cvterm.name = 'inverted_intrachromosomal_transposition' OR cvterm.name = 'inversion_derived_deficiency_plus_duplication' OR cvterm.name = 'inversion_derived_bipartite_duplication' OR cvterm.name = 'inversion_derived_duplication_plus_aneuploid' OR cvterm.name = 'intrachromosomal_transposition' OR cvterm.name = 'bipartite_duplication' OR cvterm.name = 'deficient_intrachromosomal_transposition' OR cvterm.name = 'inverted_intrachromosomal_transposition' OR cvterm.name = 'uninverted_intrachromosomal_transposition' OR cvterm.name = 'unoriented_intrachromosomal_transposition' OR cvterm.name = 'inverted_ring_chromosome' OR cvterm.name = 'free_ring_duplication' OR cvterm.name = 'chromosomal_translocation' OR cvterm.name = 'bipartite_duplication' OR cvterm.name = 'interchromosomal_transposition' OR cvterm.name = 'translocation_element' OR cvterm.name = 'Robertsonian_fusion' OR cvterm.name = 'reciprocal_chromosomal_translocation' OR cvterm.name = 'deficient_translocation' OR cvterm.name = 'inversion_cum_translocation' OR cvterm.name = 'cyclic_translocation' OR cvterm.name = 'inverted_intrachromosomal_transposition' OR cvterm.name = 'deficient_interchromosomal_transposition' OR cvterm.name = 'inverted_interchromosomal_transposition' OR cvterm.name = 'uninverted_interchromosomal_transposition' OR cvterm.name = 'unoriented_interchromosomal_transposition' OR cvterm.name = 'interchromosomal_duplication' OR cvterm.name = 'intrachromosomal_duplication' OR cvterm.name = 'free_duplication' OR cvterm.name = 'insertional_duplication' OR cvterm.name = 'inversion_derived_deficiency_plus_duplication' OR cvterm.name = 'inversion_derived_bipartite_duplication' OR cvterm.name = 'inversion_derived_duplication_plus_aneuploid' OR cvterm.name = 'intrachromosomal_transposition' OR cvterm.name = 'bipartite_duplication' OR cvterm.name = 'deficient_intrachromosomal_transposition' OR cvterm.name = 'inverted_intrachromosomal_transposition' OR cvterm.name = 'uninverted_intrachromosomal_transposition' OR cvterm.name = 'unoriented_intrachromosomal_transposition' OR cvterm.name = 'free_ring_duplication' OR cvterm.name = 'uninverted_insertional_duplication' OR cvterm.name = 'inverted_insertional_duplication' OR cvterm.name = 'unoriented_insertional_duplication' OR cvterm.name = 'compound_chromosome_arm' OR cvterm.name = 'homo_compound_chromosome' OR cvterm.name = 'hetero_compound_chromosome' OR cvterm.name = 'dexstrosynaptic_chromosome' OR cvterm.name = 'laevosynaptic_chromosome' OR cvterm.name = 'partially_characterised_chromosomal_mutation' OR cvterm.name = 'chromosome_variation';

--- ************************************************
--- *** relation: internal_utr ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A UTR bordered by the terminal and initi ***
--- *** al codons of two CDSs in a polycistronic ***
--- ***  transcript. Every UTR is either 5', 3'  ***
--- *** or internal.                             ***
--- ************************************************
---

CREATE VIEW internal_utr AS
  SELECT
    feature_id AS internal_utr_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'internal_UTR';

--- ************************************************
--- *** relation: untranslated_region_polycistronic_mrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The untranslated sequence separating the ***
--- ***  'cistrons' of multicistronic mRNA.      ***
--- ************************************************
---

CREATE VIEW untranslated_region_polycistronic_mrna AS
  SELECT
    feature_id AS untranslated_region_polycistronic_mrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'untranslated_region_polycistronic_mRNA';

--- ************************************************
--- *** relation: internal_ribosome_entry_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Sequence element that recruits a ribosom ***
--- *** al subunit to internal mRNA for translat ***
--- *** ion initiation.                          ***
--- ************************************************
---

CREATE VIEW internal_ribosome_entry_site AS
  SELECT
    feature_id AS internal_ribosome_entry_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'internal_Shine_Dalgarno_sequence' OR cvterm.name = 'internal_ribosome_entry_site';

--- ************************************************
--- *** relation: polyadenylated ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A attribute describing the addition of a ***
--- ***  poly A tail to the 3' end of a mRNA mol ***
--- *** ecule.                                   ***
--- ************************************************
---

CREATE VIEW polyadenylated AS
  SELECT
    feature_id AS polyadenylated_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polyadenylated';

--- ************************************************
--- *** relation: sequence_length_variation ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW sequence_length_variation AS
  SELECT
    feature_id AS sequence_length_variation_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'simple_sequence_length_variation' OR cvterm.name = 'sequence_length_variation';

--- ************************************************
--- *** relation: modified_rna_base_feature ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A post_transcriptionally modified base.  ***
--- ************************************************
---

CREATE VIEW modified_rna_base_feature AS
  SELECT
    feature_id AS modified_rna_base_feature_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inosine' OR cvterm.name = 'seven_methylguanine' OR cvterm.name = 'ribothymidine' OR cvterm.name = 'modified_adenosine' OR cvterm.name = 'modified_cytidine' OR cvterm.name = 'modified_guanosine' OR cvterm.name = 'modified_uridine' OR cvterm.name = 'modified_inosine' OR cvterm.name = 'methylinosine' OR cvterm.name = 'one_methylinosine' OR cvterm.name = 'one_two_prime_O_dimethylinosine' OR cvterm.name = 'two_prime_O_methylinosine' OR cvterm.name = 'one_methyladenosine' OR cvterm.name = 'two_methyladenosine' OR cvterm.name = 'N6_methyladenosine' OR cvterm.name = 'two_prime_O_methyladenosine' OR cvterm.name = 'two_methylthio_N6_methyladenosine' OR cvterm.name = 'N6_isopentenyladenosine' OR cvterm.name = 'two_methylthio_N6_isopentenyladenosine' OR cvterm.name = 'N6_cis_hydroxyisopentenyl_adenosine' OR cvterm.name = 'two_methylthio_N6_cis_hydroxyisopentenyl_adenosine' OR cvterm.name = 'N6_glycinylcarbamoyladenosine' OR cvterm.name = 'N6_threonylcarbamoyladenosine' OR cvterm.name = 'two_methylthio_N6_threonyl_carbamoyladenosine' OR cvterm.name = 'N6_methyl_N6_threonylcarbamoyladenosine' OR cvterm.name = 'N6_hydroxynorvalylcarbamoyladenosine' OR cvterm.name = 'two_methylthio_N6_hydroxynorvalyl_carbamoyladenosine' OR cvterm.name = 'two_prime_O_ribosyladenosine_phosphate' OR cvterm.name = 'N6_N6_dimethyladenosine' OR cvterm.name = 'N6_2_prime_O_dimethyladenosine' OR cvterm.name = 'N6_N6_2_prime_O_trimethyladenosine' OR cvterm.name = 'one_two_prime_O_dimethyladenosine' OR cvterm.name = 'N6_acetyladenosine' OR cvterm.name = 'three_methylcytidine' OR cvterm.name = 'five_methylcytidine' OR cvterm.name = 'two_prime_O_methylcytidine' OR cvterm.name = 'two_thiocytidine' OR cvterm.name = 'N4_acetylcytidine' OR cvterm.name = 'five_formylcytidine' OR cvterm.name = 'five_two_prime_O_dimethylcytidine' OR cvterm.name = 'N4_acetyl_2_prime_O_methylcytidine' OR cvterm.name = 'lysidine' OR cvterm.name = 'N4_methylcytidine' OR cvterm.name = 'N4_2_prime_O_dimethylcytidine' OR cvterm.name = 'five_hydroxymethylcytidine' OR cvterm.name = 'five_formyl_two_prime_O_methylcytidine' OR cvterm.name = 'N4_N4_2_prime_O_trimethylcytidine' OR cvterm.name = 'seven_deazaguanosine' OR cvterm.name = 'one_methylguanosine' OR cvterm.name = 'N2_methylguanosine' OR cvterm.name = 'seven_methylguanosine' OR cvterm.name = 'two_prime_O_methylguanosine' OR cvterm.name = 'N2_N2_dimethylguanosine' OR cvterm.name = 'N2_2_prime_O_dimethylguanosine' OR cvterm.name = 'N2_N2_2_prime_O_trimethylguanosine' OR cvterm.name = 'two_prime_O_ribosylguanosine_phosphate' OR cvterm.name = 'wybutosine' OR cvterm.name = 'peroxywybutosine' OR cvterm.name = 'hydroxywybutosine' OR cvterm.name = 'undermodified_hydroxywybutosine' OR cvterm.name = 'wyosine' OR cvterm.name = 'methylwyosine' OR cvterm.name = 'N2_7_dimethylguanosine' OR cvterm.name = 'N2_N2_7_trimethylguanosine' OR cvterm.name = 'one_two_prime_O_dimethylguanosine' OR cvterm.name = 'four_demethylwyosine' OR cvterm.name = 'isowyosine' OR cvterm.name = 'N2_7_2prirme_O_trimethylguanosine' OR cvterm.name = 'queuosine' OR cvterm.name = 'epoxyqueuosine' OR cvterm.name = 'galactosyl_queuosine' OR cvterm.name = 'mannosyl_queuosine' OR cvterm.name = 'seven_cyano_seven_deazaguanosine' OR cvterm.name = 'seven_aminomethyl_seven_deazaguanosine' OR cvterm.name = 'archaeosine' OR cvterm.name = 'dihydrouridine' OR cvterm.name = 'pseudouridine' OR cvterm.name = 'five_methyluridine' OR cvterm.name = 'two_prime_O_methyluridine' OR cvterm.name = 'five_two_prime_O_dimethyluridine' OR cvterm.name = 'one_methylpseudouridine' OR cvterm.name = 'two_prime_O_methylpseudouridine' OR cvterm.name = 'two_thiouridine' OR cvterm.name = 'four_thiouridine' OR cvterm.name = 'five_methyl_2_thiouridine' OR cvterm.name = 'two_thio_two_prime_O_methyluridine' OR cvterm.name = 'three_three_amino_three_carboxypropyl_uridine' OR cvterm.name = 'five_hydroxyuridine' OR cvterm.name = 'five_methoxyuridine' OR cvterm.name = 'uridine_five_oxyacetic_acid' OR cvterm.name = 'uridine_five_oxyacetic_acid_methyl_ester' OR cvterm.name = 'five_carboxyhydroxymethyl_uridine' OR cvterm.name = 'five_carboxyhydroxymethyl_uridine_methyl_ester' OR cvterm.name = 'five_methoxycarbonylmethyluridine' OR cvterm.name = 'five_methoxycarbonylmethyl_two_prime_O_methyluridine' OR cvterm.name = 'five_methoxycarbonylmethyl_two_thiouridine' OR cvterm.name = 'five_aminomethyl_two_thiouridine' OR cvterm.name = 'five_methylaminomethyluridine' OR cvterm.name = 'five_methylaminomethyl_two_thiouridine' OR cvterm.name = 'five_methylaminomethyl_two_selenouridine' OR cvterm.name = 'five_carbamoylmethyluridine' OR cvterm.name = 'five_carbamoylmethyl_two_prime_O_methyluridine' OR cvterm.name = 'five_carboxymethylaminomethyluridine' OR cvterm.name = 'five_carboxymethylaminomethyl_two_prime_O_methyluridine' OR cvterm.name = 'five_carboxymethylaminomethyl_two_thiouridine' OR cvterm.name = 'three_methyluridine' OR cvterm.name = 'one_methyl_three_three_amino_three_carboxypropyl_pseudouridine' OR cvterm.name = 'five_carboxymethyluridine' OR cvterm.name = 'three_two_prime_O_dimethyluridine' OR cvterm.name = 'five_methyldihydrouridine' OR cvterm.name = 'three_methylpseudouridine' OR cvterm.name = 'five_taurinomethyluridine' OR cvterm.name = 'five_taurinomethyl_two_thiouridine' OR cvterm.name = 'five_isopentenylaminomethyl_uridine' OR cvterm.name = 'five_isopentenylaminomethyl_two_thiouridine' OR cvterm.name = 'five_isopentenylaminomethyl_two_prime_O_methyluridine' OR cvterm.name = 'modified_RNA_base_feature';

--- ************************************************
--- *** relation: rrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** RNA that comprises part of a ribosome, a ***
--- *** nd that can provide both structural scaf ***
--- *** folding and catalytic activity.          ***
--- ************************************************
---

CREATE VIEW rrna AS
  SELECT
    feature_id AS rrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'small_subunit_rRNA' OR cvterm.name = 'large_subunit_rRNA' OR cvterm.name = 'rRNA_18S' OR cvterm.name = 'rRNA_16S' OR cvterm.name = 'rRNA_5_8S' OR cvterm.name = 'rRNA_5S' OR cvterm.name = 'rRNA_28S' OR cvterm.name = 'rRNA_23S' OR cvterm.name = 'rRNA_25S' OR cvterm.name = 'rRNA_21S' OR cvterm.name = 'rRNA';

--- ************************************************
--- *** relation: trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Transfer RNA (tRNA) molecules are approx ***
--- *** imately 80 nucleotides in length. Their  ***
--- *** secondary structure includes four short  ***
--- *** double-helical elements and three loops  ***
--- *** (D, anti-codon, and T loops). Further hy ***
--- *** drogen bonds mediate the characteristic  ***
--- *** L-shaped molecular structure. Transfer R ***
--- *** NAs have two regions of fundamental func ***
--- *** tional importance: the anti-codon, which ***
--- ***  is responsible for specific mRNA codon  ***
--- *** recognition, and the 3' end, to which th ***
--- *** e tRNA's corresponding amino acid is att ***
--- *** ached (by aminoacyl-tRNA synthetases). T ***
--- *** ransfer RNAs cope with the degeneracy of ***
--- ***  the genetic code in two manners: having ***
--- ***  more than one tRNA (with a specific ant ***
--- *** i-codon) for a particular amino acid; an ***
--- *** d 'wobble' base-pairing, i.e. permitting ***
--- ***  non-standard base-pairing at the 3rd an ***
--- *** ti-codon position.                       ***
--- ************************************************
---

CREATE VIEW trna AS
  SELECT
    feature_id AS trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'alanyl_tRNA' OR cvterm.name = 'asparaginyl_tRNA' OR cvterm.name = 'aspartyl_tRNA' OR cvterm.name = 'cysteinyl_tRNA' OR cvterm.name = 'glutaminyl_tRNA' OR cvterm.name = 'glutamyl_tRNA' OR cvterm.name = 'glycyl_tRNA' OR cvterm.name = 'histidyl_tRNA' OR cvterm.name = 'isoleucyl_tRNA' OR cvterm.name = 'leucyl_tRNA' OR cvterm.name = 'lysyl_tRNA' OR cvterm.name = 'methionyl_tRNA' OR cvterm.name = 'phenylalanyl_tRNA' OR cvterm.name = 'prolyl_tRNA' OR cvterm.name = 'seryl_tRNA' OR cvterm.name = 'threonyl_tRNA' OR cvterm.name = 'tryptophanyl_tRNA' OR cvterm.name = 'tyrosyl_tRNA' OR cvterm.name = 'valyl_tRNA' OR cvterm.name = 'pyrrolysyl_tRNA' OR cvterm.name = 'arginyl_tRNA' OR cvterm.name = 'selenocysteinyl_tRNA' OR cvterm.name = 'tRNA';

--- ************************************************
--- *** relation: alanyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has an alanine anti ***
--- *** codon, and a 3' alanine binding region.  ***
--- ************************************************
---

CREATE VIEW alanyl_trna AS
  SELECT
    feature_id AS alanyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'alanyl_tRNA';

--- ************************************************
--- *** relation: rrna_small_subunit_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a small ri ***
--- *** bosomal subunit RNA.                     ***
--- ************************************************
---

CREATE VIEW rrna_small_subunit_primary_transcript AS
  SELECT
    feature_id AS rrna_small_subunit_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_small_subunit_primary_transcript';

--- ************************************************
--- *** relation: asparaginyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has an asparagine a ***
--- *** nticodon, and a 3' asparagine binding re ***
--- *** gion.                                    ***
--- ************************************************
---

CREATE VIEW asparaginyl_trna AS
  SELECT
    feature_id AS asparaginyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'asparaginyl_tRNA';

--- ************************************************
--- *** relation: aspartyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has an aspartic aci ***
--- *** d anticodon, and a 3' aspartic acid bind ***
--- *** ing region.                              ***
--- ************************************************
---

CREATE VIEW aspartyl_trna AS
  SELECT
    feature_id AS aspartyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'aspartyl_tRNA';

--- ************************************************
--- *** relation: cysteinyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has a cysteine anti ***
--- *** codon, and a 3' cysteine binding region. ***
--- ************************************************
---

CREATE VIEW cysteinyl_trna AS
  SELECT
    feature_id AS cysteinyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cysteinyl_tRNA';

--- ************************************************
--- *** relation: glutaminyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has a glutamine ant ***
--- *** icodon, and a 3' glutamine binding regio ***
--- *** n.                                       ***
--- ************************************************
---

CREATE VIEW glutaminyl_trna AS
  SELECT
    feature_id AS glutaminyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'glutaminyl_tRNA';

--- ************************************************
--- *** relation: glutamyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has a glutamic acid ***
--- ***  anticodon, and a 3' glutamic acid bindi ***
--- *** ng region.                               ***
--- ************************************************
---

CREATE VIEW glutamyl_trna AS
  SELECT
    feature_id AS glutamyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'glutamyl_tRNA';

--- ************************************************
--- *** relation: glycyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has a glycine antic ***
--- *** odon, and a 3' glycine binding region.   ***
--- ************************************************
---

CREATE VIEW glycyl_trna AS
  SELECT
    feature_id AS glycyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'glycyl_tRNA';

--- ************************************************
--- *** relation: histidyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has a histidine ant ***
--- *** icodon, and a 3' histidine binding regio ***
--- *** n.                                       ***
--- ************************************************
---

CREATE VIEW histidyl_trna AS
  SELECT
    feature_id AS histidyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'histidyl_tRNA';

--- ************************************************
--- *** relation: isoleucyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has an isoleucine a ***
--- *** nticodon, and a 3' isoleucine binding re ***
--- *** gion.                                    ***
--- ************************************************
---

CREATE VIEW isoleucyl_trna AS
  SELECT
    feature_id AS isoleucyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'isoleucyl_tRNA';

--- ************************************************
--- *** relation: leucyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has a leucine antic ***
--- *** odon, and a 3' leucine binding region.   ***
--- ************************************************
---

CREATE VIEW leucyl_trna AS
  SELECT
    feature_id AS leucyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'leucyl_tRNA';

--- ************************************************
--- *** relation: lysyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has a lysine antico ***
--- *** don, and a 3' lysine binding region.     ***
--- ************************************************
---

CREATE VIEW lysyl_trna AS
  SELECT
    feature_id AS lysyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'lysyl_tRNA';

--- ************************************************
--- *** relation: methionyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has a methionine an ***
--- *** ticodon, and a 3' methionine binding reg ***
--- *** ion.                                     ***
--- ************************************************
---

CREATE VIEW methionyl_trna AS
  SELECT
    feature_id AS methionyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'methionyl_tRNA';

--- ************************************************
--- *** relation: phenylalanyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has a phenylalanine ***
--- ***  anticodon, and a 3' phenylalanine bindi ***
--- *** ng region.                               ***
--- ************************************************
---

CREATE VIEW phenylalanyl_trna AS
  SELECT
    feature_id AS phenylalanyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'phenylalanyl_tRNA';

--- ************************************************
--- *** relation: prolyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has a proline antic ***
--- *** odon, and a 3' proline binding region.   ***
--- ************************************************
---

CREATE VIEW prolyl_trna AS
  SELECT
    feature_id AS prolyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'prolyl_tRNA';

--- ************************************************
--- *** relation: seryl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has a serine antico ***
--- *** don, and a 3' serine binding region.     ***
--- ************************************************
---

CREATE VIEW seryl_trna AS
  SELECT
    feature_id AS seryl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'seryl_tRNA';

--- ************************************************
--- *** relation: threonyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has a threonine ant ***
--- *** icodon, and a 3' threonine binding regio ***
--- *** n.                                       ***
--- ************************************************
---

CREATE VIEW threonyl_trna AS
  SELECT
    feature_id AS threonyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'threonyl_tRNA';

--- ************************************************
--- *** relation: tryptophanyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has a tryptophan an ***
--- *** ticodon, and a 3' tryptophan binding reg ***
--- *** ion.                                     ***
--- ************************************************
---

CREATE VIEW tryptophanyl_trna AS
  SELECT
    feature_id AS tryptophanyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tryptophanyl_tRNA';

--- ************************************************
--- *** relation: tyrosyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has a tyrosine anti ***
--- *** codon, and a 3' tyrosine binding region. ***
--- ************************************************
---

CREATE VIEW tyrosyl_trna AS
  SELECT
    feature_id AS tyrosyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tyrosyl_tRNA';

--- ************************************************
--- *** relation: valyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has a valine antico ***
--- *** don, and a 3' valine binding region.     ***
--- ************************************************
---

CREATE VIEW valyl_trna AS
  SELECT
    feature_id AS valyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'valyl_tRNA';

--- ************************************************
--- *** relation: snrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A small nuclear RNA molecule involved in ***
--- ***  pre-mRNA splicing and processing.       ***
--- ************************************************
---

CREATE VIEW snrna AS
  SELECT
    feature_id AS snrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U1_snRNA' OR cvterm.name = 'U2_snRNA' OR cvterm.name = 'U4_snRNA' OR cvterm.name = 'U4atac_snRNA' OR cvterm.name = 'U5_snRNA' OR cvterm.name = 'U6_snRNA' OR cvterm.name = 'U6atac_snRNA' OR cvterm.name = 'U11_snRNA' OR cvterm.name = 'U12_snRNA' OR cvterm.name = 'snRNA';

--- ************************************************
--- *** relation: snorna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A snoRNA (small nucleolar RNA) is any on ***
--- *** e of a class of small RNAs that are asso ***
--- *** ciated with the eukaryotic nucleus as co ***
--- *** mponents of small nucleolar ribonucleopr ***
--- *** oteins. They participate in the processi ***
--- *** ng or modifications of many RNAs, mostly ***
--- ***  ribosomal RNAs (rRNAs) though snoRNAs a ***
--- *** re also known to target other classes of ***
--- ***  RNA, including spliceosomal RNAs, tRNAs ***
--- *** , and mRNAs via a stretch of sequence th ***
--- *** at is complementary to a sequence in the ***
--- ***  targeted RNA.                           ***
--- ************************************************
---

CREATE VIEW snorna AS
  SELECT
    feature_id AS snorna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'C_D_box_snoRNA' OR cvterm.name = 'H_ACA_box_snoRNA' OR cvterm.name = 'U14_snoRNA' OR cvterm.name = 'U3_snoRNA' OR cvterm.name = 'methylation_guide_snoRNA' OR cvterm.name = 'pseudouridylation_guide_snoRNA' OR cvterm.name = 'snoRNA';

--- ************************************************
--- *** relation: mirna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Small, ~22-nt, RNA molecule that is the  ***
--- *** endogenous transcript of a miRNA gene. M ***
--- *** icro RNAs are produced from precursor mo ***
--- *** lecules (SO:0000647) that can form local ***
--- ***  hairpin structures, which ordinarily ar ***
--- *** e processed (via the Dicer pathway) such ***
--- ***  that a single miRNA molecule accumulate ***
--- *** s from one arm of a hairpin precursor mo ***
--- *** lecule. Micro RNAs may trigger the cleav ***
--- *** age of their target molecules or act as  ***
--- *** translational repressors.                ***
--- ************************************************
---

CREATE VIEW mirna AS
  SELECT
    feature_id AS mirna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'miRNA';

--- ************************************************
--- *** relation: bound_by_factor ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence that  ***
--- *** is bound by another molecule.            ***
--- ************************************************
---

CREATE VIEW bound_by_factor AS
  SELECT
    feature_id AS bound_by_factor_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'bound_by_protein' OR cvterm.name = 'bound_by_nucleic_acid' OR cvterm.name = 'bound_by_factor';

--- ************************************************
--- *** relation: transcript_bound_by_nucleic_acid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transcript that is bound by a nucleic  ***
--- *** acid.                                    ***
--- ************************************************
---

CREATE VIEW transcript_bound_by_nucleic_acid AS
  SELECT
    feature_id AS transcript_bound_by_nucleic_acid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transcript_bound_by_nucleic_acid';

--- ************************************************
--- *** relation: transcript_bound_by_protein ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transcript that is bound by a protein. ***
--- ************************************************
---

CREATE VIEW transcript_bound_by_protein AS
  SELECT
    feature_id AS transcript_bound_by_protein_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transcript_bound_by_protein';

--- ************************************************
--- *** relation: engineered_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that is engineered.               ***
--- ************************************************
---

CREATE VIEW engineered_gene AS
  SELECT
    feature_id AS engineered_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_foreign_gene' OR cvterm.name = 'engineered_fusion_gene' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'engineered_gene';

--- ************************************************
--- *** relation: engineered_foreign_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that is engineered and foreign.   ***
--- ************************************************
---

CREATE VIEW engineered_foreign_gene AS
  SELECT
    feature_id AS engineered_foreign_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'engineered_foreign_gene';

--- ************************************************
--- *** relation: mrna_with_minus_1_frameshift ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An mRNA with a minus 1 frameshift.       ***
--- ************************************************
---

CREATE VIEW mrna_with_minus_1_frameshift AS
  SELECT
    feature_id AS mrna_with_minus_1_frameshift_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mRNA_with_minus_1_frameshift';

--- ************************************************
--- *** relation: engineered_foreign_transposable_element_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transposable_element that is engineere ***
--- *** d and foreign.                           ***
--- ************************************************
---

CREATE VIEW engineered_foreign_transposable_element_gene AS
  SELECT
    feature_id AS engineered_foreign_transposable_element_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_foreign_transposable_element_gene';

--- ************************************************
--- *** relation: foreign_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that is foreign.                  ***
--- ************************************************
---

CREATE VIEW foreign_gene AS
  SELECT
    feature_id AS foreign_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_foreign_gene' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'foreign_gene';

--- ************************************************
--- *** relation: long_terminal_repeat ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence directly repeated at both end ***
--- *** s of a defined sequence, of the sort typ ***
--- *** ically found in retroviruses.            ***
--- ************************************************
---

CREATE VIEW long_terminal_repeat AS
  SELECT
    feature_id AS long_terminal_repeat_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_LTR' OR cvterm.name = 'three_prime_LTR' OR cvterm.name = 'solo_LTR' OR cvterm.name = 'long_terminal_repeat';

--- ************************************************
--- *** relation: fusion_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that is a fusion.                 ***
--- ************************************************
---

CREATE VIEW fusion_gene AS
  SELECT
    feature_id AS fusion_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_fusion_gene' OR cvterm.name = 'fusion_gene';

--- ************************************************
--- *** relation: engineered_fusion_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A fusion gene that is engineered.        ***
--- ************************************************
---

CREATE VIEW engineered_fusion_gene AS
  SELECT
    feature_id AS engineered_fusion_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_fusion_gene';

--- ************************************************
--- *** relation: microsatellite ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A repeat_region containing repeat_units  ***
--- *** (2 to 4 bp) that is repeated multiple ti ***
--- *** mes in tandem.                           ***
--- ************************************************
---

CREATE VIEW microsatellite AS
  SELECT
    feature_id AS microsatellite_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'dinucleotide_repeat_microsatellite_feature' OR cvterm.name = 'trinucleotide_repeat_microsatellite_feature' OR cvterm.name = 'tetranucleotide_repeat_microsatellite_feature' OR cvterm.name = 'microsatellite';

--- ************************************************
--- *** relation: dinucleotide_repeat_microsatellite_feature ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW dinucleotide_repeat_microsatellite_feature AS
  SELECT
    feature_id AS dinucleotide_repeat_microsatellite_feature_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'dinucleotide_repeat_microsatellite_feature';

--- ************************************************
--- *** relation: trinuc_repeat_microsat ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW trinuc_repeat_microsat AS
  SELECT
    feature_id AS trinuc_repeat_microsat_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'trinucleotide_repeat_microsatellite_feature';

--- ************************************************
--- *** relation: engineered_foreign_repetitive_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A repetitive element that is engineered  ***
--- *** and foreign.                             ***
--- ************************************************
---

CREATE VIEW engineered_foreign_repetitive_element AS
  SELECT
    feature_id AS engineered_foreign_repetitive_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_foreign_repetitive_element';

--- ************************************************
--- *** relation: inverted_repeat ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The sequence is complementarily repeated ***
--- ***  on the opposite strand. It is a palindr ***
--- *** ome, and it may, or may not be hyphenate ***
--- *** d. Examples: GCTGATCAGC, or GCTGA-----TC ***
--- *** AGC.                                     ***
--- ************************************************
---

CREATE VIEW inverted_repeat AS
  SELECT
    feature_id AS inverted_repeat_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'terminal_inverted_repeat' OR cvterm.name = 'five_prime_terminal_inverted_repeat' OR cvterm.name = 'three_prime_terminal_inverted_repeat' OR cvterm.name = 'inverted_repeat';

--- ************************************************
--- *** relation: u12_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A type of spliceosomal intron spliced by ***
--- ***  the U12 spliceosome, that includes U11, ***
--- ***  U12, U4atac/U6atac and U5 snRNAs.       ***
--- ************************************************
---

CREATE VIEW u12_intron AS
  SELECT
    feature_id AS u12_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U12_intron';

--- ************************************************
--- *** relation: origin_of_replication ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The origin of replication; starting site ***
--- ***  for duplication of a nucleic acid molec ***
--- *** ule to give two identical copies.        ***
--- ************************************************
---

CREATE VIEW origin_of_replication AS
  SELECT
    feature_id AS origin_of_replication_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'D_loop' OR cvterm.name = 'ARS' OR cvterm.name = 'oriT' OR cvterm.name = 'amplification_origin' OR cvterm.name = 'oriV' OR cvterm.name = 'oriC' OR cvterm.name = 'origin_of_replication';

--- ************************************************
--- *** relation: d_loop ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Displacement loop; a region within mitoc ***
--- *** hondrial DNA in which a short stretch of ***
--- ***  RNA is paired with one strand of DNA, d ***
--- *** isplacing the original partner DNA stran ***
--- *** d in this region; also used to describe  ***
--- *** the displacement of a region of one stra ***
--- *** nd of duplex DNA by a single stranded in ***
--- *** vader in the reaction catalyzed by RecA  ***
--- *** protein.                                 ***
--- ************************************************
---

CREATE VIEW d_loop AS
  SELECT
    feature_id AS d_loop_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'D_loop';

--- ************************************************
--- *** relation: recombination_feature ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW recombination_feature AS
  SELECT
    feature_id AS recombination_feature_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'recombination_hotspot' OR cvterm.name = 'haplotype_block' OR cvterm.name = 'sequence_rearrangement_feature' OR cvterm.name = 'iDNA' OR cvterm.name = 'specific_recombination_site' OR cvterm.name = 'chromosome_breakage_sequence' OR cvterm.name = 'internal_eliminated_sequence' OR cvterm.name = 'macronucleus_destined_segment' OR cvterm.name = 'recombination_feature_of_rearranged_gene' OR cvterm.name = 'site_specific_recombination_target_region' OR cvterm.name = 'recombination_signal_sequence' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_feature' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_segment' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_gene_cluster' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_spacer' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_segment' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_gene_cluster' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_signal_feature' OR cvterm.name = 'D_gene' OR cvterm.name = 'V_gene' OR cvterm.name = 'J_gene' OR cvterm.name = 'C_gene' OR cvterm.name = 'D_J_C_cluster' OR cvterm.name = 'J_C_cluster' OR cvterm.name = 'J_cluster' OR cvterm.name = 'V_cluster' OR cvterm.name = 'V_J_cluster' OR cvterm.name = 'V_J_C_cluster' OR cvterm.name = 'C_cluster' OR cvterm.name = 'D_cluster' OR cvterm.name = 'D_J_cluster' OR cvterm.name = 'three_prime_D_spacer' OR cvterm.name = 'five_prime_D_spacer' OR cvterm.name = 'J_spacer' OR cvterm.name = 'V_spacer' OR cvterm.name = 'VD_gene' OR cvterm.name = 'DJ_gene' OR cvterm.name = 'VDJ_gene' OR cvterm.name = 'VJ_gene' OR cvterm.name = 'DJ_J_cluster' OR cvterm.name = 'VDJ_J_C_cluster' OR cvterm.name = 'VDJ_J_cluster' OR cvterm.name = 'VJ_C_cluster' OR cvterm.name = 'VJ_J_C_cluster' OR cvterm.name = 'VJ_J_cluster' OR cvterm.name = 'D_DJ_C_cluster' OR cvterm.name = 'D_DJ_cluster' OR cvterm.name = 'D_DJ_J_C_cluster' OR cvterm.name = 'D_DJ_J_cluster' OR cvterm.name = 'V_DJ_cluster' OR cvterm.name = 'V_DJ_J_cluster' OR cvterm.name = 'V_VDJ_C_cluster' OR cvterm.name = 'V_VDJ_cluster' OR cvterm.name = 'V_VDJ_J_cluster' OR cvterm.name = 'V_VJ_C_cluster' OR cvterm.name = 'V_VJ_cluster' OR cvterm.name = 'V_VJ_J_cluster' OR cvterm.name = 'V_D_DJ_C_cluster' OR cvterm.name = 'V_D_DJ_cluster' OR cvterm.name = 'V_D_DJ_J_C_cluster' OR cvterm.name = 'V_D_DJ_J_cluster' OR cvterm.name = 'V_D_J_C_cluster' OR cvterm.name = 'V_D_J_cluster' OR cvterm.name = 'DJ_C_cluster' OR cvterm.name = 'DJ_J_C_cluster' OR cvterm.name = 'VDJ_C_cluster' OR cvterm.name = 'V_DJ_C_cluster' OR cvterm.name = 'V_DJ_J_C_cluster' OR cvterm.name = 'V_VDJ_J_C_cluster' OR cvterm.name = 'V_VJ_J_C_cluster' OR cvterm.name = 'J_gene_recombination_feature' OR cvterm.name = 'D_gene_recombination_feature' OR cvterm.name = 'V_gene_recombination_feature' OR cvterm.name = 'heptamer_of_recombination_feature_of_vertebrate_immune_system_gene' OR cvterm.name = 'nonamer_of_recombination_feature_of_vertebrate_immune_system_gene' OR cvterm.name = 'five_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_heptamer' OR cvterm.name = 'five_prime_D_heptamer' OR cvterm.name = 'J_heptamer' OR cvterm.name = 'V_heptamer' OR cvterm.name = 'three_prime_D_nonamer' OR cvterm.name = 'five_prime_D_nonamer' OR cvterm.name = 'J_nonamer' OR cvterm.name = 'V_nonamer' OR cvterm.name = 'integration_excision_site' OR cvterm.name = 'resolution_site' OR cvterm.name = 'inversion_site' OR cvterm.name = 'inversion_site_part' OR cvterm.name = 'attI_site' OR cvterm.name = 'attP_site' OR cvterm.name = 'attB_site' OR cvterm.name = 'attL_site' OR cvterm.name = 'attR_site' OR cvterm.name = 'attC_site' OR cvterm.name = 'attCtn_site' OR cvterm.name = 'loxP_site' OR cvterm.name = 'dif_site' OR cvterm.name = 'FRT_site' OR cvterm.name = 'IRLinv_site' OR cvterm.name = 'IRRinv_site' OR cvterm.name = 'recombination_feature';

--- ************************************************
--- *** relation: specific_recombination_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW specific_recombination_site AS
  SELECT
    feature_id AS specific_recombination_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'recombination_feature_of_rearranged_gene' OR cvterm.name = 'site_specific_recombination_target_region' OR cvterm.name = 'recombination_signal_sequence' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_feature' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_segment' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_gene_cluster' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_spacer' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_segment' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_gene_cluster' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_signal_feature' OR cvterm.name = 'D_gene' OR cvterm.name = 'V_gene' OR cvterm.name = 'J_gene' OR cvterm.name = 'C_gene' OR cvterm.name = 'D_J_C_cluster' OR cvterm.name = 'J_C_cluster' OR cvterm.name = 'J_cluster' OR cvterm.name = 'V_cluster' OR cvterm.name = 'V_J_cluster' OR cvterm.name = 'V_J_C_cluster' OR cvterm.name = 'C_cluster' OR cvterm.name = 'D_cluster' OR cvterm.name = 'D_J_cluster' OR cvterm.name = 'three_prime_D_spacer' OR cvterm.name = 'five_prime_D_spacer' OR cvterm.name = 'J_spacer' OR cvterm.name = 'V_spacer' OR cvterm.name = 'VD_gene' OR cvterm.name = 'DJ_gene' OR cvterm.name = 'VDJ_gene' OR cvterm.name = 'VJ_gene' OR cvterm.name = 'DJ_J_cluster' OR cvterm.name = 'VDJ_J_C_cluster' OR cvterm.name = 'VDJ_J_cluster' OR cvterm.name = 'VJ_C_cluster' OR cvterm.name = 'VJ_J_C_cluster' OR cvterm.name = 'VJ_J_cluster' OR cvterm.name = 'D_DJ_C_cluster' OR cvterm.name = 'D_DJ_cluster' OR cvterm.name = 'D_DJ_J_C_cluster' OR cvterm.name = 'D_DJ_J_cluster' OR cvterm.name = 'V_DJ_cluster' OR cvterm.name = 'V_DJ_J_cluster' OR cvterm.name = 'V_VDJ_C_cluster' OR cvterm.name = 'V_VDJ_cluster' OR cvterm.name = 'V_VDJ_J_cluster' OR cvterm.name = 'V_VJ_C_cluster' OR cvterm.name = 'V_VJ_cluster' OR cvterm.name = 'V_VJ_J_cluster' OR cvterm.name = 'V_D_DJ_C_cluster' OR cvterm.name = 'V_D_DJ_cluster' OR cvterm.name = 'V_D_DJ_J_C_cluster' OR cvterm.name = 'V_D_DJ_J_cluster' OR cvterm.name = 'V_D_J_C_cluster' OR cvterm.name = 'V_D_J_cluster' OR cvterm.name = 'DJ_C_cluster' OR cvterm.name = 'DJ_J_C_cluster' OR cvterm.name = 'VDJ_C_cluster' OR cvterm.name = 'V_DJ_C_cluster' OR cvterm.name = 'V_DJ_J_C_cluster' OR cvterm.name = 'V_VDJ_J_C_cluster' OR cvterm.name = 'V_VJ_J_C_cluster' OR cvterm.name = 'J_gene_recombination_feature' OR cvterm.name = 'D_gene_recombination_feature' OR cvterm.name = 'V_gene_recombination_feature' OR cvterm.name = 'heptamer_of_recombination_feature_of_vertebrate_immune_system_gene' OR cvterm.name = 'nonamer_of_recombination_feature_of_vertebrate_immune_system_gene' OR cvterm.name = 'five_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_heptamer' OR cvterm.name = 'five_prime_D_heptamer' OR cvterm.name = 'J_heptamer' OR cvterm.name = 'V_heptamer' OR cvterm.name = 'three_prime_D_nonamer' OR cvterm.name = 'five_prime_D_nonamer' OR cvterm.name = 'J_nonamer' OR cvterm.name = 'V_nonamer' OR cvterm.name = 'integration_excision_site' OR cvterm.name = 'resolution_site' OR cvterm.name = 'inversion_site' OR cvterm.name = 'inversion_site_part' OR cvterm.name = 'attI_site' OR cvterm.name = 'attP_site' OR cvterm.name = 'attB_site' OR cvterm.name = 'attL_site' OR cvterm.name = 'attR_site' OR cvterm.name = 'attC_site' OR cvterm.name = 'attCtn_site' OR cvterm.name = 'loxP_site' OR cvterm.name = 'dif_site' OR cvterm.name = 'FRT_site' OR cvterm.name = 'IRLinv_site' OR cvterm.name = 'IRRinv_site' OR cvterm.name = 'specific_recombination_site';

--- ************************************************
--- *** relation: recombination_feature_of_rearranged_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW recombination_feature_of_rearranged_gene AS
  SELECT
    feature_id AS recombination_feature_of_rearranged_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'vertebrate_immune_system_gene_recombination_feature' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_segment' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_gene_cluster' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_spacer' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_segment' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_gene_cluster' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_signal_feature' OR cvterm.name = 'D_gene' OR cvterm.name = 'V_gene' OR cvterm.name = 'J_gene' OR cvterm.name = 'C_gene' OR cvterm.name = 'D_J_C_cluster' OR cvterm.name = 'J_C_cluster' OR cvterm.name = 'J_cluster' OR cvterm.name = 'V_cluster' OR cvterm.name = 'V_J_cluster' OR cvterm.name = 'V_J_C_cluster' OR cvterm.name = 'C_cluster' OR cvterm.name = 'D_cluster' OR cvterm.name = 'D_J_cluster' OR cvterm.name = 'three_prime_D_spacer' OR cvterm.name = 'five_prime_D_spacer' OR cvterm.name = 'J_spacer' OR cvterm.name = 'V_spacer' OR cvterm.name = 'VD_gene' OR cvterm.name = 'DJ_gene' OR cvterm.name = 'VDJ_gene' OR cvterm.name = 'VJ_gene' OR cvterm.name = 'DJ_J_cluster' OR cvterm.name = 'VDJ_J_C_cluster' OR cvterm.name = 'VDJ_J_cluster' OR cvterm.name = 'VJ_C_cluster' OR cvterm.name = 'VJ_J_C_cluster' OR cvterm.name = 'VJ_J_cluster' OR cvterm.name = 'D_DJ_C_cluster' OR cvterm.name = 'D_DJ_cluster' OR cvterm.name = 'D_DJ_J_C_cluster' OR cvterm.name = 'D_DJ_J_cluster' OR cvterm.name = 'V_DJ_cluster' OR cvterm.name = 'V_DJ_J_cluster' OR cvterm.name = 'V_VDJ_C_cluster' OR cvterm.name = 'V_VDJ_cluster' OR cvterm.name = 'V_VDJ_J_cluster' OR cvterm.name = 'V_VJ_C_cluster' OR cvterm.name = 'V_VJ_cluster' OR cvterm.name = 'V_VJ_J_cluster' OR cvterm.name = 'V_D_DJ_C_cluster' OR cvterm.name = 'V_D_DJ_cluster' OR cvterm.name = 'V_D_DJ_J_C_cluster' OR cvterm.name = 'V_D_DJ_J_cluster' OR cvterm.name = 'V_D_J_C_cluster' OR cvterm.name = 'V_D_J_cluster' OR cvterm.name = 'DJ_C_cluster' OR cvterm.name = 'DJ_J_C_cluster' OR cvterm.name = 'VDJ_C_cluster' OR cvterm.name = 'V_DJ_C_cluster' OR cvterm.name = 'V_DJ_J_C_cluster' OR cvterm.name = 'V_VDJ_J_C_cluster' OR cvterm.name = 'V_VJ_J_C_cluster' OR cvterm.name = 'J_gene_recombination_feature' OR cvterm.name = 'D_gene_recombination_feature' OR cvterm.name = 'V_gene_recombination_feature' OR cvterm.name = 'heptamer_of_recombination_feature_of_vertebrate_immune_system_gene' OR cvterm.name = 'nonamer_of_recombination_feature_of_vertebrate_immune_system_gene' OR cvterm.name = 'five_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_heptamer' OR cvterm.name = 'five_prime_D_heptamer' OR cvterm.name = 'J_heptamer' OR cvterm.name = 'V_heptamer' OR cvterm.name = 'three_prime_D_nonamer' OR cvterm.name = 'five_prime_D_nonamer' OR cvterm.name = 'J_nonamer' OR cvterm.name = 'V_nonamer' OR cvterm.name = 'recombination_feature_of_rearranged_gene';

--- ************************************************
--- *** relation: vertebrate_immune_system_gene_recombination_feature ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW vertebrate_immune_system_gene_recombination_feature AS
  SELECT
    feature_id AS vertebrate_immune_system_gene_recombination_feature_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_segment' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_gene_cluster' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_spacer' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_segment' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_gene_cluster' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_signal_feature' OR cvterm.name = 'D_gene' OR cvterm.name = 'V_gene' OR cvterm.name = 'J_gene' OR cvterm.name = 'C_gene' OR cvterm.name = 'D_J_C_cluster' OR cvterm.name = 'J_C_cluster' OR cvterm.name = 'J_cluster' OR cvterm.name = 'V_cluster' OR cvterm.name = 'V_J_cluster' OR cvterm.name = 'V_J_C_cluster' OR cvterm.name = 'C_cluster' OR cvterm.name = 'D_cluster' OR cvterm.name = 'D_J_cluster' OR cvterm.name = 'three_prime_D_spacer' OR cvterm.name = 'five_prime_D_spacer' OR cvterm.name = 'J_spacer' OR cvterm.name = 'V_spacer' OR cvterm.name = 'VD_gene' OR cvterm.name = 'DJ_gene' OR cvterm.name = 'VDJ_gene' OR cvterm.name = 'VJ_gene' OR cvterm.name = 'DJ_J_cluster' OR cvterm.name = 'VDJ_J_C_cluster' OR cvterm.name = 'VDJ_J_cluster' OR cvterm.name = 'VJ_C_cluster' OR cvterm.name = 'VJ_J_C_cluster' OR cvterm.name = 'VJ_J_cluster' OR cvterm.name = 'D_DJ_C_cluster' OR cvterm.name = 'D_DJ_cluster' OR cvterm.name = 'D_DJ_J_C_cluster' OR cvterm.name = 'D_DJ_J_cluster' OR cvterm.name = 'V_DJ_cluster' OR cvterm.name = 'V_DJ_J_cluster' OR cvterm.name = 'V_VDJ_C_cluster' OR cvterm.name = 'V_VDJ_cluster' OR cvterm.name = 'V_VDJ_J_cluster' OR cvterm.name = 'V_VJ_C_cluster' OR cvterm.name = 'V_VJ_cluster' OR cvterm.name = 'V_VJ_J_cluster' OR cvterm.name = 'V_D_DJ_C_cluster' OR cvterm.name = 'V_D_DJ_cluster' OR cvterm.name = 'V_D_DJ_J_C_cluster' OR cvterm.name = 'V_D_DJ_J_cluster' OR cvterm.name = 'V_D_J_C_cluster' OR cvterm.name = 'V_D_J_cluster' OR cvterm.name = 'DJ_C_cluster' OR cvterm.name = 'DJ_J_C_cluster' OR cvterm.name = 'VDJ_C_cluster' OR cvterm.name = 'V_DJ_C_cluster' OR cvterm.name = 'V_DJ_J_C_cluster' OR cvterm.name = 'V_VDJ_J_C_cluster' OR cvterm.name = 'V_VJ_J_C_cluster' OR cvterm.name = 'J_gene_recombination_feature' OR cvterm.name = 'D_gene_recombination_feature' OR cvterm.name = 'V_gene_recombination_feature' OR cvterm.name = 'heptamer_of_recombination_feature_of_vertebrate_immune_system_gene' OR cvterm.name = 'nonamer_of_recombination_feature_of_vertebrate_immune_system_gene' OR cvterm.name = 'five_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_heptamer' OR cvterm.name = 'five_prime_D_heptamer' OR cvterm.name = 'J_heptamer' OR cvterm.name = 'V_heptamer' OR cvterm.name = 'three_prime_D_nonamer' OR cvterm.name = 'five_prime_D_nonamer' OR cvterm.name = 'J_nonamer' OR cvterm.name = 'V_nonamer' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_feature';

--- ************************************************
--- *** relation: j_gene_recombination_feature ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Recombination signal including J-heptame ***
--- *** r, J-spacer and J-nonamer in 5' of J-reg ***
--- *** ion of a J-gene or J-sequence.           ***
--- ************************************************
---

CREATE VIEW j_gene_recombination_feature AS
  SELECT
    feature_id AS j_gene_recombination_feature_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'J_gene_recombination_feature';

--- ************************************************
--- *** relation: clip ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Part of the primary transcript that is c ***
--- *** lipped off during processing.            ***
--- ************************************************
---

CREATE VIEW clip AS
  SELECT
    feature_id AS clip_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_clip' OR cvterm.name = 'three_prime_clip' OR cvterm.name = 'clip';

--- ************************************************
--- *** relation: modified_base ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A modified nucleotide, i.e. a nucleotide ***
--- ***  other than A, T, C. G.                  ***
--- ************************************************
---

CREATE VIEW modified_base AS
  SELECT
    feature_id AS modified_base_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'methylated_base_feature' OR cvterm.name = 'methylated_C' OR cvterm.name = 'methylated_A' OR cvterm.name = 'modified_base';

--- ************************************************
--- *** relation: methylated_base_feature ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A nucleotide modified by methylation.    ***
--- ************************************************
---

CREATE VIEW methylated_base_feature AS
  SELECT
    feature_id AS methylated_base_feature_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'methylated_C' OR cvterm.name = 'methylated_A' OR cvterm.name = 'methylated_base_feature';

--- ************************************************
--- *** relation: cpg_island ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Regions of a few hundred to a few thousa ***
--- *** nd bases in vertebrate genomes that are  ***
--- *** relatively GC and CpG rich; they are typ ***
--- *** ically unmethylated and often found near ***
--- ***  the 5' ends of genes.                   ***
--- ************************************************
---

CREATE VIEW cpg_island AS
  SELECT
    feature_id AS cpg_island_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'CpG_island';

--- ************************************************
--- *** relation: experimentally_determined ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Attribute to describe a feature that has ***
--- ***  been experimentally verified.           ***
--- ************************************************
---

CREATE VIEW experimentally_determined AS
  SELECT
    feature_id AS experimentally_determined_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'experimentally_determined';

--- ************************************************
--- *** relation: stem_loop ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A double-helical region of nucleic acid  ***
--- *** formed by base-pairing between adjacent  ***
--- *** (inverted) complementary sequences.      ***
--- ************************************************
---

CREATE VIEW stem_loop AS
  SELECT
    feature_id AS stem_loop_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tetraloop' OR cvterm.name = 'stem_loop';

--- ************************************************
--- *** relation: direct_repeat ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A repeat where the same sequence is repe ***
--- *** ated in the same direction. Example: GCT ***
--- *** GA-----GCTGA.                            ***
--- ************************************************
---

CREATE VIEW direct_repeat AS
  SELECT
    feature_id AS direct_repeat_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'target_site_duplication' OR cvterm.name = 'CRISPR' OR cvterm.name = 'direct_repeat';

--- ************************************************
--- *** relation: tss ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The first base where RNA polymerase begi ***
--- *** ns to synthesize the RNA transcript.     ***
--- ************************************************
---

CREATE VIEW tss AS
  SELECT
    feature_id AS tss_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'major_TSS' OR cvterm.name = 'minor_TSS' OR cvterm.name = 'TSS';

--- ************************************************
--- *** relation: cds ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A contiguous sequence which begins with, ***
--- ***  and includes, a start codon and ends wi ***
--- *** th, and includes, a stop codon.          ***
--- ************************************************
---

CREATE VIEW cds AS
  SELECT
    feature_id AS cds_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'edited_CDS' OR cvterm.name = 'CDS_fragment' OR cvterm.name = 'CDS_independently_known' OR cvterm.name = 'CDS_predicted' OR cvterm.name = 'orphan_CDS' OR cvterm.name = 'CDS_supported_by_sequence_similarity_data' OR cvterm.name = 'CDS_supported_by_domain_match_data' OR cvterm.name = 'CDS_supported_by_EST_or_cDNA_data' OR cvterm.name = 'CDS';

--- ************************************************
--- *** relation: cdna_clone ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Complementary DNA; A piece of DNA copied ***
--- ***  from an mRNA and spliced into a vector  ***
--- *** for propagation in a suitable host.      ***
--- ************************************************
---

CREATE VIEW cdna_clone AS
  SELECT
    feature_id AS cdna_clone_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'validated_cDNA_clone' OR cvterm.name = 'invalidated_cDNA_clone' OR cvterm.name = 'three_prime_RACE_clone' OR cvterm.name = 'chimeric_cDNA_clone' OR cvterm.name = 'genomically_contaminated_cDNA_clone' OR cvterm.name = 'polyA_primed_cDNA_clone' OR cvterm.name = 'partially_processed_cDNA_clone' OR cvterm.name = 'cDNA_clone';

--- ************************************************
--- *** relation: start_codon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** First codon to be translated by a riboso ***
--- *** me.                                      ***
--- ************************************************
---

CREATE VIEW start_codon AS
  SELECT
    feature_id AS start_codon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'non_canonical_start_codon' OR cvterm.name = 'four_bp_start_codon' OR cvterm.name = 'CTG_start_codon' OR cvterm.name = 'start_codon';

--- ************************************************
--- *** relation: stop_codon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** In mRNA, a set of three nucleotides that ***
--- ***  indicates the end of information for pr ***
--- *** otein synthesis.                         ***
--- ************************************************
---

CREATE VIEW stop_codon AS
  SELECT
    feature_id AS stop_codon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'stop_codon';

--- ************************************************
--- *** relation: intronic_splice_enhancer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Sequences within the intron that modulat ***
--- *** e splice site selection for some introns ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW intronic_splice_enhancer AS
  SELECT
    feature_id AS intronic_splice_enhancer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'intronic_splice_enhancer';

--- ************************************************
--- *** relation: mrna_with_plus_1_frameshift ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An mRNA with a plus 1 frameshift.        ***
--- ************************************************
---

CREATE VIEW mrna_with_plus_1_frameshift AS
  SELECT
    feature_id AS mrna_with_plus_1_frameshift_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mRNA_with_plus_1_frameshift';

--- ************************************************
--- *** relation: nuclease_hypersensitive_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW nuclease_hypersensitive_site AS
  SELECT
    feature_id AS nuclease_hypersensitive_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DNAseI_hypersensitive_site' OR cvterm.name = 'nuclease_hypersensitive_site';

--- ************************************************
--- *** relation: coding_start ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The first base to be translated into pro ***
--- *** tein.                                    ***
--- ************************************************
---

CREATE VIEW coding_start AS
  SELECT
    feature_id AS coding_start_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'coding_start';

--- ************************************************
--- *** relation: tag ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A nucleotide sequence that may be used t ***
--- *** o identify a larger sequence.            ***
--- ************************************************
---

CREATE VIEW tag AS
  SELECT
    feature_id AS tag_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'SAGE_tag' OR cvterm.name = 'STS' OR cvterm.name = 'EST' OR cvterm.name = 'engineered_tag' OR cvterm.name = 'five_prime_EST' OR cvterm.name = 'three_prime_EST' OR cvterm.name = 'UST' OR cvterm.name = 'RST' OR cvterm.name = 'three_prime_UST' OR cvterm.name = 'five_prime_UST' OR cvterm.name = 'three_prime_RST' OR cvterm.name = 'five_prime_RST' OR cvterm.name = 'tag';

--- ************************************************
--- *** relation: rrna_large_subunit_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a large ri ***
--- *** bosomal subunit RNA.                     ***
--- ************************************************
---

CREATE VIEW rrna_large_subunit_primary_transcript AS
  SELECT
    feature_id AS rrna_large_subunit_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_large_subunit_primary_transcript';

--- ************************************************
--- *** relation: sage_tag ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A short diagnostic sequence tag, serial  ***
--- *** analysis of gene expression (SAGE), that ***
--- ***  allows the quantitative and simultaneou ***
--- *** s analysis of a large number of transcri ***
--- *** pts.                                     ***
--- ************************************************
---

CREATE VIEW sage_tag AS
  SELECT
    feature_id AS sage_tag_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'SAGE_tag';

--- ************************************************
--- *** relation: coding_end ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The last base to be translated into prot ***
--- *** ein. It does not include the stop codon. ***
--- ************************************************
---

CREATE VIEW coding_end AS
  SELECT
    feature_id AS coding_end_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'coding_end';

--- ************************************************
--- *** relation: microarray_oligo ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW microarray_oligo AS
  SELECT
    feature_id AS microarray_oligo_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'microarray_oligo';

--- ************************************************
--- *** relation: mrna_with_plus_2_frameshift ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An mRNA with a plus 2 frameshift.        ***
--- ************************************************
---

CREATE VIEW mrna_with_plus_2_frameshift AS
  SELECT
    feature_id AS mrna_with_plus_2_frameshift_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mRNA_with_plus_2_frameshift';

--- ************************************************
--- *** relation: conserved_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Region of sequence similarity by descent ***
--- ***  from a common ancestor.                 ***
--- ************************************************
---

CREATE VIEW conserved_region AS
  SELECT
    feature_id AS conserved_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'coding_conserved_region' OR cvterm.name = 'nc_conserved_region' OR cvterm.name = 'RR_tract' OR cvterm.name = 'homologous_region' OR cvterm.name = 'centromere_DNA_Element_I' OR cvterm.name = 'centromere_DNA_Element_II' OR cvterm.name = 'centromere_DNA_Element_III' OR cvterm.name = 'X_element' OR cvterm.name = 'U_box' OR cvterm.name = 'regional_centromere_central_core' OR cvterm.name = 'syntenic_region' OR cvterm.name = 'paralogous_region' OR cvterm.name = 'orthologous_region' OR cvterm.name = 'conserved_region';

--- ************************************************
--- *** relation: sts ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Short (typically a few hundred base pair ***
--- *** s) DNA sequence that has a single occurr ***
--- *** ence in a genome and whose location and  ***
--- *** base sequence are known.                 ***
--- ************************************************
---

CREATE VIEW sts AS
  SELECT
    feature_id AS sts_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'STS';

--- ************************************************
--- *** relation: coding_conserved_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Coding region of sequence similarity by  ***
--- *** descent from a common ancestor.          ***
--- ************************************************
---

CREATE VIEW coding_conserved_region AS
  SELECT
    feature_id AS coding_conserved_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'coding_conserved_region';

--- ************************************************
--- *** relation: exon_junction ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The boundary between two exons in a proc ***
--- *** essed transcript.                        ***
--- ************************************************
---

CREATE VIEW exon_junction AS
  SELECT
    feature_id AS exon_junction_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'exon_junction';

--- ************************************************
--- *** relation: nc_conserved_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Non-coding region of sequence similarity ***
--- ***  by descent from a common ancestor.      ***
--- ************************************************
---

CREATE VIEW nc_conserved_region AS
  SELECT
    feature_id AS nc_conserved_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'nc_conserved_region';

--- ************************************************
--- *** relation: mrna_with_minus_2_frameshift ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A mRNA with a minus 2 frameshift.        ***
--- ************************************************
---

CREATE VIEW mrna_with_minus_2_frameshift AS
  SELECT
    feature_id AS mrna_with_minus_2_frameshift_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mRNA_with_minus_2_frameshift';

--- ************************************************
--- *** relation: pseudogene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence that closely resembles a know ***
--- *** n functional gene, at another locus with ***
--- *** in a genome, that is non-functional as a ***
--- ***  consequence of (usually several) mutati ***
--- *** ons that prevent either its transcriptio ***
--- *** n or translation (or both). In general,  ***
--- *** pseudogenes result from either reverse t ***
--- *** ranscription of a transcript of their "n ***
--- *** ormal" paralog (SO:0000043) (in which ca ***
--- *** se the pseudogene typically lacks intron ***
--- *** s and includes a poly(A) tail) or from r ***
--- *** ecombination (SO:0000044) (in which case ***
--- ***  the pseudogene is typically a tandem du ***
--- *** plication of its "normal" paralog).      ***
--- ************************************************
---

CREATE VIEW pseudogene AS
  SELECT
    feature_id AS pseudogene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'processed_pseudogene' OR cvterm.name = 'non_processed_pseudogene' OR cvterm.name = 'pseudogene_by_unequal_crossing_over' OR cvterm.name = 'nuclear_mt_pseudogene' OR cvterm.name = 'cassette_pseudogene' OR cvterm.name = 'duplicated_pseudogene' OR cvterm.name = 'unitary_pseudogene' OR cvterm.name = 'pseudogene';

--- ************************************************
--- *** relation: rnai_reagent ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A double stranded RNA duplex, at least 2 ***
--- *** 0bp long, used experimentally to inhibit ***
--- ***  gene function by RNA interference.      ***
--- ************************************************
---

CREATE VIEW rnai_reagent AS
  SELECT
    feature_id AS rnai_reagent_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNAi_reagent';

--- ************************************************
--- *** relation: mite ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A highly repetitive and short (100-500 b ***
--- *** ase pair) transposable element with term ***
--- *** inal inverted repeats (TIR) and target s ***
--- *** ite duplication (TSD). MITEs do not enco ***
--- *** de proteins.                             ***
--- ************************************************
---

CREATE VIEW mite AS
  SELECT
    feature_id AS mite_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'MITE';

--- ************************************************
--- *** relation: recombination_hotspot ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region in a genome which promotes reco ***
--- *** mbination.                               ***
--- ************************************************
---

CREATE VIEW recombination_hotspot AS
  SELECT
    feature_id AS recombination_hotspot_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'recombination_hotspot';

--- ************************************************
--- *** relation: chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Structural unit composed of a nucleic ac ***
--- *** id molecule which controls its own repli ***
--- *** cation through the interaction of specif ***
--- *** ic proteins at one or more origins of re ***
--- *** plication.                               ***
--- ************************************************
---

CREATE VIEW chromosome AS
  SELECT
    feature_id AS chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mitochondrial_chromosome' OR cvterm.name = 'chloroplast_chromosome' OR cvterm.name = 'chromoplast_chromosome' OR cvterm.name = 'cyanelle_chromosome' OR cvterm.name = 'leucoplast_chromosome' OR cvterm.name = 'macronuclear_chromosome' OR cvterm.name = 'micronuclear_chromosome' OR cvterm.name = 'nuclear_chromosome' OR cvterm.name = 'nucleomorphic_chromosome' OR cvterm.name = 'DNA_chromosome' OR cvterm.name = 'RNA_chromosome' OR cvterm.name = 'apicoplast_chromosome' OR cvterm.name = 'double_stranded_DNA_chromosome' OR cvterm.name = 'single_stranded_DNA_chromosome' OR cvterm.name = 'linear_double_stranded_DNA_chromosome' OR cvterm.name = 'circular_double_stranded_DNA_chromosome' OR cvterm.name = 'linear_single_stranded_DNA_chromosome' OR cvterm.name = 'circular_single_stranded_DNA_chromosome' OR cvterm.name = 'single_stranded_RNA_chromosome' OR cvterm.name = 'double_stranded_RNA_chromosome' OR cvterm.name = 'linear_single_stranded_RNA_chromosome' OR cvterm.name = 'circular_single_stranded_RNA_chromosome' OR cvterm.name = 'linear_double_stranded_RNA_chromosome' OR cvterm.name = 'circular_double_stranded_RNA_chromosome' OR cvterm.name = 'chromosome';

--- ************************************************
--- *** relation: chromosome_band ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A cytologically distinguishable feature  ***
--- *** of a chromosome, often made visible by s ***
--- *** taining, and usually alternating light a ***
--- *** nd dark.                                 ***
--- ************************************************
---

CREATE VIEW chromosome_band AS
  SELECT
    feature_id AS chromosome_band_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'chromosome_band';

--- ************************************************
--- *** relation: site_specific_recombination_target_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW site_specific_recombination_target_region AS
  SELECT
    feature_id AS site_specific_recombination_target_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'integration_excision_site' OR cvterm.name = 'resolution_site' OR cvterm.name = 'inversion_site' OR cvterm.name = 'inversion_site_part' OR cvterm.name = 'attI_site' OR cvterm.name = 'attP_site' OR cvterm.name = 'attB_site' OR cvterm.name = 'attL_site' OR cvterm.name = 'attR_site' OR cvterm.name = 'attC_site' OR cvterm.name = 'attCtn_site' OR cvterm.name = 'loxP_site' OR cvterm.name = 'dif_site' OR cvterm.name = 'FRT_site' OR cvterm.name = 'IRLinv_site' OR cvterm.name = 'IRRinv_site' OR cvterm.name = 'site_specific_recombination_target_region';

--- ************************************************
--- *** relation: match ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of sequence, aligned to another ***
--- ***  sequence with some statistical signific ***
--- *** ance, using an algorithm such as BLAST o ***
--- *** r SIM4.                                  ***
--- ************************************************
---

CREATE VIEW match AS
  SELECT
    feature_id AS match_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'nucleotide_match' OR cvterm.name = 'protein_match' OR cvterm.name = 'expressed_sequence_match' OR cvterm.name = 'cross_genome_match' OR cvterm.name = 'translated_nucleotide_match' OR cvterm.name = 'primer_match' OR cvterm.name = 'EST_match' OR cvterm.name = 'cDNA_match' OR cvterm.name = 'UST_match' OR cvterm.name = 'RST_match' OR cvterm.name = 'match';

--- ************************************************
--- *** relation: splice_enhancer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Region of a transcript that regulates sp ***
--- *** licing.                                  ***
--- ************************************************
---

CREATE VIEW splice_enhancer AS
  SELECT
    feature_id AS splice_enhancer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'intronic_splice_enhancer' OR cvterm.name = 'exonic_splice_enhancer' OR cvterm.name = 'splice_enhancer';

--- ************************************************
--- *** relation: est ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tag produced from a single sequencing  ***
--- *** read from a cDNA clone or PCR product; t ***
--- *** ypically a few hundred base pairs long.  ***
--- ************************************************
---

CREATE VIEW est AS
  SELECT
    feature_id AS est_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_EST' OR cvterm.name = 'three_prime_EST' OR cvterm.name = 'UST' OR cvterm.name = 'RST' OR cvterm.name = 'three_prime_UST' OR cvterm.name = 'five_prime_UST' OR cvterm.name = 'three_prime_RST' OR cvterm.name = 'five_prime_RST' OR cvterm.name = 'EST';

--- ************************************************
--- *** relation: loxp_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW loxp_site AS
  SELECT
    feature_id AS loxp_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'loxP_site';

--- ************************************************
--- *** relation: nucleotide_match ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A match against a nucleotide sequence.   ***
--- ************************************************
---

CREATE VIEW nucleotide_match AS
  SELECT
    feature_id AS nucleotide_match_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'expressed_sequence_match' OR cvterm.name = 'cross_genome_match' OR cvterm.name = 'translated_nucleotide_match' OR cvterm.name = 'primer_match' OR cvterm.name = 'EST_match' OR cvterm.name = 'cDNA_match' OR cvterm.name = 'UST_match' OR cvterm.name = 'RST_match' OR cvterm.name = 'nucleotide_match';

--- ************************************************
--- *** relation: nucleic_acid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence consi ***
--- *** sting of nucleobases bound to repeating  ***
--- *** units. The forms found in nature are deo ***
--- *** xyribonucleic acid (DNA), where the repe ***
--- *** ating units are 2-deoxy-D-ribose rings c ***
--- *** onnected to a phosphate backbone, and ri ***
--- *** bonucleic acid (RNA), where the repeatin ***
--- *** g units are D-ribose rings connected to  ***
--- *** a phosphate backbone.                    ***
--- ************************************************
---

CREATE VIEW nucleic_acid AS
  SELECT
    feature_id AS nucleic_acid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DNA' OR cvterm.name = 'RNA' OR cvterm.name = 'morpholino_backbone' OR cvterm.name = 'PNA' OR cvterm.name = 'LNA' OR cvterm.name = 'TNA' OR cvterm.name = 'GNA' OR cvterm.name = 'cDNA' OR cvterm.name = 'genomic_DNA' OR cvterm.name = 'single_stranded_cDNA' OR cvterm.name = 'double_stranded_cDNA' OR cvterm.name = 'R_GNA' OR cvterm.name = 'S_GNA' OR cvterm.name = 'nucleic_acid';

--- ************************************************
--- *** relation: protein_match ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A match against a protein sequence.      ***
--- ************************************************
---

CREATE VIEW protein_match AS
  SELECT
    feature_id AS protein_match_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'protein_match';

--- ************************************************
--- *** relation: frt_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An inversion site found on the Saccharom ***
--- *** yces cerevisiae 2 micron plasmid.        ***
--- ************************************************
---

CREATE VIEW frt_site AS
  SELECT
    feature_id AS frt_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'FRT_site';

--- ************************************************
--- *** relation: synthetic_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to decide a sequence of nuc ***
--- *** leotides, nucleotide analogs, or amino a ***
--- *** cids that has been designed by an experi ***
--- *** menter and which may, or may not, corres ***
--- *** pond with any natural sequence.          ***
--- ************************************************
---

CREATE VIEW synthetic_sequence AS
  SELECT
    feature_id AS synthetic_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'random_sequence' OR cvterm.name = 'designed_sequence' OR cvterm.name = 'synthetic_sequence';

--- ************************************************
--- *** relation: dna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence consi ***
--- *** sting of nucleobases bound to a repeatin ***
--- *** g unit made of a 2-deoxy-D-ribose ring c ***
--- *** onnected to a phosphate backbone.        ***
--- ************************************************
---

CREATE VIEW dna AS
  SELECT
    feature_id AS dna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cDNA' OR cvterm.name = 'genomic_DNA' OR cvterm.name = 'single_stranded_cDNA' OR cvterm.name = 'double_stranded_cDNA' OR cvterm.name = 'DNA';

--- ************************************************
--- *** relation: sequence_assembly ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence of nucleotides that has been  ***
--- *** algorithmically derived from an alignmen ***
--- *** t of two or more different sequences.    ***
--- ************************************************
---

CREATE VIEW sequence_assembly AS
  SELECT
    feature_id AS sequence_assembly_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'supercontig' OR cvterm.name = 'contig' OR cvterm.name = 'tiling_path' OR cvterm.name = 'virtual_sequence' OR cvterm.name = 'golden_path' OR cvterm.name = 'ultracontig' OR cvterm.name = 'expressed_sequence_assembly' OR cvterm.name = 'sequence_assembly';

--- ************************************************
--- *** relation: group_1_intron_homing_endonuclease_target_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of intronic nucleotide sequence ***
--- ***  targeted by a nuclease enzyme.          ***
--- ************************************************
---

CREATE VIEW group_1_intron_homing_endonuclease_target_region AS
  SELECT
    feature_id AS group_1_intron_homing_endonuclease_target_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'group_1_intron_homing_endonuclease_target_region';

--- ************************************************
--- *** relation: haplotype_block ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of the genome which is co-inher ***
--- *** ited as the result of the lack of histor ***
--- *** ic recombination within it.              ***
--- ************************************************
---

CREATE VIEW haplotype_block AS
  SELECT
    feature_id AS haplotype_block_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'haplotype_block';

--- ************************************************
--- *** relation: rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence consi ***
--- *** sting of nucleobases bound to a repeatin ***
--- *** g unit made of a D-ribose ring connected ***
--- ***  to a phosphate backbone.                ***
--- ************************************************
---

CREATE VIEW rna AS
  SELECT
    feature_id AS rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNA';

--- ************************************************
--- *** relation: flanked ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a region that is ***
--- ***  bounded either side by a particular kin ***
--- *** d of region.                             ***
--- ************************************************
---

CREATE VIEW flanked AS
  SELECT
    feature_id AS flanked_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'floxed' OR cvterm.name = 'FRT_flanked' OR cvterm.name = 'flanked';

--- ************************************************
--- *** relation: floxed ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing sequence that is ***
--- ***  flanked by Lox-P sites.                 ***
--- ************************************************
---

CREATE VIEW floxed AS
  SELECT
    feature_id AS floxed_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'floxed';

--- ************************************************
--- *** relation: codon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A set of (usually) three nucleotide base ***
--- *** s in a DNA or RNA sequence, which togeth ***
--- *** er code for a unique amino acid or the t ***
--- *** ermination of translation and are contai ***
--- *** ned within the CDS.                      ***
--- ************************************************
---

CREATE VIEW codon AS
  SELECT
    feature_id AS codon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'recoded_codon' OR cvterm.name = 'start_codon' OR cvterm.name = 'stop_codon' OR cvterm.name = 'stop_codon_read_through' OR cvterm.name = 'stop_codon_redefined_as_pyrrolysine' OR cvterm.name = 'stop_codon_redefined_as_selenocysteine' OR cvterm.name = 'non_canonical_start_codon' OR cvterm.name = 'four_bp_start_codon' OR cvterm.name = 'CTG_start_codon' OR cvterm.name = 'codon';

--- ************************************************
--- *** relation: frt_flanked ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe sequence that i ***
--- *** s flanked by the FLP recombinase recogni ***
--- *** tion site, FRT.                          ***
--- ************************************************
---

CREATE VIEW frt_flanked AS
  SELECT
    feature_id AS frt_flanked_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'FRT_flanked';

--- ************************************************
--- *** relation: invalidated_by_chimeric_cdna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A cDNA clone constructed from more than  ***
--- *** one mRNA. Usually an experimental artifa ***
--- *** ct.                                      ***
--- ************************************************
---

CREATE VIEW invalidated_by_chimeric_cdna AS
  SELECT
    feature_id AS invalidated_by_chimeric_cdna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'invalidated_by_chimeric_cDNA';

--- ************************************************
--- *** relation: floxed_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transgene that is floxed.              ***
--- ************************************************
---

CREATE VIEW floxed_gene AS
  SELECT
    feature_id AS floxed_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'floxed_gene';

--- ************************************************
--- *** relation: transposable_element_flanking_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The region of sequence surrounding a tra ***
--- *** nsposable element.                       ***
--- ************************************************
---

CREATE VIEW transposable_element_flanking_region AS
  SELECT
    feature_id AS transposable_element_flanking_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transposable_element_flanking_region';

--- ************************************************
--- *** relation: integron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region encoding an integrase which act ***
--- *** s at a site adjacent to it (attI_site) t ***
--- *** o insert DNA which must include but is n ***
--- *** ot limited to an attC_site.              ***
--- ************************************************
---

CREATE VIEW integron AS
  SELECT
    feature_id AS integron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'integron';

--- ************************************************
--- *** relation: insertion_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The junction where an insertion occurred ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW insertion_site AS
  SELECT
    feature_id AS insertion_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transposable_element_insertion_site' OR cvterm.name = 'insertion_site';

--- ************************************************
--- *** relation: atti_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region within an integron, adjacent to ***
--- ***  an integrase, at which site specific re ***
--- *** combination involving an attC_site takes ***
--- ***  place.                                  ***
--- ************************************************
---

CREATE VIEW atti_site AS
  SELECT
    feature_id AS atti_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'attI_site';

--- ************************************************
--- *** relation: transposable_element_insertion_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The junction in a genome where a transpo ***
--- *** sable_element has inserted.              ***
--- ************************************************
---

CREATE VIEW transposable_element_insertion_site AS
  SELECT
    feature_id AS transposable_element_insertion_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transposable_element_insertion_site';

--- ************************************************
--- *** relation: small_regulatory_ncrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A non-coding RNA, usually with a specifi ***
--- *** c secondary structure, that acts to regu ***
--- *** late gene expression.                    ***
--- ************************************************
---

CREATE VIEW small_regulatory_ncrna AS
  SELECT
    feature_id AS small_regulatory_ncrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'miRNA' OR cvterm.name = 'RNA_6S' OR cvterm.name = 'CsrB_RsmB_RNA' OR cvterm.name = 'DsrA_RNA' OR cvterm.name = 'OxyS_RNA' OR cvterm.name = 'RprA_RNA' OR cvterm.name = 'RRE_RNA' OR cvterm.name = 'spot_42_RNA' OR cvterm.name = 'tmRNA' OR cvterm.name = 'GcvB_RNA' OR cvterm.name = 'small_regulatory_ncRNA';

--- ************************************************
--- *** relation: conjugative_transposon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transposon that encodes function requi ***
--- *** red for conjugation.                     ***
--- ************************************************
---

CREATE VIEW conjugative_transposon AS
  SELECT
    feature_id AS conjugative_transposon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'conjugative_transposon';

--- ************************************************
--- *** relation: enzymatic_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An RNA sequence that has catalytic activ ***
--- *** ity with or without an associated ribonu ***
--- *** cleoprotein.                             ***
--- ************************************************
---

CREATE VIEW enzymatic_rna AS
  SELECT
    feature_id AS enzymatic_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'ribozyme' OR cvterm.name = 'enzymatic_RNA';

--- ************************************************
--- *** relation: recombinationally_inverted_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A recombinationally rearranged gene by i ***
--- *** nversion.                                ***
--- ************************************************
---

CREATE VIEW recombinationally_inverted_gene AS
  SELECT
    feature_id AS recombinationally_inverted_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'recombinationally_inverted_gene';

--- ************************************************
--- *** relation: ribozyme ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An RNA with catalytic activity.          ***
--- ************************************************
---

CREATE VIEW ribozyme AS
  SELECT
    feature_id AS ribozyme_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'ribozyme';

--- ************************************************
--- *** relation: rrna_5_8s ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 5_8S ribosomal RNA (5. 8S rRNA) is a com ***
--- *** ponent of the large subunit of the eukar ***
--- *** yotic ribosome. It is transcribed by RNA ***
--- ***  polymerase I as part of the 45S precurs ***
--- *** or that also contains 18S and 28S rRNA.  ***
--- *** Functionally, it is thought that 5.8S rR ***
--- *** NA may be involved in ribosome transloca ***
--- *** tion. It is also known to form covalent  ***
--- *** linkage to the p53 tumour suppressor pro ***
--- *** tein. 5_8S rRNA is also found in archaea ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW rrna_5_8s AS
  SELECT
    feature_id AS rrna_5_8s_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_5_8S';

--- ************************************************
--- *** relation: rna_6s ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A small (184-nt in E. coli) RNA that for ***
--- *** ms a hairpin type structure. 6S RNA asso ***
--- *** ciates with RNA polymerase in a highly s ***
--- *** pecific manner. 6S RNA represses express ***
--- *** ion from a sigma70-dependent promoter du ***
--- *** ring stationary phase.                   ***
--- ************************************************
---

CREATE VIEW rna_6s AS
  SELECT
    feature_id AS rna_6s_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNA_6S';

--- ************************************************
--- *** relation: csrb_rsmb_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An enterobacterial RNA that binds the Cs ***
--- *** rA protein. The CsrB RNAs contain a cons ***
--- *** erved motif CAGGXXG that is found in up  ***
--- *** to 18 copies and has been suggested to b ***
--- *** ind CsrA. The Csr regulatory system has  ***
--- *** a strong negative regulatory effect on g ***
--- *** lycogen biosynthesis, glyconeogenesis an ***
--- *** d glycogen catabolism and a positive reg ***
--- *** ulatory effect on glycolysis. In other b ***
--- *** acteria such as Erwinia caratovara the R ***
--- *** smA protein has been shown to regulate t ***
--- *** he production of virulence determinants, ***
--- ***  such extracellular enzymes. RsmA binds  ***
--- *** to RsmB regulatory RNA which is also a m ***
--- *** ember of this family.                    ***
--- ************************************************
---

CREATE VIEW csrb_rsmb_rna AS
  SELECT
    feature_id AS csrb_rsmb_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'CsrB_RsmB_RNA';

--- ************************************************
--- *** relation: dsra_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** DsrA RNA regulates both transcription, b ***
--- *** y overcoming transcriptional silencing b ***
--- *** y the nucleoid-associated H-NS protein,  ***
--- *** and translation, by promoting efficient  ***
--- *** translation of the stress sigma factor,  ***
--- *** RpoS. These two activities of DsrA can b ***
--- *** e separated by mutation: the first of th ***
--- *** ree stem-loops of the 85 nucleotide RNA  ***
--- *** is necessary for RpoS translation but no ***
--- *** t for anti-H-NS action, while the second ***
--- ***  stem-loop is essential for antisilencin ***
--- *** g and less critical for RpoS translation ***
--- *** . The third stem-loop, which behaves as  ***
--- *** a transcription terminator, can be subst ***
--- *** ituted by the trp transcription terminat ***
--- *** or without loss of either DsrA function. ***
--- ***  The sequence of the first stem-loop of  ***
--- *** DsrA is complementary with the upstream  ***
--- *** leader portion of RpoS messenger RNA, su ***
--- *** ggesting that pairing of DsrA with the R ***
--- *** poS message might be important for trans ***
--- *** lational regulation.                     ***
--- ************************************************
---

CREATE VIEW dsra_rna AS
  SELECT
    feature_id AS dsra_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'GcvB_RNA' OR cvterm.name = 'DsrA_RNA';

--- ************************************************
--- *** relation: gcvb_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A small untranslated RNA involved in exp ***
--- *** ression of the dipeptide and oligopeptid ***
--- *** e transport systems in Escherichia coli. ***
--- ************************************************
---

CREATE VIEW gcvb_rna AS
  SELECT
    feature_id AS gcvb_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'GcvB_RNA';

--- ************************************************
--- *** relation: hammerhead_ribozyme ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A small catalytic RNA motif that catalyz ***
--- *** es self-cleavage reaction. Its name come ***
--- *** s from its secondary structure which res ***
--- *** embles a carpenter's hammer. The hammerh ***
--- *** ead ribozyme is involved in the replicat ***
--- *** ion of some viroid and some satellite RN ***
--- *** As.                                      ***
--- ************************************************
---

CREATE VIEW hammerhead_ribozyme AS
  SELECT
    feature_id AS hammerhead_ribozyme_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'hammerhead_ribozyme';

--- ************************************************
--- *** relation: group_iia_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW group_iia_intron AS
  SELECT
    feature_id AS group_iia_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'group_IIA_intron';

--- ************************************************
--- *** relation: group_iib_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW group_iib_intron AS
  SELECT
    feature_id AS group_iib_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'group_IIB_intron';

--- ************************************************
--- *** relation: micf_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A non-translated 93 nt antisense RNA tha ***
--- *** t binds its target ompF mRNA and regulat ***
--- *** es ompF expression by inhibiting transla ***
--- *** tion and inducing degradation of the mes ***
--- *** sage.                                    ***
--- ************************************************
---

CREATE VIEW micf_rna AS
  SELECT
    feature_id AS micf_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'MicF_RNA';

--- ************************************************
--- *** relation: oxys_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A small untranslated RNA which is induce ***
--- *** d in response to oxidative stress in Esc ***
--- *** herichia coli. Acts as a global regulato ***
--- *** r to activate or repress the expression  ***
--- *** of as many as 40 genes, including the fh ***
--- *** lA-encoded transcriptional activator and ***
--- ***  the rpoS-encoded sigma(s) subunit of RN ***
--- *** A polymerase. OxyS is bound by the Hfq p ***
--- *** rotein, that increases the OxyS RNA inte ***
--- *** raction with its target messages.        ***
--- ************************************************
---

CREATE VIEW oxys_rna AS
  SELECT
    feature_id AS oxys_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'OxyS_RNA';

--- ************************************************
--- *** relation: rnase_mrp_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The RNA molecule essential for the catal ***
--- *** ytic activity of RNase MRP, an enzymatic ***
--- *** ally active ribonucleoprotein with two d ***
--- *** istinct roles in eukaryotes. In mitochon ***
--- *** dria it plays a direct role in the initi ***
--- *** ation of mitochondrial DNA replication.  ***
--- *** In the nucleus it is involved in precurs ***
--- *** or rRNA processing, where it cleaves the ***
--- ***  internal transcribed spacer 1 between 1 ***
--- *** 8S and 5.8S rRNAs.                       ***
--- ************************************************
---

CREATE VIEW rnase_mrp_rna AS
  SELECT
    feature_id AS rnase_mrp_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNase_MRP_RNA';

--- ************************************************
--- *** relation: rnase_p_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The RNA component of Ribonuclease P (RNa ***
--- *** se P), a ubiquitous endoribonuclease, fo ***
--- *** und in archaea, bacteria and eukarya as  ***
--- *** well as chloroplasts and mitochondria. I ***
--- *** ts best characterized activity is the ge ***
--- *** neration of mature 5 prime ends of tRNAs ***
--- ***  by cleaving the 5 prime leader elements ***
--- ***  of precursor-tRNAs. Cellular RNase Ps a ***
--- *** re ribonucleoproteins. RNA from bacteria ***
--- *** l RNase Ps retains its catalytic activit ***
--- *** y in the absence of the protein subunit, ***
--- ***  i.e. it is a ribozyme. Isolated eukaryo ***
--- *** tic and archaeal RNase P RNA has not bee ***
--- *** n shown to retain its catalytic function ***
--- *** , but is still essential for the catalyt ***
--- *** ic activity of the holoenzyme. Although  ***
--- *** the archaeal and eukaryotic holoenzymes  ***
--- *** have a much greater protein content than ***
--- ***  the bacterial ones, the RNA cores from  ***
--- *** all the three lineages are homologous. H ***
--- *** elices corresponding to P1, P2, P3, P4,  ***
--- *** and P10/11 are common to all cellular RN ***
--- *** ase P RNAs. Yet, there is considerable s ***
--- *** equence variation, particularly among th ***
--- *** e eukaryotic RNAs.                       ***
--- ************************************************
---

CREATE VIEW rnase_p_rna AS
  SELECT
    feature_id AS rnase_p_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNase_P_RNA';

--- ************************************************
--- *** relation: rpra_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Translational regulation of the stationa ***
--- *** ry phase sigma factor RpoS is mediated b ***
--- *** y the formation of a double-stranded RNA ***
--- ***  stem-loop structure in the upstream reg ***
--- *** ion of the rpoS messenger RNA, occluding ***
--- ***  the translation initiation site. Clones ***
--- ***  carrying rprA (RpoS regulator RNA) incr ***
--- *** eased the translation of RpoS. The rprA  ***
--- *** gene encodes a 106 nucleotide regulatory ***
--- ***  RNA. As with DsrA Rfam:RF00014, RprA is ***
--- ***  predicted to form three stem-loops. Thu ***
--- *** s, at least two small RNAs, DsrA and Rpr ***
--- *** A, participate in the positive regulatio ***
--- *** n of RpoS translation. Unlike DsrA, RprA ***
--- ***  does not have an extensive region of co ***
--- *** mplementarity to the RpoS leader, leavin ***
--- *** g its mechanism of action unclear. RprA  ***
--- *** is non-essential.                        ***
--- ************************************************
---

CREATE VIEW rpra_rna AS
  SELECT
    feature_id AS rpra_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RprA_RNA';

--- ************************************************
--- *** relation: rre_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The Rev response element (RRE) is encode ***
--- *** d within the HIV-env gene. Rev is an ess ***
--- *** ential regulatory protein of HIV that bi ***
--- *** nds an internal loop of the RRE leading, ***
--- ***  encouraging further Rev-RRE binding. Th ***
--- *** is RNP complex is critical for mRNA expo ***
--- *** rt and hence for expression of the HIV s ***
--- *** tructural proteins.                      ***
--- ************************************************
---

CREATE VIEW rre_rna AS
  SELECT
    feature_id AS rre_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RRE_RNA';

--- ************************************************
--- *** relation: spot_42_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A 109-nucleotide RNA of E. coli that see ***
--- *** ms to have a regulatory role on the gala ***
--- *** ctose operon. Changes in Spot 42 levels  ***
--- *** are implicated in affecting DNA polymera ***
--- *** se I levels.                             ***
--- ************************************************
---

CREATE VIEW spot_42_rna AS
  SELECT
    feature_id AS spot_42_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'spot_42_RNA';

--- ************************************************
--- *** relation: telomerase_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The RNA component of telomerase, a rever ***
--- *** se transcriptase that synthesizes telome ***
--- *** ric DNA.                                 ***
--- ************************************************
---

CREATE VIEW telomerase_rna AS
  SELECT
    feature_id AS telomerase_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'telomerase_RNA';

--- ************************************************
--- *** relation: u1_snrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** U1 is a small nuclear RNA (snRNA) compon ***
--- *** ent of the spliceosome (involved in pre- ***
--- *** mRNA splicing). Its 5' end forms complem ***
--- *** entary base pairs with the 5' splice jun ***
--- *** ction, thus defining the 5' donor site o ***
--- *** f an intron. There are significant diffe ***
--- *** rences in sequence and secondary structu ***
--- *** re between metazoan and yeast U1 snRNAs, ***
--- ***  the latter being much longer (568 nucle ***
--- *** otides as compared to 164 nucleotides in ***
--- ***  human). Nevertheless, secondary structu ***
--- *** re predictions suggest that all U1 snRNA ***
--- *** s share a 'common core' consisting of he ***
--- *** lices I, II, the proximal region of III, ***
--- ***  and IV.                                 ***
--- ************************************************
---

CREATE VIEW u1_snrna AS
  SELECT
    feature_id AS u1_snrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U1_snRNA';

--- ************************************************
--- *** relation: u2_snrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** U2 is a small nuclear RNA (snRNA) compon ***
--- *** ent of the spliceosome (involved in pre- ***
--- *** mRNA splicing). Complementary binding be ***
--- *** tween U2 snRNA (in an area lying towards ***
--- ***  the 5' end but 3' to hairpin I) and the ***
--- ***  branchpoint sequence (BPS) of the intro ***
--- *** n results in the bulging out of an unpai ***
--- *** red adenine, on the BPS, which initiates ***
--- ***  a nucleophilic attack at the intronic 5 ***
--- *** ' splice site, thus starting the first o ***
--- *** f two transesterification reactions that ***
--- ***  mediate splicing.                       ***
--- ************************************************
---

CREATE VIEW u2_snrna AS
  SELECT
    feature_id AS u2_snrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U2_snRNA';

--- ************************************************
--- *** relation: u4_snrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** U4 small nuclear RNA (U4 snRNA) is a com ***
--- *** ponent of the major U2-dependent spliceo ***
--- *** some. It forms a duplex with U6, and wit ***
--- *** h each splicing round, it is displaced f ***
--- *** rom U6 (and the spliceosome) in an ATP-d ***
--- *** ependent manner, allowing U6 to refold a ***
--- *** nd create the active site for splicing c ***
--- *** atalysis. A recycling process involving  ***
--- *** protein Prp24 re-anneals U4 and U6.      ***
--- ************************************************
---

CREATE VIEW u4_snrna AS
  SELECT
    feature_id AS u4_snrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U4_snRNA';

--- ************************************************
--- *** relation: u4atac_snrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An snRNA required for the splicing of th ***
--- *** e minor U12-dependent class of eukaryoti ***
--- *** c nuclear introns. It forms a base paire ***
--- *** d complex with U6atac_snRNA (SO:0000397) ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW u4atac_snrna AS
  SELECT
    feature_id AS u4atac_snrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U4atac_snRNA';

--- ************************************************
--- *** relation: u5_snrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** U5 RNA is a component of both types of k ***
--- *** nown spliceosome. The precise function o ***
--- *** f this molecule is unknown, though it is ***
--- ***  known that the 5' loop is required for  ***
--- *** splice site selection and p220 binding,  ***
--- *** and that both the 3' stem-loop and the S ***
--- *** m site are important for Sm protein bind ***
--- *** ing and cap methylation.                 ***
--- ************************************************
---

CREATE VIEW u5_snrna AS
  SELECT
    feature_id AS u5_snrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U5_snRNA';

--- ************************************************
--- *** relation: u6_snrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** U6 snRNA is a component of the spliceoso ***
--- *** me which is involved in splicing pre-mRN ***
--- *** A. The putative secondary structure cons ***
--- *** ensus base pairing is confined to a shor ***
--- *** t 5' stem loop, but U6 snRNA is thought  ***
--- *** to form extensive base-pair interactions ***
--- ***  with U4 snRNA.                          ***
--- ************************************************
---

CREATE VIEW u6_snrna AS
  SELECT
    feature_id AS u6_snrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U6_snRNA';

--- ************************************************
--- *** relation: u6atac_snrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** U6atac_snRNA is an snRNA required for th ***
--- *** e splicing of the minor U12-dependent cl ***
--- *** ass of eukaryotic nuclear introns. It fo ***
--- *** rms a base paired complex with U4atac_sn ***
--- *** RNA (SO:0000394).                        ***
--- ************************************************
---

CREATE VIEW u6atac_snrna AS
  SELECT
    feature_id AS u6atac_snrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U6atac_snRNA';

--- ************************************************
--- *** relation: u11_snrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** U11 snRNA plays a role in splicing of th ***
--- *** e minor U12-dependent class of eukaryoti ***
--- *** c nuclear introns, similar to U1 snRNA i ***
--- *** n the major class spliceosome it base pa ***
--- *** irs to the conserved 5' splice site sequ ***
--- *** ence.                                    ***
--- ************************************************
---

CREATE VIEW u11_snrna AS
  SELECT
    feature_id AS u11_snrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U11_snRNA';

--- ************************************************
--- *** relation: u12_snrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The U12 small nuclear (snRNA), together  ***
--- *** with U4atac/U6atac, U5, and U11 snRNAs a ***
--- *** nd associated proteins, forms a spliceos ***
--- *** ome that cleaves a divergent class of lo ***
--- *** w-abundance pre-mRNA introns.            ***
--- ************************************************
---

CREATE VIEW u12_snrna AS
  SELECT
    feature_id AS u12_snrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U12_snRNA';

--- ************************************************
--- *** relation: sequence_attribute ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describes a quality of sequ ***
--- *** ence.                                    ***
--- ************************************************
---

CREATE VIEW sequence_attribute AS
  SELECT
    feature_id AS sequence_attribute_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polymer_attribute' OR cvterm.name = 'feature_attribute' OR cvterm.name = 'sequence_location' OR cvterm.name = 'variant_quality' OR cvterm.name = 'nucleic_acid' OR cvterm.name = 'synthetic_sequence' OR cvterm.name = 'topology_attribute' OR cvterm.name = 'peptidyl' OR cvterm.name = 'DNA' OR cvterm.name = 'RNA' OR cvterm.name = 'morpholino_backbone' OR cvterm.name = 'PNA' OR cvterm.name = 'LNA' OR cvterm.name = 'TNA' OR cvterm.name = 'GNA' OR cvterm.name = 'cDNA' OR cvterm.name = 'genomic_DNA' OR cvterm.name = 'single_stranded_cDNA' OR cvterm.name = 'double_stranded_cDNA' OR cvterm.name = 'R_GNA' OR cvterm.name = 'S_GNA' OR cvterm.name = 'random_sequence' OR cvterm.name = 'designed_sequence' OR cvterm.name = 'linear' OR cvterm.name = 'circular' OR cvterm.name = 'transcript_attribute' OR cvterm.name = 'bound_by_factor' OR cvterm.name = 'flanked' OR cvterm.name = 'gene_attribute' OR cvterm.name = 'retrotransposed' OR cvterm.name = 'transgenic' OR cvterm.name = 'natural' OR cvterm.name = 'engineered' OR cvterm.name = 'foreign' OR cvterm.name = 'fusion' OR cvterm.name = 'rescue' OR cvterm.name = 'wild_type' OR cvterm.name = 'conserved' OR cvterm.name = 'status' OR cvterm.name = 'intermediate' OR cvterm.name = 'recombinationally_rearranged' OR cvterm.name = 'cryptic' OR cvterm.name = 'strand_attribute' OR cvterm.name = 'direction_attribute' OR cvterm.name = 'enzymatic' OR cvterm.name = 'mobile' OR cvterm.name = 'alteration_attribute' OR cvterm.name = 'experimental_feature_attribute' OR cvterm.name = 'edited' OR cvterm.name = 'capped' OR cvterm.name = 'mRNA_attribute' OR cvterm.name = 'trans_spliced' OR cvterm.name = 'alternatively_spliced' OR cvterm.name = 'monocistronic' OR cvterm.name = 'polycistronic' OR cvterm.name = 'polyadenylated' OR cvterm.name = 'exemplar' OR cvterm.name = 'frameshift' OR cvterm.name = 'recoded' OR cvterm.name = 'minus_1_frameshift' OR cvterm.name = 'minus_2_frameshift' OR cvterm.name = 'plus_1_frameshift' OR cvterm.name = 'plus_2_framshift' OR cvterm.name = 'codon_redefined' OR cvterm.name = 'recoded_by_translational_bypass' OR cvterm.name = 'translationally_frameshifted' OR cvterm.name = 'minus_1_translationally_frameshifted' OR cvterm.name = 'plus_1_translationally_frameshifted' OR cvterm.name = 'dicistronic' OR cvterm.name = 'bound_by_protein' OR cvterm.name = 'bound_by_nucleic_acid' OR cvterm.name = 'floxed' OR cvterm.name = 'FRT_flanked' OR cvterm.name = 'protein_coding' OR cvterm.name = 'non_protein_coding' OR cvterm.name = 'gene_to_gene_feature' OR cvterm.name = 'gene_array_member' OR cvterm.name = 'regulated' OR cvterm.name = 'epigenetically_modified' OR cvterm.name = 'encodes_alternately_spliced_transcripts' OR cvterm.name = 'encodes_alternate_transcription_start_sites' OR cvterm.name = 'intein_containing' OR cvterm.name = 'miRNA_encoding' OR cvterm.name = 'rRNA_encoding' OR cvterm.name = 'scRNA_encoding' OR cvterm.name = 'snoRNA_encoding' OR cvterm.name = 'snRNA_encoding' OR cvterm.name = 'SRP_RNA_encoding' OR cvterm.name = 'stRNA_encoding' OR cvterm.name = 'tmRNA_encoding' OR cvterm.name = 'tRNA_encoding' OR cvterm.name = 'gRNA_encoding' OR cvterm.name = 'C_D_box_snoRNA_encoding' OR cvterm.name = 'H_ACA_box_snoRNA_encoding' OR cvterm.name = 'overlapping' OR cvterm.name = 'inside_intron' OR cvterm.name = 'five_prime_three_prime_overlap' OR cvterm.name = 'five_prime_five_prime_overlap' OR cvterm.name = 'three_prime_three_prime_overlap' OR cvterm.name = 'three_prime_five_prime_overlap' OR cvterm.name = 'antisense' OR cvterm.name = 'inside_intron_antiparallel' OR cvterm.name = 'inside_intron_parallel' OR cvterm.name = 'operon_member' OR cvterm.name = 'gene_cassette_member' OR cvterm.name = 'gene_subarray_member' OR cvterm.name = 'member_of_regulon' OR cvterm.name = 'cassette_array_member' OR cvterm.name = 'transcriptionally_regulated' OR cvterm.name = 'post_translationally_regulated' OR cvterm.name = 'translationally_regulated' OR cvterm.name = 'imprinted' OR cvterm.name = 'transcriptionally_constitutive' OR cvterm.name = 'transcriptionally_induced' OR cvterm.name = 'transcriptionally_repressed' OR cvterm.name = 'autoregulated' OR cvterm.name = 'positively_autoregulated' OR cvterm.name = 'negatively_autoregulated' OR cvterm.name = 'silenced' OR cvterm.name = 'silenced_by_DNA_modification' OR cvterm.name = 'silenced_by_RNA_interference' OR cvterm.name = 'silenced_by_histone_modification' OR cvterm.name = 'silenced_by_DNA_methylation' OR cvterm.name = 'silenced_by_histone_methylation' OR cvterm.name = 'silenced_by_histone_deacetylation' OR cvterm.name = 'negatively_autoregulated' OR cvterm.name = 'positively_autoregulated' OR cvterm.name = 'post_translationally_regulated_by_protein_stability' OR cvterm.name = 'post_translationally_regulated_by_protein_modification' OR cvterm.name = 'maternally_imprinted' OR cvterm.name = 'paternally_imprinted' OR cvterm.name = 'imprinted' OR cvterm.name = 'allelically_excluded' OR cvterm.name = 'rearranged_at_DNA_level' OR cvterm.name = 'maternally_imprinted' OR cvterm.name = 'paternally_imprinted' OR cvterm.name = 'encodes_1_polypeptide' OR cvterm.name = 'encodes_greater_than_1_polypeptide' OR cvterm.name = 'encodes_disjoint_polypeptides' OR cvterm.name = 'encodes_overlapping_peptides' OR cvterm.name = 'encodes_different_polypeptides_different_stop' OR cvterm.name = 'encodes_overlapping_peptides_different_start' OR cvterm.name = 'encodes_overlapping_polypeptides_different_start_and_stop' OR cvterm.name = 'homologous' OR cvterm.name = 'syntenic' OR cvterm.name = 'orthologous' OR cvterm.name = 'paralogous' OR cvterm.name = 'fragmentary' OR cvterm.name = 'predicted' OR cvterm.name = 'validated' OR cvterm.name = 'invalidated' OR cvterm.name = 'independently_known' OR cvterm.name = 'consensus' OR cvterm.name = 'low_complexity' OR cvterm.name = 'whole_genome_sequence_status' OR cvterm.name = 'supported_by_sequence_similarity' OR cvterm.name = 'orphan' OR cvterm.name = 'predicted_by_ab_initio_computation' OR cvterm.name = 'supported_by_domain_match' OR cvterm.name = 'supported_by_EST_or_cDNA' OR cvterm.name = 'experimentally_determined' OR cvterm.name = 'invalidated_by_chimeric_cDNA' OR cvterm.name = 'invalidated_by_genomic_contamination' OR cvterm.name = 'invalidated_by_genomic_polyA_primed_cDNA' OR cvterm.name = 'invalidated_by_partial_processing' OR cvterm.name = 'standard_draft' OR cvterm.name = 'high_quality_draft' OR cvterm.name = 'improved_high_quality_draft' OR cvterm.name = 'annotation_directed_improved_draft' OR cvterm.name = 'noncontiguous_finished' OR cvterm.name = 'finished_genome' OR cvterm.name = 'single' OR cvterm.name = 'double' OR cvterm.name = 'forward' OR cvterm.name = 'reverse' OR cvterm.name = 'ribozymic' OR cvterm.name = 'chromosomal_variation_attribute' OR cvterm.name = 'insertion_attribute' OR cvterm.name = 'inversion_attribute' OR cvterm.name = 'translocaton_attribute' OR cvterm.name = 'duplication_attribute' OR cvterm.name = 'intrachromosomal' OR cvterm.name = 'interchromosomal' OR cvterm.name = 'tandem' OR cvterm.name = 'direct' OR cvterm.name = 'inverted' OR cvterm.name = 'pericentric' OR cvterm.name = 'paracentric' OR cvterm.name = 'reciprocal' OR cvterm.name = 'insertional' OR cvterm.name = 'free' OR cvterm.name = 'score' OR cvterm.name = 'quality_value' OR cvterm.name = 'organelle_sequence' OR cvterm.name = 'plasmid_location' OR cvterm.name = 'proviral_location' OR cvterm.name = 'macronuclear_sequence' OR cvterm.name = 'micronuclear_sequence' OR cvterm.name = 'mitochondrial_sequence' OR cvterm.name = 'nuclear_sequence' OR cvterm.name = 'nucleomorphic_sequence' OR cvterm.name = 'plastid_sequence' OR cvterm.name = 'mitochondrial_DNA' OR cvterm.name = 'apicoplast_sequence' OR cvterm.name = 'chromoplast_sequence' OR cvterm.name = 'chloroplast_sequence' OR cvterm.name = 'cyanelle_sequence' OR cvterm.name = 'leucoplast_sequence' OR cvterm.name = 'proplastid_sequence' OR cvterm.name = 'chloroplast_DNA' OR cvterm.name = 'endogenous_retroviral_sequence' OR cvterm.name = 'variant_origin' OR cvterm.name = 'variant_frequency' OR cvterm.name = 'variant_phenotype' OR cvterm.name = 'maternal_variant' OR cvterm.name = 'paternal_variant' OR cvterm.name = 'somatic_variant' OR cvterm.name = 'germline_variant' OR cvterm.name = 'pedigree_specific_variant' OR cvterm.name = 'population_specific_variant' OR cvterm.name = 'de_novo_variant' OR cvterm.name = 'unique_variant' OR cvterm.name = 'rare_variant' OR cvterm.name = 'polymorphic_variant' OR cvterm.name = 'common_variant' OR cvterm.name = 'fixed_variant' OR cvterm.name = 'benign_variant' OR cvterm.name = 'disease_associated_variant' OR cvterm.name = 'disease_causing_variant' OR cvterm.name = 'lethal_variant' OR cvterm.name = 'quantitative_variant' OR cvterm.name = 'sequence_attribute';

--- ************************************************
--- *** relation: gene_attribute ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW gene_attribute AS
  SELECT
    feature_id AS gene_attribute_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'protein_coding' OR cvterm.name = 'non_protein_coding' OR cvterm.name = 'gene_to_gene_feature' OR cvterm.name = 'gene_array_member' OR cvterm.name = 'regulated' OR cvterm.name = 'epigenetically_modified' OR cvterm.name = 'encodes_alternately_spliced_transcripts' OR cvterm.name = 'encodes_alternate_transcription_start_sites' OR cvterm.name = 'intein_containing' OR cvterm.name = 'miRNA_encoding' OR cvterm.name = 'rRNA_encoding' OR cvterm.name = 'scRNA_encoding' OR cvterm.name = 'snoRNA_encoding' OR cvterm.name = 'snRNA_encoding' OR cvterm.name = 'SRP_RNA_encoding' OR cvterm.name = 'stRNA_encoding' OR cvterm.name = 'tmRNA_encoding' OR cvterm.name = 'tRNA_encoding' OR cvterm.name = 'gRNA_encoding' OR cvterm.name = 'C_D_box_snoRNA_encoding' OR cvterm.name = 'H_ACA_box_snoRNA_encoding' OR cvterm.name = 'overlapping' OR cvterm.name = 'inside_intron' OR cvterm.name = 'five_prime_three_prime_overlap' OR cvterm.name = 'five_prime_five_prime_overlap' OR cvterm.name = 'three_prime_three_prime_overlap' OR cvterm.name = 'three_prime_five_prime_overlap' OR cvterm.name = 'antisense' OR cvterm.name = 'inside_intron_antiparallel' OR cvterm.name = 'inside_intron_parallel' OR cvterm.name = 'operon_member' OR cvterm.name = 'gene_cassette_member' OR cvterm.name = 'gene_subarray_member' OR cvterm.name = 'member_of_regulon' OR cvterm.name = 'cassette_array_member' OR cvterm.name = 'transcriptionally_regulated' OR cvterm.name = 'post_translationally_regulated' OR cvterm.name = 'translationally_regulated' OR cvterm.name = 'imprinted' OR cvterm.name = 'transcriptionally_constitutive' OR cvterm.name = 'transcriptionally_induced' OR cvterm.name = 'transcriptionally_repressed' OR cvterm.name = 'autoregulated' OR cvterm.name = 'positively_autoregulated' OR cvterm.name = 'negatively_autoregulated' OR cvterm.name = 'silenced' OR cvterm.name = 'silenced_by_DNA_modification' OR cvterm.name = 'silenced_by_RNA_interference' OR cvterm.name = 'silenced_by_histone_modification' OR cvterm.name = 'silenced_by_DNA_methylation' OR cvterm.name = 'silenced_by_histone_methylation' OR cvterm.name = 'silenced_by_histone_deacetylation' OR cvterm.name = 'negatively_autoregulated' OR cvterm.name = 'positively_autoregulated' OR cvterm.name = 'post_translationally_regulated_by_protein_stability' OR cvterm.name = 'post_translationally_regulated_by_protein_modification' OR cvterm.name = 'maternally_imprinted' OR cvterm.name = 'paternally_imprinted' OR cvterm.name = 'imprinted' OR cvterm.name = 'allelically_excluded' OR cvterm.name = 'rearranged_at_DNA_level' OR cvterm.name = 'maternally_imprinted' OR cvterm.name = 'paternally_imprinted' OR cvterm.name = 'encodes_1_polypeptide' OR cvterm.name = 'encodes_greater_than_1_polypeptide' OR cvterm.name = 'encodes_disjoint_polypeptides' OR cvterm.name = 'encodes_overlapping_peptides' OR cvterm.name = 'encodes_different_polypeptides_different_stop' OR cvterm.name = 'encodes_overlapping_peptides_different_start' OR cvterm.name = 'encodes_overlapping_polypeptides_different_start_and_stop' OR cvterm.name = 'gene_attribute';

--- ************************************************
--- *** relation: u14_snorna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** U14 small nucleolar RNA (U14 snoRNA) is  ***
--- *** required for early cleavages of eukaryot ***
--- *** ic precursor rRNAs. In yeasts, this mole ***
--- *** cule possess a stem-loop region (known a ***
--- *** s the Y-domain) which is essential for f ***
--- *** unction. A similar structure, but with a ***
--- ***  different consensus sequence, is found  ***
--- *** in plants, but is absent in vertebrates. ***
--- ************************************************
---

CREATE VIEW u14_snorna AS
  SELECT
    feature_id AS u14_snorna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U14_snoRNA';

--- ************************************************
--- *** relation: vault_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A family of RNAs are found as part of th ***
--- *** e enigmatic vault ribonucleoprotein comp ***
--- *** lex. The complex consists of a major vau ***
--- *** lt protein (MVP), two minor vault protei ***
--- *** ns (VPARP and TEP1), and several small u ***
--- *** ntranslated RNA molecules. It has been s ***
--- *** uggested that the vault complex is invol ***
--- *** ved in drug resistance.                  ***
--- ************************************************
---

CREATE VIEW vault_rna AS
  SELECT
    feature_id AS vault_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'vault_RNA';

--- ************************************************
--- *** relation: y_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Y RNAs are components of the Ro ribonucl ***
--- *** eoprotein particle (Ro RNP), in associat ***
--- *** ion with Ro60 and La proteins. The Y RNA ***
--- *** s and Ro60 and La proteins are well cons ***
--- *** erved, but the function of the Ro RNP is ***
--- ***  not known. In humans the RNA component  ***
--- *** can be one of four small RNAs: hY1, hY3, ***
--- ***  hY4 and hY5. These small RNAs are predi ***
--- *** cted to fold into a conserved secondary  ***
--- *** structure containing three stem structur ***
--- *** es. The largest of the four, hY1, contai ***
--- *** ns an additional hairpin.                ***
--- ************************************************
---

CREATE VIEW y_rna AS
  SELECT
    feature_id AS y_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'Y_RNA';

--- ************************************************
--- *** relation: twintron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An intron within an intron. Twintrons ar ***
--- *** e group II or III introns, into which an ***
--- *** other group II or III intron has been tr ***
--- *** ansposed.                                ***
--- ************************************************
---

CREATE VIEW twintron AS
  SELECT
    feature_id AS twintron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'twintron';

--- ************************************************
--- *** relation: rrna_18s ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A large polynucleotide in eukaryotes, wh ***
--- *** ich functions as the small subunit of th ***
--- *** e ribosome.                              ***
--- ************************************************
---

CREATE VIEW rrna_18s AS
  SELECT
    feature_id AS rrna_18s_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_18S';

--- ************************************************
--- *** relation: binding_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A biological_region of sequence that, in ***
--- ***  the molecule, interacts selectively and ***
--- ***  non-covalently with other molecules. A  ***
--- *** region on the surface of a molecule that ***
--- ***  may interact with another molecule. Whe ***
--- *** n applied to polypeptides: Amino acids i ***
--- *** nvolved in binding or interactions. It c ***
--- *** an also apply to an amino acid bond whic ***
--- *** h is represented by the positions of the ***
--- ***  two flanking amino acids.               ***
--- ************************************************
---

CREATE VIEW binding_site AS
  SELECT
    feature_id AS binding_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'protein_binding_site' OR cvterm.name = 'epitope' OR cvterm.name = 'nucleotide_binding_site' OR cvterm.name = 'metal_binding_site' OR cvterm.name = 'ligand_binding_site' OR cvterm.name = 'protein_protein_contact' OR cvterm.name = 'nucleotide_to_protein_binding_site' OR cvterm.name = 'nuclease_binding_site' OR cvterm.name = 'TF_binding_site' OR cvterm.name = 'histone_binding_site' OR cvterm.name = 'insulator_binding_site' OR cvterm.name = 'enhancer_binding_site' OR cvterm.name = 'restriction_enzyme_binding_site' OR cvterm.name = 'nuclease_sensitive_site' OR cvterm.name = 'homing_endonuclease_binding_site' OR cvterm.name = 'nuclease_hypersensitive_site' OR cvterm.name = 'group_1_intron_homing_endonuclease_target_region' OR cvterm.name = 'DNAseI_hypersensitive_site' OR cvterm.name = 'miRNA_target_site' OR cvterm.name = 'DNA_binding_site' OR cvterm.name = 'primer_binding_site' OR cvterm.name = 'polypeptide_DNA_contact' OR cvterm.name = 'polypeptide_metal_contact' OR cvterm.name = 'polypeptide_calcium_ion_contact_site' OR cvterm.name = 'polypeptide_cobalt_ion_contact_site' OR cvterm.name = 'polypeptide_copper_ion_contact_site' OR cvterm.name = 'polypeptide_iron_ion_contact_site' OR cvterm.name = 'polypeptide_magnesium_ion_contact_site' OR cvterm.name = 'polypeptide_manganese_ion_contact_site' OR cvterm.name = 'polypeptide_molybdenum_ion_contact_site' OR cvterm.name = 'polypeptide_nickel_ion_contact_site' OR cvterm.name = 'polypeptide_tungsten_ion_contact_site' OR cvterm.name = 'polypeptide_zinc_ion_contact_site' OR cvterm.name = 'polypeptide_ligand_contact' OR cvterm.name = 'binding_site';

--- ************************************************
--- *** relation: protein_binding_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A binding site that, in the molecule, in ***
--- *** teracts selectively and non-covalently w ***
--- *** ith polypeptide molecules.               ***
--- ************************************************
---

CREATE VIEW protein_binding_site AS
  SELECT
    feature_id AS protein_binding_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'protein_protein_contact' OR cvterm.name = 'nucleotide_to_protein_binding_site' OR cvterm.name = 'nuclease_binding_site' OR cvterm.name = 'TF_binding_site' OR cvterm.name = 'histone_binding_site' OR cvterm.name = 'insulator_binding_site' OR cvterm.name = 'enhancer_binding_site' OR cvterm.name = 'restriction_enzyme_binding_site' OR cvterm.name = 'nuclease_sensitive_site' OR cvterm.name = 'homing_endonuclease_binding_site' OR cvterm.name = 'nuclease_hypersensitive_site' OR cvterm.name = 'group_1_intron_homing_endonuclease_target_region' OR cvterm.name = 'DNAseI_hypersensitive_site' OR cvterm.name = 'protein_binding_site';

--- ************************************************
--- *** relation: rescue_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region that rescues.                   ***
--- ************************************************
---

CREATE VIEW rescue_region AS
  SELECT
    feature_id AS rescue_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_rescue_region' OR cvterm.name = 'rescue_region';

--- ************************************************
--- *** relation: restriction_fragment ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of polynucleotide sequence prod ***
--- *** uced by digestion with a restriction end ***
--- *** onuclease.                               ***
--- ************************************************
---

CREATE VIEW restriction_fragment AS
  SELECT
    feature_id AS restriction_fragment_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RFLP_fragment' OR cvterm.name = 'restriction_fragment';

--- ************************************************
--- *** relation: sequence_difference ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region where the sequence differs from ***
--- ***  that of a specified sequence.           ***
--- ************************************************
---

CREATE VIEW sequence_difference AS
  SELECT
    feature_id AS sequence_difference_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'possible_base_call_error' OR cvterm.name = 'possible_assembly_error' OR cvterm.name = 'assembly_error_correction' OR cvterm.name = 'base_call_error_correction' OR cvterm.name = 'sequence_difference';

--- ************************************************
--- *** relation: invalidated_by_genomic_contamination ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a feature that  ***
--- *** is invalidated due to genomic contaminat ***
--- *** ion.                                     ***
--- ************************************************
---

CREATE VIEW invalidated_by_genomic_contamination AS
  SELECT
    feature_id AS invalidated_by_genomic_contamination_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'invalidated_by_genomic_contamination';

--- ************************************************
--- *** relation: invalidated_by_genomic_polya_primed_cdna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a feature that  ***
--- *** is invalidated due to polyA priming.     ***
--- ************************************************
---

CREATE VIEW invalidated_by_genomic_polya_primed_cdna AS
  SELECT
    feature_id AS invalidated_by_genomic_polya_primed_cdna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'invalidated_by_genomic_polyA_primed_cDNA';

--- ************************************************
--- *** relation: invalidated_by_partial_processing ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a feature that  ***
--- *** is invalidated due to partial processing ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW invalidated_by_partial_processing AS
  SELECT
    feature_id AS invalidated_by_partial_processing_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'invalidated_by_partial_processing';

--- ************************************************
--- *** relation: polypeptide_domain ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A structurally or functionally defined p ***
--- *** rotein region. In proteins with multiple ***
--- ***  domains, the combination of the domains ***
--- ***  determines the function of the protein. ***
--- ***  A region which has been shown to recur  ***
--- *** throughout evolution.                    ***
--- ************************************************
---

CREATE VIEW polypeptide_domain AS
  SELECT
    feature_id AS polypeptide_domain_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_domain';

--- ************************************************
--- *** relation: signal_peptide ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The signal_peptide is a short region of  ***
--- *** the peptide located at the N-terminus th ***
--- *** at directs the protein to be secreted or ***
--- ***  part of membrane components.            ***
--- ************************************************
---

CREATE VIEW signal_peptide AS
  SELECT
    feature_id AS signal_peptide_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'signal_peptide';

--- ************************************************
--- *** relation: mature_protein_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The polypeptide sequence that remains wh ***
--- *** en the cleaved peptide regions have been ***
--- ***  cleaved from the immature peptide.      ***
--- ************************************************
---

CREATE VIEW mature_protein_region AS
  SELECT
    feature_id AS mature_protein_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'active_peptide' OR cvterm.name = 'mature_protein_region';

--- ************************************************
--- *** relation: five_prime_terminal_inverted_repeat ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW five_prime_terminal_inverted_repeat AS
  SELECT
    feature_id AS five_prime_terminal_inverted_repeat_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_terminal_inverted_repeat';

--- ************************************************
--- *** relation: three_prime_terminal_inverted_repeat ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW three_prime_terminal_inverted_repeat AS
  SELECT
    feature_id AS three_prime_terminal_inverted_repeat_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_terminal_inverted_repeat';

--- ************************************************
--- *** relation: u5_ltr_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW u5_ltr_region AS
  SELECT
    feature_id AS u5_ltr_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U5_five_prime_LTR_region' OR cvterm.name = 'U5_LTR_region';

--- ************************************************
--- *** relation: r_ltr_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW r_ltr_region AS
  SELECT
    feature_id AS r_ltr_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'R_five_prime_LTR_region' OR cvterm.name = 'R_LTR_region';

--- ************************************************
--- *** relation: u3_ltr_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW u3_ltr_region AS
  SELECT
    feature_id AS u3_ltr_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U3_five_prime_LTR_region' OR cvterm.name = 'U3_LTR_region';

--- ************************************************
--- *** relation: five_prime_ltr ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW five_prime_ltr AS
  SELECT
    feature_id AS five_prime_ltr_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_LTR';

--- ************************************************
--- *** relation: three_prime_ltr ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW three_prime_ltr AS
  SELECT
    feature_id AS three_prime_ltr_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_LTR';

--- ************************************************
--- *** relation: r_five_prime_ltr_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW r_five_prime_ltr_region AS
  SELECT
    feature_id AS r_five_prime_ltr_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'R_five_prime_LTR_region';

--- ************************************************
--- *** relation: u5_five_prime_ltr_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW u5_five_prime_ltr_region AS
  SELECT
    feature_id AS u5_five_prime_ltr_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U5_five_prime_LTR_region';

--- ************************************************
--- *** relation: u3_five_prime_ltr_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW u3_five_prime_ltr_region AS
  SELECT
    feature_id AS u3_five_prime_ltr_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U3_five_prime_LTR_region';

--- ************************************************
--- *** relation: r_three_prime_ltr_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW r_three_prime_ltr_region AS
  SELECT
    feature_id AS r_three_prime_ltr_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'R_three_prime_LTR_region';

--- ************************************************
--- *** relation: u3_three_prime_ltr_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW u3_three_prime_ltr_region AS
  SELECT
    feature_id AS u3_three_prime_ltr_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U3_three_prime_LTR_region';

--- ************************************************
--- *** relation: u5_three_prime_ltr_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW u5_three_prime_ltr_region AS
  SELECT
    feature_id AS u5_three_prime_ltr_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U5_three_prime_LTR_region';

--- ************************************************
--- *** relation: non_ltr_retrotransposon_polymeric_tract ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A polymeric tract, such as poly(dA), wit ***
--- *** hin a non_LTR_retrotransposon.           ***
--- ************************************************
---

CREATE VIEW non_ltr_retrotransposon_polymeric_tract AS
  SELECT
    feature_id AS non_ltr_retrotransposon_polymeric_tract_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'non_LTR_retrotransposon_polymeric_tract';

--- ************************************************
--- *** relation: target_site_duplication ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence of the target DNA that is dup ***
--- *** licated when a transposable element or p ***
--- *** hage inserts; usually found at each end  ***
--- *** the insertion.                           ***
--- ************************************************
---

CREATE VIEW target_site_duplication AS
  SELECT
    feature_id AS target_site_duplication_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'target_site_duplication';

--- ************************************************
--- *** relation: rr_tract ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A polypurine tract within an LTR_retrotr ***
--- *** ansposon.                                ***
--- ************************************************
---

CREATE VIEW rr_tract AS
  SELECT
    feature_id AS rr_tract_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RR_tract';

--- ************************************************
--- *** relation: ars ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence that can autonomously replica ***
--- *** te, as a plasmid, when transformed into  ***
--- *** a bacterial host.                        ***
--- ************************************************
---

CREATE VIEW ars AS
  SELECT
    feature_id AS ars_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'ARS';

--- ************************************************
--- *** relation: inverted_ring_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW inverted_ring_chromosome AS
  SELECT
    feature_id AS inverted_ring_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inverted_ring_chromosome';

--- ************************************************
--- *** relation: vector_replicon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A replicon that has been modified to act ***
--- ***  as a vector for foreign sequence.       ***
--- ************************************************
---

CREATE VIEW vector_replicon AS
  SELECT
    feature_id AS vector_replicon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'YAC' OR cvterm.name = 'BAC' OR cvterm.name = 'PAC' OR cvterm.name = 'cosmid' OR cvterm.name = 'phagemid' OR cvterm.name = 'fosmid' OR cvterm.name = 'lambda_vector' OR cvterm.name = 'plasmid_vector' OR cvterm.name = 'targeting_vector' OR cvterm.name = 'vector_replicon';

--- ************************************************
--- *** relation: ss_oligo ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A single stranded oligonucleotide.       ***
--- ************************************************
---

CREATE VIEW ss_oligo AS
  SELECT
    feature_id AS ss_oligo_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'primer' OR cvterm.name = 'sequencing_primer' OR cvterm.name = 'forward_primer' OR cvterm.name = 'reverse_primer' OR cvterm.name = 'ASPE_primer' OR cvterm.name = 'dCAPS_primer' OR cvterm.name = 'ss_oligo';

--- ************************************************
--- *** relation: ds_oligo ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A double stranded oligonucleotide.       ***
--- ************************************************
---

CREATE VIEW ds_oligo AS
  SELECT
    feature_id AS ds_oligo_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNAi_reagent' OR cvterm.name = 'DNA_constraint_sequence' OR cvterm.name = 'ds_oligo';

--- ************************************************
--- *** relation: polymer_attribute ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe the kind of bio ***
--- *** logical sequence.                        ***
--- ************************************************
---

CREATE VIEW polymer_attribute AS
  SELECT
    feature_id AS polymer_attribute_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'nucleic_acid' OR cvterm.name = 'synthetic_sequence' OR cvterm.name = 'topology_attribute' OR cvterm.name = 'peptidyl' OR cvterm.name = 'DNA' OR cvterm.name = 'RNA' OR cvterm.name = 'morpholino_backbone' OR cvterm.name = 'PNA' OR cvterm.name = 'LNA' OR cvterm.name = 'TNA' OR cvterm.name = 'GNA' OR cvterm.name = 'cDNA' OR cvterm.name = 'genomic_DNA' OR cvterm.name = 'single_stranded_cDNA' OR cvterm.name = 'double_stranded_cDNA' OR cvterm.name = 'R_GNA' OR cvterm.name = 'S_GNA' OR cvterm.name = 'random_sequence' OR cvterm.name = 'designed_sequence' OR cvterm.name = 'linear' OR cvterm.name = 'circular' OR cvterm.name = 'polymer_attribute';

--- ************************************************
--- *** relation: three_prime_noncoding_exon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Non-coding exon in the 3' UTR.           ***
--- ************************************************
---

CREATE VIEW three_prime_noncoding_exon AS
  SELECT
    feature_id AS three_prime_noncoding_exon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_noncoding_exon';

--- ************************************************
--- *** relation: five_prime_noncoding_exon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Non-coding exon in the 5' UTR.           ***
--- ************************************************
---

CREATE VIEW five_prime_noncoding_exon AS
  SELECT
    feature_id AS five_prime_noncoding_exon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_noncoding_exon';

--- ************************************************
--- *** relation: utr_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Intron located in the untranslated regio ***
--- *** n.                                       ***
--- ************************************************
---

CREATE VIEW utr_intron AS
  SELECT
    feature_id AS utr_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_UTR_intron' OR cvterm.name = 'three_prime_UTR_intron' OR cvterm.name = 'UTR_intron';

--- ************************************************
--- *** relation: five_prime_utr_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An intron located in the 5' UTR.         ***
--- ************************************************
---

CREATE VIEW five_prime_utr_intron AS
  SELECT
    feature_id AS five_prime_utr_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_UTR_intron';

--- ************************************************
--- *** relation: three_prime_utr_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An intron located in the 3' UTR.         ***
--- ************************************************
---

CREATE VIEW three_prime_utr_intron AS
  SELECT
    feature_id AS three_prime_utr_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_UTR_intron';

--- ************************************************
--- *** relation: random_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence of nucleotides or amino acids ***
--- ***  which, by design, has a "random" order  ***
--- *** of components, given a predetermined inp ***
--- *** ut frequency of these components.        ***
--- ************************************************
---

CREATE VIEW random_sequence AS
  SELECT
    feature_id AS random_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'random_sequence';

--- ************************************************
--- *** relation: interband ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A light region between two darkly staini ***
--- *** ng bands in a polytene chromosome.       ***
--- ************************************************
---

CREATE VIEW interband AS
  SELECT
    feature_id AS interband_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'interband';

--- ************************************************
--- *** relation: gene_with_polyadenylated_mrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that encodes a polyadenylated mRN ***
--- *** A.                                       ***
--- ************************************************
---

CREATE VIEW gene_with_polyadenylated_mrna AS
  SELECT
    feature_id AS gene_with_polyadenylated_mrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_with_polyadenylated_mRNA';

--- ************************************************
--- *** relation: chromosomal_transposition ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome structure variant whereby a ***
--- ***  region of a chromosome has been transfe ***
--- *** rred to another position. Among interchr ***
--- *** omosomal rearrangements, the term transp ***
--- *** osition is reserved for that class in wh ***
--- *** ich the telomeres of the chromosomes inv ***
--- *** olved are coupled (that is to say, form  ***
--- *** the two ends of a single DNA molecule) a ***
--- *** s in wild-type.                          ***
--- ************************************************
---

CREATE VIEW chromosomal_transposition AS
  SELECT
    feature_id AS chromosomal_transposition_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'intrachromosomal_transposition' OR cvterm.name = 'interchromosomal_transposition' OR cvterm.name = 'deficient_intrachromosomal_transposition' OR cvterm.name = 'inverted_intrachromosomal_transposition' OR cvterm.name = 'uninverted_intrachromosomal_transposition' OR cvterm.name = 'unoriented_intrachromosomal_transposition' OR cvterm.name = 'deficient_interchromosomal_transposition' OR cvterm.name = 'inverted_interchromosomal_transposition' OR cvterm.name = 'uninverted_interchromosomal_transposition' OR cvterm.name = 'unoriented_interchromosomal_transposition' OR cvterm.name = 'chromosomal_transposition';

--- ************************************************
--- *** relation: rasirna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A 17-28-nt, small interfering RNA derive ***
--- *** d from transcripts of repetitive element ***
--- *** s.                                       ***
--- ************************************************
---

CREATE VIEW rasirna AS
  SELECT
    feature_id AS rasirna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rasiRNA';

--- ************************************************
--- *** relation: gene_with_mrna_with_frameshift ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that encodes an mRNA with a frame ***
--- *** shift.                                   ***
--- ************************************************
---

CREATE VIEW gene_with_mrna_with_frameshift AS
  SELECT
    feature_id AS gene_with_mrna_with_frameshift_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_with_mRNA_with_frameshift';

--- ************************************************
--- *** relation: recombinationally_rearranged_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that is recombinationally rearran ***
--- *** ged.                                     ***
--- ************************************************
---

CREATE VIEW recombinationally_rearranged_gene AS
  SELECT
    feature_id AS recombinationally_rearranged_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'recombinationally_inverted_gene' OR cvterm.name = 'recombinationally_rearranged_vertebrate_immune_system_gene' OR cvterm.name = 'recombinationally_rearranged_gene';

--- ************************************************
--- *** relation: interchromosomal_duplication ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome duplication involving an in ***
--- *** sertion from another chromosome.         ***
--- ************************************************
---

CREATE VIEW interchromosomal_duplication AS
  SELECT
    feature_id AS interchromosomal_duplication_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'interchromosomal_duplication';

--- ************************************************
--- *** relation: d_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Germline genomic DNA including D-region  ***
--- *** with 5' UTR and 3' UTR, also designated  ***
--- *** as D-segment.                            ***
--- ************************************************
---

CREATE VIEW d_gene AS
  SELECT
    feature_id AS d_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'D_gene';

--- ************************************************
--- *** relation: gene_with_trans_spliced_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene with a transcript that is trans-s ***
--- *** pliced.                                  ***
--- ************************************************
---

CREATE VIEW gene_with_trans_spliced_transcript AS
  SELECT
    feature_id AS gene_with_trans_spliced_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_with_trans_spliced_transcript';

--- ************************************************
--- *** relation: vertebrate_immunoglobulin_t_cell_receptor_segment ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW vertebrate_immunoglobulin_t_cell_receptor_segment AS
  SELECT
    feature_id AS vertebrate_immunoglobulin_t_cell_receptor_segment_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'D_gene' OR cvterm.name = 'V_gene' OR cvterm.name = 'J_gene' OR cvterm.name = 'C_gene' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_segment';

--- ************************************************
--- *** relation: inversion_derived_bipartite_deficiency ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosomal deletion whereby a chromos ***
--- *** ome generated by recombination between t ***
--- *** wo inversions; has a deficiency at each  ***
--- *** end of the inversion.                    ***
--- ************************************************
---

CREATE VIEW inversion_derived_bipartite_deficiency AS
  SELECT
    feature_id AS inversion_derived_bipartite_deficiency_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inversion_derived_bipartite_deficiency';

--- ************************************************
--- *** relation: pseudogenic_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A non-functional descendent of a functio ***
--- *** nal entity.                              ***
--- ************************************************
---

CREATE VIEW pseudogenic_region AS
  SELECT
    feature_id AS pseudogenic_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'decayed_exon' OR cvterm.name = 'pseudogenic_exon' OR cvterm.name = 'pseudogenic_transcript' OR cvterm.name = 'pseudogenic_rRNA' OR cvterm.name = 'pseudogenic_tRNA' OR cvterm.name = 'pseudogenic_region';

--- ************************************************
--- *** relation: encodes_alternately_spliced_transcripts ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that encodes more than one transc ***
--- *** ript.                                    ***
--- ************************************************
---

CREATE VIEW encodes_alternately_spliced_transcripts AS
  SELECT
    feature_id AS encodes_alternately_spliced_transcripts_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'encodes_1_polypeptide' OR cvterm.name = 'encodes_greater_than_1_polypeptide' OR cvterm.name = 'encodes_disjoint_polypeptides' OR cvterm.name = 'encodes_overlapping_peptides' OR cvterm.name = 'encodes_different_polypeptides_different_stop' OR cvterm.name = 'encodes_overlapping_peptides_different_start' OR cvterm.name = 'encodes_overlapping_polypeptides_different_start_and_stop' OR cvterm.name = 'encodes_alternately_spliced_transcripts';

--- ************************************************
--- *** relation: decayed_exon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A non-functional descendant of an exon.  ***
--- ************************************************
---

CREATE VIEW decayed_exon AS
  SELECT
    feature_id AS decayed_exon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'decayed_exon';

--- ************************************************
--- *** relation: inversion_derived_deficiency_plus_duplication ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome deletion whereby a chromoso ***
--- *** me is generated by recombination between ***
--- ***  two inversions; there is a deficiency a ***
--- *** t one end of the inversion and a duplica ***
--- *** tion at the other end of the inversion.  ***
--- ************************************************
---

CREATE VIEW inversion_derived_deficiency_plus_duplication AS
  SELECT
    feature_id AS inversion_derived_deficiency_plus_duplication_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inversion_derived_deficiency_plus_duplication';

--- ************************************************
--- *** relation: v_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Germline genomic DNA including L-part1,  ***
--- *** V-intron and V-exon, with the 5' UTR and ***
--- ***  3' UTR.                                 ***
--- ************************************************
---

CREATE VIEW v_gene AS
  SELECT
    feature_id AS v_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_gene';

--- ************************************************
--- *** relation: post_translationally_regulated_by_protein_stability ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a gene sequence  ***
--- *** where the resulting protein is regulated ***
--- ***  by the stability of the resulting prote ***
--- *** in.                                      ***
--- ************************************************
---

CREATE VIEW post_translationally_regulated_by_protein_stability AS
  SELECT
    feature_id AS post_translationally_regulated_by_protein_stability_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'post_translationally_regulated_by_protein_stability';

--- ************************************************
--- *** relation: golden_path_fragment ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** One of the pieces of sequence that make  ***
--- *** up a golden path.                        ***
--- ************************************************
---

CREATE VIEW golden_path_fragment AS
  SELECT
    feature_id AS golden_path_fragment_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'golden_path_fragment';

--- ************************************************
--- *** relation: post_translationally_regulated_by_protein_modification ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a gene sequence  ***
--- *** where the resulting protein is modified  ***
--- *** to regulate it.                          ***
--- ************************************************
---

CREATE VIEW post_translationally_regulated_by_protein_modification AS
  SELECT
    feature_id AS post_translationally_regulated_by_protein_modification_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'post_translationally_regulated_by_protein_modification';

--- ************************************************
--- *** relation: j_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Germline genomic DNA of an immunoglobuli ***
--- *** n/T-cell receptor gene including J-regio ***
--- *** n with 5' UTR (SO:0000204) and 3' UTR (S ***
--- *** O:0000205), also designated as J-segment ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW j_gene AS
  SELECT
    feature_id AS j_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'J_gene';

--- ************************************************
--- *** relation: autoregulated ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The gene product is involved in its own  ***
--- *** transcriptional regulation.              ***
--- ************************************************
---

CREATE VIEW autoregulated AS
  SELECT
    feature_id AS autoregulated_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'negatively_autoregulated' OR cvterm.name = 'positively_autoregulated' OR cvterm.name = 'autoregulated';

--- ************************************************
--- *** relation: tiling_path ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A set of regions which overlap with mini ***
--- *** mal polymorphism to form a linear sequen ***
--- *** ce.                                      ***
--- ************************************************
---

CREATE VIEW tiling_path AS
  SELECT
    feature_id AS tiling_path_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tiling_path';

--- ************************************************
--- *** relation: negatively_autoregulated ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The gene product is involved in its own  ***
--- *** transcriptional regulation where it decr ***
--- *** eases transcription.                     ***
--- ************************************************
---

CREATE VIEW negatively_autoregulated AS
  SELECT
    feature_id AS negatively_autoregulated_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'negatively_autoregulated';

--- ************************************************
--- *** relation: tiling_path_fragment ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A piece of sequence that makes up a tili ***
--- *** ng_path (SO:0000472).                    ***
--- ************************************************
---

CREATE VIEW tiling_path_fragment AS
  SELECT
    feature_id AS tiling_path_fragment_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tiling_path_clone' OR cvterm.name = 'tiling_path_fragment';

--- ************************************************
--- *** relation: positively_autoregulated ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The gene product is involved in its own  ***
--- *** transcriptional regulation, where it inc ***
--- *** reases transcription.                    ***
--- ************************************************
---

CREATE VIEW positively_autoregulated AS
  SELECT
    feature_id AS positively_autoregulated_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'positively_autoregulated';

--- ************************************************
--- *** relation: contig_read ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A DNA sequencer read which is part of a  ***
--- *** contig.                                  ***
--- ************************************************
---

CREATE VIEW contig_read AS
  SELECT
    feature_id AS contig_read_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'contig_read';

--- ************************************************
--- *** relation: c_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene including C-region (and intro ***
--- *** ns if present) with 5' UTR (SO:0000204)  ***
--- *** and 3' UTR (SO:0000205).                 ***
--- ************************************************
---

CREATE VIEW c_gene AS
  SELECT
    feature_id AS c_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'C_gene';

--- ************************************************
--- *** relation: trans_spliced_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transcript that is trans-spliced.      ***
--- ************************************************
---

CREATE VIEW trans_spliced_transcript AS
  SELECT
    feature_id AS trans_spliced_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'trans_spliced_mRNA' OR cvterm.name = 'trans_spliced_transcript';

--- ************************************************
--- *** relation: tiling_path_clone ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A clone which is part of a tiling path.  ***
--- *** A tiling path is a set of sequencing sub ***
--- *** strates, typically clones, which have be ***
--- *** en selected in order to efficiently cove ***
--- *** r a region of the genome in preparation  ***
--- *** for sequencing and assembly.             ***
--- ************************************************
---

CREATE VIEW tiling_path_clone AS
  SELECT
    feature_id AS tiling_path_clone_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tiling_path_clone';

--- ************************************************
--- *** relation: terminal_inverted_repeat ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An inverted repeat (SO:0000294) occurrin ***
--- *** g at the termini of a DNA transposon.    ***
--- ************************************************
---

CREATE VIEW terminal_inverted_repeat AS
  SELECT
    feature_id AS terminal_inverted_repeat_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_terminal_inverted_repeat' OR cvterm.name = 'three_prime_terminal_inverted_repeat' OR cvterm.name = 'terminal_inverted_repeat';

--- ************************************************
--- *** relation: vertebrate_immunoglobulin_t_cell_receptor_gene_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW vertebrate_immunoglobulin_t_cell_receptor_gene_cluster AS
  SELECT
    feature_id AS vertebrate_immunoglobulin_t_cell_receptor_gene_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'D_J_C_cluster' OR cvterm.name = 'J_C_cluster' OR cvterm.name = 'J_cluster' OR cvterm.name = 'V_cluster' OR cvterm.name = 'V_J_cluster' OR cvterm.name = 'V_J_C_cluster' OR cvterm.name = 'C_cluster' OR cvterm.name = 'D_cluster' OR cvterm.name = 'D_J_cluster' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_gene_cluster';

--- ************************************************
--- *** relation: nc_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript that is never trans ***
--- *** lated into a protein.                    ***
--- ************************************************
---

CREATE VIEW nc_primary_transcript AS
  SELECT
    feature_id AS nc_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'scRNA_primary_transcript' OR cvterm.name = 'rRNA_primary_transcript' OR cvterm.name = 'tRNA_primary_transcript' OR cvterm.name = 'snRNA_primary_transcript' OR cvterm.name = 'snoRNA_primary_transcript' OR cvterm.name = 'tmRNA_primary_transcript' OR cvterm.name = 'SRP_RNA_primary_transcript' OR cvterm.name = 'miRNA_primary_transcript' OR cvterm.name = 'tasiRNA_primary_transcript' OR cvterm.name = 'rRNA_small_subunit_primary_transcript' OR cvterm.name = 'rRNA_large_subunit_primary_transcript' OR cvterm.name = 'alanine_tRNA_primary_transcript' OR cvterm.name = 'arginine_tRNA_primary_transcript' OR cvterm.name = 'asparagine_tRNA_primary_transcript' OR cvterm.name = 'aspartic_acid_tRNA_primary_transcript' OR cvterm.name = 'cysteine_tRNA_primary_transcript' OR cvterm.name = 'glutamic_acid_tRNA_primary_transcript' OR cvterm.name = 'glutamine_tRNA_primary_transcript' OR cvterm.name = 'glycine_tRNA_primary_transcript' OR cvterm.name = 'histidine_tRNA_primary_transcript' OR cvterm.name = 'isoleucine_tRNA_primary_transcript' OR cvterm.name = 'leucine_tRNA_primary_transcript' OR cvterm.name = 'lysine_tRNA_primary_transcript' OR cvterm.name = 'methionine_tRNA_primary_transcript' OR cvterm.name = 'phenylalanine_tRNA_primary_transcript' OR cvterm.name = 'proline_tRNA_primary_transcript' OR cvterm.name = 'serine_tRNA_primary_transcript' OR cvterm.name = 'threonine_tRNA_primary_transcript' OR cvterm.name = 'tryptophan_tRNA_primary_transcript' OR cvterm.name = 'tyrosine_tRNA_primary_transcript' OR cvterm.name = 'valine_tRNA_primary_transcript' OR cvterm.name = 'pyrrolysine_tRNA_primary_transcript' OR cvterm.name = 'selenocysteine_tRNA_primary_transcript' OR cvterm.name = 'methylation_guide_snoRNA_primary_transcript' OR cvterm.name = 'rRNA_cleavage_snoRNA_primary_transcript' OR cvterm.name = 'C_D_box_snoRNA_primary_transcript' OR cvterm.name = 'H_ACA_box_snoRNA_primary_transcript' OR cvterm.name = 'U14_snoRNA_primary_transcript' OR cvterm.name = 'stRNA_primary_transcript' OR cvterm.name = 'nc_primary_transcript';

--- ************************************************
--- *** relation: three_prime_coding_exon_noncoding_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The sequence of the 3' exon that is not  ***
--- *** coding.                                  ***
--- ************************************************
---

CREATE VIEW three_prime_coding_exon_noncoding_region AS
  SELECT
    feature_id AS three_prime_coding_exon_noncoding_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_coding_exon_noncoding_region';

--- ************************************************
--- *** relation: dj_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one DJ-gene, and one J ***
--- *** -gene.                                   ***
--- ************************************************
---

CREATE VIEW dj_j_cluster AS
  SELECT
    feature_id AS dj_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DJ_J_cluster';

--- ************************************************
--- *** relation: five_prime_coding_exon_noncoding_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The sequence of the 5' exon preceding th ***
--- *** e start codon.                           ***
--- ************************************************
---

CREATE VIEW five_prime_coding_exon_noncoding_region AS
  SELECT
    feature_id AS five_prime_coding_exon_noncoding_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_coding_exon_noncoding_region';

--- ************************************************
--- *** relation: vdj_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one VDJ-gene, one J-ge ***
--- *** ne and one C-gene.                       ***
--- ************************************************
---

CREATE VIEW vdj_j_c_cluster AS
  SELECT
    feature_id AS vdj_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'VDJ_J_C_cluster';

--- ************************************************
--- *** relation: vdj_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one VDJ-gene and one J ***
--- *** -gene.                                   ***
--- ************************************************
---

CREATE VIEW vdj_j_cluster AS
  SELECT
    feature_id AS vdj_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'VDJ_J_cluster';

--- ************************************************
--- *** relation: vj_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one VJ-gene and one C- ***
--- *** gene.                                    ***
--- ************************************************
---

CREATE VIEW vj_c_cluster AS
  SELECT
    feature_id AS vj_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'VJ_C_cluster';

--- ************************************************
--- *** relation: vj_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one VJ-gene, one J-gen ***
--- *** e and one C-gene.                        ***
--- ************************************************
---

CREATE VIEW vj_j_c_cluster AS
  SELECT
    feature_id AS vj_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'VJ_J_C_cluster';

--- ************************************************
--- *** relation: vj_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one VJ-gene and one J- ***
--- *** gene.                                    ***
--- ************************************************
---

CREATE VIEW vj_j_cluster AS
  SELECT
    feature_id AS vj_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'VJ_J_cluster';

--- ************************************************
--- *** relation: d_gene_recombination_feature ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW d_gene_recombination_feature AS
  SELECT
    feature_id AS d_gene_recombination_feature_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_recombination_signal_sequence' OR cvterm.name = 'D_gene_recombination_feature';

--- ************************************************
--- *** relation: three_prime_d_heptamer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 7 nucleotide recombination site like CAC ***
--- *** AGTG, part of a 3' D-recombination signa ***
--- *** l sequence of an immunoglobulin/T-cell r ***
--- *** eceptor gene.                            ***
--- ************************************************
---

CREATE VIEW three_prime_d_heptamer AS
  SELECT
    feature_id AS three_prime_d_heptamer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_D_heptamer';

--- ************************************************
--- *** relation: three_prime_d_nonamer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A 9 nucleotide recombination site (e.g.  ***
--- *** ACAAAAACC), part of a 3' D-recombination ***
--- ***  signal sequence of an immunoglobulin/T- ***
--- *** cell receptor gene.                      ***
--- ************************************************
---

CREATE VIEW three_prime_d_nonamer AS
  SELECT
    feature_id AS three_prime_d_nonamer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_D_nonamer';

--- ************************************************
--- *** relation: three_prime_d_spacer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A 12 or 23 nucleotide spacer between the ***
--- ***  3'D-HEPTAMER and 3'D-NONAMER of a 3'D-R ***
--- *** S.                                       ***
--- ************************************************
---

CREATE VIEW three_prime_d_spacer AS
  SELECT
    feature_id AS three_prime_d_spacer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_D_spacer';

--- ************************************************
--- *** relation: five_prime_d_heptamer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 7 nucleotide recombination site (e.g. CA ***
--- *** CTGTG), part of a 5' D-recombination sig ***
--- *** nal sequence (SO:0000556) of an immunogl ***
--- *** obulin/T-cell receptor gene.             ***
--- ************************************************
---

CREATE VIEW five_prime_d_heptamer AS
  SELECT
    feature_id AS five_prime_d_heptamer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_D_heptamer';

--- ************************************************
--- *** relation: five_prime_d_nonamer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 9 nucleotide recombination site (e.g. GG ***
--- *** TTTTTGT), part of a five_prime_D-recombi ***
--- *** nation signal sequence (SO:0000556) of a ***
--- *** n immunoglobulin/T-cell receptor gene.   ***
--- ************************************************
---

CREATE VIEW five_prime_d_nonamer AS
  SELECT
    feature_id AS five_prime_d_nonamer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_D_nonamer';

--- ************************************************
--- *** relation: five_prime_d_spacer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 12 or 23 nucleotide spacer between the 5 ***
--- *** ' D-heptamer (SO:0000496) and 5' D-nonam ***
--- *** er (SO:0000497) of a 5' D-recombination  ***
--- *** signal sequence (SO:0000556) of an immun ***
--- *** oglobulin/T-cell receptor gene.          ***
--- ************************************************
---

CREATE VIEW five_prime_d_spacer AS
  SELECT
    feature_id AS five_prime_d_spacer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_D_spacer';

--- ************************************************
--- *** relation: virtual_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A continuous piece of sequence similar t ***
--- *** o the 'virtual contig' concept of the En ***
--- *** sembl database.                          ***
--- ************************************************
---

CREATE VIEW virtual_sequence AS
  SELECT
    feature_id AS virtual_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'virtual_sequence';

--- ************************************************
--- *** relation: hoogsteen_base_pair ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A type of non-canonical base-pairing. Th ***
--- *** is is less energetically favourable than ***
--- ***  watson crick base pairing. Hoogsteen GC ***
--- ***  base pairs only have two hydrogen bonds ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW hoogsteen_base_pair AS
  SELECT
    feature_id AS hoogsteen_base_pair_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'Hoogsteen_base_pair';

--- ************************************************
--- *** relation: reverse_hoogsteen_base_pair ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A type of non-canonical base-pairing.    ***
--- ************************************************
---

CREATE VIEW reverse_hoogsteen_base_pair AS
  SELECT
    feature_id AS reverse_hoogsteen_base_pair_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'reverse_Hoogsteen_base_pair';

--- ************************************************
--- *** relation: d_dj_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one D-gene, one DJ-gen ***
--- *** e and one C-gene.                        ***
--- ************************************************
---

CREATE VIEW d_dj_c_cluster AS
  SELECT
    feature_id AS d_dj_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'D_DJ_C_cluster';

--- ************************************************
--- *** relation: d_dj_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one D-gene and one DJ- ***
--- *** gene.                                    ***
--- ************************************************
---

CREATE VIEW d_dj_cluster AS
  SELECT
    feature_id AS d_dj_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'D_DJ_cluster';

--- ************************************************
--- *** relation: d_dj_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one D-gene, one DJ-gen ***
--- *** e, one J-gene and one C-gene.            ***
--- ************************************************
---

CREATE VIEW d_dj_j_c_cluster AS
  SELECT
    feature_id AS d_dj_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'D_DJ_J_C_cluster';

--- ************************************************
--- *** relation: pseudogenic_exon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A non functional descendant of an exon,  ***
--- *** part of a pseudogene.                    ***
--- ************************************************
---

CREATE VIEW pseudogenic_exon AS
  SELECT
    feature_id AS pseudogenic_exon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pseudogenic_exon';

--- ************************************************
--- *** relation: d_dj_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one D-gene, one DJ-gen ***
--- *** e, and one J-gene.                       ***
--- ************************************************
---

CREATE VIEW d_dj_j_cluster AS
  SELECT
    feature_id AS d_dj_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'D_DJ_J_cluster';

--- ************************************************
--- *** relation: d_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding at least one D-gene, one J-gene a ***
--- *** nd one C-gene.                           ***
--- ************************************************
---

CREATE VIEW d_j_c_cluster AS
  SELECT
    feature_id AS d_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'D_J_C_cluster';

--- ************************************************
--- *** relation: vd_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in partially rearranged genom ***
--- *** ic DNA including L-part1, V-intron and V ***
--- *** -D-exon, with the 5' UTR (SO:0000204) an ***
--- *** d 3' UTR (SO:0000205).                   ***
--- ************************************************
---

CREATE VIEW vd_gene AS
  SELECT
    feature_id AS vd_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'VD_gene';

--- ************************************************
--- *** relation: j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding at least one J-gene and one C-gen ***
--- *** e.                                       ***
--- ************************************************
---

CREATE VIEW j_c_cluster AS
  SELECT
    feature_id AS j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'J_C_cluster';

--- ************************************************
--- *** relation: inversion_derived_deficiency_plus_aneuploid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosomal deletion whereby a chromos ***
--- *** ome generated by recombination between t ***
--- *** wo inversions; has a deficiency at one e ***
--- *** nd and presumed to have a deficiency or  ***
--- *** duplication at the other end of the inve ***
--- *** rsion.                                   ***
--- ************************************************
---

CREATE VIEW inversion_derived_deficiency_plus_aneuploid AS
  SELECT
    feature_id AS inversion_derived_deficiency_plus_aneuploid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inversion_derived_deficiency_plus_aneuploid';

--- ************************************************
--- *** relation: j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding more than one J-gene.             ***
--- ************************************************
---

CREATE VIEW j_cluster AS
  SELECT
    feature_id AS j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'J_cluster';

--- ************************************************
--- *** relation: j_nonamer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 9 nucleotide recombination site (e.g. GG ***
--- *** TTTTTGT), part of a J-gene recombination ***
--- ***  feature of an immunoglobulin/T-cell rec ***
--- *** eptor gene.                              ***
--- ************************************************
---

CREATE VIEW j_nonamer AS
  SELECT
    feature_id AS j_nonamer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'J_nonamer';

--- ************************************************
--- *** relation: j_heptamer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 7 nucleotide recombination site (e.g. CA ***
--- *** CAGTG), part of a J-gene recombination f ***
--- *** eature of an immunoglobulin/T-cell recep ***
--- *** tor gene.                                ***
--- ************************************************
---

CREATE VIEW j_heptamer AS
  SELECT
    feature_id AS j_heptamer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'J_heptamer';

--- ************************************************
--- *** relation: pseudogenic_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A non functional descendant of a transcr ***
--- *** ipt, part of a pseudogene.               ***
--- ************************************************
---

CREATE VIEW pseudogenic_transcript AS
  SELECT
    feature_id AS pseudogenic_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pseudogenic_transcript';

--- ************************************************
--- *** relation: j_spacer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 12 or 23 nucleotide spacer between the J ***
--- *** -nonamer and the J-heptamer of a J-gene  ***
--- *** recombination feature of an immunoglobul ***
--- *** in/T-cell receptor gene.                 ***
--- ************************************************
---

CREATE VIEW j_spacer AS
  SELECT
    feature_id AS j_spacer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'J_spacer';

--- ************************************************
--- *** relation: v_dj_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene and one DJ- ***
--- *** gene.                                    ***
--- ************************************************
---

CREATE VIEW v_dj_cluster AS
  SELECT
    feature_id AS v_dj_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_DJ_cluster';

--- ************************************************
--- *** relation: v_dj_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one DJ-gen ***
--- *** e and one J-gene.                        ***
--- ************************************************
---

CREATE VIEW v_dj_j_cluster AS
  SELECT
    feature_id AS v_dj_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_DJ_J_cluster';

--- ************************************************
--- *** relation: v_vdj_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one VDJ-ge ***
--- *** ne and one C-gene.                       ***
--- ************************************************
---

CREATE VIEW v_vdj_c_cluster AS
  SELECT
    feature_id AS v_vdj_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_VDJ_C_cluster';

--- ************************************************
--- *** relation: v_vdj_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene and one VDJ ***
--- *** -gene.                                   ***
--- ************************************************
---

CREATE VIEW v_vdj_cluster AS
  SELECT
    feature_id AS v_vdj_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_VDJ_cluster';

--- ************************************************
--- *** relation: v_vdj_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one VDJ-ge ***
--- *** ne and one J-gene.                       ***
--- ************************************************
---

CREATE VIEW v_vdj_j_cluster AS
  SELECT
    feature_id AS v_vdj_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_VDJ_J_cluster';

--- ************************************************
--- *** relation: v_vj_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one VJ-gen ***
--- *** e and one C-gene.                        ***
--- ************************************************
---

CREATE VIEW v_vj_c_cluster AS
  SELECT
    feature_id AS v_vj_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_VJ_C_cluster';

--- ************************************************
--- *** relation: v_vj_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene and one VJ- ***
--- *** gene.                                    ***
--- ************************************************
---

CREATE VIEW v_vj_cluster AS
  SELECT
    feature_id AS v_vj_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_VJ_cluster';

--- ************************************************
--- *** relation: v_vj_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one VJ-gen ***
--- *** e and one J-gene.                        ***
--- ************************************************
---

CREATE VIEW v_vj_j_cluster AS
  SELECT
    feature_id AS v_vj_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_VJ_J_cluster';

--- ************************************************
--- *** relation: v_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding more than one V-gene.             ***
--- ************************************************
---

CREATE VIEW v_cluster AS
  SELECT
    feature_id AS v_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_cluster';

--- ************************************************
--- *** relation: v_d_dj_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one D-gene ***
--- *** , one DJ-gene and one C-gene.            ***
--- ************************************************
---

CREATE VIEW v_d_dj_c_cluster AS
  SELECT
    feature_id AS v_d_dj_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_D_DJ_C_cluster';

--- ************************************************
--- *** relation: v_d_dj_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one D-gene ***
--- *** , one DJ-gene.                           ***
--- ************************************************
---

CREATE VIEW v_d_dj_cluster AS
  SELECT
    feature_id AS v_d_dj_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_D_DJ_cluster';

--- ************************************************
--- *** relation: v_d_dj_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one D-gene ***
--- *** , one DJ-gene, one J-gene and one C-gene ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW v_d_dj_j_c_cluster AS
  SELECT
    feature_id AS v_d_dj_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_D_DJ_J_C_cluster';

--- ************************************************
--- *** relation: v_d_dj_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one D-gene ***
--- *** , one DJ-gene and one J-gene.            ***
--- ************************************************
---

CREATE VIEW v_d_dj_j_cluster AS
  SELECT
    feature_id AS v_d_dj_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_D_DJ_J_cluster';

--- ************************************************
--- *** relation: v_d_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding at least one V-gene, one D-gene a ***
--- *** nd one J-gene and one C-gene.            ***
--- ************************************************
---

CREATE VIEW v_d_j_c_cluster AS
  SELECT
    feature_id AS v_d_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_D_J_C_cluster';

--- ************************************************
--- *** relation: v_d_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding at least one V-gene, one D-gene a ***
--- *** nd one J-gene.                           ***
--- ************************************************
---

CREATE VIEW v_d_j_cluster AS
  SELECT
    feature_id AS v_d_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_D_J_cluster';

--- ************************************************
--- *** relation: v_heptamer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 7 nucleotide recombination site (e.g. CA ***
--- *** CAGTG), part of V-gene recombination fea ***
--- *** ture of an immunoglobulin/T-cell recepto ***
--- *** r gene.                                  ***
--- ************************************************
---

CREATE VIEW v_heptamer AS
  SELECT
    feature_id AS v_heptamer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_heptamer';

--- ************************************************
--- *** relation: v_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding at least one V-gene and one J-gen ***
--- *** e.                                       ***
--- ************************************************
---

CREATE VIEW v_j_cluster AS
  SELECT
    feature_id AS v_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_J_cluster';

--- ************************************************
--- *** relation: v_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding at least one V-gene, one J-gene a ***
--- *** nd one C-gene.                           ***
--- ************************************************
---

CREATE VIEW v_j_c_cluster AS
  SELECT
    feature_id AS v_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_J_C_cluster';

--- ************************************************
--- *** relation: v_nonamer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 9 nucleotide recombination site (e.g. AC ***
--- *** AAAAACC), part of V-gene recombination f ***
--- *** eature of an immunoglobulin/T-cell recep ***
--- *** tor gene.                                ***
--- ************************************************
---

CREATE VIEW v_nonamer AS
  SELECT
    feature_id AS v_nonamer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_nonamer';

--- ************************************************
--- *** relation: v_spacer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 12 or 23 nucleotide spacer between the V ***
--- *** -heptamer and the V-nonamer of a V-gene  ***
--- *** recombination feature of an immunoglobul ***
--- *** in/T-cell receptor gene.                 ***
--- ************************************************
---

CREATE VIEW v_spacer AS
  SELECT
    feature_id AS v_spacer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_spacer';

--- ************************************************
--- *** relation: v_gene_recombination_feature ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Recombination signal including V-heptame ***
--- *** r, V-spacer and V-nonamer in 3' of V-reg ***
--- *** ion of a V-gene or V-sequence of an immu ***
--- *** noglobulin/T-cell receptor gene.         ***
--- ************************************************
---

CREATE VIEW v_gene_recombination_feature AS
  SELECT
    feature_id AS v_gene_recombination_feature_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_gene_recombination_feature';

--- ************************************************
--- *** relation: dj_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one DJ-gene and one C- ***
--- *** gene.                                    ***
--- ************************************************
---

CREATE VIEW dj_c_cluster AS
  SELECT
    feature_id AS dj_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DJ_C_cluster';

--- ************************************************
--- *** relation: dj_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA in rearranged configuration  ***
--- *** including at least one D-J-GENE, one J-G ***
--- *** ENE and one C-GENE.                      ***
--- ************************************************
---

CREATE VIEW dj_j_c_cluster AS
  SELECT
    feature_id AS dj_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DJ_J_C_cluster';

--- ************************************************
--- *** relation: vdj_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one VDJ-gene and one C ***
--- *** -gene.                                   ***
--- ************************************************
---

CREATE VIEW vdj_c_cluster AS
  SELECT
    feature_id AS vdj_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'VDJ_C_cluster';

--- ************************************************
--- *** relation: v_dj_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one DJ-gen ***
--- *** e and one C-gene.                        ***
--- ************************************************
---

CREATE VIEW v_dj_c_cluster AS
  SELECT
    feature_id AS v_dj_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_DJ_C_cluster';

--- ************************************************
--- *** relation: helitron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A rolling circle transposon. Autonomous  ***
--- *** helitrons encode a 5'-to-3' DNA helicase ***
--- ***  and nuclease/ligase similar to those en ***
--- *** coded by known rolling-circle replicons. ***
--- ************************************************
---

CREATE VIEW helitron AS
  SELECT
    feature_id AS helitron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'helitron';

--- ************************************************
--- *** relation: recoding_pseudoknot ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The pseudoknots involved in recoding are ***
--- ***  unique in that, as they play their role ***
--- ***  as a structure, they are immediately un ***
--- *** folded and their now linear sequence ser ***
--- *** ves as a template for decoding.          ***
--- ************************************************
---

CREATE VIEW recoding_pseudoknot AS
  SELECT
    feature_id AS recoding_pseudoknot_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'recoding_pseudoknot';

--- ************************************************
--- *** relation: designed_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW designed_sequence AS
  SELECT
    feature_id AS designed_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'designed_sequence';

--- ************************************************
--- *** relation: inversion_derived_bipartite_duplication ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome generated by recombination  ***
--- *** between two inversions; there is a dupli ***
--- *** cation at each end of the inversion.     ***
--- ************************************************
---

CREATE VIEW inversion_derived_bipartite_duplication AS
  SELECT
    feature_id AS inversion_derived_bipartite_duplication_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inversion_derived_bipartite_duplication';

--- ************************************************
--- *** relation: gene_with_edited_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that encodes a transcript that is ***
--- ***  edited.                                 ***
--- ************************************************
---

CREATE VIEW gene_with_edited_transcript AS
  SELECT
    feature_id AS gene_with_edited_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_with_edited_transcript';

--- ************************************************
--- *** relation: inversion_derived_duplication_plus_aneuploid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome generated by recombination  ***
--- *** between two inversions; has a duplicatio ***
--- *** n at one end and presumed to have a defi ***
--- *** ciency or duplication at the other end o ***
--- *** f the inversion.                         ***
--- ************************************************
---

CREATE VIEW inversion_derived_duplication_plus_aneuploid AS
  SELECT
    feature_id AS inversion_derived_duplication_plus_aneuploid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inversion_derived_duplication_plus_aneuploid';

--- ************************************************
--- *** relation: aneuploid_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome structural variation whereb ***
--- *** y either a chromosome exists in addition ***
--- ***  to the normal chromosome complement or  ***
--- *** is lacking.                              ***
--- ************************************************
---

CREATE VIEW aneuploid_chromosome AS
  SELECT
    feature_id AS aneuploid_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inversion_derived_aneuploid_chromosome' OR cvterm.name = 'aneuploid_chromosome';

--- ************************************************
--- *** relation: polya_signal_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The recognition sequence necessary for e ***
--- *** ndonuclease cleavage of an RNA transcrip ***
--- *** t that is followed by polyadenylation; c ***
--- *** onsensus=AATAAA.                         ***
--- ************************************************
---

CREATE VIEW polya_signal_sequence AS
  SELECT
    feature_id AS polya_signal_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polyA_signal_sequence';

--- ************************************************
--- *** relation: shine_dalgarno_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region in the 5' UTR that pairs with t ***
--- *** he 16S rRNA during formation of the prei ***
--- *** nitiation complex.                       ***
--- ************************************************
---

CREATE VIEW shine_dalgarno_sequence AS
  SELECT
    feature_id AS shine_dalgarno_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'Shine_Dalgarno_sequence';

--- ************************************************
--- *** relation: polya_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The site on an RNA transcript to which w ***
--- *** ill be added adenine residues by post-tr ***
--- *** anscriptional polyadenylation. The bound ***
--- *** ary between the UTR and the polyA sequen ***
--- *** ce.                                      ***
--- ************************************************
---

CREATE VIEW polya_site AS
  SELECT
    feature_id AS polya_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polyA_site';

--- ************************************************
--- *** relation: five_prime_clip ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 5' most region of a precursor transcript ***
--- ***  that is clipped off during processing.  ***
--- ************************************************
---

CREATE VIEW five_prime_clip AS
  SELECT
    feature_id AS five_prime_clip_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_clip';

--- ************************************************
--- *** relation: five_prime_d_recombination_signal_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Recombination signal of an immunoglobuli ***
--- *** n/T-cell receptor gene, including the 5' ***
--- ***  D-nonamer (SO:0000497), 5' D-spacer (SO ***
--- *** :0000498), and 5' D-heptamer (SO:0000396 ***
--- *** ) in 5' of the D-region of a D-gene, or  ***
--- *** in 5' of the D-region of DJ-gene.        ***
--- ************************************************
---

CREATE VIEW five_prime_d_recombination_signal_sequence AS
  SELECT
    feature_id AS five_prime_d_recombination_signal_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_D_recombination_signal_sequence';

--- ************************************************
--- *** relation: three_prime_clip ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 3'-most region of a precursor transcript ***
--- ***  that is clipped off during processing.  ***
--- ************************************************
---

CREATE VIEW three_prime_clip AS
  SELECT
    feature_id AS three_prime_clip_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_clip';

--- ************************************************
--- *** relation: c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene including more than one C-gen ***
--- *** e.                                       ***
--- ************************************************
---

CREATE VIEW c_cluster AS
  SELECT
    feature_id AS c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'C_cluster';

--- ************************************************
--- *** relation: d_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding more than one D-gene.             ***
--- ************************************************
---

CREATE VIEW d_cluster AS
  SELECT
    feature_id AS d_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'D_cluster';

--- ************************************************
--- *** relation: d_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding at least one D-gene and one J-gen ***
--- *** e.                                       ***
--- ************************************************
---

CREATE VIEW d_j_cluster AS
  SELECT
    feature_id AS d_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'D_J_cluster';

--- ************************************************
--- *** relation: heptamer_of_recombination_feature_of_vertebrate_im_sys_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Seven nucleotide recombination site (e.g ***
--- *** . CACAGTG), part of V-gene, D-gene or J- ***
--- *** gene recombination feature of an immunog ***
--- *** lobulin or T-cell receptor gene.         ***
--- ************************************************
---

CREATE VIEW heptamer_of_recombination_feature_of_vertebrate_im_sys_gene AS
  SELECT
    feature_id AS heptamer_of_recombination_feature_of_vertebrate_im_sys_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_D_heptamer' OR cvterm.name = 'five_prime_D_heptamer' OR cvterm.name = 'J_heptamer' OR cvterm.name = 'V_heptamer' OR cvterm.name = 'heptamer_of_recombination_feature_of_vertebrate_immune_system_gene';

--- ************************************************
--- *** relation: nonamer_of_recombination_feature_of_vertebrate_im_sys_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW nonamer_of_recombination_feature_of_vertebrate_im_sys_gene AS
  SELECT
    feature_id AS nonamer_of_recombination_feature_of_vertebrate_im_sys_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_D_nonamer' OR cvterm.name = 'five_prime_D_nonamer' OR cvterm.name = 'J_nonamer' OR cvterm.name = 'V_nonamer' OR cvterm.name = 'nonamer_of_recombination_feature_of_vertebrate_immune_system_gene';

--- ************************************************
--- *** relation: vertebrate_immune_system_gene_recombination_spacer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW vertebrate_immune_system_gene_recombination_spacer AS
  SELECT
    feature_id AS vertebrate_immune_system_gene_recombination_spacer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_D_spacer' OR cvterm.name = 'five_prime_D_spacer' OR cvterm.name = 'J_spacer' OR cvterm.name = 'V_spacer' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_spacer';

--- ************************************************
--- *** relation: v_dj_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one DJ-gen ***
--- *** e, one J-gene and one C-gene.            ***
--- ************************************************
---

CREATE VIEW v_dj_j_c_cluster AS
  SELECT
    feature_id AS v_dj_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_DJ_J_C_cluster';

--- ************************************************
--- *** relation: v_vdj_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one VDJ-ge ***
--- *** ne, one J-gene and one C-gene.           ***
--- ************************************************
---

CREATE VIEW v_vdj_j_c_cluster AS
  SELECT
    feature_id AS v_vdj_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_VDJ_J_C_cluster';

--- ************************************************
--- *** relation: v_vj_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one VJ-gen ***
--- *** e, one J-gene and one C-gene.            ***
--- ************************************************
---

CREATE VIEW v_vj_j_c_cluster AS
  SELECT
    feature_id AS v_vj_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_VJ_J_C_cluster';

--- ************************************************
--- *** relation: inversion_derived_aneuploid_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome may be generated by recombi ***
--- *** nation between two inversions; presumed  ***
--- *** to have a deficiency or duplication at e ***
--- *** ach end of the inversion.                ***
--- ************************************************
---

CREATE VIEW inversion_derived_aneuploid_chromosome AS
  SELECT
    feature_id AS inversion_derived_aneuploid_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inversion_derived_aneuploid_chromosome';

--- ************************************************
--- *** relation: bidirectional_promoter ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW bidirectional_promoter AS
  SELECT
    feature_id AS bidirectional_promoter_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'bidirectional_promoter';

--- ************************************************
--- *** relation: retrotransposed ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute of a feature that occurred  ***
--- *** as the product of a reverse transcriptas ***
--- *** e mediated event.                        ***
--- ************************************************
---

CREATE VIEW retrotransposed AS
  SELECT
    feature_id AS retrotransposed_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'retrotransposed';

--- ************************************************
--- *** relation: three_prime_d_recombination_signal_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Recombination signal of an immunoglobuli ***
--- *** n/T-cell receptor gene, including the 3' ***
--- ***  D-heptamer (SO:0000493), 3' D-spacer, a ***
--- *** nd 3' D-nonamer (SO:0000494) in 3' of th ***
--- *** e D-region of a D-gene.                  ***
--- ************************************************
---

CREATE VIEW three_prime_d_recombination_signal_sequence AS
  SELECT
    feature_id AS three_prime_d_recombination_signal_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_D_recombination_signal_sequence';

--- ************************************************
--- *** relation: mirna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW mirna_encoding AS
  SELECT
    feature_id AS mirna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'miRNA_encoding';

--- ************************************************
--- *** relation: dj_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in partially rearranged genom ***
--- *** ic DNA including D-J-region with 5' UTR  ***
--- *** and 3' UTR, also designated as D-J-segme ***
--- *** nt.                                      ***
--- ************************************************
---

CREATE VIEW dj_gene AS
  SELECT
    feature_id AS dj_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DJ_gene';

--- ************************************************
--- *** relation: rrna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW rrna_encoding AS
  SELECT
    feature_id AS rrna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_encoding';

--- ************************************************
--- *** relation: vdj_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Rearranged genomic DNA of immunoglobulin ***
--- *** /T-cell receptor gene including L-part1, ***
--- ***  V-intron and V-D-J-exon, with the 5'UTR ***
--- ***  (SO:0000204) and 3'UTR (SO:0000205).    ***
--- ************************************************
---

CREATE VIEW vdj_gene AS
  SELECT
    feature_id AS vdj_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'VDJ_gene';

--- ************************************************
--- *** relation: scrna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW scrna_encoding AS
  SELECT
    feature_id AS scrna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'scRNA_encoding';

--- ************************************************
--- *** relation: vj_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Rearranged genomic DNA of immunoglobulin ***
--- *** /T-cell receptor gene including L-part1, ***
--- ***  V-intron and V-J-exon, with the 5'UTR ( ***
--- *** SO:0000204) and 3'UTR (SO:0000205).      ***
--- ************************************************
---

CREATE VIEW vj_gene AS
  SELECT
    feature_id AS vj_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'VJ_gene';

--- ************************************************
--- *** relation: centromere ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of chromosome where the spindle ***
--- ***  fibers attach during mitosis and meiosi ***
--- *** s.                                       ***
--- ************************************************
---

CREATE VIEW centromere AS
  SELECT
    feature_id AS centromere_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'point_centromere' OR cvterm.name = 'regional_centromere' OR cvterm.name = 'centromere';

--- ************************************************
--- *** relation: snorna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW snorna_encoding AS
  SELECT
    feature_id AS snorna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'C_D_box_snoRNA_encoding' OR cvterm.name = 'H_ACA_box_snoRNA_encoding' OR cvterm.name = 'snoRNA_encoding';

--- ************************************************
--- *** relation: edited_transcript_feature ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A locatable feature on a transcript that ***
--- ***  is edited.                              ***
--- ************************************************
---

CREATE VIEW edited_transcript_feature AS
  SELECT
    feature_id AS edited_transcript_feature_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pre_edited_region' OR cvterm.name = 'editing_block' OR cvterm.name = 'editing_domain' OR cvterm.name = 'unedited_region' OR cvterm.name = 'edited_transcript_feature';

--- ************************************************
--- *** relation: methylation_guide_snorna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a methylat ***
--- *** ion guide small nucleolar RNA.           ***
--- ************************************************
---

CREATE VIEW methylation_guide_snorna_primary_transcript AS
  SELECT
    feature_id AS methylation_guide_snorna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'methylation_guide_snoRNA_primary_transcript';

--- ************************************************
--- *** relation: cap ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A structure consisting of a 7-methylguan ***
--- *** osine in 5'-5' triphosphate linkage with ***
--- ***  the first nucleotide of an mRNA. It is  ***
--- *** added post-transcriptionally, and is not ***
--- ***  encoded in the DNA.                     ***
--- ************************************************
---

CREATE VIEW cap AS
  SELECT
    feature_id AS cap_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cap';

--- ************************************************
--- *** relation: rrna_cleavage_snorna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding an rRNA cl ***
--- *** eavage snoRNA.                           ***
--- ************************************************
---

CREATE VIEW rrna_cleavage_snorna_primary_transcript AS
  SELECT
    feature_id AS rrna_cleavage_snorna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_cleavage_snoRNA_primary_transcript';

--- ************************************************
--- *** relation: pre_edited_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The region of a transcript that will be  ***
--- *** edited.                                  ***
--- ************************************************
---

CREATE VIEW pre_edited_region AS
  SELECT
    feature_id AS pre_edited_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pre_edited_region';

--- ************************************************
--- *** relation: tmrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tmRNA liberates a mRNA from a stalled  ***
--- *** ribosome. To accomplish this part of the ***
--- ***  tmRNA is used as a reading frame that e ***
--- *** nds in a translation stop signal. The br ***
--- *** oken mRNA is replaced in the ribosome by ***
--- ***  the tmRNA and translation of the tmRNA  ***
--- *** leads to addition of a proteolysis tag t ***
--- *** o the incomplete protein enabling recogn ***
--- *** ition by a protease. Recently a number o ***
--- *** f permuted tmRNAs genes have been found  ***
--- *** encoded in two parts. TmRNAs have been i ***
--- *** dentified in eubacteria and some chlorop ***
--- *** lasts but are absent from archeal and Eu ***
--- *** karyote nuclear genomes.                 ***
--- ************************************************
---

CREATE VIEW tmrna AS
  SELECT
    feature_id AS tmrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tmRNA';

--- ************************************************
--- *** relation: c_d_box_snorna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW c_d_box_snorna_encoding AS
  SELECT
    feature_id AS c_d_box_snorna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'C_D_box_snoRNA_encoding';

--- ************************************************
--- *** relation: tmrna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a tmRNA (S ***
--- *** O:0000584).                              ***
--- ************************************************
---

CREATE VIEW tmrna_primary_transcript AS
  SELECT
    feature_id AS tmrna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tmRNA_primary_transcript';

--- ************************************************
--- *** relation: group_i_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Group I catalytic introns are large self ***
--- *** -splicing ribozymes. They catalyze their ***
--- ***  own excision from mRNA, tRNA and rRNA p ***
--- *** recursors in a wide range of organisms.  ***
--- *** The core secondary structure consists of ***
--- ***  9 paired regions (P1-P9). These fold to ***
--- ***  essentially two domains, the P4-P6 doma ***
--- *** in (formed from the stacking of P5, P4,  ***
--- *** P6 and P6a helices) and the P3-P9 domain ***
--- ***  (formed from the P8, P3, P7 and P9 heli ***
--- *** ces). Group I catalytic introns often ha ***
--- *** ve long ORFs inserted in loop regions.   ***
--- ************************************************
---

CREATE VIEW group_i_intron AS
  SELECT
    feature_id AS group_i_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'group_I_intron';

--- ************************************************
--- *** relation: autocatalytically_spliced_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A self spliced intron.                   ***
--- ************************************************
---

CREATE VIEW autocatalytically_spliced_intron AS
  SELECT
    feature_id AS autocatalytically_spliced_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'group_I_intron' OR cvterm.name = 'group_II_intron' OR cvterm.name = 'group_III_intron' OR cvterm.name = 'group_IIA_intron' OR cvterm.name = 'group_IIB_intron' OR cvterm.name = 'autocatalytically_spliced_intron';

--- ************************************************
--- *** relation: srp_rna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a signal r ***
--- *** ecognition particle RNA.                 ***
--- ************************************************
---

CREATE VIEW srp_rna_primary_transcript AS
  SELECT
    feature_id AS srp_rna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'SRP_RNA_primary_transcript';

--- ************************************************
--- *** relation: srp_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The signal recognition particle (SRP) is ***
--- ***  a universally conserved ribonucleoprote ***
--- *** in. It is involved in the co-translation ***
--- *** al targeting of proteins to membranes. T ***
--- *** he eukaryotic SRP consists of a 300-nucl ***
--- *** eotide 7S RNA and six proteins: SRPs 72, ***
--- ***  68, 54, 19, 14, and 9. Archaeal SRP con ***
--- *** sists of a 7S RNA and homologues of the  ***
--- *** eukaryotic SRP19 and SRP54 proteins. In  ***
--- *** most eubacteria, the SRP consists of a 4 ***
--- *** .5S RNA and the Ffh protein (a homologue ***
--- ***  of the eukaryotic SRP54 protein). Eukar ***
--- *** yotic and archaeal 7S RNAs have very sim ***
--- *** ilar secondary structures, with eight he ***
--- *** lical elements. These fold into the Alu  ***
--- *** and S domains, separated by a long linke ***
--- *** r region. Eubacterial SRP is generally a ***
--- ***  simpler structure, with the M domain of ***
--- ***  Ffh bound to a region of the 4.5S RNA t ***
--- *** hat corresponds to helix 8 of the eukary ***
--- *** otic and archaeal SRP S domain. Some Gra ***
--- *** m-positive bacteria (e.g. Bacillus subti ***
--- *** lis), however, have a larger SRP RNA tha ***
--- *** t also has an Alu domain. The Alu domain ***
--- ***  is thought to mediate the peptide chain ***
--- ***  elongation retardation function of the  ***
--- *** SRP. The universally conserved helix whi ***
--- *** ch interacts with the SRP54/Ffh M domain ***
--- ***  mediates signal sequence recognition. I ***
--- *** n eukaryotes and archaea, the SRP19-heli ***
--- *** x 6 complex is thought to be involved in ***
--- ***  SRP assembly and stabilizes helix 8 for ***
--- ***  SRP54 binding.                          ***
--- ************************************************
---

CREATE VIEW srp_rna AS
  SELECT
    feature_id AS srp_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'SRP_RNA';

--- ************************************************
--- *** relation: pseudoknot ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tertiary structure in RNA where nucleo ***
--- *** tides in a loop form base pairs with a r ***
--- *** egion of RNA downstream of the loop.     ***
--- ************************************************
---

CREATE VIEW pseudoknot AS
  SELECT
    feature_id AS pseudoknot_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'recoding_pseudoknot' OR cvterm.name = 'H_pseudoknot' OR cvterm.name = 'pseudoknot';

--- ************************************************
--- *** relation: h_pseudoknot ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A pseudoknot which contains two stems an ***
--- *** d at least two loops.                    ***
--- ************************************************
---

CREATE VIEW h_pseudoknot AS
  SELECT
    feature_id AS h_pseudoknot_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'H_pseudoknot';

--- ************************************************
--- *** relation: c_d_box_snorna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Most box C/D snoRNAs also contain long ( ***
--- *** >10 nt) sequences complementary to rRNA. ***
--- ***  Boxes C and D, as well as boxes C' and  ***
--- *** D', are usually located in close proximi ***
--- *** ty, and form a structure known as the bo ***
--- *** x C/D motif. This motif is important for ***
--- ***  snoRNA stability, processing, nucleolar ***
--- ***  targeting and function. A small number  ***
--- *** of box C/D snoRNAs are involved in rRNA  ***
--- *** processing; most, however, are known or  ***
--- *** predicted to serve as guide RNAs in ribo ***
--- *** se methylation of rRNA. Targeting involv ***
--- *** es direct base pairing of the snoRNA at  ***
--- *** the rRNA site to be modified and selecti ***
--- *** on of a rRNA nucleotide a fixed distance ***
--- ***  from box D or D'.                       ***
--- ************************************************
---

CREATE VIEW c_d_box_snorna AS
  SELECT
    feature_id AS c_d_box_snorna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U14_snoRNA' OR cvterm.name = 'U3_snoRNA' OR cvterm.name = 'methylation_guide_snoRNA' OR cvterm.name = 'C_D_box_snoRNA';

--- ************************************************
--- *** relation: h_aca_box_snorna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Members of the box H/ACA family contain  ***
--- *** an ACA triplet, exactly 3 nt upstream fr ***
--- *** om the 3' end and an H-box in a hinge re ***
--- *** gion that links two structurally similar ***
--- ***  functional domains of the molecule. Bot ***
--- *** h boxes are important for snoRNA biosynt ***
--- *** hesis and function. A few box H/ACA snoR ***
--- *** NAs are involved in rRNA processing; mos ***
--- *** t others are known or predicted to parti ***
--- *** cipate in selection of uridine nucleosid ***
--- *** es in rRNA to be converted to pseudourid ***
--- *** ines. Site selection is mediated by dire ***
--- *** ct base pairing of the snoRNA with rRNA  ***
--- *** through one or both targeting domains.   ***
--- ************************************************
---

CREATE VIEW h_aca_box_snorna AS
  SELECT
    feature_id AS h_aca_box_snorna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pseudouridylation_guide_snoRNA' OR cvterm.name = 'H_ACA_box_snoRNA';

--- ************************************************
--- *** relation: c_d_box_snorna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a small nu ***
--- *** cleolar RNA of the box C/D family.       ***
--- ************************************************
---

CREATE VIEW c_d_box_snorna_primary_transcript AS
  SELECT
    feature_id AS c_d_box_snorna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'C_D_box_snoRNA_primary_transcript';

--- ************************************************
--- *** relation: h_aca_box_snorna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a small nu ***
--- *** cleolar RNA of the box H/ACA family.     ***
--- ************************************************
---

CREATE VIEW h_aca_box_snorna_primary_transcript AS
  SELECT
    feature_id AS h_aca_box_snorna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'H_ACA_box_snoRNA_primary_transcript';

--- ************************************************
--- *** relation: guide_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A short 3'-uridylated RNA that can form  ***
--- *** a duplex (except for its post-transcript ***
--- *** ionally added oligo_U tail (SO:0000609)) ***
--- ***  with a stretch of mature edited mRNA.   ***
--- ************************************************
---

CREATE VIEW guide_rna AS
  SELECT
    feature_id AS guide_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'guide_RNA';

--- ************************************************
--- *** relation: group_ii_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Group II introns are found in rRNA, tRNA ***
--- ***  and mRNA of organelles in fungi, plants ***
--- ***  and protists, and also in mRNA in bacte ***
--- *** ria. They are large self-splicing ribozy ***
--- *** mes and have 6 structural domains (usual ***
--- *** ly designated dI to dVI). A subset of gr ***
--- *** oup II introns also encode essential spl ***
--- *** icing proteins in intronic ORFs. The len ***
--- *** gth of these introns can therefore be up ***
--- ***  to 3kb. Splicing occurs in almost ident ***
--- *** ical fashion to nuclear pre-mRNA splicin ***
--- *** g with two transesterification steps. Th ***
--- *** e 2' hydroxyl of a bulged adenosine in d ***
--- *** omain VI attacks the 5' splice site, fol ***
--- *** lowed by nucleophilic attack on the 3' s ***
--- *** plice site by the 3' OH of the upstream  ***
--- *** exon. Protein machinery is required for  ***
--- *** splicing in vivo, and long range intron- ***
--- *** intron and intron-exon interactions are  ***
--- *** important for splice site positioning. G ***
--- *** roup II introns are further sub-classifi ***
--- *** ed into groups IIA and IIB which differ  ***
--- *** in splice site consensus, distance of bu ***
--- *** lged A from 3' splice site, some tertiar ***
--- *** y interactions, and intronic ORF phyloge ***
--- *** ny.                                      ***
--- ************************************************
---

CREATE VIEW group_ii_intron AS
  SELECT
    feature_id AS group_ii_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'group_IIA_intron' OR cvterm.name = 'group_IIB_intron' OR cvterm.name = 'group_II_intron';

--- ************************************************
--- *** relation: editing_block ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Edited mRNA sequence mediated by a singl ***
--- *** e guide RNA (SO:0000602).                ***
--- ************************************************
---

CREATE VIEW editing_block AS
  SELECT
    feature_id AS editing_block_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'editing_block';

--- ************************************************
--- *** relation: intergenic_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region containing or overlapping no ge ***
--- *** nes that is bounded on either side by a  ***
--- *** gene, or bounded by a gene and the end o ***
--- *** f the chromosome.                        ***
--- ************************************************
---

CREATE VIEW intergenic_region AS
  SELECT
    feature_id AS intergenic_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'intergenic_region';

--- ************************************************
--- *** relation: editing_domain ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Edited mRNA sequence mediated by two or  ***
--- *** more overlapping guide RNAs (SO:0000602) ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW editing_domain AS
  SELECT
    feature_id AS editing_domain_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'editing_domain';

--- ************************************************
--- *** relation: unedited_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The region of an edited transcript that  ***
--- *** will not be edited.                      ***
--- ************************************************
---

CREATE VIEW unedited_region AS
  SELECT
    feature_id AS unedited_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'unedited_region';

--- ************************************************
--- *** relation: h_aca_box_snorna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW h_aca_box_snorna_encoding AS
  SELECT
    feature_id AS h_aca_box_snorna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'H_ACA_box_snoRNA_encoding';

--- ************************************************
--- *** relation: oligo_u_tail ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The string of non-encoded U's at the 3'  ***
--- *** end of a guide RNA (SO:0000602).         ***
--- ************************************************
---

CREATE VIEW oligo_u_tail AS
  SELECT
    feature_id AS oligo_u_tail_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'oligo_U_tail';

--- ************************************************
--- *** relation: polya_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Sequence of about 100 nucleotides of A a ***
--- *** dded to the 3' end of most eukaryotic mR ***
--- *** NAs.                                     ***
--- ************************************************
---

CREATE VIEW polya_sequence AS
  SELECT
    feature_id AS polya_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polyA_sequence';

--- ************************************************
--- *** relation: branch_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A pyrimidine rich sequence near the 3' e ***
--- *** nd of an intron to which the 5'end becom ***
--- *** es covalently bound during nuclear splic ***
--- *** ing. The resulting structure resembles a ***
--- ***  lariat.                                 ***
--- ************************************************
---

CREATE VIEW branch_site AS
  SELECT
    feature_id AS branch_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'branch_site';

--- ************************************************
--- *** relation: polypyrimidine_tract ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The polypyrimidine tract is one of the c ***
--- *** is-acting sequence elements directing in ***
--- *** tron removal in pre-mRNA splicing.       ***
--- ************************************************
---

CREATE VIEW polypyrimidine_tract AS
  SELECT
    feature_id AS polypyrimidine_tract_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypyrimidine_tract';

--- ************************************************
--- *** relation: bacterial_rnapol_promoter ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A DNA sequence to which bacterial RNA po ***
--- *** lymerase binds, to begin transcription.  ***
--- ************************************************
---

CREATE VIEW bacterial_rnapol_promoter AS
  SELECT
    feature_id AS bacterial_rnapol_promoter_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'bacterial_RNApol_promoter_sigma_70' OR cvterm.name = 'bacterial_RNApol_promoter_sigma54' OR cvterm.name = 'bacterial_RNApol_promoter';

--- ************************************************
--- *** relation: bacterial_terminator ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A terminator signal for bacterial transc ***
--- *** ription.                                 ***
--- ************************************************
---

CREATE VIEW bacterial_terminator AS
  SELECT
    feature_id AS bacterial_terminator_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rho_dependent_bacterial_terminator' OR cvterm.name = 'rho_independent_bacterial_terminator' OR cvterm.name = 'bacterial_terminator';

--- ************************************************
--- *** relation: terminator_of_type_2_rnapol_iii_promoter ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A terminator signal for RNA polymerase I ***
--- *** II transcription.                        ***
--- ************************************************
---

CREATE VIEW terminator_of_type_2_rnapol_iii_promoter AS
  SELECT
    feature_id AS terminator_of_type_2_rnapol_iii_promoter_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'terminator_of_type_2_RNApol_III_promoter';

--- ************************************************
--- *** relation: transcription_end_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The base where transcription ends.       ***
--- ************************************************
---

CREATE VIEW transcription_end_site AS
  SELECT
    feature_id AS transcription_end_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transcription_end_site';

--- ************************************************
--- *** relation: rnapol_iii_promoter_type_1 ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW rnapol_iii_promoter_type_1 AS
  SELECT
    feature_id AS rnapol_iii_promoter_type_1_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNApol_III_promoter_type_1';

--- ************************************************
--- *** relation: rnapol_iii_promoter_type_2 ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW rnapol_iii_promoter_type_2 AS
  SELECT
    feature_id AS rnapol_iii_promoter_type_2_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNApol_III_promoter_type_2';

--- ************************************************
--- *** relation: a_box ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A variably distant linear promoter regio ***
--- *** n recognized by TFIIIC, with consensus s ***
--- *** equence TGGCnnAGTGG.                     ***
--- ************************************************
---

CREATE VIEW a_box AS
  SELECT
    feature_id AS a_box_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'A_box_type_1' OR cvterm.name = 'A_box_type_2' OR cvterm.name = 'A_box';

--- ************************************************
--- *** relation: b_box ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A variably distant linear promoter regio ***
--- *** n recognized by TFIIIC, with consensus s ***
--- *** equence AGGTTCCAnnCC.                    ***
--- ************************************************
---

CREATE VIEW b_box AS
  SELECT
    feature_id AS b_box_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'B_box';

--- ************************************************
--- *** relation: rnapol_iii_promoter_type_3 ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW rnapol_iii_promoter_type_3 AS
  SELECT
    feature_id AS rnapol_iii_promoter_type_3_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNApol_III_promoter_type_3';

--- ************************************************
--- *** relation: c_box ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An RNA polymerase III type 1 promoter wi ***
--- *** th consensus sequence CAnnCCn.           ***
--- ************************************************
---

CREATE VIEW c_box AS
  SELECT
    feature_id AS c_box_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'C_box';

--- ************************************************
--- *** relation: snrna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW snrna_encoding AS
  SELECT
    feature_id AS snrna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'snRNA_encoding';

--- ************************************************
--- *** relation: telomere ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A specific structure at the end of a lin ***
--- *** ear chromosome, required for the integri ***
--- *** ty and maintenance of the end.           ***
--- ************************************************
---

CREATE VIEW telomere AS
  SELECT
    feature_id AS telomere_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'telomere';

--- ************************************************
--- *** relation: silencer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A regulatory region which upon binding o ***
--- *** f transcription factors, suppress the tr ***
--- *** anscription of the gene or genes they co ***
--- *** ntrol.                                   ***
--- ************************************************
---

CREATE VIEW silencer AS
  SELECT
    feature_id AS silencer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'silencer';

--- ************************************************
--- *** relation: chromosomal_regulatory_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW chromosomal_regulatory_element AS
  SELECT
    feature_id AS chromosomal_regulatory_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'matrix_attachment_site' OR cvterm.name = 'chromosomal_regulatory_element';

--- ************************************************
--- *** relation: insulator ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transcriptional cis regulatory region  ***
--- *** that when located between a CM and a gen ***
--- *** e's promoter prevents the CRM from modul ***
--- *** ating that genes expression.             ***
--- ************************************************
---

CREATE VIEW insulator AS
  SELECT
    feature_id AS insulator_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'insulator';

--- ************************************************
--- *** relation: chromosomal_structural_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW chromosomal_structural_element AS
  SELECT
    feature_id AS chromosomal_structural_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'centromere' OR cvterm.name = 'telomere' OR cvterm.name = 'point_centromere' OR cvterm.name = 'regional_centromere' OR cvterm.name = 'chromosomal_structural_element';

--- ************************************************
--- *** relation: five_prime_open_reading_frame ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW five_prime_open_reading_frame AS
  SELECT
    feature_id AS five_prime_open_reading_frame_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_open_reading_frame';

--- ************************************************
--- *** relation: upstream_aug_codon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A start codon upstream of the ORF.       ***
--- ************************************************
---

CREATE VIEW upstream_aug_codon AS
  SELECT
    feature_id AS upstream_aug_codon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'upstream_AUG_codon';

--- ************************************************
--- *** relation: polycistronic_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding for more t ***
--- *** han one gene product.                    ***
--- ************************************************
---

CREATE VIEW polycistronic_primary_transcript AS
  SELECT
    feature_id AS polycistronic_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'polycistronic_primary_transcript';

--- ************************************************
--- *** relation: monocistronic_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding for one ge ***
--- *** ne product.                              ***
--- ************************************************
---

CREATE VIEW monocistronic_primary_transcript AS
  SELECT
    feature_id AS monocistronic_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'monocistronic_primary_transcript';

--- ************************************************
--- *** relation: monocistronic_mrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An mRNA with either a single protein pro ***
--- *** duct, or for which the regions encoding  ***
--- *** all its protein products overlap.        ***
--- ************************************************
---

CREATE VIEW monocistronic_mrna AS
  SELECT
    feature_id AS monocistronic_mrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'monocistronic_mRNA';

--- ************************************************
--- *** relation: polycistronic_mrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An mRNA that encodes multiple proteins f ***
--- *** rom at least two non-overlapping regions ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW polycistronic_mrna AS
  SELECT
    feature_id AS polycistronic_mrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'polycistronic_mRNA';

--- ************************************************
--- *** relation: mini_exon_donor_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript that donates the sp ***
--- *** liced leader to other mRNA.              ***
--- ************************************************
---

CREATE VIEW mini_exon_donor_rna AS
  SELECT
    feature_id AS mini_exon_donor_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mini_exon_donor_RNA';

--- ************************************************
--- *** relation: spliced_leader_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW spliced_leader_rna AS
  SELECT
    feature_id AS spliced_leader_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'spliced_leader_RNA';

--- ************************************************
--- *** relation: engineered_plasmid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A plasmid that is engineered.            ***
--- ************************************************
---

CREATE VIEW engineered_plasmid AS
  SELECT
    feature_id AS engineered_plasmid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_episome' OR cvterm.name = 'gene_trap_construct' OR cvterm.name = 'promoter_trap_construct' OR cvterm.name = 'enhancer_trap_construct' OR cvterm.name = 'engineered_plasmid';

--- ************************************************
--- *** relation: transcribed_spacer_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Part of an rRNA transcription unit that  ***
--- *** is transcribed but discarded during matu ***
--- *** ration, not giving rise to any part of r ***
--- *** RNA.                                     ***
--- ************************************************
---

CREATE VIEW transcribed_spacer_region AS
  SELECT
    feature_id AS transcribed_spacer_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'internal_transcribed_spacer_region' OR cvterm.name = 'external_transcribed_spacer_region' OR cvterm.name = 'transcribed_spacer_region';

--- ************************************************
--- *** relation: internal_transcribed_spacer_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Non-coding regions of DNA sequence that  ***
--- *** separate genes coding for the 28S, 5.8S, ***
--- ***  and 18S ribosomal RNAs.                 ***
--- ************************************************
---

CREATE VIEW internal_transcribed_spacer_region AS
  SELECT
    feature_id AS internal_transcribed_spacer_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'internal_transcribed_spacer_region';

--- ************************************************
--- *** relation: external_transcribed_spacer_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Non-coding regions of DNA that precede t ***
--- *** he sequence that codes for the ribosomal ***
--- ***  RNA.                                    ***
--- ************************************************
---

CREATE VIEW external_transcribed_spacer_region AS
  SELECT
    feature_id AS external_transcribed_spacer_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'external_transcribed_spacer_region';

--- ************************************************
--- *** relation: tetranuc_repeat_microsat ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW tetranuc_repeat_microsat AS
  SELECT
    feature_id AS tetranuc_repeat_microsat_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tetranucleotide_repeat_microsatellite_feature';

--- ************************************************
--- *** relation: srp_rna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW srp_rna_encoding AS
  SELECT
    feature_id AS srp_rna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'SRP_RNA_encoding';

--- ************************************************
--- *** relation: minisatellite ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A repeat region containing tandemly repe ***
--- *** ated sequences having a unit length of 1 ***
--- *** 0 to 40 bp.                              ***
--- ************************************************
---

CREATE VIEW minisatellite AS
  SELECT
    feature_id AS minisatellite_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'minisatellite';

--- ************************************************
--- *** relation: antisense_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Antisense RNA is RNA that is transcribed ***
--- ***  from the coding, rather than the templa ***
--- *** te, strand of DNA. It is therefore compl ***
--- *** ementary to mRNA.                        ***
--- ************************************************
---

CREATE VIEW antisense_rna AS
  SELECT
    feature_id AS antisense_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'MicF_RNA' OR cvterm.name = 'antisense_RNA';

--- ************************************************
--- *** relation: antisense_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The reverse complement of the primary tr ***
--- *** anscript.                                ***
--- ************************************************
---

CREATE VIEW antisense_primary_transcript AS
  SELECT
    feature_id AS antisense_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'antisense_primary_transcript';

--- ************************************************
--- *** relation: sirna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A small RNA molecule that is the product ***
--- ***  of a longer exogenous or endogenous dsR ***
--- *** NA, which is either a bimolecular duplex ***
--- ***  or very long hairpin, processed (via th ***
--- *** e Dicer pathway) such that numerous siRN ***
--- *** As accumulate from both strands of the d ***
--- *** sRNA. SRNAs trigger the cleavage of thei ***
--- *** r target molecules.                      ***
--- ************************************************
---

CREATE VIEW sirna AS
  SELECT
    feature_id AS sirna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'siRNA';

--- ************************************************
--- *** relation: mirna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a micro RN ***
--- *** A.                                       ***
--- ************************************************
---

CREATE VIEW mirna_primary_transcript AS
  SELECT
    feature_id AS mirna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'stRNA_primary_transcript' OR cvterm.name = 'miRNA_primary_transcript';

--- ************************************************
--- *** relation: strna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a small te ***
--- *** mporal mRNA (SO:0000649).                ***
--- ************************************************
---

CREATE VIEW strna_primary_transcript AS
  SELECT
    feature_id AS strna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'stRNA_primary_transcript';

--- ************************************************
--- *** relation: strna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Non-coding RNAs of about 21 nucleotides  ***
--- *** in length that regulate temporal develop ***
--- *** ment; first discovered in C. elegans.    ***
--- ************************************************
---

CREATE VIEW strna AS
  SELECT
    feature_id AS strna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'stRNA';

--- ************************************************
--- *** relation: small_subunit_rrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Ribosomal RNA transcript that structures ***
--- ***  the small subunit of the ribosome.      ***
--- ************************************************
---

CREATE VIEW small_subunit_rrna AS
  SELECT
    feature_id AS small_subunit_rrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_18S' OR cvterm.name = 'rRNA_16S' OR cvterm.name = 'small_subunit_rRNA';

--- ************************************************
--- *** relation: large_subunit_rrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Ribosomal RNA transcript that structures ***
--- ***  the large subunit of the ribosome.      ***
--- ************************************************
---

CREATE VIEW large_subunit_rrna AS
  SELECT
    feature_id AS large_subunit_rrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_5_8S' OR cvterm.name = 'rRNA_5S' OR cvterm.name = 'rRNA_28S' OR cvterm.name = 'rRNA_23S' OR cvterm.name = 'rRNA_25S' OR cvterm.name = 'rRNA_21S' OR cvterm.name = 'large_subunit_rRNA';

--- ************************************************
--- *** relation: rrna_5s ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 5S ribosomal RNA (5S rRNA) is a componen ***
--- *** t of the large ribosomal subunit in both ***
--- ***  prokaryotes and eukaryotes. In eukaryot ***
--- *** es, it is synthesised by RNA polymerase  ***
--- *** III (the other eukaryotic rRNAs are clea ***
--- *** ved from a 45S precursor synthesised by  ***
--- *** RNA polymerase I). In Xenopus oocytes, i ***
--- *** t has been shown that fingers 4-7 of the ***
--- ***  nine-zinc finger transcription factor T ***
--- *** FIIIA can bind to the central region of  ***
--- *** 5S RNA. Thus, in addition to positively  ***
--- *** regulating 5S rRNA transcription, TFIIIA ***
--- ***  also stabilizes 5S rRNA until it is req ***
--- *** uired for transcription.                 ***
--- ************************************************
---

CREATE VIEW rrna_5s AS
  SELECT
    feature_id AS rrna_5s_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_5S';

--- ************************************************
--- *** relation: rrna_28s ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A component of the large ribosomal subun ***
--- *** it.                                      ***
--- ************************************************
---

CREATE VIEW rrna_28s AS
  SELECT
    feature_id AS rrna_28s_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_28S';

--- ************************************************
--- *** relation: maxicircle_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A mitochondrial gene located in a maxici ***
--- *** rcle.                                    ***
--- ************************************************
---

CREATE VIEW maxicircle_gene AS
  SELECT
    feature_id AS maxicircle_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cryptogene' OR cvterm.name = 'maxicircle_gene';

--- ************************************************
--- *** relation: ncrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An RNA transcript that does not encode f ***
--- *** or a protein rather the RNA molecule is  ***
--- *** the gene product.                        ***
--- ************************************************
---

CREATE VIEW ncrna AS
  SELECT
    feature_id AS ncrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'scRNA' OR cvterm.name = 'rRNA' OR cvterm.name = 'tRNA' OR cvterm.name = 'snRNA' OR cvterm.name = 'snoRNA' OR cvterm.name = 'small_regulatory_ncRNA' OR cvterm.name = 'RNase_MRP_RNA' OR cvterm.name = 'RNase_P_RNA' OR cvterm.name = 'telomerase_RNA' OR cvterm.name = 'vault_RNA' OR cvterm.name = 'Y_RNA' OR cvterm.name = 'rasiRNA' OR cvterm.name = 'SRP_RNA' OR cvterm.name = 'guide_RNA' OR cvterm.name = 'antisense_RNA' OR cvterm.name = 'siRNA' OR cvterm.name = 'stRNA' OR cvterm.name = 'class_II_RNA' OR cvterm.name = 'class_I_RNA' OR cvterm.name = 'piRNA' OR cvterm.name = 'lincRNA' OR cvterm.name = 'tasiRNA' OR cvterm.name = 'rRNA_cleavage_RNA' OR cvterm.name = 'small_subunit_rRNA' OR cvterm.name = 'large_subunit_rRNA' OR cvterm.name = 'rRNA_18S' OR cvterm.name = 'rRNA_16S' OR cvterm.name = 'rRNA_5_8S' OR cvterm.name = 'rRNA_5S' OR cvterm.name = 'rRNA_28S' OR cvterm.name = 'rRNA_23S' OR cvterm.name = 'rRNA_25S' OR cvterm.name = 'rRNA_21S' OR cvterm.name = 'alanyl_tRNA' OR cvterm.name = 'asparaginyl_tRNA' OR cvterm.name = 'aspartyl_tRNA' OR cvterm.name = 'cysteinyl_tRNA' OR cvterm.name = 'glutaminyl_tRNA' OR cvterm.name = 'glutamyl_tRNA' OR cvterm.name = 'glycyl_tRNA' OR cvterm.name = 'histidyl_tRNA' OR cvterm.name = 'isoleucyl_tRNA' OR cvterm.name = 'leucyl_tRNA' OR cvterm.name = 'lysyl_tRNA' OR cvterm.name = 'methionyl_tRNA' OR cvterm.name = 'phenylalanyl_tRNA' OR cvterm.name = 'prolyl_tRNA' OR cvterm.name = 'seryl_tRNA' OR cvterm.name = 'threonyl_tRNA' OR cvterm.name = 'tryptophanyl_tRNA' OR cvterm.name = 'tyrosyl_tRNA' OR cvterm.name = 'valyl_tRNA' OR cvterm.name = 'pyrrolysyl_tRNA' OR cvterm.name = 'arginyl_tRNA' OR cvterm.name = 'selenocysteinyl_tRNA' OR cvterm.name = 'U1_snRNA' OR cvterm.name = 'U2_snRNA' OR cvterm.name = 'U4_snRNA' OR cvterm.name = 'U4atac_snRNA' OR cvterm.name = 'U5_snRNA' OR cvterm.name = 'U6_snRNA' OR cvterm.name = 'U6atac_snRNA' OR cvterm.name = 'U11_snRNA' OR cvterm.name = 'U12_snRNA' OR cvterm.name = 'C_D_box_snoRNA' OR cvterm.name = 'H_ACA_box_snoRNA' OR cvterm.name = 'U14_snoRNA' OR cvterm.name = 'U3_snoRNA' OR cvterm.name = 'methylation_guide_snoRNA' OR cvterm.name = 'pseudouridylation_guide_snoRNA' OR cvterm.name = 'miRNA' OR cvterm.name = 'RNA_6S' OR cvterm.name = 'CsrB_RsmB_RNA' OR cvterm.name = 'DsrA_RNA' OR cvterm.name = 'OxyS_RNA' OR cvterm.name = 'RprA_RNA' OR cvterm.name = 'RRE_RNA' OR cvterm.name = 'spot_42_RNA' OR cvterm.name = 'tmRNA' OR cvterm.name = 'GcvB_RNA' OR cvterm.name = 'MicF_RNA' OR cvterm.name = 'ncRNA';

--- ************************************************
--- *** relation: strna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW strna_encoding AS
  SELECT
    feature_id AS strna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'stRNA_encoding';

--- ************************************************
--- *** relation: repeat_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of sequence containing one or m ***
--- *** ore repeat units.                        ***
--- ************************************************
---

CREATE VIEW repeat_region AS
  SELECT
    feature_id AS repeat_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'long_terminal_repeat' OR cvterm.name = 'engineered_foreign_repetitive_element' OR cvterm.name = 'inverted_repeat' OR cvterm.name = 'direct_repeat' OR cvterm.name = 'non_LTR_retrotransposon_polymeric_tract' OR cvterm.name = 'dispersed_repeat' OR cvterm.name = 'tandem_repeat' OR cvterm.name = 'X_element_combinatorial_repeat' OR cvterm.name = 'Y_prime_element' OR cvterm.name = 'telomeric_repeat' OR cvterm.name = 'nested_repeat' OR cvterm.name = 'centromeric_repeat' OR cvterm.name = 'five_prime_LTR' OR cvterm.name = 'three_prime_LTR' OR cvterm.name = 'solo_LTR' OR cvterm.name = 'terminal_inverted_repeat' OR cvterm.name = 'five_prime_terminal_inverted_repeat' OR cvterm.name = 'three_prime_terminal_inverted_repeat' OR cvterm.name = 'target_site_duplication' OR cvterm.name = 'CRISPR' OR cvterm.name = 'satellite_DNA' OR cvterm.name = 'microsatellite' OR cvterm.name = 'minisatellite' OR cvterm.name = 'dinucleotide_repeat_microsatellite_feature' OR cvterm.name = 'trinucleotide_repeat_microsatellite_feature' OR cvterm.name = 'tetranucleotide_repeat_microsatellite_feature' OR cvterm.name = 'nested_tandem_repeat' OR cvterm.name = 'regional_centromere_inner_repeat_region' OR cvterm.name = 'regional_centromere_outer_repeat_region' OR cvterm.name = 'repeat_region';

--- ************************************************
--- *** relation: dispersed_repeat ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A repeat that is located at dispersed si ***
--- *** tes in the genome.                       ***
--- ************************************************
---

CREATE VIEW dispersed_repeat AS
  SELECT
    feature_id AS dispersed_repeat_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'dispersed_repeat';

--- ************************************************
--- *** relation: tmrna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW tmrna_encoding AS
  SELECT
    feature_id AS tmrna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tmRNA_encoding';

--- ************************************************
--- *** relation: spliceosomal_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An intron which is spliced by the splice ***
--- *** osome.                                   ***
--- ************************************************
---

CREATE VIEW spliceosomal_intron AS
  SELECT
    feature_id AS spliceosomal_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U2_intron' OR cvterm.name = 'U12_intron' OR cvterm.name = 'spliceosomal_intron';

--- ************************************************
--- *** relation: trna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW trna_encoding AS
  SELECT
    feature_id AS trna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tRNA_encoding';

--- ************************************************
--- *** relation: introgressed_chromosome_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW introgressed_chromosome_region AS
  SELECT
    feature_id AS introgressed_chromosome_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'introgressed_chromosome_region';

--- ************************************************
--- *** relation: monocistronic_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transcript that is monocistronic.      ***
--- ************************************************
---

CREATE VIEW monocistronic_transcript AS
  SELECT
    feature_id AS monocistronic_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'monocistronic_primary_transcript' OR cvterm.name = 'monocistronic_mRNA' OR cvterm.name = 'monocistronic_transcript';

--- ************************************************
--- *** relation: mobile_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An intron (mitochondrial, chloroplast, n ***
--- *** uclear or prokaryotic) that encodes a do ***
--- *** uble strand sequence specific endonuclea ***
--- *** se allowing for mobility.                ***
--- ************************************************
---

CREATE VIEW mobile_intron AS
  SELECT
    feature_id AS mobile_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mobile_intron';

--- ************************************************
--- *** relation: insertion ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The sequence of one or more nucleotides  ***
--- *** added between two adjacent nucleotides i ***
--- *** n the sequence.                          ***
--- ************************************************
---

CREATE VIEW insertion AS
  SELECT
    feature_id AS insertion_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transgenic_insertion' OR cvterm.name = 'duplication' OR cvterm.name = 'tandem_duplication' OR cvterm.name = 'direct_tandem_duplication' OR cvterm.name = 'inverted_tandem_duplication' OR cvterm.name = 'insertion';

--- ************************************************
--- *** relation: est_match ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A match against an EST sequence.         ***
--- ************************************************
---

CREATE VIEW est_match AS
  SELECT
    feature_id AS est_match_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'EST_match';

--- ************************************************
--- *** relation: sequence_rearrangement_feature ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW sequence_rearrangement_feature AS
  SELECT
    feature_id AS sequence_rearrangement_feature_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'specific_recombination_site' OR cvterm.name = 'chromosome_breakage_sequence' OR cvterm.name = 'internal_eliminated_sequence' OR cvterm.name = 'macronucleus_destined_segment' OR cvterm.name = 'recombination_feature_of_rearranged_gene' OR cvterm.name = 'site_specific_recombination_target_region' OR cvterm.name = 'recombination_signal_sequence' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_feature' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_segment' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_gene_cluster' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_spacer' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_segment' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_gene_cluster' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_signal_feature' OR cvterm.name = 'D_gene' OR cvterm.name = 'V_gene' OR cvterm.name = 'J_gene' OR cvterm.name = 'C_gene' OR cvterm.name = 'D_J_C_cluster' OR cvterm.name = 'J_C_cluster' OR cvterm.name = 'J_cluster' OR cvterm.name = 'V_cluster' OR cvterm.name = 'V_J_cluster' OR cvterm.name = 'V_J_C_cluster' OR cvterm.name = 'C_cluster' OR cvterm.name = 'D_cluster' OR cvterm.name = 'D_J_cluster' OR cvterm.name = 'three_prime_D_spacer' OR cvterm.name = 'five_prime_D_spacer' OR cvterm.name = 'J_spacer' OR cvterm.name = 'V_spacer' OR cvterm.name = 'VD_gene' OR cvterm.name = 'DJ_gene' OR cvterm.name = 'VDJ_gene' OR cvterm.name = 'VJ_gene' OR cvterm.name = 'DJ_J_cluster' OR cvterm.name = 'VDJ_J_C_cluster' OR cvterm.name = 'VDJ_J_cluster' OR cvterm.name = 'VJ_C_cluster' OR cvterm.name = 'VJ_J_C_cluster' OR cvterm.name = 'VJ_J_cluster' OR cvterm.name = 'D_DJ_C_cluster' OR cvterm.name = 'D_DJ_cluster' OR cvterm.name = 'D_DJ_J_C_cluster' OR cvterm.name = 'D_DJ_J_cluster' OR cvterm.name = 'V_DJ_cluster' OR cvterm.name = 'V_DJ_J_cluster' OR cvterm.name = 'V_VDJ_C_cluster' OR cvterm.name = 'V_VDJ_cluster' OR cvterm.name = 'V_VDJ_J_cluster' OR cvterm.name = 'V_VJ_C_cluster' OR cvterm.name = 'V_VJ_cluster' OR cvterm.name = 'V_VJ_J_cluster' OR cvterm.name = 'V_D_DJ_C_cluster' OR cvterm.name = 'V_D_DJ_cluster' OR cvterm.name = 'V_D_DJ_J_C_cluster' OR cvterm.name = 'V_D_DJ_J_cluster' OR cvterm.name = 'V_D_J_C_cluster' OR cvterm.name = 'V_D_J_cluster' OR cvterm.name = 'DJ_C_cluster' OR cvterm.name = 'DJ_J_C_cluster' OR cvterm.name = 'VDJ_C_cluster' OR cvterm.name = 'V_DJ_C_cluster' OR cvterm.name = 'V_DJ_J_C_cluster' OR cvterm.name = 'V_VDJ_J_C_cluster' OR cvterm.name = 'V_VJ_J_C_cluster' OR cvterm.name = 'J_gene_recombination_feature' OR cvterm.name = 'D_gene_recombination_feature' OR cvterm.name = 'V_gene_recombination_feature' OR cvterm.name = 'heptamer_of_recombination_feature_of_vertebrate_immune_system_gene' OR cvterm.name = 'nonamer_of_recombination_feature_of_vertebrate_immune_system_gene' OR cvterm.name = 'five_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_heptamer' OR cvterm.name = 'five_prime_D_heptamer' OR cvterm.name = 'J_heptamer' OR cvterm.name = 'V_heptamer' OR cvterm.name = 'three_prime_D_nonamer' OR cvterm.name = 'five_prime_D_nonamer' OR cvterm.name = 'J_nonamer' OR cvterm.name = 'V_nonamer' OR cvterm.name = 'integration_excision_site' OR cvterm.name = 'resolution_site' OR cvterm.name = 'inversion_site' OR cvterm.name = 'inversion_site_part' OR cvterm.name = 'attI_site' OR cvterm.name = 'attP_site' OR cvterm.name = 'attB_site' OR cvterm.name = 'attL_site' OR cvterm.name = 'attR_site' OR cvterm.name = 'attC_site' OR cvterm.name = 'attCtn_site' OR cvterm.name = 'loxP_site' OR cvterm.name = 'dif_site' OR cvterm.name = 'FRT_site' OR cvterm.name = 'IRLinv_site' OR cvterm.name = 'IRRinv_site' OR cvterm.name = 'sequence_rearrangement_feature';

--- ************************************************
--- *** relation: chromosome_breakage_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence within the micronuclear DNA o ***
--- *** f ciliates at which chromosome breakage  ***
--- *** and telomere addition occurs during nucl ***
--- *** ear differentiation.                     ***
--- ************************************************
---

CREATE VIEW chromosome_breakage_sequence AS
  SELECT
    feature_id AS chromosome_breakage_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'chromosome_breakage_sequence';

--- ************************************************
--- *** relation: internal_eliminated_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence eliminated from the genome of ***
--- ***  ciliates during nuclear differentiation ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW internal_eliminated_sequence AS
  SELECT
    feature_id AS internal_eliminated_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'internal_eliminated_sequence';

--- ************************************************
--- *** relation: macronucleus_destined_segment ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence that is conserved, although r ***
--- *** earranged relative to the micronucleus,  ***
--- *** in the macronucleus of a ciliate genome. ***
--- ************************************************
---

CREATE VIEW macronucleus_destined_segment AS
  SELECT
    feature_id AS macronucleus_destined_segment_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'macronucleus_destined_segment';

--- ************************************************
--- *** relation: transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An RNA synthesized on a DNA or RNA templ ***
--- *** ate by an RNA polymerase.                ***
--- ************************************************
---

CREATE VIEW transcript AS
  SELECT
    feature_id AS transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polycistronic_transcript' OR cvterm.name = 'transcript_with_translational_frameshift' OR cvterm.name = 'primary_transcript' OR cvterm.name = 'mature_transcript' OR cvterm.name = 'transcript_bound_by_nucleic_acid' OR cvterm.name = 'transcript_bound_by_protein' OR cvterm.name = 'enzymatic_RNA' OR cvterm.name = 'trans_spliced_transcript' OR cvterm.name = 'monocistronic_transcript' OR cvterm.name = 'aberrant_processed_transcript' OR cvterm.name = 'edited_transcript' OR cvterm.name = 'processed_transcript' OR cvterm.name = 'alternatively_spliced_transcript' OR cvterm.name = 'dicistronic_transcript' OR cvterm.name = 'polycistronic_primary_transcript' OR cvterm.name = 'polycistronic_mRNA' OR cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'protein_coding_primary_transcript' OR cvterm.name = 'nc_primary_transcript' OR cvterm.name = 'polycistronic_primary_transcript' OR cvterm.name = 'monocistronic_primary_transcript' OR cvterm.name = 'mini_exon_donor_RNA' OR cvterm.name = 'antisense_primary_transcript' OR cvterm.name = 'capped_primary_transcript' OR cvterm.name = 'pre_edited_mRNA' OR cvterm.name = 'scRNA_primary_transcript' OR cvterm.name = 'rRNA_primary_transcript' OR cvterm.name = 'tRNA_primary_transcript' OR cvterm.name = 'snRNA_primary_transcript' OR cvterm.name = 'snoRNA_primary_transcript' OR cvterm.name = 'tmRNA_primary_transcript' OR cvterm.name = 'SRP_RNA_primary_transcript' OR cvterm.name = 'miRNA_primary_transcript' OR cvterm.name = 'tasiRNA_primary_transcript' OR cvterm.name = 'rRNA_small_subunit_primary_transcript' OR cvterm.name = 'rRNA_large_subunit_primary_transcript' OR cvterm.name = 'alanine_tRNA_primary_transcript' OR cvterm.name = 'arginine_tRNA_primary_transcript' OR cvterm.name = 'asparagine_tRNA_primary_transcript' OR cvterm.name = 'aspartic_acid_tRNA_primary_transcript' OR cvterm.name = 'cysteine_tRNA_primary_transcript' OR cvterm.name = 'glutamic_acid_tRNA_primary_transcript' OR cvterm.name = 'glutamine_tRNA_primary_transcript' OR cvterm.name = 'glycine_tRNA_primary_transcript' OR cvterm.name = 'histidine_tRNA_primary_transcript' OR cvterm.name = 'isoleucine_tRNA_primary_transcript' OR cvterm.name = 'leucine_tRNA_primary_transcript' OR cvterm.name = 'lysine_tRNA_primary_transcript' OR cvterm.name = 'methionine_tRNA_primary_transcript' OR cvterm.name = 'phenylalanine_tRNA_primary_transcript' OR cvterm.name = 'proline_tRNA_primary_transcript' OR cvterm.name = 'serine_tRNA_primary_transcript' OR cvterm.name = 'threonine_tRNA_primary_transcript' OR cvterm.name = 'tryptophan_tRNA_primary_transcript' OR cvterm.name = 'tyrosine_tRNA_primary_transcript' OR cvterm.name = 'valine_tRNA_primary_transcript' OR cvterm.name = 'pyrrolysine_tRNA_primary_transcript' OR cvterm.name = 'selenocysteine_tRNA_primary_transcript' OR cvterm.name = 'methylation_guide_snoRNA_primary_transcript' OR cvterm.name = 'rRNA_cleavage_snoRNA_primary_transcript' OR cvterm.name = 'C_D_box_snoRNA_primary_transcript' OR cvterm.name = 'H_ACA_box_snoRNA_primary_transcript' OR cvterm.name = 'U14_snoRNA_primary_transcript' OR cvterm.name = 'stRNA_primary_transcript' OR cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'mRNA' OR cvterm.name = 'ncRNA' OR cvterm.name = 'mRNA_with_frameshift' OR cvterm.name = 'monocistronic_mRNA' OR cvterm.name = 'polycistronic_mRNA' OR cvterm.name = 'exemplar_mRNA' OR cvterm.name = 'capped_mRNA' OR cvterm.name = 'polyadenylated_mRNA' OR cvterm.name = 'trans_spliced_mRNA' OR cvterm.name = 'edited_mRNA' OR cvterm.name = 'consensus_mRNA' OR cvterm.name = 'recoded_mRNA' OR cvterm.name = 'mRNA_with_minus_1_frameshift' OR cvterm.name = 'mRNA_with_plus_1_frameshift' OR cvterm.name = 'mRNA_with_plus_2_frameshift' OR cvterm.name = 'mRNA_with_minus_2_frameshift' OR cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'mRNA_recoded_by_translational_bypass' OR cvterm.name = 'mRNA_recoded_by_codon_redefinition' OR cvterm.name = 'scRNA' OR cvterm.name = 'rRNA' OR cvterm.name = 'tRNA' OR cvterm.name = 'snRNA' OR cvterm.name = 'snoRNA' OR cvterm.name = 'small_regulatory_ncRNA' OR cvterm.name = 'RNase_MRP_RNA' OR cvterm.name = 'RNase_P_RNA' OR cvterm.name = 'telomerase_RNA' OR cvterm.name = 'vault_RNA' OR cvterm.name = 'Y_RNA' OR cvterm.name = 'rasiRNA' OR cvterm.name = 'SRP_RNA' OR cvterm.name = 'guide_RNA' OR cvterm.name = 'antisense_RNA' OR cvterm.name = 'siRNA' OR cvterm.name = 'stRNA' OR cvterm.name = 'class_II_RNA' OR cvterm.name = 'class_I_RNA' OR cvterm.name = 'piRNA' OR cvterm.name = 'lincRNA' OR cvterm.name = 'tasiRNA' OR cvterm.name = 'rRNA_cleavage_RNA' OR cvterm.name = 'small_subunit_rRNA' OR cvterm.name = 'large_subunit_rRNA' OR cvterm.name = 'rRNA_18S' OR cvterm.name = 'rRNA_16S' OR cvterm.name = 'rRNA_5_8S' OR cvterm.name = 'rRNA_5S' OR cvterm.name = 'rRNA_28S' OR cvterm.name = 'rRNA_23S' OR cvterm.name = 'rRNA_25S' OR cvterm.name = 'rRNA_21S' OR cvterm.name = 'alanyl_tRNA' OR cvterm.name = 'asparaginyl_tRNA' OR cvterm.name = 'aspartyl_tRNA' OR cvterm.name = 'cysteinyl_tRNA' OR cvterm.name = 'glutaminyl_tRNA' OR cvterm.name = 'glutamyl_tRNA' OR cvterm.name = 'glycyl_tRNA' OR cvterm.name = 'histidyl_tRNA' OR cvterm.name = 'isoleucyl_tRNA' OR cvterm.name = 'leucyl_tRNA' OR cvterm.name = 'lysyl_tRNA' OR cvterm.name = 'methionyl_tRNA' OR cvterm.name = 'phenylalanyl_tRNA' OR cvterm.name = 'prolyl_tRNA' OR cvterm.name = 'seryl_tRNA' OR cvterm.name = 'threonyl_tRNA' OR cvterm.name = 'tryptophanyl_tRNA' OR cvterm.name = 'tyrosyl_tRNA' OR cvterm.name = 'valyl_tRNA' OR cvterm.name = 'pyrrolysyl_tRNA' OR cvterm.name = 'arginyl_tRNA' OR cvterm.name = 'selenocysteinyl_tRNA' OR cvterm.name = 'U1_snRNA' OR cvterm.name = 'U2_snRNA' OR cvterm.name = 'U4_snRNA' OR cvterm.name = 'U4atac_snRNA' OR cvterm.name = 'U5_snRNA' OR cvterm.name = 'U6_snRNA' OR cvterm.name = 'U6atac_snRNA' OR cvterm.name = 'U11_snRNA' OR cvterm.name = 'U12_snRNA' OR cvterm.name = 'C_D_box_snoRNA' OR cvterm.name = 'H_ACA_box_snoRNA' OR cvterm.name = 'U14_snoRNA' OR cvterm.name = 'U3_snoRNA' OR cvterm.name = 'methylation_guide_snoRNA' OR cvterm.name = 'pseudouridylation_guide_snoRNA' OR cvterm.name = 'miRNA' OR cvterm.name = 'RNA_6S' OR cvterm.name = 'CsrB_RsmB_RNA' OR cvterm.name = 'DsrA_RNA' OR cvterm.name = 'OxyS_RNA' OR cvterm.name = 'RprA_RNA' OR cvterm.name = 'RRE_RNA' OR cvterm.name = 'spot_42_RNA' OR cvterm.name = 'tmRNA' OR cvterm.name = 'GcvB_RNA' OR cvterm.name = 'MicF_RNA' OR cvterm.name = 'ribozyme' OR cvterm.name = 'trans_spliced_mRNA' OR cvterm.name = 'monocistronic_primary_transcript' OR cvterm.name = 'monocistronic_mRNA' OR cvterm.name = 'edited_transcript_by_A_to_I_substitution' OR cvterm.name = 'edited_mRNA' OR cvterm.name = 'transcript';

--- ************************************************
--- *** relation: canonical_three_prime_splice_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The canonical 3' splice site has the seq ***
--- *** uence "AG".                              ***
--- ************************************************
---

CREATE VIEW canonical_three_prime_splice_site AS
  SELECT
    feature_id AS canonical_three_prime_splice_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'canonical_three_prime_splice_site';

--- ************************************************
--- *** relation: canonical_five_prime_splice_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The canonical 5' splice site has the seq ***
--- *** uence "GT".                              ***
--- ************************************************
---

CREATE VIEW canonical_five_prime_splice_site AS
  SELECT
    feature_id AS canonical_five_prime_splice_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'canonical_five_prime_splice_site';

--- ************************************************
--- *** relation: non_canonical_three_prime_splice_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A 3' splice site that does not have the  ***
--- *** sequence "AG".                           ***
--- ************************************************
---

CREATE VIEW non_canonical_three_prime_splice_site AS
  SELECT
    feature_id AS non_canonical_three_prime_splice_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'non_canonical_three_prime_splice_site';

--- ************************************************
--- *** relation: non_canonical_five_prime_splice_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A 5' splice site which does not have the ***
--- ***  sequence "GT".                          ***
--- ************************************************
---

CREATE VIEW non_canonical_five_prime_splice_site AS
  SELECT
    feature_id AS non_canonical_five_prime_splice_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'non_canonical_five_prime_splice_site';

--- ************************************************
--- *** relation: non_canonical_start_codon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A start codon that is not the usual AUG  ***
--- *** sequence.                                ***
--- ************************************************
---

CREATE VIEW non_canonical_start_codon AS
  SELECT
    feature_id AS non_canonical_start_codon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'four_bp_start_codon' OR cvterm.name = 'CTG_start_codon' OR cvterm.name = 'non_canonical_start_codon';

--- ************************************************
--- *** relation: aberrant_processed_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transcript that has been processed "in ***
--- *** correctly", for example by the failure o ***
--- *** f splicing of one or more exons.         ***
--- ************************************************
---

CREATE VIEW aberrant_processed_transcript AS
  SELECT
    feature_id AS aberrant_processed_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'aberrant_processed_transcript';

--- ************************************************
--- *** relation: exonic_splice_enhancer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Exonic splicing enhancers (ESEs) facilit ***
--- *** ate exon definition by assisting in the  ***
--- *** recruitment of splicing factors to the a ***
--- *** djacent intron.                          ***
--- ************************************************
---

CREATE VIEW exonic_splice_enhancer AS
  SELECT
    feature_id AS exonic_splice_enhancer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'exonic_splice_enhancer';

--- ************************************************
--- *** relation: nuclease_sensitive_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of nucleotide sequence targeted ***
--- ***  by a nuclease enzyme.                   ***
--- ************************************************
---

CREATE VIEW nuclease_sensitive_site AS
  SELECT
    feature_id AS nuclease_sensitive_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'nuclease_hypersensitive_site' OR cvterm.name = 'group_1_intron_homing_endonuclease_target_region' OR cvterm.name = 'DNAseI_hypersensitive_site' OR cvterm.name = 'nuclease_sensitive_site';

--- ************************************************
--- *** relation: dnasei_hypersensitive_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW dnasei_hypersensitive_site AS
  SELECT
    feature_id AS dnasei_hypersensitive_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DNAseI_hypersensitive_site';

--- ************************************************
--- *** relation: translocation_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosomal translocation whereby the  ***
--- *** chromosomes carrying non-homologous cent ***
--- *** romeres may be recovered independently.  ***
--- *** These chromosomes are described as trans ***
--- *** location elements. This occurs for some  ***
--- *** translocations, particularly but not exc ***
--- *** lusively, reciprocal translocations.     ***
--- ************************************************
---

CREATE VIEW translocation_element AS
  SELECT
    feature_id AS translocation_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'translocation_element';

--- ************************************************
--- *** relation: deletion_junction ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The space between two bases in a sequenc ***
--- *** e which marks the position where a delet ***
--- *** ion has occurred.                        ***
--- ************************************************
---

CREATE VIEW deletion_junction AS
  SELECT
    feature_id AS deletion_junction_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'deletion_junction';

--- ************************************************
--- *** relation: golden_path ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A set of subregions selected from sequen ***
--- *** ce contigs which when concatenated form  ***
--- *** a nonredundant linear sequence.          ***
--- ************************************************
---

CREATE VIEW golden_path AS
  SELECT
    feature_id AS golden_path_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'golden_path';

--- ************************************************
--- *** relation: cdna_match ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A match against cDNA sequence.           ***
--- ************************************************
---

CREATE VIEW cdna_match AS
  SELECT
    feature_id AS cdna_match_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cDNA_match';

--- ************************************************
--- *** relation: gene_with_polycistronic_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that encodes a polycistronic tran ***
--- *** script.                                  ***
--- ************************************************
---

CREATE VIEW gene_with_polycistronic_transcript AS
  SELECT
    feature_id AS gene_with_polycistronic_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_with_dicistronic_transcript' OR cvterm.name = 'gene_with_dicistronic_primary_transcript' OR cvterm.name = 'gene_with_dicistronic_mRNA' OR cvterm.name = 'gene_with_polycistronic_transcript';

--- ************************************************
--- *** relation: cleaved_initiator_methionine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The initiator methionine that has been c ***
--- *** leaved from a mature polypeptide sequenc ***
--- *** e.                                       ***
--- ************************************************
---

CREATE VIEW cleaved_initiator_methionine AS
  SELECT
    feature_id AS cleaved_initiator_methionine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cleaved_initiator_methionine';

--- ************************************************
--- *** relation: gene_with_dicistronic_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that encodes a dicistronic transc ***
--- *** ript.                                    ***
--- ************************************************
---

CREATE VIEW gene_with_dicistronic_transcript AS
  SELECT
    feature_id AS gene_with_dicistronic_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_with_dicistronic_primary_transcript' OR cvterm.name = 'gene_with_dicistronic_mRNA' OR cvterm.name = 'gene_with_dicistronic_transcript';

--- ************************************************
--- *** relation: gene_with_recoded_mrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that encodes an mRNA that is reco ***
--- *** ded.                                     ***
--- ************************************************
---

CREATE VIEW gene_with_recoded_mrna AS
  SELECT
    feature_id AS gene_with_recoded_mrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_with_stop_codon_read_through' OR cvterm.name = 'gene_with_mRNA_recoded_by_translational_bypass' OR cvterm.name = 'gene_with_transcript_with_translational_frameshift' OR cvterm.name = 'gene_with_stop_codon_redefined_as_pyrrolysine' OR cvterm.name = 'gene_with_stop_codon_redefined_as_selenocysteine' OR cvterm.name = 'gene_with_recoded_mRNA';

--- ************************************************
--- *** relation: snp ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** SNPs are single base pair positions in g ***
--- *** enomic DNA at which different sequence a ***
--- *** lternatives exist in normal individuals  ***
--- *** in some population(s), wherein the least ***
--- ***  frequent variant has an abundance of 1% ***
--- ***  or greater.                             ***
--- ************************************************
---

CREATE VIEW snp AS
  SELECT
    feature_id AS snp_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'SNP';

--- ************************************************
--- *** relation: reagent ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence used in experiment.           ***
--- ************************************************
---

CREATE VIEW reagent AS
  SELECT
    feature_id AS reagent_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'PCR_product' OR cvterm.name = 'clone' OR cvterm.name = 'rescue_region' OR cvterm.name = 'oligo' OR cvterm.name = 'clone_insert' OR cvterm.name = 'cloned_region' OR cvterm.name = 'databank_entry' OR cvterm.name = 'RAPD' OR cvterm.name = 'genomic_clone' OR cvterm.name = 'cDNA_clone' OR cvterm.name = 'tiling_path_clone' OR cvterm.name = 'validated_cDNA_clone' OR cvterm.name = 'invalidated_cDNA_clone' OR cvterm.name = 'three_prime_RACE_clone' OR cvterm.name = 'chimeric_cDNA_clone' OR cvterm.name = 'genomically_contaminated_cDNA_clone' OR cvterm.name = 'polyA_primed_cDNA_clone' OR cvterm.name = 'partially_processed_cDNA_clone' OR cvterm.name = 'engineered_rescue_region' OR cvterm.name = 'aptamer' OR cvterm.name = 'probe' OR cvterm.name = 'tag' OR cvterm.name = 'ss_oligo' OR cvterm.name = 'ds_oligo' OR cvterm.name = 'DNAzyme' OR cvterm.name = 'synthetic_oligo' OR cvterm.name = 'DNA_aptamer' OR cvterm.name = 'RNA_aptamer' OR cvterm.name = 'microarray_oligo' OR cvterm.name = 'SAGE_tag' OR cvterm.name = 'STS' OR cvterm.name = 'EST' OR cvterm.name = 'engineered_tag' OR cvterm.name = 'five_prime_EST' OR cvterm.name = 'three_prime_EST' OR cvterm.name = 'UST' OR cvterm.name = 'RST' OR cvterm.name = 'three_prime_UST' OR cvterm.name = 'five_prime_UST' OR cvterm.name = 'three_prime_RST' OR cvterm.name = 'five_prime_RST' OR cvterm.name = 'primer' OR cvterm.name = 'sequencing_primer' OR cvterm.name = 'forward_primer' OR cvterm.name = 'reverse_primer' OR cvterm.name = 'ASPE_primer' OR cvterm.name = 'dCAPS_primer' OR cvterm.name = 'RNAi_reagent' OR cvterm.name = 'DNA_constraint_sequence' OR cvterm.name = 'morpholino_oligo' OR cvterm.name = 'PNA_oligo' OR cvterm.name = 'LNA_oligo' OR cvterm.name = 'TNA_oligo' OR cvterm.name = 'GNA_oligo' OR cvterm.name = 'R_GNA_oligo' OR cvterm.name = 'S_GNA_oligo' OR cvterm.name = 'cloned_cDNA_insert' OR cvterm.name = 'cloned_genomic_insert' OR cvterm.name = 'engineered_insert' OR cvterm.name = 'BAC_cloned_genomic_insert' OR cvterm.name = 'reagent';

--- ************************************************
--- *** relation: oligo ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A short oligonucleotide sequence, of len ***
--- *** gth on the order of 10's of bases; eithe ***
--- *** r single or double stranded.             ***
--- ************************************************
---

CREATE VIEW oligo AS
  SELECT
    feature_id AS oligo_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'aptamer' OR cvterm.name = 'probe' OR cvterm.name = 'tag' OR cvterm.name = 'ss_oligo' OR cvterm.name = 'ds_oligo' OR cvterm.name = 'DNAzyme' OR cvterm.name = 'synthetic_oligo' OR cvterm.name = 'DNA_aptamer' OR cvterm.name = 'RNA_aptamer' OR cvterm.name = 'microarray_oligo' OR cvterm.name = 'SAGE_tag' OR cvterm.name = 'STS' OR cvterm.name = 'EST' OR cvterm.name = 'engineered_tag' OR cvterm.name = 'five_prime_EST' OR cvterm.name = 'three_prime_EST' OR cvterm.name = 'UST' OR cvterm.name = 'RST' OR cvterm.name = 'three_prime_UST' OR cvterm.name = 'five_prime_UST' OR cvterm.name = 'three_prime_RST' OR cvterm.name = 'five_prime_RST' OR cvterm.name = 'primer' OR cvterm.name = 'sequencing_primer' OR cvterm.name = 'forward_primer' OR cvterm.name = 'reverse_primer' OR cvterm.name = 'ASPE_primer' OR cvterm.name = 'dCAPS_primer' OR cvterm.name = 'RNAi_reagent' OR cvterm.name = 'DNA_constraint_sequence' OR cvterm.name = 'morpholino_oligo' OR cvterm.name = 'PNA_oligo' OR cvterm.name = 'LNA_oligo' OR cvterm.name = 'TNA_oligo' OR cvterm.name = 'GNA_oligo' OR cvterm.name = 'R_GNA_oligo' OR cvterm.name = 'S_GNA_oligo' OR cvterm.name = 'oligo';

--- ************************************************
--- *** relation: gene_with_stop_codon_read_through ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that encodes a transcript with st ***
--- *** op codon readthrough.                    ***
--- ************************************************
---

CREATE VIEW gene_with_stop_codon_read_through AS
  SELECT
    feature_id AS gene_with_stop_codon_read_through_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_with_stop_codon_redefined_as_pyrrolysine' OR cvterm.name = 'gene_with_stop_codon_redefined_as_selenocysteine' OR cvterm.name = 'gene_with_stop_codon_read_through';

--- ************************************************
--- *** relation: gene_with_stop_codon_redefined_as_pyrrolysine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene encoding an mRNA that has the sto ***
--- *** p codon redefined as pyrrolysine.        ***
--- ************************************************
---

CREATE VIEW gene_with_stop_codon_redefined_as_pyrrolysine AS
  SELECT
    feature_id AS gene_with_stop_codon_redefined_as_pyrrolysine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_with_stop_codon_redefined_as_pyrrolysine';

--- ************************************************
--- *** relation: junction ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence_feature with an extent of zer ***
--- *** o.                                       ***
--- ************************************************
---

CREATE VIEW junction AS
  SELECT
    feature_id AS junction_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'clone_insert_end' OR cvterm.name = 'clone_insert_start' OR cvterm.name = 'exon_junction' OR cvterm.name = 'insertion_site' OR cvterm.name = 'polyA_site' OR cvterm.name = 'deletion_junction' OR cvterm.name = 'chromosome_breakpoint' OR cvterm.name = 'splice_junction' OR cvterm.name = 'trans_splice_junction' OR cvterm.name = 'restriction_enzyme_cleavage_junction' OR cvterm.name = 'transposable_element_insertion_site' OR cvterm.name = 'inversion_breakpoint' OR cvterm.name = 'translocation_breakpoint' OR cvterm.name = 'insertion_breakpoint' OR cvterm.name = 'deletion_breakpoint' OR cvterm.name = 'blunt_end_restriction_enzyme_cleavage_junction' OR cvterm.name = 'single_strand_restriction_enzyme_cleavage_site' OR cvterm.name = 'five_prime_restriction_enzyme_junction' OR cvterm.name = 'three_prime_restriction_enzyme_junction' OR cvterm.name = 'junction';

--- ************************************************
--- *** relation: remark ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A comment about the sequence.            ***
--- ************************************************
---

CREATE VIEW remark AS
  SELECT
    feature_id AS remark_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'sequence_difference' OR cvterm.name = 'experimental_result_region' OR cvterm.name = 'polypeptide_sequencing_information' OR cvterm.name = 'possible_base_call_error' OR cvterm.name = 'possible_assembly_error' OR cvterm.name = 'assembly_error_correction' OR cvterm.name = 'base_call_error_correction' OR cvterm.name = 'overlapping_feature_set' OR cvterm.name = 'no_output' OR cvterm.name = 'overlapping_EST_set' OR cvterm.name = 'non_adjacent_residues' OR cvterm.name = 'non_terminal_residue' OR cvterm.name = 'sequence_conflict' OR cvterm.name = 'sequence_uncertainty' OR cvterm.name = 'contig_collection' OR cvterm.name = 'remark';

--- ************************************************
--- *** relation: possible_base_call_error ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of sequence where the validity  ***
--- *** of the base calling is questionable.     ***
--- ************************************************
---

CREATE VIEW possible_base_call_error AS
  SELECT
    feature_id AS possible_base_call_error_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'possible_base_call_error';

--- ************************************************
--- *** relation: possible_assembly_error ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of sequence where there may hav ***
--- *** e been an error in the assembly.         ***
--- ************************************************
---

CREATE VIEW possible_assembly_error AS
  SELECT
    feature_id AS possible_assembly_error_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'possible_assembly_error';

--- ************************************************
--- *** relation: experimental_result_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of sequence implicated in an ex ***
--- *** perimental result.                       ***
--- ************************************************
---

CREATE VIEW experimental_result_region AS
  SELECT
    feature_id AS experimental_result_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'overlapping_feature_set' OR cvterm.name = 'no_output' OR cvterm.name = 'overlapping_EST_set' OR cvterm.name = 'experimental_result_region';

--- ************************************************
--- *** relation: gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region (or regions) that includes all  ***
--- *** of the sequence elements necessary to en ***
--- *** code a functional transcript. A gene may ***
--- ***  include regulatory regions, transcribed ***
--- ***  regions and/or other functional sequenc ***
--- *** e regions.                               ***
--- ************************************************
---

CREATE VIEW gene AS
  SELECT
    feature_id AS gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'nuclear_gene' OR cvterm.name = 'mt_gene' OR cvterm.name = 'plastid_gene' OR cvterm.name = 'nucleomorph_gene' OR cvterm.name = 'plasmid_gene' OR cvterm.name = 'proviral_gene' OR cvterm.name = 'transposable_element_gene' OR cvterm.name = 'silenced_gene' OR cvterm.name = 'engineered_gene' OR cvterm.name = 'foreign_gene' OR cvterm.name = 'fusion_gene' OR cvterm.name = 'recombinationally_rearranged_gene' OR cvterm.name = 'gene_with_trans_spliced_transcript' OR cvterm.name = 'gene_with_polycistronic_transcript' OR cvterm.name = 'rescue_gene' OR cvterm.name = 'post_translationally_regulated_gene' OR cvterm.name = 'negatively_autoregulated_gene' OR cvterm.name = 'positively_autoregulated_gene' OR cvterm.name = 'translationally_regulated_gene' OR cvterm.name = 'epigenetically_modified_gene' OR cvterm.name = 'transgene' OR cvterm.name = 'predicted_gene' OR cvterm.name = 'protein_coding_gene' OR cvterm.name = 'retrogene' OR cvterm.name = 'ncRNA_gene' OR cvterm.name = 'cryptic_gene' OR cvterm.name = 'gene_with_non_canonical_start_codon' OR cvterm.name = 'gene_cassette' OR cvterm.name = 'kinetoplast_gene' OR cvterm.name = 'maxicircle_gene' OR cvterm.name = 'minicircle_gene' OR cvterm.name = 'cryptogene' OR cvterm.name = 'apicoplast_gene' OR cvterm.name = 'ct_gene' OR cvterm.name = 'chromoplast_gene' OR cvterm.name = 'cyanelle_gene' OR cvterm.name = 'leucoplast_gene' OR cvterm.name = 'proplastid_gene' OR cvterm.name = 'endogenous_retroviral_gene' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'gene_silenced_by_DNA_modification' OR cvterm.name = 'gene_silenced_by_RNA_interference' OR cvterm.name = 'gene_silenced_by_histone_modification' OR cvterm.name = 'gene_silenced_by_DNA_methylation' OR cvterm.name = 'gene_silenced_by_histone_methylation' OR cvterm.name = 'gene_silenced_by_histone_deacetylation' OR cvterm.name = 'engineered_foreign_gene' OR cvterm.name = 'engineered_fusion_gene' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'engineered_foreign_gene' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'engineered_fusion_gene' OR cvterm.name = 'recombinationally_inverted_gene' OR cvterm.name = 'recombinationally_rearranged_vertebrate_immune_system_gene' OR cvterm.name = 'gene_with_dicistronic_transcript' OR cvterm.name = 'gene_with_dicistronic_primary_transcript' OR cvterm.name = 'gene_with_dicistronic_mRNA' OR cvterm.name = 'wild_type_rescue_gene' OR cvterm.name = 'gene_rearranged_at_DNA_level' OR cvterm.name = 'maternally_imprinted_gene' OR cvterm.name = 'paternally_imprinted_gene' OR cvterm.name = 'allelically_excluded_gene' OR cvterm.name = 'floxed_gene' OR cvterm.name = 'gene_with_polyadenylated_mRNA' OR cvterm.name = 'gene_with_mRNA_with_frameshift' OR cvterm.name = 'gene_with_edited_transcript' OR cvterm.name = 'gene_with_recoded_mRNA' OR cvterm.name = 'gene_with_stop_codon_read_through' OR cvterm.name = 'gene_with_mRNA_recoded_by_translational_bypass' OR cvterm.name = 'gene_with_transcript_with_translational_frameshift' OR cvterm.name = 'gene_with_stop_codon_redefined_as_pyrrolysine' OR cvterm.name = 'gene_with_stop_codon_redefined_as_selenocysteine' OR cvterm.name = 'gRNA_gene' OR cvterm.name = 'miRNA_gene' OR cvterm.name = 'scRNA_gene' OR cvterm.name = 'snoRNA_gene' OR cvterm.name = 'snRNA_gene' OR cvterm.name = 'SRP_RNA_gene' OR cvterm.name = 'stRNA_gene' OR cvterm.name = 'tmRNA_gene' OR cvterm.name = 'tRNA_gene' OR cvterm.name = 'rRNA_gene' OR cvterm.name = 'piRNA_gene' OR cvterm.name = 'RNase_P_RNA_gene' OR cvterm.name = 'RNase_MRP_RNA_gene' OR cvterm.name = 'lincRNA_gene' OR cvterm.name = 'telomerase_RNA_gene' OR cvterm.name = 'cryptogene' OR cvterm.name = 'gene_with_start_codon_CUG' OR cvterm.name = 'gene';

--- ************************************************
--- *** relation: tandem_repeat ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Two or more adjcent copies of a region ( ***
--- *** of length greater than 1).               ***
--- ************************************************
---

CREATE VIEW tandem_repeat AS
  SELECT
    feature_id AS tandem_repeat_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'satellite_DNA' OR cvterm.name = 'microsatellite' OR cvterm.name = 'minisatellite' OR cvterm.name = 'dinucleotide_repeat_microsatellite_feature' OR cvterm.name = 'trinucleotide_repeat_microsatellite_feature' OR cvterm.name = 'tetranucleotide_repeat_microsatellite_feature' OR cvterm.name = 'tandem_repeat';

--- ************************************************
--- *** relation: trans_splice_acceptor_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The 3' splice site of the acceptor prima ***
--- *** ry transcript.                           ***
--- ************************************************
---

CREATE VIEW trans_splice_acceptor_site AS
  SELECT
    feature_id AS trans_splice_acceptor_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'SL1_acceptor_site' OR cvterm.name = 'SL2_acceptor_site' OR cvterm.name = 'SL3_acceptor_site' OR cvterm.name = 'SL4_acceptor_site' OR cvterm.name = 'SL5_acceptor_site' OR cvterm.name = 'SL6_acceptor_site' OR cvterm.name = 'SL7_acceptor_site' OR cvterm.name = 'SL8_acceptor_site' OR cvterm.name = 'SL9_acceptor_site' OR cvterm.name = 'SL10_accceptor_site' OR cvterm.name = 'SL11_acceptor_site' OR cvterm.name = 'SL12_acceptor_site' OR cvterm.name = 'trans_splice_acceptor_site';

--- ************************************************
--- *** relation: trans_splice_donor_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The 5' five prime splice site region of  ***
--- *** the donor RNA.                           ***
--- ************************************************
---

CREATE VIEW trans_splice_donor_site AS
  SELECT
    feature_id AS trans_splice_donor_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'trans_splice_donor_site';

--- ************************************************
--- *** relation: sl1_acceptor_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A trans_splicing_acceptor_site which app ***
--- *** ends the 22nt SL1 RNA leader sequence to ***
--- ***  the 5' end of most mRNAs.               ***
--- ************************************************
---

CREATE VIEW sl1_acceptor_site AS
  SELECT
    feature_id AS sl1_acceptor_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'SL1_acceptor_site';

--- ************************************************
--- *** relation: sl2_acceptor_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A trans_splicing_acceptor_site which app ***
--- *** ends the 22nt SL2 RNA leader sequence to ***
--- ***  the 5' end of mRNAs. SL2 acceptor sites ***
--- ***  occur in genes in internal segments of  ***
--- *** polycistronic transcripts.               ***
--- ************************************************
---

CREATE VIEW sl2_acceptor_site AS
  SELECT
    feature_id AS sl2_acceptor_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'SL3_acceptor_site' OR cvterm.name = 'SL4_acceptor_site' OR cvterm.name = 'SL5_acceptor_site' OR cvterm.name = 'SL6_acceptor_site' OR cvterm.name = 'SL7_acceptor_site' OR cvterm.name = 'SL8_acceptor_site' OR cvterm.name = 'SL9_acceptor_site' OR cvterm.name = 'SL10_accceptor_site' OR cvterm.name = 'SL11_acceptor_site' OR cvterm.name = 'SL12_acceptor_site' OR cvterm.name = 'SL2_acceptor_site';

--- ************************************************
--- *** relation: gene_with_stop_codon_redefined_as_selenocysteine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene encoding an mRNA that has the sto ***
--- *** p codon redefined as selenocysteine.     ***
--- ************************************************
---

CREATE VIEW gene_with_stop_codon_redefined_as_selenocysteine AS
  SELECT
    feature_id AS gene_with_stop_codon_redefined_as_selenocysteine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_with_stop_codon_redefined_as_selenocysteine';

--- ************************************************
--- *** relation: gene_with_mrna_recoded_by_translational_bypass ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene with mRNA recoded by translationa ***
--- *** l bypass.                                ***
--- ************************************************
---

CREATE VIEW gene_with_mrna_recoded_by_translational_bypass AS
  SELECT
    feature_id AS gene_with_mrna_recoded_by_translational_bypass_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_with_mRNA_recoded_by_translational_bypass';

--- ************************************************
--- *** relation: gene_with_transcript_with_translational_frameshift ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene encoding a transcript that has a  ***
--- *** translational frameshift.                ***
--- ************************************************
---

CREATE VIEW gene_with_transcript_with_translational_frameshift AS
  SELECT
    feature_id AS gene_with_transcript_with_translational_frameshift_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_with_transcript_with_translational_frameshift';

--- ************************************************
--- *** relation: dna_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif that is active in the DNA form o ***
--- *** f the sequence.                          ***
--- ************************************************
---

CREATE VIEW dna_motif AS
  SELECT
    feature_id AS dna_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'PSE_motif' OR cvterm.name = 'CAAT_signal' OR cvterm.name = 'minus_10_signal' OR cvterm.name = 'minus_35_signal' OR cvterm.name = 'DRE_motif' OR cvterm.name = 'E_box_motif' OR cvterm.name = 'INR1_motif' OR cvterm.name = 'GAGA_motif' OR cvterm.name = 'octamer_motif' OR cvterm.name = 'retinoic_acid_responsive_element' OR cvterm.name = 'promoter_element' OR cvterm.name = 'DCE_SI' OR cvterm.name = 'DCE_SII' OR cvterm.name = 'DCE_SIII' OR cvterm.name = 'minus_12_signal' OR cvterm.name = 'minus_24_signal' OR cvterm.name = 'GC_rich_promoter_region' OR cvterm.name = 'DMv4_motif' OR cvterm.name = 'DMv5_motif' OR cvterm.name = 'DMv3_motif' OR cvterm.name = 'DMv2_motif' OR cvterm.name = 'DPE1_motif' OR cvterm.name = 'DMv1_motif' OR cvterm.name = 'NDM2_motif' OR cvterm.name = 'NDM3_motif' OR cvterm.name = 'core_promoter_element' OR cvterm.name = 'regulatory_promoter_element' OR cvterm.name = 'INR_motif' OR cvterm.name = 'DPE_motif' OR cvterm.name = 'BREu_motif' OR cvterm.name = 'TATA_box' OR cvterm.name = 'A_box' OR cvterm.name = 'B_box' OR cvterm.name = 'C_box' OR cvterm.name = 'MTE' OR cvterm.name = 'BREd_motif' OR cvterm.name = 'DCE' OR cvterm.name = 'intermediate_element' OR cvterm.name = 'RNA_polymerase_II_TATA_box' OR cvterm.name = 'RNA_polymerase_III_TATA_box' OR cvterm.name = 'A_box_type_1' OR cvterm.name = 'A_box_type_2' OR cvterm.name = 'proximal_promoter_element' OR cvterm.name = 'distal_promoter_element' OR cvterm.name = 'DNA_motif';

--- ************************************************
--- *** relation: nucleotide_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of nucleotide sequence correspo ***
--- *** nding to a known motif.                  ***
--- ************************************************
---

CREATE VIEW nucleotide_motif AS
  SELECT
    feature_id AS nucleotide_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DNA_motif' OR cvterm.name = 'RNA_motif' OR cvterm.name = 'PSE_motif' OR cvterm.name = 'CAAT_signal' OR cvterm.name = 'minus_10_signal' OR cvterm.name = 'minus_35_signal' OR cvterm.name = 'DRE_motif' OR cvterm.name = 'E_box_motif' OR cvterm.name = 'INR1_motif' OR cvterm.name = 'GAGA_motif' OR cvterm.name = 'octamer_motif' OR cvterm.name = 'retinoic_acid_responsive_element' OR cvterm.name = 'promoter_element' OR cvterm.name = 'DCE_SI' OR cvterm.name = 'DCE_SII' OR cvterm.name = 'DCE_SIII' OR cvterm.name = 'minus_12_signal' OR cvterm.name = 'minus_24_signal' OR cvterm.name = 'GC_rich_promoter_region' OR cvterm.name = 'DMv4_motif' OR cvterm.name = 'DMv5_motif' OR cvterm.name = 'DMv3_motif' OR cvterm.name = 'DMv2_motif' OR cvterm.name = 'DPE1_motif' OR cvterm.name = 'DMv1_motif' OR cvterm.name = 'NDM2_motif' OR cvterm.name = 'NDM3_motif' OR cvterm.name = 'core_promoter_element' OR cvterm.name = 'regulatory_promoter_element' OR cvterm.name = 'INR_motif' OR cvterm.name = 'DPE_motif' OR cvterm.name = 'BREu_motif' OR cvterm.name = 'TATA_box' OR cvterm.name = 'A_box' OR cvterm.name = 'B_box' OR cvterm.name = 'C_box' OR cvterm.name = 'MTE' OR cvterm.name = 'BREd_motif' OR cvterm.name = 'DCE' OR cvterm.name = 'intermediate_element' OR cvterm.name = 'RNA_polymerase_II_TATA_box' OR cvterm.name = 'RNA_polymerase_III_TATA_box' OR cvterm.name = 'A_box_type_1' OR cvterm.name = 'A_box_type_2' OR cvterm.name = 'proximal_promoter_element' OR cvterm.name = 'distal_promoter_element' OR cvterm.name = 'RNA_internal_loop' OR cvterm.name = 'A_minor_RNA_motif' OR cvterm.name = 'RNA_junction_loop' OR cvterm.name = 'hammerhead_ribozyme' OR cvterm.name = 'asymmetric_RNA_internal_loop' OR cvterm.name = 'symmetric_RNA_internal_loop' OR cvterm.name = 'K_turn_RNA_motif' OR cvterm.name = 'sarcin_like_RNA_motif' OR cvterm.name = 'RNA_hook_turn' OR cvterm.name = 'nucleotide_motif';

--- ************************************************
--- *** relation: rna_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif that is active in RNA sequence.  ***
--- ************************************************
---

CREATE VIEW rna_motif AS
  SELECT
    feature_id AS rna_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNA_internal_loop' OR cvterm.name = 'A_minor_RNA_motif' OR cvterm.name = 'RNA_junction_loop' OR cvterm.name = 'hammerhead_ribozyme' OR cvterm.name = 'asymmetric_RNA_internal_loop' OR cvterm.name = 'symmetric_RNA_internal_loop' OR cvterm.name = 'K_turn_RNA_motif' OR cvterm.name = 'sarcin_like_RNA_motif' OR cvterm.name = 'RNA_hook_turn' OR cvterm.name = 'RNA_motif';

--- ************************************************
--- *** relation: dicistronic_mrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An mRNA that has the quality dicistronic ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW dicistronic_mrna AS
  SELECT
    feature_id AS dicistronic_mrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'dicistronic_mRNA';

--- ************************************************
--- *** relation: reading_frame ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A nucleic acid sequence that when read a ***
--- *** s sequential triplets, has the potential ***
--- ***  of encoding a sequential string of amin ***
--- *** o acids. It need not contain the start o ***
--- *** r stop codon.                            ***
--- ************************************************
---

CREATE VIEW reading_frame AS
  SELECT
    feature_id AS reading_frame_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'ORF' OR cvterm.name = 'blocked_reading_frame' OR cvterm.name = 'mini_gene' OR cvterm.name = 'rescue_mini_gene' OR cvterm.name = 'reading_frame';

--- ************************************************
--- *** relation: blocked_reading_frame ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A reading_frame that is interrupted by o ***
--- *** ne or more stop codons; usually identifi ***
--- *** ed through intergenomic sequence compari ***
--- *** sons.                                    ***
--- ************************************************
---

CREATE VIEW blocked_reading_frame AS
  SELECT
    feature_id AS blocked_reading_frame_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'blocked_reading_frame';

--- ************************************************
--- *** relation: ultracontig ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An ordered and oriented set of scaffolds ***
--- ***  based on somewhat weaker sets of infere ***
--- *** ntial evidence such as one set of mate p ***
--- *** air reads together with supporting evide ***
--- *** nce from ESTs or location of markers fro ***
--- *** m SNP or microsatellite maps, or cytogen ***
--- *** etic localization of contained markers.  ***
--- ************************************************
---

CREATE VIEW ultracontig AS
  SELECT
    feature_id AS ultracontig_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'ultracontig';

--- ************************************************
--- *** relation: foreign_transposable_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transposable element that is foreign.  ***
--- ************************************************
---

CREATE VIEW foreign_transposable_element AS
  SELECT
    feature_id AS foreign_transposable_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'foreign_transposable_element';

--- ************************************************
--- *** relation: gene_with_dicistronic_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that encodes a dicistronic primar ***
--- *** y transcript.                            ***
--- ************************************************
---

CREATE VIEW gene_with_dicistronic_primary_transcript AS
  SELECT
    feature_id AS gene_with_dicistronic_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_with_dicistronic_primary_transcript';

--- ************************************************
--- *** relation: gene_with_dicistronic_mrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that encodes a polycistronic mRNA ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW gene_with_dicistronic_mrna AS
  SELECT
    feature_id AS gene_with_dicistronic_mrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_with_dicistronic_mRNA';

--- ************************************************
--- *** relation: idna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic sequence removed from the genome ***
--- *** , as a normal event, by a process of rec ***
--- *** ombination.                              ***
--- ************************************************
---

CREATE VIEW idna AS
  SELECT
    feature_id AS idna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'iDNA';

--- ************************************************
--- *** relation: orit ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of a DNA molecule where transfe ***
--- *** r is initiated during the process of con ***
--- *** jugation or mobilization.                ***
--- ************************************************
---

CREATE VIEW orit AS
  SELECT
    feature_id AS orit_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'oriT';

--- ************************************************
--- *** relation: transit_peptide ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The transit_peptide is a short region at ***
--- ***  the N-terminus of the peptide that dire ***
--- *** cts the protein to an organelle (chlorop ***
--- *** last, mitochondrion, microbody or cyanel ***
--- *** le).                                     ***
--- ************************************************
---

CREATE VIEW transit_peptide AS
  SELECT
    feature_id AS transit_peptide_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transit_peptide';

--- ************************************************
--- *** relation: repeat_unit ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The simplest repeated component of a rep ***
--- *** eat region. A single repeat.             ***
--- ************************************************
---

CREATE VIEW repeat_unit AS
  SELECT
    feature_id AS repeat_unit_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'repeat_unit';

--- ************************************************
--- *** relation: crm ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A regulatory_region where more than 1 TF ***
--- *** _binding_site together are regulatorily  ***
--- *** active.                                  ***
--- ************************************************
---

CREATE VIEW crm AS
  SELECT
    feature_id AS crm_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'locus_control_region' OR cvterm.name = 'enhancer' OR cvterm.name = 'silencer' OR cvterm.name = 'enhancer_bound_by_factor' OR cvterm.name = 'shadow_enhancer' OR cvterm.name = 'CRM';

--- ************************************************
--- *** relation: intein ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of a peptide that is able to ex ***
--- *** cise itself and rejoin the remaining por ***
--- *** tions with a peptide bond.               ***
--- ************************************************
---

CREATE VIEW intein AS
  SELECT
    feature_id AS intein_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'intein';

--- ************************************************
--- *** relation: intein_containing ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute of protein-coding genes whe ***
--- *** re the initial protein product contains  ***
--- *** an intein.                               ***
--- ************************************************
---

CREATE VIEW intein_containing AS
  SELECT
    feature_id AS intein_containing_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'intein_containing';

--- ************************************************
--- *** relation: gap ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gap in the sequence of known length. T ***
--- *** he unknown bases are filled in with N's. ***
--- ************************************************
---

CREATE VIEW gap AS
  SELECT
    feature_id AS gap_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gap';

--- ************************************************
--- *** relation: fragmentary ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a feature that  ***
--- *** is incomplete.                           ***
--- ************************************************
---

CREATE VIEW fragmentary AS
  SELECT
    feature_id AS fragmentary_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'fragmentary';

--- ************************************************
--- *** relation: predicted ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing an unverified re ***
--- *** gion.                                    ***
--- ************************************************
---

CREATE VIEW predicted AS
  SELECT
    feature_id AS predicted_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'supported_by_sequence_similarity' OR cvterm.name = 'orphan' OR cvterm.name = 'predicted_by_ab_initio_computation' OR cvterm.name = 'supported_by_domain_match' OR cvterm.name = 'supported_by_EST_or_cDNA' OR cvterm.name = 'predicted';

--- ************************************************
--- *** relation: feature_attribute ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a located_sequen ***
--- *** ce_feature.                              ***
--- ************************************************
---

CREATE VIEW feature_attribute AS
  SELECT
    feature_id AS feature_attribute_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transcript_attribute' OR cvterm.name = 'bound_by_factor' OR cvterm.name = 'flanked' OR cvterm.name = 'gene_attribute' OR cvterm.name = 'retrotransposed' OR cvterm.name = 'transgenic' OR cvterm.name = 'natural' OR cvterm.name = 'engineered' OR cvterm.name = 'foreign' OR cvterm.name = 'fusion' OR cvterm.name = 'rescue' OR cvterm.name = 'wild_type' OR cvterm.name = 'conserved' OR cvterm.name = 'status' OR cvterm.name = 'intermediate' OR cvterm.name = 'recombinationally_rearranged' OR cvterm.name = 'cryptic' OR cvterm.name = 'strand_attribute' OR cvterm.name = 'direction_attribute' OR cvterm.name = 'enzymatic' OR cvterm.name = 'mobile' OR cvterm.name = 'alteration_attribute' OR cvterm.name = 'experimental_feature_attribute' OR cvterm.name = 'edited' OR cvterm.name = 'capped' OR cvterm.name = 'mRNA_attribute' OR cvterm.name = 'trans_spliced' OR cvterm.name = 'alternatively_spliced' OR cvterm.name = 'monocistronic' OR cvterm.name = 'polycistronic' OR cvterm.name = 'polyadenylated' OR cvterm.name = 'exemplar' OR cvterm.name = 'frameshift' OR cvterm.name = 'recoded' OR cvterm.name = 'minus_1_frameshift' OR cvterm.name = 'minus_2_frameshift' OR cvterm.name = 'plus_1_frameshift' OR cvterm.name = 'plus_2_framshift' OR cvterm.name = 'codon_redefined' OR cvterm.name = 'recoded_by_translational_bypass' OR cvterm.name = 'translationally_frameshifted' OR cvterm.name = 'minus_1_translationally_frameshifted' OR cvterm.name = 'plus_1_translationally_frameshifted' OR cvterm.name = 'dicistronic' OR cvterm.name = 'bound_by_protein' OR cvterm.name = 'bound_by_nucleic_acid' OR cvterm.name = 'floxed' OR cvterm.name = 'FRT_flanked' OR cvterm.name = 'protein_coding' OR cvterm.name = 'non_protein_coding' OR cvterm.name = 'gene_to_gene_feature' OR cvterm.name = 'gene_array_member' OR cvterm.name = 'regulated' OR cvterm.name = 'epigenetically_modified' OR cvterm.name = 'encodes_alternately_spliced_transcripts' OR cvterm.name = 'encodes_alternate_transcription_start_sites' OR cvterm.name = 'intein_containing' OR cvterm.name = 'miRNA_encoding' OR cvterm.name = 'rRNA_encoding' OR cvterm.name = 'scRNA_encoding' OR cvterm.name = 'snoRNA_encoding' OR cvterm.name = 'snRNA_encoding' OR cvterm.name = 'SRP_RNA_encoding' OR cvterm.name = 'stRNA_encoding' OR cvterm.name = 'tmRNA_encoding' OR cvterm.name = 'tRNA_encoding' OR cvterm.name = 'gRNA_encoding' OR cvterm.name = 'C_D_box_snoRNA_encoding' OR cvterm.name = 'H_ACA_box_snoRNA_encoding' OR cvterm.name = 'overlapping' OR cvterm.name = 'inside_intron' OR cvterm.name = 'five_prime_three_prime_overlap' OR cvterm.name = 'five_prime_five_prime_overlap' OR cvterm.name = 'three_prime_three_prime_overlap' OR cvterm.name = 'three_prime_five_prime_overlap' OR cvterm.name = 'antisense' OR cvterm.name = 'inside_intron_antiparallel' OR cvterm.name = 'inside_intron_parallel' OR cvterm.name = 'operon_member' OR cvterm.name = 'gene_cassette_member' OR cvterm.name = 'gene_subarray_member' OR cvterm.name = 'member_of_regulon' OR cvterm.name = 'cassette_array_member' OR cvterm.name = 'transcriptionally_regulated' OR cvterm.name = 'post_translationally_regulated' OR cvterm.name = 'translationally_regulated' OR cvterm.name = 'imprinted' OR cvterm.name = 'transcriptionally_constitutive' OR cvterm.name = 'transcriptionally_induced' OR cvterm.name = 'transcriptionally_repressed' OR cvterm.name = 'autoregulated' OR cvterm.name = 'positively_autoregulated' OR cvterm.name = 'negatively_autoregulated' OR cvterm.name = 'silenced' OR cvterm.name = 'silenced_by_DNA_modification' OR cvterm.name = 'silenced_by_RNA_interference' OR cvterm.name = 'silenced_by_histone_modification' OR cvterm.name = 'silenced_by_DNA_methylation' OR cvterm.name = 'silenced_by_histone_methylation' OR cvterm.name = 'silenced_by_histone_deacetylation' OR cvterm.name = 'negatively_autoregulated' OR cvterm.name = 'positively_autoregulated' OR cvterm.name = 'post_translationally_regulated_by_protein_stability' OR cvterm.name = 'post_translationally_regulated_by_protein_modification' OR cvterm.name = 'maternally_imprinted' OR cvterm.name = 'paternally_imprinted' OR cvterm.name = 'imprinted' OR cvterm.name = 'allelically_excluded' OR cvterm.name = 'rearranged_at_DNA_level' OR cvterm.name = 'maternally_imprinted' OR cvterm.name = 'paternally_imprinted' OR cvterm.name = 'encodes_1_polypeptide' OR cvterm.name = 'encodes_greater_than_1_polypeptide' OR cvterm.name = 'encodes_disjoint_polypeptides' OR cvterm.name = 'encodes_overlapping_peptides' OR cvterm.name = 'encodes_different_polypeptides_different_stop' OR cvterm.name = 'encodes_overlapping_peptides_different_start' OR cvterm.name = 'encodes_overlapping_polypeptides_different_start_and_stop' OR cvterm.name = 'homologous' OR cvterm.name = 'syntenic' OR cvterm.name = 'orthologous' OR cvterm.name = 'paralogous' OR cvterm.name = 'fragmentary' OR cvterm.name = 'predicted' OR cvterm.name = 'validated' OR cvterm.name = 'invalidated' OR cvterm.name = 'independently_known' OR cvterm.name = 'consensus' OR cvterm.name = 'low_complexity' OR cvterm.name = 'whole_genome_sequence_status' OR cvterm.name = 'supported_by_sequence_similarity' OR cvterm.name = 'orphan' OR cvterm.name = 'predicted_by_ab_initio_computation' OR cvterm.name = 'supported_by_domain_match' OR cvterm.name = 'supported_by_EST_or_cDNA' OR cvterm.name = 'experimentally_determined' OR cvterm.name = 'invalidated_by_chimeric_cDNA' OR cvterm.name = 'invalidated_by_genomic_contamination' OR cvterm.name = 'invalidated_by_genomic_polyA_primed_cDNA' OR cvterm.name = 'invalidated_by_partial_processing' OR cvterm.name = 'standard_draft' OR cvterm.name = 'high_quality_draft' OR cvterm.name = 'improved_high_quality_draft' OR cvterm.name = 'annotation_directed_improved_draft' OR cvterm.name = 'noncontiguous_finished' OR cvterm.name = 'finished_genome' OR cvterm.name = 'single' OR cvterm.name = 'double' OR cvterm.name = 'forward' OR cvterm.name = 'reverse' OR cvterm.name = 'ribozymic' OR cvterm.name = 'chromosomal_variation_attribute' OR cvterm.name = 'insertion_attribute' OR cvterm.name = 'inversion_attribute' OR cvterm.name = 'translocaton_attribute' OR cvterm.name = 'duplication_attribute' OR cvterm.name = 'intrachromosomal' OR cvterm.name = 'interchromosomal' OR cvterm.name = 'tandem' OR cvterm.name = 'direct' OR cvterm.name = 'inverted' OR cvterm.name = 'pericentric' OR cvterm.name = 'paracentric' OR cvterm.name = 'reciprocal' OR cvterm.name = 'insertional' OR cvterm.name = 'free' OR cvterm.name = 'score' OR cvterm.name = 'quality_value' OR cvterm.name = 'feature_attribute';

--- ************************************************
--- *** relation: exemplar_mrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An exemplar is a representative cDNA seq ***
--- *** uence for each gene. The exemplar approa ***
--- *** ch is a method that usually involves som ***
--- *** e initial clustering into gene groups an ***
--- *** d the subsequent selection of a represen ***
--- *** tative from each gene group.             ***
--- ************************************************
---

CREATE VIEW exemplar_mrna AS
  SELECT
    feature_id AS exemplar_mrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'exemplar_mRNA';

--- ************************************************
--- *** relation: sequence_location ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW sequence_location AS
  SELECT
    feature_id AS sequence_location_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'organelle_sequence' OR cvterm.name = 'plasmid_location' OR cvterm.name = 'proviral_location' OR cvterm.name = 'macronuclear_sequence' OR cvterm.name = 'micronuclear_sequence' OR cvterm.name = 'mitochondrial_sequence' OR cvterm.name = 'nuclear_sequence' OR cvterm.name = 'nucleomorphic_sequence' OR cvterm.name = 'plastid_sequence' OR cvterm.name = 'mitochondrial_DNA' OR cvterm.name = 'apicoplast_sequence' OR cvterm.name = 'chromoplast_sequence' OR cvterm.name = 'chloroplast_sequence' OR cvterm.name = 'cyanelle_sequence' OR cvterm.name = 'leucoplast_sequence' OR cvterm.name = 'proplastid_sequence' OR cvterm.name = 'chloroplast_DNA' OR cvterm.name = 'endogenous_retroviral_sequence' OR cvterm.name = 'sequence_location';

--- ************************************************
--- *** relation: organelle_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW organelle_sequence AS
  SELECT
    feature_id AS organelle_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'macronuclear_sequence' OR cvterm.name = 'micronuclear_sequence' OR cvterm.name = 'mitochondrial_sequence' OR cvterm.name = 'nuclear_sequence' OR cvterm.name = 'nucleomorphic_sequence' OR cvterm.name = 'plastid_sequence' OR cvterm.name = 'mitochondrial_DNA' OR cvterm.name = 'apicoplast_sequence' OR cvterm.name = 'chromoplast_sequence' OR cvterm.name = 'chloroplast_sequence' OR cvterm.name = 'cyanelle_sequence' OR cvterm.name = 'leucoplast_sequence' OR cvterm.name = 'proplastid_sequence' OR cvterm.name = 'chloroplast_DNA' OR cvterm.name = 'organelle_sequence';

--- ************************************************
--- *** relation: mitochondrial_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW mitochondrial_sequence AS
  SELECT
    feature_id AS mitochondrial_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mitochondrial_DNA' OR cvterm.name = 'mitochondrial_sequence';

--- ************************************************
--- *** relation: nuclear_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW nuclear_sequence AS
  SELECT
    feature_id AS nuclear_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'nuclear_sequence';

--- ************************************************
--- *** relation: nucleomorphic_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW nucleomorphic_sequence AS
  SELECT
    feature_id AS nucleomorphic_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'nucleomorphic_sequence';

--- ************************************************
--- *** relation: plastid_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW plastid_sequence AS
  SELECT
    feature_id AS plastid_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'apicoplast_sequence' OR cvterm.name = 'chromoplast_sequence' OR cvterm.name = 'chloroplast_sequence' OR cvterm.name = 'cyanelle_sequence' OR cvterm.name = 'leucoplast_sequence' OR cvterm.name = 'proplastid_sequence' OR cvterm.name = 'chloroplast_DNA' OR cvterm.name = 'plastid_sequence';

--- ************************************************
--- *** relation: kinetoplast ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A kinetoplast is an interlocked network  ***
--- *** of thousands of minicircles and tens of  ***
--- *** maxi circles, located near the base of t ***
--- *** he flagellum of some protozoan species.  ***
--- ************************************************
---

CREATE VIEW kinetoplast AS
  SELECT
    feature_id AS kinetoplast_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'kinetoplast';

--- ************************************************
--- *** relation: maxicircle ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A maxicircle is a replicon, part of a ki ***
--- *** netoplast, that contains open reading fr ***
--- *** ames and replicates via a rolling circle ***
--- ***  method.                                 ***
--- ************************************************
---

CREATE VIEW maxicircle AS
  SELECT
    feature_id AS maxicircle_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'maxicircle';

--- ************************************************
--- *** relation: apicoplast_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW apicoplast_sequence AS
  SELECT
    feature_id AS apicoplast_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'apicoplast_sequence';

--- ************************************************
--- *** relation: chromoplast_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW chromoplast_sequence AS
  SELECT
    feature_id AS chromoplast_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'chromoplast_sequence';

--- ************************************************
--- *** relation: chloroplast_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW chloroplast_sequence AS
  SELECT
    feature_id AS chloroplast_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'chloroplast_DNA' OR cvterm.name = 'chloroplast_sequence';

--- ************************************************
--- *** relation: cyanelle_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW cyanelle_sequence AS
  SELECT
    feature_id AS cyanelle_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cyanelle_sequence';

--- ************************************************
--- *** relation: leucoplast_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW leucoplast_sequence AS
  SELECT
    feature_id AS leucoplast_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'leucoplast_sequence';

--- ************************************************
--- *** relation: proplastid_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW proplastid_sequence AS
  SELECT
    feature_id AS proplastid_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'proplastid_sequence';

--- ************************************************
--- *** relation: plasmid_location ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW plasmid_location AS
  SELECT
    feature_id AS plasmid_location_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'plasmid_location';

--- ************************************************
--- *** relation: amplification_origin ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An origin_of_replication that is used fo ***
--- *** r the amplification of a chromosomal nuc ***
--- *** leic acid sequence.                      ***
--- ************************************************
---

CREATE VIEW amplification_origin AS
  SELECT
    feature_id AS amplification_origin_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'amplification_origin';

--- ************************************************
--- *** relation: proviral_location ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW proviral_location AS
  SELECT
    feature_id AS proviral_location_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'endogenous_retroviral_sequence' OR cvterm.name = 'proviral_location';

--- ************************************************
--- *** relation: gene_group_regulatory_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW gene_group_regulatory_region AS
  SELECT
    feature_id AS gene_group_regulatory_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'operator' OR cvterm.name = 'bacterial_RNApol_promoter' OR cvterm.name = 'bacterial_terminator' OR cvterm.name = 'bacterial_RNApol_promoter_sigma_70' OR cvterm.name = 'bacterial_RNApol_promoter_sigma54' OR cvterm.name = 'rho_dependent_bacterial_terminator' OR cvterm.name = 'rho_independent_bacterial_terminator' OR cvterm.name = 'gene_group_regulatory_region';

--- ************************************************
--- *** relation: clone_insert ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The region of sequence that has been ins ***
--- *** erted and is being propagated by the clo ***
--- *** ne.                                      ***
--- ************************************************
---

CREATE VIEW clone_insert AS
  SELECT
    feature_id AS clone_insert_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cloned_cDNA_insert' OR cvterm.name = 'cloned_genomic_insert' OR cvterm.name = 'engineered_insert' OR cvterm.name = 'BAC_cloned_genomic_insert' OR cvterm.name = 'clone_insert';

--- ************************************************
--- *** relation: lambda_vector ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The lambda bacteriophage is the vector f ***
--- *** or the linear lambda clone. The genes in ***
--- *** volved in the lysogenic pathway are remo ***
--- *** ved from the from the viral DNA. Up to 2 ***
--- *** 5 kb of foreign DNA can then be inserted ***
--- ***  into the lambda genome.                 ***
--- ************************************************
---

CREATE VIEW lambda_vector AS
  SELECT
    feature_id AS lambda_vector_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'lambda_vector';

--- ************************************************
--- *** relation: plasmid_vector ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW plasmid_vector AS
  SELECT
    feature_id AS plasmid_vector_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'plasmid_vector';

--- ************************************************
--- *** relation: cdna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** DNA synthesized by reverse transcriptase ***
--- ***  using RNA as a template.                ***
--- ************************************************
---

CREATE VIEW cdna AS
  SELECT
    feature_id AS cdna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'single_stranded_cDNA' OR cvterm.name = 'double_stranded_cDNA' OR cvterm.name = 'cDNA';

--- ************************************************
--- *** relation: single_stranded_cdna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW single_stranded_cdna AS
  SELECT
    feature_id AS single_stranded_cdna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'single_stranded_cDNA';

--- ************************************************
--- *** relation: double_stranded_cdna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW double_stranded_cdna AS
  SELECT
    feature_id AS double_stranded_cdna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'double_stranded_cDNA';

--- ************************************************
--- *** relation: pyrrolysyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has a pyrrolysine a ***
--- *** nticodon, and a 3' pyrrolysine binding r ***
--- *** egion.                                   ***
--- ************************************************
---

CREATE VIEW pyrrolysyl_trna AS
  SELECT
    feature_id AS pyrrolysyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pyrrolysyl_tRNA';

--- ************************************************
--- *** relation: episome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A plasmid that may integrate with a chro ***
--- *** mosome.                                  ***
--- ************************************************
---

CREATE VIEW episome AS
  SELECT
    feature_id AS episome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_episome' OR cvterm.name = 'episome';

--- ************************************************
--- *** relation: tmrna_coding_piece ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The region of a two-piece tmRNA that bea ***
--- *** rs the reading frame encoding the proteo ***
--- *** lysis tag. The tmRNA gene undergoes circ ***
--- *** ular permutation in some groups of bacte ***
--- *** ria. Processing of the transcripts from  ***
--- *** such a gene leaves the mature tmRNA in t ***
--- *** wo pieces, base-paired together.         ***
--- ************************************************
---

CREATE VIEW tmrna_coding_piece AS
  SELECT
    feature_id AS tmrna_coding_piece_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tmRNA_coding_piece';

--- ************************************************
--- *** relation: tmrna_acceptor_piece ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The acceptor region of a two-piece tmRNA ***
--- ***  that when mature is charged at its 3' e ***
--- *** nd with alanine. The tmRNA gene undergoe ***
--- *** s circular permutation in some groups of ***
--- ***  bacteria; processing of the transcripts ***
--- ***  from such a gene leaves the mature tmRN ***
--- *** A in two pieces, base-paired together.   ***
--- ************************************************
---

CREATE VIEW tmrna_acceptor_piece AS
  SELECT
    feature_id AS tmrna_acceptor_piece_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tmRNA_acceptor_piece';

--- ************************************************
--- *** relation: qtl ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A quantitative trait locus (QTL) is a po ***
--- *** lymorphic locus which contains alleles t ***
--- *** hat differentially affect the expression ***
--- ***  of a continuously distributed phenotypi ***
--- *** c trait. Usually it is a marker describe ***
--- *** d by statistical association to quantita ***
--- *** tive variation in the particular phenoty ***
--- *** pic trait that is thought to be controll ***
--- *** ed by the cumulative action of alleles a ***
--- *** t multiple loci.                         ***
--- ************************************************
---

CREATE VIEW qtl AS
  SELECT
    feature_id AS qtl_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'QTL';

--- ************************************************
--- *** relation: genomic_island ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A genomic island is an integrated mobile ***
--- ***  genetic element, characterized by size  ***
--- *** (over 10 Kb). It that has features that  ***
--- *** suggest a foreign origin. These can incl ***
--- *** ude nucleotide distribution (oligonucleo ***
--- *** tides signature, CG content etc.) that d ***
--- *** iffers from the bulk of the chromosome a ***
--- *** nd/or genes suggesting DNA mobility.     ***
--- ************************************************
---

CREATE VIEW genomic_island AS
  SELECT
    feature_id AS genomic_island_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pathogenic_island' OR cvterm.name = 'metabolic_island' OR cvterm.name = 'adaptive_island' OR cvterm.name = 'symbiosis_island' OR cvterm.name = 'cryptic_prophage' OR cvterm.name = 'defective_conjugative_transposon' OR cvterm.name = 'genomic_island';

--- ************************************************
--- *** relation: pathogenic_island ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Mobile genetic elements that contribute  ***
--- *** to rapid changes in virulence potential. ***
--- ***  They are present on the genomes of path ***
--- *** ogenic strains but absent from the genom ***
--- *** es of non pathogenic members of the same ***
--- ***  or related species.                     ***
--- ************************************************
---

CREATE VIEW pathogenic_island AS
  SELECT
    feature_id AS pathogenic_island_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pathogenic_island';

--- ************************************************
--- *** relation: metabolic_island ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transmissible element containing genes ***
--- ***  involved in metabolism, analogous to th ***
--- *** e pathogenicity islands of gram negative ***
--- ***  bacteria.                               ***
--- ************************************************
---

CREATE VIEW metabolic_island AS
  SELECT
    feature_id AS metabolic_island_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'metabolic_island';

--- ************************************************
--- *** relation: adaptive_island ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An adaptive island is a genomic island t ***
--- *** hat provides an adaptive advantage to th ***
--- *** e host.                                  ***
--- ************************************************
---

CREATE VIEW adaptive_island AS
  SELECT
    feature_id AS adaptive_island_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'adaptive_island';

--- ************************************************
--- *** relation: symbiosis_island ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transmissible element containing genes ***
--- ***  involved in symbiosis, analogous to the ***
--- ***  pathogenicity islands of gram negative  ***
--- *** bacteria.                                ***
--- ************************************************
---

CREATE VIEW symbiosis_island AS
  SELECT
    feature_id AS symbiosis_island_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'symbiosis_island';

--- ************************************************
--- *** relation: pseudogenic_rrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A non functional descendent of an rRNA.  ***
--- ************************************************
---

CREATE VIEW pseudogenic_rrna AS
  SELECT
    feature_id AS pseudogenic_rrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pseudogenic_rRNA';

--- ************************************************
--- *** relation: pseudogenic_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A non functional descendent of a tRNA.   ***
--- ************************************************
---

CREATE VIEW pseudogenic_trna AS
  SELECT
    feature_id AS pseudogenic_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pseudogenic_tRNA';

--- ************************************************
--- *** relation: engineered_episome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An episome that is engineered.           ***
--- ************************************************
---

CREATE VIEW engineered_episome AS
  SELECT
    feature_id AS engineered_episome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_episome';

--- ************************************************
--- *** relation: transgenic ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Attribute describing sequence that has b ***
--- *** een integrated with foreign sequence.    ***
--- ************************************************
---

CREATE VIEW transgenic AS
  SELECT
    feature_id AS transgenic_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transgenic';

--- ************************************************
--- *** relation: so_natural ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a feature that o ***
--- *** ccurs in nature.                         ***
--- ************************************************
---

CREATE VIEW so_natural AS
  SELECT
    feature_id AS so_natural_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'natural';

--- ************************************************
--- *** relation: engineered ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a region that w ***
--- *** as modified in vitro.                    ***
--- ************************************************
---

CREATE VIEW engineered AS
  SELECT
    feature_id AS engineered_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered';

--- ************************************************
--- *** relation: so_foreign ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a region from a ***
--- *** nother species.                          ***
--- ************************************************
---

CREATE VIEW so_foreign AS
  SELECT
    feature_id AS so_foreign_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'foreign';

--- ************************************************
--- *** relation: cloned_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW cloned_region AS
  SELECT
    feature_id AS cloned_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cloned_region';

--- ************************************************
--- *** relation: validated ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a feature that  ***
--- *** has been proven.                         ***
--- ************************************************
---

CREATE VIEW validated AS
  SELECT
    feature_id AS validated_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'experimentally_determined' OR cvterm.name = 'validated';

--- ************************************************
--- *** relation: invalidated ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a feature that i ***
--- *** s invalidated.                           ***
--- ************************************************
---

CREATE VIEW invalidated AS
  SELECT
    feature_id AS invalidated_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'invalidated_by_chimeric_cDNA' OR cvterm.name = 'invalidated_by_genomic_contamination' OR cvterm.name = 'invalidated_by_genomic_polyA_primed_cDNA' OR cvterm.name = 'invalidated_by_partial_processing' OR cvterm.name = 'invalidated';

--- ************************************************
--- *** relation: engineered_rescue_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A rescue region that is engineered.      ***
--- ************************************************
---

CREATE VIEW engineered_rescue_region AS
  SELECT
    feature_id AS engineered_rescue_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_rescue_region';

--- ************************************************
--- *** relation: rescue_mini_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A mini_gene that rescues.                ***
--- ************************************************
---

CREATE VIEW rescue_mini_gene AS
  SELECT
    feature_id AS rescue_mini_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rescue_mini_gene';

--- ************************************************
--- *** relation: transgenic_transposable_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** TE that has been modified in vitro, incl ***
--- *** uding insertion of DNA derived from a so ***
--- *** urce other than the originating TE.      ***
--- ************************************************
---

CREATE VIEW transgenic_transposable_element AS
  SELECT
    feature_id AS transgenic_transposable_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transgenic_transposable_element';

--- ************************************************
--- *** relation: natural_transposable_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** TE that exists (or existed) in nature.   ***
--- ************************************************
---

CREATE VIEW natural_transposable_element AS
  SELECT
    feature_id AS natural_transposable_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'natural_transposable_element';

--- ************************************************
--- *** relation: engineered_transposable_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** TE that has been modified by manipulatio ***
--- *** ns in vitro.                             ***
--- ************************************************
---

CREATE VIEW engineered_transposable_element AS
  SELECT
    feature_id AS engineered_transposable_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'engineered_transposable_element';

--- ************************************************
--- *** relation: engineered_foreign_transposable_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transposable_element that is engineere ***
--- *** d and foreign.                           ***
--- ************************************************
---

CREATE VIEW engineered_foreign_transposable_element AS
  SELECT
    feature_id AS engineered_foreign_transposable_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_foreign_transposable_element';

--- ************************************************
--- *** relation: assortment_derived_duplication ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A multi-chromosome duplication aberratio ***
--- *** n generated by reassortment of other abe ***
--- *** rration components.                      ***
--- ************************************************
---

CREATE VIEW assortment_derived_duplication AS
  SELECT
    feature_id AS assortment_derived_duplication_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'assortment_derived_duplication';

--- ************************************************
--- *** relation: assortment_derived_deficiency_plus_duplication ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A multi-chromosome aberration generated  ***
--- *** by reassortment of other aberration comp ***
--- *** onents; presumed to have a deficiency an ***
--- *** d a duplication.                         ***
--- ************************************************
---

CREATE VIEW assortment_derived_deficiency_plus_duplication AS
  SELECT
    feature_id AS assortment_derived_deficiency_plus_duplication_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'assortment_derived_deficiency_plus_duplication';

--- ************************************************
--- *** relation: assortment_derived_deficiency ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A multi-chromosome deficiency aberration ***
--- ***  generated by reassortment of other aber ***
--- *** ration components.                       ***
--- ************************************************
---

CREATE VIEW assortment_derived_deficiency AS
  SELECT
    feature_id AS assortment_derived_deficiency_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'assortment_derived_deficiency';

--- ************************************************
--- *** relation: assortment_derived_aneuploid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A multi-chromosome aberration generated  ***
--- *** by reassortment of other aberration comp ***
--- *** onents; presumed to have a deficiency or ***
--- ***  a duplication.                          ***
--- ************************************************
---

CREATE VIEW assortment_derived_aneuploid AS
  SELECT
    feature_id AS assortment_derived_aneuploid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'assortment_derived_aneuploid';

--- ************************************************
--- *** relation: engineered_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region that is engineered.             ***
--- ************************************************
---

CREATE VIEW engineered_region AS
  SELECT
    feature_id AS engineered_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_gene' OR cvterm.name = 'engineered_plasmid' OR cvterm.name = 'engineered_rescue_region' OR cvterm.name = 'engineered_transposable_element' OR cvterm.name = 'engineered_foreign_region' OR cvterm.name = 'engineered_tag' OR cvterm.name = 'engineered_insert' OR cvterm.name = 'targeting_vector' OR cvterm.name = 'engineered_foreign_gene' OR cvterm.name = 'engineered_fusion_gene' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'engineered_episome' OR cvterm.name = 'gene_trap_construct' OR cvterm.name = 'promoter_trap_construct' OR cvterm.name = 'enhancer_trap_construct' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'engineered_foreign_gene' OR cvterm.name = 'engineered_foreign_repetitive_element' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'engineered_region';

--- ************************************************
--- *** relation: engineered_foreign_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region that is engineered and foreign. ***
--- ************************************************
---

CREATE VIEW engineered_foreign_region AS
  SELECT
    feature_id AS engineered_foreign_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_foreign_gene' OR cvterm.name = 'engineered_foreign_repetitive_element' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'engineered_foreign_transposable_element_gene' OR cvterm.name = 'engineered_foreign_region';

--- ************************************************
--- *** relation: fusion ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW fusion AS
  SELECT
    feature_id AS fusion_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'fusion';

--- ************************************************
--- *** relation: engineered_tag ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tag that is engineered.                ***
--- ************************************************
---

CREATE VIEW engineered_tag AS
  SELECT
    feature_id AS engineered_tag_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_tag';

--- ************************************************
--- *** relation: validated_cdna_clone ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A cDNA clone that has been validated.    ***
--- ************************************************
---

CREATE VIEW validated_cdna_clone AS
  SELECT
    feature_id AS validated_cdna_clone_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'validated_cDNA_clone';

--- ************************************************
--- *** relation: invalidated_cdna_clone ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A cDNA clone that is invalid.            ***
--- ************************************************
---

CREATE VIEW invalidated_cdna_clone AS
  SELECT
    feature_id AS invalidated_cdna_clone_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'chimeric_cDNA_clone' OR cvterm.name = 'genomically_contaminated_cDNA_clone' OR cvterm.name = 'polyA_primed_cDNA_clone' OR cvterm.name = 'partially_processed_cDNA_clone' OR cvterm.name = 'invalidated_cDNA_clone';

--- ************************************************
--- *** relation: chimeric_cdna_clone ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A cDNA clone invalidated because it is c ***
--- *** himeric.                                 ***
--- ************************************************
---

CREATE VIEW chimeric_cdna_clone AS
  SELECT
    feature_id AS chimeric_cdna_clone_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'chimeric_cDNA_clone';

--- ************************************************
--- *** relation: genomically_contaminated_cdna_clone ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A cDNA clone invalidated by genomic cont ***
--- *** amination.                               ***
--- ************************************************
---

CREATE VIEW genomically_contaminated_cdna_clone AS
  SELECT
    feature_id AS genomically_contaminated_cdna_clone_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'genomically_contaminated_cDNA_clone';

--- ************************************************
--- *** relation: polya_primed_cdna_clone ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A cDNA clone invalidated by polyA primin ***
--- *** g.                                       ***
--- ************************************************
---

CREATE VIEW polya_primed_cdna_clone AS
  SELECT
    feature_id AS polya_primed_cdna_clone_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polyA_primed_cDNA_clone';

--- ************************************************
--- *** relation: partially_processed_cdna_clone ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A cDNA invalidated clone by partial proc ***
--- *** essing.                                  ***
--- ************************************************
---

CREATE VIEW partially_processed_cdna_clone AS
  SELECT
    feature_id AS partially_processed_cdna_clone_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'partially_processed_cDNA_clone';

--- ************************************************
--- *** relation: rescue ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a region's abili ***
--- *** ty, when introduced to a mutant organism ***
--- *** , to re-establish (rescue) a phenotype.  ***
--- ************************************************
---

CREATE VIEW rescue AS
  SELECT
    feature_id AS rescue_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rescue';

--- ************************************************
--- *** relation: mini_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** By definition, minigenes are short open- ***
--- *** reading frames (ORF), usually encoding a ***
--- *** pproximately 9 to 20 amino acids, which  ***
--- *** are expressed in vivo (as distinct from  ***
--- *** being synthesized as peptide or protein  ***
--- *** ex vivo and subsequently injected). The  ***
--- *** in vivo synthesis confers a distinct adv ***
--- *** antage: the expressed sequences can ente ***
--- *** r both antigen presentation pathways, MH ***
--- *** C I (inducing CD8+ T- cells, which are u ***
--- *** sually cytotoxic T-lymphocytes (CTL)) an ***
--- *** d MHC II (inducing CD4+ T-cells, usually ***
--- ***  'T-helpers' (Th)); and can encounter B- ***
--- *** cells, inducing antibody responses. Thre ***
--- *** e main vector approaches have been used  ***
--- *** to deliver minigenes: viral vectors, bac ***
--- *** terial vectors and plasmid DNA.          ***
--- ************************************************
---

CREATE VIEW mini_gene AS
  SELECT
    feature_id AS mini_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rescue_mini_gene' OR cvterm.name = 'mini_gene';

--- ************************************************
--- *** relation: rescue_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that rescues.                     ***
--- ************************************************
---

CREATE VIEW rescue_gene AS
  SELECT
    feature_id AS rescue_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'wild_type_rescue_gene' OR cvterm.name = 'rescue_gene';

--- ************************************************
--- *** relation: wild_type ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing sequence with th ***
--- *** e genotype found in nature and/or standa ***
--- *** rd laboratory stock.                     ***
--- ************************************************
---

CREATE VIEW wild_type AS
  SELECT
    feature_id AS wild_type_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'wild_type';

--- ************************************************
--- *** relation: wild_type_rescue_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that rescues.                     ***
--- ************************************************
---

CREATE VIEW wild_type_rescue_gene AS
  SELECT
    feature_id AS wild_type_rescue_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'wild_type_rescue_gene';

--- ************************************************
--- *** relation: mitochondrial_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome originating in a mitochondr ***
--- *** ia.                                      ***
--- ************************************************
---

CREATE VIEW mitochondrial_chromosome AS
  SELECT
    feature_id AS mitochondrial_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mitochondrial_chromosome';

--- ************************************************
--- *** relation: chloroplast_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome originating in a chloroplas ***
--- *** t.                                       ***
--- ************************************************
---

CREATE VIEW chloroplast_chromosome AS
  SELECT
    feature_id AS chloroplast_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'chloroplast_chromosome';

--- ************************************************
--- *** relation: chromoplast_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome originating in a chromoplas ***
--- *** t.                                       ***
--- ************************************************
---

CREATE VIEW chromoplast_chromosome AS
  SELECT
    feature_id AS chromoplast_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'chromoplast_chromosome';

--- ************************************************
--- *** relation: cyanelle_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome originating in a cyanelle.  ***
--- ************************************************
---

CREATE VIEW cyanelle_chromosome AS
  SELECT
    feature_id AS cyanelle_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cyanelle_chromosome';

--- ************************************************
--- *** relation: leucoplast_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome with origin in a leucoplast ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW leucoplast_chromosome AS
  SELECT
    feature_id AS leucoplast_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'leucoplast_chromosome';

--- ************************************************
--- *** relation: macronuclear_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome originating in a macronucle ***
--- *** us.                                      ***
--- ************************************************
---

CREATE VIEW macronuclear_chromosome AS
  SELECT
    feature_id AS macronuclear_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'macronuclear_chromosome';

--- ************************************************
--- *** relation: micronuclear_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome originating in a micronucle ***
--- *** us.                                      ***
--- ************************************************
---

CREATE VIEW micronuclear_chromosome AS
  SELECT
    feature_id AS micronuclear_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'micronuclear_chromosome';

--- ************************************************
--- *** relation: nuclear_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome originating in a nucleus.   ***
--- ************************************************
---

CREATE VIEW nuclear_chromosome AS
  SELECT
    feature_id AS nuclear_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'nuclear_chromosome';

--- ************************************************
--- *** relation: nucleomorphic_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome originating in a nucleomorp ***
--- *** h.                                       ***
--- ************************************************
---

CREATE VIEW nucleomorphic_chromosome AS
  SELECT
    feature_id AS nucleomorphic_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'nucleomorphic_chromosome';

--- ************************************************
--- *** relation: chromosome_part ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of a chromosome.                ***
--- ************************************************
---

CREATE VIEW chromosome_part AS
  SELECT
    feature_id AS chromosome_part_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'chromosome_arm' OR cvterm.name = 'chromosome_band' OR cvterm.name = 'interband' OR cvterm.name = 'chromosomal_regulatory_element' OR cvterm.name = 'chromosomal_structural_element' OR cvterm.name = 'introgressed_chromosome_region' OR cvterm.name = 'matrix_attachment_site' OR cvterm.name = 'centromere' OR cvterm.name = 'telomere' OR cvterm.name = 'point_centromere' OR cvterm.name = 'regional_centromere' OR cvterm.name = 'chromosome_part';

--- ************************************************
--- *** relation: gene_member_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of a gene.                      ***
--- ************************************************
---

CREATE VIEW gene_member_region AS
  SELECT
    feature_id AS gene_member_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transcript' OR cvterm.name = 'regulatory_region' OR cvterm.name = 'polycistronic_transcript' OR cvterm.name = 'transcript_with_translational_frameshift' OR cvterm.name = 'primary_transcript' OR cvterm.name = 'mature_transcript' OR cvterm.name = 'transcript_bound_by_nucleic_acid' OR cvterm.name = 'transcript_bound_by_protein' OR cvterm.name = 'enzymatic_RNA' OR cvterm.name = 'trans_spliced_transcript' OR cvterm.name = 'monocistronic_transcript' OR cvterm.name = 'aberrant_processed_transcript' OR cvterm.name = 'edited_transcript' OR cvterm.name = 'processed_transcript' OR cvterm.name = 'alternatively_spliced_transcript' OR cvterm.name = 'dicistronic_transcript' OR cvterm.name = 'polycistronic_primary_transcript' OR cvterm.name = 'polycistronic_mRNA' OR cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'protein_coding_primary_transcript' OR cvterm.name = 'nc_primary_transcript' OR cvterm.name = 'polycistronic_primary_transcript' OR cvterm.name = 'monocistronic_primary_transcript' OR cvterm.name = 'mini_exon_donor_RNA' OR cvterm.name = 'antisense_primary_transcript' OR cvterm.name = 'capped_primary_transcript' OR cvterm.name = 'pre_edited_mRNA' OR cvterm.name = 'scRNA_primary_transcript' OR cvterm.name = 'rRNA_primary_transcript' OR cvterm.name = 'tRNA_primary_transcript' OR cvterm.name = 'snRNA_primary_transcript' OR cvterm.name = 'snoRNA_primary_transcript' OR cvterm.name = 'tmRNA_primary_transcript' OR cvterm.name = 'SRP_RNA_primary_transcript' OR cvterm.name = 'miRNA_primary_transcript' OR cvterm.name = 'tasiRNA_primary_transcript' OR cvterm.name = 'rRNA_small_subunit_primary_transcript' OR cvterm.name = 'rRNA_large_subunit_primary_transcript' OR cvterm.name = 'alanine_tRNA_primary_transcript' OR cvterm.name = 'arginine_tRNA_primary_transcript' OR cvterm.name = 'asparagine_tRNA_primary_transcript' OR cvterm.name = 'aspartic_acid_tRNA_primary_transcript' OR cvterm.name = 'cysteine_tRNA_primary_transcript' OR cvterm.name = 'glutamic_acid_tRNA_primary_transcript' OR cvterm.name = 'glutamine_tRNA_primary_transcript' OR cvterm.name = 'glycine_tRNA_primary_transcript' OR cvterm.name = 'histidine_tRNA_primary_transcript' OR cvterm.name = 'isoleucine_tRNA_primary_transcript' OR cvterm.name = 'leucine_tRNA_primary_transcript' OR cvterm.name = 'lysine_tRNA_primary_transcript' OR cvterm.name = 'methionine_tRNA_primary_transcript' OR cvterm.name = 'phenylalanine_tRNA_primary_transcript' OR cvterm.name = 'proline_tRNA_primary_transcript' OR cvterm.name = 'serine_tRNA_primary_transcript' OR cvterm.name = 'threonine_tRNA_primary_transcript' OR cvterm.name = 'tryptophan_tRNA_primary_transcript' OR cvterm.name = 'tyrosine_tRNA_primary_transcript' OR cvterm.name = 'valine_tRNA_primary_transcript' OR cvterm.name = 'pyrrolysine_tRNA_primary_transcript' OR cvterm.name = 'selenocysteine_tRNA_primary_transcript' OR cvterm.name = 'methylation_guide_snoRNA_primary_transcript' OR cvterm.name = 'rRNA_cleavage_snoRNA_primary_transcript' OR cvterm.name = 'C_D_box_snoRNA_primary_transcript' OR cvterm.name = 'H_ACA_box_snoRNA_primary_transcript' OR cvterm.name = 'U14_snoRNA_primary_transcript' OR cvterm.name = 'stRNA_primary_transcript' OR cvterm.name = 'dicistronic_primary_transcript' OR cvterm.name = 'mRNA' OR cvterm.name = 'ncRNA' OR cvterm.name = 'mRNA_with_frameshift' OR cvterm.name = 'monocistronic_mRNA' OR cvterm.name = 'polycistronic_mRNA' OR cvterm.name = 'exemplar_mRNA' OR cvterm.name = 'capped_mRNA' OR cvterm.name = 'polyadenylated_mRNA' OR cvterm.name = 'trans_spliced_mRNA' OR cvterm.name = 'edited_mRNA' OR cvterm.name = 'consensus_mRNA' OR cvterm.name = 'recoded_mRNA' OR cvterm.name = 'mRNA_with_minus_1_frameshift' OR cvterm.name = 'mRNA_with_plus_1_frameshift' OR cvterm.name = 'mRNA_with_plus_2_frameshift' OR cvterm.name = 'mRNA_with_minus_2_frameshift' OR cvterm.name = 'dicistronic_mRNA' OR cvterm.name = 'mRNA_recoded_by_translational_bypass' OR cvterm.name = 'mRNA_recoded_by_codon_redefinition' OR cvterm.name = 'scRNA' OR cvterm.name = 'rRNA' OR cvterm.name = 'tRNA' OR cvterm.name = 'snRNA' OR cvterm.name = 'snoRNA' OR cvterm.name = 'small_regulatory_ncRNA' OR cvterm.name = 'RNase_MRP_RNA' OR cvterm.name = 'RNase_P_RNA' OR cvterm.name = 'telomerase_RNA' OR cvterm.name = 'vault_RNA' OR cvterm.name = 'Y_RNA' OR cvterm.name = 'rasiRNA' OR cvterm.name = 'SRP_RNA' OR cvterm.name = 'guide_RNA' OR cvterm.name = 'antisense_RNA' OR cvterm.name = 'siRNA' OR cvterm.name = 'stRNA' OR cvterm.name = 'class_II_RNA' OR cvterm.name = 'class_I_RNA' OR cvterm.name = 'piRNA' OR cvterm.name = 'lincRNA' OR cvterm.name = 'tasiRNA' OR cvterm.name = 'rRNA_cleavage_RNA' OR cvterm.name = 'small_subunit_rRNA' OR cvterm.name = 'large_subunit_rRNA' OR cvterm.name = 'rRNA_18S' OR cvterm.name = 'rRNA_16S' OR cvterm.name = 'rRNA_5_8S' OR cvterm.name = 'rRNA_5S' OR cvterm.name = 'rRNA_28S' OR cvterm.name = 'rRNA_23S' OR cvterm.name = 'rRNA_25S' OR cvterm.name = 'rRNA_21S' OR cvterm.name = 'alanyl_tRNA' OR cvterm.name = 'asparaginyl_tRNA' OR cvterm.name = 'aspartyl_tRNA' OR cvterm.name = 'cysteinyl_tRNA' OR cvterm.name = 'glutaminyl_tRNA' OR cvterm.name = 'glutamyl_tRNA' OR cvterm.name = 'glycyl_tRNA' OR cvterm.name = 'histidyl_tRNA' OR cvterm.name = 'isoleucyl_tRNA' OR cvterm.name = 'leucyl_tRNA' OR cvterm.name = 'lysyl_tRNA' OR cvterm.name = 'methionyl_tRNA' OR cvterm.name = 'phenylalanyl_tRNA' OR cvterm.name = 'prolyl_tRNA' OR cvterm.name = 'seryl_tRNA' OR cvterm.name = 'threonyl_tRNA' OR cvterm.name = 'tryptophanyl_tRNA' OR cvterm.name = 'tyrosyl_tRNA' OR cvterm.name = 'valyl_tRNA' OR cvterm.name = 'pyrrolysyl_tRNA' OR cvterm.name = 'arginyl_tRNA' OR cvterm.name = 'selenocysteinyl_tRNA' OR cvterm.name = 'U1_snRNA' OR cvterm.name = 'U2_snRNA' OR cvterm.name = 'U4_snRNA' OR cvterm.name = 'U4atac_snRNA' OR cvterm.name = 'U5_snRNA' OR cvterm.name = 'U6_snRNA' OR cvterm.name = 'U6atac_snRNA' OR cvterm.name = 'U11_snRNA' OR cvterm.name = 'U12_snRNA' OR cvterm.name = 'C_D_box_snoRNA' OR cvterm.name = 'H_ACA_box_snoRNA' OR cvterm.name = 'U14_snoRNA' OR cvterm.name = 'U3_snoRNA' OR cvterm.name = 'methylation_guide_snoRNA' OR cvterm.name = 'pseudouridylation_guide_snoRNA' OR cvterm.name = 'miRNA' OR cvterm.name = 'RNA_6S' OR cvterm.name = 'CsrB_RsmB_RNA' OR cvterm.name = 'DsrA_RNA' OR cvterm.name = 'OxyS_RNA' OR cvterm.name = 'RprA_RNA' OR cvterm.name = 'RRE_RNA' OR cvterm.name = 'spot_42_RNA' OR cvterm.name = 'tmRNA' OR cvterm.name = 'GcvB_RNA' OR cvterm.name = 'MicF_RNA' OR cvterm.name = 'ribozyme' OR cvterm.name = 'trans_spliced_mRNA' OR cvterm.name = 'monocistronic_primary_transcript' OR cvterm.name = 'monocistronic_mRNA' OR cvterm.name = 'edited_transcript_by_A_to_I_substitution' OR cvterm.name = 'edited_mRNA' OR cvterm.name = 'transcription_regulatory_region' OR cvterm.name = 'translation_regulatory_region' OR cvterm.name = 'recombination_regulatory_region' OR cvterm.name = 'replication_regulatory_region' OR cvterm.name = 'terminator' OR cvterm.name = 'TF_binding_site' OR cvterm.name = 'polyA_signal_sequence' OR cvterm.name = 'gene_group_regulatory_region' OR cvterm.name = 'transcriptional_cis_regulatory_region' OR cvterm.name = 'splicing_regulatory_region' OR cvterm.name = 'cis_regulatory_frameshift_element' OR cvterm.name = 'intronic_regulatory_region' OR cvterm.name = 'bacterial_terminator' OR cvterm.name = 'eukaryotic_terminator' OR cvterm.name = 'rho_dependent_bacterial_terminator' OR cvterm.name = 'rho_independent_bacterial_terminator' OR cvterm.name = 'terminator_of_type_2_RNApol_III_promoter' OR cvterm.name = 'operator' OR cvterm.name = 'bacterial_RNApol_promoter' OR cvterm.name = 'bacterial_terminator' OR cvterm.name = 'bacterial_RNApol_promoter_sigma_70' OR cvterm.name = 'bacterial_RNApol_promoter_sigma54' OR cvterm.name = 'rho_dependent_bacterial_terminator' OR cvterm.name = 'rho_independent_bacterial_terminator' OR cvterm.name = 'promoter' OR cvterm.name = 'insulator' OR cvterm.name = 'CRM' OR cvterm.name = 'promoter_targeting_sequence' OR cvterm.name = 'ISRE' OR cvterm.name = 'bidirectional_promoter' OR cvterm.name = 'RNA_polymerase_promoter' OR cvterm.name = 'RNApol_I_promoter' OR cvterm.name = 'RNApol_II_promoter' OR cvterm.name = 'RNApol_III_promoter' OR cvterm.name = 'bacterial_RNApol_promoter' OR cvterm.name = 'Phage_RNA_Polymerase_Promoter' OR cvterm.name = 'RNApol_II_core_promoter' OR cvterm.name = 'RNApol_III_promoter_type_1' OR cvterm.name = 'RNApol_III_promoter_type_2' OR cvterm.name = 'RNApol_III_promoter_type_3' OR cvterm.name = 'bacterial_RNApol_promoter_sigma_70' OR cvterm.name = 'bacterial_RNApol_promoter_sigma54' OR cvterm.name = 'SP6_RNA_Polymerase_Promoter' OR cvterm.name = 'T3_RNA_Polymerase_Promoter' OR cvterm.name = 'T7_RNA_Polymerase_Promoter' OR cvterm.name = 'locus_control_region' OR cvterm.name = 'enhancer' OR cvterm.name = 'silencer' OR cvterm.name = 'enhancer_bound_by_factor' OR cvterm.name = 'shadow_enhancer' OR cvterm.name = 'splice_enhancer' OR cvterm.name = 'intronic_splice_enhancer' OR cvterm.name = 'exonic_splice_enhancer' OR cvterm.name = 'attenuator' OR cvterm.name = 'gene_member_region';

--- ************************************************
--- *** relation: transcript_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of a transcript.                ***
--- ************************************************
---

CREATE VIEW transcript_region AS
  SELECT
    feature_id AS transcript_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'exon' OR cvterm.name = 'edited_transcript_feature' OR cvterm.name = 'mature_transcript_region' OR cvterm.name = 'primary_transcript_region' OR cvterm.name = 'exon_region' OR cvterm.name = 'anchor_binding_site' OR cvterm.name = 'coding_exon' OR cvterm.name = 'noncoding_exon' OR cvterm.name = 'interior_exon' OR cvterm.name = 'exon_of_single_exon_gene' OR cvterm.name = 'interior_coding_exon' OR cvterm.name = 'five_prime_coding_exon' OR cvterm.name = 'three_prime_coding_exon' OR cvterm.name = 'three_prime_noncoding_exon' OR cvterm.name = 'five_prime_noncoding_exon' OR cvterm.name = 'pre_edited_region' OR cvterm.name = 'editing_block' OR cvterm.name = 'editing_domain' OR cvterm.name = 'unedited_region' OR cvterm.name = 'mRNA_region' OR cvterm.name = 'tmRNA_region' OR cvterm.name = 'guide_RNA_region' OR cvterm.name = 'tRNA_region' OR cvterm.name = 'riboswitch' OR cvterm.name = 'ribosome_entry_site' OR cvterm.name = 'UTR' OR cvterm.name = 'CDS' OR cvterm.name = 'five_prime_open_reading_frame' OR cvterm.name = 'UTR_region' OR cvterm.name = 'CDS_region' OR cvterm.name = 'translational_frameshift' OR cvterm.name = 'recoding_stimulatory_region' OR cvterm.name = 'internal_ribosome_entry_site' OR cvterm.name = 'Shine_Dalgarno_sequence' OR cvterm.name = 'kozak_sequence' OR cvterm.name = 'internal_Shine_Dalgarno_sequence' OR cvterm.name = 'five_prime_UTR' OR cvterm.name = 'three_prime_UTR' OR cvterm.name = 'internal_UTR' OR cvterm.name = 'untranslated_region_polycistronic_mRNA' OR cvterm.name = 'edited_CDS' OR cvterm.name = 'CDS_fragment' OR cvterm.name = 'CDS_independently_known' OR cvterm.name = 'CDS_predicted' OR cvterm.name = 'orphan_CDS' OR cvterm.name = 'CDS_supported_by_sequence_similarity_data' OR cvterm.name = 'CDS_supported_by_domain_match_data' OR cvterm.name = 'CDS_supported_by_EST_or_cDNA_data' OR cvterm.name = 'upstream_AUG_codon' OR cvterm.name = 'AU_rich_element' OR cvterm.name = 'Bruno_response_element' OR cvterm.name = 'iron_responsive_element' OR cvterm.name = 'coding_start' OR cvterm.name = 'coding_end' OR cvterm.name = 'codon' OR cvterm.name = 'recoded_codon' OR cvterm.name = 'start_codon' OR cvterm.name = 'stop_codon' OR cvterm.name = 'stop_codon_read_through' OR cvterm.name = 'stop_codon_redefined_as_pyrrolysine' OR cvterm.name = 'stop_codon_redefined_as_selenocysteine' OR cvterm.name = 'non_canonical_start_codon' OR cvterm.name = 'four_bp_start_codon' OR cvterm.name = 'CTG_start_codon' OR cvterm.name = 'plus_1_translational_frameshift' OR cvterm.name = 'plus_2_translational_frameshift' OR cvterm.name = 'internal_Shine_Dalgarno_sequence' OR cvterm.name = 'SECIS_element' OR cvterm.name = 'three_prime_recoding_site' OR cvterm.name = 'five_prime_recoding_site' OR cvterm.name = 'stop_codon_signal' OR cvterm.name = 'three_prime_stem_loop_structure' OR cvterm.name = 'flanking_three_prime_quadruplet_recoding_signal' OR cvterm.name = 'three_prime_repeat_recoding_signal' OR cvterm.name = 'distant_three_prime_recoding_signal' OR cvterm.name = 'UAG_stop_codon_signal' OR cvterm.name = 'UAA_stop_codon_signal' OR cvterm.name = 'UGA_stop_codon_signal' OR cvterm.name = 'tmRNA_coding_piece' OR cvterm.name = 'tmRNA_acceptor_piece' OR cvterm.name = 'anchor_region' OR cvterm.name = 'template_region' OR cvterm.name = 'anticodon_loop' OR cvterm.name = 'anticodon' OR cvterm.name = 'CCA_tail' OR cvterm.name = 'DHU_loop' OR cvterm.name = 'T_loop' OR cvterm.name = 'splice_site' OR cvterm.name = 'intron' OR cvterm.name = 'clip' OR cvterm.name = 'TSS' OR cvterm.name = 'transcription_end_site' OR cvterm.name = 'spliced_leader_RNA' OR cvterm.name = 'rRNA_primary_transcript_region' OR cvterm.name = 'spliceosomal_intron_region' OR cvterm.name = 'intron_domain' OR cvterm.name = 'miRNA_primary_transcript_region' OR cvterm.name = 'outron' OR cvterm.name = 'cis_splice_site' OR cvterm.name = 'trans_splice_site' OR cvterm.name = 'cryptic_splice_site' OR cvterm.name = 'five_prime_cis_splice_site' OR cvterm.name = 'three_prime_cis_splice_site' OR cvterm.name = 'recursive_splice_site' OR cvterm.name = 'canonical_five_prime_splice_site' OR cvterm.name = 'non_canonical_five_prime_splice_site' OR cvterm.name = 'canonical_three_prime_splice_site' OR cvterm.name = 'non_canonical_three_prime_splice_site' OR cvterm.name = 'trans_splice_acceptor_site' OR cvterm.name = 'trans_splice_donor_site' OR cvterm.name = 'SL1_acceptor_site' OR cvterm.name = 'SL2_acceptor_site' OR cvterm.name = 'SL3_acceptor_site' OR cvterm.name = 'SL4_acceptor_site' OR cvterm.name = 'SL5_acceptor_site' OR cvterm.name = 'SL6_acceptor_site' OR cvterm.name = 'SL7_acceptor_site' OR cvterm.name = 'SL8_acceptor_site' OR cvterm.name = 'SL9_acceptor_site' OR cvterm.name = 'SL10_accceptor_site' OR cvterm.name = 'SL11_acceptor_site' OR cvterm.name = 'SL12_acceptor_site' OR cvterm.name = 'five_prime_intron' OR cvterm.name = 'interior_intron' OR cvterm.name = 'three_prime_intron' OR cvterm.name = 'twintron' OR cvterm.name = 'UTR_intron' OR cvterm.name = 'autocatalytically_spliced_intron' OR cvterm.name = 'spliceosomal_intron' OR cvterm.name = 'mobile_intron' OR cvterm.name = 'endonuclease_spliced_intron' OR cvterm.name = 'five_prime_UTR_intron' OR cvterm.name = 'three_prime_UTR_intron' OR cvterm.name = 'group_I_intron' OR cvterm.name = 'group_II_intron' OR cvterm.name = 'group_III_intron' OR cvterm.name = 'group_IIA_intron' OR cvterm.name = 'group_IIB_intron' OR cvterm.name = 'U2_intron' OR cvterm.name = 'U12_intron' OR cvterm.name = 'archaeal_intron' OR cvterm.name = 'tRNA_intron' OR cvterm.name = 'five_prime_clip' OR cvterm.name = 'three_prime_clip' OR cvterm.name = 'major_TSS' OR cvterm.name = 'minor_TSS' OR cvterm.name = 'transcribed_spacer_region' OR cvterm.name = 'internal_transcribed_spacer_region' OR cvterm.name = 'external_transcribed_spacer_region' OR cvterm.name = 'intronic_splice_enhancer' OR cvterm.name = 'branch_site' OR cvterm.name = 'polypyrimidine_tract' OR cvterm.name = 'internal_guide_sequence' OR cvterm.name = 'mirtron' OR cvterm.name = 'pre_miRNA' OR cvterm.name = 'miRNA_stem' OR cvterm.name = 'miRNA_loop' OR cvterm.name = 'miRNA_antiguide' OR cvterm.name = 'noncoding_region_of_exon' OR cvterm.name = 'coding_region_of_exon' OR cvterm.name = 'three_prime_coding_exon_noncoding_region' OR cvterm.name = 'five_prime_coding_exon_noncoding_region' OR cvterm.name = 'five_prime_coding_exon_coding_region' OR cvterm.name = 'three_prime_coding_exon_coding_region' OR cvterm.name = 'transcript_region';

--- ************************************************
--- *** relation: mature_transcript_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of a mature transcript.         ***
--- ************************************************
---

CREATE VIEW mature_transcript_region AS
  SELECT
    feature_id AS mature_transcript_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mRNA_region' OR cvterm.name = 'tmRNA_region' OR cvterm.name = 'guide_RNA_region' OR cvterm.name = 'tRNA_region' OR cvterm.name = 'riboswitch' OR cvterm.name = 'ribosome_entry_site' OR cvterm.name = 'UTR' OR cvterm.name = 'CDS' OR cvterm.name = 'five_prime_open_reading_frame' OR cvterm.name = 'UTR_region' OR cvterm.name = 'CDS_region' OR cvterm.name = 'translational_frameshift' OR cvterm.name = 'recoding_stimulatory_region' OR cvterm.name = 'internal_ribosome_entry_site' OR cvterm.name = 'Shine_Dalgarno_sequence' OR cvterm.name = 'kozak_sequence' OR cvterm.name = 'internal_Shine_Dalgarno_sequence' OR cvterm.name = 'five_prime_UTR' OR cvterm.name = 'three_prime_UTR' OR cvterm.name = 'internal_UTR' OR cvterm.name = 'untranslated_region_polycistronic_mRNA' OR cvterm.name = 'edited_CDS' OR cvterm.name = 'CDS_fragment' OR cvterm.name = 'CDS_independently_known' OR cvterm.name = 'CDS_predicted' OR cvterm.name = 'orphan_CDS' OR cvterm.name = 'CDS_supported_by_sequence_similarity_data' OR cvterm.name = 'CDS_supported_by_domain_match_data' OR cvterm.name = 'CDS_supported_by_EST_or_cDNA_data' OR cvterm.name = 'upstream_AUG_codon' OR cvterm.name = 'AU_rich_element' OR cvterm.name = 'Bruno_response_element' OR cvterm.name = 'iron_responsive_element' OR cvterm.name = 'coding_start' OR cvterm.name = 'coding_end' OR cvterm.name = 'codon' OR cvterm.name = 'recoded_codon' OR cvterm.name = 'start_codon' OR cvterm.name = 'stop_codon' OR cvterm.name = 'stop_codon_read_through' OR cvterm.name = 'stop_codon_redefined_as_pyrrolysine' OR cvterm.name = 'stop_codon_redefined_as_selenocysteine' OR cvterm.name = 'non_canonical_start_codon' OR cvterm.name = 'four_bp_start_codon' OR cvterm.name = 'CTG_start_codon' OR cvterm.name = 'plus_1_translational_frameshift' OR cvterm.name = 'plus_2_translational_frameshift' OR cvterm.name = 'internal_Shine_Dalgarno_sequence' OR cvterm.name = 'SECIS_element' OR cvterm.name = 'three_prime_recoding_site' OR cvterm.name = 'five_prime_recoding_site' OR cvterm.name = 'stop_codon_signal' OR cvterm.name = 'three_prime_stem_loop_structure' OR cvterm.name = 'flanking_three_prime_quadruplet_recoding_signal' OR cvterm.name = 'three_prime_repeat_recoding_signal' OR cvterm.name = 'distant_three_prime_recoding_signal' OR cvterm.name = 'UAG_stop_codon_signal' OR cvterm.name = 'UAA_stop_codon_signal' OR cvterm.name = 'UGA_stop_codon_signal' OR cvterm.name = 'tmRNA_coding_piece' OR cvterm.name = 'tmRNA_acceptor_piece' OR cvterm.name = 'anchor_region' OR cvterm.name = 'template_region' OR cvterm.name = 'anticodon_loop' OR cvterm.name = 'anticodon' OR cvterm.name = 'CCA_tail' OR cvterm.name = 'DHU_loop' OR cvterm.name = 'T_loop' OR cvterm.name = 'mature_transcript_region';

--- ************************************************
--- *** relation: primary_transcript_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A part of a primary transcript.          ***
--- ************************************************
---

CREATE VIEW primary_transcript_region AS
  SELECT
    feature_id AS primary_transcript_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'splice_site' OR cvterm.name = 'intron' OR cvterm.name = 'clip' OR cvterm.name = 'TSS' OR cvterm.name = 'transcription_end_site' OR cvterm.name = 'spliced_leader_RNA' OR cvterm.name = 'rRNA_primary_transcript_region' OR cvterm.name = 'spliceosomal_intron_region' OR cvterm.name = 'intron_domain' OR cvterm.name = 'miRNA_primary_transcript_region' OR cvterm.name = 'outron' OR cvterm.name = 'cis_splice_site' OR cvterm.name = 'trans_splice_site' OR cvterm.name = 'cryptic_splice_site' OR cvterm.name = 'five_prime_cis_splice_site' OR cvterm.name = 'three_prime_cis_splice_site' OR cvterm.name = 'recursive_splice_site' OR cvterm.name = 'canonical_five_prime_splice_site' OR cvterm.name = 'non_canonical_five_prime_splice_site' OR cvterm.name = 'canonical_three_prime_splice_site' OR cvterm.name = 'non_canonical_three_prime_splice_site' OR cvterm.name = 'trans_splice_acceptor_site' OR cvterm.name = 'trans_splice_donor_site' OR cvterm.name = 'SL1_acceptor_site' OR cvterm.name = 'SL2_acceptor_site' OR cvterm.name = 'SL3_acceptor_site' OR cvterm.name = 'SL4_acceptor_site' OR cvterm.name = 'SL5_acceptor_site' OR cvterm.name = 'SL6_acceptor_site' OR cvterm.name = 'SL7_acceptor_site' OR cvterm.name = 'SL8_acceptor_site' OR cvterm.name = 'SL9_acceptor_site' OR cvterm.name = 'SL10_accceptor_site' OR cvterm.name = 'SL11_acceptor_site' OR cvterm.name = 'SL12_acceptor_site' OR cvterm.name = 'five_prime_intron' OR cvterm.name = 'interior_intron' OR cvterm.name = 'three_prime_intron' OR cvterm.name = 'twintron' OR cvterm.name = 'UTR_intron' OR cvterm.name = 'autocatalytically_spliced_intron' OR cvterm.name = 'spliceosomal_intron' OR cvterm.name = 'mobile_intron' OR cvterm.name = 'endonuclease_spliced_intron' OR cvterm.name = 'five_prime_UTR_intron' OR cvterm.name = 'three_prime_UTR_intron' OR cvterm.name = 'group_I_intron' OR cvterm.name = 'group_II_intron' OR cvterm.name = 'group_III_intron' OR cvterm.name = 'group_IIA_intron' OR cvterm.name = 'group_IIB_intron' OR cvterm.name = 'U2_intron' OR cvterm.name = 'U12_intron' OR cvterm.name = 'archaeal_intron' OR cvterm.name = 'tRNA_intron' OR cvterm.name = 'five_prime_clip' OR cvterm.name = 'three_prime_clip' OR cvterm.name = 'major_TSS' OR cvterm.name = 'minor_TSS' OR cvterm.name = 'transcribed_spacer_region' OR cvterm.name = 'internal_transcribed_spacer_region' OR cvterm.name = 'external_transcribed_spacer_region' OR cvterm.name = 'intronic_splice_enhancer' OR cvterm.name = 'branch_site' OR cvterm.name = 'polypyrimidine_tract' OR cvterm.name = 'internal_guide_sequence' OR cvterm.name = 'mirtron' OR cvterm.name = 'pre_miRNA' OR cvterm.name = 'miRNA_stem' OR cvterm.name = 'miRNA_loop' OR cvterm.name = 'miRNA_antiguide' OR cvterm.name = 'primary_transcript_region';

--- ************************************************
--- *** relation: mrna_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of an mRNA.                     ***
--- ************************************************
---

CREATE VIEW mrna_region AS
  SELECT
    feature_id AS mrna_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'riboswitch' OR cvterm.name = 'ribosome_entry_site' OR cvterm.name = 'UTR' OR cvterm.name = 'CDS' OR cvterm.name = 'five_prime_open_reading_frame' OR cvterm.name = 'UTR_region' OR cvterm.name = 'CDS_region' OR cvterm.name = 'translational_frameshift' OR cvterm.name = 'recoding_stimulatory_region' OR cvterm.name = 'internal_ribosome_entry_site' OR cvterm.name = 'Shine_Dalgarno_sequence' OR cvterm.name = 'kozak_sequence' OR cvterm.name = 'internal_Shine_Dalgarno_sequence' OR cvterm.name = 'five_prime_UTR' OR cvterm.name = 'three_prime_UTR' OR cvterm.name = 'internal_UTR' OR cvterm.name = 'untranslated_region_polycistronic_mRNA' OR cvterm.name = 'edited_CDS' OR cvterm.name = 'CDS_fragment' OR cvterm.name = 'CDS_independently_known' OR cvterm.name = 'CDS_predicted' OR cvterm.name = 'orphan_CDS' OR cvterm.name = 'CDS_supported_by_sequence_similarity_data' OR cvterm.name = 'CDS_supported_by_domain_match_data' OR cvterm.name = 'CDS_supported_by_EST_or_cDNA_data' OR cvterm.name = 'upstream_AUG_codon' OR cvterm.name = 'AU_rich_element' OR cvterm.name = 'Bruno_response_element' OR cvterm.name = 'iron_responsive_element' OR cvterm.name = 'coding_start' OR cvterm.name = 'coding_end' OR cvterm.name = 'codon' OR cvterm.name = 'recoded_codon' OR cvterm.name = 'start_codon' OR cvterm.name = 'stop_codon' OR cvterm.name = 'stop_codon_read_through' OR cvterm.name = 'stop_codon_redefined_as_pyrrolysine' OR cvterm.name = 'stop_codon_redefined_as_selenocysteine' OR cvterm.name = 'non_canonical_start_codon' OR cvterm.name = 'four_bp_start_codon' OR cvterm.name = 'CTG_start_codon' OR cvterm.name = 'plus_1_translational_frameshift' OR cvterm.name = 'plus_2_translational_frameshift' OR cvterm.name = 'internal_Shine_Dalgarno_sequence' OR cvterm.name = 'SECIS_element' OR cvterm.name = 'three_prime_recoding_site' OR cvterm.name = 'five_prime_recoding_site' OR cvterm.name = 'stop_codon_signal' OR cvterm.name = 'three_prime_stem_loop_structure' OR cvterm.name = 'flanking_three_prime_quadruplet_recoding_signal' OR cvterm.name = 'three_prime_repeat_recoding_signal' OR cvterm.name = 'distant_three_prime_recoding_signal' OR cvterm.name = 'UAG_stop_codon_signal' OR cvterm.name = 'UAA_stop_codon_signal' OR cvterm.name = 'UGA_stop_codon_signal' OR cvterm.name = 'mRNA_region';

--- ************************************************
--- *** relation: utr_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of UTR.                         ***
--- ************************************************
---

CREATE VIEW utr_region AS
  SELECT
    feature_id AS utr_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'upstream_AUG_codon' OR cvterm.name = 'AU_rich_element' OR cvterm.name = 'Bruno_response_element' OR cvterm.name = 'iron_responsive_element' OR cvterm.name = 'UTR_region';

--- ************************************************
--- *** relation: rrna_primary_transcript_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of an rRNA primary transcript.  ***
--- ************************************************
---

CREATE VIEW rrna_primary_transcript_region AS
  SELECT
    feature_id AS rrna_primary_transcript_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transcribed_spacer_region' OR cvterm.name = 'internal_transcribed_spacer_region' OR cvterm.name = 'external_transcribed_spacer_region' OR cvterm.name = 'rRNA_primary_transcript_region';

--- ************************************************
--- *** relation: polypeptide_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Biological sequence region that can be a ***
--- *** ssigned to a specific subsequence of a p ***
--- *** olypeptide.                              ***
--- ************************************************
---

CREATE VIEW polypeptide_region AS
  SELECT
    feature_id AS polypeptide_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mature_protein_region' OR cvterm.name = 'immature_peptide_region' OR cvterm.name = 'compositionally_biased_region_of_peptide' OR cvterm.name = 'polypeptide_structural_region' OR cvterm.name = 'polypeptide_variation_site' OR cvterm.name = 'peptide_localization_signal' OR cvterm.name = 'cleaved_peptide_region' OR cvterm.name = 'hydrophobic_region_of_peptide' OR cvterm.name = 'polypeptide_conserved_region' OR cvterm.name = 'active_peptide' OR cvterm.name = 'polypeptide_domain' OR cvterm.name = 'membrane_structure' OR cvterm.name = 'extramembrane_polypeptide_region' OR cvterm.name = 'intramembrane_polypeptide_region' OR cvterm.name = 'polypeptide_secondary_structure' OR cvterm.name = 'polypeptide_structural_motif' OR cvterm.name = 'intrinsically_unstructured_polypeptide_region' OR cvterm.name = 'cytoplasmic_polypeptide_region' OR cvterm.name = 'non_cytoplasmic_polypeptide_region' OR cvterm.name = 'membrane_peptide_loop' OR cvterm.name = 'transmembrane_polypeptide_region' OR cvterm.name = 'asx_motif' OR cvterm.name = 'beta_bulge' OR cvterm.name = 'beta_bulge_loop' OR cvterm.name = 'beta_strand' OR cvterm.name = 'peptide_helix' OR cvterm.name = 'polypeptide_nest_motif' OR cvterm.name = 'schellmann_loop' OR cvterm.name = 'serine_threonine_motif' OR cvterm.name = 'serine_threonine_staple_motif' OR cvterm.name = 'polypeptide_turn_motif' OR cvterm.name = 'catmat_left_handed_three' OR cvterm.name = 'catmat_left_handed_four' OR cvterm.name = 'catmat_right_handed_three' OR cvterm.name = 'catmat_right_handed_four' OR cvterm.name = 'alpha_beta_motif' OR cvterm.name = 'peptide_coil' OR cvterm.name = 'beta_bulge_loop_five' OR cvterm.name = 'beta_bulge_loop_six' OR cvterm.name = 'antiparallel_beta_strand' OR cvterm.name = 'parallel_beta_strand' OR cvterm.name = 'left_handed_peptide_helix' OR cvterm.name = 'right_handed_peptide_helix' OR cvterm.name = 'alpha_helix' OR cvterm.name = 'pi_helix' OR cvterm.name = 'three_ten_helix' OR cvterm.name = 'polypeptide_nest_left_right_motif' OR cvterm.name = 'polypeptide_nest_right_left_motif' OR cvterm.name = 'schellmann_loop_seven' OR cvterm.name = 'schellmann_loop_six' OR cvterm.name = 'asx_turn' OR cvterm.name = 'beta_turn' OR cvterm.name = 'gamma_turn' OR cvterm.name = 'serine_threonine_turn' OR cvterm.name = 'asx_turn_left_handed_type_one' OR cvterm.name = 'asx_turn_left_handed_type_two' OR cvterm.name = 'asx_turn_right_handed_type_two' OR cvterm.name = 'asx_turn_right_handed_type_one' OR cvterm.name = 'beta_turn_left_handed_type_one' OR cvterm.name = 'beta_turn_left_handed_type_two' OR cvterm.name = 'beta_turn_right_handed_type_one' OR cvterm.name = 'beta_turn_right_handed_type_two' OR cvterm.name = 'beta_turn_type_six' OR cvterm.name = 'beta_turn_type_eight' OR cvterm.name = 'beta_turn_type_six_a' OR cvterm.name = 'beta_turn_type_six_b' OR cvterm.name = 'beta_turn_type_six_a_one' OR cvterm.name = 'beta_turn_type_six_a_two' OR cvterm.name = 'gamma_turn_classic' OR cvterm.name = 'gamma_turn_inverse' OR cvterm.name = 'st_turn_left_handed_type_one' OR cvterm.name = 'st_turn_left_handed_type_two' OR cvterm.name = 'st_turn_right_handed_type_one' OR cvterm.name = 'st_turn_right_handed_type_two' OR cvterm.name = 'coiled_coil' OR cvterm.name = 'helix_turn_helix' OR cvterm.name = 'natural_variant_site' OR cvterm.name = 'mutated_variant_site' OR cvterm.name = 'alternate_sequence_site' OR cvterm.name = 'signal_peptide' OR cvterm.name = 'transit_peptide' OR cvterm.name = 'nuclear_localization_signal' OR cvterm.name = 'endosomal_localization_signal' OR cvterm.name = 'lysosomal_localization_signal' OR cvterm.name = 'nuclear_export_signal' OR cvterm.name = 'nuclear_rim_localization_signal' OR cvterm.name = 'cleaved_initiator_methionine' OR cvterm.name = 'intein' OR cvterm.name = 'propeptide_cleavage_site' OR cvterm.name = 'propeptide' OR cvterm.name = 'cleaved_for_gpi_anchor_region' OR cvterm.name = 'lipoprotein_signal_peptide' OR cvterm.name = 'n_terminal_region' OR cvterm.name = 'c_terminal_region' OR cvterm.name = 'central_hydrophobic_region_of_signal_peptide' OR cvterm.name = 'polypeptide_domain' OR cvterm.name = 'polypeptide_motif' OR cvterm.name = 'polypeptide_repeat' OR cvterm.name = 'biochemical_region_of_peptide' OR cvterm.name = 'polypeptide_conserved_motif' OR cvterm.name = 'post_translationally_modified_region' OR cvterm.name = 'conformational_switch' OR cvterm.name = 'molecular_contact_region' OR cvterm.name = 'polypeptide_binding_motif' OR cvterm.name = 'polypeptide_catalytic_motif' OR cvterm.name = 'histone_modification' OR cvterm.name = 'histone_methylation_site' OR cvterm.name = 'histone_acetylation_site' OR cvterm.name = 'histone_ubiqitination_site' OR cvterm.name = 'histone_acylation_region' OR cvterm.name = 'H4K20_monomethylation_site' OR cvterm.name = 'H2BK5_monomethylation_site' OR cvterm.name = 'H3K27_methylation_site' OR cvterm.name = 'H3K36_methylation_site' OR cvterm.name = 'H3K4_methylation_site' OR cvterm.name = 'H3K79_methylation_site' OR cvterm.name = 'H3K9_methylation_site' OR cvterm.name = 'H3K27_monomethylation_site' OR cvterm.name = 'H3K27_trimethylation_site' OR cvterm.name = 'H3K27_dimethylation_site' OR cvterm.name = 'H3K36_monomethylation_site' OR cvterm.name = 'H3K36_dimethylation_site' OR cvterm.name = 'H3K36_trimethylation_site' OR cvterm.name = 'H3K4_monomethylation_site' OR cvterm.name = 'H3K4_trimethylation' OR cvterm.name = 'H3K4_dimethylation_site' OR cvterm.name = 'H3K79_monomethylation_site' OR cvterm.name = 'H3K79_dimethylation_site' OR cvterm.name = 'H3K79_trimethylation_site' OR cvterm.name = 'H3K9_trimethylation_site' OR cvterm.name = 'H3K9_monomethylation_site' OR cvterm.name = 'H3K9_dimethylation_site' OR cvterm.name = 'H3K9_acetylation_site' OR cvterm.name = 'H3K14_acetylation_site' OR cvterm.name = 'H3K18_acetylation_site' OR cvterm.name = 'H3K23_acylation site' OR cvterm.name = 'H3K27_acylation_site' OR cvterm.name = 'H4K16_acylation_site' OR cvterm.name = 'H4K5_acylation_site' OR cvterm.name = 'H4K8_acylation site' OR cvterm.name = 'H2B_ubiquitination_site' OR cvterm.name = 'H4K_acylation_region' OR cvterm.name = 'polypeptide_metal_contact' OR cvterm.name = 'protein_protein_contact' OR cvterm.name = 'polypeptide_ligand_contact' OR cvterm.name = 'polypeptide_DNA_contact' OR cvterm.name = 'polypeptide_calcium_ion_contact_site' OR cvterm.name = 'polypeptide_cobalt_ion_contact_site' OR cvterm.name = 'polypeptide_copper_ion_contact_site' OR cvterm.name = 'polypeptide_iron_ion_contact_site' OR cvterm.name = 'polypeptide_magnesium_ion_contact_site' OR cvterm.name = 'polypeptide_manganese_ion_contact_site' OR cvterm.name = 'polypeptide_molybdenum_ion_contact_site' OR cvterm.name = 'polypeptide_nickel_ion_contact_site' OR cvterm.name = 'polypeptide_tungsten_ion_contact_site' OR cvterm.name = 'polypeptide_zinc_ion_contact_site' OR cvterm.name = 'polypeptide_region';

--- ************************************************
--- *** relation: repeat_component ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of a repeated sequence.         ***
--- ************************************************
---

CREATE VIEW repeat_component AS
  SELECT
    feature_id AS repeat_component_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'non_LTR_retrotransposon_polymeric_tract' OR cvterm.name = 'LTR_component' OR cvterm.name = 'repeat_fragment' OR cvterm.name = 'transposon_fragment' OR cvterm.name = 'U5_LTR_region' OR cvterm.name = 'R_LTR_region' OR cvterm.name = 'U3_LTR_region' OR cvterm.name = 'three_prime_LTR_component' OR cvterm.name = 'five_prime_LTR_component' OR cvterm.name = 'U5_five_prime_LTR_region' OR cvterm.name = 'R_five_prime_LTR_region' OR cvterm.name = 'U3_five_prime_LTR_region' OR cvterm.name = 'R_three_prime_LTR_region' OR cvterm.name = 'U3_three_prime_LTR_region' OR cvterm.name = 'U5_three_prime_LTR_region' OR cvterm.name = 'R_five_prime_LTR_region' OR cvterm.name = 'U5_five_prime_LTR_region' OR cvterm.name = 'U3_five_prime_LTR_region' OR cvterm.name = 'repeat_component';

--- ************************************************
--- *** relation: spliceosomal_intron_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region within an intron.               ***
--- ************************************************
---

CREATE VIEW spliceosomal_intron_region AS
  SELECT
    feature_id AS spliceosomal_intron_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'intronic_splice_enhancer' OR cvterm.name = 'branch_site' OR cvterm.name = 'polypyrimidine_tract' OR cvterm.name = 'spliceosomal_intron_region';

--- ************************************************
--- *** relation: gene_component_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW gene_component_region AS
  SELECT
    feature_id AS gene_component_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'non_transcribed_region' OR cvterm.name = 'gene_fragment' OR cvterm.name = 'TSS_region' OR cvterm.name = 'gene_segment' OR cvterm.name = 'pseudogenic_gene_segment' OR cvterm.name = 'gene_component_region';

--- ************************************************
--- *** relation: tmrna_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of a tmRNA.                     ***
--- ************************************************
---

CREATE VIEW tmrna_region AS
  SELECT
    feature_id AS tmrna_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tmRNA_coding_piece' OR cvterm.name = 'tmRNA_acceptor_piece' OR cvterm.name = 'tmRNA_region';

--- ************************************************
--- *** relation: ltr_component ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW ltr_component AS
  SELECT
    feature_id AS ltr_component_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U5_LTR_region' OR cvterm.name = 'R_LTR_region' OR cvterm.name = 'U3_LTR_region' OR cvterm.name = 'three_prime_LTR_component' OR cvterm.name = 'five_prime_LTR_component' OR cvterm.name = 'U5_five_prime_LTR_region' OR cvterm.name = 'R_five_prime_LTR_region' OR cvterm.name = 'U3_five_prime_LTR_region' OR cvterm.name = 'R_three_prime_LTR_region' OR cvterm.name = 'U3_three_prime_LTR_region' OR cvterm.name = 'U5_three_prime_LTR_region' OR cvterm.name = 'R_five_prime_LTR_region' OR cvterm.name = 'U5_five_prime_LTR_region' OR cvterm.name = 'U3_five_prime_LTR_region' OR cvterm.name = 'LTR_component';

--- ************************************************
--- *** relation: three_prime_ltr_component ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW three_prime_ltr_component AS
  SELECT
    feature_id AS three_prime_ltr_component_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'R_three_prime_LTR_region' OR cvterm.name = 'U3_three_prime_LTR_region' OR cvterm.name = 'U5_three_prime_LTR_region' OR cvterm.name = 'three_prime_LTR_component';

--- ************************************************
--- *** relation: five_prime_ltr_component ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW five_prime_ltr_component AS
  SELECT
    feature_id AS five_prime_ltr_component_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'R_five_prime_LTR_region' OR cvterm.name = 'U5_five_prime_LTR_region' OR cvterm.name = 'U3_five_prime_LTR_region' OR cvterm.name = 'five_prime_LTR_component';

--- ************************************************
--- *** relation: cds_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of a CDS.                       ***
--- ************************************************
---

CREATE VIEW cds_region AS
  SELECT
    feature_id AS cds_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'coding_start' OR cvterm.name = 'coding_end' OR cvterm.name = 'codon' OR cvterm.name = 'recoded_codon' OR cvterm.name = 'start_codon' OR cvterm.name = 'stop_codon' OR cvterm.name = 'stop_codon_read_through' OR cvterm.name = 'stop_codon_redefined_as_pyrrolysine' OR cvterm.name = 'stop_codon_redefined_as_selenocysteine' OR cvterm.name = 'non_canonical_start_codon' OR cvterm.name = 'four_bp_start_codon' OR cvterm.name = 'CTG_start_codon' OR cvterm.name = 'CDS_region';

--- ************************************************
--- *** relation: exon_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of an exon.                     ***
--- ************************************************
---

CREATE VIEW exon_region AS
  SELECT
    feature_id AS exon_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'noncoding_region_of_exon' OR cvterm.name = 'coding_region_of_exon' OR cvterm.name = 'three_prime_coding_exon_noncoding_region' OR cvterm.name = 'five_prime_coding_exon_noncoding_region' OR cvterm.name = 'five_prime_coding_exon_coding_region' OR cvterm.name = 'three_prime_coding_exon_coding_region' OR cvterm.name = 'exon_region';

--- ************************************************
--- *** relation: homologous_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region that is homologous to another r ***
--- *** egion.                                   ***
--- ************************************************
---

CREATE VIEW homologous_region AS
  SELECT
    feature_id AS homologous_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'paralogous_region' OR cvterm.name = 'orthologous_region' OR cvterm.name = 'homologous_region';

--- ************************************************
--- *** relation: paralogous_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A homologous_region that is paralogous t ***
--- *** o another region.                        ***
--- ************************************************
---

CREATE VIEW paralogous_region AS
  SELECT
    feature_id AS paralogous_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'paralogous_region';

--- ************************************************
--- *** relation: orthologous_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A homologous_region that is orthologous  ***
--- *** to another region.                       ***
--- ************************************************
---

CREATE VIEW orthologous_region AS
  SELECT
    feature_id AS orthologous_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'orthologous_region';

--- ************************************************
--- *** relation: conserved ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW conserved AS
  SELECT
    feature_id AS conserved_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'homologous' OR cvterm.name = 'syntenic' OR cvterm.name = 'orthologous' OR cvterm.name = 'paralogous' OR cvterm.name = 'conserved';

--- ************************************************
--- *** relation: homologous ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Similarity due to common ancestry.       ***
--- ************************************************
---

CREATE VIEW homologous AS
  SELECT
    feature_id AS homologous_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'orthologous' OR cvterm.name = 'paralogous' OR cvterm.name = 'homologous';

--- ************************************************
--- *** relation: orthologous ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a kind of homolo ***
--- *** gy where divergence occured after a spec ***
--- *** iation event.                            ***
--- ************************************************
---

CREATE VIEW orthologous AS
  SELECT
    feature_id AS orthologous_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'orthologous';

--- ************************************************
--- *** relation: paralogous ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a kind of homolo ***
--- *** gy where divergence occurred after a dup ***
--- *** lication event.                          ***
--- ************************************************
---

CREATE VIEW paralogous AS
  SELECT
    feature_id AS paralogous_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'paralogous';

--- ************************************************
--- *** relation: syntenic ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Attribute describing sequence regions oc ***
--- *** curring in same order on chromosome of d ***
--- *** ifferent species.                        ***
--- ************************************************
---

CREATE VIEW syntenic AS
  SELECT
    feature_id AS syntenic_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'syntenic';

--- ************************************************
--- *** relation: capped_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript that is capped.     ***
--- ************************************************
---

CREATE VIEW capped_primary_transcript AS
  SELECT
    feature_id AS capped_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'capped_primary_transcript';

--- ************************************************
--- *** relation: capped_mrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An mRNA that is capped.                  ***
--- ************************************************
---

CREATE VIEW capped_mrna AS
  SELECT
    feature_id AS capped_mrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'capped_mRNA';

--- ************************************************
--- *** relation: mrna_attribute ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing an mRNA feature. ***
--- ************************************************
---

CREATE VIEW mrna_attribute AS
  SELECT
    feature_id AS mrna_attribute_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polyadenylated' OR cvterm.name = 'exemplar' OR cvterm.name = 'frameshift' OR cvterm.name = 'recoded' OR cvterm.name = 'minus_1_frameshift' OR cvterm.name = 'minus_2_frameshift' OR cvterm.name = 'plus_1_frameshift' OR cvterm.name = 'plus_2_framshift' OR cvterm.name = 'codon_redefined' OR cvterm.name = 'recoded_by_translational_bypass' OR cvterm.name = 'translationally_frameshifted' OR cvterm.name = 'minus_1_translationally_frameshifted' OR cvterm.name = 'plus_1_translationally_frameshifted' OR cvterm.name = 'mRNA_attribute';

--- ************************************************
--- *** relation: exemplar ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence is re ***
--- *** presentative of a class of similar seque ***
--- *** nces.                                    ***
--- ************************************************
---

CREATE VIEW exemplar AS
  SELECT
    feature_id AS exemplar_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'exemplar';

--- ************************************************
--- *** relation: frameshift ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence that  ***
--- *** contains a mutation involving the deleti ***
--- *** on or insertion of one or more bases, wh ***
--- *** ere this number is not divisible by 3.   ***
--- ************************************************
---

CREATE VIEW frameshift AS
  SELECT
    feature_id AS frameshift_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'minus_1_frameshift' OR cvterm.name = 'minus_2_frameshift' OR cvterm.name = 'plus_1_frameshift' OR cvterm.name = 'plus_2_framshift' OR cvterm.name = 'frameshift';

--- ************************************************
--- *** relation: minus_1_frameshift ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A frameshift caused by deleting one base ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW minus_1_frameshift AS
  SELECT
    feature_id AS minus_1_frameshift_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'minus_1_frameshift';

--- ************************************************
--- *** relation: minus_2_frameshift ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A frameshift caused by deleting two base ***
--- *** s.                                       ***
--- ************************************************
---

CREATE VIEW minus_2_frameshift AS
  SELECT
    feature_id AS minus_2_frameshift_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'minus_2_frameshift';

--- ************************************************
--- *** relation: plus_1_frameshift ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A frameshift caused by inserting one bas ***
--- *** e.                                       ***
--- ************************************************
---

CREATE VIEW plus_1_frameshift AS
  SELECT
    feature_id AS plus_1_frameshift_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'plus_1_frameshift';

--- ************************************************
--- *** relation: plus_2_framshift ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A frameshift caused by inserting two bas ***
--- *** es.                                      ***
--- ************************************************
---

CREATE VIEW plus_2_framshift AS
  SELECT
    feature_id AS plus_2_framshift_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'plus_2_framshift';

--- ************************************************
--- *** relation: trans_spliced ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing transcript seque ***
--- *** nce that is created by splicing exons fr ***
--- *** om diferent genes.                       ***
--- ************************************************
---

CREATE VIEW trans_spliced AS
  SELECT
    feature_id AS trans_spliced_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'trans_spliced';

--- ************************************************
--- *** relation: polyadenylated_mrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An mRNA that is polyadenylated.          ***
--- ************************************************
---

CREATE VIEW polyadenylated_mrna AS
  SELECT
    feature_id AS polyadenylated_mrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polyadenylated_mRNA';

--- ************************************************
--- *** relation: trans_spliced_mrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An mRNA that is trans-spliced.           ***
--- ************************************************
---

CREATE VIEW trans_spliced_mrna AS
  SELECT
    feature_id AS trans_spliced_mrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'trans_spliced_mRNA';

--- ************************************************
--- *** relation: edited_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transcript that is edited.             ***
--- ************************************************
---

CREATE VIEW edited_transcript AS
  SELECT
    feature_id AS edited_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'edited_transcript_by_A_to_I_substitution' OR cvterm.name = 'edited_mRNA' OR cvterm.name = 'edited_transcript';

--- ************************************************
--- *** relation: edited_transcript_by_a_to_i_substitution ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transcript that has been edited by A t ***
--- *** o I substitution.                        ***
--- ************************************************
---

CREATE VIEW edited_transcript_by_a_to_i_substitution AS
  SELECT
    feature_id AS edited_transcript_by_a_to_i_substitution_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'edited_transcript_by_A_to_I_substitution';

--- ************************************************
--- *** relation: bound_by_protein ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence that  ***
--- *** is bound by a protein.                   ***
--- ************************************************
---

CREATE VIEW bound_by_protein AS
  SELECT
    feature_id AS bound_by_protein_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'bound_by_protein';

--- ************************************************
--- *** relation: bound_by_nucleic_acid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence that  ***
--- *** is bound by a nucleic acid.              ***
--- ************************************************
---

CREATE VIEW bound_by_nucleic_acid AS
  SELECT
    feature_id AS bound_by_nucleic_acid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'bound_by_nucleic_acid';

--- ************************************************
--- *** relation: alternatively_spliced ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a situation wher ***
--- *** e a gene may encode for more than 1 tran ***
--- *** script.                                  ***
--- ************************************************
---

CREATE VIEW alternatively_spliced AS
  SELECT
    feature_id AS alternatively_spliced_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'alternatively_spliced';

--- ************************************************
--- *** relation: monocistronic ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence that  ***
--- *** contains the code for one gene product.  ***
--- ************************************************
---

CREATE VIEW monocistronic AS
  SELECT
    feature_id AS monocistronic_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'monocistronic';

--- ************************************************
--- *** relation: dicistronic ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence that  ***
--- *** contains the code for two gene products. ***
--- ************************************************
---

CREATE VIEW dicistronic AS
  SELECT
    feature_id AS dicistronic_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'dicistronic';

--- ************************************************
--- *** relation: polycistronic ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence that  ***
--- *** contains the code for more than one gene ***
--- ***  product.                                ***
--- ************************************************
---

CREATE VIEW polycistronic AS
  SELECT
    feature_id AS polycistronic_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'dicistronic' OR cvterm.name = 'polycistronic';

--- ************************************************
--- *** relation: recoded ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing an mRNA sequence ***
--- ***  that has been reprogrammed at translati ***
--- *** on, causing localized alterations.       ***
--- ************************************************
---

CREATE VIEW recoded AS
  SELECT
    feature_id AS recoded_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'codon_redefined' OR cvterm.name = 'recoded_by_translational_bypass' OR cvterm.name = 'translationally_frameshifted' OR cvterm.name = 'minus_1_translationally_frameshifted' OR cvterm.name = 'plus_1_translationally_frameshifted' OR cvterm.name = 'recoded';

--- ************************************************
--- *** relation: codon_redefined ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing the alteration o ***
--- *** f codon meaning.                         ***
--- ************************************************
---

CREATE VIEW codon_redefined AS
  SELECT
    feature_id AS codon_redefined_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'codon_redefined';

--- ************************************************
--- *** relation: stop_codon_read_through ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A stop codon redefined to be a new amino ***
--- ***  acid.                                   ***
--- ************************************************
---

CREATE VIEW stop_codon_read_through AS
  SELECT
    feature_id AS stop_codon_read_through_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'stop_codon_redefined_as_pyrrolysine' OR cvterm.name = 'stop_codon_redefined_as_selenocysteine' OR cvterm.name = 'stop_codon_read_through';

--- ************************************************
--- *** relation: stop_codon_redefined_as_pyrrolysine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A stop codon redefined to be the new ami ***
--- *** no acid, pyrrolysine.                    ***
--- ************************************************
---

CREATE VIEW stop_codon_redefined_as_pyrrolysine AS
  SELECT
    feature_id AS stop_codon_redefined_as_pyrrolysine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'stop_codon_redefined_as_pyrrolysine';

--- ************************************************
--- *** relation: stop_codon_redefined_as_selenocysteine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A stop codon redefined to be the new ami ***
--- *** no acid, selenocysteine.                 ***
--- ************************************************
---

CREATE VIEW stop_codon_redefined_as_selenocysteine AS
  SELECT
    feature_id AS stop_codon_redefined_as_selenocysteine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'stop_codon_redefined_as_selenocysteine';

--- ************************************************
--- *** relation: recoded_by_translational_bypass ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Recoded mRNA where a block of nucleotide ***
--- *** s is not translated.                     ***
--- ************************************************
---

CREATE VIEW recoded_by_translational_bypass AS
  SELECT
    feature_id AS recoded_by_translational_bypass_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'recoded_by_translational_bypass';

--- ************************************************
--- *** relation: translationally_frameshifted ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Recoding by frameshifting a particular s ***
--- *** ite.                                     ***
--- ************************************************
---

CREATE VIEW translationally_frameshifted AS
  SELECT
    feature_id AS translationally_frameshifted_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'minus_1_translationally_frameshifted' OR cvterm.name = 'plus_1_translationally_frameshifted' OR cvterm.name = 'translationally_frameshifted';

--- ************************************************
--- *** relation: maternally_imprinted_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that is maternally_imprinted.     ***
--- ************************************************
---

CREATE VIEW maternally_imprinted_gene AS
  SELECT
    feature_id AS maternally_imprinted_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'maternally_imprinted_gene';

--- ************************************************
--- *** relation: paternally_imprinted_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that is paternally imprinted.     ***
--- ************************************************
---

CREATE VIEW paternally_imprinted_gene AS
  SELECT
    feature_id AS paternally_imprinted_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'paternally_imprinted_gene';

--- ************************************************
--- *** relation: post_translationally_regulated_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that is post translationally regu ***
--- *** lated.                                   ***
--- ************************************************
---

CREATE VIEW post_translationally_regulated_gene AS
  SELECT
    feature_id AS post_translationally_regulated_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'post_translationally_regulated_gene';

--- ************************************************
--- *** relation: negatively_autoregulated_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that is negatively autoreguated.  ***
--- ************************************************
---

CREATE VIEW negatively_autoregulated_gene AS
  SELECT
    feature_id AS negatively_autoregulated_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'negatively_autoregulated_gene';

--- ************************************************
--- *** relation: positively_autoregulated_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that is positively autoregulated. ***
--- ************************************************
---

CREATE VIEW positively_autoregulated_gene AS
  SELECT
    feature_id AS positively_autoregulated_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'positively_autoregulated_gene';

--- ************************************************
--- *** relation: silenced ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing an epigenetic pr ***
--- *** ocess where a gene is inactivated at tra ***
--- *** nscriptional or translational level.     ***
--- ************************************************
---

CREATE VIEW silenced AS
  SELECT
    feature_id AS silenced_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'silenced_by_DNA_modification' OR cvterm.name = 'silenced_by_RNA_interference' OR cvterm.name = 'silenced_by_histone_modification' OR cvterm.name = 'silenced_by_DNA_methylation' OR cvterm.name = 'silenced_by_histone_methylation' OR cvterm.name = 'silenced_by_histone_deacetylation' OR cvterm.name = 'silenced';

--- ************************************************
--- *** relation: silenced_by_dna_modification ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing an epigenetic pr ***
--- *** ocess where a gene is inactivated by DNA ***
--- ***  modifications, resulting in repression  ***
--- *** of transcription.                        ***
--- ************************************************
---

CREATE VIEW silenced_by_dna_modification AS
  SELECT
    feature_id AS silenced_by_dna_modification_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'silenced_by_DNA_methylation' OR cvterm.name = 'silenced_by_DNA_modification';

--- ************************************************
--- *** relation: silenced_by_dna_methylation ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing an epigenetic pr ***
--- *** ocess where a gene is inactivated by DNA ***
--- ***  methylation, resulting in repression of ***
--- ***  transcription.                          ***
--- ************************************************
---

CREATE VIEW silenced_by_dna_methylation AS
  SELECT
    feature_id AS silenced_by_dna_methylation_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'silenced_by_DNA_methylation';

--- ************************************************
--- *** relation: translationally_regulated_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that is translationally regulated ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW translationally_regulated_gene AS
  SELECT
    feature_id AS translationally_regulated_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'translationally_regulated_gene';

--- ************************************************
--- *** relation: allelically_excluded_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that is allelically_excluded.     ***
--- ************************************************
---

CREATE VIEW allelically_excluded_gene AS
  SELECT
    feature_id AS allelically_excluded_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'allelically_excluded_gene';

--- ************************************************
--- *** relation: epigenetically_modified_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that is epigenetically modified.  ***
--- ************************************************
---

CREATE VIEW epigenetically_modified_gene AS
  SELECT
    feature_id AS epigenetically_modified_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_rearranged_at_DNA_level' OR cvterm.name = 'maternally_imprinted_gene' OR cvterm.name = 'paternally_imprinted_gene' OR cvterm.name = 'allelically_excluded_gene' OR cvterm.name = 'epigenetically_modified_gene';

--- ************************************************
--- *** relation: transgene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transgene is a gene that has been tran ***
--- *** sferred naturally or by any of a number  ***
--- *** of genetic engineering techniques from o ***
--- *** ne organism to another.                  ***
--- ************************************************
---

CREATE VIEW transgene AS
  SELECT
    feature_id AS transgene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'floxed_gene' OR cvterm.name = 'transgene';

--- ************************************************
--- *** relation: endogenous_retroviral_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW endogenous_retroviral_sequence AS
  SELECT
    feature_id AS endogenous_retroviral_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'endogenous_retroviral_sequence';

--- ************************************************
--- *** relation: rearranged_at_dna_level ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe the sequence of ***
--- ***  a feature, where the DNA is rearranged. ***
--- ************************************************
---

CREATE VIEW rearranged_at_dna_level AS
  SELECT
    feature_id AS rearranged_at_dna_level_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rearranged_at_DNA_level';

--- ************************************************
--- *** relation: status ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing the status of a  ***
--- *** feature, based on the available evidence ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW status AS
  SELECT
    feature_id AS status_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'fragmentary' OR cvterm.name = 'predicted' OR cvterm.name = 'validated' OR cvterm.name = 'invalidated' OR cvterm.name = 'independently_known' OR cvterm.name = 'consensus' OR cvterm.name = 'low_complexity' OR cvterm.name = 'whole_genome_sequence_status' OR cvterm.name = 'supported_by_sequence_similarity' OR cvterm.name = 'orphan' OR cvterm.name = 'predicted_by_ab_initio_computation' OR cvterm.name = 'supported_by_domain_match' OR cvterm.name = 'supported_by_EST_or_cDNA' OR cvterm.name = 'experimentally_determined' OR cvterm.name = 'invalidated_by_chimeric_cDNA' OR cvterm.name = 'invalidated_by_genomic_contamination' OR cvterm.name = 'invalidated_by_genomic_polyA_primed_cDNA' OR cvterm.name = 'invalidated_by_partial_processing' OR cvterm.name = 'standard_draft' OR cvterm.name = 'high_quality_draft' OR cvterm.name = 'improved_high_quality_draft' OR cvterm.name = 'annotation_directed_improved_draft' OR cvterm.name = 'noncontiguous_finished' OR cvterm.name = 'finished_genome' OR cvterm.name = 'status';

--- ************************************************
--- *** relation: independently_known ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Attribute to describe a feature that is  ***
--- *** independently known - not predicted.     ***
--- ************************************************
---

CREATE VIEW independently_known AS
  SELECT
    feature_id AS independently_known_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'independently_known';

--- ************************************************
--- *** relation: supported_by_sequence_similarity ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a feature that  ***
--- *** has been predicted using sequence simila ***
--- *** rity techniques.                         ***
--- ************************************************
---

CREATE VIEW supported_by_sequence_similarity AS
  SELECT
    feature_id AS supported_by_sequence_similarity_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'supported_by_domain_match' OR cvterm.name = 'supported_by_EST_or_cDNA' OR cvterm.name = 'supported_by_sequence_similarity';

--- ************************************************
--- *** relation: supported_by_domain_match ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a feature that  ***
--- *** has been predicted using sequence simila ***
--- *** rity of a known domain.                  ***
--- ************************************************
---

CREATE VIEW supported_by_domain_match AS
  SELECT
    feature_id AS supported_by_domain_match_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'supported_by_domain_match';

--- ************************************************
--- *** relation: supported_by_est_or_cdna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a feature that  ***
--- *** has been predicted using sequence simila ***
--- *** rity to EST or cDNA data.                ***
--- ************************************************
---

CREATE VIEW supported_by_est_or_cdna AS
  SELECT
    feature_id AS supported_by_est_or_cdna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'supported_by_EST_or_cDNA';

--- ************************************************
--- *** relation: orphan ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW orphan AS
  SELECT
    feature_id AS orphan_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'orphan';

--- ************************************************
--- *** relation: predicted_by_ab_initio_computation ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a feature that i ***
--- *** s predicted by a computer program that d ***
--- *** id not rely on sequence similarity.      ***
--- ************************************************
---

CREATE VIEW predicted_by_ab_initio_computation AS
  SELECT
    feature_id AS predicted_by_ab_initio_computation_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'predicted_by_ab_initio_computation';

--- ************************************************
--- *** relation: asx_turn ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of three consecutive residues an ***
--- *** d one H-bond in which: residue(i) is Asp ***
--- *** artate or Asparagine (Asx), the side-cha ***
--- *** in O of residue(i) is H-bonded to the ma ***
--- *** in-chain NH of residue(i+2).             ***
--- ************************************************
---

CREATE VIEW asx_turn AS
  SELECT
    feature_id AS asx_turn_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'asx_turn_left_handed_type_one' OR cvterm.name = 'asx_turn_left_handed_type_two' OR cvterm.name = 'asx_turn_right_handed_type_two' OR cvterm.name = 'asx_turn_right_handed_type_one' OR cvterm.name = 'asx_turn';

--- ************************************************
--- *** relation: cloned_cdna_insert ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A clone insert made from cDNA.           ***
--- ************************************************
---

CREATE VIEW cloned_cdna_insert AS
  SELECT
    feature_id AS cloned_cdna_insert_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cloned_cDNA_insert';

--- ************************************************
--- *** relation: cloned_genomic_insert ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A clone insert made from genomic DNA.    ***
--- ************************************************
---

CREATE VIEW cloned_genomic_insert AS
  SELECT
    feature_id AS cloned_genomic_insert_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'BAC_cloned_genomic_insert' OR cvterm.name = 'cloned_genomic_insert';

--- ************************************************
--- *** relation: engineered_insert ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A clone insert that is engineered.       ***
--- ************************************************
---

CREATE VIEW engineered_insert AS
  SELECT
    feature_id AS engineered_insert_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'engineered_insert';

--- ************************************************
--- *** relation: edited_mrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An mRNA that is edited.                  ***
--- ************************************************
---

CREATE VIEW edited_mrna AS
  SELECT
    feature_id AS edited_mrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'edited_mRNA';

--- ************************************************
--- *** relation: guide_rna_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of guide RNA.                   ***
--- ************************************************
---

CREATE VIEW guide_rna_region AS
  SELECT
    feature_id AS guide_rna_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'anchor_region' OR cvterm.name = 'template_region' OR cvterm.name = 'guide_RNA_region';

--- ************************************************
--- *** relation: anchor_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of a guide_RNA that base-pairs  ***
--- *** to a target mRNA.                        ***
--- ************************************************
---

CREATE VIEW anchor_region AS
  SELECT
    feature_id AS anchor_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'anchor_region';

--- ************************************************
--- *** relation: pre_edited_mrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW pre_edited_mrna AS
  SELECT
    feature_id AS pre_edited_mrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pre_edited_mRNA';

--- ************************************************
--- *** relation: intermediate ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute to describe a feature betwe ***
--- *** en stages of processing.                 ***
--- ************************************************
---

CREATE VIEW intermediate AS
  SELECT
    feature_id AS intermediate_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'intermediate';

--- ************************************************
--- *** relation: mirna_target_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A miRNA target site is a binding site wh ***
--- *** ere the molecule is a micro RNA.         ***
--- ************************************************
---

CREATE VIEW mirna_target_site AS
  SELECT
    feature_id AS mirna_target_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'miRNA_target_site';

--- ************************************************
--- *** relation: edited_cds ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A CDS that is edited.                    ***
--- ************************************************
---

CREATE VIEW edited_cds AS
  SELECT
    feature_id AS edited_cds_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'edited_CDS';

--- ************************************************
--- *** relation: vertebrate_immunoglobulin_t_cell_receptor_rearranged_segment ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW vertebrate_immunoglobulin_t_cell_receptor_rearranged_segment AS
  SELECT
    feature_id AS vertebrate_immunoglobulin_t_cell_receptor_rearranged_segment_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'VD_gene' OR cvterm.name = 'DJ_gene' OR cvterm.name = 'VDJ_gene' OR cvterm.name = 'VJ_gene' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_segment';

--- ************************************************
--- *** relation: vertebrate_ig_t_cell_receptor_rearranged_gene_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW vertebrate_ig_t_cell_receptor_rearranged_gene_cluster AS
  SELECT
    feature_id AS vertebrate_ig_t_cell_receptor_rearranged_gene_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DJ_J_cluster' OR cvterm.name = 'VDJ_J_C_cluster' OR cvterm.name = 'VDJ_J_cluster' OR cvterm.name = 'VJ_C_cluster' OR cvterm.name = 'VJ_J_C_cluster' OR cvterm.name = 'VJ_J_cluster' OR cvterm.name = 'D_DJ_C_cluster' OR cvterm.name = 'D_DJ_cluster' OR cvterm.name = 'D_DJ_J_C_cluster' OR cvterm.name = 'D_DJ_J_cluster' OR cvterm.name = 'V_DJ_cluster' OR cvterm.name = 'V_DJ_J_cluster' OR cvterm.name = 'V_VDJ_C_cluster' OR cvterm.name = 'V_VDJ_cluster' OR cvterm.name = 'V_VDJ_J_cluster' OR cvterm.name = 'V_VJ_C_cluster' OR cvterm.name = 'V_VJ_cluster' OR cvterm.name = 'V_VJ_J_cluster' OR cvterm.name = 'V_D_DJ_C_cluster' OR cvterm.name = 'V_D_DJ_cluster' OR cvterm.name = 'V_D_DJ_J_C_cluster' OR cvterm.name = 'V_D_DJ_J_cluster' OR cvterm.name = 'V_D_J_C_cluster' OR cvterm.name = 'V_D_J_cluster' OR cvterm.name = 'DJ_C_cluster' OR cvterm.name = 'DJ_J_C_cluster' OR cvterm.name = 'VDJ_C_cluster' OR cvterm.name = 'V_DJ_C_cluster' OR cvterm.name = 'V_DJ_J_C_cluster' OR cvterm.name = 'V_VDJ_J_C_cluster' OR cvterm.name = 'V_VJ_J_C_cluster' OR cvterm.name = 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_gene_cluster';

--- ************************************************
--- *** relation: vertebrate_immune_system_gene_recombination_signal_feature ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW vertebrate_immune_system_gene_recombination_signal_feature AS
  SELECT
    feature_id AS vertebrate_immune_system_gene_recombination_signal_feature_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'J_gene_recombination_feature' OR cvterm.name = 'D_gene_recombination_feature' OR cvterm.name = 'V_gene_recombination_feature' OR cvterm.name = 'heptamer_of_recombination_feature_of_vertebrate_immune_system_gene' OR cvterm.name = 'nonamer_of_recombination_feature_of_vertebrate_immune_system_gene' OR cvterm.name = 'five_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_recombination_signal_sequence' OR cvterm.name = 'three_prime_D_heptamer' OR cvterm.name = 'five_prime_D_heptamer' OR cvterm.name = 'J_heptamer' OR cvterm.name = 'V_heptamer' OR cvterm.name = 'three_prime_D_nonamer' OR cvterm.name = 'five_prime_D_nonamer' OR cvterm.name = 'J_nonamer' OR cvterm.name = 'V_nonamer' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_signal_feature';

--- ************************************************
--- *** relation: recombinationally_rearranged ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW recombinationally_rearranged AS
  SELECT
    feature_id AS recombinationally_rearranged_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'recombinationally_rearranged';

--- ************************************************
--- *** relation: recombinationally_rearranged_vertebrate_immune_system_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A recombinationally rearranged gene of t ***
--- *** he vertebrate immune system.             ***
--- ************************************************
---

CREATE VIEW recombinationally_rearranged_vertebrate_immune_system_gene AS
  SELECT
    feature_id AS recombinationally_rearranged_vertebrate_immune_system_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'recombinationally_rearranged_vertebrate_immune_system_gene';

--- ************************************************
--- *** relation: attp_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An integration/excision site of a phage  ***
--- *** chromosome at which a recombinase acts t ***
--- *** o insert the phage DNA at a cognate inte ***
--- *** gration/excision site on a bacterial chr ***
--- *** omosome.                                 ***
--- ************************************************
---

CREATE VIEW attp_site AS
  SELECT
    feature_id AS attp_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'attP_site';

--- ************************************************
--- *** relation: attb_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An integration/excision site of a bacter ***
--- *** ial chromosome at which a recombinase ac ***
--- *** ts to insert foreign DNA containing a co ***
--- *** gnate integration/excision site.         ***
--- ************************************************
---

CREATE VIEW attb_site AS
  SELECT
    feature_id AS attb_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'attB_site';

--- ************************************************
--- *** relation: attl_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region that results from recombination ***
--- ***  between attP_site and attB_site, compos ***
--- *** ed of the 5' portion of attB_site and th ***
--- *** e 3' portion of attP_site.               ***
--- ************************************************
---

CREATE VIEW attl_site AS
  SELECT
    feature_id AS attl_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'attL_site';

--- ************************************************
--- *** relation: attr_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region that results from recombination ***
--- ***  between attP_site and attB_site, compos ***
--- *** ed of the 5' portion of attP_site and th ***
--- *** e 3' portion of attB_site.               ***
--- ************************************************
---

CREATE VIEW attr_site AS
  SELECT
    feature_id AS attr_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'attR_site';

--- ************************************************
--- *** relation: integration_excision_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region specifically recognised by a re ***
--- *** combinase, which inserts or removes anot ***
--- *** her region marked by a distinct cognate  ***
--- *** integration/excision site.               ***
--- ************************************************
---

CREATE VIEW integration_excision_site AS
  SELECT
    feature_id AS integration_excision_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'attI_site' OR cvterm.name = 'attP_site' OR cvterm.name = 'attB_site' OR cvterm.name = 'attL_site' OR cvterm.name = 'attR_site' OR cvterm.name = 'attC_site' OR cvterm.name = 'attCtn_site' OR cvterm.name = 'integration_excision_site';

--- ************************************************
--- *** relation: resolution_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region specifically recognised by a re ***
--- *** combinase, which separates a physically  ***
--- *** contiguous circle of DNA into two physic ***
--- *** ally separate circles.                   ***
--- ************************************************
---

CREATE VIEW resolution_site AS
  SELECT
    feature_id AS resolution_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'loxP_site' OR cvterm.name = 'dif_site' OR cvterm.name = 'resolution_site';

--- ************************************************
--- *** relation: inversion_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region specifically recognised by a re ***
--- *** combinase, which inverts the region flan ***
--- *** ked by a pair of sites.                  ***
--- ************************************************
---

CREATE VIEW inversion_site AS
  SELECT
    feature_id AS inversion_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'FRT_site' OR cvterm.name = 'inversion_site';

--- ************************************************
--- *** relation: dif_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A site at which replicated bacterial cir ***
--- *** cular chromosomes are decatenated by sit ***
--- *** e specific resolvase.                    ***
--- ************************************************
---

CREATE VIEW dif_site AS
  SELECT
    feature_id AS dif_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'dif_site';

--- ************************************************
--- *** relation: attc_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attC site is a sequence required for  ***
--- *** the integration of a DNA of an integron. ***
--- ************************************************
---

CREATE VIEW attc_site AS
  SELECT
    feature_id AS attc_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'attC_site';

--- ************************************************
--- *** relation: eukaryotic_terminator ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW eukaryotic_terminator AS
  SELECT
    feature_id AS eukaryotic_terminator_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'terminator_of_type_2_RNApol_III_promoter' OR cvterm.name = 'eukaryotic_terminator';

--- ************************************************
--- *** relation: oriv ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An origin of vegetative replication in p ***
--- *** lasmids and phages.                      ***
--- ************************************************
---

CREATE VIEW oriv AS
  SELECT
    feature_id AS oriv_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'oriV';

--- ************************************************
--- *** relation: oric ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An origin of bacterial chromosome replic ***
--- *** ation.                                   ***
--- ************************************************
---

CREATE VIEW oric AS
  SELECT
    feature_id AS oric_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'oriC';

--- ************************************************
--- *** relation: dna_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Structural unit composed of a self-repli ***
--- *** cating, DNA molecule.                    ***
--- ************************************************
---

CREATE VIEW dna_chromosome AS
  SELECT
    feature_id AS dna_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'double_stranded_DNA_chromosome' OR cvterm.name = 'single_stranded_DNA_chromosome' OR cvterm.name = 'linear_double_stranded_DNA_chromosome' OR cvterm.name = 'circular_double_stranded_DNA_chromosome' OR cvterm.name = 'linear_single_stranded_DNA_chromosome' OR cvterm.name = 'circular_single_stranded_DNA_chromosome' OR cvterm.name = 'DNA_chromosome';

--- ************************************************
--- *** relation: double_stranded_dna_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Structural unit composed of a self-repli ***
--- *** cating, double-stranded DNA molecule.    ***
--- ************************************************
---

CREATE VIEW double_stranded_dna_chromosome AS
  SELECT
    feature_id AS double_stranded_dna_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'linear_double_stranded_DNA_chromosome' OR cvterm.name = 'circular_double_stranded_DNA_chromosome' OR cvterm.name = 'double_stranded_DNA_chromosome';

--- ************************************************
--- *** relation: single_stranded_dna_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Structural unit composed of a self-repli ***
--- *** cating, single-stranded DNA molecule.    ***
--- ************************************************
---

CREATE VIEW single_stranded_dna_chromosome AS
  SELECT
    feature_id AS single_stranded_dna_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'linear_single_stranded_DNA_chromosome' OR cvterm.name = 'circular_single_stranded_DNA_chromosome' OR cvterm.name = 'single_stranded_DNA_chromosome';

--- ************************************************
--- *** relation: linear_double_stranded_dna_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Structural unit composed of a self-repli ***
--- *** cating, double-stranded, linear DNA mole ***
--- *** cule.                                    ***
--- ************************************************
---

CREATE VIEW linear_double_stranded_dna_chromosome AS
  SELECT
    feature_id AS linear_double_stranded_dna_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'linear_double_stranded_DNA_chromosome';

--- ************************************************
--- *** relation: circular_double_stranded_dna_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Structural unit composed of a self-repli ***
--- *** cating, double-stranded, circular DNA mo ***
--- *** lecule.                                  ***
--- ************************************************
---

CREATE VIEW circular_double_stranded_dna_chromosome AS
  SELECT
    feature_id AS circular_double_stranded_dna_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'circular_double_stranded_DNA_chromosome';

--- ************************************************
--- *** relation: linear_single_stranded_dna_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Structural unit composed of a self-repli ***
--- *** cating, single-stranded, linear DNA mole ***
--- *** cule.                                    ***
--- ************************************************
---

CREATE VIEW linear_single_stranded_dna_chromosome AS
  SELECT
    feature_id AS linear_single_stranded_dna_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'linear_single_stranded_DNA_chromosome';

--- ************************************************
--- *** relation: circular_single_stranded_dna_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Structural unit composed of a self-repli ***
--- *** cating, single-stranded, circular DNA mo ***
--- *** lecule.                                  ***
--- ************************************************
---

CREATE VIEW circular_single_stranded_dna_chromosome AS
  SELECT
    feature_id AS circular_single_stranded_dna_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'circular_single_stranded_DNA_chromosome';

--- ************************************************
--- *** relation: rna_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Structural unit composed of a self-repli ***
--- *** cating, RNA molecule.                    ***
--- ************************************************
---

CREATE VIEW rna_chromosome AS
  SELECT
    feature_id AS rna_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'single_stranded_RNA_chromosome' OR cvterm.name = 'double_stranded_RNA_chromosome' OR cvterm.name = 'linear_single_stranded_RNA_chromosome' OR cvterm.name = 'circular_single_stranded_RNA_chromosome' OR cvterm.name = 'linear_double_stranded_RNA_chromosome' OR cvterm.name = 'circular_double_stranded_RNA_chromosome' OR cvterm.name = 'RNA_chromosome';

--- ************************************************
--- *** relation: single_stranded_rna_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Structural unit composed of a self-repli ***
--- *** cating, single-stranded RNA molecule.    ***
--- ************************************************
---

CREATE VIEW single_stranded_rna_chromosome AS
  SELECT
    feature_id AS single_stranded_rna_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'linear_single_stranded_RNA_chromosome' OR cvterm.name = 'circular_single_stranded_RNA_chromosome' OR cvterm.name = 'single_stranded_RNA_chromosome';

--- ************************************************
--- *** relation: linear_single_stranded_rna_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Structural unit composed of a self-repli ***
--- *** cating, single-stranded, linear RNA mole ***
--- *** cule.                                    ***
--- ************************************************
---

CREATE VIEW linear_single_stranded_rna_chromosome AS
  SELECT
    feature_id AS linear_single_stranded_rna_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'linear_single_stranded_RNA_chromosome';

--- ************************************************
--- *** relation: linear_double_stranded_rna_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Structural unit composed of a self-repli ***
--- *** cating, double-stranded, linear RNA mole ***
--- *** cule.                                    ***
--- ************************************************
---

CREATE VIEW linear_double_stranded_rna_chromosome AS
  SELECT
    feature_id AS linear_double_stranded_rna_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'linear_double_stranded_RNA_chromosome';

--- ************************************************
--- *** relation: double_stranded_rna_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Structural unit composed of a self-repli ***
--- *** cating, double-stranded RNA molecule.    ***
--- ************************************************
---

CREATE VIEW double_stranded_rna_chromosome AS
  SELECT
    feature_id AS double_stranded_rna_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'linear_double_stranded_RNA_chromosome' OR cvterm.name = 'circular_double_stranded_RNA_chromosome' OR cvterm.name = 'double_stranded_RNA_chromosome';

--- ************************************************
--- *** relation: circular_single_stranded_rna_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Structural unit composed of a self-repli ***
--- *** cating, single-stranded, circular DNA mo ***
--- *** lecule.                                  ***
--- ************************************************
---

CREATE VIEW circular_single_stranded_rna_chromosome AS
  SELECT
    feature_id AS circular_single_stranded_rna_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'circular_single_stranded_RNA_chromosome';

--- ************************************************
--- *** relation: circular_double_stranded_rna_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Structural unit composed of a self-repli ***
--- *** cating, double-stranded, circular RNA mo ***
--- *** lecule.                                  ***
--- ************************************************
---

CREATE VIEW circular_double_stranded_rna_chromosome AS
  SELECT
    feature_id AS circular_double_stranded_rna_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'circular_double_stranded_RNA_chromosome';

--- ************************************************
--- *** relation: insertion_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A terminal_inverted_repeat_element that  ***
--- *** is bacterial and only encodes the functi ***
--- *** ons required for its transposition betwe ***
--- *** en these inverted repeats.               ***
--- ************************************************
---

CREATE VIEW insertion_sequence AS
  SELECT
    feature_id AS insertion_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'insertion_sequence';

--- ************************************************
--- *** relation: minicircle_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW minicircle_gene AS
  SELECT
    feature_id AS minicircle_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'minicircle_gene';

--- ************************************************
--- *** relation: cryptic ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A feature_attribute describing a feature ***
--- ***  that is not manifest under normal condi ***
--- *** tions.                                   ***
--- ************************************************
---

CREATE VIEW cryptic AS
  SELECT
    feature_id AS cryptic_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cryptic';

--- ************************************************
--- *** relation: anchor_binding_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW anchor_binding_site AS
  SELECT
    feature_id AS anchor_binding_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'anchor_binding_site';

--- ************************************************
--- *** relation: template_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of a guide_RNA that specifies t ***
--- *** he insertions and deletions of bases in  ***
--- *** the editing of a target mRNA.            ***
--- ************************************************
---

CREATE VIEW template_region AS
  SELECT
    feature_id AS template_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'template_region';

--- ************************************************
--- *** relation: grna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A non-protein_coding gene that encodes a ***
--- ***  guide_RNA.                              ***
--- ************************************************
---

CREATE VIEW grna_encoding AS
  SELECT
    feature_id AS grna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gRNA_encoding';

--- ************************************************
--- *** relation: minicircle ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A minicircle is a replicon, part of a ki ***
--- *** netoplast, that encodes for guide RNAs.  ***
--- ************************************************
---

CREATE VIEW minicircle AS
  SELECT
    feature_id AS minicircle_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'minicircle';

--- ************************************************
--- *** relation: rho_dependent_bacterial_terminator ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW rho_dependent_bacterial_terminator AS
  SELECT
    feature_id AS rho_dependent_bacterial_terminator_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rho_dependent_bacterial_terminator';

--- ************************************************
--- *** relation: rho_independent_bacterial_terminator ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW rho_independent_bacterial_terminator AS
  SELECT
    feature_id AS rho_independent_bacterial_terminator_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rho_independent_bacterial_terminator';

--- ************************************************
--- *** relation: strand_attribute ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW strand_attribute AS
  SELECT
    feature_id AS strand_attribute_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'single' OR cvterm.name = 'double' OR cvterm.name = 'strand_attribute';

--- ************************************************
--- *** relation: single ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW single AS
  SELECT
    feature_id AS single_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'single';

--- ************************************************
--- *** relation: double ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW double AS
  SELECT
    feature_id AS double_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'double';

--- ************************************************
--- *** relation: topology_attribute ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW topology_attribute AS
  SELECT
    feature_id AS topology_attribute_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'linear' OR cvterm.name = 'circular' OR cvterm.name = 'topology_attribute';

--- ************************************************
--- *** relation: linear ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A quality of a nucleotide polymer that h ***
--- *** as a 3'-terminal residue and a 5'-termin ***
--- *** al residue.                              ***
--- ************************************************
---

CREATE VIEW linear AS
  SELECT
    feature_id AS linear_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'linear';

--- ************************************************
--- *** relation: circular ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A quality of a nucleotide polymer that h ***
--- *** as no terminal nucleotide residues.      ***
--- ************************************************
---

CREATE VIEW circular AS
  SELECT
    feature_id AS circular_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'circular';

--- ************************************************
--- *** relation: class_ii_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Small non-coding RNA (59-60 nt long) con ***
--- *** taining 5' and 3' ends that are predicte ***
--- *** d to come together to form a stem struct ***
--- *** ure. Identified in the social amoeba Dic ***
--- *** tyostelium discoideum and localized in t ***
--- *** he cytoplasm.                            ***
--- ************************************************
---

CREATE VIEW class_ii_rna AS
  SELECT
    feature_id AS class_ii_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'class_II_RNA';

--- ************************************************
--- *** relation: class_i_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Small non-coding RNA (55-65 nt long) con ***
--- *** taining highly conserved 5' and 3' ends  ***
--- *** (16 and 8 nt, respectively) that are pre ***
--- *** dicted to come together to form a stem s ***
--- *** tructure. Identified in the social amoeb ***
--- *** a Dictyostelium discoideum and localized ***
--- ***  in the cytoplasm.                       ***
--- ************************************************
---

CREATE VIEW class_i_rna AS
  SELECT
    feature_id AS class_i_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'class_I_RNA';

--- ************************************************
--- *** relation: genomic_dna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW genomic_dna AS
  SELECT
    feature_id AS genomic_dna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'genomic_DNA';

--- ************************************************
--- *** relation: bac_cloned_genomic_insert ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW bac_cloned_genomic_insert AS
  SELECT
    feature_id AS bac_cloned_genomic_insert_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'BAC_cloned_genomic_insert';

--- ************************************************
--- *** relation: consensus ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW consensus AS
  SELECT
    feature_id AS consensus_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'consensus';

--- ************************************************
--- *** relation: consensus_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW consensus_region AS
  SELECT
    feature_id AS consensus_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'consensus_mRNA' OR cvterm.name = 'consensus_region';

--- ************************************************
--- *** relation: consensus_mrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW consensus_mrna AS
  SELECT
    feature_id AS consensus_mrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'consensus_mRNA';

--- ************************************************
--- *** relation: predicted_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW predicted_gene AS
  SELECT
    feature_id AS predicted_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'predicted_gene';

--- ************************************************
--- *** relation: gene_fragment ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW gene_fragment AS
  SELECT
    feature_id AS gene_fragment_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_fragment';

--- ************************************************
--- *** relation: recursive_splice_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A recursive splice site is a splice site ***
--- ***  which subdivides a large intron. Recurs ***
--- *** ive splicing is a mechanism that splices ***
--- ***  large introns by sub dividing the intro ***
--- *** n at non exonic elements and alternate e ***
--- *** xons.                                    ***
--- ************************************************
---

CREATE VIEW recursive_splice_site AS
  SELECT
    feature_id AS recursive_splice_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'recursive_splice_site';

--- ************************************************
--- *** relation: bac_end ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of sequence from the end of a B ***
--- *** AC clone that may provide a highly speci ***
--- *** fic marker.                              ***
--- ************************************************
---

CREATE VIEW bac_end AS
  SELECT
    feature_id AS bac_end_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'BAC_end';

--- ************************************************
--- *** relation: rrna_16s ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A large polynucleotide in Bacteria and A ***
--- *** rchaea, which functions as the small sub ***
--- *** unit of the ribosome.                    ***
--- ************************************************
---

CREATE VIEW rrna_16s AS
  SELECT
    feature_id AS rrna_16s_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_16S';

--- ************************************************
--- *** relation: rrna_23s ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A large polynucleotide in Bacteria and A ***
--- *** rchaea, which functions as the large sub ***
--- *** unit of the ribosome.                    ***
--- ************************************************
---

CREATE VIEW rrna_23s AS
  SELECT
    feature_id AS rrna_23s_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_23S';

--- ************************************************
--- *** relation: rrna_25s ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A large polynucleotide which functions a ***
--- *** s part of the large subunit of the ribos ***
--- *** ome in some eukaryotes.                  ***
--- ************************************************
---

CREATE VIEW rrna_25s AS
  SELECT
    feature_id AS rrna_25s_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_25S';

--- ************************************************
--- *** relation: solo_ltr ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A recombination product between the 2 LT ***
--- *** R of the same element.                   ***
--- ************************************************
---

CREATE VIEW solo_ltr AS
  SELECT
    feature_id AS solo_ltr_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'solo_LTR';

--- ************************************************
--- *** relation: low_complexity ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW low_complexity AS
  SELECT
    feature_id AS low_complexity_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'low_complexity';

--- ************************************************
--- *** relation: low_complexity_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW low_complexity_region AS
  SELECT
    feature_id AS low_complexity_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'low_complexity_region';

--- ************************************************
--- *** relation: prophage ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A phage genome after it has established  ***
--- *** in the host genome in a latent/immune st ***
--- *** ate either as a plasmid or as an integra ***
--- *** ted "island".                            ***
--- ************************************************
---

CREATE VIEW prophage AS
  SELECT
    feature_id AS prophage_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'prophage';

--- ************************************************
--- *** relation: cryptic_prophage ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A remnant of an integrated prophage in t ***
--- *** he host genome or an "island" in the hos ***
--- *** t genome that includes phage like-genes. ***
--- ************************************************
---

CREATE VIEW cryptic_prophage AS
  SELECT
    feature_id AS cryptic_prophage_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cryptic_prophage';

--- ************************************************
--- *** relation: tetraloop ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A base-paired stem with loop of 4 non-hy ***
--- *** drogen bonded nucleotides.               ***
--- ************************************************
---

CREATE VIEW tetraloop AS
  SELECT
    feature_id AS tetraloop_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tetraloop';

--- ************************************************
--- *** relation: dna_constraint_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A double-stranded DNA used to control ma ***
--- *** cromolecular structure and function.     ***
--- ************************************************
---

CREATE VIEW dna_constraint_sequence AS
  SELECT
    feature_id AS dna_constraint_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DNA_constraint_sequence';

--- ************************************************
--- *** relation: i_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A cytosine rich domain whereby strands a ***
--- *** ssociate both inter- and intramolecularl ***
--- *** y at moderately acidic pH.               ***
--- ************************************************
---

CREATE VIEW i_motif AS
  SELECT
    feature_id AS i_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'i_motif';

--- ************************************************
--- *** relation: pna_oligo ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Peptide nucleic acid, is a chemical not  ***
--- *** known to occur naturally but is artifici ***
--- *** ally synthesized and used in some biolog ***
--- *** ical research and medical treatments. Th ***
--- *** e PNA backbone is composed of repeating  ***
--- *** N-(2-aminoethyl)-glycine units linked by ***
--- ***  peptide bonds. The purine and pyrimidin ***
--- *** e bases are linked to the backbone by me ***
--- *** thylene carbonyl bonds.                  ***
--- ************************************************
---

CREATE VIEW pna_oligo AS
  SELECT
    feature_id AS pna_oligo_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'PNA_oligo';

--- ************************************************
--- *** relation: dnazyme ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A DNA sequence with catalytic activity.  ***
--- ************************************************
---

CREATE VIEW dnazyme AS
  SELECT
    feature_id AS dnazyme_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DNAzyme';

--- ************************************************
--- *** relation: mnp ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A multiple nucleotide polymorphism with  ***
--- *** alleles of common length > 1, for exampl ***
--- *** e AAA/TTT.                               ***
--- ************************************************
---

CREATE VIEW mnp AS
  SELECT
    feature_id AS mnp_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'MNP';

--- ************************************************
--- *** relation: intron_domain ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW intron_domain AS
  SELECT
    feature_id AS intron_domain_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'internal_guide_sequence' OR cvterm.name = 'mirtron' OR cvterm.name = 'intron_domain';

--- ************************************************
--- *** relation: wobble_base_pair ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A type of non-canonical base pairing, mo ***
--- *** st commonly between G and U, which is im ***
--- *** portant for the secondary structure of R ***
--- *** NAs. It has similar thermodynamic stabil ***
--- *** ity to the Watson-Crick pairing. Wobble  ***
--- *** base pairs only have two hydrogen bonds. ***
--- ***  Other wobble base pair possibilities ar ***
--- *** e I-A, I-U and I-C.                      ***
--- ************************************************
---

CREATE VIEW wobble_base_pair AS
  SELECT
    feature_id AS wobble_base_pair_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'wobble_base_pair';

--- ************************************************
--- *** relation: internal_guide_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A purine-rich sequence in the group I in ***
--- *** trons which determines the locations of  ***
--- *** the splice sites in group I intron splic ***
--- *** ing and has catalytic activity.          ***
--- ************************************************
---

CREATE VIEW internal_guide_sequence AS
  SELECT
    feature_id AS internal_guide_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'internal_guide_sequence';

--- ************************************************
--- *** relation: silent_mutation ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence variant that does not affect  ***
--- *** protein function. Silent mutations may o ***
--- *** ccur in genic ( CDS, UTR, intron etc) an ***
--- *** d intergenic regions. Silent mutations m ***
--- *** ay have affects on processes such as spl ***
--- *** icing and regulation.                    ***
--- ************************************************
---

CREATE VIEW silent_mutation AS
  SELECT
    feature_id AS silent_mutation_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'silent_mutation';

--- ************************************************
--- *** relation: epitope ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A binding site that, in the molecule, in ***
--- *** teracts selectively and non-covalently w ***
--- *** ith antibodies, B cells or T cells.      ***
--- ************************************************
---

CREATE VIEW epitope AS
  SELECT
    feature_id AS epitope_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'epitope';

--- ************************************************
--- *** relation: copy_number_variation ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A variation that increases or decreases  ***
--- *** the copy number of a given region.       ***
--- ************************************************
---

CREATE VIEW copy_number_variation AS
  SELECT
    feature_id AS copy_number_variation_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'copy_number_gain' OR cvterm.name = 'copy_number_loss' OR cvterm.name = 'copy_number_variation';

--- ************************************************
--- *** relation: chromosome_breakpoint ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW chromosome_breakpoint AS
  SELECT
    feature_id AS chromosome_breakpoint_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inversion_breakpoint' OR cvterm.name = 'translocation_breakpoint' OR cvterm.name = 'insertion_breakpoint' OR cvterm.name = 'deletion_breakpoint' OR cvterm.name = 'chromosome_breakpoint';

--- ************************************************
--- *** relation: inversion_breakpoint ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The point within a chromosome where an i ***
--- *** nversion begins or ends.                 ***
--- ************************************************
---

CREATE VIEW inversion_breakpoint AS
  SELECT
    feature_id AS inversion_breakpoint_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inversion_breakpoint';

--- ************************************************
--- *** relation: allele ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An allele is one of a set of coexisting  ***
--- *** sequence variants of a gene.             ***
--- ************************************************
---

CREATE VIEW allele AS
  SELECT
    feature_id AS allele_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polymorphic_sequence_variant' OR cvterm.name = 'allele';

--- ************************************************
--- *** relation: haplotype ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A haplotype is one of a set of coexistin ***
--- *** g sequence variants of a haplotype block ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW haplotype AS
  SELECT
    feature_id AS haplotype_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'haplotype';

--- ************************************************
--- *** relation: polymorphic_sequence_variant ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence variant that is segregating i ***
--- *** n one or more natural populations of a s ***
--- *** pecies.                                  ***
--- ************************************************
---

CREATE VIEW polymorphic_sequence_variant AS
  SELECT
    feature_id AS polymorphic_sequence_variant_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polymorphic_sequence_variant';

--- ************************************************
--- *** relation: genome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A genome is the sum of genetic material  ***
--- *** within a cell or virion.                 ***
--- ************************************************
---

CREATE VIEW genome AS
  SELECT
    feature_id AS genome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'kinetoplast' OR cvterm.name = 'reference_genome' OR cvterm.name = 'variant_genome' OR cvterm.name = 'chromosomally_aberrant_genome' OR cvterm.name = 'genome';

--- ************************************************
--- *** relation: so_genotype ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A genotype is a variant genome, complete ***
--- ***  or incomplete.                          ***
--- ************************************************
---

CREATE VIEW so_genotype AS
  SELECT
    feature_id AS so_genotype_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'genotype';

--- ************************************************
--- *** relation: diplotype ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A diplotype is a pair of haplotypes from ***
--- ***  a given individual. It is a genotype wh ***
--- *** ere the phase is known.                  ***
--- ************************************************
---

CREATE VIEW diplotype AS
  SELECT
    feature_id AS diplotype_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'diplotype';

--- ************************************************
--- *** relation: direction_attribute ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW direction_attribute AS
  SELECT
    feature_id AS direction_attribute_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'forward' OR cvterm.name = 'reverse' OR cvterm.name = 'direction_attribute';

--- ************************************************
--- *** relation: forward ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Forward is an attribute of the feature,  ***
--- *** where the feature is in the 5' to 3' dir ***
--- *** ection.                                  ***
--- ************************************************
---

CREATE VIEW forward AS
  SELECT
    feature_id AS forward_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'forward';

--- ************************************************
--- *** relation: reverse ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Reverse is an attribute of the feature,  ***
--- *** where the feature is in the 3' to 5' dir ***
--- *** ection. Again could be applied to primer ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW reverse AS
  SELECT
    feature_id AS reverse_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'reverse';

--- ************************************************
--- *** relation: mitochondrial_dna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW mitochondrial_dna AS
  SELECT
    feature_id AS mitochondrial_dna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mitochondrial_DNA';

--- ************************************************
--- *** relation: chloroplast_dna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW chloroplast_dna AS
  SELECT
    feature_id AS chloroplast_dna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'chloroplast_DNA';

--- ************************************************
--- *** relation: mirtron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A de-branched intron which mimics the st ***
--- *** ructure of pre-miRNA and enters the miRN ***
--- *** A processing pathway without Drosha medi ***
--- *** ated cleavage.                           ***
--- ************************************************
---

CREATE VIEW mirtron AS
  SELECT
    feature_id AS mirtron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mirtron';

--- ************************************************
--- *** relation: pirna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A small non coding RNA, part of a silenc ***
--- *** ing system that prevents the spreading o ***
--- *** f selfish genetic elements.              ***
--- ************************************************
---

CREATE VIEW pirna AS
  SELECT
    feature_id AS pirna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'piRNA';

--- ************************************************
--- *** relation: arginyl_trna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tRNA sequence that has an arginine ant ***
--- *** icodon, and a 3' arginine binding region ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW arginyl_trna AS
  SELECT
    feature_id AS arginyl_trna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'arginyl_tRNA';

--- ************************************************
--- *** relation: mobile_genetic_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A nucleotide region with either intra-ge ***
--- *** nome or intracellular moblity, of varyin ***
--- *** g length, which often carry the informat ***
--- *** ion necessary for transfer and recombina ***
--- *** tion with the host genome.               ***
--- ************************************************
---

CREATE VIEW mobile_genetic_element AS
  SELECT
    feature_id AS mobile_genetic_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mobile_intron' OR cvterm.name = 'extrachromosomal_mobile_genetic_element' OR cvterm.name = 'integrated_mobile_genetic_element' OR cvterm.name = 'natural_transposable_element' OR cvterm.name = 'viral_sequence' OR cvterm.name = 'natural_plasmid' OR cvterm.name = 'phage_sequence' OR cvterm.name = 'ds_RNA_viral_sequence' OR cvterm.name = 'ds_DNA_viral_sequence' OR cvterm.name = 'ss_RNA_viral_sequence' OR cvterm.name = 'negative_sense_ssRNA_viral_sequence' OR cvterm.name = 'positive_sense_ssRNA_viral_sequence' OR cvterm.name = 'ambisense_ssRNA_viral_sequence' OR cvterm.name = 'transposable_element' OR cvterm.name = 'proviral_region' OR cvterm.name = 'integron' OR cvterm.name = 'genomic_island' OR cvterm.name = 'integrated_plasmid' OR cvterm.name = 'cointegrated_plasmid' OR cvterm.name = 'retrotransposon' OR cvterm.name = 'DNA_transposon' OR cvterm.name = 'foreign_transposable_element' OR cvterm.name = 'transgenic_transposable_element' OR cvterm.name = 'natural_transposable_element' OR cvterm.name = 'engineered_transposable_element' OR cvterm.name = 'nested_transposon' OR cvterm.name = 'LTR_retrotransposon' OR cvterm.name = 'non_LTR_retrotransposon' OR cvterm.name = 'LINE_element' OR cvterm.name = 'SINE_element' OR cvterm.name = 'terminal_inverted_repeat_element' OR cvterm.name = 'foldback_element' OR cvterm.name = 'conjugative_transposon' OR cvterm.name = 'helitron' OR cvterm.name = 'p_element' OR cvterm.name = 'MITE' OR cvterm.name = 'insertion_sequence' OR cvterm.name = 'polinton' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'prophage' OR cvterm.name = 'pathogenic_island' OR cvterm.name = 'metabolic_island' OR cvterm.name = 'adaptive_island' OR cvterm.name = 'symbiosis_island' OR cvterm.name = 'cryptic_prophage' OR cvterm.name = 'defective_conjugative_transposon' OR cvterm.name = 'mobile_genetic_element';

--- ************************************************
--- *** relation: extrachromosomal_mobile_genetic_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An MGE that is not integrated into the h ***
--- *** ost chromosome.                          ***
--- ************************************************
---

CREATE VIEW extrachromosomal_mobile_genetic_element AS
  SELECT
    feature_id AS extrachromosomal_mobile_genetic_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'natural_transposable_element' OR cvterm.name = 'viral_sequence' OR cvterm.name = 'natural_plasmid' OR cvterm.name = 'phage_sequence' OR cvterm.name = 'ds_RNA_viral_sequence' OR cvterm.name = 'ds_DNA_viral_sequence' OR cvterm.name = 'ss_RNA_viral_sequence' OR cvterm.name = 'negative_sense_ssRNA_viral_sequence' OR cvterm.name = 'positive_sense_ssRNA_viral_sequence' OR cvterm.name = 'ambisense_ssRNA_viral_sequence' OR cvterm.name = 'extrachromosomal_mobile_genetic_element';

--- ************************************************
--- *** relation: integrated_mobile_genetic_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An MGE that is integrated into the host  ***
--- *** chromosome.                              ***
--- ************************************************
---

CREATE VIEW integrated_mobile_genetic_element AS
  SELECT
    feature_id AS integrated_mobile_genetic_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transposable_element' OR cvterm.name = 'proviral_region' OR cvterm.name = 'integron' OR cvterm.name = 'genomic_island' OR cvterm.name = 'integrated_plasmid' OR cvterm.name = 'cointegrated_plasmid' OR cvterm.name = 'retrotransposon' OR cvterm.name = 'DNA_transposon' OR cvterm.name = 'foreign_transposable_element' OR cvterm.name = 'transgenic_transposable_element' OR cvterm.name = 'natural_transposable_element' OR cvterm.name = 'engineered_transposable_element' OR cvterm.name = 'nested_transposon' OR cvterm.name = 'LTR_retrotransposon' OR cvterm.name = 'non_LTR_retrotransposon' OR cvterm.name = 'LINE_element' OR cvterm.name = 'SINE_element' OR cvterm.name = 'terminal_inverted_repeat_element' OR cvterm.name = 'foldback_element' OR cvterm.name = 'conjugative_transposon' OR cvterm.name = 'helitron' OR cvterm.name = 'p_element' OR cvterm.name = 'MITE' OR cvterm.name = 'insertion_sequence' OR cvterm.name = 'polinton' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'engineered_foreign_transposable_element' OR cvterm.name = 'prophage' OR cvterm.name = 'pathogenic_island' OR cvterm.name = 'metabolic_island' OR cvterm.name = 'adaptive_island' OR cvterm.name = 'symbiosis_island' OR cvterm.name = 'cryptic_prophage' OR cvterm.name = 'defective_conjugative_transposon' OR cvterm.name = 'integrated_mobile_genetic_element';

--- ************************************************
--- *** relation: integrated_plasmid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A plasmid sequence that is integrated wi ***
--- *** thin the host chromosome.                ***
--- ************************************************
---

CREATE VIEW integrated_plasmid AS
  SELECT
    feature_id AS integrated_plasmid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'integrated_plasmid';

--- ************************************************
--- *** relation: viral_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The region of nucleotide sequence of a v ***
--- *** irus, a submicroscopic particle that rep ***
--- *** licates by infecting a host cell.        ***
--- ************************************************
---

CREATE VIEW viral_sequence AS
  SELECT
    feature_id AS viral_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'phage_sequence' OR cvterm.name = 'ds_RNA_viral_sequence' OR cvterm.name = 'ds_DNA_viral_sequence' OR cvterm.name = 'ss_RNA_viral_sequence' OR cvterm.name = 'negative_sense_ssRNA_viral_sequence' OR cvterm.name = 'positive_sense_ssRNA_viral_sequence' OR cvterm.name = 'ambisense_ssRNA_viral_sequence' OR cvterm.name = 'viral_sequence';

--- ************************************************
--- *** relation: phage_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The nucleotide sequence of a virus that  ***
--- *** infects bacteria.                        ***
--- ************************************************
---

CREATE VIEW phage_sequence AS
  SELECT
    feature_id AS phage_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'phage_sequence';

--- ************************************************
--- *** relation: attctn_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attachment site located on a conjugat ***
--- *** ive transposon and used for site-specifi ***
--- *** c integration of a conjugative transposo ***
--- *** n.                                       ***
--- ************************************************
---

CREATE VIEW attctn_site AS
  SELECT
    feature_id AS attctn_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'attCtn_site';

--- ************************************************
--- *** relation: nuclear_mt_pseudogene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A nuclear pseudogene of either coding or ***
--- ***  non-coding mitochondria derived sequenc ***
--- *** e.                                       ***
--- ************************************************
---

CREATE VIEW nuclear_mt_pseudogene AS
  SELECT
    feature_id AS nuclear_mt_pseudogene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'nuclear_mt_pseudogene';

--- ************************************************
--- *** relation: cointegrated_plasmid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A MGE region consisting of two fused pla ***
--- *** smids resulting from a replicative trans ***
--- *** position event.                          ***
--- ************************************************
---

CREATE VIEW cointegrated_plasmid AS
  SELECT
    feature_id AS cointegrated_plasmid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cointegrated_plasmid';

--- ************************************************
--- *** relation: irlinv_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Component of the inversion site located  ***
--- *** at the left of a region susceptible to s ***
--- *** ite-specific inversion.                  ***
--- ************************************************
---

CREATE VIEW irlinv_site AS
  SELECT
    feature_id AS irlinv_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'IRLinv_site';

--- ************************************************
--- *** relation: irrinv_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Component of the inversion site located  ***
--- *** at the right of a region susceptible to  ***
--- *** site-specific inversion.                 ***
--- ************************************************
---

CREATE VIEW irrinv_site AS
  SELECT
    feature_id AS irrinv_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'IRRinv_site';

--- ************************************************
--- *** relation: inversion_site_part ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region located within an inversion sit ***
--- *** e.                                       ***
--- ************************************************
---

CREATE VIEW inversion_site_part AS
  SELECT
    feature_id AS inversion_site_part_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'IRLinv_site' OR cvterm.name = 'IRRinv_site' OR cvterm.name = 'inversion_site_part';

--- ************************************************
--- *** relation: defective_conjugative_transposon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An island that contains genes for integr ***
--- *** ation/excision and the gene and site for ***
--- ***  the initiation of intercellular transfe ***
--- *** r by conjugation. It can be complemented ***
--- ***  for transfer by a conjugative transposo ***
--- *** n.                                       ***
--- ************************************************
---

CREATE VIEW defective_conjugative_transposon AS
  SELECT
    feature_id AS defective_conjugative_transposon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'defective_conjugative_transposon';

--- ************************************************
--- *** relation: repeat_fragment ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A portion of a repeat, interrupted by th ***
--- *** e insertion of another element.          ***
--- ************************************************
---

CREATE VIEW repeat_fragment AS
  SELECT
    feature_id AS repeat_fragment_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'repeat_fragment';

--- ************************************************
--- *** relation: transposon_fragment ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A portion of a transposon, interrupted b ***
--- *** y the insertion of another element.      ***
--- ************************************************
---

CREATE VIEW transposon_fragment AS
  SELECT
    feature_id AS transposon_fragment_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transposon_fragment';

--- ************************************************
--- *** relation: transcriptional_cis_regulatory_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A regulatory_region that modulates the t ***
--- *** ranscription of a gene or genes.         ***
--- ************************************************
---

CREATE VIEW transcriptional_cis_regulatory_region AS
  SELECT
    feature_id AS transcriptional_cis_regulatory_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'promoter' OR cvterm.name = 'insulator' OR cvterm.name = 'CRM' OR cvterm.name = 'promoter_targeting_sequence' OR cvterm.name = 'ISRE' OR cvterm.name = 'bidirectional_promoter' OR cvterm.name = 'RNA_polymerase_promoter' OR cvterm.name = 'RNApol_I_promoter' OR cvterm.name = 'RNApol_II_promoter' OR cvterm.name = 'RNApol_III_promoter' OR cvterm.name = 'bacterial_RNApol_promoter' OR cvterm.name = 'Phage_RNA_Polymerase_Promoter' OR cvterm.name = 'RNApol_II_core_promoter' OR cvterm.name = 'RNApol_III_promoter_type_1' OR cvterm.name = 'RNApol_III_promoter_type_2' OR cvterm.name = 'RNApol_III_promoter_type_3' OR cvterm.name = 'bacterial_RNApol_promoter_sigma_70' OR cvterm.name = 'bacterial_RNApol_promoter_sigma54' OR cvterm.name = 'SP6_RNA_Polymerase_Promoter' OR cvterm.name = 'T3_RNA_Polymerase_Promoter' OR cvterm.name = 'T7_RNA_Polymerase_Promoter' OR cvterm.name = 'locus_control_region' OR cvterm.name = 'enhancer' OR cvterm.name = 'silencer' OR cvterm.name = 'enhancer_bound_by_factor' OR cvterm.name = 'shadow_enhancer' OR cvterm.name = 'transcriptional_cis_regulatory_region';

--- ************************************************
--- *** relation: splicing_regulatory_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A regulatory_region that modulates splic ***
--- *** ing.                                     ***
--- ************************************************
---

CREATE VIEW splicing_regulatory_region AS
  SELECT
    feature_id AS splicing_regulatory_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'splice_enhancer' OR cvterm.name = 'intronic_splice_enhancer' OR cvterm.name = 'exonic_splice_enhancer' OR cvterm.name = 'splicing_regulatory_region';

--- ************************************************
--- *** relation: promoter_targeting_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A transcriptional_cis_regulatory_region  ***
--- *** that restricts the activity of a CRM to  ***
--- *** a single promoter and which functions on ***
--- *** ly when both itself and an insulator are ***
--- ***  located between the CRM and the promote ***
--- *** r.                                       ***
--- ************************************************
---

CREATE VIEW promoter_targeting_sequence AS
  SELECT
    feature_id AS promoter_targeting_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'promoter_targeting_sequence';

--- ************************************************
--- *** relation: sequence_alteration ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence_alteration is a sequence_feat ***
--- *** ure whose extent is the deviation from a ***
--- *** nother sequence.                         ***
--- ************************************************
---

CREATE VIEW sequence_alteration AS
  SELECT
    feature_id AS sequence_alteration_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'deletion' OR cvterm.name = 'translocation' OR cvterm.name = 'insertion' OR cvterm.name = 'copy_number_variation' OR cvterm.name = 'UPD' OR cvterm.name = 'structural_alteration' OR cvterm.name = 'substitution' OR cvterm.name = 'indel' OR cvterm.name = 'inversion' OR cvterm.name = 'transgenic_insertion' OR cvterm.name = 'duplication' OR cvterm.name = 'tandem_duplication' OR cvterm.name = 'direct_tandem_duplication' OR cvterm.name = 'inverted_tandem_duplication' OR cvterm.name = 'copy_number_gain' OR cvterm.name = 'copy_number_loss' OR cvterm.name = 'maternal_uniparental_disomy' OR cvterm.name = 'paternal_uniparental_disomy' OR cvterm.name = 'complex_structural_alteration' OR cvterm.name = 'sequence_length_variation' OR cvterm.name = 'MNP' OR cvterm.name = 'SNV' OR cvterm.name = 'complex_substitution' OR cvterm.name = 'simple_sequence_length_variation' OR cvterm.name = 'SNP' OR cvterm.name = 'point_mutation' OR cvterm.name = 'transition' OR cvterm.name = 'transversion' OR cvterm.name = 'pyrimidine_transition' OR cvterm.name = 'purine_transition' OR cvterm.name = 'C_to_T_transition' OR cvterm.name = 'T_to_C_transition' OR cvterm.name = 'C_to_T_transition_at_pCpG_site' OR cvterm.name = 'A_to_G_transition' OR cvterm.name = 'G_to_A_transition' OR cvterm.name = 'pyrimidine_to_purine_transversion' OR cvterm.name = 'purine_to_pyrimidine_transversion' OR cvterm.name = 'C_to_A_transversion' OR cvterm.name = 'C_to_G_transversion' OR cvterm.name = 'T_to_A_transversion' OR cvterm.name = 'T_to_G_transversion' OR cvterm.name = 'A_to_C_transversion' OR cvterm.name = 'A_to_T_transversion' OR cvterm.name = 'G_to_C_transversion' OR cvterm.name = 'G_to_T_transversion' OR cvterm.name = 'sequence_alteration';

--- ************************************************
--- *** relation: sequence_variant ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence_variant is a non exact copy o ***
--- *** f a sequence_feature or genome exhibitin ***
--- *** g one or more sequence_alteration.       ***
--- ************************************************
---

CREATE VIEW sequence_variant AS
  SELECT
    feature_id AS sequence_variant_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'functional_variant' OR cvterm.name = 'structural_variant' OR cvterm.name = 'loss_of_heterozygosity' OR cvterm.name = 'transcript_function_variant' OR cvterm.name = 'translational_product_function_variant' OR cvterm.name = 'level_of_transcript_variant' OR cvterm.name = 'transcript_processing_variant' OR cvterm.name = 'transcript_stability_variant' OR cvterm.name = 'transcription_variant' OR cvterm.name = 'decreased_transcript_level_variant' OR cvterm.name = 'increased_transcript_level_variant' OR cvterm.name = 'editing_variant' OR cvterm.name = 'polyadenylation_variant' OR cvterm.name = 'increased_polyadenylation_variant' OR cvterm.name = 'decreased_polyadenylation_variant' OR cvterm.name = 'decreased_transcript_stability_variant' OR cvterm.name = 'increased_transcript_stability_variant' OR cvterm.name = 'rate_of_transcription_variant' OR cvterm.name = 'increased_transcription_rate_variant' OR cvterm.name = 'decreased_transcription_rate_variant' OR cvterm.name = 'translational_product_level_variant' OR cvterm.name = 'polypeptide_function_variant' OR cvterm.name = 'decreased_translational_product_level' OR cvterm.name = 'increased_translational_product_level' OR cvterm.name = 'polypeptide_gain_of_function_variant' OR cvterm.name = 'polypeptide_localization_variant' OR cvterm.name = 'polypeptide_loss_of_function_variant' OR cvterm.name = 'polypeptide_post_translational_processing_variant' OR cvterm.name = 'inactive_ligand_binding_site' OR cvterm.name = 'polypeptide_partial_loss_of_function' OR cvterm.name = 'inactive_catalytic_site' OR cvterm.name = 'silent_mutation' OR cvterm.name = 'copy_number_change' OR cvterm.name = 'gene_variant' OR cvterm.name = 'regulatory_region_variant' OR cvterm.name = 'intergenic_variant' OR cvterm.name = 'upstream_gene_variant' OR cvterm.name = 'downstream_gene_variant' OR cvterm.name = 'gene_fusion' OR cvterm.name = 'splicing_variant' OR cvterm.name = 'transcript_variant' OR cvterm.name = 'translational_product_structure_variant' OR cvterm.name = 'cryptic_splice_site_variant' OR cvterm.name = 'exon_loss' OR cvterm.name = 'intron_gain' OR cvterm.name = 'splice_region_variant' OR cvterm.name = 'cryptic_splice_acceptor' OR cvterm.name = 'cryptic_splice_donor' OR cvterm.name = 'complex_change_in_transcript' OR cvterm.name = 'transcript_secondary_structure_variant' OR cvterm.name = 'nc_transcript_variant' OR cvterm.name = 'NMD_transcript_variant' OR cvterm.name = 'UTR_variant' OR cvterm.name = 'intron_variant' OR cvterm.name = 'exon_variant' OR cvterm.name = 'compensatory_transcript_secondary_structure_variant' OR cvterm.name = 'mature_miRNA_variant' OR cvterm.name = '5_prime_UTR_variant' OR cvterm.name = '3_prime_UTR_variant' OR cvterm.name = 'splice_site_variant' OR cvterm.name = 'splice_acceptor_variant' OR cvterm.name = 'splice_donor_variant' OR cvterm.name = 'splice_donor_5th_base_variant' OR cvterm.name = 'coding_sequence_variant' OR cvterm.name = 'non_coding_exon_variant' OR cvterm.name = 'codon_variant' OR cvterm.name = 'frameshift_variant' OR cvterm.name = 'inframe_variant' OR cvterm.name = 'initiator_codon_change' OR cvterm.name = 'non_synonymous_codon' OR cvterm.name = 'synonymous_codon' OR cvterm.name = 'terminal_codon_variant' OR cvterm.name = 'stop_gained' OR cvterm.name = 'missense_codon' OR cvterm.name = 'conservative_missense_codon' OR cvterm.name = 'non_conservative_missense_codon' OR cvterm.name = 'terminator_codon_variant' OR cvterm.name = 'incomplete_terminal_codon_variant' OR cvterm.name = 'stop_retained_variant' OR cvterm.name = 'stop_lost' OR cvterm.name = 'frame_restoring_variant' OR cvterm.name = 'minus_1_frameshift_variant' OR cvterm.name = 'minus_2_frameshift_variant' OR cvterm.name = 'plus_1_frameshift_variant' OR cvterm.name = 'plus_2_frameshift variant' OR cvterm.name = 'inframe_codon_gain' OR cvterm.name = 'inframe_codon_loss' OR cvterm.name = '3D_polypeptide_structure_variant' OR cvterm.name = 'complex_change_of_translational_product_variant' OR cvterm.name = 'polypeptide_sequence_variant' OR cvterm.name = 'complex_3D_structural_variant' OR cvterm.name = 'conformational_change_variant' OR cvterm.name = 'amino_acid_deletion' OR cvterm.name = 'amino_acid_insertion' OR cvterm.name = 'amino_acid_substitution' OR cvterm.name = 'elongated_polypeptide' OR cvterm.name = 'polypeptide_fusion' OR cvterm.name = 'polypeptide_truncation' OR cvterm.name = 'conservative_amino_acid_substitution' OR cvterm.name = 'non_conservative_amino_acid_substitution' OR cvterm.name = 'elongated_polypeptide_C_terminal' OR cvterm.name = 'elongated_polypeptide_N_terminal' OR cvterm.name = 'elongated_in_frame_polypeptide_C_terminal' OR cvterm.name = 'elongated_out_of_frame_polypeptide_C_terminal' OR cvterm.name = 'elongated_in_frame_polypeptide_N_terminal_elongation' OR cvterm.name = 'elongated_out_of_frame_polypeptide_N_terminal' OR cvterm.name = 'TF_binding_site_variant' OR cvterm.name = '5KB_upstream_variant' OR cvterm.name = '2KB_upstream_variant' OR cvterm.name = '5KB_downstream_variant' OR cvterm.name = '500B_downstream_variant' OR cvterm.name = 'sequence_variant';

--- ************************************************
--- *** relation: propeptide_cleavage_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The propeptide_cleavage_site is the argi ***
--- *** nine/lysine boundary on a propeptide whe ***
--- *** re cleavage occurs.                      ***
--- ************************************************
---

CREATE VIEW propeptide_cleavage_site AS
  SELECT
    feature_id AS propeptide_cleavage_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'propeptide_cleavage_site';

--- ************************************************
--- *** relation: propeptide ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Part of a peptide chain which is cleaved ***
--- ***  off during the formation of the mature  ***
--- *** protein.                                 ***
--- ************************************************
---

CREATE VIEW propeptide AS
  SELECT
    feature_id AS propeptide_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'propeptide';

--- ************************************************
--- *** relation: immature_peptide_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An immature_peptide_region is the extent ***
--- ***  of the peptide after it has been transl ***
--- *** ated and before any processing occurs.   ***
--- ************************************************
---

CREATE VIEW immature_peptide_region AS
  SELECT
    feature_id AS immature_peptide_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'immature_peptide_region';

--- ************************************************
--- *** relation: active_peptide ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Active peptides are proteins which are b ***
--- *** iologically active, released from a prec ***
--- *** ursor molecule.                          ***
--- ************************************************
---

CREATE VIEW active_peptide AS
  SELECT
    feature_id AS active_peptide_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'active_peptide';

--- ************************************************
--- *** relation: compositionally_biased_region_of_peptide ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Polypeptide region that is rich in a par ***
--- *** ticular amino acid or homopolymeric and  ***
--- *** greater than three residues in length.   ***
--- ************************************************
---

CREATE VIEW compositionally_biased_region_of_peptide AS
  SELECT
    feature_id AS compositionally_biased_region_of_peptide_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'compositionally_biased_region_of_peptide';

--- ************************************************
--- *** relation: polypeptide_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence motif is a short (up to 20 am ***
--- *** ino acids) region of biological interest ***
--- *** . Such motifs, although they are too sho ***
--- *** rt to constitute functional domains, sha ***
--- *** re sequence similarities and are conserv ***
--- *** ed in different proteins. They display a ***
--- ***  common function (protein-binding, subce ***
--- *** llular location etc.).                   ***
--- ************************************************
---

CREATE VIEW polypeptide_motif AS
  SELECT
    feature_id AS polypeptide_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'biochemical_region_of_peptide' OR cvterm.name = 'polypeptide_conserved_motif' OR cvterm.name = 'post_translationally_modified_region' OR cvterm.name = 'conformational_switch' OR cvterm.name = 'molecular_contact_region' OR cvterm.name = 'polypeptide_binding_motif' OR cvterm.name = 'polypeptide_catalytic_motif' OR cvterm.name = 'histone_modification' OR cvterm.name = 'histone_methylation_site' OR cvterm.name = 'histone_acetylation_site' OR cvterm.name = 'histone_ubiqitination_site' OR cvterm.name = 'histone_acylation_region' OR cvterm.name = 'H4K20_monomethylation_site' OR cvterm.name = 'H2BK5_monomethylation_site' OR cvterm.name = 'H3K27_methylation_site' OR cvterm.name = 'H3K36_methylation_site' OR cvterm.name = 'H3K4_methylation_site' OR cvterm.name = 'H3K79_methylation_site' OR cvterm.name = 'H3K9_methylation_site' OR cvterm.name = 'H3K27_monomethylation_site' OR cvterm.name = 'H3K27_trimethylation_site' OR cvterm.name = 'H3K27_dimethylation_site' OR cvterm.name = 'H3K36_monomethylation_site' OR cvterm.name = 'H3K36_dimethylation_site' OR cvterm.name = 'H3K36_trimethylation_site' OR cvterm.name = 'H3K4_monomethylation_site' OR cvterm.name = 'H3K4_trimethylation' OR cvterm.name = 'H3K4_dimethylation_site' OR cvterm.name = 'H3K79_monomethylation_site' OR cvterm.name = 'H3K79_dimethylation_site' OR cvterm.name = 'H3K79_trimethylation_site' OR cvterm.name = 'H3K9_trimethylation_site' OR cvterm.name = 'H3K9_monomethylation_site' OR cvterm.name = 'H3K9_dimethylation_site' OR cvterm.name = 'H3K9_acetylation_site' OR cvterm.name = 'H3K14_acetylation_site' OR cvterm.name = 'H3K18_acetylation_site' OR cvterm.name = 'H3K23_acylation site' OR cvterm.name = 'H3K27_acylation_site' OR cvterm.name = 'H4K16_acylation_site' OR cvterm.name = 'H4K5_acylation_site' OR cvterm.name = 'H4K8_acylation site' OR cvterm.name = 'H2B_ubiquitination_site' OR cvterm.name = 'H4K_acylation_region' OR cvterm.name = 'polypeptide_metal_contact' OR cvterm.name = 'protein_protein_contact' OR cvterm.name = 'polypeptide_ligand_contact' OR cvterm.name = 'polypeptide_DNA_contact' OR cvterm.name = 'polypeptide_calcium_ion_contact_site' OR cvterm.name = 'polypeptide_cobalt_ion_contact_site' OR cvterm.name = 'polypeptide_copper_ion_contact_site' OR cvterm.name = 'polypeptide_iron_ion_contact_site' OR cvterm.name = 'polypeptide_magnesium_ion_contact_site' OR cvterm.name = 'polypeptide_manganese_ion_contact_site' OR cvterm.name = 'polypeptide_molybdenum_ion_contact_site' OR cvterm.name = 'polypeptide_nickel_ion_contact_site' OR cvterm.name = 'polypeptide_tungsten_ion_contact_site' OR cvterm.name = 'polypeptide_zinc_ion_contact_site' OR cvterm.name = 'polypeptide_motif';

--- ************************************************
--- *** relation: polypeptide_repeat ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A polypeptide_repeat is a single copy of ***
--- ***  an internal sequence repetition.        ***
--- ************************************************
---

CREATE VIEW polypeptide_repeat AS
  SELECT
    feature_id AS polypeptide_repeat_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_repeat';

--- ************************************************
--- *** relation: polypeptide_structural_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Region of polypeptide with a given struc ***
--- *** tural property.                          ***
--- ************************************************
---

CREATE VIEW polypeptide_structural_region AS
  SELECT
    feature_id AS polypeptide_structural_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_domain' OR cvterm.name = 'membrane_structure' OR cvterm.name = 'extramembrane_polypeptide_region' OR cvterm.name = 'intramembrane_polypeptide_region' OR cvterm.name = 'polypeptide_secondary_structure' OR cvterm.name = 'polypeptide_structural_motif' OR cvterm.name = 'intrinsically_unstructured_polypeptide_region' OR cvterm.name = 'cytoplasmic_polypeptide_region' OR cvterm.name = 'non_cytoplasmic_polypeptide_region' OR cvterm.name = 'membrane_peptide_loop' OR cvterm.name = 'transmembrane_polypeptide_region' OR cvterm.name = 'asx_motif' OR cvterm.name = 'beta_bulge' OR cvterm.name = 'beta_bulge_loop' OR cvterm.name = 'beta_strand' OR cvterm.name = 'peptide_helix' OR cvterm.name = 'polypeptide_nest_motif' OR cvterm.name = 'schellmann_loop' OR cvterm.name = 'serine_threonine_motif' OR cvterm.name = 'serine_threonine_staple_motif' OR cvterm.name = 'polypeptide_turn_motif' OR cvterm.name = 'catmat_left_handed_three' OR cvterm.name = 'catmat_left_handed_four' OR cvterm.name = 'catmat_right_handed_three' OR cvterm.name = 'catmat_right_handed_four' OR cvterm.name = 'alpha_beta_motif' OR cvterm.name = 'peptide_coil' OR cvterm.name = 'beta_bulge_loop_five' OR cvterm.name = 'beta_bulge_loop_six' OR cvterm.name = 'antiparallel_beta_strand' OR cvterm.name = 'parallel_beta_strand' OR cvterm.name = 'left_handed_peptide_helix' OR cvterm.name = 'right_handed_peptide_helix' OR cvterm.name = 'alpha_helix' OR cvterm.name = 'pi_helix' OR cvterm.name = 'three_ten_helix' OR cvterm.name = 'polypeptide_nest_left_right_motif' OR cvterm.name = 'polypeptide_nest_right_left_motif' OR cvterm.name = 'schellmann_loop_seven' OR cvterm.name = 'schellmann_loop_six' OR cvterm.name = 'asx_turn' OR cvterm.name = 'beta_turn' OR cvterm.name = 'gamma_turn' OR cvterm.name = 'serine_threonine_turn' OR cvterm.name = 'asx_turn_left_handed_type_one' OR cvterm.name = 'asx_turn_left_handed_type_two' OR cvterm.name = 'asx_turn_right_handed_type_two' OR cvterm.name = 'asx_turn_right_handed_type_one' OR cvterm.name = 'beta_turn_left_handed_type_one' OR cvterm.name = 'beta_turn_left_handed_type_two' OR cvterm.name = 'beta_turn_right_handed_type_one' OR cvterm.name = 'beta_turn_right_handed_type_two' OR cvterm.name = 'beta_turn_type_six' OR cvterm.name = 'beta_turn_type_eight' OR cvterm.name = 'beta_turn_type_six_a' OR cvterm.name = 'beta_turn_type_six_b' OR cvterm.name = 'beta_turn_type_six_a_one' OR cvterm.name = 'beta_turn_type_six_a_two' OR cvterm.name = 'gamma_turn_classic' OR cvterm.name = 'gamma_turn_inverse' OR cvterm.name = 'st_turn_left_handed_type_one' OR cvterm.name = 'st_turn_left_handed_type_two' OR cvterm.name = 'st_turn_right_handed_type_one' OR cvterm.name = 'st_turn_right_handed_type_two' OR cvterm.name = 'coiled_coil' OR cvterm.name = 'helix_turn_helix' OR cvterm.name = 'polypeptide_structural_region';

--- ************************************************
--- *** relation: membrane_structure ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Arrangement of the polypeptide with resp ***
--- *** ect to the lipid bilayer.                ***
--- ************************************************
---

CREATE VIEW membrane_structure AS
  SELECT
    feature_id AS membrane_structure_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'membrane_structure';

--- ************************************************
--- *** relation: extramembrane_polypeptide_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Polypeptide region that is localized out ***
--- *** side of a lipid bilayer.                 ***
--- ************************************************
---

CREATE VIEW extramembrane_polypeptide_region AS
  SELECT
    feature_id AS extramembrane_polypeptide_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cytoplasmic_polypeptide_region' OR cvterm.name = 'non_cytoplasmic_polypeptide_region' OR cvterm.name = 'extramembrane_polypeptide_region';

--- ************************************************
--- *** relation: cytoplasmic_polypeptide_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Polypeptide region that is localized ins ***
--- *** ide the cytoplasm.                       ***
--- ************************************************
---

CREATE VIEW cytoplasmic_polypeptide_region AS
  SELECT
    feature_id AS cytoplasmic_polypeptide_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cytoplasmic_polypeptide_region';

--- ************************************************
--- *** relation: non_cytoplasmic_polypeptide_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Polypeptide region that is localized out ***
--- *** side of a lipid bilayer and outside of t ***
--- *** he cytoplasm.                            ***
--- ************************************************
---

CREATE VIEW non_cytoplasmic_polypeptide_region AS
  SELECT
    feature_id AS non_cytoplasmic_polypeptide_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'non_cytoplasmic_polypeptide_region';

--- ************************************************
--- *** relation: intramembrane_polypeptide_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Polypeptide region present in the lipid  ***
--- *** bilayer.                                 ***
--- ************************************************
---

CREATE VIEW intramembrane_polypeptide_region AS
  SELECT
    feature_id AS intramembrane_polypeptide_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'membrane_peptide_loop' OR cvterm.name = 'transmembrane_polypeptide_region' OR cvterm.name = 'intramembrane_polypeptide_region';

--- ************************************************
--- *** relation: membrane_peptide_loop ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Polypeptide region localized within the  ***
--- *** lipid bilayer where both ends traverse t ***
--- *** he same membrane.                        ***
--- ************************************************
---

CREATE VIEW membrane_peptide_loop AS
  SELECT
    feature_id AS membrane_peptide_loop_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'membrane_peptide_loop';

--- ************************************************
--- *** relation: transmembrane_polypeptide_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Polypeptide region traversing the lipid  ***
--- *** bilayer.                                 ***
--- ************************************************
---

CREATE VIEW transmembrane_polypeptide_region AS
  SELECT
    feature_id AS transmembrane_polypeptide_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transmembrane_polypeptide_region';

--- ************************************************
--- *** relation: polypeptide_secondary_structure ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of peptide with secondary struc ***
--- *** ture has hydrogen bonding along the pept ***
--- *** ide chain that causes a defined conforma ***
--- *** tion of the chain.                       ***
--- ************************************************
---

CREATE VIEW polypeptide_secondary_structure AS
  SELECT
    feature_id AS polypeptide_secondary_structure_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'asx_motif' OR cvterm.name = 'beta_bulge' OR cvterm.name = 'beta_bulge_loop' OR cvterm.name = 'beta_strand' OR cvterm.name = 'peptide_helix' OR cvterm.name = 'polypeptide_nest_motif' OR cvterm.name = 'schellmann_loop' OR cvterm.name = 'serine_threonine_motif' OR cvterm.name = 'serine_threonine_staple_motif' OR cvterm.name = 'polypeptide_turn_motif' OR cvterm.name = 'catmat_left_handed_three' OR cvterm.name = 'catmat_left_handed_four' OR cvterm.name = 'catmat_right_handed_three' OR cvterm.name = 'catmat_right_handed_four' OR cvterm.name = 'alpha_beta_motif' OR cvterm.name = 'peptide_coil' OR cvterm.name = 'beta_bulge_loop_five' OR cvterm.name = 'beta_bulge_loop_six' OR cvterm.name = 'antiparallel_beta_strand' OR cvterm.name = 'parallel_beta_strand' OR cvterm.name = 'left_handed_peptide_helix' OR cvterm.name = 'right_handed_peptide_helix' OR cvterm.name = 'alpha_helix' OR cvterm.name = 'pi_helix' OR cvterm.name = 'three_ten_helix' OR cvterm.name = 'polypeptide_nest_left_right_motif' OR cvterm.name = 'polypeptide_nest_right_left_motif' OR cvterm.name = 'schellmann_loop_seven' OR cvterm.name = 'schellmann_loop_six' OR cvterm.name = 'asx_turn' OR cvterm.name = 'beta_turn' OR cvterm.name = 'gamma_turn' OR cvterm.name = 'serine_threonine_turn' OR cvterm.name = 'asx_turn_left_handed_type_one' OR cvterm.name = 'asx_turn_left_handed_type_two' OR cvterm.name = 'asx_turn_right_handed_type_two' OR cvterm.name = 'asx_turn_right_handed_type_one' OR cvterm.name = 'beta_turn_left_handed_type_one' OR cvterm.name = 'beta_turn_left_handed_type_two' OR cvterm.name = 'beta_turn_right_handed_type_one' OR cvterm.name = 'beta_turn_right_handed_type_two' OR cvterm.name = 'beta_turn_type_six' OR cvterm.name = 'beta_turn_type_eight' OR cvterm.name = 'beta_turn_type_six_a' OR cvterm.name = 'beta_turn_type_six_b' OR cvterm.name = 'beta_turn_type_six_a_one' OR cvterm.name = 'beta_turn_type_six_a_two' OR cvterm.name = 'gamma_turn_classic' OR cvterm.name = 'gamma_turn_inverse' OR cvterm.name = 'st_turn_left_handed_type_one' OR cvterm.name = 'st_turn_left_handed_type_two' OR cvterm.name = 'st_turn_right_handed_type_one' OR cvterm.name = 'st_turn_right_handed_type_two' OR cvterm.name = 'polypeptide_secondary_structure';

--- ************************************************
--- *** relation: polypeptide_structural_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Motif is a three-dimensional structural  ***
--- *** element within the chain, which appears  ***
--- *** also in a variety of other molecules. Un ***
--- *** like a domain, a motif does not need to  ***
--- *** form a stable globular unit.             ***
--- ************************************************
---

CREATE VIEW polypeptide_structural_motif AS
  SELECT
    feature_id AS polypeptide_structural_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'coiled_coil' OR cvterm.name = 'helix_turn_helix' OR cvterm.name = 'polypeptide_structural_motif';

--- ************************************************
--- *** relation: coiled_coil ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A coiled coil is a structural motif in p ***
--- *** roteins, in which alpha-helices are coil ***
--- *** ed together like the strands of a rope.  ***
--- ************************************************
---

CREATE VIEW coiled_coil AS
  SELECT
    feature_id AS coiled_coil_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'coiled_coil';

--- ************************************************
--- *** relation: helix_turn_helix ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif comprising two helices separated ***
--- ***  by a turn.                              ***
--- ************************************************
---

CREATE VIEW helix_turn_helix AS
  SELECT
    feature_id AS helix_turn_helix_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'helix_turn_helix';

--- ************************************************
--- *** relation: polypeptide_sequencing_information ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Incompatibility in the sequence due to s ***
--- *** ome experimental problem.                ***
--- ************************************************
---

CREATE VIEW polypeptide_sequencing_information AS
  SELECT
    feature_id AS polypeptide_sequencing_information_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'non_adjacent_residues' OR cvterm.name = 'non_terminal_residue' OR cvterm.name = 'sequence_conflict' OR cvterm.name = 'sequence_uncertainty' OR cvterm.name = 'contig_collection' OR cvterm.name = 'polypeptide_sequencing_information';

--- ************************************************
--- *** relation: non_adjacent_residues ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Indicates that two consecutive residues  ***
--- *** in a fragment sequence are not consecuti ***
--- *** ve in the full-length protein and that t ***
--- *** here are a number of unsequenced residue ***
--- *** s between them.                          ***
--- ************************************************
---

CREATE VIEW non_adjacent_residues AS
  SELECT
    feature_id AS non_adjacent_residues_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'non_adjacent_residues';

--- ************************************************
--- *** relation: non_terminal_residue ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The residue at an extremity of the seque ***
--- *** nce is not the terminal residue.         ***
--- ************************************************
---

CREATE VIEW non_terminal_residue AS
  SELECT
    feature_id AS non_terminal_residue_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'non_terminal_residue';

--- ************************************************
--- *** relation: sequence_conflict ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Different sources report differing seque ***
--- *** nces.                                    ***
--- ************************************************
---

CREATE VIEW sequence_conflict AS
  SELECT
    feature_id AS sequence_conflict_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'contig_collection' OR cvterm.name = 'sequence_conflict';

--- ************************************************
--- *** relation: sequence_uncertainty ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Describes the positions in a sequence wh ***
--- *** ere the authors are unsure about the seq ***
--- *** uence assignment.                        ***
--- ************************************************
---

CREATE VIEW sequence_uncertainty AS
  SELECT
    feature_id AS sequence_uncertainty_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'sequence_uncertainty';

--- ************************************************
--- *** relation: post_translationally_modified_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region where a transformation occurs i ***
--- *** n a protein after it has been synthesize ***
--- *** d. This which may regulate, stabilize, c ***
--- *** rosslink or introduce new chemical funct ***
--- *** ionalities in the protein.               ***
--- ************************************************
---

CREATE VIEW post_translationally_modified_region AS
  SELECT
    feature_id AS post_translationally_modified_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'histone_modification' OR cvterm.name = 'histone_methylation_site' OR cvterm.name = 'histone_acetylation_site' OR cvterm.name = 'histone_ubiqitination_site' OR cvterm.name = 'histone_acylation_region' OR cvterm.name = 'H4K20_monomethylation_site' OR cvterm.name = 'H2BK5_monomethylation_site' OR cvterm.name = 'H3K27_methylation_site' OR cvterm.name = 'H3K36_methylation_site' OR cvterm.name = 'H3K4_methylation_site' OR cvterm.name = 'H3K79_methylation_site' OR cvterm.name = 'H3K9_methylation_site' OR cvterm.name = 'H3K27_monomethylation_site' OR cvterm.name = 'H3K27_trimethylation_site' OR cvterm.name = 'H3K27_dimethylation_site' OR cvterm.name = 'H3K36_monomethylation_site' OR cvterm.name = 'H3K36_dimethylation_site' OR cvterm.name = 'H3K36_trimethylation_site' OR cvterm.name = 'H3K4_monomethylation_site' OR cvterm.name = 'H3K4_trimethylation' OR cvterm.name = 'H3K4_dimethylation_site' OR cvterm.name = 'H3K79_monomethylation_site' OR cvterm.name = 'H3K79_dimethylation_site' OR cvterm.name = 'H3K79_trimethylation_site' OR cvterm.name = 'H3K9_trimethylation_site' OR cvterm.name = 'H3K9_monomethylation_site' OR cvterm.name = 'H3K9_dimethylation_site' OR cvterm.name = 'H3K9_acetylation_site' OR cvterm.name = 'H3K14_acetylation_site' OR cvterm.name = 'H3K18_acetylation_site' OR cvterm.name = 'H3K23_acylation site' OR cvterm.name = 'H3K27_acylation_site' OR cvterm.name = 'H4K16_acylation_site' OR cvterm.name = 'H4K5_acylation_site' OR cvterm.name = 'H4K8_acylation site' OR cvterm.name = 'H2B_ubiquitination_site' OR cvterm.name = 'H4K_acylation_region' OR cvterm.name = 'post_translationally_modified_region';

--- ************************************************
--- *** relation: polypeptide_metal_contact ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A binding site that, in the polypeptide  ***
--- *** molecule, interacts selectively and non- ***
--- *** covalently with metal ions.              ***
--- ************************************************
---

CREATE VIEW polypeptide_metal_contact AS
  SELECT
    feature_id AS polypeptide_metal_contact_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_calcium_ion_contact_site' OR cvterm.name = 'polypeptide_cobalt_ion_contact_site' OR cvterm.name = 'polypeptide_copper_ion_contact_site' OR cvterm.name = 'polypeptide_iron_ion_contact_site' OR cvterm.name = 'polypeptide_magnesium_ion_contact_site' OR cvterm.name = 'polypeptide_manganese_ion_contact_site' OR cvterm.name = 'polypeptide_molybdenum_ion_contact_site' OR cvterm.name = 'polypeptide_nickel_ion_contact_site' OR cvterm.name = 'polypeptide_tungsten_ion_contact_site' OR cvterm.name = 'polypeptide_zinc_ion_contact_site' OR cvterm.name = 'polypeptide_metal_contact';

--- ************************************************
--- *** relation: protein_protein_contact ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A binding site that, in the protein mole ***
--- *** cule, interacts selectively and non-cova ***
--- *** lently with polypeptide residues.        ***
--- ************************************************
---

CREATE VIEW protein_protein_contact AS
  SELECT
    feature_id AS protein_protein_contact_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'protein_protein_contact';

--- ************************************************
--- *** relation: polypeptide_calcium_ion_contact_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A binding site that, in the polypeptide  ***
--- *** molecule, interacts selectively and non- ***
--- *** covalently with calcium ions.            ***
--- ************************************************
---

CREATE VIEW polypeptide_calcium_ion_contact_site AS
  SELECT
    feature_id AS polypeptide_calcium_ion_contact_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_calcium_ion_contact_site';

--- ************************************************
--- *** relation: polypeptide_cobalt_ion_contact_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A binding site that, in the polypeptide  ***
--- *** molecule, interacts selectively and non- ***
--- *** covalently with cobalt ions.             ***
--- ************************************************
---

CREATE VIEW polypeptide_cobalt_ion_contact_site AS
  SELECT
    feature_id AS polypeptide_cobalt_ion_contact_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_cobalt_ion_contact_site';

--- ************************************************
--- *** relation: polypeptide_copper_ion_contact_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A binding site that, in the polypeptide  ***
--- *** molecule, interacts selectively and non- ***
--- *** covalently with copper ions.             ***
--- ************************************************
---

CREATE VIEW polypeptide_copper_ion_contact_site AS
  SELECT
    feature_id AS polypeptide_copper_ion_contact_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_copper_ion_contact_site';

--- ************************************************
--- *** relation: polypeptide_iron_ion_contact_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A binding site that, in the polypeptide  ***
--- *** molecule, interacts selectively and non- ***
--- *** covalently with iron ions.               ***
--- ************************************************
---

CREATE VIEW polypeptide_iron_ion_contact_site AS
  SELECT
    feature_id AS polypeptide_iron_ion_contact_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_iron_ion_contact_site';

--- ************************************************
--- *** relation: polypeptide_magnesium_ion_contact_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A binding site that, in the polypeptide  ***
--- *** molecule, interacts selectively and non- ***
--- *** covalently with magnesium ions.          ***
--- ************************************************
---

CREATE VIEW polypeptide_magnesium_ion_contact_site AS
  SELECT
    feature_id AS polypeptide_magnesium_ion_contact_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_magnesium_ion_contact_site';

--- ************************************************
--- *** relation: polypeptide_manganese_ion_contact_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A binding site that, in the polypeptide  ***
--- *** molecule, interacts selectively and non- ***
--- *** covalently with manganese ions.          ***
--- ************************************************
---

CREATE VIEW polypeptide_manganese_ion_contact_site AS
  SELECT
    feature_id AS polypeptide_manganese_ion_contact_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_manganese_ion_contact_site';

--- ************************************************
--- *** relation: polypeptide_molybdenum_ion_contact_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A binding site that, in the polypeptide  ***
--- *** molecule, interacts selectively and non- ***
--- *** covalently with molybdenum ions.         ***
--- ************************************************
---

CREATE VIEW polypeptide_molybdenum_ion_contact_site AS
  SELECT
    feature_id AS polypeptide_molybdenum_ion_contact_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_molybdenum_ion_contact_site';

--- ************************************************
--- *** relation: polypeptide_nickel_ion_contact_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A binding site that, in the polypeptide  ***
--- *** molecule, interacts selectively and non- ***
--- *** covalently with nickel ions.             ***
--- ************************************************
---

CREATE VIEW polypeptide_nickel_ion_contact_site AS
  SELECT
    feature_id AS polypeptide_nickel_ion_contact_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_nickel_ion_contact_site';

--- ************************************************
--- *** relation: polypeptide_tungsten_ion_contact_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A binding site that, in the polypeptide  ***
--- *** molecule, interacts selectively and non- ***
--- *** covalently with tungsten ions.           ***
--- ************************************************
---

CREATE VIEW polypeptide_tungsten_ion_contact_site AS
  SELECT
    feature_id AS polypeptide_tungsten_ion_contact_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_tungsten_ion_contact_site';

--- ************************************************
--- *** relation: polypeptide_zinc_ion_contact_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A binding site that, in the polypeptide  ***
--- *** molecule, interacts selectively and non- ***
--- *** covalently with zinc ions.               ***
--- ************************************************
---

CREATE VIEW polypeptide_zinc_ion_contact_site AS
  SELECT
    feature_id AS polypeptide_zinc_ion_contact_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_zinc_ion_contact_site';

--- ************************************************
--- *** relation: catalytic_residue ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Amino acid involved in the activity of a ***
--- *** n enzyme.                                ***
--- ************************************************
---

CREATE VIEW catalytic_residue AS
  SELECT
    feature_id AS catalytic_residue_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'catalytic_residue';

--- ************************************************
--- *** relation: polypeptide_ligand_contact ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Residues which interact with a ligand.   ***
--- ************************************************
---

CREATE VIEW polypeptide_ligand_contact AS
  SELECT
    feature_id AS polypeptide_ligand_contact_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_ligand_contact';

--- ************************************************
--- *** relation: asx_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of five consecutive residues and ***
--- ***  two H-bonds in which: Residue(i) is Asp ***
--- *** artate or Asparagine (Asx), side-chain O ***
--- ***  of residue(i) is H-bonded to the main-c ***
--- *** hain NH of residue(i+2) or (i+3), main-c ***
--- *** hain CO of residue(i) is H-bonded to the ***
--- ***  main-chain NH of residue(i+3) or (i+4). ***
--- ************************************************
---

CREATE VIEW asx_motif AS
  SELECT
    feature_id AS asx_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'asx_motif';

--- ************************************************
--- *** relation: beta_bulge ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of three residues within a beta- ***
--- *** sheet in which the main chains of two co ***
--- *** nsecutive residues are H-bonded to that  ***
--- *** of the third, and in which the dihedral  ***
--- *** angles are as follows: Residue(i): -140  ***
--- *** degrees < phi(l) -20 degrees , -90 degre ***
--- *** es < psi(l) < 40 degrees. Residue (i+1): ***
--- ***  -180 degrees < phi < -25 degrees or +12 ***
--- *** 0 degrees < phi < +180 degrees, +40 degr ***
--- *** ees < psi < +180 degrees or -180 degrees ***
--- ***  < psi < -120 degrees.                   ***
--- ************************************************
---

CREATE VIEW beta_bulge AS
  SELECT
    feature_id AS beta_bulge_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'beta_bulge';

--- ************************************************
--- *** relation: beta_bulge_loop ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of three residues within a beta- ***
--- *** sheet consisting of two H-bonds. Beta bu ***
--- *** lge loops often occur at the loop ends o ***
--- *** f beta-hairpins.                         ***
--- ************************************************
---

CREATE VIEW beta_bulge_loop AS
  SELECT
    feature_id AS beta_bulge_loop_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'beta_bulge_loop_five' OR cvterm.name = 'beta_bulge_loop_six' OR cvterm.name = 'beta_bulge_loop';

--- ************************************************
--- *** relation: beta_bulge_loop_five ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of three residues within a beta- ***
--- *** sheet consisting of two H-bonds in which ***
--- *** : the main-chain NH of residue(i) is H-b ***
--- *** onded to the main-chain CO of residue(i+ ***
--- *** 4), the main-chain CO of residue i is H- ***
--- *** bonded to the main-chain NH of residue(i ***
--- *** +3), these loops have an RL nest at resi ***
--- *** dues i+2 and i+3.                        ***
--- ************************************************
---

CREATE VIEW beta_bulge_loop_five AS
  SELECT
    feature_id AS beta_bulge_loop_five_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'beta_bulge_loop_five';

--- ************************************************
--- *** relation: beta_bulge_loop_six ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of three residues within a beta- ***
--- *** sheet consisting of two H-bonds in which ***
--- *** : the main-chain NH of residue(i) is H-b ***
--- *** onded to the main-chain CO of residue(i+ ***
--- *** 5), the main-chain CO of residue i is H- ***
--- *** bonded to the main-chain NH of residue(i ***
--- *** +4), these loops have an RL nest at resi ***
--- *** dues i+3 and i+4.                        ***
--- ************************************************
---

CREATE VIEW beta_bulge_loop_six AS
  SELECT
    feature_id AS beta_bulge_loop_six_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'beta_bulge_loop_six';

--- ************************************************
--- *** relation: beta_strand ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A beta strand describes a single length  ***
--- *** of polypeptide chain that forms part of  ***
--- *** a beta sheet. A single continuous stretc ***
--- *** h of amino acids adopting an extended co ***
--- *** nformation of hydrogen bonds between the ***
--- ***  N-O and the C=O of another part of the  ***
--- *** peptide. This forms a secondary protein  ***
--- *** structure in which two or more extended  ***
--- *** polypeptide regions are hydrogen-bonded  ***
--- *** to one another in a planar array.        ***
--- ************************************************
---

CREATE VIEW beta_strand AS
  SELECT
    feature_id AS beta_strand_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'antiparallel_beta_strand' OR cvterm.name = 'parallel_beta_strand' OR cvterm.name = 'beta_strand';

--- ************************************************
--- *** relation: antiparallel_beta_strand ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A peptide region which hydrogen bonded t ***
--- *** o another region of peptide running in t ***
--- *** he oposite direction (one running N-term ***
--- *** inal to C-terminal and one running C-ter ***
--- *** minal to N-terminal). Hydrogen bonding o ***
--- *** ccurs between every other C=O from one s ***
--- *** trand to every other N-H on the adjacent ***
--- ***  strand. In this case, if two atoms C-al ***
--- *** pha (i) and C-alpha (j) are adjacent in  ***
--- *** two hydrogen-bonded beta strands, then t ***
--- *** hey form two mutual backbone hydrogen bo ***
--- *** nds to each other's flanking peptide gro ***
--- *** ups; this is known as a close pair of hy ***
--- *** drogen bonds. The peptide backbone dihed ***
--- *** ral angles (phi, psi) are about (-140 de ***
--- *** grees, 135 degrees) in antiparallel shee ***
--- *** ts.                                      ***
--- ************************************************
---

CREATE VIEW antiparallel_beta_strand AS
  SELECT
    feature_id AS antiparallel_beta_strand_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'antiparallel_beta_strand';

--- ************************************************
--- *** relation: parallel_beta_strand ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A peptide region which hydrogen bonded t ***
--- *** o another region of peptide running in t ***
--- *** he oposite direction (both running N-ter ***
--- *** minal to C-terminal). This orientation i ***
--- *** s slightly less stable because it introd ***
--- *** uces nonplanarity in the inter-strand hy ***
--- *** drogen bonding pattern. Hydrogen bonding ***
--- ***  occurs between every other C=O from one ***
--- ***  strand to every other N-H on the adjace ***
--- *** nt strand. In this case, if two atoms C- ***
--- *** alpha (i)and C-alpha (j) are adjacent in ***
--- ***  two hydrogen-bonded beta strands, then  ***
--- *** they do not hydrogen bond to each other; ***
--- ***  rather, one residue forms hydrogen bond ***
--- *** s to the residues that flank the other ( ***
--- *** but not vice versa). For example, residu ***
--- *** e i may form hydrogen bonds to residues  ***
--- *** j - 1 and j + 1; this is known as a wide ***
--- ***  pair of hydrogen bonds. By contrast, re ***
--- *** sidue j may hydrogen-bond to different r ***
--- *** esidues altogether, or to none at all. T ***
--- *** he dihedral angles (phi, psi) are about  ***
--- *** (-120 degrees, 115 degrees) in parallel  ***
--- *** sheets.                                  ***
--- ************************************************
---

CREATE VIEW parallel_beta_strand AS
  SELECT
    feature_id AS parallel_beta_strand_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'parallel_beta_strand';

--- ************************************************
--- *** relation: peptide_helix ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A helix is a secondary_structure conform ***
--- *** ation where the peptide backbone forms a ***
--- ***  coil.                                   ***
--- ************************************************
---

CREATE VIEW peptide_helix AS
  SELECT
    feature_id AS peptide_helix_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'left_handed_peptide_helix' OR cvterm.name = 'right_handed_peptide_helix' OR cvterm.name = 'alpha_helix' OR cvterm.name = 'pi_helix' OR cvterm.name = 'three_ten_helix' OR cvterm.name = 'peptide_helix';

--- ************************************************
--- *** relation: left_handed_peptide_helix ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A left handed helix is a region of pepti ***
--- *** de where the coiled conformation turns i ***
--- *** n an anticlockwise, left handed screw.   ***
--- ************************************************
---

CREATE VIEW left_handed_peptide_helix AS
  SELECT
    feature_id AS left_handed_peptide_helix_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'left_handed_peptide_helix';

--- ************************************************
--- *** relation: right_handed_peptide_helix ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A right handed helix is a region of pept ***
--- *** ide where the coiled conformation turns  ***
--- *** in a clockwise, right handed screw.      ***
--- ************************************************
---

CREATE VIEW right_handed_peptide_helix AS
  SELECT
    feature_id AS right_handed_peptide_helix_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'alpha_helix' OR cvterm.name = 'pi_helix' OR cvterm.name = 'three_ten_helix' OR cvterm.name = 'right_handed_peptide_helix';

--- ************************************************
--- *** relation: alpha_helix ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The helix has 3.6 residues per turn whic ***
--- *** h corersponds to a translation of 1.5 an ***
--- *** gstroms (= 0.15 nm) along the helical ax ***
--- *** is. Every backbone N-H group donates a h ***
--- *** ydrogen bond to the backbone C=O group o ***
--- *** f the amino acid four residues earlier.  ***
--- ************************************************
---

CREATE VIEW alpha_helix AS
  SELECT
    feature_id AS alpha_helix_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'alpha_helix';

--- ************************************************
--- *** relation: pi_helix ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The pi helix has 4.1 residues per turn a ***
--- *** nd a translation of 1.15  (=0.115 nm) al ***
--- *** ong the helical axis. The N-H group of a ***
--- *** n amino acid forms a hydrogen bond with  ***
--- *** the C=O group of the amino acid five res ***
--- *** idues earlier.                           ***
--- ************************************************
---

CREATE VIEW pi_helix AS
  SELECT
    feature_id AS pi_helix_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pi_helix';

--- ************************************************
--- *** relation: three_ten_helix ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The 3-10 helix has 3 residues per turn w ***
--- *** ith a translation of 2.0 angstroms (=0.2 ***
--- ***  nm) along the helical axis. The N-H gro ***
--- *** up of an amino acid forms a hydrogen bon ***
--- *** d with the C=O group of the amino acid t ***
--- *** hree residues earlier.                   ***
--- ************************************************
---

CREATE VIEW three_ten_helix AS
  SELECT
    feature_id AS three_ten_helix_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_ten_helix';

--- ************************************************
--- *** relation: polypeptide_nest_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of two consecutive residues with ***
--- ***  dihedral angles. Nest should not have P ***
--- *** roline as any residue. Nests frequently  ***
--- *** occur as parts of other motifs such as S ***
--- *** chellman loops.                          ***
--- ************************************************
---

CREATE VIEW polypeptide_nest_motif AS
  SELECT
    feature_id AS polypeptide_nest_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_nest_left_right_motif' OR cvterm.name = 'polypeptide_nest_right_left_motif' OR cvterm.name = 'polypeptide_nest_motif';

--- ************************************************
--- *** relation: polypeptide_nest_left_right_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of two consecutive residues with ***
--- ***  dihedral angles: Residue(i): +20 degree ***
--- *** s < phi < +140 degrees, -40 degrees < ps ***
--- *** i < +90 degrees. Residue(i+1): -140 degr ***
--- *** ees < phi < -20 degrees, -90 degrees < p ***
--- *** si < +40 degrees.                        ***
--- ************************************************
---

CREATE VIEW polypeptide_nest_left_right_motif AS
  SELECT
    feature_id AS polypeptide_nest_left_right_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_nest_left_right_motif';

--- ************************************************
--- *** relation: polypeptide_nest_right_left_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of two consecutive residues with ***
--- ***  dihedral angles: Residue(i): -140 degre ***
--- *** es < phi < -20 degrees, -90 degrees < ps ***
--- *** i < +40 degrees. Residue(i+1): +20 degre ***
--- *** es < phi < +140 degrees, -40 degrees < p ***
--- *** si < +90 degrees.                        ***
--- ************************************************
---

CREATE VIEW polypeptide_nest_right_left_motif AS
  SELECT
    feature_id AS polypeptide_nest_right_left_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypeptide_nest_right_left_motif';

--- ************************************************
--- *** relation: schellmann_loop ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of six or seven consecutive resi ***
--- *** dues that contains two H-bonds.          ***
--- ************************************************
---

CREATE VIEW schellmann_loop AS
  SELECT
    feature_id AS schellmann_loop_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'schellmann_loop_seven' OR cvterm.name = 'schellmann_loop_six' OR cvterm.name = 'schellmann_loop';

--- ************************************************
--- *** relation: schellmann_loop_seven ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Wild type: A motif of seven consecutive  ***
--- *** residues that contains two H-bonds in wh ***
--- *** ich: the main-chain CO of residue(i) is  ***
--- *** H-bonded to the main-chain NH of residue ***
--- *** (i+6), the main-chain CO of residue(i+1) ***
--- ***  is H-bonded to the main-chain NH of res ***
--- *** idue(i+5).                               ***
--- ************************************************
---

CREATE VIEW schellmann_loop_seven AS
  SELECT
    feature_id AS schellmann_loop_seven_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'schellmann_loop_seven';

--- ************************************************
--- *** relation: schellmann_loop_six ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Common Type: A motif of six consecutive  ***
--- *** residues that contains two H-bonds in wh ***
--- *** ich: the main-chain CO of residue(i) is  ***
--- *** H-bonded to the main-chain NH of residue ***
--- *** (i+5) the main-chain CO of residue(i+1)  ***
--- *** is H-bonded to the main-chain NH of resi ***
--- *** due(i+4).                                ***
--- ************************************************
---

CREATE VIEW schellmann_loop_six AS
  SELECT
    feature_id AS schellmann_loop_six_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'schellmann_loop_six';

--- ************************************************
--- *** relation: serine_threonine_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of five consecutive residues and ***
--- ***  two hydrogen bonds in which: residue(i) ***
--- ***  is Serine (S) or Threonine (T), the sid ***
--- *** e-chain O of residue(i) is H-bonded to t ***
--- *** he main-chain NH of residue(i+2) or (i+3 ***
--- *** ) , the main-chain CO group of residue(i ***
--- *** ) is H-bonded to the main-chain NH of re ***
--- *** sidue(i+3) or (i+4).                     ***
--- ************************************************
---

CREATE VIEW serine_threonine_motif AS
  SELECT
    feature_id AS serine_threonine_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'serine_threonine_motif';

--- ************************************************
--- *** relation: serine_threonine_staple_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of four or five consecutive resi ***
--- *** dues and one H-bond in which: residue(i) ***
--- ***  is Serine (S) or Threonine (T), the sid ***
--- *** e-chain OH of residue(i) is H-bonded to  ***
--- *** the main-chain CO of residue(i3) or (i4) ***
--- *** , Phi angles of residues(i1), (i2) and ( ***
--- *** i3) are negative.                        ***
--- ************************************************
---

CREATE VIEW serine_threonine_staple_motif AS
  SELECT
    feature_id AS serine_threonine_staple_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'serine_threonine_staple_motif';

--- ************************************************
--- *** relation: polypeptide_turn_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A reversal in the direction of the backb ***
--- *** one of a protein that is stabilized by h ***
--- *** ydrogen bond between backbone NH and CO  ***
--- *** groups, involving no more than 4 amino a ***
--- *** cid residues.                            ***
--- ************************************************
---

CREATE VIEW polypeptide_turn_motif AS
  SELECT
    feature_id AS polypeptide_turn_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'asx_turn' OR cvterm.name = 'beta_turn' OR cvterm.name = 'gamma_turn' OR cvterm.name = 'serine_threonine_turn' OR cvterm.name = 'asx_turn_left_handed_type_one' OR cvterm.name = 'asx_turn_left_handed_type_two' OR cvterm.name = 'asx_turn_right_handed_type_two' OR cvterm.name = 'asx_turn_right_handed_type_one' OR cvterm.name = 'beta_turn_left_handed_type_one' OR cvterm.name = 'beta_turn_left_handed_type_two' OR cvterm.name = 'beta_turn_right_handed_type_one' OR cvterm.name = 'beta_turn_right_handed_type_two' OR cvterm.name = 'beta_turn_type_six' OR cvterm.name = 'beta_turn_type_eight' OR cvterm.name = 'beta_turn_type_six_a' OR cvterm.name = 'beta_turn_type_six_b' OR cvterm.name = 'beta_turn_type_six_a_one' OR cvterm.name = 'beta_turn_type_six_a_two' OR cvterm.name = 'gamma_turn_classic' OR cvterm.name = 'gamma_turn_inverse' OR cvterm.name = 'st_turn_left_handed_type_one' OR cvterm.name = 'st_turn_left_handed_type_two' OR cvterm.name = 'st_turn_right_handed_type_one' OR cvterm.name = 'st_turn_right_handed_type_two' OR cvterm.name = 'polypeptide_turn_motif';

--- ************************************************
--- *** relation: asx_turn_left_handed_type_one ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Left handed type I (dihedral angles):- R ***
--- *** esidue(i): -140 degrees < chi (1) -120 d ***
--- *** egrees < -20 degrees, -90 degrees < psi  ***
--- *** +120 degrees < +40 degrees. Residue(i+1) ***
--- *** : -140 degrees < phi < -20 degrees, -90  ***
--- *** degrees < psi < +40 degrees.             ***
--- ************************************************
---

CREATE VIEW asx_turn_left_handed_type_one AS
  SELECT
    feature_id AS asx_turn_left_handed_type_one_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'asx_turn_left_handed_type_one';

--- ************************************************
--- *** relation: asx_turn_left_handed_type_two ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Left handed type II (dihedral angles):-  ***
--- *** Residue(i): -140 degrees < chi (1) -120  ***
--- *** degrees < -20 degrees, +80 degrees < psi ***
--- ***  +120 degrees < +180 degrees. Residue(i+ ***
--- *** 1): +20 degrees < phi < +140 degrees, -4 ***
--- *** 0 degrees < psi < +90 degrees.           ***
--- ************************************************
---

CREATE VIEW asx_turn_left_handed_type_two AS
  SELECT
    feature_id AS asx_turn_left_handed_type_two_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'asx_turn_left_handed_type_two';

--- ************************************************
--- *** relation: asx_turn_right_handed_type_two ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Right handed type II (dihedral angles):- ***
--- ***  Residue(i): -140 degrees < chi (1) -120 ***
--- ***  degrees < -20 degrees, +80 degrees < ps ***
--- *** i +120 degrees < +180 degrees. Residue(i ***
--- *** +1): +20 degrees < phi < +140 degrees, - ***
--- *** 40 degrees < psi < +90 degrees.          ***
--- ************************************************
---

CREATE VIEW asx_turn_right_handed_type_two AS
  SELECT
    feature_id AS asx_turn_right_handed_type_two_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'asx_turn_right_handed_type_two';

--- ************************************************
--- *** relation: asx_turn_right_handed_type_one ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Right handed type I (dihedral angles):-  ***
--- *** Residue(i): -140 degrees < chi (1) -120  ***
--- *** degrees < -20 degrees, -90 degrees < psi ***
--- ***  +120 degrees < +40 degrees. Residue(i+1 ***
--- *** ): -140 degrees < phi < -20 degrees, -90 ***
--- ***  degrees < psi < +40 degrees.            ***
--- ************************************************
---

CREATE VIEW asx_turn_right_handed_type_one AS
  SELECT
    feature_id AS asx_turn_right_handed_type_one_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'asx_turn_right_handed_type_one';

--- ************************************************
--- *** relation: beta_turn ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of four consecutive residues tha ***
--- *** t may contain one H-bond, which, if pres ***
--- *** ent, is between the main-chain CO of the ***
--- ***  first residue and the main-chain NH of  ***
--- *** the fourth. It is characterized by the d ***
--- *** ihedral angles of the second and third r ***
--- *** esidues, which are the basis for sub-cat ***
--- *** egorization.                             ***
--- ************************************************
---

CREATE VIEW beta_turn AS
  SELECT
    feature_id AS beta_turn_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'beta_turn_left_handed_type_one' OR cvterm.name = 'beta_turn_left_handed_type_two' OR cvterm.name = 'beta_turn_right_handed_type_one' OR cvterm.name = 'beta_turn_right_handed_type_two' OR cvterm.name = 'beta_turn_type_six' OR cvterm.name = 'beta_turn_type_eight' OR cvterm.name = 'beta_turn_type_six_a' OR cvterm.name = 'beta_turn_type_six_b' OR cvterm.name = 'beta_turn_type_six_a_one' OR cvterm.name = 'beta_turn_type_six_a_two' OR cvterm.name = 'beta_turn';

--- ************************************************
--- *** relation: beta_turn_left_handed_type_one ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Left handed type I:A motif of four conse ***
--- *** cutive residues that may contain one H-b ***
--- *** ond, which, if present, is between the m ***
--- *** ain-chain CO of the first residue and th ***
--- *** e main-chain NH of the fourth. It is cha ***
--- *** racterized by the dihedral angles:- Resi ***
--- *** due(i+1): -140 degrees > phi > -20 degre ***
--- *** es, -90 degrees > psi > +40 degrees. Res ***
--- *** idue(i+2): -140 degrees > phi > -20 degr ***
--- *** ees, -90 degrees > psi > +40 degrees.    ***
--- ************************************************
---

CREATE VIEW beta_turn_left_handed_type_one AS
  SELECT
    feature_id AS beta_turn_left_handed_type_one_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'beta_turn_left_handed_type_one';

--- ************************************************
--- *** relation: beta_turn_left_handed_type_two ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Left handed type II: A motif of four con ***
--- *** secutive residues that may contain one H ***
--- *** -bond, which, if present, is between the ***
--- ***  main-chain CO of the first residue and  ***
--- *** the main-chain NH of the fourth. It is c ***
--- *** haracterized by the dihedral angles: Res ***
--- *** idue(i+1): -140 degrees > phi > -20 degr ***
--- *** ees, +80 degrees > psi > +180 degrees. R ***
--- *** esidue(i+2): +20 degrees > phi > +140 de ***
--- *** grees, -40 degrees > psi > +90 degrees.  ***
--- ************************************************
---

CREATE VIEW beta_turn_left_handed_type_two AS
  SELECT
    feature_id AS beta_turn_left_handed_type_two_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'beta_turn_left_handed_type_two';

--- ************************************************
--- *** relation: beta_turn_right_handed_type_one ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Right handed type I:A motif of four cons ***
--- *** ecutive residues that may contain one H- ***
--- *** bond, which, if present, is between the  ***
--- *** main-chain CO of the first residue and t ***
--- *** he main-chain NH of the fourth. It is ch ***
--- *** aracterized by the dihedral angles: Resi ***
--- *** due(i+1): -140 degrees < phi < -20 degre ***
--- *** es, -90 degrees < psi < +40 degrees. Res ***
--- *** idue(i+2): -140 degrees < phi < -20 degr ***
--- *** ees, -90 degrees < psi < +40 degrees.    ***
--- ************************************************
---

CREATE VIEW beta_turn_right_handed_type_one AS
  SELECT
    feature_id AS beta_turn_right_handed_type_one_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'beta_turn_right_handed_type_one';

--- ************************************************
--- *** relation: beta_turn_right_handed_type_two ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Right handed type II:A motif of four con ***
--- *** secutive residues that may contain one H ***
--- *** -bond, which, if present, is between the ***
--- ***  main-chain CO of the first residue and  ***
--- *** the main-chain NH of the fourth. It is c ***
--- *** haracterized by the dihedral angles: Res ***
--- *** idue(i+1): -140 degrees < phi < -20 degr ***
--- *** ees, +80 degrees < psi < +180 degrees. R ***
--- *** esidue(i+2): +20 degrees < phi < +140 de ***
--- *** grees, -40 degrees < psi < +90 degrees.  ***
--- ************************************************
---

CREATE VIEW beta_turn_right_handed_type_two AS
  SELECT
    feature_id AS beta_turn_right_handed_type_two_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'beta_turn_right_handed_type_two';

--- ************************************************
--- *** relation: gamma_turn ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Gamma turns, defined for 3 residues i,(  ***
--- *** i+1),( i+2) if a hydrogen bond exists be ***
--- *** tween residues i and i+2 and the phi and ***
--- ***  psi angles of residue i+1 fall within 4 ***
--- *** 0 degrees.                               ***
--- ************************************************
---

CREATE VIEW gamma_turn AS
  SELECT
    feature_id AS gamma_turn_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gamma_turn_classic' OR cvterm.name = 'gamma_turn_inverse' OR cvterm.name = 'gamma_turn';

--- ************************************************
--- *** relation: gamma_turn_classic ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Gamma turns, defined for 3 residues i, i ***
--- *** +1, i+2 if a hydrogen bond exists betwee ***
--- *** n residues i and i+2 and the phi and psi ***
--- ***  angles of residue i+1 fall within 40 de ***
--- *** grees: phi(i+1)=75.0 - psi(i+1)=-64.0.   ***
--- ************************************************
---

CREATE VIEW gamma_turn_classic AS
  SELECT
    feature_id AS gamma_turn_classic_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gamma_turn_classic';

--- ************************************************
--- *** relation: gamma_turn_inverse ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Gamma turns, defined for 3 residues i, i ***
--- *** +1, i+2 if a hydrogen bond exists betwee ***
--- *** n residues i and i+2 and the phi and psi ***
--- ***  angles of residue i+1 fall within 40 de ***
--- *** grees: phi(i+1)=-79.0 - psi(i+1)=69.0.   ***
--- ************************************************
---

CREATE VIEW gamma_turn_inverse AS
  SELECT
    feature_id AS gamma_turn_inverse_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gamma_turn_inverse';

--- ************************************************
--- *** relation: serine_threonine_turn ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of three consecutive residues an ***
--- *** d one H-bond in which: residue(i) is Ser ***
--- *** ine (S) or Threonine (T), the side-chain ***
--- ***  O of residue(i) is H-bonded to the main ***
--- *** -chain NH of residue(i+2).               ***
--- ************************************************
---

CREATE VIEW serine_threonine_turn AS
  SELECT
    feature_id AS serine_threonine_turn_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'st_turn_left_handed_type_one' OR cvterm.name = 'st_turn_left_handed_type_two' OR cvterm.name = 'st_turn_right_handed_type_one' OR cvterm.name = 'st_turn_right_handed_type_two' OR cvterm.name = 'serine_threonine_turn';

--- ************************************************
--- *** relation: st_turn_left_handed_type_one ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The peptide twists in an anticlockwise,  ***
--- *** left handed manner. The dihedral angles  ***
--- *** for this turn are: Residue(i): -140 degr ***
--- *** ees < chi(1) -120 degrees < -20 degrees, ***
--- ***  -90 degrees psi +120 degrees < +40 degr ***
--- *** ees, residue(i+1): -140 degrees < phi <  ***
--- *** -20 degrees, -90 < psi < +40 degrees.    ***
--- ************************************************
---

CREATE VIEW st_turn_left_handed_type_one AS
  SELECT
    feature_id AS st_turn_left_handed_type_one_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'st_turn_left_handed_type_one';

--- ************************************************
--- *** relation: st_turn_left_handed_type_two ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The peptide twists in an anticlockwise,  ***
--- *** left handed manner. The dihedral angles  ***
--- *** for this turn are: Residue(i): -140 degr ***
--- *** ees < chi(1) -120 degrees < -20 degrees, ***
--- ***  +80 degrees psi +120 degrees < +180 deg ***
--- *** rees, residue(i+1): +20 degrees < phi <  ***
--- *** +140 degrees, -40 < psi < +90 degrees.   ***
--- ************************************************
---

CREATE VIEW st_turn_left_handed_type_two AS
  SELECT
    feature_id AS st_turn_left_handed_type_two_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'st_turn_left_handed_type_two';

--- ************************************************
--- *** relation: st_turn_right_handed_type_one ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The peptide twists in an clockwise, righ ***
--- *** t handed manner. The dihedral angles for ***
--- ***  this turn are: Residue(i): -140 degrees ***
--- ***  < chi(1) -120 degrees < -20 degrees, -9 ***
--- *** 0 degrees psi +120 degrees < +40 degrees ***
--- *** , residue(i+1): -140 degrees < phi < -20 ***
--- ***  degrees, -90 < psi < +40 degrees.       ***
--- ************************************************
---

CREATE VIEW st_turn_right_handed_type_one AS
  SELECT
    feature_id AS st_turn_right_handed_type_one_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'st_turn_right_handed_type_one';

--- ************************************************
--- *** relation: st_turn_right_handed_type_two ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The peptide twists in an clockwise, righ ***
--- *** t handed manner. The dihedral angles for ***
--- ***  this turn are: Residue(i): -140 degrees ***
--- ***  < chi(1) -120 degrees < -20 degrees, +8 ***
--- *** 0 degrees psi +120 degrees < +180 degree ***
--- *** s, residue(i+1): +20 degrees < phi < +14 ***
--- *** 0 degrees, -40 < psi < +90 degrees.      ***
--- ************************************************
---

CREATE VIEW st_turn_right_handed_type_two AS
  SELECT
    feature_id AS st_turn_right_handed_type_two_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'st_turn_right_handed_type_two';

--- ************************************************
--- *** relation: polypeptide_variation_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A site of sequence variation (alteration ***
--- *** ). Alternative sequence due to naturally ***
--- ***  occuring events such as polymorphisms a ***
--- *** nd altermatve splicing or experimental m ***
--- *** ethods such as site directed mutagenesis ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW polypeptide_variation_site AS
  SELECT
    feature_id AS polypeptide_variation_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'natural_variant_site' OR cvterm.name = 'mutated_variant_site' OR cvterm.name = 'alternate_sequence_site' OR cvterm.name = 'polypeptide_variation_site';

--- ************************************************
--- *** relation: natural_variant_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Describes the natural sequence variants  ***
--- *** due to polymorphisms, disease-associated ***
--- ***  mutations, RNA editing and variations b ***
--- *** etween strains, isolates or cultivars.   ***
--- ************************************************
---

CREATE VIEW natural_variant_site AS
  SELECT
    feature_id AS natural_variant_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'natural_variant_site';

--- ************************************************
--- *** relation: mutated_variant_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Site which has been experimentally alter ***
--- *** ed.                                      ***
--- ************************************************
---

CREATE VIEW mutated_variant_site AS
  SELECT
    feature_id AS mutated_variant_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'mutated_variant_site';

--- ************************************************
--- *** relation: alternate_sequence_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Description of sequence variants produce ***
--- *** d by alternative splicing, alternative p ***
--- *** romoter usage, alternative initiation an ***
--- *** d ribosomal frameshifting.               ***
--- ************************************************
---

CREATE VIEW alternate_sequence_site AS
  SELECT
    feature_id AS alternate_sequence_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'alternate_sequence_site';

--- ************************************************
--- *** relation: beta_turn_type_six ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of four consecutive peptide resi ***
--- *** des of type VIa or type VIb and where th ***
--- *** e i+2 residue is cis-proline.            ***
--- ************************************************
---

CREATE VIEW beta_turn_type_six AS
  SELECT
    feature_id AS beta_turn_type_six_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'beta_turn_type_six_a' OR cvterm.name = 'beta_turn_type_six_b' OR cvterm.name = 'beta_turn_type_six_a_one' OR cvterm.name = 'beta_turn_type_six_a_two' OR cvterm.name = 'beta_turn_type_six';

--- ************************************************
--- *** relation: beta_turn_type_six_a ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of four consecutive peptide resi ***
--- *** dues, of which the i+2 residue is prolin ***
--- *** e, and that may contain one H-bond, whic ***
--- *** h, if present, is between the main-chain ***
--- ***  CO of the first residue and the main-ch ***
--- *** ain NH of the fourth and is characterize ***
--- *** d by the dihedral angles: Residue(i+1):  ***
--- *** phi ~ -60 degrees, psi ~ 120 degrees. Re ***
--- *** sidue(i+2): phi ~ -90 degrees, psi ~ 0 d ***
--- *** egrees.                                  ***
--- ************************************************
---

CREATE VIEW beta_turn_type_six_a AS
  SELECT
    feature_id AS beta_turn_type_six_a_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'beta_turn_type_six_a_one' OR cvterm.name = 'beta_turn_type_six_a_two' OR cvterm.name = 'beta_turn_type_six_a';

--- ************************************************
--- *** relation: beta_turn_type_six_a_one ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW beta_turn_type_six_a_one AS
  SELECT
    feature_id AS beta_turn_type_six_a_one_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'beta_turn_type_six_a_one';

--- ************************************************
--- *** relation: beta_turn_type_six_a_two ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW beta_turn_type_six_a_two AS
  SELECT
    feature_id AS beta_turn_type_six_a_two_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'beta_turn_type_six_a_two';

--- ************************************************
--- *** relation: beta_turn_type_six_b ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of four consecutive peptide resi ***
--- *** dues, of which the i+2 residue is prolin ***
--- *** e, and that may contain one H-bond, whic ***
--- *** h, if present, is between the main-chain ***
--- ***  CO of the first residue and the main-ch ***
--- *** ain NH of the fourth and is characterize ***
--- *** d by the dihedral angles: Residue(i+1):  ***
--- *** phi ~ -120 degrees, psi ~ 120 degrees. R ***
--- *** esidue(i+2): phi ~ -60 degrees, psi ~ 0  ***
--- *** degrees.                                 ***
--- ************************************************
---

CREATE VIEW beta_turn_type_six_b AS
  SELECT
    feature_id AS beta_turn_type_six_b_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'beta_turn_type_six_b';

--- ************************************************
--- *** relation: beta_turn_type_eight ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A motif of four consecutive peptide resi ***
--- *** dues that may contain one H-bond, which, ***
--- ***  if present, is between the main-chain C ***
--- *** O of the first residue and the main-chai ***
--- *** n NH of the fourth and is characterized  ***
--- *** by the dihedral angles: Residue(i+1): ph ***
--- *** i ~ -60 degrees, psi ~ -30 degrees. Resi ***
--- *** due(i+2): phi ~ -120 degrees, psi ~ 120  ***
--- *** degrees.                                 ***
--- ************************************************
---

CREATE VIEW beta_turn_type_eight AS
  SELECT
    feature_id AS beta_turn_type_eight_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'beta_turn_type_eight';

--- ************************************************
--- *** relation: dre_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence element characteristic of som ***
--- *** e RNA polymerase II promoters, usually l ***
--- *** ocated between -10 and -60 relative to t ***
--- *** he TSS. Consensus sequence is WATCGATW.  ***
--- ************************************************
---

CREATE VIEW dre_motif AS
  SELECT
    feature_id AS dre_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DRE_motif';

--- ************************************************
--- *** relation: dmv4_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence element characteristic of som ***
--- *** e RNA polymerase II promoters, located i ***
--- *** mmediately upstream of some TATA box ele ***
--- *** ments with respect to the TSS (+1). Cons ***
--- *** ensus sequence is YGGTCACACTR. Marked sp ***
--- *** atial preference within core promoter; t ***
--- *** end to occur near the TSS, although not  ***
--- *** as tightly as INR (SO:0000014).          ***
--- ************************************************
---

CREATE VIEW dmv4_motif AS
  SELECT
    feature_id AS dmv4_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DMv4_motif';

--- ************************************************
--- *** relation: e_box_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence element characteristic of som ***
--- *** e RNA polymerase II promoters, usually l ***
--- *** ocated between -60 and +1 relative to th ***
--- *** e TSS. Consensus sequence is AWCAGCTGWT. ***
--- ***  Tends to co-occur with DMv2 (SO:0001161 ***
--- *** ). Tends to not occur with DPE motif (SO ***
--- *** :0000015).                               ***
--- ************************************************
---

CREATE VIEW e_box_motif AS
  SELECT
    feature_id AS e_box_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'E_box_motif';

--- ************************************************
--- *** relation: dmv5_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence element characteristic of som ***
--- *** e RNA polymerase II promoters, usually l ***
--- *** ocated between -50 and -10 relative to t ***
--- *** he TSS. Consensus sequence is KTYRGTATWT ***
--- *** TT. Tends to co-occur with DMv4 (SO:0001 ***
--- *** 157) . Tends to not occur with DPE motif ***
--- ***  (SO:0000015) or MTE (SO:0001162).       ***
--- ************************************************
---

CREATE VIEW dmv5_motif AS
  SELECT
    feature_id AS dmv5_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DMv5_motif';

--- ************************************************
--- *** relation: dmv3_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence element characteristic of som ***
--- *** e RNA polymerase II promoters, usually l ***
--- *** ocated between -30 and +15 relative to t ***
--- *** he TSS. Consensus sequence is KNNCAKCNCT ***
--- *** RNY. Tends to co-occur with DMv2 (SO:000 ***
--- *** 1161). Tends to not occur with DPE motif ***
--- ***  (SO:0000015) or MTE (0001162).          ***
--- ************************************************
---

CREATE VIEW dmv3_motif AS
  SELECT
    feature_id AS dmv3_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DMv3_motif';

--- ************************************************
--- *** relation: dmv2_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence element characteristic of som ***
--- *** e RNA polymerase II promoters, usually l ***
--- *** ocated between -60 and -45 relative to t ***
--- *** he TSS. Consensus sequence is MKSYGGCARC ***
--- *** GSYSS. Tends to co-occur with DMv3 (SO:0 ***
--- *** 001160). Tends to not occur with DPE mot ***
--- *** if (SO:0000015) or MTE (SO:0001162).     ***
--- ************************************************
---

CREATE VIEW dmv2_motif AS
  SELECT
    feature_id AS dmv2_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DMv2_motif';

--- ************************************************
--- *** relation: mte ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence element characteristic of som ***
--- *** e RNA polymerase II promoters, usually l ***
--- *** ocated between +20 and +30 relative to t ***
--- *** he TSS. Consensus sequence is CSARCSSAAC ***
--- *** GS. Tends to co-occur with INR motif (SO ***
--- *** :0000014). Tends to not occur with DPE m ***
--- *** otif (SO:0000015) or DMv5 (SO:0001159).  ***
--- ************************************************
---

CREATE VIEW mte AS
  SELECT
    feature_id AS mte_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'MTE';

--- ************************************************
--- *** relation: inr1_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A promoter motif with consensus sequence ***
--- ***  TCATTCG.                                ***
--- ************************************************
---

CREATE VIEW inr1_motif AS
  SELECT
    feature_id AS inr1_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'INR1_motif';

--- ************************************************
--- *** relation: dpe1_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A promoter motif with consensus sequence ***
--- ***  CGGACGT.                                ***
--- ************************************************
---

CREATE VIEW dpe1_motif AS
  SELECT
    feature_id AS dpe1_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DPE1_motif';

--- ************************************************
--- *** relation: dmv1_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A promoter motif with consensus sequence ***
--- ***  CARCCCT.                                ***
--- ************************************************
---

CREATE VIEW dmv1_motif AS
  SELECT
    feature_id AS dmv1_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DMv1_motif';

--- ************************************************
--- *** relation: gaga_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A non directional promoter motif with co ***
--- *** nsensus sequence GAGAGCG.                ***
--- ************************************************
---

CREATE VIEW gaga_motif AS
  SELECT
    feature_id AS gaga_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'GAGA_motif';

--- ************************************************
--- *** relation: ndm2_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A non directional promoter motif with co ***
--- *** nsensus CGMYGYCR.                        ***
--- ************************************************
---

CREATE VIEW ndm2_motif AS
  SELECT
    feature_id AS ndm2_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'NDM2_motif';

--- ************************************************
--- *** relation: ndm3_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A non directional promoter motif with co ***
--- *** nsensus sequence GAAAGCT.                ***
--- ************************************************
---

CREATE VIEW ndm3_motif AS
  SELECT
    feature_id AS ndm3_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'NDM3_motif';

--- ************************************************
--- *** relation: ds_rna_viral_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A ds_RNA_viral_sequence is a viral_seque ***
--- *** nce that is the sequence of a virus that ***
--- ***  exists as double stranded RNA.          ***
--- ************************************************
---

CREATE VIEW ds_rna_viral_sequence AS
  SELECT
    feature_id AS ds_rna_viral_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'ds_RNA_viral_sequence';

--- ************************************************
--- *** relation: polinton ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A kind of DNA transposon that populates  ***
--- *** the genomes of protists, fungi, and anim ***
--- *** als, characterized by a unique set of pr ***
--- *** oteins necessary for their transposition ***
--- *** , including a protein-primed DNA polymer ***
--- *** ase B, retroviral integrase, cysteine pr ***
--- *** otease, and ATPase. Polintons are charac ***
--- *** terized by 6-bp target site duplications ***
--- *** , terminal-inverted repeats that are sev ***
--- *** eral hundred nucleotides long, and 5'-AG ***
--- ***  and TC-3' termini. Polintons exist as a ***
--- *** utonomous and nonautonomous elements.    ***
--- ************************************************
---

CREATE VIEW polinton AS
  SELECT
    feature_id AS polinton_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polinton';

--- ************************************************
--- *** relation: rrna_21s ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A component of the large ribosomal subun ***
--- *** it in mitochondrial rRNA.                ***
--- ************************************************
---

CREATE VIEW rrna_21s AS
  SELECT
    feature_id AS rrna_21s_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_21S';

--- ************************************************
--- *** relation: trna_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of a tRNA.                      ***
--- ************************************************
---

CREATE VIEW trna_region AS
  SELECT
    feature_id AS trna_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'anticodon_loop' OR cvterm.name = 'anticodon' OR cvterm.name = 'CCA_tail' OR cvterm.name = 'DHU_loop' OR cvterm.name = 'T_loop' OR cvterm.name = 'tRNA_region';

--- ************************************************
--- *** relation: anticodon_loop ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence of seven nucleotide bases in  ***
--- *** tRNA which contains the anticodon. It ha ***
--- *** s the sequence 5'-pyrimidine-purine-anti ***
--- *** codon-modified purine-any base-3.        ***
--- ************************************************
---

CREATE VIEW anticodon_loop AS
  SELECT
    feature_id AS anticodon_loop_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'anticodon_loop';

--- ************************************************
--- *** relation: anticodon ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence of three nucleotide bases in  ***
--- *** tRNA which recognizes a codon in mRNA.   ***
--- ************************************************
---

CREATE VIEW anticodon AS
  SELECT
    feature_id AS anticodon_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'anticodon';

--- ************************************************
--- *** relation: cca_tail ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Base sequence at the 3' end of a tRNA. T ***
--- *** he 3'-hydroxyl group on the terminal ade ***
--- *** nosine is the attachment point for the a ***
--- *** mino acid.                               ***
--- ************************************************
---

CREATE VIEW cca_tail AS
  SELECT
    feature_id AS cca_tail_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'CCA_tail';

--- ************************************************
--- *** relation: dhu_loop ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Non-base-paired sequence of nucleotide b ***
--- *** ases in tRNA. It contains several dihydr ***
--- *** ouracil residues.                        ***
--- ************************************************
---

CREATE VIEW dhu_loop AS
  SELECT
    feature_id AS dhu_loop_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DHU_loop';

--- ************************************************
--- *** relation: t_loop ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Non-base-paired sequence of three nucleo ***
--- *** tide bases in tRNA. It has sequence T-Ps ***
--- *** i-C.                                     ***
--- ************************************************
---

CREATE VIEW t_loop AS
  SELECT
    feature_id AS t_loop_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'T_loop';

--- ************************************************
--- *** relation: pyrrolysine_trna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding pyrrolysyl ***
--- ***  tRNA (SO:0000766).                      ***
--- ************************************************
---

CREATE VIEW pyrrolysine_trna_primary_transcript AS
  SELECT
    feature_id AS pyrrolysine_trna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pyrrolysine_tRNA_primary_transcript';

--- ************************************************
--- *** relation: u3_snorna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** U3 snoRNA is a member of the box C/D cla ***
--- *** ss of small nucleolar RNAs. The U3 snoRN ***
--- *** A secondary structure is characterised b ***
--- *** y a small 5' domain (with boxes A and A' ***
--- *** ), and a larger 3' domain (with boxes B, ***
--- ***  C, C', and D), the two domains being li ***
--- *** nked by a single-stranded hinge. Boxes B ***
--- ***  and C form the B/C motif, which appears ***
--- ***  to be exclusive to U3 snoRNAs, and boxe ***
--- *** s C' and D form the C'/D motif. The latt ***
--- *** er is functionally similar to the C/D mo ***
--- *** tifs found in other snoRNAs. The 5' doma ***
--- *** in and the hinge region act as a pre-rRN ***
--- *** A-binding domain. The 3' domain has cons ***
--- *** erved protein-binding sites. Both the bo ***
--- *** x B/C and box C'/D motifs are sufficient ***
--- ***  for nuclear retention of U3 snoRNA. The ***
--- ***  box C'/D motif is also necessary for nu ***
--- *** cleolar localization, stability and hype ***
--- *** rmethylation of U3 snoRNA. Both box B/C  ***
--- *** and C'/D motifs are involved in specific ***
--- ***  protein interactions and are necessary  ***
--- *** for the rRNA processing functions of U3  ***
--- *** snoRNA.                                  ***
--- ************************************************
---

CREATE VIEW u3_snorna AS
  SELECT
    feature_id AS u3_snorna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U3_snoRNA';

--- ************************************************
--- *** relation: au_rich_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A cis-acting element found in the 3' UTR ***
--- ***  of some mRNA which is rich in AUUUA pen ***
--- *** tamers. Messenger RNAs bearing multiple  ***
--- *** AU-rich elements are often unstable.     ***
--- ************************************************
---

CREATE VIEW au_rich_element AS
  SELECT
    feature_id AS au_rich_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'AU_rich_element';

--- ************************************************
--- *** relation: bruno_response_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A cis-acting element found in the 3' UTR ***
--- ***  of some mRNA which is bound by the Dros ***
--- *** ophila Bruno protein and its homologs.   ***
--- ************************************************
---

CREATE VIEW bruno_response_element AS
  SELECT
    feature_id AS bruno_response_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'Bruno_response_element';

--- ************************************************
--- *** relation: iron_responsive_element ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A regulatory sequence found in the 5' an ***
--- *** d 3' UTRs of many mRNAs which encode iro ***
--- *** n-binding proteins. It has a hairpin str ***
--- *** ucture and is recognized by trans-acting ***
--- ***  proteins known as iron-regulatory prote ***
--- *** ins.                                     ***
--- ************************************************
---

CREATE VIEW iron_responsive_element AS
  SELECT
    feature_id AS iron_responsive_element_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'iron_responsive_element';

--- ************************************************
--- *** relation: morpholino_backbone ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence compo ***
--- *** sed of nucleobases bound to a morpholino ***
--- ***  backbone. A morpholino backbone consist ***
--- *** s of morpholine (CHEBI:34856) rings conn ***
--- *** ected by phosphorodiamidate linkages.    ***
--- ************************************************
---

CREATE VIEW morpholino_backbone AS
  SELECT
    feature_id AS morpholino_backbone_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'morpholino_backbone';

--- ************************************************
--- *** relation: pna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence compo ***
--- *** sed of peptide nucleic acid (CHEBI:48021 ***
--- *** ), a chemical consisting of nucleobases  ***
--- *** bound to a backbone composed of repeatin ***
--- *** g N-(2-aminoethyl)-glycine units linked  ***
--- *** by peptide bonds. The purine and pyrimid ***
--- *** ine bases are linked to the backbone by  ***
--- *** methylene carbonyl bonds.                ***
--- ************************************************
---

CREATE VIEW pna AS
  SELECT
    feature_id AS pna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'PNA';

--- ************************************************
--- *** relation: enzymatic ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing the sequence of  ***
--- *** a transcript that has catalytic activity ***
--- ***  with or without an associated ribonucle ***
--- *** oprotein.                                ***
--- ************************************************
---

CREATE VIEW enzymatic AS
  SELECT
    feature_id AS enzymatic_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'ribozymic' OR cvterm.name = 'enzymatic';

--- ************************************************
--- *** relation: ribozymic ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing the sequence of  ***
--- *** a transcript that has catalytic activity ***
--- ***  even without an associated ribonucleopr ***
--- *** otein.                                   ***
--- ************************************************
---

CREATE VIEW ribozymic AS
  SELECT
    feature_id AS ribozymic_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'ribozymic';

--- ************************************************
--- *** relation: pseudouridylation_guide_snorna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A snoRNA that specifies the site of pseu ***
--- *** douridylation in an RNA molecule by base ***
--- ***  pairing with a short sequence around th ***
--- *** e target residue.                        ***
--- ************************************************
---

CREATE VIEW pseudouridylation_guide_snorna AS
  SELECT
    feature_id AS pseudouridylation_guide_snorna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pseudouridylation_guide_snoRNA';

--- ************************************************
--- *** relation: lna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence consi ***
--- *** sting of nucleobases attached to a repea ***
--- *** ting unit made of 'locked' deoxyribose r ***
--- *** ings connected to a phosphate backbone.  ***
--- *** The deoxyribose unit's conformation is ' ***
--- *** locked' by a 2'-C,4'-C-oxymethylene link ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW lna AS
  SELECT
    feature_id AS lna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'LNA';

--- ************************************************
--- *** relation: lna_oligo ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An oligo composed of LNA residues.       ***
--- ************************************************
---

CREATE VIEW lna_oligo AS
  SELECT
    feature_id AS lna_oligo_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'LNA_oligo';

--- ************************************************
--- *** relation: tna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence consi ***
--- *** sting of nucleobases attached to a repea ***
--- *** ting unit made of threose rings connecte ***
--- *** d to a phosphate backbone.               ***
--- ************************************************
---

CREATE VIEW tna AS
  SELECT
    feature_id AS tna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'TNA';

--- ************************************************
--- *** relation: tna_oligo ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An oligo composed of TNA residues.       ***
--- ************************************************
---

CREATE VIEW tna_oligo AS
  SELECT
    feature_id AS tna_oligo_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'TNA_oligo';

--- ************************************************
--- *** relation: gna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a sequence consi ***
--- *** sting of nucleobases attached to a repea ***
--- *** ting unit made of an acyclic three-carbo ***
--- *** n propylene glycol connected to a phosph ***
--- *** ate backbone. It has two enantiomeric fo ***
--- *** rms, (R)-GNA and (S)-GNA.                ***
--- ************************************************
---

CREATE VIEW gna AS
  SELECT
    feature_id AS gna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'R_GNA' OR cvterm.name = 'S_GNA' OR cvterm.name = 'GNA';

--- ************************************************
--- *** relation: gna_oligo ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An oligo composed of GNA residues.       ***
--- ************************************************
---

CREATE VIEW gna_oligo AS
  SELECT
    feature_id AS gna_oligo_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'R_GNA_oligo' OR cvterm.name = 'S_GNA_oligo' OR cvterm.name = 'GNA_oligo';

--- ************************************************
--- *** relation: r_gna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute describing a GNA sequence i ***
--- *** n the (R)-GNA enantiomer.                ***
--- ************************************************
---

CREATE VIEW r_gna AS
  SELECT
   