SET search_path=so,chado,pg_catalog;
--- *** eptor gene in germline configuration inc ***
--- *** luding at least one J-gene and one C-gen ***
--- *** e.                                       ***
--- ************************************************
---

CREATE VIEW j_c_cluster AS
  SELECT
    feature_id AS j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'J_C_cluster';

--- ************************************************
--- *** relation: inversion_derived_deficiency_plus_aneuploid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosomal deletion whereby a chromos ***
--- *** ome generated by recombination between t ***
--- *** wo inversions; has a deficiency at one e ***
--- *** nd and presumed to have a deficiency or  ***
--- *** duplication at the other end of the inve ***
--- *** rsion.                                   ***
--- ************************************************
---

CREATE VIEW inversion_derived_deficiency_plus_aneuploid AS
  SELECT
    feature_id AS inversion_derived_deficiency_plus_aneuploid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inversion_derived_deficiency_plus_aneuploid';

--- ************************************************
--- *** relation: j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding more than one J-gene.             ***
--- ************************************************
---

CREATE VIEW j_cluster AS
  SELECT
    feature_id AS j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'J_cluster';

--- ************************************************
--- *** relation: j_nonamer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 9 nucleotide recombination site (e.g. GG ***
--- *** TTTTTGT), part of a J-gene recombination ***
--- ***  feature of an immunoglobulin/T-cell rec ***
--- *** eptor gene.                              ***
--- ************************************************
---

CREATE VIEW j_nonamer AS
  SELECT
    feature_id AS j_nonamer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'J_nonamer';

--- ************************************************
--- *** relation: j_heptamer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 7 nucleotide recombination site (e.g. CA ***
--- *** CAGTG), part of a J-gene recombination f ***
--- *** eature of an immunoglobulin/T-cell recep ***
--- *** tor gene.                                ***
--- ************************************************
---

CREATE VIEW j_heptamer AS
  SELECT
    feature_id AS j_heptamer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'J_heptamer';

--- ************************************************
--- *** relation: pseudogenic_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A non functional descendant of a transcr ***
--- *** ipt, part of a pseudogene.               ***
--- ************************************************
---

CREATE VIEW pseudogenic_transcript AS
  SELECT
    feature_id AS pseudogenic_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pseudogenic_transcript';

--- ************************************************
--- *** relation: j_spacer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 12 or 23 nucleotide spacer between the J ***
--- *** -nonamer and the J-heptamer of a J-gene  ***
--- *** recombination feature of an immunoglobul ***
--- *** in/T-cell receptor gene.                 ***
--- ************************************************
---

CREATE VIEW j_spacer AS
  SELECT
    feature_id AS j_spacer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'J_spacer';

--- ************************************************
--- *** relation: v_dj_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene and one DJ- ***
--- *** gene.                                    ***
--- ************************************************
---

CREATE VIEW v_dj_cluster AS
  SELECT
    feature_id AS v_dj_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_DJ_cluster';

--- ************************************************
--- *** relation: v_dj_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one DJ-gen ***
--- *** e and one J-gene.                        ***
--- ************************************************
---

CREATE VIEW v_dj_j_cluster AS
  SELECT
    feature_id AS v_dj_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_DJ_J_cluster';

--- ************************************************
--- *** relation: v_vdj_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one VDJ-ge ***
--- *** ne and one C-gene.                       ***
--- ************************************************
---

CREATE VIEW v_vdj_c_cluster AS
  SELECT
    feature_id AS v_vdj_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_VDJ_C_cluster';

--- ************************************************
--- *** relation: v_vdj_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene and one VDJ ***
--- *** -gene.                                   ***
--- ************************************************
---

CREATE VIEW v_vdj_cluster AS
  SELECT
    feature_id AS v_vdj_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_VDJ_cluster';

--- ************************************************
--- *** relation: v_vdj_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one VDJ-ge ***
--- *** ne and one J-gene.                       ***
--- ************************************************
---

CREATE VIEW v_vdj_j_cluster AS
  SELECT
    feature_id AS v_vdj_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_VDJ_J_cluster';

--- ************************************************
--- *** relation: v_vj_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one VJ-gen ***
--- *** e and one C-gene.                        ***
--- ************************************************
---

CREATE VIEW v_vj_c_cluster AS
  SELECT
    feature_id AS v_vj_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_VJ_C_cluster';

--- ************************************************
--- *** relation: v_vj_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene and one VJ- ***
--- *** gene.                                    ***
--- ************************************************
---

CREATE VIEW v_vj_cluster AS
  SELECT
    feature_id AS v_vj_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_VJ_cluster';

--- ************************************************
--- *** relation: v_vj_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one VJ-gen ***
--- *** e and one J-gene.                        ***
--- ************************************************
---

CREATE VIEW v_vj_j_cluster AS
  SELECT
    feature_id AS v_vj_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_VJ_J_cluster';

--- ************************************************
--- *** relation: v_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding more than one V-gene.             ***
--- ************************************************
---

CREATE VIEW v_cluster AS
  SELECT
    feature_id AS v_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_cluster';

--- ************************************************
--- *** relation: v_d_dj_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one D-gene ***
--- *** , one DJ-gene and one C-gene.            ***
--- ************************************************
---

CREATE VIEW v_d_dj_c_cluster AS
  SELECT
    feature_id AS v_d_dj_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_D_DJ_C_cluster';

--- ************************************************
--- *** relation: v_d_dj_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one D-gene ***
--- *** , one DJ-gene.                           ***
--- ************************************************
---

CREATE VIEW v_d_dj_cluster AS
  SELECT
    feature_id AS v_d_dj_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_D_DJ_cluster';

--- ************************************************
--- *** relation: v_d_dj_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one D-gene ***
--- *** , one DJ-gene, one J-gene and one C-gene ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW v_d_dj_j_c_cluster AS
  SELECT
    feature_id AS v_d_dj_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_D_DJ_J_C_cluster';

--- ************************************************
--- *** relation: v_d_dj_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one D-gene ***
--- *** , one DJ-gene and one J-gene.            ***
--- ************************************************
---

CREATE VIEW v_d_dj_j_cluster AS
  SELECT
    feature_id AS v_d_dj_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_D_DJ_J_cluster';

--- ************************************************
--- *** relation: v_d_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding at least one V-gene, one D-gene a ***
--- *** nd one J-gene and one C-gene.            ***
--- ************************************************
---

CREATE VIEW v_d_j_c_cluster AS
  SELECT
    feature_id AS v_d_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_D_J_C_cluster';

--- ************************************************
--- *** relation: v_d_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding at least one V-gene, one D-gene a ***
--- *** nd one J-gene.                           ***
--- ************************************************
---

CREATE VIEW v_d_j_cluster AS
  SELECT
    feature_id AS v_d_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_D_J_cluster';

--- ************************************************
--- *** relation: v_heptamer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 7 nucleotide recombination site (e.g. CA ***
--- *** CAGTG), part of V-gene recombination fea ***
--- *** ture of an immunoglobulin/T-cell recepto ***
--- *** r gene.                                  ***
--- ************************************************
---

CREATE VIEW v_heptamer AS
  SELECT
    feature_id AS v_heptamer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_heptamer';

--- ************************************************
--- *** relation: v_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding at least one V-gene and one J-gen ***
--- *** e.                                       ***
--- ************************************************
---

CREATE VIEW v_j_cluster AS
  SELECT
    feature_id AS v_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_J_cluster';

--- ************************************************
--- *** relation: v_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding at least one V-gene, one J-gene a ***
--- *** nd one C-gene.                           ***
--- ************************************************
---

CREATE VIEW v_j_c_cluster AS
  SELECT
    feature_id AS v_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_J_C_cluster';

--- ************************************************
--- *** relation: v_nonamer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 9 nucleotide recombination site (e.g. AC ***
--- *** AAAAACC), part of V-gene recombination f ***
--- *** eature of an immunoglobulin/T-cell recep ***
--- *** tor gene.                                ***
--- ************************************************
---

CREATE VIEW v_nonamer AS
  SELECT
    feature_id AS v_nonamer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_nonamer';

--- ************************************************
--- *** relation: v_spacer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 12 or 23 nucleotide spacer between the V ***
--- *** -heptamer and the V-nonamer of a V-gene  ***
--- *** recombination feature of an immunoglobul ***
--- *** in/T-cell receptor gene.                 ***
--- ************************************************
---

CREATE VIEW v_spacer AS
  SELECT
    feature_id AS v_spacer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_spacer';

--- ************************************************
--- *** relation: v_gene_recombination_feature ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Recombination signal including V-heptame ***
--- *** r, V-spacer and V-nonamer in 3' of V-reg ***
--- *** ion of a V-gene or V-sequence of an immu ***
--- *** noglobulin/T-cell receptor gene.         ***
--- ************************************************
---

CREATE VIEW v_gene_recombination_feature AS
  SELECT
    feature_id AS v_gene_recombination_feature_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_gene_recombination_feature';

--- ************************************************
--- *** relation: dj_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one DJ-gene and one C- ***
--- *** gene.                                    ***
--- ************************************************
---

CREATE VIEW dj_c_cluster AS
  SELECT
    feature_id AS dj_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DJ_C_cluster';

--- ************************************************
--- *** relation: dj_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA in rearranged configuration  ***
--- *** including at least one D-J-GENE, one J-G ***
--- *** ENE and one C-GENE.                      ***
--- ************************************************
---

CREATE VIEW dj_j_c_cluster AS
  SELECT
    feature_id AS dj_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DJ_J_C_cluster';

--- ************************************************
--- *** relation: vdj_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one VDJ-gene and one C ***
--- *** -gene.                                   ***
--- ************************************************
---

CREATE VIEW vdj_c_cluster AS
  SELECT
    feature_id AS vdj_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'VDJ_C_cluster';

--- ************************************************
--- *** relation: v_dj_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one DJ-gen ***
--- *** e and one C-gene.                        ***
--- ************************************************
---

CREATE VIEW v_dj_c_cluster AS
  SELECT
    feature_id AS v_dj_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_DJ_C_cluster';

--- ************************************************
--- *** relation: helitron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A rolling circle transposon. Autonomous  ***
--- *** helitrons encode a 5'-to-3' DNA helicase ***
--- ***  and nuclease/ligase similar to those en ***
--- *** coded by known rolling-circle replicons. ***
--- ************************************************
---

CREATE VIEW helitron AS
  SELECT
    feature_id AS helitron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'helitron';

--- ************************************************
--- *** relation: recoding_pseudoknot ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The pseudoknots involved in recoding are ***
--- ***  unique in that, as they play their role ***
--- ***  as a structure, they are immediately un ***
--- *** folded and their now linear sequence ser ***
--- *** ves as a template for decoding.          ***
--- ************************************************
---

CREATE VIEW recoding_pseudoknot AS
  SELECT
    feature_id AS recoding_pseudoknot_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'recoding_pseudoknot';

--- ************************************************
--- *** relation: designed_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW designed_sequence AS
  SELECT
    feature_id AS designed_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'designed_sequence';

--- ************************************************
--- *** relation: inversion_derived_bipartite_duplication ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome generated by recombination  ***
--- *** between two inversions; there is a dupli ***
--- *** cation at each end of the inversion.     ***
--- ************************************************
---

CREATE VIEW inversion_derived_bipartite_duplication AS
  SELECT
    feature_id AS inversion_derived_bipartite_duplication_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inversion_derived_bipartite_duplication';

--- ************************************************
--- *** relation: gene_with_edited_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A gene that encodes a transcript that is ***
--- ***  edited.                                 ***
--- ************************************************
---

CREATE VIEW gene_with_edited_transcript AS
  SELECT
    feature_id AS gene_with_edited_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gene_with_edited_transcript';

--- ************************************************
--- *** relation: inversion_derived_duplication_plus_aneuploid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome generated by recombination  ***
--- *** between two inversions; has a duplicatio ***
--- *** n at one end and presumed to have a defi ***
--- *** ciency or duplication at the other end o ***
--- *** f the inversion.                         ***
--- ************************************************
---

CREATE VIEW inversion_derived_duplication_plus_aneuploid AS
  SELECT
    feature_id AS inversion_derived_duplication_plus_aneuploid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inversion_derived_duplication_plus_aneuploid';

--- ************************************************
--- *** relation: aneuploid_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome structural variation whereb ***
--- *** y either a chromosome exists in addition ***
--- ***  to the normal chromosome complement or  ***
--- *** is lacking.                              ***
--- ************************************************
---

CREATE VIEW aneuploid_chromosome AS
  SELECT
    feature_id AS aneuploid_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inversion_derived_aneuploid_chromosome' OR cvterm.name = 'aneuploid_chromosome';

--- ************************************************
--- *** relation: polya_signal_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The recognition sequence necessary for e ***
--- *** ndonuclease cleavage of an RNA transcrip ***
--- *** t that is followed by polyadenylation; c ***
--- *** onsensus=AATAAA.                         ***
--- ************************************************
---

CREATE VIEW polya_signal_sequence AS
  SELECT
    feature_id AS polya_signal_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polyA_signal_sequence';

--- ************************************************
--- *** relation: shine_dalgarno_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region in the 5' UTR that pairs with t ***
--- *** he 16S rRNA during formation of the prei ***
--- *** nitiation complex.                       ***
--- ************************************************
---

CREATE VIEW shine_dalgarno_sequence AS
  SELECT
    feature_id AS shine_dalgarno_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'Shine_Dalgarno_sequence';

--- ************************************************
--- *** relation: polya_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The site on an RNA transcript to which w ***
--- *** ill be added adenine residues by post-tr ***
--- *** anscriptional polyadenylation. The bound ***
--- *** ary between the UTR and the polyA sequen ***
--- *** ce.                                      ***
--- ************************************************
---

CREATE VIEW polya_site AS
  SELECT
    feature_id AS polya_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polyA_site';

--- ************************************************
--- *** relation: five_prime_clip ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 5' most region of a precursor transcript ***
--- ***  that is clipped off during processing.  ***
--- ************************************************
---

CREATE VIEW five_prime_clip AS
  SELECT
    feature_id AS five_prime_clip_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_clip';

--- ************************************************
--- *** relation: five_prime_d_recombination_signal_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Recombination signal of an immunoglobuli ***
--- *** n/T-cell receptor gene, including the 5' ***
--- ***  D-nonamer (SO:0000497), 5' D-spacer (SO ***
--- *** :0000498), and 5' D-heptamer (SO:0000396 ***
--- *** ) in 5' of the D-region of a D-gene, or  ***
--- *** in 5' of the D-region of DJ-gene.        ***
--- ************************************************
---

CREATE VIEW five_prime_d_recombination_signal_sequence AS
  SELECT
    feature_id AS five_prime_d_recombination_signal_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_prime_D_recombination_signal_sequence';

--- ************************************************
--- *** relation: three_prime_clip ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 3'-most region of a precursor transcript ***
--- ***  that is clipped off during processing.  ***
--- ************************************************
---

CREATE VIEW three_prime_clip AS
  SELECT
    feature_id AS three_prime_clip_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_clip';

--- ************************************************
--- *** relation: c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene including more than one C-gen ***
--- *** e.                                       ***
--- ************************************************
---

CREATE VIEW c_cluster AS
  SELECT
    feature_id AS c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'C_cluster';

--- ************************************************
--- *** relation: d_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding more than one D-gene.             ***
--- ************************************************
---

CREATE VIEW d_cluster AS
  SELECT
    feature_id AS d_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'D_cluster';

--- ************************************************
--- *** relation: d_j_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in germline configuration inc ***
--- *** luding at least one D-gene and one J-gen ***
--- *** e.                                       ***
--- ************************************************
---

CREATE VIEW d_j_cluster AS
  SELECT
    feature_id AS d_j_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'D_J_cluster';

--- ************************************************
--- *** relation: heptamer_of_recombination_feature_of_vertebrate_im_sys_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Seven nucleotide recombination site (e.g ***
--- *** . CACAGTG), part of V-gene, D-gene or J- ***
--- *** gene recombination feature of an immunog ***
--- *** lobulin or T-cell receptor gene.         ***
--- ************************************************
---

CREATE VIEW heptamer_of_recombination_feature_of_vertebrate_im_sys_gene AS
  SELECT
    feature_id AS heptamer_of_recombination_feature_of_vertebrate_im_sys_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_D_heptamer' OR cvterm.name = 'five_prime_D_heptamer' OR cvterm.name = 'J_heptamer' OR cvterm.name = 'V_heptamer' OR cvterm.name = 'heptamer_of_recombination_feature_of_vertebrate_immune_system_gene';

--- ************************************************
--- *** relation: nonamer_of_recombination_feature_of_vertebrate_im_sys_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW nonamer_of_recombination_feature_of_vertebrate_im_sys_gene AS
  SELECT
    feature_id AS nonamer_of_recombination_feature_of_vertebrate_im_sys_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_D_nonamer' OR cvterm.name = 'five_prime_D_nonamer' OR cvterm.name = 'J_nonamer' OR cvterm.name = 'V_nonamer' OR cvterm.name = 'nonamer_of_recombination_feature_of_vertebrate_immune_system_gene';

--- ************************************************
--- *** relation: vertebrate_immune_system_gene_recombination_spacer ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW vertebrate_immune_system_gene_recombination_spacer AS
  SELECT
    feature_id AS vertebrate_immune_system_gene_recombination_spacer_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_D_spacer' OR cvterm.name = 'five_prime_D_spacer' OR cvterm.name = 'J_spacer' OR cvterm.name = 'V_spacer' OR cvterm.name = 'vertebrate_immune_system_gene_recombination_spacer';

--- ************************************************
--- *** relation: v_dj_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one DJ-gen ***
--- *** e, one J-gene and one C-gene.            ***
--- ************************************************
---

CREATE VIEW v_dj_j_c_cluster AS
  SELECT
    feature_id AS v_dj_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_DJ_J_C_cluster';

--- ************************************************
--- *** relation: v_vdj_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one VDJ-ge ***
--- *** ne, one J-gene and one C-gene.           ***
--- ************************************************
---

CREATE VIEW v_vdj_j_c_cluster AS
  SELECT
    feature_id AS v_vdj_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_VDJ_J_C_cluster';

--- ************************************************
--- *** relation: v_vj_j_c_cluster ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in rearranged configuration i ***
--- *** ncluding at least one V-gene, one VJ-gen ***
--- *** e, one J-gene and one C-gene.            ***
--- ************************************************
---

CREATE VIEW v_vj_j_c_cluster AS
  SELECT
    feature_id AS v_vj_j_c_cluster_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'V_VJ_J_C_cluster';

--- ************************************************
