SET search_path=so,chado,pg_catalog;
--- *** relation: inversion_derived_aneuploid_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome may be generated by recombi ***
--- *** nation between two inversions; presumed  ***
--- *** to have a deficiency or duplication at e ***
--- *** ach end of the inversion.                ***
--- ************************************************
---

CREATE VIEW inversion_derived_aneuploid_chromosome AS
  SELECT
    feature_id AS inversion_derived_aneuploid_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'inversion_derived_aneuploid_chromosome';

--- ************************************************
--- *** relation: bidirectional_promoter ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW bidirectional_promoter AS
  SELECT
    feature_id AS bidirectional_promoter_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'bidirectional_promoter';

--- ************************************************
--- *** relation: retrotransposed ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An attribute of a feature that occurred  ***
--- *** as the product of a reverse transcriptas ***
--- *** e mediated event.                        ***
--- ************************************************
---

CREATE VIEW retrotransposed AS
  SELECT
    feature_id AS retrotransposed_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'retrotransposed';

--- ************************************************
--- *** relation: three_prime_d_recombination_signal_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Recombination signal of an immunoglobuli ***
--- *** n/T-cell receptor gene, including the 3' ***
--- ***  D-heptamer (SO:0000493), 3' D-spacer, a ***
--- *** nd 3' D-nonamer (SO:0000494) in 3' of th ***
--- *** e D-region of a D-gene.                  ***
--- ************************************************
---

CREATE VIEW three_prime_d_recombination_signal_sequence AS
  SELECT
    feature_id AS three_prime_d_recombination_signal_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_prime_D_recombination_signal_sequence';

--- ************************************************
--- *** relation: mirna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW mirna_encoding AS
  SELECT
    feature_id AS mirna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'miRNA_encoding';

--- ************************************************
--- *** relation: dj_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Genomic DNA of immunoglobulin/T-cell rec ***
--- *** eptor gene in partially rearranged genom ***
--- *** ic DNA including D-J-region with 5' UTR  ***
--- *** and 3' UTR, also designated as D-J-segme ***
--- *** nt.                                      ***
--- ************************************************
---

CREATE VIEW dj_gene AS
  SELECT
    feature_id AS dj_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'DJ_gene';

--- ************************************************
--- *** relation: rrna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW rrna_encoding AS
  SELECT
    feature_id AS rrna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_encoding';

--- ************************************************
--- *** relation: vdj_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Rearranged genomic DNA of immunoglobulin ***
--- *** /T-cell receptor gene including L-part1, ***
--- ***  V-intron and V-D-J-exon, with the 5'UTR ***
--- ***  (SO:0000204) and 3'UTR (SO:0000205).    ***
--- ************************************************
---

CREATE VIEW vdj_gene AS
  SELECT
    feature_id AS vdj_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'VDJ_gene';

--- ************************************************
--- *** relation: scrna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW scrna_encoding AS
  SELECT
    feature_id AS scrna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'scRNA_encoding';

--- ************************************************
--- *** relation: vj_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Rearranged genomic DNA of immunoglobulin ***
--- *** /T-cell receptor gene including L-part1, ***
--- ***  V-intron and V-J-exon, with the 5'UTR ( ***
--- *** SO:0000204) and 3'UTR (SO:0000205).      ***
--- ************************************************
---

CREATE VIEW vj_gene AS
  SELECT
    feature_id AS vj_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'VJ_gene';

--- ************************************************
--- *** relation: centromere ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of chromosome where the spindle ***
--- ***  fibers attach during mitosis and meiosi ***
--- *** s.                                       ***
--- ************************************************
---

CREATE VIEW centromere AS
  SELECT
    feature_id AS centromere_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'point_centromere' OR cvterm.name = 'regional_centromere' OR cvterm.name = 'centromere';

--- ************************************************
--- *** relation: snorna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW snorna_encoding AS
  SELECT
    feature_id AS snorna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'C_D_box_snoRNA_encoding' OR cvterm.name = 'H_ACA_box_snoRNA_encoding' OR cvterm.name = 'snoRNA_encoding';

--- ************************************************
--- *** relation: edited_transcript_feature ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A locatable feature on a transcript that ***
--- ***  is edited.                              ***
--- ************************************************
---

CREATE VIEW edited_transcript_feature AS
  SELECT
    feature_id AS edited_transcript_feature_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pre_edited_region' OR cvterm.name = 'editing_block' OR cvterm.name = 'editing_domain' OR cvterm.name = 'unedited_region' OR cvterm.name = 'edited_transcript_feature';

--- ************************************************
--- *** relation: methylation_guide_snorna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a methylat ***
--- *** ion guide small nucleolar RNA.           ***
--- ************************************************
---

CREATE VIEW methylation_guide_snorna_primary_transcript AS
  SELECT
    feature_id AS methylation_guide_snorna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'methylation_guide_snoRNA_primary_transcript';

--- ************************************************
--- *** relation: cap ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A structure consisting of a 7-methylguan ***
--- *** osine in 5'-5' triphosphate linkage with ***
--- ***  the first nucleotide of an mRNA. It is  ***
--- *** added post-transcriptionally, and is not ***
--- ***  encoded in the DNA.                     ***
--- ************************************************
---

CREATE VIEW cap AS
  SELECT
    feature_id AS cap_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'cap';

--- ************************************************
--- *** relation: rrna_cleavage_snorna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding an rRNA cl ***
--- *** eavage snoRNA.                           ***
--- ************************************************
---

CREATE VIEW rrna_cleavage_snorna_primary_transcript AS
  SELECT
    feature_id AS rrna_cleavage_snorna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rRNA_cleavage_snoRNA_primary_transcript';

--- ************************************************
--- *** relation: pre_edited_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The region of a transcript that will be  ***
--- *** edited.                                  ***
--- ************************************************
---

CREATE VIEW pre_edited_region AS
  SELECT
    feature_id AS pre_edited_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pre_edited_region';

--- ************************************************
--- *** relation: tmrna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tmRNA liberates a mRNA from a stalled  ***
--- *** ribosome. To accomplish this part of the ***
--- ***  tmRNA is used as a reading frame that e ***
--- *** nds in a translation stop signal. The br ***
--- *** oken mRNA is replaced in the ribosome by ***
--- ***  the tmRNA and translation of the tmRNA  ***
--- *** leads to addition of a proteolysis tag t ***
--- *** o the incomplete protein enabling recogn ***
--- *** ition by a protease. Recently a number o ***
--- *** f permuted tmRNAs genes have been found  ***
--- *** encoded in two parts. TmRNAs have been i ***
--- *** dentified in eubacteria and some chlorop ***
--- *** lasts but are absent from archeal and Eu ***
--- *** karyote nuclear genomes.                 ***
--- ************************************************
---

CREATE VIEW tmrna AS
  SELECT
    feature_id AS tmrna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tmRNA';

--- ************************************************
--- *** relation: c_d_box_snorna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW c_d_box_snorna_encoding AS
  SELECT
    feature_id AS c_d_box_snorna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'C_D_box_snoRNA_encoding';

--- ************************************************
--- *** relation: tmrna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a tmRNA (S ***
--- *** O:0000584).                              ***
--- ************************************************
---

CREATE VIEW tmrna_primary_transcript AS
  SELECT
    feature_id AS tmrna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tmRNA_primary_transcript';

--- ************************************************
--- *** relation: group_i_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Group I catalytic introns are large self ***
--- *** -splicing ribozymes. They catalyze their ***
--- ***  own excision from mRNA, tRNA and rRNA p ***
--- *** recursors in a wide range of organisms.  ***
--- *** The core secondary structure consists of ***
--- ***  9 paired regions (P1-P9). These fold to ***
--- ***  essentially two domains, the P4-P6 doma ***
--- *** in (formed from the stacking of P5, P4,  ***
--- *** P6 and P6a helices) and the P3-P9 domain ***
--- ***  (formed from the P8, P3, P7 and P9 heli ***
--- *** ces). Group I catalytic introns often ha ***
--- *** ve long ORFs inserted in loop regions.   ***
--- ************************************************
---

CREATE VIEW group_i_intron AS
  SELECT
    feature_id AS group_i_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'group_I_intron';

--- ************************************************
--- *** relation: autocatalytically_spliced_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A self spliced intron.                   ***
--- ************************************************
---

CREATE VIEW autocatalytically_spliced_intron AS
  SELECT
    feature_id AS autocatalytically_spliced_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'group_I_intron' OR cvterm.name = 'group_II_intron' OR cvterm.name = 'group_III_intron' OR cvterm.name = 'group_IIA_intron' OR cvterm.name = 'group_IIB_intron' OR cvterm.name = 'autocatalytically_spliced_intron';

--- ************************************************
--- *** relation: srp_rna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a signal r ***
--- *** ecognition particle RNA.                 ***
--- ************************************************
---

CREATE VIEW srp_rna_primary_transcript AS
  SELECT
    feature_id AS srp_rna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'SRP_RNA_primary_transcript';

--- ************************************************
--- *** relation: srp_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The signal recognition particle (SRP) is ***
--- ***  a universally conserved ribonucleoprote ***
--- *** in. It is involved in the co-translation ***
--- *** al targeting of proteins to membranes. T ***
--- *** he eukaryotic SRP consists of a 300-nucl ***
--- *** eotide 7S RNA and six proteins: SRPs 72, ***
--- ***  68, 54, 19, 14, and 9. Archaeal SRP con ***
--- *** sists of a 7S RNA and homologues of the  ***
--- *** eukaryotic SRP19 and SRP54 proteins. In  ***
--- *** most eubacteria, the SRP consists of a 4 ***
--- *** .5S RNA and the Ffh protein (a homologue ***
--- ***  of the eukaryotic SRP54 protein). Eukar ***
--- *** yotic and archaeal 7S RNAs have very sim ***
--- *** ilar secondary structures, with eight he ***
--- *** lical elements. These fold into the Alu  ***
--- *** and S domains, separated by a long linke ***
--- *** r region. Eubacterial SRP is generally a ***
--- ***  simpler structure, with the M domain of ***
--- ***  Ffh bound to a region of the 4.5S RNA t ***
--- *** hat corresponds to helix 8 of the eukary ***
--- *** otic and archaeal SRP S domain. Some Gra ***
--- *** m-positive bacteria (e.g. Bacillus subti ***
--- *** lis), however, have a larger SRP RNA tha ***
--- *** t also has an Alu domain. The Alu domain ***
--- ***  is thought to mediate the peptide chain ***
--- ***  elongation retardation function of the  ***
--- *** SRP. The universally conserved helix whi ***
--- *** ch interacts with the SRP54/Ffh M domain ***
--- ***  mediates signal sequence recognition. I ***
--- *** n eukaryotes and archaea, the SRP19-heli ***
--- *** x 6 complex is thought to be involved in ***
--- ***  SRP assembly and stabilizes helix 8 for ***
--- ***  SRP54 binding.                          ***
--- ************************************************
---

CREATE VIEW srp_rna AS
  SELECT
    feature_id AS srp_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'SRP_RNA';

--- ************************************************
--- *** relation: pseudoknot ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A tertiary structure in RNA where nucleo ***
--- *** tides in a loop form base pairs with a r ***
--- *** egion of RNA downstream of the loop.     ***
--- ************************************************
---

CREATE VIEW pseudoknot AS
  SELECT
    feature_id AS pseudoknot_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'recoding_pseudoknot' OR cvterm.name = 'H_pseudoknot' OR cvterm.name = 'pseudoknot';

--- ************************************************
--- *** relation: h_pseudoknot ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A pseudoknot which contains two stems an ***
--- *** d at least two loops.                    ***
--- ************************************************
---

CREATE VIEW h_pseudoknot AS
  SELECT
    feature_id AS h_pseudoknot_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'H_pseudoknot';

--- ************************************************
--- *** relation: c_d_box_snorna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Most box C/D snoRNAs also contain long ( ***
--- *** >10 nt) sequences complementary to rRNA. ***
--- ***  Boxes C and D, as well as boxes C' and  ***
--- *** D', are usually located in close proximi ***
--- *** ty, and form a structure known as the bo ***
--- *** x C/D motif. This motif is important for ***
--- ***  snoRNA stability, processing, nucleolar ***
--- ***  targeting and function. A small number  ***
--- *** of box C/D snoRNAs are involved in rRNA  ***
--- *** processing; most, however, are known or  ***
--- *** predicted to serve as guide RNAs in ribo ***
--- *** se methylation of rRNA. Targeting involv ***
--- *** es direct base pairing of the snoRNA at  ***
--- *** the rRNA site to be modified and selecti ***
--- *** on of a rRNA nucleotide a fixed distance ***
--- ***  from box D or D'.                       ***
--- ************************************************
---

CREATE VIEW c_d_box_snorna AS
  SELECT
    feature_id AS c_d_box_snorna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'U14_snoRNA' OR cvterm.name = 'U3_snoRNA' OR cvterm.name = 'methylation_guide_snoRNA' OR cvterm.name = 'C_D_box_snoRNA';

--- ************************************************
--- *** relation: h_aca_box_snorna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Members of the box H/ACA family contain  ***
--- *** an ACA triplet, exactly 3 nt upstream fr ***
--- *** om the 3' end and an H-box in a hinge re ***
--- *** gion that links two structurally similar ***
--- ***  functional domains of the molecule. Bot ***
--- *** h boxes are important for snoRNA biosynt ***
--- *** hesis and function. A few box H/ACA snoR ***
--- *** NAs are involved in rRNA processing; mos ***
--- *** t others are known or predicted to parti ***
--- *** cipate in selection of uridine nucleosid ***
--- *** es in rRNA to be converted to pseudourid ***
--- *** ines. Site selection is mediated by dire ***
--- *** ct base pairing of the snoRNA with rRNA  ***
--- *** through one or both targeting domains.   ***
--- ************************************************
---

CREATE VIEW h_aca_box_snorna AS
  SELECT
    feature_id AS h_aca_box_snorna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'pseudouridylation_guide_snoRNA' OR cvterm.name = 'H_ACA_box_snoRNA';

--- ************************************************
--- *** relation: c_d_box_snorna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a small nu ***
--- *** cleolar RNA of the box C/D family.       ***
--- ************************************************
---

CREATE VIEW c_d_box_snorna_primary_transcript AS
  SELECT
    feature_id AS c_d_box_snorna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'C_D_box_snoRNA_primary_transcript';

--- ************************************************
--- *** relation: h_aca_box_snorna_primary_transcript ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A primary transcript encoding a small nu ***
--- *** cleolar RNA of the box H/ACA family.     ***
--- ************************************************
---

CREATE VIEW h_aca_box_snorna_primary_transcript AS
  SELECT
    feature_id AS h_aca_box_snorna_primary_transcript_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'H_ACA_box_snoRNA_primary_transcript';

--- ************************************************
--- *** relation: guide_rna ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A short 3'-uridylated RNA that can form  ***
--- *** a duplex (except for its post-transcript ***
--- *** ionally added oligo_U tail (SO:0000609)) ***
--- ***  with a stretch of mature edited mRNA.   ***
--- ************************************************
---

CREATE VIEW guide_rna AS
  SELECT
    feature_id AS guide_rna_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'guide_RNA';

--- ************************************************
--- *** relation: group_ii_intron ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Group II introns are found in rRNA, tRNA ***
--- ***  and mRNA of organelles in fungi, plants ***
--- ***  and protists, and also in mRNA in bacte ***
--- *** ria. They are large self-splicing ribozy ***
--- *** mes and have 6 structural domains (usual ***
--- *** ly designated dI to dVI). A subset of gr ***
--- *** oup II introns also encode essential spl ***
--- *** icing proteins in intronic ORFs. The len ***
--- *** gth of these introns can therefore be up ***
--- ***  to 3kb. Splicing occurs in almost ident ***
--- *** ical fashion to nuclear pre-mRNA splicin ***
--- *** g with two transesterification steps. Th ***
--- *** e 2' hydroxyl of a bulged adenosine in d ***
--- *** omain VI attacks the 5' splice site, fol ***
--- *** lowed by nucleophilic attack on the 3' s ***
--- *** plice site by the 3' OH of the upstream  ***
--- *** exon. Protein machinery is required for  ***
--- *** splicing in vivo, and long range intron- ***
--- *** intron and intron-exon interactions are  ***
--- *** important for splice site positioning. G ***
--- *** roup II introns are further sub-classifi ***
--- *** ed into groups IIA and IIB which differ  ***
--- *** in splice site consensus, distance of bu ***
--- *** lged A from 3' splice site, some tertiar ***
--- *** y interactions, and intronic ORF phyloge ***
--- *** ny.                                      ***
--- ************************************************
---

CREATE VIEW group_ii_intron AS
  SELECT
    feature_id AS group_ii_intron_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'group_IIA_intron' OR cvterm.name = 'group_IIB_intron' OR cvterm.name = 'group_II_intron';

--- ************************************************
--- *** relation: editing_block ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Edited mRNA sequence mediated by a singl ***
--- *** e guide RNA (SO:0000602).                ***
--- ************************************************
---

CREATE VIEW editing_block AS
  SELECT
    feature_id AS editing_block_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'editing_block';

--- ************************************************
--- *** relation: intergenic_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region containing or overlapping no ge ***
--- *** nes that is bounded on either side by a  ***
--- *** gene, or bounded by a gene and the end o ***
--- *** f the chromosome.                        ***
--- ************************************************
---

CREATE VIEW intergenic_region AS
  SELECT
    feature_id AS intergenic_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'intergenic_region';

--- ************************************************
--- *** relation: editing_domain ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Edited mRNA sequence mediated by two or  ***
--- *** more overlapping guide RNAs (SO:0000602) ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW editing_domain AS
  SELECT
    feature_id AS editing_domain_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'editing_domain';

--- ************************************************
--- *** relation: unedited_region ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The region of an edited transcript that  ***
--- *** will not be edited.                      ***
--- ************************************************
---

CREATE VIEW unedited_region AS
  SELECT
    feature_id AS unedited_region_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'unedited_region';

--- ************************************************
--- *** relation: h_aca_box_snorna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW h_aca_box_snorna_encoding AS
  SELECT
    feature_id AS h_aca_box_snorna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'H_ACA_box_snoRNA_encoding';

--- ************************************************
--- *** relation: oligo_u_tail ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The string of non-encoded U's at the 3'  ***
--- *** end of a guide RNA (SO:0000602).         ***
--- ************************************************
---

CREATE VIEW oligo_u_tail AS
  SELECT
    feature_id AS oligo_u_tail_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'oligo_U_tail';

--- ************************************************
--- *** relation: polya_sequence ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Sequence of about 100 nucleotides of A a ***
--- *** dded to the 3' end of most eukaryotic mR ***
--- *** NAs.                                     ***
--- ************************************************
---

CREATE VIEW polya_sequence AS
  SELECT
    feature_id AS polya_sequence_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polyA_sequence';

--- ************************************************
--- *** relation: branch_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A pyrimidine rich sequence near the 3' e ***
--- *** nd of an intron to which the 5'end becom ***
--- *** es covalently bound during nuclear splic ***
--- *** ing. The resulting structure resembles a ***
--- ***  lariat.                                 ***
--- ************************************************
---

CREATE VIEW branch_site AS
  SELECT
    feature_id AS branch_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'branch_site';

--- ************************************************
--- *** relation: polypyrimidine_tract ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The polypyrimidine tract is one of the c ***
--- *** is-acting sequence elements directing in ***
--- *** tron removal in pre-mRNA splicing.       ***
--- ************************************************
---

CREATE VIEW polypyrimidine_tract AS
  SELECT
    feature_id AS polypyrimidine_tract_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'polypyrimidine_tract';

--- ************************************************
--- *** relation: bacterial_rnapol_promoter ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A DNA sequence to which bacterial RNA po ***
--- *** lymerase binds, to begin transcription.  ***
--- ************************************************
---

CREATE VIEW bacterial_rnapol_promoter AS
  SELECT
    feature_id AS bacterial_rnapol_promoter_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'bacterial_RNApol_promoter_sigma_70' OR cvterm.name = 'bacterial_RNApol_promoter_sigma54' OR cvterm.name = 'bacterial_RNApol_promoter';

--- ************************************************
--- *** relation: bacterial_terminator ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A terminator signal for bacterial transc ***
--- *** ription.                                 ***
--- ************************************************
---

CREATE VIEW bacterial_terminator AS
  SELECT
    feature_id AS bacterial_terminator_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'rho_dependent_bacterial_terminator' OR cvterm.name = 'rho_independent_bacterial_terminator' OR cvterm.name = 'bacterial_terminator';

--- ************************************************
--- *** relation: terminator_of_type_2_rnapol_iii_promoter ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A terminator signal for RNA polymerase I ***
--- *** II transcription.                        ***
--- ************************************************
---

CREATE VIEW terminator_of_type_2_rnapol_iii_promoter AS
  SELECT
    feature_id AS terminator_of_type_2_rnapol_iii_promoter_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'terminator_of_type_2_RNApol_III_promoter';

--- ************************************************
--- *** relation: transcription_end_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The base where transcription ends.       ***
--- ************************************************
---

CREATE VIEW transcription_end_site AS
  SELECT
    feature_id AS transcription_end_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'transcription_end_site';

--- ************************************************
--- *** relation: rnapol_iii_promoter_type_1 ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW rnapol_iii_promoter_type_1 AS
  SELECT
    feature_id AS rnapol_iii_promoter_type_1_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNApol_III_promoter_type_1';

--- ************************************************
--- *** relation: rnapol_iii_promoter_type_2 ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW rnapol_iii_promoter_type_2 AS
  SELECT
    feature_id AS rnapol_iii_promoter_type_2_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNApol_III_promoter_type_2';

--- ************************************************
--- *** relation: a_box ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A variably distant linear promoter regio ***
--- *** n recognized by TFIIIC, with consensus s ***
--- *** equence TGGCnnAGTGG.                     ***
--- ************************************************
---

CREATE VIEW a_box AS
  SELECT
    feature_id AS a_box_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'A_box_type_1' OR cvterm.name = 'A_box_type_2' OR cvterm.name = 'A_box';

--- ************************************************
--- *** relation: b_box ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A variably distant linear promoter regio ***
--- *** n recognized by TFIIIC, with consensus s ***
--- *** equence AGGTTCCAnnCC.                    ***
--- ************************************************
---

CREATE VIEW b_box AS
  SELECT
    feature_id AS b_box_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'B_box';

--- ************************************************
--- *** relation: rnapol_iii_promoter_type_3 ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW rnapol_iii_promoter_type_3 AS
  SELECT
    feature_id AS rnapol_iii_promoter_type_3_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RNApol_III_promoter_type_3';

--- ************************************************
--- *** relation: c_box ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An RNA polymerase III type 1 promoter wi ***
--- *** th consensus sequence CAnnCCn.           ***
--- ************************************************
---

CREATE VIEW c_box AS
  SELECT
    feature_id AS c_box_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'C_box';

--- ************************************************
--- *** relation: snrna_encoding ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW snrna_encoding AS
  SELECT
    feature_id AS snrna_encoding_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'snRNA_encoding';

--- ************************************************
--- *** relation: telomere ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A specific structure at the end of a lin ***
--- *** ear chromosome, required for the integri ***
--- *** ty and maintenance of the end.           ***
--- ************************************************
---

CREATE VIEW telomere AS
  SELECT
    feature_id AS telomere_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'telomere';

--- ************************************************
