SET search_path=so,chado,pg_catalog;
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A region of the genome of known length t ***
--- *** hat is composed by ordering and aligning ***
--- ***  two or more different regions.          ***
--- ************************************************
---

CREATE VIEW assembly AS
  SELECT
    feature_id AS assembly_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'sequence_assembly' OR cvterm.name = 'fragment_assembly' OR cvterm.name = 'supercontig' OR cvterm.name = 'contig' OR cvterm.name = 'tiling_path' OR cvterm.name = 'virtual_sequence' OR cvterm.name = 'golden_path' OR cvterm.name = 'ultracontig' OR cvterm.name = 'expressed_sequence_assembly' OR cvterm.name = 'fingerprint_map' OR cvterm.name = 'STS_map' OR cvterm.name = 'RH_map' OR cvterm.name = 'assembly';

--- ************************************************
--- *** relation: fragment_assembly ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A fragment assembly is a genome assembly ***
--- ***  that orders overlapping fragments of th ***
--- *** e genome based on landmark sequences. Th ***
--- *** e base pair distance between the landmar ***
--- *** ks is known allowing additivity of lengt ***
--- *** hs.                                      ***
--- ************************************************
---

CREATE VIEW fragment_assembly AS
  SELECT
    feature_id AS fragment_assembly_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'fingerprint_map' OR cvterm.name = 'STS_map' OR cvterm.name = 'RH_map' OR cvterm.name = 'fragment_assembly';

--- ************************************************
--- *** relation: fingerprint_map ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A fingerprint_map is a physical map comp ***
--- *** osed of restriction fragments.           ***
--- ************************************************
---

CREATE VIEW fingerprint_map AS
  SELECT
    feature_id AS fingerprint_map_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'fingerprint_map';

--- ************************************************
--- *** relation: sts_map ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** An STS map is a physical map organized b ***
--- *** y the unique STS landmarks.              ***
--- ************************************************
---

CREATE VIEW sts_map AS
  SELECT
    feature_id AS sts_map_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'STS_map';

--- ************************************************
--- *** relation: rh_map ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A radiation hybrid map is a physical map ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW rh_map AS
  SELECT
    feature_id AS rh_map_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'RH_map';

--- ************************************************
--- *** relation: sonicate_fragment ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A DNA fragment generated by sonication.  ***
--- *** Sonication is a technique used to sheer  ***
--- *** DNA into smaller fragments.              ***
--- ************************************************
---

CREATE VIEW sonicate_fragment AS
  SELECT
    feature_id AS sonicate_fragment_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'sonicate_fragment';

--- ************************************************
--- *** relation: polyploid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A kind of chromosome variation where the ***
--- ***  chromosome complement is an exact multi ***
--- *** ple of the haploid number and is greater ***
--- ***  than the diploid number.                ***
--- ************************************************
---

CREATE VIEW polyploid AS
  SELECT
    feature_id AS polyploid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'autopolyploid' OR cvterm.name = 'allopolyploid' OR cvterm.name = 'polyploid';

--- ************************************************
--- *** relation: autopolyploid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A polyploid where the multiple chromosom ***
--- *** e set was derived from the same organism ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW autopolyploid AS
  SELECT
    feature_id AS autopolyploid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'autopolyploid';

--- ************************************************
--- *** relation: allopolyploid ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A polyploid where the multiple chromosom ***
--- *** e set was derived from a different organ ***
--- *** ism.                                     ***
--- ************************************************
---

CREATE VIEW allopolyploid AS
  SELECT
    feature_id AS allopolyploid_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'allopolyploid';

--- ************************************************
--- *** relation: homing_endonuclease_binding_site ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** The binding site (recognition site) of a ***
--- ***  homing endonuclease. The binding site i ***
--- *** s typically large.                       ***
--- ************************************************
---

CREATE VIEW homing_endonuclease_binding_site AS
  SELECT
    feature_id AS homing_endonuclease_binding_site_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'homing_endonuclease_binding_site';

--- ************************************************
--- *** relation: octamer_motif ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A sequence element characteristic of som ***
--- *** e RNA polymerase II promoters with seque ***
--- *** nce ATTGCAT that binds Pou-domain transc ***
--- *** ription factors.                         ***
--- ************************************************
---

CREATE VIEW octamer_motif AS
  SELECT
    feature_id AS octamer_motif_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'octamer_motif';

--- ************************************************
--- *** relation: apicoplast_chromosome ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A chromosome originating in an apicoplas ***
--- *** t.                                       ***
--- ************************************************
---

CREATE VIEW apicoplast_chromosome AS
  SELECT
    feature_id AS apicoplast_chromosome_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'apicoplast_chromosome';

--- ************************************************
--- *** relation: sequence_collection ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A collection of discontinuous sequences. ***
--- ************************************************
---

CREATE VIEW sequence_collection AS
  SELECT
    feature_id AS sequence_collection_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'kinetoplast' OR cvterm.name = 'genome' OR cvterm.name = 'contig_collection' OR cvterm.name = 'peptide_collection' OR cvterm.name = 'variant_collection' OR cvterm.name = 'kinetoplast' OR cvterm.name = 'reference_genome' OR cvterm.name = 'variant_genome' OR cvterm.name = 'chromosomally_aberrant_genome' OR cvterm.name = 'chromosome_variation' OR cvterm.name = 'allele' OR cvterm.name = 'haplotype' OR cvterm.name = 'genotype' OR cvterm.name = 'diplotype' OR cvterm.name = 'assortment_derived_variation' OR cvterm.name = 'chromosome_number_variation' OR cvterm.name = 'chromosome_structure_variation' OR cvterm.name = 'assortment_derived_duplication' OR cvterm.name = 'assortment_derived_deficiency_plus_duplication' OR cvterm.name = 'assortment_derived_deficiency' OR cvterm.name = 'assortment_derived_aneuploid' OR cvterm.name = 'aneuploid' OR cvterm.name = 'polyploid' OR cvterm.name = 'hyperploid' OR cvterm.name = 'hypoploid' OR cvterm.name = 'autopolyploid' OR cvterm.name = 'allopolyploid' OR cvterm.name = 'free_chromosome_arm' OR cvterm.name = 'chromosomal_transposition' OR cvterm.name = 'aneuploid_chromosome' OR cvterm.name = 'intrachromosomal_mutation' OR cvterm.name = 'interchromosomal_mutation' OR cvterm.name = 'chromosomal_duplication' OR cvterm.name = 'compound_chromosome' OR cvterm.name = 'autosynaptic_chromosome' OR cvterm.name = 'complex_chromosomal_mutation' OR cvterm.name = 'uncharacterised_chromosomal_mutation' OR cvterm.name = 'intrachromosomal_transposition' OR cvterm.name = 'interchromosomal_transposition' OR cvterm.name = 'deficient_intrachromosomal_transposition' OR cvterm.name = 'inverted_intrachromosomal_transposition' OR cvterm.name = 'uninverted_intrachromosomal_transposition' OR cvterm.name = 'unoriented_intrachromosomal_transposition' OR cvterm.name = 'deficient_interchromosomal_transposition' OR cvterm.name = 'inverted_interchromosomal_transposition' OR cvterm.name = 'uninverted_interchromosomal_transposition' OR cvterm.name = 'unoriented_interchromosomal_transposition' OR cvterm.name = 'inversion_derived_aneuploid_chromosome' OR cvterm.name = 'chromosomal_deletion' OR cvterm.name = 'chromosomal_inversion' OR cvterm.name = 'intrachromosomal_duplication' OR cvterm.name = 'ring_chromosome' OR cvterm.name = 'chromosome_fission' OR cvterm.name = 'deficient_intrachromosomal_transposition' OR cvterm.name = 'inversion_derived_bipartite_deficiency' OR cvterm.name = 'inversion_derived_deficiency_plus_duplication' OR cvterm.name = 'inversion_derived_deficiency_plus_aneuploid' OR cvterm.name = 'deficient_translocation' OR cvterm.name = 'deficient_inversion' OR cvterm.name = 'inverted_ring_chromosome' OR cvterm.name = 'pericentric_inversion' OR cvterm.name = 'paracentric_inversion' OR cvterm.name = 'inversion_cum_translocation' OR cvterm.name = 'bipartite_inversion' OR cvterm.name = 'inverted_intrachromosomal_transposition' OR cvterm.name = 'deficient_inversion' OR cvterm.name = 'inverted_intrachromosomal_transposition' OR cvterm.name = 'inversion_derived_deficiency_plus_duplication' OR cvterm.name = 'inversion_derived_bipartite_duplication' OR cvterm.name = 'inversion_derived_duplication_plus_aneuploid' OR cvterm.name = 'intrachromosomal_transposition' OR cvterm.name = 'bipartite_duplication' OR cvterm.name = 'deficient_intrachromosomal_transposition' OR cvterm.name = 'inverted_intrachromosomal_transposition' OR cvterm.name = 'uninverted_intrachromosomal_transposition' OR cvterm.name = 'unoriented_intrachromosomal_transposition' OR cvterm.name = 'inverted_ring_chromosome' OR cvterm.name = 'free_ring_duplication' OR cvterm.name = 'chromosomal_translocation' OR cvterm.name = 'bipartite_duplication' OR cvterm.name = 'interchromosomal_transposition' OR cvterm.name = 'translocation_element' OR cvterm.name = 'Robertsonian_fusion' OR cvterm.name = 'reciprocal_chromosomal_translocation' OR cvterm.name = 'deficient_translocation' OR cvterm.name = 'inversion_cum_translocation' OR cvterm.name = 'cyclic_translocation' OR cvterm.name = 'inverted_intrachromosomal_transposition' OR cvterm.name = 'deficient_interchromosomal_transposition' OR cvterm.name = 'inverted_interchromosomal_transposition' OR cvterm.name = 'uninverted_interchromosomal_transposition' OR cvterm.name = 'unoriented_interchromosomal_transposition' OR cvterm.name = 'interchromosomal_duplication' OR cvterm.name = 'intrachromosomal_duplication' OR cvterm.name = 'free_duplication' OR cvterm.name = 'insertional_duplication' OR cvterm.name = 'inversion_derived_deficiency_plus_duplication' OR cvterm.name = 'inversion_derived_bipartite_duplication' OR cvterm.name = 'inversion_derived_duplication_plus_aneuploid' OR cvterm.name = 'intrachromosomal_transposition' OR cvterm.name = 'bipartite_duplication' OR cvterm.name = 'deficient_intrachromosomal_transposition' OR cvterm.name = 'inverted_intrachromosomal_transposition' OR cvterm.name = 'uninverted_intrachromosomal_transposition' OR cvterm.name = 'unoriented_intrachromosomal_transposition' OR cvterm.name = 'free_ring_duplication' OR cvterm.name = 'uninverted_insertional_duplication' OR cvterm.name = 'inverted_insertional_duplication' OR cvterm.name = 'unoriented_insertional_duplication' OR cvterm.name = 'compound_chromosome_arm' OR cvterm.name = 'homo_compound_chromosome' OR cvterm.name = 'hetero_compound_chromosome' OR cvterm.name = 'dexstrosynaptic_chromosome' OR cvterm.name = 'laevosynaptic_chromosome' OR cvterm.name = 'partially_characterised_chromosomal_mutation' OR cvterm.name = 'polymorphic_sequence_variant' OR cvterm.name = 'sequence_collection';

--- ************************************************
--- *** relation: overlapping_feature_set ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A continuous region of sequence composed ***
--- ***  of the overlapping of multiple sequence ***
--- *** _features, which ultimately provides evi ***
--- *** dence for another sequence_feature.      ***
--- ************************************************
---

CREATE VIEW overlapping_feature_set AS
  SELECT
    feature_id AS overlapping_feature_set_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'overlapping_EST_set' OR cvterm.name = 'overlapping_feature_set';

--- ************************************************
--- *** relation: overlapping_est_set ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A continous experimental result region e ***
--- *** xtending the length of multiple overlapp ***
--- *** ing EST's.                               ***
--- ************************************************
---

CREATE VIEW overlapping_est_set AS
  SELECT
    feature_id AS overlapping_est_set_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'overlapping_EST_set';

--- ************************************************
--- *** relation: ncrna_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW ncrna_gene AS
  SELECT
    feature_id AS ncrna_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gRNA_gene' OR cvterm.name = 'miRNA_gene' OR cvterm.name = 'scRNA_gene' OR cvterm.name = 'snoRNA_gene' OR cvterm.name = 'snRNA_gene' OR cvterm.name = 'SRP_RNA_gene' OR cvterm.name = 'stRNA_gene' OR cvterm.name = 'tmRNA_gene' OR cvterm.name = 'tRNA_gene' OR cvterm.name = 'rRNA_gene' OR cvterm.name = 'piRNA_gene' OR cvterm.name = 'RNase_P_RNA_gene' OR cvterm.name = 'RNase_MRP_RNA_gene' OR cvterm.name = 'lincRNA_gene' OR cvterm.name = 'telomerase_RNA_gene' OR cvterm.name = 'ncRNA_gene';

--- ************************************************
--- *** relation: grna_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW grna_gene AS
  SELECT
    feature_id AS grna_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'gRNA_gene';

--- ************************************************
--- *** relation: mirna_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW mirna_gene AS
  SELECT
    feature_id AS mirna_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'miRNA_gene';

--- ************************************************
--- *** relation: scrna_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW scrna_gene AS
  SELECT
    feature_id AS scrna_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'scRNA_gene';

--- ************************************************
--- *** relation: snorna_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW snorna_gene AS
  SELECT
    feature_id AS snorna_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'snoRNA_gene';

--- ************************************************
--- *** relation: snrna_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW snrna_gene AS
  SELECT
    feature_id AS snrna_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'snRNA_gene';

--- ************************************************
--- *** relation: srp_rna_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW srp_rna_gene AS
  SELECT
    feature_id AS srp_rna_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'SRP_RNA_gene';

--- ************************************************
--- *** relation: strna_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW strna_gene AS
  SELECT
    feature_id AS strna_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'stRNA_gene';

--- ************************************************
--- *** relation: tmrna_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW tmrna_gene AS
  SELECT
    feature_id AS tmrna_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tmRNA_gene';

--- ************************************************
--- *** relation: trna_gene ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW trna_gene AS
  SELECT
    feature_id AS trna_gene_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'tRNA_gene';

--- ************************************************
--- *** relation: modified_adenosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A modified adenine is an adenine base fe ***
--- *** ature that has been altered.             ***
--- ************************************************
---

CREATE VIEW modified_adenosine AS
  SELECT
    feature_id AS modified_adenosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'one_methyladenosine' OR cvterm.name = 'two_methyladenosine' OR cvterm.name = 'N6_methyladenosine' OR cvterm.name = 'two_prime_O_methyladenosine' OR cvterm.name = 'two_methylthio_N6_methyladenosine' OR cvterm.name = 'N6_isopentenyladenosine' OR cvterm.name = 'two_methylthio_N6_isopentenyladenosine' OR cvterm.name = 'N6_cis_hydroxyisopentenyl_adenosine' OR cvterm.name = 'two_methylthio_N6_cis_hydroxyisopentenyl_adenosine' OR cvterm.name = 'N6_glycinylcarbamoyladenosine' OR cvterm.name = 'N6_threonylcarbamoyladenosine' OR cvterm.name = 'two_methylthio_N6_threonyl_carbamoyladenosine' OR cvterm.name = 'N6_methyl_N6_threonylcarbamoyladenosine' OR cvterm.name = 'N6_hydroxynorvalylcarbamoyladenosine' OR cvterm.name = 'two_methylthio_N6_hydroxynorvalyl_carbamoyladenosine' OR cvterm.name = 'two_prime_O_ribosyladenosine_phosphate' OR cvterm.name = 'N6_N6_dimethyladenosine' OR cvterm.name = 'N6_2_prime_O_dimethyladenosine' OR cvterm.name = 'N6_N6_2_prime_O_trimethyladenosine' OR cvterm.name = 'one_two_prime_O_dimethyladenosine' OR cvterm.name = 'N6_acetyladenosine' OR cvterm.name = 'modified_adenosine';

--- ************************************************
--- *** relation: modified_inosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A modified inosine is an inosine base fe ***
--- *** ature that has been altered.             ***
--- ************************************************
---

CREATE VIEW modified_inosine AS
  SELECT
    feature_id AS modified_inosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'methylinosine' OR cvterm.name = 'one_methylinosine' OR cvterm.name = 'one_two_prime_O_dimethylinosine' OR cvterm.name = 'two_prime_O_methylinosine' OR cvterm.name = 'modified_inosine';

--- ************************************************
--- *** relation: modified_cytidine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** A modified cytidine is a cytidine base f ***
--- *** eature which has been altered.           ***
--- ************************************************
---

CREATE VIEW modified_cytidine AS
  SELECT
    feature_id AS modified_cytidine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_methylcytidine' OR cvterm.name = 'five_methylcytidine' OR cvterm.name = 'two_prime_O_methylcytidine' OR cvterm.name = 'two_thiocytidine' OR cvterm.name = 'N4_acetylcytidine' OR cvterm.name = 'five_formylcytidine' OR cvterm.name = 'five_two_prime_O_dimethylcytidine' OR cvterm.name = 'N4_acetyl_2_prime_O_methylcytidine' OR cvterm.name = 'lysidine' OR cvterm.name = 'N4_methylcytidine' OR cvterm.name = 'N4_2_prime_O_dimethylcytidine' OR cvterm.name = 'five_hydroxymethylcytidine' OR cvterm.name = 'five_formyl_two_prime_O_methylcytidine' OR cvterm.name = 'N4_N4_2_prime_O_trimethylcytidine' OR cvterm.name = 'modified_cytidine';

--- ************************************************
--- *** relation: modified_guanosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW modified_guanosine AS
  SELECT
    feature_id AS modified_guanosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'seven_deazaguanosine' OR cvterm.name = 'one_methylguanosine' OR cvterm.name = 'N2_methylguanosine' OR cvterm.name = 'seven_methylguanosine' OR cvterm.name = 'two_prime_O_methylguanosine' OR cvterm.name = 'N2_N2_dimethylguanosine' OR cvterm.name = 'N2_2_prime_O_dimethylguanosine' OR cvterm.name = 'N2_N2_2_prime_O_trimethylguanosine' OR cvterm.name = 'two_prime_O_ribosylguanosine_phosphate' OR cvterm.name = 'wybutosine' OR cvterm.name = 'peroxywybutosine' OR cvterm.name = 'hydroxywybutosine' OR cvterm.name = 'undermodified_hydroxywybutosine' OR cvterm.name = 'wyosine' OR cvterm.name = 'methylwyosine' OR cvterm.name = 'N2_7_dimethylguanosine' OR cvterm.name = 'N2_N2_7_trimethylguanosine' OR cvterm.name = 'one_two_prime_O_dimethylguanosine' OR cvterm.name = 'four_demethylwyosine' OR cvterm.name = 'isowyosine' OR cvterm.name = 'N2_7_2prirme_O_trimethylguanosine' OR cvterm.name = 'queuosine' OR cvterm.name = 'epoxyqueuosine' OR cvterm.name = 'galactosyl_queuosine' OR cvterm.name = 'mannosyl_queuosine' OR cvterm.name = 'seven_cyano_seven_deazaguanosine' OR cvterm.name = 'seven_aminomethyl_seven_deazaguanosine' OR cvterm.name = 'archaeosine' OR cvterm.name = 'modified_guanosine';

--- ************************************************
--- *** relation: modified_uridine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- ************************************************
---

CREATE VIEW modified_uridine AS
  SELECT
    feature_id AS modified_uridine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'dihydrouridine' OR cvterm.name = 'pseudouridine' OR cvterm.name = 'five_methyluridine' OR cvterm.name = 'two_prime_O_methyluridine' OR cvterm.name = 'five_two_prime_O_dimethyluridine' OR cvterm.name = 'one_methylpseudouridine' OR cvterm.name = 'two_prime_O_methylpseudouridine' OR cvterm.name = 'two_thiouridine' OR cvterm.name = 'four_thiouridine' OR cvterm.name = 'five_methyl_2_thiouridine' OR cvterm.name = 'two_thio_two_prime_O_methyluridine' OR cvterm.name = 'three_three_amino_three_carboxypropyl_uridine' OR cvterm.name = 'five_hydroxyuridine' OR cvterm.name = 'five_methoxyuridine' OR cvterm.name = 'uridine_five_oxyacetic_acid' OR cvterm.name = 'uridine_five_oxyacetic_acid_methyl_ester' OR cvterm.name = 'five_carboxyhydroxymethyl_uridine' OR cvterm.name = 'five_carboxyhydroxymethyl_uridine_methyl_ester' OR cvterm.name = 'five_methoxycarbonylmethyluridine' OR cvterm.name = 'five_methoxycarbonylmethyl_two_prime_O_methyluridine' OR cvterm.name = 'five_methoxycarbonylmethyl_two_thiouridine' OR cvterm.name = 'five_aminomethyl_two_thiouridine' OR cvterm.name = 'five_methylaminomethyluridine' OR cvterm.name = 'five_methylaminomethyl_two_thiouridine' OR cvterm.name = 'five_methylaminomethyl_two_selenouridine' OR cvterm.name = 'five_carbamoylmethyluridine' OR cvterm.name = 'five_carbamoylmethyl_two_prime_O_methyluridine' OR cvterm.name = 'five_carboxymethylaminomethyluridine' OR cvterm.name = 'five_carboxymethylaminomethyl_two_prime_O_methyluridine' OR cvterm.name = 'five_carboxymethylaminomethyl_two_thiouridine' OR cvterm.name = 'three_methyluridine' OR cvterm.name = 'one_methyl_three_three_amino_three_carboxypropyl_pseudouridine' OR cvterm.name = 'five_carboxymethyluridine' OR cvterm.name = 'three_two_prime_O_dimethyluridine' OR cvterm.name = 'five_methyldihydrouridine' OR cvterm.name = 'three_methylpseudouridine' OR cvterm.name = 'five_taurinomethyluridine' OR cvterm.name = 'five_taurinomethyl_two_thiouridine' OR cvterm.name = 'five_isopentenylaminomethyl_uridine' OR cvterm.name = 'five_isopentenylaminomethyl_two_thiouridine' OR cvterm.name = 'five_isopentenylaminomethyl_two_prime_O_methyluridine' OR cvterm.name = 'modified_uridine';

--- ************************************************
--- *** relation: one_methylinosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 1-methylinosine is a modified insosine.  ***
--- ************************************************
---

CREATE VIEW one_methylinosine AS
  SELECT
    feature_id AS one_methylinosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'one_methylinosine';

--- ************************************************
--- *** relation: one_two_prime_o_dimethylinosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 1,2'-O-dimethylinosine is a modified ino ***
--- *** sine.                                    ***
--- ************************************************
---

CREATE VIEW one_two_prime_o_dimethylinosine AS
  SELECT
    feature_id AS one_two_prime_o_dimethylinosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'one_two_prime_O_dimethylinosine';

--- ************************************************
--- *** relation: two_prime_o_methylinosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 2'-O-methylinosine is a modified inosine ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW two_prime_o_methylinosine AS
  SELECT
    feature_id AS two_prime_o_methylinosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'two_prime_O_methylinosine';

--- ************************************************
--- *** relation: three_methylcytidine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 3-methylcytidine is a modified cytidine. ***
--- ************************************************
---

CREATE VIEW three_methylcytidine AS
  SELECT
    feature_id AS three_methylcytidine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'three_methylcytidine';

--- ************************************************
--- *** relation: five_methylcytidine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 5-methylcytidine is a modified cytidine. ***
--- ************************************************
---

CREATE VIEW five_methylcytidine AS
  SELECT
    feature_id AS five_methylcytidine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_methylcytidine';

--- ************************************************
--- *** relation: two_prime_o_methylcytidine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 2'-O-methylcytidine is a modified cytidi ***
--- *** ne.                                      ***
--- ************************************************
---

CREATE VIEW two_prime_o_methylcytidine AS
  SELECT
    feature_id AS two_prime_o_methylcytidine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'two_prime_O_methylcytidine';

--- ************************************************
--- *** relation: two_thiocytidine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 2-thiocytidine is a modified cytidine.   ***
--- ************************************************
---

CREATE VIEW two_thiocytidine AS
  SELECT
    feature_id AS two_thiocytidine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'two_thiocytidine';

--- ************************************************
--- *** relation: n4_acetylcytidine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** N4-acetylcytidine is a modified cytidine ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW n4_acetylcytidine AS
  SELECT
    feature_id AS n4_acetylcytidine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'N4_acetylcytidine';

--- ************************************************
--- *** relation: five_formylcytidine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 5-formylcytidine is a modified cytidine. ***
--- ************************************************
---

CREATE VIEW five_formylcytidine AS
  SELECT
    feature_id AS five_formylcytidine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_formylcytidine';

--- ************************************************
--- *** relation: five_two_prime_o_dimethylcytidine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 5,2'-O-dimethylcytidine is a modified cy ***
--- *** tidine.                                  ***
--- ************************************************
---

CREATE VIEW five_two_prime_o_dimethylcytidine AS
  SELECT
    feature_id AS five_two_prime_o_dimethylcytidine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_two_prime_O_dimethylcytidine';

--- ************************************************
--- *** relation: n4_acetyl_2_prime_o_methylcytidine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** N4-acetyl-2'-O-methylcytidine is a modif ***
--- *** ied cytidine.                            ***
--- ************************************************
---

CREATE VIEW n4_acetyl_2_prime_o_methylcytidine AS
  SELECT
    feature_id AS n4_acetyl_2_prime_o_methylcytidine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'N4_acetyl_2_prime_O_methylcytidine';

--- ************************************************
--- *** relation: lysidine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** Lysidine is a modified cytidine.         ***
--- ************************************************
---

CREATE VIEW lysidine AS
  SELECT
    feature_id AS lysidine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'lysidine';

--- ************************************************
--- *** relation: n4_methylcytidine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** N4-methylcytidine is a modified cytidine ***
--- *** .                                        ***
--- ************************************************
---

CREATE VIEW n4_methylcytidine AS
  SELECT
    feature_id AS n4_methylcytidine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'N4_methylcytidine';

--- ************************************************
--- *** relation: n4_2_prime_o_dimethylcytidine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** N4,2'-O-dimethylcytidine is a modified c ***
--- *** ytidine.                                 ***
--- ************************************************
---

CREATE VIEW n4_2_prime_o_dimethylcytidine AS
  SELECT
    feature_id AS n4_2_prime_o_dimethylcytidine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'N4_2_prime_O_dimethylcytidine';

--- ************************************************
--- *** relation: five_hydroxymethylcytidine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 5-hydroxymethylcytidine is a modified cy ***
--- *** tidine.                                  ***
--- ************************************************
---

CREATE VIEW five_hydroxymethylcytidine AS
  SELECT
    feature_id AS five_hydroxymethylcytidine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_hydroxymethylcytidine';

--- ************************************************
--- *** relation: five_formyl_two_prime_o_methylcytidine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 5-formyl-2'-O-methylcytidine is a modifi ***
--- *** ed cytidine.                             ***
--- ************************************************
---

CREATE VIEW five_formyl_two_prime_o_methylcytidine AS
  SELECT
    feature_id AS five_formyl_two_prime_o_methylcytidine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'five_formyl_two_prime_O_methylcytidine';

--- ************************************************
--- *** relation: n4_n4_2_prime_o_trimethylcytidine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** N4_N4_2_prime_O_trimethylcytidine is a m ***
--- *** odified cytidine.                        ***
--- ************************************************
---

CREATE VIEW n4_n4_2_prime_o_trimethylcytidine AS
  SELECT
    feature_id AS n4_n4_2_prime_o_trimethylcytidine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'N4_N4_2_prime_O_trimethylcytidine';

--- ************************************************
--- *** relation: one_methyladenosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 1_methyladenosine is a modified adenosin ***
--- *** e.                                       ***
--- ************************************************
---

CREATE VIEW one_methyladenosine AS
  SELECT
    feature_id AS one_methyladenosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'one_methyladenosine';

--- ************************************************
--- *** relation: two_methyladenosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 2_methyladenosine is a modified adenosin ***
--- *** e.                                       ***
--- ************************************************
---

CREATE VIEW two_methyladenosine AS
  SELECT
    feature_id AS two_methyladenosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'two_methyladenosine';

--- ************************************************
--- *** relation: n6_methyladenosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** N6_methyladenosine is a modified adenosi ***
--- *** ne.                                      ***
--- ************************************************
---

CREATE VIEW n6_methyladenosine AS
  SELECT
    feature_id AS n6_methyladenosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'N6_methyladenosine';

--- ************************************************
--- *** relation: two_prime_o_methyladenosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 2prime_O_methyladenosine is a modified a ***
--- *** denosine.                                ***
--- ************************************************
---

CREATE VIEW two_prime_o_methyladenosine AS
  SELECT
    feature_id AS two_prime_o_methyladenosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'two_prime_O_methyladenosine';

--- ************************************************
--- *** relation: two_methylthio_n6_methyladenosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 2_methylthio_N6_methyladenosine is a mod ***
--- *** ified adenosine.                         ***
--- ************************************************
---

CREATE VIEW two_methylthio_n6_methyladenosine AS
  SELECT
    feature_id AS two_methylthio_n6_methyladenosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'two_methylthio_N6_methyladenosine';

--- ************************************************
--- *** relation: n6_isopentenyladenosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** N6_isopentenyladenosine is a modified ad ***
--- *** enosine.                                 ***
--- ************************************************
---

CREATE VIEW n6_isopentenyladenosine AS
  SELECT
    feature_id AS n6_isopentenyladenosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'N6_isopentenyladenosine';

--- ************************************************
--- *** relation: two_methylthio_n6_isopentenyladenosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 2_methylthio_N6_isopentenyladenosine is  ***
--- *** a modified adenosine.                    ***
--- ************************************************
---

CREATE VIEW two_methylthio_n6_isopentenyladenosine AS
  SELECT
    feature_id AS two_methylthio_n6_isopentenyladenosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'two_methylthio_N6_isopentenyladenosine';

--- ************************************************
--- *** relation: n6_cis_hydroxyisopentenyl_adenosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** N6_cis_hydroxyisopentenyl_adenosine is a ***
--- ***  modified adenosine.                     ***
--- ************************************************
---

CREATE VIEW n6_cis_hydroxyisopentenyl_adenosine AS
  SELECT
    feature_id AS n6_cis_hydroxyisopentenyl_adenosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'N6_cis_hydroxyisopentenyl_adenosine';

--- ************************************************
--- *** relation: two_methylthio_n6_cis_hydroxyisopentenyl_adenosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 2_methylthio_N6_cis_hydroxyisopentenyl_a ***
--- *** denosine is a modified adenosine.        ***
--- ************************************************
---

CREATE VIEW two_methylthio_n6_cis_hydroxyisopentenyl_adenosine AS
  SELECT
    feature_id AS two_methylthio_n6_cis_hydroxyisopentenyl_adenosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'two_methylthio_N6_cis_hydroxyisopentenyl_adenosine';

--- ************************************************
--- *** relation: n6_glycinylcarbamoyladenosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** N6_glycinylcarbamoyladenosine is a modif ***
--- *** ied adenosine.                           ***
--- ************************************************
---

CREATE VIEW n6_glycinylcarbamoyladenosine AS
  SELECT
    feature_id AS n6_glycinylcarbamoyladenosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'N6_glycinylcarbamoyladenosine';

--- ************************************************
--- *** relation: n6_threonylcarbamoyladenosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** N6_threonylcarbamoyladenosine is a modif ***
--- *** ied adenosine.                           ***
--- ************************************************
---

CREATE VIEW n6_threonylcarbamoyladenosine AS
  SELECT
    feature_id AS n6_threonylcarbamoyladenosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'N6_threonylcarbamoyladenosine';

--- ************************************************
--- *** relation: two_methylthio_n6_threonyl_carbamoyladenosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** 2_methylthio_N6_threonyl_carbamoyladenos ***
--- *** ine is a modified adenosine.             ***
--- ************************************************
---

CREATE VIEW two_methylthio_n6_threonyl_carbamoyladenosine AS
  SELECT
    feature_id AS two_methylthio_n6_threonyl_carbamoyladenosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'two_methylthio_N6_threonyl_carbamoyladenosine';

--- ************************************************
--- *** relation: n6_methyl_n6_threonylcarbamoyladenosine ***
--- *** relation type: VIEW                      ***
--- ***                                          ***
--- *** N6_methyl_N6_threonylcarbamoyladenosine  ***
--- *** is a modified adenosine.                 ***
--- ************************************************
---

CREATE VIEW n6_methyl_n6_threonylcarbamoyladenosine AS
  SELECT
    feature_id AS n6_methyl_n6_threonylcarbamoyladenosine_id,
    feature.*
  FROM
    feature INNER JOIN cvterm ON (feature.type_id = cvterm.cvterm_id)
  WHERE cvterm.name = 'N6_methyl_N6_threonylcarbamoyladenosine';

--- ************************************************
