<?php

namespace Drupal\tripal_chado\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\tripal\TripalField\Attribute\TripalFieldFormatter;
use Drupal\tripal\Plugin\Field\FieldFormatter\DefaultTripalIntegerTypeFormatter;

/**
 * Plugin implementation of default Chado integer type formatter.
 */
#[TripalFieldFormatter(
  id: 'chado_integer_type_formatter',
  label: new TranslatableMarkup('Chado Integer Type Formatter'),
  description: new TranslatableMarkup('The Chado integer type formatter.'),
  field_types: [
    'chado_integer_type_default',
  ],
)]
class ChadoIntegerFormatterDefault extends DefaultTripalIntegerTypeFormatter {

  /**
   * {@inheritDoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    return parent::viewElements($items, $langcode);
  }
}
