INSERT INTO chado.organism (organism_id, abbreviation, genus, species, common_name, infraspecific_name, type_id, comment) VALUES (100, 'TrpDb', 'Tripalus', 'databasica', 'Tripal', 'postgresquelus', 2868, 'A fake organism used for testing purposes.');
INSERT INTO chado.analysis (analysis_id, name, description, program, programversion, algorithm, sourcename, sourceversion, sourceuri, timeexecuted) VALUES (1, 'Gene Annotation for Tripalus Databasica', '50 genes on Chr1 used for testing purposes.', 'annotation', 'n/a', '', '', '', '', '2023-12-04 15:51:11.31749');
INSERT INTO chado.db (db_id, name, description, urlprefix, url) VALUES (1000, 'GFF_source', 'Added automatically by the Tripal GFF loader.', NULL, NULL);
INSERT INTO chado.db (db_id, name, description, urlprefix, url) VALUES (1001, '"TrpDb', 'Added automatically by the Tripal GFF loader.', NULL, NULL);
INSERT INTO chado.dbxref (dbxref_id, db_id, accession, version, description) VALUES (10000, (SELECT db_id FROM chado.db WHERE name='local'), 'longest', '', '');
INSERT INTO chado.cvterm (cvterm_id, cv_id, name, definition, dbxref_id, is_obsolete, is_relationshiptype) VALUES (10000, (SELECT cv_id FROM chado.cv WHERE name='ncit'), 'longest', '', 10000, 0, 0);

INSERT INTO chado.dbxref VALUES (10001, 1000, 'tripalTest', '', NULL);
INSERT INTO chado.dbxref VALUES (10002, 1001, '19656964"', '', NULL);
INSERT INTO chado.dbxref VALUES (10003, 1001, '19655142"', '', NULL);
INSERT INTO chado.dbxref VALUES (10004, 1001, '19655143"', '', NULL);
INSERT INTO chado.dbxref VALUES (10005, 1001, '19649747"', '', NULL);
INSERT INTO chado.dbxref VALUES (10006, 1001, '19652431"', '', NULL);
INSERT INTO chado.dbxref VALUES (10007, 1001, '19652432"', '', NULL);
INSERT INTO chado.dbxref VALUES (10008, 1001, '19652974"', '', NULL);
INSERT INTO chado.dbxref VALUES (10009, 1001, '19652702"', '', NULL);
INSERT INTO chado.dbxref VALUES (10010, 1001, '19652703"', '', NULL);
INSERT INTO chado.dbxref VALUES (10011, 1001, '19652704"', '', NULL);
INSERT INTO chado.dbxref VALUES (10012, 1001, '19652705"', '', NULL);
INSERT INTO chado.dbxref VALUES (10013, 1001, '19652706"', '', NULL);
INSERT INTO chado.dbxref VALUES (10014, 1001, '19650807"', '', NULL);
INSERT INTO chado.dbxref VALUES (10015, 1001, '19650808"', '', NULL);
INSERT INTO chado.dbxref VALUES (10016, 1001, '19655091"', '', NULL);
INSERT INTO chado.dbxref VALUES (10017, 1001, '19651135"', '', NULL);
INSERT INTO chado.dbxref VALUES (10018, 1001, '19651136"', '', NULL);
INSERT INTO chado.dbxref VALUES (10019, 1001, '19650207"', '', NULL);
INSERT INTO chado.dbxref VALUES (10020, 1001, '19657597"', '', NULL);
INSERT INTO chado.dbxref VALUES (10021, 1001, '19657598"', '', NULL);
INSERT INTO chado.dbxref VALUES (10022, 1001, '19657599"', '', NULL);
INSERT INTO chado.dbxref VALUES (10023, 1001, '19657600"', '', NULL);
INSERT INTO chado.dbxref VALUES (10024, 1001, '19658169"', '', NULL);
INSERT INTO chado.dbxref VALUES (10025, 1001, '19658170"', '', NULL);
INSERT INTO chado.dbxref VALUES (10026, 1001, '19653086"', '', NULL);
INSERT INTO chado.dbxref VALUES (10027, 1001, '19655257"', '', NULL);
INSERT INTO chado.dbxref VALUES (10028, 1001, '19653597"', '', NULL);
INSERT INTO chado.dbxref VALUES (10029, 1001, '19653404"', '', NULL);
INSERT INTO chado.dbxref VALUES (10030, 1001, '19653405"', '', NULL);
INSERT INTO chado.dbxref VALUES (10031, 1001, '19653406"', '', NULL);
INSERT INTO chado.dbxref VALUES (10032, 1001, '19649619"', '', NULL);
INSERT INTO chado.dbxref VALUES (10033, 1001, '19654306"', '', NULL);
INSERT INTO chado.dbxref VALUES (10034, 1001, '19654307"', '', NULL);
INSERT INTO chado.dbxref VALUES (10035, 1001, '19649697"', '', NULL);
INSERT INTO chado.dbxref VALUES (10036, 1001, '19649698"', '', NULL);
INSERT INTO chado.dbxref VALUES (10037, 1001, '19654493"', '', NULL);
INSERT INTO chado.dbxref VALUES (10038, 1001, '19654322"', '', NULL);
INSERT INTO chado.dbxref VALUES (10039, 1001, '19649914"', '', NULL);
INSERT INTO chado.dbxref VALUES (10040, 1001, '19656818"', '', NULL);
INSERT INTO chado.dbxref VALUES (10041, 1001, '19652890"', '', NULL);
INSERT INTO chado.dbxref VALUES (10042, 1001, '19656715"', '', NULL);
INSERT INTO chado.dbxref VALUES (10043, 1001, '19650274"', '', NULL);
INSERT INTO chado.dbxref VALUES (10044, 1001, '19650436"', '', NULL);
INSERT INTO chado.dbxref VALUES (10045, 1001, '19650437"', '', NULL);
INSERT INTO chado.dbxref VALUES (10046, 1001, '19650438"', '', NULL);
INSERT INTO chado.dbxref VALUES (10047, 1001, '19649318"', '', NULL);
INSERT INTO chado.dbxref VALUES (10048, 1001, '19651078"', '', NULL);
INSERT INTO chado.dbxref VALUES (10049, 1001, '19651079"', '', NULL);
INSERT INTO chado.dbxref VALUES (10050, 1001, '19651080"', '', NULL);
INSERT INTO chado.dbxref VALUES (10051, 1001, '19651990"', '', NULL);
INSERT INTO chado.dbxref VALUES (10052, 1001, '19651139"', '', NULL);
INSERT INTO chado.dbxref VALUES (10053, 1001, '19651140"', '', NULL);
INSERT INTO chado.dbxref VALUES (10054, 1001, '19650328"', '', NULL);
INSERT INTO chado.dbxref VALUES (10055, 1001, '19651884"', '', NULL);
INSERT INTO chado.dbxref VALUES (10056, 1001, '19649801"', '', NULL);
INSERT INTO chado.dbxref VALUES (10057, 1001, '19653720"', '', NULL);
INSERT INTO chado.dbxref VALUES (10058, 1001, '19653721"', '', NULL);
INSERT INTO chado.dbxref VALUES (10059, 1001, '19650881"', '', NULL);
INSERT INTO chado.dbxref VALUES (10060, 1001, '19650882"', '', NULL);
INSERT INTO chado.dbxref VALUES (10061, 1001, '19651963"', '', NULL);
INSERT INTO chado.dbxref VALUES (10062, 1001, '19653027"', '', NULL);
INSERT INTO chado.dbxref VALUES (10063, 1001, '19654072"', '', NULL);
INSERT INTO chado.dbxref VALUES (10064, 1001, '19653570"', '', NULL);
INSERT INTO chado.dbxref VALUES (10065, 1001, '19653571"', '', NULL);
INSERT INTO chado.dbxref VALUES (10066, 1001, '19657745"', '', NULL);
INSERT INTO chado.dbxref VALUES (10067, 1001, '19657355"', '', NULL);
INSERT INTO chado.dbxref VALUES (10068, 1001, '19656548"', '', NULL);
INSERT INTO chado.dbxref VALUES (10069, 1001, '19649710"', '', NULL);
INSERT INTO chado.dbxref VALUES (10070, 1001, '19652756"', '', NULL);
INSERT INTO chado.dbxref VALUES (10071, 1001, '19652044"', '', NULL);
INSERT INTO chado.dbxref VALUES (10072, 1001, '19652813"', '', NULL);
INSERT INTO chado.dbxref VALUES (10073, 1001, '19657108"', '', NULL);
INSERT INTO chado.dbxref VALUES (10074, 1001, '19658130"', '', NULL);
INSERT INTO chado.dbxref VALUES (10075, 1001, '19658131"', '', NULL);
INSERT INTO chado.dbxref VALUES (10076, 1001, '19649516"', '', NULL);

INSERT INTO chado.feature VALUES (10000, NULL, 100, 'Chr1', 'Chr1', NULL, NULL, 'd41d8cd98f00b204e9800998ecf8427e', (SELECT cvterm_id FROM chado.cvterm WHERE name='chromosome' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:29.533459', '2024-01-05 22:24:29.533459');
INSERT INTO chado.feature VALUES (10001, NULL, 100, 'TrpDb1G01010', 'TrpDb1G01010', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10002, NULL, 100, 'TrpDb1G01010.1', 'TrpDb:19656964', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10003, NULL, 100, 'TrpDb:19656964.five_prime_UTR.1', 'TrpDb:19656964.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10004, NULL, 100, 'TrpDb:19656964.CDS.1', 'TrpDb:19656964.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10005, NULL, 100, 'TrpDb:19656964.CDS.2', 'TrpDb:19656964.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10006, NULL, 100, 'TrpDb:19656964.CDS.3', 'TrpDb:19656964.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10007, NULL, 100, 'TrpDb:19656964.CDS.4', 'TrpDb:19656964.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10008, NULL, 100, 'TrpDb:19656964.CDS.5', 'TrpDb:19656964.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10009, NULL, 100, 'TrpDb:19656964.CDS.6', 'TrpDb:19656964.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10010, NULL, 100, 'TrpDb:19656964.three_prime_UTR.1', 'TrpDb:19656964.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10011, NULL, 100, 'TrpDb1G01020', 'TrpDb1G01020', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10012, NULL, 100, 'TrpDb1G01020.1', 'TrpDb:19655142', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10013, NULL, 100, 'TrpDb:19655142.CDS.1', 'TrpDb:19655142.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10014, NULL, 100, 'TrpDb:19655142.five_prime_UTR.1', 'TrpDb:19655142.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10015, NULL, 100, 'TrpDb:19655142.CDS.2', 'TrpDb:19655142.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10016, NULL, 100, 'TrpDb:19655142.CDS.3', 'TrpDb:19655142.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10017, NULL, 100, 'TrpDb:19655142.CDS.4', 'TrpDb:19655142.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10018, NULL, 100, 'TrpDb:19655142.CDS.5', 'TrpDb:19655142.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10019, NULL, 100, 'TrpDb:19655142.CDS.6', 'TrpDb:19655142.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10020, NULL, 100, 'TrpDb:19655142.CDS.7', 'TrpDb:19655142.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10021, NULL, 100, 'TrpDb:19655142.CDS.8', 'TrpDb:19655142.CDS.8', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10022, NULL, 100, 'TrpDb:19655142.three_prime_UTR.1', 'TrpDb:19655142.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10023, NULL, 100, 'TrpDb:19655142.CDS.9', 'TrpDb:19655142.CDS.9', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10024, NULL, 100, 'TrpDb:19655142.three_prime_UTR.2', 'TrpDb:19655142.three_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10025, NULL, 100, 'TrpDb1G01020.2', 'TrpDb:19655143', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10026, NULL, 100, 'TrpDb:19655143.CDS.1', 'TrpDb:19655143.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10027, NULL, 100, 'TrpDb:19655143.five_prime_UTR.1', 'TrpDb:19655143.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10028, NULL, 100, 'TrpDb:19655143.CDS.2', 'TrpDb:19655143.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10029, NULL, 100, 'TrpDb:19655143.CDS.3', 'TrpDb:19655143.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10030, NULL, 100, 'TrpDb:19655143.CDS.4', 'TrpDb:19655143.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10031, NULL, 100, 'TrpDb:19655143.CDS.5', 'TrpDb:19655143.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10032, NULL, 100, 'TrpDb:19655143.CDS.6', 'TrpDb:19655143.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10033, NULL, 100, 'TrpDb:19655143.three_prime_UTR.1', 'TrpDb:19655143.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10034, NULL, 100, 'TrpDb:19655143.CDS.7', 'TrpDb:19655143.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10035, NULL, 100, 'TrpDb:19655143.three_prime_UTR.2', 'TrpDb:19655143.three_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10036, NULL, 100, 'TrpDb1G01030', 'TrpDb1G01030', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10037, NULL, 100, 'TrpDb1G01030.1', 'TrpDb:19649747', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10038, NULL, 100, 'TrpDb:19649747.five_prime_UTR.1', 'TrpDb:19649747.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10039, NULL, 100, 'TrpDb:19649747.three_prime_UTR.1', 'TrpDb:19649747.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10040, NULL, 100, 'TrpDb:19649747.CDS.1', 'TrpDb:19649747.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10041, NULL, 100, 'TrpDb:19649747.five_prime_UTR.2', 'TrpDb:19649747.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10042, NULL, 100, 'TrpDb1G01040', 'TrpDb1G01040', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10043, NULL, 100, 'TrpDb1G01040.2', 'TrpDb:19652431', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10220, NULL, 100, 'TrpDb1G01100.4', 'TrpDb:19657599', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10044, NULL, 100, 'TrpDb:19652431.five_prime_UTR.1', 'TrpDb:19652431.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10045, NULL, 100, 'TrpDb:19652431.CDS.1', 'TrpDb:19652431.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10046, NULL, 100, 'TrpDb:19652431.CDS.2', 'TrpDb:19652431.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10047, NULL, 100, 'TrpDb:19652431.CDS.3', 'TrpDb:19652431.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10048, NULL, 100, 'TrpDb:19652431.CDS.4', 'TrpDb:19652431.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10049, NULL, 100, 'TrpDb:19652431.CDS.5', 'TrpDb:19652431.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10050, NULL, 100, 'TrpDb:19652431.CDS.6', 'TrpDb:19652431.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10051, NULL, 100, 'TrpDb:19652431.CDS.7', 'TrpDb:19652431.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10052, NULL, 100, 'TrpDb:19652431.CDS.8', 'TrpDb:19652431.CDS.8', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10053, NULL, 100, 'TrpDb:19652431.CDS.9', 'TrpDb:19652431.CDS.9', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10054, NULL, 100, 'TrpDb:19652431.CDS.10', 'TrpDb:19652431.CDS.10', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10055, NULL, 100, 'TrpDb:19652431.CDS.11', 'TrpDb:19652431.CDS.11', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10056, NULL, 100, 'TrpDb:19652431.CDS.12', 'TrpDb:19652431.CDS.12', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10057, NULL, 100, 'TrpDb:19652431.CDS.13', 'TrpDb:19652431.CDS.13', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10058, NULL, 100, 'TrpDb:19652431.CDS.14', 'TrpDb:19652431.CDS.14', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10059, NULL, 100, 'TrpDb:19652431.CDS.15', 'TrpDb:19652431.CDS.15', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10060, NULL, 100, 'TrpDb:19652431.CDS.16', 'TrpDb:19652431.CDS.16', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10061, NULL, 100, 'TrpDb:19652431.CDS.17', 'TrpDb:19652431.CDS.17', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10062, NULL, 100, 'TrpDb:19652431.CDS.18', 'TrpDb:19652431.CDS.18', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10063, NULL, 100, 'TrpDb:19652431.CDS.19', 'TrpDb:19652431.CDS.19', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10064, NULL, 100, 'TrpDb:19652431.CDS.20', 'TrpDb:19652431.CDS.20', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10065, NULL, 100, 'TrpDb:19652431.three_prime_UTR.1', 'TrpDb:19652431.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10066, NULL, 100, 'TrpDb1G01040.1', 'TrpDb:19652432', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10067, NULL, 100, 'TrpDb:19652432.five_prime_UTR.1', 'TrpDb:19652432.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10068, NULL, 100, 'TrpDb:19652432.CDS.1', 'TrpDb:19652432.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10069, NULL, 100, 'TrpDb:19652432.CDS.2', 'TrpDb:19652432.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10070, NULL, 100, 'TrpDb:19652432.CDS.3', 'TrpDb:19652432.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10071, NULL, 100, 'TrpDb:19652432.CDS.4', 'TrpDb:19652432.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10072, NULL, 100, 'TrpDb:19652432.CDS.5', 'TrpDb:19652432.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10073, NULL, 100, 'TrpDb:19652432.CDS.6', 'TrpDb:19652432.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10074, NULL, 100, 'TrpDb:19652432.CDS.7', 'TrpDb:19652432.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10075, NULL, 100, 'TrpDb:19652432.CDS.8', 'TrpDb:19652432.CDS.8', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10076, NULL, 100, 'TrpDb:19652432.CDS.9', 'TrpDb:19652432.CDS.9', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10077, NULL, 100, 'TrpDb:19652432.CDS.10', 'TrpDb:19652432.CDS.10', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10078, NULL, 100, 'TrpDb:19652432.CDS.11', 'TrpDb:19652432.CDS.11', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10079, NULL, 100, 'TrpDb:19652432.CDS.12', 'TrpDb:19652432.CDS.12', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10080, NULL, 100, 'TrpDb:19652432.CDS.13', 'TrpDb:19652432.CDS.13', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10081, NULL, 100, 'TrpDb:19652432.CDS.14', 'TrpDb:19652432.CDS.14', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10082, NULL, 100, 'TrpDb:19652432.CDS.15', 'TrpDb:19652432.CDS.15', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10083, NULL, 100, 'TrpDb:19652432.CDS.16', 'TrpDb:19652432.CDS.16', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10084, NULL, 100, 'TrpDb:19652432.CDS.17', 'TrpDb:19652432.CDS.17', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10085, NULL, 100, 'TrpDb:19652432.CDS.18', 'TrpDb:19652432.CDS.18', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10086, NULL, 100, 'TrpDb:19652432.CDS.19', 'TrpDb:19652432.CDS.19', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10087, NULL, 100, 'TrpDb:19652432.CDS.20', 'TrpDb:19652432.CDS.20', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10353, NULL, 100, 'TrpDb1G01180.1', 'TrpDb:19654493', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10088, NULL, 100, 'TrpDb:19652432.three_prime_UTR.1', 'TrpDb:19652432.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10089, NULL, 100, 'TrpDb1G01050', 'TrpDb1G01050', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10090, NULL, 100, 'TrpDb1G01050.1', 'TrpDb:19652974', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10091, NULL, 100, 'TrpDb:19652974.five_prime_UTR.1', 'TrpDb:19652974.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10092, NULL, 100, 'TrpDb:19652974.CDS.1', 'TrpDb:19652974.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10093, NULL, 100, 'TrpDb:19652974.CDS.2', 'TrpDb:19652974.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10094, NULL, 100, 'TrpDb:19652974.CDS.3', 'TrpDb:19652974.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10095, NULL, 100, 'TrpDb:19652974.CDS.4', 'TrpDb:19652974.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10096, NULL, 100, 'TrpDb:19652974.CDS.5', 'TrpDb:19652974.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10097, NULL, 100, 'TrpDb:19652974.CDS.6', 'TrpDb:19652974.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10098, NULL, 100, 'TrpDb:19652974.CDS.7', 'TrpDb:19652974.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10099, NULL, 100, 'TrpDb:19652974.three_prime_UTR.1', 'TrpDb:19652974.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10100, NULL, 100, 'TrpDb:19652974.CDS.8', 'TrpDb:19652974.CDS.8', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10101, NULL, 100, 'TrpDb1G01060', 'TrpDb1G01060', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10102, NULL, 100, 'TrpDb1G01060.1', 'TrpDb:19652702', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10103, NULL, 100, 'TrpDb:19652702.five_prime_UTR.1', 'TrpDb:19652702.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10104, NULL, 100, 'TrpDb:19652702.five_prime_UTR.2', 'TrpDb:19652702.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10105, NULL, 100, 'TrpDb:19652702.CDS.1', 'TrpDb:19652702.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10106, NULL, 100, 'TrpDb:19652702.five_prime_UTR.3', 'TrpDb:19652702.five_prime_UTR.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10107, NULL, 100, 'TrpDb:19652702.CDS.2', 'TrpDb:19652702.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10108, NULL, 100, 'TrpDb:19652702.CDS.3', 'TrpDb:19652702.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10109, NULL, 100, 'TrpDb:19652702.CDS.4', 'TrpDb:19652702.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10110, NULL, 100, 'TrpDb:19652702.CDS.5', 'TrpDb:19652702.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10111, NULL, 100, 'TrpDb:19652702.CDS.6', 'TrpDb:19652702.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10112, NULL, 100, 'TrpDb:19652702.three_prime_UTR.1', 'TrpDb:19652702.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10113, NULL, 100, 'TrpDb:19652702.CDS.7', 'TrpDb:19652702.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10114, NULL, 100, 'TrpDb1G01060.2', 'TrpDb:19652703', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10115, NULL, 100, 'TrpDb:19652703.five_prime_UTR.1', 'TrpDb:19652703.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10116, NULL, 100, 'TrpDb:19652703.CDS.1', 'TrpDb:19652703.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10117, NULL, 100, 'TrpDb:19652703.five_prime_UTR.2', 'TrpDb:19652703.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10118, NULL, 100, 'TrpDb:19652703.CDS.2', 'TrpDb:19652703.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10119, NULL, 100, 'TrpDb:19652703.CDS.3', 'TrpDb:19652703.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10120, NULL, 100, 'TrpDb:19652703.CDS.4', 'TrpDb:19652703.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10121, NULL, 100, 'TrpDb:19652703.CDS.5', 'TrpDb:19652703.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10122, NULL, 100, 'TrpDb:19652703.CDS.6', 'TrpDb:19652703.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10123, NULL, 100, 'TrpDb:19652703.three_prime_UTR.1', 'TrpDb:19652703.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10124, NULL, 100, 'TrpDb:19652703.CDS.7', 'TrpDb:19652703.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10125, NULL, 100, 'TrpDb1G01060.3', 'TrpDb:19652704', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10126, NULL, 100, 'TrpDb:19652704.five_prime_UTR.1', 'TrpDb:19652704.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10127, NULL, 100, 'TrpDb:19652704.five_prime_UTR.2', 'TrpDb:19652704.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10128, NULL, 100, 'TrpDb:19652704.CDS.1', 'TrpDb:19652704.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10129, NULL, 100, 'TrpDb:19652704.five_prime_UTR.3', 'TrpDb:19652704.five_prime_UTR.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10130, NULL, 100, 'TrpDb:19652704.CDS.2', 'TrpDb:19652704.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10131, NULL, 100, 'TrpDb:19652704.CDS.3', 'TrpDb:19652704.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10132, NULL, 100, 'TrpDb:19652704.CDS.4', 'TrpDb:19652704.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10133, NULL, 100, 'TrpDb:19652704.CDS.5', 'TrpDb:19652704.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10134, NULL, 100, 'TrpDb:19652704.CDS.6', 'TrpDb:19652704.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10135, NULL, 100, 'TrpDb:19652704.three_prime_UTR.1', 'TrpDb:19652704.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10136, NULL, 100, 'TrpDb:19652704.CDS.7', 'TrpDb:19652704.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10137, NULL, 100, 'TrpDb:19652704.three_prime_UTR.2', 'TrpDb:19652704.three_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10138, NULL, 100, 'TrpDb1G01060.4', 'TrpDb:19652705', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10139, NULL, 100, 'TrpDb:19652705.five_prime_UTR.1', 'TrpDb:19652705.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10140, NULL, 100, 'TrpDb:19652705.five_prime_UTR.2', 'TrpDb:19652705.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10141, NULL, 100, 'TrpDb:19652705.CDS.1', 'TrpDb:19652705.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10142, NULL, 100, 'TrpDb:19652705.five_prime_UTR.3', 'TrpDb:19652705.five_prime_UTR.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10143, NULL, 100, 'TrpDb:19652705.CDS.2', 'TrpDb:19652705.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10144, NULL, 100, 'TrpDb:19652705.CDS.3', 'TrpDb:19652705.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10145, NULL, 100, 'TrpDb:19652705.CDS.4', 'TrpDb:19652705.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10146, NULL, 100, 'TrpDb:19652705.CDS.5', 'TrpDb:19652705.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10147, NULL, 100, 'TrpDb:19652705.CDS.6', 'TrpDb:19652705.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10148, NULL, 100, 'TrpDb:19652705.three_prime_UTR.1', 'TrpDb:19652705.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10149, NULL, 100, 'TrpDb:19652705.CDS.7', 'TrpDb:19652705.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10150, NULL, 100, 'TrpDb1G01060.5', 'TrpDb:19652706', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10151, NULL, 100, 'TrpDb:19652706.five_prime_UTR.1', 'TrpDb:19652706.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10152, NULL, 100, 'TrpDb:19652706.five_prime_UTR.2', 'TrpDb:19652706.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10153, NULL, 100, 'TrpDb:19652706.CDS.1', 'TrpDb:19652706.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10154, NULL, 100, 'TrpDb:19652706.five_prime_UTR.3', 'TrpDb:19652706.five_prime_UTR.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10155, NULL, 100, 'TrpDb:19652706.CDS.2', 'TrpDb:19652706.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10156, NULL, 100, 'TrpDb:19652706.CDS.3', 'TrpDb:19652706.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10157, NULL, 100, 'TrpDb:19652706.CDS.4', 'TrpDb:19652706.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10158, NULL, 100, 'TrpDb:19652706.CDS.5', 'TrpDb:19652706.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10159, NULL, 100, 'TrpDb:19652706.CDS.6', 'TrpDb:19652706.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10160, NULL, 100, 'TrpDb:19652706.three_prime_UTR.1', 'TrpDb:19652706.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10161, NULL, 100, 'TrpDb:19652706.CDS.7', 'TrpDb:19652706.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10162, NULL, 100, 'TrpDb1G01070', 'TrpDb1G01070', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10163, NULL, 100, 'TrpDb1G01070.1', 'TrpDb:19650807', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10164, NULL, 100, 'TrpDb:19650807.CDS.1', 'TrpDb:19650807.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10165, NULL, 100, 'TrpDb:19650807.five_prime_UTR.1', 'TrpDb:19650807.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10166, NULL, 100, 'TrpDb:19650807.CDS.2', 'TrpDb:19650807.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10167, NULL, 100, 'TrpDb:19650807.CDS.3', 'TrpDb:19650807.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10168, NULL, 100, 'TrpDb:19650807.CDS.4', 'TrpDb:19650807.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10169, NULL, 100, 'TrpDb:19650807.CDS.5', 'TrpDb:19650807.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10170, NULL, 100, 'TrpDb:19650807.three_prime_UTR.1', 'TrpDb:19650807.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10171, NULL, 100, 'TrpDb:19650807.CDS.6', 'TrpDb:19650807.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10172, NULL, 100, 'TrpDb1G01070.2', 'TrpDb:19650808', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10173, NULL, 100, 'TrpDb:19650808.CDS.1', 'TrpDb:19650808.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10174, NULL, 100, 'TrpDb:19650808.five_prime_UTR.1', 'TrpDb:19650808.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10175, NULL, 100, 'TrpDb:19650808.CDS.2', 'TrpDb:19650808.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10176, NULL, 100, 'TrpDb:19650808.CDS.3', 'TrpDb:19650808.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10177, NULL, 100, 'TrpDb:19650808.CDS.4', 'TrpDb:19650808.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10178, NULL, 100, 'TrpDb:19650808.three_prime_UTR.1', 'TrpDb:19650808.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10179, NULL, 100, 'TrpDb:19650808.CDS.5', 'TrpDb:19650808.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10180, NULL, 100, 'TrpDb1G01073', 'TrpDb1G01073', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10181, NULL, 100, 'TrpDb1G01073.1', 'TrpDb:19655091', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10182, NULL, 100, 'TrpDb:19655091.CDS.1', 'TrpDb:19655091.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10183, NULL, 100, 'TrpDb1G01080', 'TrpDb1G01080', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10184, NULL, 100, 'TrpDb1G01080.2', 'TrpDb:19651135', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10185, NULL, 100, 'TrpDb:19651135.CDS.1', 'TrpDb:19651135.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10186, NULL, 100, 'TrpDb:19651135.five_prime_UTR.1', 'TrpDb:19651135.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10187, NULL, 100, 'TrpDb:19651135.CDS.2', 'TrpDb:19651135.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10188, NULL, 100, 'TrpDb:19651135.CDS.3', 'TrpDb:19651135.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10189, NULL, 100, 'TrpDb:19651135.three_prime_UTR.1', 'TrpDb:19651135.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10190, NULL, 100, 'TrpDb:19651135.CDS.4', 'TrpDb:19651135.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10191, NULL, 100, 'TrpDb1G01080.1', 'TrpDb:19651136', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10192, NULL, 100, 'TrpDb:19651136.CDS.1', 'TrpDb:19651136.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10193, NULL, 100, 'TrpDb:19651136.five_prime_UTR.1', 'TrpDb:19651136.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10194, NULL, 100, 'TrpDb:19651136.CDS.2', 'TrpDb:19651136.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10195, NULL, 100, 'TrpDb:19651136.CDS.3', 'TrpDb:19651136.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10196, NULL, 100, 'TrpDb:19651136.three_prime_UTR.1', 'TrpDb:19651136.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10197, NULL, 100, 'TrpDb:19651136.CDS.4', 'TrpDb:19651136.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10198, NULL, 100, 'TrpDb1G01090', 'TrpDb1G01090', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10199, NULL, 100, 'TrpDb1G01090.1', 'TrpDb:19650207', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10200, NULL, 100, 'TrpDb:19650207.CDS.1', 'TrpDb:19650207.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10201, NULL, 100, 'TrpDb:19650207.five_prime_UTR.1', 'TrpDb:19650207.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10202, NULL, 100, 'TrpDb:19650207.CDS.2', 'TrpDb:19650207.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10203, NULL, 100, 'TrpDb:19650207.three_prime_UTR.1', 'TrpDb:19650207.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10204, NULL, 100, 'TrpDb:19650207.CDS.3', 'TrpDb:19650207.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10205, NULL, 100, 'TrpDb1G01100', 'TrpDb1G01100', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10206, NULL, 100, 'TrpDb1G01100.1', 'TrpDb:19657597', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10207, NULL, 100, 'TrpDb:19657597.five_prime_UTR.1', 'TrpDb:19657597.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10208, NULL, 100, 'TrpDb:19657597.CDS.1', 'TrpDb:19657597.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10209, NULL, 100, 'TrpDb:19657597.five_prime_UTR.2', 'TrpDb:19657597.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10210, NULL, 100, 'TrpDb:19657597.CDS.2', 'TrpDb:19657597.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10211, NULL, 100, 'TrpDb:19657597.three_prime_UTR.1', 'TrpDb:19657597.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10212, NULL, 100, 'TrpDb:19657597.CDS.3', 'TrpDb:19657597.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10213, NULL, 100, 'TrpDb1G01100.2', 'TrpDb:19657598', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10214, NULL, 100, 'TrpDb:19657598.five_prime_UTR.1', 'TrpDb:19657598.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10215, NULL, 100, 'TrpDb:19657598.CDS.1', 'TrpDb:19657598.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10216, NULL, 100, 'TrpDb:19657598.five_prime_UTR.2', 'TrpDb:19657598.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10217, NULL, 100, 'TrpDb:19657598.CDS.2', 'TrpDb:19657598.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10218, NULL, 100, 'TrpDb:19657598.three_prime_UTR.1', 'TrpDb:19657598.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10219, NULL, 100, 'TrpDb:19657598.CDS.3', 'TrpDb:19657598.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10221, NULL, 100, 'TrpDb:19657599.five_prime_UTR.1', 'TrpDb:19657599.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10222, NULL, 100, 'TrpDb:19657599.CDS.1', 'TrpDb:19657599.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10223, NULL, 100, 'TrpDb:19657599.five_prime_UTR.2', 'TrpDb:19657599.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10224, NULL, 100, 'TrpDb:19657599.CDS.2', 'TrpDb:19657599.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10225, NULL, 100, 'TrpDb:19657599.three_prime_UTR.1', 'TrpDb:19657599.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10226, NULL, 100, 'TrpDb:19657599.CDS.3', 'TrpDb:19657599.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10227, NULL, 100, 'TrpDb1G01100.3', 'TrpDb:19657600', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10228, NULL, 100, 'TrpDb:19657600.five_prime_UTR.1', 'TrpDb:19657600.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10229, NULL, 100, 'TrpDb:19657600.CDS.1', 'TrpDb:19657600.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10230, NULL, 100, 'TrpDb:19657600.five_prime_UTR.2', 'TrpDb:19657600.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10231, NULL, 100, 'TrpDb:19657600.CDS.2', 'TrpDb:19657600.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10232, NULL, 100, 'TrpDb:19657600.CDS.3', 'TrpDb:19657600.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10233, NULL, 100, 'TrpDb:19657600.three_prime_UTR.1', 'TrpDb:19657600.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10234, NULL, 100, 'TrpDb:19657600.CDS.4', 'TrpDb:19657600.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10235, NULL, 100, 'TrpDb1G01110', 'TrpDb1G01110', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10236, NULL, 100, 'TrpDb1G01110.2', 'TrpDb:19658169', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10237, NULL, 100, 'TrpDb:19658169.CDS.1', 'TrpDb:19658169.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10238, NULL, 100, 'TrpDb:19658169.CDS.2', 'TrpDb:19658169.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10239, NULL, 100, 'TrpDb:19658169.CDS.3', 'TrpDb:19658169.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10240, NULL, 100, 'TrpDb:19658169.CDS.4', 'TrpDb:19658169.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10241, NULL, 100, 'TrpDb:19658169.CDS.5', 'TrpDb:19658169.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10242, NULL, 100, 'TrpDb:19658169.three_prime_UTR.1', 'TrpDb:19658169.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10243, NULL, 100, 'TrpDb1G01110.1', 'TrpDb:19658170', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10244, NULL, 100, 'TrpDb:19658170.five_prime_UTR.1', 'TrpDb:19658170.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10245, NULL, 100, 'TrpDb:19658170.CDS.1', 'TrpDb:19658170.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10246, NULL, 100, 'TrpDb:19658170.CDS.2', 'TrpDb:19658170.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10247, NULL, 100, 'TrpDb:19658170.CDS.3', 'TrpDb:19658170.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10248, NULL, 100, 'TrpDb:19658170.three_prime_UTR.1', 'TrpDb:19658170.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10249, NULL, 100, 'TrpDb1G01115', 'TrpDb1G01115', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10250, NULL, 100, 'TrpDb1G01115.1', 'TrpDb:19653086', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10251, NULL, 100, 'TrpDb:19653086.CDS.1', 'TrpDb:19653086.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10252, NULL, 100, 'TrpDb1G01120', 'TrpDb1G01120', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10253, NULL, 100, 'TrpDb1G01120.1', 'TrpDb:19655257', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10254, NULL, 100, 'TrpDb:19655257.three_prime_UTR.1', 'TrpDb:19655257.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10255, NULL, 100, 'TrpDb:19655257.CDS.1', 'TrpDb:19655257.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10256, NULL, 100, 'TrpDb:19655257.five_prime_UTR.1', 'TrpDb:19655257.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10257, NULL, 100, 'TrpDb1G01130', 'TrpDb1G01130', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10258, NULL, 100, 'TrpDb1G01130.1', 'TrpDb:19653597', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10259, NULL, 100, 'TrpDb:19653597.CDS.1', 'TrpDb:19653597.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10260, NULL, 100, 'TrpDb:19653597.CDS.2', 'TrpDb:19653597.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10261, NULL, 100, 'TrpDb:19653597.CDS.3', 'TrpDb:19653597.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10262, NULL, 100, 'TrpDb1G01140', 'TrpDb1G01140', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10263, NULL, 100, 'TrpDb1G01140.3', 'TrpDb:19653404', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10264, NULL, 100, 'TrpDb:19653404.CDS.1', 'TrpDb:19653404.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10441, NULL, 100, 'TrpDb1G01290.1', 'TrpDb:19651139', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10265, NULL, 100, 'TrpDb:19653404.five_prime_UTR.1', 'TrpDb:19653404.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10266, NULL, 100, 'TrpDb:19653404.CDS.2', 'TrpDb:19653404.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10267, NULL, 100, 'TrpDb:19653404.CDS.3', 'TrpDb:19653404.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10268, NULL, 100, 'TrpDb:19653404.CDS.4', 'TrpDb:19653404.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10269, NULL, 100, 'TrpDb:19653404.CDS.5', 'TrpDb:19653404.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10270, NULL, 100, 'TrpDb:19653404.CDS.6', 'TrpDb:19653404.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10271, NULL, 100, 'TrpDb:19653404.CDS.7', 'TrpDb:19653404.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10272, NULL, 100, 'TrpDb:19653404.CDS.8', 'TrpDb:19653404.CDS.8', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10273, NULL, 100, 'TrpDb:19653404.CDS.9', 'TrpDb:19653404.CDS.9', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10274, NULL, 100, 'TrpDb:19653404.CDS.10', 'TrpDb:19653404.CDS.10', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10275, NULL, 100, 'TrpDb:19653404.CDS.11', 'TrpDb:19653404.CDS.11', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10276, NULL, 100, 'TrpDb:19653404.CDS.12', 'TrpDb:19653404.CDS.12', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10277, NULL, 100, 'TrpDb:19653404.CDS.13', 'TrpDb:19653404.CDS.13', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10278, NULL, 100, 'TrpDb:19653404.three_prime_UTR.1', 'TrpDb:19653404.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10279, NULL, 100, 'TrpDb:19653404.CDS.14', 'TrpDb:19653404.CDS.14', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10280, NULL, 100, 'TrpDb1G01140.2', 'TrpDb:19653405', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10281, NULL, 100, 'TrpDb:19653405.CDS.1', 'TrpDb:19653405.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10282, NULL, 100, 'TrpDb:19653405.five_prime_UTR.1', 'TrpDb:19653405.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10283, NULL, 100, 'TrpDb:19653405.CDS.2', 'TrpDb:19653405.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10284, NULL, 100, 'TrpDb:19653405.CDS.3', 'TrpDb:19653405.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10285, NULL, 100, 'TrpDb:19653405.CDS.4', 'TrpDb:19653405.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10286, NULL, 100, 'TrpDb:19653405.CDS.5', 'TrpDb:19653405.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10287, NULL, 100, 'TrpDb:19653405.CDS.6', 'TrpDb:19653405.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10288, NULL, 100, 'TrpDb:19653405.CDS.7', 'TrpDb:19653405.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10289, NULL, 100, 'TrpDb:19653405.CDS.8', 'TrpDb:19653405.CDS.8', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10290, NULL, 100, 'TrpDb:19653405.CDS.9', 'TrpDb:19653405.CDS.9', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10291, NULL, 100, 'TrpDb:19653405.CDS.10', 'TrpDb:19653405.CDS.10', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10292, NULL, 100, 'TrpDb:19653405.CDS.11', 'TrpDb:19653405.CDS.11', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10293, NULL, 100, 'TrpDb:19653405.CDS.12', 'TrpDb:19653405.CDS.12', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10294, NULL, 100, 'TrpDb:19653405.CDS.13', 'TrpDb:19653405.CDS.13', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10295, NULL, 100, 'TrpDb:19653405.three_prime_UTR.1', 'TrpDb:19653405.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10296, NULL, 100, 'TrpDb:19653405.CDS.14', 'TrpDb:19653405.CDS.14', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10297, NULL, 100, 'TrpDb1G01140.1', 'TrpDb:19653406', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10298, NULL, 100, 'TrpDb:19653406.CDS.1', 'TrpDb:19653406.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10299, NULL, 100, 'TrpDb:19653406.five_prime_UTR.1', 'TrpDb:19653406.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10300, NULL, 100, 'TrpDb:19653406.CDS.2', 'TrpDb:19653406.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10301, NULL, 100, 'TrpDb:19653406.CDS.3', 'TrpDb:19653406.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10302, NULL, 100, 'TrpDb:19653406.CDS.4', 'TrpDb:19653406.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10303, NULL, 100, 'TrpDb:19653406.CDS.5', 'TrpDb:19653406.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10304, NULL, 100, 'TrpDb:19653406.CDS.6', 'TrpDb:19653406.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10305, NULL, 100, 'TrpDb:19653406.CDS.7', 'TrpDb:19653406.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10306, NULL, 100, 'TrpDb:19653406.CDS.8', 'TrpDb:19653406.CDS.8', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10307, NULL, 100, 'TrpDb:19653406.CDS.9', 'TrpDb:19653406.CDS.9', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10308, NULL, 100, 'TrpDb:19653406.CDS.10', 'TrpDb:19653406.CDS.10', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10309, NULL, 100, 'TrpDb:19653406.CDS.11', 'TrpDb:19653406.CDS.11', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10310, NULL, 100, 'TrpDb:19653406.CDS.12', 'TrpDb:19653406.CDS.12', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10311, NULL, 100, 'TrpDb:19653406.CDS.13', 'TrpDb:19653406.CDS.13', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10312, NULL, 100, 'TrpDb:19653406.three_prime_UTR.1', 'TrpDb:19653406.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10313, NULL, 100, 'TrpDb:19653406.CDS.14', 'TrpDb:19653406.CDS.14', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10314, NULL, 100, 'TrpDb1G01150', 'TrpDb1G01150', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10315, NULL, 100, 'TrpDb1G01150.1', 'TrpDb:19649619', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10316, NULL, 100, 'TrpDb:19649619.CDS.1', 'TrpDb:19649619.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10317, NULL, 100, 'TrpDb:19649619.five_prime_UTR.1', 'TrpDb:19649619.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10318, NULL, 100, 'TrpDb:19649619.CDS.2', 'TrpDb:19649619.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10319, NULL, 100, 'TrpDb:19649619.CDS.3', 'TrpDb:19649619.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10320, NULL, 100, 'TrpDb:19649619.CDS.4', 'TrpDb:19649619.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10321, NULL, 100, 'TrpDb1G01160', 'TrpDb1G01160', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10322, NULL, 100, 'TrpDb1G01160.2', 'TrpDb:19654306', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10323, NULL, 100, 'TrpDb:19654306.five_prime_UTR.1', 'TrpDb:19654306.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10324, NULL, 100, 'TrpDb:19654306.CDS.1', 'TrpDb:19654306.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10325, NULL, 100, 'TrpDb:19654306.CDS.2', 'TrpDb:19654306.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10326, NULL, 100, 'TrpDb:19654306.CDS.3', 'TrpDb:19654306.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10327, NULL, 100, 'TrpDb:19654306.CDS.4', 'TrpDb:19654306.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10328, NULL, 100, 'TrpDb:19654306.CDS.5', 'TrpDb:19654306.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10329, NULL, 100, 'TrpDb:19654306.CDS.6', 'TrpDb:19654306.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10330, NULL, 100, 'TrpDb:19654306.three_prime_UTR.1', 'TrpDb:19654306.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10331, NULL, 100, 'TrpDb1G01160.1', 'TrpDb:19654307', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10332, NULL, 100, 'TrpDb:19654307.five_prime_UTR.1', 'TrpDb:19654307.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10333, NULL, 100, 'TrpDb:19654307.CDS.1', 'TrpDb:19654307.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10334, NULL, 100, 'TrpDb:19654307.CDS.2', 'TrpDb:19654307.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10335, NULL, 100, 'TrpDb:19654307.CDS.3', 'TrpDb:19654307.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10336, NULL, 100, 'TrpDb:19654307.CDS.4', 'TrpDb:19654307.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10337, NULL, 100, 'TrpDb:19654307.CDS.5', 'TrpDb:19654307.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10338, NULL, 100, 'TrpDb:19654307.three_prime_UTR.1', 'TrpDb:19654307.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10339, NULL, 100, 'TrpDb1G01170', 'TrpDb1G01170', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10340, NULL, 100, 'TrpDb1G01170.1', 'TrpDb:19649697', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10341, NULL, 100, 'TrpDb:19649697.five_prime_UTR.1', 'TrpDb:19649697.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10342, NULL, 100, 'TrpDb:19649697.CDS.1', 'TrpDb:19649697.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10343, NULL, 100, 'TrpDb:19649697.five_prime_UTR.2', 'TrpDb:19649697.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10344, NULL, 100, 'TrpDb:19649697.three_prime_UTR.1', 'TrpDb:19649697.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10345, NULL, 100, 'TrpDb:19649697.CDS.2', 'TrpDb:19649697.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10346, NULL, 100, 'TrpDb1G01170.2', 'TrpDb:19649698', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10347, NULL, 100, 'TrpDb:19649698.five_prime_UTR.1', 'TrpDb:19649698.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10348, NULL, 100, 'TrpDb:19649698.CDS.1', 'TrpDb:19649698.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10349, NULL, 100, 'TrpDb:19649698.five_prime_UTR.2', 'TrpDb:19649698.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10350, NULL, 100, 'TrpDb:19649698.three_prime_UTR.1', 'TrpDb:19649698.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10351, NULL, 100, 'TrpDb:19649698.CDS.2', 'TrpDb:19649698.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10352, NULL, 100, 'TrpDb1G01180', 'TrpDb1G01180', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10354, NULL, 100, 'TrpDb:19654493.five_prime_UTR.1', 'TrpDb:19654493.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10355, NULL, 100, 'TrpDb:19654493.CDS.1', 'TrpDb:19654493.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10356, NULL, 100, 'TrpDb:19654493.three_prime_UTR.1', 'TrpDb:19654493.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10357, NULL, 100, 'TrpDb1G01190', 'TrpDb1G01190', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10358, NULL, 100, 'TrpDb1G01190.1', 'TrpDb:19654322', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10359, NULL, 100, 'TrpDb:19654322.CDS.1', 'TrpDb:19654322.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10360, NULL, 100, 'TrpDb:19654322.CDS.2', 'TrpDb:19654322.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10361, NULL, 100, 'TrpDb1G01200', 'TrpDb1G01200', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10362, NULL, 100, 'TrpDb1G01200.1', 'TrpDb:19649914', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10363, NULL, 100, 'TrpDb:19649914.CDS.1', 'TrpDb:19649914.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10364, NULL, 100, 'TrpDb:19649914.five_prime_UTR.1', 'TrpDb:19649914.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10365, NULL, 100, 'TrpDb:19649914.three_prime_UTR.1', 'TrpDb:19649914.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10366, NULL, 100, 'TrpDb:19649914.CDS.2', 'TrpDb:19649914.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10367, NULL, 100, 'TrpDb1G01210', 'TrpDb1G01210', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10368, NULL, 100, 'TrpDb1G01210.1', 'TrpDb:19656818', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10369, NULL, 100, 'TrpDb:19656818.five_prime_UTR.1', 'TrpDb:19656818.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10370, NULL, 100, 'TrpDb:19656818.CDS.1', 'TrpDb:19656818.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10371, NULL, 100, 'TrpDb:19656818.CDS.2', 'TrpDb:19656818.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10372, NULL, 100, 'TrpDb:19656818.CDS.3', 'TrpDb:19656818.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10373, NULL, 100, 'TrpDb:19656818.three_prime_UTR.1', 'TrpDb:19656818.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10374, NULL, 100, 'TrpDb1G01220', 'TrpDb1G01220', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10375, NULL, 100, 'TrpDb1G01220.1', 'TrpDb:19652890', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10376, NULL, 100, 'TrpDb:19652890.five_prime_UTR.1', 'TrpDb:19652890.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10377, NULL, 100, 'TrpDb:19652890.five_prime_UTR.2', 'TrpDb:19652890.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10378, NULL, 100, 'TrpDb:19652890.CDS.1', 'TrpDb:19652890.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10379, NULL, 100, 'TrpDb:19652890.CDS.2', 'TrpDb:19652890.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10380, NULL, 100, 'TrpDb:19652890.CDS.3', 'TrpDb:19652890.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10381, NULL, 100, 'TrpDb:19652890.CDS.4', 'TrpDb:19652890.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10382, NULL, 100, 'TrpDb:19652890.CDS.5', 'TrpDb:19652890.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10383, NULL, 100, 'TrpDb:19652890.CDS.6', 'TrpDb:19652890.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10384, NULL, 100, 'TrpDb:19652890.CDS.7', 'TrpDb:19652890.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10385, NULL, 100, 'TrpDb:19652890.three_prime_UTR.1', 'TrpDb:19652890.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10386, NULL, 100, 'TrpDb1G01225', 'TrpDb1G01225', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10387, NULL, 100, 'TrpDb1G01225.1', 'TrpDb:19656715', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10388, NULL, 100, 'TrpDb:19656715.five_prime_UTR.1', 'TrpDb:19656715.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10389, NULL, 100, 'TrpDb:19656715.CDS.1', 'TrpDb:19656715.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10390, NULL, 100, 'TrpDb:19656715.CDS.2', 'TrpDb:19656715.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10391, NULL, 100, 'TrpDb:19656715.three_prime_UTR.1', 'TrpDb:19656715.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10392, NULL, 100, 'TrpDb1G01230', 'TrpDb1G01230', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10393, NULL, 100, 'TrpDb1G01230.1', 'TrpDb:19650274', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10394, NULL, 100, 'TrpDb:19650274.five_prime_UTR.1', 'TrpDb:19650274.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10395, NULL, 100, 'TrpDb:19650274.CDS.1', 'TrpDb:19650274.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10396, NULL, 100, 'TrpDb:19650274.CDS.2', 'TrpDb:19650274.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10397, NULL, 100, 'TrpDb:19650274.CDS.3', 'TrpDb:19650274.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10398, NULL, 100, 'TrpDb:19650274.three_prime_UTR.1', 'TrpDb:19650274.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10399, NULL, 100, 'TrpDb1G01240', 'TrpDb1G01240', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10400, NULL, 100, 'TrpDb1G01240.1', 'TrpDb:19650436', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10401, NULL, 100, 'TrpDb:19650436.five_prime_UTR.1', 'TrpDb:19650436.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10402, NULL, 100, 'TrpDb:19650436.five_prime_UTR.2', 'TrpDb:19650436.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10403, NULL, 100, 'TrpDb:19650436.CDS.1', 'TrpDb:19650436.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10404, NULL, 100, 'TrpDb:19650436.three_prime_UTR.1', 'TrpDb:19650436.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10405, NULL, 100, 'TrpDb1G01240.2', 'TrpDb:19650437', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10406, NULL, 100, 'TrpDb:19650437.five_prime_UTR.1', 'TrpDb:19650437.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10407, NULL, 100, 'TrpDb:19650437.five_prime_UTR.2', 'TrpDb:19650437.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10408, NULL, 100, 'TrpDb:19650437.CDS.1', 'TrpDb:19650437.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10409, NULL, 100, 'TrpDb:19650437.three_prime_UTR.1', 'TrpDb:19650437.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10410, NULL, 100, 'TrpDb1G01240.3', 'TrpDb:19650438', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10411, NULL, 100, 'TrpDb:19650438.five_prime_UTR.1', 'TrpDb:19650438.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10412, NULL, 100, 'TrpDb:19650438.CDS.1', 'TrpDb:19650438.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10413, NULL, 100, 'TrpDb:19650438.three_prime_UTR.1', 'TrpDb:19650438.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10414, NULL, 100, 'TrpDb1G01250', 'TrpDb1G01250', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10415, NULL, 100, 'TrpDb1G01250.1', 'TrpDb:19649318', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10416, NULL, 100, 'TrpDb:19649318.three_prime_UTR.1', 'TrpDb:19649318.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10417, NULL, 100, 'TrpDb:19649318.CDS.1', 'TrpDb:19649318.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10418, NULL, 100, 'TrpDb:19649318.five_prime_UTR.1', 'TrpDb:19649318.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10419, NULL, 100, 'TrpDb1G01260', 'TrpDb1G01260', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10420, NULL, 100, 'TrpDb1G01260.1', 'TrpDb:19651078', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10421, NULL, 100, 'TrpDb:19651078.five_prime_UTR.1', 'TrpDb:19651078.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10422, NULL, 100, 'TrpDb:19651078.CDS.1', 'TrpDb:19651078.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10423, NULL, 100, 'TrpDb:19651078.three_prime_UTR.1', 'TrpDb:19651078.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10424, NULL, 100, 'TrpDb1G01260.2', 'TrpDb:19651079', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10425, NULL, 100, 'TrpDb:19651079.five_prime_UTR.1', 'TrpDb:19651079.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10426, NULL, 100, 'TrpDb:19651079.five_prime_UTR.2', 'TrpDb:19651079.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10427, NULL, 100, 'TrpDb:19651079.CDS.1', 'TrpDb:19651079.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10428, NULL, 100, 'TrpDb:19651079.three_prime_UTR.1', 'TrpDb:19651079.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10429, NULL, 100, 'TrpDb1G01260.3', 'TrpDb:19651080', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10430, NULL, 100, 'TrpDb:19651080.five_prime_UTR.1', 'TrpDb:19651080.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10431, NULL, 100, 'TrpDb:19651080.five_prime_UTR.2', 'TrpDb:19651080.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10432, NULL, 100, 'TrpDb:19651080.CDS.1', 'TrpDb:19651080.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10433, NULL, 100, 'TrpDb:19651080.three_prime_UTR.1', 'TrpDb:19651080.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10434, NULL, 100, 'TrpDb1G01280', 'TrpDb1G01280', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10435, NULL, 100, 'TrpDb1G01280.1', 'TrpDb:19651990', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10436, NULL, 100, 'TrpDb:19651990.five_prime_UTR.1', 'TrpDb:19651990.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10437, NULL, 100, 'TrpDb:19651990.CDS.1', 'TrpDb:19651990.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10438, NULL, 100, 'TrpDb:19651990.CDS.2', 'TrpDb:19651990.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10439, NULL, 100, 'TrpDb:19651990.three_prime_UTR.1', 'TrpDb:19651990.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10440, NULL, 100, 'TrpDb1G01290', 'TrpDb1G01290', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10442, NULL, 100, 'TrpDb:19651139.five_prime_UTR.1', 'TrpDb:19651139.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10443, NULL, 100, 'TrpDb:19651139.CDS.1', 'TrpDb:19651139.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10444, NULL, 100, 'TrpDb:19651139.CDS.2', 'TrpDb:19651139.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10445, NULL, 100, 'TrpDb:19651139.three_prime_UTR.1', 'TrpDb:19651139.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10446, NULL, 100, 'TrpDb1G01290.2', 'TrpDb:19651140', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10447, NULL, 100, 'TrpDb:19651140.five_prime_UTR.1', 'TrpDb:19651140.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10448, NULL, 100, 'TrpDb:19651140.CDS.1', 'TrpDb:19651140.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10449, NULL, 100, 'TrpDb:19651140.CDS.2', 'TrpDb:19651140.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10450, NULL, 100, 'TrpDb:19651140.three_prime_UTR.1', 'TrpDb:19651140.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10451, NULL, 100, 'TrpDb:19651140.three_prime_UTR.2', 'TrpDb:19651140.three_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10452, NULL, 100, 'TrpDb1G01300', 'TrpDb1G01300', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10453, NULL, 100, 'TrpDb1G01300.1', 'TrpDb:19650328', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10454, NULL, 100, 'TrpDb:19650328.five_prime_UTR.1', 'TrpDb:19650328.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10455, NULL, 100, 'TrpDb:19650328.CDS.1', 'TrpDb:19650328.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10456, NULL, 100, 'TrpDb:19650328.three_prime_UTR.1', 'TrpDb:19650328.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10457, NULL, 100, 'TrpDb1G01305', 'TrpDb1G01305', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10458, NULL, 100, 'TrpDb1G01305.1', 'TrpDb:19651884', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10459, NULL, 100, 'TrpDb:19651884.five_prime_UTR.1', 'TrpDb:19651884.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10460, NULL, 100, 'TrpDb:19651884.CDS.1', 'TrpDb:19651884.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10461, NULL, 100, 'TrpDb:19651884.three_prime_UTR.1', 'TrpDb:19651884.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10462, NULL, 100, 'TrpDb1G01310', 'TrpDb1G01310', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10463, NULL, 100, 'TrpDb1G01310.1', 'TrpDb:19649801', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10464, NULL, 100, 'TrpDb:19649801.five_prime_UTR.1', 'TrpDb:19649801.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10465, NULL, 100, 'TrpDb:19649801.CDS.1', 'TrpDb:19649801.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10466, NULL, 100, 'TrpDb:19649801.three_prime_UTR.1', 'TrpDb:19649801.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10467, NULL, 100, 'TrpDb1G01320', 'TrpDb1G01320', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10468, NULL, 100, 'TrpDb1G01320.1', 'TrpDb:19653720', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10469, NULL, 100, 'TrpDb:19653720.five_prime_UTR.1', 'TrpDb:19653720.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10470, NULL, 100, 'TrpDb:19653720.CDS.1', 'TrpDb:19653720.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10471, NULL, 100, 'TrpDb:19653720.five_prime_UTR.2', 'TrpDb:19653720.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10472, NULL, 100, 'TrpDb:19653720.CDS.2', 'TrpDb:19653720.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10473, NULL, 100, 'TrpDb:19653720.CDS.3', 'TrpDb:19653720.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10474, NULL, 100, 'TrpDb:19653720.CDS.4', 'TrpDb:19653720.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10475, NULL, 100, 'TrpDb:19653720.CDS.5', 'TrpDb:19653720.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10476, NULL, 100, 'TrpDb:19653720.CDS.6', 'TrpDb:19653720.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10477, NULL, 100, 'TrpDb:19653720.CDS.7', 'TrpDb:19653720.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10478, NULL, 100, 'TrpDb:19653720.CDS.8', 'TrpDb:19653720.CDS.8', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10479, NULL, 100, 'TrpDb:19653720.CDS.9', 'TrpDb:19653720.CDS.9', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10480, NULL, 100, 'TrpDb:19653720.CDS.10', 'TrpDb:19653720.CDS.10', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10481, NULL, 100, 'TrpDb:19653720.CDS.11', 'TrpDb:19653720.CDS.11', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10482, NULL, 100, 'TrpDb:19653720.CDS.12', 'TrpDb:19653720.CDS.12', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10483, NULL, 100, 'TrpDb:19653720.CDS.13', 'TrpDb:19653720.CDS.13', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10484, NULL, 100, 'TrpDb:19653720.CDS.14', 'TrpDb:19653720.CDS.14', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10485, NULL, 100, 'TrpDb:19653720.CDS.15', 'TrpDb:19653720.CDS.15', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10486, NULL, 100, 'TrpDb:19653720.CDS.16', 'TrpDb:19653720.CDS.16', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10487, NULL, 100, 'TrpDb:19653720.CDS.17', 'TrpDb:19653720.CDS.17', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10488, NULL, 100, 'TrpDb:19653720.CDS.18', 'TrpDb:19653720.CDS.18', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10489, NULL, 100, 'TrpDb:19653720.CDS.19', 'TrpDb:19653720.CDS.19', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10490, NULL, 100, 'TrpDb:19653720.CDS.20', 'TrpDb:19653720.CDS.20', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10491, NULL, 100, 'TrpDb:19653720.CDS.21', 'TrpDb:19653720.CDS.21', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10492, NULL, 100, 'TrpDb:19653720.CDS.22', 'TrpDb:19653720.CDS.22', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10493, NULL, 100, 'TrpDb:19653720.three_prime_UTR.1', 'TrpDb:19653720.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10494, NULL, 100, 'TrpDb:19653720.CDS.23', 'TrpDb:19653720.CDS.23', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10495, NULL, 100, 'TrpDb:19653720.three_prime_UTR.2', 'TrpDb:19653720.three_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10496, NULL, 100, 'TrpDb1G01320.2', 'TrpDb:19653721', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10497, NULL, 100, 'TrpDb:19653721.five_prime_UTR.1', 'TrpDb:19653721.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10498, NULL, 100, 'TrpDb:19653721.CDS.1', 'TrpDb:19653721.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10499, NULL, 100, 'TrpDb:19653721.five_prime_UTR.2', 'TrpDb:19653721.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10500, NULL, 100, 'TrpDb:19653721.CDS.2', 'TrpDb:19653721.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10501, NULL, 100, 'TrpDb:19653721.CDS.3', 'TrpDb:19653721.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10502, NULL, 100, 'TrpDb:19653721.CDS.4', 'TrpDb:19653721.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10503, NULL, 100, 'TrpDb:19653721.CDS.5', 'TrpDb:19653721.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10504, NULL, 100, 'TrpDb:19653721.CDS.6', 'TrpDb:19653721.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10505, NULL, 100, 'TrpDb:19653721.CDS.7', 'TrpDb:19653721.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10506, NULL, 100, 'TrpDb:19653721.CDS.8', 'TrpDb:19653721.CDS.8', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10507, NULL, 100, 'TrpDb:19653721.CDS.9', 'TrpDb:19653721.CDS.9', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10508, NULL, 100, 'TrpDb:19653721.CDS.10', 'TrpDb:19653721.CDS.10', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10509, NULL, 100, 'TrpDb:19653721.CDS.11', 'TrpDb:19653721.CDS.11', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10510, NULL, 100, 'TrpDb:19653721.CDS.12', 'TrpDb:19653721.CDS.12', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10511, NULL, 100, 'TrpDb:19653721.CDS.13', 'TrpDb:19653721.CDS.13', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10512, NULL, 100, 'TrpDb:19653721.CDS.14', 'TrpDb:19653721.CDS.14', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10513, NULL, 100, 'TrpDb:19653721.CDS.15', 'TrpDb:19653721.CDS.15', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10514, NULL, 100, 'TrpDb:19653721.CDS.16', 'TrpDb:19653721.CDS.16', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10515, NULL, 100, 'TrpDb:19653721.CDS.17', 'TrpDb:19653721.CDS.17', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10516, NULL, 100, 'TrpDb:19653721.CDS.18', 'TrpDb:19653721.CDS.18', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10517, NULL, 100, 'TrpDb:19653721.CDS.19', 'TrpDb:19653721.CDS.19', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10518, NULL, 100, 'TrpDb:19653721.CDS.20', 'TrpDb:19653721.CDS.20', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10519, NULL, 100, 'TrpDb:19653721.CDS.21', 'TrpDb:19653721.CDS.21', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10520, NULL, 100, 'TrpDb:19653721.CDS.22', 'TrpDb:19653721.CDS.22', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10521, NULL, 100, 'TrpDb:19653721.three_prime_UTR.1', 'TrpDb:19653721.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10522, NULL, 100, 'TrpDb:19653721.CDS.23', 'TrpDb:19653721.CDS.23', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10523, NULL, 100, 'TrpDb:19653721.three_prime_UTR.2', 'TrpDb:19653721.three_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10524, NULL, 100, 'TrpDb1G01340', 'TrpDb1G01340', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10525, NULL, 100, 'TrpDb1G01340.2', 'TrpDb:19650881', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10526, NULL, 100, 'TrpDb:19650881.five_prime_UTR.1', 'TrpDb:19650881.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10527, NULL, 100, 'TrpDb:19650881.CDS.1', 'TrpDb:19650881.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10528, NULL, 100, 'TrpDb:19650881.five_prime_UTR.2', 'TrpDb:19650881.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10529, NULL, 100, 'TrpDb:19650881.CDS.2', 'TrpDb:19650881.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10530, NULL, 100, 'TrpDb:19650881.CDS.3', 'TrpDb:19650881.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10531, NULL, 100, 'TrpDb:19650881.CDS.4', 'TrpDb:19650881.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10532, NULL, 100, 'TrpDb:19650881.CDS.5', 'TrpDb:19650881.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10533, NULL, 100, 'TrpDb:19650881.CDS.6', 'TrpDb:19650881.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10534, NULL, 100, 'TrpDb:19650881.CDS.7', 'TrpDb:19650881.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10535, NULL, 100, 'TrpDb:19650881.three_prime_UTR.1', 'TrpDb:19650881.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10536, NULL, 100, 'TrpDb:19650881.CDS.8', 'TrpDb:19650881.CDS.8', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10537, NULL, 100, 'TrpDb1G01340.1', 'TrpDb:19650882', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10538, NULL, 100, 'TrpDb:19650882.CDS.1', 'TrpDb:19650882.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10539, NULL, 100, 'TrpDb:19650882.five_prime_UTR.1', 'TrpDb:19650882.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10540, NULL, 100, 'TrpDb:19650882.CDS.2', 'TrpDb:19650882.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10541, NULL, 100, 'TrpDb:19650882.CDS.3', 'TrpDb:19650882.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10542, NULL, 100, 'TrpDb:19650882.CDS.4', 'TrpDb:19650882.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10543, NULL, 100, 'TrpDb:19650882.CDS.5', 'TrpDb:19650882.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10544, NULL, 100, 'TrpDb:19650882.CDS.6', 'TrpDb:19650882.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10545, NULL, 100, 'TrpDb:19650882.three_prime_UTR.1', 'TrpDb:19650882.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10546, NULL, 100, 'TrpDb:19650882.CDS.7', 'TrpDb:19650882.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10547, NULL, 100, 'TrpDb1G01350', 'TrpDb1G01350', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10548, NULL, 100, 'TrpDb1G01350.1', 'TrpDb:19651963', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10549, NULL, 100, 'TrpDb:19651963.five_prime_UTR.1', 'TrpDb:19651963.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10550, NULL, 100, 'TrpDb:19651963.five_prime_UTR.2', 'TrpDb:19651963.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10551, NULL, 100, 'TrpDb:19651963.CDS.1', 'TrpDb:19651963.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10552, NULL, 100, 'TrpDb:19651963.CDS.2', 'TrpDb:19651963.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10553, NULL, 100, 'TrpDb:19651963.CDS.3', 'TrpDb:19651963.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10554, NULL, 100, 'TrpDb:19651963.three_prime_UTR.1', 'TrpDb:19651963.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10555, NULL, 100, 'TrpDb1G01355', 'TrpDb1G01355', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10556, NULL, 100, 'TrpDb1G01355.1', 'TrpDb:19653027', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10557, NULL, 100, 'TrpDb:19653027.CDS.1', 'TrpDb:19653027.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10558, NULL, 100, 'TrpDb:19653027.CDS.2', 'TrpDb:19653027.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10559, NULL, 100, 'TrpDb:19653027.CDS.3', 'TrpDb:19653027.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10560, NULL, 100, 'TrpDb:19653027.CDS.4', 'TrpDb:19653027.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10561, NULL, 100, 'TrpDb:19653027.CDS.5', 'TrpDb:19653027.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10562, NULL, 100, 'TrpDb1G01360', 'TrpDb1G01360', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10563, NULL, 100, 'TrpDb1G01360.1', 'TrpDb:19654072', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10564, NULL, 100, 'TrpDb:19654072.five_prime_UTR.1', 'TrpDb:19654072.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10565, NULL, 100, 'TrpDb:19654072.CDS.1', 'TrpDb:19654072.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10566, NULL, 100, 'TrpDb:19654072.CDS.2', 'TrpDb:19654072.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10567, NULL, 100, 'TrpDb:19654072.CDS.3', 'TrpDb:19654072.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10568, NULL, 100, 'TrpDb:19654072.three_prime_UTR.1', 'TrpDb:19654072.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10569, NULL, 100, 'TrpDb1G01370', 'TrpDb1G01370', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10570, NULL, 100, 'TrpDb1G01370.1', 'TrpDb:19653570', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10571, NULL, 100, 'TrpDb:19653570.five_prime_UTR.1', 'TrpDb:19653570.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10572, NULL, 100, 'TrpDb:19653570.five_prime_UTR.2', 'TrpDb:19653570.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10573, NULL, 100, 'TrpDb:19653570.CDS.1', 'TrpDb:19653570.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10574, NULL, 100, 'TrpDb:19653570.CDS.2', 'TrpDb:19653570.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10575, NULL, 100, 'TrpDb:19653570.CDS.3', 'TrpDb:19653570.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10576, NULL, 100, 'TrpDb:19653570.CDS.4', 'TrpDb:19653570.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10577, NULL, 100, 'TrpDb:19653570.CDS.5', 'TrpDb:19653570.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10578, NULL, 100, 'TrpDb:19653570.CDS.6', 'TrpDb:19653570.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10579, NULL, 100, 'TrpDb:19653570.CDS.7', 'TrpDb:19653570.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10580, NULL, 100, 'TrpDb:19653570.CDS.8', 'TrpDb:19653570.CDS.8', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10581, NULL, 100, 'TrpDb:19653570.CDS.9', 'TrpDb:19653570.CDS.9', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10582, NULL, 100, 'TrpDb:19653570.three_prime_UTR.1', 'TrpDb:19653570.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10583, NULL, 100, 'TrpDb1G01370.2', 'TrpDb:19653571', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10584, NULL, 100, 'TrpDb:19653571.five_prime_UTR.1', 'TrpDb:19653571.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10585, NULL, 100, 'TrpDb:19653571.CDS.1', 'TrpDb:19653571.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10586, NULL, 100, 'TrpDb:19653571.CDS.2', 'TrpDb:19653571.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10587, NULL, 100, 'TrpDb:19653571.CDS.3', 'TrpDb:19653571.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10588, NULL, 100, 'TrpDb:19653571.CDS.4', 'TrpDb:19653571.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10589, NULL, 100, 'TrpDb:19653571.CDS.5', 'TrpDb:19653571.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10590, NULL, 100, 'TrpDb:19653571.CDS.6', 'TrpDb:19653571.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10591, NULL, 100, 'TrpDb:19653571.CDS.7', 'TrpDb:19653571.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10592, NULL, 100, 'TrpDb:19653571.CDS.8', 'TrpDb:19653571.CDS.8', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10593, NULL, 100, 'TrpDb:19653571.CDS.9', 'TrpDb:19653571.CDS.9', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10594, NULL, 100, 'TrpDb:19653571.three_prime_UTR.1', 'TrpDb:19653571.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10595, NULL, 100, 'TrpDb1G01380', 'TrpDb1G01380', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10596, NULL, 100, 'TrpDb1G01380.1', 'TrpDb:19657745', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10597, NULL, 100, 'TrpDb:19657745.five_prime_UTR.1', 'TrpDb:19657745.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10598, NULL, 100, 'TrpDb:19657745.CDS.1', 'TrpDb:19657745.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10599, NULL, 100, 'TrpDb:19657745.CDS.2', 'TrpDb:19657745.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10600, NULL, 100, 'TrpDb:19657745.CDS.3', 'TrpDb:19657745.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10601, NULL, 100, 'TrpDb:19657745.three_prime_UTR.1', 'TrpDb:19657745.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10602, NULL, 100, 'TrpDb1G01390', 'TrpDb1G01390', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10603, NULL, 100, 'TrpDb1G01390.1', 'TrpDb:19657355', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10604, NULL, 100, 'TrpDb:19657355.three_prime_UTR.1', 'TrpDb:19657355.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10605, NULL, 100, 'TrpDb:19657355.CDS.1', 'TrpDb:19657355.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10606, NULL, 100, 'TrpDb:19657355.five_prime_UTR.1', 'TrpDb:19657355.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10607, NULL, 100, 'TrpDb1G01400', 'TrpDb1G01400', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10608, NULL, 100, 'TrpDb1G01400.1', 'TrpDb:19656548', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10609, NULL, 100, 'TrpDb:19656548.CDS.1', 'TrpDb:19656548.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10610, NULL, 100, 'TrpDb:19656548.five_prime_UTR.1', 'TrpDb:19656548.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10611, NULL, 100, 'TrpDb:19656548.CDS.2', 'TrpDb:19656548.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10612, NULL, 100, 'TrpDb:19656548.CDS.3', 'TrpDb:19656548.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10613, NULL, 100, 'TrpDb:19656548.three_prime_UTR.1', 'TrpDb:19656548.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10614, NULL, 100, 'TrpDb:19656548.CDS.4', 'TrpDb:19656548.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10615, NULL, 100, 'TrpDb1G01410', 'TrpDb1G01410', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10616, NULL, 100, 'TrpDb1G01410.1', 'TrpDb:19649710', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10617, NULL, 100, 'TrpDb:19649710.CDS.1', 'TrpDb:19649710.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10618, NULL, 100, 'TrpDb1G01420', 'TrpDb1G01420', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10619, NULL, 100, 'TrpDb1G01420.1', 'TrpDb:19652756', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10620, NULL, 100, 'TrpDb:19652756.three_prime_UTR.1', 'TrpDb:19652756.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10621, NULL, 100, 'TrpDb:19652756.CDS.1', 'TrpDb:19652756.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10622, NULL, 100, 'TrpDb1G01430', 'TrpDb1G01430', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10623, NULL, 100, 'TrpDb1G01430.1', 'TrpDb:19652044', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10624, NULL, 100, 'TrpDb:19652044.CDS.1', 'TrpDb:19652044.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10625, NULL, 100, 'TrpDb:19652044.five_prime_UTR.1', 'TrpDb:19652044.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10626, NULL, 100, 'TrpDb:19652044.CDS.2', 'TrpDb:19652044.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10627, NULL, 100, 'TrpDb:19652044.three_prime_UTR.1', 'TrpDb:19652044.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10628, NULL, 100, 'TrpDb:19652044.CDS.3', 'TrpDb:19652044.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10629, NULL, 100, 'TrpDb1G01440', 'TrpDb1G01440', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10630, NULL, 100, 'TrpDb1G01440.1', 'TrpDb:19652813', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10631, NULL, 100, 'TrpDb:19652813.five_prime_UTR.1', 'TrpDb:19652813.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10632, NULL, 100, 'TrpDb:19652813.CDS.1', 'TrpDb:19652813.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10633, NULL, 100, 'TrpDb:19652813.five_prime_UTR.2', 'TrpDb:19652813.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10634, NULL, 100, 'TrpDb:19652813.CDS.2', 'TrpDb:19652813.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10635, NULL, 100, 'TrpDb:19652813.CDS.3', 'TrpDb:19652813.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10636, NULL, 100, 'TrpDb:19652813.three_prime_UTR.1', 'TrpDb:19652813.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10637, NULL, 100, 'TrpDb:19652813.CDS.4', 'TrpDb:19652813.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10638, NULL, 100, 'TrpDb1G01450', 'TrpDb1G01450', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10639, NULL, 100, 'TrpDb1G01450.1', 'TrpDb:19657108', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10640, NULL, 100, 'TrpDb:19657108.CDS.1', 'TrpDb:19657108.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10641, NULL, 100, 'TrpDb1G01453', 'TrpDb1G01453', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10642, NULL, 100, 'TrpDb1G01453.2', 'TrpDb:19658130', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10643, NULL, 100, 'TrpDb:19658130.three_prime_UTR.1', 'TrpDb:19658130.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10644, NULL, 100, 'TrpDb:19658130.CDS.1', 'TrpDb:19658130.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10645, NULL, 100, 'TrpDb:19658130.five_prime_UTR.1', 'TrpDb:19658130.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10646, NULL, 100, 'TrpDb1G01453.1', 'TrpDb:19658131', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10647, NULL, 100, 'TrpDb:19658131.CDS.1', 'TrpDb:19658131.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10648, NULL, 100, 'TrpDb:19658131.five_prime_UTR.1', 'TrpDb:19658131.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10649, NULL, 100, 'TrpDb:19658131.three_prime_UTR.1', 'TrpDb:19658131.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10650, NULL, 100, 'TrpDb:19658131.CDS.2', 'TrpDb:19658131.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10651, NULL, 100, 'TrpDb1G01460', 'TrpDb1G01460', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='gene' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10652, NULL, 100, 'TrpDb1G01460.1', 'TrpDb:19649516', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='mRNA' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10653, NULL, 100, 'TrpDb:19649516.five_prime_UTR.1', 'TrpDb:19649516.five_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10654, NULL, 100, 'TrpDb:19649516.five_prime_UTR.2', 'TrpDb:19649516.five_prime_UTR.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='five_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10655, NULL, 100, 'TrpDb:19649516.CDS.1', 'TrpDb:19649516.CDS.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10656, NULL, 100, 'TrpDb:19649516.CDS.2', 'TrpDb:19649516.CDS.2', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10657, NULL, 100, 'TrpDb:19649516.CDS.3', 'TrpDb:19649516.CDS.3', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10658, NULL, 100, 'TrpDb:19649516.CDS.4', 'TrpDb:19649516.CDS.4', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10659, NULL, 100, 'TrpDb:19649516.CDS.5', 'TrpDb:19649516.CDS.5', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10660, NULL, 100, 'TrpDb:19649516.CDS.6', 'TrpDb:19649516.CDS.6', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10661, NULL, 100, 'TrpDb:19649516.CDS.7', 'TrpDb:19649516.CDS.7', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10662, NULL, 100, 'TrpDb:19649516.CDS.8', 'TrpDb:19649516.CDS.8', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10663, NULL, 100, 'TrpDb:19649516.CDS.9', 'TrpDb:19649516.CDS.9', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='CDS' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10664, NULL, 100, 'TrpDb:19649516.three_prime_UTR.1', 'TrpDb:19649516.three_prime_UTR.1', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='three_prime_UTR' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10665, NULL, 100, 'TrpDb:19656964', 'TrpDb:19656964-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10666, NULL, 100, 'TrpDb:19655142', 'TrpDb:19655142-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10667, NULL, 100, 'TrpDb:19655143', 'TrpDb:19655143-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10668, NULL, 100, 'TrpDb:19649747', 'TrpDb:19649747-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10669, NULL, 100, 'TrpDb:19652431', 'TrpDb:19652431-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10670, NULL, 100, 'TrpDb:19652432', 'TrpDb:19652432-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10671, NULL, 100, 'TrpDb:19652974', 'TrpDb:19652974-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10672, NULL, 100, 'TrpDb:19652702', 'TrpDb:19652702-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10673, NULL, 100, 'TrpDb:19652703', 'TrpDb:19652703-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10674, NULL, 100, 'TrpDb:19652704', 'TrpDb:19652704-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10675, NULL, 100, 'TrpDb:19652705', 'TrpDb:19652705-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10676, NULL, 100, 'TrpDb:19652706', 'TrpDb:19652706-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10677, NULL, 100, 'TrpDb:19650807', 'TrpDb:19650807-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10678, NULL, 100, 'TrpDb:19650808', 'TrpDb:19650808-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10679, NULL, 100, 'TrpDb:19655091', 'TrpDb:19655091-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10680, NULL, 100, 'TrpDb:19651135', 'TrpDb:19651135-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10681, NULL, 100, 'TrpDb:19651136', 'TrpDb:19651136-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10682, NULL, 100, 'TrpDb:19650207', 'TrpDb:19650207-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10683, NULL, 100, 'TrpDb:19657597', 'TrpDb:19657597-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10684, NULL, 100, 'TrpDb:19657598', 'TrpDb:19657598-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10685, NULL, 100, 'TrpDb:19657599', 'TrpDb:19657599-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10686, NULL, 100, 'TrpDb:19657600', 'TrpDb:19657600-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10687, NULL, 100, 'TrpDb:19658169', 'TrpDb:19658169-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10688, NULL, 100, 'TrpDb:19658170', 'TrpDb:19658170-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10689, NULL, 100, 'TrpDb:19653086', 'TrpDb:19653086-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10690, NULL, 100, 'TrpDb:19655257', 'TrpDb:19655257-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10691, NULL, 100, 'TrpDb:19653597', 'TrpDb:19653597-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10692, NULL, 100, 'TrpDb:19653404', 'TrpDb:19653404-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10693, NULL, 100, 'TrpDb:19653405', 'TrpDb:19653405-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10694, NULL, 100, 'TrpDb:19653406', 'TrpDb:19653406-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10695, NULL, 100, 'TrpDb:19649619', 'TrpDb:19649619-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10696, NULL, 100, 'TrpDb:19654306', 'TrpDb:19654306-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10697, NULL, 100, 'TrpDb:19654307', 'TrpDb:19654307-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10698, NULL, 100, 'TrpDb:19649697', 'TrpDb:19649697-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10699, NULL, 100, 'TrpDb:19649698', 'TrpDb:19649698-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10700, NULL, 100, 'TrpDb:19654493', 'TrpDb:19654493-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10701, NULL, 100, 'TrpDb:19654322', 'TrpDb:19654322-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10702, NULL, 100, 'TrpDb:19649914', 'TrpDb:19649914-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10703, NULL, 100, 'TrpDb:19656818', 'TrpDb:19656818-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10704, NULL, 100, 'TrpDb:19652890', 'TrpDb:19652890-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10705, NULL, 100, 'TrpDb:19656715', 'TrpDb:19656715-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10706, NULL, 100, 'TrpDb:19650274', 'TrpDb:19650274-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10707, NULL, 100, 'TrpDb:19650436', 'TrpDb:19650436-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10708, NULL, 100, 'TrpDb:19650437', 'TrpDb:19650437-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10709, NULL, 100, 'TrpDb:19650438', 'TrpDb:19650438-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10710, NULL, 100, 'TrpDb:19649318', 'TrpDb:19649318-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10711, NULL, 100, 'TrpDb:19651078', 'TrpDb:19651078-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10712, NULL, 100, 'TrpDb:19651079', 'TrpDb:19651079-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10713, NULL, 100, 'TrpDb:19651080', 'TrpDb:19651080-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10714, NULL, 100, 'TrpDb:19651990', 'TrpDb:19651990-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10715, NULL, 100, 'TrpDb:19651139', 'TrpDb:19651139-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10716, NULL, 100, 'TrpDb:19651140', 'TrpDb:19651140-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10717, NULL, 100, 'TrpDb:19650328', 'TrpDb:19650328-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10718, NULL, 100, 'TrpDb:19651884', 'TrpDb:19651884-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10719, NULL, 100, 'TrpDb:19649801', 'TrpDb:19649801-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10720, NULL, 100, 'TrpDb:19653720', 'TrpDb:19653720-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10721, NULL, 100, 'TrpDb:19653721', 'TrpDb:19653721-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10722, NULL, 100, 'TrpDb:19650881', 'TrpDb:19650881-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10723, NULL, 100, 'TrpDb:19650882', 'TrpDb:19650882-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10724, NULL, 100, 'TrpDb:19651963', 'TrpDb:19651963-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10725, NULL, 100, 'TrpDb:19653027', 'TrpDb:19653027-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10726, NULL, 100, 'TrpDb:19654072', 'TrpDb:19654072-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10727, NULL, 100, 'TrpDb:19653570', 'TrpDb:19653570-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10728, NULL, 100, 'TrpDb:19653571', 'TrpDb:19653571-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10729, NULL, 100, 'TrpDb:19657745', 'TrpDb:19657745-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10730, NULL, 100, 'TrpDb:19657355', 'TrpDb:19657355-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10731, NULL, 100, 'TrpDb:19656548', 'TrpDb:19656548-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10732, NULL, 100, 'TrpDb:19649710', 'TrpDb:19649710-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10733, NULL, 100, 'TrpDb:19652756', 'TrpDb:19652756-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10734, NULL, 100, 'TrpDb:19652044', 'TrpDb:19652044-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10735, NULL, 100, 'TrpDb:19652813', 'TrpDb:19652813-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10736, NULL, 100, 'TrpDb:19657108', 'TrpDb:19657108-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10737, NULL, 100, 'TrpDb:19658130', 'TrpDb:19658130-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10738, NULL, 100, 'TrpDb:19658131', 'TrpDb:19658131-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');
INSERT INTO chado.feature VALUES (10739, NULL, 100, 'TrpDb:19649516', 'TrpDb:19649516-protein', '', 0, '                                ', (SELECT cvterm_id FROM chado.cvterm WHERE name='polypeptide' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), false, false, '2024-01-05 22:24:30.179321', '2024-01-05 22:24:30.179321');

INSERT INTO chado.analysisfeature VALUES (10000, 10001, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10001, 10002, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10002, 10003, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10003, 10004, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10004, 10005, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10005, 10006, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10006, 10007, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10007, 10008, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10008, 10009, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10009, 10010, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10010, 10011, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10011, 10012, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10012, 10013, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10013, 10014, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10014, 10015, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10015, 10016, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10016, 10017, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10017, 10018, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10018, 10019, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10019, 10020, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10020, 10021, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10021, 10022, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10022, 10023, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10023, 10024, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10024, 10025, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10025, 10026, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10026, 10027, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10027, 10028, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10028, 10029, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10029, 10030, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10030, 10031, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10031, 10032, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10032, 10033, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10033, 10034, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10034, 10035, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10035, 10036, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10036, 10037, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10037, 10038, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10038, 10039, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10039, 10040, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10040, 10041, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10041, 10042, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10042, 10043, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10043, 10044, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10044, 10045, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10045, 10046, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10046, 10047, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10047, 10048, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10048, 10049, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10049, 10050, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10050, 10051, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10051, 10052, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10052, 10053, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10053, 10054, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10054, 10055, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10055, 10056, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10056, 10057, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10057, 10058, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10058, 10059, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10059, 10060, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10060, 10061, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10061, 10062, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10062, 10063, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10063, 10064, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10064, 10065, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10065, 10066, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10066, 10067, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10067, 10068, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10068, 10069, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10069, 10070, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10070, 10071, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10071, 10072, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10072, 10073, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10073, 10074, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10074, 10075, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10075, 10076, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10076, 10077, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10077, 10078, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10078, 10079, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10079, 10080, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10080, 10081, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10081, 10082, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10082, 10083, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10083, 10084, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10084, 10085, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10085, 10086, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10086, 10087, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10087, 10088, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10088, 10089, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10089, 10090, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10090, 10091, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10091, 10092, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10092, 10093, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10093, 10094, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10094, 10095, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10095, 10096, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10096, 10097, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10097, 10098, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10098, 10099, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10099, 10100, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10100, 10101, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10101, 10102, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10102, 10103, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10103, 10104, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10104, 10105, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10105, 10106, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10106, 10107, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10107, 10108, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10108, 10109, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10109, 10110, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10110, 10111, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10111, 10112, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10112, 10113, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10113, 10114, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10114, 10115, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10115, 10116, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10116, 10117, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10117, 10118, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10118, 10119, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10119, 10120, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10120, 10121, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10121, 10122, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10122, 10123, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10123, 10124, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10124, 10125, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10125, 10126, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10126, 10127, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10127, 10128, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10128, 10129, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10129, 10130, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10130, 10131, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10131, 10132, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10132, 10133, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10133, 10134, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10134, 10135, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10135, 10136, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10136, 10137, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10137, 10138, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10138, 10139, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10139, 10140, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10140, 10141, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10141, 10142, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10142, 10143, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10143, 10144, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10144, 10145, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10145, 10146, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10146, 10147, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10147, 10148, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10148, 10149, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10149, 10150, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10150, 10151, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10151, 10152, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10152, 10153, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10153, 10154, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10154, 10155, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10155, 10156, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10156, 10157, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10157, 10158, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10158, 10159, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10159, 10160, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10160, 10161, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10161, 10162, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10162, 10163, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10163, 10164, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10164, 10165, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10165, 10166, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10166, 10167, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10167, 10168, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10168, 10169, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10169, 10170, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10170, 10171, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10171, 10172, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10172, 10173, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10173, 10174, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10174, 10175, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10175, 10176, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10176, 10177, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10177, 10178, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10178, 10179, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10179, 10180, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10180, 10181, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10181, 10182, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10182, 10183, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10183, 10184, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10184, 10185, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10185, 10186, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10186, 10187, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10187, 10188, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10188, 10189, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10189, 10190, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10190, 10191, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10191, 10192, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10192, 10193, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10193, 10194, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10194, 10195, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10195, 10196, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10196, 10197, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10197, 10198, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10198, 10199, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10199, 10200, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10200, 10201, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10201, 10202, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10202, 10203, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10203, 10204, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10204, 10205, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10205, 10206, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10206, 10207, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10207, 10208, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10208, 10209, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10209, 10210, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10210, 10211, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10211, 10212, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10212, 10213, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10213, 10214, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10214, 10215, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10215, 10216, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10216, 10217, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10217, 10218, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10218, 10219, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10219, 10220, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10220, 10221, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10221, 10222, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10222, 10223, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10223, 10224, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10224, 10225, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10225, 10226, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10226, 10227, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10227, 10228, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10228, 10229, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10229, 10230, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10230, 10231, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10231, 10232, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10232, 10233, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10233, 10234, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10234, 10235, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10235, 10236, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10236, 10237, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10237, 10238, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10238, 10239, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10239, 10240, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10240, 10241, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10241, 10242, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10242, 10243, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10243, 10244, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10244, 10245, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10245, 10246, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10246, 10247, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10247, 10248, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10248, 10249, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10249, 10250, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10250, 10251, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10251, 10252, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10252, 10253, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10253, 10254, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10254, 10255, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10255, 10256, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10256, 10257, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10257, 10258, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10258, 10259, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10259, 10260, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10260, 10261, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10261, 10262, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10262, 10263, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10263, 10264, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10264, 10265, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10265, 10266, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10266, 10267, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10267, 10268, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10268, 10269, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10269, 10270, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10270, 10271, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10271, 10272, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10272, 10273, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10273, 10274, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10274, 10275, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10275, 10276, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10276, 10277, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10277, 10278, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10278, 10279, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10279, 10280, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10280, 10281, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10281, 10282, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10282, 10283, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10283, 10284, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10284, 10285, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10285, 10286, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10286, 10287, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10287, 10288, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10288, 10289, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10289, 10290, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10290, 10291, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10291, 10292, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10292, 10293, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10293, 10294, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10294, 10295, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10295, 10296, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10296, 10297, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10297, 10298, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10298, 10299, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10299, 10300, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10300, 10301, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10301, 10302, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10302, 10303, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10303, 10304, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10304, 10305, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10305, 10306, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10306, 10307, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10307, 10308, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10308, 10309, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10309, 10310, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10310, 10311, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10311, 10312, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10312, 10313, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10313, 10314, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10314, 10315, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10315, 10316, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10316, 10317, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10317, 10318, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10318, 10319, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10319, 10320, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10320, 10321, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10321, 10322, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10322, 10323, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10323, 10324, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10324, 10325, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10325, 10326, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10326, 10327, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10327, 10328, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10328, 10329, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10329, 10330, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10330, 10331, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10331, 10332, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10332, 10333, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10333, 10334, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10334, 10335, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10335, 10336, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10336, 10337, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10337, 10338, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10338, 10339, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10339, 10340, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10340, 10341, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10341, 10342, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10342, 10343, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10343, 10344, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10344, 10345, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10345, 10346, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10346, 10347, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10347, 10348, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10348, 10349, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10349, 10350, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10350, 10351, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10351, 10352, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10352, 10353, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10353, 10354, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10354, 10355, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10355, 10356, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10356, 10357, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10357, 10358, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10358, 10359, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10359, 10360, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10360, 10361, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10361, 10362, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10362, 10363, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10363, 10364, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10364, 10365, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10365, 10366, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10366, 10367, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10367, 10368, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10368, 10369, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10369, 10370, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10370, 10371, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10371, 10372, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10372, 10373, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10373, 10374, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10374, 10375, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10375, 10376, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10376, 10377, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10377, 10378, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10378, 10379, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10379, 10380, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10380, 10381, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10381, 10382, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10382, 10383, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10383, 10384, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10384, 10385, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10385, 10386, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10386, 10387, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10387, 10388, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10388, 10389, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10389, 10390, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10390, 10391, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10391, 10392, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10392, 10393, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10393, 10394, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10394, 10395, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10395, 10396, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10396, 10397, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10397, 10398, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10398, 10399, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10399, 10400, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10400, 10401, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10401, 10402, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10402, 10403, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10403, 10404, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10404, 10405, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10405, 10406, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10406, 10407, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10407, 10408, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10408, 10409, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10409, 10410, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10410, 10411, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10411, 10412, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10412, 10413, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10413, 10414, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10414, 10415, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10415, 10416, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10416, 10417, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10417, 10418, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10418, 10419, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10419, 10420, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10420, 10421, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10421, 10422, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10422, 10423, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10423, 10424, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10424, 10425, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10425, 10426, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10426, 10427, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10427, 10428, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10428, 10429, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10429, 10430, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10430, 10431, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10431, 10432, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10432, 10433, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10433, 10434, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10434, 10435, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10435, 10436, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10436, 10437, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10437, 10438, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10438, 10439, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10439, 10440, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10440, 10441, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10441, 10442, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10442, 10443, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10443, 10444, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10444, 10445, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10445, 10446, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10446, 10447, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10447, 10448, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10448, 10449, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10449, 10450, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10450, 10451, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10451, 10452, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10452, 10453, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10453, 10454, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10454, 10455, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10455, 10456, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10456, 10457, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10457, 10458, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10458, 10459, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10459, 10460, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10460, 10461, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10461, 10462, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10462, 10463, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10463, 10464, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10464, 10465, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10465, 10466, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10466, 10467, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10467, 10468, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10468, 10469, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10469, 10470, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10470, 10471, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10471, 10472, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10472, 10473, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10473, 10474, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10474, 10475, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10475, 10476, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10476, 10477, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10477, 10478, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10478, 10479, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10479, 10480, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10480, 10481, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10481, 10482, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10482, 10483, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10483, 10484, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10484, 10485, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10485, 10486, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10486, 10487, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10487, 10488, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10488, 10489, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10489, 10490, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10490, 10491, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10491, 10492, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10492, 10493, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10493, 10494, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10494, 10495, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10495, 10496, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10496, 10497, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10497, 10498, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10498, 10499, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10499, 10500, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10500, 10501, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10501, 10502, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10502, 10503, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10503, 10504, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10504, 10505, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10505, 10506, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10506, 10507, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10507, 10508, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10508, 10509, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10509, 10510, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10510, 10511, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10511, 10512, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10512, 10513, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10513, 10514, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10514, 10515, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10515, 10516, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10516, 10517, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10517, 10518, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10518, 10519, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10519, 10520, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10520, 10521, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10521, 10522, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10522, 10523, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10523, 10524, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10524, 10525, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10525, 10526, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10526, 10527, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10527, 10528, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10528, 10529, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10529, 10530, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10530, 10531, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10531, 10532, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10532, 10533, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10533, 10534, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10534, 10535, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10535, 10536, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10536, 10537, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10537, 10538, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10538, 10539, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10539, 10540, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10540, 10541, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10541, 10542, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10542, 10543, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10543, 10544, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10544, 10545, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10545, 10546, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10546, 10547, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10547, 10548, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10548, 10549, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10549, 10550, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10550, 10551, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10551, 10552, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10552, 10553, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10553, 10554, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10554, 10555, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10555, 10556, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10556, 10557, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10557, 10558, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10558, 10559, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10559, 10560, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10560, 10561, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10561, 10562, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10562, 10563, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10563, 10564, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10564, 10565, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10565, 10566, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10566, 10567, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10567, 10568, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10568, 10569, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10569, 10570, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10570, 10571, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10571, 10572, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10572, 10573, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10573, 10574, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10574, 10575, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10575, 10576, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10576, 10577, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10577, 10578, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10578, 10579, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10579, 10580, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10580, 10581, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10581, 10582, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10582, 10583, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10583, 10584, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10584, 10585, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10585, 10586, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10586, 10587, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10587, 10588, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10588, 10589, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10589, 10590, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10590, 10591, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10591, 10592, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10592, 10593, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10593, 10594, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10594, 10595, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10595, 10596, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10596, 10597, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10597, 10598, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10598, 10599, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10599, 10600, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10600, 10601, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10601, 10602, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10602, 10603, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10603, 10604, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10604, 10605, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10605, 10606, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10606, 10607, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10607, 10608, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10608, 10609, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10609, 10610, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10610, 10611, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10611, 10612, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10612, 10613, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10613, 10614, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10614, 10615, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10615, 10616, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10616, 10617, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10617, 10618, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10618, 10619, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10619, 10620, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10620, 10621, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10621, 10622, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10622, 10623, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10623, 10624, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10624, 10625, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10625, 10626, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10626, 10627, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10627, 10628, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10628, 10629, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10629, 10630, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10630, 10631, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10631, 10632, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10632, 10633, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10633, 10634, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10634, 10635, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10635, 10636, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10636, 10637, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10637, 10638, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10638, 10639, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10639, 10640, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10640, 10641, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10641, 10642, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10642, 10643, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10643, 10644, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10644, 10645, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10645, 10646, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10646, 10647, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10647, 10648, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10648, 10649, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10649, 10650, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10650, 10651, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10651, 10652, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10652, 10653, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10653, 10654, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10654, 10655, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10655, 10656, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10656, 10657, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10657, 10658, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10658, 10659, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10659, 10660, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10660, 10661, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10661, 10662, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10662, 10663, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10663, 10664, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10664, 10665, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10665, 10666, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10666, 10667, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10667, 10668, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10668, 10669, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10669, 10670, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10670, 10671, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10671, 10672, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10672, 10673, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10673, 10674, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10674, 10675, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10675, 10676, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10676, 10677, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10677, 10678, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10678, 10679, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10679, 10680, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10680, 10681, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10681, 10682, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10682, 10683, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10683, 10684, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10684, 10685, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10685, 10686, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10686, 10687, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10687, 10688, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10688, 10689, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10689, 10690, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10690, 10691, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10691, 10692, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10692, 10693, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10693, 10694, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10694, 10695, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10695, 10696, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10696, 10697, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10697, 10698, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10698, 10699, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10699, 10700, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10700, 10701, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10701, 10702, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10702, 10703, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10703, 10704, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10704, 10705, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10705, 10706, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10706, 10707, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10707, 10708, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10708, 10709, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10709, 10710, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10710, 10711, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10711, 10712, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10712, 10713, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10713, 10714, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10714, 10715, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10715, 10716, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10716, 10717, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10717, 10718, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10718, 10719, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10719, 10720, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10720, 10721, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10721, 10722, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10722, 10723, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10723, 10724, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10724, 10725, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10725, 10726, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10726, 10727, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10727, 10728, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10728, 10729, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10729, 10730, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10730, 10731, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10731, 10732, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10732, 10733, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10733, 10734, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10734, 10735, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10735, 10736, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10736, 10737, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10737, 10738, 1, NULL, NULL, NULL, NULL);
INSERT INTO chado.analysisfeature VALUES (10738, 10739, 1, NULL, NULL, NULL, NULL);

INSERT INTO chado.feature_dbxref VALUES (10000, 10001, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10001, 10002, 10002, true);
INSERT INTO chado.feature_dbxref VALUES (10002, 10002, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10003, 10003, 10002, true);
INSERT INTO chado.feature_dbxref VALUES (10004, 10003, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10005, 10004, 10002, true);
INSERT INTO chado.feature_dbxref VALUES (10006, 10004, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10007, 10005, 10002, true);
INSERT INTO chado.feature_dbxref VALUES (10008, 10005, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10009, 10006, 10002, true);
INSERT INTO chado.feature_dbxref VALUES (10010, 10006, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10011, 10007, 10002, true);
INSERT INTO chado.feature_dbxref VALUES (10012, 10007, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10013, 10008, 10002, true);
INSERT INTO chado.feature_dbxref VALUES (10014, 10008, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10015, 10009, 10002, true);
INSERT INTO chado.feature_dbxref VALUES (10016, 10009, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10017, 10010, 10002, true);
INSERT INTO chado.feature_dbxref VALUES (10018, 10010, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10019, 10011, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10020, 10012, 10003, true);
INSERT INTO chado.feature_dbxref VALUES (10021, 10012, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10022, 10013, 10003, true);
INSERT INTO chado.feature_dbxref VALUES (10023, 10013, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10024, 10014, 10003, true);
INSERT INTO chado.feature_dbxref VALUES (10025, 10014, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10026, 10015, 10003, true);
INSERT INTO chado.feature_dbxref VALUES (10027, 10015, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10028, 10016, 10003, true);
INSERT INTO chado.feature_dbxref VALUES (10029, 10016, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10030, 10017, 10003, true);
INSERT INTO chado.feature_dbxref VALUES (10031, 10017, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10032, 10018, 10003, true);
INSERT INTO chado.feature_dbxref VALUES (10033, 10018, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10034, 10019, 10003, true);
INSERT INTO chado.feature_dbxref VALUES (10035, 10019, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10036, 10020, 10003, true);
INSERT INTO chado.feature_dbxref VALUES (10037, 10020, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10038, 10021, 10003, true);
INSERT INTO chado.feature_dbxref VALUES (10039, 10021, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10040, 10022, 10003, true);
INSERT INTO chado.feature_dbxref VALUES (10041, 10022, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10042, 10023, 10003, true);
INSERT INTO chado.feature_dbxref VALUES (10043, 10023, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10044, 10024, 10003, true);
INSERT INTO chado.feature_dbxref VALUES (10045, 10024, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10046, 10025, 10004, true);
INSERT INTO chado.feature_dbxref VALUES (10047, 10025, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10048, 10026, 10004, true);
INSERT INTO chado.feature_dbxref VALUES (10049, 10026, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10050, 10027, 10004, true);
INSERT INTO chado.feature_dbxref VALUES (10051, 10027, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10052, 10028, 10004, true);
INSERT INTO chado.feature_dbxref VALUES (10053, 10028, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10054, 10029, 10004, true);
INSERT INTO chado.feature_dbxref VALUES (10055, 10029, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10056, 10030, 10004, true);
INSERT INTO chado.feature_dbxref VALUES (10057, 10030, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10058, 10031, 10004, true);
INSERT INTO chado.feature_dbxref VALUES (10059, 10031, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10060, 10032, 10004, true);
INSERT INTO chado.feature_dbxref VALUES (10061, 10032, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10062, 10033, 10004, true);
INSERT INTO chado.feature_dbxref VALUES (10063, 10033, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10064, 10034, 10004, true);
INSERT INTO chado.feature_dbxref VALUES (10065, 10034, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10066, 10035, 10004, true);
INSERT INTO chado.feature_dbxref VALUES (10067, 10035, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10068, 10036, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10069, 10037, 10005, true);
INSERT INTO chado.feature_dbxref VALUES (10070, 10037, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10071, 10038, 10005, true);
INSERT INTO chado.feature_dbxref VALUES (10072, 10038, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10073, 10039, 10005, true);
INSERT INTO chado.feature_dbxref VALUES (10074, 10039, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10075, 10040, 10005, true);
INSERT INTO chado.feature_dbxref VALUES (10076, 10040, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10077, 10041, 10005, true);
INSERT INTO chado.feature_dbxref VALUES (10078, 10041, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10079, 10042, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10080, 10043, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10081, 10043, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10082, 10044, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10083, 10044, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10084, 10045, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10085, 10045, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10086, 10046, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10087, 10046, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10088, 10047, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10089, 10047, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10090, 10048, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10091, 10048, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10092, 10049, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10093, 10049, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10094, 10050, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10095, 10050, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10096, 10051, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10097, 10051, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10098, 10052, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10099, 10052, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10100, 10053, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10101, 10053, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10102, 10054, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10103, 10054, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10104, 10055, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10105, 10055, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10106, 10056, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10107, 10056, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10108, 10057, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10109, 10057, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10110, 10058, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10111, 10058, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10112, 10059, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10113, 10059, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10114, 10060, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10115, 10060, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10116, 10061, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10117, 10061, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10118, 10062, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10119, 10062, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10120, 10063, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10121, 10063, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10122, 10064, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10123, 10064, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10124, 10065, 10006, true);
INSERT INTO chado.feature_dbxref VALUES (10125, 10065, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10126, 10066, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10127, 10066, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10128, 10067, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10129, 10067, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10130, 10068, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10131, 10068, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10132, 10069, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10133, 10069, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10134, 10070, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10135, 10070, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10136, 10071, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10137, 10071, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10138, 10072, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10139, 10072, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10140, 10073, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10141, 10073, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10142, 10074, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10143, 10074, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10144, 10075, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10145, 10075, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10146, 10076, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10147, 10076, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10148, 10077, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10149, 10077, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10150, 10078, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10151, 10078, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10152, 10079, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10153, 10079, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10154, 10080, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10155, 10080, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10156, 10081, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10157, 10081, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10158, 10082, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10159, 10082, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10160, 10083, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10161, 10083, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10162, 10084, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10163, 10084, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10164, 10085, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10165, 10085, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10166, 10086, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10167, 10086, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10168, 10087, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10169, 10087, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10170, 10088, 10007, true);
INSERT INTO chado.feature_dbxref VALUES (10171, 10088, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10172, 10089, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10173, 10090, 10008, true);
INSERT INTO chado.feature_dbxref VALUES (10174, 10090, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10175, 10091, 10008, true);
INSERT INTO chado.feature_dbxref VALUES (10176, 10091, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10177, 10092, 10008, true);
INSERT INTO chado.feature_dbxref VALUES (10178, 10092, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10179, 10093, 10008, true);
INSERT INTO chado.feature_dbxref VALUES (10180, 10093, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10181, 10094, 10008, true);
INSERT INTO chado.feature_dbxref VALUES (10182, 10094, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10183, 10095, 10008, true);
INSERT INTO chado.feature_dbxref VALUES (10184, 10095, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10185, 10096, 10008, true);
INSERT INTO chado.feature_dbxref VALUES (10186, 10096, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10187, 10097, 10008, true);
INSERT INTO chado.feature_dbxref VALUES (10188, 10097, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10189, 10098, 10008, true);
INSERT INTO chado.feature_dbxref VALUES (10190, 10098, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10191, 10099, 10008, true);
INSERT INTO chado.feature_dbxref VALUES (10192, 10099, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10193, 10100, 10008, true);
INSERT INTO chado.feature_dbxref VALUES (10194, 10100, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10195, 10101, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10196, 10102, 10009, true);
INSERT INTO chado.feature_dbxref VALUES (10197, 10102, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10198, 10103, 10009, true);
INSERT INTO chado.feature_dbxref VALUES (10199, 10103, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10200, 10104, 10009, true);
INSERT INTO chado.feature_dbxref VALUES (10201, 10104, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10202, 10105, 10009, true);
INSERT INTO chado.feature_dbxref VALUES (10203, 10105, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10204, 10106, 10009, true);
INSERT INTO chado.feature_dbxref VALUES (10205, 10106, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10206, 10107, 10009, true);
INSERT INTO chado.feature_dbxref VALUES (10207, 10107, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10208, 10108, 10009, true);
INSERT INTO chado.feature_dbxref VALUES (10209, 10108, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10210, 10109, 10009, true);
INSERT INTO chado.feature_dbxref VALUES (10211, 10109, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10212, 10110, 10009, true);
INSERT INTO chado.feature_dbxref VALUES (10213, 10110, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10214, 10111, 10009, true);
INSERT INTO chado.feature_dbxref VALUES (10215, 10111, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10216, 10112, 10009, true);
INSERT INTO chado.feature_dbxref VALUES (10217, 10112, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10218, 10113, 10009, true);
INSERT INTO chado.feature_dbxref VALUES (10219, 10113, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10220, 10114, 10010, true);
INSERT INTO chado.feature_dbxref VALUES (10221, 10114, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10222, 10115, 10010, true);
INSERT INTO chado.feature_dbxref VALUES (10223, 10115, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10224, 10116, 10010, true);
INSERT INTO chado.feature_dbxref VALUES (10225, 10116, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10226, 10117, 10010, true);
INSERT INTO chado.feature_dbxref VALUES (10227, 10117, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10228, 10118, 10010, true);
INSERT INTO chado.feature_dbxref VALUES (10229, 10118, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10230, 10119, 10010, true);
INSERT INTO chado.feature_dbxref VALUES (10231, 10119, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10232, 10120, 10010, true);
INSERT INTO chado.feature_dbxref VALUES (10233, 10120, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10234, 10121, 10010, true);
INSERT INTO chado.feature_dbxref VALUES (10235, 10121, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10236, 10122, 10010, true);
INSERT INTO chado.feature_dbxref VALUES (10237, 10122, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10238, 10123, 10010, true);
INSERT INTO chado.feature_dbxref VALUES (10239, 10123, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10240, 10124, 10010, true);
INSERT INTO chado.feature_dbxref VALUES (10241, 10124, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10242, 10125, 10011, true);
INSERT INTO chado.feature_dbxref VALUES (10243, 10125, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10244, 10126, 10011, true);
INSERT INTO chado.feature_dbxref VALUES (10245, 10126, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10246, 10127, 10011, true);
INSERT INTO chado.feature_dbxref VALUES (10247, 10127, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10248, 10128, 10011, true);
INSERT INTO chado.feature_dbxref VALUES (10249, 10128, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10250, 10129, 10011, true);
INSERT INTO chado.feature_dbxref VALUES (10251, 10129, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10252, 10130, 10011, true);
INSERT INTO chado.feature_dbxref VALUES (10253, 10130, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10254, 10131, 10011, true);
INSERT INTO chado.feature_dbxref VALUES (10255, 10131, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10256, 10132, 10011, true);
INSERT INTO chado.feature_dbxref VALUES (10257, 10132, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10258, 10133, 10011, true);
INSERT INTO chado.feature_dbxref VALUES (10259, 10133, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10260, 10134, 10011, true);
INSERT INTO chado.feature_dbxref VALUES (10261, 10134, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10262, 10135, 10011, true);
INSERT INTO chado.feature_dbxref VALUES (10263, 10135, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10264, 10136, 10011, true);
INSERT INTO chado.feature_dbxref VALUES (10265, 10136, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10266, 10137, 10011, true);
INSERT INTO chado.feature_dbxref VALUES (10267, 10137, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10268, 10138, 10012, true);
INSERT INTO chado.feature_dbxref VALUES (10269, 10138, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10270, 10139, 10012, true);
INSERT INTO chado.feature_dbxref VALUES (10271, 10139, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10272, 10140, 10012, true);
INSERT INTO chado.feature_dbxref VALUES (10273, 10140, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10274, 10141, 10012, true);
INSERT INTO chado.feature_dbxref VALUES (10275, 10141, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10276, 10142, 10012, true);
INSERT INTO chado.feature_dbxref VALUES (10277, 10142, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10278, 10143, 10012, true);
INSERT INTO chado.feature_dbxref VALUES (10279, 10143, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10280, 10144, 10012, true);
INSERT INTO chado.feature_dbxref VALUES (10281, 10144, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10282, 10145, 10012, true);
INSERT INTO chado.feature_dbxref VALUES (10283, 10145, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10284, 10146, 10012, true);
INSERT INTO chado.feature_dbxref VALUES (10285, 10146, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10286, 10147, 10012, true);
INSERT INTO chado.feature_dbxref VALUES (10287, 10147, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10288, 10148, 10012, true);
INSERT INTO chado.feature_dbxref VALUES (10289, 10148, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10290, 10149, 10012, true);
INSERT INTO chado.feature_dbxref VALUES (10291, 10149, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10292, 10150, 10013, true);
INSERT INTO chado.feature_dbxref VALUES (10293, 10150, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10294, 10151, 10013, true);
INSERT INTO chado.feature_dbxref VALUES (10295, 10151, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10296, 10152, 10013, true);
INSERT INTO chado.feature_dbxref VALUES (10297, 10152, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10298, 10153, 10013, true);
INSERT INTO chado.feature_dbxref VALUES (10299, 10153, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10300, 10154, 10013, true);
INSERT INTO chado.feature_dbxref VALUES (10301, 10154, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10302, 10155, 10013, true);
INSERT INTO chado.feature_dbxref VALUES (10303, 10155, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10304, 10156, 10013, true);
INSERT INTO chado.feature_dbxref VALUES (10305, 10156, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10306, 10157, 10013, true);
INSERT INTO chado.feature_dbxref VALUES (10307, 10157, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10308, 10158, 10013, true);
INSERT INTO chado.feature_dbxref VALUES (10309, 10158, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10310, 10159, 10013, true);
INSERT INTO chado.feature_dbxref VALUES (10311, 10159, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10312, 10160, 10013, true);
INSERT INTO chado.feature_dbxref VALUES (10313, 10160, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10314, 10161, 10013, true);
INSERT INTO chado.feature_dbxref VALUES (10315, 10161, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10316, 10162, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10317, 10163, 10014, true);
INSERT INTO chado.feature_dbxref VALUES (10318, 10163, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10319, 10164, 10014, true);
INSERT INTO chado.feature_dbxref VALUES (10320, 10164, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10321, 10165, 10014, true);
INSERT INTO chado.feature_dbxref VALUES (10322, 10165, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10323, 10166, 10014, true);
INSERT INTO chado.feature_dbxref VALUES (10324, 10166, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10325, 10167, 10014, true);
INSERT INTO chado.feature_dbxref VALUES (10326, 10167, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10327, 10168, 10014, true);
INSERT INTO chado.feature_dbxref VALUES (10328, 10168, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10329, 10169, 10014, true);
INSERT INTO chado.feature_dbxref VALUES (10330, 10169, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10331, 10170, 10014, true);
INSERT INTO chado.feature_dbxref VALUES (10332, 10170, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10333, 10171, 10014, true);
INSERT INTO chado.feature_dbxref VALUES (10334, 10171, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10335, 10172, 10015, true);
INSERT INTO chado.feature_dbxref VALUES (10336, 10172, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10337, 10173, 10015, true);
INSERT INTO chado.feature_dbxref VALUES (10338, 10173, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10339, 10174, 10015, true);
INSERT INTO chado.feature_dbxref VALUES (10340, 10174, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10341, 10175, 10015, true);
INSERT INTO chado.feature_dbxref VALUES (10342, 10175, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10343, 10176, 10015, true);
INSERT INTO chado.feature_dbxref VALUES (10344, 10176, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10345, 10177, 10015, true);
INSERT INTO chado.feature_dbxref VALUES (10346, 10177, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10347, 10178, 10015, true);
INSERT INTO chado.feature_dbxref VALUES (10348, 10178, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10349, 10179, 10015, true);
INSERT INTO chado.feature_dbxref VALUES (10350, 10179, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10351, 10180, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10352, 10181, 10016, true);
INSERT INTO chado.feature_dbxref VALUES (10353, 10181, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10354, 10182, 10016, true);
INSERT INTO chado.feature_dbxref VALUES (10355, 10182, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10356, 10183, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10357, 10184, 10017, true);
INSERT INTO chado.feature_dbxref VALUES (10358, 10184, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10359, 10185, 10017, true);
INSERT INTO chado.feature_dbxref VALUES (10360, 10185, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10361, 10186, 10017, true);
INSERT INTO chado.feature_dbxref VALUES (10362, 10186, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10363, 10187, 10017, true);
INSERT INTO chado.feature_dbxref VALUES (10364, 10187, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10365, 10188, 10017, true);
INSERT INTO chado.feature_dbxref VALUES (10366, 10188, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10367, 10189, 10017, true);
INSERT INTO chado.feature_dbxref VALUES (10368, 10189, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10369, 10190, 10017, true);
INSERT INTO chado.feature_dbxref VALUES (10370, 10190, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10371, 10191, 10018, true);
INSERT INTO chado.feature_dbxref VALUES (10372, 10191, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10373, 10192, 10018, true);
INSERT INTO chado.feature_dbxref VALUES (10374, 10192, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10375, 10193, 10018, true);
INSERT INTO chado.feature_dbxref VALUES (10376, 10193, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10377, 10194, 10018, true);
INSERT INTO chado.feature_dbxref VALUES (10378, 10194, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10379, 10195, 10018, true);
INSERT INTO chado.feature_dbxref VALUES (10380, 10195, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10381, 10196, 10018, true);
INSERT INTO chado.feature_dbxref VALUES (10382, 10196, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10383, 10197, 10018, true);
INSERT INTO chado.feature_dbxref VALUES (10384, 10197, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10385, 10198, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10386, 10199, 10019, true);
INSERT INTO chado.feature_dbxref VALUES (10387, 10199, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10388, 10200, 10019, true);
INSERT INTO chado.feature_dbxref VALUES (10389, 10200, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10390, 10201, 10019, true);
INSERT INTO chado.feature_dbxref VALUES (10391, 10201, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10392, 10202, 10019, true);
INSERT INTO chado.feature_dbxref VALUES (10393, 10202, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10394, 10203, 10019, true);
INSERT INTO chado.feature_dbxref VALUES (10395, 10203, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10396, 10204, 10019, true);
INSERT INTO chado.feature_dbxref VALUES (10397, 10204, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10398, 10205, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10399, 10206, 10020, true);
INSERT INTO chado.feature_dbxref VALUES (10400, 10206, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10401, 10207, 10020, true);
INSERT INTO chado.feature_dbxref VALUES (10402, 10207, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10403, 10208, 10020, true);
INSERT INTO chado.feature_dbxref VALUES (10404, 10208, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10405, 10209, 10020, true);
INSERT INTO chado.feature_dbxref VALUES (10406, 10209, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10407, 10210, 10020, true);
INSERT INTO chado.feature_dbxref VALUES (10408, 10210, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10409, 10211, 10020, true);
INSERT INTO chado.feature_dbxref VALUES (10410, 10211, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10411, 10212, 10020, true);
INSERT INTO chado.feature_dbxref VALUES (10412, 10212, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10413, 10213, 10021, true);
INSERT INTO chado.feature_dbxref VALUES (10414, 10213, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10415, 10214, 10021, true);
INSERT INTO chado.feature_dbxref VALUES (10416, 10214, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10417, 10215, 10021, true);
INSERT INTO chado.feature_dbxref VALUES (10418, 10215, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10419, 10216, 10021, true);
INSERT INTO chado.feature_dbxref VALUES (10420, 10216, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10421, 10217, 10021, true);
INSERT INTO chado.feature_dbxref VALUES (10422, 10217, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10423, 10218, 10021, true);
INSERT INTO chado.feature_dbxref VALUES (10424, 10218, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10425, 10219, 10021, true);
INSERT INTO chado.feature_dbxref VALUES (10426, 10219, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10427, 10220, 10022, true);
INSERT INTO chado.feature_dbxref VALUES (10428, 10220, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10429, 10221, 10022, true);
INSERT INTO chado.feature_dbxref VALUES (10430, 10221, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10431, 10222, 10022, true);
INSERT INTO chado.feature_dbxref VALUES (10432, 10222, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10433, 10223, 10022, true);
INSERT INTO chado.feature_dbxref VALUES (10434, 10223, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10435, 10224, 10022, true);
INSERT INTO chado.feature_dbxref VALUES (10436, 10224, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10437, 10225, 10022, true);
INSERT INTO chado.feature_dbxref VALUES (10438, 10225, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10439, 10226, 10022, true);
INSERT INTO chado.feature_dbxref VALUES (10440, 10226, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10441, 10227, 10023, true);
INSERT INTO chado.feature_dbxref VALUES (10442, 10227, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10443, 10228, 10023, true);
INSERT INTO chado.feature_dbxref VALUES (10444, 10228, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10445, 10229, 10023, true);
INSERT INTO chado.feature_dbxref VALUES (10446, 10229, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10447, 10230, 10023, true);
INSERT INTO chado.feature_dbxref VALUES (10448, 10230, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10449, 10231, 10023, true);
INSERT INTO chado.feature_dbxref VALUES (10450, 10231, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10451, 10232, 10023, true);
INSERT INTO chado.feature_dbxref VALUES (10452, 10232, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10453, 10233, 10023, true);
INSERT INTO chado.feature_dbxref VALUES (10454, 10233, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10455, 10234, 10023, true);
INSERT INTO chado.feature_dbxref VALUES (10456, 10234, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10457, 10235, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10458, 10236, 10024, true);
INSERT INTO chado.feature_dbxref VALUES (10459, 10236, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10460, 10237, 10024, true);
INSERT INTO chado.feature_dbxref VALUES (10461, 10237, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10462, 10238, 10024, true);
INSERT INTO chado.feature_dbxref VALUES (10463, 10238, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10464, 10239, 10024, true);
INSERT INTO chado.feature_dbxref VALUES (10465, 10239, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10466, 10240, 10024, true);
INSERT INTO chado.feature_dbxref VALUES (10467, 10240, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10468, 10241, 10024, true);
INSERT INTO chado.feature_dbxref VALUES (10469, 10241, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10470, 10242, 10024, true);
INSERT INTO chado.feature_dbxref VALUES (10471, 10242, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10472, 10243, 10025, true);
INSERT INTO chado.feature_dbxref VALUES (10473, 10243, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10474, 10244, 10025, true);
INSERT INTO chado.feature_dbxref VALUES (10475, 10244, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10476, 10245, 10025, true);
INSERT INTO chado.feature_dbxref VALUES (10477, 10245, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10478, 10246, 10025, true);
INSERT INTO chado.feature_dbxref VALUES (10479, 10246, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10480, 10247, 10025, true);
INSERT INTO chado.feature_dbxref VALUES (10481, 10247, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10482, 10248, 10025, true);
INSERT INTO chado.feature_dbxref VALUES (10483, 10248, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10484, 10249, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10485, 10250, 10026, true);
INSERT INTO chado.feature_dbxref VALUES (10486, 10250, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10487, 10251, 10026, true);
INSERT INTO chado.feature_dbxref VALUES (10488, 10251, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10489, 10252, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10490, 10253, 10027, true);
INSERT INTO chado.feature_dbxref VALUES (10491, 10253, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10492, 10254, 10027, true);
INSERT INTO chado.feature_dbxref VALUES (10493, 10254, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10494, 10255, 10027, true);
INSERT INTO chado.feature_dbxref VALUES (10495, 10255, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10496, 10256, 10027, true);
INSERT INTO chado.feature_dbxref VALUES (10497, 10256, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10498, 10257, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10499, 10258, 10028, true);
INSERT INTO chado.feature_dbxref VALUES (10500, 10258, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10501, 10259, 10028, true);
INSERT INTO chado.feature_dbxref VALUES (10502, 10259, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10503, 10260, 10028, true);
INSERT INTO chado.feature_dbxref VALUES (10504, 10260, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10505, 10261, 10028, true);
INSERT INTO chado.feature_dbxref VALUES (10506, 10261, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10507, 10262, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10508, 10263, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10509, 10263, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10510, 10264, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10511, 10264, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10512, 10265, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10513, 10265, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10514, 10266, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10515, 10266, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10516, 10267, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10517, 10267, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10518, 10268, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10519, 10268, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10520, 10269, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10521, 10269, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10522, 10270, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10523, 10270, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10524, 10271, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10525, 10271, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10526, 10272, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10527, 10272, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10528, 10273, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10529, 10273, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10530, 10274, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10531, 10274, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10532, 10275, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10533, 10275, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10534, 10276, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10535, 10276, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10536, 10277, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10537, 10277, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10538, 10278, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10539, 10278, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10540, 10279, 10029, true);
INSERT INTO chado.feature_dbxref VALUES (10541, 10279, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10542, 10280, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10543, 10280, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10544, 10281, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10545, 10281, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10546, 10282, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10547, 10282, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10548, 10283, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10549, 10283, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10550, 10284, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10551, 10284, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10552, 10285, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10553, 10285, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10554, 10286, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10555, 10286, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10556, 10287, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10557, 10287, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10558, 10288, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10559, 10288, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10560, 10289, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10561, 10289, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10562, 10290, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10563, 10290, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10564, 10291, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10565, 10291, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10566, 10292, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10567, 10292, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10568, 10293, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10569, 10293, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10570, 10294, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10571, 10294, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10572, 10295, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10573, 10295, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10574, 10296, 10030, true);
INSERT INTO chado.feature_dbxref VALUES (10575, 10296, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10576, 10297, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10577, 10297, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10578, 10298, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10579, 10298, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10580, 10299, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10581, 10299, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10582, 10300, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10583, 10300, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10584, 10301, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10585, 10301, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10586, 10302, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10587, 10302, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10588, 10303, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10589, 10303, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10590, 10304, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10591, 10304, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10592, 10305, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10593, 10305, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10594, 10306, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10595, 10306, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10596, 10307, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10597, 10307, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10598, 10308, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10599, 10308, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10600, 10309, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10601, 10309, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10602, 10310, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10603, 10310, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10604, 10311, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10605, 10311, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10606, 10312, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10607, 10312, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10608, 10313, 10031, true);
INSERT INTO chado.feature_dbxref VALUES (10609, 10313, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10610, 10314, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10611, 10315, 10032, true);
INSERT INTO chado.feature_dbxref VALUES (10612, 10315, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10613, 10316, 10032, true);
INSERT INTO chado.feature_dbxref VALUES (10614, 10316, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10615, 10317, 10032, true);
INSERT INTO chado.feature_dbxref VALUES (10616, 10317, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10617, 10318, 10032, true);
INSERT INTO chado.feature_dbxref VALUES (10618, 10318, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10619, 10319, 10032, true);
INSERT INTO chado.feature_dbxref VALUES (10620, 10319, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10621, 10320, 10032, true);
INSERT INTO chado.feature_dbxref VALUES (10622, 10320, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10623, 10321, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10624, 10322, 10033, true);
INSERT INTO chado.feature_dbxref VALUES (10625, 10322, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10626, 10323, 10033, true);
INSERT INTO chado.feature_dbxref VALUES (10627, 10323, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10628, 10324, 10033, true);
INSERT INTO chado.feature_dbxref VALUES (10629, 10324, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10630, 10325, 10033, true);
INSERT INTO chado.feature_dbxref VALUES (10631, 10325, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10632, 10326, 10033, true);
INSERT INTO chado.feature_dbxref VALUES (10633, 10326, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10634, 10327, 10033, true);
INSERT INTO chado.feature_dbxref VALUES (10635, 10327, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10636, 10328, 10033, true);
INSERT INTO chado.feature_dbxref VALUES (10637, 10328, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10638, 10329, 10033, true);
INSERT INTO chado.feature_dbxref VALUES (10639, 10329, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10640, 10330, 10033, true);
INSERT INTO chado.feature_dbxref VALUES (10641, 10330, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10642, 10331, 10034, true);
INSERT INTO chado.feature_dbxref VALUES (10643, 10331, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10644, 10332, 10034, true);
INSERT INTO chado.feature_dbxref VALUES (10645, 10332, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10646, 10333, 10034, true);
INSERT INTO chado.feature_dbxref VALUES (10647, 10333, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10648, 10334, 10034, true);
INSERT INTO chado.feature_dbxref VALUES (10649, 10334, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10650, 10335, 10034, true);
INSERT INTO chado.feature_dbxref VALUES (10651, 10335, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10652, 10336, 10034, true);
INSERT INTO chado.feature_dbxref VALUES (10653, 10336, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10654, 10337, 10034, true);
INSERT INTO chado.feature_dbxref VALUES (10655, 10337, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10656, 10338, 10034, true);
INSERT INTO chado.feature_dbxref VALUES (10657, 10338, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10658, 10339, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10659, 10340, 10035, true);
INSERT INTO chado.feature_dbxref VALUES (10660, 10340, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10661, 10341, 10035, true);
INSERT INTO chado.feature_dbxref VALUES (10662, 10341, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10663, 10342, 10035, true);
INSERT INTO chado.feature_dbxref VALUES (10664, 10342, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10665, 10343, 10035, true);
INSERT INTO chado.feature_dbxref VALUES (10666, 10343, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10667, 10344, 10035, true);
INSERT INTO chado.feature_dbxref VALUES (10668, 10344, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10669, 10345, 10035, true);
INSERT INTO chado.feature_dbxref VALUES (10670, 10345, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10671, 10346, 10036, true);
INSERT INTO chado.feature_dbxref VALUES (10672, 10346, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10673, 10347, 10036, true);
INSERT INTO chado.feature_dbxref VALUES (10674, 10347, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10675, 10348, 10036, true);
INSERT INTO chado.feature_dbxref VALUES (10676, 10348, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10677, 10349, 10036, true);
INSERT INTO chado.feature_dbxref VALUES (10678, 10349, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10679, 10350, 10036, true);
INSERT INTO chado.feature_dbxref VALUES (10680, 10350, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10681, 10351, 10036, true);
INSERT INTO chado.feature_dbxref VALUES (10682, 10351, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10683, 10352, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10684, 10353, 10037, true);
INSERT INTO chado.feature_dbxref VALUES (10685, 10353, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10686, 10354, 10037, true);
INSERT INTO chado.feature_dbxref VALUES (10687, 10354, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10688, 10355, 10037, true);
INSERT INTO chado.feature_dbxref VALUES (10689, 10355, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10690, 10356, 10037, true);
INSERT INTO chado.feature_dbxref VALUES (10691, 10356, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10692, 10357, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10693, 10358, 10038, true);
INSERT INTO chado.feature_dbxref VALUES (10694, 10358, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10695, 10359, 10038, true);
INSERT INTO chado.feature_dbxref VALUES (10696, 10359, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10697, 10360, 10038, true);
INSERT INTO chado.feature_dbxref VALUES (10698, 10360, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10699, 10361, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10700, 10362, 10039, true);
INSERT INTO chado.feature_dbxref VALUES (10701, 10362, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10702, 10363, 10039, true);
INSERT INTO chado.feature_dbxref VALUES (10703, 10363, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10704, 10364, 10039, true);
INSERT INTO chado.feature_dbxref VALUES (10705, 10364, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10706, 10365, 10039, true);
INSERT INTO chado.feature_dbxref VALUES (10707, 10365, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10708, 10366, 10039, true);
INSERT INTO chado.feature_dbxref VALUES (10709, 10366, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10710, 10367, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10711, 10368, 10040, true);
INSERT INTO chado.feature_dbxref VALUES (10712, 10368, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10713, 10369, 10040, true);
INSERT INTO chado.feature_dbxref VALUES (10714, 10369, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10715, 10370, 10040, true);
INSERT INTO chado.feature_dbxref VALUES (10716, 10370, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10717, 10371, 10040, true);
INSERT INTO chado.feature_dbxref VALUES (10718, 10371, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10719, 10372, 10040, true);
INSERT INTO chado.feature_dbxref VALUES (10720, 10372, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10721, 10373, 10040, true);
INSERT INTO chado.feature_dbxref VALUES (10722, 10373, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10723, 10374, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10724, 10375, 10041, true);
INSERT INTO chado.feature_dbxref VALUES (10725, 10375, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10726, 10376, 10041, true);
INSERT INTO chado.feature_dbxref VALUES (10727, 10376, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10728, 10377, 10041, true);
INSERT INTO chado.feature_dbxref VALUES (10729, 10377, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10730, 10378, 10041, true);
INSERT INTO chado.feature_dbxref VALUES (10731, 10378, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10732, 10379, 10041, true);
INSERT INTO chado.feature_dbxref VALUES (10733, 10379, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10734, 10380, 10041, true);
INSERT INTO chado.feature_dbxref VALUES (10735, 10380, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10736, 10381, 10041, true);
INSERT INTO chado.feature_dbxref VALUES (10737, 10381, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10738, 10382, 10041, true);
INSERT INTO chado.feature_dbxref VALUES (10739, 10382, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10740, 10383, 10041, true);
INSERT INTO chado.feature_dbxref VALUES (10741, 10383, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10742, 10384, 10041, true);
INSERT INTO chado.feature_dbxref VALUES (10743, 10384, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10744, 10385, 10041, true);
INSERT INTO chado.feature_dbxref VALUES (10745, 10385, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10746, 10386, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10747, 10387, 10042, true);
INSERT INTO chado.feature_dbxref VALUES (10748, 10387, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10749, 10388, 10042, true);
INSERT INTO chado.feature_dbxref VALUES (10750, 10388, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10751, 10389, 10042, true);
INSERT INTO chado.feature_dbxref VALUES (10752, 10389, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10753, 10390, 10042, true);
INSERT INTO chado.feature_dbxref VALUES (10754, 10390, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10755, 10391, 10042, true);
INSERT INTO chado.feature_dbxref VALUES (10756, 10391, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10757, 10392, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10758, 10393, 10043, true);
INSERT INTO chado.feature_dbxref VALUES (10759, 10393, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10760, 10394, 10043, true);
INSERT INTO chado.feature_dbxref VALUES (10761, 10394, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10762, 10395, 10043, true);
INSERT INTO chado.feature_dbxref VALUES (10763, 10395, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10764, 10396, 10043, true);
INSERT INTO chado.feature_dbxref VALUES (10765, 10396, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10766, 10397, 10043, true);
INSERT INTO chado.feature_dbxref VALUES (10767, 10397, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10768, 10398, 10043, true);
INSERT INTO chado.feature_dbxref VALUES (10769, 10398, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10770, 10399, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10771, 10400, 10044, true);
INSERT INTO chado.feature_dbxref VALUES (10772, 10400, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10773, 10401, 10044, true);
INSERT INTO chado.feature_dbxref VALUES (10774, 10401, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10775, 10402, 10044, true);
INSERT INTO chado.feature_dbxref VALUES (10776, 10402, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10777, 10403, 10044, true);
INSERT INTO chado.feature_dbxref VALUES (10778, 10403, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10779, 10404, 10044, true);
INSERT INTO chado.feature_dbxref VALUES (10780, 10404, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10781, 10405, 10045, true);
INSERT INTO chado.feature_dbxref VALUES (10782, 10405, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10783, 10406, 10045, true);
INSERT INTO chado.feature_dbxref VALUES (10784, 10406, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10785, 10407, 10045, true);
INSERT INTO chado.feature_dbxref VALUES (10786, 10407, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10787, 10408, 10045, true);
INSERT INTO chado.feature_dbxref VALUES (10788, 10408, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10789, 10409, 10045, true);
INSERT INTO chado.feature_dbxref VALUES (10790, 10409, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10791, 10410, 10046, true);
INSERT INTO chado.feature_dbxref VALUES (10792, 10410, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10793, 10411, 10046, true);
INSERT INTO chado.feature_dbxref VALUES (10794, 10411, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10795, 10412, 10046, true);
INSERT INTO chado.feature_dbxref VALUES (10796, 10412, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10797, 10413, 10046, true);
INSERT INTO chado.feature_dbxref VALUES (10798, 10413, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10799, 10414, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10800, 10415, 10047, true);
INSERT INTO chado.feature_dbxref VALUES (10801, 10415, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10802, 10416, 10047, true);
INSERT INTO chado.feature_dbxref VALUES (10803, 10416, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10804, 10417, 10047, true);
INSERT INTO chado.feature_dbxref VALUES (10805, 10417, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10806, 10418, 10047, true);
INSERT INTO chado.feature_dbxref VALUES (10807, 10418, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10808, 10419, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10809, 10420, 10048, true);
INSERT INTO chado.feature_dbxref VALUES (10810, 10420, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10811, 10421, 10048, true);
INSERT INTO chado.feature_dbxref VALUES (10812, 10421, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10813, 10422, 10048, true);
INSERT INTO chado.feature_dbxref VALUES (10814, 10422, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10815, 10423, 10048, true);
INSERT INTO chado.feature_dbxref VALUES (10816, 10423, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10817, 10424, 10049, true);
INSERT INTO chado.feature_dbxref VALUES (10818, 10424, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10819, 10425, 10049, true);
INSERT INTO chado.feature_dbxref VALUES (10820, 10425, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10821, 10426, 10049, true);
INSERT INTO chado.feature_dbxref VALUES (10822, 10426, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10823, 10427, 10049, true);
INSERT INTO chado.feature_dbxref VALUES (10824, 10427, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10825, 10428, 10049, true);
INSERT INTO chado.feature_dbxref VALUES (10826, 10428, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10827, 10429, 10050, true);
INSERT INTO chado.feature_dbxref VALUES (10828, 10429, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10829, 10430, 10050, true);
INSERT INTO chado.feature_dbxref VALUES (10830, 10430, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10831, 10431, 10050, true);
INSERT INTO chado.feature_dbxref VALUES (10832, 10431, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10833, 10432, 10050, true);
INSERT INTO chado.feature_dbxref VALUES (10834, 10432, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10835, 10433, 10050, true);
INSERT INTO chado.feature_dbxref VALUES (10836, 10433, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10837, 10434, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10838, 10435, 10051, true);
INSERT INTO chado.feature_dbxref VALUES (10839, 10435, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10840, 10436, 10051, true);
INSERT INTO chado.feature_dbxref VALUES (10841, 10436, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10842, 10437, 10051, true);
INSERT INTO chado.feature_dbxref VALUES (10843, 10437, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10844, 10438, 10051, true);
INSERT INTO chado.feature_dbxref VALUES (10845, 10438, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10846, 10439, 10051, true);
INSERT INTO chado.feature_dbxref VALUES (10847, 10439, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10848, 10440, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10849, 10441, 10052, true);
INSERT INTO chado.feature_dbxref VALUES (10850, 10441, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10851, 10442, 10052, true);
INSERT INTO chado.feature_dbxref VALUES (10852, 10442, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10853, 10443, 10052, true);
INSERT INTO chado.feature_dbxref VALUES (10854, 10443, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10855, 10444, 10052, true);
INSERT INTO chado.feature_dbxref VALUES (10856, 10444, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10857, 10445, 10052, true);
INSERT INTO chado.feature_dbxref VALUES (10858, 10445, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10859, 10446, 10053, true);
INSERT INTO chado.feature_dbxref VALUES (10860, 10446, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10861, 10447, 10053, true);
INSERT INTO chado.feature_dbxref VALUES (10862, 10447, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10863, 10448, 10053, true);
INSERT INTO chado.feature_dbxref VALUES (10864, 10448, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10865, 10449, 10053, true);
INSERT INTO chado.feature_dbxref VALUES (10866, 10449, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10867, 10450, 10053, true);
INSERT INTO chado.feature_dbxref VALUES (10868, 10450, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10869, 10451, 10053, true);
INSERT INTO chado.feature_dbxref VALUES (10870, 10451, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10871, 10452, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10872, 10453, 10054, true);
INSERT INTO chado.feature_dbxref VALUES (10873, 10453, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10874, 10454, 10054, true);
INSERT INTO chado.feature_dbxref VALUES (10875, 10454, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10876, 10455, 10054, true);
INSERT INTO chado.feature_dbxref VALUES (10877, 10455, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10878, 10456, 10054, true);
INSERT INTO chado.feature_dbxref VALUES (10879, 10456, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10880, 10457, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10881, 10458, 10055, true);
INSERT INTO chado.feature_dbxref VALUES (10882, 10458, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10883, 10459, 10055, true);
INSERT INTO chado.feature_dbxref VALUES (10884, 10459, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10885, 10460, 10055, true);
INSERT INTO chado.feature_dbxref VALUES (10886, 10460, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10887, 10461, 10055, true);
INSERT INTO chado.feature_dbxref VALUES (10888, 10461, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10889, 10462, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10890, 10463, 10056, true);
INSERT INTO chado.feature_dbxref VALUES (10891, 10463, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10892, 10464, 10056, true);
INSERT INTO chado.feature_dbxref VALUES (10893, 10464, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10894, 10465, 10056, true);
INSERT INTO chado.feature_dbxref VALUES (10895, 10465, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10896, 10466, 10056, true);
INSERT INTO chado.feature_dbxref VALUES (10897, 10466, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10898, 10467, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10899, 10468, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10900, 10468, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10901, 10469, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10902, 10469, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10903, 10470, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10904, 10470, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10905, 10471, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10906, 10471, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10907, 10472, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10908, 10472, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10909, 10473, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10910, 10473, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10911, 10474, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10912, 10474, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10913, 10475, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10914, 10475, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10915, 10476, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10916, 10476, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10917, 10477, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10918, 10477, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10919, 10478, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10920, 10478, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10921, 10479, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10922, 10479, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10923, 10480, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10924, 10480, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10925, 10481, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10926, 10481, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10927, 10482, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10928, 10482, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10929, 10483, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10930, 10483, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10931, 10484, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10932, 10484, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10933, 10485, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10934, 10485, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10935, 10486, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10936, 10486, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10937, 10487, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10938, 10487, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10939, 10488, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10940, 10488, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10941, 10489, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10942, 10489, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10943, 10490, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10944, 10490, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10945, 10491, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10946, 10491, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10947, 10492, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10948, 10492, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10949, 10493, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10950, 10493, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10951, 10494, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10952, 10494, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10953, 10495, 10057, true);
INSERT INTO chado.feature_dbxref VALUES (10954, 10495, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10955, 10496, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10956, 10496, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10957, 10497, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10958, 10497, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10959, 10498, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10960, 10498, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10961, 10499, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10962, 10499, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10963, 10500, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10964, 10500, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10965, 10501, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10966, 10501, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10967, 10502, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10968, 10502, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10969, 10503, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10970, 10503, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10971, 10504, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10972, 10504, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10973, 10505, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10974, 10505, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10975, 10506, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10976, 10506, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10977, 10507, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10978, 10507, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10979, 10508, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10980, 10508, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10981, 10509, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10982, 10509, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10983, 10510, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10984, 10510, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10985, 10511, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10986, 10511, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10987, 10512, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10988, 10512, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10989, 10513, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10990, 10513, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10991, 10514, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10992, 10514, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10993, 10515, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10994, 10515, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10995, 10516, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10996, 10516, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10997, 10517, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (10998, 10517, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (10999, 10518, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (11000, 10518, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11001, 10519, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (11002, 10519, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11003, 10520, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (11004, 10520, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11005, 10521, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (11006, 10521, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11007, 10522, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (11008, 10522, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11009, 10523, 10058, true);
INSERT INTO chado.feature_dbxref VALUES (11010, 10523, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11011, 10524, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11012, 10525, 10059, true);
INSERT INTO chado.feature_dbxref VALUES (11013, 10525, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11014, 10526, 10059, true);
INSERT INTO chado.feature_dbxref VALUES (11015, 10526, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11016, 10527, 10059, true);
INSERT INTO chado.feature_dbxref VALUES (11017, 10527, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11018, 10528, 10059, true);
INSERT INTO chado.feature_dbxref VALUES (11019, 10528, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11020, 10529, 10059, true);
INSERT INTO chado.feature_dbxref VALUES (11021, 10529, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11022, 10530, 10059, true);
INSERT INTO chado.feature_dbxref VALUES (11023, 10530, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11024, 10531, 10059, true);
INSERT INTO chado.feature_dbxref VALUES (11025, 10531, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11026, 10532, 10059, true);
INSERT INTO chado.feature_dbxref VALUES (11027, 10532, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11028, 10533, 10059, true);
INSERT INTO chado.feature_dbxref VALUES (11029, 10533, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11030, 10534, 10059, true);
INSERT INTO chado.feature_dbxref VALUES (11031, 10534, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11032, 10535, 10059, true);
INSERT INTO chado.feature_dbxref VALUES (11033, 10535, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11034, 10536, 10059, true);
INSERT INTO chado.feature_dbxref VALUES (11035, 10536, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11036, 10537, 10060, true);
INSERT INTO chado.feature_dbxref VALUES (11037, 10537, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11038, 10538, 10060, true);
INSERT INTO chado.feature_dbxref VALUES (11039, 10538, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11040, 10539, 10060, true);
INSERT INTO chado.feature_dbxref VALUES (11041, 10539, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11042, 10540, 10060, true);
INSERT INTO chado.feature_dbxref VALUES (11043, 10540, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11044, 10541, 10060, true);
INSERT INTO chado.feature_dbxref VALUES (11045, 10541, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11046, 10542, 10060, true);
INSERT INTO chado.feature_dbxref VALUES (11047, 10542, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11048, 10543, 10060, true);
INSERT INTO chado.feature_dbxref VALUES (11049, 10543, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11050, 10544, 10060, true);
INSERT INTO chado.feature_dbxref VALUES (11051, 10544, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11052, 10545, 10060, true);
INSERT INTO chado.feature_dbxref VALUES (11053, 10545, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11054, 10546, 10060, true);
INSERT INTO chado.feature_dbxref VALUES (11055, 10546, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11056, 10547, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11057, 10548, 10061, true);
INSERT INTO chado.feature_dbxref VALUES (11058, 10548, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11059, 10549, 10061, true);
INSERT INTO chado.feature_dbxref VALUES (11060, 10549, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11061, 10550, 10061, true);
INSERT INTO chado.feature_dbxref VALUES (11062, 10550, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11063, 10551, 10061, true);
INSERT INTO chado.feature_dbxref VALUES (11064, 10551, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11065, 10552, 10061, true);
INSERT INTO chado.feature_dbxref VALUES (11066, 10552, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11067, 10553, 10061, true);
INSERT INTO chado.feature_dbxref VALUES (11068, 10553, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11069, 10554, 10061, true);
INSERT INTO chado.feature_dbxref VALUES (11070, 10554, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11071, 10555, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11072, 10556, 10062, true);
INSERT INTO chado.feature_dbxref VALUES (11073, 10556, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11074, 10557, 10062, true);
INSERT INTO chado.feature_dbxref VALUES (11075, 10557, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11076, 10558, 10062, true);
INSERT INTO chado.feature_dbxref VALUES (11077, 10558, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11078, 10559, 10062, true);
INSERT INTO chado.feature_dbxref VALUES (11079, 10559, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11080, 10560, 10062, true);
INSERT INTO chado.feature_dbxref VALUES (11081, 10560, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11082, 10561, 10062, true);
INSERT INTO chado.feature_dbxref VALUES (11083, 10561, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11084, 10562, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11085, 10563, 10063, true);
INSERT INTO chado.feature_dbxref VALUES (11086, 10563, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11087, 10564, 10063, true);
INSERT INTO chado.feature_dbxref VALUES (11088, 10564, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11089, 10565, 10063, true);
INSERT INTO chado.feature_dbxref VALUES (11090, 10565, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11091, 10566, 10063, true);
INSERT INTO chado.feature_dbxref VALUES (11092, 10566, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11093, 10567, 10063, true);
INSERT INTO chado.feature_dbxref VALUES (11094, 10567, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11095, 10568, 10063, true);
INSERT INTO chado.feature_dbxref VALUES (11096, 10568, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11097, 10569, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11098, 10570, 10064, true);
INSERT INTO chado.feature_dbxref VALUES (11099, 10570, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11100, 10571, 10064, true);
INSERT INTO chado.feature_dbxref VALUES (11101, 10571, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11102, 10572, 10064, true);
INSERT INTO chado.feature_dbxref VALUES (11103, 10572, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11104, 10573, 10064, true);
INSERT INTO chado.feature_dbxref VALUES (11105, 10573, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11106, 10574, 10064, true);
INSERT INTO chado.feature_dbxref VALUES (11107, 10574, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11108, 10575, 10064, true);
INSERT INTO chado.feature_dbxref VALUES (11109, 10575, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11110, 10576, 10064, true);
INSERT INTO chado.feature_dbxref VALUES (11111, 10576, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11112, 10577, 10064, true);
INSERT INTO chado.feature_dbxref VALUES (11113, 10577, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11114, 10578, 10064, true);
INSERT INTO chado.feature_dbxref VALUES (11115, 10578, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11116, 10579, 10064, true);
INSERT INTO chado.feature_dbxref VALUES (11117, 10579, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11118, 10580, 10064, true);
INSERT INTO chado.feature_dbxref VALUES (11119, 10580, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11120, 10581, 10064, true);
INSERT INTO chado.feature_dbxref VALUES (11121, 10581, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11122, 10582, 10064, true);
INSERT INTO chado.feature_dbxref VALUES (11123, 10582, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11124, 10583, 10065, true);
INSERT INTO chado.feature_dbxref VALUES (11125, 10583, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11126, 10584, 10065, true);
INSERT INTO chado.feature_dbxref VALUES (11127, 10584, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11128, 10585, 10065, true);
INSERT INTO chado.feature_dbxref VALUES (11129, 10585, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11130, 10586, 10065, true);
INSERT INTO chado.feature_dbxref VALUES (11131, 10586, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11132, 10587, 10065, true);
INSERT INTO chado.feature_dbxref VALUES (11133, 10587, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11134, 10588, 10065, true);
INSERT INTO chado.feature_dbxref VALUES (11135, 10588, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11136, 10589, 10065, true);
INSERT INTO chado.feature_dbxref VALUES (11137, 10589, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11138, 10590, 10065, true);
INSERT INTO chado.feature_dbxref VALUES (11139, 10590, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11140, 10591, 10065, true);
INSERT INTO chado.feature_dbxref VALUES (11141, 10591, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11142, 10592, 10065, true);
INSERT INTO chado.feature_dbxref VALUES (11143, 10592, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11144, 10593, 10065, true);
INSERT INTO chado.feature_dbxref VALUES (11145, 10593, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11146, 10594, 10065, true);
INSERT INTO chado.feature_dbxref VALUES (11147, 10594, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11148, 10595, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11149, 10596, 10066, true);
INSERT INTO chado.feature_dbxref VALUES (11150, 10596, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11151, 10597, 10066, true);
INSERT INTO chado.feature_dbxref VALUES (11152, 10597, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11153, 10598, 10066, true);
INSERT INTO chado.feature_dbxref VALUES (11154, 10598, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11155, 10599, 10066, true);
INSERT INTO chado.feature_dbxref VALUES (11156, 10599, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11157, 10600, 10066, true);
INSERT INTO chado.feature_dbxref VALUES (11158, 10600, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11159, 10601, 10066, true);
INSERT INTO chado.feature_dbxref VALUES (11160, 10601, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11161, 10602, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11162, 10603, 10067, true);
INSERT INTO chado.feature_dbxref VALUES (11163, 10603, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11164, 10604, 10067, true);
INSERT INTO chado.feature_dbxref VALUES (11165, 10604, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11166, 10605, 10067, true);
INSERT INTO chado.feature_dbxref VALUES (11167, 10605, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11168, 10606, 10067, true);
INSERT INTO chado.feature_dbxref VALUES (11169, 10606, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11170, 10607, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11171, 10608, 10068, true);
INSERT INTO chado.feature_dbxref VALUES (11172, 10608, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11173, 10609, 10068, true);
INSERT INTO chado.feature_dbxref VALUES (11174, 10609, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11175, 10610, 10068, true);
INSERT INTO chado.feature_dbxref VALUES (11176, 10610, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11177, 10611, 10068, true);
INSERT INTO chado.feature_dbxref VALUES (11178, 10611, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11179, 10612, 10068, true);
INSERT INTO chado.feature_dbxref VALUES (11180, 10612, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11181, 10613, 10068, true);
INSERT INTO chado.feature_dbxref VALUES (11182, 10613, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11183, 10614, 10068, true);
INSERT INTO chado.feature_dbxref VALUES (11184, 10614, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11185, 10615, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11186, 10616, 10069, true);
INSERT INTO chado.feature_dbxref VALUES (11187, 10616, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11188, 10617, 10069, true);
INSERT INTO chado.feature_dbxref VALUES (11189, 10617, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11190, 10618, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11191, 10619, 10070, true);
INSERT INTO chado.feature_dbxref VALUES (11192, 10619, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11193, 10620, 10070, true);
INSERT INTO chado.feature_dbxref VALUES (11194, 10620, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11195, 10621, 10070, true);
INSERT INTO chado.feature_dbxref VALUES (11196, 10621, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11197, 10622, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11198, 10623, 10071, true);
INSERT INTO chado.feature_dbxref VALUES (11199, 10623, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11200, 10624, 10071, true);
INSERT INTO chado.feature_dbxref VALUES (11201, 10624, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11202, 10625, 10071, true);
INSERT INTO chado.feature_dbxref VALUES (11203, 10625, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11204, 10626, 10071, true);
INSERT INTO chado.feature_dbxref VALUES (11205, 10626, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11206, 10627, 10071, true);
INSERT INTO chado.feature_dbxref VALUES (11207, 10627, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11208, 10628, 10071, true);
INSERT INTO chado.feature_dbxref VALUES (11209, 10628, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11210, 10629, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11211, 10630, 10072, true);
INSERT INTO chado.feature_dbxref VALUES (11212, 10630, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11213, 10631, 10072, true);
INSERT INTO chado.feature_dbxref VALUES (11214, 10631, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11215, 10632, 10072, true);
INSERT INTO chado.feature_dbxref VALUES (11216, 10632, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11217, 10633, 10072, true);
INSERT INTO chado.feature_dbxref VALUES (11218, 10633, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11219, 10634, 10072, true);
INSERT INTO chado.feature_dbxref VALUES (11220, 10634, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11221, 10635, 10072, true);
INSERT INTO chado.feature_dbxref VALUES (11222, 10635, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11223, 10636, 10072, true);
INSERT INTO chado.feature_dbxref VALUES (11224, 10636, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11225, 10637, 10072, true);
INSERT INTO chado.feature_dbxref VALUES (11226, 10637, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11227, 10638, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11228, 10639, 10073, true);
INSERT INTO chado.feature_dbxref VALUES (11229, 10639, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11230, 10640, 10073, true);
INSERT INTO chado.feature_dbxref VALUES (11231, 10640, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11232, 10641, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11233, 10642, 10074, true);
INSERT INTO chado.feature_dbxref VALUES (11234, 10642, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11235, 10643, 10074, true);
INSERT INTO chado.feature_dbxref VALUES (11236, 10643, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11237, 10644, 10074, true);
INSERT INTO chado.feature_dbxref VALUES (11238, 10644, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11239, 10645, 10074, true);
INSERT INTO chado.feature_dbxref VALUES (11240, 10645, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11241, 10646, 10075, true);
INSERT INTO chado.feature_dbxref VALUES (11242, 10646, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11243, 10647, 10075, true);
INSERT INTO chado.feature_dbxref VALUES (11244, 10647, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11245, 10648, 10075, true);
INSERT INTO chado.feature_dbxref VALUES (11246, 10648, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11247, 10649, 10075, true);
INSERT INTO chado.feature_dbxref VALUES (11248, 10649, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11249, 10650, 10075, true);
INSERT INTO chado.feature_dbxref VALUES (11250, 10650, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11251, 10651, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11252, 10652, 10076, true);
INSERT INTO chado.feature_dbxref VALUES (11253, 10652, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11254, 10653, 10076, true);
INSERT INTO chado.feature_dbxref VALUES (11255, 10653, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11256, 10654, 10076, true);
INSERT INTO chado.feature_dbxref VALUES (11257, 10654, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11258, 10655, 10076, true);
INSERT INTO chado.feature_dbxref VALUES (11259, 10655, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11260, 10656, 10076, true);
INSERT INTO chado.feature_dbxref VALUES (11261, 10656, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11262, 10657, 10076, true);
INSERT INTO chado.feature_dbxref VALUES (11263, 10657, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11264, 10658, 10076, true);
INSERT INTO chado.feature_dbxref VALUES (11265, 10658, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11266, 10659, 10076, true);
INSERT INTO chado.feature_dbxref VALUES (11267, 10659, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11268, 10660, 10076, true);
INSERT INTO chado.feature_dbxref VALUES (11269, 10660, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11270, 10661, 10076, true);
INSERT INTO chado.feature_dbxref VALUES (11271, 10661, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11272, 10662, 10076, true);
INSERT INTO chado.feature_dbxref VALUES (11273, 10662, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11274, 10663, 10076, true);
INSERT INTO chado.feature_dbxref VALUES (11275, 10663, 10001, true);
INSERT INTO chado.feature_dbxref VALUES (11276, 10664, 10076, true);
INSERT INTO chado.feature_dbxref VALUES (11277, 10664, 10001, true);

INSERT INTO chado.feature_relationship VALUES (100000, 10002, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100001, 10003, 10002, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100002, 10004, 10002, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100003, 10665, 10002, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100004, 10005, 10002, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100005, 10006, 10002, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100006, 10007, 10002, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100007, 10008, 10002, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100008, 10009, 10002, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100009, 10010, 10002, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100010, 10012, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100011, 10025, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100012, 10013, 10012, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 11);
INSERT INTO chado.feature_relationship VALUES (100013, 10014, 10012, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 12);
INSERT INTO chado.feature_relationship VALUES (100014, 10015, 10012, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100015, 10016, 10012, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100016, 10017, 10012, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100017, 10018, 10012, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100018, 10019, 10012, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100019, 10020, 10012, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100020, 10021, 10012, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100021, 10022, 10012, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100022, 10023, 10012, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100023, 10666, 10012, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100024, 10024, 10012, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100025, 10026, 10025, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100026, 10027, 10025, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100027, 10028, 10025, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100028, 10029, 10025, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100029, 10030, 10025, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100030, 10031, 10025, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100031, 10032, 10025, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100032, 10033, 10025, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100033, 10034, 10025, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100034, 10667, 10025, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100035, 10035, 10025, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100036, 10037, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100037, 10038, 10037, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100038, 10039, 10037, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100039, 10040, 10037, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100040, 10668, 10037, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100041, 10041, 10037, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100042, 10043, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100043, 10066, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100044, 10044, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100045, 10045, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100046, 10669, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100047, 10046, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100048, 10047, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100049, 10048, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100050, 10049, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100051, 10050, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100052, 10051, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100053, 10052, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100054, 10053, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100055, 10054, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 11);
INSERT INTO chado.feature_relationship VALUES (100056, 10055, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 12);
INSERT INTO chado.feature_relationship VALUES (100057, 10056, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 13);
INSERT INTO chado.feature_relationship VALUES (100058, 10057, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 14);
INSERT INTO chado.feature_relationship VALUES (100059, 10058, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 15);
INSERT INTO chado.feature_relationship VALUES (100060, 10059, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 16);
INSERT INTO chado.feature_relationship VALUES (100061, 10060, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 17);
INSERT INTO chado.feature_relationship VALUES (100062, 10061, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 18);
INSERT INTO chado.feature_relationship VALUES (100063, 10062, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 19);
INSERT INTO chado.feature_relationship VALUES (100064, 10063, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 20);
INSERT INTO chado.feature_relationship VALUES (100065, 10064, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 21);
INSERT INTO chado.feature_relationship VALUES (100066, 10065, 10043, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 22);
INSERT INTO chado.feature_relationship VALUES (100067, 10067, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100068, 10068, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100069, 10670, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100070, 10069, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100071, 10070, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100072, 10071, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100073, 10072, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100074, 10073, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100075, 10074, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100076, 10075, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100077, 10076, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100078, 10077, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 11);
INSERT INTO chado.feature_relationship VALUES (100079, 10078, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 12);
INSERT INTO chado.feature_relationship VALUES (100080, 10079, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 13);
INSERT INTO chado.feature_relationship VALUES (100081, 10080, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 14);
INSERT INTO chado.feature_relationship VALUES (100082, 10081, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 15);
INSERT INTO chado.feature_relationship VALUES (100083, 10082, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 16);
INSERT INTO chado.feature_relationship VALUES (100084, 10083, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 17);
INSERT INTO chado.feature_relationship VALUES (100085, 10084, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 18);
INSERT INTO chado.feature_relationship VALUES (100086, 10085, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 19);
INSERT INTO chado.feature_relationship VALUES (100087, 10086, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 20);
INSERT INTO chado.feature_relationship VALUES (100088, 10087, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 21);
INSERT INTO chado.feature_relationship VALUES (100089, 10088, 10066, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 22);
INSERT INTO chado.feature_relationship VALUES (100090, 10090, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100091, 10091, 10090, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100092, 10092, 10090, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100093, 10093, 10090, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100094, 10094, 10090, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100095, 10095, 10090, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100096, 10096, 10090, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100097, 10097, 10090, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100098, 10098, 10090, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100099, 10099, 10090, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100100, 10100, 10090, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100101, 10671, 10090, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100102, 10102, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100103, 10114, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100104, 10138, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100105, 10125, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100106, 10150, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100107, 10103, 10102, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 11);
INSERT INTO chado.feature_relationship VALUES (100108, 10104, 10102, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100109, 10105, 10102, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100110, 10106, 10102, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100111, 10107, 10102, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100112, 10108, 10102, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100113, 10109, 10102, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100114, 10110, 10102, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100115, 10111, 10102, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100116, 10112, 10102, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100117, 10113, 10102, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100118, 10672, 10102, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100119, 10115, 10114, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100120, 10116, 10114, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100121, 10117, 10114, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100122, 10118, 10114, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100123, 10119, 10114, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100124, 10120, 10114, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100125, 10121, 10114, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100126, 10122, 10114, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100127, 10123, 10114, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100128, 10124, 10114, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100129, 10673, 10114, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100130, 10126, 10125, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 12);
INSERT INTO chado.feature_relationship VALUES (100131, 10127, 10125, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 11);
INSERT INTO chado.feature_relationship VALUES (100132, 10128, 10125, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100133, 10129, 10125, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100134, 10130, 10125, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100135, 10131, 10125, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100136, 10132, 10125, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100137, 10133, 10125, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100138, 10134, 10125, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100139, 10135, 10125, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100140, 10136, 10125, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100141, 10674, 10125, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100142, 10137, 10125, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100143, 10139, 10138, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 11);
INSERT INTO chado.feature_relationship VALUES (100144, 10140, 10138, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100145, 10141, 10138, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100146, 10142, 10138, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100147, 10143, 10138, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100148, 10144, 10138, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100149, 10145, 10138, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100150, 10146, 10138, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100151, 10147, 10138, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100152, 10148, 10138, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100153, 10149, 10138, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100154, 10675, 10138, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100155, 10151, 10150, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 11);
INSERT INTO chado.feature_relationship VALUES (100156, 10152, 10150, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100157, 10153, 10150, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100158, 10154, 10150, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100159, 10155, 10150, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100160, 10156, 10150, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100161, 10157, 10150, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100162, 10158, 10150, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100163, 10159, 10150, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100164, 10160, 10150, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100165, 10161, 10150, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100166, 10676, 10150, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100167, 10163, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100168, 10172, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100169, 10164, 10163, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100170, 10165, 10163, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100171, 10166, 10163, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100172, 10167, 10163, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100173, 10168, 10163, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100174, 10169, 10163, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100175, 10170, 10163, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100176, 10171, 10163, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100177, 10677, 10163, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100178, 10173, 10172, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100179, 10174, 10172, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100180, 10175, 10172, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100181, 10176, 10172, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100182, 10177, 10172, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100183, 10178, 10172, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100184, 10179, 10172, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100185, 10678, 10172, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100186, 10181, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100187, 10182, 10181, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100188, 10679, 10181, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100189, 10184, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100190, 10191, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100191, 10185, 10184, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100192, 10186, 10184, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100193, 10187, 10184, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100194, 10188, 10184, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100195, 10189, 10184, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100196, 10190, 10184, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100197, 10680, 10184, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100198, 10192, 10191, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100199, 10193, 10191, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100200, 10194, 10191, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100201, 10195, 10191, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100202, 10196, 10191, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100203, 10197, 10191, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100204, 10681, 10191, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100205, 10199, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100206, 10200, 10199, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100207, 10201, 10199, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100208, 10202, 10199, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100209, 10203, 10199, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100210, 10204, 10199, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100211, 10682, 10199, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100212, 10206, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100213, 10220, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100214, 10227, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100215, 10213, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100216, 10207, 10206, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100217, 10208, 10206, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100218, 10209, 10206, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100219, 10210, 10206, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100220, 10211, 10206, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100221, 10212, 10206, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100222, 10683, 10206, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100223, 10214, 10213, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100224, 10215, 10213, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100225, 10216, 10213, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100226, 10217, 10213, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100227, 10218, 10213, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100228, 10219, 10213, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100229, 10684, 10213, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100230, 10221, 10220, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100231, 10222, 10220, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100232, 10223, 10220, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100233, 10224, 10220, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100234, 10225, 10220, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100235, 10226, 10220, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100236, 10685, 10220, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100237, 10228, 10227, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100238, 10229, 10227, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100239, 10230, 10227, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100240, 10231, 10227, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100241, 10232, 10227, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100242, 10233, 10227, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100243, 10234, 10227, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100244, 10686, 10227, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100245, 10236, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100246, 10243, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100247, 10237, 10236, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100248, 10687, 10236, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100249, 10238, 10236, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100250, 10239, 10236, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100251, 10240, 10236, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100252, 10241, 10236, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100253, 10242, 10236, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100254, 10244, 10243, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100255, 10245, 10243, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100256, 10688, 10243, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100257, 10246, 10243, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100258, 10247, 10243, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100259, 10248, 10243, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100260, 10250, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100261, 10251, 10250, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100262, 10689, 10250, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100263, 10253, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100264, 10254, 10253, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100265, 10255, 10253, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100266, 10690, 10253, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100267, 10256, 10253, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100268, 10258, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100269, 10259, 10258, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100270, 10260, 10258, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100271, 10261, 10258, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100272, 10691, 10258, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100273, 10263, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100274, 10280, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100275, 10297, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100276, 10264, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 15);
INSERT INTO chado.feature_relationship VALUES (100277, 10265, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 16);
INSERT INTO chado.feature_relationship VALUES (100278, 10266, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 14);
INSERT INTO chado.feature_relationship VALUES (100279, 10267, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 13);
INSERT INTO chado.feature_relationship VALUES (100280, 10268, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 12);
INSERT INTO chado.feature_relationship VALUES (100281, 10269, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 11);
INSERT INTO chado.feature_relationship VALUES (100282, 10270, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100283, 10271, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100284, 10272, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100285, 10273, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100286, 10274, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100287, 10275, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100288, 10276, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100289, 10277, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100290, 10278, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100291, 10279, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100292, 10692, 10263, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100293, 10281, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 15);
INSERT INTO chado.feature_relationship VALUES (100294, 10282, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 16);
INSERT INTO chado.feature_relationship VALUES (100295, 10283, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 14);
INSERT INTO chado.feature_relationship VALUES (100296, 10284, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 13);
INSERT INTO chado.feature_relationship VALUES (100297, 10285, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 12);
INSERT INTO chado.feature_relationship VALUES (100298, 10286, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 11);
INSERT INTO chado.feature_relationship VALUES (100299, 10287, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100300, 10288, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100301, 10289, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100302, 10290, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100303, 10291, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100304, 10292, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100305, 10293, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100306, 10294, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100307, 10295, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100308, 10296, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100309, 10693, 10280, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100310, 10298, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 15);
INSERT INTO chado.feature_relationship VALUES (100311, 10299, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 16);
INSERT INTO chado.feature_relationship VALUES (100312, 10300, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 14);
INSERT INTO chado.feature_relationship VALUES (100313, 10301, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 13);
INSERT INTO chado.feature_relationship VALUES (100314, 10302, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 12);
INSERT INTO chado.feature_relationship VALUES (100315, 10303, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 11);
INSERT INTO chado.feature_relationship VALUES (100316, 10304, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100317, 10305, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100318, 10306, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100319, 10307, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100320, 10308, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100321, 10309, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100322, 10310, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100323, 10311, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100324, 10312, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100325, 10313, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100326, 10694, 10297, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100327, 10315, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100328, 10316, 10315, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100329, 10317, 10315, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100330, 10318, 10315, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100331, 10319, 10315, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100332, 10320, 10315, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100333, 10695, 10315, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100334, 10322, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100335, 10331, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100336, 10323, 10322, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100337, 10324, 10322, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100338, 10696, 10322, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100339, 10325, 10322, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100340, 10326, 10322, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100341, 10327, 10322, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100342, 10328, 10322, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100343, 10329, 10322, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100344, 10330, 10322, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100345, 10332, 10331, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100346, 10333, 10331, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100347, 10697, 10331, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100348, 10334, 10331, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100349, 10335, 10331, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100350, 10336, 10331, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100351, 10337, 10331, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100352, 10338, 10331, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100353, 10340, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100354, 10346, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100355, 10341, 10340, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100356, 10342, 10340, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100357, 10343, 10340, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100358, 10344, 10340, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100359, 10345, 10340, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100360, 10698, 10340, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100361, 10347, 10346, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100362, 10348, 10346, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100363, 10349, 10346, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100364, 10350, 10346, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100365, 10351, 10346, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100366, 10699, 10346, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100367, 10353, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100368, 10354, 10353, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100369, 10355, 10353, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100370, 10700, 10353, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100371, 10356, 10353, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100372, 10358, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100373, 10359, 10358, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100374, 10360, 10358, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100375, 10701, 10358, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100376, 10362, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100377, 10363, 10362, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100378, 10364, 10362, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100379, 10365, 10362, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100380, 10366, 10362, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100381, 10702, 10362, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100382, 10368, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100383, 10369, 10368, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100384, 10370, 10368, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100385, 10703, 10368, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100386, 10371, 10368, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100387, 10372, 10368, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100388, 10373, 10368, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100389, 10375, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100390, 10376, 10375, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100391, 10377, 10375, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100392, 10378, 10375, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100393, 10704, 10375, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100394, 10379, 10375, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100395, 10380, 10375, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100396, 10381, 10375, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100397, 10382, 10375, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100398, 10383, 10375, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100399, 10384, 10375, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100400, 10385, 10375, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100401, 10387, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100402, 10388, 10387, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100403, 10389, 10387, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100404, 10705, 10387, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100405, 10390, 10387, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100406, 10391, 10387, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100407, 10393, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100408, 10394, 10393, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100409, 10395, 10393, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100410, 10706, 10393, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100411, 10396, 10393, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100412, 10397, 10393, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100413, 10398, 10393, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100414, 10400, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100415, 10405, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100416, 10410, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100417, 10401, 10400, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100418, 10402, 10400, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100419, 10403, 10400, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100420, 10707, 10400, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100421, 10404, 10400, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100422, 10406, 10405, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100423, 10407, 10405, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100424, 10408, 10405, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100425, 10708, 10405, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100426, 10409, 10405, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100427, 10411, 10410, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100428, 10412, 10410, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100429, 10709, 10410, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100430, 10413, 10410, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100431, 10415, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100432, 10416, 10415, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100433, 10417, 10415, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100434, 10710, 10415, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100435, 10418, 10415, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100436, 10420, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100437, 10424, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100438, 10429, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100439, 10421, 10420, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100440, 10422, 10420, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100441, 10711, 10420, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100442, 10423, 10420, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100443, 10425, 10424, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100444, 10426, 10424, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100445, 10427, 10424, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100446, 10712, 10424, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100447, 10428, 10424, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100448, 10430, 10429, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100449, 10431, 10429, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100450, 10432, 10429, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100451, 10713, 10429, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100452, 10433, 10429, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100453, 10435, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100454, 10436, 10435, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100455, 10437, 10435, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100456, 10714, 10435, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100457, 10438, 10435, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100458, 10439, 10435, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100459, 10441, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100460, 10446, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100461, 10442, 10441, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100462, 10443, 10441, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100463, 10715, 10441, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100464, 10444, 10441, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100465, 10445, 10441, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100466, 10447, 10446, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100467, 10448, 10446, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100468, 10716, 10446, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100469, 10449, 10446, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100470, 10450, 10446, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100471, 10451, 10446, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100472, 10453, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100473, 10454, 10453, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100474, 10455, 10453, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100475, 10717, 10453, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100476, 10456, 10453, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100477, 10458, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100478, 10459, 10458, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100479, 10460, 10458, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100480, 10718, 10458, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100481, 10461, 10458, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100482, 10463, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100483, 10464, 10463, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100484, 10465, 10463, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100485, 10719, 10463, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100486, 10466, 10463, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100487, 10468, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100488, 10496, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100489, 10469, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 27);
INSERT INTO chado.feature_relationship VALUES (100490, 10470, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 25);
INSERT INTO chado.feature_relationship VALUES (100491, 10471, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 26);
INSERT INTO chado.feature_relationship VALUES (100492, 10472, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 24);
INSERT INTO chado.feature_relationship VALUES (100493, 10473, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 23);
INSERT INTO chado.feature_relationship VALUES (100494, 10474, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 22);
INSERT INTO chado.feature_relationship VALUES (100495, 10475, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 21);
INSERT INTO chado.feature_relationship VALUES (100496, 10476, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 20);
INSERT INTO chado.feature_relationship VALUES (100497, 10477, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 19);
INSERT INTO chado.feature_relationship VALUES (100498, 10478, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 18);
INSERT INTO chado.feature_relationship VALUES (100499, 10479, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 17);
INSERT INTO chado.feature_relationship VALUES (100500, 10480, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 16);
INSERT INTO chado.feature_relationship VALUES (100501, 10481, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 15);
INSERT INTO chado.feature_relationship VALUES (100502, 10482, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 14);
INSERT INTO chado.feature_relationship VALUES (100503, 10483, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 13);
INSERT INTO chado.feature_relationship VALUES (100504, 10484, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 12);
INSERT INTO chado.feature_relationship VALUES (100505, 10485, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 11);
INSERT INTO chado.feature_relationship VALUES (100506, 10486, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100507, 10487, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100508, 10488, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100509, 10489, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100510, 10490, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100511, 10491, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100512, 10492, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100513, 10493, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100514, 10494, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100515, 10720, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100516, 10495, 10468, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100517, 10497, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 27);
INSERT INTO chado.feature_relationship VALUES (100518, 10498, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 25);
INSERT INTO chado.feature_relationship VALUES (100519, 10499, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 26);
INSERT INTO chado.feature_relationship VALUES (100520, 10500, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 24);
INSERT INTO chado.feature_relationship VALUES (100521, 10501, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 23);
INSERT INTO chado.feature_relationship VALUES (100522, 10502, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 22);
INSERT INTO chado.feature_relationship VALUES (100523, 10503, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 21);
INSERT INTO chado.feature_relationship VALUES (100524, 10504, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 20);
INSERT INTO chado.feature_relationship VALUES (100525, 10505, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 19);
INSERT INTO chado.feature_relationship VALUES (100526, 10506, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 18);
INSERT INTO chado.feature_relationship VALUES (100527, 10507, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 17);
INSERT INTO chado.feature_relationship VALUES (100528, 10508, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 16);
INSERT INTO chado.feature_relationship VALUES (100529, 10509, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 15);
INSERT INTO chado.feature_relationship VALUES (100530, 10510, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 14);
INSERT INTO chado.feature_relationship VALUES (100531, 10511, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 13);
INSERT INTO chado.feature_relationship VALUES (100532, 10512, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 12);
INSERT INTO chado.feature_relationship VALUES (100533, 10513, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 11);
INSERT INTO chado.feature_relationship VALUES (100534, 10514, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100535, 10515, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100536, 10516, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100537, 10517, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100538, 10518, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100539, 10519, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100540, 10520, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100541, 10521, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100542, 10522, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100543, 10721, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100544, 10523, 10496, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100545, 10525, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100546, 10537, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100547, 10526, 10525, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 11);
INSERT INTO chado.feature_relationship VALUES (100548, 10527, 10525, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100549, 10528, 10525, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100550, 10529, 10525, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100551, 10530, 10525, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100552, 10531, 10525, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100553, 10532, 10525, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100554, 10533, 10525, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100555, 10534, 10525, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100556, 10535, 10525, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100557, 10536, 10525, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100558, 10722, 10525, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100559, 10538, 10537, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100560, 10539, 10537, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100561, 10540, 10537, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100562, 10541, 10537, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100563, 10542, 10537, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100564, 10543, 10537, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100565, 10544, 10537, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100566, 10545, 10537, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100567, 10546, 10537, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100568, 10723, 10537, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100569, 10548, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100570, 10549, 10548, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100571, 10550, 10548, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100572, 10551, 10548, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100573, 10724, 10548, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100574, 10552, 10548, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100575, 10553, 10548, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100576, 10554, 10548, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100577, 10556, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100578, 10557, 10556, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100579, 10725, 10556, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100580, 10558, 10556, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100581, 10559, 10556, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100582, 10560, 10556, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100583, 10561, 10556, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100584, 10563, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100585, 10564, 10563, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100586, 10565, 10563, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100587, 10726, 10563, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100588, 10566, 10563, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100589, 10567, 10563, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100590, 10568, 10563, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100591, 10570, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100592, 10583, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100593, 10571, 10570, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100594, 10572, 10570, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100595, 10573, 10570, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100596, 10727, 10570, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100597, 10574, 10570, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100598, 10575, 10570, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100599, 10576, 10570, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100600, 10577, 10570, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100601, 10578, 10570, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100602, 10579, 10570, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100603, 10580, 10570, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100604, 10581, 10570, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 11);
INSERT INTO chado.feature_relationship VALUES (100605, 10582, 10570, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 12);
INSERT INTO chado.feature_relationship VALUES (100606, 10584, 10583, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100607, 10585, 10583, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100608, 10728, 10583, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100609, 10586, 10583, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100610, 10587, 10583, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100611, 10588, 10583, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100612, 10589, 10583, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100613, 10590, 10583, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100614, 10591, 10583, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100615, 10592, 10583, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100616, 10593, 10583, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100617, 10594, 10583, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 11);
INSERT INTO chado.feature_relationship VALUES (100618, 10596, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100619, 10597, 10596, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100620, 10598, 10596, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100621, 10729, 10596, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100622, 10599, 10596, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100623, 10600, 10596, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100624, 10601, 10596, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100625, 10603, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100626, 10604, 10603, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100627, 10605, 10603, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100628, 10730, 10603, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100629, 10606, 10603, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100630, 10608, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100631, 10609, 10608, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100632, 10610, 10608, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100633, 10611, 10608, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100634, 10612, 10608, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100635, 10613, 10608, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100636, 10614, 10608, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100637, 10731, 10608, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100638, 10616, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100639, 10617, 10616, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100640, 10732, 10616, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100641, 10619, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100642, 10620, 10619, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100643, 10621, 10619, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100644, 10733, 10619, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100645, 10623, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100646, 10624, 10623, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100647, 10625, 10623, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100648, 10626, 10623, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100649, 10627, 10623, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100650, 10628, 10623, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100651, 10734, 10623, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100652, 10630, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100653, 10631, 10630, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100654, 10632, 10630, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100655, 10633, 10630, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100656, 10634, 10630, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100657, 10635, 10630, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100658, 10636, 10630, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100659, 10637, 10630, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100660, 10735, 10630, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100661, 10639, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100662, 10640, 10639, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100663, 10736, 10639, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100664, 10642, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100665, 10646, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100666, 10643, 10642, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100667, 10644, 10642, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100668, 10737, 10642, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100669, 10645, 10642, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100670, 10647, 10646, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100671, 10648, 10646, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100672, 10649, 10646, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100673, 10650, 10646, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100674, 10738, 10646, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100675, 10652, 10001, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100676, 10653, 10652, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 0);
INSERT INTO chado.feature_relationship VALUES (100677, 10654, 10652, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 1);
INSERT INTO chado.feature_relationship VALUES (100678, 10655, 10652, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 2);
INSERT INTO chado.feature_relationship VALUES (100679, 10739, 10652, (SELECT cvterm_id FROM chado.cvterm WHERE name='contained_by' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 3);
INSERT INTO chado.feature_relationship VALUES (100680, 10656, 10652, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 4);
INSERT INTO chado.feature_relationship VALUES (100681, 10657, 10652, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 5);
INSERT INTO chado.feature_relationship VALUES (100682, 10658, 10652, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 6);
INSERT INTO chado.feature_relationship VALUES (100683, 10659, 10652, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 7);
INSERT INTO chado.feature_relationship VALUES (100684, 10660, 10652, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 8);
INSERT INTO chado.feature_relationship VALUES (100685, 10661, 10652, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 9);
INSERT INTO chado.feature_relationship VALUES (100686, 10662, 10652, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 10);
INSERT INTO chado.feature_relationship VALUES (100687, 10663, 10652, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 11);
INSERT INTO chado.feature_relationship VALUES (100688, 10664, 10652, (SELECT cvterm_id FROM chado.cvterm WHERE name='similar_to' AND cv_id=(SELECT cv_id FROM chado.cv WHERE name='sequence')), NULL, 12);

INSERT INTO chado.featureloc VALUES (100000, 10001, 10000, 3630, false, 5899, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100001, 10002, 10000, 3630, false, 5899, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100002, 10003, 10000, 3630, false, 3759, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100003, 10004, 10000, 3759, false, 3913, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100004, 10005, 10000, 3995, false, 4276, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100005, 10006, 10000, 4485, false, 4605, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100006, 10007, 10000, 4705, false, 5095, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100007, 10008, 10000, 5173, false, 5326, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100008, 10009, 10000, 5438, false, 5630, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100009, 10010, 10000, 5630, false, 5899, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100010, 10011, 10000, 5927, false, 8737, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100011, 10012, 10000, 5927, false, 8737, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100012, 10013, 10000, 8570, false, 8666, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100013, 10014, 10000, 8666, false, 8737, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100014, 10015, 10000, 8416, false, 8464, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100015, 10016, 10000, 8235, false, 8325, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100016, 10017, 10000, 7941, false, 7987, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100017, 10018, 10000, 7761, false, 7835, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100018, 10019, 10000, 7563, false, 7649, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100019, 10020, 10000, 7383, false, 7450, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100020, 10021, 10000, 7156, false, 7232, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100021, 10022, 10000, 6436, false, 6914, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100022, 10023, 10000, 6914, false, 7069, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100023, 10024, 10000, 5927, false, 6263, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100024, 10025, 10000, 6789, false, 8737, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100025, 10026, 10000, 8570, false, 8666, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100026, 10027, 10000, 8666, false, 8737, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100027, 10028, 10000, 8416, false, 8464, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100028, 10029, 10000, 8235, false, 8325, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100029, 10030, 10000, 7941, false, 7987, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100030, 10031, 10000, 7761, false, 7835, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100031, 10032, 10000, 7563, false, 7649, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100032, 10033, 10000, 7156, false, 7314, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100033, 10034, 10000, 7314, false, 7450, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100034, 10035, 10000, 6789, false, 7069, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100035, 10036, 10000, 11648, false, 13714, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100036, 10037, 10000, 11648, false, 13714, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100037, 10038, 10000, 13334, false, 13714, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100038, 10039, 10000, 11648, false, 11863, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100039, 10040, 10000, 11863, false, 12940, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100040, 10041, 10000, 12940, false, 13173, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100041, 10042, 10000, 23145, false, 31227, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100042, 10043, 10000, 23415, false, 31120, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100043, 10044, 10000, 23415, false, 23518, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100044, 10045, 10000, 23518, false, 24451, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100045, 10046, 10000, 24541, false, 24655, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100046, 10047, 10000, 24751, false, 24962, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100047, 10048, 10000, 25040, false, 25435, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100048, 10049, 10000, 25523, false, 25743, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100049, 10050, 10000, 25824, false, 25997, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100050, 10051, 10000, 26080, false, 26203, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100051, 10052, 10000, 26291, false, 26452, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100052, 10053, 10000, 26542, false, 26776, false, 1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100053, 10054, 10000, 26861, false, 27012, false, 1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100054, 10055, 10000, 27098, false, 27281, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100055, 10056, 10000, 27371, false, 27536, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100056, 10057, 10000, 27617, false, 27713, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100057, 10058, 10000, 27802, false, 28431, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100058, 10059, 10000, 28707, false, 28805, false, 1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100059, 10060, 10000, 28889, false, 29080, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100060, 10061, 10000, 29159, false, 30065, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100061, 10062, 10000, 30146, false, 30311, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100062, 10063, 10000, 30409, false, 30816, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100063, 10064, 10000, 30901, false, 31079, false, 1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100064, 10065, 10000, 31079, false, 31120, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100065, 10066, 10000, 23145, false, 31227, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100066, 10067, 10000, 23145, false, 23518, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100067, 10068, 10000, 23518, false, 24451, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100068, 10069, 10000, 24541, false, 24655, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100069, 10070, 10000, 24751, false, 24962, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100070, 10071, 10000, 25040, false, 25435, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100071, 10072, 10000, 25523, false, 25743, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100072, 10073, 10000, 25824, false, 25997, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100073, 10074, 10000, 26080, false, 26203, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100074, 10075, 10000, 26291, false, 26452, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100075, 10076, 10000, 26542, false, 26776, false, 1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100076, 10077, 10000, 26861, false, 27012, false, 1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100077, 10078, 10000, 27098, false, 27281, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100078, 10079, 10000, 27371, false, 27533, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100079, 10080, 10000, 27617, false, 27713, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100080, 10081, 10000, 27802, false, 28431, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100081, 10082, 10000, 28707, false, 28805, false, 1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100082, 10083, 10000, 28889, false, 29080, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100083, 10084, 10000, 29159, false, 30065, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100084, 10085, 10000, 30146, false, 30311, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100085, 10086, 10000, 30409, false, 30816, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100086, 10087, 10000, 30901, false, 31079, false, 1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100087, 10088, 10000, 31079, false, 31227, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100088, 10089, 10000, 31169, false, 33153, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100089, 10090, 10000, 31169, false, 33153, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100090, 10091, 10000, 33028, false, 33153, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100091, 10092, 10000, 32546, false, 32670, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100092, 10093, 10000, 32430, false, 32459, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100093, 10094, 10000, 32281, false, 32347, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100094, 10095, 10000, 32087, false, 32195, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100095, 10096, 10000, 31932, false, 31998, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100096, 10097, 10000, 31692, false, 31813, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100097, 10098, 10000, 31520, false, 31602, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100098, 10099, 10000, 31169, false, 31381, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100099, 10100, 10000, 31381, false, 31424, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100100, 10101, 10000, 33378, false, 37871, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100101, 10102, 10000, 33665, false, 37840, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100102, 10103, 10000, 37568, false, 37840, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100103, 10104, 10000, 37372, false, 37398, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100104, 10105, 10000, 37022, false, 37061, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100105, 10106, 10000, 37061, false, 37203, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100106, 10107, 10000, 36809, false, 36921, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100107, 10108, 10000, 36623, false, 36685, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100108, 10109, 10000, 35729, false, 35963, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100109, 10110, 10000, 35566, false, 35647, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100110, 10111, 10000, 34400, false, 35474, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100111, 10112, 10000, 33665, false, 33991, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100112, 10113, 10000, 33991, false, 34327, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100113, 10114, 10000, 33665, false, 37780, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100114, 10115, 10000, 37372, false, 37780, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100115, 10116, 10000, 37022, false, 37061, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100116, 10117, 10000, 37061, false, 37203, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100117, 10118, 10000, 36809, false, 36921, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100118, 10119, 10000, 36623, false, 36685, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100119, 10120, 10000, 35729, false, 35963, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100120, 10121, 10000, 35566, false, 35647, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100121, 10122, 10000, 34400, false, 35474, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100122, 10123, 10000, 33665, false, 33991, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100123, 10124, 10000, 33991, false, 34327, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100124, 10125, 10000, 33378, false, 37757, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100125, 10126, 10000, 37568, false, 37757, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100126, 10127, 10000, 37372, false, 37398, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100127, 10128, 10000, 37022, false, 37061, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100128, 10129, 10000, 37061, false, 37203, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100129, 10130, 10000, 36809, false, 36921, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100130, 10131, 10000, 36623, false, 36685, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100131, 10132, 10000, 35729, false, 35963, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100132, 10133, 10000, 35566, false, 35647, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100133, 10134, 10000, 34400, false, 35474, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100134, 10135, 10000, 33980, false, 33991, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100135, 10136, 10000, 33991, false, 34327, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100136, 10137, 10000, 33378, false, 33589, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100137, 10138, 10000, 33665, false, 37780, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100138, 10139, 10000, 37568, false, 37780, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100139, 10140, 10000, 37372, false, 37398, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100140, 10141, 10000, 37022, false, 37061, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100141, 10142, 10000, 37061, false, 37203, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100142, 10143, 10000, 36809, false, 36921, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100143, 10144, 10000, 36623, false, 36685, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100144, 10145, 10000, 35729, false, 35963, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100145, 10146, 10000, 35566, false, 35647, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100146, 10147, 10000, 34400, false, 35471, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100147, 10148, 10000, 33665, false, 33991, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100148, 10149, 10000, 33991, false, 34327, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100149, 10150, 10000, 33966, false, 37871, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100150, 10151, 10000, 37372, false, 37871, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100151, 10152, 10000, 37022, false, 37203, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100152, 10153, 10000, 36809, false, 36836, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100153, 10154, 10000, 36836, false, 36921, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100154, 10155, 10000, 36623, false, 36685, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100155, 10156, 10000, 36089, false, 36171, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100156, 10157, 10000, 35729, false, 35999, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100157, 10158, 10000, 35566, false, 35647, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100158, 10159, 10000, 34400, false, 35474, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100159, 10160, 10000, 33966, false, 33991, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100160, 10161, 10000, 33991, false, 34327, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100161, 10162, 10000, 38751, false, 40944, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100162, 10163, 10000, 38751, false, 40944, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100163, 10164, 10000, 40674, false, 40877, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100164, 10165, 10000, 40877, false, 40944, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100165, 10166, 10000, 40472, false, 40535, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100166, 10167, 10000, 40212, false, 40329, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100167, 10168, 10000, 39408, false, 39814, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100168, 10169, 10000, 39135, false, 39287, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100169, 10170, 10000, 38751, false, 38897, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100170, 10171, 10000, 38897, false, 39054, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100171, 10172, 10000, 38751, false, 40927, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100172, 10173, 10000, 40472, false, 40597, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100173, 10174, 10000, 40597, false, 40927, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100174, 10175, 10000, 40212, false, 40329, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100175, 10176, 10000, 39408, false, 39814, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100176, 10177, 10000, 39135, false, 39287, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100177, 10178, 10000, 38751, false, 38897, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100178, 10179, 10000, 38897, false, 39054, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100179, 10180, 10000, 44676, false, 44787, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100180, 10181, 10000, 44676, false, 44787, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100181, 10182, 10000, 44676, false, 44787, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100182, 10183, 10000, 45295, false, 47019, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100183, 10184, 10000, 45295, false, 47019, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100184, 10185, 10000, 46372, false, 46789, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100185, 10186, 10000, 46789, false, 47019, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100186, 10187, 10000, 46043, false, 46145, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100187, 10188, 10000, 45645, false, 45954, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100188, 10189, 10000, 45295, false, 45502, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100189, 10190, 10000, 45502, false, 45559, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100190, 10191, 10000, 45295, false, 47019, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100191, 10192, 10000, 46375, false, 46789, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100192, 10193, 10000, 46789, false, 47019, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100193, 10194, 10000, 46043, false, 46145, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100194, 10195, 10000, 45645, false, 45954, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100195, 10196, 10000, 45295, false, 45502, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100196, 10197, 10000, 45502, false, 45559, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100197, 10198, 10000, 47484, false, 49286, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100198, 10199, 10000, 47484, false, 49286, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100199, 10200, 10000, 48935, false, 49166, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100200, 10201, 10000, 49166, false, 49286, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100201, 10202, 10000, 48074, false, 48852, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100202, 10203, 10000, 47484, false, 47704, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100203, 10204, 10000, 47704, false, 47982, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100204, 10205, 10000, 50074, false, 51199, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100205, 10206, 10000, 50089, false, 51108, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100206, 10207, 10000, 51063, false, 51108, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100207, 10208, 10000, 50882, false, 50954, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100208, 10209, 10000, 50954, false, 50963, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100209, 10210, 10000, 50418, false, 50631, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100210, 10211, 10000, 50089, false, 50283, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100211, 10212, 10000, 50283, false, 50337, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100212, 10213, 10000, 50074, false, 51199, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100213, 10214, 10000, 51125, false, 51199, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100214, 10215, 10000, 50882, false, 50954, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100215, 10216, 10000, 50954, false, 50963, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100216, 10217, 10000, 50418, false, 50631, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100217, 10218, 10000, 50074, false, 50283, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100218, 10219, 10000, 50283, false, 50337, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100219, 10220, 10000, 50089, false, 51187, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100220, 10221, 10000, 51122, false, 51187, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100221, 10222, 10000, 50882, false, 50954, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100222, 10223, 10000, 50954, false, 50963, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100223, 10224, 10000, 50418, false, 50631, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100224, 10225, 10000, 50089, false, 50283, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100225, 10226, 10000, 50283, false, 50337, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100226, 10227, 10000, 50089, false, 51197, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100227, 10228, 10000, 51125, false, 51197, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100228, 10229, 10000, 50882, false, 50954, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100229, 10230, 10000, 50954, false, 50963, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100230, 10231, 10000, 50495, false, 50631, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100231, 10232, 10000, 50418, false, 50447, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100232, 10233, 10000, 50089, false, 50283, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100233, 10234, 10000, 50283, false, 50337, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100234, 10235, 10000, 52238, false, 54692, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100235, 10236, 10000, 52238, false, 54692, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100236, 10237, 10000, 52238, false, 52346, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100237, 10238, 10000, 52433, false, 52730, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100238, 10239, 10000, 52937, false, 53183, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100239, 10240, 10000, 53483, false, 53624, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100240, 10241, 10000, 53702, false, 54494, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100241, 10242, 10000, 54494, false, 54692, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100242, 10243, 10000, 52868, false, 54685, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100243, 10244, 10000, 52868, false, 53021, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100244, 10245, 10000, 53021, false, 53183, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100245, 10246, 10000, 53483, false, 53624, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100246, 10247, 10000, 53702, false, 54494, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100247, 10248, 10000, 54494, false, 54685, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100248, 10249, 10000, 56623, false, 56740, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100249, 10250, 10000, 56623, false, 56740, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100250, 10251, 10000, 56623, false, 56740, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100251, 10252, 10000, 57268, false, 59167, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100252, 10253, 10000, 57268, false, 59167, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100253, 10254, 10000, 57268, false, 57391, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100254, 10255, 10000, 57391, false, 58978, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100255, 10256, 10000, 58978, false, 59167, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100256, 10257, 10000, 61904, false, 63811, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100257, 10258, 10000, 61904, false, 63811, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100258, 10259, 10000, 63556, false, 63811, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100259, 10260, 10000, 62049, false, 62124, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100260, 10261, 10000, 61904, false, 61949, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100261, 10262, 10000, 64165, false, 67625, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100262, 10263, 10000, 64166, false, 67625, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100263, 10264, 10000, 67323, false, 67512, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100264, 10265, 10000, 67512, false, 67625, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100265, 10266, 10000, 66834, false, 66897, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100266, 10267, 10000, 66677, false, 66749, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100267, 10268, 10000, 66449, false, 66557, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100268, 10269, 10000, 66261, false, 66342, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100269, 10270, 10000, 66106, false, 66160, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100270, 10271, 10000, 65738, false, 65864, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100271, 10272, 10000, 65562, false, 65652, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100272, 10273, 10000, 65330, false, 65456, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100273, 10274, 10000, 65109, false, 65217, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100274, 10275, 10000, 64900, false, 65017, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100275, 10276, 10000, 64750, false, 64807, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100276, 10277, 10000, 64569, false, 64656, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100277, 10278, 10000, 64166, false, 64397, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100278, 10279, 10000, 64397, false, 64475, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100279, 10280, 10000, 64166, false, 67625, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100280, 10281, 10000, 67323, false, 67512, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100281, 10282, 10000, 67512, false, 67625, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100282, 10283, 10000, 66834, false, 66897, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100283, 10284, 10000, 66677, false, 66749, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100284, 10285, 10000, 66449, false, 66557, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100285, 10286, 10000, 66261, false, 66342, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100286, 10287, 10000, 66106, false, 66160, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100287, 10288, 10000, 65732, false, 65864, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100288, 10289, 10000, 65562, false, 65652, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100289, 10290, 10000, 65330, false, 65456, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100290, 10291, 10000, 65109, false, 65217, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100291, 10292, 10000, 64900, false, 65017, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100292, 10293, 10000, 64750, false, 64807, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100293, 10294, 10000, 64581, false, 64656, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100294, 10295, 10000, 64166, false, 64397, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100295, 10296, 10000, 64397, false, 64475, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100296, 10297, 10000, 64165, false, 67625, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100297, 10298, 10000, 67323, false, 67512, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100298, 10299, 10000, 67512, false, 67625, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100299, 10300, 10000, 66834, false, 66897, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100300, 10301, 10000, 66677, false, 66749, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100301, 10302, 10000, 66449, false, 66557, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100302, 10303, 10000, 66261, false, 66342, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100303, 10304, 10000, 66106, false, 66160, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100304, 10305, 10000, 65738, false, 65864, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100305, 10306, 10000, 65562, false, 65652, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100306, 10307, 10000, 65330, false, 65456, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100307, 10308, 10000, 65109, false, 65217, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100308, 10309, 10000, 64900, false, 65017, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100309, 10310, 10000, 64750, false, 64807, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100310, 10311, 10000, 64581, false, 64656, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100311, 10312, 10000, 64165, false, 64397, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100312, 10313, 10000, 64397, false, 64475, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100313, 10314, 10000, 70114, false, 72138, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100314, 10315, 10000, 70114, false, 72138, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100315, 10316, 10000, 71941, false, 71998, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100316, 10317, 10000, 71998, false, 72138, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100317, 10318, 10000, 71040, false, 71721, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100318, 10319, 10000, 70839, false, 70968, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100319, 10320, 10000, 70114, false, 70285, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100320, 10321, 10000, 72338, false, 74096, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100321, 10322, 10000, 72356, false, 74096, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100322, 10323, 10000, 72356, false, 72582, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100323, 10324, 10000, 72582, false, 72669, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100324, 10325, 10000, 72914, false, 73016, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100325, 10326, 10000, 73086, false, 73163, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100326, 10327, 10000, 73286, false, 73395, false, 1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100327, 10328, 10000, 73487, false, 73740, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100328, 10329, 10000, 73821, false, 73883, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100329, 10330, 10000, 73883, false, 74096, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100330, 10331, 10000, 72338, false, 74096, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100331, 10332, 10000, 72338, false, 72582, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100332, 10333, 10000, 72582, false, 72669, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100333, 10334, 10000, 73086, false, 73163, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100334, 10335, 10000, 73286, false, 73395, false, 1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100335, 10336, 10000, 73487, false, 73740, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100336, 10337, 10000, 73821, false, 73883, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100337, 10338, 10000, 73883, false, 74096, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100338, 10339, 10000, 73930, false, 74737, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100339, 10340, 10000, 73930, false, 74737, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100340, 10341, 10000, 74660, false, 74737, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100341, 10342, 10000, 74337, false, 74443, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100342, 10343, 10000, 74443, false, 74455, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100343, 10344, 10000, 73930, false, 74104, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100344, 10345, 10000, 74104, false, 74250, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100345, 10346, 10000, 73930, false, 74731, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100346, 10347, 10000, 74660, false, 74731, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100347, 10348, 10000, 74337, false, 74443, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100348, 10349, 10000, 74443, false, 74449, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100349, 10350, 10000, 73930, false, 74104, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100350, 10351, 10000, 74104, false, 74250, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100351, 10352, 10000, 75582, false, 76758, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100352, 10353, 10000, 75582, false, 76758, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100353, 10354, 10000, 75582, false, 75632, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100354, 10355, 10000, 75632, false, 76556, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100355, 10356, 10000, 76556, false, 76758, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100356, 10357, 10000, 83044, false, 84864, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100357, 10358, 10000, 83044, false, 84864, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100358, 10359, 10000, 83883, false, 84864, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100359, 10360, 10000, 83044, false, 83671, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100360, 10361, 10000, 86514, false, 88213, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100361, 10362, 10000, 86514, false, 88213, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100362, 10363, 10000, 87879, false, 88145, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100363, 10364, 10000, 88145, false, 88213, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100364, 10365, 10000, 86514, false, 86714, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100365, 10366, 10000, 86714, false, 87162, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100366, 10367, 10000, 88897, false, 89745, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100367, 10368, 10000, 88897, false, 89745, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100368, 10369, 10000, 88897, false, 88976, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100369, 10370, 10000, 88976, false, 89081, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100370, 10371, 10000, 89172, false, 89263, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100371, 10372, 10000, 89404, false, 89529, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100372, 10373, 10000, 89529, false, 89745, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100373, 10374, 10000, 91375, false, 95651, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100374, 10375, 10000, 91375, false, 95651, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100375, 10376, 10000, 91375, false, 91633, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100376, 10377, 10000, 91742, false, 91749, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100377, 10378, 10000, 91749, false, 92070, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100378, 10379, 10000, 92269, false, 92501, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100379, 10380, 10000, 92568, false, 92933, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100380, 10381, 10000, 93044, false, 93171, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100381, 10382, 10000, 93270, false, 94281, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100382, 10383, 10000, 94356, false, 95075, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100383, 10384, 10000, 95159, false, 95552, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100384, 10385, 10000, 95552, false, 95651, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100385, 10386, 10000, 95986, false, 97407, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100386, 10387, 10000, 95986, false, 97407, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100387, 10388, 10000, 95986, false, 96063, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100388, 10389, 10000, 96063, false, 96157, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100389, 10390, 10000, 96553, false, 97242, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100390, 10391, 10000, 97242, false, 97407, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100391, 10392, 10000, 97455, false, 99240, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100392, 10393, 10000, 97455, false, 99240, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100393, 10394, 10000, 97455, false, 97619, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100394, 10395, 10000, 97619, false, 97805, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100395, 10396, 10000, 98456, false, 98605, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100396, 10397, 10000, 98907, false, 99046, false, 1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100397, 10398, 10000, 99046, false, 99240, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100398, 10399, 10000, 99893, false, 101834, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100399, 10400, 10000, 99921, false, 101834, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100400, 10401, 10000, 99921, false, 100031, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100401, 10402, 10000, 100656, false, 100682, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100402, 10403, 10000, 100682, false, 101678, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100403, 10404, 10000, 101678, false, 101834, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100404, 10405, 10000, 100030, false, 101834, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100405, 10406, 10000, 100030, false, 100220, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100406, 10407, 10000, 100656, false, 100682, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100407, 10408, 10000, 100682, false, 101678, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100408, 10409, 10000, 101678, false, 101834, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100409, 10410, 10000, 99893, false, 101834, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100410, 10411, 10000, 99893, false, 100682, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100411, 10412, 10000, 100682, false, 101678, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100412, 10413, 10000, 101678, false, 101834, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100413, 10414, 10000, 104490, false, 105330, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100414, 10415, 10000, 104490, false, 105330, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100415, 10416, 10000, 104490, false, 104730, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100416, 10417, 10000, 104730, false, 105309, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100417, 10418, 10000, 105309, false, 105330, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100418, 10419, 10000, 108945, false, 111609, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100419, 10420, 10000, 109031, false, 111609, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100420, 10421, 10000, 109031, false, 109594, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100421, 10422, 10000, 109594, false, 111367, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100422, 10423, 10000, 111367, false, 111609, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100423, 10424, 10000, 109075, false, 111535, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100424, 10425, 10000, 109075, false, 109330, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100425, 10426, 10000, 109412, false, 109594, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100426, 10427, 10000, 109594, false, 111367, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100427, 10428, 10000, 111367, false, 111535, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100428, 10429, 10000, 108945, false, 111597, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100429, 10430, 10000, 108945, false, 109330, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100430, 10431, 10000, 109405, false, 109594, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100431, 10432, 10000, 109594, false, 111367, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100432, 10433, 10000, 111367, false, 111597, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100433, 10434, 10000, 112262, false, 113947, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100434, 10435, 10000, 112262, false, 113947, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100435, 10436, 10000, 112262, false, 112289, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100436, 10437, 10000, 112289, false, 113195, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100437, 10438, 10000, 113278, false, 113905, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100438, 10439, 10000, 113905, false, 113947, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100439, 10440, 10000, 114285, false, 116108, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100440, 10441, 10000, 114285, false, 115549, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100441, 10442, 10000, 114285, false, 114298, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100442, 10443, 10000, 114298, false, 114433, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100443, 10444, 10000, 114618, false, 115296, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100444, 10445, 10000, 115296, false, 115549, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100445, 10446, 10000, 114285, false, 116108, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100446, 10447, 10000, 114285, false, 114298, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100447, 10448, 10000, 114298, false, 114433, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100448, 10449, 10000, 114618, false, 115296, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100449, 10450, 10000, 115296, false, 115339, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100450, 10451, 10000, 115960, false, 116108, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100451, 10452, 10000, 116942, false, 118764, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100452, 10453, 10000, 116942, false, 118764, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100453, 10454, 10000, 116942, false, 117064, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100454, 10455, 10000, 117064, false, 118522, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100455, 10456, 10000, 118522, false, 118764, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100456, 10457, 10000, 119396, false, 119997, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100457, 10458, 10000, 119396, false, 119997, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100458, 10459, 10000, 119396, false, 119428, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100459, 10460, 10000, 119428, false, 119854, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100460, 10461, 10000, 119854, false, 119997, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100461, 10462, 10000, 120153, false, 121130, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100462, 10463, 10000, 120153, false, 121130, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100463, 10464, 10000, 120153, false, 120220, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100464, 10465, 10000, 120220, false, 120946, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100465, 10466, 10000, 120946, false, 121130, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100466, 10467, 10000, 121066, false, 130577, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100467, 10468, 10000, 121123, false, 130570, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100468, 10469, 10000, 130371, false, 130570, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100469, 10470, 10000, 130038, false, 130099, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100470, 10471, 10000, 130099, false, 130149, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100471, 10472, 10000, 129852, false, 129914, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100472, 10473, 10000, 128967, false, 129060, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100473, 10474, 10000, 128478, false, 128551, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100474, 10475, 10000, 128027, false, 128312, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100475, 10476, 10000, 127867, false, 127935, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100476, 10477, 10000, 127650, false, 127782, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100477, 10478, 10000, 127531, false, 127573, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100478, 10479, 10000, 126934, false, 127453, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100479, 10480, 10000, 126685, false, 126840, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100480, 10481, 10000, 126075, false, 126589, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100481, 10482, 10000, 125935, false, 125998, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100482, 10483, 10000, 125741, false, 125843, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100483, 10484, 10000, 125328, false, 125655, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100484, 10485, 10000, 125133, false, 125226, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100485, 10486, 10000, 124920, false, 125046, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100486, 10487, 10000, 124713, false, 124818, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100487, 10488, 10000, 124498, false, 124632, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100488, 10489, 10000, 124210, false, 124394, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100489, 10490, 10000, 123991, false, 124123, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100490, 10491, 10000, 123784, false, 123897, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100491, 10492, 10000, 123578, false, 123669, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100492, 10493, 10000, 121492, false, 121581, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100493, 10494, 10000, 121581, false, 123501, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100494, 10495, 10000, 121123, false, 121406, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100495, 10496, 10000, 121066, false, 130577, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100496, 10497, 10000, 130371, false, 130577, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100497, 10498, 10000, 130038, false, 130099, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100498, 10499, 10000, 130099, false, 130149, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100499, 10500, 10000, 129852, false, 129914, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100500, 10501, 10000, 128967, false, 129060, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100501, 10502, 10000, 128478, false, 128551, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100502, 10503, 10000, 128027, false, 128312, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100503, 10504, 10000, 127867, false, 127935, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100504, 10505, 10000, 127650, false, 127782, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100505, 10506, 10000, 127531, false, 127573, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100506, 10507, 10000, 126934, false, 127453, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100507, 10508, 10000, 126685, false, 126840, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100508, 10509, 10000, 126075, false, 126589, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100509, 10510, 10000, 125935, false, 125998, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100510, 10511, 10000, 125741, false, 125843, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100511, 10512, 10000, 125328, false, 125655, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100512, 10513, 10000, 125133, false, 125226, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100513, 10514, 10000, 124920, false, 125022, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100514, 10515, 10000, 124713, false, 124818, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100515, 10516, 10000, 124498, false, 124632, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100516, 10517, 10000, 124210, false, 124394, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100517, 10518, 10000, 123991, false, 124123, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100518, 10519, 10000, 123784, false, 123897, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100519, 10520, 10000, 123578, false, 123669, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100520, 10521, 10000, 121492, false, 121581, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100521, 10522, 10000, 121581, false, 123495, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100522, 10523, 10000, 121066, false, 121406, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100523, 10524, 10000, 132327, false, 135831, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100524, 10525, 10000, 132329, false, 135831, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100525, 10526, 10000, 135707, false, 135831, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100526, 10527, 10000, 135187, false, 135216, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100527, 10528, 10000, 135216, false, 135269, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100528, 10529, 10000, 134581, false, 135104, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100529, 10530, 10000, 134288, false, 134501, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100530, 10531, 10000, 133910, false, 134206, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100531, 10532, 10000, 133640, false, 133752, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100532, 10533, 10000, 133302, false, 133539, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100533, 10534, 10000, 132823, false, 133218, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100534, 10535, 10000, 132329, false, 132413, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100535, 10536, 10000, 132413, false, 132744, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100536, 10537, 10000, 132327, false, 135322, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100537, 10538, 10000, 134581, false, 135118, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100538, 10539, 10000, 135118, false, 135322, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100539, 10540, 10000, 134288, false, 134501, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100540, 10541, 10000, 133910, false, 134206, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100541, 10542, 10000, 133640, false, 133752, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100542, 10543, 10000, 133302, false, 133539, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100543, 10544, 10000, 132823, false, 133218, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100544, 10545, 10000, 132327, false, 132413, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100545, 10546, 10000, 132413, false, 132744, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100546, 10547, 10000, 136123, false, 138162, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100547, 10548, 10000, 136123, false, 138162, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100548, 10549, 10000, 136123, false, 136234, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100549, 10550, 10000, 136666, false, 136731, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100550, 10551, 10000, 136731, false, 136816, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100551, 10552, 10000, 136934, false, 137758, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100552, 10553, 10000, 137847, false, 137970, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100553, 10554, 10000, 137970, false, 138162, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100554, 10555, 10000, 138512, false, 139568, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100555, 10556, 10000, 138512, false, 139568, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100556, 10557, 10000, 138512, false, 138541, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100557, 10558, 10000, 138596, false, 138778, false, 1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100558, 10559, 10000, 138862, false, 139114, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100559, 10560, 10000, 139202, false, 139345, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100560, 10561, 10000, 139487, false, 139568, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100561, 10562, 10000, 141970, false, 143183, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100562, 10563, 10000, 141970, false, 143183, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100563, 10564, 10000, 141970, false, 142137, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100564, 10565, 10000, 142137, false, 142281, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100565, 10566, 10000, 142423, false, 142639, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100566, 10567, 10000, 142710, false, 142914, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100567, 10568, 10000, 142914, false, 143183, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100568, 10569, 10000, 143563, false, 145684, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100569, 10570, 10000, 143563, false, 145650, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100570, 10571, 10000, 143563, false, 143676, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100571, 10572, 10000, 143763, false, 143772, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100572, 10573, 10000, 143772, false, 143824, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100573, 10574, 10000, 143933, false, 143977, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100574, 10575, 10000, 144063, false, 144109, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100575, 10576, 10000, 144192, false, 144227, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100576, 10577, 10000, 144314, false, 144351, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100577, 10578, 10000, 144446, false, 144559, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100578, 10579, 10000, 144926, false, 145004, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100579, 10580, 10000, 145131, false, 145207, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100580, 10581, 10000, 145344, false, 145400, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100581, 10582, 10000, 145400, false, 145650, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100582, 10583, 10000, 143714, false, 145684, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100583, 10584, 10000, 143714, false, 143772, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100584, 10585, 10000, 143772, false, 143824, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100585, 10586, 10000, 143933, false, 143977, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100586, 10587, 10000, 144063, false, 144109, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100587, 10588, 10000, 144192, false, 144227, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100588, 10589, 10000, 144314, false, 144351, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100589, 10590, 10000, 144446, false, 144559, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100590, 10591, 10000, 144926, false, 145004, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100591, 10592, 10000, 145131, false, 145207, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100592, 10593, 10000, 145344, false, 145400, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100593, 10594, 10000, 145400, false, 145684, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100594, 10595, 10000, 147152, false, 147942, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100595, 10596, 10000, 147152, false, 147942, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100596, 10597, 10000, 147152, false, 147266, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100597, 10598, 10000, 147266, false, 147333, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100598, 10599, 10000, 147451, false, 147539, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100599, 10600, 10000, 147643, false, 147740, false, 1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100600, 10601, 10000, 147740, false, 147942, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100601, 10602, 10000, 148119, false, 149806, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100602, 10603, 10000, 148119, false, 149806, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100603, 10604, 10000, 148119, false, 148318, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100604, 10605, 10000, 148318, false, 149761, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100605, 10606, 10000, 149761, false, 149806, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100606, 10607, 10000, 150688, false, 152210, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100607, 10608, 10000, 150688, false, 152210, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100608, 10609, 10000, 152085, false, 152149, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100609, 10610, 10000, 152149, false, 152210, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100610, 10611, 10000, 151931, false, 152002, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100611, 10612, 10000, 151392, false, 151731, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100612, 10613, 10000, 150688, false, 151157, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100613, 10614, 10000, 151157, false, 151298, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100614, 10615, 10000, 153112, false, 154198, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100615, 10616, 10000, 153112, false, 154198, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100616, 10617, 10000, 153112, false, 154198, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100617, 10618, 10000, 154491, false, 156011, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100618, 10619, 10000, 154491, false, 156011, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100619, 10620, 10000, 154491, false, 154565, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100620, 10621, 10000, 154565, false, 156011, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100621, 10622, 10000, 156800, false, 158655, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100622, 10623, 10000, 156800, false, 158655, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100623, 10624, 10000, 158253, false, 158536, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100624, 10625, 10000, 158536, false, 158655, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100625, 10626, 10000, 157828, false, 158112, false, -1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100626, 10627, 10000, 156800, false, 156952, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100627, 10628, 10000, 156952, false, 157756, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100628, 10629, 10000, 159855, false, 162572, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100629, 10630, 10000, 159855, false, 162572, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100630, 10631, 10000, 162486, false, 162572, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100631, 10632, 10000, 160567, false, 162219, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100632, 10633, 10000, 162219, false, 162280, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100633, 10634, 10000, 160417, false, 160478, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100634, 10635, 10000, 160078, false, 160302, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100635, 10636, 10000, 159855, false, 159934, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100636, 10637, 10000, 159934, false, 159992, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100637, 10638, 10000, 164104, false, 165517, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100638, 10639, 10000, 164104, false, 165517, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100639, 10640, 10000, 164104, false, 165517, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100640, 10641, 10000, 166588, false, 167842, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100641, 10642, 10000, 166617, false, 167842, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100642, 10643, 10000, 166617, false, 166928, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100643, 10644, 10000, 166928, false, 167798, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100644, 10645, 10000, 167798, false, 167842, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100645, 10646, 10000, 166588, false, 167842, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100646, 10647, 10000, 167013, false, 167798, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100647, 10648, 10000, 167798, false, 167842, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100648, 10649, 10000, 166588, false, 166852, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100649, 10650, 10000, 166852, false, 166871, false, -1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100650, 10651, 10000, 168722, false, 171165, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100651, 10652, 10000, 168722, false, 171165, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100652, 10653, 10000, 168722, false, 168801, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100653, 10654, 10000, 169036, false, 169114, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100654, 10655, 10000, 169114, false, 169257, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100655, 10656, 10000, 169346, false, 169509, false, 1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100656, 10657, 10000, 169599, false, 169710, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100657, 10658, 10000, 169805, false, 169993, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100658, 10659, 10000, 170070, false, 170162, false, 1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100659, 10660, 10000, 170265, false, 170313, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100660, 10661, 10000, 170411, false, 170507, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100661, 10662, 10000, 170621, false, 170760, false, 1, 2, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100662, 10663, 10000, 170850, false, 171154, false, 1, 1, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100663, 10664, 10000, 171154, false, 171165, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100664, 10665, 10000, 3759, false, 5630, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100665, 10666, 10000, 6914, false, 8666, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100666, 10667, 10000, 7314, false, 8666, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100667, 10668, 10000, 11863, false, 12940, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100668, 10669, 10000, 23518, false, 31079, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100669, 10670, 10000, 23518, false, 31079, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100670, 10671, 10000, 31381, false, 32670, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100671, 10672, 10000, 33991, false, 37061, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100672, 10673, 10000, 33991, false, 37061, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100673, 10674, 10000, 33991, false, 37061, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100674, 10675, 10000, 33991, false, 37061, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100675, 10676, 10000, 33991, false, 36836, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100676, 10677, 10000, 38897, false, 40877, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100677, 10678, 10000, 38897, false, 40597, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100678, 10679, 10000, 44676, false, 44787, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100679, 10680, 10000, 45502, false, 46789, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100680, 10681, 10000, 45502, false, 46789, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100681, 10682, 10000, 47704, false, 49166, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100682, 10683, 10000, 50283, false, 50954, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100683, 10684, 10000, 50283, false, 50954, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100684, 10685, 10000, 50283, false, 50954, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100685, 10686, 10000, 50283, false, 50954, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100686, 10687, 10000, 52238, false, 54494, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100687, 10688, 10000, 53021, false, 54494, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100688, 10689, 10000, 56623, false, 56740, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100689, 10690, 10000, 57391, false, 58978, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100690, 10691, 10000, 61904, false, 63811, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100691, 10692, 10000, 64397, false, 67512, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100692, 10693, 10000, 64397, false, 67512, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100693, 10694, 10000, 64397, false, 67512, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100694, 10695, 10000, 70114, false, 71998, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100695, 10696, 10000, 72582, false, 73883, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100696, 10697, 10000, 72582, false, 73883, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100697, 10698, 10000, 74104, false, 74443, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100698, 10699, 10000, 74104, false, 74443, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100699, 10700, 10000, 75632, false, 76556, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100700, 10701, 10000, 83044, false, 84864, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100701, 10702, 10000, 86714, false, 88145, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100702, 10703, 10000, 88976, false, 89529, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100703, 10704, 10000, 91749, false, 95552, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100704, 10705, 10000, 96063, false, 97242, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100705, 10706, 10000, 97619, false, 99046, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100706, 10707, 10000, 100682, false, 101678, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100707, 10708, 10000, 100682, false, 101678, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100708, 10709, 10000, 100682, false, 101678, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100709, 10710, 10000, 104730, false, 105309, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100710, 10711, 10000, 109594, false, 111367, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100711, 10712, 10000, 109594, false, 111367, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100712, 10713, 10000, 109594, false, 111367, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100713, 10714, 10000, 112289, false, 113905, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100714, 10715, 10000, 114298, false, 115296, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100715, 10716, 10000, 114298, false, 115296, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100716, 10717, 10000, 117064, false, 118522, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100717, 10718, 10000, 119428, false, 119854, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100718, 10719, 10000, 120220, false, 120946, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100719, 10720, 10000, 121581, false, 130099, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100720, 10721, 10000, 121581, false, 130099, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100721, 10722, 10000, 132413, false, 135216, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100722, 10723, 10000, 132413, false, 135118, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100723, 10724, 10000, 136731, false, 137970, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100724, 10725, 10000, 138512, false, 139568, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100725, 10726, 10000, 142137, false, 142914, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100726, 10727, 10000, 143772, false, 145400, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100727, 10728, 10000, 143772, false, 145400, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100728, 10729, 10000, 147266, false, 147740, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100729, 10730, 10000, 148318, false, 149761, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100730, 10731, 10000, 151157, false, 152149, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100731, 10732, 10000, 153112, false, 154198, false, 1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100732, 10733, 10000, 154565, false, 156011, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100733, 10734, 10000, 156952, false, 158536, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100734, 10735, 10000, 159934, false, 162219, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100735, 10736, 10000, 164104, false, 165517, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100736, 10737, 10000, 166928, false, 167798, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100737, 10738, 10000, 166852, false, 167798, false, -1, NULL, NULL, 0, 0);
INSERT INTO chado.featureloc VALUES (100738, 10739, 10000, 169114, false, 171154, false, 1, NULL, NULL, 0, 0);


--
-- Data for Name: featureloc_pub; Type: TABLE DATA; Schema: chado; Owner: -
--



--
-- Data for Name: featuremap; Type: TABLE DATA; Schema: chado; Owner: -
--

INSERT INTO chado.featuremap VALUES (1, 'fred', 'heya', 99);


--
-- Data for Name: featuremap_contact; Type: TABLE DATA; Schema: chado; Owner: -
--

INSERT INTO chado.featuremap_contact VALUES (2, 1, 1);


--
-- Data for Name: featuremap_dbxref; Type: TABLE DATA; Schema: chado; Owner: -
--



--
-- Data for Name: featuremap_organism; Type: TABLE DATA; Schema: chado; Owner: -
--



--
-- Data for Name: featuremap_pub; Type: TABLE DATA; Schema: chado; Owner: -
--



--
-- Data for Name: featuremapprop; Type: TABLE DATA; Schema: chado; Owner: -
--



--
-- Data for Name: featurepos; Type: TABLE DATA; Schema: chado; Owner: -
--



--
-- Data for Name: featureposprop; Type: TABLE DATA; Schema: chado; Owner: -
--



--
-- Data for Name: featureprop; Type: TABLE DATA; Schema: chado; Owner: -
--

INSERT INTO chado.featureprop VALUES (100000, 10002, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100001, 10012, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100002, 10025, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100003, 10037, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100004, 10043, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100005, 10066, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100006, 10090, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100007, 10102, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100008, 10114, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100009, 10125, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100010, 10138, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100011, 10150, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100012, 10163, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100013, 10172, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100014, 10181, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100015, 10184, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100016, 10191, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100017, 10199, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100018, 10206, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100019, 10213, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100020, 10220, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100021, 10227, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100022, 10236, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100023, 10243, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100024, 10250, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100025, 10253, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100026, 10258, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100027, 10263, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100028, 10280, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100029, 10297, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100030, 10315, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100031, 10322, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100032, 10331, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100033, 10340, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100034, 10346, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100035, 10353, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100036, 10358, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100037, 10362, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100038, 10368, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100039, 10375, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100040, 10387, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100041, 10393, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100042, 10400, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100043, 10405, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100044, 10410, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100045, 10415, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100046, 10420, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100047, 10424, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100048, 10429, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100049, 10435, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100050, 10441, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100051, 10446, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100052, 10453, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100053, 10458, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100054, 10463, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100055, 10468, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100056, 10496, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100057, 10525, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100058, 10537, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100059, 10548, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100060, 10556, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100061, 10563, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100062, 10570, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100063, 10583, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100064, 10596, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100065, 10603, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100066, 10608, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100067, 10616, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100068, 10619, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100069, 10623, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100070, 10630, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100071, 10639, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100072, 10642, 10000, '1', 0);
INSERT INTO chado.featureprop VALUES (100073, 10646, 10000, '0', 0);
INSERT INTO chado.featureprop VALUES (100074, 10652, 10000, '1', 0);
INSERT INTO chado.contact VALUES (20000, NULL, 'Me', 'Myself and I');
INSERT INTO chado.feature_contact VALUES (20000, 10001, 20000);
