--
-- CREATED BY:
-- 1. Creating a fresh chado instance and preparing it through the UI.
-- 2. Exporting it via pg_dump --data-only --file=fill_chado_test_prepare.sql --schema=chado --no-owner --inserts --user docker sitedb
-- 3. Remove all SQL Comments `--`
-- 4. Remove all empty lines.
-- 5. Remove all `CREATE INDEX` commands.
-- 6. Remove all `SELECT pg_catalog.setval(.*, 1, false)` statements
-- 7. Add in the `CREATE TABLE commands for the custom tables and mviews.
-- Detailed instructions https://github.com/tripal/tripal/issues/1848#issuecomment-2052189642
--
CREATE TABLE chado.analysis_organism (
    analysis_id bigint NOT NULL,
    organism_id bigint NOT NULL
);
COMMENT ON TABLE chado.analysis_organism IS 'This view is for associating an organism (via it''s associated features) to an analysis.';
CREATE TABLE chado.cv_root_mview (
    name character varying(255) NOT NULL,
    cvterm_id bigint NOT NULL,
    cv_id bigint NOT NULL,
    cv_name character varying(255) NOT NULL
);
COMMENT ON TABLE chado.cv_root_mview IS 'A list of the root terms for all controlled vocabularies. This is needed for viewing CV trees';
CREATE TABLE chado.db2cv_mview (
    cv_id integer NOT NULL,
    cvname character varying(255) NOT NULL,
    db_id integer NOT NULL,
    dbname character varying(255) NOT NULL,
    num_terms integer NOT NULL
);
COMMENT ON TABLE chado.db2cv_mview IS 'A table for quick lookup of the vocabularies and the databases they are associated with.';
CREATE TABLE chado.library_feature_count (
    library_id bigint NOT NULL,
    name character varying(255) NOT NULL,
    num_features integer NOT NULL,
    feature_type character varying(255) NOT NULL
);
COMMENT ON TABLE chado.library_feature_count IS 'Provides count of feature by type that are associated with all libraries';
CREATE TABLE chado.organism_feature_count (
    organism_id bigint NOT NULL,
    genus character varying(255) NOT NULL,
    species character varying(255) NOT NULL,
    common_name character varying(255),
    num_features integer NOT NULL,
    cvterm_id bigint NOT NULL,
    feature_type character varying(255) NOT NULL
);
COMMENT ON TABLE chado.organism_feature_count IS 'Stores the type and number of features per organism';
CREATE TABLE chado.organism_stock_count (
    organism_id bigint NOT NULL,
    genus character varying(255) NOT NULL,
    species character varying(255) NOT NULL,
    common_name character varying(255),
    num_stocks integer NOT NULL,
    cvterm_id bigint NOT NULL,
    stock_type character varying(255) NOT NULL
);
COMMENT ON TABLE chado.organism_stock_count IS 'Stores the type and number of stocks per organism';
CREATE TABLE chado.tripal_gff_temp (
    feature_id integer NOT NULL,
    organism_id integer NOT NULL,
    uniquename text NOT NULL,
    type_name character varying(1024) NOT NULL
);
CREATE TABLE chado.tripal_gffcds_temp (
    feature_id integer NOT NULL,
    parent_id integer NOT NULL,
    phase integer,
    strand integer NOT NULL,
    fmin integer NOT NULL,
    fmax integer NOT NULL
);
CREATE TABLE chado.tripal_gffprotein_temp (
    feature_id integer NOT NULL,
    parent_id integer NOT NULL,
    fmin integer NOT NULL,
    fmax integer NOT NULL
);
CREATE TABLE chado.tripal_obo_temp (
    id character varying(255) NOT NULL,
    stanza text NOT NULL,
    type character varying(50) NOT NULL
);
SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;
INSERT INTO chado.cv VALUES (3, 'Statistical Terms', 'Locally created terms for statistics');
INSERT INTO chado.cv VALUES (4, 'chado_properties', 'Terms that are used in the chadoprop table to describe the state of the database');
INSERT INTO chado.cv VALUES (5, 'germplasm_ontology', 'GCP germplasm ontology');
INSERT INTO chado.cv VALUES (6, 'dc', 'DCMI Metadata Terms');
INSERT INTO chado.cv VALUES (7, 'EDAM', 'Bioscientific data analysis ontology');
INSERT INTO chado.cv VALUES (8, 'efo', 'The Experimental Factor Ontology (EFO) provides a systematic description of many experimental variables available in EBI databases, and for external projects such as the NHGRI GWAS catalogue. It combines parts of several biological ontologies, such as anatomy, disease and chemical compounds. The scope of EFO is to support the annotation, analysis and visualization of data handled by many groups at the EBI and as the core ontology for OpenTargets.org');
INSERT INTO chado.cv VALUES (9, 'ero', 'The Eagle-I Research Resource Ontology models research resources such instruments. protocols, reagents, animal models and biospecimens. It has been developed in the context of the eagle-i project (http://eagle-i.net/).');
INSERT INTO chado.cv VALUES (10, 'GEO', 'Geographical Entity Ontology');
INSERT INTO chado.cv VALUES (11, 'OBCS', 'Ontology of Biological and Clinical Statistics');
INSERT INTO chado.cv VALUES (12, 'obi', 'Ontology for Biomedical Investigation. The Ontology for Biomedical Investigations (OBI) is build in a collaborative, international effort and will serve as a resource for annotating biomedical investigations, including the study design, protocols and instrumentation used, the data generated and the types of analysis performed on the data. This ontology arose from the Functional Genomics Investigation Ontology (FuGO) and will contain both terms that are common to all biomedical investigations, including functional genomics investigations and those that are more domain specific');
INSERT INTO chado.cv VALUES (13, 'ogi', 'Ontology for genetic interval');
INSERT INTO chado.cv VALUES (14, 'IAO', 'Information Artifact Ontology');
INSERT INTO chado.cv VALUES (1, 'null', 'No vocabulary');
INSERT INTO chado.cv VALUES (2, 'local', 'Locally created terms');
INSERT INTO chado.cv VALUES (15, 'sbo', 'Systems Biology.  Terms commonly used in Systems Biology, and in particular in computational modeling.');
INSERT INTO chado.cv VALUES (16, 'swo', 'Bioinformatics operations, data types, formats, identifiers and topics');
INSERT INTO chado.cv VALUES (17, 'PMID', 'PubMed.');
INSERT INTO chado.cv VALUES (18, 'uo', 'Units of Measurement Ontology');
INSERT INTO chado.cv VALUES (19, 'ncit', 'NCI Thesaurus OBO Edition');
INSERT INTO chado.cv VALUES (20, 'ncbitaxon', 'NCBI organismal classification. An ontology representation of the NCBI organismal taxonomy');
INSERT INTO chado.cv VALUES (21, 'rdfs', 'Resource Description Framework Schema');
INSERT INTO chado.cv VALUES (22, 'ro', 'Relationship Ontology (legacy)');
INSERT INTO chado.cv VALUES (23, 'sequence', 'The Sequence Ontology');
INSERT INTO chado.cv VALUES (24, 'taxonomic_rank', 'Taxonomic Rank');
INSERT INTO chado.cv VALUES (25, 'tripal_contact', 'Tripal Contact Ontology');
INSERT INTO chado.cv VALUES (26, 'tripal_pub', 'Tripal Publication Ontology');
INSERT INTO chado.cv VALUES (27, 'hydra', 'A Vocabulary for Hypermedia-Driven Web APIs.');
INSERT INTO chado.cv VALUES (28, 'schema', 'Schema.org. Schema.org is sponsored by Google, Microsoft, Yahoo and Yandex. The vocabularies are developed by an open community process.');
INSERT INTO chado.cv VALUES (29, 'sep', 'A structured controlled vocabulary for the annotation of sample processing and separation techniques in scientific experiments.');
INSERT INTO chado.cv VALUES (30, 'SIO', 'The Semanticscience Integrated Ontology (SIO) provides a simple, integrated ontology of types and relations for rich description of objects, processes and their attributes.');
INSERT INTO chado.cv VALUES (31, 'cellular_component', NULL);
INSERT INTO chado.cv VALUES (32, 'synonym_type', NULL);
INSERT INTO chado.cv VALUES (33, 'PBO', 'Plant Breeding Ontology');
INSERT INTO chado.db VALUES (19, 'UO', 'Units of Measurement Ontology', 'http://purl.obolibrary.org/obo/UO_{accession}', 'http://purl.obolibrary.org/obo/uo');
INSERT INTO chado.db VALUES (2, 'CO_010', 'Crop Germplasm Ontology', 'http://www.cropontology.org/terms/CO_010:{accession}', 'http://www.cropontology.org/get-ontology/CO_010');
INSERT INTO chado.db VALUES (11, 'OBCS', 'Ontology of Biological and Clinical Statistics', 'http://purl.obolibrary.org/obo/{db}_{accession}', 'https://github.com/obcs/obcs');
INSERT INTO chado.db VALUES (3, 'dc', 'DCMI Metadata Terms', 'http://purl.org/dc/terms/{accession}', 'http://purl.org/dc/dcmitype/');
INSERT INTO chado.db VALUES (39, 'https', '', NULL, '');
INSERT INTO chado.db VALUES (20, 'NCIT', 'The NCIt is a reference terminology that includes broad coverage of the cancer domain, including cancer related diseases, findings and abnormalities. NCIt OBO Edition releases should be considered experimental.', 'http://purl.obolibrary.org/obo/{db}_{accession}', 'http://purl.obolibrary.org/obo/ncit.owl');
INSERT INTO chado.db VALUES (12, 'OBI', 'The Ontology for Biomedical Investigation', 'http://purl.obolibrary.org/obo/{db}_{accession}', 'http://obi-ontology.org/page/Main_Page');
INSERT INTO chado.db VALUES (40, 'doi', '', NULL, '');
INSERT INTO chado.db VALUES (25, 'TAXRANK', 'A vocabulary of taxonomic ranks (species, family, phylum, etc)', 'http://purl.obolibrary.org/obo/{db}_{accession}', 'http://www.obofoundry.org/ontology/taxrank.html');
INSERT INTO chado.db VALUES (13, 'OGI', 'Ontology for genetic interval', 'http://purl.obolibrary.org/obo/{db}_{accession}', 'http://purl.bioontology.org/ontology/OGI');
INSERT INTO chado.db VALUES (4, 'data', 'Bioinformatics operations, data types, formats, identifiers and topics.', 'http://edamontology.org/{db}_{accession}', 'http://edamontology.org/page');
INSERT INTO chado.db VALUES (5, 'format', 'A defined way or layout of representing and structuring data in a computer file, blob, string, message, or elsewhere. The main focus in EDAM lies on formats as means of structuring data exchanged between different tools or resources.', 'http://edamontology.org/{db}_{accession}', 'http://edamontology.org/page');
INSERT INTO chado.db VALUES (6, 'operation', 'A function that processes a set of inputs and results in a set of outputs, or associates arguments (inputs) with values (outputs). Special cases are: a) An operation that consumes no input (has no input arguments).', 'http://edamontology.org/{db}_{accession}', 'http://edamontology.org/page');
INSERT INTO chado.db VALUES (21, 'NCBITaxon', 'NCBI organismal classification', 'https://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?id={accession}', 'http://www.berkeleybop.org/ontologies/ncbitaxon/');
INSERT INTO chado.db VALUES (7, 'topic', 'A category denoting a rather broad domain or field of interest, of study, application, work, data, or technology. Topics have no clearly defined borders between each other.', 'http://edamontology.org/{db}_{accession}', 'http://edamontology.org/page');
INSERT INTO chado.db VALUES (14, 'IAO', 'Information Artifact Ontology', 'http://purl.obolibrary.org/obo/{db}_{accession}', 'https://github.com/information-artifact-ontology/IAO/');
INSERT INTO chado.db VALUES (8, 'EFO', 'Experimental Factor Ontology', 'http://www.ebi.ac.uk/efo/{db}_{accession}', 'http://www.ebi.ac.uk/efo/efo.owl');
INSERT INTO chado.db VALUES (29, 'schema', 'Schema.org', 'https://schema.org/{accession}', 'https://schema.org/');
INSERT INTO chado.db VALUES (1, 'null', 'No database', 'cv/lookup/{db}/{accession}', 'cv/lookup/null');
INSERT INTO chado.db VALUES (9, 'ERO', 'The Eagle-I Research Resource Ontology', 'http://purl.bioontology.org/ontology/ERO/{db}:{accession}', 'http://purl.bioontology.org/ontology/ERO');
INSERT INTO chado.db VALUES (22, 'rdfs', 'Resource Description Framework Schema', 'http://www.w3.org/2000/01/rdf-schema#{accession}', 'https://www.w3.org/TR/rdf-schema/');
INSERT INTO chado.db VALUES (10, 'GEO', 'An ontology of geographical entities', 'http://purl.obolibrary.org/obo/{$db}_{accession}', 'https://github.com/mcwdsi/geographical-entity-ontology/wiki');
INSERT INTO chado.db VALUES (26, 'TCONTACT', 'Tripal Contact Ontology. A temporary ontology until a more formal appropriate ontology can be identified.', 'cv/lookup/TCONTACT/{accession}', 'cv/lookup/TCONTACT');
INSERT INTO chado.db VALUES (15, 'local', 'Terms created for this site', 'cv/lookup/{db}/{accession}', 'cv/lookup/local');
INSERT INTO chado.db VALUES (23, 'RO', 'Relationship Ontology (legacy)', 'cv/lookup/RO/{accession}', 'cv/lookup/RO');
INSERT INTO chado.db VALUES (16, 'SBO', 'Systems Biology Ontology', 'http://purl.obolibrary.org/obo/{db}_{accession}', 'http://www.ebi.ac.uk/sbo/main/');
INSERT INTO chado.db VALUES (17, 'SWO', 'Bioinformatics operations, data types, formats, identifiers and topics', 'http://www.ebi.ac.uk/swo/{db}_{accession}', 'http://purl.obolibrary.org/obo/swo');
INSERT INTO chado.db VALUES (27, 'TPUB', 'Tripal Publication Ontology. A temporary ontology until a more formal appropriate ontology can be identified.', 'cv/lookup/TPUB/{accession}', 'cv/lookup/TPUB');
INSERT INTO chado.db VALUES (24, 'SO', 'The Sequence Ontology', 'http://www.sequenceontology.org/browser/current_svn/term/{db}:{accession}', 'http://www.sequenceontology.org');
INSERT INTO chado.db VALUES (18, 'PMID', 'PubMed', 'http://www.ncbi.nlm.nih.gov/pubmed/{accession}', 'http://www.ncbi.nlm.nih.gov/pubmed');
INSERT INTO chado.db VALUES (30, 'sep', 'Sample processing and separation techniques.', 'http://purl.obolibrary.org/obo/{db}_{accession}', 'http://psidev.info/index.php?q=node/312');
INSERT INTO chado.db VALUES (28, 'hydra', 'A Vocabulary for Hypermedia-Driven Web APIs', 'http://www.w3.org/ns/hydra/core#{accession}', 'http://www.w3.org/ns/hydra/core');
INSERT INTO chado.db VALUES (31, 'SIO', 'Semanticscience Integrated Ontology', 'http://semanticscience.org/resource/{db}_{accession}', 'http://sio.semanticscience.org/');
INSERT INTO chado.db VALUES (32, 'GO', NULL, NULL, NULL);
INSERT INTO chado.db VALUES (33, 'synonym_type', NULL, NULL, NULL);
INSERT INTO chado.db VALUES (34, 'loinc', '', NULL, '');
INSERT INTO chado.db VALUES (35, 'BS', '', NULL, '');
INSERT INTO chado.db VALUES (36, 'RNAMOD', '', NULL, '');
INSERT INTO chado.db VALUES (37, 'MOD', '', NULL, '');
INSERT INTO chado.db VALUES (38, 'wikipedia', '', NULL, '');
INSERT INTO chado.db VALUES (41, 'PBO', 'Plant Breeding Ontology (PBO): an ontology for the plant breeding community which captures more than 2200 entries where 80 represent the core terms.', 'https://agroportal.lirmm.fr/ontologies/PBO/PBO_{accession}', 'https://agroportal.lirmm.fr/ontologies/PBO');
INSERT INTO chado.dbxref VALUES (1, 1, 'local:null', '', NULL);
INSERT INTO chado.dbxref VALUES (2, 1, 'chado_properties:version', '', NULL);
INSERT INTO chado.dbxref VALUES (3, 2, '0000044', '', NULL);
INSERT INTO chado.dbxref VALUES (4, 2, '0000255', '', NULL);
INSERT INTO chado.dbxref VALUES (5, 2, '0000029', '', NULL);
INSERT INTO chado.dbxref VALUES (6, 2, '0000162', '', NULL);
INSERT INTO chado.dbxref VALUES (7, 3, 'Service', '', NULL);
INSERT INTO chado.dbxref VALUES (8, 4, '1249', '', NULL);
INSERT INTO chado.dbxref VALUES (9, 4, '2190', '', NULL);
INSERT INTO chado.dbxref VALUES (10, 4, '2091', '', NULL);
INSERT INTO chado.dbxref VALUES (11, 4, '2044', '', NULL);
INSERT INTO chado.dbxref VALUES (12, 4, '0849', '', NULL);
INSERT INTO chado.dbxref VALUES (13, 4, '0842', '', NULL);
INSERT INTO chado.dbxref VALUES (14, 4, '2976', '', NULL);
INSERT INTO chado.dbxref VALUES (15, 4, '2968', '', NULL);
INSERT INTO chado.dbxref VALUES (16, 4, '1274', '', NULL);
INSERT INTO chado.dbxref VALUES (17, 4, '1278', '', NULL);
INSERT INTO chado.dbxref VALUES (18, 4, '1280', '', NULL);
INSERT INTO chado.dbxref VALUES (19, 4, '2012', '', NULL);
INSERT INTO chado.dbxref VALUES (20, 4, '1056', '', NULL);
INSERT INTO chado.dbxref VALUES (21, 4, '1048', '', NULL);
INSERT INTO chado.dbxref VALUES (22, 4, '1047', '', NULL);
INSERT INTO chado.dbxref VALUES (23, 4, '2336', '', NULL);
INSERT INTO chado.dbxref VALUES (24, 4, '0853', '', NULL);
INSERT INTO chado.dbxref VALUES (25, 4, '3002', '', NULL);
INSERT INTO chado.dbxref VALUES (26, 4, '0872', '', NULL);
INSERT INTO chado.dbxref VALUES (27, 4, '3272', '', NULL);
INSERT INTO chado.dbxref VALUES (28, 4, '3271', '', NULL);
INSERT INTO chado.dbxref VALUES (29, 6, '0567', '', NULL);
INSERT INTO chado.dbxref VALUES (30, 6, '0564', '', NULL);
INSERT INTO chado.dbxref VALUES (31, 6, '0525', '', NULL);
INSERT INTO chado.dbxref VALUES (32, 6, '0362', '', NULL);
INSERT INTO chado.dbxref VALUES (33, 6, '2945', '', NULL);
INSERT INTO chado.dbxref VALUES (34, 4, '1017', '', NULL);
INSERT INTO chado.dbxref VALUES (35, 8, '0000548', '', NULL);
INSERT INTO chado.dbxref VALUES (36, 8, '0000269', '', NULL);
INSERT INTO chado.dbxref VALUES (37, 8, '0005522', '', NULL);
INSERT INTO chado.dbxref VALUES (38, 8, '0001728', '', NULL);
INSERT INTO chado.dbxref VALUES (39, 9, '0001716', '', NULL);
INSERT INTO chado.dbxref VALUES (40, 9, '0000387', '', NULL);
INSERT INTO chado.dbxref VALUES (41, 10, '000000788', '', NULL);
INSERT INTO chado.dbxref VALUES (42, 11, '0000117', '', NULL);
INSERT INTO chado.dbxref VALUES (43, 12, '0100026', '', NULL);
INSERT INTO chado.dbxref VALUES (44, 12, '0000070', '', NULL);
INSERT INTO chado.dbxref VALUES (45, 13, '0000021', '', NULL);
INSERT INTO chado.dbxref VALUES (46, 14, '0000064', '', NULL);
INSERT INTO chado.dbxref VALUES (47, 14, '0000098', '', NULL);
INSERT INTO chado.dbxref VALUES (48, 14, '0000101', '', NULL);
INSERT INTO chado.dbxref VALUES (49, 14, '0000115', '', NULL);
INSERT INTO chado.dbxref VALUES (50, 14, '0000129', '', NULL);
INSERT INTO chado.dbxref VALUES (51, 15, 'property', '', NULL);
INSERT INTO chado.dbxref VALUES (52, 15, 'timelastmodified', '', NULL);
INSERT INTO chado.dbxref VALUES (53, 15, 'timeaccessioned', '', NULL);
INSERT INTO chado.dbxref VALUES (54, 15, 'timeexecuted', '', NULL);
INSERT INTO chado.dbxref VALUES (55, 15, 'infraspecific_type', '', NULL);
INSERT INTO chado.dbxref VALUES (56, 15, 'abbreviation', '', NULL);
INSERT INTO chado.dbxref VALUES (57, 15, 'expression', '', NULL);
INSERT INTO chado.dbxref VALUES (58, 15, 'is_analysis', '', NULL);
INSERT INTO chado.dbxref VALUES (59, 15, 'is_obsolete', '', NULL);
INSERT INTO chado.dbxref VALUES (60, 15, 'is_current', '', NULL);
INSERT INTO chado.dbxref VALUES (61, 15, 'is_internal', '', NULL);
INSERT INTO chado.dbxref VALUES (62, 15, 'miniref', '', NULL);
INSERT INTO chado.dbxref VALUES (63, 15, 'array_batch_identifier', '', NULL);
INSERT INTO chado.dbxref VALUES (64, 15, 'relationship_subject', '', NULL);
INSERT INTO chado.dbxref VALUES (65, 15, 'relationship_object', '', NULL);
INSERT INTO chado.dbxref VALUES (66, 15, 'relationship_type', '', NULL);
INSERT INTO chado.dbxref VALUES (67, 15, 'fasta_definition', '', NULL);
INSERT INTO chado.dbxref VALUES (68, 15, 'Reference Feature', '', NULL);
INSERT INTO chado.dbxref VALUES (69, 15, 'fmin', '', NULL);
INSERT INTO chado.dbxref VALUES (70, 15, 'is_fmin_partial', '', NULL);
INSERT INTO chado.dbxref VALUES (71, 15, 'fmax', '', NULL);
INSERT INTO chado.dbxref VALUES (72, 15, 'is_fmax_partial', '', NULL);
INSERT INTO chado.dbxref VALUES (73, 15, 'residue_info', '', NULL);
INSERT INTO chado.dbxref VALUES (74, 15, 'locgroup', '', NULL);
INSERT INTO chado.dbxref VALUES (75, 15, 'analysis', '', NULL);
INSERT INTO chado.dbxref VALUES (76, 15, 'source_data', '', NULL);
INSERT INTO chado.dbxref VALUES (77, 15, 'rawscore', '', NULL);
INSERT INTO chado.dbxref VALUES (78, 15, 'normscore', '', NULL);
INSERT INTO chado.dbxref VALUES (79, 15, 'significance', '', NULL);
INSERT INTO chado.dbxref VALUES (80, 15, 'identity', '', NULL);
INSERT INTO chado.dbxref VALUES (81, 15, 'contact', '', NULL);
INSERT INTO chado.dbxref VALUES (82, 15, 'relationship', '', NULL);
INSERT INTO chado.dbxref VALUES (83, 15, 'biomaterial', '', NULL);
INSERT INTO chado.dbxref VALUES (84, 15, 'array_dimensions', '', NULL);
INSERT INTO chado.dbxref VALUES (85, 15, 'element_dimensions', '', NULL);
INSERT INTO chado.dbxref VALUES (86, 15, 'num_of_elements', '', NULL);
INSERT INTO chado.dbxref VALUES (87, 15, 'num_array_columns', '', NULL);
INSERT INTO chado.dbxref VALUES (88, 15, 'num_array_rows', '', NULL);
INSERT INTO chado.dbxref VALUES (89, 15, 'num_grid_columns', '', NULL);
INSERT INTO chado.dbxref VALUES (90, 15, 'num_grid_rows', '', NULL);
INSERT INTO chado.dbxref VALUES (91, 15, 'num_sub_columns', '', NULL);
INSERT INTO chado.dbxref VALUES (92, 15, 'num_sub_rows', '', NULL);
INSERT INTO chado.dbxref VALUES (93, 15, 'Genome Project', '', NULL);
INSERT INTO chado.dbxref VALUES (94, 15, 'rank', '', NULL);
INSERT INTO chado.dbxref VALUES (95, 15, 'lineage', '', NULL);
INSERT INTO chado.dbxref VALUES (96, 15, 'genetic_code', '', NULL);
INSERT INTO chado.dbxref VALUES (97, 15, 'genetic_code_name', '', NULL);
INSERT INTO chado.dbxref VALUES (98, 15, 'mitochondrial_genetic_code', '', NULL);
INSERT INTO chado.dbxref VALUES (99, 15, 'mitochondrial_genetic_code_name', '', NULL);
INSERT INTO chado.dbxref VALUES (100, 15, 'division', '', NULL);
INSERT INTO chado.dbxref VALUES (101, 15, 'genbank_common_name', '', NULL);
INSERT INTO chado.dbxref VALUES (102, 15, 'synonym', '', NULL);
INSERT INTO chado.dbxref VALUES (103, 15, 'synonym_sgml', '', NULL);
INSERT INTO chado.dbxref VALUES (104, 15, 'other_name', '', NULL);
INSERT INTO chado.dbxref VALUES (105, 15, 'equivalent_name', '', NULL);
INSERT INTO chado.dbxref VALUES (106, 15, 'anamorph', '', NULL);
INSERT INTO chado.dbxref VALUES (107, 15, 'Analysis Type', '', NULL);
INSERT INTO chado.dbxref VALUES (108, 15, 'phylo_leaf', '', NULL);
INSERT INTO chado.dbxref VALUES (109, 15, 'phylo_root', '', NULL);
INSERT INTO chado.dbxref VALUES (110, 15, 'phylo_interior', '', NULL);
INSERT INTO chado.dbxref VALUES (111, 15, 'taxonomy', '', NULL);
INSERT INTO chado.dbxref VALUES (112, 15, 'cM', '', NULL);
INSERT INTO chado.dbxref VALUES (113, 15, 'bp', '', NULL);
INSERT INTO chado.dbxref VALUES (114, 15, 'bin_unit', '', NULL);
INSERT INTO chado.dbxref VALUES (115, 15, 'marker_order', '', NULL);
INSERT INTO chado.dbxref VALUES (116, 15, 'undefined', '', NULL);
INSERT INTO chado.dbxref VALUES (117, 15, 'start', '', NULL);
INSERT INTO chado.dbxref VALUES (118, 15, 'stop', '', NULL);
INSERT INTO chado.dbxref VALUES (119, 15, 'Map Dbxref', '', NULL);
INSERT INTO chado.dbxref VALUES (120, 15, 'Map Type', '', NULL);
INSERT INTO chado.dbxref VALUES (121, 15, 'Genome Group', '', NULL);
INSERT INTO chado.dbxref VALUES (122, 15, 'URL', '', NULL);
INSERT INTO chado.dbxref VALUES (123, 15, 'Population Type', '', NULL);
INSERT INTO chado.dbxref VALUES (124, 15, 'Population Size', '', NULL);
INSERT INTO chado.dbxref VALUES (125, 15, 'Methods', '', NULL);
INSERT INTO chado.dbxref VALUES (126, 15, 'Software', '', NULL);
INSERT INTO chado.dbxref VALUES (127, 15, 'library', '', NULL);
INSERT INTO chado.dbxref VALUES (128, 15, 'library_description', '', NULL);
INSERT INTO chado.dbxref VALUES (129, 15, 'cdna_library', '', NULL);
INSERT INTO chado.dbxref VALUES (130, 15, 'bac_library', '', NULL);
INSERT INTO chado.dbxref VALUES (131, 15, 'fosmid_library', '', NULL);
INSERT INTO chado.dbxref VALUES (132, 15, 'cosmid_library', '', NULL);
INSERT INTO chado.dbxref VALUES (133, 15, 'yac_library', '', NULL);
INSERT INTO chado.dbxref VALUES (134, 15, 'genomic_library', '', NULL);
INSERT INTO chado.dbxref VALUES (135, 15, 'Project Description', '', NULL);
INSERT INTO chado.dbxref VALUES (136, 15, 'Project Type', '', NULL);
INSERT INTO chado.dbxref VALUES (137, 15, 'Study Type', '', NULL);
INSERT INTO chado.dbxref VALUES (138, 15, 'analysis_date', '', NULL);
INSERT INTO chado.dbxref VALUES (139, 15, 'analysis_short_name', '', NULL);
INSERT INTO chado.dbxref VALUES (140, 15, 'Genotyping', '', NULL);
INSERT INTO chado.dbxref VALUES (141, 15, 'Phenotyping', '', NULL);
INSERT INTO chado.dbxref VALUES (142, 15, 'Location', '', NULL);
INSERT INTO chado.dbxref VALUES (143, 16, '0000358', '', NULL);
INSERT INTO chado.dbxref VALUES (144, 16, '0000552', '', NULL);
INSERT INTO chado.dbxref VALUES (145, 16, '0000554', '', NULL);
INSERT INTO chado.dbxref VALUES (146, 16, '0000374', '', NULL);
INSERT INTO chado.dbxref VALUES (147, 17, '0000001', '', NULL);
INSERT INTO chado.dbxref VALUES (148, 19, '0000000', '', NULL);
INSERT INTO chado.dbxref VALUES (149, 20, 'C25164', '', NULL);
INSERT INTO chado.dbxref VALUES (150, 20, 'C48036', '', NULL);
INSERT INTO chado.dbxref VALUES (151, 20, 'C45378', '', NULL);
INSERT INTO chado.dbxref VALUES (152, 20, 'C25712', '', NULL);
INSERT INTO chado.dbxref VALUES (153, 20, 'C44170', '', NULL);
INSERT INTO chado.dbxref VALUES (154, 20, 'C48697', '', NULL);
INSERT INTO chado.dbxref VALUES (155, 20, 'C45559', '', NULL);
INSERT INTO chado.dbxref VALUES (156, 20, 'C80488', '', NULL);
INSERT INTO chado.dbxref VALUES (157, 20, 'C16977', '', NULL);
INSERT INTO chado.dbxref VALUES (158, 20, 'C16631', '', NULL);
INSERT INTO chado.dbxref VALUES (159, 20, 'C25341', '', NULL);
INSERT INTO chado.dbxref VALUES (160, 20, 'C802', '', NULL);
INSERT INTO chado.dbxref VALUES (161, 20, 'C16551', '', NULL);
INSERT INTO chado.dbxref VALUES (162, 20, 'C42765', '', NULL);
INSERT INTO chado.dbxref VALUES (163, 20, 'C15320', '', NULL);
INSERT INTO chado.dbxref VALUES (164, 20, 'C54131', '', NULL);
INSERT INTO chado.dbxref VALUES (165, 20, 'C47885', '', NULL);
INSERT INTO chado.dbxref VALUES (166, 20, 'C16223', '', NULL);
INSERT INTO chado.dbxref VALUES (167, 20, 'C85496', '', NULL);
INSERT INTO chado.dbxref VALUES (168, 20, 'C25693', '', NULL);
INSERT INTO chado.dbxref VALUES (169, 20, 'C42699', '', NULL);
INSERT INTO chado.dbxref VALUES (170, 20, 'C70699', '', NULL);
INSERT INTO chado.dbxref VALUES (171, 20, 'C47954', '', NULL);
INSERT INTO chado.dbxref VALUES (172, 20, 'C43359', '', NULL);
INSERT INTO chado.dbxref VALUES (173, 20, 'C40975', '', NULL);
INSERT INTO chado.dbxref VALUES (174, 20, 'C43368', '', NULL);
INSERT INTO chado.dbxref VALUES (175, 20, 'C40974', '', NULL);
INSERT INTO chado.dbxref VALUES (176, 20, 'C49106', '', NULL);
INSERT INTO chado.dbxref VALUES (177, 20, 'C25167', '', NULL);
INSERT INTO chado.dbxref VALUES (178, 20, 'C164386', '', NULL);
INSERT INTO chado.dbxref VALUES (179, 21, 'common_name', '', NULL);
INSERT INTO chado.dbxref VALUES (180, 21, 'scientific_name', '', NULL);
INSERT INTO chado.dbxref VALUES (181, 22, 'comment', '', NULL);
INSERT INTO chado.dbxref VALUES (182, 22, 'type', '', NULL);
INSERT INTO chado.dbxref VALUES (183, 22, 'label', '', NULL);
INSERT INTO chado.dbxref VALUES (184, 24, '0000110', '', NULL);
INSERT INTO chado.dbxref VALUES (185, 24, '0000704', '', NULL);
INSERT INTO chado.dbxref VALUES (186, 24, '0000234', '', NULL);
INSERT INTO chado.dbxref VALUES (187, 24, '0000771', '', NULL);
INSERT INTO chado.dbxref VALUES (188, 24, '0001060', '', NULL);
INSERT INTO chado.dbxref VALUES (189, 24, '0001645', '', NULL);
INSERT INTO chado.dbxref VALUES (190, 24, '0001500', '', NULL);
INSERT INTO chado.dbxref VALUES (191, 25, '0000005', '', NULL);
INSERT INTO chado.dbxref VALUES (192, 25, '0000006', '', NULL);
INSERT INTO chado.dbxref VALUES (193, 25, '0000045', '', NULL);
INSERT INTO chado.dbxref VALUES (194, 27, '0000002', '', NULL);
INSERT INTO chado.dbxref VALUES (195, 27, '0000003', '', NULL);
INSERT INTO chado.dbxref VALUES (196, 27, '0000015', '', NULL);
INSERT INTO chado.dbxref VALUES (197, 27, '0000243', '', NULL);
INSERT INTO chado.dbxref VALUES (198, 28, 'Collection', '', NULL);
INSERT INTO chado.dbxref VALUES (199, 28, 'member', '', NULL);
INSERT INTO chado.dbxref VALUES (200, 28, 'description', '', NULL);
INSERT INTO chado.dbxref VALUES (201, 28, 'totalItems', '', NULL);
INSERT INTO chado.dbxref VALUES (202, 28, 'title', '', NULL);
INSERT INTO chado.dbxref VALUES (203, 28, 'PartialCollectionView', '', NULL);
INSERT INTO chado.dbxref VALUES (204, 29, 'name', '', NULL);
INSERT INTO chado.dbxref VALUES (205, 29, 'alternateName', '', NULL);
INSERT INTO chado.dbxref VALUES (206, 29, 'comment', '', NULL);
INSERT INTO chado.dbxref VALUES (207, 29, 'description', '', NULL);
INSERT INTO chado.dbxref VALUES (208, 29, 'publication', '', NULL);
INSERT INTO chado.dbxref VALUES (209, 29, 'url', '', NULL);
INSERT INTO chado.dbxref VALUES (210, 29, 'additionalType', '', NULL);
INSERT INTO chado.dbxref VALUES (211, 29, 'ItemPage', '', NULL);
INSERT INTO chado.dbxref VALUES (212, 30, '00195', '', NULL);
INSERT INTO chado.dbxref VALUES (213, 30, '00101', '', NULL);
INSERT INTO chado.dbxref VALUES (214, 31, '000067', '', NULL);
INSERT INTO chado.dbxref VALUES (215, 31, '000493', '', NULL);
INSERT INTO chado.dbxref VALUES (216, 31, '000631', '', NULL);
INSERT INTO chado.dbxref VALUES (217, 31, '000056', '', NULL);
INSERT INTO chado.dbxref VALUES (218, 31, '001166', '', NULL);
INSERT INTO chado.dbxref VALUES (219, 31, '000281', '', NULL);
INSERT INTO chado.dbxref VALUES (220, 31, '000729', '', NULL);
INSERT INTO chado.dbxref VALUES (221, 31, '001080', '', NULL);
INSERT INTO chado.dbxref VALUES (222, 31, '001323', '', NULL);
INSERT INTO chado.dbxref VALUES (223, 31, '001007', '', NULL);
INSERT INTO chado.dbxref VALUES (224, 31, '010054', '', NULL);
INSERT INTO chado.dbxref VALUES (225, 31, '001066', '', NULL);
INSERT INTO chado.dbxref VALUES (226, 33, 'exact', '', NULL);
INSERT INTO chado.dbxref VALUES (227, 33, 'broad', '', NULL);
INSERT INTO chado.dbxref VALUES (228, 33, 'narrow', '', NULL);
INSERT INTO chado.dbxref VALUES (229, 33, 'related', '', NULL);
INSERT INTO chado.dbxref VALUES (230, 24, 'adjacent_to', '', NULL);
INSERT INTO chado.dbxref VALUES (231, 24, 'associated_with', '', NULL);
INSERT INTO chado.dbxref VALUES (232, 24, 'complete_evidence_for_feature', '', NULL);
INSERT INTO chado.dbxref VALUES (233, 24, 'is_a', '', NULL);
INSERT INTO chado.dbxref VALUES (234, 24, 'evidence_for_feature', '', NULL);
INSERT INTO chado.dbxref VALUES (235, 24, 'connects_on', '', NULL);
INSERT INTO chado.dbxref VALUES (236, 24, 'contained_by', '', NULL);
INSERT INTO chado.dbxref VALUES (237, 24, 'contains', '', NULL);
INSERT INTO chado.dbxref VALUES (238, 24, 'derives_from', '', NULL);
INSERT INTO chado.dbxref VALUES (239, 24, 'disconnected_from', '', NULL);
INSERT INTO chado.dbxref VALUES (240, 24, 'edited_from', '', NULL);
INSERT INTO chado.dbxref VALUES (241, 24, 'edited_to', '', NULL);
INSERT INTO chado.dbxref VALUES (242, 24, 'exemplar_of', '', NULL);
INSERT INTO chado.dbxref VALUES (243, 24, 'finished_by', '', NULL);
INSERT INTO chado.dbxref VALUES (244, 24, 'finishes', '', NULL);
INSERT INTO chado.dbxref VALUES (245, 24, 'gained', '', NULL);
INSERT INTO chado.dbxref VALUES (246, 24, 'genome_of', '', NULL);
INSERT INTO chado.dbxref VALUES (247, 24, 'guided_by', '', NULL);
INSERT INTO chado.dbxref VALUES (248, 24, 'guides', '', NULL);
INSERT INTO chado.dbxref VALUES (249, 24, 'has_integral_part', '', NULL);
INSERT INTO chado.dbxref VALUES (250, 24, 'has_part', '', NULL);
INSERT INTO chado.dbxref VALUES (251, 24, 'has_origin', '', NULL);
INSERT INTO chado.dbxref VALUES (252, 24, 'has_quality', '', NULL);
INSERT INTO chado.dbxref VALUES (253, 24, 'homologous_to', '', NULL);
INSERT INTO chado.dbxref VALUES (254, 24, 'similar_to', '', NULL);
INSERT INTO chado.dbxref VALUES (255, 24, 'integral_part_of', '', NULL);
INSERT INTO chado.dbxref VALUES (256, 24, 'part_of', '', NULL);
INSERT INTO chado.dbxref VALUES (257, 24, 'is_consecutive_sequence_of', '', NULL);
INSERT INTO chado.dbxref VALUES (258, 24, 'lost', '', NULL);
INSERT INTO chado.dbxref VALUES (259, 24, 'maximally_overlaps', '', NULL);
INSERT INTO chado.dbxref VALUES (260, 24, 'member_of', '', NULL);
INSERT INTO chado.dbxref VALUES (261, 24, 'non_functional_homolog_of', '', NULL);
INSERT INTO chado.dbxref VALUES (262, 24, 'orthologous_to', '', NULL);
INSERT INTO chado.dbxref VALUES (263, 24, 'overlaps', '', NULL);
INSERT INTO chado.dbxref VALUES (264, 24, 'paralogous_to', '', NULL);
INSERT INTO chado.dbxref VALUES (265, 24, 'partial_evidence_for_feature', '', NULL);
INSERT INTO chado.dbxref VALUES (266, 24, 'position_of', '', NULL);
INSERT INTO chado.dbxref VALUES (267, 24, 'processed_from', '', NULL);
INSERT INTO chado.dbxref VALUES (268, 24, 'processed_into', '', NULL);
INSERT INTO chado.dbxref VALUES (269, 24, 'recombined_from', '', NULL);
INSERT INTO chado.dbxref VALUES (270, 24, 'recombined_to', '', NULL);
INSERT INTO chado.dbxref VALUES (271, 24, 'sequence_of', '', NULL);
INSERT INTO chado.dbxref VALUES (272, 24, 'started_by', '', NULL);
INSERT INTO chado.dbxref VALUES (273, 24, 'starts', '', NULL);
INSERT INTO chado.dbxref VALUES (274, 24, 'trans_spliced_from', '', NULL);
INSERT INTO chado.dbxref VALUES (275, 24, 'trans_spliced_to', '', NULL);
INSERT INTO chado.dbxref VALUES (276, 24, 'transcribed_from', '', NULL);
INSERT INTO chado.dbxref VALUES (277, 24, 'transcribed_to', '', NULL);
INSERT INTO chado.dbxref VALUES (278, 24, 'translates_to', '', NULL);
INSERT INTO chado.dbxref VALUES (279, 24, 'translation_of', '', NULL);
INSERT INTO chado.dbxref VALUES (280, 24, 'variant_of', '', NULL);
INSERT INTO chado.dbxref VALUES (281, 24, '0000000', '', NULL);
INSERT INTO chado.dbxref VALUES (282, 24, '00000000002382', '', NULL);
INSERT INTO chado.dbxref VALUES (283, 24, '0001623', '', NULL);
INSERT INTO chado.dbxref VALUES (284, 24, '0000001', '', NULL);
INSERT INTO chado.dbxref VALUES (285, 24, '00000010002382', '', NULL);
INSERT INTO chado.dbxref VALUES (286, 24, '0000002', '', NULL);
INSERT INTO chado.dbxref VALUES (287, 24, '0001411', '', NULL);
INSERT INTO chado.dbxref VALUES (288, 24, '00000020002382', '', NULL);
INSERT INTO chado.dbxref VALUES (289, 24, '0000003', '', NULL);
INSERT INTO chado.dbxref VALUES (290, 24, '00000030002382', '', NULL);
INSERT INTO chado.dbxref VALUES (291, 24, '0000004', '', NULL);
INSERT INTO chado.dbxref VALUES (292, 24, '0000195', '', NULL);
INSERT INTO chado.dbxref VALUES (293, 24, '00000040002382', '', NULL);
INSERT INTO chado.dbxref VALUES (294, 24, '0000005', '', NULL);
INSERT INTO chado.dbxref VALUES (295, 24, '0000705', '', NULL);
INSERT INTO chado.dbxref VALUES (296, 24, '0000006', '', NULL);
INSERT INTO chado.dbxref VALUES (297, 24, '0000695', '', NULL);
INSERT INTO chado.dbxref VALUES (298, 24, '0000007', '', NULL);
INSERT INTO chado.dbxref VALUES (299, 24, '0000150', '', NULL);
INSERT INTO chado.dbxref VALUES (300, 24, '0000149', '', NULL);
INSERT INTO chado.dbxref VALUES (301, 24, '0001790', '', NULL);
INSERT INTO chado.dbxref VALUES (302, 24, '0000008', '', NULL);
INSERT INTO chado.dbxref VALUES (303, 24, '0000009', '', NULL);
INSERT INTO chado.dbxref VALUES (304, 24, '0000010', '', NULL);
INSERT INTO chado.dbxref VALUES (305, 24, '0000401', '', NULL);
INSERT INTO chado.dbxref VALUES (306, 24, '0000011', '', NULL);
INSERT INTO chado.dbxref VALUES (307, 24, '0000012', '', NULL);
INSERT INTO chado.dbxref VALUES (308, 24, '0000483', '', NULL);
INSERT INTO chado.dbxref VALUES (309, 24, '0000013', '', NULL);
INSERT INTO chado.dbxref VALUES (310, 24, '0000655', '', NULL);
INSERT INTO chado.dbxref VALUES (311, 24, '0000014', '', NULL);
INSERT INTO chado.dbxref VALUES (312, 24, '0001660', '', NULL);
INSERT INTO chado.dbxref VALUES (313, 24, '0001669', '', NULL);
INSERT INTO chado.dbxref VALUES (314, 24, '0000015', '', NULL);
INSERT INTO chado.dbxref VALUES (315, 24, '0000016', '', NULL);
INSERT INTO chado.dbxref VALUES (316, 24, '0000017', '', NULL);
INSERT INTO chado.dbxref VALUES (317, 24, '0000713', '', NULL);
INSERT INTO chado.dbxref VALUES (318, 24, '0000167', '', NULL);
INSERT INTO chado.dbxref VALUES (319, 24, '0000018', '', NULL);
INSERT INTO chado.dbxref VALUES (320, 24, '0000020', '', NULL);
INSERT INTO chado.dbxref VALUES (321, 24, '0000715', '', NULL);
INSERT INTO chado.dbxref VALUES (322, 24, '0000021', '', NULL);
INSERT INTO chado.dbxref VALUES (323, 24, '0000022', '', NULL);
INSERT INTO chado.dbxref VALUES (324, 24, '0000023', '', NULL);
INSERT INTO chado.dbxref VALUES (325, 24, '0000024', '', NULL);
INSERT INTO chado.dbxref VALUES (326, 24, '0000025', '', NULL);
INSERT INTO chado.dbxref VALUES (327, 24, '0000026', '', NULL);
INSERT INTO chado.dbxref VALUES (328, 24, '0000027', '', NULL);
INSERT INTO chado.dbxref VALUES (329, 24, '0000028', '', NULL);
INSERT INTO chado.dbxref VALUES (330, 24, '0000029', '', NULL);
INSERT INTO chado.dbxref VALUES (331, 24, '0000030', '', NULL);
INSERT INTO chado.dbxref VALUES (332, 24, '0000031', '', NULL);
INSERT INTO chado.dbxref VALUES (333, 24, '0000696', '', NULL);
INSERT INTO chado.dbxref VALUES (334, 24, '0000032', '', NULL);
INSERT INTO chado.dbxref VALUES (335, 24, '0000033', '', NULL);
INSERT INTO chado.dbxref VALUES (336, 24, '0000034', '', NULL);
INSERT INTO chado.dbxref VALUES (337, 24, '0001247', '', NULL);
INSERT INTO chado.dbxref VALUES (338, 24, '0001183', '', NULL);
INSERT INTO chado.dbxref VALUES (339, 24, '0000035', '', NULL);
INSERT INTO chado.dbxref VALUES (340, 24, '0000836', '', NULL);
INSERT INTO chado.dbxref VALUES (341, 24, '0000036', '', NULL);
INSERT INTO chado.dbxref VALUES (342, 24, '0000626', '', NULL);
INSERT INTO chado.dbxref VALUES (343, 24, '0000037', '', NULL);
INSERT INTO chado.dbxref VALUES (344, 24, '0000727', '', NULL);
INSERT INTO chado.dbxref VALUES (345, 24, '0000038', '', NULL);
INSERT INTO chado.dbxref VALUES (346, 24, '0000039', '', NULL);
INSERT INTO chado.dbxref VALUES (347, 24, '0001410', '', NULL);
INSERT INTO chado.dbxref VALUES (348, 24, '0000343', '', NULL);
INSERT INTO chado.dbxref VALUES (349, 24, '0000040', '', NULL);
INSERT INTO chado.dbxref VALUES (350, 24, '0000151', '', NULL);
INSERT INTO chado.dbxref VALUES (351, 24, '0000991', '', NULL);
INSERT INTO chado.dbxref VALUES (352, 24, '0000041', '', NULL);
INSERT INTO chado.dbxref VALUES (353, 24, '0000042', '', NULL);
INSERT INTO chado.dbxref VALUES (354, 24, '0000043', '', NULL);
INSERT INTO chado.dbxref VALUES (355, 24, '0000336', '', NULL);
INSERT INTO chado.dbxref VALUES (356, 24, '0000044', '', NULL);
INSERT INTO chado.dbxref VALUES (357, 24, '0001760', '', NULL);
INSERT INTO chado.dbxref VALUES (358, 24, '0000045', '', NULL);
INSERT INTO chado.dbxref VALUES (359, 24, '0000046', '', NULL);
INSERT INTO chado.dbxref VALUES (360, 24, '0000047', '', NULL);
INSERT INTO chado.dbxref VALUES (361, 24, '0000048', '', NULL);
INSERT INTO chado.dbxref VALUES (362, 24, '0000049', '', NULL);
INSERT INTO chado.dbxref VALUES (363, 24, '0000050', '', NULL);
INSERT INTO chado.dbxref VALUES (364, 24, '0000051', '', NULL);
INSERT INTO chado.dbxref VALUES (365, 24, '0000052', '', NULL);
INSERT INTO chado.dbxref VALUES (366, 24, '0000053', '', NULL);
INSERT INTO chado.dbxref VALUES (367, 24, '0000054', '', NULL);
INSERT INTO chado.dbxref VALUES (368, 24, '1000182', '', NULL);
INSERT INTO chado.dbxref VALUES (369, 24, '0000055', '', NULL);
INSERT INTO chado.dbxref VALUES (370, 24, '0000056', '', NULL);
INSERT INTO chado.dbxref VALUES (371, 24, '0000057', '', NULL);
INSERT INTO chado.dbxref VALUES (372, 24, '0001055', '', NULL);
INSERT INTO chado.dbxref VALUES (373, 24, '0000058', '', NULL);
INSERT INTO chado.dbxref VALUES (374, 24, '0000059', '', NULL);
INSERT INTO chado.dbxref VALUES (375, 24, '0001654', '', NULL);
INSERT INTO chado.dbxref VALUES (376, 24, '0000060', '', NULL);
INSERT INTO chado.dbxref VALUES (377, 24, '1000042', '', NULL);
INSERT INTO chado.dbxref VALUES (378, 24, '0000061', '', NULL);
INSERT INTO chado.dbxref VALUES (379, 24, '0000062', '', NULL);
INSERT INTO chado.dbxref VALUES (380, 24, '1000029', '', NULL);
INSERT INTO chado.dbxref VALUES (381, 24, '1000041', '', NULL);
INSERT INTO chado.dbxref VALUES (382, 24, '0000159', '', NULL);
INSERT INTO chado.dbxref VALUES (383, 24, '0000063', '', NULL);
INSERT INTO chado.dbxref VALUES (384, 24, '1000155', '', NULL);
INSERT INTO chado.dbxref VALUES (385, 24, '0000064', '', NULL);
INSERT INTO chado.dbxref VALUES (386, 24, '0000065', '', NULL);
INSERT INTO chado.dbxref VALUES (387, 24, '1000183', '', NULL);
INSERT INTO chado.dbxref VALUES (388, 24, '0000066', '', NULL);
INSERT INTO chado.dbxref VALUES (389, 24, '0000067', '', NULL);
INSERT INTO chado.dbxref VALUES (390, 24, '0000068', '', NULL);
INSERT INTO chado.dbxref VALUES (391, 24, '0000069', '', NULL);
INSERT INTO chado.dbxref VALUES (392, 24, '0000070', '', NULL);
INSERT INTO chado.dbxref VALUES (393, 24, '0000071', '', NULL);
INSERT INTO chado.dbxref VALUES (394, 24, '0000072', '', NULL);
INSERT INTO chado.dbxref VALUES (395, 24, '0000073', '', NULL);
INSERT INTO chado.dbxref VALUES (396, 24, '0000074', '', NULL);
INSERT INTO chado.dbxref VALUES (397, 24, '0000075', '', NULL);
INSERT INTO chado.dbxref VALUES (398, 24, '0000076', '', NULL);
INSERT INTO chado.dbxref VALUES (399, 24, '0000077', '', NULL);
INSERT INTO chado.dbxref VALUES (400, 24, '0000078', '', NULL);
INSERT INTO chado.dbxref VALUES (401, 24, '0000673', '', NULL);
INSERT INTO chado.dbxref VALUES (402, 24, '0000880', '', NULL);
INSERT INTO chado.dbxref VALUES (403, 24, '0000079', '', NULL);
INSERT INTO chado.dbxref VALUES (404, 24, '0000879', '', NULL);
INSERT INTO chado.dbxref VALUES (405, 24, '0000080', '', NULL);
INSERT INTO chado.dbxref VALUES (406, 24, '0000081', '', NULL);
INSERT INTO chado.dbxref VALUES (407, 24, '0000082', '', NULL);
INSERT INTO chado.dbxref VALUES (408, 24, '0000083', '', NULL);
INSERT INTO chado.dbxref VALUES (409, 24, '0000736', '', NULL);
INSERT INTO chado.dbxref VALUES (410, 24, '0000084', '', NULL);
INSERT INTO chado.dbxref VALUES (411, 24, '0000085', '', NULL);
INSERT INTO chado.dbxref VALUES (412, 24, '0000086', '', NULL);
INSERT INTO chado.dbxref VALUES (413, 24, '0000087', '', NULL);
INSERT INTO chado.dbxref VALUES (414, 24, '0000738', '', NULL);
INSERT INTO chado.dbxref VALUES (415, 24, '0000088', '', NULL);
INSERT INTO chado.dbxref VALUES (416, 24, '0000737', '', NULL);
INSERT INTO chado.dbxref VALUES (417, 24, '0000089', '', NULL);
INSERT INTO chado.dbxref VALUES (418, 24, '0000741', '', NULL);
INSERT INTO chado.dbxref VALUES (419, 24, '0000090', '', NULL);
INSERT INTO chado.dbxref VALUES (420, 24, '0000740', '', NULL);
INSERT INTO chado.dbxref VALUES (421, 24, '0000091', '', NULL);
INSERT INTO chado.dbxref VALUES (422, 24, '0000743', '', NULL);
INSERT INTO chado.dbxref VALUES (423, 24, '0000092', '', NULL);
INSERT INTO chado.dbxref VALUES (424, 24, '0000745', '', NULL);
INSERT INTO chado.dbxref VALUES (425, 24, '0000093', '', NULL);
INSERT INTO chado.dbxref VALUES (426, 24, '0000744', '', NULL);
INSERT INTO chado.dbxref VALUES (427, 24, '0000094', '', NULL);
INSERT INTO chado.dbxref VALUES (428, 24, '0000746', '', NULL);
INSERT INTO chado.dbxref VALUES (429, 24, '0000095', '', NULL);
INSERT INTO chado.dbxref VALUES (430, 24, '0000747', '', NULL);
INSERT INTO chado.dbxref VALUES (431, 24, '0000096', '', NULL);
INSERT INTO chado.dbxref VALUES (432, 24, '0000748', '', NULL);
INSERT INTO chado.dbxref VALUES (433, 24, '0000097', '', NULL);
INSERT INTO chado.dbxref VALUES (434, 24, '0000739', '', NULL);
INSERT INTO chado.dbxref VALUES (435, 24, '0000098', '', NULL);
INSERT INTO chado.dbxref VALUES (436, 24, '0000749', '', NULL);
INSERT INTO chado.dbxref VALUES (437, 24, '0000099', '', NULL);
INSERT INTO chado.dbxref VALUES (438, 24, '0000751', '', NULL);
INSERT INTO chado.dbxref VALUES (439, 24, '0000100', '', NULL);
INSERT INTO chado.dbxref VALUES (440, 24, '0000903', '', NULL);
INSERT INTO chado.dbxref VALUES (441, 24, '0000101', '', NULL);
INSERT INTO chado.dbxref VALUES (442, 24, '0001039', '', NULL);
INSERT INTO chado.dbxref VALUES (443, 24, '0000102', '', NULL);
INSERT INTO chado.dbxref VALUES (444, 24, '0000347', '', NULL);
INSERT INTO chado.dbxref VALUES (445, 24, '0000103', '', NULL);
INSERT INTO chado.dbxref VALUES (446, 24, '0000699', '', NULL);
INSERT INTO chado.dbxref VALUES (447, 24, '0000753', '', NULL);
INSERT INTO chado.dbxref VALUES (448, 24, '0000104', '', NULL);
INSERT INTO chado.dbxref VALUES (449, 24, '0000358', '', NULL);
INSERT INTO chado.dbxref VALUES (450, 24, '0000316', '', NULL);
INSERT INTO chado.dbxref VALUES (451, 24, '0000105', '', NULL);
INSERT INTO chado.dbxref VALUES (452, 24, '0000830', '', NULL);
INSERT INTO chado.dbxref VALUES (453, 24, '0000106', '', NULL);
INSERT INTO chado.dbxref VALUES (454, 24, '0000107', '', NULL);
INSERT INTO chado.dbxref VALUES (455, 24, '0000112', '', NULL);
INSERT INTO chado.dbxref VALUES (456, 24, '0000108', '', NULL);
INSERT INTO chado.dbxref VALUES (457, 24, '0000865', '', NULL);
INSERT INTO chado.dbxref VALUES (458, 24, '0000109', '', NULL);
INSERT INTO chado.dbxref VALUES (459, 24, '0000111', '', NULL);
INSERT INTO chado.dbxref VALUES (460, 24, '0000441', '', NULL);
INSERT INTO chado.dbxref VALUES (461, 24, '0000113', '', NULL);
INSERT INTO chado.dbxref VALUES (462, 24, '0000114', '', NULL);
INSERT INTO chado.dbxref VALUES (463, 24, '0000306', '', NULL);
INSERT INTO chado.dbxref VALUES (464, 24, '0001963', '', NULL);
INSERT INTO chado.dbxref VALUES (465, 24, '0000115', '', NULL);
INSERT INTO chado.dbxref VALUES (466, 24, '0000116', '', NULL);
INSERT INTO chado.dbxref VALUES (467, 24, '0000237', '', NULL);
INSERT INTO chado.dbxref VALUES (468, 24, '0000117', '', NULL);
INSERT INTO chado.dbxref VALUES (469, 24, '0000118', '', NULL);
INSERT INTO chado.dbxref VALUES (470, 24, '0000887', '', NULL);
INSERT INTO chado.dbxref VALUES (471, 24, '0000119', '', NULL);
INSERT INTO chado.dbxref VALUES (472, 24, '0000120', '', NULL);
INSERT INTO chado.dbxref VALUES (473, 24, '0000185', '', NULL);
INSERT INTO chado.dbxref VALUES (474, 24, '0000121', '', NULL);
INSERT INTO chado.dbxref VALUES (475, 24, '0001030', '', NULL);
INSERT INTO chado.dbxref VALUES (476, 24, '0000122', '', NULL);
INSERT INTO chado.dbxref VALUES (477, 24, '0000123', '', NULL);
INSERT INTO chado.dbxref VALUES (478, 24, '0000124', '', NULL);
INSERT INTO chado.dbxref VALUES (479, 24, '0000125', '', NULL);
INSERT INTO chado.dbxref VALUES (480, 24, '0000126', '', NULL);
INSERT INTO chado.dbxref VALUES (481, 24, '0000127', '', NULL);
INSERT INTO chado.dbxref VALUES (482, 24, '0000893', '', NULL);
INSERT INTO chado.dbxref VALUES (483, 24, '0000128', '', NULL);
INSERT INTO chado.dbxref VALUES (484, 24, '0000894', '', NULL);
INSERT INTO chado.dbxref VALUES (485, 24, '0000129', '', NULL);
INSERT INTO chado.dbxref VALUES (486, 24, '0000895', '', NULL);
INSERT INTO chado.dbxref VALUES (487, 24, '0000130', '', NULL);
INSERT INTO chado.dbxref VALUES (488, 24, '0000131', '', NULL);
INSERT INTO chado.dbxref VALUES (489, 24, '0000132', '', NULL);
INSERT INTO chado.dbxref VALUES (490, 24, '0001031', '', NULL);
INSERT INTO chado.dbxref VALUES (491, 24, '0000133', '', NULL);
INSERT INTO chado.dbxref VALUES (492, 24, '0000134', '', NULL);
INSERT INTO chado.dbxref VALUES (493, 24, '0000135', '', NULL);
INSERT INTO chado.dbxref VALUES (494, 24, '0000136', '', NULL);
INSERT INTO chado.dbxref VALUES (495, 24, '0000137', '', NULL);
INSERT INTO chado.dbxref VALUES (496, 24, '0000138', '', NULL);
INSERT INTO chado.dbxref VALUES (497, 24, '0000898', '', NULL);
INSERT INTO chado.dbxref VALUES (498, 24, '0000904', '', NULL);
INSERT INTO chado.dbxref VALUES (499, 24, '0000139', '', NULL);
INSERT INTO chado.dbxref VALUES (500, 24, '0000204', '', NULL);
INSERT INTO chado.dbxref VALUES (501, 24, '0000140', '', NULL);
INSERT INTO chado.dbxref VALUES (502, 24, '0001680', '', NULL);
INSERT INTO chado.dbxref VALUES (503, 24, '0000141', '', NULL);
INSERT INTO chado.dbxref VALUES (504, 24, '0000142', '', NULL);
INSERT INTO chado.dbxref VALUES (505, 24, '0000143', '', NULL);
INSERT INTO chado.dbxref VALUES (506, 24, '0000144', '', NULL);
INSERT INTO chado.dbxref VALUES (507, 24, '0000145', '', NULL);
INSERT INTO chado.dbxref VALUES (508, 24, '0000360', '', NULL);
INSERT INTO chado.dbxref VALUES (509, 24, '0000146', '', NULL);
INSERT INTO chado.dbxref VALUES (510, 24, '0000147', '', NULL);
INSERT INTO chado.dbxref VALUES (511, 24, '0000833', '', NULL);
INSERT INTO chado.dbxref VALUES (512, 24, '0000148', '', NULL);
INSERT INTO chado.dbxref VALUES (513, 24, '0001876', '', NULL);
INSERT INTO chado.dbxref VALUES (514, 24, '0000719', '', NULL);
INSERT INTO chado.dbxref VALUES (515, 24, '0000353', '', NULL);
INSERT INTO chado.dbxref VALUES (516, 24, '0000152', '', NULL);
INSERT INTO chado.dbxref VALUES (517, 24, '0000440', '', NULL);
INSERT INTO chado.dbxref VALUES (518, 24, '0000153', '', NULL);
INSERT INTO chado.dbxref VALUES (519, 24, '0000154', '', NULL);
INSERT INTO chado.dbxref VALUES (520, 24, '0000155', '', NULL);
INSERT INTO chado.dbxref VALUES (521, 24, '0001235', '', NULL);
INSERT INTO chado.dbxref VALUES (522, 24, '0000156', '', NULL);
INSERT INTO chado.dbxref VALUES (523, 24, '0000157', '', NULL);
INSERT INTO chado.dbxref VALUES (524, 24, '0000158', '', NULL);
INSERT INTO chado.dbxref VALUES (525, 24, '1000033', '', NULL);
INSERT INTO chado.dbxref VALUES (526, 34, 'LA6692-3', '', NULL);
INSERT INTO chado.dbxref VALUES (527, 24, '0001059', '', NULL);
INSERT INTO chado.dbxref VALUES (528, 24, '0000160', '', NULL);
INSERT INTO chado.dbxref VALUES (529, 24, '0000161', '', NULL);
INSERT INTO chado.dbxref VALUES (530, 24, '0001962', '', NULL);
INSERT INTO chado.dbxref VALUES (531, 24, '0000162', '', NULL);
INSERT INTO chado.dbxref VALUES (532, 24, '0000835', '', NULL);
INSERT INTO chado.dbxref VALUES (533, 24, '0000163', '', NULL);
INSERT INTO chado.dbxref VALUES (534, 24, '0001419', '', NULL);
INSERT INTO chado.dbxref VALUES (535, 24, '0000164', '', NULL);
INSERT INTO chado.dbxref VALUES (536, 24, '0000165', '', NULL);
INSERT INTO chado.dbxref VALUES (537, 24, '0000166', '', NULL);
INSERT INTO chado.dbxref VALUES (538, 24, '0000277', '', NULL);
INSERT INTO chado.dbxref VALUES (539, 24, '0000842', '', NULL);
INSERT INTO chado.dbxref VALUES (540, 24, '0000168', '', NULL);
INSERT INTO chado.dbxref VALUES (541, 24, '0000169', '', NULL);
INSERT INTO chado.dbxref VALUES (542, 24, '0002221', '', NULL);
INSERT INTO chado.dbxref VALUES (543, 24, '0000170', '', NULL);
INSERT INTO chado.dbxref VALUES (544, 24, '0000171', '', NULL);
INSERT INTO chado.dbxref VALUES (545, 24, '0000172', '', NULL);
INSERT INTO chado.dbxref VALUES (546, 24, '0000173', '', NULL);
INSERT INTO chado.dbxref VALUES (547, 24, '0001659', '', NULL);
INSERT INTO chado.dbxref VALUES (548, 24, '0000174', '', NULL);
INSERT INTO chado.dbxref VALUES (549, 24, '0000175', '', NULL);
INSERT INTO chado.dbxref VALUES (550, 24, '0001671', '', NULL);
INSERT INTO chado.dbxref VALUES (551, 24, '0001913', '', NULL);
INSERT INTO chado.dbxref VALUES (552, 24, '0000176', '', NULL);
INSERT INTO chado.dbxref VALUES (553, 24, '0000177', '', NULL);
INSERT INTO chado.dbxref VALUES (554, 24, '0000178', '', NULL);
INSERT INTO chado.dbxref VALUES (555, 24, '0005855', '', NULL);
INSERT INTO chado.dbxref VALUES (556, 24, '0000179', '', NULL);
INSERT INTO chado.dbxref VALUES (557, 24, '0000180', '', NULL);
INSERT INTO chado.dbxref VALUES (558, 24, '0000181', '', NULL);
INSERT INTO chado.dbxref VALUES (559, 24, '0000182', '', NULL);
INSERT INTO chado.dbxref VALUES (560, 24, '0000183', '', NULL);
INSERT INTO chado.dbxref VALUES (561, 24, '0000184', '', NULL);
INSERT INTO chado.dbxref VALUES (562, 24, '0000662', '', NULL);
INSERT INTO chado.dbxref VALUES (563, 24, '0000186', '', NULL);
INSERT INTO chado.dbxref VALUES (564, 24, '0000187', '', NULL);
INSERT INTO chado.dbxref VALUES (565, 24, '0000188', '', NULL);
INSERT INTO chado.dbxref VALUES (566, 24, '0000189', '', NULL);
INSERT INTO chado.dbxref VALUES (567, 24, '0000190', '', NULL);
INSERT INTO chado.dbxref VALUES (568, 24, '0000191', '', NULL);
INSERT INTO chado.dbxref VALUES (569, 24, '0000192', '', NULL);
INSERT INTO chado.dbxref VALUES (570, 24, '0000193', '', NULL);
INSERT INTO chado.dbxref VALUES (571, 24, '0000412', '', NULL);
INSERT INTO chado.dbxref VALUES (572, 24, '0000194', '', NULL);
INSERT INTO chado.dbxref VALUES (573, 24, '0000196', '', NULL);
INSERT INTO chado.dbxref VALUES (574, 24, '0001215', '', NULL);
INSERT INTO chado.dbxref VALUES (575, 24, '0000200', '', NULL);
INSERT INTO chado.dbxref VALUES (576, 24, '0000197', '', NULL);
INSERT INTO chado.dbxref VALUES (577, 24, '0000202', '', NULL);
INSERT INTO chado.dbxref VALUES (578, 24, '0000198', '', NULL);
INSERT INTO chado.dbxref VALUES (579, 24, '0000199', '', NULL);
INSERT INTO chado.dbxref VALUES (580, 24, '0001785', '', NULL);
INSERT INTO chado.dbxref VALUES (581, 24, '0000201', '', NULL);
INSERT INTO chado.dbxref VALUES (582, 24, '0000203', '', NULL);
INSERT INTO chado.dbxref VALUES (583, 24, '0000205', '', NULL);
INSERT INTO chado.dbxref VALUES (584, 24, '0000206', '', NULL);
INSERT INTO chado.dbxref VALUES (585, 24, '0000207', '', NULL);
INSERT INTO chado.dbxref VALUES (586, 24, '0000248', '', NULL);
INSERT INTO chado.dbxref VALUES (587, 24, '0000208', '', NULL);
INSERT INTO chado.dbxref VALUES (588, 24, '0000209', '', NULL);
INSERT INTO chado.dbxref VALUES (589, 24, '0000210', '', NULL);
INSERT INTO chado.dbxref VALUES (590, 24, '0000211', '', NULL);
INSERT INTO chado.dbxref VALUES (591, 24, '0000212', '', NULL);
INSERT INTO chado.dbxref VALUES (592, 24, '0000213', '', NULL);
INSERT INTO chado.dbxref VALUES (593, 24, '0000214', '', NULL);
INSERT INTO chado.dbxref VALUES (594, 24, '0000215', '', NULL);
INSERT INTO chado.dbxref VALUES (595, 24, '0000216', '', NULL);
INSERT INTO chado.dbxref VALUES (596, 24, '0000217', '', NULL);
INSERT INTO chado.dbxref VALUES (597, 24, '0000218', '', NULL);
INSERT INTO chado.dbxref VALUES (598, 24, '0000219', '', NULL);
INSERT INTO chado.dbxref VALUES (599, 24, '0000220', '', NULL);
INSERT INTO chado.dbxref VALUES (600, 24, '0000221', '', NULL);
INSERT INTO chado.dbxref VALUES (601, 24, '0000222', '', NULL);
INSERT INTO chado.dbxref VALUES (602, 24, '0000223', '', NULL);
INSERT INTO chado.dbxref VALUES (603, 24, '0000224', '', NULL);
INSERT INTO chado.dbxref VALUES (604, 24, '0000225', '', NULL);
INSERT INTO chado.dbxref VALUES (605, 24, '0000226', '', NULL);
INSERT INTO chado.dbxref VALUES (606, 24, '0000227', '', NULL);
INSERT INTO chado.dbxref VALUES (607, 24, '0000228', '', NULL);
INSERT INTO chado.dbxref VALUES (608, 24, '0000229', '', NULL);
INSERT INTO chado.dbxref VALUES (609, 24, '0000230', '', NULL);
INSERT INTO chado.dbxref VALUES (610, 24, '0000231', '', NULL);
INSERT INTO chado.dbxref VALUES (611, 24, '0000232', '', NULL);
INSERT INTO chado.dbxref VALUES (612, 24, '0000233', '', NULL);
INSERT INTO chado.dbxref VALUES (613, 24, '0000235', '', NULL);
INSERT INTO chado.dbxref VALUES (614, 24, '0000236', '', NULL);
INSERT INTO chado.dbxref VALUES (615, 24, '0000717', '', NULL);
INSERT INTO chado.dbxref VALUES (616, 24, '0000733', '', NULL);
INSERT INTO chado.dbxref VALUES (617, 24, '0000238', '', NULL);
INSERT INTO chado.dbxref VALUES (618, 24, '0000239', '', NULL);
INSERT INTO chado.dbxref VALUES (619, 24, '0001412', '', NULL);
INSERT INTO chado.dbxref VALUES (620, 24, '0000240', '', NULL);
INSERT INTO chado.dbxref VALUES (621, 24, '0001507', '', NULL);
INSERT INTO chado.dbxref VALUES (622, 24, '0001524', '', NULL);
INSERT INTO chado.dbxref VALUES (623, 24, '0000241', '', NULL);
INSERT INTO chado.dbxref VALUES (624, 24, '0000242', '', NULL);
INSERT INTO chado.dbxref VALUES (625, 24, '0000243', '', NULL);
INSERT INTO chado.dbxref VALUES (626, 24, '0000244', '', NULL);
INSERT INTO chado.dbxref VALUES (627, 24, '0000245', '', NULL);
INSERT INTO chado.dbxref VALUES (628, 24, '0000246', '', NULL);
INSERT INTO chado.dbxref VALUES (629, 24, '0000863', '', NULL);
INSERT INTO chado.dbxref VALUES (630, 24, '0000247', '', NULL);
INSERT INTO chado.dbxref VALUES (631, 24, '0000249', '', NULL);
INSERT INTO chado.dbxref VALUES (632, 24, '0000250', '', NULL);
INSERT INTO chado.dbxref VALUES (633, 24, '0001236', '', NULL);
INSERT INTO chado.dbxref VALUES (634, 24, '0000251', '', NULL);
INSERT INTO chado.dbxref VALUES (635, 24, '0000252', '', NULL);
INSERT INTO chado.dbxref VALUES (636, 24, '0000253', '', NULL);
INSERT INTO chado.dbxref VALUES (637, 24, '0002247', '', NULL);
INSERT INTO chado.dbxref VALUES (638, 24, '0000254', '', NULL);
INSERT INTO chado.dbxref VALUES (639, 24, '0000255', '', NULL);
INSERT INTO chado.dbxref VALUES (640, 24, '0000256', '', NULL);
INSERT INTO chado.dbxref VALUES (641, 24, '0000257', '', NULL);
INSERT INTO chado.dbxref VALUES (642, 24, '0000258', '', NULL);
INSERT INTO chado.dbxref VALUES (643, 24, '0000259', '', NULL);
INSERT INTO chado.dbxref VALUES (644, 24, '0000260', '', NULL);
INSERT INTO chado.dbxref VALUES (645, 24, '0000261', '', NULL);
INSERT INTO chado.dbxref VALUES (646, 24, '0000262', '', NULL);
INSERT INTO chado.dbxref VALUES (647, 24, '0000263', '', NULL);
INSERT INTO chado.dbxref VALUES (648, 24, '0000264', '', NULL);
INSERT INTO chado.dbxref VALUES (649, 24, '0000265', '', NULL);
INSERT INTO chado.dbxref VALUES (650, 24, '0000266', '', NULL);
INSERT INTO chado.dbxref VALUES (651, 24, '0000267', '', NULL);
INSERT INTO chado.dbxref VALUES (652, 24, '0000268', '', NULL);
INSERT INTO chado.dbxref VALUES (653, 24, '0000269', '', NULL);
INSERT INTO chado.dbxref VALUES (654, 24, '0000270', '', NULL);
INSERT INTO chado.dbxref VALUES (655, 24, '0000271', '', NULL);
INSERT INTO chado.dbxref VALUES (656, 24, '0000272', '', NULL);
INSERT INTO chado.dbxref VALUES (657, 24, '0000273', '', NULL);
INSERT INTO chado.dbxref VALUES (658, 24, '0000274', '', NULL);
INSERT INTO chado.dbxref VALUES (659, 24, '0000275', '', NULL);
INSERT INTO chado.dbxref VALUES (660, 24, '0000276', '', NULL);
INSERT INTO chado.dbxref VALUES (661, 24, '0000649', '', NULL);
INSERT INTO chado.dbxref VALUES (662, 24, '0000370', '', NULL);
INSERT INTO chado.dbxref VALUES (663, 24, '0001244', '', NULL);
INSERT INTO chado.dbxref VALUES (664, 24, '0000278', '', NULL);
INSERT INTO chado.dbxref VALUES (665, 24, '0000876', '', NULL);
INSERT INTO chado.dbxref VALUES (666, 24, '0000279', '', NULL);
INSERT INTO chado.dbxref VALUES (667, 24, '0000875', '', NULL);
INSERT INTO chado.dbxref VALUES (668, 24, '0000280', '', NULL);
INSERT INTO chado.dbxref VALUES (669, 24, '0000804', '', NULL);
INSERT INTO chado.dbxref VALUES (670, 24, '0000783', '', NULL);
INSERT INTO chado.dbxref VALUES (671, 24, '0000281', '', NULL);
INSERT INTO chado.dbxref VALUES (672, 24, '0000285', '', NULL);
INSERT INTO chado.dbxref VALUES (673, 24, '0000805', '', NULL);
INSERT INTO chado.dbxref VALUES (674, 24, '0000784', '', NULL);
INSERT INTO chado.dbxref VALUES (675, 24, '0000282', '', NULL);
INSERT INTO chado.dbxref VALUES (676, 24, '0000866', '', NULL);
INSERT INTO chado.dbxref VALUES (677, 24, '0000283', '', NULL);
INSERT INTO chado.dbxref VALUES (678, 24, '0000284', '', NULL);
INSERT INTO chado.dbxref VALUES (679, 24, '0000286', '', NULL);
INSERT INTO chado.dbxref VALUES (680, 24, '0000657', '', NULL);
INSERT INTO chado.dbxref VALUES (681, 24, '0000287', '', NULL);
INSERT INTO chado.dbxref VALUES (682, 24, '0000806', '', NULL);
INSERT INTO chado.dbxref VALUES (683, 24, '0000288', '', NULL);
INSERT INTO chado.dbxref VALUES (684, 24, '0000289', '', NULL);
INSERT INTO chado.dbxref VALUES (685, 24, '0000290', '', NULL);
INSERT INTO chado.dbxref VALUES (686, 24, '0000291', '', NULL);
INSERT INTO chado.dbxref VALUES (687, 24, '0000292', '', NULL);
INSERT INTO chado.dbxref VALUES (688, 24, '0000293', '', NULL);
INSERT INTO chado.dbxref VALUES (689, 24, '0000294', '', NULL);
INSERT INTO chado.dbxref VALUES (690, 24, '0000295', '', NULL);
INSERT INTO chado.dbxref VALUES (691, 24, '0000296', '', NULL);
INSERT INTO chado.dbxref VALUES (692, 24, '0000297', '', NULL);
INSERT INTO chado.dbxref VALUES (693, 24, '0000298', '', NULL);
INSERT INTO chado.dbxref VALUES (694, 24, '0000299', '', NULL);
INSERT INTO chado.dbxref VALUES (695, 24, '0000669', '', NULL);
INSERT INTO chado.dbxref VALUES (696, 24, '0000300', '', NULL);
INSERT INTO chado.dbxref VALUES (697, 24, '0000301', '', NULL);
INSERT INTO chado.dbxref VALUES (698, 24, '0000302', '', NULL);
INSERT INTO chado.dbxref VALUES (699, 24, '0000939', '', NULL);
INSERT INTO chado.dbxref VALUES (700, 24, '0000303', '', NULL);
INSERT INTO chado.dbxref VALUES (701, 24, '0000304', '', NULL);
INSERT INTO chado.dbxref VALUES (702, 24, '0000305', '', NULL);
INSERT INTO chado.dbxref VALUES (703, 24, '0001720', '', NULL);
INSERT INTO chado.dbxref VALUES (704, 24, '0000307', '', NULL);
INSERT INTO chado.dbxref VALUES (705, 24, '0000308', '', NULL);
INSERT INTO chado.dbxref VALUES (706, 24, '0000309', '', NULL);
INSERT INTO chado.dbxref VALUES (707, 24, '0000310', '', NULL);
INSERT INTO chado.dbxref VALUES (708, 24, '0000311', '', NULL);
INSERT INTO chado.dbxref VALUES (709, 24, '0000312', '', NULL);
INSERT INTO chado.dbxref VALUES (710, 24, '0000789', '', NULL);
INSERT INTO chado.dbxref VALUES (711, 24, '0000313', '', NULL);
INSERT INTO chado.dbxref VALUES (712, 24, '0000019', '', NULL);
INSERT INTO chado.dbxref VALUES (713, 24, '0000314', '', NULL);
INSERT INTO chado.dbxref VALUES (714, 24, '0000315', '', NULL);
INSERT INTO chado.dbxref VALUES (715, 24, '0002309', '', NULL);
INSERT INTO chado.dbxref VALUES (716, 24, '0000317', '', NULL);
INSERT INTO chado.dbxref VALUES (717, 24, '0000756', '', NULL);
INSERT INTO chado.dbxref VALUES (718, 24, '0000318', '', NULL);
INSERT INTO chado.dbxref VALUES (719, 24, '0000319', '', NULL);
INSERT INTO chado.dbxref VALUES (720, 24, '0000320', '', NULL);
INSERT INTO chado.dbxref VALUES (721, 24, '0000344', '', NULL);
INSERT INTO chado.dbxref VALUES (722, 24, '0000841', '', NULL);
INSERT INTO chado.dbxref VALUES (723, 24, '0000321', '', NULL);
INSERT INTO chado.dbxref VALUES (724, 24, '0000868', '', NULL);
INSERT INTO chado.dbxref VALUES (725, 24, '0000322', '', NULL);
INSERT INTO chado.dbxref VALUES (726, 24, '0000684', '', NULL);
INSERT INTO chado.dbxref VALUES (727, 24, '0002331', '', NULL);
INSERT INTO chado.dbxref VALUES (728, 24, '0000323', '', NULL);
INSERT INTO chado.dbxref VALUES (729, 24, '0000851', '', NULL);
INSERT INTO chado.dbxref VALUES (730, 24, '0000324', '', NULL);
INSERT INTO chado.dbxref VALUES (731, 24, '0000325', '', NULL);
INSERT INTO chado.dbxref VALUES (732, 24, '0000326', '', NULL);
INSERT INTO chado.dbxref VALUES (733, 24, '0000327', '', NULL);
INSERT INTO chado.dbxref VALUES (734, 24, '0000328', '', NULL);
INSERT INTO chado.dbxref VALUES (735, 24, '0000329', '', NULL);
INSERT INTO chado.dbxref VALUES (736, 24, '0000869', '', NULL);
INSERT INTO chado.dbxref VALUES (737, 24, '0000330', '', NULL);
INSERT INTO chado.dbxref VALUES (738, 24, '0000331', '', NULL);
INSERT INTO chado.dbxref VALUES (739, 24, '0000332', '', NULL);
INSERT INTO chado.dbxref VALUES (740, 24, '0000333', '', NULL);
INSERT INTO chado.dbxref VALUES (741, 24, '0000334', '', NULL);
INSERT INTO chado.dbxref VALUES (742, 24, '0000335', '', NULL);
INSERT INTO chado.dbxref VALUES (743, 24, '0000867', '', NULL);
INSERT INTO chado.dbxref VALUES (744, 24, '0000337', '', NULL);
INSERT INTO chado.dbxref VALUES (745, 24, '0000442', '', NULL);
INSERT INTO chado.dbxref VALUES (746, 24, '0000338', '', NULL);
INSERT INTO chado.dbxref VALUES (747, 24, '0000339', '', NULL);
INSERT INTO chado.dbxref VALUES (748, 24, '0000340', '', NULL);
INSERT INTO chado.dbxref VALUES (749, 24, '0000341', '', NULL);
INSERT INTO chado.dbxref VALUES (750, 24, '0000342', '', NULL);
INSERT INTO chado.dbxref VALUES (751, 24, '0001056', '', NULL);
INSERT INTO chado.dbxref VALUES (752, 24, '0000345', '', NULL);
INSERT INTO chado.dbxref VALUES (753, 24, '0000346', '', NULL);
INSERT INTO chado.dbxref VALUES (754, 24, '0000947', '', NULL);
INSERT INTO chado.dbxref VALUES (755, 24, '0000348', '', NULL);
INSERT INTO chado.dbxref VALUES (756, 24, '0000443', '', NULL);
INSERT INTO chado.dbxref VALUES (757, 24, '0000349', '', NULL);
INSERT INTO chado.dbxref VALUES (758, 24, '0000350', '', NULL);
INSERT INTO chado.dbxref VALUES (759, 24, '0000948', '', NULL);
INSERT INTO chado.dbxref VALUES (760, 24, '0000351', '', NULL);
INSERT INTO chado.dbxref VALUES (761, 24, '0000352', '', NULL);
INSERT INTO chado.dbxref VALUES (762, 24, '0001248', '', NULL);
INSERT INTO chado.dbxref VALUES (763, 24, '0000354', '', NULL);
INSERT INTO chado.dbxref VALUES (764, 24, '0000355', '', NULL);
INSERT INTO chado.dbxref VALUES (765, 24, '0000356', '', NULL);
INSERT INTO chado.dbxref VALUES (766, 24, '0000357', '', NULL);
INSERT INTO chado.dbxref VALUES (767, 24, '0000359', '', NULL);
INSERT INTO chado.dbxref VALUES (768, 24, '0000361', '', NULL);
INSERT INTO chado.dbxref VALUES (769, 24, '0000362', '', NULL);
INSERT INTO chado.dbxref VALUES (770, 24, '0000790', '', NULL);
INSERT INTO chado.dbxref VALUES (771, 24, '0000363', '', NULL);
INSERT INTO chado.dbxref VALUES (772, 24, '0000902', '', NULL);
INSERT INTO chado.dbxref VALUES (773, 24, '0000364', '', NULL);
INSERT INTO chado.dbxref VALUES (774, 24, '0000365', '', NULL);
INSERT INTO chado.dbxref VALUES (775, 24, '0000366', '', NULL);
INSERT INTO chado.dbxref VALUES (776, 24, '0000367', '', NULL);
INSERT INTO chado.dbxref VALUES (777, 24, '0000946', '', NULL);
INSERT INTO chado.dbxref VALUES (778, 24, '0000368', '', NULL);
INSERT INTO chado.dbxref VALUES (779, 24, '0000369', '', NULL);
INSERT INTO chado.dbxref VALUES (780, 24, '0000371', '', NULL);
INSERT INTO chado.dbxref VALUES (781, 24, '0000372', '', NULL);
INSERT INTO chado.dbxref VALUES (782, 24, '0001185', '', NULL);
INSERT INTO chado.dbxref VALUES (783, 24, '0000373', '', NULL);
INSERT INTO chado.dbxref VALUES (784, 24, '0000456', '', NULL);
INSERT INTO chado.dbxref VALUES (785, 24, '1000036', '', NULL);
INSERT INTO chado.dbxref VALUES (786, 24, '0000374', '', NULL);
INSERT INTO chado.dbxref VALUES (787, 24, '0001186', '', NULL);
INSERT INTO chado.dbxref VALUES (788, 24, '0000375', '', NULL);
INSERT INTO chado.dbxref VALUES (789, 24, '0000651', '', NULL);
INSERT INTO chado.dbxref VALUES (790, 24, '0002240', '', NULL);
INSERT INTO chado.dbxref VALUES (791, 24, '0000376', '', NULL);
INSERT INTO chado.dbxref VALUES (792, 24, '0000377', '', NULL);
INSERT INTO chado.dbxref VALUES (793, 24, '0000378', '', NULL);
INSERT INTO chado.dbxref VALUES (794, 24, '0000379', '', NULL);
INSERT INTO chado.dbxref VALUES (795, 24, '0000380', '', NULL);
INSERT INTO chado.dbxref VALUES (796, 24, '0000381', '', NULL);
INSERT INTO chado.dbxref VALUES (797, 24, '0000603', '', NULL);
INSERT INTO chado.dbxref VALUES (798, 24, '0000382', '', NULL);
INSERT INTO chado.dbxref VALUES (799, 24, '0000383', '', NULL);
INSERT INTO chado.dbxref VALUES (800, 24, '0000644', '', NULL);
INSERT INTO chado.dbxref VALUES (801, 24, '0000384', '', NULL);
INSERT INTO chado.dbxref VALUES (802, 24, '0000385', '', NULL);
INSERT INTO chado.dbxref VALUES (803, 24, '0000386', '', NULL);
INSERT INTO chado.dbxref VALUES (804, 24, '0000387', '', NULL);
INSERT INTO chado.dbxref VALUES (805, 24, '0000388', '', NULL);
INSERT INTO chado.dbxref VALUES (806, 24, '0000389', '', NULL);
INSERT INTO chado.dbxref VALUES (807, 24, '0000390', '', NULL);
INSERT INTO chado.dbxref VALUES (808, 24, '0000391', '', NULL);
INSERT INTO chado.dbxref VALUES (809, 24, '0000392', '', NULL);
INSERT INTO chado.dbxref VALUES (810, 24, '0000393', '', NULL);
INSERT INTO chado.dbxref VALUES (811, 24, '0000394', '', NULL);
INSERT INTO chado.dbxref VALUES (812, 24, '0000395', '', NULL);
INSERT INTO chado.dbxref VALUES (813, 24, '0000396', '', NULL);
INSERT INTO chado.dbxref VALUES (814, 24, '0000397', '', NULL);
INSERT INTO chado.dbxref VALUES (815, 24, '0000398', '', NULL);
INSERT INTO chado.dbxref VALUES (816, 24, '0000399', '', NULL);
INSERT INTO chado.dbxref VALUES (817, 24, '0000400', '', NULL);
INSERT INTO chado.dbxref VALUES (818, 24, '0000402', '', NULL);
INSERT INTO chado.dbxref VALUES (819, 24, '0000403', '', NULL);
INSERT INTO chado.dbxref VALUES (820, 24, '0005839', '', NULL);
INSERT INTO chado.dbxref VALUES (821, 24, '0000593', '', NULL);
INSERT INTO chado.dbxref VALUES (822, 24, '0005837', '', NULL);
INSERT INTO chado.dbxref VALUES (823, 24, '0000404', '', NULL);
INSERT INTO chado.dbxref VALUES (824, 24, '0000405', '', NULL);
INSERT INTO chado.dbxref VALUES (825, 24, '0000406', '', NULL);
INSERT INTO chado.dbxref VALUES (826, 24, '0000407', '', NULL);
INSERT INTO chado.dbxref VALUES (827, 24, '0000650', '', NULL);
INSERT INTO chado.dbxref VALUES (828, 24, '0002236', '', NULL);
INSERT INTO chado.dbxref VALUES (829, 24, '0000408', '', NULL);
INSERT INTO chado.dbxref VALUES (830, 24, '0000409', '', NULL);
INSERT INTO chado.dbxref VALUES (831, 35, '00033', '', NULL);
INSERT INTO chado.dbxref VALUES (832, 24, '0000410', '', NULL);
INSERT INTO chado.dbxref VALUES (833, 24, '0000411', '', NULL);
INSERT INTO chado.dbxref VALUES (834, 24, '0000814', '', NULL);
INSERT INTO chado.dbxref VALUES (835, 24, '0000413', '', NULL);
INSERT INTO chado.dbxref VALUES (836, 24, '0000700', '', NULL);
INSERT INTO chado.dbxref VALUES (837, 24, '0000414', '', NULL);
INSERT INTO chado.dbxref VALUES (838, 24, '0000415', '', NULL);
INSERT INTO chado.dbxref VALUES (839, 24, '0000416', '', NULL);
INSERT INTO chado.dbxref VALUES (840, 24, '0000417', '', NULL);
INSERT INTO chado.dbxref VALUES (841, 35, '00012', '', NULL);
INSERT INTO chado.dbxref VALUES (842, 35, '00134', '', NULL);
INSERT INTO chado.dbxref VALUES (843, 24, '0001069', '', NULL);
INSERT INTO chado.dbxref VALUES (844, 24, '0001070', '', NULL);
INSERT INTO chado.dbxref VALUES (845, 24, '0100021', '', NULL);
INSERT INTO chado.dbxref VALUES (846, 24, '0000418', '', NULL);
INSERT INTO chado.dbxref VALUES (847, 35, '00159', '', NULL);
INSERT INTO chado.dbxref VALUES (848, 24, '0001527', '', NULL);
INSERT INTO chado.dbxref VALUES (849, 24, '0002251', '', NULL);
INSERT INTO chado.dbxref VALUES (850, 24, '0001062', '', NULL);
INSERT INTO chado.dbxref VALUES (851, 24, '0000419', '', NULL);
INSERT INTO chado.dbxref VALUES (852, 35, '00149', '', NULL);
INSERT INTO chado.dbxref VALUES (853, 24, '0000839', '', NULL);
INSERT INTO chado.dbxref VALUES (854, 24, '0002249', '', NULL);
INSERT INTO chado.dbxref VALUES (855, 24, '0001063', '', NULL);
INSERT INTO chado.dbxref VALUES (856, 24, '0000420', '', NULL);
INSERT INTO chado.dbxref VALUES (857, 24, '0000481', '', NULL);
INSERT INTO chado.dbxref VALUES (858, 24, '0000421', '', NULL);
INSERT INTO chado.dbxref VALUES (859, 24, '0000422', '', NULL);
INSERT INTO chado.dbxref VALUES (860, 24, '0000848', '', NULL);
INSERT INTO chado.dbxref VALUES (861, 24, '0000423', '', NULL);
INSERT INTO chado.dbxref VALUES (862, 24, '0000424', '', NULL);
INSERT INTO chado.dbxref VALUES (863, 24, '0000425', '', NULL);
INSERT INTO chado.dbxref VALUES (864, 24, '0000426', '', NULL);
INSERT INTO chado.dbxref VALUES (865, 24, '0000427', '', NULL);
INSERT INTO chado.dbxref VALUES (866, 24, '0000850', '', NULL);
INSERT INTO chado.dbxref VALUES (867, 24, '0000428', '', NULL);
INSERT INTO chado.dbxref VALUES (868, 24, '0000429', '', NULL);
INSERT INTO chado.dbxref VALUES (869, 24, '0000430', '', NULL);
INSERT INTO chado.dbxref VALUES (870, 24, '0000849', '', NULL);
INSERT INTO chado.dbxref VALUES (871, 24, '0000431', '', NULL);
INSERT INTO chado.dbxref VALUES (872, 24, '0000432', '', NULL);
INSERT INTO chado.dbxref VALUES (873, 24, '0000433', '', NULL);
INSERT INTO chado.dbxref VALUES (874, 24, '0000840', '', NULL);
INSERT INTO chado.dbxref VALUES (875, 24, '0000434', '', NULL);
INSERT INTO chado.dbxref VALUES (876, 24, '0000435', '', NULL);
INSERT INTO chado.dbxref VALUES (877, 24, '0000436', '', NULL);
INSERT INTO chado.dbxref VALUES (878, 24, '0000437', '', NULL);
INSERT INTO chado.dbxref VALUES (879, 24, '0000438', '', NULL);
INSERT INTO chado.dbxref VALUES (880, 24, '0000439', '', NULL);
INSERT INTO chado.dbxref VALUES (881, 24, '1000030', '', NULL);
INSERT INTO chado.dbxref VALUES (882, 24, '1000045', '', NULL);
INSERT INTO chado.dbxref VALUES (883, 24, '0000444', '', NULL);
INSERT INTO chado.dbxref VALUES (884, 24, '0000445', '', NULL);
INSERT INTO chado.dbxref VALUES (885, 24, '0000446', '', NULL);
INSERT INTO chado.dbxref VALUES (886, 24, '0000447', '', NULL);
INSERT INTO chado.dbxref VALUES (887, 24, '0000448', '', NULL);
INSERT INTO chado.dbxref VALUES (888, 24, '0000449', '', NULL);
INSERT INTO chado.dbxref VALUES (889, 24, '0000450', '', NULL);
INSERT INTO chado.dbxref VALUES (890, 24, '0000451', '', NULL);
INSERT INTO chado.dbxref VALUES (891, 24, '0001217', '', NULL);
INSERT INTO chado.dbxref VALUES (892, 24, '0000871', '', NULL);
INSERT INTO chado.dbxref VALUES (893, 24, '0000452', '', NULL);
INSERT INTO chado.dbxref VALUES (894, 24, '0000453', '', NULL);
INSERT INTO chado.dbxref VALUES (895, 24, '0000454', '', NULL);
INSERT INTO chado.dbxref VALUES (896, 24, '0001035', '', NULL);
INSERT INTO chado.dbxref VALUES (897, 24, '0000455', '', NULL);
INSERT INTO chado.dbxref VALUES (898, 24, '0000940', '', NULL);
INSERT INTO chado.dbxref VALUES (899, 24, '0000457', '', NULL);
INSERT INTO chado.dbxref VALUES (900, 24, '1000037', '', NULL);
INSERT INTO chado.dbxref VALUES (901, 24, '0000458', '', NULL);
INSERT INTO chado.dbxref VALUES (902, 24, '0000460', '', NULL);
INSERT INTO chado.dbxref VALUES (903, 24, '0000459', '', NULL);
INSERT INTO chado.dbxref VALUES (904, 24, '0000479', '', NULL);
INSERT INTO chado.dbxref VALUES (905, 24, '0000461', '', NULL);
INSERT INTO chado.dbxref VALUES (906, 24, '0000462', '', NULL);
INSERT INTO chado.dbxref VALUES (907, 24, '0000463', '', NULL);
INSERT INTO chado.dbxref VALUES (908, 24, '0000464', '', NULL);
INSERT INTO chado.dbxref VALUES (909, 24, '0000465', '', NULL);
INSERT INTO chado.dbxref VALUES (910, 24, '1000038', '', NULL);
INSERT INTO chado.dbxref VALUES (911, 24, '0000466', '', NULL);
INSERT INTO chado.dbxref VALUES (912, 24, '0000467', '', NULL);
INSERT INTO chado.dbxref VALUES (913, 24, '0000468', '', NULL);
INSERT INTO chado.dbxref VALUES (914, 24, '0000688', '', NULL);
INSERT INTO chado.dbxref VALUES (915, 24, '0000469', '', NULL);
INSERT INTO chado.dbxref VALUES (916, 24, '0000470', '', NULL);
INSERT INTO chado.dbxref VALUES (917, 24, '0000471', '', NULL);
INSERT INTO chado.dbxref VALUES (918, 24, '0000472', '', NULL);
INSERT INTO chado.dbxref VALUES (919, 24, '0000473', '', NULL);
INSERT INTO chado.dbxref VALUES (920, 24, '0000474', '', NULL);
INSERT INTO chado.dbxref VALUES (921, 24, '0000475', '', NULL);
INSERT INTO chado.dbxref VALUES (922, 24, '0000476', '', NULL);
INSERT INTO chado.dbxref VALUES (923, 24, '0000477', '', NULL);
INSERT INTO chado.dbxref VALUES (924, 24, '0000478', '', NULL);
INSERT INTO chado.dbxref VALUES (925, 24, '0000870', '', NULL);
INSERT INTO chado.dbxref VALUES (926, 24, '0000480', '', NULL);
INSERT INTO chado.dbxref VALUES (927, 24, '0000482', '', NULL);
INSERT INTO chado.dbxref VALUES (928, 24, '0000484', '', NULL);
INSERT INTO chado.dbxref VALUES (929, 24, '0001214', '', NULL);
INSERT INTO chado.dbxref VALUES (930, 24, '0000485', '', NULL);
INSERT INTO chado.dbxref VALUES (931, 24, '0000938', '', NULL);
INSERT INTO chado.dbxref VALUES (932, 24, '0000572', '', NULL);
INSERT INTO chado.dbxref VALUES (933, 24, '0000486', '', NULL);
INSERT INTO chado.dbxref VALUES (934, 24, '0000487', '', NULL);
INSERT INTO chado.dbxref VALUES (935, 24, '0000574', '', NULL);
INSERT INTO chado.dbxref VALUES (936, 24, '0000488', '', NULL);
INSERT INTO chado.dbxref VALUES (937, 24, '0000489', '', NULL);
INSERT INTO chado.dbxref VALUES (938, 24, '0000576', '', NULL);
INSERT INTO chado.dbxref VALUES (939, 24, '0000490', '', NULL);
INSERT INTO chado.dbxref VALUES (940, 24, '0000491', '', NULL);
INSERT INTO chado.dbxref VALUES (941, 24, '0000492', '', NULL);
INSERT INTO chado.dbxref VALUES (942, 24, '0000493', '', NULL);
INSERT INTO chado.dbxref VALUES (943, 24, '0000561', '', NULL);
INSERT INTO chado.dbxref VALUES (944, 24, '0000570', '', NULL);
INSERT INTO chado.dbxref VALUES (945, 24, '0000494', '', NULL);
INSERT INTO chado.dbxref VALUES (946, 24, '0000562', '', NULL);
INSERT INTO chado.dbxref VALUES (947, 24, '0000495', '', NULL);
INSERT INTO chado.dbxref VALUES (948, 24, '0000563', '', NULL);
INSERT INTO chado.dbxref VALUES (949, 24, '0000496', '', NULL);
INSERT INTO chado.dbxref VALUES (950, 24, '0000556', '', NULL);
INSERT INTO chado.dbxref VALUES (951, 24, '0000497', '', NULL);
INSERT INTO chado.dbxref VALUES (952, 24, '0000498', '', NULL);
INSERT INTO chado.dbxref VALUES (953, 24, '0000499', '', NULL);
INSERT INTO chado.dbxref VALUES (954, 24, '0000500', '', NULL);
INSERT INTO chado.dbxref VALUES (955, 24, '0000501', '', NULL);
INSERT INTO chado.dbxref VALUES (956, 24, '0000502', '', NULL);
INSERT INTO chado.dbxref VALUES (957, 24, '0000503', '', NULL);
INSERT INTO chado.dbxref VALUES (958, 24, '0000504', '', NULL);
INSERT INTO chado.dbxref VALUES (959, 24, '0000505', '', NULL);
INSERT INTO chado.dbxref VALUES (960, 24, '0000506', '', NULL);
INSERT INTO chado.dbxref VALUES (961, 24, '0000507', '', NULL);
INSERT INTO chado.dbxref VALUES (962, 24, '0000516', '', NULL);
INSERT INTO chado.dbxref VALUES (963, 24, '0000508', '', NULL);
INSERT INTO chado.dbxref VALUES (964, 24, '0000509', '', NULL);
INSERT INTO chado.dbxref VALUES (965, 24, '0000510', '', NULL);
INSERT INTO chado.dbxref VALUES (966, 24, '0000936', '', NULL);
INSERT INTO chado.dbxref VALUES (967, 24, '0000511', '', NULL);
INSERT INTO chado.dbxref VALUES (968, 24, '0000512', '', NULL);
INSERT INTO chado.dbxref VALUES (969, 24, '0000513', '', NULL);
INSERT INTO chado.dbxref VALUES (970, 24, '0000514', '', NULL);
INSERT INTO chado.dbxref VALUES (971, 24, '0000515', '', NULL);
INSERT INTO chado.dbxref VALUES (972, 24, '0000517', '', NULL);
INSERT INTO chado.dbxref VALUES (973, 24, '0000518', '', NULL);
INSERT INTO chado.dbxref VALUES (974, 24, '0000519', '', NULL);
INSERT INTO chado.dbxref VALUES (975, 24, '0000520', '', NULL);
INSERT INTO chado.dbxref VALUES (976, 24, '0000521', '', NULL);
INSERT INTO chado.dbxref VALUES (977, 24, '0000522', '', NULL);
INSERT INTO chado.dbxref VALUES (978, 24, '0000523', '', NULL);
INSERT INTO chado.dbxref VALUES (979, 24, '0000524', '', NULL);
INSERT INTO chado.dbxref VALUES (980, 24, '0000525', '', NULL);
INSERT INTO chado.dbxref VALUES (981, 24, '0000526', '', NULL);
INSERT INTO chado.dbxref VALUES (982, 24, '0000527', '', NULL);
INSERT INTO chado.dbxref VALUES (983, 24, '0000528', '', NULL);
INSERT INTO chado.dbxref VALUES (984, 24, '0000529', '', NULL);
INSERT INTO chado.dbxref VALUES (985, 24, '0000530', '', NULL);
INSERT INTO chado.dbxref VALUES (986, 24, '0000531', '', NULL);
INSERT INTO chado.dbxref VALUES (987, 24, '0000532', '', NULL);
INSERT INTO chado.dbxref VALUES (988, 24, '0000533', '', NULL);
INSERT INTO chado.dbxref VALUES (989, 24, '0000538', '', NULL);
INSERT INTO chado.dbxref VALUES (990, 24, '0000534', '', NULL);
INSERT INTO chado.dbxref VALUES (991, 24, '0000535', '', NULL);
INSERT INTO chado.dbxref VALUES (992, 24, '0000536', '', NULL);
INSERT INTO chado.dbxref VALUES (993, 24, '0000537', '', NULL);
INSERT INTO chado.dbxref VALUES (994, 24, '0000539', '', NULL);
INSERT INTO chado.dbxref VALUES (995, 24, '0000540', '', NULL);
INSERT INTO chado.dbxref VALUES (996, 24, '0000541', '', NULL);
INSERT INTO chado.dbxref VALUES (997, 24, '0000542', '', NULL);
INSERT INTO chado.dbxref VALUES (998, 24, '0000543', '', NULL);
INSERT INTO chado.dbxref VALUES (999, 24, '0000544', '', NULL);
INSERT INTO chado.dbxref VALUES (1000, 24, '0000545', '', NULL);
INSERT INTO chado.dbxref VALUES (1001, 24, '0000591', '', NULL);
INSERT INTO chado.dbxref VALUES (1002, 24, '1001268', '', NULL);
INSERT INTO chado.dbxref VALUES (1003, 24, '0000546', '', NULL);
INSERT INTO chado.dbxref VALUES (1004, 24, '0000547', '', NULL);
INSERT INTO chado.dbxref VALUES (1005, 24, '0000548', '', NULL);
INSERT INTO chado.dbxref VALUES (1006, 24, '0000873', '', NULL);
INSERT INTO chado.dbxref VALUES (1007, 24, '0000549', '', NULL);
INSERT INTO chado.dbxref VALUES (1008, 24, '0000550', '', NULL);
INSERT INTO chado.dbxref VALUES (1009, 24, '0000551', '', NULL);
INSERT INTO chado.dbxref VALUES (1010, 24, '0000552', '', NULL);
INSERT INTO chado.dbxref VALUES (1011, 24, '0000553', '', NULL);
INSERT INTO chado.dbxref VALUES (1012, 24, '0001430', '', NULL);
INSERT INTO chado.dbxref VALUES (1013, 24, '0000554', '', NULL);
INSERT INTO chado.dbxref VALUES (1014, 24, '0000555', '', NULL);
INSERT INTO chado.dbxref VALUES (1015, 24, '0000557', '', NULL);
INSERT INTO chado.dbxref VALUES (1016, 24, '0000558', '', NULL);
INSERT INTO chado.dbxref VALUES (1017, 24, '0000559', '', NULL);
INSERT INTO chado.dbxref VALUES (1018, 24, '0000560', '', NULL);
INSERT INTO chado.dbxref VALUES (1019, 24, '0000564', '', NULL);
INSERT INTO chado.dbxref VALUES (1020, 24, '0000565', '', NULL);
INSERT INTO chado.dbxref VALUES (1021, 24, '0000566', '', NULL);
INSERT INTO chado.dbxref VALUES (1022, 24, '0000567', '', NULL);
INSERT INTO chado.dbxref VALUES (1023, 24, '0000568', '', NULL);
INSERT INTO chado.dbxref VALUES (1024, 24, '0000569', '', NULL);
INSERT INTO chado.dbxref VALUES (1025, 24, '0100042', '', NULL);
INSERT INTO chado.dbxref VALUES (1026, 24, '0000571', '', NULL);
INSERT INTO chado.dbxref VALUES (1027, 24, '0000573', '', NULL);
INSERT INTO chado.dbxref VALUES (1028, 24, '0000575', '', NULL);
INSERT INTO chado.dbxref VALUES (1029, 24, '0000577', '', NULL);
INSERT INTO chado.dbxref VALUES (1030, 24, '0000628', '', NULL);
INSERT INTO chado.dbxref VALUES (1031, 24, '0000578', '', NULL);
INSERT INTO chado.dbxref VALUES (1032, 24, '0000579', '', NULL);
INSERT INTO chado.dbxref VALUES (1033, 24, '0000580', '', NULL);
INSERT INTO chado.dbxref VALUES (1034, 24, '0000581', '', NULL);
INSERT INTO chado.dbxref VALUES (1035, 24, '0000582', '', NULL);
INSERT INTO chado.dbxref VALUES (1036, 24, '0000583', '', NULL);
INSERT INTO chado.dbxref VALUES (1037, 24, '0000584', '', NULL);
INSERT INTO chado.dbxref VALUES (1038, 24, '0000585', '', NULL);
INSERT INTO chado.dbxref VALUES (1039, 24, '0000586', '', NULL);
INSERT INTO chado.dbxref VALUES (1040, 24, '0000587', '', NULL);
INSERT INTO chado.dbxref VALUES (1041, 24, '0000588', '', NULL);
INSERT INTO chado.dbxref VALUES (1042, 24, '0000589', '', NULL);
INSERT INTO chado.dbxref VALUES (1043, 24, '0000590', '', NULL);
INSERT INTO chado.dbxref VALUES (1044, 24, '0000592', '', NULL);
INSERT INTO chado.dbxref VALUES (1045, 24, '0000595', '', NULL);
INSERT INTO chado.dbxref VALUES (1046, 24, '0000594', '', NULL);
INSERT INTO chado.dbxref VALUES (1047, 24, '0000596', '', NULL);
INSERT INTO chado.dbxref VALUES (1048, 24, '0000597', '', NULL);
INSERT INTO chado.dbxref VALUES (1049, 24, '0000598', '', NULL);
INSERT INTO chado.dbxref VALUES (1050, 24, '0000599', '', NULL);
INSERT INTO chado.dbxref VALUES (1051, 24, '0000600', '', NULL);
INSERT INTO chado.dbxref VALUES (1052, 24, '0000601', '', NULL);
INSERT INTO chado.dbxref VALUES (1053, 24, '0000602', '', NULL);
INSERT INTO chado.dbxref VALUES (1054, 24, '0000604', '', NULL);
INSERT INTO chado.dbxref VALUES (1055, 24, '0000605', '', NULL);
INSERT INTO chado.dbxref VALUES (1056, 24, '0000606', '', NULL);
INSERT INTO chado.dbxref VALUES (1057, 24, '0000607', '', NULL);
INSERT INTO chado.dbxref VALUES (1058, 24, '0000608', '', NULL);
INSERT INTO chado.dbxref VALUES (1059, 24, '0000609', '', NULL);
INSERT INTO chado.dbxref VALUES (1060, 24, '0000610', '', NULL);
INSERT INTO chado.dbxref VALUES (1061, 24, '0000611', '', NULL);
INSERT INTO chado.dbxref VALUES (1062, 24, '0000612', '', NULL);
INSERT INTO chado.dbxref VALUES (1063, 24, '0000613', '', NULL);
INSERT INTO chado.dbxref VALUES (1064, 24, '0002222', '', NULL);
INSERT INTO chado.dbxref VALUES (1065, 24, '0000614', '', NULL);
INSERT INTO chado.dbxref VALUES (1066, 24, '0000615', '', NULL);
INSERT INTO chado.dbxref VALUES (1067, 24, '0000951', '', NULL);
INSERT INTO chado.dbxref VALUES (1068, 24, '0000616', '', NULL);
INSERT INTO chado.dbxref VALUES (1069, 24, '0000617', '', NULL);
INSERT INTO chado.dbxref VALUES (1070, 24, '0000618', '', NULL);
INSERT INTO chado.dbxref VALUES (1071, 24, '0000619', '', NULL);
INSERT INTO chado.dbxref VALUES (1072, 24, '0000620', '', NULL);
INSERT INTO chado.dbxref VALUES (1073, 24, '0000621', '', NULL);
INSERT INTO chado.dbxref VALUES (1074, 24, '0000622', '', NULL);
INSERT INTO chado.dbxref VALUES (1075, 24, '0000623', '', NULL);
INSERT INTO chado.dbxref VALUES (1076, 24, '0000624', '', NULL);
INSERT INTO chado.dbxref VALUES (1077, 24, '0000625', '', NULL);
INSERT INTO chado.dbxref VALUES (1078, 24, '0000627', '', NULL);
INSERT INTO chado.dbxref VALUES (1079, 24, '0000629', '', NULL);
INSERT INTO chado.dbxref VALUES (1080, 24, '0000630', '', NULL);
INSERT INTO chado.dbxref VALUES (1081, 24, '0000837', '', NULL);
INSERT INTO chado.dbxref VALUES (1082, 24, '0000631', '', NULL);
INSERT INTO chado.dbxref VALUES (1083, 24, '0000632', '', NULL);
INSERT INTO chado.dbxref VALUES (1084, 24, '0000665', '', NULL);
INSERT INTO chado.dbxref VALUES (1085, 24, '0000878', '', NULL);
INSERT INTO chado.dbxref VALUES (1086, 24, '0000633', '', NULL);
INSERT INTO chado.dbxref VALUES (1087, 24, '0000634', '', NULL);
INSERT INTO chado.dbxref VALUES (1088, 24, '0000635', '', NULL);
INSERT INTO chado.dbxref VALUES (1089, 24, '0000636', '', NULL);
INSERT INTO chado.dbxref VALUES (1090, 24, '0000637', '', NULL);
INSERT INTO chado.dbxref VALUES (1091, 24, '0000638', '', NULL);
INSERT INTO chado.dbxref VALUES (1092, 24, '0000838', '', NULL);
INSERT INTO chado.dbxref VALUES (1093, 24, '0000639', '', NULL);
INSERT INTO chado.dbxref VALUES (1094, 24, '0000640', '', NULL);
INSERT INTO chado.dbxref VALUES (1095, 24, '0000641', '', NULL);
INSERT INTO chado.dbxref VALUES (1096, 24, '0000642', '', NULL);
INSERT INTO chado.dbxref VALUES (1097, 24, '0000643', '', NULL);
INSERT INTO chado.dbxref VALUES (1098, 24, '0000645', '', NULL);
INSERT INTO chado.dbxref VALUES (1099, 24, '0000646', '', NULL);
INSERT INTO chado.dbxref VALUES (1100, 24, '0000647', '', NULL);
INSERT INTO chado.dbxref VALUES (1101, 24, '0000648', '', NULL);
INSERT INTO chado.dbxref VALUES (1102, 24, '0002343', '', NULL);
INSERT INTO chado.dbxref VALUES (1103, 24, '0000652', '', NULL);
INSERT INTO chado.dbxref VALUES (1104, 24, '0002238', '', NULL);
INSERT INTO chado.dbxref VALUES (1105, 24, '0000653', '', NULL);
INSERT INTO chado.dbxref VALUES (1106, 24, '0002239', '', NULL);
INSERT INTO chado.dbxref VALUES (1107, 24, '0000654', '', NULL);
INSERT INTO chado.dbxref VALUES (1108, 24, '0000742', '', NULL);
INSERT INTO chado.dbxref VALUES (1109, 24, '0000656', '', NULL);
INSERT INTO chado.dbxref VALUES (1110, 24, '0000726', '', NULL);
INSERT INTO chado.dbxref VALUES (1111, 24, '0000658', '', NULL);
INSERT INTO chado.dbxref VALUES (1112, 24, '0000659', '', NULL);
INSERT INTO chado.dbxref VALUES (1113, 24, '0000660', '', NULL);
INSERT INTO chado.dbxref VALUES (1114, 24, '0000661', '', NULL);
INSERT INTO chado.dbxref VALUES (1115, 24, '0000663', '', NULL);
INSERT INTO chado.dbxref VALUES (1116, 24, '0000664', '', NULL);
INSERT INTO chado.dbxref VALUES (1117, 24, '0000666', '', NULL);
INSERT INTO chado.dbxref VALUES (1118, 24, '0001037', '', NULL);
INSERT INTO chado.dbxref VALUES (1119, 24, '0001234', '', NULL);
INSERT INTO chado.dbxref VALUES (1120, 24, '0000667', '', NULL);
INSERT INTO chado.dbxref VALUES (1121, 24, '1000034', '', NULL);
INSERT INTO chado.dbxref VALUES (1122, 34, 'LA6687-3', '', NULL);
INSERT INTO chado.dbxref VALUES (1123, 24, '0000668', '', NULL);
INSERT INTO chado.dbxref VALUES (1124, 24, '0000670', '', NULL);
INSERT INTO chado.dbxref VALUES (1125, 24, '0000671', '', NULL);
INSERT INTO chado.dbxref VALUES (1126, 24, '0000672', '', NULL);
INSERT INTO chado.dbxref VALUES (1127, 24, '0000831', '', NULL);
INSERT INTO chado.dbxref VALUES (1128, 24, '0002300', '', NULL);
INSERT INTO chado.dbxref VALUES (1129, 24, '0000674', '', NULL);
INSERT INTO chado.dbxref VALUES (1130, 24, '0000675', '', NULL);
INSERT INTO chado.dbxref VALUES (1131, 24, '0000676', '', NULL);
INSERT INTO chado.dbxref VALUES (1132, 24, '0000677', '', NULL);
INSERT INTO chado.dbxref VALUES (1133, 24, '0000678', '', NULL);
INSERT INTO chado.dbxref VALUES (1134, 24, '0000679', '', NULL);
INSERT INTO chado.dbxref VALUES (1135, 24, '0000680', '', NULL);
INSERT INTO chado.dbxref VALUES (1136, 24, '0000681', '', NULL);
INSERT INTO chado.dbxref VALUES (1137, 24, '0000682', '', NULL);
INSERT INTO chado.dbxref VALUES (1138, 24, '0000683', '', NULL);
INSERT INTO chado.dbxref VALUES (1139, 24, '0000685', '', NULL);
INSERT INTO chado.dbxref VALUES (1140, 24, '0000686', '', NULL);
INSERT INTO chado.dbxref VALUES (1141, 24, '1000044', '', NULL);
INSERT INTO chado.dbxref VALUES (1142, 24, '0000687', '', NULL);
INSERT INTO chado.dbxref VALUES (1143, 24, '0000689', '', NULL);
INSERT INTO chado.dbxref VALUES (1144, 24, '0000690', '', NULL);
INSERT INTO chado.dbxref VALUES (1145, 24, '0000691', '', NULL);
INSERT INTO chado.dbxref VALUES (1146, 35, '00067', '', NULL);
INSERT INTO chado.dbxref VALUES (1147, 24, '0100011', '', NULL);
INSERT INTO chado.dbxref VALUES (1148, 24, '0000692', '', NULL);
INSERT INTO chado.dbxref VALUES (1149, 24, '0000693', '', NULL);
INSERT INTO chado.dbxref VALUES (1150, 24, '0000881', '', NULL);
INSERT INTO chado.dbxref VALUES (1151, 24, '0000694', '', NULL);
INSERT INTO chado.dbxref VALUES (1152, 24, '0001483', '', NULL);
INSERT INTO chado.dbxref VALUES (1153, 24, '0001409', '', NULL);
INSERT INTO chado.dbxref VALUES (1154, 24, '0000697', '', NULL);
INSERT INTO chado.dbxref VALUES (1155, 24, '0000883', '', NULL);
INSERT INTO chado.dbxref VALUES (1156, 24, '0000698', '', NULL);
INSERT INTO chado.dbxref VALUES (1157, 24, '0000884', '', NULL);
INSERT INTO chado.dbxref VALUES (1158, 24, '0000701', '', NULL);
INSERT INTO chado.dbxref VALUES (1159, 24, '0000702', '', NULL);
INSERT INTO chado.dbxref VALUES (1160, 24, '0000703', '', NULL);
INSERT INTO chado.dbxref VALUES (1161, 24, '0000706', '', NULL);
INSERT INTO chado.dbxref VALUES (1162, 24, '0001420', '', NULL);
INSERT INTO chado.dbxref VALUES (1163, 24, '0000707', '', NULL);
INSERT INTO chado.dbxref VALUES (1164, 24, '0000708', '', NULL);
INSERT INTO chado.dbxref VALUES (1165, 24, '0000709', '', NULL);
INSERT INTO chado.dbxref VALUES (1166, 24, '0000710', '', NULL);
INSERT INTO chado.dbxref VALUES (1167, 24, '0000885', '', NULL);
INSERT INTO chado.dbxref VALUES (1168, 24, '0000711', '', NULL);
INSERT INTO chado.dbxref VALUES (1169, 24, '0000886', '', NULL);
INSERT INTO chado.dbxref VALUES (1170, 24, '0000712', '', NULL);
INSERT INTO chado.dbxref VALUES (1171, 24, '0000714', '', NULL);
INSERT INTO chado.dbxref VALUES (1172, 24, '0001683', '', NULL);
INSERT INTO chado.dbxref VALUES (1173, 24, '0000716', '', NULL);
INSERT INTO chado.dbxref VALUES (1174, 24, '0000718', '', NULL);
INSERT INTO chado.dbxref VALUES (1175, 24, '0000720', '', NULL);
INSERT INTO chado.dbxref VALUES (1176, 24, '0000721', '', NULL);
INSERT INTO chado.dbxref VALUES (1177, 24, '1001197', '', NULL);
INSERT INTO chado.dbxref VALUES (1178, 24, '0000722', '', NULL);
INSERT INTO chado.dbxref VALUES (1179, 24, '0000723', '', NULL);
INSERT INTO chado.dbxref VALUES (1180, 24, '0000724', '', NULL);
INSERT INTO chado.dbxref VALUES (1181, 24, '0000725', '', NULL);
INSERT INTO chado.dbxref VALUES (1182, 35, '00055', '', NULL);
INSERT INTO chado.dbxref VALUES (1183, 24, '0002252', '', NULL);
INSERT INTO chado.dbxref VALUES (1184, 24, '0000728', '', NULL);
INSERT INTO chado.dbxref VALUES (1185, 24, '0000729', '', NULL);
INSERT INTO chado.dbxref VALUES (1186, 24, '0000730', '', NULL);
INSERT INTO chado.dbxref VALUES (1187, 24, '0000731', '', NULL);
INSERT INTO chado.dbxref VALUES (1188, 24, '0000905', '', NULL);
INSERT INTO chado.dbxref VALUES (1189, 24, '0000732', '', NULL);
INSERT INTO chado.dbxref VALUES (1190, 24, '0000734', '', NULL);
INSERT INTO chado.dbxref VALUES (1191, 24, '0000864', '', NULL);
INSERT INTO chado.dbxref VALUES (1192, 24, '0000735', '', NULL);
INSERT INTO chado.dbxref VALUES (1193, 24, '0000826', '', NULL);
INSERT INTO chado.dbxref VALUES (1194, 24, '0001026', '', NULL);
INSERT INTO chado.dbxref VALUES (1195, 24, '0000980', '', NULL);
INSERT INTO chado.dbxref VALUES (1196, 24, '0000827', '', NULL);
INSERT INTO chado.dbxref VALUES (1197, 24, '0000750', '', NULL);
INSERT INTO chado.dbxref VALUES (1198, 24, '0000752', '', NULL);
INSERT INTO chado.dbxref VALUES (1199, 24, '0000754', '', NULL);
INSERT INTO chado.dbxref VALUES (1200, 24, '0000755', '', NULL);
INSERT INTO chado.dbxref VALUES (1201, 24, '0000757', '', NULL);
INSERT INTO chado.dbxref VALUES (1202, 24, '0000758', '', NULL);
INSERT INTO chado.dbxref VALUES (1203, 24, '0000759', '', NULL);
INSERT INTO chado.dbxref VALUES (1204, 24, '0000760', '', NULL);
INSERT INTO chado.dbxref VALUES (1205, 24, '0000761', '', NULL);
INSERT INTO chado.dbxref VALUES (1206, 24, '0000762', '', NULL);
INSERT INTO chado.dbxref VALUES (1207, 24, '0000763', '', NULL);
INSERT INTO chado.dbxref VALUES (1208, 24, '0000764', '', NULL);
INSERT INTO chado.dbxref VALUES (1209, 24, '0000765', '', NULL);
INSERT INTO chado.dbxref VALUES (1210, 24, '0000766', '', NULL);
INSERT INTO chado.dbxref VALUES (1211, 24, '0001178', '', NULL);
INSERT INTO chado.dbxref VALUES (1212, 24, '0000767', '', NULL);
INSERT INTO chado.dbxref VALUES (1213, 24, '0000768', '', NULL);
INSERT INTO chado.dbxref VALUES (1214, 24, '0000769', '', NULL);
INSERT INTO chado.dbxref VALUES (1215, 24, '0000847', '', NULL);
INSERT INTO chado.dbxref VALUES (1216, 24, '0000770', '', NULL);
INSERT INTO chado.dbxref VALUES (1217, 24, '0000772', '', NULL);
INSERT INTO chado.dbxref VALUES (1218, 24, '0000773', '', NULL);
INSERT INTO chado.dbxref VALUES (1219, 24, '0000774', '', NULL);
INSERT INTO chado.dbxref VALUES (1220, 24, '0000775', '', NULL);
INSERT INTO chado.dbxref VALUES (1221, 24, '0000776', '', NULL);
INSERT INTO chado.dbxref VALUES (1222, 24, '0000777', '', NULL);
INSERT INTO chado.dbxref VALUES (1223, 24, '0000778', '', NULL);
INSERT INTO chado.dbxref VALUES (1224, 24, '0000779', '', NULL);
INSERT INTO chado.dbxref VALUES (1225, 24, '0000780', '', NULL);
INSERT INTO chado.dbxref VALUES (1226, 24, '0000781', '', NULL);
INSERT INTO chado.dbxref VALUES (1227, 24, '0000782', '', NULL);
INSERT INTO chado.dbxref VALUES (1228, 24, '0000785', '', NULL);
INSERT INTO chado.dbxref VALUES (1229, 24, '0000786', '', NULL);
INSERT INTO chado.dbxref VALUES (1230, 24, '0000787', '', NULL);
INSERT INTO chado.dbxref VALUES (1231, 24, '0000788', '', NULL);
INSERT INTO chado.dbxref VALUES (1232, 24, '0000791', '', NULL);
INSERT INTO chado.dbxref VALUES (1233, 24, '0000792', '', NULL);
INSERT INTO chado.dbxref VALUES (1234, 24, '0000793', '', NULL);
INSERT INTO chado.dbxref VALUES (1235, 24, '0000794', '', NULL);
INSERT INTO chado.dbxref VALUES (1236, 24, '0000795', '', NULL);
INSERT INTO chado.dbxref VALUES (1237, 24, '0000815', '', NULL);
INSERT INTO chado.dbxref VALUES (1238, 24, '0000796', '', NULL);
INSERT INTO chado.dbxref VALUES (1239, 24, '0000797', '', NULL);
INSERT INTO chado.dbxref VALUES (1240, 24, '0001038', '', NULL);
INSERT INTO chado.dbxref VALUES (1241, 24, '0000798', '', NULL);
INSERT INTO chado.dbxref VALUES (1242, 24, '0000799', '', NULL);
INSERT INTO chado.dbxref VALUES (1243, 24, '0000800', '', NULL);
INSERT INTO chado.dbxref VALUES (1244, 24, '0001504', '', NULL);
INSERT INTO chado.dbxref VALUES (1245, 24, '0000801', '', NULL);
INSERT INTO chado.dbxref VALUES (1246, 24, '0000802', '', NULL);
INSERT INTO chado.dbxref VALUES (1247, 24, '0000803', '', NULL);
INSERT INTO chado.dbxref VALUES (1248, 24, '0000807', '', NULL);
INSERT INTO chado.dbxref VALUES (1249, 24, '0000808', '', NULL);
INSERT INTO chado.dbxref VALUES (1250, 24, '0000809', '', NULL);
INSERT INTO chado.dbxref VALUES (1251, 24, '0000810', '', NULL);
INSERT INTO chado.dbxref VALUES (1252, 24, '0000811', '', NULL);
INSERT INTO chado.dbxref VALUES (1253, 24, '0000812', '', NULL);
INSERT INTO chado.dbxref VALUES (1254, 24, '0000813', '', NULL);
INSERT INTO chado.dbxref VALUES (1255, 24, '0000816', '', NULL);
INSERT INTO chado.dbxref VALUES (1256, 24, '0000817', '', NULL);
INSERT INTO chado.dbxref VALUES (1257, 34, 'LA9658-1', '', NULL);
INSERT INTO chado.dbxref VALUES (1258, 24, '0000818', '', NULL);
INSERT INTO chado.dbxref VALUES (1259, 24, '0000819', '', NULL);
INSERT INTO chado.dbxref VALUES (1260, 24, '0000820', '', NULL);
INSERT INTO chado.dbxref VALUES (1261, 24, '0000821', '', NULL);
INSERT INTO chado.dbxref VALUES (1262, 24, '0000822', '', NULL);
INSERT INTO chado.dbxref VALUES (1263, 24, '0000823', '', NULL);
INSERT INTO chado.dbxref VALUES (1264, 24, '0000824', '', NULL);
INSERT INTO chado.dbxref VALUES (1265, 24, '0000825', '', NULL);
INSERT INTO chado.dbxref VALUES (1266, 24, '0000828', '', NULL);
INSERT INTO chado.dbxref VALUES (1267, 24, '0000829', '', NULL);
INSERT INTO chado.dbxref VALUES (1268, 24, '0000832', '', NULL);
INSERT INTO chado.dbxref VALUES (1269, 24, '0000834', '', NULL);
INSERT INTO chado.dbxref VALUES (1270, 35, '00124', '', NULL);
INSERT INTO chado.dbxref VALUES (1271, 35, '00331', '', NULL);
INSERT INTO chado.dbxref VALUES (1272, 24, '0000843', '', NULL);
INSERT INTO chado.dbxref VALUES (1273, 24, '0000844', '', NULL);
INSERT INTO chado.dbxref VALUES (1274, 24, '0000845', '', NULL);
INSERT INTO chado.dbxref VALUES (1275, 24, '0000846', '', NULL);
INSERT INTO chado.dbxref VALUES (1276, 24, '0000852', '', NULL);
INSERT INTO chado.dbxref VALUES (1277, 24, '0000853', '', NULL);
INSERT INTO chado.dbxref VALUES (1278, 24, '0000857', '', NULL);
INSERT INTO chado.dbxref VALUES (1279, 24, '0000854', '', NULL);
INSERT INTO chado.dbxref VALUES (1280, 24, '0000859', '', NULL);
INSERT INTO chado.dbxref VALUES (1281, 24, '0000855', '', NULL);
INSERT INTO chado.dbxref VALUES (1282, 24, '0000858', '', NULL);
INSERT INTO chado.dbxref VALUES (1283, 24, '0000856', '', NULL);
INSERT INTO chado.dbxref VALUES (1284, 24, '0000860', '', NULL);
INSERT INTO chado.dbxref VALUES (1285, 24, '0000861', '', NULL);
INSERT INTO chado.dbxref VALUES (1286, 24, '0000862', '', NULL);
INSERT INTO chado.dbxref VALUES (1287, 24, '0000872', '', NULL);
INSERT INTO chado.dbxref VALUES (1288, 24, '0000977', '', NULL);
INSERT INTO chado.dbxref VALUES (1289, 24, '0000874', '', NULL);
INSERT INTO chado.dbxref VALUES (1290, 24, '0000877', '', NULL);
INSERT INTO chado.dbxref VALUES (1291, 24, '0000882', '', NULL);
INSERT INTO chado.dbxref VALUES (1292, 24, '0000888', '', NULL);
INSERT INTO chado.dbxref VALUES (1293, 24, '0000889', '', NULL);
INSERT INTO chado.dbxref VALUES (1294, 24, '0000890', '', NULL);
INSERT INTO chado.dbxref VALUES (1295, 24, '0000891', '', NULL);
INSERT INTO chado.dbxref VALUES (1296, 24, '0000892', '', NULL);
INSERT INTO chado.dbxref VALUES (1297, 24, '0000896', '', NULL);
INSERT INTO chado.dbxref VALUES (1298, 24, '0000897', '', NULL);
INSERT INTO chado.dbxref VALUES (1299, 24, '0000899', '', NULL);
INSERT INTO chado.dbxref VALUES (1300, 24, '0000900', '', NULL);
INSERT INTO chado.dbxref VALUES (1301, 24, '0000901', '', NULL);
INSERT INTO chado.dbxref VALUES (1302, 24, '0000906', '', NULL);
INSERT INTO chado.dbxref VALUES (1303, 24, '0000907', '', NULL);
INSERT INTO chado.dbxref VALUES (1304, 24, '0000908', '', NULL);
INSERT INTO chado.dbxref VALUES (1305, 24, '0000909', '', NULL);
INSERT INTO chado.dbxref VALUES (1306, 24, '0000910', '', NULL);
INSERT INTO chado.dbxref VALUES (1307, 24, '0000911', '', NULL);
INSERT INTO chado.dbxref VALUES (1308, 24, '0000912', '', NULL);
INSERT INTO chado.dbxref VALUES (1309, 35, '00203', '', NULL);
INSERT INTO chado.dbxref VALUES (1310, 24, '0001128', '', NULL);
INSERT INTO chado.dbxref VALUES (1311, 24, '0000913', '', NULL);
INSERT INTO chado.dbxref VALUES (1312, 24, '0000914', '', NULL);
INSERT INTO chado.dbxref VALUES (1313, 24, '0000915', '', NULL);
INSERT INTO chado.dbxref VALUES (1314, 24, '0000916', '', NULL);
INSERT INTO chado.dbxref VALUES (1315, 24, '0000917', '', NULL);
INSERT INTO chado.dbxref VALUES (1316, 24, '0000918', '', NULL);
INSERT INTO chado.dbxref VALUES (1317, 24, '0000919', '', NULL);
INSERT INTO chado.dbxref VALUES (1318, 24, '0000920', '', NULL);
INSERT INTO chado.dbxref VALUES (1319, 24, '0000921', '', NULL);
INSERT INTO chado.dbxref VALUES (1320, 24, '0000922', '', NULL);
INSERT INTO chado.dbxref VALUES (1321, 24, '0000923', '', NULL);
INSERT INTO chado.dbxref VALUES (1322, 24, '0000924', '', NULL);
INSERT INTO chado.dbxref VALUES (1323, 24, '0000925', '', NULL);
INSERT INTO chado.dbxref VALUES (1324, 24, '0000926', '', NULL);
INSERT INTO chado.dbxref VALUES (1325, 24, '0000927', '', NULL);
INSERT INTO chado.dbxref VALUES (1326, 24, '0000928', '', NULL);
INSERT INTO chado.dbxref VALUES (1327, 24, '0000929', '', NULL);
INSERT INTO chado.dbxref VALUES (1328, 24, '0000930', '', NULL);
INSERT INTO chado.dbxref VALUES (1329, 24, '0000931', '', NULL);
INSERT INTO chado.dbxref VALUES (1330, 24, '0000932', '', NULL);
INSERT INTO chado.dbxref VALUES (1331, 24, '0000933', '', NULL);
INSERT INTO chado.dbxref VALUES (1332, 24, '0000934', '', NULL);
INSERT INTO chado.dbxref VALUES (1333, 24, '0001655', '', NULL);
INSERT INTO chado.dbxref VALUES (1334, 24, '0000935', '', NULL);
INSERT INTO chado.dbxref VALUES (1335, 24, '0000937', '', NULL);
INSERT INTO chado.dbxref VALUES (1336, 24, '0000941', '', NULL);
INSERT INTO chado.dbxref VALUES (1337, 24, '0000942', '', NULL);
INSERT INTO chado.dbxref VALUES (1338, 24, '0001042', '', NULL);
INSERT INTO chado.dbxref VALUES (1339, 24, '0000943', '', NULL);
INSERT INTO chado.dbxref VALUES (1340, 24, '0000944', '', NULL);
INSERT INTO chado.dbxref VALUES (1341, 24, '0000945', '', NULL);
INSERT INTO chado.dbxref VALUES (1342, 24, '0000949', '', NULL);
INSERT INTO chado.dbxref VALUES (1343, 24, '0000950', '', NULL);
INSERT INTO chado.dbxref VALUES (1344, 24, '0000952', '', NULL);
INSERT INTO chado.dbxref VALUES (1345, 24, '0000953', '', NULL);
INSERT INTO chado.dbxref VALUES (1346, 24, '0000954', '', NULL);
INSERT INTO chado.dbxref VALUES (1347, 24, '0000955', '', NULL);
INSERT INTO chado.dbxref VALUES (1348, 24, '0000985', '', NULL);
INSERT INTO chado.dbxref VALUES (1349, 24, '0000956', '', NULL);
INSERT INTO chado.dbxref VALUES (1350, 24, '0000984', '', NULL);
INSERT INTO chado.dbxref VALUES (1351, 24, '0000957', '', NULL);
INSERT INTO chado.dbxref VALUES (1352, 24, '0000987', '', NULL);
INSERT INTO chado.dbxref VALUES (1353, 24, '0000958', '', NULL);
INSERT INTO chado.dbxref VALUES (1354, 24, '0000988', '', NULL);
INSERT INTO chado.dbxref VALUES (1355, 24, '0000959', '', NULL);
INSERT INTO chado.dbxref VALUES (1356, 24, '0000960', '', NULL);
INSERT INTO chado.dbxref VALUES (1357, 24, '0000961', '', NULL);
INSERT INTO chado.dbxref VALUES (1358, 24, '0000962', '', NULL);
INSERT INTO chado.dbxref VALUES (1359, 24, '0000963', '', NULL);
INSERT INTO chado.dbxref VALUES (1360, 24, '0000964', '', NULL);
INSERT INTO chado.dbxref VALUES (1361, 24, '0000965', '', NULL);
INSERT INTO chado.dbxref VALUES (1362, 24, '0000966', '', NULL);
INSERT INTO chado.dbxref VALUES (1363, 24, '0000967', '', NULL);
INSERT INTO chado.dbxref VALUES (1364, 24, '0000968', '', NULL);
INSERT INTO chado.dbxref VALUES (1365, 24, '0000969', '', NULL);
INSERT INTO chado.dbxref VALUES (1366, 24, '0000970', '', NULL);
INSERT INTO chado.dbxref VALUES (1367, 24, '0000971', '', NULL);
INSERT INTO chado.dbxref VALUES (1368, 24, '0000972', '', NULL);
INSERT INTO chado.dbxref VALUES (1369, 24, '0000973', '', NULL);
INSERT INTO chado.dbxref VALUES (1370, 24, '0000975', '', NULL);
INSERT INTO chado.dbxref VALUES (1371, 24, '0000976', '', NULL);
INSERT INTO chado.dbxref VALUES (1372, 24, '0000978', '', NULL);
INSERT INTO chado.dbxref VALUES (1373, 24, '0000979', '', NULL);
INSERT INTO chado.dbxref VALUES (1374, 24, '0000974', '', NULL);
INSERT INTO chado.dbxref VALUES (1375, 24, '0000981', '', NULL);
INSERT INTO chado.dbxref VALUES (1376, 24, '0000982', '', NULL);
INSERT INTO chado.dbxref VALUES (1377, 24, '0000983', '', NULL);
INSERT INTO chado.dbxref VALUES (1378, 24, '0000986', '', NULL);
INSERT INTO chado.dbxref VALUES (1379, 24, '0000989', '', NULL);
INSERT INTO chado.dbxref VALUES (1380, 24, '0000990', '', NULL);
INSERT INTO chado.dbxref VALUES (1381, 24, '0000992', '', NULL);
INSERT INTO chado.dbxref VALUES (1382, 24, '0000993', '', NULL);
INSERT INTO chado.dbxref VALUES (1383, 24, '0000994', '', NULL);
INSERT INTO chado.dbxref VALUES (1384, 24, '0000995', '', NULL);
INSERT INTO chado.dbxref VALUES (1385, 24, '0000996', '', NULL);
INSERT INTO chado.dbxref VALUES (1386, 24, '0000997', '', NULL);
INSERT INTO chado.dbxref VALUES (1387, 24, '0000998', '', NULL);
INSERT INTO chado.dbxref VALUES (1388, 24, '0000999', '', NULL);
INSERT INTO chado.dbxref VALUES (1389, 24, '0001000', '', NULL);
INSERT INTO chado.dbxref VALUES (1390, 24, '0002237', '', NULL);
INSERT INTO chado.dbxref VALUES (1391, 24, '0001001', '', NULL);
INSERT INTO chado.dbxref VALUES (1392, 24, '0002243', '', NULL);
INSERT INTO chado.dbxref VALUES (1393, 24, '0001002', '', NULL);
INSERT INTO chado.dbxref VALUES (1394, 24, '0002242', '', NULL);
INSERT INTO chado.dbxref VALUES (1395, 24, '0001003', '', NULL);
INSERT INTO chado.dbxref VALUES (1396, 24, '0001004', '', NULL);
INSERT INTO chado.dbxref VALUES (1397, 24, '0001005', '', NULL);
INSERT INTO chado.dbxref VALUES (1398, 24, '0001006', '', NULL);
INSERT INTO chado.dbxref VALUES (1399, 24, '0001007', '', NULL);
INSERT INTO chado.dbxref VALUES (1400, 24, '0001008', '', NULL);
INSERT INTO chado.dbxref VALUES (1401, 24, '0001009', '', NULL);
INSERT INTO chado.dbxref VALUES (1402, 24, '0001010', '', NULL);
INSERT INTO chado.dbxref VALUES (1403, 24, '0001011', '', NULL);
INSERT INTO chado.dbxref VALUES (1404, 24, '0001184', '', NULL);
INSERT INTO chado.dbxref VALUES (1405, 24, '0001012', '', NULL);
INSERT INTO chado.dbxref VALUES (1406, 24, '0001013', '', NULL);
INSERT INTO chado.dbxref VALUES (1407, 24, '0002007', '', NULL);
INSERT INTO chado.dbxref VALUES (1408, 24, '0001014', '', NULL);
INSERT INTO chado.dbxref VALUES (1409, 24, '0001015', '', NULL);
INSERT INTO chado.dbxref VALUES (1410, 24, '0001016', '', NULL);
INSERT INTO chado.dbxref VALUES (1411, 24, '0001017', '', NULL);
INSERT INTO chado.dbxref VALUES (1412, 34, 'LA6700-4', '', NULL);
INSERT INTO chado.dbxref VALUES (1413, 24, '0001878', '', NULL);
INSERT INTO chado.dbxref VALUES (1414, 24, '0001018', '', NULL);
INSERT INTO chado.dbxref VALUES (1415, 24, '0001019', '', NULL);
INSERT INTO chado.dbxref VALUES (1416, 24, '0001020', '', NULL);
INSERT INTO chado.dbxref VALUES (1417, 24, '0001021', '', NULL);
INSERT INTO chado.dbxref VALUES (1418, 24, '0001242', '', NULL);
INSERT INTO chado.dbxref VALUES (1419, 24, '0001022', '', NULL);
INSERT INTO chado.dbxref VALUES (1420, 24, '0001023', '', NULL);
INSERT INTO chado.dbxref VALUES (1421, 24, '0001024', '', NULL);
INSERT INTO chado.dbxref VALUES (1422, 24, '0001025', '', NULL);
INSERT INTO chado.dbxref VALUES (1423, 24, '0001260', '', NULL);
INSERT INTO chado.dbxref VALUES (1424, 24, '0001027', '', NULL);
INSERT INTO chado.dbxref VALUES (1425, 24, '0001028', '', NULL);
INSERT INTO chado.dbxref VALUES (1426, 24, '0001029', '', NULL);
INSERT INTO chado.dbxref VALUES (1427, 24, '0001032', '', NULL);
INSERT INTO chado.dbxref VALUES (1428, 24, '0001033', '', NULL);
INSERT INTO chado.dbxref VALUES (1429, 24, '0001034', '', NULL);
INSERT INTO chado.dbxref VALUES (1430, 24, '0001036', '', NULL);
INSERT INTO chado.dbxref VALUES (1431, 24, '0001040', '', NULL);
INSERT INTO chado.dbxref VALUES (1432, 24, '0001041', '', NULL);
INSERT INTO chado.dbxref VALUES (1433, 24, '0001043', '', NULL);
INSERT INTO chado.dbxref VALUES (1434, 24, '0001044', '', NULL);
INSERT INTO chado.dbxref VALUES (1435, 24, '0001045', '', NULL);
INSERT INTO chado.dbxref VALUES (1436, 24, '0001046', '', NULL);
INSERT INTO chado.dbxref VALUES (1437, 24, '0001048', '', NULL);
INSERT INTO chado.dbxref VALUES (1438, 24, '0001047', '', NULL);
INSERT INTO chado.dbxref VALUES (1439, 24, '0001049', '', NULL);
INSERT INTO chado.dbxref VALUES (1440, 24, '0001050', '', NULL);
INSERT INTO chado.dbxref VALUES (1441, 24, '0001649', '', NULL);
INSERT INTO chado.dbxref VALUES (1442, 24, '0001051', '', NULL);
INSERT INTO chado.dbxref VALUES (1443, 24, '0001052', '', NULL);
INSERT INTO chado.dbxref VALUES (1444, 24, '0001053', '', NULL);
INSERT INTO chado.dbxref VALUES (1445, 24, '0001054', '', NULL);
INSERT INTO chado.dbxref VALUES (1446, 24, '0001648', '', NULL);
INSERT INTO chado.dbxref VALUES (1447, 24, '0005836', '', NULL);
INSERT INTO chado.dbxref VALUES (1448, 24, '0001057', '', NULL);
INSERT INTO chado.dbxref VALUES (1449, 24, '0001058', '', NULL);
INSERT INTO chado.dbxref VALUES (1450, 24, '1000004', '', NULL);
INSERT INTO chado.dbxref VALUES (1451, 24, '1000007', '', NULL);
INSERT INTO chado.dbxref VALUES (1452, 24, '0002072', '', NULL);
INSERT INTO chado.dbxref VALUES (1453, 24, '0001061', '', NULL);
INSERT INTO chado.dbxref VALUES (1454, 35, '00063', '', NULL);
INSERT INTO chado.dbxref VALUES (1455, 35, '00077', '', NULL);
INSERT INTO chado.dbxref VALUES (1456, 24, '0002250', '', NULL);
INSERT INTO chado.dbxref VALUES (1457, 35, '00129', '', NULL);
INSERT INTO chado.dbxref VALUES (1458, 24, '0001064', '', NULL);
INSERT INTO chado.dbxref VALUES (1459, 35, '00076', '', NULL);
INSERT INTO chado.dbxref VALUES (1460, 24, '0001066', '', NULL);
INSERT INTO chado.dbxref VALUES (1461, 35, '00068', '', NULL);
INSERT INTO chado.dbxref VALUES (1462, 24, '0001067', '', NULL);
INSERT INTO chado.dbxref VALUES (1463, 35, '00032', '', NULL);
INSERT INTO chado.dbxref VALUES (1464, 24, '0001068', '', NULL);
INSERT INTO chado.dbxref VALUES (1465, 35, '00070', '', NULL);
INSERT INTO chado.dbxref VALUES (1466, 35, '00337', '', NULL);
INSERT INTO chado.dbxref VALUES (1467, 24, '0001071', '', NULL);
INSERT INTO chado.dbxref VALUES (1468, 35, '00128', '', NULL);
INSERT INTO chado.dbxref VALUES (1469, 24, '0001072', '', NULL);
INSERT INTO chado.dbxref VALUES (1470, 35, '00154', '', NULL);
INSERT INTO chado.dbxref VALUES (1471, 24, '0001073', '', NULL);
INSERT INTO chado.dbxref VALUES (1472, 35, '00145', '', NULL);
INSERT INTO chado.dbxref VALUES (1473, 24, '0001074', '', NULL);
INSERT INTO chado.dbxref VALUES (1474, 35, '00144', '', NULL);
INSERT INTO chado.dbxref VALUES (1475, 24, '0001075', '', NULL);
INSERT INTO chado.dbxref VALUES (1476, 35, '00156', '', NULL);
INSERT INTO chado.dbxref VALUES (1477, 24, '0001076', '', NULL);
INSERT INTO chado.dbxref VALUES (1478, 35, '00155', '', NULL);
INSERT INTO chado.dbxref VALUES (1479, 24, '0001077', '', NULL);
INSERT INTO chado.dbxref VALUES (1480, 35, '00158', '', NULL);
INSERT INTO chado.dbxref VALUES (1481, 24, '0001078', '', NULL);
INSERT INTO chado.dbxref VALUES (1482, 35, '00003', '', NULL);
INSERT INTO chado.dbxref VALUES (1483, 24, '0001079', '', NULL);
INSERT INTO chado.dbxref VALUES (1484, 35, '0000338', '', NULL);
INSERT INTO chado.dbxref VALUES (1485, 24, '0001080', '', NULL);
INSERT INTO chado.dbxref VALUES (1486, 35, '00041', '', NULL);
INSERT INTO chado.dbxref VALUES (1487, 24, '0001081', '', NULL);
INSERT INTO chado.dbxref VALUES (1488, 35, '00147', '', NULL);
INSERT INTO chado.dbxref VALUES (1489, 24, '0001114', '', NULL);
INSERT INTO chado.dbxref VALUES (1490, 24, '0001082', '', NULL);
INSERT INTO chado.dbxref VALUES (1491, 35, '00125', '', NULL);
INSERT INTO chado.dbxref VALUES (1492, 24, '0001083', '', NULL);
INSERT INTO chado.dbxref VALUES (1493, 35, '00182', '', NULL);
INSERT INTO chado.dbxref VALUES (1494, 24, '0001084', '', NULL);
INSERT INTO chado.dbxref VALUES (1495, 35, '00072', '', NULL);
INSERT INTO chado.dbxref VALUES (1496, 24, '0001085', '', NULL);
INSERT INTO chado.dbxref VALUES (1497, 35, '00069', '', NULL);
INSERT INTO chado.dbxref VALUES (1498, 24, '0001086', '', NULL);
INSERT INTO chado.dbxref VALUES (1499, 35, '00181', '', NULL);
INSERT INTO chado.dbxref VALUES (1500, 24, '0001087', '', NULL);
INSERT INTO chado.dbxref VALUES (1501, 35, '00178', '', NULL);
INSERT INTO chado.dbxref VALUES (1502, 24, '0001088', '', NULL);
INSERT INTO chado.dbxref VALUES (1503, 35, '00028', '', NULL);
INSERT INTO chado.dbxref VALUES (1504, 24, '0001089', '', NULL);
INSERT INTO chado.dbxref VALUES (1505, 35, '00052', '', NULL);
INSERT INTO chado.dbxref VALUES (1506, 24, '0100001', '', NULL);
INSERT INTO chado.dbxref VALUES (1507, 24, '0001090', '', NULL);
INSERT INTO chado.dbxref VALUES (1508, 35, '00246', '', NULL);
INSERT INTO chado.dbxref VALUES (1509, 24, '0001091', '', NULL);
INSERT INTO chado.dbxref VALUES (1510, 35, '00029', '', NULL);
INSERT INTO chado.dbxref VALUES (1511, 24, '0001092', '', NULL);
INSERT INTO chado.dbxref VALUES (1512, 35, '00027', '', NULL);
INSERT INTO chado.dbxref VALUES (1513, 24, '0001656', '', NULL);
INSERT INTO chado.dbxref VALUES (1514, 24, '0100002', '', NULL);
INSERT INTO chado.dbxref VALUES (1515, 24, '0001093', '', NULL);
INSERT INTO chado.dbxref VALUES (1516, 35, '00131', '', NULL);
INSERT INTO chado.dbxref VALUES (1517, 24, '0001094', '', NULL);
INSERT INTO chado.dbxref VALUES (1518, 35, '00186', '', NULL);
INSERT INTO chado.dbxref VALUES (1519, 24, '0001095', '', NULL);
INSERT INTO chado.dbxref VALUES (1520, 35, '00136', '', NULL);
INSERT INTO chado.dbxref VALUES (1521, 24, '0001096', '', NULL);
INSERT INTO chado.dbxref VALUES (1522, 35, '00146', '', NULL);
INSERT INTO chado.dbxref VALUES (1523, 24, '0001097', '', NULL);
INSERT INTO chado.dbxref VALUES (1524, 35, '00137', '', NULL);
INSERT INTO chado.dbxref VALUES (1525, 24, '0001098', '', NULL);
INSERT INTO chado.dbxref VALUES (1526, 35, '00187', '', NULL);
INSERT INTO chado.dbxref VALUES (1527, 24, '0001099', '', NULL);
INSERT INTO chado.dbxref VALUES (1528, 35, '00140', '', NULL);
INSERT INTO chado.dbxref VALUES (1529, 24, '0001100', '', NULL);
INSERT INTO chado.dbxref VALUES (1530, 35, '00141', '', NULL);
INSERT INTO chado.dbxref VALUES (1531, 24, '0001101', '', NULL);
INSERT INTO chado.dbxref VALUES (1532, 35, '00142', '', NULL);
INSERT INTO chado.dbxref VALUES (1533, 24, '0001102', '', NULL);
INSERT INTO chado.dbxref VALUES (1534, 35, '00143', '', NULL);
INSERT INTO chado.dbxref VALUES (1535, 24, '0001103', '', NULL);
INSERT INTO chado.dbxref VALUES (1536, 35, '00185', '', NULL);
INSERT INTO chado.dbxref VALUES (1537, 24, '0001104', '', NULL);
INSERT INTO chado.dbxref VALUES (1538, 35, '00026', '', NULL);
INSERT INTO chado.dbxref VALUES (1539, 24, '0001237', '', NULL);
INSERT INTO chado.dbxref VALUES (1540, 24, '0100019', '', NULL);
INSERT INTO chado.dbxref VALUES (1541, 24, '0001105', '', NULL);
INSERT INTO chado.dbxref VALUES (1542, 35, '00157', '', NULL);
INSERT INTO chado.dbxref VALUES (1543, 24, '0001657', '', NULL);
INSERT INTO chado.dbxref VALUES (1544, 24, '0001106', '', NULL);
INSERT INTO chado.dbxref VALUES (1545, 35, '00202', '', NULL);
INSERT INTO chado.dbxref VALUES (1546, 24, '0001107', '', NULL);
INSERT INTO chado.dbxref VALUES (1547, 35, '00208', '', NULL);
INSERT INTO chado.dbxref VALUES (1548, 24, '0001108', '', NULL);
INSERT INTO chado.dbxref VALUES (1549, 35, '00209', '', NULL);
INSERT INTO chado.dbxref VALUES (1550, 24, '0001109', '', NULL);
INSERT INTO chado.dbxref VALUES (1551, 35, '00210', '', NULL);
INSERT INTO chado.dbxref VALUES (1552, 24, '0001110', '', NULL);
INSERT INTO chado.dbxref VALUES (1553, 35, '00211', '', NULL);
INSERT INTO chado.dbxref VALUES (1554, 24, '0001111', '', NULL);
INSERT INTO chado.dbxref VALUES (1555, 35, '00042', '', NULL);
INSERT INTO chado.dbxref VALUES (1556, 24, '0001112', '', NULL);
INSERT INTO chado.dbxref VALUES (1557, 35, '0000341', '', NULL);
INSERT INTO chado.dbxref VALUES (1558, 24, '0001113', '', NULL);
INSERT INTO chado.dbxref VALUES (1559, 35, '00151', '', NULL);
INSERT INTO chado.dbxref VALUES (1560, 35, '00152', '', NULL);
INSERT INTO chado.dbxref VALUES (1561, 24, '0001115', '', NULL);
INSERT INTO chado.dbxref VALUES (1562, 35, '00222', '', NULL);
INSERT INTO chado.dbxref VALUES (1563, 24, '0001116', '', NULL);
INSERT INTO chado.dbxref VALUES (1564, 35, '0000339', '', NULL);
INSERT INTO chado.dbxref VALUES (1565, 24, '0001117', '', NULL);
INSERT INTO chado.dbxref VALUES (1566, 35, '00040', '', NULL);
INSERT INTO chado.dbxref VALUES (1567, 24, '0001118', '', NULL);
INSERT INTO chado.dbxref VALUES (1568, 35, '00153', '', NULL);
INSERT INTO chado.dbxref VALUES (1569, 24, '0001119', '', NULL);
INSERT INTO chado.dbxref VALUES (1570, 35, '0000340', '', NULL);
INSERT INTO chado.dbxref VALUES (1571, 24, '0001120', '', NULL);
INSERT INTO chado.dbxref VALUES (1572, 35, '00223', '', NULL);
INSERT INTO chado.dbxref VALUES (1573, 24, '0001121', '', NULL);
INSERT INTO chado.dbxref VALUES (1574, 35, '00224', '', NULL);
INSERT INTO chado.dbxref VALUES (1575, 24, '0001122', '', NULL);
INSERT INTO chado.dbxref VALUES (1576, 35, '00225', '', NULL);
INSERT INTO chado.dbxref VALUES (1577, 24, '0001123', '', NULL);
INSERT INTO chado.dbxref VALUES (1578, 35, '00226', '', NULL);
INSERT INTO chado.dbxref VALUES (1579, 24, '0001124', '', NULL);
INSERT INTO chado.dbxref VALUES (1580, 35, '00228', '', NULL);
INSERT INTO chado.dbxref VALUES (1581, 24, '0001125', '', NULL);
INSERT INTO chado.dbxref VALUES (1582, 35, '00227', '', NULL);
INSERT INTO chado.dbxref VALUES (1583, 24, '0001126', '', NULL);
INSERT INTO chado.dbxref VALUES (1584, 35, '00229', '', NULL);
INSERT INTO chado.dbxref VALUES (1585, 24, '0001127', '', NULL);
INSERT INTO chado.dbxref VALUES (1586, 35, '00230', '', NULL);
INSERT INTO chado.dbxref VALUES (1587, 35, '00148', '', NULL);
INSERT INTO chado.dbxref VALUES (1588, 24, '0001129', '', NULL);
INSERT INTO chado.dbxref VALUES (1589, 35, '00206', '', NULL);
INSERT INTO chado.dbxref VALUES (1590, 24, '0001130', '', NULL);
INSERT INTO chado.dbxref VALUES (1591, 35, '00204', '', NULL);
INSERT INTO chado.dbxref VALUES (1592, 24, '0001131', '', NULL);
INSERT INTO chado.dbxref VALUES (1593, 35, '00205', '', NULL);
INSERT INTO chado.dbxref VALUES (1594, 24, '0001132', '', NULL);
INSERT INTO chado.dbxref VALUES (1595, 35, '00207', '', NULL);
INSERT INTO chado.dbxref VALUES (1596, 24, '0001133', '', NULL);
INSERT INTO chado.dbxref VALUES (1597, 35, '00212', '', NULL);
INSERT INTO chado.dbxref VALUES (1598, 24, '0001134', '', NULL);
INSERT INTO chado.dbxref VALUES (1599, 35, '00215', '', NULL);
INSERT INTO chado.dbxref VALUES (1600, 24, '0001135', '', NULL);
INSERT INTO chado.dbxref VALUES (1601, 35, '00213', '', NULL);
INSERT INTO chado.dbxref VALUES (1602, 24, '0001136', '', NULL);
INSERT INTO chado.dbxref VALUES (1603, 35, '00216', '', NULL);
INSERT INTO chado.dbxref VALUES (1604, 24, '0001137', '', NULL);
INSERT INTO chado.dbxref VALUES (1605, 35, '00214', '', NULL);
INSERT INTO chado.dbxref VALUES (1606, 24, '0001138', '', NULL);
INSERT INTO chado.dbxref VALUES (1607, 35, '00219', '', NULL);
INSERT INTO chado.dbxref VALUES (1608, 24, '0001139', '', NULL);
INSERT INTO chado.dbxref VALUES (1609, 35, '00220', '', NULL);
INSERT INTO chado.dbxref VALUES (1610, 24, '0001140', '', NULL);
INSERT INTO chado.dbxref VALUES (1611, 35, '00221', '', NULL);
INSERT INTO chado.dbxref VALUES (1612, 24, '0001141', '', NULL);
INSERT INTO chado.dbxref VALUES (1613, 35, '00231', '', NULL);
INSERT INTO chado.dbxref VALUES (1614, 24, '0001142', '', NULL);
INSERT INTO chado.dbxref VALUES (1615, 35, '00234', '', NULL);
INSERT INTO chado.dbxref VALUES (1616, 24, '0001143', '', NULL);
INSERT INTO chado.dbxref VALUES (1617, 35, '00232', '', NULL);
INSERT INTO chado.dbxref VALUES (1618, 24, '0001144', '', NULL);
INSERT INTO chado.dbxref VALUES (1619, 35, '00235', '', NULL);
INSERT INTO chado.dbxref VALUES (1620, 24, '0001145', '', NULL);
INSERT INTO chado.dbxref VALUES (1621, 35, '00233', '', NULL);
INSERT INTO chado.dbxref VALUES (1622, 24, '0001146', '', NULL);
INSERT INTO chado.dbxref VALUES (1623, 35, '00336', '', NULL);
INSERT INTO chado.dbxref VALUES (1624, 24, '0001147', '', NULL);
INSERT INTO chado.dbxref VALUES (1625, 35, '00071', '', NULL);
INSERT INTO chado.dbxref VALUES (1626, 24, '0001148', '', NULL);
INSERT INTO chado.dbxref VALUES (1627, 35, '00036', '', NULL);
INSERT INTO chado.dbxref VALUES (1628, 24, '0001149', '', NULL);
INSERT INTO chado.dbxref VALUES (1629, 35, '00073', '', NULL);
INSERT INTO chado.dbxref VALUES (1630, 24, '0001065', '', NULL);
INSERT INTO chado.dbxref VALUES (1631, 24, '0001150', '', NULL);
INSERT INTO chado.dbxref VALUES (1632, 24, '0001151', '', NULL);
INSERT INTO chado.dbxref VALUES (1633, 24, '0001152', '', NULL);
INSERT INTO chado.dbxref VALUES (1634, 24, '0001153', '', NULL);
INSERT INTO chado.dbxref VALUES (1635, 24, '0001154', '', NULL);
INSERT INTO chado.dbxref VALUES (1636, 24, '0001155', '', NULL);
INSERT INTO chado.dbxref VALUES (1637, 24, '0001156', '', NULL);
INSERT INTO chado.dbxref VALUES (1638, 24, '0001157', '', NULL);
INSERT INTO chado.dbxref VALUES (1639, 24, '0001158', '', NULL);
INSERT INTO chado.dbxref VALUES (1640, 24, '0001159', '', NULL);
INSERT INTO chado.dbxref VALUES (1641, 24, '0001160', '', NULL);
INSERT INTO chado.dbxref VALUES (1642, 24, '0001161', '', NULL);
INSERT INTO chado.dbxref VALUES (1643, 24, '0001162', '', NULL);
INSERT INTO chado.dbxref VALUES (1644, 24, '0001163', '', NULL);
INSERT INTO chado.dbxref VALUES (1645, 24, '0001164', '', NULL);
INSERT INTO chado.dbxref VALUES (1646, 24, '0001165', '', NULL);
INSERT INTO chado.dbxref VALUES (1647, 24, '0001166', '', NULL);
INSERT INTO chado.dbxref VALUES (1648, 24, '0001167', '', NULL);
INSERT INTO chado.dbxref VALUES (1649, 24, '0001168', '', NULL);
INSERT INTO chado.dbxref VALUES (1650, 24, '0001169', '', NULL);
INSERT INTO chado.dbxref VALUES (1651, 24, '0001170', '', NULL);
INSERT INTO chado.dbxref VALUES (1652, 24, '0001171', '', NULL);
INSERT INTO chado.dbxref VALUES (1653, 24, '0001172', '', NULL);
INSERT INTO chado.dbxref VALUES (1654, 24, '0001173', '', NULL);
INSERT INTO chado.dbxref VALUES (1655, 24, '0001174', '', NULL);
INSERT INTO chado.dbxref VALUES (1656, 24, '0001175', '', NULL);
INSERT INTO chado.dbxref VALUES (1657, 24, '0001176', '', NULL);
INSERT INTO chado.dbxref VALUES (1658, 24, '0001177', '', NULL);
INSERT INTO chado.dbxref VALUES (1659, 24, '0001179', '', NULL);
INSERT INTO chado.dbxref VALUES (1660, 24, '0001180', '', NULL);
INSERT INTO chado.dbxref VALUES (1661, 24, '0001181', '', NULL);
INSERT INTO chado.dbxref VALUES (1662, 24, '0001182', '', NULL);
INSERT INTO chado.dbxref VALUES (1663, 24, '0001187', '', NULL);
INSERT INTO chado.dbxref VALUES (1664, 24, '0001188', '', NULL);
INSERT INTO chado.dbxref VALUES (1665, 24, '0001189', '', NULL);
INSERT INTO chado.dbxref VALUES (1666, 24, '0001190', '', NULL);
INSERT INTO chado.dbxref VALUES (1667, 24, '0001191', '', NULL);
INSERT INTO chado.dbxref VALUES (1668, 24, '0001192', '', NULL);
INSERT INTO chado.dbxref VALUES (1669, 24, '0001193', '', NULL);
INSERT INTO chado.dbxref VALUES (1670, 24, '0001194', '', NULL);
INSERT INTO chado.dbxref VALUES (1671, 24, '0001195', '', NULL);
INSERT INTO chado.dbxref VALUES (1672, 24, '0001196', '', NULL);
INSERT INTO chado.dbxref VALUES (1673, 24, '0001197', '', NULL);
INSERT INTO chado.dbxref VALUES (1674, 24, '0001198', '', NULL);
INSERT INTO chado.dbxref VALUES (1675, 24, '0001199', '', NULL);
INSERT INTO chado.dbxref VALUES (1676, 24, '0001200', '', NULL);
INSERT INTO chado.dbxref VALUES (1677, 24, '0001201', '', NULL);
INSERT INTO chado.dbxref VALUES (1678, 24, '0001202', '', NULL);
INSERT INTO chado.dbxref VALUES (1679, 24, '0001203', '', NULL);
INSERT INTO chado.dbxref VALUES (1680, 24, '0001204', '', NULL);
INSERT INTO chado.dbxref VALUES (1681, 24, '0002311', '', NULL);
INSERT INTO chado.dbxref VALUES (1682, 24, '0001205', '', NULL);
INSERT INTO chado.dbxref VALUES (1683, 24, '0001206', '', NULL);
INSERT INTO chado.dbxref VALUES (1684, 24, '0001207', '', NULL);
INSERT INTO chado.dbxref VALUES (1685, 24, '0001208', '', NULL);
INSERT INTO chado.dbxref VALUES (1686, 24, '0001209', '', NULL);
INSERT INTO chado.dbxref VALUES (1687, 24, '0001210', '', NULL);
INSERT INTO chado.dbxref VALUES (1688, 24, '0001211', '', NULL);
INSERT INTO chado.dbxref VALUES (1689, 24, '0001212', '', NULL);
INSERT INTO chado.dbxref VALUES (1690, 24, '0001213', '', NULL);
INSERT INTO chado.dbxref VALUES (1691, 24, '0001216', '', NULL);
INSERT INTO chado.dbxref VALUES (1692, 24, '0001218', '', NULL);
INSERT INTO chado.dbxref VALUES (1693, 24, '0001219', '', NULL);
INSERT INTO chado.dbxref VALUES (1694, 24, '0001220', '', NULL);
INSERT INTO chado.dbxref VALUES (1695, 24, '0001221', '', NULL);
INSERT INTO chado.dbxref VALUES (1696, 24, '0001222', '', NULL);
INSERT INTO chado.dbxref VALUES (1697, 24, '0001223', '', NULL);
INSERT INTO chado.dbxref VALUES (1698, 24, '0001224', '', NULL);
INSERT INTO chado.dbxref VALUES (1699, 24, '0001225', '', NULL);
INSERT INTO chado.dbxref VALUES (1700, 24, '0001226', '', NULL);
INSERT INTO chado.dbxref VALUES (1701, 24, '0001227', '', NULL);
INSERT INTO chado.dbxref VALUES (1702, 24, '0001228', '', NULL);
INSERT INTO chado.dbxref VALUES (1703, 36, '051', '', NULL);
INSERT INTO chado.dbxref VALUES (1704, 24, '0001277', '', NULL);
INSERT INTO chado.dbxref VALUES (1705, 24, '0001229', '', NULL);
INSERT INTO chado.dbxref VALUES (1706, 36, '050', '', NULL);
INSERT INTO chado.dbxref VALUES (1707, 24, '0001230', '', NULL);
INSERT INTO chado.dbxref VALUES (1708, 24, '0001231', '', NULL);
INSERT INTO chado.dbxref VALUES (1709, 24, '0001232', '', NULL);
INSERT INTO chado.dbxref VALUES (1710, 24, '0001233', '', NULL);
INSERT INTO chado.dbxref VALUES (1711, 24, '0001274', '', NULL);
INSERT INTO chado.dbxref VALUES (1712, 24, '0001238', '', NULL);
INSERT INTO chado.dbxref VALUES (1713, 24, '0001239', '', NULL);
INSERT INTO chado.dbxref VALUES (1714, 24, '0001240', '', NULL);
INSERT INTO chado.dbxref VALUES (1715, 24, '0001241', '', NULL);
INSERT INTO chado.dbxref VALUES (1716, 24, '0001243', '', NULL);
INSERT INTO chado.dbxref VALUES (1717, 24, '0001245', '', NULL);
INSERT INTO chado.dbxref VALUES (1718, 24, '0001246', '', NULL);
INSERT INTO chado.dbxref VALUES (1719, 24, '0001249', '', NULL);
INSERT INTO chado.dbxref VALUES (1720, 24, '0001250', '', NULL);
INSERT INTO chado.dbxref VALUES (1721, 24, '0001251', '', NULL);
INSERT INTO chado.dbxref VALUES (1722, 24, '0001252', '', NULL);
INSERT INTO chado.dbxref VALUES (1723, 24, '0001253', '', NULL);
INSERT INTO chado.dbxref VALUES (1724, 24, '0001254', '', NULL);
INSERT INTO chado.dbxref VALUES (1725, 24, '0001255', '', NULL);
INSERT INTO chado.dbxref VALUES (1726, 24, '0001256', '', NULL);
INSERT INTO chado.dbxref VALUES (1727, 24, '0001257', '', NULL);
INSERT INTO chado.dbxref VALUES (1728, 24, '0001258', '', NULL);
INSERT INTO chado.dbxref VALUES (1729, 24, '0001259', '', NULL);
INSERT INTO chado.dbxref VALUES (1730, 24, '0001261', '', NULL);
INSERT INTO chado.dbxref VALUES (1731, 24, '0001262', '', NULL);
INSERT INTO chado.dbxref VALUES (1732, 24, '0001263', '', NULL);
INSERT INTO chado.dbxref VALUES (1733, 24, '0001264', '', NULL);
INSERT INTO chado.dbxref VALUES (1734, 24, '0001265', '', NULL);
INSERT INTO chado.dbxref VALUES (1735, 24, '0001270', '', NULL);
INSERT INTO chado.dbxref VALUES (1736, 24, '0002342', '', NULL);
INSERT INTO chado.dbxref VALUES (1737, 24, '0001266', '', NULL);
INSERT INTO chado.dbxref VALUES (1738, 24, '0001267', '', NULL);
INSERT INTO chado.dbxref VALUES (1739, 24, '0001268', '', NULL);
INSERT INTO chado.dbxref VALUES (1740, 24, '0001269', '', NULL);
INSERT INTO chado.dbxref VALUES (1741, 24, '0001271', '', NULL);
INSERT INTO chado.dbxref VALUES (1742, 24, '0001272', '', NULL);
INSERT INTO chado.dbxref VALUES (1743, 24, '0001273', '', NULL);
INSERT INTO chado.dbxref VALUES (1744, 24, '0001275', '', NULL);
INSERT INTO chado.dbxref VALUES (1745, 24, '0001276', '', NULL);
INSERT INTO chado.dbxref VALUES (1746, 24, '0001278', '', NULL);
INSERT INTO chado.dbxref VALUES (1747, 36, '018', '', NULL);
INSERT INTO chado.dbxref VALUES (1748, 24, '0001279', '', NULL);
INSERT INTO chado.dbxref VALUES (1749, 36, '019', '', NULL);
INSERT INTO chado.dbxref VALUES (1750, 24, '0001280', '', NULL);
INSERT INTO chado.dbxref VALUES (1751, 36, '081', '', NULL);
INSERT INTO chado.dbxref VALUES (1752, 24, '0001281', '', NULL);
INSERT INTO chado.dbxref VALUES (1753, 36, '020', '', NULL);
INSERT INTO chado.dbxref VALUES (1754, 24, '0001282', '', NULL);
INSERT INTO chado.dbxref VALUES (1755, 36, '021', '', NULL);
INSERT INTO chado.dbxref VALUES (1756, 24, '0001283', '', NULL);
INSERT INTO chado.dbxref VALUES (1757, 36, '022', '', NULL);
INSERT INTO chado.dbxref VALUES (1758, 24, '0001284', '', NULL);
INSERT INTO chado.dbxref VALUES (1759, 36, '023', '', NULL);
INSERT INTO chado.dbxref VALUES (1760, 24, '0001285', '', NULL);
INSERT INTO chado.dbxref VALUES (1761, 36, '024', '', NULL);
INSERT INTO chado.dbxref VALUES (1762, 24, '0001286', '', NULL);
INSERT INTO chado.dbxref VALUES (1763, 36, '025', '', NULL);
INSERT INTO chado.dbxref VALUES (1764, 24, '0001287', '', NULL);
INSERT INTO chado.dbxref VALUES (1765, 36, '026', '', NULL);
INSERT INTO chado.dbxref VALUES (1766, 24, '0001288', '', NULL);
INSERT INTO chado.dbxref VALUES (1767, 36, '027', '', NULL);
INSERT INTO chado.dbxref VALUES (1768, 24, '0001289', '', NULL);
INSERT INTO chado.dbxref VALUES (1769, 36, '028', '', NULL);
INSERT INTO chado.dbxref VALUES (1770, 24, '0001290', '', NULL);
INSERT INTO chado.dbxref VALUES (1771, 36, '082', '', NULL);
INSERT INTO chado.dbxref VALUES (1772, 24, '0001291', '', NULL);
INSERT INTO chado.dbxref VALUES (1773, 36, '083', '', NULL);
INSERT INTO chado.dbxref VALUES (1774, 24, '0001292', '', NULL);
INSERT INTO chado.dbxref VALUES (1775, 36, '084', '', NULL);
INSERT INTO chado.dbxref VALUES (1776, 24, '0001293', '', NULL);
INSERT INTO chado.dbxref VALUES (1777, 36, '095', '', NULL);
INSERT INTO chado.dbxref VALUES (1778, 24, '0001294', '', NULL);
INSERT INTO chado.dbxref VALUES (1779, 36, '107', '', NULL);
INSERT INTO chado.dbxref VALUES (1780, 24, '0001295', '', NULL);
INSERT INTO chado.dbxref VALUES (1781, 36, '001', '', NULL);
INSERT INTO chado.dbxref VALUES (1782, 24, '0001296', '', NULL);
INSERT INTO chado.dbxref VALUES (1783, 36, '002', '', NULL);
INSERT INTO chado.dbxref VALUES (1784, 24, '0001297', '', NULL);
INSERT INTO chado.dbxref VALUES (1785, 36, '003', '', NULL);
INSERT INTO chado.dbxref VALUES (1786, 24, '0001298', '', NULL);
INSERT INTO chado.dbxref VALUES (1787, 36, '004', '', NULL);
INSERT INTO chado.dbxref VALUES (1788, 24, '0001299', '', NULL);
INSERT INTO chado.dbxref VALUES (1789, 36, '005', '', NULL);
INSERT INTO chado.dbxref VALUES (1790, 24, '0001300', '', NULL);
INSERT INTO chado.dbxref VALUES (1791, 36, '006', '', NULL);
INSERT INTO chado.dbxref VALUES (1792, 24, '0001301', '', NULL);
INSERT INTO chado.dbxref VALUES (1793, 36, '007', '', NULL);
INSERT INTO chado.dbxref VALUES (1794, 24, '0001302', '', NULL);
INSERT INTO chado.dbxref VALUES (1795, 36, '008', '', NULL);
INSERT INTO chado.dbxref VALUES (1796, 24, '0001303', '', NULL);
INSERT INTO chado.dbxref VALUES (1797, 36, '009', '', NULL);
INSERT INTO chado.dbxref VALUES (1798, 24, '0001304', '', NULL);
INSERT INTO chado.dbxref VALUES (1799, 36, '010', '', NULL);
INSERT INTO chado.dbxref VALUES (1800, 24, '0001305', '', NULL);
INSERT INTO chado.dbxref VALUES (1801, 36, '011', '', NULL);
INSERT INTO chado.dbxref VALUES (1802, 24, '0001306', '', NULL);
INSERT INTO chado.dbxref VALUES (1803, 36, '012', '', NULL);
INSERT INTO chado.dbxref VALUES (1804, 24, '0001307', '', NULL);
INSERT INTO chado.dbxref VALUES (1805, 36, '013', '', NULL);
INSERT INTO chado.dbxref VALUES (1806, 24, '0001308', '', NULL);
INSERT INTO chado.dbxref VALUES (1807, 36, '014', '', NULL);
INSERT INTO chado.dbxref VALUES (1808, 24, '0001309', '', NULL);
INSERT INTO chado.dbxref VALUES (1809, 36, '015', '', NULL);
INSERT INTO chado.dbxref VALUES (1810, 24, '0001310', '', NULL);
INSERT INTO chado.dbxref VALUES (1811, 36, '016', '', NULL);
INSERT INTO chado.dbxref VALUES (1812, 24, '0001311', '', NULL);
INSERT INTO chado.dbxref VALUES (1813, 36, '080', '', NULL);
INSERT INTO chado.dbxref VALUES (1814, 24, '0001312', '', NULL);
INSERT INTO chado.dbxref VALUES (1815, 36, '088', '', NULL);
INSERT INTO chado.dbxref VALUES (1816, 24, '0001313', '', NULL);
INSERT INTO chado.dbxref VALUES (1817, 36, '089', '', NULL);
INSERT INTO chado.dbxref VALUES (1818, 24, '0001314', '', NULL);
INSERT INTO chado.dbxref VALUES (1819, 36, '097', '', NULL);
INSERT INTO chado.dbxref VALUES (1820, 24, '0001315', '', NULL);
INSERT INTO chado.dbxref VALUES (1821, 36, '102', '', NULL);
INSERT INTO chado.dbxref VALUES (1822, 24, '0001316', '', NULL);
INSERT INTO chado.dbxref VALUES (1823, 24, '0001317', '', NULL);
INSERT INTO chado.dbxref VALUES (1824, 36, '043', '', NULL);
INSERT INTO chado.dbxref VALUES (1825, 24, '0001318', '', NULL);
INSERT INTO chado.dbxref VALUES (1826, 36, '044', '', NULL);
INSERT INTO chado.dbxref VALUES (1827, 24, '0001319', '', NULL);
INSERT INTO chado.dbxref VALUES (1828, 36, '045', '', NULL);
INSERT INTO chado.dbxref VALUES (1829, 24, '0001320', '', NULL);
INSERT INTO chado.dbxref VALUES (1830, 36, '046', '', NULL);
INSERT INTO chado.dbxref VALUES (1831, 24, '0001321', '', NULL);
INSERT INTO chado.dbxref VALUES (1832, 36, '047', '', NULL);
INSERT INTO chado.dbxref VALUES (1833, 24, '0001322', '', NULL);
INSERT INTO chado.dbxref VALUES (1834, 36, '048', '', NULL);
INSERT INTO chado.dbxref VALUES (1835, 24, '0001323', '', NULL);
INSERT INTO chado.dbxref VALUES (1836, 36, '049', '', NULL);
INSERT INTO chado.dbxref VALUES (1837, 24, '0001324', '', NULL);
INSERT INTO chado.dbxref VALUES (1838, 36, '029', '', NULL);
INSERT INTO chado.dbxref VALUES (1839, 24, '0001325', '', NULL);
INSERT INTO chado.dbxref VALUES (1840, 36, '030', '', NULL);
INSERT INTO chado.dbxref VALUES (1841, 24, '0001326', '', NULL);
INSERT INTO chado.dbxref VALUES (1842, 36, '031', '', NULL);
INSERT INTO chado.dbxref VALUES (1843, 24, '0001327', '', NULL);
INSERT INTO chado.dbxref VALUES (1844, 36, '032', '', NULL);
INSERT INTO chado.dbxref VALUES (1845, 24, '0001328', '', NULL);
INSERT INTO chado.dbxref VALUES (1846, 36, '033', '', NULL);
INSERT INTO chado.dbxref VALUES (1847, 24, '0001329', '', NULL);
INSERT INTO chado.dbxref VALUES (1848, 36, '034', '', NULL);
INSERT INTO chado.dbxref VALUES (1849, 24, '0001330', '', NULL);
INSERT INTO chado.dbxref VALUES (1850, 36, '035', '', NULL);
INSERT INTO chado.dbxref VALUES (1851, 24, '0001331', '', NULL);
INSERT INTO chado.dbxref VALUES (1852, 36, '036', '', NULL);
INSERT INTO chado.dbxref VALUES (1853, 24, '0001332', '', NULL);
INSERT INTO chado.dbxref VALUES (1854, 36, '037', '', NULL);
INSERT INTO chado.dbxref VALUES (1855, 24, '0001333', '', NULL);
INSERT INTO chado.dbxref VALUES (1856, 36, '038', '', NULL);
INSERT INTO chado.dbxref VALUES (1857, 24, '0001334', '', NULL);
INSERT INTO chado.dbxref VALUES (1858, 36, '039', '', NULL);
INSERT INTO chado.dbxref VALUES (1859, 24, '0001335', '', NULL);
INSERT INTO chado.dbxref VALUES (1860, 36, '040', '', NULL);
INSERT INTO chado.dbxref VALUES (1861, 24, '0001336', '', NULL);
INSERT INTO chado.dbxref VALUES (1862, 36, '041', '', NULL);
INSERT INTO chado.dbxref VALUES (1863, 24, '0001337', '', NULL);
INSERT INTO chado.dbxref VALUES (1864, 36, '042', '', NULL);
INSERT INTO chado.dbxref VALUES (1865, 24, '0001338', '', NULL);
INSERT INTO chado.dbxref VALUES (1866, 36, '090', '', NULL);
INSERT INTO chado.dbxref VALUES (1867, 24, '0001339', '', NULL);
INSERT INTO chado.dbxref VALUES (1868, 36, '091', '', NULL);
INSERT INTO chado.dbxref VALUES (1869, 24, '0001340', '', NULL);
INSERT INTO chado.dbxref VALUES (1870, 36, '096', '', NULL);
INSERT INTO chado.dbxref VALUES (1871, 24, '0001341', '', NULL);
INSERT INTO chado.dbxref VALUES (1872, 36, '100', '', NULL);
INSERT INTO chado.dbxref VALUES (1873, 24, '0001342', '', NULL);
INSERT INTO chado.dbxref VALUES (1874, 36, '101', '', NULL);
INSERT INTO chado.dbxref VALUES (1875, 24, '0001343', '', NULL);
INSERT INTO chado.dbxref VALUES (1876, 36, '106', '', NULL);
INSERT INTO chado.dbxref VALUES (1877, 24, '0001344', '', NULL);
INSERT INTO chado.dbxref VALUES (1878, 36, '052', '', NULL);
INSERT INTO chado.dbxref VALUES (1879, 24, '0001345', '', NULL);
INSERT INTO chado.dbxref VALUES (1880, 36, '053', '', NULL);
INSERT INTO chado.dbxref VALUES (1881, 24, '0001346', '', NULL);
INSERT INTO chado.dbxref VALUES (1882, 36, '054', '', NULL);
INSERT INTO chado.dbxref VALUES (1883, 24, '0001347', '', NULL);
INSERT INTO chado.dbxref VALUES (1884, 36, '055', '', NULL);
INSERT INTO chado.dbxref VALUES (1885, 24, '0001348', '', NULL);
INSERT INTO chado.dbxref VALUES (1886, 36, '056', '', NULL);
INSERT INTO chado.dbxref VALUES (1887, 24, '0001349', '', NULL);
INSERT INTO chado.dbxref VALUES (1888, 36, '057', '', NULL);
INSERT INTO chado.dbxref VALUES (1889, 24, '0001350', '', NULL);
INSERT INTO chado.dbxref VALUES (1890, 36, '058', '', NULL);
INSERT INTO chado.dbxref VALUES (1891, 24, '0001351', '', NULL);
INSERT INTO chado.dbxref VALUES (1892, 36, '059', '', NULL);
INSERT INTO chado.dbxref VALUES (1893, 24, '0001352', '', NULL);
INSERT INTO chado.dbxref VALUES (1894, 36, '060', '', NULL);
INSERT INTO chado.dbxref VALUES (1895, 24, '0001353', '', NULL);
INSERT INTO chado.dbxref VALUES (1896, 36, '061', '', NULL);
INSERT INTO chado.dbxref VALUES (1897, 24, '0001354', '', NULL);
INSERT INTO chado.dbxref VALUES (1898, 24, '0001355', '', NULL);
INSERT INTO chado.dbxref VALUES (1899, 36, '063', '', NULL);
INSERT INTO chado.dbxref VALUES (1900, 24, '0001356', '', NULL);
INSERT INTO chado.dbxref VALUES (1901, 36, '064', '', NULL);
INSERT INTO chado.dbxref VALUES (1902, 24, '0001357', '', NULL);
INSERT INTO chado.dbxref VALUES (1903, 36, '065', '', NULL);
INSERT INTO chado.dbxref VALUES (1904, 24, '0001358', '', NULL);
INSERT INTO chado.dbxref VALUES (1905, 36, '066', '', NULL);
INSERT INTO chado.dbxref VALUES (1906, 24, '0001359', '', NULL);
INSERT INTO chado.dbxref VALUES (1907, 36, '067', '', NULL);
INSERT INTO chado.dbxref VALUES (1908, 24, '0001360', '', NULL);
INSERT INTO chado.dbxref VALUES (1909, 36, '068', '', NULL);
INSERT INTO chado.dbxref VALUES (1910, 24, '0001361', '', NULL);
INSERT INTO chado.dbxref VALUES (1911, 36, '069', '', NULL);
INSERT INTO chado.dbxref VALUES (1912, 24, '0001362', '', NULL);
INSERT INTO chado.dbxref VALUES (1913, 36, '070', '', NULL);
INSERT INTO chado.dbxref VALUES (1914, 24, '0001363', '', NULL);
INSERT INTO chado.dbxref VALUES (1915, 36, '071', '', NULL);
INSERT INTO chado.dbxref VALUES (1916, 24, '0001364', '', NULL);
INSERT INTO chado.dbxref VALUES (1917, 36, '072', '', NULL);
INSERT INTO chado.dbxref VALUES (1918, 24, '0001365', '', NULL);
INSERT INTO chado.dbxref VALUES (1919, 36, '073', '', NULL);
INSERT INTO chado.dbxref VALUES (1920, 24, '0001366', '', NULL);
INSERT INTO chado.dbxref VALUES (1921, 36, '074', '', NULL);
INSERT INTO chado.dbxref VALUES (1922, 24, '0001367', '', NULL);
INSERT INTO chado.dbxref VALUES (1923, 36, '075', '', NULL);
INSERT INTO chado.dbxref VALUES (1924, 24, '0001368', '', NULL);
INSERT INTO chado.dbxref VALUES (1925, 36, '076', '', NULL);
INSERT INTO chado.dbxref VALUES (1926, 24, '0001369', '', NULL);
INSERT INTO chado.dbxref VALUES (1927, 36, '077', '', NULL);
INSERT INTO chado.dbxref VALUES (1928, 24, '0001370', '', NULL);
INSERT INTO chado.dbxref VALUES (1929, 36, '078', '', NULL);
INSERT INTO chado.dbxref VALUES (1930, 24, '0001371', '', NULL);
INSERT INTO chado.dbxref VALUES (1931, 36, '079', '', NULL);
INSERT INTO chado.dbxref VALUES (1932, 24, '0001372', '', NULL);
INSERT INTO chado.dbxref VALUES (1933, 36, '085', '', NULL);
INSERT INTO chado.dbxref VALUES (1934, 24, '0001373', '', NULL);
INSERT INTO chado.dbxref VALUES (1935, 36, '086', '', NULL);
INSERT INTO chado.dbxref VALUES (1936, 24, '0001374', '', NULL);
INSERT INTO chado.dbxref VALUES (1937, 36, '087', '', NULL);
INSERT INTO chado.dbxref VALUES (1938, 24, '0001375', '', NULL);
INSERT INTO chado.dbxref VALUES (1939, 36, '092', '', NULL);
INSERT INTO chado.dbxref VALUES (1940, 24, '0001376', '', NULL);
INSERT INTO chado.dbxref VALUES (1941, 36, '093', '', NULL);
INSERT INTO chado.dbxref VALUES (1942, 24, '0001377', '', NULL);
INSERT INTO chado.dbxref VALUES (1943, 36, '094', '', NULL);
INSERT INTO chado.dbxref VALUES (1944, 24, '0001378', '', NULL);
INSERT INTO chado.dbxref VALUES (1945, 36, '098', '', NULL);
INSERT INTO chado.dbxref VALUES (1946, 24, '0001379', '', NULL);
INSERT INTO chado.dbxref VALUES (1947, 36, '099', '', NULL);
INSERT INTO chado.dbxref VALUES (1948, 24, '0001380', '', NULL);
INSERT INTO chado.dbxref VALUES (1949, 36, '103', '', NULL);
INSERT INTO chado.dbxref VALUES (1950, 24, '0001381', '', NULL);
INSERT INTO chado.dbxref VALUES (1951, 36, '104', '', NULL);
INSERT INTO chado.dbxref VALUES (1952, 24, '0001382', '', NULL);
INSERT INTO chado.dbxref VALUES (1953, 36, '105', '', NULL);
INSERT INTO chado.dbxref VALUES (1954, 24, '0001383', '', NULL);
INSERT INTO chado.dbxref VALUES (1955, 24, '0001384', '', NULL);
INSERT INTO chado.dbxref VALUES (1956, 24, '0001385', '', NULL);
INSERT INTO chado.dbxref VALUES (1957, 24, '0001386', '', NULL);
INSERT INTO chado.dbxref VALUES (1958, 37, '00908', '', NULL);
INSERT INTO chado.dbxref VALUES (1959, 24, '0001387', '', NULL);
INSERT INTO chado.dbxref VALUES (1960, 37, '00901', '', NULL);
INSERT INTO chado.dbxref VALUES (1961, 24, '0001388', '', NULL);
INSERT INTO chado.dbxref VALUES (1962, 37, '00903', '', NULL);
INSERT INTO chado.dbxref VALUES (1963, 24, '0001389', '', NULL);
INSERT INTO chado.dbxref VALUES (1964, 37, '00904', '', NULL);
INSERT INTO chado.dbxref VALUES (1965, 24, '0001390', '', NULL);
INSERT INTO chado.dbxref VALUES (1966, 37, '00905', '', NULL);
INSERT INTO chado.dbxref VALUES (1967, 24, '0001391', '', NULL);
INSERT INTO chado.dbxref VALUES (1968, 37, '00906', '', NULL);
INSERT INTO chado.dbxref VALUES (1969, 24, '0001392', '', NULL);
INSERT INTO chado.dbxref VALUES (1970, 37, '00917', '', NULL);
INSERT INTO chado.dbxref VALUES (1971, 24, '0001393', '', NULL);
INSERT INTO chado.dbxref VALUES (1972, 37, '00918', '', NULL);
INSERT INTO chado.dbxref VALUES (1973, 24, '0001394', '', NULL);
INSERT INTO chado.dbxref VALUES (1974, 37, '00907', '', NULL);
INSERT INTO chado.dbxref VALUES (1975, 24, '0001395', '', NULL);
INSERT INTO chado.dbxref VALUES (1976, 37, '00913', '', NULL);
INSERT INTO chado.dbxref VALUES (1977, 24, '0001396', '', NULL);
INSERT INTO chado.dbxref VALUES (1978, 37, '00910', '', NULL);
INSERT INTO chado.dbxref VALUES (1979, 24, '0001397', '', NULL);
INSERT INTO chado.dbxref VALUES (1980, 37, '00914', '', NULL);
INSERT INTO chado.dbxref VALUES (1981, 24, '0001398', '', NULL);
INSERT INTO chado.dbxref VALUES (1982, 37, '00909', '', NULL);
INSERT INTO chado.dbxref VALUES (1983, 24, '0001399', '', NULL);
INSERT INTO chado.dbxref VALUES (1984, 37, '00916', '', NULL);
INSERT INTO chado.dbxref VALUES (1985, 24, '0001400', '', NULL);
INSERT INTO chado.dbxref VALUES (1986, 37, '00912', '', NULL);
INSERT INTO chado.dbxref VALUES (1987, 24, '0001401', '', NULL);
INSERT INTO chado.dbxref VALUES (1988, 37, '00911', '', NULL);
INSERT INTO chado.dbxref VALUES (1989, 24, '0001402', '', NULL);
INSERT INTO chado.dbxref VALUES (1990, 37, '01158', '', NULL);
INSERT INTO chado.dbxref VALUES (1991, 24, '0001403', '', NULL);
INSERT INTO chado.dbxref VALUES (1992, 37, '00920', '', NULL);
INSERT INTO chado.dbxref VALUES (1993, 24, '0001404', '', NULL);
INSERT INTO chado.dbxref VALUES (1994, 37, '00915', '', NULL);
INSERT INTO chado.dbxref VALUES (1995, 24, '0001405', '', NULL);
INSERT INTO chado.dbxref VALUES (1996, 37, '00919', '', NULL);
INSERT INTO chado.dbxref VALUES (1997, 24, '0001406', '', NULL);
INSERT INTO chado.dbxref VALUES (1998, 37, '00902', '', NULL);
INSERT INTO chado.dbxref VALUES (1999, 24, '0001407', '', NULL);
INSERT INTO chado.dbxref VALUES (2000, 24, '0001408', '', NULL);
INSERT INTO chado.dbxref VALUES (2001, 24, '0001413', '', NULL);
INSERT INTO chado.dbxref VALUES (2002, 24, '0001414', '', NULL);
INSERT INTO chado.dbxref VALUES (2003, 24, '0001415', '', NULL);
INSERT INTO chado.dbxref VALUES (2004, 24, '0001416', '', NULL);
INSERT INTO chado.dbxref VALUES (2005, 24, '0001417', '', NULL);
INSERT INTO chado.dbxref VALUES (2006, 24, '0001418', '', NULL);
INSERT INTO chado.dbxref VALUES (2007, 24, '0001421', '', NULL);
INSERT INTO chado.dbxref VALUES (2008, 24, '0001422', '', NULL);
INSERT INTO chado.dbxref VALUES (2009, 24, '0001423', '', NULL);
INSERT INTO chado.dbxref VALUES (2010, 24, '0001424', '', NULL);
INSERT INTO chado.dbxref VALUES (2011, 24, '0001425', '', NULL);
INSERT INTO chado.dbxref VALUES (2012, 24, '0001426', '', NULL);
INSERT INTO chado.dbxref VALUES (2013, 24, '0001427', '', NULL);
INSERT INTO chado.dbxref VALUES (2014, 24, '0001428', '', NULL);
INSERT INTO chado.dbxref VALUES (2015, 24, '0001429', '', NULL);
INSERT INTO chado.dbxref VALUES (2016, 24, '0001431', '', NULL);
INSERT INTO chado.dbxref VALUES (2017, 24, '0001432', '', NULL);
INSERT INTO chado.dbxref VALUES (2018, 24, '0001433', '', NULL);
INSERT INTO chado.dbxref VALUES (2019, 24, '0001434', '', NULL);
INSERT INTO chado.dbxref VALUES (2020, 24, '0001435', '', NULL);
INSERT INTO chado.dbxref VALUES (2021, 24, '0001436', '', NULL);
INSERT INTO chado.dbxref VALUES (2022, 24, '0001437', '', NULL);
INSERT INTO chado.dbxref VALUES (2023, 24, '0001438', '', NULL);
INSERT INTO chado.dbxref VALUES (2024, 24, '0001439', '', NULL);
INSERT INTO chado.dbxref VALUES (2025, 24, '0001440', '', NULL);
INSERT INTO chado.dbxref VALUES (2026, 24, '0001441', '', NULL);
INSERT INTO chado.dbxref VALUES (2027, 24, '0001442', '', NULL);
INSERT INTO chado.dbxref VALUES (2028, 24, '0001443', '', NULL);
INSERT INTO chado.dbxref VALUES (2029, 24, '0001444', '', NULL);
INSERT INTO chado.dbxref VALUES (2030, 24, '0001445', '', NULL);
INSERT INTO chado.dbxref VALUES (2031, 24, '0001446', '', NULL);
INSERT INTO chado.dbxref VALUES (2032, 24, '0001447', '', NULL);
INSERT INTO chado.dbxref VALUES (2033, 24, '0001448', '', NULL);
INSERT INTO chado.dbxref VALUES (2034, 24, '0001449', '', NULL);
INSERT INTO chado.dbxref VALUES (2035, 24, '0001450', '', NULL);
INSERT INTO chado.dbxref VALUES (2036, 24, '0001451', '', NULL);
INSERT INTO chado.dbxref VALUES (2037, 24, '0001452', '', NULL);
INSERT INTO chado.dbxref VALUES (2038, 24, '0001453', '', NULL);
INSERT INTO chado.dbxref VALUES (2039, 24, '0001454', '', NULL);
INSERT INTO chado.dbxref VALUES (2040, 24, '0001455', '', NULL);
INSERT INTO chado.dbxref VALUES (2041, 24, '0001456', '', NULL);
INSERT INTO chado.dbxref VALUES (2042, 24, '0001457', '', NULL);
INSERT INTO chado.dbxref VALUES (2043, 24, '0001458', '', NULL);
INSERT INTO chado.dbxref VALUES (2044, 24, '0001459', '', NULL);
INSERT INTO chado.dbxref VALUES (2045, 24, '0001460', '', NULL);
INSERT INTO chado.dbxref VALUES (2046, 24, '0001461', '', NULL);
INSERT INTO chado.dbxref VALUES (2047, 24, '0001462', '', NULL);
INSERT INTO chado.dbxref VALUES (2048, 24, '0001463', '', NULL);
INSERT INTO chado.dbxref VALUES (2049, 24, '0001877', '', NULL);
INSERT INTO chado.dbxref VALUES (2050, 24, '0001464', '', NULL);
INSERT INTO chado.dbxref VALUES (2051, 24, '0001465', '', NULL);
INSERT INTO chado.dbxref VALUES (2052, 24, '0001466', '', NULL);
INSERT INTO chado.dbxref VALUES (2053, 24, '0001467', '', NULL);
INSERT INTO chado.dbxref VALUES (2054, 24, '0001468', '', NULL);
INSERT INTO chado.dbxref VALUES (2055, 24, '0001469', '', NULL);
INSERT INTO chado.dbxref VALUES (2056, 24, '0001470', '', NULL);
INSERT INTO chado.dbxref VALUES (2057, 24, '0001471', '', NULL);
INSERT INTO chado.dbxref VALUES (2058, 24, '0001472', '', NULL);
INSERT INTO chado.dbxref VALUES (2059, 24, '0001473', '', NULL);
INSERT INTO chado.dbxref VALUES (2060, 24, '0001474', '', NULL);
INSERT INTO chado.dbxref VALUES (2061, 24, '0001475', '', NULL);
INSERT INTO chado.dbxref VALUES (2062, 24, '0001476', '', NULL);
INSERT INTO chado.dbxref VALUES (2063, 24, '0001477', '', NULL);
INSERT INTO chado.dbxref VALUES (2064, 24, '0001478', '', NULL);
INSERT INTO chado.dbxref VALUES (2065, 24, '0001479', '', NULL);
INSERT INTO chado.dbxref VALUES (2066, 24, '0001480', '', NULL);
INSERT INTO chado.dbxref VALUES (2067, 24, '0001481', '', NULL);
INSERT INTO chado.dbxref VALUES (2068, 24, '0001482', '', NULL);
INSERT INTO chado.dbxref VALUES (2069, 24, '1000002', '', NULL);
INSERT INTO chado.dbxref VALUES (2070, 24, '0001484', '', NULL);
INSERT INTO chado.dbxref VALUES (2071, 24, '0001485', '', NULL);
INSERT INTO chado.dbxref VALUES (2072, 24, '0001486', '', NULL);
INSERT INTO chado.dbxref VALUES (2073, 24, '0001499', '', NULL);
INSERT INTO chado.dbxref VALUES (2074, 24, '0001487', '', NULL);
INSERT INTO chado.dbxref VALUES (2075, 24, '0001488', '', NULL);
INSERT INTO chado.dbxref VALUES (2076, 24, '0001489', '', NULL);
INSERT INTO chado.dbxref VALUES (2077, 24, '0001490', '', NULL);
INSERT INTO chado.dbxref VALUES (2078, 24, '0001491', '', NULL);
INSERT INTO chado.dbxref VALUES (2079, 24, '0001492', '', NULL);
INSERT INTO chado.dbxref VALUES (2080, 24, '0001493', '', NULL);
INSERT INTO chado.dbxref VALUES (2081, 24, '0001794', '', NULL);
INSERT INTO chado.dbxref VALUES (2082, 24, '0001494', '', NULL);
INSERT INTO chado.dbxref VALUES (2083, 24, '0001495', '', NULL);
INSERT INTO chado.dbxref VALUES (2084, 24, '0001496', '', NULL);
INSERT INTO chado.dbxref VALUES (2085, 24, '0001497', '', NULL);
INSERT INTO chado.dbxref VALUES (2086, 24, '0001498', '', NULL);
INSERT INTO chado.dbxref VALUES (2087, 24, '0001501', '', NULL);
INSERT INTO chado.dbxref VALUES (2088, 24, '0001502', '', NULL);
INSERT INTO chado.dbxref VALUES (2089, 24, '0001503', '', NULL);
INSERT INTO chado.dbxref VALUES (2090, 24, '0001505', '', NULL);
INSERT INTO chado.dbxref VALUES (2091, 24, '0001506', '', NULL);
INSERT INTO chado.dbxref VALUES (2092, 24, '0001508', '', NULL);
INSERT INTO chado.dbxref VALUES (2093, 24, '0001509', '', NULL);
INSERT INTO chado.dbxref VALUES (2094, 24, '0001510', '', NULL);
INSERT INTO chado.dbxref VALUES (2095, 24, '0001511', '', NULL);
INSERT INTO chado.dbxref VALUES (2096, 24, '0001512', '', NULL);
INSERT INTO chado.dbxref VALUES (2097, 24, '0001513', '', NULL);
INSERT INTO chado.dbxref VALUES (2098, 24, '0001514', '', NULL);
INSERT INTO chado.dbxref VALUES (2099, 24, '0001515', '', NULL);
INSERT INTO chado.dbxref VALUES (2100, 24, '0001516', '', NULL);
INSERT INTO chado.dbxref VALUES (2101, 24, '0001523', '', NULL);
INSERT INTO chado.dbxref VALUES (2102, 24, '0001517', '', NULL);
INSERT INTO chado.dbxref VALUES (2103, 24, '0001518', '', NULL);
INSERT INTO chado.dbxref VALUES (2104, 24, '0001519', '', NULL);
INSERT INTO chado.dbxref VALUES (2105, 24, '0001520', '', NULL);
INSERT INTO chado.dbxref VALUES (2106, 24, '0001521', '', NULL);
INSERT INTO chado.dbxref VALUES (2107, 24, '0001522', '', NULL);
INSERT INTO chado.dbxref VALUES (2108, 24, '0001525', '', NULL);
INSERT INTO chado.dbxref VALUES (2109, 24, '0001526', '', NULL);
INSERT INTO chado.dbxref VALUES (2110, 24, '0001528', '', NULL);
INSERT INTO chado.dbxref VALUES (2111, 24, '0001529', '', NULL);
INSERT INTO chado.dbxref VALUES (2112, 24, '0001530', '', NULL);
INSERT INTO chado.dbxref VALUES (2113, 24, '0001531', '', NULL);
INSERT INTO chado.dbxref VALUES (2114, 24, '0001532', '', NULL);
INSERT INTO chado.dbxref VALUES (2115, 24, '0001533', '', NULL);
INSERT INTO chado.dbxref VALUES (2116, 24, '0001534', '', NULL);
INSERT INTO chado.dbxref VALUES (2117, 18, '16027110', '', NULL);
INSERT INTO chado.dbxref VALUES (2118, 24, '0001535', '', NULL);
INSERT INTO chado.dbxref VALUES (2119, 24, '0001536', '', NULL);
INSERT INTO chado.dbxref VALUES (2120, 24, '0001537', '', NULL);
INSERT INTO chado.dbxref VALUES (2121, 24, '0001538', '', NULL);
INSERT INTO chado.dbxref VALUES (2122, 24, '0002218', '', NULL);
INSERT INTO chado.dbxref VALUES (2123, 24, '0001539', '', NULL);
INSERT INTO chado.dbxref VALUES (2124, 24, '0001540', '', NULL);
INSERT INTO chado.dbxref VALUES (2125, 24, '0001541', '', NULL);
INSERT INTO chado.dbxref VALUES (2126, 24, '0001542', '', NULL);
INSERT INTO chado.dbxref VALUES (2127, 24, '0001543', '', NULL);
INSERT INTO chado.dbxref VALUES (2128, 24, '0001544', '', NULL);
INSERT INTO chado.dbxref VALUES (2129, 24, '0001545', '', NULL);
INSERT INTO chado.dbxref VALUES (2130, 24, '0001546', '', NULL);
INSERT INTO chado.dbxref VALUES (2131, 24, '0001547', '', NULL);
INSERT INTO chado.dbxref VALUES (2132, 24, '0001548', '', NULL);
INSERT INTO chado.dbxref VALUES (2133, 24, '0001549', '', NULL);
INSERT INTO chado.dbxref VALUES (2134, 24, '0001550', '', NULL);
INSERT INTO chado.dbxref VALUES (2135, 24, '0001551', '', NULL);
INSERT INTO chado.dbxref VALUES (2136, 24, '0001552', '', NULL);
INSERT INTO chado.dbxref VALUES (2137, 24, '0001553', '', NULL);
INSERT INTO chado.dbxref VALUES (2138, 24, '0001554', '', NULL);
INSERT INTO chado.dbxref VALUES (2139, 24, '0001555', '', NULL);
INSERT INTO chado.dbxref VALUES (2140, 24, '0001556', '', NULL);
INSERT INTO chado.dbxref VALUES (2141, 24, '0001557', '', NULL);
INSERT INTO chado.dbxref VALUES (2142, 24, '0001558', '', NULL);
INSERT INTO chado.dbxref VALUES (2143, 24, '0001559', '', NULL);
INSERT INTO chado.dbxref VALUES (2144, 24, '0001560', '', NULL);
INSERT INTO chado.dbxref VALUES (2145, 24, '0001561', '', NULL);
INSERT INTO chado.dbxref VALUES (2146, 24, '0001562', '', NULL);
INSERT INTO chado.dbxref VALUES (2147, 24, '0001563', '', NULL);
INSERT INTO chado.dbxref VALUES (2148, 24, '0002160', '', NULL);
INSERT INTO chado.dbxref VALUES (2149, 24, '0001564', '', NULL);
INSERT INTO chado.dbxref VALUES (2150, 24, '0001565', '', NULL);
INSERT INTO chado.dbxref VALUES (2151, 24, '0001882', '', NULL);
INSERT INTO chado.dbxref VALUES (2152, 24, '0001566', '', NULL);
INSERT INTO chado.dbxref VALUES (2153, 24, '0001567', '', NULL);
INSERT INTO chado.dbxref VALUES (2154, 24, '0001590', '', NULL);
INSERT INTO chado.dbxref VALUES (2155, 24, '0001819', '', NULL);
INSERT INTO chado.dbxref VALUES (2156, 24, '0001568', '', NULL);
INSERT INTO chado.dbxref VALUES (2157, 24, '0001576', '', NULL);
INSERT INTO chado.dbxref VALUES (2158, 24, '0001569', '', NULL);
INSERT INTO chado.dbxref VALUES (2159, 24, '0001570', '', NULL);
INSERT INTO chado.dbxref VALUES (2160, 24, '0001571', '', NULL);
INSERT INTO chado.dbxref VALUES (2161, 24, '0001572', '', NULL);
INSERT INTO chado.dbxref VALUES (2162, 24, '0001573', '', NULL);
INSERT INTO chado.dbxref VALUES (2163, 24, '0001574', '', NULL);
INSERT INTO chado.dbxref VALUES (2164, 24, '0001629', '', NULL);
INSERT INTO chado.dbxref VALUES (2165, 24, '0001575', '', NULL);
INSERT INTO chado.dbxref VALUES (2166, 24, '0001577', '', NULL);
INSERT INTO chado.dbxref VALUES (2167, 24, '0001578', '', NULL);
INSERT INTO chado.dbxref VALUES (2168, 24, '0001907', '', NULL);
INSERT INTO chado.dbxref VALUES (2169, 24, '0001992', '', NULL);
INSERT INTO chado.dbxref VALUES (2170, 24, '0001579', '', NULL);
INSERT INTO chado.dbxref VALUES (2171, 24, '0001580', '', NULL);
INSERT INTO chado.dbxref VALUES (2172, 24, '0001581', '', NULL);
INSERT INTO chado.dbxref VALUES (2173, 24, '0001791', '', NULL);
INSERT INTO chado.dbxref VALUES (2174, 24, '0001968', '', NULL);
INSERT INTO chado.dbxref VALUES (2175, 24, '0001582', '', NULL);
INSERT INTO chado.dbxref VALUES (2176, 34, 'LA6695-6', '', NULL);
INSERT INTO chado.dbxref VALUES (2177, 24, '0001583', '', NULL);
INSERT INTO chado.dbxref VALUES (2178, 24, '0001584', '', NULL);
INSERT INTO chado.dbxref VALUES (2179, 24, '0001783', '', NULL);
INSERT INTO chado.dbxref VALUES (2180, 34, 'LA6698-0', '', NULL);
INSERT INTO chado.dbxref VALUES (2181, 24, '0001585', '', NULL);
INSERT INTO chado.dbxref VALUES (2182, 24, '0001586', '', NULL);
INSERT INTO chado.dbxref VALUES (2183, 24, '0001587', '', NULL);
INSERT INTO chado.dbxref VALUES (2184, 34, 'LA6699-8', '', NULL);
INSERT INTO chado.dbxref VALUES (2185, 24, '0001906', '', NULL);
INSERT INTO chado.dbxref VALUES (2186, 24, '0001589', '', NULL);
INSERT INTO chado.dbxref VALUES (2187, 34, 'LA6694-9', '', NULL);
INSERT INTO chado.dbxref VALUES (2188, 24, '0001818', '', NULL);
INSERT INTO chado.dbxref VALUES (2189, 24, '0001625', '', NULL);
INSERT INTO chado.dbxref VALUES (2190, 34, 'LA6700-2', '', NULL);
INSERT INTO chado.dbxref VALUES (2191, 24, '0001591', '', NULL);
INSERT INTO chado.dbxref VALUES (2192, 24, '0001592', '', NULL);
INSERT INTO chado.dbxref VALUES (2193, 24, '0001593', '', NULL);
INSERT INTO chado.dbxref VALUES (2194, 24, '0001594', '', NULL);
INSERT INTO chado.dbxref VALUES (2195, 24, '0001595', '', NULL);
INSERT INTO chado.dbxref VALUES (2196, 24, '0001596', '', NULL);
INSERT INTO chado.dbxref VALUES (2197, 24, '0001597', '', NULL);
INSERT INTO chado.dbxref VALUES (2198, 24, '0001598', '', NULL);
INSERT INTO chado.dbxref VALUES (2199, 24, '0001599', '', NULL);
INSERT INTO chado.dbxref VALUES (2200, 24, '0001600', '', NULL);
INSERT INTO chado.dbxref VALUES (2201, 24, '0001601', '', NULL);
INSERT INTO chado.dbxref VALUES (2202, 24, '0001602', '', NULL);
INSERT INTO chado.dbxref VALUES (2203, 24, '0001603', '', NULL);
INSERT INTO chado.dbxref VALUES (2204, 24, '0001604', '', NULL);
INSERT INTO chado.dbxref VALUES (2205, 24, '0001605', '', NULL);
INSERT INTO chado.dbxref VALUES (2206, 24, '0001606', '', NULL);
INSERT INTO chado.dbxref VALUES (2207, 24, '0001607', '', NULL);
INSERT INTO chado.dbxref VALUES (2208, 24, '0001608', '', NULL);
INSERT INTO chado.dbxref VALUES (2209, 24, '0001609', '', NULL);
INSERT INTO chado.dbxref VALUES (2210, 24, '0001610', '', NULL);
INSERT INTO chado.dbxref VALUES (2211, 24, '0002229', '', NULL);
INSERT INTO chado.dbxref VALUES (2212, 24, '0001611', '', NULL);
INSERT INTO chado.dbxref VALUES (2213, 24, '0002228', '', NULL);
INSERT INTO chado.dbxref VALUES (2214, 24, '0001612', '', NULL);
INSERT INTO chado.dbxref VALUES (2215, 24, '0001613', '', NULL);
INSERT INTO chado.dbxref VALUES (2216, 24, '0001614', '', NULL);
INSERT INTO chado.dbxref VALUES (2217, 24, '0001615', '', NULL);
INSERT INTO chado.dbxref VALUES (2218, 24, '0001616', '', NULL);
INSERT INTO chado.dbxref VALUES (2219, 24, '0001617', '', NULL);
INSERT INTO chado.dbxref VALUES (2220, 24, '0001618', '', NULL);
INSERT INTO chado.dbxref VALUES (2221, 24, '0001619', '', NULL);
INSERT INTO chado.dbxref VALUES (2222, 24, '0001620', '', NULL);
INSERT INTO chado.dbxref VALUES (2223, 24, '0001621', '', NULL);
INSERT INTO chado.dbxref VALUES (2224, 24, '0001622', '', NULL);
INSERT INTO chado.dbxref VALUES (2225, 24, '0001624', '', NULL);
INSERT INTO chado.dbxref VALUES (2226, 24, '0001626', '', NULL);
INSERT INTO chado.dbxref VALUES (2227, 24, '0001650', '', NULL);
INSERT INTO chado.dbxref VALUES (2228, 24, '0001627', '', NULL);
INSERT INTO chado.dbxref VALUES (2229, 24, '0001628', '', NULL);
INSERT INTO chado.dbxref VALUES (2230, 24, '0001630', '', NULL);
INSERT INTO chado.dbxref VALUES (2231, 24, '0001631', '', NULL);
INSERT INTO chado.dbxref VALUES (2232, 24, '0001632', '', NULL);
INSERT INTO chado.dbxref VALUES (2233, 24, '0001633', '', NULL);
INSERT INTO chado.dbxref VALUES (2234, 24, '0001634', '', NULL);
INSERT INTO chado.dbxref VALUES (2235, 24, '0001635', '', NULL);
INSERT INTO chado.dbxref VALUES (2236, 24, '0001636', '', NULL);
INSERT INTO chado.dbxref VALUES (2237, 24, '0001637', '', NULL);
INSERT INTO chado.dbxref VALUES (2238, 24, '0001638', '', NULL);
INSERT INTO chado.dbxref VALUES (2239, 24, '0001639', '', NULL);
INSERT INTO chado.dbxref VALUES (2240, 24, '0002180', '', NULL);
INSERT INTO chado.dbxref VALUES (2241, 24, '0001640', '', NULL);
INSERT INTO chado.dbxref VALUES (2242, 24, '0001641', '', NULL);
INSERT INTO chado.dbxref VALUES (2243, 24, '0002127', '', NULL);
INSERT INTO chado.dbxref VALUES (2244, 24, '0001642', '', NULL);
INSERT INTO chado.dbxref VALUES (2245, 24, '0001643', '', NULL);
INSERT INTO chado.dbxref VALUES (2246, 24, '0001644', '', NULL);
INSERT INTO chado.dbxref VALUES (2247, 24, '0001646', '', NULL);
INSERT INTO chado.dbxref VALUES (2248, 24, '0001647', '', NULL);
INSERT INTO chado.dbxref VALUES (2249, 24, '0001653', '', NULL);
INSERT INTO chado.dbxref VALUES (2250, 24, '0001658', '', NULL);
INSERT INTO chado.dbxref VALUES (2251, 24, '0001661', '', NULL);
INSERT INTO chado.dbxref VALUES (2252, 24, '0001662', '', NULL);
INSERT INTO chado.dbxref VALUES (2253, 24, '0001663', '', NULL);
INSERT INTO chado.dbxref VALUES (2254, 24, '0001664', '', NULL);
INSERT INTO chado.dbxref VALUES (2255, 24, '0001665', '', NULL);
INSERT INTO chado.dbxref VALUES (2256, 24, '0001666', '', NULL);
INSERT INTO chado.dbxref VALUES (2257, 24, '0001667', '', NULL);
INSERT INTO chado.dbxref VALUES (2258, 24, '0001668', '', NULL);
INSERT INTO chado.dbxref VALUES (2259, 24, '0001678', '', NULL);
INSERT INTO chado.dbxref VALUES (2260, 24, '0001670', '', NULL);
INSERT INTO chado.dbxref VALUES (2261, 24, '0001672', '', NULL);
INSERT INTO chado.dbxref VALUES (2262, 24, '0001673', '', NULL);
INSERT INTO chado.dbxref VALUES (2263, 24, '0001674', '', NULL);
INSERT INTO chado.dbxref VALUES (2264, 24, '0001675', '', NULL);
INSERT INTO chado.dbxref VALUES (2265, 24, '0001676', '', NULL);
INSERT INTO chado.dbxref VALUES (2266, 24, '0001677', '', NULL);
INSERT INTO chado.dbxref VALUES (2267, 24, '0001679', '', NULL);
INSERT INTO chado.dbxref VALUES (2268, 24, '0001681', '', NULL);
INSERT INTO chado.dbxref VALUES (2269, 24, '0001682', '', NULL);
INSERT INTO chado.dbxref VALUES (2270, 24, '0001684', '', NULL);
INSERT INTO chado.dbxref VALUES (2271, 24, '0001685', '', NULL);
INSERT INTO chado.dbxref VALUES (2272, 24, '0001686', '', NULL);
INSERT INTO chado.dbxref VALUES (2273, 24, '0001687', '', NULL);
INSERT INTO chado.dbxref VALUES (2274, 24, '0001954', '', NULL);
INSERT INTO chado.dbxref VALUES (2275, 24, '0001688', '', NULL);
INSERT INTO chado.dbxref VALUES (2276, 24, '0002204', '', NULL);
INSERT INTO chado.dbxref VALUES (2277, 24, '0001689', '', NULL);
INSERT INTO chado.dbxref VALUES (2278, 24, '0001694', '', NULL);
INSERT INTO chado.dbxref VALUES (2279, 24, '0001692', '', NULL);
INSERT INTO chado.dbxref VALUES (2280, 24, '0001690', '', NULL);
INSERT INTO chado.dbxref VALUES (2281, 24, '0001691', '', NULL);
INSERT INTO chado.dbxref VALUES (2282, 24, '0001693', '', NULL);
INSERT INTO chado.dbxref VALUES (2283, 24, '0001695', '', NULL);
INSERT INTO chado.dbxref VALUES (2284, 24, '0001696', '', NULL);
INSERT INTO chado.dbxref VALUES (2285, 24, '0001697', '', NULL);
INSERT INTO chado.dbxref VALUES (2286, 24, '0001698', '', NULL);
INSERT INTO chado.dbxref VALUES (2287, 24, '0001699', '', NULL);
INSERT INTO chado.dbxref VALUES (2288, 24, '0001700', '', NULL);
INSERT INTO chado.dbxref VALUES (2289, 24, '0001701', '', NULL);
INSERT INTO chado.dbxref VALUES (2290, 24, '0001702', '', NULL);
INSERT INTO chado.dbxref VALUES (2291, 24, '0001703', '', NULL);
INSERT INTO chado.dbxref VALUES (2292, 24, '0001973', '', NULL);
INSERT INTO chado.dbxref VALUES (2293, 24, '0001704', '', NULL);
INSERT INTO chado.dbxref VALUES (2294, 24, '0001705', '', NULL);
INSERT INTO chado.dbxref VALUES (2295, 24, '0001734', '', NULL);
INSERT INTO chado.dbxref VALUES (2296, 24, '0001706', '', NULL);
INSERT INTO chado.dbxref VALUES (2297, 24, '0001707', '', NULL);
INSERT INTO chado.dbxref VALUES (2298, 24, '0001736', '', NULL);
INSERT INTO chado.dbxref VALUES (2299, 24, '0001708', '', NULL);
INSERT INTO chado.dbxref VALUES (2300, 24, '0001732', '', NULL);
INSERT INTO chado.dbxref VALUES (2301, 24, '0001709', '', NULL);
INSERT INTO chado.dbxref VALUES (2302, 24, '0001710', '', NULL);
INSERT INTO chado.dbxref VALUES (2303, 24, '0001735', '', NULL);
INSERT INTO chado.dbxref VALUES (2304, 24, '0001711', '', NULL);
INSERT INTO chado.dbxref VALUES (2305, 24, '0001712', '', NULL);
INSERT INTO chado.dbxref VALUES (2306, 24, '0001713', '', NULL);
INSERT INTO chado.dbxref VALUES (2307, 24, '0001714', '', NULL);
INSERT INTO chado.dbxref VALUES (2308, 24, '0001715', '', NULL);
INSERT INTO chado.dbxref VALUES (2309, 24, '0001716', '', NULL);
INSERT INTO chado.dbxref VALUES (2310, 24, '0001717', '', NULL);
INSERT INTO chado.dbxref VALUES (2311, 24, '0001718', '', NULL);
INSERT INTO chado.dbxref VALUES (2312, 24, '0001719', '', NULL);
INSERT INTO chado.dbxref VALUES (2313, 24, '0001721', '', NULL);
INSERT INTO chado.dbxref VALUES (2314, 24, '0001722', '', NULL);
INSERT INTO chado.dbxref VALUES (2315, 24, '0001733', '', NULL);
INSERT INTO chado.dbxref VALUES (2316, 24, '0001723', '', NULL);
INSERT INTO chado.dbxref VALUES (2317, 24, '0001724', '', NULL);
INSERT INTO chado.dbxref VALUES (2318, 24, '0001725', '', NULL);
INSERT INTO chado.dbxref VALUES (2319, 24, '0001726', '', NULL);
INSERT INTO chado.dbxref VALUES (2320, 24, '0001727', '', NULL);
INSERT INTO chado.dbxref VALUES (2321, 24, '0001728', '', NULL);
INSERT INTO chado.dbxref VALUES (2322, 24, '0001729', '', NULL);
INSERT INTO chado.dbxref VALUES (2323, 24, '0001972', '', NULL);
INSERT INTO chado.dbxref VALUES (2324, 24, '0001730', '', NULL);
INSERT INTO chado.dbxref VALUES (2325, 24, '0001731', '', NULL);
INSERT INTO chado.dbxref VALUES (2326, 24, '0001737', '', NULL);
INSERT INTO chado.dbxref VALUES (2327, 24, '0001738', '', NULL);
INSERT INTO chado.dbxref VALUES (2328, 24, '0001739', '', NULL);
INSERT INTO chado.dbxref VALUES (2329, 24, '0001740', '', NULL);
INSERT INTO chado.dbxref VALUES (2330, 24, '0001741', '', NULL);
INSERT INTO chado.dbxref VALUES (2331, 24, '3000000', '', NULL);
INSERT INTO chado.dbxref VALUES (2332, 24, '0001742', '', NULL);
INSERT INTO chado.dbxref VALUES (2333, 24, '0001743', '', NULL);
INSERT INTO chado.dbxref VALUES (2334, 24, '0001744', '', NULL);
INSERT INTO chado.dbxref VALUES (2335, 24, '0001745', '', NULL);
INSERT INTO chado.dbxref VALUES (2336, 24, '0001746', '', NULL);
INSERT INTO chado.dbxref VALUES (2337, 24, '0001747', '', NULL);
INSERT INTO chado.dbxref VALUES (2338, 24, '0001748', '', NULL);
INSERT INTO chado.dbxref VALUES (2339, 24, '0001749', '', NULL);
INSERT INTO chado.dbxref VALUES (2340, 24, '0001750', '', NULL);
INSERT INTO chado.dbxref VALUES (2341, 24, '0001751', '', NULL);
INSERT INTO chado.dbxref VALUES (2342, 24, '0001752', '', NULL);
INSERT INTO chado.dbxref VALUES (2343, 24, '0001753', '', NULL);
INSERT INTO chado.dbxref VALUES (2344, 24, '0001754', '', NULL);
INSERT INTO chado.dbxref VALUES (2345, 24, '0001755', '', NULL);
INSERT INTO chado.dbxref VALUES (2346, 24, '0001756', '', NULL);
INSERT INTO chado.dbxref VALUES (2347, 24, '0001757', '', NULL);
INSERT INTO chado.dbxref VALUES (2348, 24, '0001758', '', NULL);
INSERT INTO chado.dbxref VALUES (2349, 24, '0001759', '', NULL);
INSERT INTO chado.dbxref VALUES (2350, 24, '0001761', '', NULL);
INSERT INTO chado.dbxref VALUES (2351, 24, '0001762', '', NULL);
INSERT INTO chado.dbxref VALUES (2352, 24, '0001763', '', NULL);
INSERT INTO chado.dbxref VALUES (2353, 24, '0001764', '', NULL);
INSERT INTO chado.dbxref VALUES (2354, 24, '0001765', '', NULL);
INSERT INTO chado.dbxref VALUES (2355, 24, '0001766', '', NULL);
INSERT INTO chado.dbxref VALUES (2356, 24, '0001767', '', NULL);
INSERT INTO chado.dbxref VALUES (2357, 24, '0001768', '', NULL);
INSERT INTO chado.dbxref VALUES (2358, 24, '0001769', '', NULL);
INSERT INTO chado.dbxref VALUES (2359, 24, '0001770', '', NULL);
INSERT INTO chado.dbxref VALUES (2360, 24, '0001771', '', NULL);
INSERT INTO chado.dbxref VALUES (2361, 24, '0001772', '', NULL);
INSERT INTO chado.dbxref VALUES (2362, 24, '0001773', '', NULL);
INSERT INTO chado.dbxref VALUES (2363, 24, '0001774', '', NULL);
INSERT INTO chado.dbxref VALUES (2364, 24, '0001775', '', NULL);
INSERT INTO chado.dbxref VALUES (2365, 24, '0001776', '', NULL);
INSERT INTO chado.dbxref VALUES (2366, 24, '0001777', '', NULL);
INSERT INTO chado.dbxref VALUES (2367, 24, '0001778', '', NULL);
INSERT INTO chado.dbxref VALUES (2368, 24, '0001779', '', NULL);
INSERT INTO chado.dbxref VALUES (2369, 24, '0001780', '', NULL);
INSERT INTO chado.dbxref VALUES (2370, 24, '0001781', '', NULL);
INSERT INTO chado.dbxref VALUES (2371, 24, '0001782', '', NULL);
INSERT INTO chado.dbxref VALUES (2372, 24, '0001784', '', NULL);
INSERT INTO chado.dbxref VALUES (2373, 24, '1000146', '', NULL);
INSERT INTO chado.dbxref VALUES (2374, 24, '0001786', '', NULL);
INSERT INTO chado.dbxref VALUES (2375, 24, '0001787', '', NULL);
INSERT INTO chado.dbxref VALUES (2376, 24, '0001788', '', NULL);
INSERT INTO chado.dbxref VALUES (2377, 24, '0001789', '', NULL);
INSERT INTO chado.dbxref VALUES (2378, 24, '0001792', '', NULL);
INSERT INTO chado.dbxref VALUES (2379, 24, '0001793', '', NULL);
INSERT INTO chado.dbxref VALUES (2380, 24, '0001795', '', NULL);
INSERT INTO chado.dbxref VALUES (2381, 24, '0001796', '', NULL);
INSERT INTO chado.dbxref VALUES (2382, 24, '0001797', '', NULL);
INSERT INTO chado.dbxref VALUES (2383, 24, '0001798', '', NULL);
INSERT INTO chado.dbxref VALUES (2384, 24, '0001799', '', NULL);
INSERT INTO chado.dbxref VALUES (2385, 24, '0001800', '', NULL);
INSERT INTO chado.dbxref VALUES (2386, 24, '0001801', '', NULL);
INSERT INTO chado.dbxref VALUES (2387, 24, '0001802', '', NULL);
INSERT INTO chado.dbxref VALUES (2388, 24, '0001803', '', NULL);
INSERT INTO chado.dbxref VALUES (2389, 24, '0001804', '', NULL);
INSERT INTO chado.dbxref VALUES (2390, 24, '0001805', '', NULL);
INSERT INTO chado.dbxref VALUES (2391, 24, '0100017', '', NULL);
INSERT INTO chado.dbxref VALUES (2392, 24, '0001806', '', NULL);
INSERT INTO chado.dbxref VALUES (2393, 24, '0001807', '', NULL);
INSERT INTO chado.dbxref VALUES (2394, 24, '0001808', '', NULL);
INSERT INTO chado.dbxref VALUES (2395, 24, '0001809', '', NULL);
INSERT INTO chado.dbxref VALUES (2396, 24, '0001810', '', NULL);
INSERT INTO chado.dbxref VALUES (2397, 24, '0001811', '', NULL);
INSERT INTO chado.dbxref VALUES (2398, 24, '0001812', '', NULL);
INSERT INTO chado.dbxref VALUES (2399, 24, '0001813', '', NULL);
INSERT INTO chado.dbxref VALUES (2400, 24, '0001814', '', NULL);
INSERT INTO chado.dbxref VALUES (2401, 24, '0001815', '', NULL);
INSERT INTO chado.dbxref VALUES (2402, 24, '0001816', '', NULL);
INSERT INTO chado.dbxref VALUES (2403, 24, '0001817', '', NULL);
INSERT INTO chado.dbxref VALUES (2404, 24, '0001588', '', NULL);
INSERT INTO chado.dbxref VALUES (2405, 24, '0001820', '', NULL);
INSERT INTO chado.dbxref VALUES (2406, 24, '0001821', '', NULL);
INSERT INTO chado.dbxref VALUES (2407, 24, '0001651', '', NULL);
INSERT INTO chado.dbxref VALUES (2408, 24, '0001908', '', NULL);
INSERT INTO chado.dbxref VALUES (2409, 24, '0001822', '', NULL);
INSERT INTO chado.dbxref VALUES (2410, 24, '0001652', '', NULL);
INSERT INTO chado.dbxref VALUES (2411, 24, '0001823', '', NULL);
INSERT INTO chado.dbxref VALUES (2412, 24, '0001824', '', NULL);
INSERT INTO chado.dbxref VALUES (2413, 24, '0001825', '', NULL);
INSERT INTO chado.dbxref VALUES (2414, 24, '0001826', '', NULL);
INSERT INTO chado.dbxref VALUES (2415, 24, '0001827', '', NULL);
INSERT INTO chado.dbxref VALUES (2416, 24, '0001828', '', NULL);
INSERT INTO chado.dbxref VALUES (2417, 24, '0001829', '', NULL);
INSERT INTO chado.dbxref VALUES (2418, 24, '0001830', '', NULL);
INSERT INTO chado.dbxref VALUES (2419, 24, '0001831', '', NULL);
INSERT INTO chado.dbxref VALUES (2420, 24, '0001832', '', NULL);
INSERT INTO chado.dbxref VALUES (2421, 24, '0001833', '', NULL);
INSERT INTO chado.dbxref VALUES (2422, 24, '0001834', '', NULL);
INSERT INTO chado.dbxref VALUES (2423, 24, '0001835', '', NULL);
INSERT INTO chado.dbxref VALUES (2424, 24, '0001836', '', NULL);
INSERT INTO chado.dbxref VALUES (2425, 24, '0001837', '', NULL);
INSERT INTO chado.dbxref VALUES (2426, 24, '0001838', '', NULL);
INSERT INTO chado.dbxref VALUES (2427, 24, '0001839', '', NULL);
INSERT INTO chado.dbxref VALUES (2428, 24, '0001840', '', NULL);
INSERT INTO chado.dbxref VALUES (2429, 24, '0001841', '', NULL);
INSERT INTO chado.dbxref VALUES (2430, 24, '0001842', '', NULL);
INSERT INTO chado.dbxref VALUES (2431, 24, '0001843', '', NULL);
INSERT INTO chado.dbxref VALUES (2432, 24, '0001900', '', NULL);
INSERT INTO chado.dbxref VALUES (2433, 24, '0001844', '', NULL);
INSERT INTO chado.dbxref VALUES (2434, 24, '0001845', '', NULL);
INSERT INTO chado.dbxref VALUES (2435, 24, '0001846', '', NULL);
INSERT INTO chado.dbxref VALUES (2436, 24, '0001847', '', NULL);
INSERT INTO chado.dbxref VALUES (2437, 24, '0001848', '', NULL);
INSERT INTO chado.dbxref VALUES (2438, 24, '0001849', '', NULL);
INSERT INTO chado.dbxref VALUES (2439, 24, '0001850', '', NULL);
INSERT INTO chado.dbxref VALUES (2440, 24, '0001851', '', NULL);
INSERT INTO chado.dbxref VALUES (2441, 24, '0001852', '', NULL);
INSERT INTO chado.dbxref VALUES (2442, 24, '0001853', '', NULL);
INSERT INTO chado.dbxref VALUES (2443, 24, '0001854', '', NULL);
INSERT INTO chado.dbxref VALUES (2444, 24, '0001855', '', NULL);
INSERT INTO chado.dbxref VALUES (2445, 24, '0001856', '', NULL);
INSERT INTO chado.dbxref VALUES (2446, 24, '0001857', '', NULL);
INSERT INTO chado.dbxref VALUES (2447, 24, '0001858', '', NULL);
INSERT INTO chado.dbxref VALUES (2448, 24, '0001859', '', NULL);
INSERT INTO chado.dbxref VALUES (2449, 24, '0001860', '', NULL);
INSERT INTO chado.dbxref VALUES (2450, 24, '0001861', '', NULL);
INSERT INTO chado.dbxref VALUES (2451, 24, '0001862', '', NULL);
INSERT INTO chado.dbxref VALUES (2452, 24, '0001863', '', NULL);
INSERT INTO chado.dbxref VALUES (2453, 24, '0001864', '', NULL);
INSERT INTO chado.dbxref VALUES (2454, 24, '0001865', '', NULL);
INSERT INTO chado.dbxref VALUES (2455, 24, '0001866', '', NULL);
INSERT INTO chado.dbxref VALUES (2456, 24, '0001867', '', NULL);
INSERT INTO chado.dbxref VALUES (2457, 24, '0001868', '', NULL);
INSERT INTO chado.dbxref VALUES (2458, 24, '0001869', '', NULL);
INSERT INTO chado.dbxref VALUES (2459, 24, '0001870', '', NULL);
INSERT INTO chado.dbxref VALUES (2460, 24, '0001871', '', NULL);
INSERT INTO chado.dbxref VALUES (2461, 24, '0001872', '', NULL);
INSERT INTO chado.dbxref VALUES (2462, 24, '0001873', '', NULL);
INSERT INTO chado.dbxref VALUES (2463, 24, '0001874', '', NULL);
INSERT INTO chado.dbxref VALUES (2464, 24, '0001875', '', NULL);
INSERT INTO chado.dbxref VALUES (2465, 24, '0001879', '', NULL);
INSERT INTO chado.dbxref VALUES (2466, 24, '0001880', '', NULL);
INSERT INTO chado.dbxref VALUES (2467, 24, '0001881', '', NULL);
INSERT INTO chado.dbxref VALUES (2468, 24, '0001883', '', NULL);
INSERT INTO chado.dbxref VALUES (2469, 24, '0001884', '', NULL);
INSERT INTO chado.dbxref VALUES (2470, 24, '0001885', '', NULL);
INSERT INTO chado.dbxref VALUES (2471, 24, '0001886', '', NULL);
INSERT INTO chado.dbxref VALUES (2472, 24, '0001887', '', NULL);
INSERT INTO chado.dbxref VALUES (2473, 24, '0001888', '', NULL);
INSERT INTO chado.dbxref VALUES (2474, 24, '0001889', '', NULL);
INSERT INTO chado.dbxref VALUES (2475, 24, '0001890', '', NULL);
INSERT INTO chado.dbxref VALUES (2476, 24, '0001891', '', NULL);
INSERT INTO chado.dbxref VALUES (2477, 24, '0001892', '', NULL);
INSERT INTO chado.dbxref VALUES (2478, 24, '0001893', '', NULL);
INSERT INTO chado.dbxref VALUES (2479, 24, '0001894', '', NULL);
INSERT INTO chado.dbxref VALUES (2480, 24, '0001895', '', NULL);
INSERT INTO chado.dbxref VALUES (2481, 24, '0001896', '', NULL);
INSERT INTO chado.dbxref VALUES (2482, 24, '0001897', '', NULL);
INSERT INTO chado.dbxref VALUES (2483, 24, '0001898', '', NULL);
INSERT INTO chado.dbxref VALUES (2484, 24, '0001899', '', NULL);
INSERT INTO chado.dbxref VALUES (2485, 24, '0001901', '', NULL);
INSERT INTO chado.dbxref VALUES (2486, 24, '0001902', '', NULL);
INSERT INTO chado.dbxref VALUES (2487, 24, '0001904', '', NULL);
INSERT INTO chado.dbxref VALUES (2488, 24, '0001905', '', NULL);
INSERT INTO chado.dbxref VALUES (2489, 24, '0001909', '', NULL);
INSERT INTO chado.dbxref VALUES (2490, 24, '0001910', '', NULL);
INSERT INTO chado.dbxref VALUES (2491, 24, '0001911', '', NULL);
INSERT INTO chado.dbxref VALUES (2492, 24, '0001912', '', NULL);
INSERT INTO chado.dbxref VALUES (2493, 24, '0001914', '', NULL);
INSERT INTO chado.dbxref VALUES (2494, 24, '0001915', '', NULL);
INSERT INTO chado.dbxref VALUES (2495, 24, '0001916', '', NULL);
INSERT INTO chado.dbxref VALUES (2496, 24, '0001917', '', NULL);
INSERT INTO chado.dbxref VALUES (2497, 24, '0001918', '', NULL);
INSERT INTO chado.dbxref VALUES (2498, 24, '0001919', '', NULL);
INSERT INTO chado.dbxref VALUES (2499, 24, '0001920', '', NULL);
INSERT INTO chado.dbxref VALUES (2500, 24, '0001921', '', NULL);
INSERT INTO chado.dbxref VALUES (2501, 24, '0001922', '', NULL);
INSERT INTO chado.dbxref VALUES (2502, 24, '0001923', '', NULL);
INSERT INTO chado.dbxref VALUES (2503, 24, '0001927', '', NULL);
INSERT INTO chado.dbxref VALUES (2504, 24, '0001924', '', NULL);
INSERT INTO chado.dbxref VALUES (2505, 24, '0001925', '', NULL);
INSERT INTO chado.dbxref VALUES (2506, 24, '0001926', '', NULL);
INSERT INTO chado.dbxref VALUES (2507, 24, '0001928', '', NULL);
INSERT INTO chado.dbxref VALUES (2508, 24, '1000035', '', NULL);
INSERT INTO chado.dbxref VALUES (2509, 24, '0001929', '', NULL);
INSERT INTO chado.dbxref VALUES (2510, 24, '0001930', '', NULL);
INSERT INTO chado.dbxref VALUES (2511, 24, '0001931', '', NULL);
INSERT INTO chado.dbxref VALUES (2512, 24, '0001932', '', NULL);
INSERT INTO chado.dbxref VALUES (2513, 24, '0001933', '', NULL);
INSERT INTO chado.dbxref VALUES (2514, 24, '0001934', '', NULL);
INSERT INTO chado.dbxref VALUES (2515, 24, '0001935', '', NULL);
INSERT INTO chado.dbxref VALUES (2516, 24, '0001936', '', NULL);
INSERT INTO chado.dbxref VALUES (2517, 24, '0001937', '', NULL);
INSERT INTO chado.dbxref VALUES (2518, 24, '0002143', '', NULL);
INSERT INTO chado.dbxref VALUES (2519, 24, '0001938', '', NULL);
INSERT INTO chado.dbxref VALUES (2520, 24, '0002142', '', NULL);
INSERT INTO chado.dbxref VALUES (2521, 24, '0001939', '', NULL);
INSERT INTO chado.dbxref VALUES (2522, 24, '0001940', '', NULL);
INSERT INTO chado.dbxref VALUES (2523, 24, '0001941', '', NULL);
INSERT INTO chado.dbxref VALUES (2524, 24, '0001942', '', NULL);
INSERT INTO chado.dbxref VALUES (2525, 24, '0001943', '', NULL);
INSERT INTO chado.dbxref VALUES (2526, 24, '0001944', '', NULL);
INSERT INTO chado.dbxref VALUES (2527, 24, '0001945', '', NULL);
INSERT INTO chado.dbxref VALUES (2528, 24, '0001946', '', NULL);
INSERT INTO chado.dbxref VALUES (2529, 24, '0001947', '', NULL);
INSERT INTO chado.dbxref VALUES (2530, 24, '0001948', '', NULL);
INSERT INTO chado.dbxref VALUES (2531, 24, '0001949', '', NULL);
INSERT INTO chado.dbxref VALUES (2532, 24, '0001950', '', NULL);
INSERT INTO chado.dbxref VALUES (2533, 24, '0001951', '', NULL);
INSERT INTO chado.dbxref VALUES (2534, 24, '0001952', '', NULL);
INSERT INTO chado.dbxref VALUES (2535, 24, '0001953', '', NULL);
INSERT INTO chado.dbxref VALUES (2536, 24, '0001955', '', NULL);
INSERT INTO chado.dbxref VALUES (2537, 24, '0001956', '', NULL);
INSERT INTO chado.dbxref VALUES (2538, 24, '0001957', '', NULL);
INSERT INTO chado.dbxref VALUES (2539, 24, '0001958', '', NULL);
INSERT INTO chado.dbxref VALUES (2540, 24, '0001959', '', NULL);
INSERT INTO chado.dbxref VALUES (2541, 24, '0001960', '', NULL);
INSERT INTO chado.dbxref VALUES (2542, 24, '0001961', '', NULL);
INSERT INTO chado.dbxref VALUES (2543, 24, '0001964', '', NULL);
INSERT INTO chado.dbxref VALUES (2544, 24, '0001965', '', NULL);
INSERT INTO chado.dbxref VALUES (2545, 24, '0001966', '', NULL);
INSERT INTO chado.dbxref VALUES (2546, 24, '0001967', '', NULL);
INSERT INTO chado.dbxref VALUES (2547, 24, '0001969', '', NULL);
INSERT INTO chado.dbxref VALUES (2548, 24, '0001970', '', NULL);
INSERT INTO chado.dbxref VALUES (2549, 24, '0001971', '', NULL);
INSERT INTO chado.dbxref VALUES (2550, 24, '0001974', '', NULL);
INSERT INTO chado.dbxref VALUES (2551, 24, '0001975', '', NULL);
INSERT INTO chado.dbxref VALUES (2552, 24, '0001976', '', NULL);
INSERT INTO chado.dbxref VALUES (2553, 24, '0001977', '', NULL);
INSERT INTO chado.dbxref VALUES (2554, 24, '0001978', '', NULL);
INSERT INTO chado.dbxref VALUES (2555, 24, '0001979', '', NULL);
INSERT INTO chado.dbxref VALUES (2556, 24, '0001980', '', NULL);
INSERT INTO chado.dbxref VALUES (2557, 24, '0001981', '', NULL);
INSERT INTO chado.dbxref VALUES (2558, 24, '0001982', '', NULL);
INSERT INTO chado.dbxref VALUES (2559, 24, '0001983', '', NULL);
INSERT INTO chado.dbxref VALUES (2560, 24, '0001984', '', NULL);
INSERT INTO chado.dbxref VALUES (2561, 24, '0005854', '', NULL);
INSERT INTO chado.dbxref VALUES (2562, 24, '0001985', '', NULL);
INSERT INTO chado.dbxref VALUES (2563, 24, '0001986', '', NULL);
INSERT INTO chado.dbxref VALUES (2564, 24, '0001987', '', NULL);
INSERT INTO chado.dbxref VALUES (2565, 24, '0001988', '', NULL);
INSERT INTO chado.dbxref VALUES (2566, 24, '0001989', '', NULL);
INSERT INTO chado.dbxref VALUES (2567, 24, '0001990', '', NULL);
INSERT INTO chado.dbxref VALUES (2568, 24, '0001991', '', NULL);
INSERT INTO chado.dbxref VALUES (2569, 24, '0001993', '', NULL);
INSERT INTO chado.dbxref VALUES (2570, 24, '0001994', '', NULL);
INSERT INTO chado.dbxref VALUES (2571, 24, '0001995', '', NULL);
INSERT INTO chado.dbxref VALUES (2572, 24, '0001996', '', NULL);
INSERT INTO chado.dbxref VALUES (2573, 24, '0001997', '', NULL);
INSERT INTO chado.dbxref VALUES (2574, 24, '0001998', '', NULL);
INSERT INTO chado.dbxref VALUES (2575, 24, '0001999', '', NULL);
INSERT INTO chado.dbxref VALUES (2576, 24, '0002001', '', NULL);
INSERT INTO chado.dbxref VALUES (2577, 24, '0002002', '', NULL);
INSERT INTO chado.dbxref VALUES (2578, 24, '0002003', '', NULL);
INSERT INTO chado.dbxref VALUES (2579, 24, '0002004', '', NULL);
INSERT INTO chado.dbxref VALUES (2580, 24, '0002005', '', NULL);
INSERT INTO chado.dbxref VALUES (2581, 24, '0002006', '', NULL);
INSERT INTO chado.dbxref VALUES (2582, 24, '0002008', '', NULL);
INSERT INTO chado.dbxref VALUES (2583, 24, '0002009', '', NULL);
INSERT INTO chado.dbxref VALUES (2584, 24, '0002010', '', NULL);
INSERT INTO chado.dbxref VALUES (2585, 24, '0002011', '', NULL);
INSERT INTO chado.dbxref VALUES (2586, 24, '0002012', '', NULL);
INSERT INTO chado.dbxref VALUES (2587, 24, '0002013', '', NULL);
INSERT INTO chado.dbxref VALUES (2588, 24, '0002014', '', NULL);
INSERT INTO chado.dbxref VALUES (2589, 24, '0002015', '', NULL);
INSERT INTO chado.dbxref VALUES (2590, 24, '0002016', '', NULL);
INSERT INTO chado.dbxref VALUES (2591, 24, '0002017', '', NULL);
INSERT INTO chado.dbxref VALUES (2592, 24, '0002018', '', NULL);
INSERT INTO chado.dbxref VALUES (2593, 24, '0002019', '', NULL);
INSERT INTO chado.dbxref VALUES (2594, 24, '0002020', '', NULL);
INSERT INTO chado.dbxref VALUES (2595, 24, '0002021', '', NULL);
INSERT INTO chado.dbxref VALUES (2596, 24, '0002022', '', NULL);
INSERT INTO chado.dbxref VALUES (2597, 24, '0002023', '', NULL);
INSERT INTO chado.dbxref VALUES (2598, 24, '0002024', '', NULL);
INSERT INTO chado.dbxref VALUES (2599, 24, '0002000', '', NULL);
INSERT INTO chado.dbxref VALUES (2600, 24, '0002025', '', NULL);
INSERT INTO chado.dbxref VALUES (2601, 24, '0002026', '', NULL);
INSERT INTO chado.dbxref VALUES (2602, 24, '0002027', '', NULL);
INSERT INTO chado.dbxref VALUES (2603, 18, '26684391', '', NULL);
INSERT INTO chado.dbxref VALUES (2604, 24, '0002028', '', NULL);
INSERT INTO chado.dbxref VALUES (2605, 24, '0002029', '', NULL);
INSERT INTO chado.dbxref VALUES (2606, 24, '0002030', '', NULL);
INSERT INTO chado.dbxref VALUES (2607, 24, '0002031', '', NULL);
INSERT INTO chado.dbxref VALUES (2608, 24, '0002032', '', NULL);
INSERT INTO chado.dbxref VALUES (2609, 24, '0002033', '', NULL);
INSERT INTO chado.dbxref VALUES (2610, 24, '0002034', '', NULL);
INSERT INTO chado.dbxref VALUES (2611, 24, '0002035', '', NULL);
INSERT INTO chado.dbxref VALUES (2612, 24, '0002036', '', NULL);
INSERT INTO chado.dbxref VALUES (2613, 24, '0002037', '', NULL);
INSERT INTO chado.dbxref VALUES (2614, 24, '0002038', '', NULL);
INSERT INTO chado.dbxref VALUES (2615, 24, '0002039', '', NULL);
INSERT INTO chado.dbxref VALUES (2616, 24, '0002040', '', NULL);
INSERT INTO chado.dbxref VALUES (2617, 24, '0002041', '', NULL);
INSERT INTO chado.dbxref VALUES (2618, 24, '0002042', '', NULL);
INSERT INTO chado.dbxref VALUES (2619, 24, '0002043', '', NULL);
INSERT INTO chado.dbxref VALUES (2620, 24, '0002044', '', NULL);
INSERT INTO chado.dbxref VALUES (2621, 24, '0002045', '', NULL);
INSERT INTO chado.dbxref VALUES (2622, 24, '0002046', '', NULL);
INSERT INTO chado.dbxref VALUES (2623, 24, '0002047', '', NULL);
INSERT INTO chado.dbxref VALUES (2624, 24, '0002048', '', NULL);
INSERT INTO chado.dbxref VALUES (2625, 24, '0002049', '', NULL);
INSERT INTO chado.dbxref VALUES (2626, 24, '0002050', '', NULL);
INSERT INTO chado.dbxref VALUES (2627, 24, '0002051', '', NULL);
INSERT INTO chado.dbxref VALUES (2628, 24, '0002052', '', NULL);
INSERT INTO chado.dbxref VALUES (2629, 24, '0002053', '', NULL);
INSERT INTO chado.dbxref VALUES (2630, 24, '0002054', '', NULL);
INSERT INTO chado.dbxref VALUES (2631, 24, '0002055', '', NULL);
INSERT INTO chado.dbxref VALUES (2632, 24, '0002056', '', NULL);
INSERT INTO chado.dbxref VALUES (2633, 24, '0002057', '', NULL);
INSERT INTO chado.dbxref VALUES (2634, 24, '0002058', '', NULL);
INSERT INTO chado.dbxref VALUES (2635, 24, '0002059', '', NULL);
INSERT INTO chado.dbxref VALUES (2636, 24, '0002060', '', NULL);
INSERT INTO chado.dbxref VALUES (2637, 24, '0002061', '', NULL);
INSERT INTO chado.dbxref VALUES (2638, 24, '0002062', '', NULL);
INSERT INTO chado.dbxref VALUES (2639, 24, '0002063', '', NULL);
INSERT INTO chado.dbxref VALUES (2640, 24, '0002064', '', NULL);
INSERT INTO chado.dbxref VALUES (2641, 24, '0002272', '', NULL);
INSERT INTO chado.dbxref VALUES (2642, 24, '0002065', '', NULL);
INSERT INTO chado.dbxref VALUES (2643, 24, '0002066', '', NULL);
INSERT INTO chado.dbxref VALUES (2644, 24, '0002067', '', NULL);
INSERT INTO chado.dbxref VALUES (2645, 24, '0002268', '', NULL);
INSERT INTO chado.dbxref VALUES (2646, 24, '0002068', '', NULL);
INSERT INTO chado.dbxref VALUES (2647, 24, '0002069', '', NULL);
INSERT INTO chado.dbxref VALUES (2648, 24, '0002070', '', NULL);
INSERT INTO chado.dbxref VALUES (2649, 24, '0002071', '', NULL);
INSERT INTO chado.dbxref VALUES (2650, 24, '1001251', '', NULL);
INSERT INTO chado.dbxref VALUES (2651, 24, '0002073', '', NULL);
INSERT INTO chado.dbxref VALUES (2652, 24, '0002074', '', NULL);
INSERT INTO chado.dbxref VALUES (2653, 24, '0002075', '', NULL);
INSERT INTO chado.dbxref VALUES (2654, 24, '0002076', '', NULL);
INSERT INTO chado.dbxref VALUES (2655, 24, '0002077', '', NULL);
INSERT INTO chado.dbxref VALUES (2656, 24, '0002078', '', NULL);
INSERT INTO chado.dbxref VALUES (2657, 24, '0002079', '', NULL);
INSERT INTO chado.dbxref VALUES (2658, 24, '0002080', '', NULL);
INSERT INTO chado.dbxref VALUES (2659, 24, '0002081', '', NULL);
INSERT INTO chado.dbxref VALUES (2660, 24, '0002082', '', NULL);
INSERT INTO chado.dbxref VALUES (2661, 24, '0002083', '', NULL);
INSERT INTO chado.dbxref VALUES (2662, 24, '0002084', '', NULL);
INSERT INTO chado.dbxref VALUES (2663, 24, '0002085', '', NULL);
INSERT INTO chado.dbxref VALUES (2664, 24, '0002086', '', NULL);
INSERT INTO chado.dbxref VALUES (2665, 24, '0002087', '', NULL);
INSERT INTO chado.dbxref VALUES (2666, 24, '0002088', '', NULL);
INSERT INTO chado.dbxref VALUES (2667, 24, '0002089', '', NULL);
INSERT INTO chado.dbxref VALUES (2668, 24, '0002090', '', NULL);
INSERT INTO chado.dbxref VALUES (2669, 24, '0002091', '', NULL);
INSERT INTO chado.dbxref VALUES (2670, 24, '0002092', '', NULL);
INSERT INTO chado.dbxref VALUES (2671, 24, '0002093', '', NULL);
INSERT INTO chado.dbxref VALUES (2672, 24, '0002094', '', NULL);
INSERT INTO chado.dbxref VALUES (2673, 24, '0002095', '', NULL);
INSERT INTO chado.dbxref VALUES (2674, 24, '0002096', '', NULL);
INSERT INTO chado.dbxref VALUES (2675, 24, '0002097', '', NULL);
INSERT INTO chado.dbxref VALUES (2676, 24, '0002098', '', NULL);
INSERT INTO chado.dbxref VALUES (2677, 24, '0002099', '', NULL);
INSERT INTO chado.dbxref VALUES (2678, 24, '0002100', '', NULL);
INSERT INTO chado.dbxref VALUES (2679, 24, '0002101', '', NULL);
INSERT INTO chado.dbxref VALUES (2680, 24, '0002102', '', NULL);
INSERT INTO chado.dbxref VALUES (2681, 24, '0002103', '', NULL);
INSERT INTO chado.dbxref VALUES (2682, 24, '0002104', '', NULL);
INSERT INTO chado.dbxref VALUES (2683, 24, '0002105', '', NULL);
INSERT INTO chado.dbxref VALUES (2684, 24, '0002106', '', NULL);
INSERT INTO chado.dbxref VALUES (2685, 24, '0002107', '', NULL);
INSERT INTO chado.dbxref VALUES (2686, 24, '0002108', '', NULL);
INSERT INTO chado.dbxref VALUES (2687, 24, '0002109', '', NULL);
INSERT INTO chado.dbxref VALUES (2688, 24, '0002110', '', NULL);
INSERT INTO chado.dbxref VALUES (2689, 24, '0002111', '', NULL);
INSERT INTO chado.dbxref VALUES (2690, 24, '0002112', '', NULL);
INSERT INTO chado.dbxref VALUES (2691, 24, '0002113', '', NULL);
INSERT INTO chado.dbxref VALUES (2692, 24, '0002114', '', NULL);
INSERT INTO chado.dbxref VALUES (2693, 24, '0002115', '', NULL);
INSERT INTO chado.dbxref VALUES (2694, 24, '0002116', '', NULL);
INSERT INTO chado.dbxref VALUES (2695, 24, '0002117', '', NULL);
INSERT INTO chado.dbxref VALUES (2696, 24, '0002118', '', NULL);
INSERT INTO chado.dbxref VALUES (2697, 24, '0002119', '', NULL);
INSERT INTO chado.dbxref VALUES (2698, 38, 'Allele_frequency', '', NULL);
INSERT INTO chado.dbxref VALUES (2699, 24, '0002120', '', NULL);
INSERT INTO chado.dbxref VALUES (2700, 24, '0002121', '', NULL);
INSERT INTO chado.dbxref VALUES (2701, 24, '0002122', '', NULL);
INSERT INTO chado.dbxref VALUES (2702, 24, '0002123', '', NULL);
INSERT INTO chado.dbxref VALUES (2703, 24, '0002124', '', NULL);
INSERT INTO chado.dbxref VALUES (2704, 24, '0002125', '', NULL);
INSERT INTO chado.dbxref VALUES (2705, 24, '0002126', '', NULL);
INSERT INTO chado.dbxref VALUES (2706, 24, '0002128', '', NULL);
INSERT INTO chado.dbxref VALUES (2707, 24, '0002129', '', NULL);
INSERT INTO chado.dbxref VALUES (2708, 24, '0002130', '', NULL);
INSERT INTO chado.dbxref VALUES (2709, 24, '0002131', '', NULL);
INSERT INTO chado.dbxref VALUES (2710, 24, '0001903', '', NULL);
INSERT INTO chado.dbxref VALUES (2711, 24, '0002132', '', NULL);
INSERT INTO chado.dbxref VALUES (2712, 24, '0002133', '', NULL);
INSERT INTO chado.dbxref VALUES (2713, 24, '0002134', '', NULL);
INSERT INTO chado.dbxref VALUES (2714, 24, '0002135', '', NULL);
INSERT INTO chado.dbxref VALUES (2715, 24, '0002136', '', NULL);
INSERT INTO chado.dbxref VALUES (2716, 24, '0002137', '', NULL);
INSERT INTO chado.dbxref VALUES (2717, 24, '0002138', '', NULL);
INSERT INTO chado.dbxref VALUES (2718, 24, '0002139', '', NULL);
INSERT INTO chado.dbxref VALUES (2719, 24, '0002140', '', NULL);
INSERT INTO chado.dbxref VALUES (2720, 24, '0002141', '', NULL);
INSERT INTO chado.dbxref VALUES (2721, 24, '0002144', '', NULL);
INSERT INTO chado.dbxref VALUES (2722, 24, '0002145', '', NULL);
INSERT INTO chado.dbxref VALUES (2723, 24, '0002146', '', NULL);
INSERT INTO chado.dbxref VALUES (2724, 24, '0002147', '', NULL);
INSERT INTO chado.dbxref VALUES (2725, 24, '0002148', '', NULL);
INSERT INTO chado.dbxref VALUES (2726, 24, '0002149', '', NULL);
INSERT INTO chado.dbxref VALUES (2727, 24, '0002150', '', NULL);
INSERT INTO chado.dbxref VALUES (2728, 24, '0002151', '', NULL);
INSERT INTO chado.dbxref VALUES (2729, 24, '0002152', '', NULL);
INSERT INTO chado.dbxref VALUES (2730, 24, '0002153', '', NULL);
INSERT INTO chado.dbxref VALUES (2731, 24, '0002154', '', NULL);
INSERT INTO chado.dbxref VALUES (2732, 24, '0002155', '', NULL);
INSERT INTO chado.dbxref VALUES (2733, 24, '0002156', '', NULL);
INSERT INTO chado.dbxref VALUES (2734, 24, '0002157', '', NULL);
INSERT INTO chado.dbxref VALUES (2735, 24, '0002158', '', NULL);
INSERT INTO chado.dbxref VALUES (2736, 24, '0002159', '', NULL);
INSERT INTO chado.dbxref VALUES (2737, 24, '0002161', '', NULL);
INSERT INTO chado.dbxref VALUES (2738, 24, '0002162', '', NULL);
INSERT INTO chado.dbxref VALUES (2739, 24, '0002163', '', NULL);
INSERT INTO chado.dbxref VALUES (2740, 24, '0002164', '', NULL);
INSERT INTO chado.dbxref VALUES (2741, 24, '0002165', '', NULL);
INSERT INTO chado.dbxref VALUES (2742, 24, '0002166', '', NULL);
INSERT INTO chado.dbxref VALUES (2743, 24, '0002167', '', NULL);
INSERT INTO chado.dbxref VALUES (2744, 24, '0002168', '', NULL);
INSERT INTO chado.dbxref VALUES (2745, 39, '//en.wikipedia.org/wiki/RNA_thermometer', '', NULL);
INSERT INTO chado.dbxref VALUES (2746, 24, '0002169', '', NULL);
INSERT INTO chado.dbxref VALUES (2747, 24, '0002170', '', NULL);
INSERT INTO chado.dbxref VALUES (2748, 24, '0002171', '', NULL);
INSERT INTO chado.dbxref VALUES (2749, 24, '0002172', '', NULL);
INSERT INTO chado.dbxref VALUES (2750, 24, '0002173', '', NULL);
INSERT INTO chado.dbxref VALUES (2751, 24, '0002174', '', NULL);
INSERT INTO chado.dbxref VALUES (2752, 24, '0002175', '', NULL);
INSERT INTO chado.dbxref VALUES (2753, 24, '0002176', '', NULL);
INSERT INTO chado.dbxref VALUES (2754, 24, '0002177', '', NULL);
INSERT INTO chado.dbxref VALUES (2755, 24, '0002178', '', NULL);
INSERT INTO chado.dbxref VALUES (2756, 24, '0002179', '', NULL);
INSERT INTO chado.dbxref VALUES (2757, 24, '0002181', '', NULL);
INSERT INTO chado.dbxref VALUES (2758, 24, '0002182', '', NULL);
INSERT INTO chado.dbxref VALUES (2759, 24, '0002183', '', NULL);
INSERT INTO chado.dbxref VALUES (2760, 24, '0002184', '', NULL);
INSERT INTO chado.dbxref VALUES (2761, 24, '0002185', '', NULL);
INSERT INTO chado.dbxref VALUES (2762, 24, '0002186', '', NULL);
INSERT INTO chado.dbxref VALUES (2763, 24, '0002187', '', NULL);
INSERT INTO chado.dbxref VALUES (2764, 24, '0002188', '', NULL);
INSERT INTO chado.dbxref VALUES (2765, 24, '0002189', '', NULL);
INSERT INTO chado.dbxref VALUES (2766, 24, '0002190', '', NULL);
INSERT INTO chado.dbxref VALUES (2767, 24, '0002191', '', NULL);
INSERT INTO chado.dbxref VALUES (2768, 24, '0002192', '', NULL);
INSERT INTO chado.dbxref VALUES (2769, 24, '0002193', '', NULL);
INSERT INTO chado.dbxref VALUES (2770, 24, '0002194', '', NULL);
INSERT INTO chado.dbxref VALUES (2771, 24, '0002195', '', NULL);
INSERT INTO chado.dbxref VALUES (2772, 24, '0002196', '', NULL);
INSERT INTO chado.dbxref VALUES (2773, 24, '0002197', '', NULL);
INSERT INTO chado.dbxref VALUES (2774, 24, '0002198', '', NULL);
INSERT INTO chado.dbxref VALUES (2775, 24, '0002199', '', NULL);
INSERT INTO chado.dbxref VALUES (2776, 24, '0002200', '', NULL);
INSERT INTO chado.dbxref VALUES (2777, 24, '0002201', '', NULL);
INSERT INTO chado.dbxref VALUES (2778, 24, '0002202', '', NULL);
INSERT INTO chado.dbxref VALUES (2779, 24, '0002203', '', NULL);
INSERT INTO chado.dbxref VALUES (2780, 24, '0002205', '', NULL);
INSERT INTO chado.dbxref VALUES (2781, 24, '0002206', '', NULL);
INSERT INTO chado.dbxref VALUES (2782, 24, '0002207', '', NULL);
INSERT INTO chado.dbxref VALUES (2783, 24, '0002208', '', NULL);
INSERT INTO chado.dbxref VALUES (2784, 24, '0002209', '', NULL);
INSERT INTO chado.dbxref VALUES (2785, 24, '0002210', '', NULL);
INSERT INTO chado.dbxref VALUES (2786, 24, '0002211', '', NULL);
INSERT INTO chado.dbxref VALUES (2787, 24, '0002212', '', NULL);
INSERT INTO chado.dbxref VALUES (2788, 24, '0002213', '', NULL);
INSERT INTO chado.dbxref VALUES (2789, 24, '0002214', '', NULL);
INSERT INTO chado.dbxref VALUES (2790, 24, '0002215', '', NULL);
INSERT INTO chado.dbxref VALUES (2791, 24, '0002216', '', NULL);
INSERT INTO chado.dbxref VALUES (2792, 24, '0002217', '', NULL);
INSERT INTO chado.dbxref VALUES (2793, 24, '0002219', '', NULL);
INSERT INTO chado.dbxref VALUES (2794, 24, '0002220', '', NULL);
INSERT INTO chado.dbxref VALUES (2795, 24, '0002223', '', NULL);
INSERT INTO chado.dbxref VALUES (2796, 40, '10.1101/584664', '', NULL);
INSERT INTO chado.dbxref VALUES (2797, 24, '0002224', '', NULL);
INSERT INTO chado.dbxref VALUES (2798, 24, '0002225', '', NULL);
INSERT INTO chado.dbxref VALUES (2799, 24, '0002226', '', NULL);
INSERT INTO chado.dbxref VALUES (2800, 24, '0002227', '', NULL);
INSERT INTO chado.dbxref VALUES (2801, 24, '0002230', '', NULL);
INSERT INTO chado.dbxref VALUES (2802, 24, '0002231', '', NULL);
INSERT INTO chado.dbxref VALUES (2803, 24, '0002232', '', NULL);
INSERT INTO chado.dbxref VALUES (2804, 24, '0002233', '', NULL);
INSERT INTO chado.dbxref VALUES (2805, 24, '0002234', '', NULL);
INSERT INTO chado.dbxref VALUES (2806, 24, '0002235', '', NULL);
INSERT INTO chado.dbxref VALUES (2807, 24, '0002362', '', NULL);
INSERT INTO chado.dbxref VALUES (2808, 24, '0002361', '', NULL);
INSERT INTO chado.dbxref VALUES (2809, 24, '0002241', '', NULL);
INSERT INTO chado.dbxref VALUES (2810, 24, '0002244', '', NULL);
INSERT INTO chado.dbxref VALUES (2811, 24, '0002245', '', NULL);
INSERT INTO chado.dbxref VALUES (2812, 24, '0002246', '', NULL);
INSERT INTO chado.dbxref VALUES (2813, 24, '0002248', '', NULL);
INSERT INTO chado.dbxref VALUES (2814, 24, '0002253', '', NULL);
INSERT INTO chado.dbxref VALUES (2815, 24, '0002254', '', NULL);
INSERT INTO chado.dbxref VALUES (2816, 24, '0002255', '', NULL);
INSERT INTO chado.dbxref VALUES (2817, 24, '0002256', '', NULL);
INSERT INTO chado.dbxref VALUES (2818, 24, '0002257', '', NULL);
INSERT INTO chado.dbxref VALUES (2819, 24, '0002258', '', NULL);
INSERT INTO chado.dbxref VALUES (2820, 24, '0002259', '', NULL);
INSERT INTO chado.dbxref VALUES (2821, 24, '0002260', '', NULL);
INSERT INTO chado.dbxref VALUES (2822, 24, '0002261', '', NULL);
INSERT INTO chado.dbxref VALUES (2823, 24, '0002262', '', NULL);
INSERT INTO chado.dbxref VALUES (2824, 24, '0002263', '', NULL);
INSERT INTO chado.dbxref VALUES (2825, 24, '0002264', '', NULL);
INSERT INTO chado.dbxref VALUES (2826, 24, '0002265', '', NULL);
INSERT INTO chado.dbxref VALUES (2827, 24, '0002266', '', NULL);
INSERT INTO chado.dbxref VALUES (2828, 24, '0002267', '', NULL);
INSERT INTO chado.dbxref VALUES (2829, 24, '0002269', '', NULL);
INSERT INTO chado.dbxref VALUES (2830, 24, '0002270', '', NULL);
INSERT INTO chado.dbxref VALUES (2831, 24, '0002271', '', NULL);
INSERT INTO chado.dbxref VALUES (2832, 24, '0002273', '', NULL);
INSERT INTO chado.dbxref VALUES (2833, 39, '//www.sciencedirect.com/topics/biochemistry-genetics-and-molecular-biology/long-interspersed-nuclear-element', '', NULL);
INSERT INTO chado.dbxref VALUES (2834, 24, '0002274', '', NULL);
INSERT INTO chado.dbxref VALUES (2835, 24, '0002275', '', NULL);
INSERT INTO chado.dbxref VALUES (2836, 24, '0002276', '', NULL);
INSERT INTO chado.dbxref VALUES (2837, 24, '0002277', '', NULL);
INSERT INTO chado.dbxref VALUES (2838, 24, '0002278', '', NULL);
INSERT INTO chado.dbxref VALUES (2839, 24, '0002279', '', NULL);
INSERT INTO chado.dbxref VALUES (2840, 24, '0002280', '', NULL);
INSERT INTO chado.dbxref VALUES (2841, 24, '0002281', '', NULL);
INSERT INTO chado.dbxref VALUES (2842, 24, '0002282', '', NULL);
INSERT INTO chado.dbxref VALUES (2843, 24, '0002283', '', NULL);
INSERT INTO chado.dbxref VALUES (2844, 24, '0002284', '', NULL);
INSERT INTO chado.dbxref VALUES (2845, 24, '0002285', '', NULL);
INSERT INTO chado.dbxref VALUES (2846, 24, '0002286', '', NULL);
INSERT INTO chado.dbxref VALUES (2847, 24, '0002287', '', NULL);
INSERT INTO chado.dbxref VALUES (2848, 24, '0002288', '', NULL);
INSERT INTO chado.dbxref VALUES (2849, 24, '0002289', '', NULL);
INSERT INTO chado.dbxref VALUES (2850, 24, '0002290', '', NULL);
INSERT INTO chado.dbxref VALUES (2851, 24, '0002291', '', NULL);
INSERT INTO chado.dbxref VALUES (2852, 24, '0002292', '', NULL);
INSERT INTO chado.dbxref VALUES (2853, 24, '0002293', '', NULL);
INSERT INTO chado.dbxref VALUES (2854, 39, '//en.wikipedia.org/wiki/MtDNA_control_region', '', NULL);
INSERT INTO chado.dbxref VALUES (2855, 24, '0002294', '', NULL);
INSERT INTO chado.dbxref VALUES (2856, 24, '0002295', '', NULL);
INSERT INTO chado.dbxref VALUES (2857, 24, '0002296', '', NULL);
INSERT INTO chado.dbxref VALUES (2858, 24, '0002297', '', NULL);
INSERT INTO chado.dbxref VALUES (2859, 24, '0002298', '', NULL);
INSERT INTO chado.dbxref VALUES (2860, 24, '0002299', '', NULL);
INSERT INTO chado.dbxref VALUES (2861, 24, '0002301', '', NULL);
INSERT INTO chado.dbxref VALUES (2862, 24, '0002302', '', NULL);
INSERT INTO chado.dbxref VALUES (2863, 24, '1001284', '', NULL);
INSERT INTO chado.dbxref VALUES (2864, 24, '0002303', '', NULL);
INSERT INTO chado.dbxref VALUES (2865, 24, '0002304', '', NULL);
INSERT INTO chado.dbxref VALUES (2866, 24, '0002305', '', NULL);
INSERT INTO chado.dbxref VALUES (2867, 24, '0002306', '', NULL);
INSERT INTO chado.dbxref VALUES (2868, 24, '0002307', '', NULL);
INSERT INTO chado.dbxref VALUES (2869, 24, '0002308', '', NULL);
INSERT INTO chado.dbxref VALUES (2870, 24, '0002310', '', NULL);
INSERT INTO chado.dbxref VALUES (2871, 24, '0002312', '', NULL);
INSERT INTO chado.dbxref VALUES (2872, 24, '0002313', '', NULL);
INSERT INTO chado.dbxref VALUES (2873, 24, '0002314', '', NULL);
INSERT INTO chado.dbxref VALUES (2874, 24, '0002315', '', NULL);
INSERT INTO chado.dbxref VALUES (2875, 24, '0002316', '', NULL);
INSERT INTO chado.dbxref VALUES (2876, 24, '0002317', '', NULL);
INSERT INTO chado.dbxref VALUES (2877, 24, '0002318', '', NULL);
INSERT INTO chado.dbxref VALUES (2878, 24, '0002319', '', NULL);
INSERT INTO chado.dbxref VALUES (2879, 24, '0002320', '', NULL);
INSERT INTO chado.dbxref VALUES (2880, 24, '0002321', '', NULL);
INSERT INTO chado.dbxref VALUES (2881, 24, '0002322', '', NULL);
INSERT INTO chado.dbxref VALUES (2882, 24, '0002323', '', NULL);
INSERT INTO chado.dbxref VALUES (2883, 24, '0002324', '', NULL);
INSERT INTO chado.dbxref VALUES (2884, 24, '0002325', '', NULL);
INSERT INTO chado.dbxref VALUES (2885, 24, '0002326', '', NULL);
INSERT INTO chado.dbxref VALUES (2886, 24, '0002327', '', NULL);
INSERT INTO chado.dbxref VALUES (2887, 24, '0002328', '', NULL);
INSERT INTO chado.dbxref VALUES (2888, 24, '0002329', '', NULL);
INSERT INTO chado.dbxref VALUES (2889, 24, '0002330', '', NULL);
INSERT INTO chado.dbxref VALUES (2890, 24, '0002332', '', NULL);
INSERT INTO chado.dbxref VALUES (2891, 39, '//epi.grants.cancer.gov/epigen/#\:~\:text=mail.nih.gov-\,Overview\,a%20cell%20or%20entire%20organism.', '', NULL);
INSERT INTO chado.dbxref VALUES (2892, 24, '0002333', '', NULL);
INSERT INTO chado.dbxref VALUES (2893, 24, '0002334', '', NULL);
INSERT INTO chado.dbxref VALUES (2894, 24, '0002335', '', NULL);
INSERT INTO chado.dbxref VALUES (2895, 24, '0002336', '', NULL);
INSERT INTO chado.dbxref VALUES (2896, 24, '0002337', '', NULL);
INSERT INTO chado.dbxref VALUES (2897, 24, '0002338', '', NULL);
INSERT INTO chado.dbxref VALUES (2898, 24, '0002339', '', NULL);
INSERT INTO chado.dbxref VALUES (2899, 24, '0002340', '', NULL);
INSERT INTO chado.dbxref VALUES (2900, 24, '0002341', '', NULL);
INSERT INTO chado.dbxref VALUES (2901, 24, '0002344', '', NULL);
INSERT INTO chado.dbxref VALUES (2902, 24, '0002345', '', NULL);
INSERT INTO chado.dbxref VALUES (2903, 24, '0002346', '', NULL);
INSERT INTO chado.dbxref VALUES (2904, 24, '0002347', '', NULL);
INSERT INTO chado.dbxref VALUES (2905, 24, '0002348', '', NULL);
INSERT INTO chado.dbxref VALUES (2906, 24, '0002349', '', NULL);
INSERT INTO chado.dbxref VALUES (2907, 24, '0002350', '', NULL);
INSERT INTO chado.dbxref VALUES (2908, 24, '0002351', '', NULL);
INSERT INTO chado.dbxref VALUES (2909, 24, '0002352', '', NULL);
INSERT INTO chado.dbxref VALUES (2910, 24, '0002353', '', NULL);
INSERT INTO chado.dbxref VALUES (2911, 24, '0002354', '', NULL);
INSERT INTO chado.dbxref VALUES (2912, 24, '0002355', '', NULL);
INSERT INTO chado.dbxref VALUES (2913, 24, '0002356', '', NULL);
INSERT INTO chado.dbxref VALUES (2914, 24, '0002357', '', NULL);
INSERT INTO chado.dbxref VALUES (2915, 24, '0002358', '', NULL);
INSERT INTO chado.dbxref VALUES (2916, 24, '0002359', '', NULL);
INSERT INTO chado.dbxref VALUES (2917, 24, '0002360', '', NULL);
INSERT INTO chado.dbxref VALUES (2918, 24, '0002363', '', NULL);
INSERT INTO chado.dbxref VALUES (2919, 24, '0002364', '', NULL);
INSERT INTO chado.dbxref VALUES (2920, 24, '0002365', '', NULL);
INSERT INTO chado.dbxref VALUES (2921, 24, '0002366', '', NULL);
INSERT INTO chado.dbxref VALUES (2922, 24, '0002367', '', NULL);
INSERT INTO chado.dbxref VALUES (2923, 24, '0002368', '', NULL);
INSERT INTO chado.dbxref VALUES (2924, 24, '0002369', '', NULL);
INSERT INTO chado.dbxref VALUES (2925, 24, '0002370', '', NULL);
INSERT INTO chado.dbxref VALUES (2926, 24, '0002371', '', NULL);
INSERT INTO chado.dbxref VALUES (2927, 24, '0002372', '', NULL);
INSERT INTO chado.dbxref VALUES (2928, 24, '0002373', '', NULL);
INSERT INTO chado.dbxref VALUES (2929, 24, '0002374', '', NULL);
INSERT INTO chado.dbxref VALUES (2930, 24, '0002375', '', NULL);
INSERT INTO chado.dbxref VALUES (2931, 24, '0002376', '', NULL);
INSERT INTO chado.dbxref VALUES (2932, 24, '0002377', '', NULL);
INSERT INTO chado.dbxref VALUES (2933, 24, '0002378', '', NULL);
INSERT INTO chado.dbxref VALUES (2934, 24, '0002379', '', NULL);
INSERT INTO chado.dbxref VALUES (2935, 24, '0002380', '', NULL);
INSERT INTO chado.dbxref VALUES (2936, 24, '0002381', '', NULL);
INSERT INTO chado.dbxref VALUES (2937, 24, '0005841', '', NULL);
INSERT INTO chado.dbxref VALUES (2938, 24, '0005843', '', NULL);
INSERT INTO chado.dbxref VALUES (2939, 24, '0005845', '', NULL);
INSERT INTO chado.dbxref VALUES (2940, 24, '0005847', '', NULL);
INSERT INTO chado.dbxref VALUES (2941, 24, '0005848', '', NULL);
INSERT INTO chado.dbxref VALUES (2942, 24, '0005849', '', NULL);
INSERT INTO chado.dbxref VALUES (2943, 24, '0005850', '', NULL);
INSERT INTO chado.dbxref VALUES (2944, 24, '0005851', '', NULL);
INSERT INTO chado.dbxref VALUES (2945, 24, '0005852', '', NULL);
INSERT INTO chado.dbxref VALUES (2946, 24, '0005853', '', NULL);
INSERT INTO chado.dbxref VALUES (2947, 24, '0005856', '', NULL);
INSERT INTO chado.dbxref VALUES (2948, 24, '0005857', '', NULL);
INSERT INTO chado.dbxref VALUES (2949, 24, '0005858', '', NULL);
INSERT INTO chado.dbxref VALUES (2950, 24, '0100003', '', NULL);
INSERT INTO chado.dbxref VALUES (2951, 24, '0100004', '', NULL);
INSERT INTO chado.dbxref VALUES (2952, 24, '0100005', '', NULL);
INSERT INTO chado.dbxref VALUES (2953, 24, '0100006', '', NULL);
INSERT INTO chado.dbxref VALUES (2954, 24, '0100007', '', NULL);
INSERT INTO chado.dbxref VALUES (2955, 24, '0100008', '', NULL);
INSERT INTO chado.dbxref VALUES (2956, 24, '0100009', '', NULL);
INSERT INTO chado.dbxref VALUES (2957, 24, '0100010', '', NULL);
INSERT INTO chado.dbxref VALUES (2958, 24, '0100012', '', NULL);
INSERT INTO chado.dbxref VALUES (2959, 24, '0100013', '', NULL);
INSERT INTO chado.dbxref VALUES (2960, 24, '0100014', '', NULL);
INSERT INTO chado.dbxref VALUES (2961, 24, '0100015', '', NULL);
INSERT INTO chado.dbxref VALUES (2962, 24, '0100016', '', NULL);
INSERT INTO chado.dbxref VALUES (2963, 24, '0100018', '', NULL);
INSERT INTO chado.dbxref VALUES (2964, 24, '0100020', '', NULL);
INSERT INTO chado.dbxref VALUES (2965, 34, 'LA6690-7', '', NULL);
INSERT INTO chado.dbxref VALUES (2966, 24, '1000005', '', NULL);
INSERT INTO chado.dbxref VALUES (2967, 24, '1000008', '', NULL);
INSERT INTO chado.dbxref VALUES (2968, 24, '1000009', '', NULL);
INSERT INTO chado.dbxref VALUES (2969, 24, '1000010', '', NULL);
INSERT INTO chado.dbxref VALUES (2970, 24, '1000011', '', NULL);
INSERT INTO chado.dbxref VALUES (2971, 24, '1000012', '', NULL);
INSERT INTO chado.dbxref VALUES (2972, 24, '1000013', '', NULL);
INSERT INTO chado.dbxref VALUES (2973, 24, '1000014', '', NULL);
INSERT INTO chado.dbxref VALUES (2974, 24, '1000015', '', NULL);
INSERT INTO chado.dbxref VALUES (2975, 24, '1000016', '', NULL);
INSERT INTO chado.dbxref VALUES (2976, 24, '1000017', '', NULL);
INSERT INTO chado.dbxref VALUES (2977, 24, '1000018', '', NULL);
INSERT INTO chado.dbxref VALUES (2978, 24, '1000019', '', NULL);
INSERT INTO chado.dbxref VALUES (2979, 24, '1000020', '', NULL);
INSERT INTO chado.dbxref VALUES (2980, 24, '1000021', '', NULL);
INSERT INTO chado.dbxref VALUES (2981, 24, '1000022', '', NULL);
INSERT INTO chado.dbxref VALUES (2982, 24, '1000023', '', NULL);
INSERT INTO chado.dbxref VALUES (2983, 24, '1000024', '', NULL);
INSERT INTO chado.dbxref VALUES (2984, 24, '1000025', '', NULL);
INSERT INTO chado.dbxref VALUES (2985, 24, '1000026', '', NULL);
INSERT INTO chado.dbxref VALUES (2986, 24, '1000027', '', NULL);
INSERT INTO chado.dbxref VALUES (2987, 24, '1000028', '', NULL);
INSERT INTO chado.dbxref VALUES (2988, 24, '1000031', '', NULL);
INSERT INTO chado.dbxref VALUES (2989, 24, '1000032', '', NULL);
INSERT INTO chado.dbxref VALUES (2990, 34, 'LA9659-9', '', NULL);
INSERT INTO chado.dbxref VALUES (2991, 34, 'LA6686-5', '', NULL);
INSERT INTO chado.dbxref VALUES (2992, 34, 'LA6689-9', '', NULL);
INSERT INTO chado.dbxref VALUES (2993, 24, '1000039', '', NULL);
INSERT INTO chado.dbxref VALUES (2994, 24, '1000173', '', NULL);
INSERT INTO chado.dbxref VALUES (2995, 24, '1000040', '', NULL);
INSERT INTO chado.dbxref VALUES (2996, 24, '1000043', '', NULL);
INSERT INTO chado.dbxref VALUES (2997, 24, '1000046', '', NULL);
INSERT INTO chado.dbxref VALUES (2998, 24, '1000047', '', NULL);
INSERT INTO chado.dbxref VALUES (2999, 24, '1000048', '', NULL);
INSERT INTO chado.dbxref VALUES (3000, 24, '1000049', '', NULL);
INSERT INTO chado.dbxref VALUES (3001, 24, '1000177', '', NULL);
INSERT INTO chado.dbxref VALUES (3002, 24, '1000179', '', NULL);
INSERT INTO chado.dbxref VALUES (3003, 24, '1000050', '', NULL);
INSERT INTO chado.dbxref VALUES (3004, 24, '1000054', '', NULL);
INSERT INTO chado.dbxref VALUES (3005, 24, '1000055', '', NULL);
INSERT INTO chado.dbxref VALUES (3006, 24, '1000056', '', NULL);
INSERT INTO chado.dbxref VALUES (3007, 24, '1000057', '', NULL);
INSERT INTO chado.dbxref VALUES (3008, 24, '1000058', '', NULL);
INSERT INTO chado.dbxref VALUES (3009, 24, '1000059', '', NULL);
INSERT INTO chado.dbxref VALUES (3010, 24, '1000060', '', NULL);
INSERT INTO chado.dbxref VALUES (3011, 24, '1000061', '', NULL);
INSERT INTO chado.dbxref VALUES (3012, 24, '1000062', '', NULL);
INSERT INTO chado.dbxref VALUES (3013, 24, '1000063', '', NULL);
INSERT INTO chado.dbxref VALUES (3014, 24, '1000064', '', NULL);
INSERT INTO chado.dbxref VALUES (3015, 24, '1000065', '', NULL);
INSERT INTO chado.dbxref VALUES (3016, 24, '1000066', '', NULL);
INSERT INTO chado.dbxref VALUES (3017, 24, '1000067', '', NULL);
INSERT INTO chado.dbxref VALUES (3018, 24, '1000068', '', NULL);
INSERT INTO chado.dbxref VALUES (3019, 24, '1000069', '', NULL);
INSERT INTO chado.dbxref VALUES (3020, 24, '1000070', '', NULL);
INSERT INTO chado.dbxref VALUES (3021, 24, '1000071', '', NULL);
INSERT INTO chado.dbxref VALUES (3022, 24, '1000072', '', NULL);
INSERT INTO chado.dbxref VALUES (3023, 24, '1000073', '', NULL);
INSERT INTO chado.dbxref VALUES (3024, 24, '1000074', '', NULL);
INSERT INTO chado.dbxref VALUES (3025, 24, '1000075', '', NULL);
INSERT INTO chado.dbxref VALUES (3026, 24, '1000076', '', NULL);
INSERT INTO chado.dbxref VALUES (3027, 24, '1000078', '', NULL);
INSERT INTO chado.dbxref VALUES (3028, 24, '1000079', '', NULL);
INSERT INTO chado.dbxref VALUES (3029, 24, '1000080', '', NULL);
INSERT INTO chado.dbxref VALUES (3030, 24, '1000081', '', NULL);
INSERT INTO chado.dbxref VALUES (3031, 24, '1000082', '', NULL);
INSERT INTO chado.dbxref VALUES (3032, 24, '1000083', '', NULL);
INSERT INTO chado.dbxref VALUES (3033, 24, '1000084', '', NULL);
INSERT INTO chado.dbxref VALUES (3034, 24, '1000085', '', NULL);
INSERT INTO chado.dbxref VALUES (3035, 24, '1000086', '', NULL);
INSERT INTO chado.dbxref VALUES (3036, 24, '1000087', '', NULL);
INSERT INTO chado.dbxref VALUES (3037, 24, '1000088', '', NULL);
INSERT INTO chado.dbxref VALUES (3038, 24, '1000090', '', NULL);
INSERT INTO chado.dbxref VALUES (3039, 24, '1000091', '', NULL);
INSERT INTO chado.dbxref VALUES (3040, 24, '1000089', '', NULL);
INSERT INTO chado.dbxref VALUES (3041, 24, '1000092', '', NULL);
INSERT INTO chado.dbxref VALUES (3042, 24, '1000093', '', NULL);
INSERT INTO chado.dbxref VALUES (3043, 24, '1000094', '', NULL);
INSERT INTO chado.dbxref VALUES (3044, 24, '1000095', '', NULL);
INSERT INTO chado.dbxref VALUES (3045, 24, '1000096', '', NULL);
INSERT INTO chado.dbxref VALUES (3046, 24, '1000097', '', NULL);
INSERT INTO chado.dbxref VALUES (3047, 24, '1000098', '', NULL);
INSERT INTO chado.dbxref VALUES (3048, 24, '1000099', '', NULL);
INSERT INTO chado.dbxref VALUES (3049, 24, '1000100', '', NULL);
INSERT INTO chado.dbxref VALUES (3050, 24, '1000101', '', NULL);
INSERT INTO chado.dbxref VALUES (3051, 24, '1000102', '', NULL);
INSERT INTO chado.dbxref VALUES (3052, 24, '1000103', '', NULL);
INSERT INTO chado.dbxref VALUES (3053, 24, '1000104', '', NULL);
INSERT INTO chado.dbxref VALUES (3054, 24, '1000105', '', NULL);
INSERT INTO chado.dbxref VALUES (3055, 24, '1000106', '', NULL);
INSERT INTO chado.dbxref VALUES (3056, 24, '1000107', '', NULL);
INSERT INTO chado.dbxref VALUES (3057, 24, '1000108', '', NULL);
INSERT INTO chado.dbxref VALUES (3058, 24, '1000109', '', NULL);
INSERT INTO chado.dbxref VALUES (3059, 24, '1000110', '', NULL);
INSERT INTO chado.dbxref VALUES (3060, 24, '1000111', '', NULL);
INSERT INTO chado.dbxref VALUES (3061, 24, '1000113', '', NULL);
INSERT INTO chado.dbxref VALUES (3062, 24, '1000114', '', NULL);
INSERT INTO chado.dbxref VALUES (3063, 24, '1000112', '', NULL);
INSERT INTO chado.dbxref VALUES (3064, 24, '1000115', '', NULL);
INSERT INTO chado.dbxref VALUES (3065, 24, '1000116', '', NULL);
INSERT INTO chado.dbxref VALUES (3066, 24, '1000117', '', NULL);
INSERT INTO chado.dbxref VALUES (3067, 24, '1000118', '', NULL);
INSERT INTO chado.dbxref VALUES (3068, 24, '1000119', '', NULL);
INSERT INTO chado.dbxref VALUES (3069, 24, '1000120', '', NULL);
INSERT INTO chado.dbxref VALUES (3070, 24, '1000121', '', NULL);
INSERT INTO chado.dbxref VALUES (3071, 24, '1000122', '', NULL);
INSERT INTO chado.dbxref VALUES (3072, 24, '1000123', '', NULL);
INSERT INTO chado.dbxref VALUES (3073, 24, '1000124', '', NULL);
INSERT INTO chado.dbxref VALUES (3074, 24, '1000125', '', NULL);
INSERT INTO chado.dbxref VALUES (3075, 24, '1000126', '', NULL);
INSERT INTO chado.dbxref VALUES (3076, 24, '1000127', '', NULL);
INSERT INTO chado.dbxref VALUES (3077, 24, '1000132', '', NULL);
INSERT INTO chado.dbxref VALUES (3078, 24, '1000134', '', NULL);
INSERT INTO chado.dbxref VALUES (3079, 24, '1000136', '', NULL);
INSERT INTO chado.dbxref VALUES (3080, 24, '1000138', '', NULL);
INSERT INTO chado.dbxref VALUES (3081, 24, '1000140', '', NULL);
INSERT INTO chado.dbxref VALUES (3082, 24, '1000141', '', NULL);
INSERT INTO chado.dbxref VALUES (3083, 24, '1000142', '', NULL);
INSERT INTO chado.dbxref VALUES (3084, 24, '1000143', '', NULL);
INSERT INTO chado.dbxref VALUES (3085, 24, '1000144', '', NULL);
INSERT INTO chado.dbxref VALUES (3086, 24, '1000145', '', NULL);
INSERT INTO chado.dbxref VALUES (3087, 24, '1000147', '', NULL);
INSERT INTO chado.dbxref VALUES (3088, 24, '1000148', '', NULL);
INSERT INTO chado.dbxref VALUES (3089, 24, '1000149', '', NULL);
INSERT INTO chado.dbxref VALUES (3090, 24, '1000150', '', NULL);
INSERT INTO chado.dbxref VALUES (3091, 24, '1000151', '', NULL);
INSERT INTO chado.dbxref VALUES (3092, 24, '1000152', '', NULL);
INSERT INTO chado.dbxref VALUES (3093, 24, '1000154', '', NULL);
INSERT INTO chado.dbxref VALUES (3094, 24, '1000153', '', NULL);
INSERT INTO chado.dbxref VALUES (3095, 24, '1000156', '', NULL);
INSERT INTO chado.dbxref VALUES (3096, 24, '1000157', '', NULL);
INSERT INTO chado.dbxref VALUES (3097, 24, '1000158', '', NULL);
INSERT INTO chado.dbxref VALUES (3098, 24, '1000159', '', NULL);
INSERT INTO chado.dbxref VALUES (3099, 24, '1000160', '', NULL);
INSERT INTO chado.dbxref VALUES (3100, 24, '1000161', '', NULL);
INSERT INTO chado.dbxref VALUES (3101, 24, '1000162', '', NULL);
INSERT INTO chado.dbxref VALUES (3102, 24, '1000170', '', NULL);
INSERT INTO chado.dbxref VALUES (3103, 24, '1000171', '', NULL);
INSERT INTO chado.dbxref VALUES (3104, 24, '1000175', '', NULL);
INSERT INTO chado.dbxref VALUES (3105, 24, '1000180', '', NULL);
INSERT INTO chado.dbxref VALUES (3106, 24, '1000181', '', NULL);
INSERT INTO chado.dbxref VALUES (3107, 24, '1000184', '', NULL);
INSERT INTO chado.dbxref VALUES (3108, 24, '1000185', '', NULL);
INSERT INTO chado.dbxref VALUES (3109, 24, '1000186', '', NULL);
INSERT INTO chado.dbxref VALUES (3110, 24, '1001186', '', NULL);
INSERT INTO chado.dbxref VALUES (3111, 24, '1001187', '', NULL);
INSERT INTO chado.dbxref VALUES (3112, 24, '1001188', '', NULL);
INSERT INTO chado.dbxref VALUES (3113, 24, '1001189', '', NULL);
INSERT INTO chado.dbxref VALUES (3114, 24, '1001190', '', NULL);
INSERT INTO chado.dbxref VALUES (3115, 24, '1001195', '', NULL);
INSERT INTO chado.dbxref VALUES (3116, 24, '1001191', '', NULL);
INSERT INTO chado.dbxref VALUES (3117, 24, '1001192', '', NULL);
INSERT INTO chado.dbxref VALUES (3118, 24, '1001193', '', NULL);
INSERT INTO chado.dbxref VALUES (3119, 24, '1001194', '', NULL);
INSERT INTO chado.dbxref VALUES (3120, 24, '1001196', '', NULL);
INSERT INTO chado.dbxref VALUES (3121, 24, '1001217', '', NULL);
INSERT INTO chado.dbxref VALUES (3122, 24, '1001244', '', NULL);
INSERT INTO chado.dbxref VALUES (3123, 24, '1001246', '', NULL);
INSERT INTO chado.dbxref VALUES (3124, 24, '1001247', '', NULL);
INSERT INTO chado.dbxref VALUES (3125, 24, '1001254', '', NULL);
INSERT INTO chado.dbxref VALUES (3126, 24, '1001249', '', NULL);
INSERT INTO chado.dbxref VALUES (3127, 24, '1001255', '', NULL);
INSERT INTO chado.dbxref VALUES (3128, 24, '1001259', '', NULL);
INSERT INTO chado.dbxref VALUES (3129, 24, '1001260', '', NULL);
INSERT INTO chado.dbxref VALUES (3130, 24, '1001261', '', NULL);
INSERT INTO chado.dbxref VALUES (3131, 24, '1001262', '', NULL);
INSERT INTO chado.dbxref VALUES (3132, 24, '1001263', '', NULL);
INSERT INTO chado.dbxref VALUES (3133, 24, '1001264', '', NULL);
INSERT INTO chado.dbxref VALUES (3134, 24, '1001265', '', NULL);
INSERT INTO chado.dbxref VALUES (3135, 24, '1001266', '', NULL);
INSERT INTO chado.dbxref VALUES (3136, 24, '1001267', '', NULL);
INSERT INTO chado.dbxref VALUES (3137, 24, '1001269', '', NULL);
INSERT INTO chado.dbxref VALUES (3138, 24, '1001270', '', NULL);
INSERT INTO chado.dbxref VALUES (3139, 24, '1001271', '', NULL);
INSERT INTO chado.dbxref VALUES (3140, 24, '1001272', '', NULL);
INSERT INTO chado.dbxref VALUES (3141, 24, '1001273', '', NULL);
INSERT INTO chado.dbxref VALUES (3142, 24, '1001274', '', NULL);
INSERT INTO chado.dbxref VALUES (3143, 24, '1001275', '', NULL);
INSERT INTO chado.dbxref VALUES (3144, 24, '1001277', '', NULL);
INSERT INTO chado.dbxref VALUES (3145, 24, '1001279', '', NULL);
INSERT INTO chado.dbxref VALUES (3146, 24, '1001280', '', NULL);
INSERT INTO chado.dbxref VALUES (3147, 24, '1001281', '', NULL);
INSERT INTO chado.dbxref VALUES (3148, 24, '1001282', '', NULL);
INSERT INTO chado.dbxref VALUES (3149, 24, '1001288', '', NULL);
INSERT INTO chado.dbxref VALUES (3150, 24, '1001283', '', NULL);
INSERT INTO chado.dbxref VALUES (3151, 24, '1001285', '', NULL);
INSERT INTO chado.dbxref VALUES (3152, 24, '1001286', '', NULL);
INSERT INTO chado.dbxref VALUES (3153, 24, '1001287', '', NULL);
INSERT INTO chado.dbxref VALUES (3154, 24, '2000061', '', NULL);
INSERT INTO chado.dbxref VALUES (3155, 25, '1000000', '', NULL);
INSERT INTO chado.dbxref VALUES (3156, 25, 'is_a', '', NULL);
INSERT INTO chado.dbxref VALUES (3157, 25, '0000000', '', NULL);
INSERT INTO chado.dbxref VALUES (3158, 25, '0000001', '', NULL);
INSERT INTO chado.dbxref VALUES (3159, 21, 'phylum', '', NULL);
INSERT INTO chado.dbxref VALUES (3160, 25, '0000002', '', NULL);
INSERT INTO chado.dbxref VALUES (3161, 21, 'class', '', NULL);
INSERT INTO chado.dbxref VALUES (3162, 25, '0000003', '', NULL);
INSERT INTO chado.dbxref VALUES (3163, 21, 'order', '', NULL);
INSERT INTO chado.dbxref VALUES (3164, 25, '0000004', '', NULL);
INSERT INTO chado.dbxref VALUES (3165, 21, 'family', '', NULL);
INSERT INTO chado.dbxref VALUES (3166, 21, 'genus', '', NULL);
INSERT INTO chado.dbxref VALUES (3167, 21, 'species', '', NULL);
INSERT INTO chado.dbxref VALUES (3168, 25, '0000007', '', NULL);
INSERT INTO chado.dbxref VALUES (3169, 21, 'subclass', '', NULL);
INSERT INTO chado.dbxref VALUES (3170, 25, '0000008', '', NULL);
INSERT INTO chado.dbxref VALUES (3171, 21, 'subphylum', '', NULL);
INSERT INTO chado.dbxref VALUES (3172, 25, '0000009', '', NULL);
INSERT INTO chado.dbxref VALUES (3173, 21, 'subgenus', '', NULL);
INSERT INTO chado.dbxref VALUES (3174, 25, '0000010', '', NULL);
INSERT INTO chado.dbxref VALUES (3175, 21, 'species_group', '', NULL);
INSERT INTO chado.dbxref VALUES (3176, 25, '0000011', '', NULL);
INSERT INTO chado.dbxref VALUES (3177, 21, 'species_subgroup', '', NULL);
INSERT INTO chado.dbxref VALUES (3178, 25, '0000012', '', NULL);
INSERT INTO chado.dbxref VALUES (3179, 25, '0000013', '', NULL);
INSERT INTO chado.dbxref VALUES (3180, 21, 'infraorder', '', NULL);
INSERT INTO chado.dbxref VALUES (3181, 25, '0000014', '', NULL);
INSERT INTO chado.dbxref VALUES (3182, 21, 'suborder', '', NULL);
INSERT INTO chado.dbxref VALUES (3183, 25, '0000015', '', NULL);
INSERT INTO chado.dbxref VALUES (3184, 21, 'superclass', '', NULL);
INSERT INTO chado.dbxref VALUES (3185, 25, '0000016', '', NULL);
INSERT INTO chado.dbxref VALUES (3186, 21, 'varietas', '', NULL);
INSERT INTO chado.dbxref VALUES (3187, 25, '0000017', '', NULL);
INSERT INTO chado.dbxref VALUES (3188, 21, 'kingdom', '', NULL);
INSERT INTO chado.dbxref VALUES (3189, 25, '0000018', '', NULL);
INSERT INTO chado.dbxref VALUES (3190, 21, 'superfamily', '', NULL);
INSERT INTO chado.dbxref VALUES (3191, 25, '0000019', '', NULL);
INSERT INTO chado.dbxref VALUES (3192, 21, 'infraclass', '', NULL);
INSERT INTO chado.dbxref VALUES (3193, 25, '0000020', '', NULL);
INSERT INTO chado.dbxref VALUES (3194, 21, 'superorder', '', NULL);
INSERT INTO chado.dbxref VALUES (3195, 25, '0000021', '', NULL);
INSERT INTO chado.dbxref VALUES (3196, 21, 'parvorder', '', NULL);
INSERT INTO chado.dbxref VALUES (3197, 25, '0000022', '', NULL);
INSERT INTO chado.dbxref VALUES (3198, 21, 'superkingdom', '', NULL);
INSERT INTO chado.dbxref VALUES (3199, 25, '0000023', '', NULL);
INSERT INTO chado.dbxref VALUES (3200, 21, 'subspecies', '', NULL);
INSERT INTO chado.dbxref VALUES (3201, 25, '0000024', '', NULL);
INSERT INTO chado.dbxref VALUES (3202, 21, 'subfamily', '', NULL);
INSERT INTO chado.dbxref VALUES (3203, 25, '0000025', '', NULL);
INSERT INTO chado.dbxref VALUES (3204, 21, 'tribe', '', NULL);
INSERT INTO chado.dbxref VALUES (3205, 25, '0000026', '', NULL);
INSERT INTO chado.dbxref VALUES (3206, 21, 'forma', '', NULL);
INSERT INTO chado.dbxref VALUES (3207, 25, '0000027', '', NULL);
INSERT INTO chado.dbxref VALUES (3208, 21, 'superphylum', '', NULL);
INSERT INTO chado.dbxref VALUES (3209, 25, '0000028', '', NULL);
INSERT INTO chado.dbxref VALUES (3210, 21, 'subtribe', '', NULL);
INSERT INTO chado.dbxref VALUES (3211, 25, '0000029', '', NULL);
INSERT INTO chado.dbxref VALUES (3212, 21, 'subkingdom', '', NULL);
INSERT INTO chado.dbxref VALUES (3213, 25, '0000030', '', NULL);
INSERT INTO chado.dbxref VALUES (3214, 25, '0000031', '', NULL);
INSERT INTO chado.dbxref VALUES (3215, 25, '0000032', '', NULL);
INSERT INTO chado.dbxref VALUES (3216, 25, '0000033', '', NULL);
INSERT INTO chado.dbxref VALUES (3217, 25, '0000034', '', NULL);
INSERT INTO chado.dbxref VALUES (3218, 25, '0000035', '', NULL);
INSERT INTO chado.dbxref VALUES (3219, 25, '0000036', '', NULL);
INSERT INTO chado.dbxref VALUES (3220, 25, '0000037', '', NULL);
INSERT INTO chado.dbxref VALUES (3221, 25, '0000038', '', NULL);
INSERT INTO chado.dbxref VALUES (3222, 25, '0000039', '', NULL);
INSERT INTO chado.dbxref VALUES (3223, 25, '0000040', '', NULL);
INSERT INTO chado.dbxref VALUES (3224, 25, '0000041', '', NULL);
INSERT INTO chado.dbxref VALUES (3225, 25, '0000042', '', NULL);
INSERT INTO chado.dbxref VALUES (3226, 25, '0000043', '', NULL);
INSERT INTO chado.dbxref VALUES (3227, 25, '0000044', '', NULL);
INSERT INTO chado.dbxref VALUES (3228, 25, '0000046', '', NULL);
INSERT INTO chado.dbxref VALUES (3229, 25, '0000047', '', NULL);
INSERT INTO chado.dbxref VALUES (3230, 25, '0000048', '', NULL);
INSERT INTO chado.dbxref VALUES (3231, 25, '0000049', '', NULL);
INSERT INTO chado.dbxref VALUES (3232, 25, '0000050', '', NULL);
INSERT INTO chado.dbxref VALUES (3233, 25, '0000051', '', NULL);
INSERT INTO chado.dbxref VALUES (3234, 25, '0000052', '', NULL);
INSERT INTO chado.dbxref VALUES (3235, 25, '0000053', '', NULL);
INSERT INTO chado.dbxref VALUES (3236, 25, '0000054', '', NULL);
INSERT INTO chado.dbxref VALUES (3237, 25, '0000055', '', NULL);
INSERT INTO chado.dbxref VALUES (3238, 25, '0000056', '', NULL);
INSERT INTO chado.dbxref VALUES (3239, 25, '0000057', '', NULL);
INSERT INTO chado.dbxref VALUES (3240, 25, '0000058', '', NULL);
INSERT INTO chado.dbxref VALUES (3241, 25, '0000059', '', NULL);
INSERT INTO chado.dbxref VALUES (3242, 25, '0000060', '', NULL);
INSERT INTO chado.dbxref VALUES (3243, 26, 'is_a', '', NULL);
INSERT INTO chado.dbxref VALUES (3244, 26, 'part_of', '', NULL);
INSERT INTO chado.dbxref VALUES (3245, 26, '0000001', '', NULL);
INSERT INTO chado.dbxref VALUES (3246, 26, '0000002', '', NULL);
INSERT INTO chado.dbxref VALUES (3247, 26, '0000003', '', NULL);
INSERT INTO chado.dbxref VALUES (3248, 26, '0000004', '', NULL);
INSERT INTO chado.dbxref VALUES (3249, 26, '0000005', '', NULL);
INSERT INTO chado.dbxref VALUES (3250, 26, '0000006', '', NULL);
INSERT INTO chado.dbxref VALUES (3251, 26, '0000007', '', NULL);
INSERT INTO chado.dbxref VALUES (3252, 26, '0000008', '', NULL);
INSERT INTO chado.dbxref VALUES (3253, 26, '0000009', '', NULL);
INSERT INTO chado.dbxref VALUES (3254, 26, '0000010', '', NULL);
INSERT INTO chado.dbxref VALUES (3255, 26, '0000011', '', NULL);
INSERT INTO chado.dbxref VALUES (3256, 26, '0000012', '', NULL);
INSERT INTO chado.dbxref VALUES (3257, 26, '0000013', '', NULL);
INSERT INTO chado.dbxref VALUES (3258, 26, '0000014', '', NULL);
INSERT INTO chado.dbxref VALUES (3259, 26, '0000015', '', NULL);
INSERT INTO chado.dbxref VALUES (3260, 26, '0000016', '', NULL);
INSERT INTO chado.dbxref VALUES (3261, 26, '0000017', '', NULL);
INSERT INTO chado.dbxref VALUES (3262, 26, '0000018', '', NULL);
INSERT INTO chado.dbxref VALUES (3263, 26, '0000019', '', NULL);
INSERT INTO chado.dbxref VALUES (3264, 26, '0000020', '', NULL);
INSERT INTO chado.dbxref VALUES (3265, 26, '0000021', '', NULL);
INSERT INTO chado.dbxref VALUES (3266, 26, '0000022', '', NULL);
INSERT INTO chado.dbxref VALUES (3267, 26, '0000023', '', NULL);
INSERT INTO chado.dbxref VALUES (3268, 26, '0000024', '', NULL);
INSERT INTO chado.dbxref VALUES (3269, 26, '0000025', '', NULL);
INSERT INTO chado.dbxref VALUES (3270, 26, '0000026', '', NULL);
INSERT INTO chado.dbxref VALUES (3271, 26, '0000027', '', NULL);
INSERT INTO chado.dbxref VALUES (3272, 26, '0000028', '', NULL);
INSERT INTO chado.dbxref VALUES (3273, 27, 'is_a', '', NULL);
INSERT INTO chado.dbxref VALUES (3274, 27, 'part_of', '', NULL);
INSERT INTO chado.dbxref VALUES (3275, 27, '0000001', '', NULL);
INSERT INTO chado.dbxref VALUES (3276, 27, '0000037', '', NULL);
INSERT INTO chado.dbxref VALUES (3277, 27, '0000004', '', NULL);
INSERT INTO chado.dbxref VALUES (3278, 27, '0000005', '', NULL);
INSERT INTO chado.dbxref VALUES (3279, 27, '0000006', '', NULL);
INSERT INTO chado.dbxref VALUES (3280, 27, '0000016', '', NULL);
INSERT INTO chado.dbxref VALUES (3281, 27, '0000007', '', NULL);
INSERT INTO chado.dbxref VALUES (3282, 27, '0000008', '', NULL);
INSERT INTO chado.dbxref VALUES (3283, 27, '0000009', '', NULL);
INSERT INTO chado.dbxref VALUES (3284, 27, '0000010', '', NULL);
INSERT INTO chado.dbxref VALUES (3285, 27, '0000046', '', NULL);
INSERT INTO chado.dbxref VALUES (3286, 27, '0000011', '', NULL);
INSERT INTO chado.dbxref VALUES (3287, 27, '0000012', '', NULL);
INSERT INTO chado.dbxref VALUES (3288, 27, '0000013', '', NULL);
INSERT INTO chado.dbxref VALUES (3289, 27, '0000014', '', NULL);
INSERT INTO chado.dbxref VALUES (3290, 27, '0000035', '', NULL);
INSERT INTO chado.dbxref VALUES (3291, 27, '0000036', '', NULL);
INSERT INTO chado.dbxref VALUES (3292, 27, '0000038', '', NULL);
INSERT INTO chado.dbxref VALUES (3293, 27, '0000257', '', NULL);
INSERT INTO chado.dbxref VALUES (3294, 27, '0000039', '', NULL);
INSERT INTO chado.dbxref VALUES (3295, 27, '0000040', '', NULL);
INSERT INTO chado.dbxref VALUES (3296, 27, '0000041', '', NULL);
INSERT INTO chado.dbxref VALUES (3297, 27, '0000042', '', NULL);
INSERT INTO chado.dbxref VALUES (3298, 27, '0000043', '', NULL);
INSERT INTO chado.dbxref VALUES (3299, 27, '0000044', '', NULL);
INSERT INTO chado.dbxref VALUES (3300, 27, '0000045', '', NULL);
INSERT INTO chado.dbxref VALUES (3301, 27, '0000047', '', NULL);
INSERT INTO chado.dbxref VALUES (3302, 27, '0000048', '', NULL);
INSERT INTO chado.dbxref VALUES (3303, 27, '0000049', '', NULL);
INSERT INTO chado.dbxref VALUES (3304, 27, '0000080', '', NULL);
INSERT INTO chado.dbxref VALUES (3305, 27, '0000050', '', NULL);
INSERT INTO chado.dbxref VALUES (3306, 27, '0000051', '', NULL);
INSERT INTO chado.dbxref VALUES (3307, 27, '0000052', '', NULL);
INSERT INTO chado.dbxref VALUES (3308, 27, '0000053', '', NULL);
INSERT INTO chado.dbxref VALUES (3309, 27, '0000059', '', NULL);
INSERT INTO chado.dbxref VALUES (3310, 27, '0000064', '', NULL);
INSERT INTO chado.dbxref VALUES (3311, 27, '0000065', '', NULL);
INSERT INTO chado.dbxref VALUES (3312, 27, '0000066', '', NULL);
INSERT INTO chado.dbxref VALUES (3313, 27, '0000067', '', NULL);
INSERT INTO chado.dbxref VALUES (3314, 27, '0000068', '', NULL);
INSERT INTO chado.dbxref VALUES (3315, 27, '0000069', '', NULL);
INSERT INTO chado.dbxref VALUES (3316, 27, '0000070', '', NULL);
INSERT INTO chado.dbxref VALUES (3317, 27, '0000072', '', NULL);
INSERT INTO chado.dbxref VALUES (3318, 27, '0000073', '', NULL);
INSERT INTO chado.dbxref VALUES (3319, 27, '0000074', '', NULL);
INSERT INTO chado.dbxref VALUES (3320, 27, '0000075', '', NULL);
INSERT INTO chado.dbxref VALUES (3321, 27, '0000256', '', NULL);
INSERT INTO chado.dbxref VALUES (3322, 27, '0000076', '', NULL);
INSERT INTO chado.dbxref VALUES (3323, 27, '0000077', '', NULL);
INSERT INTO chado.dbxref VALUES (3324, 27, '0000078', '', NULL);
INSERT INTO chado.dbxref VALUES (3325, 27, '0000079', '', NULL);
INSERT INTO chado.dbxref VALUES (3326, 27, '0000081', '', NULL);
INSERT INTO chado.dbxref VALUES (3327, 27, '0000082', '', NULL);
INSERT INTO chado.dbxref VALUES (3328, 27, '0000083', '', NULL);
INSERT INTO chado.dbxref VALUES (3329, 27, '0000084', '', NULL);
INSERT INTO chado.dbxref VALUES (3330, 27, '0000085', '', NULL);
INSERT INTO chado.dbxref VALUES (3331, 27, '0000087', '', NULL);
INSERT INTO chado.dbxref VALUES (3332, 27, '0000100', '', NULL);
INSERT INTO chado.dbxref VALUES (3333, 27, '0000101', '', NULL);
INSERT INTO chado.dbxref VALUES (3334, 27, '0000102', '', NULL);
INSERT INTO chado.dbxref VALUES (3335, 27, '0000103', '', NULL);
INSERT INTO chado.dbxref VALUES (3336, 27, '0000104', '', NULL);
INSERT INTO chado.dbxref VALUES (3337, 27, '0000105', '', NULL);
INSERT INTO chado.dbxref VALUES (3338, 27, '0000106', '', NULL);
INSERT INTO chado.dbxref VALUES (3339, 27, '0000107', '', NULL);
INSERT INTO chado.dbxref VALUES (3340, 27, '0000108', '', NULL);
INSERT INTO chado.dbxref VALUES (3341, 27, '0000109', '', NULL);
INSERT INTO chado.dbxref VALUES (3342, 27, '0000110', '', NULL);
INSERT INTO chado.dbxref VALUES (3343, 27, '0000111', '', NULL);
INSERT INTO chado.dbxref VALUES (3344, 27, '0000112', '', NULL);
INSERT INTO chado.dbxref VALUES (3345, 27, '0000113', '', NULL);
INSERT INTO chado.dbxref VALUES (3346, 27, '0000114', '', NULL);
INSERT INTO chado.dbxref VALUES (3347, 27, '0000115', '', NULL);
INSERT INTO chado.dbxref VALUES (3348, 27, '0000116', '', NULL);
INSERT INTO chado.dbxref VALUES (3349, 27, '0000117', '', NULL);
INSERT INTO chado.dbxref VALUES (3350, 27, '0000118', '', NULL);
INSERT INTO chado.dbxref VALUES (3351, 27, '0000119', '', NULL);
INSERT INTO chado.dbxref VALUES (3352, 27, '0000120', '', NULL);
INSERT INTO chado.dbxref VALUES (3353, 27, '0000121', '', NULL);
INSERT INTO chado.dbxref VALUES (3354, 27, '0000122', '', NULL);
INSERT INTO chado.dbxref VALUES (3355, 27, '0000123', '', NULL);
INSERT INTO chado.dbxref VALUES (3356, 27, '0000124', '', NULL);
INSERT INTO chado.dbxref VALUES (3357, 27, '0000125', '', NULL);
INSERT INTO chado.dbxref VALUES (3358, 27, '0000126', '', NULL);
INSERT INTO chado.dbxref VALUES (3359, 27, '0000127', '', NULL);
INSERT INTO chado.dbxref VALUES (3360, 27, '0000128', '', NULL);
INSERT INTO chado.dbxref VALUES (3361, 27, '0000129', '', NULL);
INSERT INTO chado.dbxref VALUES (3362, 27, '0000130', '', NULL);
INSERT INTO chado.dbxref VALUES (3363, 27, '0000131', '', NULL);
INSERT INTO chado.dbxref VALUES (3364, 27, '0000132', '', NULL);
INSERT INTO chado.dbxref VALUES (3365, 27, '0000133', '', NULL);
INSERT INTO chado.dbxref VALUES (3366, 27, '0000134', '', NULL);
INSERT INTO chado.dbxref VALUES (3367, 27, '0000135', '', NULL);
INSERT INTO chado.dbxref VALUES (3368, 27, '0000136', '', NULL);
INSERT INTO chado.dbxref VALUES (3369, 27, '0000137', '', NULL);
INSERT INTO chado.dbxref VALUES (3370, 27, '0000138', '', NULL);
INSERT INTO chado.dbxref VALUES (3371, 27, '0000139', '', NULL);
INSERT INTO chado.dbxref VALUES (3372, 27, '0000140', '', NULL);
INSERT INTO chado.dbxref VALUES (3373, 27, '0000141', '', NULL);
INSERT INTO chado.dbxref VALUES (3374, 27, '0000142', '', NULL);
INSERT INTO chado.dbxref VALUES (3375, 27, '0000143', '', NULL);
INSERT INTO chado.dbxref VALUES (3376, 27, '0000144', '', NULL);
INSERT INTO chado.dbxref VALUES (3377, 27, '0000145', '', NULL);
INSERT INTO chado.dbxref VALUES (3378, 27, '0000146', '', NULL);
INSERT INTO chado.dbxref VALUES (3379, 27, '0000147', '', NULL);
INSERT INTO chado.dbxref VALUES (3380, 27, '0000148', '', NULL);
INSERT INTO chado.dbxref VALUES (3381, 27, '0000149', '', NULL);
INSERT INTO chado.dbxref VALUES (3382, 27, '0000150', '', NULL);
INSERT INTO chado.dbxref VALUES (3383, 27, '0000151', '', NULL);
INSERT INTO chado.dbxref VALUES (3384, 27, '0000152', '', NULL);
INSERT INTO chado.dbxref VALUES (3385, 27, '0000153', '', NULL);
INSERT INTO chado.dbxref VALUES (3386, 27, '0000154', '', NULL);
INSERT INTO chado.dbxref VALUES (3387, 27, '0000155', '', NULL);
INSERT INTO chado.dbxref VALUES (3388, 27, '0000156', '', NULL);
INSERT INTO chado.dbxref VALUES (3389, 27, '0000157', '', NULL);
INSERT INTO chado.dbxref VALUES (3390, 27, '0000158', '', NULL);
INSERT INTO chado.dbxref VALUES (3391, 27, '0000159', '', NULL);
INSERT INTO chado.dbxref VALUES (3392, 27, '0000160', '', NULL);
INSERT INTO chado.dbxref VALUES (3393, 27, '0000161', '', NULL);
INSERT INTO chado.dbxref VALUES (3394, 27, '0000162', '', NULL);
INSERT INTO chado.dbxref VALUES (3395, 27, '0000163', '', NULL);
INSERT INTO chado.dbxref VALUES (3396, 27, '0000164', '', NULL);
INSERT INTO chado.dbxref VALUES (3397, 27, '0000165', '', NULL);
INSERT INTO chado.dbxref VALUES (3398, 27, '0000166', '', NULL);
INSERT INTO chado.dbxref VALUES (3399, 27, '0000167', '', NULL);
INSERT INTO chado.dbxref VALUES (3400, 27, '0000168', '', NULL);
INSERT INTO chado.dbxref VALUES (3401, 27, '0000169', '', NULL);
INSERT INTO chado.dbxref VALUES (3402, 27, '0000170', '', NULL);
INSERT INTO chado.dbxref VALUES (3403, 27, '0000171', '', NULL);
INSERT INTO chado.dbxref VALUES (3404, 27, '0000172', '', NULL);
INSERT INTO chado.dbxref VALUES (3405, 27, '0000173', '', NULL);
INSERT INTO chado.dbxref VALUES (3406, 27, '0000174', '', NULL);
INSERT INTO chado.dbxref VALUES (3407, 27, '0000175', '', NULL);
INSERT INTO chado.dbxref VALUES (3408, 27, '0000176', '', NULL);
INSERT INTO chado.dbxref VALUES (3409, 27, '0000177', '', NULL);
INSERT INTO chado.dbxref VALUES (3410, 27, '0000178', '', NULL);
INSERT INTO chado.dbxref VALUES (3411, 27, '0000179', '', NULL);
INSERT INTO chado.dbxref VALUES (3412, 27, '0000180', '', NULL);
INSERT INTO chado.dbxref VALUES (3413, 27, '0000181', '', NULL);
INSERT INTO chado.dbxref VALUES (3414, 27, '0000182', '', NULL);
INSERT INTO chado.dbxref VALUES (3415, 27, '0000183', '', NULL);
INSERT INTO chado.dbxref VALUES (3416, 27, '0000184', '', NULL);
INSERT INTO chado.dbxref VALUES (3417, 27, '0000185', '', NULL);
INSERT INTO chado.dbxref VALUES (3418, 27, '0000186', '', NULL);
INSERT INTO chado.dbxref VALUES (3419, 27, '0000187', '', NULL);
INSERT INTO chado.dbxref VALUES (3420, 27, '0000188', '', NULL);
INSERT INTO chado.dbxref VALUES (3421, 27, '0000189', '', NULL);
INSERT INTO chado.dbxref VALUES (3422, 27, '0000190', '', NULL);
INSERT INTO chado.dbxref VALUES (3423, 27, '0000191', '', NULL);
INSERT INTO chado.dbxref VALUES (3424, 27, '0000192', '', NULL);
INSERT INTO chado.dbxref VALUES (3425, 27, '0000193', '', NULL);
INSERT INTO chado.dbxref VALUES (3426, 27, '0000194', '', NULL);
INSERT INTO chado.dbxref VALUES (3427, 27, '0000195', '', NULL);
INSERT INTO chado.dbxref VALUES (3428, 27, '0000196', '', NULL);
INSERT INTO chado.dbxref VALUES (3429, 27, '0000197', '', NULL);
INSERT INTO chado.dbxref VALUES (3430, 27, '0000198', '', NULL);
INSERT INTO chado.dbxref VALUES (3431, 27, '0000199', '', NULL);
INSERT INTO chado.dbxref VALUES (3432, 27, '0000200', '', NULL);
INSERT INTO chado.dbxref VALUES (3433, 27, '0000201', '', NULL);
INSERT INTO chado.dbxref VALUES (3434, 27, '0000202', '', NULL);
INSERT INTO chado.dbxref VALUES (3435, 27, '0000203', '', NULL);
INSERT INTO chado.dbxref VALUES (3436, 27, '0000204', '', NULL);
INSERT INTO chado.dbxref VALUES (3437, 27, '0000205', '', NULL);
INSERT INTO chado.dbxref VALUES (3438, 27, '0000206', '', NULL);
INSERT INTO chado.dbxref VALUES (3439, 27, '0000207', '', NULL);
INSERT INTO chado.dbxref VALUES (3440, 27, '0000208', '', NULL);
INSERT INTO chado.dbxref VALUES (3441, 27, '0000209', '', NULL);
INSERT INTO chado.dbxref VALUES (3442, 27, '0000210', '', NULL);
INSERT INTO chado.dbxref VALUES (3443, 27, '0000211', '', NULL);
INSERT INTO chado.dbxref VALUES (3444, 27, '0000212', '', NULL);
INSERT INTO chado.dbxref VALUES (3445, 27, '0000213', '', NULL);
INSERT INTO chado.dbxref VALUES (3446, 27, '0000214', '', NULL);
INSERT INTO chado.dbxref VALUES (3447, 27, '0000215', '', NULL);
INSERT INTO chado.dbxref VALUES (3448, 27, '0000216', '', NULL);
INSERT INTO chado.dbxref VALUES (3449, 27, '0000217', '', NULL);
INSERT INTO chado.dbxref VALUES (3450, 27, '0000218', '', NULL);
INSERT INTO chado.dbxref VALUES (3451, 27, '0000219', '', NULL);
INSERT INTO chado.dbxref VALUES (3452, 27, '0000220', '', NULL);
INSERT INTO chado.dbxref VALUES (3453, 27, '0000221', '', NULL);
INSERT INTO chado.dbxref VALUES (3454, 27, '0000222', '', NULL);
INSERT INTO chado.dbxref VALUES (3455, 27, '0000223', '', NULL);
INSERT INTO chado.dbxref VALUES (3456, 27, '0000224', '', NULL);
INSERT INTO chado.dbxref VALUES (3457, 27, '0000225', '', NULL);
INSERT INTO chado.dbxref VALUES (3458, 27, '0000226', '', NULL);
INSERT INTO chado.dbxref VALUES (3459, 27, '0000227', '', NULL);
INSERT INTO chado.dbxref VALUES (3460, 27, '0000228', '', NULL);
INSERT INTO chado.dbxref VALUES (3461, 27, '0000229', '', NULL);
INSERT INTO chado.dbxref VALUES (3462, 27, '0000230', '', NULL);
INSERT INTO chado.dbxref VALUES (3463, 27, '0000231', '', NULL);
INSERT INTO chado.dbxref VALUES (3464, 27, '0000232', '', NULL);
INSERT INTO chado.dbxref VALUES (3465, 27, '0000233', '', NULL);
INSERT INTO chado.dbxref VALUES (3466, 27, '0000234', '', NULL);
INSERT INTO chado.dbxref VALUES (3467, 27, '0000235', '', NULL);
INSERT INTO chado.dbxref VALUES (3468, 27, '0000236', '', NULL);
INSERT INTO chado.dbxref VALUES (3469, 27, '0000237', '', NULL);
INSERT INTO chado.dbxref VALUES (3470, 27, '0000238', '', NULL);
INSERT INTO chado.dbxref VALUES (3471, 27, '0000239', '', NULL);
INSERT INTO chado.dbxref VALUES (3472, 27, '0000241', '', NULL);
INSERT INTO chado.dbxref VALUES (3473, 27, '0000242', '', NULL);
INSERT INTO chado.dbxref VALUES (3474, 27, '0000244', '', NULL);
INSERT INTO chado.dbxref VALUES (3475, 27, '0000245', '', NULL);
INSERT INTO chado.dbxref VALUES (3476, 27, '0000246', '', NULL);
INSERT INTO chado.dbxref VALUES (3477, 27, '0000247', '', NULL);
INSERT INTO chado.dbxref VALUES (3478, 27, '0000248', '', NULL);
INSERT INTO chado.dbxref VALUES (3479, 27, '0000249', '', NULL);
INSERT INTO chado.dbxref VALUES (3480, 27, '0000250', '', NULL);
INSERT INTO chado.dbxref VALUES (3481, 27, '0000251', '', NULL);
INSERT INTO chado.dbxref VALUES (3482, 27, '0000252', '', NULL);
INSERT INTO chado.dbxref VALUES (3483, 27, '0000253', '', NULL);
INSERT INTO chado.dbxref VALUES (3484, 27, '0000254', '', NULL);
INSERT INTO chado.dbxref VALUES (3485, 27, '0000255', '', NULL);
INSERT INTO chado.dbxref VALUES (3486, 15, 'lineageex', '', NULL);
INSERT INTO chado.dbxref VALUES (3487, 20, 'C16493', '', NULL);
INSERT INTO chado.dbxref VALUES (3488, 31, '001377', '', NULL);
INSERT INTO chado.dbxref VALUES (3489, 4, '1122', '', NULL);
INSERT INTO chado.dbxref VALUES (3490, 8, '0007059', '', NULL);
INSERT INTO chado.dbxref VALUES (3491, 8, '0005136', '', NULL);
INSERT INTO chado.dbxref VALUES (3492, 12, '0002076', '', NULL);
INSERT INTO chado.dbxref VALUES (3493, 41, '0000065', '', NULL);
INSERT INTO chado.cvterm VALUES (1, 1, 'null', NULL, 1, 0, 0);
INSERT INTO chado.cvterm VALUES (2, 4, 'version', 'Chado schema version', 2, 0, 0);
INSERT INTO chado.cvterm VALUES (3, 5, 'accession', '', 3, 0, 0);
INSERT INTO chado.cvterm VALUES (4, 5, 'generated germplasm', '', 4, 0, 0);
INSERT INTO chado.cvterm VALUES (5, 5, 'cultivar', '', 5, 0, 0);
INSERT INTO chado.cvterm VALUES (6, 5, '414 inbred line', '', 6, 0, 0);
INSERT INTO chado.cvterm VALUES (7, 6, 'Service', 'A system that provides one or more functions.', 7, 0, 0);
INSERT INTO chado.cvterm VALUES (8, 7, 'Sequence length', 'The size (length) of a sequence, subsequence or region in a sequence, or range(s) of lengths.', 8, 0, 0);
INSERT INTO chado.cvterm VALUES (9, 7, 'Sequence checksum', 'A fixed-size datum calculated (by using a hash function) for a molecular sequence, typically for purposes of error detection or indexing.', 9, 0, 0);
INSERT INTO chado.cvterm VALUES (10, 7, 'Accession', 'A persistent (stable) and unique identifier, typically identifying an object (entry) from a database.', 10, 0, 0);
INSERT INTO chado.cvterm VALUES (11, 7, 'Sequence', 'One or more molecular sequences, possibly with associated annotation.', 11, 0, 0);
INSERT INTO chado.cvterm VALUES (12, 7, 'Sequence record', 'A molecular sequence and associated metadata.', 12, 0, 0);
INSERT INTO chado.cvterm VALUES (13, 7, 'Identifier', 'A text token, number or something else which identifies an entity, but which may not be persistent (stable) or unique (the same identifier may identify multiple things).', 13, 0, 0);
INSERT INTO chado.cvterm VALUES (14, 7, 'Protein sequence', 'One or more protein sequences, possibly with associated annotation.', 14, 0, 0);
INSERT INTO chado.cvterm VALUES (15, 7, 'Image', 'Biological or biomedical data has been rendered into an image, typically for display on screen.', 15, 0, 0);
INSERT INTO chado.cvterm VALUES (16, 7, 'Map', 'A map of (typically one) DNA sequence annotated with positional or non-positional features.', 16, 0, 0);
INSERT INTO chado.cvterm VALUES (17, 7, 'Genetic map', 'A map showing the relative positions of genetic markers in a nucleic acid sequence, based on estimation of non-physical distance such as recombination frequencies.', 17, 0, 0);
INSERT INTO chado.cvterm VALUES (18, 7, 'Physical map', 'A map of DNA (linear or circular) annotated with physical features or landmarks such as restriction sites, cloned DNA fragments, genes or genetic markers, along with the physical distances between them. Distance in a physical map is measured in base pairs. A physical map might be ordered relative to a reference map (typically a genetic map) in the process of genome sequencing.', 18, 0, 0);
INSERT INTO chado.cvterm VALUES (19, 7, 'Sequence coordinates', 'A position in a map (for example a genetic map), either a single position (point) or a region / interval.', 19, 0, 0);
INSERT INTO chado.cvterm VALUES (20, 7, 'Database name', 'The name of a biological or bioinformatics database.', 20, 0, 0);
INSERT INTO chado.cvterm VALUES (21, 7, 'Database ID', 'An identifier of a biological or bioinformatics database.', 21, 0, 0);
INSERT INTO chado.cvterm VALUES (22, 7, 'URI', 'The name of a biological or bioinformatics database.', 22, 0, 0);
INSERT INTO chado.cvterm VALUES (23, 7, 'Translation phase specification', 'Phase for translation of DNA (0, 1 or 2) relative to a fragment of the coding sequence.', 23, 0, 0);
INSERT INTO chado.cvterm VALUES (24, 7, 'DNA sense specification', 'The strand of a DNA sequence (forward or reverse).', 24, 0, 0);
INSERT INTO chado.cvterm VALUES (25, 7, 'Annotation track', 'Annotation of one particular positional feature on a biomolecular (typically genome) sequence, suitable for import and display in a genome browser. Synonym: Sequence annotation track.', 25, 0, 0);
INSERT INTO chado.cvterm VALUES (26, 7, 'Phylogenetic tree', 'The raw data (not just an image) from which a phylogenetic tree is directly generated or plotted, such as topology, lengths (in time or in expected amounts of variance) and a confidence interval for each length.', 26, 0, 0);
INSERT INTO chado.cvterm VALUES (27, 7, 'Species tree', 'A phylogenetic tree that reflects phylogeny of the taxa from which the characters (used in calculating the tree) were sampled.', 27, 0, 0);
INSERT INTO chado.cvterm VALUES (28, 7, 'Gene tree', 'A phylogenetic tree that is an estimate of the character''s phylogeny.', 28, 0, 0);
INSERT INTO chado.cvterm VALUES (29, 7, 'Phylogenetic tree visualisation', 'A phylogenetic tree that is an estimate of the character''s phylogeny.', 29, 0, 0);
INSERT INTO chado.cvterm VALUES (30, 7, 'Sequence visualisation', 'Visualise, format or render a molecular sequence or sequences such as a sequence alignment, possibly with sequence features or properties shown.', 30, 0, 0);
INSERT INTO chado.cvterm VALUES (31, 7, 'genome assembly', '', 31, 0, 0);
INSERT INTO chado.cvterm VALUES (32, 7, 'Genome annotation', '', 32, 0, 0);
INSERT INTO chado.cvterm VALUES (33, 7, 'Analysis', 'Apply analytical methods to existing data of a specific type.', 33, 0, 0);
INSERT INTO chado.cvterm VALUES (34, 7, 'Sequence range', 'Specification of range(s) of sequence positions.', 34, 0, 0);
INSERT INTO chado.cvterm VALUES (35, 8, 'instrument', 'An instrument is a device which provides a mechanical or electronic function.', 35, 0, 0);
INSERT INTO chado.cvterm VALUES (37, 8, 'substrate type', 'Controlled terms for descriptors of types of array substrates.', 37, 0, 0);
INSERT INTO chado.cvterm VALUES (38, 8, 'array manufacturer', '', 38, 0, 0);
INSERT INTO chado.cvterm VALUES (36, 8, 'array design', 'An instrument design which describes the design of the array.', 36, 0, 0);
INSERT INTO chado.cvterm VALUES (39, 9, 'database', 'A database is an organized collection of data, today typically in digital form.', 39, 0, 0);
INSERT INTO chado.cvterm VALUES (40, 9, 'data acquisition', 'A technique that samples real world physical conditions and conversion of the resulting samples into digital numeric values that can be manipulated by a computer.', 40, 0, 0);
INSERT INTO chado.cvterm VALUES (41, 10, 'geodetic datum', 'A coordinate system, and a set of reference points, used to locate places on the Earth (or similar objects).', 41, 0, 0);
INSERT INTO chado.cvterm VALUES (42, 11, 'rank order', 'A data item that represents an arrangement according to a rank, i.e., the position of a particular case relative to other cases on a defined scale.', 42, 0, 0);
INSERT INTO chado.cvterm VALUES (43, 12, 'organism', 'A material entity that is an individual living system, such as animal, plant, bacteria or virus, that is capable of replicating or reproducing, growth and maintenance in the right environment. An organism may be unicellular or made up, like humans, of many billions of cells divided into specialized tissues and organs.', 43, 0, 0);
INSERT INTO chado.cvterm VALUES (44, 12, 'assay', 'A planned process with the objective to produce information about the material entity that is the evaluant, by physically examining it or its proxies.', 44, 0, 0);
INSERT INTO chado.cvterm VALUES (45, 13, 'location on map', '', 45, 0, 0);
INSERT INTO chado.cvterm VALUES (46, 14, 'algorithm', 'An algorithm is a set of instructions for performing a particular calculation.', 46, 0, 0);
INSERT INTO chado.cvterm VALUES (47, 14, 'data format specification', 'A data format specification is the information content borne by the document published defining the specification.', 47, 0, 0);
INSERT INTO chado.cvterm VALUES (91, 2, 'num_sub_columns', 'The number of sub columns.', 91, 0, 0);
INSERT INTO chado.cvterm VALUES (92, 2, 'num_sub_rows', 'The number of sub rows.', 92, 0, 0);
INSERT INTO chado.cvterm VALUES (48, 14, 'image', 'An image is an affine projection to a two dimensional surface, of measurements of some quality of an entity or entities repeated at regular intervals across a spatial range, where the measurements are represented as color and luminosity on the projected on surface.', 48, 0, 0);
INSERT INTO chado.cvterm VALUES (49, 14, 'definition', 'The official OBI definition, explaining the meaning of a class or property. Shall be Aristotelian, formalized and normalized. Can be augmented with colloquial definitions.', 49, 0, 0);
INSERT INTO chado.cvterm VALUES (50, 14, 'version number', 'A version number is an information content entity which is a sequence of characters borne by part of each of a class of manufactured products or its packaging and indicates its order within a set of other products having the same name.', 50, 0, 0);
INSERT INTO chado.cvterm VALUES (51, 2, 'property', 'A generic term indicating that represents an attribute, quality or characteristic of something.', 51, 0, 0);
INSERT INTO chado.cvterm VALUES (52, 2, 'time_last_modified', 'The time at which the record was last modified.', 52, 0, 0);
INSERT INTO chado.cvterm VALUES (53, 2, 'time_accessioned', 'The time at which the record was first added.', 53, 0, 0);
INSERT INTO chado.cvterm VALUES (54, 2, 'time_executed', 'The time when the task was executed.', 54, 0, 0);
INSERT INTO chado.cvterm VALUES (55, 2, 'infraspecific_type', 'The connector type (e.g. subspecies, varietas, forma, etc.) for the infraspecific name', 55, 0, 0);
INSERT INTO chado.cvterm VALUES (56, 2, 'abbreviation', 'A shortened name (or abbreviation) for the item.', 56, 0, 0);
INSERT INTO chado.cvterm VALUES (57, 2, 'expression', 'Curated expression data', 57, 0, 0);
INSERT INTO chado.cvterm VALUES (58, 2, 'is_analysis', 'Indicates if this feature was predicted computationally using another feature.', 58, 0, 0);
INSERT INTO chado.cvterm VALUES (59, 2, 'is_obsolete', 'Indicates if this record is obsolete.', 59, 0, 0);
INSERT INTO chado.cvterm VALUES (60, 2, 'is_current', 'Indicates if this record is current.', 60, 0, 0);
INSERT INTO chado.cvterm VALUES (61, 2, 'is_internal', 'Indicates if this record is internal and not normally available outside of a local setting.', 61, 0, 0);
INSERT INTO chado.cvterm VALUES (62, 2, 'Mini-ref', 'A small in-house unique identifier for a publication.', 62, 0, 0);
INSERT INTO chado.cvterm VALUES (63, 2, 'Array Batch Identifier', 'A unique identifier for an array batch.', 63, 0, 0);
INSERT INTO chado.cvterm VALUES (64, 2, 'clause subject', 'The subject of a relationship clause.', 64, 0, 0);
INSERT INTO chado.cvterm VALUES (65, 2, 'clause predicate', 'The object of a relationship clause.', 65, 0, 0);
INSERT INTO chado.cvterm VALUES (66, 2, 'relationship type', 'The relationship type.', 66, 0, 0);
INSERT INTO chado.cvterm VALUES (67, 2, 'fasta_definition', 'The definition line for a FASTA formatted sequence', 67, 0, 0);
INSERT INTO chado.cvterm VALUES (68, 2, 'Reference Feature', 'A genomic or genetic feature on which other features are mapped.', 68, 0, 0);
INSERT INTO chado.cvterm VALUES (69, 2, 'minimal boundary', 'The leftmost, minimal boundary in the linear range represented by the feature location. Sometimes this is called start although this is confusing because it does not necessarily represent the 5-prime coordinate.', 69, 0, 0);
INSERT INTO chado.cvterm VALUES (70, 2, 'is_fmin_partial', 'This is typically false, but may be true if the value for column:fmin is inaccurate or the leftmost part of the range is unknown/unbounded.', 70, 0, 0);
INSERT INTO chado.cvterm VALUES (71, 2, 'maximal boundary', 'The rightmost, maximal boundary in the linear range represented by the featureloc. Sometimes this is called end although this is confusing because it does not necessarily represent the 3-prime coordinate', 71, 0, 0);
INSERT INTO chado.cvterm VALUES (72, 2, 'is_fmax_partial', 'This is typically false, but may be true if the value for column:fmax is inaccurate or the rightmost part of the range is unknown/unbounded.', 72, 0, 0);
INSERT INTO chado.cvterm VALUES (73, 2, 'residue_info', 'Alternative residues, when these differ from feature.residues.', 73, 0, 0);
INSERT INTO chado.cvterm VALUES (74, 2, 'locgroup', 'This is used to manifest redundant, derivable extra locations for a feature.', 74, 0, 0);
INSERT INTO chado.cvterm VALUES (75, 2, 'analysis', 'A process as a method of studying the nature of something or of determining its essential features and their relations. (Random House Kernerman Webster''s College Dictionary, © 2010 K Dictionaries Ltd).', 75, 0, 0);
INSERT INTO chado.cvterm VALUES (76, 2, 'source_data', 'The location where data that is being used come from.', 76, 0, 0);
INSERT INTO chado.cvterm VALUES (77, 2, 'rawscore', 'This is the native score generated by the program; for example, the bitscore generated by blast, sim4 or genscan scores. One should not assume that high is necessarily better than low.', 77, 0, 0);
INSERT INTO chado.cvterm VALUES (78, 2, 'normscore', 'This is the rawscore but semi-normalized. Complete normalization to allow comparison of features generated by different programs would be nice but too difficult. Instead the normalization should strive to enforce the following semantics: * normscores are floating point numbers >= 0, * high normscores are better than low one. For most programs, it would be sufficient to make the normscore the same as this rawscore, providing these semantics are satisfied.', 78, 0, 0);
INSERT INTO chado.cvterm VALUES (79, 2, 'significance', 'This is some kind of expectation or probability metric, representing the probability that the analysis would appear randomly given the model. As such, any program or person querying this table can assume the following semantics: * 0 <= significance <= n, where n is a positive number, theoretically unbounded but unlikely to be more than 10 * low numbers are better than high numbers.', 79, 0, 0);
INSERT INTO chado.cvterm VALUES (80, 2, 'identity', 'Percent identity between the locations compared. Note that these 4 metrics do not cover the full range of scores possible; it would be undesirable to list every score possible, as this should be kept extensible. instead, for non-standard scores, use the analysisprop table.', 80, 0, 0);
INSERT INTO chado.cvterm VALUES (81, 2, 'contact', 'An entity (e.g. individual or organization) through whom a person can gain access to information, favors, influential people, and the like.', 81, 0, 0);
INSERT INTO chado.cvterm VALUES (82, 2, 'relationship', 'The way in which two things are connected.', 82, 0, 0);
INSERT INTO chado.cvterm VALUES (83, 2, 'biomaterial', 'A biomaterial represents the MAGE concept of BioSource, BioSample, and LabeledExtract. It is essentially some biological material (tissue, cells, serum) that may have been processed. Processed biomaterials should be traceable back to raw biomaterials via the biomaterialrelationship table.', 83, 0, 0);
INSERT INTO chado.cvterm VALUES (84, 2, 'array_dimensions', 'The dimensions of an array.', 84, 0, 0);
INSERT INTO chado.cvterm VALUES (85, 2, 'element_dimensions', 'The dimensions of an element.', 85, 0, 0);
INSERT INTO chado.cvterm VALUES (86, 2, 'num_of_elements', 'The number of elements.', 86, 0, 0);
INSERT INTO chado.cvterm VALUES (87, 2, 'num_array_columns', 'The number of columns in an array.', 87, 0, 0);
INSERT INTO chado.cvterm VALUES (88, 2, 'num_array_rows', 'The number of rows in an array.', 88, 0, 0);
INSERT INTO chado.cvterm VALUES (89, 2, 'num_grid_columns', 'The number of columns in a grid.', 89, 0, 0);
INSERT INTO chado.cvterm VALUES (90, 2, 'num_grid_rows', 'The number of rows in a grid.', 90, 0, 0);
INSERT INTO chado.cvterm VALUES (93, 2, 'Genome Project', 'A project for whole genome analysis that can include assembly and annotation.', 93, 0, 0);
INSERT INTO chado.cvterm VALUES (94, 2, 'rank', 'A taxonmic rank', 94, 0, 0);
INSERT INTO chado.cvterm VALUES (95, 2, 'lineage', '', 95, 0, 0);
INSERT INTO chado.cvterm VALUES (96, 2, 'genetic_code', '', 96, 0, 0);
INSERT INTO chado.cvterm VALUES (97, 2, 'genetic_code_name', '', 97, 0, 0);
INSERT INTO chado.cvterm VALUES (98, 2, 'mitochondrial_genetic_code', '', 98, 0, 0);
INSERT INTO chado.cvterm VALUES (99, 2, 'mitochondrial_genetic_code_name', '', 99, 0, 0);
INSERT INTO chado.cvterm VALUES (100, 2, 'division', '', 100, 0, 0);
INSERT INTO chado.cvterm VALUES (101, 2, 'genbank_common_name', '', 101, 0, 0);
INSERT INTO chado.cvterm VALUES (102, 2, 'synonym', '', 102, 0, 0);
INSERT INTO chado.cvterm VALUES (103, 2, 'synonym_sgml', 'The fully specified synonym, with any non-ascii characters encoded in SGML.', 103, 0, 0);
INSERT INTO chado.cvterm VALUES (104, 2, 'other_name', '', 104, 0, 0);
INSERT INTO chado.cvterm VALUES (105, 2, 'equivalent_name', '', 105, 0, 0);
INSERT INTO chado.cvterm VALUES (106, 2, 'anamorph', '', 106, 0, 0);
INSERT INTO chado.cvterm VALUES (107, 2, 'Analysis Type', 'The type of analysis that was performed.', 107, 0, 0);
INSERT INTO chado.cvterm VALUES (108, 2, 'phylo_leaf', 'A leaf node in a phylogenetic tree.', 108, 0, 0);
INSERT INTO chado.cvterm VALUES (109, 2, 'phylo_root', 'The root node of a phylogenetic tree.', 109, 0, 0);
INSERT INTO chado.cvterm VALUES (110, 2, 'phylo_interior', 'An interior node in a phylogenetic tree.', 110, 0, 0);
INSERT INTO chado.cvterm VALUES (111, 2, 'taxonomy', 'Deprecated: A term used to indicate if a phylotree is a taxonomic tree', 111, 0, 0);
INSERT INTO chado.cvterm VALUES (112, 2, 'cM', 'Centimorgan units', 112, 0, 0);
INSERT INTO chado.cvterm VALUES (113, 2, 'bp', 'Base pairs units', 113, 0, 0);
INSERT INTO chado.cvterm VALUES (114, 2, 'bin_unit', 'The bin unit', 114, 0, 0);
INSERT INTO chado.cvterm VALUES (115, 2, 'marker_order', 'Units simply to define marker order.', 115, 0, 0);
INSERT INTO chado.cvterm VALUES (116, 2, 'undefined', 'A catch-all for an undefined unit type', 116, 0, 0);
INSERT INTO chado.cvterm VALUES (117, 2, 'start', 'The start coordinate for a map feature.', 117, 0, 0);
INSERT INTO chado.cvterm VALUES (118, 2, 'stop', 'The end coordinate for a map feature', 118, 0, 0);
INSERT INTO chado.cvterm VALUES (119, 2, 'Map Dbxref', 'A unique identifer for the map in a remote database.  The format is a database abbreviation and a unique accession separated by a colon.  (e.g. Gramene:tsh1996a)', 119, 0, 0);
INSERT INTO chado.cvterm VALUES (120, 2, 'Map Type', 'The type of Map (e.g. QTL, Physical, etc.)', 120, 0, 0);
INSERT INTO chado.cvterm VALUES (121, 2, 'Genome Group', '', 121, 0, 0);
INSERT INTO chado.cvterm VALUES (122, 2, 'URL', 'A univeral resource locator (URL) reference where the publication can be found.  For maps found online, this would be the web address for the map.', 122, 0, 0);
INSERT INTO chado.cvterm VALUES (123, 2, 'Population Type', 'A brief description of the population type used to generate the map (e.g. RIL, F2, BC1, etc).', 123, 0, 0);
INSERT INTO chado.cvterm VALUES (124, 2, 'Population Size', 'The size of the population used to construct the map.', 124, 0, 0);
INSERT INTO chado.cvterm VALUES (125, 2, 'Methods', 'A brief description of the methods used to construct the map.', 125, 0, 0);
INSERT INTO chado.cvterm VALUES (126, 2, 'Software', 'The software used to construct the map.', 126, 0, 0);
INSERT INTO chado.cvterm VALUES (127, 2, 'Library', 'A group of physical entities organized into a collection', 127, 0, 0);
INSERT INTO chado.cvterm VALUES (128, 2, 'Library Description', 'Description of a library', 128, 0, 0);
INSERT INTO chado.cvterm VALUES (129, 2, 'cdna_library', 'cDNA library', 129, 0, 0);
INSERT INTO chado.cvterm VALUES (130, 2, 'bac_library', 'Bacterial Artifical Chromsome (BAC) library', 130, 0, 0);
INSERT INTO chado.cvterm VALUES (131, 2, 'fosmid_library', 'Fosmid library', 131, 0, 0);
INSERT INTO chado.cvterm VALUES (132, 2, 'cosmid_library', 'Cosmid library', 132, 0, 0);
INSERT INTO chado.cvterm VALUES (133, 2, 'yac_library', 'Yeast Artificial Chromosome (YAC) library', 133, 0, 0);
INSERT INTO chado.cvterm VALUES (134, 2, 'genomic_library', 'Genomic Library', 134, 0, 0);
INSERT INTO chado.cvterm VALUES (135, 2, 'Project Description', 'Description of a project', 135, 0, 0);
INSERT INTO chado.cvterm VALUES (136, 2, 'Project Type', 'A type of project', 136, 0, 0);
INSERT INTO chado.cvterm VALUES (137, 2, 'Study Type', 'A type of study', 137, 0, 0);
INSERT INTO chado.cvterm VALUES (138, 2, 'analysis_date', 'The date that an analysis was performed.', 138, 0, 0);
INSERT INTO chado.cvterm VALUES (139, 2, 'analysis_short_name', 'A computer legible (no spaces or special characters) abbreviation for the analysis.', 139, 0, 0);
INSERT INTO chado.cvterm VALUES (140, 2, 'Genotyping', 'An experiment where genotypes of individuals are identified.', 140, 0, 0);
INSERT INTO chado.cvterm VALUES (141, 2, 'Phenotyping', 'An experiment where phenotypes of individuals are identified.', 141, 0, 0);
INSERT INTO chado.cvterm VALUES (142, 2, 'Location', 'The name of the location.', 142, 0, 0);
INSERT INTO chado.cvterm VALUES (143, 15, 'phenotype', 'A biochemical network can generate phenotypes or affects biological processes. Such processes can take place at different levels and are independent of the biochemical network itself.', 143, 0, 0);
INSERT INTO chado.cvterm VALUES (144, 15, 'reference annotation', 'Additional information that supplements existing data, usually in a document, by providing a link to more detailed information, which is held externally, or elsewhere.', 144, 0, 0);
INSERT INTO chado.cvterm VALUES (145, 15, 'database cross reference', 'An annotation which directs one to information contained within a database.', 145, 0, 0);
INSERT INTO chado.cvterm VALUES (146, 15, 'relationship', 'Connectedness between entities and/or interactions representing their relatedness or influence.', 146, 0, 0);
INSERT INTO chado.cvterm VALUES (147, 16, 'software', 'Computer software, or generally just software, is any set of machine-readable instructions (most often in the form of a computer program) that conform to a given syntax (sometimes referred to as a language) that is interpretable by a given processor and that directs a computer''s processor to perform specific operations.', 147, 0, 0);
INSERT INTO chado.cvterm VALUES (148, 18, 'unit', 'A unit of measurement is a standardized quantity of a physical quality.', 148, 0, 0);
INSERT INTO chado.cvterm VALUES (149, 19, 'Date', 'The particular day, month and year an event has happened or will happen.', 149, 0, 0);
INSERT INTO chado.cvterm VALUES (150, 19, 'Operator', 'A person that operates some apparatus or machine', 150, 0, 0);
INSERT INTO chado.cvterm VALUES (151, 19, 'Technology Platform', 'The specific version (manufacturer, model, etc.) of a technology that is used to carry out a laboratory or computational experiment.', 151, 0, 0);
INSERT INTO chado.cvterm VALUES (152, 19, 'Value', 'A numerical quantity measured or assigned or computed.', 152, 0, 0);
INSERT INTO chado.cvterm VALUES (153, 19, 'Channel', 'An independent acquisition scheme, i.e., a route or conduit through which flows data consisting of one particular measurement using one particular parameter.', 153, 0, 0);
INSERT INTO chado.cvterm VALUES (154, 19, 'Controlled Vocabulary', 'A set of terms that are selected and defined based on the requirements set out by the user group, usually a set of vocabulary is chosen to promote consistency across data collection projects. [ NCI ]', 154, 0, 0);
INSERT INTO chado.cvterm VALUES (155, 19, 'Term', 'A word or expression used for some particular thing. [ NCI ]', 155, 0, 0);
INSERT INTO chado.cvterm VALUES (156, 19, 'Expression', 'A combination of symbols that represents a value. [ NCI ]', 156, 0, 0);
INSERT INTO chado.cvterm VALUES (157, 19, 'Phenotype', 'The assemblage of traits or outward appearance of an individual. It is the product of interactions between genes and between genes and the environment. [ NCI ]', 157, 0, 0);
INSERT INTO chado.cvterm VALUES (158, 19, 'Genotype', 'The genetic constitution of an organism or cell, as distinct from its expressed features or phenotype. [ NCI ]', 158, 0, 0);
INSERT INTO chado.cvterm VALUES (159, 19, 'Location', 'A position, site, or point in space where something can be found. [ NCI ]', 159, 0, 0);
INSERT INTO chado.cvterm VALUES (160, 19, 'Reagent', 'Any natural or synthetic substance used in a chemical or biological reaction in order to produce, identify, or measure another substance. [ NCI ]', 160, 0, 0);
INSERT INTO chado.cvterm VALUES (161, 19, 'Environment', 'The totality of surrounding conditions. [ NCI ]', 161, 0, 0);
INSERT INTO chado.cvterm VALUES (162, 19, 'Tree Node', 'A term that refers to any individual item or entity in a hierarchy or pedigree. [ NCI ]', 162, 0, 0);
INSERT INTO chado.cvterm VALUES (163, 19, 'Study Design', 'A plan detailing how a study will be performed in order to represent the phenomenon under examination, to answer the research questions that have been asked, and defining the methods of data analysis. Study design is driven by research hypothesis being posed, study subject/population/sample available, logistics/resources: technology, support, networking, collaborative support, etc. [ NCI ]', 163, 0, 0);
INSERT INTO chado.cvterm VALUES (164, 19, 'Company', 'Any formal business entity for profit, which may be a corporation, a partnership, association or individual proprietorship.', 164, 0, 0);
INSERT INTO chado.cvterm VALUES (165, 19, 'Project', 'Any specifically defined piece of work that is undertaken or attempted to meet a single requirement.', 165, 0, 0);
INSERT INTO chado.cvterm VALUES (166, 19, 'DNA Library', 'A collection of DNA molecules that have been cloned in vectors.', 166, 0, 0);
INSERT INTO chado.cvterm VALUES (167, 19, 'Trait', 'Any genetically determined characteristic.', 167, 0, 0);
INSERT INTO chado.cvterm VALUES (168, 19, 'Subgroup', 'A subdivision of a larger group with members often exhibiting similar characteristics. [ NCI ]', 168, 0, 0);
INSERT INTO chado.cvterm VALUES (169, 19, 'Namespace', 'In general, a namespace is an abstract container, which is or could be filled by names, or technical terms, or words, and these represent or stand for real-world things. A description logic terminology namespace is a collection of Kind, Role, Property and Concept definitions. As in computer programming, context namespaces are intended to allow multiple knowledge bases to reside in the same physical database. (from Apelon) [ NCI ]', 169, 0, 0);
INSERT INTO chado.cvterm VALUES (170, 19, 'Biospecimen', 'Any material sample taken from a biological entity for testing, diagnostic, propagation, treatment or research purposes, including a sample obtained from a living organism or taken from the biological object after halting of all its life functions.', 170, 0, 0);
INSERT INTO chado.cvterm VALUES (171, 19, 'Communication Contact', 'A channel for communication between groups.', 171, 0, 0);
INSERT INTO chado.cvterm VALUES (172, 19, 'Group', 'Any number of entities (members) considered as a unit.', 172, 0, 0);
INSERT INTO chado.cvterm VALUES (173, 19, 'Last Name', 'A word or group of words indicating a persons last (family) name.', 173, 0, 0);
INSERT INTO chado.cvterm VALUES (174, 19, 'Editor', 'A person who edits material for publication; a person having managerial and sometimes policy-making responsibility for the editorial part of a publishing firm or of a newspaper, magazine, or other publication; the supervisor or conductor of a department of a newspaper, magazine, etc.', 174, 0, 0);
INSERT INTO chado.cvterm VALUES (175, 19, 'First Name', 'A word or group of words indicating a persons first (personal or given) name; the name that precedes the surname.', 175, 0, 0);
INSERT INTO chado.cvterm VALUES (176, 19, 'Suffix', 'An affix occurring at the end of a word, word base, phrase, or name.', 176, 0, 0);
INSERT INTO chado.cvterm VALUES (177, 19, 'Distance', 'The space separating two objects or points.', 177, 0, 0);
INSERT INTO chado.cvterm VALUES (178, 19, 'Experimental Factor Value', 'A specific type, time period, compound, dose, temperature, magnitude, quantity, element, aspect or other item in a variable manipulated by the experimentalist. (BRIDG)', 178, 0, 0);
INSERT INTO chado.cvterm VALUES (179, 20, 'common name', '', 179, 0, 0);
INSERT INTO chado.cvterm VALUES (180, 20, 'scientific name', '', 180, 0, 0);
INSERT INTO chado.cvterm VALUES (181, 21, 'comment', 'A human-readable description of a resource.', 181, 0, 0);
INSERT INTO chado.cvterm VALUES (182, 21, 'type', 'The type of resource.', 182, 0, 0);
INSERT INTO chado.cvterm VALUES (183, 21, 'label', 'A human-readable version of a resource''s name.', 183, 0, 0);
INSERT INTO chado.cvterm VALUES (1141, 23, 'possible_assembly_error', 'A region of sequence where there may have been an error in the assembly. [SO:ke]', 1159, 0, 0);
INSERT INTO chado.cvterm VALUES (1248, 23, 'bacterial_RNApol_promoter_region', 'A region which is part of a bacterial RNA polymerase promoter. [SO:ke]', 1272, 1, 0);
INSERT INTO chado.cvterm VALUES (198, 27, 'Collection', 'A collection holding references to a number of related resources.', 198, 0, 0);
INSERT INTO chado.cvterm VALUES (199, 27, 'member', 'A member of the collection', 199, 0, 0);
INSERT INTO chado.cvterm VALUES (200, 27, 'description', 'A description.', 200, 0, 0);
INSERT INTO chado.cvterm VALUES (201, 27, 'totalItems', 'The total number of items referenced by a collection.', 201, 0, 0);
INSERT INTO chado.cvterm VALUES (185, 23, 'gene', 'A region (or regions) that includes all of the sequence elements necessary to encode a functional transcript. A gene may include regulatory regions, transcribed regions and/or other functional sequence regions. [SO:immuno_workshop]', 185, 0, 0);
INSERT INTO chado.cvterm VALUES (1249, 23, 'RNApol_II_promoter_region', 'A region of sequence which is a promoter for RNA polymerase II. [SO:ke]', 1273, 1, 0);
INSERT INTO chado.cvterm VALUES (1250, 23, 'RNApol_III_promoter_type_1_region', 'A region of sequence which is a promoter for RNA polymerase III type 1. [SO:ke]', 1274, 1, 0);
INSERT INTO chado.cvterm VALUES (189, 23, 'genetic_marker', 'A measurable sequence feature that varies within a population. [SO:db]', 189, 0, 0);
INSERT INTO chado.cvterm VALUES (191, 24, 'genus', '', 191, 0, 0);
INSERT INTO chado.cvterm VALUES (192, 24, 'species', '', 192, 0, 0);
INSERT INTO chado.cvterm VALUES (193, 24, 'infraspecies', '', 193, 0, 0);
INSERT INTO chado.cvterm VALUES (2954, 25, 'Institution', '', 3261, 0, 0);
INSERT INTO chado.cvterm VALUES (2955, 25, 'Organization(TCONTACT:0000018)', 'A generic term for any organization.', 3262, 0, 0);
INSERT INTO chado.cvterm VALUES (2956, 25, 'Address', '', 3263, 0, 0);
INSERT INTO chado.cvterm VALUES (2957, 25, 'Address Line 1', '', 3264, 0, 0);
INSERT INTO chado.cvterm VALUES (2958, 25, 'Address Line 2', '', 3265, 0, 0);
INSERT INTO chado.cvterm VALUES (2959, 25, 'Address Line 3', '', 3266, 0, 0);
INSERT INTO chado.cvterm VALUES (2960, 25, 'City', '', 3267, 0, 0);
INSERT INTO chado.cvterm VALUES (196, 26, 'Publication Type', '', 196, 0, 0);
INSERT INTO chado.cvterm VALUES (197, 26, 'Volume Title', '', 197, 0, 0);
INSERT INTO chado.cvterm VALUES (202, 27, 'title', 'A title, often used along with a description.', 202, 0, 0);
INSERT INTO chado.cvterm VALUES (203, 27, 'PartialCollectionView', 'A PartialCollectionView describes a partial view of a Collection. Multiple PartialCollectionViews can be connected with the next/previous properties to allow a client to retrieve all members of the collection.', 203, 0, 0);
INSERT INTO chado.cvterm VALUES (204, 28, 'name', 'The name of the item.', 204, 0, 0);
INSERT INTO chado.cvterm VALUES (205, 28, 'alternateName', 'An alias for the item.', 205, 0, 0);
INSERT INTO chado.cvterm VALUES (206, 28, 'comment', 'Comments, typically from users.', 206, 0, 0);
INSERT INTO chado.cvterm VALUES (207, 28, 'description', 'A description of the item.', 207, 0, 0);
INSERT INTO chado.cvterm VALUES (208, 28, 'publication', 'A publication event associated with the item.', 208, 0, 0);
INSERT INTO chado.cvterm VALUES (209, 28, 'url', 'URL of the item.', 209, 0, 0);
INSERT INTO chado.cvterm VALUES (210, 28, 'additionalType', 'An additional type for the item, typically used for adding more specific types from external vocabularies in microdata syntax. This is a relationship between something and a class that the thing is in.', 210, 0, 0);
INSERT INTO chado.cvterm VALUES (211, 28, 'ItemPage', 'A page devoted to a single item, such as a particular product or hotel.', 211, 0, 0);
INSERT INTO chado.cvterm VALUES (212, 29, 'biological sample', 'A biological sample analysed by a particular technology.', 212, 0, 0);
INSERT INTO chado.cvterm VALUES (213, 29, 'protocol', 'A protocol is a process which is a parameterizable description of a process.', 213, 0, 0);
INSERT INTO chado.cvterm VALUES (214, 30, 'namespace', 'A namespace is an informational entity that defines a logical container for a set of symbols or identifiers.', 214, 0, 0);
INSERT INTO chado.cvterm VALUES (215, 30, 'clause', 'A clause consists of a subject and a predicate.', 215, 0, 0);
INSERT INTO chado.cvterm VALUES (216, 30, 'references', 'references is a relation between one entity and the entity that it makes reference to by name, but is not described by it.', 216, 0, 0);
INSERT INTO chado.cvterm VALUES (217, 30, 'position', 'A measurement of a spatial location relative to a frame of reference or other objects.', 217, 0, 0);
INSERT INTO chado.cvterm VALUES (218, 30, 'annotation', 'An annotation is a written explanatory or critical description, or other in-context information (e.g., pattern, motif, link), that has been associated with data or other types of information.', 218, 0, 0);
INSERT INTO chado.cvterm VALUES (219, 30, 'negation', 'NOT is a logical operator in that has the value true if its operand is false.', 219, 0, 0);
INSERT INTO chado.cvterm VALUES (220, 30, 'record identifier', 'A record identifier is an identifier for a database entry.', 220, 0, 0);
INSERT INTO chado.cvterm VALUES (221, 30, 'vocabulary', 'A vocabulary is a collection of terms.', 221, 0, 0);
INSERT INTO chado.cvterm VALUES (222, 30, 'email address', 'an email address is an identifier to send mail to particular electronic mailbox.', 222, 0, 0);
INSERT INTO chado.cvterm VALUES (223, 30, 'assay', 'An assay is an investigative (analytic) procedure in laboratory medicine, pharmacology, environmental biology, and molecular biology for qualitatively assessing or quantitatively measuring the presence or amount or the functional activity of a target entity (the analyte) which can be a drug or biochemical substance or a cell in an organism or organic sample.', 223, 0, 0);
INSERT INTO chado.cvterm VALUES (224, 30, 'cell line', 'A cell line is a collection of genetically identifical cells.', 224, 0, 0);
INSERT INTO chado.cvterm VALUES (225, 30, 'study', 'A study is a process that realizes the steps of a study design.', 225, 0, 0);
INSERT INTO chado.cvterm VALUES (230, 23, 'adjacent_to', 'A geometric operator, specified in Egenhofer 1989. Two features meet if they share a junction on the sequence. X adjacent_to Y iff X and Y share a boundary but do not overlap. [PMID:20226267, SO:ke]', 230, 0, 1);
INSERT INTO chado.cvterm VALUES (231, 23, 'associated_with', '', 231, 0, 1);
INSERT INTO chado.cvterm VALUES (232, 23, 'complete_evidence_for_feature', 'B is complete_evidence_for_feature A if the extent (5'' and 3'' boundaries) and internal boundaries of B fully support the extent and internal boundaries of A. [SO:ke]', 232, 0, 1);
INSERT INTO chado.cvterm VALUES (233, 23, 'is_a', '', 233, 0, 1);
INSERT INTO chado.cvterm VALUES (234, 23, 'evidence_for_feature', 'B is evidence_for_feature A, if an instance of B supports the existence of A. [SO:ke]', 234, 0, 1);
INSERT INTO chado.cvterm VALUES (235, 23, 'connects_on', 'X connects_on Y, Z, R iff whenever Z is on a R, X is adjacent to a Y and adjacent to a Z. [PMID:20226267]', 235, 0, 1);
INSERT INTO chado.cvterm VALUES (236, 23, 'contained_by', 'X contained_by Y iff X starts after start of Y and X ends before end of Y. [PMID:20226267]', 236, 0, 1);
INSERT INTO chado.cvterm VALUES (237, 23, 'contains', 'The inverse of contained_by. [PMID:20226267]', 237, 0, 1);
INSERT INTO chado.cvterm VALUES (238, 23, 'derives_from', '', 238, 0, 1);
INSERT INTO chado.cvterm VALUES (239, 23, 'disconnected_from', 'X is disconnected_from Y iff it is not the case that X overlaps Y. [PMID:20226267]', 239, 0, 1);
INSERT INTO chado.cvterm VALUES (240, 23, 'edited_from', '', 240, 0, 1);
INSERT INTO chado.cvterm VALUES (241, 23, 'edited_to', '', 241, 0, 1);
INSERT INTO chado.cvterm VALUES (242, 23, 'exemplar_of', 'X is exemplar of Y if X is the best evidence for Y. [SO:ke]', 242, 0, 1);
INSERT INTO chado.cvterm VALUES (243, 23, 'finished_by', 'Xy is finished_by Y if Y part of X, and X and Y share a 3'' boundary. [PMID:20226267]', 243, 0, 1);
INSERT INTO chado.cvterm VALUES (244, 23, 'finishes', 'X finishes Y if X is part_of Y and X and Y share a 3'' or C terminal boundary. [PMID:20226267]', 244, 0, 1);
INSERT INTO chado.cvterm VALUES (245, 23, 'gained', 'X gained Y if X is a variant_of X'' and Y part of X but not X''. [SO:ke]', 245, 0, 1);
INSERT INTO chado.cvterm VALUES (246, 23, 'genome_of', '', 246, 0, 1);
INSERT INTO chado.cvterm VALUES (247, 23, 'guided_by', '', 247, 0, 1);
INSERT INTO chado.cvterm VALUES (248, 23, 'guides', '', 248, 0, 1);
INSERT INTO chado.cvterm VALUES (249, 23, 'has_integral_part', 'X has_integral_part Y if and only if: X has_part Y and Y part_of X. [http://precedings.nature.com/documents/3495/version/1]', 249, 0, 1);
INSERT INTO chado.cvterm VALUES (250, 23, 'has_part', 'Inverse of part_of. [http://precedings.nature.com/documents/3495/version/1]', 250, 0, 1);
INSERT INTO chado.cvterm VALUES (251, 23, 'has_origin', '', 251, 0, 1);
INSERT INTO chado.cvterm VALUES (252, 23, 'has_quality', '', 252, 0, 1);
INSERT INTO chado.cvterm VALUES (253, 23, 'homologous_to', '', 253, 0, 1);
INSERT INTO chado.cvterm VALUES (254, 23, 'similar_to', '', 254, 0, 1);
INSERT INTO chado.cvterm VALUES (255, 23, 'integral_part_of', 'X integral_part_of Y if and only if: X part_of Y and Y has_part X. [http://precedings.nature.com/documents/3495/version/1]', 255, 0, 1);
INSERT INTO chado.cvterm VALUES (256, 23, 'part_of', 'X part_of Y if X is a subregion of Y. [http://precedings.nature.com/documents/3495/version/1]', 256, 0, 1);
INSERT INTO chado.cvterm VALUES (257, 23, 'is_consecutive_sequence_of', 'R is_consecutive_sequence_of R iff every instance of R is equivalent to a collection of instances of U:u1, u2, un, such that no pair of ux uy is overlapping and for all ux, it is adjacent to ux-1 and ux+1, with the exception of the initial and terminal u1,and un (which may be identical). [PMID:20226267]', 257, 0, 1);
INSERT INTO chado.cvterm VALUES (227, 32, 'broad', '', 227, 0, 0);
INSERT INTO chado.cvterm VALUES (228, 32, 'narrow', '', 228, 0, 0);
INSERT INTO chado.cvterm VALUES (258, 23, 'lost', 'X lost Y if X is a variant_of X'' and Y part of X'' but not X. [SO:ke]', 258, 0, 1);
INSERT INTO chado.cvterm VALUES (259, 23, 'maximally_overlaps', 'A maximally_overlaps X iff all parts of A (including A itself) overlap both A and Y. [PMID:20226267]', 259, 0, 1);
INSERT INTO chado.cvterm VALUES (260, 23, 'member_of', '', 260, 0, 1);
INSERT INTO chado.cvterm VALUES (261, 23, 'non_functional_homolog_of', 'A relationship between a pseudogenic feature and its functional ancestor. [SO:ke]', 261, 0, 1);
INSERT INTO chado.cvterm VALUES (262, 23, 'orthologous_to', '', 262, 0, 1);
INSERT INTO chado.cvterm VALUES (263, 23, 'overlaps', 'X overlaps Y iff there exists some Z such that Z contained_by X and Z contained_by Y. [PMID:20226267]', 263, 0, 1);
INSERT INTO chado.cvterm VALUES (264, 23, 'paralogous_to', '', 264, 0, 1);
INSERT INTO chado.cvterm VALUES (265, 23, 'partial_evidence_for_feature', 'B is partial_evidence_for_feature A if the extent of B supports part_of but not all of A. [SO:ke]', 265, 0, 1);
INSERT INTO chado.cvterm VALUES (266, 23, 'position_of', '', 266, 0, 1);
INSERT INTO chado.cvterm VALUES (267, 23, 'processed_from', 'Inverse of processed_into. [http://precedings.nature.com/documents/3495/version/1]', 267, 0, 1);
INSERT INTO chado.cvterm VALUES (268, 23, 'processed_into', 'X is processed_into Y if a region X is modified to create Y. [http://precedings.nature.com/documents/3495/version/1]', 268, 0, 1);
INSERT INTO chado.cvterm VALUES (269, 23, 'recombined_from', '', 269, 0, 1);
INSERT INTO chado.cvterm VALUES (270, 23, 'recombined_to', '', 270, 0, 1);
INSERT INTO chado.cvterm VALUES (271, 23, 'sequence_of', '', 271, 0, 1);
INSERT INTO chado.cvterm VALUES (272, 23, 'started_by', 'X is strted_by Y if Y is part_of X and X and Y share a 5'' boundary. [PMID:20226267]', 272, 0, 1);
INSERT INTO chado.cvterm VALUES (273, 23, 'starts', 'X starts Y if X is part of Y, and A and Y share a 5'' or N-terminal boundary. [PMID:20226267]', 273, 0, 1);
INSERT INTO chado.cvterm VALUES (274, 23, 'trans_spliced_from', '', 274, 0, 1);
INSERT INTO chado.cvterm VALUES (275, 23, 'trans_spliced_to', '', 275, 0, 1);
INSERT INTO chado.cvterm VALUES (276, 23, 'transcribed_from', 'X is transcribed_from Y if X is synthesized from template Y. [http://precedings.nature.com/documents/3495/version/1]', 276, 0, 1);
INSERT INTO chado.cvterm VALUES (277, 23, 'transcribed_to', 'Inverse of transcribed_from. [http://precedings.nature.com/documents/3495/version/1]', 277, 0, 1);
INSERT INTO chado.cvterm VALUES (278, 23, 'translates_to', 'Inverse of translation _of. [http://precedings.nature.com/documents/3495/version/1]', 278, 0, 1);
INSERT INTO chado.cvterm VALUES (279, 23, 'translation_of', 'X is translation of Y if Y is translated by ribosome to create X. [http://precedings.nature.com/documents/3495/version/1]', 279, 0, 1);
INSERT INTO chado.cvterm VALUES (280, 23, 'variant_of', 'A'' is a variant (mutation) of A = definition every instance of A'' is either an immediate mutation of some instance of A, or there is a chain of immediate mutation processes linking A'' to some instance of A. [SO:immuno_workshop]', 280, 0, 1);
INSERT INTO chado.cvterm VALUES (281, 23, 'Sequence_Ontology', '', 281, 1, 0);
INSERT INTO chado.cvterm VALUES (282, 23, '5_prime_UTR_uORF_variant', 'A 5'' UTR variant within an upstream open reading frame. [PMID:32461616, PMID:32926138]', 282, 0, 0);
INSERT INTO chado.cvterm VALUES (283, 23, '5_prime_UTR_variant', 'A UTR variant of the 5'' UTR. [SO:ke]', 283, 0, 0);
INSERT INTO chado.cvterm VALUES (284, 23, 'region', 'A sequence_feature with an extent greater than zero. A nucleotide region is composed of bases and a polypeptide region is composed of amino acids. [SO:ke]', 284, 0, 0);
INSERT INTO chado.cvterm VALUES (184, 23, 'sequence_feature', 'Any extent of continuous biological sequence. [LAMHDI:mb, SO:ke]', 184, 0, 0);
INSERT INTO chado.cvterm VALUES (285, 23, '5_prime_UTR_uORF_stop_codon_variant', 'A 5'' UTR variant where a stop codon in an upstream open reading frame is introduced, moved or lost. [PMID:32461616, PMID:32926138]', 285, 0, 0);
INSERT INTO chado.cvterm VALUES (286, 23, 'sequence_secondary_structure', 'A folded sequence. [SO:ke]', 286, 0, 0);
INSERT INTO chado.cvterm VALUES (287, 23, 'biological_region', 'A region defined by its disposition to be involved in a biological process. [SO:cb]', 287, 0, 0);
INSERT INTO chado.cvterm VALUES (288, 23, '5_prime_UTR_uORF_frameshift_variant', 'A 5'' UTR variant which disrupts the translation of an upstream open reading frame because the number of nucleotides inserted or deleted is not a multiple of three. [PMID:32461616, PMID:32926138]', 288, 0, 0);
INSERT INTO chado.cvterm VALUES (289, 23, 'G_quartet', 'G-quartets are unusual nucleic acid structures consisting of a planar arrangement where each guanine is hydrogen bonded by hoogsteen pairing to another guanine in the quartet. [http://www.ncbi.nlm.nih.gov/pubmed/7919797?dopt=Abstract]', 289, 0, 0);
INSERT INTO chado.cvterm VALUES (290, 23, '5_prime_UTR_uORF_stop_codon_gain_variant', 'A 5'' UTR variant where a premature stop codon is gained in an upstream open reading frame. [PMID:32461616, PMID:32926138]', 290, 0, 0);
INSERT INTO chado.cvterm VALUES (291, 23, 'interior_coding_exon', 'A coding exon that is not the most 3-prime or the most 5-prime in a given transcript. []', 291, 0, 0);
INSERT INTO chado.cvterm VALUES (292, 23, 'coding_exon', 'An exon whereby at least one base is part of a codon (here, ''codon'' is inclusive of the stop_codon). [SO:ke]', 292, 0, 0);
INSERT INTO chado.cvterm VALUES (293, 23, '5_prime_UTR_uORF_stop_codon_loss_variant', 'A 5'' UTR variant where the stop codon of an upstream open reading frame is lost. [PMID:32461616, PMID:32926138]', 293, 0, 0);
INSERT INTO chado.cvterm VALUES (294, 23, 'satellite_DNA', 'The many tandem repeats (identical or related) of a short basic repeating unit; many have a base composition or other property different from the genome average that allows them to be separated from the bulk (main band) genomic DNA. [http://www.insdc.org/files/feature_table.html]', 294, 0, 0);
INSERT INTO chado.cvterm VALUES (295, 23, 'tandem_repeat', 'Two or more adjacent copies of a region (of length greater than 1). [SO:ke]', 295, 0, 0);
INSERT INTO chado.cvterm VALUES (296, 23, 'PCR_product', 'A region amplified by a PCR reaction. [SO:ke]', 296, 0, 0);
INSERT INTO chado.cvterm VALUES (297, 23, 'reagent', 'A sequence used in experiment. [SO:ke]', 297, 0, 0);
INSERT INTO chado.cvterm VALUES (298, 23, 'read_pair', 'One of a pair of sequencing reads in which the two members of the pair are related by originating at either end of a clone insert. [SO:ls]', 298, 0, 0);
INSERT INTO chado.cvterm VALUES (299, 23, 'read', 'A sequence obtained from a single sequencing experiment. Typically a read is produced when a base calling program interprets information from a chromatogram trace file produced from a sequencing machine. [SO:rd]', 299, 0, 0);
INSERT INTO chado.cvterm VALUES (300, 23, 'contig', 'A contiguous sequence derived from sequence assembly. Has no gaps, but may contain N''s from unavailable bases. [SO:ls]', 300, 0, 0);
INSERT INTO chado.cvterm VALUES (301, 23, 'paired_end_fragment', 'An assembly region that has been sequenced from both ends resulting in a read_pair (mate_pair). [SO:ke]', 301, 0, 0);
INSERT INTO chado.cvterm VALUES (302, 23, 'gene_sensu_your_favorite_organism', '', 302, 1, 0);
INSERT INTO chado.cvterm VALUES (303, 23, 'gene_class', '', 303, 1, 0);
INSERT INTO chado.cvterm VALUES (304, 23, 'protein_coding', 'A gene which, when transcribed, can be translated into a protein. []', 304, 0, 0);
INSERT INTO chado.cvterm VALUES (305, 23, 'gene_attribute', 'An attribute describing a gene. []', 305, 0, 0);
INSERT INTO chado.cvterm VALUES (1389, 23, 'sequence_variant_affecting_copy_number', '', 1416, 1, 0);
INSERT INTO chado.cvterm VALUES (306, 23, 'non_protein_coding', 'A gene which can be transcribed, but will not be translated into a protein. []', 306, 0, 0);
INSERT INTO chado.cvterm VALUES (307, 23, 'scRNA_primary_transcript', 'The primary transcript of any one of several small cytoplasmic RNA molecules present in the cytoplasm and sometimes nucleus of a Eukaryote. [http://www.ebi.ac.uk/embl/WebFeat/align/scRNA_s.html]', 307, 0, 0);
INSERT INTO chado.cvterm VALUES (308, 23, 'nc_primary_transcript', 'A primary transcript that is never translated into a protein. [SO:ke]', 308, 0, 0);
INSERT INTO chado.cvterm VALUES (309, 23, 'scRNA', 'A small non coding RNA sequence, present in the cytoplasm. [SO:ke]', 309, 0, 0);
INSERT INTO chado.cvterm VALUES (310, 23, 'ncRNA', 'An RNA transcript that does not encode for a protein rather the RNA molecule is the gene product. [SO:ke]', 310, 0, 0);
INSERT INTO chado.cvterm VALUES (311, 23, 'INR_motif', 'A sequence element characteristic of some RNA polymerase II promoters required for the correct positioning of the polymerase for the start of transcription. Overlaps the TSS. The mammalian consensus sequence is YYAN(T|A)YY; the Drosophila consensus sequence is TCA(G|T)t(T|C). In each the A is at position +1 with respect to the TSS. Functionally similar to the TATA box element. [PMID:12651739, PMID:16858867]', 311, 0, 0);
INSERT INTO chado.cvterm VALUES (312, 23, 'core_eukaryotic_promoter_element', 'An element that only exists within the promoter region of a eukaryotic gene. [GREEKC:cl]', 312, 0, 0);
INSERT INTO chado.cvterm VALUES (313, 23, 'RNApol_II_core_promoter', 'The minimal portion of the promoter required to properly initiate transcription in RNA polymerase II transcribed genes. [PMID:16858867]', 313, 0, 0);
INSERT INTO chado.cvterm VALUES (314, 23, 'DPE_motif', 'A sequence element characteristic of some RNA polymerase II promoters; Positioned from +28 to +32 with respect to the TSS (+1). Experimental results suggest that the DPE acts in conjunction with the INR_motif to provide a binding site for TFIID in the absence of a TATA box to mediate transcription of TATA-less promoters. Consensus sequence (A|G)G(A|T)(C|T)(G|A|C). [PMID:12515390, PMID:12537576, PMID:12651739, PMID:16858867]', 314, 0, 0);
INSERT INTO chado.cvterm VALUES (315, 23, 'BREu_motif', 'A sequence element characteristic of some RNA polymerase II promoters, located immediately upstream of some TATA box elements at -37 to -32 with respect to the TSS (+1). Consensus sequence is (G|C)(G|C)(G|A)CGCC. Binds TFIIB. [PMID:12651739, PMID:16858867]', 315, 0, 0);
INSERT INTO chado.cvterm VALUES (316, 23, 'PSE_motif', 'A sequence element characteristic of the promoters of snRNA genes transcribed by RNA polymerase II or by RNA polymerase III. Located between -45 and -60 relative to the TSS. The human PSE_motif consensus sequence is TCACCNTNA(C|G)TNAAAAG(T|G). The basal transcription factor, snRNA-activating protein complex (SNAPc), binds the PSE_motif and is required for the transcription of both RNA polymerase II and III transcribed small-nuclear RNA genes. [PMID:11390411, PMID:12621023, PMID:12651739, PMID:23166507, PMID:8339931]', 316, 0, 0);
INSERT INTO chado.cvterm VALUES (317, 23, 'DNA_motif', 'A motif that is active in the DNA form of the sequence. [SO:ke]', 317, 0, 0);
INSERT INTO chado.cvterm VALUES (318, 23, 'promoter', 'A regulatory_region composed of the TSS(s) and binding sites for TF_complexes of the core transcription machinery. A region (DNA) to which RNA polymerase binds, to begin transcription. [SO:regcreative]', 318, 0, 0);
INSERT INTO chado.cvterm VALUES (319, 23, 'linkage_group', 'A group of loci that can be grouped in a linear order representing the different degrees of linkage among the genes concerned. [ISBN:038752046]', 319, 0, 0);
INSERT INTO chado.cvterm VALUES (320, 23, 'RNA_internal_loop', 'A region of double stranded RNA where the bases do not conform to WC base pairing. The loop is closed on both sides by canonical base pairing. If the interruption to base pairing occurs on one strand only, it is known as a bulge. [SO:ke]', 320, 0, 0);
INSERT INTO chado.cvterm VALUES (321, 23, 'RNA_motif', 'A motif that is active in RNA sequence. [SO:ke]', 321, 0, 0);
INSERT INTO chado.cvterm VALUES (322, 23, 'asymmetric_RNA_internal_loop', 'An internal RNA loop where one of the strands includes more bases than the corresponding region on the other strand. [SO:ke]', 322, 0, 0);
INSERT INTO chado.cvterm VALUES (323, 23, 'A_minor_RNA_motif', 'A region forming a motif, composed of adenines, where the minor groove edges are inserted into the minor groove of another helix. [SO:ke]', 323, 0, 0);
INSERT INTO chado.cvterm VALUES (324, 23, 'K_turn_RNA_motif', 'The kink turn (K-turn) is an RNA structural motif that creates a sharp (~120 degree) bend between two continuous helices. [SO:ke]', 324, 0, 0);
INSERT INTO chado.cvterm VALUES (325, 23, 'sarcin_like_RNA_motif', 'A loop in ribosomal RNA containing the sites of attack for ricin and sarcin. [http://www.ncbi.nlm.nih.gov/pubmed/7897662]', 325, 0, 0);
INSERT INTO chado.cvterm VALUES (326, 23, 'symmetric_RNA_internal_loop', 'An internal RNA loop where the extent of the loop on both stands is the same size. [SO:ke]', 326, 0, 0);
INSERT INTO chado.cvterm VALUES (327, 23, 'RNA_junction_loop', '', 327, 0, 0);
INSERT INTO chado.cvterm VALUES (328, 23, 'RNA_hook_turn', '', 328, 0, 0);
INSERT INTO chado.cvterm VALUES (329, 23, 'base_pair', 'Two bases paired opposite each other by hydrogen bonds creating a secondary structure. []', 329, 0, 0);
INSERT INTO chado.cvterm VALUES (330, 23, 'WC_base_pair', 'The canonical base pair, where two bases interact via WC edges, with glycosidic bonds oriented cis relative to the axis of orientation. [PMID:12177293]', 330, 0, 0);
INSERT INTO chado.cvterm VALUES (331, 23, 'sugar_edge_base_pair', 'A type of non-canonical base-pairing. [PMID:12177293]', 331, 0, 0);
INSERT INTO chado.cvterm VALUES (332, 23, 'aptamer', 'DNA or RNA molecules that have been selected from random pools based on their ability to bind other molecules. [http://aptamer.icmb.utexas.edu]', 332, 0, 0);
INSERT INTO chado.cvterm VALUES (333, 23, 'oligo', 'A short oligonucleotide sequence, of length on the order of 10''s of bases; either single or double stranded. [SO:ma]', 333, 0, 0);
INSERT INTO chado.cvterm VALUES (334, 23, 'DNA_aptamer', 'DNA molecules that have been selected from random pools based on their ability to bind other molecules. [http:aptamer.icmb.utexas.edu]', 334, 0, 0);
INSERT INTO chado.cvterm VALUES (335, 23, 'RNA_aptamer', 'RNA molecules that have been selected from random pools based on their ability to bind other molecules. [http://aptamer.icmb.utexas.edu]', 335, 0, 0);
INSERT INTO chado.cvterm VALUES (336, 23, 'morpholino_oligo', 'Morpholino oligos are synthesized from four different Morpholino subunits, each of which contains one of the four genetic bases (A, C, G, T) linked to a 6-membered morpholine ring. Eighteen to 25 subunits of these four subunit types are joined in a specific order by non-ionic phosphorodiamidate intersubunit linkages to give a Morpholino. [http://www.gene-tools.com/]', 336, 0, 0);
INSERT INTO chado.cvterm VALUES (337, 23, 'synthetic_oligo', 'An oligo composed of synthetic nucleotides. [SO:ke]', 337, 0, 0);
INSERT INTO chado.cvterm VALUES (338, 23, 'morpholino_backbone', 'An attribute describing a sequence composed of nucleobases bound to a morpholino backbone. A morpholino backbone consists of morpholine (CHEBI:34856) rings connected by phosphorodiamidate linkages. [RSC:cb]', 338, 0, 0);
INSERT INTO chado.cvterm VALUES (339, 23, 'riboswitch', 'A riboswitch is a part of an mRNA that can act as a direct sensor of small molecules to control their own expression. A riboswitch is a cis element in the 5'' end of an mRNA, that acts as a direct sensor of metabolites. [PMID:2820954]', 339, 0, 0);
INSERT INTO chado.cvterm VALUES (340, 23, 'mRNA_region', 'A region of an mRNA. [SO:cb]', 340, 0, 0);
INSERT INTO chado.cvterm VALUES (186, 23, 'mRNA', 'Messenger RNA is the intermediate molecule between DNA and protein. It includes UTR and coding sequences. It does not contain introns. [SO:ma]', 186, 0, 0);
INSERT INTO chado.cvterm VALUES (341, 23, 'matrix_attachment_site', 'A DNA region that is required for the binding of chromatin to the nuclear matrix. [SO:ma]', 341, 0, 0);
INSERT INTO chado.cvterm VALUES (342, 23, 'chromosomal_regulatory_element', 'Regions of the chromosome that are important for regulating binding of chromosomes to the nuclear matrix. []', 342, 0, 0);
INSERT INTO chado.cvterm VALUES (343, 23, 'locus_control_region', 'A DNA region that includes DNAse hypersensitive sites located near a gene that confers the high-level, position-independent, and copy number-dependent expression to that gene. [SO:ma]', 343, 0, 0);
INSERT INTO chado.cvterm VALUES (344, 23, 'cis_regulatory_module', 'A regulatory region where transcription factor binding sites are clustered to regulate various aspects of transcription activities. (CRMs can be located a few kb to hundreds of kb upstream of the core promoter, in the coding sequence, within introns, or in the untranslated regions (UTR) sequences, and even on a different chromosome). A single gene can be regulated by multiple CRMs to give precise control of its spatial and temporal expression. CRMs function as nodes in large, intertwined regulatory network. CRM DNA accessibility is subject to regulation by dbTFs and transcription co-TFs. [PMID:19660565, SO:SG]', 344, 0, 0);
INSERT INTO chado.cvterm VALUES (345, 23, 'match_set', 'A collection of match parts. [SO:ke]', 345, 1, 0);
INSERT INTO chado.cvterm VALUES (346, 23, 'match_part', 'A part of a match, for example an hsp from blast is a match_part. [SO:ke]', 346, 0, 0);
INSERT INTO chado.cvterm VALUES (347, 23, 'experimental_feature', 'A region which is the result of some arbitrary experimental procedure. The procedure may be carried out with biological material or inside a computer. [SO:cb]', 347, 0, 0);
INSERT INTO chado.cvterm VALUES (348, 23, 'match', 'A region of sequence, aligned to another sequence with some statistical significance, using an algorithm such as BLAST or SIM4. [SO:ke]', 348, 0, 0);
INSERT INTO chado.cvterm VALUES (349, 23, 'genomic_clone', 'A clone of a DNA region of a genome. [SO:ma]', 349, 0, 0);
INSERT INTO chado.cvterm VALUES (350, 23, 'clone', 'A piece of DNA that has been inserted in a vector so that it can be propagated in a host bacterium or some other organism. [SO:ke]', 350, 0, 0);
INSERT INTO chado.cvterm VALUES (351, 23, 'genomic_DNA', 'DNA located in the genome and able to be transmitted to the offspring. [BCS:etrwz]', 351, 0, 0);
INSERT INTO chado.cvterm VALUES (352, 23, 'sequence_operation', 'An operation that can be applied to a sequence, that results in a change. [SO:ke]', 352, 1, 0);
INSERT INTO chado.cvterm VALUES (353, 23, 'pseudogene_attribute', 'An attribute of a pseudogene (SO:0000336). [SO:ma]', 353, 1, 0);
INSERT INTO chado.cvterm VALUES (354, 23, 'processed_pseudogene', 'A pseudogene created via retrotranposition of the mRNA of a functional protein-coding parent gene followed by accumulation of deleterious mutations lacking introns and promoters, often including a polyA tail. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 354, 0, 0);
INSERT INTO chado.cvterm VALUES (355, 23, 'pseudogene', 'A sequence that closely resembles a known functional gene, at another locus within a genome, that is non-functional as a consequence of (usually several) mutations that prevent either its transcription or translation (or both). In general, pseudogenes result from either reverse transcription of a transcript of their \"normal\" paralog (SO:0000043) (in which case the pseudogene typically lacks introns and includes a poly(A) tail) or from recombination (SO:0000044) (in which case the pseudogene is typically a tandem duplication of its \"normal\" paralog). [http://www.ucl.ac.uk/~ucbhjow/b241/glossary.html]', 355, 0, 0);
INSERT INTO chado.cvterm VALUES (356, 23, 'pseudogene_by_unequal_crossing_over', 'A pseudogene caused by unequal crossing over at recombination. [SO:ke]', 356, 0, 0);
INSERT INTO chado.cvterm VALUES (357, 23, 'non_processed_pseudogene', 'A pseudogene that arose from a means other than retrotransposition. A pseudogene created via genomic duplication of a functional protein-coding parent gene followed by accumulation of deleterious mutations. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, SO:ke]', 357, 0, 0);
INSERT INTO chado.cvterm VALUES (358, 23, 'delete', 'To remove a subsection of sequence. [SO:ke]', 358, 1, 0);
INSERT INTO chado.cvterm VALUES (359, 23, 'insert', 'To insert a subsection of sequence. [SO:ke]', 359, 1, 0);
INSERT INTO chado.cvterm VALUES (360, 23, 'invert', 'To invert a subsection of sequence. [SO:ke]', 360, 1, 0);
INSERT INTO chado.cvterm VALUES (361, 23, 'substitute', 'To substitute a subsection of sequence for another. [SO:ke]', 361, 1, 0);
INSERT INTO chado.cvterm VALUES (362, 23, 'translocate', 'To translocate a subsection of sequence. [SO:ke]', 362, 1, 0);
INSERT INTO chado.cvterm VALUES (363, 23, 'gene_part', 'A part of a gene, that has no other route in the ontology back to region. This concept is necessary for logical inference as these parts must have the properties of region. It also allows us to associate all the parts of genes with a gene. [SO:ke]', 363, 1, 0);
INSERT INTO chado.cvterm VALUES (364, 23, 'probe', 'A DNA sequence used experimentally to detect the presence or absence of a complementary nucleic acid. [SO:ma]', 364, 0, 0);
INSERT INTO chado.cvterm VALUES (365, 23, 'assortment_derived_deficiency', '', 365, 1, 0);
INSERT INTO chado.cvterm VALUES (366, 23, 'sequence_variant_affecting_regulatory_region', 'A sequence_variant_effect which changes the regulatory region of a gene. [SO:ke]', 366, 1, 0);
INSERT INTO chado.cvterm VALUES (367, 23, 'aneuploid', 'A kind of chromosome variation where the chromosome complement is not an exact multiple of the haploid number. [SO:ke]', 367, 0, 0);
INSERT INTO chado.cvterm VALUES (368, 23, 'chromosome_number_variation', 'A kind of chromosome variation where the chromosome complement is not an exact multiple of the haploid number. [SO:ke]', 368, 0, 0);
INSERT INTO chado.cvterm VALUES (369, 23, 'hyperploid', 'A kind of chromosome variation where the chromosome complement is not an exact multiple of the haploid number as extra chromosomes are present. [SO:ke]', 369, 0, 0);
INSERT INTO chado.cvterm VALUES (370, 23, 'hypoploid', 'A kind of chromosome variation where the chromosome complement is not an exact multiple of the haploid number as some chromosomes are missing. [SO:ke]', 370, 0, 0);
INSERT INTO chado.cvterm VALUES (371, 23, 'operator', 'A regulatory element of an operon to which activators or repressors bind thereby effecting translation of genes in that operon. [SO:ma]', 371, 0, 0);
INSERT INTO chado.cvterm VALUES (372, 23, 'transcriptional_cis_regulatory_region', 'A regulatory_region that modulates the transcription of a gene or genes. [PMID:9679020, SO:regcreative]', 372, 0, 0);
INSERT INTO chado.cvterm VALUES (373, 23, 'assortment_derived_aneuploid', '', 373, 1, 0);
INSERT INTO chado.cvterm VALUES (374, 23, 'nuclease_binding_site', 'A binding site that, of a nucleotide molecule, that interacts selectively and non-covalently with polypeptide residues of a nuclease. [SO:cb]', 374, 0, 0);
INSERT INTO chado.cvterm VALUES (375, 23, 'nucleotide_to_protein_binding_site', 'A binding site that, in the nucleotide molecule, interacts selectively and non-covalently with polypeptide residues. [SO:ke]', 375, 0, 0);
INSERT INTO chado.cvterm VALUES (376, 23, 'compound_chromosome_arm', 'One arm of a compound chromosome. []', 376, 0, 0);
INSERT INTO chado.cvterm VALUES (377, 23, 'compound_chromosome', 'A chromosome structure variant where a monocentric element is caused by the fusion of two chromosome arms. [SO:ke]', 377, 0, 0);
INSERT INTO chado.cvterm VALUES (378, 23, 'restriction_enzyme_binding_site', 'A binding site that, in the nucleotide molecule, interacts selectively and non-covalently with polypeptide residues of a restriction enzyme. [SO:cb]', 378, 0, 0);
INSERT INTO chado.cvterm VALUES (379, 23, 'deficient_intrachromosomal_transposition', 'An intrachromosomal transposition whereby a translocation in which one of the four broken ends loses a segment before re-joining. [FB:reference_manual]', 379, 0, 0);
INSERT INTO chado.cvterm VALUES (380, 23, 'chromosomal_deletion', 'An incomplete chromosome. [SO:ke]', 380, 0, 0);
INSERT INTO chado.cvterm VALUES (381, 23, 'intrachromosomal_transposition', 'A chromosome structure variation whereby a transposition occurred within a chromosome. [SO:ke]', 381, 0, 0);
INSERT INTO chado.cvterm VALUES (382, 23, 'deletion', 'The point at which one or more contiguous nucleotides were excised. [SO:ke]', 382, 0, 0);
INSERT INTO chado.cvterm VALUES (383, 23, 'deficient_interchromosomal_transposition', 'An interchromosomal transposition whereby a translocation in which one of the four broken ends loses a segment before re-joining. [SO:ke]', 383, 0, 0);
INSERT INTO chado.cvterm VALUES (384, 23, 'interchromosomal_transposition', 'A chromosome structure variation whereby a transposition occurred between chromosomes. [SO:ke]', 384, 0, 0);
INSERT INTO chado.cvterm VALUES (385, 23, 'gene_by_transcript_attribute', '', 385, 1, 0);
INSERT INTO chado.cvterm VALUES (386, 23, 'free_chromosome_arm', 'A chromosome structure variation whereby an arm exists as an individual chromosome element. [SO:ke]', 386, 0, 0);
INSERT INTO chado.cvterm VALUES (387, 23, 'chromosome_structure_variation', 'An alteration of the genome that leads to a change in the structure or number of one or more chromosomes. []', 387, 0, 0);
INSERT INTO chado.cvterm VALUES (388, 23, 'gene_by_polyadenylation_attribute', '', 388, 1, 0);
INSERT INTO chado.cvterm VALUES (389, 23, 'gene_to_gene_feature', '', 389, 0, 0);
INSERT INTO chado.cvterm VALUES (390, 23, 'overlapping', 'An attribute describing a gene that has a sequence that overlaps the sequence of another gene. [SO:ke]', 390, 0, 0);
INSERT INTO chado.cvterm VALUES (391, 23, 'inside_intron', 'An attribute to describe a gene when it is located within the intron of another gene. [SO:ke]', 391, 0, 0);
INSERT INTO chado.cvterm VALUES (392, 23, 'inside_intron_antiparallel', 'An attribute to describe a gene when it is located within the intron of another gene and on the opposite strand. [SO:ke]', 392, 0, 0);
INSERT INTO chado.cvterm VALUES (393, 23, 'inside_intron_parallel', 'An attribute to describe a gene when it is located within the intron of another gene and on the same strand. [SO:ke]', 393, 0, 0);
INSERT INTO chado.cvterm VALUES (394, 23, 'end_overlapping_gene', '', 394, 1, 0);
INSERT INTO chado.cvterm VALUES (395, 23, 'five_prime_three_prime_overlap', 'An attribute to describe a gene when the five prime region overlaps with another gene''s 3'' region. [SO:ke]', 395, 0, 0);
INSERT INTO chado.cvterm VALUES (396, 23, 'five_prime_five_prime_overlap', 'An attribute to describe a gene when the five prime region overlaps with another gene''s five prime region. [SO:ke]', 396, 0, 0);
INSERT INTO chado.cvterm VALUES (397, 23, 'three_prime_three_prime_overlap', 'An attribute to describe a gene when the 3'' region overlaps with another gene''s 3'' region. [SO:ke]', 397, 0, 0);
INSERT INTO chado.cvterm VALUES (398, 23, 'three_prime_five_prime_overlap', 'An attribute to describe a gene when the 3'' region overlaps with another gene''s 5'' region. [SO:ke]', 398, 0, 0);
INSERT INTO chado.cvterm VALUES (399, 23, 'antisense', 'A region sequence that is complementary to a sequence of messenger RNA. [SO:ke]', 399, 0, 0);
INSERT INTO chado.cvterm VALUES (400, 23, 'polycistronic_transcript', 'A transcript that is polycistronic. [SO:xp]', 400, 0, 0);
INSERT INTO chado.cvterm VALUES (401, 23, 'transcript', 'An RNA synthesized on a DNA or RNA template by an RNA polymerase. [SO:ma]', 401, 0, 0);
INSERT INTO chado.cvterm VALUES (402, 23, 'polycistronic', 'An attribute describing a sequence that contains the code for more than one gene product. [SO:ke]', 402, 0, 0);
INSERT INTO chado.cvterm VALUES (403, 23, 'dicistronic_transcript', 'A transcript that is dicistronic. [SO:ke]', 403, 0, 0);
INSERT INTO chado.cvterm VALUES (404, 23, 'dicistronic', 'An attribute describing a sequence that contains the code for two gene products. [SO:ke]', 404, 0, 0);
INSERT INTO chado.cvterm VALUES (405, 23, 'operon_member', 'A gene that is a member of an operon, which is a set of genes transcribed together as a unit. []', 405, 0, 0);
INSERT INTO chado.cvterm VALUES (406, 23, 'gene_array_member', '', 406, 0, 0);
INSERT INTO chado.cvterm VALUES (407, 23, 'processed_transcript_attribute', '', 407, 1, 0);
INSERT INTO chado.cvterm VALUES (408, 23, 'macronuclear_sequence', 'DNA belonging to the macronuclei of ciliates. []', 408, 0, 0);
INSERT INTO chado.cvterm VALUES (409, 23, 'organelle_sequence', 'A sequence of DNA that originates from a an organelle. []', 409, 0, 0);
INSERT INTO chado.cvterm VALUES (410, 23, 'micronuclear_sequence', 'DNA belonging to the micronuclei of a cell. []', 410, 0, 0);
INSERT INTO chado.cvterm VALUES (411, 23, 'gene_by_genome_location', '', 411, 1, 0);
INSERT INTO chado.cvterm VALUES (412, 23, 'gene_by_organelle_of_genome', '', 412, 1, 0);
INSERT INTO chado.cvterm VALUES (413, 23, 'nuclear_gene', 'A gene from nuclear sequence. [SO:xp]', 413, 0, 0);
INSERT INTO chado.cvterm VALUES (414, 23, 'nuclear_sequence', 'DNA belonging to the nuclear genome of cell. []', 414, 0, 0);
INSERT INTO chado.cvterm VALUES (415, 23, 'mt_gene', 'A gene located in mitochondrial sequence. [SO:xp]', 415, 0, 0);
INSERT INTO chado.cvterm VALUES (416, 23, 'mitochondrial_sequence', 'DNA belonging to the genome of a mitochondria. []', 416, 0, 0);
INSERT INTO chado.cvterm VALUES (417, 23, 'kinetoplast_gene', 'A gene located in kinetoplast sequence. [SO:xp]', 417, 0, 0);
INSERT INTO chado.cvterm VALUES (418, 23, 'kinetoplast', 'A kinetoplast is an interlocked network of thousands of minicircles and tens of maxicircles, located near the base of the flagellum of some protozoan species. [PMID:8395055]', 418, 0, 0);
INSERT INTO chado.cvterm VALUES (419, 23, 'plastid_gene', 'A gene from plastid sequence. [SO:xp]', 419, 0, 0);
INSERT INTO chado.cvterm VALUES (420, 23, 'plastid_sequence', 'DNA belonging to the genome of a plastid such as a chloroplast. []', 420, 0, 0);
INSERT INTO chado.cvterm VALUES (421, 23, 'apicoplast_gene', 'A gene from apicoplast sequence. [SO:xp]', 421, 0, 0);
INSERT INTO chado.cvterm VALUES (422, 23, 'apicoplast_sequence', 'DNA belonging to the genome of an apicoplast, a non-photosynthetic plastid. []', 422, 0, 0);
INSERT INTO chado.cvterm VALUES (423, 23, 'ct_gene', 'A gene from chloroplast sequence. [SO:xp]', 423, 0, 0);
INSERT INTO chado.cvterm VALUES (424, 23, 'chloroplast_sequence', 'DNA belonging to the genome of a chloroplast, a green plastid for photosynthesis. []', 424, 0, 0);
INSERT INTO chado.cvterm VALUES (425, 23, 'chromoplast_gene', 'A gene from chromoplast_sequence. [SO:xp]', 425, 0, 0);
INSERT INTO chado.cvterm VALUES (426, 23, 'chromoplast_sequence', 'DNA belonging to the genome of a chromoplast, a colored plastid for synthesis and storage of pigments. []', 426, 0, 0);
INSERT INTO chado.cvterm VALUES (427, 23, 'cyanelle_gene', 'A gene from cyanelle sequence. [SO:xp]', 427, 0, 0);
INSERT INTO chado.cvterm VALUES (428, 23, 'cyanelle_sequence', 'DNA belonging to the genome of a cyanelle, a photosynthetic plastid found in algae. []', 428, 0, 0);
INSERT INTO chado.cvterm VALUES (2961, 25, 'State', '', 3268, 0, 0);
INSERT INTO chado.cvterm VALUES (429, 23, 'leucoplast_gene', 'A plastid gene from leucoplast sequence. [SO:xp]', 429, 0, 0);
INSERT INTO chado.cvterm VALUES (430, 23, 'leucoplast_sequence', 'DNA belonging to the genome of a leucoplast, a colorless plastid generally containing starch or oil. []', 430, 0, 0);
INSERT INTO chado.cvterm VALUES (431, 23, 'proplastid_gene', 'A gene from proplastid sequence. [SO:ke]', 431, 0, 0);
INSERT INTO chado.cvterm VALUES (432, 23, 'proplastid_sequence', 'DNA belonging to the genome of a proplastid such as an immature chloroplast. []', 432, 0, 0);
INSERT INTO chado.cvterm VALUES (433, 23, 'nucleomorph_gene', 'A gene from nucleomorph sequence. [SO:xp]', 433, 0, 0);
INSERT INTO chado.cvterm VALUES (434, 23, 'nucleomorphic_sequence', 'DNA belonging to the genome of a plastid such as a chloroplast. The nucleomorph is the nuclei of the plastic. []', 434, 0, 0);
INSERT INTO chado.cvterm VALUES (435, 23, 'plasmid_gene', 'A gene from plasmid sequence. [SO:xp]', 435, 0, 0);
INSERT INTO chado.cvterm VALUES (436, 23, 'plasmid_location', 'The location of DNA that has come from a plasmid sequence. []', 436, 0, 0);
INSERT INTO chado.cvterm VALUES (437, 23, 'proviral_gene', 'A gene from proviral sequence. [SO:xp]', 437, 0, 0);
INSERT INTO chado.cvterm VALUES (438, 23, 'proviral_location', 'The location of DNA that has come from a viral origin. []', 438, 0, 0);
INSERT INTO chado.cvterm VALUES (439, 23, 'endogenous_retroviral_gene', 'A proviral gene with origin endogenous retrovirus. [SO:xp]', 439, 0, 0);
INSERT INTO chado.cvterm VALUES (440, 23, 'endogenous_retroviral_sequence', 'Endogenous DNA sequence that are likely to have arisen from retroviruses. []', 440, 0, 0);
INSERT INTO chado.cvterm VALUES (441, 23, 'transposable_element', 'A transposon or insertion sequence. An element that can insert in a variety of DNA sequences. [http://www.sci.sdsu.edu/~smaloy/Glossary/T.html]', 441, 0, 0);
INSERT INTO chado.cvterm VALUES (442, 23, 'integrated_mobile_genetic_element', 'An MGE that is integrated into the host chromosome. [SO:ke]', 442, 0, 0);
INSERT INTO chado.cvterm VALUES (443, 23, 'expressed_sequence_match', 'A match to an EST or cDNA sequence. [SO:ke]', 443, 0, 0);
INSERT INTO chado.cvterm VALUES (444, 23, 'nucleotide_match', 'A match against a nucleotide sequence. [SO:ke]', 444, 0, 0);
INSERT INTO chado.cvterm VALUES (445, 23, 'clone_insert_end', 'The end of the clone insert. [SO:ke]', 445, 0, 0);
INSERT INTO chado.cvterm VALUES (446, 23, 'junction', 'A sequence_feature with an extent of zero. [SO:ke]', 446, 0, 0);
INSERT INTO chado.cvterm VALUES (447, 23, 'clone_insert', 'The region of sequence that has been inserted and is being propagated by the clone. [SO:ke]', 447, 0, 0);
INSERT INTO chado.cvterm VALUES (448, 23, 'polypeptide', 'A sequence of amino acids linked by peptide bonds which may lack appreciable tertiary structure and may not be liable to irreversible denaturation. [SO:ma]', 448, 0, 0);
INSERT INTO chado.cvterm VALUES (449, 23, 'CDS', 'A contiguous sequence which begins with, and includes, a start codon and ends with, and includes, a stop codon. [SO:ma]', 450, 0, 0);
INSERT INTO chado.cvterm VALUES (450, 23, 'chromosome_arm', 'A region of the chromosome between the centromere and the telomere. Human chromosomes have two arms, the p arm (short) and the q arm (long) which are separated from each other by the centromere. [http://www.medterms.com/script/main/art.asp?articlekey=5152]', 451, 0, 0);
INSERT INTO chado.cvterm VALUES (451, 23, 'chromosome_part', 'A region of a chromosome. [SO:ke]', 452, 0, 0);
INSERT INTO chado.cvterm VALUES (452, 23, 'non_capped_primary_transcript', '', 453, 1, 0);
INSERT INTO chado.cvterm VALUES (453, 23, 'sequencing_primer', 'A single stranded oligo used for polymerase chain reaction. []', 454, 0, 0);
INSERT INTO chado.cvterm VALUES (454, 23, 'primer', 'An oligo to which new deoxyribonucleotides can be added by DNA polymerase. [SO:ke]', 455, 0, 0);
INSERT INTO chado.cvterm VALUES (455, 23, 'mRNA_with_frameshift', 'An mRNA with a frameshift. [SO:xp]', 456, 0, 0);
INSERT INTO chado.cvterm VALUES (456, 23, 'frameshift', 'An attribute describing a sequence that contains a mutation involving the deletion or insertion of one or more bases, where this number is not divisible by 3. [SO:ke]', 457, 0, 0);
INSERT INTO chado.cvterm VALUES (457, 23, 'sequence_variant_obs', 'A sequence_variant is a non exact copy of a sequence_feature or genome exhibiting one or more sequence_alteration. [SO:ke]', 458, 1, 0);
INSERT INTO chado.cvterm VALUES (458, 23, 'transposable_element_gene', 'A gene encoded within a transposable element. For example gag, int, env and pol are the transposable element genes of the TY element in yeast. [SO:ke]', 459, 0, 0);
INSERT INTO chado.cvterm VALUES (459, 23, 'ss_oligo', 'A single stranded oligonucleotide. [SO:ke]', 460, 0, 0);
INSERT INTO chado.cvterm VALUES (460, 23, 'proviral_region', 'A viral sequence which has integrated into a host genome. [SO:ke]', 461, 0, 0);
INSERT INTO chado.cvterm VALUES (461, 23, 'methylated_cytosine', 'A methylated deoxy-cytosine. [SO:ke]', 462, 0, 0);
INSERT INTO chado.cvterm VALUES (462, 23, 'methylated_DNA_base_feature', 'A nucleotide modified by methylation. [SO:ke]', 463, 0, 0);
INSERT INTO chado.cvterm VALUES (463, 23, 'modified_cytosine', 'A modified cytosine DNA base feature. [SO:ke]', 464, 0, 0);
INSERT INTO chado.cvterm VALUES (464, 23, 'transcript_feature', '', 465, 1, 0);
INSERT INTO chado.cvterm VALUES (465, 23, 'edited', 'An attribute describing a sequence that is modified by editing. [SO:ke]', 466, 0, 0);
INSERT INTO chado.cvterm VALUES (466, 23, 'transcript_attribute', 'An attribute describing a transcript. []', 467, 0, 0);
INSERT INTO chado.cvterm VALUES (467, 23, 'transcript_with_readthrough_stop_codon', '', 468, 1, 0);
INSERT INTO chado.cvterm VALUES (468, 23, 'transcript_with_translational_frameshift', 'A transcript with a translational frameshift. [SO:xp]', 469, 0, 0);
INSERT INTO chado.cvterm VALUES (469, 23, 'translationally_frameshifted', 'Recoding by frameshifting a particular site. [SO:ke]', 470, 0, 0);
INSERT INTO chado.cvterm VALUES (470, 23, 'regulated', 'An attribute to describe a sequence that is regulated. [SO:ke]', 471, 0, 0);
INSERT INTO chado.cvterm VALUES (471, 23, 'protein_coding_primary_transcript', 'A primary transcript that, at least in part, encodes one or more proteins. [SO:ke]', 472, 0, 0);
INSERT INTO chado.cvterm VALUES (472, 23, 'primary_transcript', 'A transcript that in its initial state requires modification to be functional. [SO:ma]', 473, 0, 0);
INSERT INTO chado.cvterm VALUES (473, 23, 'forward_primer', 'A single stranded oligo used for polymerase chain reaction. [http://mged.sourceforge.net/ontologies/MGEDontology.php]', 474, 0, 0);
INSERT INTO chado.cvterm VALUES (474, 23, 'forward', 'Forward is an attribute of the feature, where the feature is in the 5'' to 3'' direction. [SO:ke]', 475, 0, 0);
INSERT INTO chado.cvterm VALUES (475, 23, 'RNA_sequence_secondary_structure', 'A folded RNA sequence. [SO:ke]', 476, 0, 0);
INSERT INTO chado.cvterm VALUES (476, 23, 'transcriptionally_regulated', 'An attribute describing a gene that is regulated at transcription. [SO:ma]', 477, 0, 0);
INSERT INTO chado.cvterm VALUES (477, 23, 'transcriptionally_constitutive', 'Expressed in relatively constant amounts without regard to cellular environmental conditions such as the concentration of a particular substrate. [SO:ke]', 478, 0, 0);
INSERT INTO chado.cvterm VALUES (478, 23, 'transcriptionally_induced', 'An inducer molecule is required for transcription to occur. [SO:ke]', 479, 0, 0);
INSERT INTO chado.cvterm VALUES (479, 23, 'transcriptionally_repressed', 'A repressor molecule is required for transcription to stop. [SO:ke]', 480, 0, 0);
INSERT INTO chado.cvterm VALUES (480, 23, 'silenced_gene', 'A gene that is silenced. [SO:xp]', 481, 0, 0);
INSERT INTO chado.cvterm VALUES (481, 23, 'silenced', 'An attribute describing an epigenetic process where a gene is inactivated at transcriptional or translational level. [SO:ke]', 482, 0, 0);
INSERT INTO chado.cvterm VALUES (482, 23, 'gene_silenced_by_DNA_modification', 'A gene that is silenced by DNA modification. [SO:xp]', 483, 0, 0);
INSERT INTO chado.cvterm VALUES (483, 23, 'silenced_by_DNA_modification', 'An attribute describing an epigenetic process where a gene is inactivated by DNA modifications, resulting in repression of transcription. [SO:ke]', 484, 0, 0);
INSERT INTO chado.cvterm VALUES (484, 23, 'gene_silenced_by_DNA_methylation', 'A gene that is silenced by DNA methylation. [SO:xp]', 485, 0, 0);
INSERT INTO chado.cvterm VALUES (485, 23, 'silenced_by_DNA_methylation', 'An attribute describing an epigenetic process where a gene is inactivated by DNA methylation, resulting in repression of transcription. [SO:ke]', 486, 0, 0);
INSERT INTO chado.cvterm VALUES (486, 23, 'post_translationally_regulated', 'An attribute describing a gene that is regulated after it has been translated. [SO:ke]', 487, 0, 0);
INSERT INTO chado.cvterm VALUES (487, 23, 'translationally_regulated', 'An attribute describing a gene that is regulated as it is translated. [SO:ke]', 488, 0, 0);
INSERT INTO chado.cvterm VALUES (488, 23, 'reverse_primer', 'A single stranded oligo used for polymerase chain reaction. [http://mged.sourceforge.net/ontologies/MGEDontology.php]', 489, 0, 0);
INSERT INTO chado.cvterm VALUES (489, 23, 'reverse', 'Reverse is an attribute of the feature, where the feature is in the 3'' to 5'' direction. Again could be applied to primer. [SO:ke]', 490, 0, 0);
INSERT INTO chado.cvterm VALUES (490, 23, 'epigenetically_modified', 'This attribute describes a gene where heritable changes other than those in the DNA sequence occur. These changes include: modification to the DNA (such as DNA methylation, the covalent modification of cytosine), and post-translational modification of histones. [SO:ke]', 491, 0, 0);
INSERT INTO chado.cvterm VALUES (491, 23, 'genomically_imprinted', 'Imprinted genes are epigenetically modified genes that are expressed monoallelically according to their parent of origin. [SO:ke]', 492, 0, 0);
INSERT INTO chado.cvterm VALUES (492, 23, 'maternally_imprinted', 'The maternal copy of the gene is modified, rendering it transcriptionally silent. [SO:ke]', 493, 0, 0);
INSERT INTO chado.cvterm VALUES (493, 23, 'paternally_imprinted', 'The paternal copy of the gene is modified, rendering it transcriptionally silent. [SO:ke]', 494, 0, 0);
INSERT INTO chado.cvterm VALUES (494, 23, 'allelically_excluded', 'Allelic exclusion is a process occurring in diploid organisms, where a gene is inactivated and not expressed in that cell. [SO:ke]', 495, 0, 0);
INSERT INTO chado.cvterm VALUES (495, 23, 'gene_rearranged_at_DNA_level', 'An epigenetically modified gene, rearranged at the DNA level. [SO:xp]', 496, 0, 0);
INSERT INTO chado.cvterm VALUES (496, 23, 'epigenetically_modified_gene', 'A gene that is epigenetically modified. [SO:ke]', 497, 0, 0);
INSERT INTO chado.cvterm VALUES (497, 23, 'rearranged_at_DNA_level', 'An attribute to describe the sequence of a feature, where the DNA is rearranged. [SO:ke]', 498, 0, 0);
INSERT INTO chado.cvterm VALUES (498, 23, 'ribosome_entry_site', 'Region in mRNA where ribosome assembles. [SO:ke]', 499, 0, 0);
INSERT INTO chado.cvterm VALUES (499, 23, 'five_prime_UTR', 'A region at the 5'' end of a mature transcript (preceding the initiation codon) that is not translated into a protein. [http://www.insdc.org/files/feature_table.html]', 500, 0, 0);
INSERT INTO chado.cvterm VALUES (500, 23, 'attenuator', 'A sequence segment located within the five prime end of an mRNA that causes premature termination of translation. [SO:as]', 501, 0, 0);
INSERT INTO chado.cvterm VALUES (501, 23, 'translation_regulatory_region', 'A regulatory region that is involved in the control of the process of translation. [SO:ke]', 502, 0, 0);
INSERT INTO chado.cvterm VALUES (502, 23, 'terminator', 'The sequence of DNA located either at the end of the transcript that causes RNA polymerase to terminate transcription. [http://www.insdc.org/files/feature_table.html]', 503, 0, 0);
INSERT INTO chado.cvterm VALUES (503, 23, 'DNA_sequence_secondary_structure', 'A folded DNA sequence. [SO:ke]', 504, 0, 0);
INSERT INTO chado.cvterm VALUES (504, 23, 'assembly_component', 'A region of known length which may be used to manufacture a longer region. [SO:ke]', 505, 0, 0);
INSERT INTO chado.cvterm VALUES (505, 23, 'primary_transcript_attribute', '', 506, 1, 0);
INSERT INTO chado.cvterm VALUES (506, 23, 'recoded_codon', 'A codon that has been redefined at translation. The redefinition may be as a result of translational bypass, translational frameshifting or stop codon readthrough. [SO:xp]', 507, 0, 0);
INSERT INTO chado.cvterm VALUES (507, 23, 'codon', 'A set of (usually) three nucleotide bases in a DNA or RNA sequence, which together code for a unique amino acid or the termination of translation and are contained within the CDS. [SO:ke]', 508, 0, 0);
INSERT INTO chado.cvterm VALUES (508, 23, 'capped', 'An attribute describing when a sequence, usually an mRNA is capped by the addition of a modified guanine nucleotide at the 5'' end. [SO:ke]', 509, 0, 0);
INSERT INTO chado.cvterm VALUES (509, 23, 'exon', 'A region of the transcript sequence within a gene which is not removed from the primary RNA transcript by RNA splicing. [SO:ke]', 510, 0, 0);
INSERT INTO chado.cvterm VALUES (510, 23, 'transcript_region', 'A region of a transcript. [SO:ke]', 511, 0, 0);
INSERT INTO chado.cvterm VALUES (511, 23, 'supercontig', 'One or more contigs that have been ordered and oriented using end-read information. Contains gaps that are filled with N''s. [SO:ls]', 512, 0, 0);
INSERT INTO chado.cvterm VALUES (512, 23, 'partial_genomic_sequence_assembly', 'A partial DNA sequence assembly of a chromosome or full genome, which contains gaps that are filled with N''s. [GMOD:ea]', 513, 0, 0);
INSERT INTO chado.cvterm VALUES (513, 23, 'ultracontig', 'An ordered and oriented set of scaffolds based on somewhat weaker sets of inferential evidence such as one set of mate pair reads together with supporting evidence from ESTs or location of markers from SNP or microsatellite maps, or cytogenetic localization of contained markers. [FB:WG]', 514, 0, 0);
INSERT INTO chado.cvterm VALUES (514, 23, 'sequence_assembly', 'A sequence of nucleotides that has been algorithmically derived from an alignment of two or more different sequences. [SO:ma]', 515, 0, 0);
INSERT INTO chado.cvterm VALUES (515, 23, 'YAC', 'Yeast Artificial Chromosome, a vector constructed from the telomeric, centromeric, and replication origin sequences needed for replication in yeast cells. [SO:ma]', 516, 0, 0);
INSERT INTO chado.cvterm VALUES (516, 23, 'vector_replicon', 'A replicon that has been modified to act as a vector for foreign sequence. [SO:ma]', 517, 0, 0);
INSERT INTO chado.cvterm VALUES (517, 23, 'BAC', 'Bacterial Artificial Chromosome, a cloning vector that can be propagated as mini-chromosomes in a bacterial host. [SO:ma]', 518, 0, 0);
INSERT INTO chado.cvterm VALUES (518, 23, 'PAC', 'The P1-derived artificial chromosome are DNA constructs that are derived from the DNA of P1 bacteriophage. They can carry large amounts (about 100-300 kilobases) of other sequences for a variety of bioengineering purposes. It is one type of vector used to clone DNA fragments (100- to 300-kb insert size; average, 150 kb) in Escherichia coli cells. [http://en.wikipedia.org/wiki/P1-derived_artificial_chromosome]', 519, 0, 0);
INSERT INTO chado.cvterm VALUES (519, 23, 'plasmid', 'A self replicating, using the hosts cellular machinery, often circular nucleic acid molecule that is distinct from a chromosome in the organism. [SO:ma]', 520, 0, 0);
INSERT INTO chado.cvterm VALUES (520, 23, 'replicon', 'A region containing at least one unique origin of replication and a unique termination site. [ISBN:0716719207]', 521, 0, 0);
INSERT INTO chado.cvterm VALUES (521, 23, 'cosmid', 'A cloning vector that is a hybrid of lambda phages and a plasmid that can be propagated as a plasmid or packaged as a phage,since they retain the lambda cos sites. [SO:ma]', 522, 0, 0);
INSERT INTO chado.cvterm VALUES (522, 23, 'phagemid', 'A plasmid which carries within its sequence a bacteriophage replication origin. When the host bacterium is infected with \"helper\" phage, a phagemid is replicated along with the phage DNA and packaged into phage capsids. [SO:ma]', 523, 0, 0);
INSERT INTO chado.cvterm VALUES (523, 23, 'fosmid', 'A cloning vector that utilizes the E. coli F factor. [SO:ma]', 524, 0, 0);
INSERT INTO chado.cvterm VALUES (524, 23, 'sequence_alteration', 'A sequence_alteration is a sequence_feature whose extent is the deviation from another sequence. [SO:ke]', 527, 0, 0);
INSERT INTO chado.cvterm VALUES (525, 23, 'lambda_clone', 'A linear clone derived from lambda bacteriophage. The genes involved in the lysogenic pathway are removed from the from the viral DNA. Up to 25 kb of foreign DNA can then be inserted into the lambda genome. [ISBN:0-1767-2380-8]', 528, 1, 0);
INSERT INTO chado.cvterm VALUES (526, 23, 'methylated_adenine', 'A modified base in which adenine has been methylated. [SO:ke]', 529, 0, 0);
INSERT INTO chado.cvterm VALUES (527, 23, 'modified_adenine', 'A modified adenine DNA base feature. [SO:ke]', 530, 0, 0);
INSERT INTO chado.cvterm VALUES (528, 23, 'splice_site', 'Consensus region of primary transcript bordering junction of splicing. A region that overlaps exactly 2 base and adjacent_to splice_junction. [SO:cjm, SO:ke]', 531, 0, 0);
INSERT INTO chado.cvterm VALUES (529, 23, 'primary_transcript_region', 'A part of a primary transcript. [SO:ke]', 532, 0, 0);
INSERT INTO chado.cvterm VALUES (530, 23, 'five_prime_cis_splice_site', 'Intronic 2 bp region bordering the exon, at the 5'' edge of the intron. A splice_site that is downstream_adjacent_to exon and starts intron. [http://www.ucl.ac.uk/~ucbhjow/b241/glossary.html, SO:cjm, SO:ke]', 533, 0, 0);
INSERT INTO chado.cvterm VALUES (531, 23, 'cis_splice_site', 'Intronic 2 bp region bordering exon. A splice_site that adjacent_to exon and overlaps intron. [SO:cjm, SO:ke]', 534, 0, 0);
INSERT INTO chado.cvterm VALUES (532, 23, 'three_prime_cis_splice_site', 'Intronic 2 bp region bordering the exon, at the 3'' edge of the intron. A splice_site that is upstream_adjacent_to exon and finishes intron. [http://www.ucl.ac.uk/~ucbhjow/b241/glossary.html, SO:cjm, SO:ke]', 535, 0, 0);
INSERT INTO chado.cvterm VALUES (533, 23, 'enhancer', 'A cis-acting sequence that increases the utilization of (some) eukaryotic promoters, and can function in either orientation and in any location (upstream or downstream) relative to the promoter. [http://www.insdc.org/files/feature_table.html]', 536, 0, 0);
INSERT INTO chado.cvterm VALUES (534, 23, 'enhancer_bound_by_factor', 'An enhancer bound by a factor. [SO:xp]', 537, 0, 0);
INSERT INTO chado.cvterm VALUES (535, 23, 'bound_by_factor', 'An attribute describing a sequence that is bound by another molecule. [SO:ke]', 538, 0, 0);
INSERT INTO chado.cvterm VALUES (536, 23, 'gene_component_region', 'A region of a gene that has a specific function. []', 539, 0, 0);
INSERT INTO chado.cvterm VALUES (537, 23, 'restriction_enzyme_cut_site', 'A specific nucleotide sequence of DNA at or near which a particular restriction enzyme cuts the DNA. [SO:ma]', 540, 1, 0);
INSERT INTO chado.cvterm VALUES (538, 23, 'RNApol_I_promoter', 'A DNA sequence in eukaryotic DNA to which RNA polymerase I binds, to begin transcription. [SO:ke]', 541, 0, 0);
INSERT INTO chado.cvterm VALUES (539, 23, 'eukaryotic_promoter', 'A regulatory_region including the Transcription Start Site (TSS) of a gene and serving as a platform for Pre-Initiation Complex (PIC) assembly, enabling transcription of a gene under certain conditions. []', 542, 0, 0);
INSERT INTO chado.cvterm VALUES (540, 23, 'RNApol_II_promoter', 'A DNA sequence in eukaryotic DNA to which RNA polymerase II binds, to begin transcription. [SO:ke]', 543, 0, 0);
INSERT INTO chado.cvterm VALUES (541, 23, 'RNApol_III_promoter', 'A DNA sequence in eukaryotic DNA to which RNA polymerase III binds, to begin transcription. [SO:ke]', 544, 0, 0);
INSERT INTO chado.cvterm VALUES (542, 23, 'CAAT_signal', 'Part of a conserved sequence located about 75-bp upstream of the start point of eukaryotic transcription units which may be involved in RNA polymerase binding; consensus=GG(C|T)CAATCT. [http://www.insdc.org/files/feature_table.html]', 545, 0, 0);
INSERT INTO chado.cvterm VALUES (543, 23, 'GC_rich_promoter_region', 'A conserved GC-rich region located upstream of the start point of eukaryotic transcription units which may occur in multiple copies or in either orientation; consensus=GGGCGG. [http://www.insdc.org/files/feature_table.html]', 546, 0, 0);
INSERT INTO chado.cvterm VALUES (544, 23, 'promoter_element', 'An element that can exist within the promoter region of a gene. []', 547, 0, 0);
INSERT INTO chado.cvterm VALUES (545, 23, 'TATA_box', 'A conserved AT-rich septamer found about 25-bp before the start point of many eukaryotic RNA polymerase II transcript units; may be involved in positioning the enzyme for correct initiation; consensus=TATA(A|T)A(A|T). [http://www.insdc.org/files/feature_table.html, PMID:16858867]', 548, 0, 0);
INSERT INTO chado.cvterm VALUES (546, 23, 'minus_10_signal', 'A conserved region about 10-bp upstream of the start point of bacterial transcription units which may be involved in binding RNA polymerase; consensus=TAtAaT. This region is associated with sigma factor 70. [http://www.insdc.org/files/feature_table.html]', 549, 0, 0);
INSERT INTO chado.cvterm VALUES (547, 23, 'bacterial_RNApol_promoter_sigma_70_element', 'A DNA sequence to which bacterial RNA polymerase sigma 70 binds, to begin transcription. []', 550, 0, 0);
INSERT INTO chado.cvterm VALUES (548, 23, 'bacterial_RNApol_promoter_sigma_ecf_element', 'A bacterial promoter with sigma ecf factor binding dependency. This is a type of bacterial promoters that requires a sigma ECF factor to bind to identified -10 and -35 sequence regions in order to mediate binding of the RNA polymerase to the promoter region as part of transcription initiation. [Invitrogen:kc]', 551, 0, 0);
INSERT INTO chado.cvterm VALUES (549, 23, 'minus_35_signal', 'A conserved hexamer about 35-bp upstream of the start point of bacterial transcription units; consensus=TTGACa or TGTTGACA. This region is associated with sigma factor 70. [http://www.insdc.org/files/feature_table.html]', 552, 0, 0);
INSERT INTO chado.cvterm VALUES (550, 23, 'cross_genome_match', 'A nucleotide match against a sequence from another organism. [SO:ma]', 553, 0, 0);
INSERT INTO chado.cvterm VALUES (551, 23, 'operon', 'The DNA region of a group of adjacent genes whose transcription is coordinated onone or several mutually overlapping transcription units transcribed in the same direction and sharing at least one gene. [SO:ma]', 554, 0, 0);
INSERT INTO chado.cvterm VALUES (552, 23, 'gene_group', 'A collection of related genes. [SO:ma]', 555, 0, 0);
INSERT INTO chado.cvterm VALUES (553, 23, 'clone_insert_start', 'The start of the clone insert. [SO:ke]', 556, 0, 0);
INSERT INTO chado.cvterm VALUES (554, 23, 'retrotransposon', 'A transposable element that is incorporated into a chromosome by a mechanism that requires reverse transcriptase. [http://www.dddmag.com/Glossary.aspx#r]', 557, 0, 0);
INSERT INTO chado.cvterm VALUES (555, 23, 'translated_nucleotide_match', 'A match against a translated sequence. [SO:ke]', 558, 0, 0);
INSERT INTO chado.cvterm VALUES (556, 23, 'DNA_transposon', 'A transposon where the mechanism of transposition is via a DNA intermediate. [SO:ke]', 559, 0, 0);
INSERT INTO chado.cvterm VALUES (557, 23, 'non_transcribed_region', 'A region of the gene which is not transcribed. [SO:ke]', 560, 0, 0);
INSERT INTO chado.cvterm VALUES (558, 23, 'U2_intron', 'A major type of spliceosomal intron spliced by the U2 spliceosome, that includes U1, U2, U4/U6 and U5 snRNAs. [PMID:9428511]', 561, 0, 0);
INSERT INTO chado.cvterm VALUES (559, 23, 'spliceosomal_intron', 'An intron which is spliced by the spliceosome. [SO:ke]', 562, 0, 0);
INSERT INTO chado.cvterm VALUES (560, 23, 'LTR_retrotransposon', 'A retrotransposon flanked by long terminal repeat sequences. [SO:ke]', 563, 0, 0);
INSERT INTO chado.cvterm VALUES (561, 23, 'repeat_family', 'A group of characterized repeat sequences. [SO:ke]', 564, 1, 0);
INSERT INTO chado.cvterm VALUES (562, 23, 'intron', 'A region of a primary transcript that is transcribed, but removed from within the transcript by splicing together the sequences (exons) on either side of it. [http://www.insdc.org/files/feature_table.html]', 565, 0, 0);
INSERT INTO chado.cvterm VALUES (563, 23, 'non_LTR_retrotransposon', 'A retrotransposon without long terminal repeat sequences. [SO:ke]', 566, 0, 0);
INSERT INTO chado.cvterm VALUES (564, 23, 'five_prime_intron', 'An intron that is the most 5-prime in a given transcript. []', 567, 0, 0);
INSERT INTO chado.cvterm VALUES (565, 23, 'interior_intron', 'An intron that is not the most 3-prime or the most 5-prime in a given transcript. []', 568, 0, 0);
INSERT INTO chado.cvterm VALUES (566, 23, 'three_prime_intron', 'An intron that is the most 3-prime in a given transcript. []', 569, 0, 0);
INSERT INTO chado.cvterm VALUES (567, 23, 'RFLP_fragment', 'A DNA fragment used as a reagent to detect the polymorphic genomic loci by hybridizing against the genomic DNA digested with a given restriction enzyme. [GOC:pj]', 570, 0, 0);
INSERT INTO chado.cvterm VALUES (568, 23, 'restriction_fragment', 'A region of polynucleotide sequence produced by digestion with a restriction endonuclease. [SO:ke]', 571, 0, 0);
INSERT INTO chado.cvterm VALUES (569, 23, 'LINE_element', 'A dispersed repeat family with many copies, each from 1 to 6 kb long. New elements are generated by retroposition of a transcribed copy. Typically the LINE contains 2 ORF''s one of which is reverse transcriptase, and 3''and 5'' direct repeats. [http://www.ucl.ac.uk/~ucbhjow/b241/glossary.html]', 572, 0, 0);
INSERT INTO chado.cvterm VALUES (570, 23, 'five_prime_coding_exon_coding_region', 'The sequence of the five_prime_coding_exon that codes for protein. [SO:cjm]', 573, 0, 0);
INSERT INTO chado.cvterm VALUES (571, 23, 'coding_region_of_exon', 'The region of an exon that encodes for protein sequence. [SO:ke]', 574, 0, 0);
INSERT INTO chado.cvterm VALUES (572, 23, 'five_prime_coding_exon', 'The 5'' most coding exon. [SO:ke]', 575, 0, 0);
INSERT INTO chado.cvterm VALUES (573, 23, 'three_prime_coding_exon_coding_region', 'The sequence of the three_prime_coding_exon that codes for protein. [SO:cjm]', 576, 0, 0);
INSERT INTO chado.cvterm VALUES (574, 23, 'three_prime_coding_exon', 'The coding exon that is most 3-prime on a given transcript. [SO:ma]', 577, 0, 0);
INSERT INTO chado.cvterm VALUES (575, 23, 'noncoding_exon', 'An exon that does not contain any codons. [SO:ke]', 578, 0, 0);
INSERT INTO chado.cvterm VALUES (576, 23, 'translocation', 'A region of nucleotide sequence that has translocated to a new position. The observed adjacency of two previously separated regions. [NCBI:th, SO:ke]', 579, 0, 0);
INSERT INTO chado.cvterm VALUES (577, 23, 'structural_alteration', 'An alteration of the genome that leads to a change in the structure of one or more chromosomes. []', 580, 0, 0);
INSERT INTO chado.cvterm VALUES (578, 23, 'interior_exon', 'An exon that is bounded by 5'' and 3'' splice sites. [PMID:10373547]', 581, 0, 0);
INSERT INTO chado.cvterm VALUES (579, 23, 'UTR', 'Messenger RNA sequences that are untranslated and lie five prime or three prime to sequences which are translated. [SO:ke]', 582, 0, 0);
INSERT INTO chado.cvterm VALUES (580, 23, 'three_prime_UTR', 'A region at the 3'' end of a mature transcript (following the stop codon) that is not translated into a protein. [http://www.insdc.org/files/feature_table.html]', 583, 0, 0);
INSERT INTO chado.cvterm VALUES (581, 23, 'SINE_element', 'A repetitive element, a few hundred base pairs long, that is dispersed throughout the genome. A common human SINE is the Alu element. [SO:ke]', 584, 0, 0);
INSERT INTO chado.cvterm VALUES (582, 23, 'simple_sequence_length_variation', 'SSLP are a kind of sequence alteration where the number of repeated sequences in intergenic regions may differ. [SO:ke]', 585, 0, 0);
INSERT INTO chado.cvterm VALUES (583, 23, 'sequence_length_alteration', 'A kind of kind of sequence alteration where the copies of a region present varies across a population. [SO:ke]', 586, 0, 0);
INSERT INTO chado.cvterm VALUES (584, 23, 'terminal_inverted_repeat_element', 'A DNA transposable element defined as having termini with perfect, or nearly perfect short inverted repeats, generally 10 - 40 nucleotides long. [http://www.genetics.org/cgi/reprint/156/4/1983.pdf]', 587, 0, 0);
INSERT INTO chado.cvterm VALUES (585, 23, 'rRNA_primary_transcript', 'A primary transcript encoding a ribosomal RNA. [SO:ke]', 588, 0, 0);
INSERT INTO chado.cvterm VALUES (586, 23, 'tRNA_primary_transcript', 'A primary transcript encoding a transfer RNA (SO:0000253). [SO:ke]', 589, 0, 0);
INSERT INTO chado.cvterm VALUES (587, 23, 'alanine_tRNA_primary_transcript', 'A primary transcript encoding alanyl tRNA. [SO:ke]', 590, 0, 0);
INSERT INTO chado.cvterm VALUES (588, 23, 'arginine_tRNA_primary_transcript', 'A primary transcript encoding arginyl tRNA (SO:0000255). [SO:ke]', 591, 0, 0);
INSERT INTO chado.cvterm VALUES (589, 23, 'asparagine_tRNA_primary_transcript', 'A primary transcript encoding asparaginyl tRNA (SO:0000256). [SO:ke]', 592, 0, 0);
INSERT INTO chado.cvterm VALUES (590, 23, 'aspartic_acid_tRNA_primary_transcript', 'A primary transcript encoding aspartyl tRNA (SO:0000257). [SO:ke]', 593, 0, 0);
INSERT INTO chado.cvterm VALUES (591, 23, 'cysteine_tRNA_primary_transcript', 'A primary transcript encoding cysteinyl tRNA (SO:0000258). [SO:ke]', 594, 0, 0);
INSERT INTO chado.cvterm VALUES (592, 23, 'glutamic_acid_tRNA_primary_transcript', 'A primary transcript encoding glutaminyl tRNA (SO:0000260). [SO:ke]', 595, 0, 0);
INSERT INTO chado.cvterm VALUES (593, 23, 'glutamine_tRNA_primary_transcript', 'A primary transcript encoding glutamyl tRNA (SO:0000260). [SO:ke]', 596, 0, 0);
INSERT INTO chado.cvterm VALUES (594, 23, 'glycine_tRNA_primary_transcript', 'A primary transcript encoding glycyl tRNA (SO:0000263). [SO:ke]', 597, 0, 0);
INSERT INTO chado.cvterm VALUES (595, 23, 'histidine_tRNA_primary_transcript', 'A primary transcript encoding histidyl tRNA (SO:0000262). [SO:ke]', 598, 0, 0);
INSERT INTO chado.cvterm VALUES (596, 23, 'isoleucine_tRNA_primary_transcript', 'A primary transcript encoding isoleucyl tRNA (SO:0000263). [SO:ke]', 599, 0, 0);
INSERT INTO chado.cvterm VALUES (597, 23, 'leucine_tRNA_primary_transcript', 'A primary transcript encoding leucyl tRNA (SO:0000264). [SO:ke]', 600, 0, 0);
INSERT INTO chado.cvterm VALUES (598, 23, 'lysine_tRNA_primary_transcript', 'A primary transcript encoding lysyl tRNA (SO:0000265). [SO:ke]', 601, 0, 0);
INSERT INTO chado.cvterm VALUES (599, 23, 'methionine_tRNA_primary_transcript', 'A primary transcript encoding methionyl tRNA (SO:0000266). [SO:ke]', 602, 0, 0);
INSERT INTO chado.cvterm VALUES (600, 23, 'phenylalanine_tRNA_primary_transcript', 'A primary transcript encoding phenylalanyl tRNA (SO:0000267). [SO:ke]', 603, 0, 0);
INSERT INTO chado.cvterm VALUES (601, 23, 'proline_tRNA_primary_transcript', 'A primary transcript encoding prolyl tRNA (SO:0000268). [SO:ke]', 604, 0, 0);
INSERT INTO chado.cvterm VALUES (730, 23, 'mRNA_with_plus_2_frameshift', 'An mRNA with a plus 2 frameshift. [SO:xp]', 735, 0, 0);
INSERT INTO chado.cvterm VALUES (602, 23, 'serine_tRNA_primary_transcript', 'A primary transcript encoding seryl tRNA (SO:000269). [SO:ke]', 605, 0, 0);
INSERT INTO chado.cvterm VALUES (603, 23, 'threonine_tRNA_primary_transcript', 'A primary transcript encoding threonyl tRNA (SO:000270). [SO:ke]', 606, 0, 0);
INSERT INTO chado.cvterm VALUES (604, 23, 'tryptophan_tRNA_primary_transcript', 'A primary transcript encoding tryptophanyl tRNA (SO:000271). [SO:ke]', 607, 0, 0);
INSERT INTO chado.cvterm VALUES (605, 23, 'tyrosine_tRNA_primary_transcript', 'A primary transcript encoding tyrosyl tRNA (SO:000272). [SO:ke]', 608, 0, 0);
INSERT INTO chado.cvterm VALUES (606, 23, 'valine_tRNA_primary_transcript', 'A primary transcript encoding valyl tRNA (SO:000273). [SO:ke]', 609, 0, 0);
INSERT INTO chado.cvterm VALUES (607, 23, 'snRNA_primary_transcript', 'A primary transcript encoding a small nuclear RNA (SO:0000274). [SO:ke]', 610, 0, 0);
INSERT INTO chado.cvterm VALUES (608, 23, 'snoRNA_primary_transcript', 'A primary transcript encoding one or more small nucleolar RNAs (SO:0000275). [SO:ke]', 611, 0, 0);
INSERT INTO chado.cvterm VALUES (609, 23, 'mature_transcript', 'A transcript which has undergone the necessary modifications, if any, for its function. In eukaryotes this includes, for example, processing of introns, cleavage, base modification, and modifications to the 5'' and/or the 3'' ends, other than addition of bases. In bacteria functional mRNAs are usually not modified. [SO:ke]', 612, 0, 0);
INSERT INTO chado.cvterm VALUES (610, 23, 'TF_binding_site', 'A DNA site where a transcription factor binds. [SO:ke]', 613, 0, 0);
INSERT INTO chado.cvterm VALUES (611, 23, 'ORF', 'The in-frame interval between the stop codons of a reading frame which when read as sequential triplets, has the potential of encoding a sequential string of amino acids. TER(NNN)nTER. [SGD:rb, SO:ma]', 614, 0, 0);
INSERT INTO chado.cvterm VALUES (612, 23, 'reading_frame', 'A nucleic acid sequence that when read as sequential triplets, has the potential of encoding a sequential string of amino acids. It need not contain the start or stop codon. [SGD:rb]', 615, 0, 0);
INSERT INTO chado.cvterm VALUES (613, 23, 'feature_attribute', 'An attribute describing a located_sequence_feature. [SO:ke]', 616, 0, 0);
INSERT INTO chado.cvterm VALUES (614, 23, 'foldback_element', 'A transposable element with extensive secondary structure, characterized by large modular imperfect long inverted repeats. [http://www.genetics.org/cgi/reprint/156/4/1983.pdf]', 617, 0, 0);
INSERT INTO chado.cvterm VALUES (615, 23, 'flanking_region', 'The sequences extending on either side of a specific region. [SO:ke]', 618, 0, 0);
INSERT INTO chado.cvterm VALUES (616, 23, 'topologically_defined_region', 'A DNA region within which self-interaction occurs more often than expected by chance because of DNA-looping. [PMID:32782014, SO:cb]', 619, 0, 0);
INSERT INTO chado.cvterm VALUES (617, 23, 'chromosome_variation', 'A deviation in chromosome structure or number. []', 620, 0, 0);
INSERT INTO chado.cvterm VALUES (618, 23, 'variant_collection', 'A collection of one or more sequences of an individual. [SO:ke]', 621, 0, 0);
INSERT INTO chado.cvterm VALUES (619, 23, 'chromosomally_aberrant_genome', 'When a genome contains an abnormal amount of chromosomes. []', 622, 0, 0);
INSERT INTO chado.cvterm VALUES (620, 23, 'internal_UTR', 'A UTR bordered by the terminal and initial codons of two CDSs in a polycistronic transcript. Every UTR is either 5'', 3'' or internal. [SO:cjm]', 623, 0, 0);
INSERT INTO chado.cvterm VALUES (621, 23, 'untranslated_region_polycistronic_mRNA', 'The untranslated sequence separating the ''cistrons'' of multicistronic mRNA. [SO:ke]', 624, 0, 0);
INSERT INTO chado.cvterm VALUES (622, 23, 'internal_ribosome_entry_site', 'Sequence element that recruits a ribosomal subunit to internal mRNA for translation initiation. [SO:ke]', 625, 0, 0);
INSERT INTO chado.cvterm VALUES (623, 23, 'four_cutter_restriction_site', '', 626, 1, 0);
INSERT INTO chado.cvterm VALUES (624, 23, 'mRNA_by_polyadenylation_status', '', 627, 1, 0);
INSERT INTO chado.cvterm VALUES (625, 23, 'polyadenylated', 'A attribute describing the addition of a poly A tail to the 3'' end of a mRNA molecule. [SO:ke]', 628, 0, 0);
INSERT INTO chado.cvterm VALUES (626, 23, 'mRNA_attribute', 'An attribute describing an mRNA feature. [SO:ke]', 629, 0, 0);
INSERT INTO chado.cvterm VALUES (627, 23, 'mRNA_not_polyadenylated', '', 630, 1, 0);
INSERT INTO chado.cvterm VALUES (628, 23, 'six_cutter_restriction_site', '', 631, 1, 0);
INSERT INTO chado.cvterm VALUES (629, 23, 'modified_RNA_base_feature', 'A post_transcriptionally modified base. [SO:ke]', 632, 0, 0);
INSERT INTO chado.cvterm VALUES (630, 23, 'base', 'A base is a sequence feature that corresponds to a single unit of a nucleotide polymer. [SO:ke]', 633, 0, 0);
INSERT INTO chado.cvterm VALUES (631, 23, 'eight_cutter_restriction_site', '', 634, 1, 0);
INSERT INTO chado.cvterm VALUES (632, 23, 'rRNA', 'rRNA is an RNA component of a ribosome that can provide both structural scaffolding and catalytic activity. [http://www.insdc.org/files/feature_table.html, ISBN:0198506732]', 635, 0, 0);
INSERT INTO chado.cvterm VALUES (633, 23, 'tRNA', 'Transfer RNA (tRNA) molecules are approximately 80 nucleotides in length. Their secondary structure includes four short double-helical elements and three loops (D, anti-codon, and T loops). Further hydrogen bonds mediate the characteristic L-shaped molecular structure. Transfer RNAs have two regions of fundamental functional importance: the anti-codon, which is responsible for specific mRNA codon recognition, and the 3'' end, to which the tRNA''s corresponding amino acid is attached (by aminoacyl-tRNA synthetases). Transfer RNAs cope with the degeneracy of the genetic code in two manners: having more than one tRNA (with a specific anti-codon) for a particular amino acid; and ''wobble'' base-pairing, i.e. permitting non-standard base-pairing at the 3rd anti-codon position. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00005, ISBN:0198506732]', 636, 0, 0);
INSERT INTO chado.cvterm VALUES (634, 23, 'sncRNA', 'A non-coding RNA less than 200 nucleotides in length. [PMID:30069443]', 637, 0, 0);
INSERT INTO chado.cvterm VALUES (635, 23, 'alanyl_tRNA', 'A tRNA sequence that has an alanine anticodon, and a 3'' alanine binding region. [SO:ke]', 638, 0, 0);
INSERT INTO chado.cvterm VALUES (636, 23, 'rRNA_small_subunit_primary_transcript', 'A primary transcript encoding a small ribosomal subunit RNA. [SO:ke]', 639, 0, 0);
INSERT INTO chado.cvterm VALUES (637, 23, 'asparaginyl_tRNA', 'A tRNA sequence that has an asparagine anticodon, and a 3'' asparagine binding region. [SO:ke]', 640, 0, 0);
INSERT INTO chado.cvterm VALUES (638, 23, 'aspartyl_tRNA', 'A tRNA sequence that has an aspartic acid anticodon, and a 3'' aspartic acid binding region. [SO:ke]', 641, 0, 0);
INSERT INTO chado.cvterm VALUES (639, 23, 'cysteinyl_tRNA', 'A tRNA sequence that has a cysteine anticodon, and a 3'' cysteine binding region. [SO:ke]', 642, 0, 0);
INSERT INTO chado.cvterm VALUES (640, 23, 'glutaminyl_tRNA', 'A tRNA sequence that has a glutamine anticodon, and a 3'' glutamine binding region. [SO:ke]', 643, 0, 0);
INSERT INTO chado.cvterm VALUES (641, 23, 'glutamyl_tRNA', 'A tRNA sequence that has a glutamic acid anticodon, and a 3'' glutamic acid binding region. [SO:ke]', 644, 0, 0);
INSERT INTO chado.cvterm VALUES (642, 23, 'glycyl_tRNA', 'A tRNA sequence that has a glycine anticodon, and a 3'' glycine binding region. [SO:ke]', 645, 0, 0);
INSERT INTO chado.cvterm VALUES (643, 23, 'histidyl_tRNA', 'A tRNA sequence that has a histidine anticodon, and a 3'' histidine binding region. [SO:ke]', 646, 0, 0);
INSERT INTO chado.cvterm VALUES (644, 23, 'isoleucyl_tRNA', 'A tRNA sequence that has an isoleucine anticodon, and a 3'' isoleucine binding region. [SO:ke]', 647, 0, 0);
INSERT INTO chado.cvterm VALUES (645, 23, 'leucyl_tRNA', 'A tRNA sequence that has a leucine anticodon, and a 3'' leucine binding region. [SO:ke]', 648, 0, 0);
INSERT INTO chado.cvterm VALUES (646, 23, 'lysyl_tRNA', 'A tRNA sequence that has a lysine anticodon, and a 3'' lysine binding region. [SO:ke]', 649, 0, 0);
INSERT INTO chado.cvterm VALUES (647, 23, 'methionyl_tRNA', 'A tRNA sequence that has a methionine anticodon, and a 3'' methionine binding region. [SO:ke]', 650, 0, 0);
INSERT INTO chado.cvterm VALUES (648, 23, 'phenylalanyl_tRNA', 'A tRNA sequence that has a phenylalanine anticodon, and a 3'' phenylalanine binding region. [SO:ke]', 651, 0, 0);
INSERT INTO chado.cvterm VALUES (649, 23, 'prolyl_tRNA', 'A tRNA sequence that has a proline anticodon, and a 3'' proline binding region. [SO:ke]', 652, 0, 0);
INSERT INTO chado.cvterm VALUES (650, 23, 'seryl_tRNA', 'A tRNA sequence that has a serine anticodon, and a 3'' serine binding region. [SO:ke]', 653, 0, 0);
INSERT INTO chado.cvterm VALUES (651, 23, 'threonyl_tRNA', 'A tRNA sequence that has a threonine anticodon, and a 3'' threonine binding region. [SO:ke]', 654, 0, 0);
INSERT INTO chado.cvterm VALUES (652, 23, 'tryptophanyl_tRNA', 'A tRNA sequence that has a tryptophan anticodon, and a 3'' tryptophan binding region. [SO:ke]', 655, 0, 0);
INSERT INTO chado.cvterm VALUES (653, 23, 'tyrosyl_tRNA', 'A tRNA sequence that has a tyrosine anticodon, and a 3'' tyrosine binding region. [SO:ke]', 656, 0, 0);
INSERT INTO chado.cvterm VALUES (654, 23, 'valyl_tRNA', 'A tRNA sequence that has a valine anticodon, and a 3'' valine binding region. [SO:ke]', 657, 0, 0);
INSERT INTO chado.cvterm VALUES (655, 23, 'snRNA', 'A small nuclear RNA molecule involved in pre-mRNA splicing and processing. [http://www.insdc.org/files/feature_table.html, PMID:11733745, WB:ems]', 658, 0, 0);
INSERT INTO chado.cvterm VALUES (656, 23, 'snoRNA', 'Small nucleolar RNAs (snoRNAs) are short non-coding RNAs enriched in the nucleolus as components of small nucleolar ribonucleoproteins. They guide ribose methylation and pseudouridylation of rRNAs and snRNAs, and a subgroup regulate excision of rRNAs from rRNA precursor transcripts. snoRNAs may also guide rRNA acetylation and tRNA methylation, and regulate mRNA abundance and alternative splicing. [GOC:kgc, PMID:31828325]', 659, 0, 0);
INSERT INTO chado.cvterm VALUES (657, 23, 'miRNA', 'Small, ~22-nt, RNA molecule that is the endogenous transcript of a miRNA gene (or the product of other non coding RNA genes. Micro RNAs are produced from precursor molecules (SO:0001244) that can form local hairpin structures, which ordinarily are processed (usually via the Dicer pathway) such that a single miRNA molecule accumulates from one arm of a hairpin precursor molecule. Micro RNAs may trigger the cleavage of their target molecules or act as translational repressors. [PMID:11081512, PMID:12592000]', 660, 0, 0);
INSERT INTO chado.cvterm VALUES (658, 23, 'small_regulatory_ncRNA', 'A non-coding RNA less than 200 nucleotides long, usually with a specific secondary structure, that acts to regulate gene expression. These include short ncRNAs such as piRNA, miRNA and siRNAs (among others). [PMID:28541282, PomBase:al, SO:ma]', 662, 0, 0);
INSERT INTO chado.cvterm VALUES (659, 23, 'pre_miRNA', 'The 60-70 nucleotide region remain after Drosha processing of the primary transcript, that folds back upon itself to form a hairpin structure. [SO:ke]', 663, 0, 0);
INSERT INTO chado.cvterm VALUES (660, 23, 'transcript_bound_by_nucleic_acid', 'A transcript that is bound by a nucleic acid. [SO:xp]', 664, 0, 0);
INSERT INTO chado.cvterm VALUES (661, 23, 'bound_by_nucleic_acid', 'An attribute describing a sequence that is bound by a nucleic acid. [SO:ke]', 665, 0, 0);
INSERT INTO chado.cvterm VALUES (662, 23, 'transcript_bound_by_protein', 'A transcript that is bound by a protein. [SO:xp]', 666, 0, 0);
INSERT INTO chado.cvterm VALUES (663, 23, 'bound_by_protein', 'An attribute describing a sequence that is bound by a protein. [SO:ke]', 667, 0, 0);
INSERT INTO chado.cvterm VALUES (664, 23, 'engineered_gene', 'A gene that is engineered. [SO:xp]', 668, 0, 0);
INSERT INTO chado.cvterm VALUES (665, 23, 'engineered_region', 'A region that is engineered. [SO:xp]', 669, 0, 0);
INSERT INTO chado.cvterm VALUES (666, 23, 'engineered', 'An attribute to describe a region that was modified in vitro. [SO:ke]', 670, 0, 0);
INSERT INTO chado.cvterm VALUES (667, 23, 'engineered_foreign_gene', 'A gene that is engineered and foreign. [SO:xp]', 671, 0, 0);
INSERT INTO chado.cvterm VALUES (668, 23, 'foreign_gene', 'A gene that is foreign. [SO:xp]', 672, 0, 0);
INSERT INTO chado.cvterm VALUES (669, 23, 'engineered_foreign_region', 'A region that is engineered and foreign. [SO:xp]', 673, 0, 0);
INSERT INTO chado.cvterm VALUES (670, 23, 'foreign', 'An attribute to describe a region from another species. [SO:ke]', 674, 0, 0);
INSERT INTO chado.cvterm VALUES (671, 23, 'mRNA_with_minus_1_frameshift', 'An mRNA with a minus 1 frameshift. [SO:xp]', 675, 0, 0);
INSERT INTO chado.cvterm VALUES (672, 23, 'minus_1_frameshift', 'A frameshift caused by deleting one base. [SO:ke]', 676, 0, 0);
INSERT INTO chado.cvterm VALUES (673, 23, 'engineered_foreign_transposable_element_gene', 'A transposable_element that is engineered and foreign. [SO:xp]', 677, 0, 0);
INSERT INTO chado.cvterm VALUES (674, 23, 'type_I_enzyme_restriction_site', 'The recognition site is bipartite and interrupted. [http://www.promega.com]', 678, 1, 0);
INSERT INTO chado.cvterm VALUES (675, 23, 'long_terminal_repeat', 'A sequence directly repeated at both ends of a defined sequence, of the sort typically found in retroviruses. [http://www.insdc.org/files/feature_table.html]', 679, 0, 0);
INSERT INTO chado.cvterm VALUES (676, 23, 'repeat_region', 'A region of sequence containing one or more repeat units. [SO:ke]', 680, 0, 0);
INSERT INTO chado.cvterm VALUES (677, 23, 'fusion_gene', 'A gene that is a fusion. [SO:xp]', 681, 0, 0);
INSERT INTO chado.cvterm VALUES (678, 23, 'fusion', 'When two regions of DNA are joined together that are not normally together. []', 682, 0, 0);
INSERT INTO chado.cvterm VALUES (679, 23, 'engineered_fusion_gene', 'A fusion gene that is engineered. [SO:xp]', 683, 0, 0);
INSERT INTO chado.cvterm VALUES (680, 23, 'microsatellite', 'A repeat_region containing repeat_units of 2 to 10 bp repeated in tandem. [http://www.informatics.jax.org/silver/glossary.shtml, NCBI:th]', 684, 0, 0);
INSERT INTO chado.cvterm VALUES (681, 23, 'dinucleotide_repeat_microsatellite_feature', 'A region of a repeating dinucleotide sequence (two bases). []', 685, 0, 0);
INSERT INTO chado.cvterm VALUES (682, 23, 'trinucleotide_repeat_microsatellite_feature', 'A region of a repeating trinucleotide sequence (three bases). []', 686, 0, 0);
INSERT INTO chado.cvterm VALUES (683, 23, 'repetitive_element', '', 687, 1, 0);
INSERT INTO chado.cvterm VALUES (684, 23, 'engineered_foreign_repetitive_element', 'A repetitive element that is engineered and foreign. [SO:xp]', 688, 0, 0);
INSERT INTO chado.cvterm VALUES (685, 23, 'inverted_repeat', 'The sequence is complementarily repeated on the opposite strand. It is a palindrome, and it may, or may not be hyphenated. Examples: GCTGATCAGC, or GCTGA-----TCAGC. [SO:ke]', 689, 0, 0);
INSERT INTO chado.cvterm VALUES (686, 23, 'U12_intron', 'A type of spliceosomal intron spliced by the U12 spliceosome, that includes U11, U12, U4atac/U6atac and U5 snRNAs. [PMID:9428511]', 690, 0, 0);
INSERT INTO chado.cvterm VALUES (687, 23, 'origin_of_replication', 'A region of nucleic acid from which replication initiates; includes sequences that are recognized by replication proteins, the site from which the first separation of complementary strands occurs, and specific replication start sites. [http://www.insdc.org/files/feature_table.html, NCBI:cf]', 691, 0, 0);
INSERT INTO chado.cvterm VALUES (774, 23, 'integrase_coding_region', '', 779, 1, 0);
INSERT INTO chado.cvterm VALUES (688, 23, 'D_loop', 'Displacement loop; a region within mitochondrial DNA in which a short stretch of RNA is paired with one strand of DNA, displacing the original partner DNA strand in this region; also used to describe the displacement of a region of one strand of duplex DNA by a single stranded invader in the reaction catalyzed by RecA protein. [http://www.insdc.org/files/feature_table.html]', 692, 0, 0);
INSERT INTO chado.cvterm VALUES (689, 23, 'recombination_feature', 'A feature where there has been exchange of genetic material in the event of mitosis or meiosis []', 693, 0, 0);
INSERT INTO chado.cvterm VALUES (690, 23, 'specific_recombination_site', 'A location where recombination or occurs during mitosis or meiosis. []', 694, 0, 0);
INSERT INTO chado.cvterm VALUES (691, 23, 'sequence_rearrangement_feature', 'A feature where a segment of DNA has been rearranged from what it was in the parent cell. []', 695, 0, 0);
INSERT INTO chado.cvterm VALUES (692, 23, 'recombination_feature_of_rearranged_gene', 'A location where a gene is rearranged due to recombination during mitosis or meiosis. []', 696, 0, 0);
INSERT INTO chado.cvterm VALUES (693, 23, 'vertebrate_immune_system_gene_recombination_feature', 'A feature where recombination has occurred for the purpose of generating a diversity in the immune system. []', 697, 0, 0);
INSERT INTO chado.cvterm VALUES (694, 23, 'J_gene_recombination_feature', 'Recombination signal including J-heptamer, J-spacer and J-nonamer in 5'' of J-region of a J-gene or J-sequence. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 698, 0, 0);
INSERT INTO chado.cvterm VALUES (695, 23, 'vertebrate_immune_system_gene_recombination_signal_feature', 'Feature used for the recombination of genomic material for the purpose of generating diversity of the immune system. []', 699, 0, 0);
INSERT INTO chado.cvterm VALUES (696, 23, 'clip', 'Part of the primary transcript that is clipped off during processing. [SO:ke]', 700, 0, 0);
INSERT INTO chado.cvterm VALUES (697, 23, 'type_II_enzyme_restriction_site', 'The recognition site is either palindromic, partially palindromic or an interrupted palindrome. Cleavage occurs within the recognition site. [http://www.promega.com]', 701, 1, 0);
INSERT INTO chado.cvterm VALUES (698, 23, 'modified_DNA_base', 'A modified nucleotide, i.e. a nucleotide other than A, T, C. G. [http://www.insdc.org/files/feature_table.html]', 702, 0, 0);
INSERT INTO chado.cvterm VALUES (699, 23, 'epigenetically_modified_region', 'A biological DNA region implicated in epigenomic changes caused by mechanisms other than changes in the underlying DNA sequence. This includes, nucleosomal histone post-translational modifications, nucleosome depletion to render DNA accessible and post-replicational base modifications such as cytosine modification. [http://en.wikipedia.org/wiki/Epigenetics, SO:ke]', 703, 0, 0);
INSERT INTO chado.cvterm VALUES (700, 23, 'CpG_island', 'Regions of a few hundred to a few thousand bases in vertebrate genomes that are relatively GC and CpG rich; they are typically unmethylated and often found near the 5'' ends of genes. [SO:rd]', 704, 0, 0);
INSERT INTO chado.cvterm VALUES (701, 23, 'sequence_feature_locating_method', '', 705, 1, 0);
INSERT INTO chado.cvterm VALUES (702, 23, 'computed_feature', '', 706, 1, 0);
INSERT INTO chado.cvterm VALUES (703, 23, 'predicted_ab_initio_computation', '', 707, 1, 0);
INSERT INTO chado.cvterm VALUES (704, 23, 'computed_feature_by_similarity', '. [SO:ma]', 708, 1, 0);
INSERT INTO chado.cvterm VALUES (705, 23, 'experimentally_determined', 'Attribute to describe a feature that has been experimentally verified. [SO:ke]', 709, 0, 0);
INSERT INTO chado.cvterm VALUES (706, 23, 'validated', 'An attribute to describe a feature that has been proven. [SO:ke]', 710, 0, 0);
INSERT INTO chado.cvterm VALUES (707, 23, 'stem_loop', 'A double-helical region of nucleic acid formed by base-pairing between adjacent (inverted) complementary sequences. [http://www.insdc.org/files/feature_table.html]', 711, 0, 0);
INSERT INTO chado.cvterm VALUES (708, 23, 'direct_repeat', 'A repeat where the same sequence is repeated in the same direction. Example: GCTGA-followed by-GCTGA. [SO:ke]', 713, 0, 0);
INSERT INTO chado.cvterm VALUES (709, 23, 'TSS', 'The first base where RNA polymerase begins to synthesize the RNA transcript. [SO:ke]', 714, 0, 0);
INSERT INTO chado.cvterm VALUES (710, 23, 'core_promoter_element', 'An element that always exists within the promoter region of a gene. When multiple transcripts exist for a gene, the separate transcripts may have separate core_promoter_elements. [GREEKC:rl]', 715, 0, 0);
INSERT INTO chado.cvterm VALUES (711, 23, 'cDNA_clone', 'Complementary DNA; A piece of DNA copied from an mRNA and spliced into a vector for propagation in a suitable host. [http://seqcore.brcf.med.umich.edu/doc/educ/dnapr/mbglossary/mbgloss.html]', 716, 0, 0);
INSERT INTO chado.cvterm VALUES (712, 23, 'cDNA', 'DNA synthesized by reverse transcriptase using RNA as a template. [SO:ma]', 717, 0, 0);
INSERT INTO chado.cvterm VALUES (713, 23, 'start_codon', 'First codon to be translated by a ribosome. [SO:ke]', 718, 0, 0);
INSERT INTO chado.cvterm VALUES (714, 23, 'stop_codon', 'In mRNA, a set of three nucleotides that indicates the end of information for protein synthesis. [SO:ke]', 719, 0, 0);
INSERT INTO chado.cvterm VALUES (715, 23, 'intronic_splice_enhancer', 'Sequences within the intron that modulate splice site selection for some introns. [SO:ke]', 720, 0, 0);
INSERT INTO chado.cvterm VALUES (716, 23, 'splice_enhancer', 'Region of a transcript that regulates splicing. [SO:ke]', 721, 0, 0);
INSERT INTO chado.cvterm VALUES (717, 23, 'spliceosomal_intron_region', 'A region within an intron. [SO:ke]', 722, 0, 0);
INSERT INTO chado.cvterm VALUES (718, 23, 'mRNA_with_plus_1_frameshift', 'An mRNA with a plus 1 frameshift. [SO:ke]', 723, 0, 0);
INSERT INTO chado.cvterm VALUES (719, 23, 'plus_1_frameshift', 'A frameshift caused by inserting one base. [SO:ke]', 724, 0, 0);
INSERT INTO chado.cvterm VALUES (720, 23, 'nuclease_hypersensitive_site', 'A region of nucleotide sequence targeted by a nuclease enzyme that is found cleaved more than would be expected by chance. []', 725, 0, 0);
INSERT INTO chado.cvterm VALUES (721, 23, 'nuclease_sensitive_site', 'A region of nucleotide sequence targeted by a nuclease enzyme. [SO:ma]', 726, 0, 0);
INSERT INTO chado.cvterm VALUES (722, 23, 'accessible_DNA_region', 'A region of DNA that is depleted of nucleosomes and accessible to DNA-binding proteins including transcription factors and nucleases. [PMID:25903461, SO:ds]', 727, 0, 0);
INSERT INTO chado.cvterm VALUES (723, 23, 'coding_start', 'The first base to be translated into protein. [SO:ke]', 728, 0, 0);
INSERT INTO chado.cvterm VALUES (724, 23, 'CDS_region', 'A region of a CDS. [SO:cb]', 729, 0, 0);
INSERT INTO chado.cvterm VALUES (725, 23, 'tag', 'A nucleotide sequence that may be used to identify a larger sequence. [SO:ke]', 730, 0, 0);
INSERT INTO chado.cvterm VALUES (726, 23, 'rRNA_large_subunit_primary_transcript', 'A primary transcript encoding a large ribosomal subunit RNA. [SO:ke]', 731, 0, 0);
INSERT INTO chado.cvterm VALUES (727, 23, 'SAGE_tag', 'A short diagnostic sequence tag, serial analysis of gene expression (SAGE), that allows the quantitative and simultaneous analysis of a large number of transcripts. [http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=7570003&dopt=Abstract]', 732, 0, 0);
INSERT INTO chado.cvterm VALUES (728, 23, 'coding_end', 'The last base to be translated into protein. It does not include the stop codon. [SO:ke]', 733, 0, 0);
INSERT INTO chado.cvterm VALUES (729, 23, 'microarray_oligo', 'A DNA sequence used experimentally to detect the presence or absence of a complementary nucleic acid. []', 734, 0, 0);
INSERT INTO chado.cvterm VALUES (731, 23, 'plus_2_framshift', 'A frameshift caused by inserting two bases. [SO:ke]', 736, 0, 0);
INSERT INTO chado.cvterm VALUES (732, 23, 'conserved_region', 'Region of sequence similarity by descent from a common ancestor. [SO:ke]', 737, 0, 0);
INSERT INTO chado.cvterm VALUES (733, 23, 'STS', 'Short (typically a few hundred base pairs) DNA sequence that has a single occurrence in a genome and whose location and base sequence are known. [http://www.biospace.com]', 738, 0, 0);
INSERT INTO chado.cvterm VALUES (734, 23, 'coding_conserved_region', 'Coding region of sequence similarity by descent from a common ancestor. [SO:ke]', 739, 0, 0);
INSERT INTO chado.cvterm VALUES (735, 23, 'exon_junction', 'The boundary between two exons in a processed transcript. [SO:ke]', 740, 0, 0);
INSERT INTO chado.cvterm VALUES (736, 23, 'nc_conserved_region', 'Non-coding region of sequence similarity by descent from a common ancestor. [SO:ke]', 741, 0, 0);
INSERT INTO chado.cvterm VALUES (737, 23, 'mRNA_with_minus_2_frameshift', 'A mRNA with a minus 2 frameshift. [SO:ke]', 742, 0, 0);
INSERT INTO chado.cvterm VALUES (738, 23, 'minus_2_frameshift', 'A frameshift caused by deleting two bases. [SO:ke]', 743, 0, 0);
INSERT INTO chado.cvterm VALUES (739, 23, 'RNAi_reagent', 'A double stranded RNA duplex, at least 20bp long, used experimentally to inhibit gene function by RNA interference. [SO:rd]', 744, 0, 0);
INSERT INTO chado.cvterm VALUES (740, 23, 'ds_oligo', 'A double stranded oligonucleotide. [SO:ke]', 745, 0, 0);
INSERT INTO chado.cvterm VALUES (741, 23, 'MITE', 'A highly repetitive and short (100-500 base pair) transposable element with terminal inverted repeats (TIR) and target site duplication (TSD). MITEs do not encode proteins. [http://www.pnas.org/cgi/content/full/97/18/10083]', 746, 0, 0);
INSERT INTO chado.cvterm VALUES (742, 23, 'recombination_hotspot', 'A region in a genome which promotes recombination. [SO:rd]', 747, 0, 0);
INSERT INTO chado.cvterm VALUES (743, 23, 'chromosome', 'Structural unit composed of a nucleic acid molecule which controls its own replication through the interaction of specific proteins at one or more origins of replication. [SO:ma]', 748, 0, 0);
INSERT INTO chado.cvterm VALUES (744, 23, 'chromosome_band', 'A cytologically distinguishable feature of a chromosome, often made visible by staining, and usually alternating light and dark. [SO:ma]', 749, 0, 0);
INSERT INTO chado.cvterm VALUES (745, 23, 'site_specific_recombination_target_region', 'A region specifically recognised by a recombinase where recombination can occur during mitosis or meiosis. []', 750, 0, 0);
INSERT INTO chado.cvterm VALUES (746, 23, 'splicing_regulatory_region', 'A regulatory_region that modulates splicing. [SO:ke]', 751, 0, 0);
INSERT INTO chado.cvterm VALUES (747, 23, 'EST', 'A tag produced from a single sequencing read from a cDNA clone or PCR product; typically a few hundred base pairs long. [SO:ke]', 752, 0, 0);
INSERT INTO chado.cvterm VALUES (748, 23, 'loxP_site', 'Cre-Recombination target sequence. []', 753, 0, 0);
INSERT INTO chado.cvterm VALUES (749, 23, 'resolution_site', 'A region specifically recognized by a recombinase, which separates a physically contiguous circle of DNA into two physically separate circles. [SO:as]', 754, 0, 0);
INSERT INTO chado.cvterm VALUES (750, 23, 'nucleic_acid', 'An attribute describing a sequence consisting of nucleobases bound to repeating units. The forms found in nature are deoxyribonucleic acid (DNA), where the repeating units are 2-deoxy-D-ribose rings connected to a phosphate backbone, and ribonucleic acid (RNA), where the repeating units are D-ribose rings connected to a phosphate backbone. [CHEBI:33696, RSC:cb]', 755, 0, 0);
INSERT INTO chado.cvterm VALUES (751, 23, 'polymer_attribute', 'An attribute to describe the kind of biological sequence. [SO:ke]', 756, 0, 0);
INSERT INTO chado.cvterm VALUES (752, 23, 'protein_match', 'A match against a protein sequence. [SO:ke]', 757, 0, 0);
INSERT INTO chado.cvterm VALUES (753, 23, 'FRT_site', 'An inversion site found on the Saccharomyces cerevisiae 2 micron plasmid. [SO:ma]', 758, 0, 0);
INSERT INTO chado.cvterm VALUES (754, 23, 'inversion_site', 'A region specifically recognised by a recombinase, which inverts the region flanked by a pair of sites. [SO:ma]', 759, 0, 0);
INSERT INTO chado.cvterm VALUES (755, 23, 'synthetic_sequence', 'An attribute to decide a sequence of nucleotides, nucleotide analogs, or amino acids that has been designed by an experimenter and which may, or may not, correspond with any natural sequence. [SO:ma]', 760, 0, 0);
INSERT INTO chado.cvterm VALUES (756, 23, 'DNA', 'An attribute describing a sequence consisting of nucleobases bound to a repeating unit made of a 2-deoxy-D-ribose ring connected to a phosphate backbone. [RSC:cb]', 761, 0, 0);
INSERT INTO chado.cvterm VALUES (757, 23, 'assembly', 'A region of the genome of known length that is composed by ordering and aligning two or more different regions. [SO:ke]', 762, 0, 0);
INSERT INTO chado.cvterm VALUES (758, 23, 'group_1_intron_homing_endonuclease_target_region', 'A region of intronic nucleotide sequence targeted by a nuclease enzyme. [SO:ke]', 763, 0, 0);
INSERT INTO chado.cvterm VALUES (759, 23, 'haplotype_block', 'A region of the genome which is co-inherited as the result of the lack of historic recombination within it. [SO:ma]', 764, 0, 0);
INSERT INTO chado.cvterm VALUES (760, 23, 'RNA', 'An attribute describing a sequence consisting of nucleobases bound to a repeating unit made of a D-ribose ring connected to a phosphate backbone. [RSC:cb]', 765, 0, 0);
INSERT INTO chado.cvterm VALUES (761, 23, 'flanked', 'An attribute describing a region that is bounded either side by a particular kind of region. [SO:ke]', 766, 0, 0);
INSERT INTO chado.cvterm VALUES (762, 23, 'floxed', 'An attribute describing sequence that is flanked by Lox-P sites. [SO:ke]', 767, 0, 0);
INSERT INTO chado.cvterm VALUES (763, 23, 'FRT_flanked', 'An attribute to describe sequence that is flanked by the FLP recombinase recognition site, FRT. [SO:ke]', 768, 0, 0);
INSERT INTO chado.cvterm VALUES (764, 23, 'invalidated_by_chimeric_cDNA', 'A cDNA clone constructed from more than one mRNA. Usually an experimental artifact. [SO:ma]', 769, 0, 0);
INSERT INTO chado.cvterm VALUES (765, 23, 'invalidated', 'An attribute describing a feature that is invalidated. [SO:ke]', 770, 0, 0);
INSERT INTO chado.cvterm VALUES (766, 23, 'floxed_gene', 'A transgene that is floxed. [SO:xp]', 771, 0, 0);
INSERT INTO chado.cvterm VALUES (767, 23, 'transgene', 'A transgene is a gene that has been transferred naturally or by any of a number of genetic engineering techniques from one organism to another. [SO:xp]', 772, 0, 0);
INSERT INTO chado.cvterm VALUES (768, 23, 'transposable_element_flanking_region', 'The region of sequence surrounding a transposable element. [SO:ke]', 773, 0, 0);
INSERT INTO chado.cvterm VALUES (769, 23, 'integron', 'A region encoding an integrase which acts at a site adjacent to it (attI_site) to insert DNA which must include but is not limited to an attC_site. [SO:as]', 774, 0, 0);
INSERT INTO chado.cvterm VALUES (770, 23, 'insertion_site', 'The junction where an insertion occurred. [SO:ke]', 775, 0, 0);
INSERT INTO chado.cvterm VALUES (771, 23, 'attI_site', 'A region within an integron, adjacent to an integrase, at which site specific recombination involving an attC_site takes place. [SO:as]', 776, 0, 0);
INSERT INTO chado.cvterm VALUES (772, 23, 'integration_excision_site', 'A region specifically recognised by a recombinase, which inserts or removes another region marked by a distinct cognate integration/excision site. [SO:as]', 777, 0, 0);
INSERT INTO chado.cvterm VALUES (773, 23, 'transposable_element_insertion_site', 'The junction in a genome where a transposable_element has inserted. [SO:ke]', 778, 0, 0);
INSERT INTO chado.cvterm VALUES (775, 23, 'conjugative_transposon', 'A transposon that encodes function required for conjugation. [http://www.sci.sdsu.edu/~smaloy/Glossary/C.html]', 780, 0, 0);
INSERT INTO chado.cvterm VALUES (776, 23, 'enzymatic_RNA', 'An RNA sequence that has catalytic activity with or without an associated ribonucleoprotein. [RSC:cb]', 781, 0, 0);
INSERT INTO chado.cvterm VALUES (777, 23, 'enzymatic', 'An attribute describing the sequence of a transcript that has catalytic activity with or without an associated ribonucleoprotein. [RSC:cb]', 782, 0, 0);
INSERT INTO chado.cvterm VALUES (778, 23, 'recombinationally_inverted_gene', 'A recombinationally rearranged gene by inversion. [SO:xp]', 783, 0, 0);
INSERT INTO chado.cvterm VALUES (779, 23, 'recombinationally_rearranged_gene', 'A gene that is recombinationally rearranged. [SO:ke]', 784, 0, 0);
INSERT INTO chado.cvterm VALUES (780, 23, 'inversion', 'A continuous nucleotide sequence is inverted in the same position. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 785, 0, 0);
INSERT INTO chado.cvterm VALUES (781, 23, 'ribozyme', 'An RNA with catalytic activity. [SO:ma]', 786, 0, 0);
INSERT INTO chado.cvterm VALUES (782, 23, 'ribozymic', 'An attribute describing the sequence of a transcript that has catalytic activity even without an associated ribonucleoprotein. [RSC:cb]', 787, 0, 0);
INSERT INTO chado.cvterm VALUES (783, 23, 'cytosolic_5_8S_rRNA', 'Cytosolic 5.8S rRNA is an RNA component of the large subunit of cytosolic ribosomes in eukaryotes. [https://rfam.xfam.org/family/RF00002]', 788, 0, 0);
INSERT INTO chado.cvterm VALUES (784, 23, 'cytosolic_LSU_rRNA', 'Cytosolic LSU rRNA is an RNA component of the large subunit of cytosolic ribosomes. [SO:ke]', 789, 0, 0);
INSERT INTO chado.cvterm VALUES (785, 23, 'cytosolic_rRNA_5_8S_gene', 'A gene which codes for 5_8S_rRNA (5.8S rRNA), which functions as a component of the large subunit of the ribosome in eukaryotes. []', 790, 0, 0);
INSERT INTO chado.cvterm VALUES (786, 23, 'RNA_6S', 'A small (184-nt in E. coli) RNA that forms a hairpin type structure. 6S RNA associates with RNA polymerase in a highly specific manner. 6S RNA represses expression from a sigma70-dependent promoter during stationary phase. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00013]', 791, 0, 0);
INSERT INTO chado.cvterm VALUES (787, 23, 'CsrB_RsmB_RNA', 'An enterobacterial RNA that binds the CsrA protein. The CsrB RNAs contain a conserved motif CAGGXXG that is found in up to 18 copies and has been suggested to bind CsrA. The Csr regulatory system has a strong negative regulatory effect on glycogen biosynthesis, glyconeogenesis and glycogen catabolism and a positive regulatory effect on glycolysis. In other bacteria such as Erwinia caratovara the RsmA protein has been shown to regulate the production of virulence determinants, such extracellular enzymes. RsmA binds to RsmB regulatory RNA which is also a member of this family. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00018]', 792, 0, 0);
INSERT INTO chado.cvterm VALUES (788, 23, 'DsrA_RNA', 'DsrA RNA regulates both transcription, by overcoming transcriptional silencing by the nucleoid-associated H-NS protein, and translation, by promoting efficient translation of the stress sigma factor, RpoS. These two activities of DsrA can be separated by mutation: the first of three stem-loops of the 85 nucleotide RNA is necessary for RpoS translation but not for anti-H-NS action, while the second stem-loop is essential for antisilencing and less critical for RpoS translation. The third stem-loop, which behaves as a transcription terminator, can be substituted by the trp transcription terminator without loss of either DsrA function. The sequence of the first stem-loop of DsrA is complementary with the upstream leader portion of RpoS messenger RNA, suggesting that pairing of DsrA with the RpoS message might be important for translational regulation. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00014]', 793, 0, 0);
INSERT INTO chado.cvterm VALUES (789, 23, 'GcvB_RNA', 'A small untranslated RNA involved in expression of the dipeptide and oligopeptide transport systems in Escherichia coli. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00022]', 794, 0, 0);
INSERT INTO chado.cvterm VALUES (790, 23, 'hammerhead_ribozyme', 'A small catalytic RNA motif that catalyzes self-cleavage reaction. Its name comes from its secondary structure which resembles a carpenter''s hammer. The hammerhead ribozyme is involved in the replication of some viroid and some satellite RNAs. [PMID:2436805]', 795, 0, 0);
INSERT INTO chado.cvterm VALUES (791, 23, 'group_IIA_intron', 'A group II intron that recognizes IBS1/EBS1 and IBS2/EBS2 for the 5-prime exon and gamma/gamma-prime for the 3-prime exon. [PMID:20463000]', 796, 0, 0);
INSERT INTO chado.cvterm VALUES (792, 23, 'group_II_intron', 'Group II introns are found in rRNA, tRNA and mRNA of organelles in fungi, plants and protists, and also in mRNA in bacteria. They are large self-splicing ribozymes and have 6 structural domains (usually designated dI to dVI). A subset of group II introns also encode essential splicing proteins in intronic ORFs. The length of these introns can therefore be up to 3kb. Splicing occurs in almost identical fashion to nuclear pre-mRNA splicing with two transesterification steps. The 2'' hydroxyl of a bulged adenosine in domain VI attacks the 5'' splice site, followed by nucleophilic attack on the 3'' splice site by the 3'' OH of the upstream exon. Protein machinery is required for splicing in vivo, and long range intron to intron and intron-exon interactions are important for splice site positioning. Group II introns are further sub-classified into groups IIA and IIB which differ in splice site consensus, distance of bulged A from 3'' splice site, some tertiary interactions, and intronic ORF phylogeny. [http://www.sanger.ac.uk/Software/Rfam/browse/index.shtml]', 797, 0, 0);
INSERT INTO chado.cvterm VALUES (793, 23, 'group_IIB_intron', 'A group II intron that recognizes IBS1/EBS1 and IBS2/EBS2 for the 5-prime exon and IBS3/EBS3 for the 3-prime exon. [PMID:20463000]', 798, 0, 0);
INSERT INTO chado.cvterm VALUES (794, 23, 'MicF_RNA', 'A non-translated 93 nt antisense RNA that binds its target ompF mRNA and regulates ompF expression by inhibiting translation and inducing degradation of the message. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00033]', 799, 0, 0);
INSERT INTO chado.cvterm VALUES (795, 23, 'antisense_RNA', 'Antisense RNA is RNA that is transcribed from the coding, rather than the template, strand of DNA. It is therefore complementary to mRNA. [SO:ke]', 800, 0, 0);
INSERT INTO chado.cvterm VALUES (796, 23, 'OxyS_RNA', 'A small untranslated RNA which is induced in response to oxidative stress in Escherichia coli. Acts as a global regulator to activate or repress the expression of as many as 40 genes, including the fhlA-encoded transcriptional activator and the rpoS-encoded sigma(s) subunit of RNA polymerase. OxyS is bound by the Hfq protein, that increases the OxyS RNA interaction with its target messages. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00035]', 801, 0, 0);
INSERT INTO chado.cvterm VALUES (797, 23, 'RNase_MRP_RNA', 'The RNA molecule essential for the catalytic activity of RNase MRP, an enzymatically active ribonucleoprotein with two distinct roles in eukaryotes. In mitochondria it plays a direct role in the initiation of mitochondrial DNA replication. In the nucleus it is involved in precursor rRNA processing, where it cleaves the internal transcribed spacer 1 between 18S and 5.8S rRNAs. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00030]', 802, 0, 0);
INSERT INTO chado.cvterm VALUES (848, 23, 'LTR_component', 'The long terminal repeat found at the ends of the sequence to be inserted into the host genome. []', 860, 0, 0);
INSERT INTO chado.cvterm VALUES (2962, 25, 'Province', '', 3269, 0, 0);
INSERT INTO chado.cvterm VALUES (798, 23, 'RNase_P_RNA', 'The RNA component of Ribonuclease P (RNase P), a ubiquitous endoribonuclease, found in archaea, bacteria and eukarya as well as chloroplasts and mitochondria. Its best characterized activity is the generation of mature 5 prime ends of tRNAs by cleaving the 5 prime leader elements of precursor-tRNAs. Cellular RNase Ps are ribonucleoproteins. RNA from bacterial RNase Ps retains its catalytic activity in the absence of the protein subunit, i.e. it is a ribozyme. Isolated eukaryotic and archaeal RNase P RNA has not been shown to retain its catalytic function, but is still essential for the catalytic activity of the holoenzyme. Although the archaeal and eukaryotic holoenzymes have a much greater protein content than the bacterial ones, the RNA cores from all the three lineages are homologous. Helices corresponding to P1, P2, P3, P4, and P10/11 are common to all cellular RNase P RNAs. Yet, there is considerable sequence variation, particularly among the eukaryotic RNAs. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00010]', 803, 0, 0);
INSERT INTO chado.cvterm VALUES (799, 23, 'RprA_RNA', 'Translational regulation of the stationary phase sigma factor RpoS is mediated by the formation of a double-stranded RNA stem-loop structure in the upstream region of the rpoS messenger RNA, occluding the translation initiation site. Clones carrying rprA (RpoS regulator RNA) increased the translation of RpoS. The rprA gene encodes a 106 nucleotide regulatory RNA. As with DsrA Rfam:RF00014, RprA is predicted to form three stem-loops. Thus, at least two small RNAs, DsrA and RprA, participate in the positive regulation of RpoS translation. Unlike DsrA, RprA does not have an extensive region of complementarity to the RpoS leader, leaving its mechanism of action unclear. RprA is non-essential. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00034]', 804, 0, 0);
INSERT INTO chado.cvterm VALUES (800, 23, 'RRE_RNA', 'The Rev response element (RRE) is encoded within the HIV-env gene. Rev is an essential regulatory protein of HIV that binds an internal loop of the RRE leading, encouraging further Rev-RRE binding. This RNP complex is critical for mRNA export and hence for expression of the HIV structural proteins. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00036]', 805, 0, 0);
INSERT INTO chado.cvterm VALUES (801, 23, 'spot_42_RNA', 'A 109-nucleotide RNA of E. coli that seems to have a regulatory role on the galactose operon. Changes in Spot 42 levels are implicated in affecting DNA polymerase I levels. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00021]', 806, 0, 0);
INSERT INTO chado.cvterm VALUES (802, 23, 'telomerase_RNA', 'The RNA component of telomerase, a reverse transcriptase that synthesizes telomeric DNA. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00025]', 807, 0, 0);
INSERT INTO chado.cvterm VALUES (803, 23, 'U1_snRNA', 'U1 is a small nuclear RNA (snRNA) component of the spliceosome (involved in pre-mRNA splicing). Its 5'' end forms complementary base pairs with the 5'' splice junction, thus defining the 5'' donor site of an intron. There are significant differences in sequence and secondary structure between metazoan and yeast U1 snRNAs, the latter being much longer (568 nucleotides as compared to 164 nucleotides in human). Nevertheless, secondary structure predictions suggest that all U1 snRNAs share a ''common core'' consisting of helices I, II, the proximal region of III, and IV. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00003]', 808, 0, 0);
INSERT INTO chado.cvterm VALUES (804, 23, 'U2_snRNA', 'U2 is a small nuclear RNA (snRNA) component of the spliceosome (involved in pre-mRNA splicing). Complementary binding between U2 snRNA (in an area lying towards the 5'' end but 3'' to hairpin I) and the branchpoint sequence (BPS) of the intron results in the bulging out of an unpaired adenine, on the BPS, which initiates a nucleophilic attack at the intronic 5'' splice site, thus starting the first of two transesterification reactions that mediate splicing. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00004]', 809, 0, 0);
INSERT INTO chado.cvterm VALUES (805, 23, 'U4_snRNA', 'U4 small nuclear RNA (U4 snRNA) is a component of the major U2-dependent spliceosome. It forms a duplex with U6, and with each splicing round, it is displaced from U6 (and the spliceosome) in an ATP-dependent manner, allowing U6 to refold and create the active site for splicing catalysis. A recycling process involving protein Prp24 re-anneals U4 and U6. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00015]', 810, 0, 0);
INSERT INTO chado.cvterm VALUES (806, 23, 'U4atac_snRNA', 'An snRNA required for the splicing of the minor U12-dependent class of eukaryotic nuclear introns. It forms a base paired complex with U6atac_snRNA (SO:0000397). [PMID:12409455]', 811, 0, 0);
INSERT INTO chado.cvterm VALUES (807, 23, 'U5_snRNA', 'U5 RNA is a component of both types of known spliceosome. The precise function of this molecule is unknown, though it is known that the 5'' loop is required for splice site selection and p220 binding, and that both the 3'' stem-loop and the Sm site are important for Sm protein binding and cap methylation. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00020]', 812, 0, 0);
INSERT INTO chado.cvterm VALUES (808, 23, 'U6_snRNA', 'U6 snRNA is a component of the spliceosome which is involved in splicing pre-mRNA. The putative secondary structure consensus base pairing is confined to a short 5'' stem loop, but U6 snRNA is thought to form extensive base-pair interactions with U4 snRNA. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00015]', 813, 0, 0);
INSERT INTO chado.cvterm VALUES (809, 23, 'U6atac_snRNA', 'U6atac_snRNA is an snRNA required for the splicing of the minor U12-dependent class of eukaryotic nuclear introns. It forms a base paired complex with U4atac_snRNA (SO:0000394). [http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=retrieve&db=pubmed&list_uids=12409455&dopt=Abstract]', 814, 0, 0);
INSERT INTO chado.cvterm VALUES (810, 23, 'U11_snRNA', 'U11 snRNA plays a role in splicing of the minor U12-dependent class of eukaryotic nuclear introns, similar to U1 snRNA in the major class spliceosome it base pairs to the conserved 5'' splice site sequence. [PMID:9622129]', 815, 0, 0);
INSERT INTO chado.cvterm VALUES (811, 23, 'U12_snRNA', 'The U12 small nuclear (snRNA), together with U4atac/U6atac, U5, and U11 snRNAs and associated proteins, forms a spliceosome that cleaves a divergent class of low-abundance pre-mRNA introns. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00007]', 816, 0, 0);
INSERT INTO chado.cvterm VALUES (812, 23, 'sequence_attribute', 'An attribute describes a quality of sequence. [SO:ke]', 817, 0, 0);
INSERT INTO chado.cvterm VALUES (813, 23, 'enhancer_attribute', '', 818, 1, 0);
INSERT INTO chado.cvterm VALUES (814, 23, 'U14_snoRNA', 'U14 small nucleolar RNA (U14 snoRNA) is required for early cleavages of eukaryotic precursor rRNAs. In yeasts, this molecule possess a stem-loop region (known as the Y-domain) which is essential for function. A similar structure, but with a different consensus sequence, is found in plants, but is absent in vertebrates. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00016, PMID:2551119]', 819, 0, 0);
INSERT INTO chado.cvterm VALUES (849, 23, 'R_LTR_region', 'The R segment of the long terminal repeats. []', 861, 0, 0);
INSERT INTO chado.cvterm VALUES (850, 23, 'U3_LTR_region', 'The U3 segment of the long terminal repeats. []', 862, 0, 0);
INSERT INTO chado.cvterm VALUES (851, 23, 'five_prime_LTR', 'The long terminal repeat found at the five-prime end of the sequence to be inserted into the host genome. []', 863, 0, 0);
INSERT INTO chado.cvterm VALUES (852, 23, 'three_prime_LTR', 'The long terminal repeat found at the three-prime end of the sequence to be inserted into the host genome. []', 864, 0, 0);
INSERT INTO chado.cvterm VALUES (2963, 25, 'Country', '', 3270, 0, 0);
INSERT INTO chado.cvterm VALUES (815, 23, 'C_D_box_snoRNA', 'Most box C/D snoRNAs also contain long (>10 nt) sequences complementary to rRNA. Boxes C and D, as well as boxes C'' and D'', are usually located in close proximity, and form a structure known as the box C/D motif. This motif is important for snoRNA stability, processing, nucleolar targeting and function. A small number of box C/D snoRNAs are involved in rRNA processing; most, however, are known or predicted to serve as guide RNAs in ribose methylation of rRNA. Targeting involves direct base pairing of the snoRNA at the rRNA site to be modified and selection of a rRNA nucleotide a fixed distance from box D or D''. [http://www.bio.umass.edu/biochem/rna-sequence/Yeast_snoRNA_Database/snoRNA_DataBase.html]', 821, 0, 0);
INSERT INTO chado.cvterm VALUES (816, 23, 'U14_snoRNA_primary_transcript', 'The primary transcript of an evolutionarily conserved eukaryotic low molecular weight RNA capable of intermolecular hybridization with both homologous and heterologous 18S rRNA. [PMID:2251119]', 822, 0, 0);
INSERT INTO chado.cvterm VALUES (817, 23, 'vault_RNA', 'A family of RNAs are found as part of the enigmatic vault ribonucleoprotein complex. The complex consists of a major vault protein (MVP), two minor vault proteins (VPARP and TEP1), and several small untranslated RNA molecules. It has been suggested that the vault complex is involved in drug resistance. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00006]', 823, 0, 0);
INSERT INTO chado.cvterm VALUES (818, 23, 'Y_RNA', 'Y RNAs are components of the Ro ribonucleoprotein particle (Ro RNP), in association with Ro60 and La proteins. The Y RNAs and Ro60 and La proteins are well conserved, but the function of the Ro RNP is not known. In humans the RNA component can be one of four small RNAs: hY1, hY3, hY4 and hY5. These small RNAs are predicted to fold into a conserved secondary structure containing three stem structures. The largest of the four, hY1, contains an additional hairpin. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00019]', 824, 0, 0);
INSERT INTO chado.cvterm VALUES (819, 23, 'twintron', 'An intron within an intron. Twintrons are group II or III introns, into which another group II or III intron has been transposed. [PMID:1899376, PMID:7823908]', 825, 0, 0);
INSERT INTO chado.cvterm VALUES (820, 23, 'cytosolic_18S_rRNA', 'Cytosolic 18S rRNA is an RNA component of the small subunit of cytosolic ribosomes in eukaryotes. [SO:ke]', 826, 0, 0);
INSERT INTO chado.cvterm VALUES (821, 23, 'cytosolic_SSU_rRNA', 'Cytosolic SSU rRNA is an RNA component of the small subunit of cytosolic ribosomes. [SO:ke]', 827, 0, 0);
INSERT INTO chado.cvterm VALUES (822, 23, 'cytosolic_rRNA_18S_gene', 'A gene which codes for 18S_rRNA, which functions as the small subunit of the ribosome in eukaryotes. []', 828, 0, 0);
INSERT INTO chado.cvterm VALUES (823, 23, 'site', 'The interbase position where something (eg an aberration) occurred. [SO:ke]', 829, 1, 0);
INSERT INTO chado.cvterm VALUES (824, 23, 'binding_site', 'A biological_region of sequence that, in the molecule, interacts selectively and non-covalently with other molecules. A region on the surface of a molecule that may interact with another molecule. When applied to polypeptides: Amino acids involved in binding or interactions. It can also apply to an amino acid bond which is represented by the positions of the two flanking amino acids. [EBIBS:GAR, SO:ke]', 830, 0, 0);
INSERT INTO chado.cvterm VALUES (825, 23, 'protein_binding_site', 'A binding site that, in the molecule, interacts selectively and non-covalently with polypeptide molecules. [SO:ke]', 832, 0, 0);
INSERT INTO chado.cvterm VALUES (826, 23, 'rescue_region', 'A region that rescues. [SO:xp]', 833, 0, 0);
INSERT INTO chado.cvterm VALUES (827, 23, 'rescue', 'An attribute describing a region''s ability, when introduced to a mutant organism, to re-establish (rescue) a phenotype. [SO:ke]', 834, 0, 0);
INSERT INTO chado.cvterm VALUES (828, 23, 'sequence_difference', 'A region where the sequence differs from that of a specified sequence. [SO:ke]', 835, 0, 0);
INSERT INTO chado.cvterm VALUES (829, 23, 'remark', 'A comment about the sequence. [SO:ke]', 836, 0, 0);
INSERT INTO chado.cvterm VALUES (830, 23, 'invalidated_by_genomic_contamination', 'An attribute to describe a feature that is invalidated due to genomic contamination. [SO:ke]', 837, 0, 0);
INSERT INTO chado.cvterm VALUES (831, 23, 'invalidated_by_genomic_polyA_primed_cDNA', 'An attribute to describe a feature that is invalidated due to polyA priming. [SO:ke]', 838, 0, 0);
INSERT INTO chado.cvterm VALUES (832, 23, 'invalidated_by_partial_processing', 'An attribute to describe a feature that is invalidated due to partial processing. [SO:ke]', 839, 0, 0);
INSERT INTO chado.cvterm VALUES (833, 23, 'polypeptide_domain', 'A structurally or functionally defined protein region. In proteins with multiple domains, the combination of the domains determines the function of the protein. A region which has been shown to recur throughout evolution. [EBIBS:GAR]', 840, 0, 0);
INSERT INTO chado.cvterm VALUES (834, 23, 'polypeptide_structural_region', 'Region of polypeptide with a given structural property. [EBIBS:GAR, SO:cb]', 844, 0, 0);
INSERT INTO chado.cvterm VALUES (835, 23, 'polypeptide_conserved_region', 'A subsection of sequence with biological interest that is conserved in different proteins. They may or may not have functional or structural significance within the proteins in which they are found. [EBIBS:GAR]', 845, 0, 0);
INSERT INTO chado.cvterm VALUES (836, 23, 'signal_peptide', 'The signal_peptide is a short region of the peptide located at the N-terminus that directs the protein to be secreted or part of membrane components. [http://www.insdc.org/files/feature_table.html]', 846, 0, 0);
INSERT INTO chado.cvterm VALUES (837, 23, 'peptide_localization_signal', 'A region of peptide sequence used to target the polypeptide molecule to a specific organelle. [SO:ke]', 848, 0, 0);
INSERT INTO chado.cvterm VALUES (838, 23, 'signal_peptide_region_of_CDS', 'A CDS region corresponding to a signal peptide of a polypeptide. []', 849, 0, 0);
INSERT INTO chado.cvterm VALUES (839, 23, 'propeptide', 'Part of a peptide chain which is cleaved off during the formation of the mature protein. [EBIBS:GAR]', 850, 0, 0);
INSERT INTO chado.cvterm VALUES (840, 23, 'mature_protein_region', 'The polypeptide sequence that remains when the cleaved peptide regions have been cleaved from the immature peptide. [EBIBS:GAR, http://www.insdc.org/files/feature_table.html, SO:cb]', 851, 0, 0);
INSERT INTO chado.cvterm VALUES (841, 23, 'polypeptide_region', 'Biological sequence region that can be assigned to a specific subsequence of a polypeptide. [SO:GAR, SO:ke]', 853, 0, 0);
INSERT INTO chado.cvterm VALUES (842, 23, 'mature_protein_region_of_CDS', 'A CDS region corresponding to a mature protein region of a polypeptide. []', 854, 0, 0);
INSERT INTO chado.cvterm VALUES (843, 23, 'immature_peptide_region', 'An immature_peptide_region is the extent of the peptide after it has been translated and before any processing occurs. [EBIBS:GAR]', 855, 0, 0);
INSERT INTO chado.cvterm VALUES (844, 23, 'five_prime_terminal_inverted_repeat', 'An inverted repeat (SO:0000294) occurring at the 5-prime termini of a DNA transposon. []', 856, 0, 0);
INSERT INTO chado.cvterm VALUES (845, 23, 'terminal_inverted_repeat', 'An inverted repeat (SO:0000294) occurring at the termini of a DNA transposon. [SO:ke]', 857, 0, 0);
INSERT INTO chado.cvterm VALUES (846, 23, 'three_prime_terminal_inverted_repeat', 'An inverted repeat (SO:0000294) occurring at the 3-prime termini of a DNA transposon. []', 858, 0, 0);
INSERT INTO chado.cvterm VALUES (847, 23, 'U5_LTR_region', 'The U5 segment of the long terminal repeats. []', 859, 0, 0);
INSERT INTO chado.cvterm VALUES (1247, 23, 'mature_transcript_region', 'A region of a mature transcript. [SO:ke]', 1269, 0, 0);
INSERT INTO chado.cvterm VALUES (853, 23, 'R_five_prime_LTR_region', 'The R segment of the three-prime long terminal repeat. []', 865, 0, 0);
INSERT INTO chado.cvterm VALUES (854, 23, 'five_prime_LTR_component', 'A component of the five-prime long terminal repeat. [PMID:8649407]', 866, 0, 0);
INSERT INTO chado.cvterm VALUES (855, 23, 'U5_five_prime_LTR_region', 'The U5 segment of the three-prime long terminal repeat. []', 867, 0, 0);
INSERT INTO chado.cvterm VALUES (856, 23, 'U3_five_prime_LTR_region', 'The U3 segment of the three-prime long terminal repeat. []', 868, 0, 0);
INSERT INTO chado.cvterm VALUES (857, 23, 'R_three_prime_LTR_region', 'The R segment of the three-prime long terminal repeat. []', 869, 0, 0);
INSERT INTO chado.cvterm VALUES (858, 23, 'three_prime_LTR_component', 'A component of the three-prime long terminal repeat. [PMID:8649407]', 870, 0, 0);
INSERT INTO chado.cvterm VALUES (859, 23, 'U3_three_prime_LTR_region', 'The U3 segment of the three-prime long terminal repeat. []', 871, 0, 0);
INSERT INTO chado.cvterm VALUES (860, 23, 'U5_three_prime_LTR_region', 'The U5 segment of the three-prime long terminal repeat. []', 872, 0, 0);
INSERT INTO chado.cvterm VALUES (861, 23, 'non_LTR_retrotransposon_polymeric_tract', 'A polymeric tract, such as poly(dA), within a non_LTR_retrotransposon. [SO:ke]', 873, 0, 0);
INSERT INTO chado.cvterm VALUES (862, 23, 'repeat_component', 'A region of a repeated sequence. [SO:ke]', 874, 0, 0);
INSERT INTO chado.cvterm VALUES (863, 23, 'target_site_duplication', 'A sequence of the target DNA that is duplicated when a transposable element or phage inserts; usually found at each end the insertion. [http://www.koko.gov.my/CocoaBioTech/Glossaryt.html]', 875, 0, 0);
INSERT INTO chado.cvterm VALUES (864, 23, 'RR_tract', 'A polypurine tract within an LTR_retrotransposon. [SO:ke]', 876, 0, 0);
INSERT INTO chado.cvterm VALUES (865, 23, 'ARS', 'A sequence that can autonomously replicate, as a plasmid, when transformed into a bacterial host. [SO:ma]', 877, 0, 0);
INSERT INTO chado.cvterm VALUES (866, 23, 'assortment_derived_duplication', '', 878, 1, 0);
INSERT INTO chado.cvterm VALUES (867, 23, 'gene_not_polyadenylated', '', 879, 1, 0);
INSERT INTO chado.cvterm VALUES (868, 23, 'inverted_ring_chromosome', 'A ring chromosome is a chromosome whose arms have fused together to form a ring in an inverted fashion, often with the loss of the ends of the chromosome. []', 880, 0, 0);
INSERT INTO chado.cvterm VALUES (869, 23, 'chromosomal_inversion', 'An interchromosomal mutation where a region of the chromosome is inverted with respect to wild type. [SO:ke]', 881, 0, 0);
INSERT INTO chado.cvterm VALUES (870, 23, 'ring_chromosome', 'A ring chromosome is a chromosome whose arms have fused together to form a ring, often with the loss of the ends of the chromosome. [http://en.wikipedia.org/wiki/Ring_chromosome]', 882, 0, 0);
INSERT INTO chado.cvterm VALUES (871, 23, 'three_prime_noncoding_exon', 'Non-coding exon in the 3'' UTR. [SO:ke]', 883, 0, 0);
INSERT INTO chado.cvterm VALUES (872, 23, 'five_prime_noncoding_exon', 'Non-coding exon in the 5'' UTR. [SO:ke]', 884, 0, 0);
INSERT INTO chado.cvterm VALUES (873, 23, 'UTR_intron', 'Intron located in the untranslated region. [SO:ke]', 885, 0, 0);
INSERT INTO chado.cvterm VALUES (874, 23, 'five_prime_UTR_intron', 'An intron located in the 5'' UTR. [SO:ke]', 886, 0, 0);
INSERT INTO chado.cvterm VALUES (875, 23, 'three_prime_UTR_intron', 'An intron located in the 3'' UTR. [SO:ke]', 887, 0, 0);
INSERT INTO chado.cvterm VALUES (876, 23, 'random_sequence', 'A sequence of nucleotides or amino acids which, by design, has a \"random\" order of components, given a predetermined input frequency of these components. [SO:ma]', 888, 0, 0);
INSERT INTO chado.cvterm VALUES (877, 23, 'interband', 'A light region between two darkly staining bands in a polytene chromosome. [SO:ma]', 889, 0, 0);
INSERT INTO chado.cvterm VALUES (878, 23, 'gene_with_polyadenylated_mRNA', 'A gene that encodes a polyadenylated mRNA. [SO:xp]', 890, 0, 0);
INSERT INTO chado.cvterm VALUES (879, 23, 'protein_coding_gene', 'A gene that codes for an RNA that can be translated into a protein. []', 891, 0, 0);
INSERT INTO chado.cvterm VALUES (880, 23, 'polyadenylated_mRNA', 'An mRNA that is polyadenylated. [SO:xp]', 892, 0, 0);
INSERT INTO chado.cvterm VALUES (881, 23, 'transgene_attribute', '', 893, 1, 0);
INSERT INTO chado.cvterm VALUES (882, 23, 'chromosomal_transposition', 'A chromosome structure variant whereby a region of a chromosome has been transferred to another position. Among interchromosomal rearrangements, the term transposition is reserved for that class in which the telomeres of the chromosomes involved are coupled (that is to say, form the two ends of a single DNA molecule) as in wild-type. [FB:reference_manual, SO:ke]', 894, 0, 0);
INSERT INTO chado.cvterm VALUES (883, 23, 'rasiRNA', 'A 17-28-nt, small interfering RNA derived from transcripts of repetitive elements. [http://www.developmentalcell.com/content/article/abstract?uid=PIIS1534580703002284, PMID:18032451]', 895, 0, 0);
INSERT INTO chado.cvterm VALUES (884, 23, 'piRNA', 'A small non coding RNA, part of a silencing system that prevents the spreading of selfish genetic elements. [SO:ke]', 896, 0, 0);
INSERT INTO chado.cvterm VALUES (885, 23, 'gene_with_mRNA_with_frameshift', 'A gene that encodes an mRNA with a frameshift. [SO:xp]', 897, 0, 0);
INSERT INTO chado.cvterm VALUES (886, 23, 'recombinationally_rearranged', 'A gene that is recombinationally rearranged. []', 898, 0, 0);
INSERT INTO chado.cvterm VALUES (887, 23, 'interchromosomal_duplication', 'A chromosome duplication involving an insertion from another chromosome. [SO:ke]', 899, 0, 0);
INSERT INTO chado.cvterm VALUES (888, 23, 'chromosomal_duplication', 'An extra chromosome. [SO:ke]', 900, 0, 0);
INSERT INTO chado.cvterm VALUES (889, 23, 'D_gene_segment', 'Germline genomic DNA including D-region with 5'' UTR and 3'' UTR, also designated as D-segment. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 901, 0, 0);
INSERT INTO chado.cvterm VALUES (890, 23, 'vertebrate_immunoglobulin_T_cell_receptor_segment', 'Germline genomic DNA with the sequence for a V, D, C, or J portion of an immunoglobulin/T-cell receptor. []', 902, 0, 0);
INSERT INTO chado.cvterm VALUES (891, 23, 'gene_with_trans_spliced_transcript', 'A gene with a transcript that is trans-spliced. [SO:xp]', 903, 0, 0);
INSERT INTO chado.cvterm VALUES (892, 23, 'trans_spliced_transcript', 'A transcript that is trans-spliced. [SO:xp]', 904, 0, 0);
INSERT INTO chado.cvterm VALUES (893, 23, 'inversion_derived_bipartite_deficiency', 'A chromosomal deletion whereby a chromosome generated by recombination between two inversions; has a deficiency at each end of the inversion. [FB:km]', 905, 0, 0);
INSERT INTO chado.cvterm VALUES (894, 23, 'pseudogenic_region', 'A non-functional descendant of a functional entity. [SO:cjm]', 906, 0, 0);
INSERT INTO chado.cvterm VALUES (895, 23, 'encodes_alternately_spliced_transcripts', 'A gene that encodes more than one transcript. [SO:ke]', 907, 0, 0);
INSERT INTO chado.cvterm VALUES (896, 23, 'decayed_exon', 'A non-functional descendant of an exon. [SO:ke]', 908, 0, 0);
INSERT INTO chado.cvterm VALUES (897, 23, 'inversion_derived_deficiency_plus_duplication', 'A chromosome deletion whereby a chromosome is generated by recombination between two inversions; there is a deficiency at one end of the inversion and a duplication at the other end of the inversion. [FB:km]', 909, 0, 0);
INSERT INTO chado.cvterm VALUES (898, 23, 'intrachromosomal_duplication', 'A duplication that occurred within a chromosome. [SO:ke]', 910, 0, 0);
INSERT INTO chado.cvterm VALUES (899, 23, 'V_gene_segment', 'Germline genomic DNA including L-part1, V-intron and V-exon, with the 5'' UTR and 3'' UTR. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 911, 0, 0);
INSERT INTO chado.cvterm VALUES (900, 23, 'post_translationally_regulated_by_protein_stability', 'An attribute describing a gene sequence where the resulting protein is regulated by the stability of the resulting protein. [SO:ke]', 912, 0, 0);
INSERT INTO chado.cvterm VALUES (901, 23, 'golden_path_fragment', 'One of the pieces of sequence that make up a golden path. [SO:rd]', 913, 0, 0);
INSERT INTO chado.cvterm VALUES (902, 23, 'golden_path', 'A set of subregions selected from sequence contigs which when concatenated form a nonredundant linear sequence. [SO:ls]', 914, 0, 0);
INSERT INTO chado.cvterm VALUES (903, 23, 'post_translationally_regulated_by_protein_modification', 'An attribute describing a gene sequence where the resulting protein is modified to regulate it. [SO:ke]', 915, 0, 0);
INSERT INTO chado.cvterm VALUES (904, 23, 'J_gene_segment', 'Germline genomic DNA of an immunoglobulin/T-cell receptor gene including J-region with 5'' UTR (SO:0000204) and 3'' UTR (SO:0000205), also designated as J-segment. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 916, 0, 0);
INSERT INTO chado.cvterm VALUES (905, 23, 'autoregulated', 'The gene product is involved in its own transcriptional regulation. [SO:ke]', 917, 0, 0);
INSERT INTO chado.cvterm VALUES (906, 23, 'tiling_path', 'A set of regions which overlap with minimal polymorphism to form a linear sequence. [SO:cjm]', 918, 0, 0);
INSERT INTO chado.cvterm VALUES (907, 23, 'negatively_autoregulated', 'The gene product is involved in its own transcriptional regulation where it decreases transcription. [SO:ke]', 919, 0, 0);
INSERT INTO chado.cvterm VALUES (908, 23, 'tiling_path_fragment', 'A piece of sequence that makes up a tiling_path (SO:0000472). [SO:ke]', 920, 0, 0);
INSERT INTO chado.cvterm VALUES (909, 23, 'positively_autoregulated', 'The gene product is involved in its own transcriptional regulation, where it increases transcription. [SO:ke]', 921, 0, 0);
INSERT INTO chado.cvterm VALUES (910, 23, 'contig_read', 'A DNA sequencer read which is part of a contig. [SO:ke]', 922, 0, 0);
INSERT INTO chado.cvterm VALUES (911, 23, 'polycistronic_gene', 'A gene that is polycistronic. [SO:ke]', 923, 1, 0);
INSERT INTO chado.cvterm VALUES (912, 23, 'C_gene_segment', 'Genomic DNA of immunoglobulin/T-cell receptor gene including C-region (and introns if present) with 5'' UTR (SO:0000204) and 3'' UTR (SO:0000205). [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 924, 0, 0);
INSERT INTO chado.cvterm VALUES (913, 23, 'trans_spliced', 'An attribute describing transcript sequence that is created by splicing exons from diferent genes. [SO:ke]', 925, 0, 0);
INSERT INTO chado.cvterm VALUES (914, 23, 'tiling_path_clone', 'A clone which is part of a tiling path. A tiling path is a set of sequencing substrates, typically clones, which have been selected in order to efficiently cover a region of the genome in preparation for sequencing and assembly. [SO:ke]', 926, 0, 0);
INSERT INTO chado.cvterm VALUES (915, 23, 'vertebrate_immunoglobulin_T_cell_receptor_gene_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration. []', 927, 0, 0);
INSERT INTO chado.cvterm VALUES (916, 23, 'three_prime_coding_exon_noncoding_region', 'The sequence of the 3'' exon that is not coding. [SO:ke]', 928, 0, 0);
INSERT INTO chado.cvterm VALUES (917, 23, 'noncoding_region_of_exon', 'The maximal intersection of exon and UTR. [SO:ke]', 929, 0, 0);
INSERT INTO chado.cvterm VALUES (918, 23, 'DJ_J_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one DJ-gene, and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 930, 0, 0);
INSERT INTO chado.cvterm VALUES (919, 23, 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_gene_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration. []', 931, 0, 0);
INSERT INTO chado.cvterm VALUES (920, 23, 'DJ_gene_segment', 'Genomic DNA of immunoglobulin/T-cell receptor gene in partially rearranged genomic DNA including D-J-region with 5'' UTR and 3'' UTR, also designated as D-J-segment. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 932, 0, 0);
INSERT INTO chado.cvterm VALUES (921, 23, 'five_prime_coding_exon_noncoding_region', 'The sequence of the 5'' exon preceding the start codon. [SO:ke]', 933, 0, 0);
INSERT INTO chado.cvterm VALUES (922, 23, 'VDJ_J_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one VDJ-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 934, 0, 0);
INSERT INTO chado.cvterm VALUES (923, 23, 'VDJ_gene_segment', 'Rearranged genomic DNA of immunoglobulin/T-cell receptor gene including L-part1, V-intron and V-D-J-exon, with the 5''UTR (SO:0000204) and 3''UTR (SO:0000205). [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 935, 0, 0);
INSERT INTO chado.cvterm VALUES (924, 23, 'VDJ_J_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one VDJ-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 936, 0, 0);
INSERT INTO chado.cvterm VALUES (925, 23, 'VJ_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one VJ-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 937, 0, 0);
INSERT INTO chado.cvterm VALUES (926, 23, 'VJ_gene_segment', 'Rearranged genomic DNA of immunoglobulin/T-cell receptor gene including L-part1, V-intron and V-J-exon, with the 5''UTR (SO:0000204) and 3''UTR (SO:0000205). [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 938, 0, 0);
INSERT INTO chado.cvterm VALUES (927, 23, 'VJ_J_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one VJ-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 939, 0, 0);
INSERT INTO chado.cvterm VALUES (928, 23, 'VJ_J_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one VJ-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 940, 0, 0);
INSERT INTO chado.cvterm VALUES (929, 23, 'D_gene_recombination_feature', 'Recombination signal including D-heptamer, D-spacer and D-nonamer in 5'' of D-region of a D-gene or D-sequence. []', 941, 0, 0);
INSERT INTO chado.cvterm VALUES (930, 23, 'three_prime_D_heptamer', '7 nucleotide recombination site like CACAGTG, part of a 3'' D-recombination signal sequence of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 942, 0, 0);
INSERT INTO chado.cvterm VALUES (931, 23, 'heptamer_of_recombination_feature_of_vertebrate_immune_system_gene', 'Seven nucleotide recombination site (e.g. CACAGTG), part of V-gene, D-gene or J-gene recombination feature of an immunoglobulin or T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 943, 0, 0);
INSERT INTO chado.cvterm VALUES (932, 23, 'three_prime_D_recombination_signal_sequence', 'Recombination signal of an immunoglobulin/T-cell receptor gene, including the 3'' D-heptamer (SO:0000493), 3'' D-spacer, and 3'' D-nonamer (SO:0000494) in 3'' of the D-region of a D-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 944, 0, 0);
INSERT INTO chado.cvterm VALUES (933, 23, 'three_prime_D_nonamer', 'A 9 nucleotide recombination site (e.g. ACAAAAACC), part of a 3'' D-recombination signal sequence of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 945, 0, 0);
INSERT INTO chado.cvterm VALUES (934, 23, 'nonamer_of_recombination_feature_of_vertebrate_immune_system_gene', 'Nine nucleotide recombination site, part of V-gene, D-gene or J-gene recombination feature of an immunoglobulin or T-cell receptor gene. []', 946, 0, 0);
INSERT INTO chado.cvterm VALUES (935, 23, 'three_prime_D_spacer', 'A 12 or 23 nucleotide spacer between the 3''D-HEPTAMER and 3''D-NONAMER of a 3''D-RS. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 947, 0, 0);
INSERT INTO chado.cvterm VALUES (936, 23, 'vertebrate_immune_system_gene_recombination_spacer', 'A 12 or 23 nucleotide spacer between two regions of an immunoglobulin/T-cell receptor gene that may be rearranged by recombinase. []', 948, 0, 0);
INSERT INTO chado.cvterm VALUES (937, 23, 'five_prime_D_heptamer', '7 nucleotide recombination site (e.g. CACTGTG), part of a 5'' D-recombination signal sequence (SO:0000556) of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 949, 0, 0);
INSERT INTO chado.cvterm VALUES (938, 23, 'five_prime_D_recombination_signal_sequence', 'Recombination signal of an immunoglobulin/T-cell receptor gene, including the 5'' D-nonamer (SO:0000497), 5'' D-spacer (SO:0000498), and 5'' D-heptamer (SO:0000396) in 5'' of the D-region of a D-gene, or in 5'' of the D-region of DJ-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 950, 0, 0);
INSERT INTO chado.cvterm VALUES (939, 23, 'five_prime_D_nonamer', '9 nucleotide recombination site (e.g. GGTTTTTGT), part of a five_prime_D-recombination signal sequence (SO:0000556) of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 951, 0, 0);
INSERT INTO chado.cvterm VALUES (940, 23, 'five_prime_D_spacer', '12 or 23 nucleotide spacer between the 5'' D-heptamer (SO:0000496) and 5'' D-nonamer (SO:0000497) of a 5'' D-recombination signal sequence (SO:0000556) of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 952, 0, 0);
INSERT INTO chado.cvterm VALUES (941, 23, 'virtual_sequence', 'A continuous piece of sequence similar to the ''virtual contig'' concept of the Ensembl database. [SO:ke]', 953, 0, 0);
INSERT INTO chado.cvterm VALUES (942, 23, 'Hoogsteen_base_pair', 'A type of non-canonical base-pairing. This is less energetically favourable than watson crick base pairing. Hoogsteen GC base pairs only have two hydrogen bonds. [PMID:12177293]', 954, 0, 0);
INSERT INTO chado.cvterm VALUES (943, 23, 'reverse_Hoogsteen_base_pair', 'A type of non-canonical base-pairing. [SO:ke]', 955, 0, 0);
INSERT INTO chado.cvterm VALUES (944, 23, 'transcribed_region', 'A region of sequence that is transcribed. This region may cover the transcript of a gene, it may emcompas the sequence covered by all of the transcripts of a alternately spliced gene, or it may cover the region transcribed by a polycistronic transcript. A gene may have 1 or more transcribed regions and a transcribed_region may belong to one or more genes. [SO:ke]', 956, 1, 0);
INSERT INTO chado.cvterm VALUES (945, 23, 'alternately_spliced_gene_encodeing_one_transcript', '', 957, 1, 0);
INSERT INTO chado.cvterm VALUES (946, 23, 'D_DJ_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one D-gene, one DJ-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 958, 0, 0);
INSERT INTO chado.cvterm VALUES (947, 23, 'D_DJ_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one D-gene and one DJ-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 959, 0, 0);
INSERT INTO chado.cvterm VALUES (948, 23, 'D_DJ_J_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one D-gene, one DJ-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 960, 0, 0);
INSERT INTO chado.cvterm VALUES (949, 23, 'pseudogenic_exon', 'A non functional descendant of an exon, part of a pseudogene. [SO:ke]', 961, 0, 0);
INSERT INTO chado.cvterm VALUES (950, 23, 'pseudogenic_transcript', 'A non functional descendant of a transcript, part of a pseudogene. [SO:ke]', 962, 0, 0);
INSERT INTO chado.cvterm VALUES (951, 23, 'D_DJ_J_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one D-gene, one DJ-gene, and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 963, 0, 0);
INSERT INTO chado.cvterm VALUES (952, 23, 'D_J_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including at least one D-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 964, 0, 0);
INSERT INTO chado.cvterm VALUES (953, 23, 'VD_gene_segment', 'Genomic DNA of immunoglobulin/T-cell receptor gene in partially rearranged genomic DNA including L-part1, V-intron and V-D-exon, with the 5'' UTR (SO:0000204) and 3'' UTR (SO:0000205). [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 965, 0, 0);
INSERT INTO chado.cvterm VALUES (954, 23, 'vertebrate_immunoglobulin_T_cell_receptor_rearranged_segment', 'Genomic DNA of immunoglobulin/T-cell receptor gene in partially rearranged genomic DNA. []', 966, 0, 0);
INSERT INTO chado.cvterm VALUES (955, 23, 'J_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including at least one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 967, 0, 0);
INSERT INTO chado.cvterm VALUES (956, 23, 'inversion_derived_deficiency_plus_aneuploid', 'A chromosomal deletion whereby a chromosome generated by recombination between two inversions; has a deficiency at one end and presumed to have a deficiency or duplication at the other end of the inversion. [FB:km]', 968, 0, 0);
INSERT INTO chado.cvterm VALUES (957, 23, 'J_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including more than one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 969, 0, 0);
INSERT INTO chado.cvterm VALUES (958, 23, 'J_nonamer', '9 nucleotide recombination site (e.g. GGTTTTTGT), part of a J-gene recombination feature of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 970, 0, 0);
INSERT INTO chado.cvterm VALUES (959, 23, 'J_heptamer', '7 nucleotide recombination site (e.g. CACAGTG), part of a J-gene recombination feature of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 971, 0, 0);
INSERT INTO chado.cvterm VALUES (960, 23, 'J_spacer', '12 or 23 nucleotide spacer between the J-nonamer and the J-heptamer of a J-gene recombination feature of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 972, 0, 0);
INSERT INTO chado.cvterm VALUES (961, 23, 'V_DJ_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene and one DJ-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 973, 0, 0);
INSERT INTO chado.cvterm VALUES (962, 23, 'V_DJ_J_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one DJ-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 974, 0, 0);
INSERT INTO chado.cvterm VALUES (963, 23, 'V_VDJ_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one VDJ-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 975, 0, 0);
INSERT INTO chado.cvterm VALUES (964, 23, 'V_VDJ_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene and one VDJ-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 976, 0, 0);
INSERT INTO chado.cvterm VALUES (965, 23, 'V_VDJ_J_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one VDJ-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 977, 0, 0);
INSERT INTO chado.cvterm VALUES (966, 23, 'V_VJ_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one VJ-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 978, 0, 0);
INSERT INTO chado.cvterm VALUES (967, 23, 'V_VJ_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene and one VJ-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 979, 0, 0);
INSERT INTO chado.cvterm VALUES (968, 23, 'V_VJ_J_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one VJ-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 980, 0, 0);
INSERT INTO chado.cvterm VALUES (969, 23, 'V_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including more than one V-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 981, 0, 0);
INSERT INTO chado.cvterm VALUES (970, 23, 'V_D_DJ_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one D-gene, one DJ-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 982, 0, 0);
INSERT INTO chado.cvterm VALUES (971, 23, 'V_D_DJ_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one D-gene, one DJ-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 983, 0, 0);
INSERT INTO chado.cvterm VALUES (972, 23, 'V_D_DJ_J_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one D-gene, one DJ-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 984, 0, 0);
INSERT INTO chado.cvterm VALUES (973, 23, 'V_D_DJ_J_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one D-gene, one DJ-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 985, 0, 0);
INSERT INTO chado.cvterm VALUES (974, 23, 'V_D_J_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including at least one V-gene, one D-gene and one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 986, 0, 0);
INSERT INTO chado.cvterm VALUES (975, 23, 'V_D_J_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including at least one V-gene, one D-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 987, 0, 0);
INSERT INTO chado.cvterm VALUES (976, 23, 'V_heptamer', '7 nucleotide recombination site (e.g. CACAGTG), part of V-gene recombination feature of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 988, 0, 0);
INSERT INTO chado.cvterm VALUES (977, 23, 'V_gene_recombination_feature', 'Recombination signal including V-heptamer, V-spacer and V-nonamer in 3'' of V-region of a V-gene or V-sequence of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 989, 0, 0);
INSERT INTO chado.cvterm VALUES (978, 23, 'V_J_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including at least one V-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 990, 0, 0);
INSERT INTO chado.cvterm VALUES (979, 23, 'V_J_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including at least one V-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 991, 0, 0);
INSERT INTO chado.cvterm VALUES (980, 23, 'V_nonamer', '9 nucleotide recombination site (e.g. ACAAAAACC), part of V-gene recombination feature of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 992, 0, 0);
INSERT INTO chado.cvterm VALUES (981, 23, 'V_spacer', '12 or 23 nucleotide spacer between the V-heptamer and the V-nonamer of a V-gene recombination feature of an immunoglobulin/T-cell receptor gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 993, 0, 0);
INSERT INTO chado.cvterm VALUES (982, 23, 'DJ_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one DJ-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 994, 0, 0);
INSERT INTO chado.cvterm VALUES (983, 23, 'DJ_J_C_cluster', 'Genomic DNA in rearranged configuration including at least one D-J-GENE, one J-GENE and one C-GENE. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 995, 0, 0);
INSERT INTO chado.cvterm VALUES (984, 23, 'VDJ_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one VDJ-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 996, 0, 0);
INSERT INTO chado.cvterm VALUES (985, 23, 'V_DJ_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one DJ-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 997, 0, 0);
INSERT INTO chado.cvterm VALUES (986, 23, 'alternately_spliced_gene_encoding_greater_than_one_transcript', '', 998, 1, 0);
INSERT INTO chado.cvterm VALUES (987, 23, 'helitron', 'A rolling circle transposon. Autonomous helitrons encode a 5''-to-3'' DNA helicase and nuclease/ligase similar to those encoded by known rolling-circle replicons. [http://www.pnas.org/cgi/content/full/100/11/6569]', 999, 0, 0);
INSERT INTO chado.cvterm VALUES (988, 23, 'recoding_pseudoknot', 'The pseudoknots involved in recoding are unique in that, as they play their role as a structure, they are immediately unfolded and their now linear sequence serves as a template for decoding. [http://www.pubmedcentral.nih.gov/articlerender.fcgi?artid=33937]', 1000, 0, 0);
INSERT INTO chado.cvterm VALUES (989, 23, 'pseudoknot', 'A tertiary structure in RNA where nucleotides in a loop form base pairs with a region of RNA downstream of the loop. [RSC:cb]', 1001, 0, 0);
INSERT INTO chado.cvterm VALUES (990, 23, 'recoding_stimulatory_region', 'A site in an mRNA sequence that stimulates the recoding of a region in the same mRNA. [http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=12519954&dopt=Abstract]', 1002, 0, 0);
INSERT INTO chado.cvterm VALUES (991, 23, 'designed_sequence', 'An oligonucleotide sequence that was designed by an experimenter that may or may not correspond with any natural sequence. []', 1003, 0, 0);
INSERT INTO chado.cvterm VALUES (992, 23, 'inversion_derived_bipartite_duplication', 'A chromosome generated by recombination between two inversions; there is a duplication at each end of the inversion. [FB:km]', 1004, 0, 0);
INSERT INTO chado.cvterm VALUES (993, 23, 'gene_with_edited_transcript', 'A gene that encodes a transcript that is edited. [SO:xp]', 1005, 0, 0);
INSERT INTO chado.cvterm VALUES (994, 23, 'edited_transcript', 'A transcript that is edited. [SO:ke]', 1006, 0, 0);
INSERT INTO chado.cvterm VALUES (995, 23, 'inversion_derived_duplication_plus_aneuploid', 'A chromosome generated by recombination between two inversions; has a duplication at one end and presumed to have a deficiency or duplication at the other end of the inversion. [FB:km]', 1007, 0, 0);
INSERT INTO chado.cvterm VALUES (996, 23, 'aneuploid_chromosome', 'A chromosome structural variation whereby either a chromosome exists in addition to the normal chromosome complement or is lacking. [SO:ke]', 1008, 0, 0);
INSERT INTO chado.cvterm VALUES (997, 23, 'polyA_signal_sequence', 'The recognition sequence necessary for endonuclease cleavage of an RNA transcript that is followed by polyadenylation; consensus=AATAAA. [http://www.insdc.org/files/feature_table.html]', 1009, 0, 0);
INSERT INTO chado.cvterm VALUES (998, 23, 'Shine_Dalgarno_sequence', 'A region in the 5'' UTR that pairs with the 16S rRNA during formation of the preinitiation complex. [SO:jh]', 1010, 0, 0);
INSERT INTO chado.cvterm VALUES (999, 23, 'polyA_site', 'The site on an RNA transcript to which will be added adenine residues by post-transcriptional polyadenylation. The boundary between the UTR and the polyA sequence. [http://www.insdc.org/files/feature_table.html]', 1011, 0, 0);
INSERT INTO chado.cvterm VALUES (1000, 23, 'assortment_derived_deficiency_plus_duplication', '', 1013, 1, 0);
INSERT INTO chado.cvterm VALUES (1001, 23, 'five_prime_clip', '5'' most region of a precursor transcript that is clipped off during processing. [http://www.insdc.org/files/feature_table.html]', 1014, 0, 0);
INSERT INTO chado.cvterm VALUES (1002, 23, 'three_prime_clip', '3''-most region of a precursor transcript that is clipped off during processing. [http://www.insdc.org/files/feature_table.html]', 1015, 0, 0);
INSERT INTO chado.cvterm VALUES (1003, 23, 'C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene including more than one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 1016, 0, 0);
INSERT INTO chado.cvterm VALUES (1004, 23, 'D_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including more than one D-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 1017, 0, 0);
INSERT INTO chado.cvterm VALUES (1005, 23, 'D_J_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in germline configuration including at least one D-gene and one J-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 1018, 0, 0);
INSERT INTO chado.cvterm VALUES (1006, 23, 'V_DJ_J_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one DJ-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 1019, 0, 0);
INSERT INTO chado.cvterm VALUES (1007, 23, 'V_VDJ_J_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one VDJ-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 1020, 0, 0);
INSERT INTO chado.cvterm VALUES (1008, 23, 'V_VJ_J_C_cluster', 'Genomic DNA of immunoglobulin/T-cell receptor gene in rearranged configuration including at least one V-gene, one VJ-gene, one J-gene and one C-gene. [http://www.imgt.org/cgi-bin/IMGTlect.jv?query=7#]', 1021, 0, 0);
INSERT INTO chado.cvterm VALUES (1009, 23, 'inversion_derived_aneuploid_chromosome', 'A chromosome may be generated by recombination between two inversions; presumed to have a deficiency or duplication at each end of the inversion. [FB:km]', 1022, 0, 0);
INSERT INTO chado.cvterm VALUES (1010, 23, 'bidirectional_promoter', 'A promoter that can allow for transcription in both directions. [PMID:21601935, SO:ke]', 1023, 0, 0);
INSERT INTO chado.cvterm VALUES (1011, 23, 'retrotransposed', 'An attribute of a feature that occurred as the product of a reverse transcriptase mediated event. [SO:ke]', 1024, 0, 0);
INSERT INTO chado.cvterm VALUES (1012, 23, 'miRNA_encoding', 'A region that can be transcribed into a microRNA (miRNA). []', 1026, 0, 0);
INSERT INTO chado.cvterm VALUES (1013, 23, 'rRNA_encoding', 'A region that can be transcribed into a ribosomal RNA (rRNA). []', 1027, 0, 0);
INSERT INTO chado.cvterm VALUES (1014, 23, 'scRNA_encoding', 'A region that can be transcribed into a small cytoplasmic RNA (scRNA). []', 1028, 0, 0);
INSERT INTO chado.cvterm VALUES (1015, 23, 'centromere', 'A region of chromosome where the spindle fibers attach during mitosis and meiosis. [SO:ke]', 1029, 0, 0);
INSERT INTO chado.cvterm VALUES (1016, 23, 'chromosomal_structural_element', 'Regions of the chromosome that are important for structural elements. []', 1030, 0, 0);
INSERT INTO chado.cvterm VALUES (1017, 23, 'snoRNA_encoding', 'A region that can be transcribed into a small nucleolar RNA (snoRNA). []', 1031, 0, 0);
INSERT INTO chado.cvterm VALUES (1018, 23, 'edited_transcript_feature', 'A locatable feature on a transcript that is edited. [SO:ma]', 1032, 0, 0);
INSERT INTO chado.cvterm VALUES (1019, 23, 'methylation_guide_snoRNA_primary_transcript', 'A primary transcript encoding a methylation guide small nucleolar RNA. [SO:ke]', 1033, 0, 0);
INSERT INTO chado.cvterm VALUES (1020, 23, 'cap', 'A structure consisting of a 7-methylguanosine in 5''-5'' triphosphate linkage with the first nucleotide of an mRNA. It is added post-transcriptionally, and is not encoded in the DNA. [http://seqcore.brcf.med.umich.edu/doc/educ/dnapr/mbglossary/mbgloss.html]', 1034, 0, 0);
INSERT INTO chado.cvterm VALUES (1021, 23, 'rRNA_cleavage_snoRNA_primary_transcript', 'A primary transcript encoding an rRNA cleavage snoRNA. [SO:ke]', 1035, 0, 0);
INSERT INTO chado.cvterm VALUES (1022, 23, 'pre_edited_region', 'The region of a transcript that will be edited. [http://dna.kdna.ucla.edu/rna/index.aspx]', 1036, 0, 0);
INSERT INTO chado.cvterm VALUES (1023, 23, 'tmRNA', 'A tmRNA liberates a mRNA from a stalled ribosome. To accomplish this part of the tmRNA is used as a reading frame that ends in a translation stop signal. The broken mRNA is replaced in the ribosome by the tmRNA and translation of the tmRNA leads to addition of a proteolysis tag to the incomplete protein enabling recognition by a protease. Recently a number of permuted tmRNAs genes have been found encoded in two parts. TmRNAs have been identified in eubacteria and some chloroplasts but are absent from archeal and Eukaryote nuclear genomes. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00023]', 1037, 0, 0);
INSERT INTO chado.cvterm VALUES (1024, 23, 'C_D_box_snoRNA_encoding', 'snoRNA that is associated with guiding methylation of nucleotides. It contains two short conserved sequence motifs: C (RUGAUGA) near the 5-prime end and D (CUGA) near the 3-prime end. []', 1038, 0, 0);
INSERT INTO chado.cvterm VALUES (1025, 23, 'tmRNA_primary_transcript', 'A primary transcript encoding a tmRNA (SO:0000584). [SO:ke]', 1039, 0, 0);
INSERT INTO chado.cvterm VALUES (1026, 23, 'group_I_intron', 'Group I catalytic introns are large self-splicing ribozymes. They catalyze their own excision from mRNA, tRNA and rRNA precursors in a wide range of organisms. The core secondary structure consists of 9 paired regions (P1-P9). These fold to essentially two domains, the P4-P6 domain (formed from the stacking of P5, P4, P6 and P6a helices) and the P3-P9 domain (formed from the P8, P3, P7 and P9 helices). Group I catalytic introns often have long ORFs inserted in loop regions. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00028]', 1040, 0, 0);
INSERT INTO chado.cvterm VALUES (1027, 23, 'autocatalytically_spliced_intron', 'A self spliced intron. [SO:ke]', 1041, 0, 0);
INSERT INTO chado.cvterm VALUES (1028, 23, 'SRP_RNA_primary_transcript', 'A primary transcript encoding a signal recognition particle RNA. [SO:ke]', 1042, 0, 0);
INSERT INTO chado.cvterm VALUES (1059, 23, 'RNApol_III_promoter_type_3', 'This type of promoter recruits RNA pol III to transcribe predominantly noncoding RNAs. This promoter contains a proximal sequence element (PSE) and a TATA box upstream of the gene that it regulates. Transcription can also be activated by a distal sequence element (DSE), which is located further upstream.  [PMID:12381659]', 1073, 0, 0);
INSERT INTO chado.cvterm VALUES (1060, 23, 'C_box', 'An RNA polymerase III type 1 promoter with consensus sequence CAnnCCn. [SO:ke]', 1074, 0, 0);
INSERT INTO chado.cvterm VALUES (1061, 23, 'snRNA_encoding', 'A region that can be transcribed into a small nuclear RNA (snRNA). []', 1075, 0, 0);
INSERT INTO chado.cvterm VALUES (1062, 23, 'telomere', 'A specific structure at the end of a linear chromosome, required for the integrity and maintenance of the end. [SO:ma]', 1076, 0, 0);
INSERT INTO chado.cvterm VALUES (2964, 25, 'Postal Code', '', 3271, 0, 0);
INSERT INTO chado.cvterm VALUES (1029, 23, 'SRP_RNA', 'The signal recognition particle (SRP) is a universally conserved ribonucleoprotein. It is involved in the co-translational targeting of proteins to membranes. The eukaryotic SRP consists of a 300-nucleotide 7S RNA and six proteins: SRPs 72, 68, 54, 19, 14, and 9. Archaeal SRP consists of a 7S RNA and homologues of the eukaryotic SRP19 and SRP54 proteins. In most eubacteria, the SRP consists of a 4.5S RNA and the Ffh protein (a homologue of the eukaryotic SRP54 protein). Eukaryotic and archaeal 7S RNAs have very similar secondary structures, with eight helical elements. These fold into the Alu and S domains, separated by a long linker region. Eubacterial SRP is generally a simpler structure, with the M domain of Ffh bound to a region of the 4.5S RNA that corresponds to helix 8 of the eukaryotic and archaeal SRP S domain. Some Gram-positive bacteria (e.g. Bacillus subtilis), however, have a larger SRP RNA that also has an Alu domain. The Alu domain is thought to mediate the peptide chain elongation retardation function of the SRP. The universally conserved helix which interacts with the SRP54/Ffh M domain mediates signal sequence recognition. In eukaryotes and archaea, the SRP19-helix 6 complex is thought to be involved in SRP assembly and stabilizes helix 8 for SRP54 binding. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00017]', 1043, 0, 0);
INSERT INTO chado.cvterm VALUES (1030, 23, 'H_pseudoknot', 'A pseudoknot which contains two stems and at least two loops. [http://www.ncbi.nlm.nih.gov\:80/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=10334330&dopt=Abstract]', 1044, 0, 0);
INSERT INTO chado.cvterm VALUES (1031, 23, 'C_D_box_snoRNA_primary_transcript', 'A primary transcript encoding a small nucleolar RNA of the box C/D family. [SO:ke]', 1045, 0, 0);
INSERT INTO chado.cvterm VALUES (1032, 23, 'H_ACA_box_snoRNA', 'Members of the box H/ACA family contain an ACA triplet, exactly 3 nt upstream from the 3'' end and an H-box in a hinge region that links two structurally similar functional domains of the molecule. Both boxes are important for snoRNA biosynthesis and function. A few box H/ACA snoRNAs are involved in rRNA processing; most others are known or predicted to participate in selection of uridine nucleosides in rRNA to be converted to pseudouridines. Site selection is mediated by direct base pairing of the snoRNA with rRNA through one or both targeting domains. [http://www.bio.umass.edu/biochem/rna-sequence/Yeast_snoRNA_Database/snoRNA_DataBase.html]', 1046, 0, 0);
INSERT INTO chado.cvterm VALUES (1033, 23, 'H_ACA_box_snoRNA_primary_transcript', 'A primary transcript encoding a small nucleolar RNA of the box H/ACA family. [SO:ke]', 1047, 0, 0);
INSERT INTO chado.cvterm VALUES (1034, 23, 'transcript_edited_by_U_insertion/deletion', 'The insertion and deletion of uridine (U) residues, usually within coding regions of mRNA transcripts of cryptogenes in the mitochondrial genome of kinetoplastid protozoa. [http://www.rna.ucla.edu/index.html]', 1048, 1, 0);
INSERT INTO chado.cvterm VALUES (1035, 23, 'edited_by_C_insertion_and_dinucleotide_insertion', '', 1049, 1, 0);
INSERT INTO chado.cvterm VALUES (1036, 23, 'edited_by_C_to_U_substitution', '', 1050, 1, 0);
INSERT INTO chado.cvterm VALUES (1037, 23, 'edited_by_A_to_I_substitution', '', 1051, 1, 0);
INSERT INTO chado.cvterm VALUES (1038, 23, 'edited_by_G_addition', '', 1052, 1, 0);
INSERT INTO chado.cvterm VALUES (1039, 23, 'guide_RNA', 'A short 3''-uridylated RNA that can form a duplex (except for its post-transcriptionally added oligo_U tail (SO:0000609)) with a stretch of mature edited mRNA. [http://www.rna.ucla.edu/index.html]', 1053, 0, 0);
INSERT INTO chado.cvterm VALUES (1040, 23, 'editing_block', 'Edited mRNA sequence mediated by a single guide RNA (SO:0000602). [http://dna.kdna.ucla.edu/rna/index.aspx]', 1054, 0, 0);
INSERT INTO chado.cvterm VALUES (1041, 23, 'intergenic_region', 'A region containing or overlapping no genes that is bounded on either side by a gene, or bounded by a gene and the end of the chromosome. [SO:cjm]', 1055, 0, 0);
INSERT INTO chado.cvterm VALUES (1042, 23, 'editing_domain', 'Edited mRNA sequence mediated by two or more overlapping guide RNAs (SO:0000602). [http://dna.kdna.ucla.edu/rna/index.aspx]', 1056, 0, 0);
INSERT INTO chado.cvterm VALUES (1043, 23, 'unedited_region', 'The region of an edited transcript that will not be edited. [http://dna.kdna.ucla.edu/rna/index.aspx]', 1057, 0, 0);
INSERT INTO chado.cvterm VALUES (1044, 23, 'H_ACA_box_snoRNA_encoding', 'snoRNA that is associated with guiding polyuridylation. It contains two short conserved sequence motifs: H box (ANANNA) and ACA (ACA). []', 1058, 0, 0);
INSERT INTO chado.cvterm VALUES (1045, 23, 'oligo_U_tail', 'The string of non-encoded U''s at the 3'' end of a guide RNA (SO:0000602). [http://www.rna.ucla.edu/]', 1059, 0, 0);
INSERT INTO chado.cvterm VALUES (1046, 23, 'polyA_sequence', 'Sequence of about 100 nucleotides of A added to the 3'' end of most eukaryotic mRNAs. [SO:ke]', 1060, 0, 0);
INSERT INTO chado.cvterm VALUES (1047, 23, 'branch_site', 'A pyrimidine rich sequence near the 3'' end of an intron to which the 5''end becomes covalently bound during nuclear splicing. The resulting structure resembles a lariat. [SO:ke]', 1061, 0, 0);
INSERT INTO chado.cvterm VALUES (1048, 23, 'polypyrimidine_tract', 'The polypyrimidine tract is one of the cis-acting sequence elements directing intron removal in pre-mRNA splicing. [http://nar.oupjournals.org/cgi/content/full/25/4/888]', 1062, 0, 0);
INSERT INTO chado.cvterm VALUES (1049, 23, 'bacterial_RNApol_promoter', 'A DNA sequence to which bacterial RNA polymerase binds, to begin transcription. [SO:ke]', 1063, 0, 0);
INSERT INTO chado.cvterm VALUES (1050, 23, 'prokaryotic_promoter', 'A regulatory_region essential for the specific initiation of transcription at a defined location in a DNA molecule, although this location might not be one single base. It is recognized by a specific RNA polymerase(RNAP)-holoenzyme, and this recognition is not necessarily autonomous. [PMID:32665585]', 1064, 0, 0);
INSERT INTO chado.cvterm VALUES (1051, 23, 'bacterial_terminator', 'A terminator signal for bacterial transcription. [SO:ke]', 1065, 0, 0);
INSERT INTO chado.cvterm VALUES (1052, 23, 'terminator_of_type_2_RNApol_III_promoter', 'A terminator signal for RNA polymerase III transcription. [SO:ke]', 1066, 0, 0);
INSERT INTO chado.cvterm VALUES (1053, 23, 'eukaryotic_terminator', 'A signal for RNA polymerase to terminate transcription. []', 1067, 0, 0);
INSERT INTO chado.cvterm VALUES (1054, 23, 'transcription_end_site', 'The base where transcription ends. [SO:ke]', 1068, 0, 0);
INSERT INTO chado.cvterm VALUES (1055, 23, 'RNApol_III_promoter_type_1', 'This type of promoter recruits RNA pol III. This promoter is intragenic and includes an A box, an intermediate element, and a C box. This is well conserved in the 5s rRNA promoters across species. [PMID:12381659]', 1069, 0, 0);
INSERT INTO chado.cvterm VALUES (1056, 23, 'RNApol_III_promoter_type_2', 'This type of promoter recruits RNA pol III to transcribe genes mainly for t-RNA. This promoter is intragenic and includes an A box and a B box. [PMID:12381659]', 1070, 0, 0);
INSERT INTO chado.cvterm VALUES (1057, 23, 'A_box', 'A variably distant linear promoter region recognized by TFIIIC, with consensus sequence TGGCnnAGTGG. [SO:ke]', 1071, 0, 0);
INSERT INTO chado.cvterm VALUES (1058, 23, 'B_box', 'A variably distant linear promoter region recognized by TFIIIC, with consensus sequence AGGTTCCAnnCC. [SO:ke]', 1072, 0, 0);
INSERT INTO chado.cvterm VALUES (1063, 23, 'silencer', 'A regulatory region which upon binding of transcription factors, suppress the transcription of the gene or genes they control. [SO:ke]', 1077, 0, 0);
INSERT INTO chado.cvterm VALUES (1142, 23, 'experimental_result_region', 'A region of sequence implicated in an experimental result. [SO:ke]', 1160, 0, 0);
INSERT INTO chado.cvterm VALUES (1064, 23, 'insulator', 'A regulatory region that 1) when located between a CRM and a gene''s promoter prevents the CRM from modulating that genes expression and 2) acts as a chromatin boundary element or barrier that can block the encroachment of condensed chromatin from an adjacent region. [NCBI:cf, PMID:12154228, SO:regcreative]', 1078, 0, 0);
INSERT INTO chado.cvterm VALUES (1065, 23, 'five_prime_open_reading_frame', 'An open reading frame found within the 5'' UTR that can be translated and stall the translation of the downstream open reading frame. [PMID:12890013]', 1079, 0, 0);
INSERT INTO chado.cvterm VALUES (1066, 23, 'upstream_AUG_codon', 'A start codon upstream of the ORF. [SO:ke]', 1080, 0, 0);
INSERT INTO chado.cvterm VALUES (1067, 23, 'UTR_region', 'A region of UTR. [SO:ke]', 1081, 0, 0);
INSERT INTO chado.cvterm VALUES (1068, 23, 'polycistronic_primary_transcript', 'A primary transcript encoding for more than one gene product. [SO:ke]', 1082, 0, 0);
INSERT INTO chado.cvterm VALUES (1069, 23, 'monocistronic_primary_transcript', 'A primary transcript encoding for one gene product. [SO:ke]', 1083, 0, 0);
INSERT INTO chado.cvterm VALUES (1070, 23, 'monocistronic_transcript', 'A transcript that is monocistronic. [SO:xp]', 1084, 0, 0);
INSERT INTO chado.cvterm VALUES (1071, 23, 'monocistronic', 'An attribute describing a sequence that contains the code for one gene product. [SO:ke]', 1085, 0, 0);
INSERT INTO chado.cvterm VALUES (1072, 23, 'monocistronic_mRNA', 'An mRNA with either a single protein product, or for which the regions encoding all its protein products overlap. [SO:rd]', 1086, 0, 0);
INSERT INTO chado.cvterm VALUES (1073, 23, 'polycistronic_mRNA', 'An mRNA that encodes multiple proteins from at least two non-overlapping regions. [SO:rd]', 1087, 0, 0);
INSERT INTO chado.cvterm VALUES (1074, 23, 'mini_exon_donor_RNA', 'A primary transcript that donates the spliced leader to other mRNA. [SO:ke]', 1088, 0, 0);
INSERT INTO chado.cvterm VALUES (1075, 23, 'spliced_leader_RNA', 'Snall nuclear RNAs that are incorporated into the pre-mRNAs to replace the 5'' end in some eukaryotes. [PMID:24130571]', 1089, 0, 0);
INSERT INTO chado.cvterm VALUES (1076, 23, 'engineered_plasmid', 'A plasmid that is engineered. [SO:xp]', 1090, 0, 0);
INSERT INTO chado.cvterm VALUES (1077, 23, 'transcribed_spacer_region', 'Part of an rRNA transcription unit that is transcribed but discarded during maturation, not giving rise to any part of rRNA. [http://oregonstate.edu/instruction/bb492/general/glossary.html]', 1091, 0, 0);
INSERT INTO chado.cvterm VALUES (1078, 23, 'rRNA_primary_transcript_region', 'A region of an rRNA primary transcript. [SO:ke]', 1092, 0, 0);
INSERT INTO chado.cvterm VALUES (1079, 23, 'internal_transcribed_spacer_region', 'Non-coding regions of DNA sequence that separate genes coding for the 28S, 5.8S, and 18S ribosomal RNAs. [SO:ke]', 1093, 0, 0);
INSERT INTO chado.cvterm VALUES (1080, 23, 'external_transcribed_spacer_region', 'Non-coding regions of DNA that precede the sequence that codes for the ribosomal RNA. [SO:ke]', 1094, 0, 0);
INSERT INTO chado.cvterm VALUES (1081, 23, 'tetranucleotide_repeat_microsatellite_feature', 'A region of a repeating tetranucleotide sequence (four bases). []', 1095, 0, 0);
INSERT INTO chado.cvterm VALUES (1082, 23, 'SRP_RNA_encoding', 'A region that can be transcribed into a signal recognition particle RNA (SRP RNA). []', 1096, 0, 0);
INSERT INTO chado.cvterm VALUES (1083, 23, 'minisatellite', 'A repeat region containing tandemly repeated sequences having a unit length of 10 to 40 bp. [http://www.informatics.jax.org/silver/glossary.shtml]', 1097, 0, 0);
INSERT INTO chado.cvterm VALUES (1084, 23, 'antisense_primary_transcript', 'The reverse complement of the primary transcript. [SO:ke]', 1098, 0, 0);
INSERT INTO chado.cvterm VALUES (1085, 23, 'siRNA', 'A small RNA molecule that is the product of a longer exogenous or endogenous dsRNA, which is either a bimolecular duplex or very long hairpin, processed (via the Dicer pathway) such that numerous siRNAs accumulate from both strands of the dsRNA. siRNAs trigger the cleavage of their target molecules. [PMID:12592000]', 1099, 0, 0);
INSERT INTO chado.cvterm VALUES (1086, 23, 'miRNA_primary_transcript', 'A primary transcript encoding a micro RNA. [SO:ke]', 1100, 0, 0);
INSERT INTO chado.cvterm VALUES (1087, 23, 'cytosolic_rRNA', 'Cytosolic rRNA is an RNA component of the small or large subunits of cytosolic ribosomes. [PMID:3044395]', 1102, 0, 0);
INSERT INTO chado.cvterm VALUES (1088, 23, 'cytosolic_5S_rRNA', 'Cytosolic 5S rRNA is an RNA component of the large subunit of cytosolic ribosomes in both prokaryotes and eukaryotes. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00001]', 1103, 0, 0);
INSERT INTO chado.cvterm VALUES (1089, 23, 'cytosolic_rRNA_5S_gene', 'A gene which codes for 5S_rRNA, which is a portion of the large subunit of the ribosome in both eukaryotes and prokaryotes. []', 1104, 0, 0);
INSERT INTO chado.cvterm VALUES (1090, 23, 'cytosolic_28S_rRNA', 'Cytosolic 28S rRNA is an RNA component of the large subunit of cytosolic ribosomes in metazoan eukaryotes. [SO:ke]', 1105, 0, 0);
INSERT INTO chado.cvterm VALUES (1091, 23, 'cytosolic_rRNA_28S_gene', 'A gene which codes for 28S_rRNA, which functions as a component of the large subunit of the ribosome in eukaryotes. []', 1106, 0, 0);
INSERT INTO chado.cvterm VALUES (1092, 23, 'maxicircle_gene', 'A mitochondrial gene located in a maxicircle. [SO:xp]', 1107, 0, 0);
INSERT INTO chado.cvterm VALUES (1093, 23, 'maxicircle', 'A maxicircle is a replicon, part of a kinetoplast, that contains open reading frames and replicates via a rolling circle method. [PMID:8395055]', 1108, 0, 0);
INSERT INTO chado.cvterm VALUES (1094, 23, 'stRNA_encoding', 'A region that can be transcribed into a small temporal RNA (stRNA). Found in roundworm development. []', 1109, 0, 0);
INSERT INTO chado.cvterm VALUES (1095, 23, 'repeat_unit', 'The simplest repeated component of a repeat region. A single repeat. [SO:ke]', 1110, 0, 0);
INSERT INTO chado.cvterm VALUES (1096, 23, 'dispersed_repeat', 'A repeat that is located at dispersed sites in the genome. [SO:ke]', 1111, 0, 0);
INSERT INTO chado.cvterm VALUES (1097, 23, 'tmRNA_encoding', 'A region that can be transcribed into a transfer-messenger RNA (tmRNA). []', 1112, 0, 0);
INSERT INTO chado.cvterm VALUES (1098, 23, 'DNA_invertase_target_sequence', '', 1113, 1, 0);
INSERT INTO chado.cvterm VALUES (1099, 23, 'intron_attribute', '', 1114, 1, 0);
INSERT INTO chado.cvterm VALUES (1100, 23, 'tRNA_encoding', 'A region that can be transcribed into a transfer RNA (tRNA). []', 1115, 0, 0);
INSERT INTO chado.cvterm VALUES (1101, 23, 'introgressed_chromosome_region', 'A region of a chromosome that has been introduced by backcrossing with a separate species. [PMID:11454782]', 1116, 0, 0);
INSERT INTO chado.cvterm VALUES (1102, 23, 'mobile_intron', 'An intron (mitochondrial, chloroplast, nuclear or prokaryotic) that encodes a double strand sequence specific endonuclease allowing for mobility. [SO:ke]', 1117, 0, 0);
INSERT INTO chado.cvterm VALUES (1103, 23, 'mobile_genetic_element', 'A nucleotide region with either intra-genome or intracellular mobility, of varying length, which often carry the information necessary for transfer and recombination with the host genome. [PMID:14681355]', 1118, 0, 0);
INSERT INTO chado.cvterm VALUES (1104, 23, 'mobile', 'An attribute describing a feature that has either intra-genome or intracellular mobility. [RSC:cb]', 1119, 0, 0);
INSERT INTO chado.cvterm VALUES (1105, 23, 'insertion', 'The sequence of one or more nucleotides added between two adjacent nucleotides in the sequence. [SO:ke]', 1120, 0, 0);
INSERT INTO chado.cvterm VALUES (1106, 23, 'EST_match', 'A match against an EST sequence. [SO:ke]', 1123, 0, 0);
INSERT INTO chado.cvterm VALUES (1143, 23, 'trans_splice_acceptor_site', 'The 3'' splice site of the acceptor primary transcript. [SO:ke]', 1161, 0, 0);
INSERT INTO chado.cvterm VALUES (1107, 23, 'chromosome_breakage_sequence', 'A sequence within the micronuclear DNA of ciliates at which chromosome breakage and telomere addition occurs during nuclear differentiation. [SO:ma]', 1124, 0, 0);
INSERT INTO chado.cvterm VALUES (1108, 23, 'internal_eliminated_sequence', 'A sequence eliminated from the genome of ciliates during nuclear differentiation. [SO:ma]', 1125, 0, 0);
INSERT INTO chado.cvterm VALUES (1109, 23, 'macronucleus_destined_segment', 'A sequence that is conserved, although rearranged relative to the micronucleus, in the macronucleus of a ciliate genome. [SO:ma]', 1126, 0, 0);
INSERT INTO chado.cvterm VALUES (1110, 23, 'gene_member_region', 'A region of a gene. [SO:ke]', 1127, 0, 0);
INSERT INTO chado.cvterm VALUES (1111, 23, 'unit_of_gene_expression', 'Transcription units or transcribed coding sequences. [Bacterial_regulation_working_group:CMA, PMID:32665585]', 1128, 0, 0);
INSERT INTO chado.cvterm VALUES (1112, 23, 'non_canonical_splice_site', 'A splice site where the donor and acceptor sites differ from the canonical form. [SO:ke]', 1129, 1, 0);
INSERT INTO chado.cvterm VALUES (1113, 23, 'canonical_splice_site', 'The major class of splice site with dinucleotides GT and AG for donor and acceptor sites, respectively. [SO:ke]', 1130, 1, 0);
INSERT INTO chado.cvterm VALUES (1114, 23, 'canonical_three_prime_splice_site', 'The canonical 3'' splice site has the sequence \"AG\". [SO:ke]', 1131, 0, 0);
INSERT INTO chado.cvterm VALUES (1115, 23, 'canonical_five_prime_splice_site', 'The canonical 5'' splice site has the sequence \"GT\". [SO:ke]', 1132, 0, 0);
INSERT INTO chado.cvterm VALUES (1116, 23, 'non_canonical_three_prime_splice_site', 'A 3'' splice site that does not have the sequence \"AG\". [SO:ke]', 1133, 0, 0);
INSERT INTO chado.cvterm VALUES (1117, 23, 'non_canonical_five_prime_splice_site', 'A 5'' splice site which does not have the sequence \"GT\". [SO:ke]', 1134, 0, 0);
INSERT INTO chado.cvterm VALUES (1118, 23, 'non_canonical_start_codon', 'A start codon that is not the usual AUG sequence. [SO:ke]', 1135, 0, 0);
INSERT INTO chado.cvterm VALUES (1119, 23, 'aberrant_processed_transcript', 'A transcript that has been processed \"incorrectly\", for example by the failure of splicing of one or more exons. [SO:ke]', 1136, 0, 0);
INSERT INTO chado.cvterm VALUES (1120, 23, 'splicing_feature', '', 1137, 1, 0);
INSERT INTO chado.cvterm VALUES (1121, 23, 'exonic_splice_enhancer', 'Exonic splicing enhancers (ESEs) facilitate exon definition by assisting in the recruitment of splicing factors to the adjacent intron. [http://www.ncbi.nlm.nih.gov\:80/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=12403462&dopt=Abstract]', 1138, 0, 0);
INSERT INTO chado.cvterm VALUES (1122, 23, 'DNaseI_hypersensitive_site', 'DNA region representing open chromatin structure that is hypersensitive to digestion by DNase I. []', 1139, 0, 0);
INSERT INTO chado.cvterm VALUES (1123, 23, 'translocation_element', 'A chromosomal translocation whereby the chromosomes carrying non-homologous centromeres may be recovered independently. These chromosomes are described as translocation elements. This occurs for some translocations, particularly but not exclusively, reciprocal translocations. [SO:ma]', 1140, 0, 0);
INSERT INTO chado.cvterm VALUES (1124, 23, 'chromosomal_translocation', 'A chromosomal mutation. Rearrangements that alter the pairing of telomeres are classified as translocations. [FB:reference_manual]', 1141, 0, 0);
INSERT INTO chado.cvterm VALUES (1125, 23, 'deletion_junction', 'The space between two bases in a sequence which marks the position where a deletion has occurred. [SO:ke]', 1142, 0, 0);
INSERT INTO chado.cvterm VALUES (1126, 23, 'cDNA_match', 'A match against cDNA sequence. [SO:ke]', 1143, 0, 0);
INSERT INTO chado.cvterm VALUES (1127, 23, 'gene_with_polycistronic_transcript', 'A gene that encodes a polycistronic transcript. [SO:xp]', 1144, 0, 0);
INSERT INTO chado.cvterm VALUES (1128, 23, 'cleaved_initiator_methionine', 'The initiator methionine that has been cleaved from a mature polypeptide sequence. [EBIBS:GAR]', 1145, 0, 0);
INSERT INTO chado.cvterm VALUES (1129, 23, 'cleaved_peptide_region', 'The cleaved_peptide_region is the region of a peptide sequence that is cleaved during maturation. [EBIBS:GAR]', 1147, 0, 0);
INSERT INTO chado.cvterm VALUES (1130, 23, 'gene_with_dicistronic_transcript', 'A gene that encodes a dicistronic transcript. [SO:xp]', 1148, 0, 0);
INSERT INTO chado.cvterm VALUES (1131, 23, 'gene_with_recoded_mRNA', 'A gene that encodes an mRNA that is recoded. [SO:xp]', 1149, 0, 0);
INSERT INTO chado.cvterm VALUES (1132, 23, 'recoded', 'An attribute describing an mRNA sequence that has been reprogrammed at translation, causing localized alterations. [SO:ke]', 1150, 0, 0);
INSERT INTO chado.cvterm VALUES (1133, 23, 'SNP', 'SNPs are single base pair positions in genomic DNA at which different sequence alternatives exist in normal individuals in some population(s), wherein the least frequent variant has an abundance of 1% or greater. [SO:cb]', 1151, 0, 0);
INSERT INTO chado.cvterm VALUES (1134, 23, 'SNV', 'SNVs are single nucleotide positions in genomic DNA at which different sequence alternatives exist. [SO:bm]', 1152, 0, 0);
INSERT INTO chado.cvterm VALUES (1135, 23, 'biomaterial_region', 'A region which is intended for use in an experiment. [SO:cb]', 1153, 0, 0);
INSERT INTO chado.cvterm VALUES (1136, 23, 'gene_with_stop_codon_read_through', 'A gene that encodes a transcript with stop codon readthrough. [SO:xp]', 1154, 0, 0);
INSERT INTO chado.cvterm VALUES (1137, 23, 'stop_codon_read_through', 'A stop codon redefined to be a new amino acid. [SO:ke]', 1155, 0, 0);
INSERT INTO chado.cvterm VALUES (1138, 23, 'gene_with_stop_codon_redefined_as_pyrrolysine', 'A gene encoding an mRNA that has the stop codon redefined as pyrrolysine. [SO:xp]', 1156, 0, 0);
INSERT INTO chado.cvterm VALUES (1139, 23, 'stop_codon_redefined_as_pyrrolysine', 'A stop codon redefined to be the new amino acid, pyrrolysine. [SO:ke]', 1157, 0, 0);
INSERT INTO chado.cvterm VALUES (1140, 23, 'possible_base_call_error', 'A region of sequence where the validity of the base calling is questionable. [SO:ke]', 1158, 0, 0);
INSERT INTO chado.cvterm VALUES (1144, 23, 'trans_splice_site', 'Primary transcript region bordering trans-splice junction. [SO:ke]', 1162, 0, 0);
INSERT INTO chado.cvterm VALUES (1145, 23, 'trans_splice_donor_site', 'The 5'' five prime splice site region of the donor RNA. [SO:ke]', 1163, 0, 0);
INSERT INTO chado.cvterm VALUES (1146, 23, 'SL1_acceptor_site', 'A trans_splicing_acceptor_site which appends the 22nt SL1 RNA leader sequence to the 5'' end of most mRNAs. [SO:nlw]', 1164, 0, 0);
INSERT INTO chado.cvterm VALUES (1147, 23, 'SL2_acceptor_site', 'A trans_splicing_acceptor_site which appends the 22nt SL2 RNA leader sequence to the 5'' end of mRNAs. SL2 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]', 1165, 0, 0);
INSERT INTO chado.cvterm VALUES (1148, 23, 'gene_with_stop_codon_redefined_as_selenocysteine', 'A gene encoding an mRNA that has the stop codon redefined as selenocysteine. [SO:xp]', 1166, 0, 0);
INSERT INTO chado.cvterm VALUES (1149, 23, 'stop_codon_redefined_as_selenocysteine', 'A stop codon redefined to be the new amino acid, selenocysteine. [SO:ke]', 1167, 0, 0);
INSERT INTO chado.cvterm VALUES (1150, 23, 'gene_with_mRNA_recoded_by_translational_bypass', 'A gene with mRNA recoded by translational bypass. [SO:xp]', 1168, 0, 0);
INSERT INTO chado.cvterm VALUES (1151, 23, 'recoded_by_translational_bypass', 'Recoded mRNA where a block of nucleotides is not translated. [SO:ke]', 1169, 0, 0);
INSERT INTO chado.cvterm VALUES (1152, 23, 'gene_with_transcript_with_translational_frameshift', 'A gene encoding a transcript that has a translational frameshift. [SO:xp]', 1170, 0, 0);
INSERT INTO chado.cvterm VALUES (1153, 23, 'nucleotide_motif', 'A region of nucleotide sequence corresponding to a known motif. [SO:ke]', 1171, 0, 0);
INSERT INTO chado.cvterm VALUES (1154, 23, 'sequence_motif', 'A sequence motif is a nucleotide or amino-acid sequence pattern that may have biological significance. [http://en.wikipedia.org/wiki/Sequence_motif]', 1172, 0, 0);
INSERT INTO chado.cvterm VALUES (1155, 23, 'dicistronic_mRNA', 'An mRNA that has the quality dicistronic. [SO:ke]', 1173, 0, 0);
INSERT INTO chado.cvterm VALUES (1156, 23, 'blocked_reading_frame', 'A reading_frame that is interrupted by one or more stop codons; usually identified through inter-genomic sequence comparisons. [SGD:rb]', 1174, 0, 0);
INSERT INTO chado.cvterm VALUES (1157, 23, 'foreign_transposable_element', 'A transposable element that is foreign. [SO:ke]', 1175, 0, 0);
INSERT INTO chado.cvterm VALUES (1158, 23, 'gene_with_dicistronic_primary_transcript', 'A gene that encodes a dicistronic primary transcript. [SO:xp]', 1176, 0, 0);
INSERT INTO chado.cvterm VALUES (1159, 23, 'dicistronic_primary_transcript', 'A primary transcript that has the quality dicistronic. [SO:xp]', 1177, 0, 0);
INSERT INTO chado.cvterm VALUES (1160, 23, 'gene_with_dicistronic_mRNA', 'A gene that encodes a polycistronic mRNA. [SO:xp]', 1178, 0, 0);
INSERT INTO chado.cvterm VALUES (1161, 23, 'iDNA', 'Genomic sequence removed from the genome, as a normal event, by a process of recombination. [SO:ma]', 1179, 0, 0);
INSERT INTO chado.cvterm VALUES (1162, 23, 'oriT', 'A region of a DNA molecule where transfer is initiated during the process of conjugation or mobilization. [http://www.insdc.org/files/feature_table.html]', 1180, 0, 0);
INSERT INTO chado.cvterm VALUES (1163, 23, 'transit_peptide', 'The transit_peptide is a short region at the N-terminus of the peptide that directs the protein to an organelle (chloroplast, mitochondrion, microbody or cyanelle). [http://www.insdc.org/files/feature_table.html]', 1181, 0, 0);
INSERT INTO chado.cvterm VALUES (1164, 23, 'transit_peptide_region_of_CDS', 'CDS region corresponding to a transit peptide region of a polypeptide. []', 1183, 0, 0);
INSERT INTO chado.cvterm VALUES (1165, 23, 'intein', 'A region of a peptide that is able to excise itself and rejoin the remaining portions with a peptide bond. [SO:ke]', 1184, 0, 0);
INSERT INTO chado.cvterm VALUES (1166, 23, 'intein_containing', 'An attribute of protein-coding genes where the initial protein product contains an intein. [SO:ke]', 1185, 0, 0);
INSERT INTO chado.cvterm VALUES (1167, 23, 'gap', 'A gap in the sequence of known length. The unknown bases are filled in with N''s. [SO:ke]', 1186, 0, 0);
INSERT INTO chado.cvterm VALUES (1168, 23, 'fragmentary', 'An attribute to describe a feature that is incomplete. [SO:ke]', 1187, 0, 0);
INSERT INTO chado.cvterm VALUES (1169, 23, 'status', 'An attribute describing the status of a feature, based on the available evidence. [SO:ke]', 1188, 0, 0);
INSERT INTO chado.cvterm VALUES (1170, 23, 'predicted', 'An attribute describing an unverified region. [SO:ke]', 1189, 0, 0);
INSERT INTO chado.cvterm VALUES (1171, 23, 'exemplar_mRNA', 'An exemplar is a representative cDNA sequence for each gene. The exemplar approach is a method that usually involves some initial clustering into gene groups and the subsequent selection of a representative from each gene group. [http://mged.sourceforge.net/ontologies/MGEDontology.php]', 1190, 0, 0);
INSERT INTO chado.cvterm VALUES (1172, 23, 'exemplar', 'An attribute describing a sequence is representative of a class of similar sequences. [SO:ke]', 1191, 0, 0);
INSERT INTO chado.cvterm VALUES (1173, 23, 'sequence_location', 'The location of a sequence. []', 1192, 0, 0);
INSERT INTO chado.cvterm VALUES (1174, 23, 'genome', 'A genome is the sum of genetic material within a cell or virion. [SO:immuno_workshop]', 1194, 0, 0);
INSERT INTO chado.cvterm VALUES (1175, 23, 'minicircle', 'A minicircle is a replicon, part of a kinetoplast, that encodes for guide RNAs. [PMID:8395055]', 1195, 0, 0);
INSERT INTO chado.cvterm VALUES (1176, 23, 'amplification_origin', 'An origin_of_replication that is used for the amplification of a chromosomal nucleic acid sequence. [SO:ma]', 1197, 0, 0);
INSERT INTO chado.cvterm VALUES (1177, 23, 'gene_group_regulatory_region', 'A region that is involved in the regulation of transcription of a group of regulated genes. []', 1198, 1, 0);
INSERT INTO chado.cvterm VALUES (1178, 23, 'lambda_vector', 'The lambda bacteriophage is the vector for the linear lambda clone. The genes involved in the lysogenic pathway are removed from the from the viral DNA. Up to 25 kb of foreign DNA can then be inserted into the lambda genome. [ISBN:0-1767-2380-8]', 1199, 0, 0);
INSERT INTO chado.cvterm VALUES (1179, 23, 'plasmid_vector', 'A plasmid that has been generated to act as a vector for foreign sequence. []', 1200, 0, 0);
INSERT INTO chado.cvterm VALUES (1180, 23, 'single_stranded_cDNA', 'DNA synthesized from RNA by reverse transcriptase, single stranded. []', 1201, 0, 0);
INSERT INTO chado.cvterm VALUES (1181, 23, 'double_stranded_cDNA', 'DNA synthesized from RNA by reverse transcriptase that has been copied by PCR to make it double stranded. []', 1202, 0, 0);
INSERT INTO chado.cvterm VALUES (1182, 23, 'plasmid_clone', '', 1203, 1, 0);
INSERT INTO chado.cvterm VALUES (1183, 23, 'YAC_clone', '', 1204, 1, 0);
INSERT INTO chado.cvterm VALUES (1184, 23, 'phagemid_clone', '', 1205, 1, 0);
INSERT INTO chado.cvterm VALUES (1185, 23, 'PAC_clone', '', 1206, 1, 0);
INSERT INTO chado.cvterm VALUES (1186, 23, 'fosmid_clone', '', 1207, 1, 0);
INSERT INTO chado.cvterm VALUES (1187, 23, 'BAC_clone', '', 1208, 1, 0);
INSERT INTO chado.cvterm VALUES (1188, 23, 'cosmid_clone', '', 1209, 1, 0);
INSERT INTO chado.cvterm VALUES (1189, 23, 'pyrrolysyl_tRNA', 'A tRNA sequence that has a pyrrolysine anticodon, and a 3'' pyrrolysine binding region. [SO:ke]', 1210, 0, 0);
INSERT INTO chado.cvterm VALUES (1190, 23, 'pyrrolysine_tRNA_primary_transcript', 'A primary transcript encoding pyrrolysyl tRNA (SO:0000766). [RSC:cb]', 1211, 0, 0);
INSERT INTO chado.cvterm VALUES (1191, 23, 'clone_insert_start(SO:0000767)', '', 1212, 1, 0);
INSERT INTO chado.cvterm VALUES (1192, 23, 'episome', 'A plasmid that may integrate with a chromosome. [SO:ma]', 1213, 0, 0);
INSERT INTO chado.cvterm VALUES (1193, 23, 'tmRNA_coding_piece', 'The region of a two-piece tmRNA that bears the reading frame encoding the proteolysis tag. The tmRNA gene undergoes circular permutation in some groups of bacteria. Processing of the transcripts from such a gene leaves the mature tmRNA in two pieces, base-paired together. [doi:10.1093/nar/gkh795, Indiana:kw, issn:1362-4962]', 1214, 0, 0);
INSERT INTO chado.cvterm VALUES (1194, 23, 'tmRNA_region', 'A region of a tmRNA. [SO:cb]', 1215, 0, 0);
INSERT INTO chado.cvterm VALUES (1195, 23, 'tmRNA_acceptor_piece', 'The acceptor region of a two-piece tmRNA that when mature is charged at its 3'' end with alanine. The tmRNA gene undergoes circular permutation in some groups of bacteria; processing of the transcripts from such a gene leaves the mature tmRNA in two pieces, base-paired together. [doi:10.1093/nar/gkh795, Indiana:kw]', 1216, 0, 0);
INSERT INTO chado.cvterm VALUES (187, 23, 'QTL', 'A quantitative trait locus (QTL) is a polymorphic locus which contains alleles that differentially affect the expression of a continuously distributed phenotypic trait. Usually it is a marker described by statistical association to quantitative variation in the particular phenotypic trait that is thought to be controlled by the cumulative action of alleles at multiple loci. [http://rgd.mcw.edu/tu/qtls/]', 187, 0, 0);
INSERT INTO chado.cvterm VALUES (1196, 23, 'genomic_island', 'A genomic island is an integrated mobile genetic element, characterized by size (over 10 Kb). It that has features that suggest a foreign origin. These can include nucleotide distribution (oligonucleotides signature, CG content etc.) that differs from the bulk of the chromosome and/or genes suggesting DNA mobility. [Phigo:at, SO:ke]', 1217, 0, 0);
INSERT INTO chado.cvterm VALUES (1197, 23, 'pathogenic_island', 'Mobile genetic elements that contribute to rapid changes in virulence potential. They are present on the genomes of pathogenic strains but absent from the genomes of non pathogenic members of the same or related species. [SO:ke]', 1218, 0, 0);
INSERT INTO chado.cvterm VALUES (1198, 23, 'metabolic_island', 'A transmissible element containing genes involved in metabolism, analogous to the pathogenicity islands of gram negative bacteria. [SO:ke]', 1219, 0, 0);
INSERT INTO chado.cvterm VALUES (1199, 23, 'adaptive_island', 'An adaptive island is a genomic island that provides an adaptive advantage to the host. [SO:ke]', 1220, 0, 0);
INSERT INTO chado.cvterm VALUES (1200, 23, 'symbiosis_island', 'A transmissible element containing genes involved in symbiosis, analogous to the pathogenicity islands of gram negative bacteria. [SO:ke]', 1221, 0, 0);
INSERT INTO chado.cvterm VALUES (1201, 23, 'pseudogenic_rRNA', 'A non functional descendant of an rRNA. [SO:ke]', 1222, 0, 0);
INSERT INTO chado.cvterm VALUES (1202, 23, 'pseudogenic_tRNA', 'A non functional descendent of a tRNA. [SO:ke]', 1223, 0, 0);
INSERT INTO chado.cvterm VALUES (1203, 23, 'engineered_episome', 'An episome that is engineered. [SO:xp]', 1224, 0, 0);
INSERT INTO chado.cvterm VALUES (1204, 23, 'transposable_element_attribute', '', 1225, 1, 0);
INSERT INTO chado.cvterm VALUES (1205, 23, 'transgenic', 'Attribute describing sequence that has been integrated with foreign sequence. [SO:ke]', 1226, 0, 0);
INSERT INTO chado.cvterm VALUES (1206, 23, 'natural', 'An attribute describing a feature that occurs in nature. [SO:ke]', 1227, 0, 0);
INSERT INTO chado.cvterm VALUES (1207, 23, 'cloned_region', 'The region of sequence that has been inserted and is being propagated by the clone. []', 1228, 0, 0);
INSERT INTO chado.cvterm VALUES (1208, 23, 'reagent_attribute', '', 1229, 1, 0);
INSERT INTO chado.cvterm VALUES (1209, 23, 'clone_attribute', '', 1230, 1, 0);
INSERT INTO chado.cvterm VALUES (1210, 23, 'cloned', '', 1231, 1, 0);
INSERT INTO chado.cvterm VALUES (1211, 23, 'cloned_genomic', '', 1232, 1, 0);
INSERT INTO chado.cvterm VALUES (1212, 23, 'cloned_cDNA', '', 1233, 1, 0);
INSERT INTO chado.cvterm VALUES (1213, 23, 'engineered_DNA', '', 1234, 1, 0);
INSERT INTO chado.cvterm VALUES (1214, 23, 'engineered_rescue_region', 'A rescue region that is engineered. [SO:xp]', 1235, 0, 0);
INSERT INTO chado.cvterm VALUES (1215, 23, 'rescue_mini_gene', 'A mini_gene that rescues. [SO:xp]', 1236, 0, 0);
INSERT INTO chado.cvterm VALUES (1216, 23, 'mini_gene', 'By definition, minigenes are short open-reading frames (ORF), usually encoding approximately 9 to 20 amino acids, which are expressed in vivo (as distinct from being synthesized as peptide or protein ex vivo and subsequently injected). The in vivo synthesis confers a distinct advantage: the expressed sequences can enter both antigen presentation pathways, MHC I (inducing CD8+ T- cells, which are usually cytotoxic T-lymphocytes (CTL)) and MHC II (inducing CD4+ T-cells, usually ''T-helpers'' (Th)); and can encounter B-cells, inducing antibody responses. Three main vector approaches have been used to deliver minigenes: viral vectors, bacterial vectors and plasmid DNA. [PMID:15992143]', 1237, 0, 0);
INSERT INTO chado.cvterm VALUES (1217, 23, 'transgenic_transposable_element', 'TE that has been modified in vitro, including insertion of DNA derived from a source other than the originating TE. [FB:mc]', 1238, 0, 0);
INSERT INTO chado.cvterm VALUES (1218, 23, 'natural_transposable_element', 'TE that exists (or existed) in nature. [FB:mc]', 1239, 0, 0);
INSERT INTO chado.cvterm VALUES (1219, 23, 'extrachromosomal_mobile_genetic_element', 'An MGE that is not integrated into the host chromosome. [SO:ke]', 1240, 0, 0);
INSERT INTO chado.cvterm VALUES (1220, 23, 'engineered_transposable_element', 'TE that has been modified by manipulations in vitro. [FB:mc]', 1241, 0, 0);
INSERT INTO chado.cvterm VALUES (1221, 23, 'engineered_foreign_transposable_element', 'A transposable_element that is engineered and foreign. [FB:mc]', 1242, 0, 0);
INSERT INTO chado.cvterm VALUES (1222, 23, 'assortment_derived_duplication(SO:0000800)', 'A multi-chromosome duplication aberration generated by reassortment of other aberration components. [FB:gm]', 1243, 0, 0);
INSERT INTO chado.cvterm VALUES (1223, 23, 'assortment_derived_variation', 'A chromosome variation derived from an event during meiosis. [SO:ke]', 1244, 0, 0);
INSERT INTO chado.cvterm VALUES (1224, 23, 'assortment_derived_deficiency_plus_duplication(SO:0000801)', 'A multi-chromosome aberration generated by reassortment of other aberration components; presumed to have a deficiency and a duplication. [FB:gm]', 1245, 0, 0);
INSERT INTO chado.cvterm VALUES (1225, 23, 'assortment_derived_deficiency(SO:0000802)', 'A multi-chromosome deficiency aberration generated by reassortment of other aberration components. [FB:gm]', 1246, 0, 0);
INSERT INTO chado.cvterm VALUES (1226, 23, 'assortment_derived_aneuploid(SO:0000803)', 'A multi-chromosome aberration generated by reassortment of other aberration components; presumed to have a deficiency or a duplication. [FB:gm]', 1247, 0, 0);
INSERT INTO chado.cvterm VALUES (1227, 23, 'engineered_tag', 'A tag that is engineered. [SO:xp]', 1248, 0, 0);
INSERT INTO chado.cvterm VALUES (1228, 23, 'validated_cDNA_clone', 'A cDNA clone that has been validated. [SO:xp]', 1249, 0, 0);
INSERT INTO chado.cvterm VALUES (1229, 23, 'invalidated_cDNA_clone', 'A cDNA clone that is invalid. [SO:xp]', 1250, 0, 0);
INSERT INTO chado.cvterm VALUES (1230, 23, 'chimeric_cDNA_clone', 'A cDNA clone invalidated because it is chimeric. [SO:xp]', 1251, 0, 0);
INSERT INTO chado.cvterm VALUES (1231, 23, 'genomically_contaminated_cDNA_clone', 'A cDNA clone invalidated by genomic contamination. [SO:xp]', 1252, 0, 0);
INSERT INTO chado.cvterm VALUES (1232, 23, 'polyA_primed_cDNA_clone', 'A cDNA clone invalidated by polyA priming. [SO:xp]', 1253, 0, 0);
INSERT INTO chado.cvterm VALUES (1233, 23, 'partially_processed_cDNA_clone', 'A cDNA invalidated clone by partial processing. [SO:xp]', 1254, 0, 0);
INSERT INTO chado.cvterm VALUES (1234, 23, 'rescue_gene', 'A gene that rescues. [SO:xp]', 1255, 0, 0);
INSERT INTO chado.cvterm VALUES (1235, 23, 'wild_type', 'An attribute describing sequence with the genotype found in nature and/or standard laboratory stock. [SO:ke]', 1256, 0, 0);
INSERT INTO chado.cvterm VALUES (1236, 23, 'wild_type_rescue_gene', 'A gene that rescues. [SO:xp]', 1258, 0, 0);
INSERT INTO chado.cvterm VALUES (1237, 23, 'mitochondrial_chromosome', 'A chromosome originating in a mitochondria. [SO:xp]', 1259, 0, 0);
INSERT INTO chado.cvterm VALUES (1238, 23, 'chloroplast_chromosome', 'A chromosome originating in a chloroplast. [SO:xp]', 1260, 0, 0);
INSERT INTO chado.cvterm VALUES (1239, 23, 'chromoplast_chromosome', 'A chromosome originating in a chromoplast. [SO:xp]', 1261, 0, 0);
INSERT INTO chado.cvterm VALUES (1240, 23, 'cyanelle_chromosome', 'A chromosome originating in a cyanelle. [SO:xp]', 1262, 0, 0);
INSERT INTO chado.cvterm VALUES (1241, 23, 'leucoplast_chromosome', 'A chromosome with origin in a leucoplast. [SO:xp]', 1263, 0, 0);
INSERT INTO chado.cvterm VALUES (1242, 23, 'macronuclear_chromosome', 'A chromosome originating in a macronucleus. [SO:xp]', 1264, 0, 0);
INSERT INTO chado.cvterm VALUES (1243, 23, 'micronuclear_chromosome', 'A chromosome originating in a micronucleus. [SO:xp]', 1265, 0, 0);
INSERT INTO chado.cvterm VALUES (1244, 23, 'nuclear_chromosome', 'A chromosome originating in a nucleus. [SO:xp]', 1266, 0, 0);
INSERT INTO chado.cvterm VALUES (1245, 23, 'nucleomorphic_chromosome', 'A chromosome originating in a nucleomorph. [SO:xp]', 1267, 0, 0);
INSERT INTO chado.cvterm VALUES (1246, 23, 'promoter_region', 'A region of sequence which is part of a promoter. [SO:ke]', 1268, 1, 0);
INSERT INTO chado.cvterm VALUES (1251, 23, 'RNApol_III_promoter_type_2_region', 'A region of sequence which is a promoter for RNA polymerase III type 2. [SO:ke]', 1275, 1, 0);
INSERT INTO chado.cvterm VALUES (1252, 23, 'exon_region', 'A region of an exon. [RSC:cb]', 1276, 0, 0);
INSERT INTO chado.cvterm VALUES (1253, 23, 'homologous_region', 'A region that is homologous to another region. [SO:ke]', 1277, 0, 0);
INSERT INTO chado.cvterm VALUES (1254, 23, 'homologous', 'Similarity due to common ancestry. [SO:ke]', 1278, 0, 0);
INSERT INTO chado.cvterm VALUES (1255, 23, 'paralogous_region', 'A homologous_region that is paralogous to another region. [SO:ke]', 1279, 0, 0);
INSERT INTO chado.cvterm VALUES (1256, 23, 'paralogous', 'An attribute describing a kind of homology where divergence occurred after a duplication event. [SO:ke]', 1280, 0, 0);
INSERT INTO chado.cvterm VALUES (1257, 23, 'orthologous_region', 'A homologous_region that is orthologous to another region. [SO:ke]', 1281, 0, 0);
INSERT INTO chado.cvterm VALUES (1258, 23, 'orthologous', 'An attribute describing a kind of homology where divergence occurred after a speciation event. [SO:ke]', 1282, 0, 0);
INSERT INTO chado.cvterm VALUES (1259, 23, 'conserved', 'A region that is similar or identical across more than one species. []', 1283, 0, 0);
INSERT INTO chado.cvterm VALUES (1260, 23, 'syntenic', 'Attribute describing sequence regions occurring in same order on chromosome of different species. [SO:ke]', 1284, 0, 0);
INSERT INTO chado.cvterm VALUES (1261, 23, 'capped_primary_transcript', 'A primary transcript that is capped. [SO:xp]', 1285, 0, 0);
INSERT INTO chado.cvterm VALUES (1262, 23, 'capped_mRNA', 'An mRNA that is capped. [SO:xp]', 1286, 0, 0);
INSERT INTO chado.cvterm VALUES (1263, 23, 'trans_spliced_mRNA', 'An mRNA that is trans-spliced. [SO:xp]', 1287, 0, 0);
INSERT INTO chado.cvterm VALUES (1264, 23, 'anchor_binding_site', '', 1288, 0, 0);
INSERT INTO chado.cvterm VALUES (1265, 23, 'edited_transcript_by_A_to_I_substitution', 'A transcript that has been edited by A to I substitution. [SO:ke]', 1289, 0, 0);
INSERT INTO chado.cvterm VALUES (1266, 23, 'alternatively_spliced', 'An attribute describing a situation where a gene may encode for more than 1 transcript. [SO:ke]', 1290, 0, 0);
INSERT INTO chado.cvterm VALUES (1267, 23, 'codon_redefined', 'An attribute describing the alteration of codon meaning. [SO:ke]', 1291, 0, 0);
INSERT INTO chado.cvterm VALUES (1268, 23, 'maternally_imprinted_gene', 'A gene that is maternally_imprinted. [SO:xp]', 1292, 0, 0);
INSERT INTO chado.cvterm VALUES (1269, 23, 'paternally_imprinted_gene', 'A gene that is paternally imprinted. [SO:xp]', 1293, 0, 0);
INSERT INTO chado.cvterm VALUES (1270, 23, 'post_translationally_regulated_gene', 'A gene that is post translationally regulated. [SO:xp]', 1294, 0, 0);
INSERT INTO chado.cvterm VALUES (1271, 23, 'negatively_autoregulated_gene', 'A gene that is negatively autoreguated. [SO:xp]', 1295, 0, 0);
INSERT INTO chado.cvterm VALUES (1272, 23, 'positively_autoregulated_gene', 'A gene that is positively autoregulated. [SO:xp]', 1296, 0, 0);
INSERT INTO chado.cvterm VALUES (1273, 23, 'translationally_regulated_gene', 'A gene that is translationally regulated. [SO:xp]', 1297, 0, 0);
INSERT INTO chado.cvterm VALUES (1274, 23, 'allelically_excluded_gene', 'A gene that is allelically_excluded. [SO:xp]', 1298, 0, 0);
INSERT INTO chado.cvterm VALUES (1275, 23, 'nuclear_mitochondrial', 'An attribute describing a nuclear pseudogene of a mitochndrial gene. [SO:ke]', 1299, 1, 0);
INSERT INTO chado.cvterm VALUES (1276, 23, 'processed', 'An attribute describing a pseudogene where by an mRNA was retrotransposed. The mRNA sequence is transcribed back into the genome, lacking introns and promotors, but often including a polyA tail. [SO:ke]', 1300, 1, 0);
INSERT INTO chado.cvterm VALUES (1277, 23, 'unequally_crossed_over', 'An attribute describing a pseudogene that was created by tandem duplication and unequal crossing over during recombination. [SO:ke]', 1301, 1, 0);
INSERT INTO chado.cvterm VALUES (1278, 23, 'independently_known', 'Attribute to describe a feature that is independently known - not predicted. [SO:ke]', 1302, 0, 0);
INSERT INTO chado.cvterm VALUES (1279, 23, 'supported_by_sequence_similarity', 'An attribute to describe a feature that has been predicted using sequence similarity techniques. [SO:ke]', 1303, 0, 0);
INSERT INTO chado.cvterm VALUES (1280, 23, 'supported_by_domain_match', 'An attribute to describe a feature that has been predicted using sequence similarity of a known domain. [SO:ke]', 1304, 0, 0);
INSERT INTO chado.cvterm VALUES (1281, 23, 'supported_by_EST_or_cDNA', 'An attribute to describe a feature that has been predicted using sequence similarity to EST or cDNA data. [SO:ke]', 1305, 0, 0);
INSERT INTO chado.cvterm VALUES (1282, 23, 'orphan', 'A gene whose predicted amino acid sequence is unsupported by any experimental evidence or by any match with any other known sequence. []', 1306, 0, 0);
INSERT INTO chado.cvterm VALUES (1283, 23, 'predicted_by_ab_initio_computation', 'An attribute describing a feature that is predicted by a computer program that did not rely on sequence similarity. [SO:ke]', 1307, 0, 0);
INSERT INTO chado.cvterm VALUES (1284, 23, 'asx_turn', 'A motif of three consecutive residues and one H-bond in which: residue(i) is Aspartate or Asparagine (Asx), the side-chain O of residue(i) is H-bonded to the main-chain NH of residue(i+2). [http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1308, 0, 0);
INSERT INTO chado.cvterm VALUES (1285, 23, 'polypeptide_turn_motif', 'A reversal in the direction of the backbone of a protein that is stabilized by hydrogen bond between backbone NH and CO groups, involving no more than 4 amino acid residues. [EBIBS:GAR, uniprot:feature_type]', 1310, 0, 0);
INSERT INTO chado.cvterm VALUES (1286, 23, 'cloned_cDNA_insert', 'A clone insert made from cDNA. [SO:xp]', 1311, 0, 0);
INSERT INTO chado.cvterm VALUES (1287, 23, 'cloned_genomic_insert', 'A clone insert made from genomic DNA. [SO:xp]', 1312, 0, 0);
INSERT INTO chado.cvterm VALUES (1288, 23, 'engineered_insert', 'A clone insert that is engineered. [SO:xp]', 1313, 0, 0);
INSERT INTO chado.cvterm VALUES (1289, 23, 'edit_operation', '', 1314, 1, 0);
INSERT INTO chado.cvterm VALUES (1290, 23, 'insert_U', 'An edit to insert a U. [SO:ke]', 1315, 1, 0);
INSERT INTO chado.cvterm VALUES (1291, 23, 'delete_U', 'An edit to delete a uridine. [SO:ke]', 1316, 1, 0);
INSERT INTO chado.cvterm VALUES (1292, 23, 'substitute_A_to_I', 'An edit to substitute an I for an A. [SO:ke]', 1317, 1, 0);
INSERT INTO chado.cvterm VALUES (1293, 23, 'insert_C', 'An edit to insert a cytidine. [SO:ke]', 1318, 1, 0);
INSERT INTO chado.cvterm VALUES (1294, 23, 'insert_dinucleotide', 'An edit to insert a dinucleotide. [SO:ke]', 1319, 1, 0);
INSERT INTO chado.cvterm VALUES (1295, 23, 'substitute_C_to_U', 'An edit to substitute an U for a C. [SO:ke]', 1320, 1, 0);
INSERT INTO chado.cvterm VALUES (1296, 23, 'insert_G', 'An edit to insert a G. [SO:ke]', 1321, 1, 0);
INSERT INTO chado.cvterm VALUES (1297, 23, 'insert_GC', 'An edit to insert a GC dinucleotide. [SO:ke]', 1322, 1, 0);
INSERT INTO chado.cvterm VALUES (1298, 23, 'insert_GU', 'An edit to insert a GU dinucleotide. [SO:ke]', 1323, 1, 0);
INSERT INTO chado.cvterm VALUES (1299, 23, 'insert_CU', 'An edit to insert a CU dinucleotide. [SO:ke]', 1324, 1, 0);
INSERT INTO chado.cvterm VALUES (1300, 23, 'insert_AU', 'An edit to insert a AU dinucleotide. [SO:ke]', 1325, 1, 0);
INSERT INTO chado.cvterm VALUES (1301, 23, 'insert_AA', 'An edit to insert a AA dinucleotide. [SO:ke]', 1326, 1, 0);
INSERT INTO chado.cvterm VALUES (1302, 23, 'edited_mRNA', 'An mRNA that is edited. [SO:xp]', 1327, 0, 0);
INSERT INTO chado.cvterm VALUES (1303, 23, 'guide_RNA_region', 'A region of guide RNA. [SO:ma]', 1328, 0, 0);
INSERT INTO chado.cvterm VALUES (1304, 23, 'anchor_region', 'A region of a guide_RNA that base-pairs to a target mRNA. [SO:jk]', 1329, 0, 0);
INSERT INTO chado.cvterm VALUES (1305, 23, 'pre_edited_mRNA', 'A primary transcript that, at least in part, encodes one or more proteins that has not been edited. []', 1330, 0, 0);
INSERT INTO chado.cvterm VALUES (1306, 23, 'intermediate', 'An attribute to describe a feature between stages of processing. [SO:ke]', 1331, 0, 0);
INSERT INTO chado.cvterm VALUES (1307, 23, 'miRNA_target_site', 'A miRNA target site is a binding site where the molecule is a micro RNA. [FB:cds]', 1332, 0, 0);
INSERT INTO chado.cvterm VALUES (1308, 23, 'nucleotide_binding_site', 'A binding site that, in the molecule, interacts selectively and non-covalently with nucleotide residues. [SO:cb]', 1333, 0, 0);
INSERT INTO chado.cvterm VALUES (1309, 23, 'edited_CDS', 'A CDS that is edited. [SO:xp]', 1334, 0, 0);
INSERT INTO chado.cvterm VALUES (1310, 23, 'vertebrate_immune_system_feature', '', 1335, 1, 0);
INSERT INTO chado.cvterm VALUES (1311, 23, 'recombinationally_rearranged_vertebrate_immune_system_gene', 'A recombinationally rearranged gene of the vertebrate immune system. [SO:xp]', 1336, 0, 0);
INSERT INTO chado.cvterm VALUES (1312, 23, 'attP_site', 'An integration/excision site of a phage chromosome at which a recombinase acts to insert the phage DNA at a cognate integration/excision site on a bacterial chromosome. [SO:as]', 1337, 0, 0);
INSERT INTO chado.cvterm VALUES (1313, 23, 'phage_sequence', 'The nucleotide sequence of a virus that infects bacteria. [SO:ke]', 1338, 0, 0);
INSERT INTO chado.cvterm VALUES (1314, 23, 'attB_site', 'An integration/excision site of a bacterial chromosome at which a recombinase acts to insert foreign DNA containing a cognate integration/excision site. [SO:as]', 1339, 0, 0);
INSERT INTO chado.cvterm VALUES (1315, 23, 'attL_site', 'A region that results from recombination between attP_site and attB_site, composed of the 5'' portion of attB_site and the 3'' portion of attP_site. [SO:as]', 1340, 0, 0);
INSERT INTO chado.cvterm VALUES (1316, 23, 'attR_site', 'A region that results from recombination between attP_site and attB_site, composed of the 5'' portion of attP_site and the 3'' portion of attB_site. [SO:as]', 1341, 0, 0);
INSERT INTO chado.cvterm VALUES (1317, 23, 'dif_site', 'A site at which replicated bacterial circular chromosomes are decatenated by site specific resolvase. [SO:as]', 1342, 0, 0);
INSERT INTO chado.cvterm VALUES (1318, 23, 'attC_site', 'An attC site is a sequence required for the integration of a DNA of an integron. [SO:as]', 1343, 0, 0);
INSERT INTO chado.cvterm VALUES (1319, 23, 'oriV', 'An origin of vegetative replication in plasmids and phages. [SO:as]', 1344, 0, 0);
INSERT INTO chado.cvterm VALUES (1320, 23, 'oriC', 'An origin of bacterial chromosome replication. [SO:as]', 1345, 0, 0);
INSERT INTO chado.cvterm VALUES (1321, 23, 'DNA_chromosome', 'Structural unit composed of a self-replicating, DNA molecule. [SO:ma]', 1346, 0, 0);
INSERT INTO chado.cvterm VALUES (1322, 23, 'double_stranded_DNA_chromosome', 'Structural unit composed of a self-replicating, double-stranded DNA molecule. [SO:ma]', 1347, 0, 0);
INSERT INTO chado.cvterm VALUES (1323, 23, 'double', 'When a nucleotide polymer has two strands that are reverse-complement to one another and pair together. []', 1348, 0, 0);
INSERT INTO chado.cvterm VALUES (1324, 23, 'single_stranded_DNA_chromosome', 'Structural unit composed of a self-replicating, single-stranded DNA molecule. [SO:ma]', 1349, 0, 0);
INSERT INTO chado.cvterm VALUES (1325, 23, 'single', 'When a nucleotide polymer has only one strand. []', 1350, 0, 0);
INSERT INTO chado.cvterm VALUES (1326, 23, 'linear_double_stranded_DNA_chromosome', 'Structural unit composed of a self-replicating, double-stranded, linear DNA molecule. [SO:ma]', 1351, 0, 0);
INSERT INTO chado.cvterm VALUES (1327, 23, 'linear', 'A quality of a nucleotide polymer that has a 3''-terminal residue and a 5''-terminal residue. [SO:cb]', 1352, 0, 0);
INSERT INTO chado.cvterm VALUES (1328, 23, 'circular_double_stranded_DNA_chromosome', 'Structural unit composed of a self-replicating, double-stranded, circular DNA molecule. [SO:ma]', 1353, 0, 0);
INSERT INTO chado.cvterm VALUES (1329, 23, 'circular', 'A quality of a nucleotide polymer that has no terminal nucleotide residues. [SO:cb]', 1354, 0, 0);
INSERT INTO chado.cvterm VALUES (1330, 23, 'linear_single_stranded_DNA_chromosome', 'Structural unit composed of a self-replicating, single-stranded, linear DNA molecule. [SO:ma]', 1355, 0, 0);
INSERT INTO chado.cvterm VALUES (1331, 23, 'circular_single_stranded_DNA_chromosome', 'Structural unit composed of a self-replicating, single-stranded, circular DNA molecule. [SO:ma]', 1356, 0, 0);
INSERT INTO chado.cvterm VALUES (1332, 23, 'RNA_chromosome', 'Structural unit composed of a self-replicating, RNA molecule. [SO:ma]', 1357, 0, 0);
INSERT INTO chado.cvterm VALUES (1333, 23, 'single_stranded_RNA_chromosome', 'Structural unit composed of a self-replicating, single-stranded RNA molecule. [SO:ma]', 1358, 0, 0);
INSERT INTO chado.cvterm VALUES (1334, 23, 'linear_single_stranded_RNA_chromosome', 'Structural unit composed of a self-replicating, single-stranded, linear RNA molecule. [SO:ma]', 1359, 0, 0);
INSERT INTO chado.cvterm VALUES (1335, 23, 'linear_double_stranded_RNA_chromosome', 'Structural unit composed of a self-replicating, double-stranded, linear RNA molecule. [SO:ma]', 1360, 0, 0);
INSERT INTO chado.cvterm VALUES (1336, 23, 'double_stranded_RNA_chromosome', 'Structural unit composed of a self-replicating, double-stranded RNA molecule. [SO:ma]', 1361, 0, 0);
INSERT INTO chado.cvterm VALUES (1337, 23, 'circular_single_stranded_RNA_chromosome', 'Structural unit composed of a self-replicating, single-stranded, circular DNA molecule. [SO:ma]', 1362, 0, 0);
INSERT INTO chado.cvterm VALUES (1338, 23, 'circular_double_stranded_RNA_chromosome', 'Structural unit composed of a self-replicating, double-stranded, circular RNA molecule. [SO:ma]', 1363, 0, 0);
INSERT INTO chado.cvterm VALUES (1339, 23, 'sequence_replication_mode', '', 1364, 1, 0);
INSERT INTO chado.cvterm VALUES (1340, 23, 'rolling_circle', '', 1365, 1, 0);
INSERT INTO chado.cvterm VALUES (1341, 23, 'theta_replication', '', 1366, 1, 0);
INSERT INTO chado.cvterm VALUES (1342, 23, 'DNA_replication_mode', '', 1367, 1, 0);
INSERT INTO chado.cvterm VALUES (1343, 23, 'RNA_replication_mode', '', 1368, 1, 0);
INSERT INTO chado.cvterm VALUES (1344, 23, 'insertion_sequence', 'A terminal_inverted_repeat_element that is bacterial and only encodes the functions required for its transposition between these inverted repeats. [SO:as]', 1369, 0, 0);
INSERT INTO chado.cvterm VALUES (1345, 23, 'minicircle_gene', 'A gene found within a minicircle. []', 1370, 0, 0);
INSERT INTO chado.cvterm VALUES (1346, 23, 'cryptic', 'A feature_attribute describing a feature that is not manifest under normal conditions. [SO:ke]', 1371, 0, 0);
INSERT INTO chado.cvterm VALUES (1347, 23, 'template_region', 'A region of a guide_RNA that specifies the insertions and deletions of bases in the editing of a target mRNA. [SO:jk]', 1372, 0, 0);
INSERT INTO chado.cvterm VALUES (1348, 23, 'gRNA_encoding', 'A non-protein_coding gene that encodes a guide_RNA. [SO:ma]', 1373, 0, 0);
INSERT INTO chado.cvterm VALUES (1349, 23, 'rho_dependent_bacterial_terminator', 'A transcription terminator that is dependent upon Rho. []', 1375, 0, 0);
INSERT INTO chado.cvterm VALUES (1350, 23, 'rho_independent_bacterial_terminator', 'A transcription terminator that is not dependent upon Rho. Rather, the mRNA contains a sequence that allows it to base-pair with itself and make a stem-loop structure. []', 1376, 0, 0);
INSERT INTO chado.cvterm VALUES (1351, 23, 'strand_attribute', 'The attribute of how many strands are present in a nucleotide polymer. []', 1377, 0, 0);
INSERT INTO chado.cvterm VALUES (1352, 23, 'topology_attribute', 'The attribute of whether a nucleotide polymer is linear or circular. []', 1378, 0, 0);
INSERT INTO chado.cvterm VALUES (1353, 23, 'class_II_RNA', 'Small non-coding RNA (59-60 nt long) containing 5'' and 3'' ends that are predicted to come together to form a stem structure. Identified in the social amoeba Dictyostelium discoideum and localized in the cytoplasm. [PMID:15333696]', 1379, 0, 0);
INSERT INTO chado.cvterm VALUES (1354, 23, 'class_I_RNA', 'Small non-coding RNA (55-65 nt long) containing highly conserved 5'' and 3'' ends (16 and 8 nt, respectively) that are predicted to come together to form a stem structure. Identified in the social amoeba Dictyostelium discoideum and localized in the cytoplasm. [PMID:15333696]', 1380, 0, 0);
INSERT INTO chado.cvterm VALUES (1355, 23, 'BAC_cloned_genomic_insert', 'A region of DNA that has been inserted into the bacterial genome using a bacterial artificial chromosome. []', 1381, 0, 0);
INSERT INTO chado.cvterm VALUES (1356, 23, 'consensus', 'A sequence produced from an aligment algorithm that uses multiple sequences as input. []', 1382, 0, 0);
INSERT INTO chado.cvterm VALUES (1357, 23, 'consensus_region', 'A region that has a known consensus sequence. []', 1383, 0, 0);
INSERT INTO chado.cvterm VALUES (1358, 23, 'consensus_mRNA', 'An mRNA sequence produced from an aligment algorithm that uses multiple sequences as input. []', 1384, 0, 0);
INSERT INTO chado.cvterm VALUES (1359, 23, 'predicted_gene', 'A region of the genome that has been predicted to be a gene but has not been confirmed by laboratory experiments. []', 1385, 0, 0);
INSERT INTO chado.cvterm VALUES (1360, 23, 'gene_fragment', 'A portion of a gene that is not the complete gene. []', 1386, 0, 0);
INSERT INTO chado.cvterm VALUES (1361, 23, 'recursive_splice_site', 'A recursive splice site is a splice site which subdivides a large intron. Recursive splicing is a mechanism that splices large introns by sub dividing the intron at non exonic elements and alternate exons. [http://www.genetics.org/cgi/content/full/170/2/661]', 1387, 0, 0);
INSERT INTO chado.cvterm VALUES (1362, 23, 'BAC_end', 'A region of sequence from the end of a BAC clone that may provide a highly specific marker. [SO:ke]', 1388, 0, 0);
INSERT INTO chado.cvterm VALUES (1363, 23, 'cytosolic_16S_rRNA', 'Cytosolic 16S rRNA is an RNA component of the small subunit of cytosolic ribosomes in prokaryotes. [SO:ke]', 1389, 0, 0);
INSERT INTO chado.cvterm VALUES (1364, 23, 'cytosolic_rRNA_16S_gene', 'A gene which codes for 16S_rRNA, which functions as the small subunit of the ribosome in prokaryotes. []', 1390, 0, 0);
INSERT INTO chado.cvterm VALUES (1365, 23, 'cytosolic_23S_rRNA', 'Cytosolic 23S rRNA is an RNA component of the large subunit of cytosolic ribosomes in prokaryotes. [SO:ke]', 1391, 0, 0);
INSERT INTO chado.cvterm VALUES (1366, 23, 'cytosolic_rRNA_23S_gene', 'A gene which codes for 23S_rRNA, which functions as a component of the large subunit of the ribosome in prokaryotes. []', 1392, 0, 0);
INSERT INTO chado.cvterm VALUES (1367, 23, 'cytosolic_25S_rRNA', 'Cytosolic 25S rRNA is an RNA component of the large subunit of cytosolic ribosomes most eukaryotes. [PMID:15493135, PMID:2100998, RSC:cb]', 1393, 0, 0);
INSERT INTO chado.cvterm VALUES (1368, 23, 'cytosolic_rRNA_25S_gene', 'A gene which codes for 25S_rRNA, which functions as a component of the large subunit of the ribosome in some eukaryotes. []', 1394, 0, 0);
INSERT INTO chado.cvterm VALUES (1369, 23, 'solo_LTR', 'A recombination product between the 2 LTR of the same element. [SO:ke]', 1395, 0, 0);
INSERT INTO chado.cvterm VALUES (1370, 23, 'low_complexity', 'When a sequence does not contain an equal distribution of all four possible nucleotide bases or does not contain all nucleotide bases. []', 1396, 0, 0);
INSERT INTO chado.cvterm VALUES (1371, 23, 'low_complexity_region', 'A region where the DNA does not contain an equal distrubution of all four possible nucleotides or does not contain all four nucleotides. []', 1397, 0, 0);
INSERT INTO chado.cvterm VALUES (1372, 23, 'prophage', 'A phage genome after it has established in the host genome in a latent/immune state either as a plasmid or as an integrated \"island\". [GOC:jl]', 1398, 0, 0);
INSERT INTO chado.cvterm VALUES (1373, 23, 'cryptic_prophage', 'A remnant of an integrated prophage in the host genome or an \"island\" in the host genome that includes phage like-genes. [GOC:jl]', 1399, 0, 0);
INSERT INTO chado.cvterm VALUES (1374, 23, 'tetraloop', 'A base-paired stem with loop of 4 non-hydrogen bonded nucleotides. [SO:ke]', 1400, 0, 0);
INSERT INTO chado.cvterm VALUES (1375, 23, 'DNA_constraint_sequence', 'A double-stranded DNA used to control macromolecular structure and function. [http:/www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=search&db=pubmed&term=SILVERMAN+SK[au\]&dispmax=50]', 1401, 0, 0);
INSERT INTO chado.cvterm VALUES (1376, 23, 'i_motif', 'A cytosine rich domain whereby strands associate both inter- and intramolecularly at moderately acidic pH. [PMID:9753739]', 1402, 0, 0);
INSERT INTO chado.cvterm VALUES (1377, 23, 'PNA_oligo', 'Peptide nucleic acid, is a chemical not known to occur naturally but is artificially synthesized and used in some biological research and medical treatments. The PNA backbone is composed of repeating N-(2-aminoethyl)-glycine units linked by peptide bonds. The purine and pyrimidine bases are linked to the backbone by methylene carbonyl bonds. [SO:ke]', 1403, 0, 0);
INSERT INTO chado.cvterm VALUES (1378, 23, 'PNA', 'An attribute describing a sequence composed of peptide nucleic acid (CHEBI:48021), a chemical consisting of nucleobases bound to a backbone composed of repeating N-(2-aminoethyl)-glycine units linked by peptide bonds. The purine and pyrimidine bases are linked to the backbone by methylene carbonyl bonds. [RSC:cb]', 1404, 0, 0);
INSERT INTO chado.cvterm VALUES (1379, 23, 'DNAzyme', 'A DNA sequence with catalytic activity. [SO:cb]', 1405, 0, 0);
INSERT INTO chado.cvterm VALUES (1380, 23, 'MNP', 'A multiple nucleotide polymorphism with alleles of common length > 1, for example AAA/TTT. [http://www.ncbi.nlm.nih.gov/SNP/snp_ref.cgi?rs=rs2067431]', 1406, 0, 0);
INSERT INTO chado.cvterm VALUES (1381, 23, 'MNV', 'An MNV is a multiple nucleotide variant (substitution) in which the inserted sequence is the same length as the replaced sequence. [NCBI:th]', 1407, 0, 0);
INSERT INTO chado.cvterm VALUES (1382, 23, 'intron_domain', 'An intronic region that has an attribute. []', 1408, 0, 0);
INSERT INTO chado.cvterm VALUES (1383, 23, 'wobble_base_pair', 'A type of non-canonical base pairing, most commonly between G and U, which is important for the secondary structure of RNAs. It has similar thermodynamic stability to the Watson-Crick pairing. Wobble base pairs only have two hydrogen bonds. Other wobble base pair possibilities are I-A, I-U and I-C. [PMID:11256617]', 1409, 0, 0);
INSERT INTO chado.cvterm VALUES (1384, 23, 'internal_guide_sequence', 'A purine-rich sequence in the group I introns which determines the locations of the splice sites in group I intron splicing and has catalytic activity. [SO:cb]', 1410, 0, 0);
INSERT INTO chado.cvterm VALUES (1385, 23, 'silent_mutation', 'A sequence variant that does not affect protein function. Silent mutations may occur in genic ( CDS, UTR, intron etc) and intergenic regions. Silent mutations may have affects on processes such as splicing and regulation. [SO:ke]', 1411, 0, 0);
INSERT INTO chado.cvterm VALUES (1386, 23, 'feature_variant', 'A sequence variant that falls entirely or partially within a genomic feature. [EBI:fc, SO:ke]', 1413, 0, 0);
INSERT INTO chado.cvterm VALUES (1387, 23, 'epitope', 'A binding site that, in the molecule, interacts selectively and non-covalently with antibodies, B cells or T cells. [http://en.wikipedia.org/wiki/Epitope, SO:cb]', 1414, 0, 0);
INSERT INTO chado.cvterm VALUES (1388, 23, 'copy_number_variation', 'A variation that increases or decreases the copy number of a given region. [SO:ke]', 1415, 0, 0);
INSERT INTO chado.cvterm VALUES (1390, 23, 'chromosome_breakpoint', 'A chromosomal region that may sustain a double-strand break, resulting in a recombination event. []', 1417, 0, 0);
INSERT INTO chado.cvterm VALUES (1391, 23, 'inversion_breakpoint', 'The point within a chromosome where an inversion begins or ends. [SO:cb]', 1419, 0, 0);
INSERT INTO chado.cvterm VALUES (1392, 23, 'allele', 'An allele is one of a set of coexisting sequence variants of a gene. [SO:immuno_workshop]', 1420, 0, 0);
INSERT INTO chado.cvterm VALUES (1393, 23, 'haplotype', 'A haplotype is one of a set of coexisting sequence variants of a haplotype block. [SO:immuno_workshop]', 1421, 0, 0);
INSERT INTO chado.cvterm VALUES (1394, 23, 'polymorphic_sequence_variant', 'A sequence variant that is segregating in one or more natural populations of a species. [SO:immuno_workshop]', 1422, 0, 0);
INSERT INTO chado.cvterm VALUES (1395, 23, 'sequence_collection', 'A collection of discontinuous sequences. [SO:ke]', 1423, 0, 0);
INSERT INTO chado.cvterm VALUES (1396, 23, 'genotype', 'A genotype is a variant genome, complete or incomplete. [SO:immuno_workshop]', 1424, 0, 0);
INSERT INTO chado.cvterm VALUES (1397, 23, 'diplotype', 'A diplotype is a pair of haplotypes from a given individual. It is a genotype where the phase is known. [SO:immuno_workshop]', 1425, 0, 0);
INSERT INTO chado.cvterm VALUES (1398, 23, 'direction_attribute', 'The attribute of whether the sequence is the same direction as a feature (forward) or the opposite direction as a feature (reverse). []', 1426, 0, 0);
INSERT INTO chado.cvterm VALUES (1399, 23, 'mitochondrial_DNA', 'DNA belonging to the genome of a mitochondria. []', 1427, 0, 0);
INSERT INTO chado.cvterm VALUES (1400, 23, 'chloroplast_DNA', 'DNA belonging to the genome of a chloroplast, a photosynthetic plastid. []', 1428, 0, 0);
INSERT INTO chado.cvterm VALUES (1401, 23, 'miRtron', 'A de-branched intron which mimics the structure of pre-miRNA and enters the miRNA processing pathway without Drosha mediated cleavage. [PMID:17589500, SO:ma]', 1429, 0, 0);
INSERT INTO chado.cvterm VALUES (1402, 23, 'arginyl_tRNA', 'A tRNA sequence that has an arginine anticodon, and a 3'' arginine binding region. [SO:ke]', 1430, 0, 0);
INSERT INTO chado.cvterm VALUES (1403, 23, 'integrated_plasmid', 'A plasmid sequence that is integrated within the host chromosome. [SO:ke]', 1431, 0, 0);
INSERT INTO chado.cvterm VALUES (1404, 23, 'viral_sequence', 'The region of nucleotide sequence of a virus, a submicroscopic particle that replicates by infecting a host cell. [SO:ke]', 1432, 0, 0);
INSERT INTO chado.cvterm VALUES (1405, 23, 'attCtn_site', 'An attachment site located on a conjugative transposon and used for site-specific integration of a conjugative transposon. [Phigo:at]', 1433, 0, 0);
INSERT INTO chado.cvterm VALUES (1406, 23, 'nuclear_mt_pseudogene', 'A nuclear pseudogene of either coding or non-coding mitochondria derived sequence. [SO:xp]', 1434, 0, 0);
INSERT INTO chado.cvterm VALUES (1407, 23, 'cointegrated_plasmid', 'A MGE region consisting of two fused plasmids resulting from a replicative transposition event. [phigo:at]', 1435, 0, 0);
INSERT INTO chado.cvterm VALUES (1408, 23, 'IRLinv_site', 'Component of the inversion site located at the left of a region susceptible to site-specific inversion. [Phigo:at]', 1436, 0, 0);
INSERT INTO chado.cvterm VALUES (1409, 23, 'inversion_site_part', 'A region located within an inversion site. [SO:ke]', 1437, 0, 0);
INSERT INTO chado.cvterm VALUES (1410, 23, 'IRRinv_site', 'Component of the inversion site located at the right of a region susceptible to site-specific inversion. [Phigo:at]', 1438, 0, 0);
INSERT INTO chado.cvterm VALUES (1411, 23, 'defective_conjugative_transposon', 'An island that contains genes for integration/excision and the gene and site for the initiation of intercellular transfer by conjugation. It can be complemented for transfer by a conjugative transposon. [Phigo:ariane]', 1439, 0, 0);
INSERT INTO chado.cvterm VALUES (1412, 23, 'repeat_fragment', 'A portion of a repeat, interrupted by the insertion of another element. [SO:ke]', 1440, 0, 0);
INSERT INTO chado.cvterm VALUES (1413, 23, 'nested_repeat(SO:0001649)', 'A repeat that is disrupted by the insertion of another element. [SO:ke]', 1441, 0, 0);
INSERT INTO chado.cvterm VALUES (1414, 23, 'nested_region', '', 1442, 1, 0);
INSERT INTO chado.cvterm VALUES (1415, 23, 'nested_repeat', '', 1443, 1, 0);
INSERT INTO chado.cvterm VALUES (1416, 23, 'nested_transposon', '', 1444, 1, 0);
INSERT INTO chado.cvterm VALUES (1417, 23, 'transposon_fragment', 'A portion of a transposon, interrupted by the insertion of another element. [SO:ke]', 1445, 0, 0);
INSERT INTO chado.cvterm VALUES (1418, 23, 'nested_transposon(SO:0001648)', 'A transposon that is disrupted by the insertion of another element. [SO:ke]', 1446, 0, 0);
INSERT INTO chado.cvterm VALUES (1419, 23, 'regulatory_region', 'A region of sequence that is involved in the control of a biological process. [SO:ke]', 1447, 0, 0);
INSERT INTO chado.cvterm VALUES (1420, 23, 'enhanceosome', '', 1448, 1, 0);
INSERT INTO chado.cvterm VALUES (1421, 23, 'promoter_targeting_sequence', 'A transcriptional_cis_regulatory_region that restricts the activity of a CRM to a single promoter and which functions only when both itself and an insulator are located between the CRM and the promoter. [SO:regcreative]', 1449, 1, 0);
INSERT INTO chado.cvterm VALUES (1422, 23, 'sequence_comparison', 'A position or feature where two sequences have been compared. []', 1452, 0, 0);
INSERT INTO chado.cvterm VALUES (188, 23, 'sequence_variant', 'A sequence_variant is a non exact copy of a sequence_feature or genome exhibiting one or more sequence_alteration. [SO:ke]', 188, 0, 0);
INSERT INTO chado.cvterm VALUES (1423, 23, 'propeptide_cleavage_site', 'The propeptide_cleavage_site is the arginine/lysine boundary on a propeptide where cleavage occurs. [EBIBS:GAR]', 1453, 0, 0);
INSERT INTO chado.cvterm VALUES (1424, 23, 'propeptide_region_of_CDS', 'A CDS region corresponding to a propeptide of a polypeptide. []', 1456, 0, 0);
INSERT INTO chado.cvterm VALUES (1425, 23, 'active_peptide', 'Active peptides are proteins which are biologically active, released from a precursor molecule. [EBIBS:GAR, UniProt:curation_manual]', 1458, 0, 0);
INSERT INTO chado.cvterm VALUES (1426, 23, 'compositionally_biased_region_of_peptide', 'Polypeptide region that is rich in a particular amino acid or homopolymeric and greater than three residues in length. [EBIBS:GAR, UniProt:curation_manual]', 1460, 0, 0);
INSERT INTO chado.cvterm VALUES (1427, 23, 'polypeptide_motif', 'A sequence motif is a short (up to 20 amino acids) region of biological interest. Such motifs, although they are too short to constitute functional domains, share sequence similarities and are conserved in different proteins. They display a common function (protein-binding, subcellular location etc.). [EBIBS:GAR, UniProt:curation_manual]', 1462, 0, 0);
INSERT INTO chado.cvterm VALUES (1428, 23, 'polypeptide_repeat', 'A polypeptide_repeat is a single copy of an internal sequence repetition. [EBIBS:GAR]', 1464, 0, 0);
INSERT INTO chado.cvterm VALUES (1429, 23, 'membrane_structure', 'Arrangement of the polypeptide with respect to the lipid bilayer. [EBIBS:GAR]', 1467, 0, 0);
INSERT INTO chado.cvterm VALUES (1430, 23, 'extramembrane_polypeptide_region', 'Polypeptide region that is localized outside of a lipid bilayer. [EBIBS:GAR, SO:cb]', 1469, 0, 0);
INSERT INTO chado.cvterm VALUES (1431, 23, 'cytoplasmic_polypeptide_region', 'Polypeptide region that is localized inside the cytoplasm. [EBIBS:GAR, SO:cb]', 1471, 0, 0);
INSERT INTO chado.cvterm VALUES (1432, 23, 'non_cytoplasmic_polypeptide_region', 'Polypeptide region that is localized outside of a lipid bilayer and outside of the cytoplasm. [EBIBS:GAR, SO:cb]', 1473, 0, 0);
INSERT INTO chado.cvterm VALUES (2965, 25, 'contact_description', 'A description of the contact', 3272, 0, 0);
INSERT INTO chado.cvterm VALUES (1433, 23, 'intramembrane_polypeptide_region', 'Polypeptide region present in the lipid bilayer. [EBIBS:GAR]', 1475, 0, 0);
INSERT INTO chado.cvterm VALUES (1434, 23, 'membrane_peptide_loop', 'Polypeptide region localized within the lipid bilayer where both ends traverse the same membrane. [EBIBS:GAR, SO:cb]', 1477, 0, 0);
INSERT INTO chado.cvterm VALUES (1435, 23, 'transmembrane_polypeptide_region', 'Polypeptide region traversing the lipid bilayer. [EBIBS:GAR, UniProt:curator_manual]', 1479, 0, 0);
INSERT INTO chado.cvterm VALUES (1436, 23, 'polypeptide_secondary_structure', 'A region of peptide with secondary structure has hydrogen bonding along the peptide chain that causes a defined conformation of the chain. [EBIBS:GAR]', 1481, 0, 0);
INSERT INTO chado.cvterm VALUES (1437, 23, 'polypeptide_structural_motif', 'Motif is a three-dimensional structural element within the chain, which appears also in a variety of other molecules. Unlike a domain, a motif does not need to form a stable globular unit. [EBIBS:GAR]', 1483, 0, 0);
INSERT INTO chado.cvterm VALUES (1438, 23, 'coiled_coil', 'A coiled coil is a structural motif in proteins, in which alpha-helices are coiled together like the strands of a rope. [EBIBS:GAR, UniProt:curation_manual]', 1485, 0, 0);
INSERT INTO chado.cvterm VALUES (1439, 23, 'helix_turn_helix', 'A motif comprising two helices separated by a turn. [EBIBS:GAR]', 1487, 0, 0);
INSERT INTO chado.cvterm VALUES (1440, 23, 'peptide_helix', 'A helix is a secondary_structure conformation where the peptide backbone forms a coil. [EBIBS:GAR]', 1489, 0, 0);
INSERT INTO chado.cvterm VALUES (1441, 23, 'polypeptide_sequencing_information', 'Incompatibility in the sequence due to some experimental problem. [EBIBS:GAR]', 1490, 0, 0);
INSERT INTO chado.cvterm VALUES (1442, 23, 'non_adjacent_residues', 'Indicates that two consecutive residues in a fragment sequence are not consecutive in the full-length protein and that there are a number of unsequenced residues between them. [EBIBS:GAR, UniProt:curation_manual]', 1492, 0, 0);
INSERT INTO chado.cvterm VALUES (1443, 23, 'non_terminal_residue', 'The residue at an extremity of the sequence is not the terminal residue. [EBIBS:GAR, UniProt:curation_manual]', 1494, 0, 0);
INSERT INTO chado.cvterm VALUES (1444, 23, 'sequence_conflict', 'Different sources report differing sequences. [EBIBS:GAR, UniProt:curation_manual]', 1496, 0, 0);
INSERT INTO chado.cvterm VALUES (1445, 23, 'sequence_uncertainty', 'Describes the positions in a sequence where the authors are unsure about the sequence assignment. [EBIBS:GAR, UniProt:curation_manual]', 1498, 0, 0);
INSERT INTO chado.cvterm VALUES (1446, 23, 'cross_link', 'Posttranslationally formed amino acid bonds. [EBIBS:GAR, UniProt:curation_manual]', 1500, 1, 0);
INSERT INTO chado.cvterm VALUES (1447, 23, 'disulfide_bond', 'The covalent bond between sulfur atoms that binds two peptide chains or different parts of one peptide chain and is a structural determinant in many protein molecules. [EBIBS:GAR, UniProt:curation_manual]', 1502, 1, 0);
INSERT INTO chado.cvterm VALUES (1448, 23, 'post_translationally_modified_region', 'A region where a transformation occurs in a protein after it has been synthesized. This which may regulate, stabilize, crosslink or introduce new chemical functionalities in the protein. [EBIBS:GAR, UniProt:curation_manual]', 1504, 0, 0);
INSERT INTO chado.cvterm VALUES (1449, 23, 'biochemical_region_of_peptide', 'A region of a peptide that is involved in a biochemical function. [EBIBS:GAR]', 1506, 0, 0);
INSERT INTO chado.cvterm VALUES (1450, 23, 'covalent_binding_site', 'Binding involving a covalent bond. [EBIBS:GAR]', 1507, 1, 0);
INSERT INTO chado.cvterm VALUES (1451, 23, 'non_covalent_binding_site', 'Binding site for any chemical group (co-enzyme, prosthetic group, etc.). [EBIBS:GAR]', 1509, 1, 0);
INSERT INTO chado.cvterm VALUES (1452, 23, 'polypeptide_metal_contact', 'A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with metal ions. [EBIBS:GAR, SO:cb, UniProt:curation_manual]', 1511, 0, 0);
INSERT INTO chado.cvterm VALUES (1453, 23, 'metal_binding_site', 'A binding site that, in the molecule, interacts selectively and non-covalently with metal ions. [SO:cb]', 1513, 0, 0);
INSERT INTO chado.cvterm VALUES (1454, 23, 'molecular_contact_region', 'A region that is involved a contact with another molecule. [EBIBS:GAR]', 1514, 0, 0);
INSERT INTO chado.cvterm VALUES (1455, 23, 'protein_protein_contact', 'A binding site that, in the protein molecule, interacts selectively and non-covalently with polypeptide residues. [EBIBS:GAR, UniProt:Curation_manual]', 1515, 0, 0);
INSERT INTO chado.cvterm VALUES (1456, 23, 'polypeptide_calcium_ion_contact_site', 'A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with calcium ions. [EBIBS:GAR]', 1517, 0, 0);
INSERT INTO chado.cvterm VALUES (1457, 23, 'polypeptide_cobalt_ion_contact_site', 'A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with cobalt ions. [EBIBS:GAR, SO:cb]', 1519, 0, 0);
INSERT INTO chado.cvterm VALUES (1458, 23, 'polypeptide_copper_ion_contact_site', 'A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with copper ions. [EBIBS:GAR, SO:cb]', 1521, 0, 0);
INSERT INTO chado.cvterm VALUES (1459, 23, 'polypeptide_iron_ion_contact_site', 'A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with iron ions. [EBIBS:GAR, SO:cb]', 1523, 0, 0);
INSERT INTO chado.cvterm VALUES (1460, 23, 'polypeptide_magnesium_ion_contact_site', 'A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with magnesium ions. [EBIBS:GAR, SO:cb]', 1525, 0, 0);
INSERT INTO chado.cvterm VALUES (1461, 23, 'polypeptide_manganese_ion_contact_site', 'A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with manganese ions. [EBIBS:GAR, SO:cb]', 1527, 0, 0);
INSERT INTO chado.cvterm VALUES (1462, 23, 'polypeptide_molybdenum_ion_contact_site', 'A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with molybdenum ions. [EBIBS:GAR, SO:cb]', 1529, 0, 0);
INSERT INTO chado.cvterm VALUES (1463, 23, 'polypeptide_nickel_ion_contact_site', 'A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with nickel ions. [EBIBS:GAR]', 1531, 0, 0);
INSERT INTO chado.cvterm VALUES (1464, 23, 'polypeptide_tungsten_ion_contact_site', 'A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with tungsten ions. [EBIBS:GAR, SO:cb]', 1533, 0, 0);
INSERT INTO chado.cvterm VALUES (1465, 23, 'polypeptide_zinc_ion_contact_site', 'A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with zinc ions. [EBIBS:GAR, SO:cb]', 1535, 0, 0);
INSERT INTO chado.cvterm VALUES (1466, 23, 'catalytic_residue', 'Amino acid involved in the activity of an enzyme. [EBIBS:GAR, UniProt:curation_manual]', 1537, 0, 0);
INSERT INTO chado.cvterm VALUES (1467, 23, 'amino_acid', 'A sequence feature that corresponds to a single amino acid residue in a polypeptide. [RSC:cb]', 1539, 0, 0);
INSERT INTO chado.cvterm VALUES (1468, 23, 'polypeptide_catalytic_motif', 'A polypeptide catalytic motif is a short (up to 20 amino acids) polypeptide region that contains one or more active site residues. [EBIBS:GAR]', 1540, 0, 0);
INSERT INTO chado.cvterm VALUES (1469, 23, 'polypeptide_ligand_contact', 'Residues which interact with a ligand. [EBIBS:GAR]', 1541, 0, 0);
INSERT INTO chado.cvterm VALUES (1470, 23, 'ligand_binding_site', 'A binding site that, in the molecule, interacts selectively and non-covalently with a small molecule such as a drug, or hormone. [SO:ke]', 1543, 0, 0);
INSERT INTO chado.cvterm VALUES (2966, 26, 'is a', '', 3273, 0, 1);
INSERT INTO chado.cvterm VALUES (2967, 26, 'part of', '', 3274, 0, 1);
INSERT INTO chado.cvterm VALUES (1471, 23, 'asx_motif', 'A motif of five consecutive residues and two H-bonds in which: Residue(i) is Aspartate or Asparagine (Asx), side-chain O of residue(i) is H-bonded to the main-chain NH of residue(i+2) or (i+3), main-chain CO of residue(i) is H-bonded to the main-chain NH of residue(i+3) or (i+4). [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1544, 0, 0);
INSERT INTO chado.cvterm VALUES (1472, 23, 'beta_bulge', 'A motif of three residues within a beta-sheet in which the main chains of two consecutive residues are H-bonded to that of the third, and in which the dihedral angles are as follows: Residue(i): -140 degrees < phi(l) -20 degrees , -90 degrees < psi(l) < 40 degrees. Residue (i+1): -180 degrees < phi < -25 degrees or +120 degrees < phi < +180 degrees, +40 degrees < psi < +180 degrees or -180 degrees < psi < -120 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1546, 0, 0);
INSERT INTO chado.cvterm VALUES (1473, 23, 'beta_bulge_loop', 'A motif of three residues within a beta-sheet consisting of two H-bonds. Beta bulge loops often occur at the loop ends of beta-hairpins. [EBIBS:GAR, Http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1548, 0, 0);
INSERT INTO chado.cvterm VALUES (1474, 23, 'beta_bulge_loop_five', 'A motif of three residues within a beta-sheet consisting of two H-bonds in which: the main-chain NH of residue(i) is H-bonded to the main-chain CO of residue(i+4), the main-chain CO of residue i is H-bonded to the main-chain NH of residue(i+3), these loops have an RL nest at residues i+2 and i+3. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1550, 0, 0);
INSERT INTO chado.cvterm VALUES (1475, 23, 'beta_bulge_loop_six', 'A motif of three residues within a beta-sheet consisting of two H-bonds in which: the main-chain NH of residue(i) is H-bonded to the main-chain CO of residue(i+5), the main-chain CO of residue i is H-bonded to the main-chain NH of residue(i+4), these loops have an RL nest at residues i+3 and i+4. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1552, 0, 0);
INSERT INTO chado.cvterm VALUES (1476, 23, 'beta_strand', 'A beta strand describes a single length of polypeptide chain that forms part of a beta sheet. A single continuous stretch of amino acids adopting an extended conformation of hydrogen bonds between the N-O and the C=O of another part of the peptide. This forms a secondary protein structure in which two or more extended polypeptide regions are hydrogen-bonded to one another in a planar array. [EBIBS:GAR, UniProt:curation_manual]', 1554, 0, 0);
INSERT INTO chado.cvterm VALUES (1477, 23, 'antiparallel_beta_strand', 'A peptide region which hydrogen bonded to another region of peptide running in the oposite direction (one running N-terminal to C-terminal and one running C-terminal to N-terminal). Hydrogen bonding occurs between every other C=O from one strand to every other N-H on the adjacent strand. In this case, if two atoms C-alpha (i) and C-alpha (j) are adjacent in two hydrogen-bonded beta strands, then they form two mutual backbone hydrogen bonds to each other''s flanking peptide groups; this is known as a close pair of hydrogen bonds. The peptide backbone dihedral angles (phi, psi) are about (-140 degrees, 135 degrees) in antiparallel sheets. [EBIBS:GAR, UniProt:curation_manual]', 1556, 0, 0);
INSERT INTO chado.cvterm VALUES (1478, 23, 'parallel_beta_strand', 'A peptide region which hydrogen bonded to another region of peptide running in the oposite direction (both running N-terminal to C-terminal). This orientation is slightly less stable because it introduces nonplanarity in the inter-strand hydrogen bonding pattern. Hydrogen bonding occurs between every other C=O from one strand to every other N-H on the adjacent strand. In this case, if two atoms C-alpha (i)and C-alpha (j) are adjacent in two hydrogen-bonded beta strands, then they do not hydrogen bond to each other; rather, one residue forms hydrogen bonds to the residues that flank the other (but not vice versa). For example, residue i may form hydrogen bonds to residues j - 1 and j + 1; this is known as a wide pair of hydrogen bonds. By contrast, residue j may hydrogen-bond to different residues altogether, or to none at all. The dihedral angles (phi, psi) are about (-120 degrees, 115 degrees) in parallel sheets. [EBIBS:GAR, UniProt:curation_manual]', 1558, 0, 0);
INSERT INTO chado.cvterm VALUES (1479, 23, 'left_handed_peptide_helix', 'A left handed helix is a region of peptide where the coiled conformation turns in an anticlockwise, left handed screw. [EBIBS:GAR]', 1561, 0, 0);
INSERT INTO chado.cvterm VALUES (1480, 23, 'right_handed_peptide_helix', 'A right handed helix is a region of peptide where the coiled conformation turns in a clockwise, right handed screw. [EBIBS:GAR]', 1563, 0, 0);
INSERT INTO chado.cvterm VALUES (1481, 23, 'alpha_helix', 'The helix has 3.6 residues per turn which corresponds to a translation of 1.5 angstroms (= 0.15 nm) along the helical axis. Every backbone N-H group donates a hydrogen bond to the backbone C=O group of the amino acid four residues earlier. [EBIBS:GAR]', 1565, 0, 0);
INSERT INTO chado.cvterm VALUES (1482, 23, 'pi_helix', 'The pi helix has 4.1 residues per turn and a translation of 1.15 (=0.115 nm) along the helical axis. The N-H group of an amino acid forms a hydrogen bond with the C=O group of the amino acid five residues earlier. [EBIBS:GAR]', 1567, 0, 0);
INSERT INTO chado.cvterm VALUES (1483, 23, 'three_ten_helix', 'The 3-10 helix has 3 residues per turn with a translation of 2.0 angstroms (=0.2 nm) along the helical axis. The N-H group of an amino acid forms a hydrogen bond with the C=O group of the amino acid three residues earlier. [EBIBS:GAR]', 1569, 0, 0);
INSERT INTO chado.cvterm VALUES (1484, 23, 'polypeptide_nest_motif', 'A motif of two consecutive residues with dihedral angles. Nest should not have Proline as any residue. Nests frequently occur as parts of other motifs such as Schellman loops. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1571, 0, 0);
INSERT INTO chado.cvterm VALUES (1485, 23, 'polypeptide_nest_left_right_motif', 'A motif of two consecutive residues with dihedral angles: Residue(i): +20 degrees < phi < +140 degrees, -40 degrees < psi < +90 degrees. Residue(i+1): -140 degrees < phi < -20 degrees, -90 degrees < psi < +40 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1573, 0, 0);
INSERT INTO chado.cvterm VALUES (1486, 23, 'polypeptide_nest_right_left_motif', 'A motif of two consecutive residues with dihedral angles: Residue(i): -140 degrees < phi < -20 degrees, -90 degrees < psi < +40 degrees. Residue(i+1): +20 degrees < phi < +140 degrees, -40 degrees < psi < +90 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1575, 0, 0);
INSERT INTO chado.cvterm VALUES (1487, 23, 'schellmann_loop', 'A motif of six or seven consecutive residues that contains two H-bonds. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1577, 0, 0);
INSERT INTO chado.cvterm VALUES (1488, 23, 'schellmann_loop_seven', 'Wild type: A motif of seven consecutive residues that contains two H-bonds in which: the main-chain CO of residue(i) is H-bonded to the main-chain NH of residue(i+6), the main-chain CO of residue(i+1) is H-bonded to the main-chain NH of residue(i+5). [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1579, 0, 0);
INSERT INTO chado.cvterm VALUES (1489, 23, 'schellmann_loop_six', 'Common Type: A motif of six consecutive residues that contains two H-bonds in which: the main-chain CO of residue(i) is H-bonded to the main-chain NH of residue(i+5) the main-chain CO of residue(i+1) is H-bonded to the main-chain NH of residue(i+4). [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1581, 0, 0);
INSERT INTO chado.cvterm VALUES (1538, 23, 'CCA_tail', 'Base sequence at the 3'' end of a tRNA. The 3''-hydroxyl group on the terminal adenosine is the attachment point for the amino acid. [ISBN:0716719207]', 1656, 0, 0);
INSERT INTO chado.cvterm VALUES (1490, 23, 'serine_threonine_motif', 'A motif of five consecutive residues and two hydrogen bonds in which: residue(i) is Serine (S) or Threonine (T), the side-chain O of residue(i) is H-bonded to the main-chain NH of residue(i+2) or (i+3) , the main-chain CO group of residue(i) is H-bonded to the main-chain NH of residue(i+3) or (i+4). [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1583, 0, 0);
INSERT INTO chado.cvterm VALUES (1491, 23, 'serine_threonine_staple_motif', 'A motif of four or five consecutive residues and one H-bond in which: residue(i) is Serine (S) or Threonine (T), the side-chain OH of residue(i) is H-bonded to the main-chain CO of residue(i3) or (i4), Phi angles of residues(i1), (i2) and (i3) are negative. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1585, 0, 0);
INSERT INTO chado.cvterm VALUES (1492, 23, 'asx_turn_left_handed_type_one', 'Left handed type I (dihedral angles):- Residue(i): -140 degrees < chi (1) -120 degrees < -20 degrees, -90 degrees < psi +120 degrees < +40 degrees. Residue(i+1): -140 degrees < phi < -20 degrees, -90 degrees < psi < +40 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1588, 0, 0);
INSERT INTO chado.cvterm VALUES (1493, 23, 'asx_turn_left_handed_type_two', 'Left handed type II (dihedral angles):- Residue(i): -140 degrees < chi (1) -120 degrees < -20 degrees, +80 degrees < psi +120 degrees < +180 degrees. Residue(i+1): +20 degrees < phi < +140 degrees, -40 degrees < psi < +90 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1590, 0, 0);
INSERT INTO chado.cvterm VALUES (1494, 23, 'asx_turn_right_handed_type_two', 'Right handed type II (dihedral angles):- Residue(i): -140 degrees < chi (1) -120 degrees < -20 degrees, +80 degrees < psi +120 degrees < +180 degrees. Residue(i+1): +20 degrees < phi < +140 degrees, -40 degrees < psi < +90 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1592, 0, 0);
INSERT INTO chado.cvterm VALUES (1495, 23, 'asx_turn_right_handed_type_one', 'Right handed type I (dihedral angles):- Residue(i): -140 degrees < chi (1) -120 degrees < -20 degrees, -90 degrees < psi +120 degrees < +40 degrees. Residue(i+1): -140 degrees < phi < -20 degrees, -90 degrees < psi < +40 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1594, 0, 0);
INSERT INTO chado.cvterm VALUES (1496, 23, 'beta_turn', 'A motif of four consecutive residues that may contain one H-bond, which, if present, is between the main-chain CO of the first residue and the main-chain NH of the fourth. It is characterized by the dihedral angles of the second and third residues, which are the basis for sub-categorization. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1596, 0, 0);
INSERT INTO chado.cvterm VALUES (1497, 23, 'beta_turn_left_handed_type_one', 'Left handed type I:A motif of four consecutive residues that may contain one H-bond, which, if present, is between the main-chain CO of the first residue and the main-chain NH of the fourth. It is characterized by the dihedral angles:- Residue(i+1): -140 degrees > phi > -20 degrees, -90 degrees > psi > +40 degrees. Residue(i+2): -140 degrees > phi > -20 degrees, -90 degrees > psi > +40 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1598, 0, 0);
INSERT INTO chado.cvterm VALUES (1498, 23, 'beta_turn_left_handed_type_two', 'Left handed type II: A motif of four consecutive residues that may contain one H-bond, which, if present, is between the main-chain CO of the first residue and the main-chain NH of the fourth. It is characterized by the dihedral angles: Residue(i+1): -140 degrees > phi > -20 degrees, +80 degrees > psi > +180 degrees. Residue(i+2): +20 degrees > phi > +140 degrees, -40 degrees > psi > +90 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1600, 0, 0);
INSERT INTO chado.cvterm VALUES (1499, 23, 'beta_turn_right_handed_type_one', 'Right handed type I:A motif of four consecutive residues that may contain one H-bond, which, if present, is between the main-chain CO of the first residue and the main-chain NH of the fourth. It is characterized by the dihedral angles: Residue(i+1): -140 degrees < phi < -20 degrees, -90 degrees < psi < +40 degrees. Residue(i+2): -140 degrees < phi < -20 degrees, -90 degrees < psi < +40 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1602, 0, 0);
INSERT INTO chado.cvterm VALUES (1500, 23, 'beta_turn_right_handed_type_two', 'Right handed type II:A motif of four consecutive residues that may contain one H-bond, which, if present, is between the main-chain CO of the first residue and the main-chain NH of the fourth. It is characterized by the dihedral angles: Residue(i+1): -140 degrees < phi < -20 degrees, +80 degrees < psi < +180 degrees. Residue(i+2): +20 degrees < phi < +140 degrees, -40 degrees < psi < +90 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1604, 0, 0);
INSERT INTO chado.cvterm VALUES (1501, 23, 'gamma_turn', 'Gamma turns, defined for 3 residues i,( i+1),( i+2) if a hydrogen bond exists between residues i and i+2 and the phi and psi angles of residue i+1 fall within 40 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1606, 0, 0);
INSERT INTO chado.cvterm VALUES (1502, 23, 'gamma_turn_classic', 'Gamma turns, defined for 3 residues i, i+1, i+2 if a hydrogen bond exists between residues i and i+2 and the phi and psi angles of residue i+1 fall within 40 degrees: phi(i+1)=75.0 - psi(i+1)=-64.0. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1608, 0, 0);
INSERT INTO chado.cvterm VALUES (1503, 23, 'gamma_turn_inverse', 'Gamma turns, defined for 3 residues i, i+1, i+2 if a hydrogen bond exists between residues i and i+2 and the phi and psi angles of residue i+1 fall within 40 degrees: phi(i+1)=-79.0 - psi(i+1)=69.0. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1610, 0, 0);
INSERT INTO chado.cvterm VALUES (1504, 23, 'serine_threonine_turn', 'A motif of three consecutive residues and one H-bond in which: residue(i) is Serine (S) or Threonine (T), the side-chain O of residue(i) is H-bonded to the main-chain NH of residue(i+2). [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1612, 0, 0);
INSERT INTO chado.cvterm VALUES (1505, 23, 'st_turn_left_handed_type_one', 'The peptide twists in an anticlockwise, left handed manner. The dihedral angles for this turn are: Residue(i): -140 degrees < chi(1) -120 degrees < -20 degrees, -90 degrees psi +120 degrees < +40 degrees, residue(i+1): -140 degrees < phi < -20 degrees, -90 < psi < +40 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1614, 0, 0);
INSERT INTO chado.cvterm VALUES (1506, 23, 'st_turn_left_handed_type_two', 'The peptide twists in an anticlockwise, left handed manner. The dihedral angles for this turn are: Residue(i): -140 degrees < chi(1) -120 degrees < -20 degrees, +80 degrees psi +120 degrees < +180 degrees, residue(i+1): +20 degrees < phi < +140 degrees, -40 < psi < +90 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1616, 0, 0);
INSERT INTO chado.cvterm VALUES (1507, 23, 'st_turn_right_handed_type_one', 'The peptide twists in an clockwise, right handed manner. The dihedral angles for this turn are: Residue(i): -140 degrees < chi(1) -120 degrees < -20 degrees, -90 degrees psi +120 degrees < +40 degrees, residue(i+1): -140 degrees < phi < -20 degrees, -90 < psi < +40 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1618, 0, 0);
INSERT INTO chado.cvterm VALUES (1508, 23, 'st_turn_right_handed_type_two', 'The peptide twists in an clockwise, right handed manner. The dihedral angles for this turn are: Residue(i): -140 degrees < chi(1) -120 degrees < -20 degrees, +80 degrees psi +120 degrees < +180 degrees, residue(i+1): +20 degrees < phi < +140 degrees, -40 < psi < +90 degrees. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 1620, 0, 0);
INSERT INTO chado.cvterm VALUES (3016, 26, 'Conference Year', '', 3323, 0, 0);
INSERT INTO chado.cvterm VALUES (1509, 23, 'polypeptide_variation_site', 'A site of sequence variation (alteration). Alternative sequence due to naturally occurring events such as polymorphisms and alternative splicing or experimental methods such as site directed mutagenesis. [EBIBS:GAR, SO:ke]', 1622, 0, 0);
INSERT INTO chado.cvterm VALUES (1510, 23, 'natural_variant_site', 'Describes the natural sequence variants due to polymorphisms, disease-associated mutations, RNA editing and variations between strains, isolates or cultivars. [EBIBS:GAR, UniProt:curation_manual]', 1624, 0, 0);
INSERT INTO chado.cvterm VALUES (1511, 23, 'mutated_variant_site', 'Site which has been experimentally altered. [EBIBS:GAR, UniProt:curation_manual]', 1626, 0, 0);
INSERT INTO chado.cvterm VALUES (1512, 23, 'alternate_sequence_site', 'Description of sequence variants produced by alternative splicing, alternative promoter usage, alternative initiation and ribosomal frameshifting. [EBIBS:GAR, UniProt:curation_manual]', 1628, 0, 0);
INSERT INTO chado.cvterm VALUES (1513, 23, 'beta_turn_type_six', 'A motif of four consecutive peptide resides of type VIa or type VIb and where the i+2 residue is cis-proline. [SO:cb]', 1631, 0, 0);
INSERT INTO chado.cvterm VALUES (1514, 23, 'beta_turn_type_six_a', 'A motif of four consecutive peptide residues, of which the i+2 residue is proline, and that may contain one H-bond, which, if present, is between the main-chain CO of the first residue and the main-chain NH of the fourth and is characterized by the dihedral angles: Residue(i+1): phi ~ -60 degrees, psi ~ 120 degrees. Residue(i+2): phi ~ -90 degrees, psi ~ 0 degrees. [PMID:2371257, SO:cb]', 1632, 0, 0);
INSERT INTO chado.cvterm VALUES (1515, 23, 'beta_turn_type_six_a_one', 'A type VIa beta turn with the following phi and psi sngles on amino acid residues 2 and 3: phi-2 = -60 degrees, psi-2 = 120 degrees, phi-3 = -90 degrees, psi-3 = 0 degrees. [PMID:27428516]', 1633, 0, 0);
INSERT INTO chado.cvterm VALUES (1516, 23, 'beta_turn_type_six_a_two', 'A type VIa beta turn with the following phi and psi sngles on amino acid residues 2 and 3: phi-2 = -120 degrees, psi-2 = 120 degrees, phi-3 = -60 degrees, psi-3 = 0 degrees. [PMID:27428516]', 1634, 0, 0);
INSERT INTO chado.cvterm VALUES (1517, 23, 'beta_turn_type_six_b', 'A motif of four consecutive peptide residues, of which the i+2 residue is proline, and that may contain one H-bond, which, if present, is between the main-chain CO of the first residue and the main-chain NH of the fourth and is characterized by the dihedral angles: Residue(i+1): phi ~ -120 degrees, psi ~ 120 degrees. Residue(i+2): phi ~ -60 degrees, psi ~ 0 degrees. [PMID:2371257, SO:cb]', 1635, 0, 0);
INSERT INTO chado.cvterm VALUES (1518, 23, 'beta_turn_type_eight', 'A motif of four consecutive peptide residues that may contain one H-bond, which, if present, is between the main-chain CO of the first residue and the main-chain NH of the fourth and is characterized by the dihedral angles: Residue(i+1): phi ~ -60 degrees, psi ~ -30 degrees. Residue(i+2): phi ~ -120 degrees, psi ~ 120 degrees. [PMID:2371257, SO:cb]', 1636, 0, 0);
INSERT INTO chado.cvterm VALUES (1519, 23, 'DRE_motif', 'A sequence element characteristic of some RNA polymerase II promoters, usually located between -10 and -60 relative to the TSS. Consensus sequence is WATCGATW. [PMID:12537576]', 1637, 0, 0);
INSERT INTO chado.cvterm VALUES (1520, 23, 'DMv4_motif', 'A sequence element characteristic of some RNA polymerase II promoters, located immediately upstream of some TATA box elements with respect to the TSS (+1). Consensus sequence is YGGTCACACTR. Marked spatial preference within core promoter; tend to occur near the TSS, although not as tightly as INR (SO:0000014). [PMID:16827941\:12537576]', 1638, 0, 0);
INSERT INTO chado.cvterm VALUES (1521, 23, 'E_box_motif', 'A sequence element characteristic of some RNA polymerase II promoters, usually located between -60 and +1 relative to the TSS. Consensus sequence is AWCAGCTGWT. Tends to co-occur with DMv2 (SO:0001161). Tends to not occur with DPE motif (SO:0000015). [PMID:12537576\:16827941]', 1639, 0, 0);
INSERT INTO chado.cvterm VALUES (1522, 23, 'DMv5_motif', 'A sequence element characteristic of some RNA polymerase II promoters, usually located between -50 and -10 relative to the TSS. Consensus sequence is KTYRGTATWTTT. Tends to co-occur with DMv4 (SO:0001157) . Tends to not occur with DPE motif (SO:0000015) or MTE (SO:0001162). [PMID:12537576\:16827941]', 1640, 0, 0);
INSERT INTO chado.cvterm VALUES (1523, 23, 'DMv3_motif', 'A sequence element characteristic of some RNA polymerase II promoters, usually located between -30 and +15 relative to the TSS. Consensus sequence is KNNCAKCNCTRNY. Tends to co-occur with DMv2 (SO:0001161). Tends to not occur with DPE motif (SO:0000015) or MTE (0001162). [PMID:12537576\:16827941]', 1641, 0, 0);
INSERT INTO chado.cvterm VALUES (1524, 23, 'DMv2_motif', 'A sequence element characteristic of some RNA polymerase II promoters, usually located between -60 and -45 relative to the TSS. Consensus sequence is MKSYGGCARCGSYSS. Tends to co-occur with DMv3 (SO:0001160). Tends to not occur with DPE motif (SO:0000015) or MTE (SO:0001162). [PMID:12537576\:16827941]', 1642, 0, 0);
INSERT INTO chado.cvterm VALUES (1525, 23, 'MTE', 'A sequence element characteristic of some RNA polymerase II promoters, usually located between +20 and +30 relative to the TSS. Consensus sequence is CSARCSSAACGS. Tends to co-occur with INR motif (SO:0000014). Tends to not occur with DPE motif (SO:0000015) or DMv5 (SO:0001159). [PMID:12537576\:15231738, PMID:16858867]', 1643, 0, 0);
INSERT INTO chado.cvterm VALUES (1526, 23, 'INR1_motif', 'A promoter motif with consensus sequence TCATTCG. [PMID:16827941]', 1644, 0, 0);
INSERT INTO chado.cvterm VALUES (1527, 23, 'DPE1_motif', 'A promoter motif with consensus sequence CGGACGT. [PMID:16827941]', 1645, 0, 0);
INSERT INTO chado.cvterm VALUES (1528, 23, 'DMv1_motif', 'A promoter motif with consensus sequence CARCCCT. [PMID:16827941]', 1646, 0, 0);
INSERT INTO chado.cvterm VALUES (1529, 23, 'GAGA_motif', 'A non directional promoter motif with consensus sequence GAGAGCG. [PMID:16827941]', 1647, 0, 0);
INSERT INTO chado.cvterm VALUES (1530, 23, 'NDM2_motif', 'A non directional promoter motif with consensus CGMYGYCR. [PMID:16827941]', 1648, 0, 0);
INSERT INTO chado.cvterm VALUES (1531, 23, 'NDM3_motif', 'A non directional promoter motif with consensus sequence GAAAGCT. [PMID:16827941]', 1649, 0, 0);
INSERT INTO chado.cvterm VALUES (1532, 23, 'ds_RNA_viral_sequence', 'A ds_RNA_viral_sequence is a viral_sequence that is the sequence of a virus that exists as double stranded RNA. [SO:ke]', 1650, 0, 0);
INSERT INTO chado.cvterm VALUES (1533, 23, 'polinton', 'A kind of DNA transposon that populates the genomes of protists, fungi, and animals, characterized by a unique set of proteins necessary for their transposition, including a protein-primed DNA polymerase B, retroviral integrase, cysteine protease, and ATPase. Polintons are characterized by 6-bp target site duplications, terminal-inverted repeats that are several hundred nucleotides long, and 5''-AG and TC-3'' termini. Polintons exist as autonomous and nonautonomous elements. [PMID:16537396]', 1651, 0, 0);
INSERT INTO chado.cvterm VALUES (1534, 23, 'rRNA_21S', 'A component of the large ribosomal subunit in mitochondrial rRNA. [RSC:cb]', 1652, 1, 0);
INSERT INTO chado.cvterm VALUES (1535, 23, 'tRNA_region', 'A region of a tRNA. [RSC:cb]', 1653, 0, 0);
INSERT INTO chado.cvterm VALUES (1536, 23, 'anticodon_loop', 'A sequence of seven nucleotide bases in tRNA which contains the anticodon. It has the sequence 5''-pyrimidine-purine-anticodon-modified purine-any base-3. [ISBN:0716719207]', 1654, 0, 0);
INSERT INTO chado.cvterm VALUES (1537, 23, 'anticodon', 'A sequence of three nucleotide bases in tRNA which recognizes a codon in mRNA. [RSC:cb]', 1655, 0, 0);
INSERT INTO chado.cvterm VALUES (1539, 23, 'DHU_loop', 'Non-base-paired sequence of nucleotide bases in tRNA. It contains several dihydrouracil residues. [ISBN:071671920]', 1657, 0, 0);
INSERT INTO chado.cvterm VALUES (1540, 23, 'T_loop', 'Non-base-paired sequence of three nucleotide bases in tRNA. It has sequence T-Psi-C. [ISBN:0716719207]', 1658, 0, 0);
INSERT INTO chado.cvterm VALUES (1541, 23, 'U3_snoRNA', 'U3 snoRNA is a member of the box C/D class of small nucleolar RNAs. The U3 snoRNA secondary structure is characterised by a small 5'' domain (with boxes A and A''), and a larger 3'' domain (with boxes B, C, C'', and D), the two domains being linked by a single-stranded hinge. Boxes B and C form the B/C motif, which appears to be exclusive to U3 snoRNAs, and boxes C'' and D form the C''/D motif. The latter is functionally similar to the C/D motifs found in other snoRNAs. The 5'' domain and the hinge region act as a pre-rRNA-binding domain. The 3'' domain has conserved protein-binding sites. Both the box B/C and box C''/D motifs are sufficient for nuclear retention of U3 snoRNA. The box C''/D motif is also necessary for nucleolar localization, stability and hypermethylation of U3 snoRNA. Both box B/C and C''/D motifs are involved in specific protein interactions and are necessary for the rRNA processing functions of U3 snoRNA. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00012]', 1659, 0, 0);
INSERT INTO chado.cvterm VALUES (1542, 23, 'AU_rich_element', 'A cis-acting element found in the 3'' UTR of some mRNA which is rich in AUUUA pentamers. Messenger RNAs bearing multiple AU-rich elements are often unstable. [PMID:7892223]', 1660, 0, 0);
INSERT INTO chado.cvterm VALUES (1543, 23, 'Bruno_response_element', 'A cis-acting element found in the 3'' UTR of some mRNA which is bound by the Drosophila Bruno protein and its homologs. [PMID:10893231]', 1661, 0, 0);
INSERT INTO chado.cvterm VALUES (1544, 23, 'iron_responsive_element', 'A regulatory sequence found in the 5'' and 3'' UTRs of many mRNAs which encode iron-binding proteins. It has a hairpin structure and is recognized by trans-acting proteins known as iron-regulatory proteins. [PMID:3198610, PMID:8710843]', 1662, 0, 0);
INSERT INTO chado.cvterm VALUES (1545, 23, 'pseudouridylation_guide_snoRNA', 'A snoRNA that specifies the site of pseudouridylation in an RNA molecule by base pairing with a short sequence around the target residue. [GOC:mah, PMID:12457565]', 1663, 0, 0);
INSERT INTO chado.cvterm VALUES (1546, 23, 'LNA', 'An attribute describing a sequence consisting of nucleobases attached to a repeating unit made of ''locked'' deoxyribose rings connected to a phosphate backbone. The deoxyribose unit''s conformation is ''locked'' by a 2''-C,4''-C-oxymethylene link. [CHEBI:48010]', 1664, 0, 0);
INSERT INTO chado.cvterm VALUES (1547, 23, 'LNA_oligo', 'An oligo composed of LNA residues. [RSC:cb]', 1665, 0, 0);
INSERT INTO chado.cvterm VALUES (1548, 23, 'TNA', 'An attribute describing a sequence consisting of nucleobases attached to a repeating unit made of threose rings connected to a phosphate backbone. [CHEBI:48019]', 1666, 0, 0);
INSERT INTO chado.cvterm VALUES (1549, 23, 'TNA_oligo', 'An oligo composed of TNA residues. [RSC:cb]', 1667, 0, 0);
INSERT INTO chado.cvterm VALUES (1550, 23, 'GNA', 'An attribute describing a sequence consisting of nucleobases attached to a repeating unit made of an acyclic three-carbon propylene glycol connected to a phosphate backbone. It has two enantiomeric forms, (R)-GNA and (S)-GNA. [CHEBI:48015]', 1668, 0, 0);
INSERT INTO chado.cvterm VALUES (1551, 23, 'GNA_oligo', 'An oligo composed of GNA residues. [RSC:cb]', 1669, 0, 0);
INSERT INTO chado.cvterm VALUES (1552, 23, 'R_GNA', 'An attribute describing a GNA sequence in the (R)-GNA enantiomer. [CHEBI:48016]', 1670, 0, 0);
INSERT INTO chado.cvterm VALUES (1553, 23, 'R_GNA_oligo', 'An oligo composed of (R)-GNA residues. [RSC:cb]', 1671, 0, 0);
INSERT INTO chado.cvterm VALUES (1554, 23, 'S_GNA', 'An attribute describing a GNA sequence in the (S)-GNA enantiomer. [CHEBI:48017]', 1672, 0, 0);
INSERT INTO chado.cvterm VALUES (1555, 23, 'S_GNA_oligo', 'An oligo composed of (S)-GNA residues. [RSC:cb]', 1673, 0, 0);
INSERT INTO chado.cvterm VALUES (1556, 23, 'ds_DNA_viral_sequence', 'A ds_DNA_viral_sequence is a viral_sequence that is the sequence of a virus that exists as double stranded DNA. [SO:ke]', 1674, 0, 0);
INSERT INTO chado.cvterm VALUES (1557, 23, 'ss_RNA_viral_sequence', 'A ss_RNA_viral_sequence is a viral_sequence that is the sequence of a virus that exists as single stranded RNA. [SO:ke]', 1675, 0, 0);
INSERT INTO chado.cvterm VALUES (1558, 23, 'negative_sense_ssRNA_viral_sequence', 'A negative_sense_RNA_viral_sequence is a ss_RNA_viral_sequence that is the sequence of a single stranded RNA virus that is complementary to mRNA and must be converted to positive sense RNA by RNA polymerase before translation. [SO:ke]', 1676, 0, 0);
INSERT INTO chado.cvterm VALUES (1559, 23, 'positive_sense_ssRNA_viral_sequence', 'A positive_sense_RNA_viral_sequence is a ss_RNA_viral_sequence that is the sequence of a single stranded RNA virus that can be immediately translated by the host. [SO:ke]', 1677, 0, 0);
INSERT INTO chado.cvterm VALUES (1560, 23, 'ambisense_ssRNA_viral_sequence', 'A ambisense_RNA_virus is a ss_RNA_viral_sequence that is the sequence of a single stranded RNA virus with both messenger and anti messenger polarity. [SO:ke]', 1678, 0, 0);
INSERT INTO chado.cvterm VALUES (1561, 23, 'RNA_polymerase_promoter', 'A region (DNA) to which RNA polymerase binds, to begin transcription. [xenbase:jb]', 1679, 1, 0);
INSERT INTO chado.cvterm VALUES (1562, 23, 'Phage_RNA_Polymerase_Promoter', 'A region (DNA) to which Bacteriophage RNA polymerase binds, to begin transcription. [xenbase:jb]', 1680, 0, 0);
INSERT INTO chado.cvterm VALUES (1563, 23, 'viral_promoter', 'A regulatory_region including the Transcription Start Site (TSS) of a gene found in genes of viruses. [GREEKC:cl]', 1681, 0, 0);
INSERT INTO chado.cvterm VALUES (1564, 23, 'SP6_RNA_Polymerase_Promoter', 'A region (DNA) to which the SP6 RNA polymerase binds, to begin transcription. [xenbase:jb]', 1682, 0, 0);
INSERT INTO chado.cvterm VALUES (1565, 23, 'T3_RNA_Polymerase_Promoter', 'A DNA sequence to which the T3 RNA polymerase binds, to begin transcription. [xenbase:jb]', 1683, 0, 0);
INSERT INTO chado.cvterm VALUES (1566, 23, 'T7_RNA_Polymerase_Promoter', 'A region (DNA) to which the T7 RNA polymerase binds, to begin transcription. [xenbase:jb]', 1684, 0, 0);
INSERT INTO chado.cvterm VALUES (1567, 23, 'five_prime_EST', 'An EST read from the 5'' end of a transcript that usually codes for a protein. These regions tend to be conserved across species and do not change much within a gene family. [http://www.ncbi.nlm.nih.gov/About/primer/est.html]', 1685, 0, 0);
INSERT INTO chado.cvterm VALUES (1568, 23, 'three_prime_EST', 'An EST read from the 3'' end of a transcript. They are more likely to fall within non-coding, or untranslated regions(UTRs). [http://www.ncbi.nlm.nih.gov/About/primer/est.html]', 1686, 0, 0);
INSERT INTO chado.cvterm VALUES (1569, 23, 'translational_frameshift', 'The region of mRNA (not divisible by 3 bases) that is skipped or added during the process of translational frameshifting (GO:0006452), causing the reading frame to be different. [http://www.insdc.org/files/feature_table.html, SO:ke]', 1687, 0, 0);
INSERT INTO chado.cvterm VALUES (1570, 23, 'plus_1_translational_frameshift', 'The region of mRNA 1 base long that is skipped during the process of translational frameshifting (GO:0006452), causing the reading frame to be different. [SO:ke]', 1688, 0, 0);
INSERT INTO chado.cvterm VALUES (1571, 23, 'plus_2_translational_frameshift', 'The region of mRNA 2 bases long that is skipped during the process of translational frameshifting (GO:0006452), causing the reading frame to be different. [SO:ke]', 1689, 0, 0);
INSERT INTO chado.cvterm VALUES (3017, 26, 'Proceedings Computer Demo', '', 3324, 0, 0);
INSERT INTO chado.cvterm VALUES (1572, 23, 'group_III_intron', 'Group III introns are introns found in the mRNA of the plastids of euglenoid protists. They are spliced by a two step transesterification with bulged adenosine as initiating nucleophile. [PMID:11377794]', 1690, 0, 0);
INSERT INTO chado.cvterm VALUES (1573, 23, 'endonuclease_spliced_intron', 'An intron that spliced via endonucleolytic cleavage and ligation rather than transesterification. [SO:ke]', 1691, 0, 0);
INSERT INTO chado.cvterm VALUES (1574, 23, 'transgenic_insertion', 'An insertion that derives from another organism, via the use of recombinant DNA technology. [SO:bm]', 1692, 0, 0);
INSERT INTO chado.cvterm VALUES (1575, 23, 'retrogene', 'A gene that has been produced as the product of a reverse transcriptase mediated event. []', 1693, 0, 0);
INSERT INTO chado.cvterm VALUES (1576, 23, 'silenced_by_RNA_interference', 'An attribute describing an epigenetic process where a gene is inactivated by RNA interference. [RSC:cb]', 1694, 0, 0);
INSERT INTO chado.cvterm VALUES (1577, 23, 'silenced_by_histone_modification', 'An attribute describing an epigenetic process where a gene is inactivated by histone modification. [RSC:cb]', 1695, 0, 0);
INSERT INTO chado.cvterm VALUES (1578, 23, 'silenced_by_histone_methylation', 'An attribute describing an epigenetic process where a gene is inactivated by histone methylation. [RSC:cb]', 1696, 0, 0);
INSERT INTO chado.cvterm VALUES (1579, 23, 'silenced_by_histone_deacetylation', 'An attribute describing an epigenetic process where a gene is inactivated by histone deacetylation. [RSC:cb]', 1697, 0, 0);
INSERT INTO chado.cvterm VALUES (1580, 23, 'gene_silenced_by_RNA_interference', 'A gene that is silenced by RNA interference. [SO:xp]', 1698, 0, 0);
INSERT INTO chado.cvterm VALUES (1581, 23, 'gene_silenced_by_histone_modification', 'A gene that is silenced by histone modification. [SO:xp]', 1699, 0, 0);
INSERT INTO chado.cvterm VALUES (1582, 23, 'gene_silenced_by_histone_methylation', 'A gene that is silenced by histone methylation. [SO:xp]', 1700, 0, 0);
INSERT INTO chado.cvterm VALUES (1583, 23, 'gene_silenced_by_histone_deacetylation', 'A gene that is silenced by histone deacetylation. [SO:xp]', 1701, 0, 0);
INSERT INTO chado.cvterm VALUES (1584, 23, 'dihydrouridine', 'A modified RNA base in which the 5,6-dihydrouracil is bound to the ribose ring. [RSC:cb]', 1702, 0, 0);
INSERT INTO chado.cvterm VALUES (1585, 23, 'modified_uridine', 'A uridine base that has been modified. []', 1704, 0, 0);
INSERT INTO chado.cvterm VALUES (1586, 23, 'pseudouridine', 'A modified RNA base in which the 5- position of the uracil is bound to the ribose ring instead of the 4- position. [RSC:cb]', 1705, 0, 0);
INSERT INTO chado.cvterm VALUES (1587, 23, 'inosine', 'A modified RNA base in which hypoxanthine is bound to the ribose ring. [http://library.med.utah.edu/RNAmods/, RSC:cb]', 1707, 0, 0);
INSERT INTO chado.cvterm VALUES (1588, 23, 'seven_methylguanine', 'A modified RNA base in which guanine is methylated at the 7- position. [RSC:cb]', 1708, 0, 0);
INSERT INTO chado.cvterm VALUES (1589, 23, 'ribothymidine', 'A modified RNA base in which thymine is bound to the ribose ring. [RSC:cb]', 1709, 0, 0);
INSERT INTO chado.cvterm VALUES (1590, 23, 'methylinosine', 'A modified RNA base in which methylhypoxanthine is bound to the ribose ring. [RSC:cb]', 1710, 0, 0);
INSERT INTO chado.cvterm VALUES (1591, 23, 'modified_inosine', 'A modified inosine is an inosine base feature that has been altered. [SO:ke]', 1711, 0, 0);
INSERT INTO chado.cvterm VALUES (1592, 23, 'major_TSS', 'The tanscription start site that is most frequently used for transcription of a gene. []', 1712, 0, 0);
INSERT INTO chado.cvterm VALUES (1593, 23, 'minor_TSS', 'A tanscription start site that is not the most frequently used for transcription of a gene. []', 1713, 0, 0);
INSERT INTO chado.cvterm VALUES (1594, 23, 'TSS_region', 'The region of a gene from the 5'' most TSS to the 3'' TSS. [BBOP:nw]', 1714, 1, 0);
INSERT INTO chado.cvterm VALUES (1595, 23, 'encodes_alternate_transcription_start_sites', 'A gene that has multiple possible transcription start sites. []', 1715, 0, 0);
INSERT INTO chado.cvterm VALUES (1596, 23, 'miRNA_primary_transcript_region', 'A part of an miRNA primary_transcript. [SO:ke]', 1716, 0, 0);
INSERT INTO chado.cvterm VALUES (1597, 23, 'miRNA_stem', 'The stem of the hairpin loop formed by folding of the pre-miRNA. [SO:ke]', 1717, 0, 0);
INSERT INTO chado.cvterm VALUES (1598, 23, 'miRNA_loop', 'The loop of the hairpin loop formed by folding of the pre-miRNA. [SO:ke]', 1718, 0, 0);
INSERT INTO chado.cvterm VALUES (1599, 23, 'fragment_assembly', 'A fragment assembly is a genome assembly that orders overlapping fragments of the genome based on landmark sequences. The base pair distance between the landmarks is known allowing additivity of lengths. [SO:ke]', 1719, 0, 0);
INSERT INTO chado.cvterm VALUES (1600, 23, 'fingerprint_map', 'A fingerprint_map is a physical map composed of restriction fragments. [SO:ke]', 1720, 0, 0);
INSERT INTO chado.cvterm VALUES (1601, 23, 'STS_map', 'An STS map is a physical map organized by the unique STS landmarks. [SO:ke]', 1721, 0, 0);
INSERT INTO chado.cvterm VALUES (1602, 23, 'RH_map', 'A radiation hybrid map is a physical map. [SO:ke]', 1722, 0, 0);
INSERT INTO chado.cvterm VALUES (1603, 23, 'sonicate_fragment', 'A DNA fragment generated by sonication. Sonication is a technique used to sheer DNA into smaller fragments. [SO:ke]', 1723, 0, 0);
INSERT INTO chado.cvterm VALUES (1604, 23, 'polyploid', 'A kind of chromosome variation where the chromosome complement is an exact multiple of the haploid number and is greater than the diploid number. [SO:ke]', 1724, 0, 0);
INSERT INTO chado.cvterm VALUES (1605, 23, 'autopolyploid', 'A polyploid where the multiple chromosome set was derived from the same organism. [SO:ke]', 1725, 0, 0);
INSERT INTO chado.cvterm VALUES (1606, 23, 'allopolyploid', 'A polyploid where the multiple chromosome set was derived from a different organism. [SO:ke]', 1726, 0, 0);
INSERT INTO chado.cvterm VALUES (1607, 23, 'homing_endonuclease_binding_site', 'The binding site (recognition site) of a homing endonuclease. The binding site is typically large. [SO:ke]', 1727, 0, 0);
INSERT INTO chado.cvterm VALUES (1608, 23, 'octamer_motif', 'A sequence element characteristic of some RNA polymerase II promoters with sequence ATTGCAT that binds Pou-domain transcription factors. [GOC:dh, PMID:3095662]', 1728, 0, 0);
INSERT INTO chado.cvterm VALUES (1609, 23, 'apicoplast_chromosome', 'A chromosome originating in an apicoplast. [SO:xp]', 1729, 0, 0);
INSERT INTO chado.cvterm VALUES (1610, 23, 'overlapping_feature_set', 'A continuous region of sequence composed of the overlapping of multiple sequence_features, which ultimately provides evidence for another sequence_feature. [SO:ke]', 1730, 0, 0);
INSERT INTO chado.cvterm VALUES (1611, 23, 'overlapping_EST_set', 'A continous experimental result region extending the length of multiple overlapping EST''s. [SO:ke]', 1731, 0, 0);
INSERT INTO chado.cvterm VALUES (1612, 23, 'ncRNA_gene', 'A gene that encodes a non-coding RNA. []', 1732, 0, 0);
INSERT INTO chado.cvterm VALUES (1613, 23, 'gRNA_gene', 'A noncoding RNA that guides the insertion or deletion of uridine residues in mitochondrial mRNAs. This may also refer to synthetic RNAs used to guide DNA editing using the CRIPSR/Cas9 system. []', 1733, 0, 0);
INSERT INTO chado.cvterm VALUES (1614, 23, 'miRNA_gene', 'A small noncoding RNA of approximately 22 nucleotides in length which may be involved in regulation of gene expression. []', 1734, 0, 0);
INSERT INTO chado.cvterm VALUES (1615, 23, 'sncRNA_gene', 'A ncRNA_gene that encodes an ncRNA less than 200 nucleotides in length. [PMID:28449079, PMID:30069443, PMID:30937442]', 1736, 0, 0);
INSERT INTO chado.cvterm VALUES (1616, 23, 'scRNA_gene', 'A gene encoding a small noncoding RNA that is generally found only in the cytoplasm. []', 1737, 0, 0);
INSERT INTO chado.cvterm VALUES (1617, 23, 'snoRNA_gene', 'A gene encoding a small noncoding RNA that participates in the processing or chemical modifications of many RNAs, including ribosomal RNAs and spliceosomal RNAs. []', 1738, 0, 0);
INSERT INTO chado.cvterm VALUES (1618, 23, 'snRNA_gene', 'A gene that encodes a small nuclear RNA. [http://en.wikipedia.org/wiki/Small_nuclear_RNA]', 1739, 0, 0);
INSERT INTO chado.cvterm VALUES (1619, 23, 'SRP_RNA_gene', 'A gene that encodes a signal recognition particle (SRP) RNA. []', 1740, 0, 0);
INSERT INTO chado.cvterm VALUES (1620, 23, 'tmRNA_gene', 'A bacterial RNA with both tRNA and mRNA like properties. []', 1741, 0, 0);
INSERT INTO chado.cvterm VALUES (1621, 23, 'tRNA_gene', 'A noncoding RNA that binds to a specific amino acid to allow that amino acid to be used by the ribosome during translation of RNA. []', 1742, 0, 0);
INSERT INTO chado.cvterm VALUES (1622, 23, 'modified_adenosine', 'A modified adenine is an adenine base feature that has been altered. [SO:ke]', 1743, 0, 0);
INSERT INTO chado.cvterm VALUES (1623, 23, 'modified_cytidine', 'A modified cytidine is a cytidine base feature which has been altered. [SO:ke]', 1744, 0, 0);
INSERT INTO chado.cvterm VALUES (1624, 23, 'modified_guanosine', 'A guanosine base that has been modified. []', 1745, 0, 0);
INSERT INTO chado.cvterm VALUES (1625, 23, 'one_methylinosine', '1-methylinosine is a modified inosine. [http://library.med.utah.edu/RNAmods/]', 1746, 0, 0);
INSERT INTO chado.cvterm VALUES (1626, 23, 'one_two_prime_O_dimethylinosine', '1,2''-O-dimethylinosine is a modified inosine. [http://library.med.utah.edu/RNAmods/]', 1748, 0, 0);
INSERT INTO chado.cvterm VALUES (1627, 23, 'two_prime_O_methylinosine', '2''-O-methylinosine is a modified inosine. [http://library.med.utah.edu/RNAmods/]', 1750, 0, 0);
INSERT INTO chado.cvterm VALUES (1628, 23, 'three_methylcytidine', '3-methylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]', 1752, 0, 0);
INSERT INTO chado.cvterm VALUES (1629, 23, 'five_methylcytidine', '5-methylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]', 1754, 0, 0);
INSERT INTO chado.cvterm VALUES (1630, 23, 'two_prime_O_methylcytidine', '2''-O-methylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]', 1756, 0, 0);
INSERT INTO chado.cvterm VALUES (1631, 23, 'two_thiocytidine', '2-thiocytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]', 1758, 0, 0);
INSERT INTO chado.cvterm VALUES (1632, 23, 'N4_acetylcytidine', 'N4-acetylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]', 1760, 0, 0);
INSERT INTO chado.cvterm VALUES (1633, 23, 'five_formylcytidine', '5-formylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]', 1762, 0, 0);
INSERT INTO chado.cvterm VALUES (1634, 23, 'five_two_prime_O_dimethylcytidine', '5,2''-O-dimethylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]', 1764, 0, 0);
INSERT INTO chado.cvterm VALUES (1635, 23, 'N4_acetyl_2_prime_O_methylcytidine', 'N4-acetyl-2''-O-methylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]', 1766, 0, 0);
INSERT INTO chado.cvterm VALUES (1636, 23, 'lysidine', 'Lysidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]', 1768, 0, 0);
INSERT INTO chado.cvterm VALUES (1637, 23, 'N4_methylcytidine', 'N4-methylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]', 1770, 0, 0);
INSERT INTO chado.cvterm VALUES (1638, 23, 'N4_2_prime_O_dimethylcytidine', 'N4,2''-O-dimethylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]', 1772, 0, 0);
INSERT INTO chado.cvterm VALUES (1639, 23, 'five_hydroxymethylcytidine', '5-hydroxymethylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]', 1774, 0, 0);
INSERT INTO chado.cvterm VALUES (1640, 23, 'five_formyl_two_prime_O_methylcytidine', '5-formyl-2''-O-methylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]', 1776, 0, 0);
INSERT INTO chado.cvterm VALUES (1641, 23, 'N4_N4_2_prime_O_trimethylcytidine', 'N4_N4_2_prime_O_trimethylcytidine is a modified cytidine. [http://library.med.utah.edu/RNAmods/]', 1778, 0, 0);
INSERT INTO chado.cvterm VALUES (1642, 23, 'one_methyladenosine', '1_methyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1780, 0, 0);
INSERT INTO chado.cvterm VALUES (1643, 23, 'two_methyladenosine', '2_methyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1782, 0, 0);
INSERT INTO chado.cvterm VALUES (1644, 23, 'N6_methyladenosine', 'N6_methyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1784, 0, 0);
INSERT INTO chado.cvterm VALUES (1645, 23, 'two_prime_O_methyladenosine', '2prime_O_methyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1786, 0, 0);
INSERT INTO chado.cvterm VALUES (1646, 23, 'two_methylthio_N6_methyladenosine', '2_methylthio_N6_methyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1788, 0, 0);
INSERT INTO chado.cvterm VALUES (1647, 23, 'N6_isopentenyladenosine', 'N6_isopentenyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1790, 0, 0);
INSERT INTO chado.cvterm VALUES (1648, 23, 'two_methylthio_N6_isopentenyladenosine', '2_methylthio_N6_isopentenyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1792, 0, 0);
INSERT INTO chado.cvterm VALUES (1649, 23, 'N6_cis_hydroxyisopentenyl_adenosine', 'N6_cis_hydroxyisopentenyl_adenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1794, 0, 0);
INSERT INTO chado.cvterm VALUES (1650, 23, 'two_methylthio_N6_cis_hydroxyisopentenyl_adenosine', '2_methylthio_N6_cis_hydroxyisopentenyl_adenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1796, 0, 0);
INSERT INTO chado.cvterm VALUES (1651, 23, 'N6_glycinylcarbamoyladenosine', 'N6_glycinylcarbamoyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1798, 0, 0);
INSERT INTO chado.cvterm VALUES (1652, 23, 'N6_threonylcarbamoyladenosine', 'N6_threonylcarbamoyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1800, 0, 0);
INSERT INTO chado.cvterm VALUES (1653, 23, 'two_methylthio_N6_threonyl_carbamoyladenosine', '2_methylthio_N6_threonyl_carbamoyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1802, 0, 0);
INSERT INTO chado.cvterm VALUES (1654, 23, 'N6_methyl_N6_threonylcarbamoyladenosine', 'N6_methyl_N6_threonylcarbamoyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1804, 0, 0);
INSERT INTO chado.cvterm VALUES (1655, 23, 'N6_hydroxynorvalylcarbamoyladenosine', 'N6_hydroxynorvalylcarbamoyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1806, 0, 0);
INSERT INTO chado.cvterm VALUES (1656, 23, 'two_methylthio_N6_hydroxynorvalyl_carbamoyladenosine', '2_methylthio_N6_hydroxynorvalyl_carbamoyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1808, 0, 0);
INSERT INTO chado.cvterm VALUES (1657, 23, 'two_prime_O_ribosyladenosine_phosphate', '2prime_O_ribosyladenosine_phosphate is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1810, 0, 0);
INSERT INTO chado.cvterm VALUES (1658, 23, 'N6_N6_dimethyladenosine', 'N6_N6_dimethyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1812, 0, 0);
INSERT INTO chado.cvterm VALUES (1659, 23, 'N6_2_prime_O_dimethyladenosine', 'N6_2prime_O_dimethyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1814, 0, 0);
INSERT INTO chado.cvterm VALUES (1660, 23, 'N6_N6_2_prime_O_trimethyladenosine', 'N6_N6_2prime_O_trimethyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1816, 0, 0);
INSERT INTO chado.cvterm VALUES (1661, 23, 'one_two_prime_O_dimethyladenosine', '1,2''-O-dimethyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1818, 0, 0);
INSERT INTO chado.cvterm VALUES (1662, 23, 'N6_acetyladenosine', 'N6_acetyladenosine is a modified adenosine. [http://library.med.utah.edu/RNAmods/]', 1820, 0, 0);
INSERT INTO chado.cvterm VALUES (1663, 23, 'seven_deazaguanosine', '7-deazaguanosine is a modified guanosine. [http://library.med.utah.edu/RNAmods/]', 1822, 0, 0);
INSERT INTO chado.cvterm VALUES (1664, 23, 'queuosine', 'Queuosine is a modified 7-deazoguanosine. [http://library.med.utah.edu/RNAmods/]', 1823, 0, 0);
INSERT INTO chado.cvterm VALUES (1665, 23, 'epoxyqueuosine', 'Epoxyqueuosine is a modified 7-deazoguanosine. [http://library.med.utah.edu/RNAmods/]', 1825, 0, 0);
INSERT INTO chado.cvterm VALUES (1666, 23, 'galactosyl_queuosine', 'Galactosyl_queuosine is a modified 7-deazoguanosine. [http://library.med.utah.edu/RNAmods/]', 1827, 0, 0);
INSERT INTO chado.cvterm VALUES (1667, 23, 'mannosyl_queuosine', 'Mannosyl_queuosine is a modified 7-deazoguanosine. [http://library.med.utah.edu/RNAmods/]', 1829, 0, 0);
INSERT INTO chado.cvterm VALUES (1668, 23, 'seven_cyano_seven_deazaguanosine', '7_cyano_7_deazaguanosine is a modified 7-deazoguanosine. [http://library.med.utah.edu/RNAmods/]', 1831, 0, 0);
INSERT INTO chado.cvterm VALUES (1669, 23, 'seven_aminomethyl_seven_deazaguanosine', '7_aminomethyl_7_deazaguanosine is a modified 7-deazoguanosine. [http://library.med.utah.edu/RNAmods/]', 1833, 0, 0);
INSERT INTO chado.cvterm VALUES (1670, 23, 'archaeosine', 'Archaeosine is a modified 7-deazoguanosine. [http://library.med.utah.edu/RNAmods/]', 1835, 0, 0);
INSERT INTO chado.cvterm VALUES (1671, 23, 'one_methylguanosine', '1_methylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1837, 0, 0);
INSERT INTO chado.cvterm VALUES (1672, 23, 'N2_methylguanosine', 'N2_methylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1839, 0, 0);
INSERT INTO chado.cvterm VALUES (1673, 23, 'seven_methylguanosine', '7_methylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1841, 0, 0);
INSERT INTO chado.cvterm VALUES (1674, 23, 'two_prime_O_methylguanosine', '2prime_O_methylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1843, 0, 0);
INSERT INTO chado.cvterm VALUES (1675, 23, 'N2_N2_dimethylguanosine', 'N2_N2_dimethylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1845, 0, 0);
INSERT INTO chado.cvterm VALUES (1676, 23, 'N2_2_prime_O_dimethylguanosine', 'N2_2prime_O_dimethylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1847, 0, 0);
INSERT INTO chado.cvterm VALUES (1677, 23, 'N2_N2_2_prime_O_trimethylguanosine', 'N2_N2_2prime_O_trimethylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1849, 0, 0);
INSERT INTO chado.cvterm VALUES (1678, 23, 'two_prime_O_ribosylguanosine_phosphate', '2prime_O_ribosylguanosine_phosphate is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1851, 0, 0);
INSERT INTO chado.cvterm VALUES (1679, 23, 'wybutosine', 'Wybutosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1853, 0, 0);
INSERT INTO chado.cvterm VALUES (1680, 23, 'peroxywybutosine', 'Peroxywybutosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1855, 0, 0);
INSERT INTO chado.cvterm VALUES (1681, 23, 'hydroxywybutosine', 'Hydroxywybutosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1857, 0, 0);
INSERT INTO chado.cvterm VALUES (1682, 23, 'undermodified_hydroxywybutosine', 'Undermodified_hydroxywybutosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1859, 0, 0);
INSERT INTO chado.cvterm VALUES (1683, 23, 'wyosine', 'Wyosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1861, 0, 0);
INSERT INTO chado.cvterm VALUES (1684, 23, 'methylwyosine', 'Methylwyosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1863, 0, 0);
INSERT INTO chado.cvterm VALUES (1685, 23, 'N2_7_dimethylguanosine', 'N2_7_dimethylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1865, 0, 0);
INSERT INTO chado.cvterm VALUES (1686, 23, 'N2_N2_7_trimethylguanosine', 'N2_N2_7_trimethylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1867, 0, 0);
INSERT INTO chado.cvterm VALUES (1687, 23, 'one_two_prime_O_dimethylguanosine', '1_2prime_O_dimethylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1869, 0, 0);
INSERT INTO chado.cvterm VALUES (1688, 23, 'four_demethylwyosine', '4_demethylwyosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1871, 0, 0);
INSERT INTO chado.cvterm VALUES (1689, 23, 'isowyosine', 'Isowyosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1873, 0, 0);
INSERT INTO chado.cvterm VALUES (1690, 23, 'N2_7_2prirme_O_trimethylguanosine', 'N2_7_2prirme_O_trimethylguanosine is a modified guanosine base feature. [http://library.med.utah.edu/RNAmods/]', 1875, 0, 0);
INSERT INTO chado.cvterm VALUES (1691, 23, 'five_methyluridine', '5_methyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1877, 0, 0);
INSERT INTO chado.cvterm VALUES (1692, 23, 'two_prime_O_methyluridine', '2prime_O_methyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1879, 0, 0);
INSERT INTO chado.cvterm VALUES (1693, 23, 'five_two_prime_O_dimethyluridine', '5_2_prime_O_dimethyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1881, 0, 0);
INSERT INTO chado.cvterm VALUES (1694, 23, 'one_methylpseudouridine', '1_methylpseudouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1883, 0, 0);
INSERT INTO chado.cvterm VALUES (1695, 23, 'two_prime_O_methylpseudouridine', '2prime_O_methylpseudouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1885, 0, 0);
INSERT INTO chado.cvterm VALUES (1696, 23, 'two_thiouridine', '2_thiouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1887, 0, 0);
INSERT INTO chado.cvterm VALUES (1697, 23, 'four_thiouridine', '4_thiouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1889, 0, 0);
INSERT INTO chado.cvterm VALUES (1698, 23, 'five_methyl_2_thiouridine', '5_methyl_2_thiouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1891, 0, 0);
INSERT INTO chado.cvterm VALUES (1699, 23, 'two_thio_two_prime_O_methyluridine', '2_thio_2prime_O_methyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1893, 0, 0);
INSERT INTO chado.cvterm VALUES (1700, 23, 'three_three_amino_three_carboxypropyl_uridine', '3_3_amino_3_carboxypropyl_uridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1895, 0, 0);
INSERT INTO chado.cvterm VALUES (1701, 23, 'five_hydroxyuridine', '5_hydroxyuridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1897, 0, 0);
INSERT INTO chado.cvterm VALUES (1702, 23, 'five_methoxyuridine', '5_methoxyuridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1898, 0, 0);
INSERT INTO chado.cvterm VALUES (1703, 23, 'uridine_five_oxyacetic_acid', 'Uridine_5_oxyacetic_acid is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1900, 0, 0);
INSERT INTO chado.cvterm VALUES (1704, 23, 'uridine_five_oxyacetic_acid_methyl_ester', 'Uridine_5_oxyacetic_acid_methyl_ester is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1902, 0, 0);
INSERT INTO chado.cvterm VALUES (1705, 23, 'five_carboxyhydroxymethyl_uridine', '5_carboxyhydroxymethyl_uridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1904, 0, 0);
INSERT INTO chado.cvterm VALUES (1706, 23, 'five_carboxyhydroxymethyl_uridine_methyl_ester', '5_carboxyhydroxymethyl_uridine_methyl_ester is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1906, 0, 0);
INSERT INTO chado.cvterm VALUES (1707, 23, 'five_methoxycarbonylmethyluridine', 'Five_methoxycarbonylmethyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1908, 0, 0);
INSERT INTO chado.cvterm VALUES (1708, 23, 'five_methoxycarbonylmethyl_two_prime_O_methyluridine', 'Five_methoxycarbonylmethyl_2_prime_O_methyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1910, 0, 0);
INSERT INTO chado.cvterm VALUES (1709, 23, 'five_methoxycarbonylmethyl_two_thiouridine', '5_methoxycarbonylmethyl_2_thiouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1912, 0, 0);
INSERT INTO chado.cvterm VALUES (1710, 23, 'five_aminomethyl_two_thiouridine', '5_aminomethyl_2_thiouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1914, 0, 0);
INSERT INTO chado.cvterm VALUES (1711, 23, 'five_methylaminomethyluridine', '5_methylaminomethyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1916, 0, 0);
INSERT INTO chado.cvterm VALUES (1712, 23, 'five_methylaminomethyl_two_thiouridine', '5_methylaminomethyl_2_thiouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1918, 0, 0);
INSERT INTO chado.cvterm VALUES (1713, 23, 'five_methylaminomethyl_two_selenouridine', '5_methylaminomethyl_2_selenouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1920, 0, 0);
INSERT INTO chado.cvterm VALUES (1714, 23, 'five_carbamoylmethyluridine', '5_carbamoylmethyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1922, 0, 0);
INSERT INTO chado.cvterm VALUES (1715, 23, 'five_carbamoylmethyl_two_prime_O_methyluridine', '5_carbamoylmethyl_2_prime_O_methyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1924, 0, 0);
INSERT INTO chado.cvterm VALUES (1716, 23, 'five_carboxymethylaminomethyluridine', '5_carboxymethylaminomethyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1926, 0, 0);
INSERT INTO chado.cvterm VALUES (1717, 23, 'five_carboxymethylaminomethyl_two_prime_O_methyluridine', '5_carboxymethylaminomethyl_2_prime_O_methyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1928, 0, 0);
INSERT INTO chado.cvterm VALUES (1718, 23, 'five_carboxymethylaminomethyl_two_thiouridine', '5_carboxymethylaminomethyl_2_thiouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1930, 0, 0);
INSERT INTO chado.cvterm VALUES (1719, 23, 'three_methyluridine', '3_methyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1932, 0, 0);
INSERT INTO chado.cvterm VALUES (1720, 23, 'one_methyl_three_three_amino_three_carboxypropyl_pseudouridine', '1_methyl_3_3_amino_3_carboxypropyl_pseudouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1934, 0, 0);
INSERT INTO chado.cvterm VALUES (1721, 23, 'five_carboxymethyluridine', '5_carboxymethyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1936, 0, 0);
INSERT INTO chado.cvterm VALUES (1722, 23, 'three_two_prime_O_dimethyluridine', '3_2prime_O_dimethyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1938, 0, 0);
INSERT INTO chado.cvterm VALUES (1723, 23, 'five_methyldihydrouridine', '5_methyldihydrouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1940, 0, 0);
INSERT INTO chado.cvterm VALUES (1724, 23, 'three_methylpseudouridine', '3_methylpseudouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1942, 0, 0);
INSERT INTO chado.cvterm VALUES (1725, 23, 'five_taurinomethyluridine', '5_taurinomethyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1944, 0, 0);
INSERT INTO chado.cvterm VALUES (1726, 23, 'five_taurinomethyl_two_thiouridine', '5_taurinomethyl_2_thiouridineis a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1946, 0, 0);
INSERT INTO chado.cvterm VALUES (1727, 23, 'five_isopentenylaminomethyl_uridine', '5_isopentenylaminomethyl_uridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1948, 0, 0);
INSERT INTO chado.cvterm VALUES (1728, 23, 'five_isopentenylaminomethyl_two_thiouridine', '5_isopentenylaminomethyl_2_thiouridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1950, 0, 0);
INSERT INTO chado.cvterm VALUES (1729, 23, 'five_isopentenylaminomethyl_two_prime_O_methyluridine', '5_isopentenylaminomethyl_2prime_O_methyluridine is a modified uridine base feature. [http://library.med.utah.edu/RNAmods/]', 1952, 0, 0);
INSERT INTO chado.cvterm VALUES (1730, 23, 'histone_binding_site', 'A binding site that, in the nucleotide molecule, interacts selectively and non-covalently with polypeptide residues of a histone. [SO:ke]', 1954, 0, 0);
INSERT INTO chado.cvterm VALUES (1731, 23, 'CDS_fragment', 'A portion of a CDS that is not the complete CDS. []', 1955, 0, 0);
INSERT INTO chado.cvterm VALUES (1732, 23, 'modified_amino_acid_feature', 'A post translationally modified amino acid feature. [SO:ke]', 1956, 0, 0);
INSERT INTO chado.cvterm VALUES (1733, 23, 'modified_glycine', 'A post translationally modified glycine amino acid feature. [SO:ke]', 1957, 0, 0);
INSERT INTO chado.cvterm VALUES (1734, 23, 'modified_L_alanine', 'A post translationally modified alanine amino acid feature. [SO:ke]', 1959, 0, 0);
INSERT INTO chado.cvterm VALUES (1735, 23, 'modified_L_asparagine', 'A post translationally modified asparagine amino acid feature. [SO:ke]', 1961, 0, 0);
INSERT INTO chado.cvterm VALUES (1736, 23, 'modified_L_aspartic_acid', 'A post translationally modified aspartic acid amino acid feature. [SO:ke]', 1963, 0, 0);
INSERT INTO chado.cvterm VALUES (1737, 23, 'modified_L_cysteine', 'A post translationally modified cysteine amino acid feature. [SO:ke]', 1965, 0, 0);
INSERT INTO chado.cvterm VALUES (1738, 23, 'modified_L_glutamic_acid', 'A post translationally modified glutamic acid. []', 1967, 0, 0);
INSERT INTO chado.cvterm VALUES (1739, 23, 'modified_L_threonine', 'A post translationally modified threonine amino acid feature. [SO:ke]', 1969, 0, 0);
INSERT INTO chado.cvterm VALUES (1740, 23, 'modified_L_tryptophan', 'A post translationally modified tryptophan amino acid feature. [SO:ke]', 1971, 0, 0);
INSERT INTO chado.cvterm VALUES (1741, 23, 'modified_L_glutamine', 'A post translationally modified glutamine amino acid feature. [SO:ke]', 1973, 0, 0);
INSERT INTO chado.cvterm VALUES (1742, 23, 'modified_L_methionine', 'A post translationally modified methionine amino acid feature. [SO:ke]', 1975, 0, 0);
INSERT INTO chado.cvterm VALUES (1743, 23, 'modified_L_isoleucine', 'A post translationally modified isoleucine amino acid feature. [SO:ke]', 1977, 0, 0);
INSERT INTO chado.cvterm VALUES (1744, 23, 'modified_L_phenylalanine', 'A post translationally modified phenylalanine amino acid feature. [SO:ke]', 1979, 0, 0);
INSERT INTO chado.cvterm VALUES (1745, 23, 'modified_L_histidine', 'A post translationally modified histidine amino acid feature. [SO:ke]', 1981, 0, 0);
INSERT INTO chado.cvterm VALUES (1746, 23, 'modified_L_serine', 'A post translationally modified serine amino acid feature. [SO:ke]', 1983, 0, 0);
INSERT INTO chado.cvterm VALUES (1747, 23, 'modified_L_lysine', 'A post translationally modified lysine amino acid feature. [SO:ke]', 1985, 0, 0);
INSERT INTO chado.cvterm VALUES (1748, 23, 'modified_L_leucine', 'A post translationally modified leucine amino acid feature. [SO:ke]', 1987, 0, 0);
INSERT INTO chado.cvterm VALUES (1749, 23, 'modified_L_selenocysteine', 'A post translationally modified selenocysteine amino acid feature. [SO:ke]', 1989, 0, 0);
INSERT INTO chado.cvterm VALUES (1750, 23, 'modified_L_valine', 'A post translationally modified valine amino acid feature. [SO:ke]', 1991, 0, 0);
INSERT INTO chado.cvterm VALUES (1751, 23, 'modified_L_proline', 'A post translationally modified proline amino acid feature. [SO:ke]', 1993, 0, 0);
INSERT INTO chado.cvterm VALUES (1752, 23, 'modified_L_tyrosine', 'A post translationally modified tyrosine amino acid feature. [SO:ke]', 1995, 0, 0);
INSERT INTO chado.cvterm VALUES (1753, 23, 'modified_L_arginine', 'A post translationally modified arginine amino acid feature. [SO:ke]', 1997, 0, 0);
INSERT INTO chado.cvterm VALUES (1754, 23, 'peptidyl', 'An attribute describing the nature of a proteinaceous polymer, where by the amino acid units are joined by peptide bonds. [SO:ke]', 1999, 0, 0);
INSERT INTO chado.cvterm VALUES (1755, 23, 'cleaved_for_gpi_anchor_region', 'The C-terminal residues of a polypeptide which are exchanged for a GPI-anchor. [EBI:rh]', 2000, 0, 0);
INSERT INTO chado.cvterm VALUES (1756, 23, 'translocation_breakpoint', 'The point within a chromosome where a translocation begins or ends. [SO:cb]', 2001, 0, 0);
INSERT INTO chado.cvterm VALUES (1757, 23, 'insertion_breakpoint', 'The point within a chromosome where a insertion begins or ends. [SO:cb]', 2002, 0, 0);
INSERT INTO chado.cvterm VALUES (1758, 23, 'deletion_breakpoint', 'The point within a chromosome where a deletion begins or ends. [SO:cb]', 2003, 0, 0);
INSERT INTO chado.cvterm VALUES (1759, 23, 'five_prime_flanking_region', 'A flanking region located five prime of a specific region. [SO:chado]', 2004, 0, 0);
INSERT INTO chado.cvterm VALUES (1760, 23, 'three_prime_flanking_region', 'A flanking region located three prime of a specific region. [SO:chado]', 2005, 0, 0);
INSERT INTO chado.cvterm VALUES (1761, 23, 'transcribed_fragment', 'An experimental region, defined by a tiling array experiment to be transcribed at some level. [SO:ke]', 2006, 0, 0);
INSERT INTO chado.cvterm VALUES (1762, 23, 'splice_junction', 'The boundary between an intron and an exon. [SO:ke]', 2007, 0, 0);
INSERT INTO chado.cvterm VALUES (1763, 23, 'conformational_switch', 'A region of a polypeptide, involved in the transition from one conformational state to another. [SO:ke]', 2008, 0, 0);
INSERT INTO chado.cvterm VALUES (1764, 23, 'dye_terminator_read', 'A read produced by the dye terminator method of sequencing. [SO:ke]', 2009, 0, 0);
INSERT INTO chado.cvterm VALUES (1765, 23, 'pyrosequenced_read', 'A read produced by pyrosequencing technology. [SO:ke]', 2010, 0, 0);
INSERT INTO chado.cvterm VALUES (1766, 23, 'ligation_based_read', 'A read produced by ligation based sequencing technologies. [SO:ke]', 2011, 0, 0);
INSERT INTO chado.cvterm VALUES (1767, 23, 'polymerase_synthesis_read', 'A read produced by the polymerase based sequence by synthesis method. [SO:ke]', 2012, 0, 0);
INSERT INTO chado.cvterm VALUES (1768, 23, 'cis_regulatory_frameshift_element', 'A structural region in an RNA molecule which promotes ribosomal frameshifting of cis coding sequence. [RFAM:jd]', 2013, 0, 0);
INSERT INTO chado.cvterm VALUES (1769, 23, 'expressed_sequence_assembly', 'A sequence assembly derived from expressed sequences. [SO:ke]', 2014, 0, 0);
INSERT INTO chado.cvterm VALUES (1770, 23, 'DNA_binding_site', 'A binding site that, in the molecule, interacts selectively and non-covalently with DNA. [SO:ke]', 2015, 0, 0);
INSERT INTO chado.cvterm VALUES (1771, 23, 'cryptic_gene', 'A gene that is not transcribed under normal conditions and is not critical to normal cellular functioning. [SO:ke]', 2016, 0, 0);
INSERT INTO chado.cvterm VALUES (1772, 23, 'sequence_variant_affecting_polyadenylation', '', 2017, 1, 0);
INSERT INTO chado.cvterm VALUES (1773, 23, 'three_prime_RACE_clone', 'A three prime RACE (Rapid Amplification of cDNA Ends) clone is a cDNA clone copied from the 3'' end of an mRNA (using a poly-dT primer to capture the polyA tail and a gene-specific or randomly primed 5'' primer), and spliced into a vector for propagation in a suitable host. [modENCODE:nlw]', 2018, 0, 0);
INSERT INTO chado.cvterm VALUES (1774, 23, 'cassette_pseudogene', 'A cassette pseudogene is a kind of gene in an inactive form which may recombine at a telomeric locus to form a functional copy. [SO:ke]', 2019, 0, 0);
INSERT INTO chado.cvterm VALUES (1775, 23, 'alanine', 'A non-polar, hydorophobic amino acid encoded by the codons GCN (GCT, GCC, GCA and GCG). []', 2020, 0, 0);
INSERT INTO chado.cvterm VALUES (1776, 23, 'valine', 'A non-polar, hydorophobic amino acid encoded by the codons GTN (GTT, GTC, GTA and GTG). []', 2021, 0, 0);
INSERT INTO chado.cvterm VALUES (1777, 23, 'leucine', 'A non-polar, hydorophobic amino acid encoded by the codons CTN (CTT, CTC, CTA and CTG), TTA and TTG. []', 2022, 0, 0);
INSERT INTO chado.cvterm VALUES (1778, 23, 'isoleucine', 'A non-polar, hydorophobic amino acid encoded by the codons ATH (ATT, ATC and ATA). []', 2023, 0, 0);
INSERT INTO chado.cvterm VALUES (1779, 23, 'proline', 'A non-polar, hydorophobic amino acid encoded by the codons CCN (CCT, CCC, CCA and CCG). []', 2024, 0, 0);
INSERT INTO chado.cvterm VALUES (1780, 23, 'tryptophan', 'A non-polar, hydorophobic amino acid encoded by the codon TGG. []', 2025, 0, 0);
INSERT INTO chado.cvterm VALUES (1781, 23, 'phenylalanine', 'A non-polar, hydorophobic amino acid encoded by the codons TTT and TTC. []', 2026, 0, 0);
INSERT INTO chado.cvterm VALUES (1782, 23, 'methionine', 'A non-polar, hydorophobic amino acid encoded by the codon ATG. []', 2027, 0, 0);
INSERT INTO chado.cvterm VALUES (1783, 23, 'glycine', 'A non-polar, hydorophilic amino acid encoded by the codons GGN (GGT, GGC, GGA and GGG). []', 2028, 0, 0);
INSERT INTO chado.cvterm VALUES (1784, 23, 'serine', 'A polar, hydorophilic amino acid encoded by the codons TCN (TCT, TCC, TCA, TCG), AGT and AGC. []', 2029, 0, 0);
INSERT INTO chado.cvterm VALUES (1785, 23, 'threonine', 'A polar, hydorophilic amino acid encoded by the codons ACN (ACT, ACC, ACA and ACG). []', 2030, 0, 0);
INSERT INTO chado.cvterm VALUES (1786, 23, 'tyrosine', 'A polar, hydorophilic amino acid encoded by the codons TAT and TAC. []', 2031, 0, 0);
INSERT INTO chado.cvterm VALUES (1787, 23, 'cysteine', 'A polar amino acid encoded by the codons TGT and TGC. []', 2032, 0, 0);
INSERT INTO chado.cvterm VALUES (1788, 23, 'glutamine', 'A polar, hydorophilic amino acid encoded by the codons CAA and CAG.  []', 2033, 0, 0);
INSERT INTO chado.cvterm VALUES (1789, 23, 'asparagine', 'A polar, hydorophilic amino acid encoded by the codons AAT and AAC. []', 2034, 0, 0);
INSERT INTO chado.cvterm VALUES (1790, 23, 'lysine', 'A positively charged, hydorophilic amino acid encoded by the codons AAA and AAG. []', 2035, 0, 0);
INSERT INTO chado.cvterm VALUES (1791, 23, 'arginine', 'A positively charged, hydorophilic amino acid encoded by the codons CGN (CGT, CGC, CGA and CGG), AGA and AGG. []', 2036, 0, 0);
INSERT INTO chado.cvterm VALUES (1792, 23, 'histidine', 'A positively charged, hydorophilic amino acid encoded by the codons CAT and CAC. []', 2037, 0, 0);
INSERT INTO chado.cvterm VALUES (1793, 23, 'aspartic_acid', 'A negatively charged, hydorophilic amino acid encoded by the codons GAT and GAC. []', 2038, 0, 0);
INSERT INTO chado.cvterm VALUES (1794, 23, 'glutamic_acid', 'A negatively charged, hydorophilic amino acid encoded by the codons GAA and GAG. []', 2039, 0, 0);
INSERT INTO chado.cvterm VALUES (1795, 23, 'selenocysteine', 'A relatively rare amino acid encoded by the codon UGA in some contexts, whereas UGA is a termination codon in other contexts. [PMID:23275319]', 2040, 0, 0);
INSERT INTO chado.cvterm VALUES (1796, 23, 'pyrrolysine', 'A relatively rare amino acid encoded by the codon UAG in some contexts, whereas UAG is a termination codon in other contexts. [PMID:15788401]', 2041, 0, 0);
INSERT INTO chado.cvterm VALUES (1797, 23, 'transcribed_cluster', 'A region defined by a set of transcribed sequences from the same gene or expressed pseudogene. [SO:ke]', 2042, 0, 0);
INSERT INTO chado.cvterm VALUES (1798, 23, 'unigene_cluster', 'A kind of transcribed_cluster defined by a set of transcribed sequences from the a unique gene. [SO:ke]', 2043, 0, 0);
INSERT INTO chado.cvterm VALUES (1799, 23, 'CRISPR', 'Clustered Palindromic Repeats interspersed with bacteriophage derived spacer sequences. [RFAM:jd]', 2044, 0, 0);
INSERT INTO chado.cvterm VALUES (1800, 23, 'insulator_binding_site', 'A binding site that, in an insulator region of a nucleotide molecule, interacts selectively and non-covalently with polypeptide residues. [SO:ke]', 2045, 0, 0);
INSERT INTO chado.cvterm VALUES (1801, 23, 'enhancer_binding_site', 'A binding site that, in the enhancer region of a nucleotide molecule, interacts selectively and non-covalently with polypeptide residues. [SO:ke]', 2046, 0, 0);
INSERT INTO chado.cvterm VALUES (1802, 23, 'contig_collection', 'A collection of contigs. [SO:ke]', 2047, 0, 0);
INSERT INTO chado.cvterm VALUES (1803, 23, 'lincRNA', 'Long, intervening non-coding RNA. A transcript that does not overlap within the start or end genomic coordinates of a coding gene or pseudogene on either strand. [http://www.gencodegenes.org/gencode_biotypes.html, PMID:19182780, PMID:23463798, SO:ke]', 2048, 0, 0);
INSERT INTO chado.cvterm VALUES (1804, 23, 'lncRNA', 'A non-coding RNA generally longer than 200 nucleotides that cannot be classified as any other ncRNA subtype. Similar to mRNAs, lncRNAs are mainly transcribed by RNA polymerase II, are often capped by 7-methyl guanosine at their 5'' ends, polyadenylated at their 3'' ends and may be spliced." [HGNC:mw] {comment="PMID:33353982}', 2049, 0, 0);
INSERT INTO chado.cvterm VALUES (1805, 23, 'UST', 'An EST spanning part or all of the untranslated regions of a protein-coding transcript. [SO:nlw]', 2050, 0, 0);
INSERT INTO chado.cvterm VALUES (1806, 23, 'three_prime_UST', 'A UST located in the 3''UTR of a protein-coding transcript. [SO:nlw]', 2051, 0, 0);
INSERT INTO chado.cvterm VALUES (1807, 23, 'five_prime_UST', 'An UST located in the 5''UTR of a protein-coding transcript. [SO:nlw]', 2052, 0, 0);
INSERT INTO chado.cvterm VALUES (1808, 23, 'RST', 'A tag produced from a single sequencing read from a RACE product; typically a few hundred base pairs long. [SO:nlw]', 2053, 0, 0);
INSERT INTO chado.cvterm VALUES (1809, 23, 'three_prime_RST', 'A tag produced from a single sequencing read from a 3''-RACE product; typically a few hundred base pairs long. [SO:nlw]', 2054, 0, 0);
INSERT INTO chado.cvterm VALUES (1810, 23, 'five_prime_RST', 'A tag produced from a single sequencing read from a 5''-RACE product; typically a few hundred base pairs long. [SO:nlw]', 2055, 0, 0);
INSERT INTO chado.cvterm VALUES (1811, 23, 'UST_match', 'A match against an UST sequence. [SO:nlw]', 2056, 0, 0);
INSERT INTO chado.cvterm VALUES (1812, 23, 'RST_match', 'A match against an RST sequence. [SO:nlw]', 2057, 0, 0);
INSERT INTO chado.cvterm VALUES (1813, 23, 'primer_match', 'A nucleotide match to a primer sequence. [SO:nlw]', 2058, 0, 0);
INSERT INTO chado.cvterm VALUES (1814, 23, 'miRNA_antiguide', 'A region of the pri miRNA that base pairs with the guide to form the hairpin. [SO:ke]', 2059, 0, 0);
INSERT INTO chado.cvterm VALUES (1815, 23, 'trans_splice_junction', 'The boundary between the spliced leader and the first exon of the mRNA. [SO:ke]', 2060, 0, 0);
INSERT INTO chado.cvterm VALUES (1816, 23, 'outron', 'A region of a primary transcript, that is removed via trans splicing. [PMID:16401417, SO:ke]', 2061, 0, 0);
INSERT INTO chado.cvterm VALUES (1817, 23, 'natural_plasmid', 'A plasmid that occurs naturally. [SO:xp]', 2062, 0, 0);
INSERT INTO chado.cvterm VALUES (1818, 23, 'gene_trap_construct', 'A gene trap construct is a type of engineered plasmid which is designed to integrate into a genome and produce a fusion transcript between exons of the gene into which it inserts and a reporter element in the construct. Gene traps contain a splice acceptor, do not contain promoter elements for the reporter, and are mutagenic. Gene traps may be bicistronic with the second cassette containing a promoter driving an a selectable marker. [ZFIN:dh]', 2063, 0, 0);
INSERT INTO chado.cvterm VALUES (1819, 23, 'promoter_trap_construct', 'A promoter trap construct is a type of engineered plasmid which is designed to integrate into a genome and express a reporter when inserted in close proximity to a promoter element. Promoter traps typically do not contain promoter elements and are mutagenic. [ZFIN:dh]', 2064, 0, 0);
INSERT INTO chado.cvterm VALUES (1820, 23, 'enhancer_trap_construct', 'An enhancer trap construct is a type of engineered plasmid which is designed to integrate into a genome and express a reporter when the expression from a basic minimal promoter is enhanced by genomic enhancer elements. Enhancer traps contain promoter elements and are not usually mutagenic. [ZFIN:dh]', 2065, 0, 0);
INSERT INTO chado.cvterm VALUES (1821, 23, 'PAC_end', 'A region of sequence from the end of a PAC clone that may provide a highly specific marker. [ZFIN:mh]', 2066, 0, 0);
INSERT INTO chado.cvterm VALUES (1822, 23, 'RAPD', 'RAPD is a ''PCR product'' where a sequence variant is identified through the use of PCR with random primers. [ZFIN:mh]', 2067, 0, 0);
INSERT INTO chado.cvterm VALUES (1823, 23, 'shadow_enhancer', 'An enhancer that drives the pattern of transcription and binds to the same TF as the primary enhancer, but is located in the intron of or on the far side of a neighboring gene. [PMID:22083793]', 2068, 0, 0);
INSERT INTO chado.cvterm VALUES (1824, 23, 'substitution', 'A sequence alteration where the length of the change in the variant is the same as that of the reference. [SO:ke]', 2069, 0, 0);
INSERT INTO chado.cvterm VALUES (1825, 23, 'X_element_combinatorial_repeat', 'An X element combinatorial repeat is a repeat region located between the X element and the telomere or adjacent Y'' element. [http://www.yeastgenome.org/help/glossary.html]', 2070, 0, 0);
INSERT INTO chado.cvterm VALUES (1826, 23, 'Y_prime_element', 'A Y'' element is a repeat region (SO:0000657) located adjacent to telomeric repeats or X element combinatorial repeats, either as a single copy or tandem repeat of two to four copies. [http:http\://www.yeastgenome.org/help/glossary.html]', 2071, 0, 0);
INSERT INTO chado.cvterm VALUES (1827, 23, 'standard_draft', 'The status of a whole genome sequence, where the data is minimally filtered or un-filtered, from any number of sequencing platforms, and is assembled into contigs. Genome sequence of this quality may harbour regions of poor quality and can be relatively incomplete. [DOI:10.1126]', 2072, 0, 0);
INSERT INTO chado.cvterm VALUES (1828, 23, 'whole_genome_sequence_status', 'The status of whole genome sequence. [DOI:10.1126]', 2073, 0, 0);
INSERT INTO chado.cvterm VALUES (1829, 23, 'high_quality_draft', 'The status of a whole genome sequence, where overall coverage represents at least 90 percent of the genome. [DOI:10.1126]', 2074, 0, 0);
INSERT INTO chado.cvterm VALUES (1830, 23, 'improved_high_quality_draft', 'The status of a whole genome sequence, where additional work has been performed, using either manual or automated methods, such as gap resolution. [DOI:10.1126]', 2075, 0, 0);
INSERT INTO chado.cvterm VALUES (1831, 23, 'annotation_directed_improved_draft', 'The status of a whole genome sequence,where annotation, and verification of coding regions has occurred. [DOI:10.1126]', 2076, 0, 0);
INSERT INTO chado.cvterm VALUES (1832, 23, 'noncontiguous_finished', 'The status of a whole genome sequence, where the assembly is high quality, closure approaches have been successful for most gaps, misassemblies and low quality regions. [DOI:10.1126]', 2077, 0, 0);
INSERT INTO chado.cvterm VALUES (2104, 23, 'benign_variant', 'A variant that does not affect the function of the gene or cause disease. []', 2359, 0, 0);
INSERT INTO chado.cvterm VALUES (1833, 23, 'finished_genome', 'The status of a whole genome sequence, with less than 1 error per 100,000 base pairs. [DOI:10.1126]', 2078, 0, 0);
INSERT INTO chado.cvterm VALUES (1834, 23, 'intronic_regulatory_region', 'A regulatory region that is part of an intron. [SO:ke]', 2079, 0, 0);
INSERT INTO chado.cvterm VALUES (1835, 23, 'centromere_DNA_Element_I', 'A centromere DNA Element I (CDEI) is a conserved region, part of the centromere, consisting of a consensus region composed of 8-11bp which enables binding by the centromere binding factor 1(Cbf1p). [PMID:11222754]', 2080, 0, 0);
INSERT INTO chado.cvterm VALUES (1836, 23, 'point_centromere', 'A point centromere is a relatively small centromere (about 125 bp DNA) in discrete sequence, found in some yeast including S. cerevisiae. [PMID:7502067, SO:vw]', 2081, 0, 0);
INSERT INTO chado.cvterm VALUES (1837, 23, 'centromere_DNA_Element_II', 'A centromere DNA Element II (CDEII) is part a conserved region of the centromere, consisting of a consensus region that is AT-rich and ~ 75-100 bp in length. [PMID:11222754]', 2082, 0, 0);
INSERT INTO chado.cvterm VALUES (1838, 23, 'centromere_DNA_Element_III', 'A centromere DNA Element I (CDEI) is a conserved region, part of the centromere, consisting of a consensus region that consists of a 25-bp which enables binding by the centromere DNA binding factor 3 (CBF3) complex. [PMID:11222754]', 2083, 0, 0);
INSERT INTO chado.cvterm VALUES (1839, 23, 'telomeric_repeat', 'The telomeric repeat is a repeat region, part of the chromosome, which in yeast, is a G-rich terminal sequence of the form (TG(1-3))n or more precisely ((TG)(1-6)TG(2-3))n. [PMID:8720065]', 2084, 0, 0);
INSERT INTO chado.cvterm VALUES (1840, 23, 'X_element', 'The X element is a conserved region, of the telomere, of ~475 bp that contains an ARS sequence and in most cases an Abf1p binding site. [http://www.yeastgenome.org/help/glossary.html#xelemcoresequence, PMID:7785338, PMID:8005434]', 2085, 0, 0);
INSERT INTO chado.cvterm VALUES (1841, 23, 'YAC_end', 'A region of sequence from the end of a YAC clone that may provide a highly specific marker. [SO:ke]', 2086, 0, 0);
INSERT INTO chado.cvterm VALUES (190, 23, 'heritable_phenotypic_marker', 'A biological_region characterized as a single heritable trait in a phenotype screen. The heritable phenotype may be mapped to a chromosome but generally has not been characterized to a specific gene locus. [JAX:hdene]', 190, 0, 0);
INSERT INTO chado.cvterm VALUES (1842, 23, 'peptide_collection', 'A collection of peptide sequences. [BBOP:nlw]', 2087, 0, 0);
INSERT INTO chado.cvterm VALUES (1843, 23, 'high_identity_region', 'An experimental feature with high sequence identity to another sequence. [SO:ke]', 2088, 0, 0);
INSERT INTO chado.cvterm VALUES (1844, 23, 'processed_transcript', 'A transcript for which no open reading frame has been identified and for which no other function has been determined. [MGI:hdeen]', 2089, 0, 0);
INSERT INTO chado.cvterm VALUES (1845, 23, 'reference_genome', 'A collection of sequences (often chromosomes) taken as the standard for a given organism and genome assembly. [SO:ke]', 2090, 0, 0);
INSERT INTO chado.cvterm VALUES (1846, 23, 'variant_genome', 'A collection of sequences (often chromosomes) of an individual. [SO:ke]', 2091, 0, 0);
INSERT INTO chado.cvterm VALUES (1847, 23, 'alteration_attribute', 'An attribute of alteration of one or more chromosomes. []', 2092, 0, 0);
INSERT INTO chado.cvterm VALUES (1848, 23, 'chromosomal_variation_attribute', 'An attribute of a change in the structure or number of a chromosomes. []', 2093, 0, 0);
INSERT INTO chado.cvterm VALUES (1849, 23, 'intrachromosomal', 'A change in chromosomes that occurs between two separate chromosomes. []', 2094, 0, 0);
INSERT INTO chado.cvterm VALUES (1850, 23, 'interchromosomal', 'A change in chromosomes that occurs between two sections of the same chromosome or between homologous chromosomes. []', 2095, 0, 0);
INSERT INTO chado.cvterm VALUES (1851, 23, 'insertion_attribute', 'A quality of a chromosomal insertion,. [SO:ke]', 2096, 0, 0);
INSERT INTO chado.cvterm VALUES (1852, 23, 'tandem', 'An insertion of extension of a tandem repeat. []', 2097, 0, 0);
INSERT INTO chado.cvterm VALUES (1853, 23, 'direct', 'A quality of an insertion where the insert is not in a cytologically inverted orientation. [SO:ke]', 2098, 0, 0);
INSERT INTO chado.cvterm VALUES (1854, 23, 'inverted', 'A quality of an insertion where the insert is in a cytologically inverted orientation. [SO:ke]', 2099, 0, 0);
INSERT INTO chado.cvterm VALUES (1855, 23, 'free', 'The quality of a duplication where the new region exists independently of the original. [SO:ke]', 2100, 0, 0);
INSERT INTO chado.cvterm VALUES (1856, 23, 'duplication_attribute', 'An attribute of a duplication, which is an insertion which derives from, or is identical in sequence to, nucleotides present at a known location in the genome. []', 2101, 0, 0);
INSERT INTO chado.cvterm VALUES (1857, 23, 'inversion_attribute', 'When a region of a chromosome is changed to the reverse order without duplication or deletion. []', 2102, 0, 0);
INSERT INTO chado.cvterm VALUES (1858, 23, 'pericentric', 'An inversion event that includes the centromere. []', 2103, 0, 0);
INSERT INTO chado.cvterm VALUES (1859, 23, 'paracentric', 'An inversion event that does not include the centromere. []', 2104, 0, 0);
INSERT INTO chado.cvterm VALUES (1860, 23, 'translocaton_attribute', 'An attribute of a translocation, which is then a region of nucleotide sequence that has translocated to a new position. The observed adjacency of two previously separated regions. []', 2105, 0, 0);
INSERT INTO chado.cvterm VALUES (1861, 23, 'reciprocal', 'When translocation occurs between nonhomologous chromosomes and involved an equal exchange of genetic materials. []', 2106, 0, 0);
INSERT INTO chado.cvterm VALUES (1862, 23, 'insertional', 'When a translocation is simply moving genetic material from one chromosome to another. []', 2107, 0, 0);
INSERT INTO chado.cvterm VALUES (1863, 23, 'assembly_error_correction', 'A region of sequence where the final nucleotide assignment differs from the original assembly due to an improvement that replaces a mistake. [SO:ke]', 2108, 0, 0);
INSERT INTO chado.cvterm VALUES (1864, 23, 'base_call_error_correction', 'A region of sequence where the final nucleotide assignment is different from that given by the base caller due to an improvement that replaces a mistake. [SO:ke]', 2109, 0, 0);
INSERT INTO chado.cvterm VALUES (1865, 23, 'nuclear_localization_signal', 'A polypeptide region that targets a polypeptide to the nucleus. [SO:ke]', 2110, 0, 0);
INSERT INTO chado.cvterm VALUES (1866, 23, 'endosomal_localization_signal', 'A polypeptide region that targets a polypeptide to the endosome. [SO:ke]', 2111, 0, 0);
INSERT INTO chado.cvterm VALUES (1867, 23, 'lysosomal_localization_signal', 'A polypeptide region that targets a polypeptide to the lysosome. [SO:ke]', 2112, 0, 0);
INSERT INTO chado.cvterm VALUES (1868, 23, 'nuclear_export_signal', 'A polypeptide region that targets a polypeptide to he cytoplasm. [SO:ke]', 2113, 0, 0);
INSERT INTO chado.cvterm VALUES (1869, 23, 'recombination_signal_sequence', 'A region recognized by a recombinase. [SO:ke]', 2114, 0, 0);
INSERT INTO chado.cvterm VALUES (1870, 23, 'cryptic_splice_site', 'A splice site that is in part of the transcript not normally spliced. They occur via mutation or transcriptional error. [SO:ke]', 2115, 0, 0);
INSERT INTO chado.cvterm VALUES (1871, 23, 'nuclear_rim_localization_signal', 'A polypeptide region that targets a polypeptide to the nuclear rim. [SO:ke]', 2116, 0, 0);
INSERT INTO chado.cvterm VALUES (1913, 23, 'cryptic_splice_acceptor', 'A sequence variant whereby a new splice site is created due to the activation of a new acceptor. [SO:ke]', 2159, 0, 0);
INSERT INTO chado.cvterm VALUES (2105, 23, 'disease_associated_variant', 'A variant that has been found to be associated with disease. []', 2360, 0, 0);
INSERT INTO chado.cvterm VALUES (1872, 23, 'P_TIR_transposon', 'A P-element is a DNA transposon responsible for hybrid dysgenesis. P elements in this terminal inverted repeat (TIR) transposon superfamily have 31 bp perfect TIR and upon insertion duplicate an 8 bp sequence. It contains transposase that may lack the DDE domain. [PMID:6309410, SO:ke]', 2118, 0, 0);
INSERT INTO chado.cvterm VALUES (1873, 23, 'functional_effect_variant', 'A variant whereby the effect is evaluated with respect to a reference. [SO:ke]', 2119, 0, 0);
INSERT INTO chado.cvterm VALUES (1874, 23, 'structural_variant', 'A sequence variant that changes one or more structural features. [SO:ke]', 2120, 0, 0);
INSERT INTO chado.cvterm VALUES (1875, 23, 'transcript_function_variant', 'A sequence variant which alters the functioning of a transcript with respect to a reference sequence. [SO:ke]', 2121, 0, 0);
INSERT INTO chado.cvterm VALUES (1876, 23, 'functionally_abnormal', 'A sequence variant in which the function of a gene product is altered with respect to a reference. []', 2122, 0, 0);
INSERT INTO chado.cvterm VALUES (1877, 23, 'translational_product_function_variant', 'A sequence variant that affects the functioning of a translational product with respect to a reference sequence. [SO:ke]', 2123, 0, 0);
INSERT INTO chado.cvterm VALUES (1878, 23, 'level_of_transcript_variant', 'A sequence variant which alters the level of a transcript. [SO:ke]', 2124, 0, 0);
INSERT INTO chado.cvterm VALUES (1879, 23, 'decreased_transcript_level_variant', 'A sequence variant that decreases the level of mature, spliced and processed RNA with respect to a reference sequence. [SO:ke]', 2125, 0, 0);
INSERT INTO chado.cvterm VALUES (1880, 23, 'increased_transcript_level_variant', 'A sequence variant that increases the level of mature, spliced and processed RNA with respect to a reference sequence. [SO:ke]', 2126, 0, 0);
INSERT INTO chado.cvterm VALUES (1881, 23, 'transcript_processing_variant', 'A sequence variant that affects the post transcriptional processing of a transcript with respect to a reference sequence. [SO:ke]', 2127, 0, 0);
INSERT INTO chado.cvterm VALUES (1882, 23, 'editing_variant', 'A transcript processing variant whereby the process of editing is disrupted with respect to the reference. [SO:ke]', 2128, 0, 0);
INSERT INTO chado.cvterm VALUES (1883, 23, 'polyadenylation_variant', 'A sequence variant that changes polyadenylation with respect to a reference sequence. [SO:ke]', 2129, 0, 0);
INSERT INTO chado.cvterm VALUES (1884, 23, 'transcript_stability_variant', 'A variant that changes the stability of a transcript with respect to a reference sequence. [SO:ke]', 2130, 0, 0);
INSERT INTO chado.cvterm VALUES (1885, 23, 'decreased_transcript_stability_variant', 'A sequence variant that decreases transcript stability with respect to a reference sequence. [SO:ke]', 2131, 0, 0);
INSERT INTO chado.cvterm VALUES (1886, 23, 'increased_transcript_stability_variant', 'A sequence variant that increases transcript stability with respect to a reference sequence. [SO:ke]', 2132, 0, 0);
INSERT INTO chado.cvterm VALUES (1887, 23, 'transcription_variant', 'A variant that changes alters the transcription of a transcript with respect to a reference sequence. [SO:ke]', 2133, 0, 0);
INSERT INTO chado.cvterm VALUES (1888, 23, 'rate_of_transcription_variant', 'A sequence variant that changes the rate of transcription with respect to a reference sequence. [SO:ke]', 2134, 0, 0);
INSERT INTO chado.cvterm VALUES (1889, 23, 'increased_transcription_rate_variant', 'A sequence variant that increases the rate of transcription with respect to a reference sequence. [SO:ke]', 2135, 0, 0);
INSERT INTO chado.cvterm VALUES (1890, 23, 'decreased_transcription_rate_variant', 'A sequence variant that decreases the rate of transcription with respect to a reference sequence. [SO:ke]', 2136, 0, 0);
INSERT INTO chado.cvterm VALUES (1891, 23, 'translational_product_level_variant', 'A functional variant that changes the translational product level with respect to a reference sequence. [SO:ke]', 2137, 0, 0);
INSERT INTO chado.cvterm VALUES (1892, 23, 'polypeptide_function_variant', 'A sequence variant which changes polypeptide functioning with respect to a reference sequence. [SO:ke]', 2138, 0, 0);
INSERT INTO chado.cvterm VALUES (1893, 23, 'decreased_translational_product_level', 'A sequence variant which decreases the translational product level with respect to a reference sequence. [SO:ke]', 2139, 0, 0);
INSERT INTO chado.cvterm VALUES (1894, 23, 'increased_translational_product_level', 'A sequence variant which increases the translational product level with respect to a reference sequence. [SO:ke]', 2140, 0, 0);
INSERT INTO chado.cvterm VALUES (1895, 23, 'polypeptide_gain_of_function_variant', 'A sequence variant which causes gain of polypeptide function with respect to a reference sequence. [SO:ke]', 2141, 0, 0);
INSERT INTO chado.cvterm VALUES (1896, 23, 'polypeptide_localization_variant', 'A sequence variant which changes the localization of a polypeptide with respect to a reference sequence. [SO:ke]', 2142, 0, 0);
INSERT INTO chado.cvterm VALUES (1897, 23, 'polypeptide_loss_of_function_variant', 'A sequence variant that causes the loss of a polypeptide function with respect to a reference sequence. [SO:ke]', 2143, 0, 0);
INSERT INTO chado.cvterm VALUES (1898, 23, 'inactive_ligand_binding_site', 'A sequence variant that causes the inactivation of a ligand binding site with respect to a reference sequence. [SO:ke]', 2144, 0, 0);
INSERT INTO chado.cvterm VALUES (1899, 23, 'polypeptide_partial_loss_of_function', 'A sequence variant that causes some but not all loss of polypeptide function with respect to a reference sequence. [SO:ke]', 2145, 0, 0);
INSERT INTO chado.cvterm VALUES (1900, 23, 'polypeptide_post_translational_processing_variant', 'A sequence variant that causes a change in post translational processing of the peptide with respect to a reference sequence. [SO:ke]', 2146, 0, 0);
INSERT INTO chado.cvterm VALUES (1901, 23, 'copy_number_change', 'A sequence variant where copies of a feature (CNV) are either increased or decreased. [SO:ke]', 2147, 0, 0);
INSERT INTO chado.cvterm VALUES (1902, 23, 'sequence_length_variant', 'A sequence variant that changes the length of one or more sequence features. []', 2148, 0, 0);
INSERT INTO chado.cvterm VALUES (1903, 23, 'gene_variant', 'A sequence variant where the structure of the gene is changed. [SO:ke]', 2149, 0, 0);
INSERT INTO chado.cvterm VALUES (1904, 23, 'gene_fusion', 'A sequence variant whereby a two genes have become joined. [SO:ke]', 2150, 0, 0);
INSERT INTO chado.cvterm VALUES (1905, 23, 'feature_fusion', 'A sequence variant, caused by an alteration of the genomic sequence, where a deletion fuses genomic features. [SO:ke]', 2151, 0, 0);
INSERT INTO chado.cvterm VALUES (1906, 23, 'regulatory_region_variant', 'A sequence variant located within a regulatory region. [SO:ke]', 2152, 0, 0);
INSERT INTO chado.cvterm VALUES (1907, 23, 'stop_retained_variant', 'A sequence variant where at least one base in the terminator codon is changed, but the terminator remains. [SO:ke]', 2153, 0, 0);
INSERT INTO chado.cvterm VALUES (1908, 23, 'terminator_codon_variant', 'A sequence variant whereby at least one of the bases in the terminator codon is changed. [SO:ke]', 2154, 0, 0);
INSERT INTO chado.cvterm VALUES (1909, 23, 'synonymous_variant', 'A sequence variant where there is no resulting change to the encoded amino acid. [SO:ke]', 2155, 0, 0);
INSERT INTO chado.cvterm VALUES (1910, 23, 'splicing_variant', 'A sequence variant that changes the process of splicing. [SO:ke]', 2156, 0, 0);
INSERT INTO chado.cvterm VALUES (1911, 23, 'transcript_variant', 'A sequence variant that changes the structure of the transcript. [SO:ke]', 2157, 0, 0);
INSERT INTO chado.cvterm VALUES (1912, 23, 'cryptic_splice_site_variant', 'A sequence variant causing a new (functional) splice site. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 2158, 0, 0);
INSERT INTO chado.cvterm VALUES (1914, 23, 'cryptic_splice_donor', 'A sequence variant whereby a new splice site is created due to the activation of a new donor. [SO:ke]', 2160, 0, 0);
INSERT INTO chado.cvterm VALUES (1915, 23, 'exon_loss_variant', 'A sequence variant whereby an exon is lost from the transcript. [SO:ke]', 2161, 0, 0);
INSERT INTO chado.cvterm VALUES (1916, 23, 'intron_gain_variant', 'A sequence variant whereby an intron is gained by the processed transcript; usually a result of an alteration of the donor or acceptor. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 2162, 0, 0);
INSERT INTO chado.cvterm VALUES (1917, 23, 'splice_acceptor_variant', 'A splice variant that changes the 2 base region at the 3'' end of an intron. [SO:ke]', 2163, 0, 0);
INSERT INTO chado.cvterm VALUES (1918, 23, 'splice_site_variant', 'A sequence variant that changes the first two or last two bases of an intron, or the 5th base from the start of the intron in the orientation of the transcript. [http://ensembl.org/info/docs/variation/index.html]', 2164, 0, 0);
INSERT INTO chado.cvterm VALUES (1919, 23, 'splice_donor_variant', 'A splice variant that changes the 2 base pair region at the 5'' end of an intron. [SO:ke]', 2165, 0, 0);
INSERT INTO chado.cvterm VALUES (1920, 23, 'complex_transcript_variant', 'A transcript variant with a complex INDEL- Insertion or deletion that spans an exon/intron border or a coding sequence/UTR border. [http://ensembl.org/info/docs/variation/index.html]', 2166, 0, 0);
INSERT INTO chado.cvterm VALUES (1921, 23, 'stop_lost', 'A sequence variant where at least one base of the terminator codon (stop) is changed, resulting in an elongated transcript. [SO:ke]', 2167, 0, 0);
INSERT INTO chado.cvterm VALUES (1922, 23, 'feature_elongation', 'A sequence variant that causes the extension of a genomic feature, with regard to the reference sequence. [SO:ke]', 2168, 0, 0);
INSERT INTO chado.cvterm VALUES (1923, 23, 'nonsynonymous_variant', 'A non-synonymous variant is an inframe, protein altering variant, resulting in a codon change. [SO:ke]', 2169, 0, 0);
INSERT INTO chado.cvterm VALUES (1924, 23, 'transcript_sequence_variant', '', 2170, 1, 0);
INSERT INTO chado.cvterm VALUES (1925, 23, 'coding_sequence_variant', 'A sequence variant that changes the coding sequence. [SO:ke]', 2171, 0, 0);
INSERT INTO chado.cvterm VALUES (1926, 23, 'exon_variant', 'A sequence variant that changes exon sequence. [SO:ke]', 2173, 0, 0);
INSERT INTO chado.cvterm VALUES (1927, 23, 'coding_transcript_variant', 'A transcript variant of a protein coding gene. [SO:ke]', 2174, 0, 0);
INSERT INTO chado.cvterm VALUES (1928, 23, 'initiator_codon_variant', 'A codon variant that changes at least one base of the first codon of a transcript. [SO:ke]', 2175, 0, 0);
INSERT INTO chado.cvterm VALUES (1929, 23, 'missense_variant', 'A sequence variant, that changes one or more bases, resulting in a different amino acid sequence but where the length is preserved. [EBI:fc, EBI:gr, SO:ke]', 2177, 0, 0);
INSERT INTO chado.cvterm VALUES (1930, 23, 'conservative_missense_variant', 'A sequence variant whereby at least one base of a codon is changed resulting in a codon that encodes for a different but similar amino acid. These variants may or may not be deleterious. [SO:ke]', 2181, 0, 0);
INSERT INTO chado.cvterm VALUES (1931, 23, 'non_conservative_missense_variant', 'A sequence variant whereby at least one base of a codon is changed resulting in a codon that encodes for an amino acid with different biochemical properties. [SO:ke]', 2182, 0, 0);
INSERT INTO chado.cvterm VALUES (1932, 23, 'stop_gained', 'A sequence variant whereby at least one base of a codon is changed, resulting in a premature stop codon, leading to a shortened polypeptide. [SO:ke]', 2183, 0, 0);
INSERT INTO chado.cvterm VALUES (1933, 23, 'feature_truncation', 'A sequence variant that causes the reduction of a genomic feature, with regard to the reference sequence. [SO:ke]', 2185, 0, 0);
INSERT INTO chado.cvterm VALUES (1934, 23, 'frameshift_variant', 'A sequence variant which causes a disruption of the translational reading frame, because the number of nucleotides inserted or deleted is not a multiple of three. [SO:ke]', 2186, 0, 0);
INSERT INTO chado.cvterm VALUES (1935, 23, 'protein_altering_variant', 'A sequence_variant which is predicted to change the protein encoded in the coding sequence. [EBI:gr]', 2188, 0, 0);
INSERT INTO chado.cvterm VALUES (1936, 23, 'frame_restoring_variant', 'A sequence variant that reverts the sequence of a previous frameshift mutation back to the initial frame. [SO:ke]', 2191, 0, 0);
INSERT INTO chado.cvterm VALUES (1937, 23, 'minus_1_frameshift_variant', 'A sequence variant which causes a disruption of the translational reading frame, by shifting one base ahead. [http://arjournals.annualreviews.org/doi/pdf/10.1146/annurev.ge.08.120174.001535]', 2192, 0, 0);
INSERT INTO chado.cvterm VALUES (1938, 23, 'minus_2_frameshift_variant', 'A sequence variant which causes a disruption of the translational reading frame, by shifting two bases forward. []', 2193, 0, 0);
INSERT INTO chado.cvterm VALUES (1939, 23, 'plus_1_frameshift_variant', 'A sequence variant which causes a disruption of the translational reading frame, by shifting one base backward. [http://arjournals.annualreviews.org/doi/pdf/10.1146/annurev.ge.08.120174.001535]', 2194, 0, 0);
INSERT INTO chado.cvterm VALUES (1940, 23, 'plus_2_frameshift_variant', 'A sequence variant which causes a disruption of the translational reading frame, by shifting two bases backward. []', 2195, 0, 0);
INSERT INTO chado.cvterm VALUES (1941, 23, 'transcript_secondary_structure_variant', 'A sequence variant within a transcript that changes the secondary structure of the RNA product. [SO:ke]', 2196, 0, 0);
INSERT INTO chado.cvterm VALUES (1942, 23, 'compensatory_transcript_secondary_structure_variant', 'A secondary structure variant that compensate for the change made by a previous variant. [SO:ke]', 2197, 0, 0);
INSERT INTO chado.cvterm VALUES (1943, 23, 'translational_product_structure_variant', 'A sequence variant within the transcript that changes the structure of the translational product. [SO:ke]', 2198, 0, 0);
INSERT INTO chado.cvterm VALUES (1944, 23, '3D_polypeptide_structure_variant', 'A sequence variant that changes the resulting polypeptide structure. [SO:ke]', 2199, 0, 0);
INSERT INTO chado.cvterm VALUES (1945, 23, 'complex_3D_structural_variant', 'A sequence variant that changes the resulting polypeptide structure. [SO:ke]', 2200, 0, 0);
INSERT INTO chado.cvterm VALUES (1946, 23, 'conformational_change_variant', 'A sequence variant in the CDS region that causes a conformational change in the resulting polypeptide sequence. [SO:ke]', 2201, 0, 0);
INSERT INTO chado.cvterm VALUES (1947, 23, 'complex_change_of_translational_product_variant', 'A variant that changes the translational product with respect to the reference. []', 2202, 0, 0);
INSERT INTO chado.cvterm VALUES (1948, 23, 'polypeptide_sequence_variant', 'A sequence variant with in the CDS that causes a change in the resulting polypeptide sequence. [SO:ke]', 2203, 0, 0);
INSERT INTO chado.cvterm VALUES (1949, 23, 'amino_acid_deletion', 'A sequence variant within a CDS resulting in the loss of an amino acid from the resulting polypeptide. [SO:ke]', 2204, 0, 0);
INSERT INTO chado.cvterm VALUES (1950, 23, 'amino_acid_insertion', 'A sequence variant within a CDS resulting in the gain of an amino acid to the resulting polypeptide. [SO:ke]', 2205, 0, 0);
INSERT INTO chado.cvterm VALUES (1951, 23, 'amino_acid_substitution', 'A sequence variant of a codon resulting in the substitution of one amino acid for another in the resulting polypeptide. [SO:ke]', 2206, 0, 0);
INSERT INTO chado.cvterm VALUES (1952, 23, 'conservative_amino_acid_substitution', 'A sequence variant of a codon causing the substitution of a similar amino acid for another in the resulting polypeptide. [SO:ke]', 2207, 0, 0);
INSERT INTO chado.cvterm VALUES (1953, 23, 'non_conservative_amino_acid_substitution', 'A sequence variant of a codon causing the substitution of a non conservative amino acid for another in the resulting polypeptide. [SO:ke]', 2208, 0, 0);
INSERT INTO chado.cvterm VALUES (1954, 23, 'elongated_polypeptide', 'An elongation of a polypeptide sequence deriving from a sequence variant extending the CDS. [SO:ke]', 2209, 0, 0);
INSERT INTO chado.cvterm VALUES (1955, 23, 'elongated_polypeptide_C_terminal', 'An elongation of a polypeptide sequence at the C terminus deriving from a sequence variant extending the CDS. [SO:ke]', 2210, 0, 0);
INSERT INTO chado.cvterm VALUES (1956, 23, 'CDS_three_prime_extension', 'A sequence variant extending the CDS at the 3'' end, that causes elongation of the resulting polypeptide sequence at the C terminus. [PMID:14732127, PMID:15864293, PMID:27984720, PMID:31216041, PMID:32020195]', 2211, 0, 0);
INSERT INTO chado.cvterm VALUES (1957, 23, 'elongated_polypeptide_N_terminal', 'An elongation of a polypeptide sequence at the N terminus deriving from a sequence variant extending the CDS. [SO:ke]', 2212, 0, 0);
INSERT INTO chado.cvterm VALUES (1958, 23, 'CDS_five_prime_extension', 'A sequence variant extending the CDS at the 5'' end, that causes elongation of the resulting polypeptide sequence at the N terminus. [PMID:14732127, PMID:15864293, PMID:27984720, PMID:31216041, PMID:32020195]', 2213, 0, 0);
INSERT INTO chado.cvterm VALUES (1959, 23, 'elongated_in_frame_polypeptide_C_terminal', 'A sequence variant with in the CDS that causes in frame elongation of the resulting polypeptide sequence at the C terminus. [SO:ke]', 2214, 0, 0);
INSERT INTO chado.cvterm VALUES (1960, 23, 'elongated_out_of_frame_polypeptide_C_terminal', 'A sequence variant with in the CDS that causes out of frame elongation of the resulting polypeptide sequence at the C terminus. [SO:ke]', 2215, 0, 0);
INSERT INTO chado.cvterm VALUES (1961, 23, 'elongated_in_frame_polypeptide_N_terminal_elongation', 'A sequence variant with in the CDS that causes in frame elongation of the resulting polypeptide sequence at the N terminus. [SO:ke]', 2216, 0, 0);
INSERT INTO chado.cvterm VALUES (1962, 23, 'elongated_out_of_frame_polypeptide_N_terminal', 'A sequence variant with in the CDS that causes out of frame elongation of the resulting polypeptide sequence at the N terminus. [SO:ke]', 2217, 0, 0);
INSERT INTO chado.cvterm VALUES (1963, 23, 'polypeptide_fusion', 'A sequence variant that causes a fusion of two polypeptide sequences. [SO:ke]', 2218, 0, 0);
INSERT INTO chado.cvterm VALUES (1964, 23, 'polypeptide_truncation', 'A sequence variant of the CD that causes a truncation of the resulting polypeptide. [SO:ke]', 2219, 0, 0);
INSERT INTO chado.cvterm VALUES (1965, 23, 'inactive_catalytic_site', 'A sequence variant that causes the inactivation of a catalytic site with respect to a reference sequence. [SO:ke]', 2220, 0, 0);
INSERT INTO chado.cvterm VALUES (1966, 23, 'non_coding_transcript_variant', 'A transcript variant of a non coding RNA gene. [SO:ke]', 2221, 0, 0);
INSERT INTO chado.cvterm VALUES (1967, 23, 'mature_miRNA_variant', 'A transcript variant located with the sequence of the mature miRNA. [SO:ke]', 2222, 0, 0);
INSERT INTO chado.cvterm VALUES (1968, 23, 'NMD_transcript_variant', 'A variant in a transcript that is the target of nonsense-mediated mRNA decay. [SO:ke]', 2223, 0, 0);
INSERT INTO chado.cvterm VALUES (1969, 23, 'UTR_variant', 'A transcript variant that is located within the UTR. [SO:ke]', 2224, 0, 0);
INSERT INTO chado.cvterm VALUES (1970, 23, '3_prime_UTR_variant', 'A UTR variant of the 3'' UTR. [SO:ke]', 2225, 0, 0);
INSERT INTO chado.cvterm VALUES (1971, 23, 'incomplete_terminal_codon_variant', 'A sequence variant where at least one base of the final codon of an incompletely annotated transcript is changed. [SO:ke]', 2226, 0, 0);
INSERT INTO chado.cvterm VALUES (1972, 23, 'inframe_variant', 'A sequence variant which does not cause a disruption of the translational reading frame. [SO:ke]', 2227, 0, 0);
INSERT INTO chado.cvterm VALUES (1973, 23, 'intron_variant', 'A transcript variant occurring within an intron. [SO:ke]', 2228, 0, 0);
INSERT INTO chado.cvterm VALUES (1974, 23, 'intergenic_variant', 'A sequence variant located in the intergenic region, between genes. [SO:ke]', 2229, 0, 0);
INSERT INTO chado.cvterm VALUES (1975, 23, 'splice_region_variant', 'A sequence variant in which a change has occurred within the region of the splice site, either within 1-3 bases of the exon or 3-8 bases of the intron. [http://ensembl.org/info/docs/variation/index.html]', 2230, 0, 0);
INSERT INTO chado.cvterm VALUES (1976, 23, 'upstream_gene_variant', 'A sequence variant located 5'' of a gene. [SO:ke]', 2231, 0, 0);
INSERT INTO chado.cvterm VALUES (1977, 23, 'downstream_gene_variant', 'A sequence variant located 3'' of a gene. [SO:ke]', 2232, 0, 0);
INSERT INTO chado.cvterm VALUES (1978, 23, '5KB_downstream_variant', 'A sequence variant located within 5 KB of the end of a gene. [SO:ke]', 2233, 0, 0);
INSERT INTO chado.cvterm VALUES (1979, 23, '500B_downstream_variant', 'A sequence variant located within a half KB of the end of a gene. [SO:ke]', 2234, 0, 0);
INSERT INTO chado.cvterm VALUES (1980, 23, '5KB_upstream_variant', 'A sequence variant located within 5KB 5'' of a gene. [SO:ke]', 2235, 0, 0);
INSERT INTO chado.cvterm VALUES (1981, 23, '2KB_upstream_variant', 'A sequence variant located within 2KB 5'' of a gene. [SO:ke]', 2236, 0, 0);
INSERT INTO chado.cvterm VALUES (1982, 23, 'rRNA_gene', 'A gene that encodes for ribosomal RNA. [SO:ke]', 2237, 0, 0);
INSERT INTO chado.cvterm VALUES (1983, 23, 'piRNA_gene', 'A gene that encodes for an piwi associated RNA. [SO:ke]', 2238, 0, 0);
INSERT INTO chado.cvterm VALUES (1984, 23, 'RNase_P_RNA_gene', 'A gene that encodes an RNase P RNA. [SO:ke]', 2239, 0, 0);
INSERT INTO chado.cvterm VALUES (1985, 23, 'enzymatic_RNA_gene', 'A gene that encodes an enzymatic RNA. []', 2240, 0, 0);
INSERT INTO chado.cvterm VALUES (1986, 23, 'RNase_MRP_RNA_gene', 'A gene that encodes a RNase_MRP_RNA. [SO:ke]', 2241, 0, 0);
INSERT INTO chado.cvterm VALUES (1987, 23, 'lincRNA_gene', 'A gene that encodes a long, intervening non-coding RNA. [http://www.gencodegenes.org/gencode_biotypes.html, PMID:23463798, SO:ke]', 2242, 0, 0);
INSERT INTO chado.cvterm VALUES (1988, 23, 'lncRNA_gene', 'A gene that encodes a long non-coding RNA. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2243, 0, 0);
INSERT INTO chado.cvterm VALUES (1989, 23, 'mathematically_defined_repeat', 'A mathematically defined repeat (MDR) is a experimental feature that is determined by querying overlapping oligomers of length k against a database of shotgun sequence data and identifying regions in the query sequence that exceed a statistically determined threshold of repetitiveness. [SO:jestill]', 2244, 0, 0);
INSERT INTO chado.cvterm VALUES (1990, 23, 'telomerase_RNA_gene', 'A telomerase RNA gene is a non coding RNA gene the RNA product of which is a component of telomerase. [SO:ke]', 2245, 0, 0);
INSERT INTO chado.cvterm VALUES (1991, 23, 'targeting_vector', 'An engineered vector that is able to take part in homologous recombination in a host with the intent of introducing site specific genomic modifications. [MGD:tm, PMID:10354467]', 2246, 0, 0);
INSERT INTO chado.cvterm VALUES (1992, 23, 'DArT_marker', 'A genetic marker, discovered using Diversity Arrays Technology (DArT) technology. [SO:ke]', 2247, 0, 0);
INSERT INTO chado.cvterm VALUES (1993, 23, 'kozak_sequence', 'A kind of ribosome entry site, specific to Eukaryotic organisms that overlaps part of both 5'' UTR and CDS sequence. [SO:ke]', 2248, 0, 0);
INSERT INTO chado.cvterm VALUES (2034, 23, 'histone_methylation_site', 'A histone modification site where the modification is the methylation of the residue. [SO:ke]', 2289, 0, 0);
INSERT INTO chado.cvterm VALUES (1994, 23, 'retinoic_acid_responsive_element', 'A transcription factor binding site of variable direct repeats of the sequence PuGGTCA spaced by five nucleotides (DR5) found in the promoters of retinoic acid-responsive genes, to which retinoic acid receptors bind. [PMID:11327309, PMID:19917671]', 2249, 0, 0);
INSERT INTO chado.cvterm VALUES (1995, 23, 'nested_tandem_repeat', 'An NTR is a nested repeat of two distinct tandem motifs interspersed with each other. [SO:AF]', 2250, 0, 0);
INSERT INTO chado.cvterm VALUES (1996, 23, 'RNA_polymerase_II_TATA_box', 'A TATA box core promoter of a gene transcribed by RNA polymerase II. [PMID:16858867]', 2251, 0, 0);
INSERT INTO chado.cvterm VALUES (1997, 23, 'RNA_polymerase_III_TATA_box', 'A TATA box core promoter of a gene transcribed by RNA polymerase III. [SO:ke]', 2252, 0, 0);
INSERT INTO chado.cvterm VALUES (1998, 23, 'BREd_motif', 'A core RNA polymerase II promoter element with consensus (G/A)T(T/G/A)(T/A)(G/T)(T/G)(T/G). [PMID:16858867]', 2253, 0, 0);
INSERT INTO chado.cvterm VALUES (1999, 23, 'DCE', 'A discontinuous core element of RNA polymerase II transcribed genes, situated downstream of the TSS. It is composed of three sub elements: SI, SII and SIII. [PMID:16858867]', 2254, 0, 0);
INSERT INTO chado.cvterm VALUES (2000, 23, 'DCE_SI', 'A sub element of the DCE core promoter element, with consensus sequence CTTC. [PMID:16858867, SO:ke]', 2255, 0, 0);
INSERT INTO chado.cvterm VALUES (2001, 23, 'DCE_SII', 'A sub element of the DCE core promoter element with consensus sequence CTGT. [PMID:16858867, SO:ke]', 2256, 0, 0);
INSERT INTO chado.cvterm VALUES (2002, 23, 'DCE_SIII', 'A sub element of the DCE core promoter element with consensus sequence AGC. [PMID:16858867, SO:ke]', 2257, 0, 0);
INSERT INTO chado.cvterm VALUES (2003, 23, 'proximal_promoter_element', 'DNA segment that ranges from about -250 to -40 relative to +1 of RNA transcription start site, where sequence specific DNA-binding transcription factors binds, such as Sp1, CTF (CCAAT-binding transcription factor), and CBF (CCAAT-box binding factor). [PMID:12515390, PMID:9679020, SO:ml]', 2258, 0, 0);
INSERT INTO chado.cvterm VALUES (2004, 23, 'regulatory_promoter_element', 'A promoter element that is not part of the core promoter, but provides the promoter with a specific regulatory region. [PMID:12381659]', 2259, 0, 0);
INSERT INTO chado.cvterm VALUES (2005, 23, 'distal_promoter_element', 'A regulatory promoter element that is distal from the TSS. []', 2260, 0, 0);
INSERT INTO chado.cvterm VALUES (2006, 23, 'bacterial_RNApol_promoter_sigma54_element', 'A DNA sequence to which bacterial RNA polymerase sigma 54 binds, to begin transcription. []', 2261, 0, 0);
INSERT INTO chado.cvterm VALUES (2007, 23, 'minus_12_signal', 'A conserved region about 12-bp upstream of the start point of bacterial transcription units, involved with sigma factor 54. [PMID:18331472]', 2262, 0, 0);
INSERT INTO chado.cvterm VALUES (2008, 23, 'minus_24_signal', 'A conserved region about 24-bp upstream of the start point of bacterial transcription units, involved with sigma factor 54. [PMID:18331472]', 2263, 0, 0);
INSERT INTO chado.cvterm VALUES (2009, 23, 'A_box_type_1', 'An A box within an RNA polymerase III type 1 promoter. [SO:ke]', 2264, 0, 0);
INSERT INTO chado.cvterm VALUES (2010, 23, 'A_box_type_2', 'An A box within an RNA polymerase III type 2 promoter. [SO:ke]', 2265, 0, 0);
INSERT INTO chado.cvterm VALUES (2011, 23, 'intermediate_element', 'A core promoter region of RNA polymerase III type 1 promoters. [PMID:12381659]', 2266, 0, 0);
INSERT INTO chado.cvterm VALUES (2012, 23, 'transcription_regulatory_region', 'A regulatory region that is involved in the control of the process of transcription. [SO:ke]', 2267, 1, 0);
INSERT INTO chado.cvterm VALUES (2013, 23, 'recombination_regulatory_region', 'A regulatory region that is involved in the control of the process of recombination. [SO:ke]', 2268, 0, 0);
INSERT INTO chado.cvterm VALUES (2014, 23, 'replication_regulatory_region', 'A regulatory region that is involved in the control of the process of nucleotide replication. [SO:ke]', 2269, 0, 0);
INSERT INTO chado.cvterm VALUES (2015, 23, 'experimental_feature_attribute', 'An attribute of an experimentally derived feature. [SO:ke]', 2270, 0, 0);
INSERT INTO chado.cvterm VALUES (2016, 23, 'score', 'The score of an experimentally derived feature such as a p-value. [SO:ke]', 2271, 0, 0);
INSERT INTO chado.cvterm VALUES (2017, 23, 'quality_value', 'An experimental feature attribute that defines the quality of the feature in a quantitative way, such as a phred quality score. [SO:ke]', 2272, 0, 0);
INSERT INTO chado.cvterm VALUES (2018, 23, 'restriction_enzyme_recognition_site', 'The nucleotide region (usually a palindrome) that is recognized by a restriction enzyme. This may or may not be equal to the restriction enzyme binding site. [SO:ke]', 2273, 0, 0);
INSERT INTO chado.cvterm VALUES (2019, 23, 'restriction_enzyme_region', 'A region related to restriction enzyme function. [SO:ke]', 2274, 0, 0);
INSERT INTO chado.cvterm VALUES (2020, 23, 'restriction_enzyme_cleavage_junction', 'The boundary at which a restriction enzyme breaks the nucleotide sequence. [SO:ke]', 2275, 0, 0);
INSERT INTO chado.cvterm VALUES (2021, 23, 'nucleotide_cleavage_site', 'A point in nucleic acid where a cleavage event occurs. []', 2276, 0, 0);
INSERT INTO chado.cvterm VALUES (2022, 23, 'five_prime_restriction_enzyme_junction', 'The restriction enzyme cleavage junction on the 5'' strand of the nucleotide sequence. [SO:ke]', 2277, 0, 0);
INSERT INTO chado.cvterm VALUES (2023, 23, 'single_strand_restriction_enzyme_cleavage_site', 'A restriction enzyme cleavage site whereby only one strand is cut. [SO:ke]', 2278, 0, 0);
INSERT INTO chado.cvterm VALUES (2024, 23, 'sticky_end_restriction_enzyme_cleavage_site', 'A site where restriction enzymes can cleave that will produce an overhang or ''sticky end''. []', 2279, 0, 0);
INSERT INTO chado.cvterm VALUES (2025, 23, 'three_prime_restriction_enzyme_junction', 'The restriction enzyme cleavage junction on the 3'' strand of the nucleotide sequence. []', 2280, 0, 0);
INSERT INTO chado.cvterm VALUES (2026, 23, 'blunt_end_restriction_enzyme_cleavage_site', 'A restriction enzyme recognition site that, when cleaved, results in no overhangs. [SBOL:jgquinn, SO:ke]', 2281, 0, 0);
INSERT INTO chado.cvterm VALUES (2027, 23, 'blunt_end_restriction_enzyme_cleavage_junction', 'A restriction enzyme cleavage site where both strands are cut at the same position. [SO:ke]', 2282, 0, 0);
INSERT INTO chado.cvterm VALUES (2028, 23, 'restriction_enzyme_single_strand_overhang', 'A terminal region of DNA sequence where the end of the region is not blunt ended. [SO:ke]', 2283, 0, 0);
INSERT INTO chado.cvterm VALUES (2029, 23, 'experimentally_defined_binding_region', 'A region that has been implicated in binding although the exact coordinates of binding may be unknown. [SO:ke]', 2284, 0, 0);
INSERT INTO chado.cvterm VALUES (2030, 23, 'ChIP_seq_region', 'A region of sequence identified by CHiP seq technology to contain a protein binding site. [SO:ke]', 2285, 0, 0);
INSERT INTO chado.cvterm VALUES (2031, 23, 'ASPE_primer', '\"A primer containing an SNV at the 3'' end for accurate genotyping. [http://www.ncbi.nlm.nih.gov/pubmed/11252801]', 2286, 0, 0);
INSERT INTO chado.cvterm VALUES (2032, 23, 'dCAPS_primer', 'A primer with one or more mismatches to the DNA template corresponding to a position within a restriction enzyme recognition site. [http://www.ncbi.nlm.nih.gov/pubmed/9628033]', 2287, 0, 0);
INSERT INTO chado.cvterm VALUES (2033, 23, 'histone_modification', 'Histone modification is a post translationally modified region whereby residues of the histone protein are modified by methylation, acetylation, phosphorylation, ubiquitination, sumoylation, citrullination, or ADP-ribosylation. [http:en.wikipedia.org/wiki/Histone]', 2288, 0, 0);
INSERT INTO chado.cvterm VALUES (2035, 23, 'histone_acetylation_site', 'A histone modification where the modification is the acylation of the residue. [SO:ke]', 2290, 0, 0);
INSERT INTO chado.cvterm VALUES (2036, 23, 'H3K9_acetylation_site', 'A kind of histone modification site, whereby the 9th residue (a lysine), from the start of the H3 histone protein is acetylated. [http://en.wikipedia.org/wiki/Histone]', 2291, 0, 0);
INSERT INTO chado.cvterm VALUES (2037, 23, 'histone_3_acetylation_site', 'A histone 3 modification where the modification is the acetylation of the residue. [EBI:nj, ISBN:0815341059, SO:ke]', 2292, 0, 0);
INSERT INTO chado.cvterm VALUES (2038, 23, 'H3K14_acetylation_site', 'A kind of histone modification site, whereby the 14th residue (a lysine), from the start of the H3 histone protein is acetylated. [http://en.wikipedia.org/wiki/Histone]', 2293, 0, 0);
INSERT INTO chado.cvterm VALUES (2039, 23, 'H3K4_monomethylation_site', 'A kind of histone modification, whereby the 4th residue (a lysine), from the start of the H3 protein is mono-methylated. [http://en.wikipedia.org/wiki/Histone]', 2294, 0, 0);
INSERT INTO chado.cvterm VALUES (2040, 23, 'H3K4_methylation_site', 'A kind of histone modification, whereby the 4th residue (a lysine), from the start of the H3 protein is methylated. [SO:ke]', 2295, 0, 0);
INSERT INTO chado.cvterm VALUES (2041, 23, 'H3K4_trimethylation', 'A kind of histone modification site, whereby the 4th residue (a lysine), from the start of the H3 protein is tri-methylated. [http://en.wikipedia.org/wiki/Histone]', 2296, 0, 0);
INSERT INTO chado.cvterm VALUES (2042, 23, 'H3K9_trimethylation_site', 'A kind of histone modification site, whereby the 9th residue (a lysine), from the start of the H3 histone protein is tri-methylated. [http://en.wikipedia.org/wiki/Histone]', 2297, 0, 0);
INSERT INTO chado.cvterm VALUES (2043, 23, 'H3K9_methylation_site', 'A kind of histone modification site, whereby the 9th residue (a lysine), from the start of the H3 histone protein is methylated. [SO:ke]', 2298, 0, 0);
INSERT INTO chado.cvterm VALUES (2044, 23, 'H3K27_monomethylation_site', 'A kind of histone modification site, whereby the 27th residue (a lysine), from the start of the H3 histone protein is mono-methylated. [http://en.wikipedia.org/wiki/Histone]', 2299, 0, 0);
INSERT INTO chado.cvterm VALUES (2045, 23, 'H3K27_methylation_site', 'A kind of histone modification site, whereby the 27th residue (a lysine), from the start of the H3 histone protein is methylated. [SO:ke]', 2300, 0, 0);
INSERT INTO chado.cvterm VALUES (2046, 23, 'H3K27_trimethylation_site', 'A kind of histone modification site, whereby the 27th residue (a lysine), from the start of the H3 histone protein is tri-methylated. [http://en.wikipedia.org/wiki/Histone]', 2301, 0, 0);
INSERT INTO chado.cvterm VALUES (2047, 23, 'H3K79_monomethylation_site', 'A kind of histone modification site, whereby the 79th residue (a lysine), from the start of the H3 histone protein is mono- methylated. [http://en.wikipedia.org/wiki/Histone]', 2302, 0, 0);
INSERT INTO chado.cvterm VALUES (2048, 23, 'H3K79_methylation_site', 'A kind of histone modification site, whereby the 79th residue (a lysine), from the start of the H3 histone protein is methylated. [SO:ke]', 2303, 0, 0);
INSERT INTO chado.cvterm VALUES (2049, 23, 'H3K79_dimethylation_site', 'A kind of histone modification site, whereby the 79th residue (a lysine), from the start of the H3 histone protein is di-methylated. [http://en.wikipedia.org/wiki/Histone]', 2304, 0, 0);
INSERT INTO chado.cvterm VALUES (2050, 23, 'H3K79_trimethylation_site', 'A kind of histone modification site, whereby the 79th residue (a lysine), from the start of the H3 histone protein is tri-methylated. [http://en.wikipedia.org/wiki/Histone]', 2305, 0, 0);
INSERT INTO chado.cvterm VALUES (2051, 23, 'H4K20_monomethylation_site', 'A kind of histone modification site, whereby the 20th residue (a lysine), from the start of the H4histone protein is mono-methylated. [http://en.wikipedia.org/wiki/Histone]', 2306, 0, 0);
INSERT INTO chado.cvterm VALUES (2052, 23, 'H2BK5_monomethylation_site', 'A kind of histone modification site, whereby the 5th residue (a lysine), from the start of the H2B protein is methylated. [http://en.wikipedia.org/wiki/Histone]', 2307, 0, 0);
INSERT INTO chado.cvterm VALUES (2053, 23, 'ISRE', 'An ISRE is a transcriptional cis regulatory region, containing the consensus region: YAGTTTC(A/T)YTTTYCC, responsible for increased transcription via interferon binding. [http://genesdev.cshlp.org/content/2/4/383.abstrac]', 2308, 0, 0);
INSERT INTO chado.cvterm VALUES (2054, 23, 'histone_ubiqitination_site', 'A histone modification site where ubiquitin may be added. [SO:ke]', 2309, 0, 0);
INSERT INTO chado.cvterm VALUES (2055, 23, 'H2B_ubiquitination_site', 'A histone modification site on H2B where ubiquitin may be added. [SO:ke]', 2310, 0, 0);
INSERT INTO chado.cvterm VALUES (2056, 23, 'H3K18_acetylation_site', 'A kind of histone modification site, whereby the 18th residue (a lysine), from the start of the H3 histone protein is acetylated. [SO:ke]', 2311, 0, 0);
INSERT INTO chado.cvterm VALUES (2057, 23, 'H3K23_acetylation_site', 'A kind of histone modification, whereby the 23rd residue (a lysine), from the start of the H3 histone protein is acetylated. [SO:ke]', 2312, 0, 0);
INSERT INTO chado.cvterm VALUES (2058, 23, 'H3K27_acylation_site', 'A kind of histone modification site, whereby the 27th residue (a lysine), from the start of the H3 histone protein is acylated. [SO:ke]', 2313, 1, 0);
INSERT INTO chado.cvterm VALUES (2059, 23, 'H3K36_monomethylation_site', 'A kind of histone modification site, whereby the 36th residue (a lysine), from the start of the H3 histone protein is mono-methylated. [SO:ke]', 2314, 0, 0);
INSERT INTO chado.cvterm VALUES (2060, 23, 'H3K36_methylation_site', 'A kind of histone modification site, whereby the 36th residue (a lysine), from the start of the H3 histone protein is methylated. [SO:ke]', 2315, 0, 0);
INSERT INTO chado.cvterm VALUES (2061, 23, 'H3K36_dimethylation_site', 'A kind of histone modification site, whereby the 36th residue (a lysine), from the start of the H3 histone protein is dimethylated. [SO:ke]', 2316, 0, 0);
INSERT INTO chado.cvterm VALUES (2062, 23, 'H3K36_trimethylation_site', 'A kind of histone modification site, whereby the 36th residue (a lysine), from the start of the H3 histone protein is tri-methylated. [SO:ke]', 2317, 0, 0);
INSERT INTO chado.cvterm VALUES (2063, 23, 'H3K4_dimethylation_site', 'A kind of histone modification site, whereby the 4th residue (a lysine), from the start of the H3 histone protein is di-methylated. [SO:ke]', 2318, 0, 0);
INSERT INTO chado.cvterm VALUES (2064, 23, 'H3K27_dimethylation_site', 'A kind of histone modification site, whereby the 27th residue (a lysine), from the start of the H3 histone protein is di-methylated. [SO:ke]', 2319, 0, 0);
INSERT INTO chado.cvterm VALUES (2065, 23, 'H3K9_monomethylation_site', 'A kind of histone modification site, whereby the 9th residue (a lysine), from the start of the H3 histone protein is mono-methylated. [SO:ke]', 2320, 0, 0);
INSERT INTO chado.cvterm VALUES (2066, 23, 'H3K9_dimethylation_site', 'A kind of histone modification site, whereby the 9th residue (a lysine), from the start of the H3 histone protein may be dimethylated. [SO:ke]', 2321, 0, 0);
INSERT INTO chado.cvterm VALUES (2067, 23, 'H4K16_acetylation_site', 'A kind of histone modification site, whereby the 16th residue (a lysine), from the start of the H4 histone protein is acetylated. [SO:ke]', 2322, 0, 0);
INSERT INTO chado.cvterm VALUES (2068, 23, 'histone_4_acetylation_site', 'A histone 4 modification where the modification is the acetylation of the residue. [EBI:nj, ISBN:0815341059, SO:ke]', 2323, 0, 0);
INSERT INTO chado.cvterm VALUES (2069, 23, 'H4K5_acetylation_site', 'A kind of histone modification site, whereby the 5th residue (a lysine), from the start of the H4 histone protein is acetylated. [SO:ke]', 2324, 0, 0);
INSERT INTO chado.cvterm VALUES (2070, 23, 'H4K8_acetylation_site', 'A kind of histone modification site, whereby the 8th residue (a lysine), from the start of the H4 histone protein is acetylated. [SO:KE]', 2325, 0, 0);
INSERT INTO chado.cvterm VALUES (2071, 23, 'histone_acylation_region', 'A histone modification, whereby the histone protein is acylated at multiple sites in a region. [SO:ke]', 2326, 0, 0);
INSERT INTO chado.cvterm VALUES (2072, 23, 'H4K_acylation_region', 'A region of the H4 histone whereby multiple lysines are acylated. [SO:ke]', 2327, 0, 0);
INSERT INTO chado.cvterm VALUES (2073, 23, 'gene_with_non_canonical_start_codon', 'A gene with a start codon other than AUG. [SO:xp]', 2328, 0, 0);
INSERT INTO chado.cvterm VALUES (2074, 23, 'gene_with_start_codon_CUG', 'A gene with a translational start codon of CUG. [SO:mc]', 2329, 0, 0);
INSERT INTO chado.cvterm VALUES (2075, 23, 'pseudogenic_gene_segment', 'A gene segment which when incorporated by somatic recombination in the final gene transcript results in a nonfunctional product. [SO:hd]', 2330, 0, 0);
INSERT INTO chado.cvterm VALUES (2076, 23, 'gene_segment', 'A gene component region which acts as a recombinational unit of a gene whose functional form is generated through somatic recombination. [GOC:add]', 2331, 0, 0);
INSERT INTO chado.cvterm VALUES (2077, 23, 'copy_number_gain', 'A sequence alteration whereby the copy number of a given regions is greater than the reference sequence. [SO:ke]', 2332, 0, 0);
INSERT INTO chado.cvterm VALUES (2078, 23, 'copy_number_loss', 'A sequence alteration whereby the copy number of a given region is less than the reference sequence. [SO:ke]', 2333, 0, 0);
INSERT INTO chado.cvterm VALUES (2079, 23, 'UPD', 'Uniparental disomy is a sequence_alteration where a diploid individual receives two copies for all or part of a chromosome from one parent and no copies of the same chromosome or region from the other parent. [SO:BM]', 2334, 0, 0);
INSERT INTO chado.cvterm VALUES (2080, 23, 'maternal_uniparental_disomy', 'Uniparental disomy is a sequence_alteration where a diploid individual receives two copies for all or part of a chromosome from the mother and no copies of the same chromosome or region from the father. [SO:bm]', 2335, 0, 0);
INSERT INTO chado.cvterm VALUES (2081, 23, 'paternal_uniparental_disomy', 'Uniparental disomy is a sequence_alteration where a diploid individual receives two copies for all or part of a chromosome from the father and no copies of the same chromosome or region from the mother. [SO:bm]', 2336, 0, 0);
INSERT INTO chado.cvterm VALUES (2082, 23, 'open_chromatin_region', 'A DNA sequence that in the normal state of the chromosome corresponds to an unfolded, un-complexed stretch of double-stranded DNA. [SO:cb]', 2337, 0, 0);
INSERT INTO chado.cvterm VALUES (2083, 23, 'SL3_acceptor_site', 'A SL2_acceptor_site which appends the SL3 RNA leader sequence to the 5'' end of an mRNA. SL3 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]', 2338, 0, 0);
INSERT INTO chado.cvterm VALUES (2084, 23, 'SL4_acceptor_site', 'A SL2_acceptor_site which appends the SL4 RNA leader sequence to the 5'' end of an mRNA. SL4 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]', 2339, 0, 0);
INSERT INTO chado.cvterm VALUES (2085, 23, 'SL5_acceptor_site', 'A SL2_acceptor_site which appends the SL5 RNA leader sequence to the 5'' end of an mRNA. SL5 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]', 2340, 0, 0);
INSERT INTO chado.cvterm VALUES (2086, 23, 'SL6_acceptor_site', 'A SL2_acceptor_site which appends the SL6 RNA leader sequence to the 5'' end of an mRNA. SL6 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]', 2341, 0, 0);
INSERT INTO chado.cvterm VALUES (2087, 23, 'SL7_acceptor_site', 'A SL2_acceptor_site which appends the SL7 RNA leader sequence to the 5'' end of an mRNA. SL7 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]', 2342, 0, 0);
INSERT INTO chado.cvterm VALUES (2088, 23, 'SL8_acceptor_site', 'A SL2_acceptor_site which appends the SL8 RNA leader sequence to the 5'' end of an mRNA. SL8 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]', 2343, 0, 0);
INSERT INTO chado.cvterm VALUES (2089, 23, 'SL9_acceptor_site', 'A SL2_acceptor_site which appends the SL9 RNA leader sequence to the 5'' end of an mRNA. SL9 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]', 2344, 0, 0);
INSERT INTO chado.cvterm VALUES (2090, 23, 'SL10_acceptor_site', 'A SL2_acceptor_site which appends the SL10 RNA leader sequence to the 5'' end of an mRNA. SL10 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]', 2345, 0, 0);
INSERT INTO chado.cvterm VALUES (2091, 23, 'SL11_acceptor_site', 'A SL2_acceptor_site which appends the SL11 RNA leader sequence to the 5'' end of an mRNA. SL11 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]', 2346, 0, 0);
INSERT INTO chado.cvterm VALUES (2092, 23, 'SL12_acceptor_site', 'A SL2_acceptor_site which appends the SL12 RNA leader sequence to the 5'' end of an mRNA. SL12 acceptor sites occur in genes in internal segments of polycistronic transcripts. [SO:nlw]', 2347, 0, 0);
INSERT INTO chado.cvterm VALUES (2093, 23, 'duplicated_pseudogene', 'A pseudogene that arose via gene duplication. Generally duplicated pseudogenes have the same structure as the original gene, including intron-exon structure and some regulatory sequence. [http://en.wikipedia.org/wiki/Pseudogene]', 2348, 0, 0);
INSERT INTO chado.cvterm VALUES (2094, 23, 'unitary_pseudogene', 'A pseudogene, deactivated from original state by mutation, fixed in a population,where the ortholog in a reference species such as mouse remains functional. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, http://en.wikipedia.org/wiki/Pseudogene, SO:ke]', 2349, 0, 0);
INSERT INTO chado.cvterm VALUES (2095, 23, 'variant_quality', 'A dependent entity that inheres in a bearer, a sequence variant. [PMID:17597783, SO:ke]', 2350, 0, 0);
INSERT INTO chado.cvterm VALUES (2096, 23, 'variant_origin', 'A quality inhering in a variant by virtue of its origin. [PMID:17597783, SO:ke]', 2351, 0, 0);
INSERT INTO chado.cvterm VALUES (2097, 23, 'variant_frequency', 'A physical quality which inheres to the variant by virtue of the number instances of the variant within a population. [PMID:17597783, SO:ke]', 2352, 0, 0);
INSERT INTO chado.cvterm VALUES (2098, 23, 'unique_variant', 'A physical quality which inheres to the variant by virtue of the number instances of the variant within a population. [SO:ke]', 2353, 0, 0);
INSERT INTO chado.cvterm VALUES (2099, 23, 'rare_variant', 'When a variant from the genomic sequence is rarely found in the general population. The threshold for ''rare'' varies between studies. []', 2354, 0, 0);
INSERT INTO chado.cvterm VALUES (2100, 23, 'polymorphic_variant', 'A variant that affects one of several possible alleles at that location, such as the major histocompatibility complex (MHC) genes. []', 2355, 0, 0);
INSERT INTO chado.cvterm VALUES (2101, 23, 'common_variant', 'When a variant from the genomic sequence is commonly found in the general population. []', 2356, 0, 0);
INSERT INTO chado.cvterm VALUES (2102, 23, 'fixed_variant', 'When a variant has become fixed in the population so that it is now the only variant. []', 2357, 0, 0);
INSERT INTO chado.cvterm VALUES (2103, 23, 'variant_phenotype', 'A quality inhering in a variant by virtue of its phenotype. [PMID:17597783, SO:ke]', 2358, 0, 0);
INSERT INTO chado.cvterm VALUES (2106, 23, 'disease_causing_variant', 'A variant that has been found to cause disease. []', 2361, 0, 0);
INSERT INTO chado.cvterm VALUES (2107, 23, 'lethal_variant', 'A sequence variant where the mutated gene product does not allow for one or more basic functions necessary for survival. []', 2362, 0, 0);
INSERT INTO chado.cvterm VALUES (2108, 23, 'quantitative_variant', 'A variant within a gene that contributes to a quantitative trait such as height or weight. []', 2363, 0, 0);
INSERT INTO chado.cvterm VALUES (2109, 23, 'maternal_variant', 'A variant in the genetic material inherited from the mother. []', 2364, 0, 0);
INSERT INTO chado.cvterm VALUES (2110, 23, 'paternal_variant', 'A variant in the genetic material inherited from the father. []', 2365, 0, 0);
INSERT INTO chado.cvterm VALUES (2111, 23, 'somatic_variant', 'A variant that has arisen after splitting of the embryo, resulting in the variant being found in only some of the tissues or cells of the body. []', 2366, 0, 0);
INSERT INTO chado.cvterm VALUES (2112, 23, 'germline_variant', 'A variant present in the embryo that is carried by every cell in the body. []', 2367, 0, 0);
INSERT INTO chado.cvterm VALUES (2113, 23, 'pedigree_specific_variant', 'A variant that is found only by individuals that belong to the same pedigree. []', 2368, 0, 0);
INSERT INTO chado.cvterm VALUES (2114, 23, 'population_specific_variant', 'A variant found within only speficic populations. []', 2369, 0, 0);
INSERT INTO chado.cvterm VALUES (2115, 23, 'de_novo_variant', 'A variant arising in the offspring that is not found in either of the parents. []', 2370, 0, 0);
INSERT INTO chado.cvterm VALUES (2116, 23, 'TF_binding_site_variant', 'A sequence variant located within a transcription factor binding site. [EBI:fc]', 2371, 0, 0);
INSERT INTO chado.cvterm VALUES (2117, 23, 'complex_structural_alteration', 'A structural sequence alteration or rearrangement encompassing one or more genome fragments, with 4 or more breakpoints. [FB:reference_manual, NCBI:th, SO:ke]', 2372, 0, 0);
INSERT INTO chado.cvterm VALUES (2118, 23, 'loss_of_heterozygosity', 'A functional variant whereby the sequence alteration causes a loss of function of one allele of a gene. [SO:ke]', 2374, 0, 0);
INSERT INTO chado.cvterm VALUES (2119, 23, 'splice_donor_5th_base_variant', 'A sequence variant that causes a change at the 5th base pair after the start of the intron in the orientation of the transcript. [EBI:gr]', 2375, 0, 0);
INSERT INTO chado.cvterm VALUES (2120, 23, 'U_box', 'An U-box is a conserved T-rich region upstream of a retroviral polypurine tract that is involved in PPT primer creation during reverse transcription. [PMID:10556309, PMID:11577982, PMID:9649446]', 2376, 0, 0);
INSERT INTO chado.cvterm VALUES (2121, 23, 'mating_type_region', 'A specialized region in the genomes of some yeast and fungi, the genes of which regulate mating type. [SO:ke]', 2377, 0, 0);
INSERT INTO chado.cvterm VALUES (2122, 23, 'non_coding_transcript_exon_variant', 'A sequence variant that changes non-coding exon sequence in a non-coding transcript. [EBI:fc, SO:ke]', 2378, 0, 0);
INSERT INTO chado.cvterm VALUES (2123, 23, 'clone_end', 'A read from an end of the clone sequence. [SO:ke]', 2379, 0, 0);
INSERT INTO chado.cvterm VALUES (2124, 23, 'regional_centromere', 'A regional centromere is a large modular centromere found in fission yeast and higher eukaryotes. It consist of a central core region flanked by inverted inner and outer repeat regions. [PMID:7502067, SO:vw]', 2380, 0, 0);
INSERT INTO chado.cvterm VALUES (2125, 23, 'regional_centromere_central_core', 'A conserved region within the central region of a modular centromere, where the kinetochore is formed. [SO:vw]', 2381, 0, 0);
INSERT INTO chado.cvterm VALUES (2126, 23, 'centromeric_repeat', 'A repeat region found within the modular centromere. [SO:ke]', 2382, 0, 0);
INSERT INTO chado.cvterm VALUES (2127, 23, 'regional_centromere_inner_repeat_region', 'The inner inverted repeat region of a modular centromere and part of the central core surrounding a non-conserved central region. This region is adjacent to the central core, on each chromosome arm. [SO:vw]', 2383, 0, 0);
INSERT INTO chado.cvterm VALUES (2128, 23, 'regional_centromere_outer_repeat_region', 'The heterochromatic outer repeat region of a modular centromere. These repeats exist in tandem arrays on both chromosome arms. [SO:vw]', 2384, 0, 0);
INSERT INTO chado.cvterm VALUES (2129, 23, 'tasiRNA', 'The sequence of a 21 nucleotide double stranded, polyadenylated non coding RNA, transcribed from the TAS gene. [PMID:16145017]', 2385, 0, 0);
INSERT INTO chado.cvterm VALUES (2130, 23, 'tasiRNA_primary_transcript', 'A primary transcript encoding a tasiRNA. [PMID:16145017]', 2386, 0, 0);
INSERT INTO chado.cvterm VALUES (2131, 23, 'increased_polyadenylation_variant', 'A transcript processing variant whereby polyadenylation of the encoded transcript is increased with respect to the reference. [SO:ke]', 2387, 0, 0);
INSERT INTO chado.cvterm VALUES (2132, 23, 'decreased_polyadenylation_variant', 'A transcript processing variant whereby polyadenylation of the encoded transcript is decreased with respect to the reference. [SO:ke]', 2388, 0, 0);
INSERT INTO chado.cvterm VALUES (2133, 23, 'DDB_box', 'A conserved polypeptide motif that mediates protein-protein interaction and defines adaptor proteins for DDB1/cullin 4 ubiquitin ligases. [PMID:18794354, PMID:19818632]', 2389, 0, 0);
INSERT INTO chado.cvterm VALUES (2134, 23, 'destruction_box', 'A conserved polypeptide motif that can be recognized by both Fizzy/Cdc20- and FZR/Cdh1-activated anaphase-promoting complex/cyclosome (APC/C) and targets a protein for ubiquitination and subsequent degradation by the APC/C. The consensus sequence is RXXLXXXXN. [PMID:12208841, PMID:1842691]', 2390, 0, 0);
INSERT INTO chado.cvterm VALUES (2135, 23, 'polypeptide_conserved_motif', 'A conserved motif is a short (up to 20 amino acids) region of biological interest that is conserved in different proteins. They may or may not have functional or structural significance within the proteins in which they are found. [EBIBS:GAR]', 2391, 0, 0);
INSERT INTO chado.cvterm VALUES (2136, 23, 'ER_retention_signal', 'A C-terminal tetrapeptide motif that mediates retention of a protein in (or retrieval to) the endoplasmic reticulum. In mammals the sequence is KDEL, and in fungi HDEL or DDEL. [doi:10.1093/jxb/50.331.157, PMID:2077689]', 2392, 0, 0);
INSERT INTO chado.cvterm VALUES (2137, 23, 'KEN_box', 'A conserved polypeptide motif that can be recognized by FZR/Cdh1-activated anaphase-promoting complex/cyclosome (APC/C) and targets a protein for ubiquitination and subsequent degradation by the APC/C. The consensus sequence is KENXXXN. [PMID:10733526, PMID:1220884, PMID:18426916]', 2393, 0, 0);
INSERT INTO chado.cvterm VALUES (2138, 23, 'mitochondrial_targeting_signal', 'A polypeptide region that targets a polypeptide to the mitochondrion. [PomBase:mah]', 2394, 0, 0);
INSERT INTO chado.cvterm VALUES (2139, 23, 'signal_anchor', 'A signal sequence that is not cleaved from the polypeptide. Anchors a Type II membrane protein to the membrane. [http://www.cbs.dtu.dk/services/SignalP/background/biobackground.php]', 2395, 0, 0);
INSERT INTO chado.cvterm VALUES (2140, 23, 'PIP_box', 'A polypeptide region that mediates binding to PCNA. The consensus sequence is QXX(hh)XX(aa), where (h) denotes residues with moderately hydrophobic side chains and (a) denotes residues with highly hydrophobic aromatic side chains. [PMID:9631646]', 2396, 0, 0);
INSERT INTO chado.cvterm VALUES (2141, 23, 'phosphorylation_site', 'A post-translationally modified region in which residues of the protein are modified by phosphorylation. [PomBase:mah]', 2397, 0, 0);
INSERT INTO chado.cvterm VALUES (2142, 23, 'transmembrane_helix', 'A region that traverses the lipid bilayer and adopts a helical secondary structure. [PomBase:mah]', 2398, 0, 0);
INSERT INTO chado.cvterm VALUES (2143, 23, 'vacuolar_sorting_signal', 'A polypeptide region that targets a polypeptide to the vacuole. [PomBase:mah]', 2399, 0, 0);
INSERT INTO chado.cvterm VALUES (2144, 23, 'coding_variant_quality', 'An attribute of a coding genomic variant. []', 2400, 0, 0);
INSERT INTO chado.cvterm VALUES (2145, 23, 'synonymous', 'A variant that does not lead to any change in the amino acid sequence. []', 2401, 0, 0);
INSERT INTO chado.cvterm VALUES (2146, 23, 'non_synonymous', 'A variant that leads to the change of an amino acid within the protein. []', 2402, 0, 0);
INSERT INTO chado.cvterm VALUES (2147, 23, 'inframe', 'An attribute describing a sequence that contains a mutation involving the deletion or insertion of one or more bases, where this number is divisible by 3. [SO:ke]', 2403, 0, 0);
INSERT INTO chado.cvterm VALUES (2148, 23, 'inframe_indel', 'A coding sequence variant where the change does not alter the frame of the transcript. [SO:ke]', 2405, 0, 0);
INSERT INTO chado.cvterm VALUES (2149, 23, 'inframe_insertion', 'An inframe non synonymous variant that inserts bases into in the coding sequence. [EBI:gr]', 2406, 0, 0);
INSERT INTO chado.cvterm VALUES (2150, 23, 'internal_feature_elongation', 'A sequence variant that causes the extension of a genomic feature from within the feature rather than from the terminus of the feature, with regard to the reference sequence. [SO:ke]', 2408, 0, 0);
INSERT INTO chado.cvterm VALUES (2151, 23, 'inframe_deletion', 'An inframe non synonymous variant that deletes bases from the coding sequence. [EBI:gr]', 2409, 0, 0);
INSERT INTO chado.cvterm VALUES (2152, 23, 'conservative_inframe_insertion', 'An inframe increase in cds length that inserts one or more codons into the coding sequence between existing codons. [EBI:gr]', 2411, 0, 0);
INSERT INTO chado.cvterm VALUES (2153, 23, 'disruptive_inframe_insertion', 'An inframe increase in cds length that inserts one or more codons into the coding sequence within an existing codon. [EBI:gr]', 2412, 0, 0);
INSERT INTO chado.cvterm VALUES (2154, 23, 'conservative_inframe_deletion', 'An inframe decrease in cds length that deletes one or more entire codons from the coding sequence but does not change any remaining codons. [EBI:gr]', 2413, 0, 0);
INSERT INTO chado.cvterm VALUES (2155, 23, 'disruptive_inframe_deletion', 'An inframe decrease in cds length that deletes bases from the coding sequence starting within an existing codon. [EBI:gr]', 2414, 0, 0);
INSERT INTO chado.cvterm VALUES (2156, 23, 'mRNA_read', 'A sequencer read of an mRNA substrate. [SO:ke]', 2415, 0, 0);
INSERT INTO chado.cvterm VALUES (2157, 23, 'genomic_DNA_read', 'A sequencer read of a genomic DNA substrate. [SO:ke]', 2416, 0, 0);
INSERT INTO chado.cvterm VALUES (2158, 23, 'mRNA_contig', 'A contig composed of mRNA_reads. [SO:ke]', 2417, 0, 0);
INSERT INTO chado.cvterm VALUES (2159, 23, 'AFLP_fragment', 'A PCR product obtained by applying the AFLP technique, based on a restriction enzyme digestion of genomic DNA and an amplification of the resulting fragments. [GMOD:ea]', 2418, 0, 0);
INSERT INTO chado.cvterm VALUES (2160, 23, 'protein_hmm_match', 'A match to a protein HMM such as pfam. [SO:ke]', 2419, 0, 0);
INSERT INTO chado.cvterm VALUES (2161, 23, 'immunoglobulin_region', 'A region of immunoglobulin sequence, either constant or variable. [SO:ke]', 2420, 0, 0);
INSERT INTO chado.cvterm VALUES (2162, 23, 'V_region', 'The variable region of an immunoglobulin polypeptide sequence. [SO:ke]', 2421, 0, 0);
INSERT INTO chado.cvterm VALUES (2163, 23, 'C_region', 'The constant region of an immunoglobulin polypeptide sequence. [SO:ke]', 2422, 0, 0);
INSERT INTO chado.cvterm VALUES (2164, 23, 'N_region', 'Extra nucleotides inserted between rearranged immunoglobulin segments. [SO:ke]', 2423, 0, 0);
INSERT INTO chado.cvterm VALUES (2165, 23, 'S_region', 'The switch region of immunoglobulin heavy chains; it is involved in the rearrangement of heavy chain DNA leading to the expression of a different immunoglobulin classes from the same B-cell. [SO:ke]', 2424, 0, 0);
INSERT INTO chado.cvterm VALUES (2166, 23, 'mobile_element_insertion', 'A kind of insertion where the inserted sequence is a mobile element. [EBI:dvga]', 2425, 0, 0);
INSERT INTO chado.cvterm VALUES (2167, 23, 'novel_sequence_insertion', 'An insertion the sequence of which cannot be mapped to the reference genome. [NCBI:th]', 2426, 0, 0);
INSERT INTO chado.cvterm VALUES (2168, 23, 'CSL_response_element', 'A promoter element with consensus sequence GTGRGAA, bound by CSL (CBF1/RBP-JK/Suppressor of Hairless/LAG-1) transcription factors. [PMID:19101542]', 2427, 0, 0);
INSERT INTO chado.cvterm VALUES (2169, 23, 'GATA_box', 'A GATA transcription factor element containing the consensus sequence WGATAR (in which W indicates A/T and R indicates A/G). [PMID:8321208]', 2428, 0, 0);
INSERT INTO chado.cvterm VALUES (2170, 23, 'polymorphic_pseudogene', 'A pseudogene in the reference genome, though known to be intact in the genomes of other individuals of the same species. The annotation process has confirmed that the pseudogenisation event is not a genomic sequencing error. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, JAX:hd]', 2429, 0, 0);
INSERT INTO chado.cvterm VALUES (2171, 23, 'AP_1_binding_site', 'A promoter element with consensus sequence TGACTCA, bound by AP-1 and related transcription factors. [PMID:1899230, PMID:3034432, PMID:3125983]', 2430, 0, 0);
INSERT INTO chado.cvterm VALUES (2172, 23, 'CRE', 'MERGED DEFINITION:\nTARGET DEFINITION: A promoter element with consensus sequence TGACGTCA; bound by the ATF/CREB family of transcription factors.\n--------------------\nSOURCE DEFINITION: A promoter element that contains a core sequence TGACGT, bound by a protein complex that regulates transcription of genes encoding PKA pathway components. [PMID:11483355, PMID:11483993, PMID:15448137]', 2431, 0, 0);
INSERT INTO chado.cvterm VALUES (2173, 23, 'CuRE', 'A promoter element bound by copper ion-sensing transcription factors such as S. cerevisiae Mac1p or S. pombe Cuf1; the consensus sequence is HTHNNGCTGD (more specifically TTTGCKCR in budding yeast). [PMID:10593913, PMID:9188496, PMID:9211922]', 2433, 0, 0);
INSERT INTO chado.cvterm VALUES (2174, 23, 'DRE', 'A promoter element with consensus sequence CGWGGWNGMM, bound by transcription factors related to RecA and found in promoters of genes expressed following several types of DNA damage or inhibition of DNA synthesis. [PMID:11073995, PMID:8668127]', 2434, 0, 0);
INSERT INTO chado.cvterm VALUES (2175, 23, 'FLEX_element', 'A promoter element that has consensus sequence GTAAACAAACAAAM and contains a heptameric core GTAAACA, bound by transcription factors with a forkhead DNA-binding domain. [PMID:10747048, PMID:14871934]', 2435, 0, 0);
INSERT INTO chado.cvterm VALUES (2176, 23, 'forkhead_motif', 'A promoter element with consensus sequence TTTRTTTACA, bound by transcription factors with a forkhead DNA-binding domain. [PMID:15195092]', 2436, 0, 0);
INSERT INTO chado.cvterm VALUES (2177, 23, 'homol_D_box', 'A core promoter element that has the consensus sequence CAGTCACA (or its inverted form TGTGACTG), and plays the role of a TATA box in promoters that do not contain a canonical TATA sequence. [PMID:21673110, PMID:7501449, PMID:8458332]', 2437, 0, 0);
INSERT INTO chado.cvterm VALUES (2178, 23, 'homol_E_box', 'A core promoter element that has the consensus sequence ACCCTACCCT (or its inverted form AGGGTAGGGT), and is found near the homol D box in some promoters that use a homol D box instead of a canonical TATA sequence. [PMID:7501449]', 2438, 0, 0);
INSERT INTO chado.cvterm VALUES (2179, 23, 'HSE', 'A promoter element that consists of at least three copies of the pentanucleotide NGAAN, bound by the heat shock transcription factor HSF. [PMID:17347150, PMID:8689565]', 2439, 0, 0);
INSERT INTO chado.cvterm VALUES (2180, 23, 'iron_repressed_GATA_element', 'A GATA promoter element with consensus sequence WGATAA, found in promoters of genes repressed in the presence of iron. [PMID:11956219, PMID:17211681]', 2440, 0, 0);
INSERT INTO chado.cvterm VALUES (2181, 23, 'mating_type_M_box', 'A promoter element with consensus sequence ACAAT, found in promoters of mating type M-specific genes in fission yeast and bound by the transcription factor Mat1-Mc. [PMID:9233811]', 2441, 0, 0);
INSERT INTO chado.cvterm VALUES (2182, 23, 'androgen_response_element', 'A non-palindromic sequence found in the promoters of genes whose expression is regulated in response to androgen. [PMID:21796522]', 2442, 0, 0);
INSERT INTO chado.cvterm VALUES (2183, 23, 'smFISH_probe', 'A smFISH is a probe that binds RNA in a single molecule in situ hybridization experiment. [PMID:18806792]', 2443, 0, 0);
INSERT INTO chado.cvterm VALUES (2184, 23, 'MCB', 'A promoter element with consensus sequence ACGCGT, bound by the transcription factor complex MBF (MCB-binding factor) and found in promoters of genes expressed during the G1/S transition of the cell cycle. [PMID:16285853]', 2444, 0, 0);
INSERT INTO chado.cvterm VALUES (2185, 23, 'CCAAT_motif', 'A promoter element with consensus sequence CCAAT, bound by a protein complex that represses transcription in response to low iron levels. [PMID:16963626]', 2445, 0, 0);
INSERT INTO chado.cvterm VALUES (2186, 23, 'Ace2_UAS', 'A promoter element with consensus sequence CCAGCC, bound by the fungal transcription factor Ace2. [PMID:16678171]', 2446, 0, 0);
INSERT INTO chado.cvterm VALUES (2187, 23, 'TR_box', 'A promoter element with consensus sequence TTCTTTGTTY, bound an HMG-box transcription factor such as S. pombe Ste11, and found in promoters of genes up-regulated early in meiosis. [PMID:1657709]', 2447, 0, 0);
INSERT INTO chado.cvterm VALUES (2188, 23, 'STREP_motif', 'A promoter element with consensus sequence CCCCTC, bound by the PKA-responsive zinc finger transcription factor Rst2. [PMID:11739717]', 2448, 0, 0);
INSERT INTO chado.cvterm VALUES (2189, 23, 'rDNA_intergenic_spacer_element', 'A DNA motif that contains a core consensus sequence AGGTAAGGGTAATGCAC, is found in the intergenic regions of rDNA repeats, and is bound by an RNA polymerase I transcription termination factor (e.g. S. pombe Reb1). The S. pombe telomeric repeat consensus is TTAC(0-1)A(0-1)G(1-8). [ISBN:978-0199638901, PMID:9016645]', 2449, 0, 0);
INSERT INTO chado.cvterm VALUES (2190, 23, 'sterol_regulatory_element', 'A 10-bp promoter element bound by sterol regulatory element binding proteins (SREBPs), found in promoters of genes involved in sterol metabolism. Many variants of the sequence ATCACCCCAC function as SREs. [GO:mah, PMID:11111080, PMID:16537923]', 2450, 0, 0);
INSERT INTO chado.cvterm VALUES (2191, 23, 'GT_dinucleotide_repeat', 'A dinucleotide repeat region composed of GT repeating elements. [SO:ke]', 2451, 0, 0);
INSERT INTO chado.cvterm VALUES (2192, 23, 'GTT_trinucleotide_repeat', 'A trinucleotide repeat region composed of GTT repeating elements. [SO:ke]', 2452, 0, 0);
INSERT INTO chado.cvterm VALUES (2193, 23, 'Sap1_recognition_motif', 'A DNA motif to which the S. pombe Sap1 protein binds. The consensus sequence is 5''-TARGCAGNTNYAACGMG-3''; it is found at the mating type locus, where it is important for mating type switching, and at replication fork barriers in rDNA repeats. [PMID:16166653, PMID:7651412]', 2453, 0, 0);
INSERT INTO chado.cvterm VALUES (2194, 23, 'CDRE_motif', 'An RNA polymerase II promoter element found in the promoters of genes regulated by calcineurin. The consensus sequence is GNGGCKCA. [PMID:16928959]', 2454, 0, 0);
INSERT INTO chado.cvterm VALUES (2195, 23, 'BAC_read_contig', 'A contig of BAC reads. [GMOD:ea]', 2455, 0, 0);
INSERT INTO chado.cvterm VALUES (2196, 23, 'candidate_gene', 'A gene suspected of being involved in the expression of a trait. [GMOD:ea]', 2456, 0, 0);
INSERT INTO chado.cvterm VALUES (2197, 23, 'positional_candidate_gene', 'A candidate gene whose association with a trait is based on the gene''s location on a chromosome. [GMOD:ea]', 2457, 0, 0);
INSERT INTO chado.cvterm VALUES (2198, 23, 'functional_candidate_gene', 'A candidate gene whose function has something in common biologically with the trait under investigation. [GMOD:ea]', 2458, 0, 0);
INSERT INTO chado.cvterm VALUES (2199, 23, 'enhancerRNA', 'A short ncRNA that is transcribed from an enhancer. May have a regulatory function. [doi:10.1038/465173a, SO:cjm]', 2459, 0, 0);
INSERT INTO chado.cvterm VALUES (2200, 23, 'PCB', 'A promoter element with consensus sequence GNAACR, bound by the transcription factor complex PBF (PCB-binding factor) and found in promoters of genes expressed during the M/G1 transition of the cell cycle. [GO:mah, PMID:12411492]', 2460, 0, 0);
INSERT INTO chado.cvterm VALUES (2201, 23, 'rearrangement_region', 'A region of a chromosome, where the chromosome has undergone a large structural rearrangement that altered the genome organization. There is no longer synteny to the reference genome. [NCBI:th, PMID:18564416]', 2461, 0, 0);
INSERT INTO chado.cvterm VALUES (2202, 23, 'interchromosomal_breakpoint', 'A rearrangement breakpoint between two different chromosomes. [NCBI:th]', 2462, 0, 0);
INSERT INTO chado.cvterm VALUES (2203, 23, 'intrachromosomal_breakpoint', 'A rearrangement breakpoint within the same chromosome. [NCBI:th]', 2463, 0, 0);
INSERT INTO chado.cvterm VALUES (2204, 23, 'unassigned_supercontig', 'A supercontig that is not been assigned to any ultracontig during a genome assembly project. [GMOD:ea]', 2464, 0, 0);
INSERT INTO chado.cvterm VALUES (2205, 23, 'feature_ablation', 'A sequence variant, caused by an alteration of the genomic sequence, where the deletion, is greater than the extent of the underlying genomic features. [SO:ke]', 2465, 0, 0);
INSERT INTO chado.cvterm VALUES (2206, 23, 'feature_amplification', 'A sequence variant, caused by an alteration of the genomic sequence, where the structural change, an amplification of sequence, is greater than the extent of the underlying genomic features. [SO:ke]', 2466, 0, 0);
INSERT INTO chado.cvterm VALUES (2207, 23, 'feature_translocation', 'A sequence variant, caused by an alteration of the genomic sequence, where the structural change, a translocation, is greater than the extent of the underlying genomic features. [SO:ke]', 2467, 0, 0);
INSERT INTO chado.cvterm VALUES (2208, 23, 'transcript_translocation', 'A feature translocation where the region contains a transcript. [SO:ke]', 2468, 0, 0);
INSERT INTO chado.cvterm VALUES (2209, 23, 'regulatory_region_translocation', 'A feature translocation where the region contains a regulatory region. [SO:ke]', 2469, 0, 0);
INSERT INTO chado.cvterm VALUES (2210, 23, 'TFBS_translocation', 'A feature translocation where the region contains a transcription factor binding site. [SO:ke]', 2470, 0, 0);
INSERT INTO chado.cvterm VALUES (2211, 23, 'transcript_fusion', 'A feature fusion where the deletion brings together transcript regions. [SO:ke]', 2471, 0, 0);
INSERT INTO chado.cvterm VALUES (2212, 23, 'regulatory_region_fusion', 'A feature fusion where the deletion brings together regulatory regions. [SO:ke]', 2472, 0, 0);
INSERT INTO chado.cvterm VALUES (2213, 23, 'TFBS_fusion', 'A fusion where the deletion brings together transcription factor binding sites. [SO:ke]', 2473, 0, 0);
INSERT INTO chado.cvterm VALUES (2214, 23, 'transcript_amplification', 'A feature amplification of a region containing a transcript. [SO:ke]', 2474, 0, 0);
INSERT INTO chado.cvterm VALUES (2215, 23, 'transcript_regulatory_region_fusion', 'A feature fusion where the deletion brings together a regulatory region and a transcript region. [SO:ke]', 2475, 0, 0);
INSERT INTO chado.cvterm VALUES (2216, 23, 'regulatory_region_amplification', 'A feature amplification of a region containing a regulatory region. [SO:ke]', 2476, 0, 0);
INSERT INTO chado.cvterm VALUES (2217, 23, 'TFBS_amplification', 'A feature amplification of a region containing a transcription factor binding site. [SO:ke]', 2477, 0, 0);
INSERT INTO chado.cvterm VALUES (2218, 23, 'transcript_ablation', 'A feature ablation whereby the deleted region includes a transcript feature. [SO:ke]', 2478, 0, 0);
INSERT INTO chado.cvterm VALUES (2219, 23, 'regulatory_region_ablation', 'A feature ablation whereby the deleted region includes a regulatory region. [SO:ke]', 2479, 0, 0);
INSERT INTO chado.cvterm VALUES (2220, 23, 'TFBS_ablation', 'A feature ablation whereby the deleted region includes a transcription factor binding site. [SO:ke]', 2480, 0, 0);
INSERT INTO chado.cvterm VALUES (2221, 23, 'transposable_element_CDS', 'A CDS that is part of a transposable element. [SO:ke]', 2481, 0, 0);
INSERT INTO chado.cvterm VALUES (2222, 23, 'transposable_element_pseudogene', 'A pseudogene contained within a transposable element. [SO:ke]', 2482, 0, 0);
INSERT INTO chado.cvterm VALUES (2223, 23, 'dg_repeat', 'A repeat region which is part of the regional centromere outer repeat region. [PMID:16407326, SO:vw]', 2483, 0, 0);
INSERT INTO chado.cvterm VALUES (2224, 23, 'dh_repeat', 'A repeat region which is part of the regional centromere outer repeat region. [PMID:16407326, SO:vw]', 2484, 0, 0);
INSERT INTO chado.cvterm VALUES (2225, 23, 'AACCCT_box', 'A conserved 17-bp sequence (5''-ATCA(C/A)AACCCTAACCCT-3'') commonly present upstream of the start site of histone transcription units functioning as a transcription factor binding site. [PMID:17452352, PMID:4092687]', 2485, 0, 0);
INSERT INTO chado.cvterm VALUES (2226, 23, 'splice_region', 'A region surrounding a cis_splice site, either within 1-3 bases of the exon or 3-8 bases of the intron. [SO:bm]', 2486, 0, 0);
INSERT INTO chado.cvterm VALUES (2227, 23, 'antisense_lncRNA', 'Non-coding RNA transcribed from the opposite DNA strand compared with other transcripts and overlap in part with sense RNA. [PMID:19638999]', 2487, 0, 0);
INSERT INTO chado.cvterm VALUES (2228, 23, 'regional_centromere_outer_repeat_transcript', 'A transcript that is transcribed from the outer repeat region of a regional centromere. [PomBase:mah]', 2488, 0, 0);
INSERT INTO chado.cvterm VALUES (2229, 23, 'frameshift_elongation', 'A frameshift variant that causes the translational reading frame to be extended relative to the reference feature. [SO:ke]', 2489, 0, 0);
INSERT INTO chado.cvterm VALUES (2230, 23, 'frameshift_truncation', 'A frameshift variant that causes the translational reading frame to be shortened relative to the reference feature. [SO:ke]', 2490, 0, 0);
INSERT INTO chado.cvterm VALUES (2231, 23, 'copy_number_increase', 'A sequence variant where copies of a feature are increased relative to the reference. [SO:ke]', 2491, 0, 0);
INSERT INTO chado.cvterm VALUES (2232, 23, 'copy_number_decrease', 'A sequence variant where copies of a feature are decreased relative to the reference. [SO:ke]', 2492, 0, 0);
INSERT INTO chado.cvterm VALUES (2233, 23, 'rDNA_replication_fork_barrier', 'A DNA motif that is found in eukaryotic rDNA repeats, and is a site of replication fork pausing. [PMID:14645529]', 2493, 0, 0);
INSERT INTO chado.cvterm VALUES (2234, 23, 'transcription_start_cluster', 'A region defined by a cluster of experimentally determined transcription starting sites. [PMID:19624849, PMID:21372179, SO:andrewgibson]', 2494, 0, 0);
INSERT INTO chado.cvterm VALUES (2235, 23, 'CAGE_tag', 'A CAGE tag is a sequence tag hat corresponds to 5'' ends of mRNA at cap sites, produced by cap analysis gene expression and used to identify transcriptional start sites. [SO:andrewgibson]', 2495, 0, 0);
INSERT INTO chado.cvterm VALUES (2236, 23, 'CAGE_cluster', 'A kind of transcription_initiation_cluster defined by the clustering of CAGE tags on a sequence region. [PMID:16645617, SO:andrewgibson]', 2496, 0, 0);
INSERT INTO chado.cvterm VALUES (2237, 23, '5_methylcytosine', 'A cytosine methylated at the 5 carbon. [SO:rtapella]', 2497, 0, 0);
INSERT INTO chado.cvterm VALUES (2238, 23, '4_methylcytosine', 'A cytosine methylated at the 4 nitrogen. [SO:rtapella]', 2498, 0, 0);
INSERT INTO chado.cvterm VALUES (2239, 23, 'N6_methyladenine', 'An adenine methylated at the 6 nitrogen. [SO:rtapella]', 2499, 0, 0);
INSERT INTO chado.cvterm VALUES (2240, 23, 'mitochondrial_contig', 'A contig of mitochondria derived sequences. [GMOD:ea]', 2500, 0, 0);
INSERT INTO chado.cvterm VALUES (2241, 23, 'mitochondrial_supercontig', 'A scaffold composed of mitochondrial contigs. [GMOD:ea]', 2501, 0, 0);
INSERT INTO chado.cvterm VALUES (2242, 23, 'TERRA', 'A non-coding RNA transcript, derived from the transcription of the telomere. These transcripts contain G rich telomeric RNA repeats and RNA tracts corresponding to adjacent subtelomeric sequences. They are 100-9000 bases long. [PMID:22139915]', 2502, 0, 0);
INSERT INTO chado.cvterm VALUES (2243, 23, 'telomeric_transcript', 'A non-coding transcript derived from the transcript of the telomere. [PMID:22139915]', 2503, 0, 0);
INSERT INTO chado.cvterm VALUES (2244, 23, 'ARRET', 'A non coding RNA transcript, complementary to subtelomeric tract of TERRA transcript but devoid of the repeats. [PMID:2139915]', 2504, 0, 0);
INSERT INTO chado.cvterm VALUES (2245, 23, 'ARIA', 'A non-coding RNA transcript, derived from the transcription of the telomere. These transcripts consist of C rich repeats. [PMID:22139915]', 2505, 0, 0);
INSERT INTO chado.cvterm VALUES (2246, 23, 'anti_ARRET', 'A non-coding RNA transcript, derived from the transcription of the telomere. These transcripts are antisense of ARRET transcripts. [PMID:22139915]', 2506, 0, 0);
INSERT INTO chado.cvterm VALUES (2247, 23, 'distal_duplication', 'A duplication of the distal region of a chromosome. [SO:bm]', 2507, 0, 0);
INSERT INTO chado.cvterm VALUES (2248, 23, 'duplication', 'An insertion which derives from, or is identical in sequence to, nucleotides present at a known location in the genome. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html, NCBI:th]', 2508, 0, 0);
INSERT INTO chado.cvterm VALUES (2249, 23, 'mitochondrial_DNA_read', 'A sequencer read of a mitochondrial DNA sample. [GMOD:ea]', 2509, 0, 0);
INSERT INTO chado.cvterm VALUES (2250, 23, 'chloroplast_DNA_read', 'A sequencer read of a chloroplast DNA sample. [GMOD:ea]', 2510, 0, 0);
INSERT INTO chado.cvterm VALUES (2251, 23, 'consensus_gDNA', 'Genomic DNA sequence produced from some base calling or alignment algorithm which uses aligned or assembled multiple gDNA sequences as input. [GMOD:ea]', 2511, 0, 0);
INSERT INTO chado.cvterm VALUES (2252, 23, 'restriction_enzyme_five_prime_single_strand_overhang', 'A terminal region of DNA sequence where the end of the region is not blunt ended and the exposed single strand terminates at the 5'' end. [SO:ke]', 2512, 0, 0);
INSERT INTO chado.cvterm VALUES (2253, 23, 'restriction_enzyme_three_prime_single_strand_overhang', 'A terminal region of DNA sequence where the end of the region is not blunt ended and the exposed single strand terminates at the 3'' end. [SO:ke]', 2513, 0, 0);
INSERT INTO chado.cvterm VALUES (2254, 23, 'monomeric_repeat', 'A repeat_region containing repeat_units of 1 bp that is repeated multiple times in tandem. [SO:ke]', 2514, 0, 0);
INSERT INTO chado.cvterm VALUES (2255, 23, 'H3K20_trimethylation_site', 'A kind of histone modification site, whereby the 20th residue (a lysine), from the start of the H3 protein is tri-methylated. [EBI:nj]', 2515, 0, 0);
INSERT INTO chado.cvterm VALUES (2256, 23, 'H3K36_acetylation_site', 'A kind of histone modification site, whereby the 36th residue (a lysine), from the start of the H3 histone protein is acetylated. [EBI:nj]', 2516, 0, 0);
INSERT INTO chado.cvterm VALUES (2257, 23, 'H2BK12_acetylation_site', 'A kind of histone modification site, whereby the 12th residue (a lysine), from the start of the H2B protein is acetylated. [EBI:nj]', 2517, 0, 0);
INSERT INTO chado.cvterm VALUES (2258, 23, 'histone_2B_acetylation_site', 'A histone 2B modification where the modification is the acetylation of the residue. [ISBN:0815341059]', 2518, 0, 0);
INSERT INTO chado.cvterm VALUES (2259, 23, 'H2AK5_acetylation_site', 'A kind of histone modification site, whereby the 5th residue (a lysine), from the start of the H2A histone protein is acetylated. [EBI:nj]', 2519, 0, 0);
INSERT INTO chado.cvterm VALUES (2260, 23, 'histone_2A_acetylation_site', 'A histone 2A modification where the modification is the acetylation of the residue. [ISBN:0815341059]', 2520, 0, 0);
INSERT INTO chado.cvterm VALUES (2261, 23, 'H4K12_acetylation_site', 'A kind of histone modification site, whereby the 12th residue (a lysine), from the start of the H4 histone protein is acetylated. [EBI:nj]', 2521, 0, 0);
INSERT INTO chado.cvterm VALUES (2262, 23, 'H2BK120_acetylation_site', 'A kind of histone modification site, whereby the 120th residue (a lysine), from the start of the H2B histone protein is acetylated. [EBI:nj, http://dx.doi.org/10.4161/epi.6.5.15623]', 2522, 0, 0);
INSERT INTO chado.cvterm VALUES (2263, 23, 'H4K91_acetylation_site', 'A kind of histone modification site, whereby the 91st residue (a lysine), from the start of the H4 histone protein is acetylated. [EBI:nj]', 2523, 0, 0);
INSERT INTO chado.cvterm VALUES (2264, 23, 'H2BK20_acetylation_site', 'A kind of histone modification site, whereby the 20th residue (a lysine), from the start of the H2B histone protein is acetylated. [EBI:nj]', 2524, 0, 0);
INSERT INTO chado.cvterm VALUES (2265, 23, 'H3K4_acetylation_site', 'A kind of histone modification site, whereby the 4th residue (a lysine), from the start of the H3 histone protein is acetylated. [EBI:nj]', 2525, 0, 0);
INSERT INTO chado.cvterm VALUES (2266, 23, 'H2AK9_acetylation_site', 'A kind of histone modification site, whereby the 9th residue (a lysine), from the start of the H2A histone protein is acetylated. [EBI:nj]', 2526, 0, 0);
INSERT INTO chado.cvterm VALUES (2267, 23, 'H3K56_acetylation_site', 'A kind of histone modification site, whereby the 56th residue (a lysine), from the start of the H3 histone protein is acetylated. [EBI:nj]', 2527, 0, 0);
INSERT INTO chado.cvterm VALUES (2268, 23, 'H2BK15_acetylation_site', 'A kind of histone modification site, whereby the 15th residue (a lysine), from the start of the H2B histone protein is acetylated. [EBI:nj]', 2528, 0, 0);
INSERT INTO chado.cvterm VALUES (2269, 23, 'H3R2_monomethylation_site', 'A kind of histone modification site, whereby the 2nd residue (an arginine), from the start of the H3 protein is mono-methylated. [EBI:nj]', 2529, 0, 0);
INSERT INTO chado.cvterm VALUES (2270, 23, 'H3R2_dimethylation_site', 'A kind of histone modification site, whereby the 2nd residue (an arginine), from the start of the H3 protein is di-methylated. [EBI:nj]', 2530, 0, 0);
INSERT INTO chado.cvterm VALUES (2271, 23, 'H4R3_dimethylation_site', 'A kind of histone modification site, whereby the 3nd residue (an arginine), from the start of the H4 protein is di-methylated. [EBI:nj]', 2531, 0, 0);
INSERT INTO chado.cvterm VALUES (2272, 23, 'H4K4_trimethylation_site', 'A kind of histone modification site, whereby the 4th residue (a lysine), from the start of the H4 protein is tri-methylated. [EBI:nj]', 2532, 0, 0);
INSERT INTO chado.cvterm VALUES (2273, 23, 'H3K23_dimethylation_site', 'A kind of histone modification site, whereby the 23rd residue (a lysine), from the start of the H3 protein is di-methylated. [EBI:nj]', 2533, 0, 0);
INSERT INTO chado.cvterm VALUES (2274, 23, 'promoter_flanking_region', 'A region immediately adjacent to a promoter which may or may not contain transcription factor binding sites. [EBI:nj]', 2534, 0, 0);
INSERT INTO chado.cvterm VALUES (2275, 23, 'restriction_enzyme_assembly_scar', 'A region of DNA sequence formed from the ligation of two sticky ends where the palindrome is broken and no longer comprises the recognition site and thus cannot be re-cut by the restriction enzymes used to create the sticky ends. [SO:ke]', 2535, 0, 0);
INSERT INTO chado.cvterm VALUES (2276, 23, 'protein_stability_element', 'A polypeptide region that proves structure in a protein that affects the stability of the protein. [SO:ke]', 2536, 0, 0);
INSERT INTO chado.cvterm VALUES (2277, 23, 'protease_site', 'A polypeptide_region that codes for a protease cleavage site. [SO:ke]', 2537, 0, 0);
INSERT INTO chado.cvterm VALUES (2278, 23, 'RNA_stability_element', 'RNA secondary structure that affects the stability of an RNA molecule. [SO:ke]', 2538, 1, 0);
INSERT INTO chado.cvterm VALUES (2279, 23, 'lariat_intron', 'A kind of intron whereby the excision is driven by lariat formation. [SO:ke]', 2539, 0, 0);
INSERT INTO chado.cvterm VALUES (2280, 23, 'TCT_motif', 'A cis-regulatory element, conserved sequence YYC+1TTTYY, and spans -2 to +6 relative to +1 TSS. It is present in most ribosomal protein genes in Drosophila and mammals but not in the yeast Saccharomyces cerevisiae. Resembles the initiator (TCAKTY in Drosophila) but functionally distinct from initiator. [PMID:20801935, SO:myl]', 2540, 0, 0);
INSERT INTO chado.cvterm VALUES (2281, 23, '5_hydroxymethylcytosine', 'A modified DNA cytosine base feature, modified by a hydroxymethyl group at the 5 carbon. [SO:ke]', 2541, 0, 0);
INSERT INTO chado.cvterm VALUES (2282, 23, '5_formylcytosine', 'A modified DNA cytosine base feature, modified by a formyl group at the 5 carbon. [SO:ke]', 2542, 0, 0);
INSERT INTO chado.cvterm VALUES (2283, 23, 'modified_guanine', 'A modified guanine DNA base feature. [SO:ke]', 2543, 0, 0);
INSERT INTO chado.cvterm VALUES (2284, 23, '8_oxoguanine', 'A modified DNA guanine base,at the 8 carbon, often the product of DNA damage. [SO:ke]', 2544, 0, 0);
INSERT INTO chado.cvterm VALUES (2285, 23, '5_carboxylcytosine', 'A modified DNA cytosine base feature, modified by a carboxy group at the 5 carbon. [SO:ke]', 2545, 0, 0);
INSERT INTO chado.cvterm VALUES (2286, 23, '8_oxoadenine', 'A modified DNA adenine base,at the 8 carbon, often the product of DNA damage. [SO:ke]', 2546, 0, 0);
INSERT INTO chado.cvterm VALUES (2287, 23, 'coding_transcript_intron_variant', 'A transcript variant occurring within an intron of a coding transcript. [SO:ke]', 2547, 0, 0);
INSERT INTO chado.cvterm VALUES (2288, 23, 'non_coding_transcript_intron_variant', 'A transcript variant occurring within an intron of a non coding transcript. [SO:ke]', 2548, 0, 0);
INSERT INTO chado.cvterm VALUES (2289, 23, 'zinc_finger_binding_site', 'A binding site to which a polypeptide will bind with a zinc finger motif, which is characterized by requiring one or more Zinc 2+ ions for stabilized folding. []', 2549, 0, 0);
INSERT INTO chado.cvterm VALUES (2290, 23, 'CTCF_binding_site', 'A transcription factor binding site with consensus sequence CCGCGNGGNGGCAG, bound by CCCTF-binding factor. [EBI:nj]', 2550, 0, 0);
INSERT INTO chado.cvterm VALUES (2291, 23, 'five_prime_sticky_end_restriction_enzyme_cleavage_site', 'A restriction enzyme recognition site that, when cleaved, results in 5 prime overhangs. [SO:ke]', 2551, 0, 0);
INSERT INTO chado.cvterm VALUES (2292, 23, 'three_prime_sticky_end_restriction_enzyme_cleavage_site', 'A restriction enzyme recognition site that, when cleaved, results in 3 prime overhangs. [SO:ke]', 2552, 0, 0);
INSERT INTO chado.cvterm VALUES (2293, 23, 'ribonuclease_site', 'A region of a transcript encoding the cleavage site for a ribonuclease enzyme. [SO:ke]', 2553, 0, 0);
INSERT INTO chado.cvterm VALUES (2294, 23, 'signature', 'A region of sequence where developer information is encoded. [SO:ke]', 2554, 0, 0);
INSERT INTO chado.cvterm VALUES (2295, 23, 'RNA_stability_element(SO:0001979)', 'A motif that affects the stability of RNA. [PMID:22495308, SO:ke]', 2555, 0, 0);
INSERT INTO chado.cvterm VALUES (2333, 23, 'start_retained_variant', 'A sequence variant where at least one base in the start codon is changed, but the start remains. [SO:ke]', 2593, 0, 0);
INSERT INTO chado.cvterm VALUES (2296, 23, 'G_box', 'A regulatory promoter element identified in mutation experiments, with consensus sequence: CACGTG. Present in promoters, intergenic regions, coding regions, and introns. They are involved in gene expression responses to light and interact with G-box binding factor and I-box binding factor 1a. [PMID:19249238, PMID:8571452, SO:ml]', 2556, 0, 0);
INSERT INTO chado.cvterm VALUES (2297, 23, 'L_box', 'An orientation dependent regulatory promoter element, with consensus sequence of TTGCACAN4TTGCACA, found in plants. [PMID:17381552, PMID:2902624, SO:ml]', 2557, 0, 0);
INSERT INTO chado.cvterm VALUES (2298, 23, 'I-box', 'A plant regulatory promoter motif, composed of a highly conserved hexamer GATAAG (I-box core). [PMID:2347304, PMID:2902624, SO:ml]', 2558, 0, 0);
INSERT INTO chado.cvterm VALUES (2299, 23, '5_prime_UTR_premature_start_codon_variant', 'A 5'' UTR variant where a premature start codon is introduced, moved or lost. [SANGER:am]', 2559, 0, 0);
INSERT INTO chado.cvterm VALUES (2300, 23, 'silent_mating_type_cassette_array', 'A gene cassette array that corresponds to a silenced version of a mating type region. [PomBase:mah]', 2560, 0, 0);
INSERT INTO chado.cvterm VALUES (2301, 23, 'gene_cassette_array', 'An array of non-functional genes whose members, when captured by recombination form functional genes. [SO:ma]', 2561, 0, 0);
INSERT INTO chado.cvterm VALUES (2302, 23, 'Okazaki_fragment', 'Any of the DNA segments produced by discontinuous synthesis of the lagging strand during DNA replication. [ISBN:0805350152]', 2562, 0, 0);
INSERT INTO chado.cvterm VALUES (2303, 23, 'upstream_transcript_variant', 'A feature variant, where the alteration occurs upstream of the transcript TSS. [EBI:gr]', 2563, 0, 0);
INSERT INTO chado.cvterm VALUES (2304, 23, 'downstream_transcript_variant', 'A feature variant, where the alteration occurs downstream of the transcript termination site. []', 2564, 0, 0);
INSERT INTO chado.cvterm VALUES (2305, 23, '5_prime_UTR_premature_start_codon_gain_variant', 'A 5'' UTR variant where a premature start codon is gained. [Sanger:am]', 2565, 0, 0);
INSERT INTO chado.cvterm VALUES (2306, 23, '5_prime_UTR_premature_start_codon_loss_variant', 'A 5'' UTR variant where a premature start codon is lost. [SANGER:am]', 2566, 0, 0);
INSERT INTO chado.cvterm VALUES (2307, 23, 'five_prime_UTR_premature_start_codon_location_variant', 'A 5'' UTR variant where a premature start codon is moved. [SANGER:am]', 2567, 0, 0);
INSERT INTO chado.cvterm VALUES (2308, 23, 'consensus_AFLP_fragment', 'A consensus AFLP fragment is an AFLP sequence produced from any alignment algorithm which uses assembled multiple AFLP sequences as input. [GMOD:ea]', 2568, 0, 0);
INSERT INTO chado.cvterm VALUES (2309, 23, 'extended_cis_splice_site', 'Intronic positions associated with cis-splicing. Contains the first and second positions immediately before the exon and the first, second and fifth positions immediately after. [SANGER:am]', 2569, 0, 0);
INSERT INTO chado.cvterm VALUES (2310, 23, 'intron_base_5', 'Fifth intronic position after the intron exon boundary, close to the 5'' edge of the intron. [SANGER:am]', 2570, 0, 0);
INSERT INTO chado.cvterm VALUES (2311, 23, 'extended_intronic_splice_region_variant', 'A sequence variant occurring in the intron, within 10 bases of exon. [sanger:am]', 2571, 0, 0);
INSERT INTO chado.cvterm VALUES (2312, 23, 'extended_intronic_splice_region', 'Region of intronic sequence within 10 bases of an exon. [SANGER:am]', 2572, 0, 0);
INSERT INTO chado.cvterm VALUES (2313, 23, 'subtelomere', 'A heterochromatic region of the chromosome, adjacent to the telomere (on the centromeric side) that contains repetitive DNA and sometimes genes and it is transcribed. [POMBE:al]', 2573, 0, 0);
INSERT INTO chado.cvterm VALUES (2314, 23, 'sgRNA', 'A small RNA oligo, typically about 20 bases, that guides the cas nuclease to a target DNA sequence in the CRISPR/cas mutagenesis method. [PMID:23934893]', 2574, 0, 0);
INSERT INTO chado.cvterm VALUES (2315, 23, 'mating_type_region_motif', 'DNA motif that is a component of a mating type region. [SO:ke]', 2575, 0, 0);
INSERT INTO chado.cvterm VALUES (2316, 23, 'Y_region', 'A segment of non-homology between a and alpha mating alleles, found at all three mating loci (HML, MAT, and HMR), has two forms (Ya and Yalpha). [SGD:jd]', 2576, 0, 0);
INSERT INTO chado.cvterm VALUES (2317, 23, 'Z1_region', 'A mating type region motif, one of two segments of homology found at all three mating loci (HML, MAT, and HMR). [SGD:jd]', 2577, 0, 0);
INSERT INTO chado.cvterm VALUES (2318, 23, 'Z2_region', 'A mating type region motif, the rightmost segment of homology in the HML and MAT mating loci (not present in HMR). [SGD:jd]', 2578, 0, 0);
INSERT INTO chado.cvterm VALUES (2319, 23, 'ARS_consensus_sequence', 'The ACS is an 11-bp sequence of the form 5''-WTTTAYRTTTW-3'' which is at the core of every yeast ARS, and is necessary but not sufficient for recognition and binding by the origin recognition complex (ORC). Functional ARSs require an ACS, as well as other cis elements in the 5'' (C domain) and 3'' (B domain) flanking sequences of the ACS. [SGD:jd]', 2579, 0, 0);
INSERT INTO chado.cvterm VALUES (2320, 23, 'DSR_motif', 'The determinant of selective removal (DSR) motif consists of repeats of U(U/C)AAAC. The motif targets meiotic transcripts for removal during mitosis via the exosome. [PMID:22645662]', 2580, 0, 0);
INSERT INTO chado.cvterm VALUES (2321, 23, 'zinc_repressed_element', 'A promoter element that has the consensus sequence GNMGATC, and is found in promoters of genes repressed in the presence of zinc. [PMID:24003116, POMBE:mh]', 2581, 0, 0);
INSERT INTO chado.cvterm VALUES (2322, 23, 'rare_amino_acid_variant', 'A sequence variant whereby at least one base of a codon encoding a rare amino acid is changed, resulting in a different encoded amino acid. [SO:ke]', 2582, 0, 0);
INSERT INTO chado.cvterm VALUES (2323, 23, 'selenocysteine_loss', 'A sequence variant whereby at least one base of a codon encoding selenocysteine is changed, resulting in a different encoded amino acid. [SO:ke]', 2583, 0, 0);
INSERT INTO chado.cvterm VALUES (2324, 23, 'pyrrolysine_loss', 'A sequence variant whereby at least one base of a codon encoding pyrrolysine is changed, resulting in a different encoded amino acid. [SO:ke]', 2584, 0, 0);
INSERT INTO chado.cvterm VALUES (2325, 23, 'intragenic_variant', 'A variant that occurs within a gene but falls outside of all transcript features. This occurs when alternate transcripts of a gene do not share overlapping sequence. [SO:ke]', 2585, 0, 0);
INSERT INTO chado.cvterm VALUES (2326, 23, 'start_lost', 'A codon variant that changes at least one base of the canonical start codon. [SO:ke]', 2586, 0, 0);
INSERT INTO chado.cvterm VALUES (2327, 23, '5_prime_UTR_truncation', 'A sequence variant that causes the reduction of a the 5''UTR with regard to the reference sequence. [SO:ke]', 2587, 0, 0);
INSERT INTO chado.cvterm VALUES (2328, 23, '5_prime_UTR_elongation', 'A sequence variant that causes the extension of 5'' UTR, with regard to the reference sequence. [SO:ke]', 2588, 0, 0);
INSERT INTO chado.cvterm VALUES (2329, 23, '3_prime_UTR_truncation', 'A sequence variant that causes the reduction of a the 3'' UTR with regard to the reference sequence. [SO:ke]', 2589, 0, 0);
INSERT INTO chado.cvterm VALUES (2330, 23, '3_prime_UTR_elongation', 'A sequence variant that causes the extension of 3'' UTR, with regard to the reference sequence. [SO:ke]', 2590, 0, 0);
INSERT INTO chado.cvterm VALUES (2331, 23, 'conserved_intergenic_variant', 'A sequence variant located in a conserved intergenic region, between genes. [SO:ke]', 2591, 0, 0);
INSERT INTO chado.cvterm VALUES (2332, 23, 'conserved_intron_variant', 'A transcript variant occurring within a conserved region of an intron. [SO:ke]', 2592, 0, 0);
INSERT INTO chado.cvterm VALUES (2334, 23, 'boundary_element', 'Boundary elements are DNA motifs that prevent heterochromatin from spreading into neighboring euchromatic regions. [PMID:24013502]', 2594, 0, 0);
INSERT INTO chado.cvterm VALUES (2335, 23, 'mating_type_region_replication_fork_barrier', 'A DNA motif that is found in eukaryotic rDNA repeats, and is a site of replication fork pausing. [PMID:17614787]', 2595, 0, 0);
INSERT INTO chado.cvterm VALUES (2336, 23, 'priRNA', 'A small RNA molecule, 22-23 nt in size, that is the product of a longer RNA. The production of priRNAs is independent of dicer and involves binding of RNA by argonaute and trimming by triman. In fission yeast, priRNAs trigger the establishment of heterochromatin. PriRNAs are primarily generated from centromeric transcripts (dg and dh repeats), but may also be produced from degradation products of primary transcripts. [PMID:20178743, PMID:24095277, PomBase:al]', 2596, 0, 0);
INSERT INTO chado.cvterm VALUES (2337, 23, 'multiplexing_sequence_identifier', 'A nucleic tag which is used in a ligation step of library preparation process to allow pooling of samples while maintaining ability to identify individual source material and creation of a multiplexed library. [OBO:prs, PMID:22574170]', 2597, 0, 0);
INSERT INTO chado.cvterm VALUES (2338, 23, 'W_region', 'The leftmost segment of homology in the HML and MAT mating loci, but not present in HMR. [SGD:jd]', 2598, 0, 0);
INSERT INTO chado.cvterm VALUES (2339, 23, 'cis_acting_homologous_chromosome_pairing_region', 'A genome region where chromosome pairing occurs preferentially during homologous chromosome pairing during early meiotic prophase of Meiosis I. [PMID:22582262, PMID:23117617, PMID:24173580, PomBase:vw]', 2600, 0, 0);
INSERT INTO chado.cvterm VALUES (2340, 23, 'intein_encoding_region', 'The nucleotide sequence which encodes the intein portion of the precursor gene. [PMID:8165123]', 2601, 0, 0);
INSERT INTO chado.cvterm VALUES (2341, 23, 'uORF', 'A short open reading frame that is found in the 5'' untranslated region of an mRNA and plays a role in translational regulation. [PMID:12890013, PMID:16153175, POMBASE:mah]', 2602, 0, 0);
INSERT INTO chado.cvterm VALUES (2342, 23, 'sORF', 'An open reading frame that encodes a peptide of less than 100 amino acids. [PMID:23970561, PMID:24705786, POMBASE:mah]', 2604, 0, 0);
INSERT INTO chado.cvterm VALUES (2343, 23, 'tnaORF', 'A translated ORF encoded entirely within the antisense strand of a known protein coding gene. [POMBASE:vw]', 2605, 0, 0);
INSERT INTO chado.cvterm VALUES (2344, 23, 'X_region', 'One of two segments of homology found at all three mating loci (HML, MAT and HMR). [SGD:jd]', 2606, 0, 0);
INSERT INTO chado.cvterm VALUES (2345, 23, 'shRNA', 'A short hairpin RNA (shRNA) is an RNA transcript that makes a tight hairpin turn that can be used to silence target gene expression via RNA interference. [PMID:6699500, SO:ke]', 2607, 0, 0);
INSERT INTO chado.cvterm VALUES (2346, 23, 'moR', 'A non-coding transcript encoded by sequences adjacent to the ends of the 5'' and 3'' miR-encoding sequences that abut the loop in precursor miRNA. [SO:ke]', 2608, 0, 0);
INSERT INTO chado.cvterm VALUES (2347, 23, 'loR', 'A short, non coding transcript of loop-derived sequences encoded in precursor miRNA. [SO:ke]', 2609, 0, 0);
INSERT INTO chado.cvterm VALUES (2348, 23, 'miR_encoding_snoRNA_primary_transcript', 'A snoRNA primary transcript that also encodes pre-miR sequence that is processed to form functionally active miRNA. [SO:ke]', 2610, 0, 0);
INSERT INTO chado.cvterm VALUES (2349, 23, 'lncRNA_primary_transcript', 'A primary transcript encoding a lncRNA. [SO:ke]', 2611, 0, 0);
INSERT INTO chado.cvterm VALUES (2350, 23, 'miR_encoding_lncRNA_primary_transcript', 'A lncRNA primary transcript that also encodes pre-miR sequence that is processed to form functionally active miRNA. [SO:ke]', 2612, 0, 0);
INSERT INTO chado.cvterm VALUES (2351, 23, 'miR_encoding_tRNA_primary_transcript', 'A tRNA primary transcript that also encodes pre-miR sequence that is processed to form functionally active miRNA. [SO:ke]', 2613, 0, 0);
INSERT INTO chado.cvterm VALUES (2352, 23, 'shRNA_primary_transcript', 'A primary transcript encoding an shRNA. [SO:ke]', 2614, 0, 0);
INSERT INTO chado.cvterm VALUES (2353, 23, 'miR_encoding_shRNA_primary_transcript', 'A shRNA primary transcript that also encodes pre-miR sequence that is processed to form functionally active miRNA. [SO:ke]', 2615, 0, 0);
INSERT INTO chado.cvterm VALUES (2354, 23, 'vaultRNA_primary_transcript', 'A primary transcript encoding a vaultRNA. [SO:ke]', 2616, 0, 0);
INSERT INTO chado.cvterm VALUES (2355, 23, 'miR_encoding_vaultRNA_primary_transcript', 'A vaultRNA primary transcript that also encodes pre-miR sequence that is processed to form functionally active miRNA. [SO:ke]', 2617, 0, 0);
INSERT INTO chado.cvterm VALUES (2356, 23, 'Y_RNA_primary_transcript', 'A primary transcript encoding a Y-RNA. [SO:ke]', 2618, 0, 0);
INSERT INTO chado.cvterm VALUES (2357, 23, 'miR_encoding_Y_RNA_primary_transcript', 'A Y-RNA primary transcript that also encodes pre-miR sequence that is processed to form functionally active miRNA. [SO:ke]', 2619, 0, 0);
INSERT INTO chado.cvterm VALUES (2358, 23, 'TCS_element', 'A TCS element is a (yeast) transcription factor binding site, bound by the TEA DNA binding domain (DBD) of transcription factors. The consensus site is CATTCC or CATTCT. [PMID:1489142, PMID:20118212, SO:ke]', 2620, 0, 0);
INSERT INTO chado.cvterm VALUES (2359, 23, 'pheromone_response_element', 'A PRE is a (yeast) TFBS with consensus site [TGAAAC(A/G)]. [PMID:1489142, SO:ke]', 2621, 0, 0);
INSERT INTO chado.cvterm VALUES (2360, 23, 'FRE', 'A FRE is an enhancer element necessary and sufficient to confer filamentation associated expression in S. cerevisiae. [PMID:1489142, SO:ke]', 2622, 0, 0);
INSERT INTO chado.cvterm VALUES (2361, 23, 'transcription_pause_site', 'Transcription pause sites are regions of a gene where RNA polymerase may pause during transcription. The functional role of pausing may be to facilitate factor recruitment, RNA folding, and synchronization with translation. Consensus transcription pause site have been observed in E. coli. [PMID:24789973, SO:ke]', 2623, 0, 0);
INSERT INTO chado.cvterm VALUES (2362, 23, 'disabled_reading_frame', 'A reading frame that could encode a full-length protein but which contains obvious mid-sequence disablements (frameshifts or premature stop codons). [SGD:se]', 2624, 0, 0);
INSERT INTO chado.cvterm VALUES (2363, 23, 'H3K27_acetylation_site', 'A kind of histone modification site, whereby the 27th residue (a lysine), from the start of the H3 histone protein is acetylated. [SO:rs]', 2625, 0, 0);
INSERT INTO chado.cvterm VALUES (2364, 23, 'constitutive_promoter', 'A promoter that allows for continual transcription of gene. [SO:ke]', 2626, 0, 0);
INSERT INTO chado.cvterm VALUES (2365, 23, 'inducible_promoter', 'A promoter whereby activity is induced by the presence or absence of biotic or abiotic factors. [SO:ke]', 2627, 0, 0);
INSERT INTO chado.cvterm VALUES (2366, 23, 'dominant_negative_variant', 'A variant where the mutated gene product adversely affects the other (wild type) gene product. [SO:ke]', 2628, 0, 0);
INSERT INTO chado.cvterm VALUES (2367, 23, 'gain_of_function_variant', 'A sequence variant whereby new or enhanced function is conferred on the gene product. [SO:ke]', 2629, 0, 0);
INSERT INTO chado.cvterm VALUES (2368, 23, 'loss_of_function_variant', 'A sequence variant whereby the gene product has diminished or abolished function. [SO:ke]', 2630, 0, 0);
INSERT INTO chado.cvterm VALUES (2369, 23, 'null_mutation', 'A variant whereby the gene product is not functional or the gene product is not produced. [SO:ke]', 2631, 0, 0);
INSERT INTO chado.cvterm VALUES (2464, 23, 'non_AUG_initiated_uORF', 'A uORF beginning with a codon other than AUG. [PMID:26684391, PMID:27313038]', 2728, 0, 0);
INSERT INTO chado.cvterm VALUES (2370, 23, 'intronic_splicing_silencer', 'An intronic splicing regulatory element that functions to recruit trans acting splicing factors suppress the transcription of the gene or genes they control. [PMID:23241926, SO:ke]', 2632, 0, 0);
INSERT INTO chado.cvterm VALUES (2371, 23, 'intronic_splicing_enhancer', '', 2633, 1, 0);
INSERT INTO chado.cvterm VALUES (2372, 23, 'exonic_splicing_silencer', 'An exonic splicing regulatory element that functions to recruit trans acting splicing factors suppress the transcription of the gene or genes they control. [PMID:23241926, SO:ke]', 2634, 0, 0);
INSERT INTO chado.cvterm VALUES (2373, 23, 'recombination_enhancer', 'A regulatory_region that promotes or induces the process of recombination. [PMID:8861911, SGD:se]', 2635, 0, 0);
INSERT INTO chado.cvterm VALUES (2374, 23, 'interchromosomal_translocation', 'A translocation where the regions involved are from different chromosomes. [NCBI:th]', 2636, 0, 0);
INSERT INTO chado.cvterm VALUES (2375, 23, 'intrachromosomal_translocation', 'A translocation where the regions involved are from the same chromosome. [NCBI:th]', 2637, 0, 0);
INSERT INTO chado.cvterm VALUES (2376, 23, 'complex_chromosomal_rearrangement', 'A contiguous cluster of translocations, usually the result of a single catastrophic event such as chromothripsis or chromoanasynthesis. [NCBI:th]', 2638, 0, 0);
INSERT INTO chado.cvterm VALUES (2377, 23, 'Alu_insertion', 'An insertion of sequence from the Alu family of mobile elements. [NCBI:th]', 2639, 0, 0);
INSERT INTO chado.cvterm VALUES (2378, 23, 'LINE1_insertion', 'An insertion from the Line1 family of mobile elements. [NCBI:th]', 2640, 0, 0);
INSERT INTO chado.cvterm VALUES (2379, 23, 'L1_LINE_retrotransposon', 'Long interspersed element-1 (LINE-1) elements are found in the human genome, which contains ORF1 (open reading frame1, including CC, coiled coil; RRM, RNA recognition motif; CTD, carboxyl-terminal domain) and ORF2 (including EN, endonuclease; RT, reverse transcriptase; C, cysteine-rich domain). The L1-encoded proteins (ORF1p and ORF2p) can mobilize nonautonomous retrotransposons, other noncoding RNAs, and messenger RNAs. [PMID:31709017]', 2641, 0, 0);
INSERT INTO chado.cvterm VALUES (2380, 23, 'SVA_insertion', 'An insertion of sequence from the SVA family of mobile elements. [NCBI:th]', 2642, 0, 0);
INSERT INTO chado.cvterm VALUES (2381, 23, 'mobile_element_deletion', 'A deletion of a mobile element when comparing a reference sequence (has mobile element) to a individual sequence (does not have mobile element). [NCBI:th]', 2643, 0, 0);
INSERT INTO chado.cvterm VALUES (2382, 23, 'HERV_deletion', 'A deletion of the HERV mobile element with respect to a reference. [NCBI:th]', 2644, 0, 0);
INSERT INTO chado.cvterm VALUES (2383, 23, 'Endogenous_Retrovirus_LTR_retrotransposon', 'Endogenous retrovirus (ERV) retrotransposons are abundant in the genomes of jawed vertebrates. Human ERVs (HERVs) are classified based on their homologies to animal retroviruses. Class I families are similar in sequence to mammalian Gammaretroviruses (type C) and Epsilonretroviruses (Type E). Class II families show homology to mammalian Betaretroviruses (Type B) and Deltaretroviruses (Type D). F-Class III families are similar to foamy viruses. [PMID:17984973]', 2645, 0, 0);
INSERT INTO chado.cvterm VALUES (2384, 23, 'SVA_deletion', 'A deletion of an SVA mobile element. [NCBI:th]', 2646, 0, 0);
INSERT INTO chado.cvterm VALUES (2385, 23, 'LINE1_deletion', 'A deletion of a LINE1 mobile element with respect to a reference. [NCBI:th]', 2647, 0, 0);
INSERT INTO chado.cvterm VALUES (2386, 23, 'Alu_deletion', 'A deletion of an Alu mobile element with respect to a reference. [NCBI:th]', 2648, 0, 0);
INSERT INTO chado.cvterm VALUES (2387, 23, 'CDS_supported_by_peptide_spectrum_match', 'A CDS that is supported by proteomics data. [SO:ke]', 2649, 0, 0);
INSERT INTO chado.cvterm VALUES (2388, 23, 'CDS_supported_by_sequence_similarity_data', 'A CDS that is supported by sequence similarity data. [SO:xp]', 2650, 0, 0);
INSERT INTO chado.cvterm VALUES (2389, 23, 'no_sequence_alteration', 'A position or feature within a sequence that is identical to the comparable position or feature of a specified reference sequence. [SO:ke]', 2651, 0, 0);
INSERT INTO chado.cvterm VALUES (2390, 23, 'intergenic_1kb_variant', 'A variant that falls in an intergenic region that is 1 kb or less between 2 genes. [SO:ke]', 2652, 0, 0);
INSERT INTO chado.cvterm VALUES (2391, 23, 'incomplete_transcript_variant', 'A sequence variant that intersects an incompletely annotated transcript. [SO:ke]', 2653, 0, 0);
INSERT INTO chado.cvterm VALUES (2392, 23, 'incomplete_transcript_3UTR_variant', 'A sequence variant that intersects the 3'' UTR of an incompletely annotated transcript. [SO:ke]', 2654, 0, 0);
INSERT INTO chado.cvterm VALUES (2393, 23, 'incomplete_transcript_5UTR_variant', 'A sequence variant that intersects the 5'' UTR of an incompletely annotated transcript. [SO:ke]', 2655, 0, 0);
INSERT INTO chado.cvterm VALUES (2394, 23, 'incomplete_transcript_intronic_variant', 'A sequence variant that intersects the intron of an incompletely annotated transcript. [SO:ke]', 2656, 0, 0);
INSERT INTO chado.cvterm VALUES (2395, 23, 'incomplete_transcript_splice_region_variant', 'A sequence variant that intersects the splice region of an incompletely annotated transcript. [SO:ke]', 2657, 0, 0);
INSERT INTO chado.cvterm VALUES (2396, 23, 'incomplete_transcript_exonic_variant', 'A sequence variant that intersects the exon of an incompletely annotated transcript. [SO:ke]', 2658, 0, 0);
INSERT INTO chado.cvterm VALUES (2397, 23, 'incomplete_transcript_CDS', 'A sequence variant that intersects the coding regions of an incompletely annotated transcript. [SO:ke]', 2659, 0, 0);
INSERT INTO chado.cvterm VALUES (2398, 23, 'incomplete_transcript_coding_splice_variant', 'A sequence variant that intersects the coding sequence near a splice region of an incompletely annotated transcript. [SO:ke]', 2660, 0, 0);
INSERT INTO chado.cvterm VALUES (2399, 23, '2KB_downstream_variant', 'A sequence variant located within 2KB 3'' of a gene. [SO:ke]', 2661, 0, 0);
INSERT INTO chado.cvterm VALUES (2400, 23, 'exonic_splice_region_variant', 'A sequence variant in which a change has occurred within the exonic region of the splice site, 1-2 bases from boundary. [SO:ke]', 2662, 0, 0);
INSERT INTO chado.cvterm VALUES (2401, 23, 'unidirectional_gene_fusion', 'A sequence variant whereby two genes, on the same strand have become joined. [SO:ke]', 2663, 0, 0);
INSERT INTO chado.cvterm VALUES (2402, 23, 'bidirectional_gene_fusion', 'A sequence variant whereby two genes, on alternate strands have become joined. [SO:ke]', 2664, 0, 0);
INSERT INTO chado.cvterm VALUES (2403, 23, 'pseudogenic_CDS', 'A non functional descendant of the coding portion of a coding transcript, part of a pseudogene. [SO:ke]', 2665, 0, 0);
INSERT INTO chado.cvterm VALUES (2404, 23, 'non_coding_transcript_splice_region_variant', 'A transcript variant occurring within the splice region (1-3 bases of the exon or 3-8 bases of the intron) of a non coding transcript. [SO:ke]', 2666, 0, 0);
INSERT INTO chado.cvterm VALUES (2405, 23, '3_prime_UTR_exon_variant', 'A UTR variant of exonic sequence of the 3'' UTR. [SO:ke]', 2667, 0, 0);
INSERT INTO chado.cvterm VALUES (2406, 23, '3_prime_UTR_intron_variant', 'A UTR variant of intronic sequence of the 3'' UTR. [SO:ke]', 2668, 0, 0);
INSERT INTO chado.cvterm VALUES (2407, 23, '5_prime_UTR_intron_variant', 'A UTR variant of intronic sequence of the 5'' UTR. [SO:ke]', 2669, 0, 0);
INSERT INTO chado.cvterm VALUES (2408, 23, '5_prime_UTR_exon_variant', 'A UTR variant of exonic sequence of the 5'' UTR. [SO:ke]', 2670, 0, 0);
INSERT INTO chado.cvterm VALUES (2409, 23, 'structural_interaction_variant', 'A variant that impacts the internal interactions of the resulting polypeptide structure. [SO:ke]', 2671, 0, 0);
INSERT INTO chado.cvterm VALUES (2410, 23, 'non_allelic_homologous_recombination_region', 'A genomic region at a non-allelic position where exchange of genetic material happens as a result of homologous recombination. []', 2672, 0, 0);
INSERT INTO chado.cvterm VALUES (2411, 23, 'scaRNA', 'A ncRNA, specific to the Cajal body, that has been demonstrated to function as a guide RNA in the site-specific synthesis of 2''-O-ribose-methylated nucleotides and pseudouridines in the RNA polymerase II-transcribed U1, U2, U4 and U5 spliceosomal small nuclear RNAs (snRNAs). [PMC:126017, PMID:27775477, PMID:28869095, SO:nrs]', 2673, 0, 0);
INSERT INTO chado.cvterm VALUES (2412, 23, 'short_tandem_repeat_variation', 'A variation that expands or contracts a tandem repeat with regard to a reference. [SO:ke]', 2674, 0, 0);
INSERT INTO chado.cvterm VALUES (2413, 23, 'vertebrate_immune_system_pseudogene', 'A pseudogene derived from a vertebrate immune system gene. [SO:ke]', 2675, 0, 0);
INSERT INTO chado.cvterm VALUES (2414, 23, 'immunoglobulin_pseudogene', 'A pseudogene derived from an immunoglobulin gene. [SO:ke]', 2676, 0, 0);
INSERT INTO chado.cvterm VALUES (2415, 23, 'T_cell_receptor_pseudogene', 'A pseudogene derived from a T-cell receptor gene. [SO:ke]', 2677, 0, 0);
INSERT INTO chado.cvterm VALUES (2416, 23, 'IG_C_pseudogene', 'A pseudogenic constant region of an immunoglobulin gene which closely resembles a known functional Imunoglobulin constant gene but in which the coding region has stop codons, frameshift mutations or a mutation that effects the initiation codon. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, IGMT:http\://www.imgt.org/IMGTScientificChart/SequenceDescription/Keywords.php]', 2678, 0, 0);
INSERT INTO chado.cvterm VALUES (2417, 23, 'IG_J_pseudogene', 'A pseudogenic joining region which closely resembles a known functional imunoglobulin joining gene but in which the coding region has stop codons, frameshift mutations or a mutation that effects the initiation codon that rearranges at the DNA level and codes the joining region of the variable domain of an immunoglobulin chain. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, IGMT:http\://www.imgt.org/IMGTScientificChart/SequenceDescription/Keywords.php]', 2679, 0, 0);
INSERT INTO chado.cvterm VALUES (2418, 23, 'IG_V_pseudogene', 'A pseudogenic variable region which closely resembles a known functional imunoglobulin variable gene but in which the coding region has stop codons, frameshift mutations or a mutation that effects the initiation codon that rearranges at the DNA level and codes the variable region of an immunoglobulin chain. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, IGMT:http\://www.imgt.org/IMGTScientificChart/SequenceDescription/Keywords.php]', 2680, 0, 0);
INSERT INTO chado.cvterm VALUES (2419, 23, 'TR_V_pseudogene', 'A pseudogenic variable region which closely resembles a known functional T receptor variable gene but in which the coding region has stop codons, frameshift mutations or a mutation that effects the initiation codon that rearranges at the DNA level and codes the variable region of an immunoglobulin chain. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, IGMT:http\://www.imgt.org/IMGTScientificChart/SequenceDescription/Keywords.php]', 2681, 0, 0);
INSERT INTO chado.cvterm VALUES (2420, 23, 'TR_J_pseudogene', 'A pseudogenic joining region which closely resembles a known functional T receptor (TR) joining gene but in which the coding region has stop codons, frameshift mutations or a mutation that effects the initiation codon that rearranges at the DNA level and codes the joining region of the variable domain of an immunoglobulin chain. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, IGMT:http\://www.imgt.org/IMGTScientificChart/SequenceDescription/Keywords.php]', 2682, 0, 0);
INSERT INTO chado.cvterm VALUES (2421, 23, 'translated_processed_pseudogene', 'A processed pseudogene where there is evidence, (mass spec data) suggesting that it is also translated. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2683, 0, 0);
INSERT INTO chado.cvterm VALUES (2422, 23, 'translated_unprocessed_pseudogene', 'A non-processed pseudogene where there is evidence, (mass spec data) suggesting that it is also translated. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2684, 0, 0);
INSERT INTO chado.cvterm VALUES (2423, 23, 'transcribed_unprocessed_pseudogene', 'A unprocessed pseudogene supported by locus-specific evidence of transcription. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2685, 0, 0);
INSERT INTO chado.cvterm VALUES (2424, 23, 'transcribed_unitary_pseudogene', 'A species specific unprocessed pseudogene without a parent gene, as it has an active orthologue in another species. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2686, 0, 0);
INSERT INTO chado.cvterm VALUES (2425, 23, 'transcribed_processed_pseudogene', 'A processed_pseudogene overlapped by locus-specific evidence of transcription. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2687, 0, 0);
INSERT INTO chado.cvterm VALUES (2426, 23, 'polymorphic_pseudogene_with_retained_intron', 'A polymorphic pseudogene in the reference genome, containing a retained intron, known to be intact in the genomes of other individuals of the same species. The annotation process has confirmed that the pseudogenisation event is not a genomic sequencing error. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2688, 0, 0);
INSERT INTO chado.cvterm VALUES (2427, 23, 'pseudogene_processed_transcript', 'A processed_transcript supported by EST and/or mRNA evidence that aligns unambiguously to a pseudogene locus (i.e. alignment to the pseudogene locus clearly better than alignment to parent locus). [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2689, 0, 0);
INSERT INTO chado.cvterm VALUES (2428, 23, 'coding_transcript_with_retained_intron', 'A protein coding transcript containing a retained intron. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2690, 0, 0);
INSERT INTO chado.cvterm VALUES (2429, 23, 'lncRNA_with_retained_intron', 'A lncRNA transcript containing a retained intron. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2691, 0, 0);
INSERT INTO chado.cvterm VALUES (2430, 23, 'NMD_transcript', 'A protein coding transcript that contains a CDS but has one or more splice junctions >50bp downstream of stop codon, making it susceptible to nonsense mediated decay. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2692, 0, 0);
INSERT INTO chado.cvterm VALUES (2431, 23, 'pseudogenic_transcript_with_retained_intron', 'A transcript supported by EST and/or mRNA evidence that aligns unambiguously to the pseudogene locus; has retained intronic sequence compared to a reference transcript sequence. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2693, 0, 0);
INSERT INTO chado.cvterm VALUES (2432, 23, 'polymorphic_pseudogene_processed_transcript', 'A processed transcript that does not contain a CDS that fullfills annotation criteria and not necessarily functionally non-coding. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2694, 0, 0);
INSERT INTO chado.cvterm VALUES (2433, 23, '<new term>', '', 2695, 1, 0);
INSERT INTO chado.cvterm VALUES (2434, 23, 'NMD_polymorphic_pseudogene_transcript', 'A polymorphic pseudogene transcript that contains a CDS but has one or more splice junctions >50bp downstream of stop codon. Premature stop codon is not introduced, directly or indirectly, as a result of the variation i.e. must be present in both protein_coding and pseudogenic alleles. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2696, 0, 0);
INSERT INTO chado.cvterm VALUES (2532, 23, 'LOZ1_response_element', 'A conserved sequence (5''-CGNMGATCNTY-3'') transcription repressor binding site required for gene repression in the presence of high zinc. []', 2798, 0, 0);
INSERT INTO chado.cvterm VALUES (2435, 23, 'allelic_frequency', 'A physical quality which inheres to the allele by virtue of the number instances of the allele within a population. This is the relative frequency of the allele at a given locus in a population. [SO:ke]', 2697, 0, 0);
INSERT INTO chado.cvterm VALUES (2436, 23, 'three_prime_overlapping_ncrna', 'Transcript where ditag (digital gene expression profiling)and/or published experimental data strongly supports the existence of short non-coding transcripts transcribed from the 3''UTR. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2699, 0, 0);
INSERT INTO chado.cvterm VALUES (2437, 23, 'vertebrate_immune_system_gene', 'The configuration of the IG and TR variable (V), diversity (D) and joining (J) germline genes before DNA rearrangements (with or without constant (C) genes in undefined configuration. (germline, non rearranged regions of the IG DNA loci). [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, IGMT:http\://www.imgt.org/IMGTScientificChart/SequenceDescription/Keywords.php]', 2700, 0, 0);
INSERT INTO chado.cvterm VALUES (2438, 23, 'immunoglobulin_gene', 'A germline immunoglobulin gene. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2701, 0, 0);
INSERT INTO chado.cvterm VALUES (2439, 23, 'IG_C_gene', 'A constant (C) gene, a gene that codes the constant region of an immunoglobulin chain. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, IGMT:http\://www.imgt.org/IMGTScientificChart/SequenceDescription/Keywords.php]', 2702, 0, 0);
INSERT INTO chado.cvterm VALUES (2440, 23, 'IG_D_gene', 'A gene that rearranges at the DNA level and codes the diversity region of the variable domain of an immunoglobuin (IG) gene. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, IGMT:http\://www.imgt.org/IMGTScientificChart/SequenceDescription/Keywords.php]', 2703, 0, 0);
INSERT INTO chado.cvterm VALUES (2441, 23, 'IG_J_gene', 'A joining gene that rearranges at the DNA level and codes the joining region of the variable domain of an immunoglobulin chain. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, IGMT:http\://www.imgt.org/IMGTScientificChart/SequenceDescription/Keywords.php]', 2704, 0, 0);
INSERT INTO chado.cvterm VALUES (2442, 23, 'IG_V_gene', 'A variable gene that rearranges at the DNA level and codes the variable region of the variable domain of an Immunoglobulin chain. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, IGMT:http\://www.imgt.org/IMGTScientificChart/SequenceDescription/Keywords.php]', 2705, 0, 0);
INSERT INTO chado.cvterm VALUES (2443, 23, 'mt_rRNA', 'Mitochondrial rRNA is an RNA component of the small or large subunits of mitochondrial ribosomes. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2706, 0, 0);
INSERT INTO chado.cvterm VALUES (2444, 23, 'mt_tRNA', 'Mitochondrial transfer RNA. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2707, 0, 0);
INSERT INTO chado.cvterm VALUES (2445, 23, 'NSD_transcript', 'A transcript that contains a CDS but has no stop codon before the polyA site is reached. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2708, 0, 0);
INSERT INTO chado.cvterm VALUES (2446, 23, 'sense_intronic_lncRNA', 'A long non-coding transcript found within an intron of a coding or non-coding gene, with no overlap of exonic sequence. [GENECODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2709, 0, 0);
INSERT INTO chado.cvterm VALUES (2447, 23, 'sense_overlap_lncRNA', 'A long non-coding transcript that contains a protein coding gene within its intronic sequence on the same strand, with no overlap of exonic sequence. [GENECODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2711, 0, 0);
INSERT INTO chado.cvterm VALUES (2448, 23, 'T_cell_receptor_gene', 'A T-cell receptor germline gene. []', 2712, 0, 0);
INSERT INTO chado.cvterm VALUES (2449, 23, 'TR_C_Gene', 'A constant (C) gene, a gene that codes the constant region of a T-cell receptor chain. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, IGMT:http\://www.imgt.org/IMGTScientificChart/SequenceDescription/Keywords.php]', 2713, 0, 0);
INSERT INTO chado.cvterm VALUES (2450, 23, 'TR_D_Gene', 'A gene that rearranges at the DNA level and codes the diversity region of the variable domain of aT-cell receptor gene. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, IGMT:http\://www.imgt.org/IMGTScientificChart/SequenceDescription/Keywords.php]', 2714, 0, 0);
INSERT INTO chado.cvterm VALUES (2451, 23, 'TR_J_Gene', 'A joining gene that rearranges at the DNA level and codes the joining region of the variable domain of aT-cell receptor chain. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, IGMT:http\://www.imgt.org/IMGTScientificChart/SequenceDescription/Keywords.php]', 2715, 0, 0);
INSERT INTO chado.cvterm VALUES (2452, 23, 'TR_V_Gene', 'A variable gene that rearranges at the DNA level and codes the variable region of the variable domain of aT-cell receptor chain. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html, IGMT:http\://www.imgt.org/IMGTScientificChart/SequenceDescription/Keywords.php]', 2716, 0, 0);
INSERT INTO chado.cvterm VALUES (2453, 23, 'predicted_transcript', 'A transcript feature that has been predicted but is not yet validated. [SO:ke]', 2717, 0, 0);
INSERT INTO chado.cvterm VALUES (2454, 23, 'unconfirmed_transcript', 'This is used for non-spliced EST clusters that have polyA features. This category has been specifically created for the ENCODE project to highlight regions that could indicate the presence of protein coding genes that require experimental validation, either by 5'' RACE or RT-PCR to extend the transcripts, or by confirming expression of the putatively-encoded peptide with specific antibodies. [GENCODE:http\://www.gencodegenes.org/gencode_biotypes.html]', 2718, 0, 0);
INSERT INTO chado.cvterm VALUES (2455, 23, 'early_origin_of_replication', 'An origin of replication that initiates early in S phase. [PMID:23348837, PMID:9115207]', 2719, 0, 0);
INSERT INTO chado.cvterm VALUES (2456, 23, 'late_origin_of_replication', 'An origin of replication that initiates late in S phase. [PMID:23348837, PMID:9115207]', 2720, 0, 0);
INSERT INTO chado.cvterm VALUES (2457, 23, 'histone_2AZ_acetylation_site', 'A histone 2AZ modification where the modification is the acetylation of the residue. [PMID:19385636, PMID:24316985, PMID:27087541]', 2721, 0, 0);
INSERT INTO chado.cvterm VALUES (2458, 23, 'H2AZK4_acetylation_site', 'A kind of histone modification site, whereby the 4th residue (a lysine), from the start of the H2AZ histone protein is acetylated. [PMID:19385636, PMID:24316985, PMID:27087541]', 2722, 0, 0);
INSERT INTO chado.cvterm VALUES (2459, 23, 'H2AZK7_acetylation_site', 'A kind of histone modification site, whereby the 7th residue (a lysine), from the start of the H2AZ histone protein is acetylated. [PMID:19385636, PMID:24316985, PMID:27087541]', 2723, 0, 0);
INSERT INTO chado.cvterm VALUES (2460, 23, 'H2AZK11_acetylation_site', 'A kind of histone modification site, whereby the 11th residue (a lysine), from the start of the H2AZ histone protein is acetylated. [PMID:19385636, PMID:24316985, PMID:27087541]', 2724, 0, 0);
INSERT INTO chado.cvterm VALUES (2461, 23, 'H2AZK13_acetylation_site', 'A kind of histone modification site, whereby the 13th residue (a lysine), from the start of the H2AZ histone protein is acetylated. [PMID:19385636, PMID:24316985, PMID:27087541]', 2725, 0, 0);
INSERT INTO chado.cvterm VALUES (2462, 23, 'H2AZK15_acetylation_site', 'A kind of histone modification site, whereby the 15th residue (a lysine), from the start of the H2AZ histone protein is acetylated. [PMID:19385636, PMID:24316985, PMID:27087541]', 2726, 0, 0);
INSERT INTO chado.cvterm VALUES (2463, 23, 'AUG_initiated_uORF', 'A uORF beginning with the canonical start codon AUG. [PMID:26684391, PMID:27313038]', 2727, 0, 0);
INSERT INTO chado.cvterm VALUES (2465, 23, 'genic_downstream_transcript_variant', 'A variant that falls downstream of a transcript, but within the genic region of the gene due to alternately transcribed isoforms. [NCBI:dm, SO:ke]', 2729, 0, 0);
INSERT INTO chado.cvterm VALUES (2466, 23, 'genic_upstream_transcript_variant', 'A variant that falls upstream of a transcript, but within the genic region of the gene due to alternately transcribed isoforms. [NCBI:dm, SO:ke]', 2730, 0, 0);
INSERT INTO chado.cvterm VALUES (2467, 23, 'mitotic_recombination_region', 'A genomic region where there is an exchange of genetic material with another genomic region, occurring in somatic cells. [NCBI:cf, SO:ke]', 2731, 0, 0);
INSERT INTO chado.cvterm VALUES (2468, 23, 'meiotic_recombination_region', 'A genomic region in which there is an exchange of genetic material as a result of the repair of meiosis-specific double strand breaks that occur during meiotic prophase. [NCBI:cf, SO:ke]', 2732, 0, 0);
INSERT INTO chado.cvterm VALUES (2469, 23, 'CArG_box', 'A promoter element bound by the MADS family of transcription factors with consensus 5''-(C/T)TA(T/A)4TA(G/A)-3''. [PMID:1748287, PMID:7623803]', 2733, 0, 0);
INSERT INTO chado.cvterm VALUES (2470, 23, 'Mat2P', 'A gene cassette array containing H+ mating type specific information. [PMID:18354497]', 2734, 0, 0);
INSERT INTO chado.cvterm VALUES (2471, 23, 'Mat3M', 'A gene cassette array containing H- mating type specific information. [PMID:18354497]', 2735, 0, 0);
INSERT INTO chado.cvterm VALUES (2472, 23, 'SHP_box', 'A conserved Cdc48/p97 interaction motif with strict consensus sequence F[PI]GKG[TK][RK]LG[GT] and relaxed consensus sequence FXGKGX[RK]LG. [PMID:17083136, PMID:27655872]', 2736, 0, 0);
INSERT INTO chado.cvterm VALUES (2473, 23, 'short_tandem_repeat_change', 'A sequence variant where the copies of a short tandem repeat (STR) feature are either contracted or expanded. []', 2737, 0, 0);
INSERT INTO chado.cvterm VALUES (2474, 23, 'short_tandem_repeat_expansion', 'A short tandem repeat variant containing more repeat units than the reference sequence. []', 2738, 0, 0);
INSERT INTO chado.cvterm VALUES (2475, 23, 'short_tandem_repeat_contraction', 'A short tandem repeat variant containing fewer repeat units than the reference sequence. []', 2739, 0, 0);
INSERT INTO chado.cvterm VALUES (2476, 23, 'H2BK5_acetylation_site', 'A kind of histone modification site, whereby the 5th residue (a lysine), from the start of the H2B histone protein is acetylated. [http://www.actrec.gov.in/histome/ptm_sp.php?ptm_sp=H2BK5ac, PMID:18552846]', 2740, 0, 0);
INSERT INTO chado.cvterm VALUES (2477, 23, 'trinucleotide_repeat_expansion', 'A short tandem repeat expansion with an increase in a sequence of three nucleotide units repeated in tandem compared to a reference sequence. []', 2741, 0, 0);
INSERT INTO chado.cvterm VALUES (2478, 23, 'ref_miRNA', 'A ref_miRNA (RefSeq-miRNA) sequence is assigned at the creation of a new mature miRNA entry in a database. The ref_miRNA sequence designation remains unchanged even if a different isomiR is later shown to be expressed at a higher level. A ref_miRNA can be produced by one or multiple pre-miRNA. [PMID:26453491]', 2742, 0, 0);
INSERT INTO chado.cvterm VALUES (2479, 23, 'isomiR', 'IsomiRs are all the bona fide variants of a mature product. IsomiRs should be connected to the ref_miRNA it is most likely to be the variant of. Some isomiRs can be variations of one or multiple ref_miRNA. [PMID:26453491]', 2743, 0, 0);
INSERT INTO chado.cvterm VALUES (2480, 23, 'RNA_thermometer', 'An RNA_thermometer is a cis element in the 5'' end of an mRNA that can change its secondary structure in response to temperature and coordinate temperature-dependent gene expression. [PMID:22421878]', 2744, 0, 0);
INSERT INTO chado.cvterm VALUES (2481, 23, 'splice_polypyrimidine_tract_variant', 'A sequence variant that falls in the polypyrimidine tract at 3'' end of intron between 17 and 3 bases from the end (acceptor -3 to acceptor -17). []', 2746, 0, 0);
INSERT INTO chado.cvterm VALUES (2482, 23, 'splice_donor_region_variant', 'A sequence variant that falls in the region between the 3rd and 6th base after splice junction (5'' end of intron). []', 2747, 0, 0);
INSERT INTO chado.cvterm VALUES (2483, 23, 'telomeric_D_loop', 'A telomeric D-loop is a three-stranded DNA displacement loop that forms at the site where the telomeric 3'' single-stranded DNA overhang (formed of the repeat sequence TTAGGG in mammals) is tucked back inside the double-stranded component of telomeric DNA molecule, thus forming a t-loop or telomeric-loop and protecting the chromosome terminus. [PMID:10338204, PMID:15071557, PMID:24012755]', 2748, 0, 0);
INSERT INTO chado.cvterm VALUES (2484, 23, 'sequence_alteration_artifact', 'A sequence_alteration where the source of the alteration is due to an artifact in the base-calling or assembly process. []', 2749, 0, 0);
INSERT INTO chado.cvterm VALUES (2485, 23, 'indel_artifact', 'An indel that is the result of base-calling or assembly error. []', 2750, 0, 0);
INSERT INTO chado.cvterm VALUES (2486, 23, 'deletion_artifact', 'A deletion that is the result of base-calling or assembly error. []', 2751, 0, 0);
INSERT INTO chado.cvterm VALUES (2487, 23, 'insertion_artifact', 'An insertion that is the result of base-calling or assembly error. []', 2752, 0, 0);
INSERT INTO chado.cvterm VALUES (2488, 23, 'substitution_artifact', 'A substitution that is the result of base-calling or assembly error. []', 2753, 0, 0);
INSERT INTO chado.cvterm VALUES (2489, 23, 'duplication_artifact', 'A duplication that is the result of base-calling or assembly error. []', 2754, 0, 0);
INSERT INTO chado.cvterm VALUES (2490, 23, 'SNV_artifact', 'An SNV that is the result of base-calling or assembly error. []', 2755, 0, 0);
INSERT INTO chado.cvterm VALUES (2491, 23, 'MNV_artifact', 'An MNV that is the result of base-calling or assembly error. []', 2756, 0, 0);
INSERT INTO chado.cvterm VALUES (2492, 23, 'ribozyme_gene', 'A gene that encodes a ribozyme. []', 2757, 0, 0);
INSERT INTO chado.cvterm VALUES (2493, 23, 'antisense_lncRNA_gene', 'A gene that encodes an antisense long, non-coding RNA. []', 2758, 0, 0);
INSERT INTO chado.cvterm VALUES (2494, 23, 'sense_overlap_lncRNA_gene', 'A gene that encodes a sense overlap long non-coding RNA. []', 2759, 0, 0);
INSERT INTO chado.cvterm VALUES (2495, 23, 'sense_intronic_lncRNA_gene', 'A gene that encodes a sense intronic long non-coding RNA. []', 2760, 0, 0);
INSERT INTO chado.cvterm VALUES (2496, 23, 'bidirectional_promoter_lncRNA_gene', 'A non-coding locus that originates from within the promoter region of a protein-coding gene, with transcription proceeding in the opposite direction on the other strand. [https://www.gencodegenes.org/pages/biotypes.html]', 2761, 0, 0);
INSERT INTO chado.cvterm VALUES (2497, 23, 'mutational_hotspot', 'A region of genomic sequence known to undergo mutational events with greater frequency than expected by chance. []', 2762, 0, 0);
INSERT INTO chado.cvterm VALUES (2498, 23, 'HERV_insertion', 'An insertion of sequence from the HERV family of mobile elements with respect to a reference. [NCBI:th]', 2763, 0, 0);
INSERT INTO chado.cvterm VALUES (2499, 23, 'functional_gene_region', 'A gene_member_region that encodes sequence that directly contributes to the molecular function of its gene or gene product. [Clingen:mb]', 2764, 0, 0);
INSERT INTO chado.cvterm VALUES (2500, 23, 'allelic_pseudogene', 'A (unitary) pseudogene that is stable in the population but importantly it has a functional alternative allele also in the population. i.e., one strain may have the gene, another strain may have the pseudogene. MHC haplotypes have allelic pseudogenes. []', 2765, 0, 0);
INSERT INTO chado.cvterm VALUES (2533, 23, 'group_IIC_intron', 'A group II intron that recognizes IBS1/EBS1 for the 5-prime exon and IBS3/EBS3 for the 3-prime exon and may also recognize a stem-loop in the RNA. [PMID:20463000]', 2799, 0, 0);
INSERT INTO chado.cvterm VALUES (2501, 23, 'enhancer_blocking_element', 'A transcriptional cis regulatory region that when located between an enhancer and a gene''s promoter prevents the enhancer from modulating the expression of the gene. Sometimes referred to as an insulator but may not include the barrier function of an insulator. [NCBI:cf]', 2766, 0, 0);
INSERT INTO chado.cvterm VALUES (2502, 23, 'imprinting_control_region', 'A regulatory region that controls epigenetic imprinting and affects the expression of target genes in an allele- or parent-of-origin-specific manner. Associated regulatory elements may include differentially methylated regions and non-coding RNAs. []', 2767, 0, 0);
INSERT INTO chado.cvterm VALUES (2503, 23, 'flanking_repeat', 'A repeat lying outside the sequence for which it has functional significance (eg. transposon insertion target sites). []', 2768, 0, 0);
INSERT INTO chado.cvterm VALUES (2504, 23, 'processed_pseudogenic_rRNA', 'The pseudogene has arisen by reverse transcription of a mRNA into cDNA, followed by reintegration into the genome. Therefore, it has lost any intron/exon structure, and it might have a pseudo-polyA-tail. []', 2769, 0, 0);
INSERT INTO chado.cvterm VALUES (2505, 23, 'unprocessed_pseudogenic_rRNA', 'The pseudogene has arisen from a copy of the parent gene by duplication followed by accumulation of random mutation. The changes, compared to their functional homolog, include insertions, deletions, premature stop codons, frameshifts and a higher proportion of non-synonymous versus synonymous substitutions. []', 2770, 0, 0);
INSERT INTO chado.cvterm VALUES (2506, 23, 'unitary_pseudogenic_rRNA', 'The pseudogene has no parent. It is the original gene, which is functional in some species but disrupted in some way (indels, mutation, recombination) in another species or strain. []', 2771, 0, 0);
INSERT INTO chado.cvterm VALUES (2507, 23, 'allelic_pseudogenic_rRNA', 'A (unitary) pseudogene that is stable in the population but importantly it has a functional alternative allele also in the population. i.e., one strain may have the gene, another strain may have the pseudogene. MHC haplotypes have allelic pseudogenes. []', 2772, 0, 0);
INSERT INTO chado.cvterm VALUES (2508, 23, 'processed_pseudogenic_tRNA', 'The pseudogene has arisen by reverse transcription of a mRNA into cDNA, followed by reintegration into the genome. Therefore, it has lost any intron/exon structure, and it might have a pseudo-polyA-tail. []', 2773, 0, 0);
INSERT INTO chado.cvterm VALUES (2509, 23, 'unprocessed_pseudogenic_tRNA', 'The pseudogene has arisen from a copy of the parent gene by duplication followed by accumulation of random mutation. The changes, compared to their functional homolog, include insertions, deletions, premature stop codons, frameshifts and a higher proportion of non-synonymous versus synonymous substitutions. []', 2774, 0, 0);
INSERT INTO chado.cvterm VALUES (2510, 23, 'unitary_pseudogenic_tRNA', 'The pseudogene has no parent. It is the original gene, which is functional in some species but disrupted in some way (indels, mutation, recombination) in another species or strain. []', 2775, 0, 0);
INSERT INTO chado.cvterm VALUES (2511, 23, 'allelic_pseudogenic_tRNA', 'A (unitary) pseudogene that is stable in the population but importantly it has a functional alternative allele also in the population. i.e., one strain may have the gene, another strain may have the pseudogene. MHC haplotypes have allelic pseudogenes. []', 2776, 0, 0);
INSERT INTO chado.cvterm VALUES (2512, 23, 'terminal_repeat', 'A repeat at the ends of and within the sequence for which it has functional significance other than long terminal repeat. []', 2777, 0, 0);
INSERT INTO chado.cvterm VALUES (2513, 23, 'repeat_instability_region', 'A repeat region that is prone to expansions and/or contractions. []', 2778, 0, 0);
INSERT INTO chado.cvterm VALUES (2514, 23, 'replication_start_site', 'A nucleotide site from which replication initiates. [NCBI:cf]', 2779, 0, 0);
INSERT INTO chado.cvterm VALUES (2515, 23, 'response_element', 'A regulatory element that acts in response to a stimulus, usually via transcription factor binding. []', 2780, 0, 0);
INSERT INTO chado.cvterm VALUES (2516, 23, 'sequence_source', 'Identifies the biological source of the specified span of the sequence [NCBI:tm]', 2781, 0, 0);
INSERT INTO chado.cvterm VALUES (2517, 23, 'UNAAAC_motif', 'A hexameric RNA motif consisting of nucleotides UNAAAC (where N can be any nucleotide) that targets the RNA for degradation. [PMID:22645662, PMID:28765164, PomBase:al]', 2782, 0, 0);
INSERT INTO chado.cvterm VALUES (2518, 23, 'long_terminal_repeat_transcript', 'An RNA that is transcribed from a long terminal repeat. [PMID:24256266, PomBase:mh]', 2783, 0, 0);
INSERT INTO chado.cvterm VALUES (2519, 23, 'genomic_DNA_contig', 'A contig composed of genomic DNA derived sequences. [BCS:etrwz]', 2784, 0, 0);
INSERT INTO chado.cvterm VALUES (2520, 23, 'presence_absence_variation', 'A variation qualifying the presence of a sequence in a genome which is entirely missing in another genome. [BCS:bbean, PMID:19956538, PMID:25881062]', 2785, 0, 0);
INSERT INTO chado.cvterm VALUES (2521, 23, 'circular_plasmid', 'A self replicating circular nucleic acid molecule that is distinct from a chromosome in the organism. [PMID:21719542, SBOL:jb]', 2786, 0, 0);
INSERT INTO chado.cvterm VALUES (2522, 23, 'linear_plasmid', 'A self replicating linear nucleic acid molecule that is distinct from a chromosome in the organism. They are capped by terminal proteins covalently bound to the 5'' ends of the DNA. [PMID:21719542, SBOL:jb]', 2787, 0, 0);
INSERT INTO chado.cvterm VALUES (2523, 23, 'transcription_termination_signal', 'Termination signal preferentially observed downstream of polyadenylation signal [PMID:28367989]', 2788, 0, 0);
INSERT INTO chado.cvterm VALUES (2524, 23, 'redundant_inserted_stop_gained', 'A sequence variant whereby at least one base of a codon is changed, resulting in a stop codon inserted next to an existing stop codon. This leads to a polypeptide of the same length. []', 2789, 0, 0);
INSERT INTO chado.cvterm VALUES (2525, 23, 'Zas1_recognition_motif', 'A DNA motif to which the S. pombe Zas1 protein binds. The consensus sequence is 5''-(Y)CCCCAY-3''. [PMID:29735745, PomBase:vw]', 2790, 0, 0);
INSERT INTO chado.cvterm VALUES (2526, 23, 'Pho7_binding_site', 'A promoter element with consensus sequence [5''-TCG(G/C)(A/T)xxTTxAA], bound by the transcription factor Pho7. [PMID:28811350]', 2791, 0, 0);
INSERT INTO chado.cvterm VALUES (2527, 23, 'unspecified_indel', 'A sequence alteration which includes an insertion or a deletion. This describes a sequence length change when the direction of the change is unspecified or when such changes are pooled into one category. [ZFIN:st]', 2792, 0, 0);
INSERT INTO chado.cvterm VALUES (2528, 23, 'functionally_normal', 'A sequence variant in which the function of a gene product is retained with respect to a reference. []', 2793, 0, 0);
INSERT INTO chado.cvterm VALUES (2529, 23, 'function_uncertain_variant', 'A sequence variant in which the function of a gene product is unknown with respect to a reference. []', 2794, 0, 0);
INSERT INTO chado.cvterm VALUES (2530, 23, 'inert_DNA_spacer', 'Sequences that decrease interactions between biological regions, such as between a promoter, its 5'' context and/or the translational unit(s) it regulates. Spacers can affect regulation of translation, transcription, and other biological processes. [PMID:20843779, PMID:24933158, PMID:27034378, PMID:28422998]', 2795, 0, 0);
INSERT INTO chado.cvterm VALUES (2531, 23, '2A_self_cleaving_peptide_region', 'A region that codes for a 2A self-cleaving polypeptide region, which is a region that can result in a break in the peptide sequence at its terminal G-P junction. [PMID:22301656, PMID:28526819]', 2797, 0, 0);
INSERT INTO chado.cvterm VALUES (2716, 23, 'G_to_T_transversion', 'A transversion from guanine to thymine. [SO:ke]', 2986, 0, 0);
INSERT INTO chado.cvterm VALUES (2534, 23, 'CDS_extension', 'A sequence variant extending the CDS, that causes elongation of the resulting polypeptide sequence. [PMID:14732127, PMID:15864293, PMID:27984720, PMID:31216041, PMID:32020195]', 2800, 0, 0);
INSERT INTO chado.cvterm VALUES (2535, 23, 'CAAX_box', 'A C-terminus protein motif (CAAX) serving as a post-translational prenylation site modified by the attachment of either a farnesyl or a geranyl-geranyl group to a cysteine residue. Farnesyltransferase recognizes CaaX boxes where X = M, S, Q, A, or C, whereas Geranylgeranyltransferase I recognizes CaaX boxes with X = L or E. []', 2801, 0, 0);
INSERT INTO chado.cvterm VALUES (2536, 23, 'self_cleaving_ribozyme', 'An RNA that catalyzes its own cleavage. []', 2802, 0, 0);
INSERT INTO chado.cvterm VALUES (2537, 23, 'selection_marker', 'A genetic feature that encodes a trait used for artificial selection of a subpopulation. []', 2803, 0, 0);
INSERT INTO chado.cvterm VALUES (2538, 23, 'homologous_chromosome_recognition_and_pairing_locus', 'A chromosomal locus where complementary lncRNA and associated proteins accumulate at the corresponding lncRNA gene loci to tether homologous chromosome during chromosome pairing at meiosis I. [PMID:22582262, PMID:31811152]', 2804, 0, 0);
INSERT INTO chado.cvterm VALUES (2539, 23, 'pumilio_response_element', 'A cis-acting element involved in RNA stability found in the 3'' UTR of some RNA (consensus UGUAAAUA). [PMID:30601114]', 2805, 0, 0);
INSERT INTO chado.cvterm VALUES (2540, 23, 'SUMO_interaction_motif', 'A polypeptide region that mediates binding to SUMO. The motif contains a hydrophobic core sequence consisting of three or four Ile, Leu, or Val residues plus one acidic or polar residue at position 2 or 3. [PMID:15388847\,PMID\:16524884]', 2806, 0, 0);
INSERT INTO chado.cvterm VALUES (2541, 23, 'cytosolic_SSU_rRNA_gene', 'A gene that codes for cytosolic SSU rRNA. []', 2807, 0, 0);
INSERT INTO chado.cvterm VALUES (2542, 23, 'cytosolic_LSU_rRNA_gene', 'A gene that codes for cytosolic LSU rRNA. []', 2808, 0, 0);
INSERT INTO chado.cvterm VALUES (2543, 23, 'rRNA_21S_gene', 'A gene which codes for 21S_rRNA, which functions as a component of the large subunit of the ribosome in mitochondria. []', 2809, 1, 0);
INSERT INTO chado.cvterm VALUES (2544, 23, 'partially_duplicated_transcript', 'A transcript which is partially duplicated due to duplication of DNA, leading to a new transcript that is only partial and likely nonfunctional. []', 2810, 0, 0);
INSERT INTO chado.cvterm VALUES (2545, 23, 'five_prime_duplicated_transcript', 'A partially_duplicated_transcript where the 5'' end of the transcript is duplicated. []', 2811, 0, 0);
INSERT INTO chado.cvterm VALUES (2546, 23, 'three_prime_duplicated_transcript', 'A partially_duplicated_transcript where the 3'' end of the transcript is duplicated. []', 2812, 0, 0);
INSERT INTO chado.cvterm VALUES (2547, 23, 'spurious_protein', 'A region of DNA that is predicted to be translated and transcribed into a protein by a protein detection algorithm that does not get transcribed in nature. [PMID:21771858]', 2813, 0, 0);
INSERT INTO chado.cvterm VALUES (2548, 23, 'stem_loop_region', 'A portion of a stem loop secondary structure in RNA. []', 2814, 0, 0);
INSERT INTO chado.cvterm VALUES (2549, 23, 'loop', 'The loop portion of a stem loop, which is not folded back upon itself.  []', 2815, 0, 0);
INSERT INTO chado.cvterm VALUES (2550, 23, 'stem', 'The portion of a stem loop where the RNA is folded back upon itself.  []', 2816, 0, 0);
INSERT INTO chado.cvterm VALUES (2551, 23, 'non_complimentary_stem', 'A region of a stem in a stem loop structure where the sequences are non-complimentary. []', 2817, 0, 0);
INSERT INTO chado.cvterm VALUES (2552, 23, 'knob', 'Cytologically observable heterochromatic regions of chromosomes away from centromeres that contain predominatly large tandem repeats and retrotransposons. [PMID:6439888]', 2818, 0, 0);
INSERT INTO chado.cvterm VALUES (2553, 23, 'teb1_recognition_motif', 'A binding motif with the consensus sequence TTAGGG to which Teb1 binds. [PMID:23314747, PMID:27901072]', 2819, 0, 0);
INSERT INTO chado.cvterm VALUES (2554, 23, 'polyA_site_cluster', 'A region defined by a cluster of experimentally determined polyadenylation sites, typically less than 25 bp in length and associated with a single polyadenylation signal. [PMID:17202160, PMID:24072873, PMID:25906188]', 2820, 0, 0);
INSERT INTO chado.cvterm VALUES (2555, 23, 'LARD', 'Large Retrotransposon Derivative elements are long-terminal repeats that contain reverse transcriptase priming sites and are conserved in sequence but contain no open reading frames encoding typical retrotransposon proteins . The LARDs identified in barley and other Triticeae have LTRs ~5.5 kb and an interal domain of ~3.5 kb. LARDs lack coding domains and thus do not encode proteins. [PMID:15082561]', 2821, 0, 0);
INSERT INTO chado.cvterm VALUES (2556, 23, 'TRIM', 'TRIM elements have terminal direct repeat sequences of 100-250 bp in length that flank an internal domain of 100300 bp. TRIMs lack coding domains and thus do not encode proteins. [PMID:11717436]', 2822, 0, 0);
INSERT INTO chado.cvterm VALUES (2557, 23, 'Watson_strand', 'An absolute reference to the strand. When a chromosome has p and q arms, the Watson strand is the strand whose 5''-end is on the short arm of the chromosome. Of note, the term ''plus strand'' is typically based on a reference sequence where it''s preferred for the plus strand to be the Watson strand, but might not be and ''plus strand'' is therefore not an exact synonym. [PMID:21303550]', 2823, 0, 0);
INSERT INTO chado.cvterm VALUES (2558, 23, 'Crick_strand', 'An absolute reference to the strand. When a chromosome has p and q arms, the Crick strand is the strand whose 5''-end is on the long arm of the chromosome. Of note, the term ''minus strand'' is typically based on a reference sequence where it''s preferred for the minus strand to be the Crick strand, but might not be and ''minus strand'' is therefore not an exact synonym. [PMID:21303550]', 2824, 0, 0);
INSERT INTO chado.cvterm VALUES (2559, 23, 'Copia_LTR_retrotransposon', 'LTR retrotransposons in the Copia superfamily contain elements coding for specific proteins in this order: GAG, AP, INT, RT, RH. GAG is a structural protein for virus-like particles. AP is aspartic proteinase. INT is a DDE integrase. RT is a reverse transcriptase. RH is RNAse H. [PMID:17984973]', 2825, 0, 0);
INSERT INTO chado.cvterm VALUES (2560, 23, 'Gypsy_LTR_retrotransposon', 'LTR retrotransposons in the Gypsy superfamily contain elements coding for specific proteins in this order: GAG, AP, RT, RH, INT. GAG is a structural protein for virus-like particles. AP is aspartic proteinase. INT is a DDE integrase. RT is a reverse transcriptase. RH is RNAse H. [PMID:17984973]', 2826, 0, 0);
INSERT INTO chado.cvterm VALUES (2561, 23, 'Bel_Pao_LTR_retrotransposon', 'LTR retrotransposons in the Bel-Pao superfamily are similar to LTRs in the Gypsy and Retrovirus superfamilies. Mainly described in metazoan genomes, this superfamily contain elements coding for specific proteins in this order: GAG, AP, RT, RH and INT. GAG is a structural protein for virus-like particles. AP is aspartic proteinase. INT is a DDE integrase. RT is a reverse transcriptase. RH is RNAse H. [PMID:17984973]', 2827, 0, 0);
INSERT INTO chado.cvterm VALUES (2562, 23, 'Retrovirus_LTR_retrotransposon', 'LTR retrotransposons in the retrovirus superfamily are similar to LTR retrotransposons in the Gypsy and Bel-Pao superfamilies. Mainly described in vertebrate animals, this superfamily contain elements coding for specific proteins in this order: GAG, AP, RT, RH, INT, and ENV. GAG is a structural protein for virus-like particles. AP is aspartic proteinase. INT is a DDE integrase. RT is a reverse transcriptase. RH is RNAse H. ENV is envelop protein. [PMID:17984973]', 2828, 0, 0);
INSERT INTO chado.cvterm VALUES (2563, 23, 'R2_LINE_retrotransposon', 'R2 retrotransposons are LINE elements (SO:0000194) that insert site-specifically into the host organism''s 28S ribosomal RNA (rRNA) genes. [PMID:21734471]', 2829, 0, 0);
INSERT INTO chado.cvterm VALUES (2564, 23, 'RTE_LINE_retrotransposon', 'RTE retrotransposons are LINE elements (SO:0000194) that contain a domain with homology to the apurinic-apyrimidic (AP) endonucleases in addition to the previously identified reverse transcriptase domain. [PMID:9729877]', 2830, 0, 0);
INSERT INTO chado.cvterm VALUES (2565, 23, 'Jockey_LINE_retrotransposon', 'Jockey retrotransposons are LINE elements (SO:0000194) found only in arthropods. The full-length element is ~5kb and contains two open reading frames (SO:0000236), ORF1 (568 aa) and ORF2 (916 aa), the second of which encodes an apurinic endonuclease (APE) and a reverse transcriptase (RT). [PMID:31709017]', 2831, 0, 0);
INSERT INTO chado.cvterm VALUES (2566, 23, 'I_LINE_retrotransposon', 'Elements of the LINE I superfamily are similar to the Jockey and L1 superfamily. They contains two ORFs, the.second of which includes Apurinic endonuclease (APE) and reverse transcriptase (RT). The I superfamily encodes an RH (RNase H) domain downstream of the RT domain. []', 2832, 0, 0);
INSERT INTO chado.cvterm VALUES (2567, 23, 'tRNA_SINE_retrotransposon', 'Short interspersed elements that originated from tRNAs. [PMID:21673742]', 2834, 0, 0);
INSERT INTO chado.cvterm VALUES (2568, 23, '7SL_SINE_retrotransposon', 'Short interspersed elements that originated from 7SL RNAs. [PMID:21673742]', 2835, 0, 0);
INSERT INTO chado.cvterm VALUES (2569, 23, '5S_SINE_retrotransposon', 'Short interspersed elements that originated from 5S rRNAs. [PMID:21673742]', 2836, 0, 0);
INSERT INTO chado.cvterm VALUES (2570, 23, 'Crypton_YR_transposon', 'Crypton is a superfamily of DNA transposons that use tyrosine recombinase (YR) to cut and rejoin the recombining DNA molecules. [PMID:22011512]', 2837, 0, 0);
INSERT INTO chado.cvterm VALUES (2571, 23, 'Tc1_Mariner_TIR_transposon', 'Elements of the Tc1-Mariner terminal inverted repeat transposon superfamily (also called mariner transposons) are named after the Transponon of C. elegans number 1 transposasse. Their activity creates a 2-bp (TA) target-site duplication (TSD). Stowaway is the non-autonomous element in this superfamily usually shorter than 600 bp. [PMID:17984973, PMID:8556864]', 2838, 0, 0);
INSERT INTO chado.cvterm VALUES (2572, 23, 'hAT_TIR_transposon', 'The hAT terminal inverted repeat transposon superfamily elements were first found in maize (the Ac/Ds elements). Members of the hAT superfamily have TSDs of 8 bp, relatively short TIRs of 527 bp and overall lengths of less than 4 kb. [PMID:11454746]', 2839, 0, 0);
INSERT INTO chado.cvterm VALUES (2573, 23, 'Mutator_TIR_transposon', 'Members of the Mutator family of terminal inverted repeat (TIR) transposon are usually long but are also highly divergent, either sharing only terminal GC nucleotides, or with the GC nucleotides absent. The length of the TSD (7-11 bp, usually 9 bp) remains probably the most useful criterion for identification. [PMID:17984973]', 2840, 0, 0);
INSERT INTO chado.cvterm VALUES (2574, 23, 'Merlin_TIR_transposon', 'Terminal inverted repeat transposon superfamily Merlin elements create 8-9 bp target-site duplications (TSD). [PMID:17984973]', 2841, 0, 0);
INSERT INTO chado.cvterm VALUES (2575, 23, 'Transib_TIR_transposon', 'Terminal inverted repeat (TIR) transposons of the superfamily Transib contain the DDE motif, which is related to the RAG1 protein involved in V(D)J recombination. [PMID:17984973]', 2842, 0, 0);
INSERT INTO chado.cvterm VALUES (2576, 23, 'piggyBac_TIR_transposon', 'Primarily found in animals, the terminal inverted repeat (TIR) transposon superfamily piggyBac elements favour insertion adjacent to TTAA. [PMID:17984973]', 2843, 0, 0);
INSERT INTO chado.cvterm VALUES (2577, 23, 'PIF_Harbinger_TIR_transposon', 'Terminal inverted repeat transposons in the PIF/Harbinger/tourist superfamily create 3-bp target site duplication that are mainly ''TAA'' or ''TTA''. The autonomous PIF-Harbinger elements are relatively small in size, usually a few kb in length. Non-autonomous elements in this superfamily usually shorter than 600 bp are referrred to as Tourist elements. The terminal sequences for PIF/Harbinger/Tourist elements are ''GGG/CCCGGC/GCC'' or ''GA/GGCATGCC/TC''. [PMID:26709091]', 2844, 0, 0);
INSERT INTO chado.cvterm VALUES (2578, 23, 'CACTA_TIR_transposon', 'This terminal inverted repeat of the CACTA family generate 3-bp target site duplication (TSD) upon insertion. CACTA elements do not have a significant preference for genic region insertions. This terminal inverted repeat (TIR) transposon superfamily is named CACTA because their terminal sequences are ''CACTA/GC/TAGTG''. [PMID:26709091]', 2845, 0, 0);
INSERT INTO chado.cvterm VALUES (2579, 23, 'YR_retrotransposon', 'Tyrosine Kinase (YR) retrotransposons are a subclass of non-LTR retrotransposons. These YR-encoding elements consist of central gag, pol and tyrosine recombinase (YR) open reading frames (ORFs) flanked with terminal repeat. The pol ORF includes a reverse transcriptase (RT), a RNase H (RH) and, in case of DIRS, a domain similar to bacterial and phage DNA N-6-adenine-methyltransferase (MT). Compared to the retroviral pol (LTR retrotransposons, non-LTR retrotransposons and Penelope elements), both aspartic protease and DDE integrase are absent from YR retrotransposons. YR retrotransposons have inverted terminal repeats (ITRs). [PMID:24086727]', 2846, 0, 0);
INSERT INTO chado.cvterm VALUES (2580, 23, 'DIRS_YR_retrotransposon', 'Dictyostelium intermediate repeat sequence (DIRS) retrotransposons are members of the YR_retrotransposon (SO:0002286) superfamily with the following protein domains: RT, RH, YR, and MT. RT is a reverse transcriptase. RH is RNAse H. YR is tyrosine recombinase. MT is DNA N-6-adenine-methyltransferase. [PMID:24086727]', 2847, 0, 0);
INSERT INTO chado.cvterm VALUES (2581, 23, 'Ngaro_YR_retrotransposon', 'Ngaro retrotransposons are members of the YR_retrotransposon (SO:0002286) superfamily with the following protein domains: RT, RH, YR. RT is a reverse transcriptase. RH is RNAse H. YR is Tyrosine recombinase. Inverted terminal repeats (ITRs) in Ngaro are arranged in A-pol-B-A-B order where A and B represent ITRs. [PMID:24086727]', 2848, 0, 0);
INSERT INTO chado.cvterm VALUES (2582, 23, 'Viper_YR_retrotransposon', 'VIPER retrotransposons are members of the YR_retrotransposon (SO:0002286 superfamily with protein domains: RT, RH, YR. RT is a reverse transcriptase. RH is RNAse H. YR is Tyrosine recombinase. Inverted terminal repeats (ITRs) in VIPER are arranged in A-pol-B-A-B order where A and B represent ITRs. VIPER is only found in kinetoplastida genomes. [PMID:16297462]', 2849, 0, 0);
INSERT INTO chado.cvterm VALUES (2583, 23, 'Penelope_retrotransposon', 'Penelope is a subclass of non_LTR_retrotransposons (SO:0000189). Penelope retrotransposons contains structural features of TR, RT, EN, TR, terminal repeats which can be in tandem or inverse orientation in different Penelope copies. RT is reverse transcriptase. EN is endonuclease. [PMID:23914310]', 2850, 0, 0);
INSERT INTO chado.cvterm VALUES (2584, 23, 'circular_ncRNA', 'A non-coding RNA that is generated by backsplicing of exons or introns, resulting in a covalently closed loop without a 5 cap or 3 polyA tail. [PMID:29086764, PMID:29182528, PMID:29230098, PMID:29576969, PMID:29626935]', 2851, 0, 0);
INSERT INTO chado.cvterm VALUES (2585, 23, 'circular_mRNA', 'An mRNA that is generated by backsplicing of exons or introns, resulting in a covalently closed loop without a 5 cap or 3 polyA tail. [PMID:29086764, PMID:29182528, PMID:29576969]', 2852, 0, 0);
INSERT INTO chado.cvterm VALUES (2717, 23, 'intrachromosomal_mutation', 'A chromosomal structure variation within a single chromosome. [SO:ke]', 2987, 0, 0);
INSERT INTO chado.cvterm VALUES (2586, 23, 'mitochondrial_control_region', 'The non-coding region of the mitochondrial genome that controls RNA and DNA synthesis. [PMID: 19407924, PMID:10968878]', 2853, 0, 0);
INSERT INTO chado.cvterm VALUES (2587, 23, 'mitochondrial_D_loop', 'Mitochondrial displacement loop; a region within mitochondrial DNA in which a short stretch of RNA is paired with one strand of DNA, displacing the original partner DNA strand in this region. [http://www.insdc.org/files/feature_table.html]', 2855, 0, 0);
INSERT INTO chado.cvterm VALUES (2588, 23, 'transcription_factor_regulatory_site', 'A TF_binding_site that is involved in regulation of expression. [Bacterial_regulation_working_group:CMA, PMID:32665585]', 2856, 0, 0);
INSERT INTO chado.cvterm VALUES (2589, 23, 'TFRS_module', 'The possible discontinuous stretch of DNA that is the combination of one or several TFRSs whose bound TFs work jointly in the regulation of a promoter.  [Bacterial_regulation_working_group:CMA, PMID:32665585]', 2857, 0, 0);
INSERT INTO chado.cvterm VALUES (2590, 23, 'TFRS_collection', 'The possible discontinous stretch of DNA that encompass all the TFRSs that regulate a promoter. [Bacterial_regulation_working_group:CMA, PMID:32665585]', 2858, 0, 0);
INSERT INTO chado.cvterm VALUES (2591, 23, 'simple_operon', 'An operon whose transcription is coordinated on a single transcription unit. [Bacterial_regulation_working_group:CMA, PMID:32665585]', 2859, 0, 0);
INSERT INTO chado.cvterm VALUES (2592, 23, 'complex_operon', 'An operon whose transcription is coordinated on several mutually overlapping transcription units transcribed in the same direction and sharing at least one gene. [Bacterial_regulation_working_group:CMA, PMID:32665585]', 2860, 0, 0);
INSERT INTO chado.cvterm VALUES (2593, 23, 'transcription_unit', 'DNA regions delimited by different nonspurious TSS-TTS pairs. [Bacterial_regulation_working_group:CMA, PMID:32665585]', 2861, 0, 0);
INSERT INTO chado.cvterm VALUES (2594, 23, 'simple_regulon', 'A regulon defined by considering one regulatory gene product. [Bacterial_regulation_working_group:CMA, PMID:32665585]', 2862, 0, 0);
INSERT INTO chado.cvterm VALUES (2595, 23, 'regulon', 'A set of units of gene expression directly regulated by a common set of one or more common regulatory gene products. [ISBN:0198506732, PMID:32665585]', 2863, 0, 0);
INSERT INTO chado.cvterm VALUES (2596, 23, 'complex_regulon', 'A regulon defined by considering the units of expression regulated by a specified set of regulatory gene products. [Bacterial_regulation_working_group:CMA, PMID:32665585]', 2864, 0, 0);
INSERT INTO chado.cvterm VALUES (2597, 23, 'topologically_associated_domain', 'An instance of a self-interacting DNA region flanked by left and right TAD boundaries. [GREEKC:cl, PMID:32782014]', 2865, 0, 0);
INSERT INTO chado.cvterm VALUES (2598, 23, 'topologically_associated_domain_boundary', 'A DNA region enriched in DNA loop anchors and across which DNA loops occur less often than expected by chance. [GREEKC:cl, PMID:32782014]', 2866, 0, 0);
INSERT INTO chado.cvterm VALUES (2599, 23, 'chromatin_regulatory_region', 'A region of a chromosome where regulatory events occur, including epigenetic modifications. These epigenetic modifications can include nucleosome modifications and post-replicational DNA modifications. [GREEKC:cl, PMID:32782014]', 2867, 0, 0);
INSERT INTO chado.cvterm VALUES (2600, 23, 'DNA_loop', 'A region of DNA between two loop anchor positions that are held in close physical proximity. [GREEKC:cl, PMID:32782014]', 2868, 0, 0);
INSERT INTO chado.cvterm VALUES (2601, 23, 'DNA_loop_anchor', 'The ends of a DNA loop where the two strands of DNA are held in close physical proximity. During interphase the anchors of DNA loops are convergently oriented CTCF binding sites. [GREEKC:cl, PMID:32782014]', 2869, 0, 0);
INSERT INTO chado.cvterm VALUES (2602, 23, 'cryptic_promoter', 'The promoter of a cryptic gene. [GREEKC:cl]', 2870, 0, 0);
INSERT INTO chado.cvterm VALUES (2603, 23, 'core_prokaryotic_promoter_element', 'An element that always exists within the promoter region of a prokaryotic gene. [GREEKC:rl]', 2871, 0, 0);
INSERT INTO chado.cvterm VALUES (2604, 23, 'core_viral_promoter_element', 'An element that always exists within the promoter region of a viral gene. [GREEKC:rl]', 2872, 0, 0);
INSERT INTO chado.cvterm VALUES (2605, 23, 'altered_gene_product_level', 'A sequence variant that alters the level or amount of gene product produced. This high level term can be applied where the direction of level change (increased vs decreased gene product level) is unknown or not confirmed. [GenCC:AR]', 2873, 0, 0);
INSERT INTO chado.cvterm VALUES (2606, 23, 'increased_gene_product_level', 'A variant that increases the level or amount of gene product produced. [GenCC:AR]', 2874, 0, 0);
INSERT INTO chado.cvterm VALUES (2607, 23, 'decreased_gene_product_level', 'A sequence variant that decreases the level or amount of gene product produced. [GenCC:AR]', 2875, 0, 0);
INSERT INTO chado.cvterm VALUES (2608, 23, 'absent_gene_product', 'A sequence variant that results in no gene product. [GenCC:AR]', 2876, 0, 0);
INSERT INTO chado.cvterm VALUES (2609, 23, 'altered_gene_product_sequence', 'A sequence variant that alters the sequence of a gene product. [GenCC:AR]', 2877, 0, 0);
INSERT INTO chado.cvterm VALUES (2610, 23, 'NMD_triggering_variant', 'A sequence variant that leads to a change in the location of a termination codon in a transcript that leads to nonsense-mediated decay (NMD). The change in location of a termination codon can be caused by several different types of sequence variants, including stop_gained (SO:0001587), frameshift_variant (SO:0001589), splice_donor_variant (SO:0001575), and splice_acceptor_variant (SO:0001574) types of variants. [GenCC:AR]', 2878, 0, 0);
INSERT INTO chado.cvterm VALUES (2611, 23, 'NMD_escaping_variant', 'A sequence variant that leads to a change in the location of a termination codon in a transcript but allows the transcript to escape nonsense-mediated decay (NMD). The change in location of a termination codon can be caused by several different types of sequence variants, including stop_gained (SO:0001587), frameshift_variant (SO:0001589), splice_donor_variant (SO:0001575), and splice_acceptor_variant (SO:0001574) types of variants. [GenCC:AR]', 2879, 0, 0);
INSERT INTO chado.cvterm VALUES (2612, 23, 'stop_gained_NMD_triggering', 'A stop_gained (SO:0001587) variant that is degraded by nonsense-mediated decay (NMD). [GenCC:AR]', 2880, 0, 0);
INSERT INTO chado.cvterm VALUES (2613, 23, 'stop_gained_NMD_escaping', 'A stop_gained (SO:0001587) variant that allows the transcript to escape nonsense-mediated decay (NMD). [GenCC:AR]', 2881, 0, 0);
INSERT INTO chado.cvterm VALUES (2614, 23, 'frameshift_variant_NMD_triggering', 'A frameshift_variant (SO:0001589) that is degraded by nonsense-mediated decay (NMD). [GenCC:AR]', 2882, 0, 0);
INSERT INTO chado.cvterm VALUES (2615, 23, 'frameshift_variant_NMD_escaping', 'A frameshift_variant (SO:0001589) that allows the transcript to escape nonsense-mediated decay (NMD). [GenCC:AR]', 2883, 0, 0);
INSERT INTO chado.cvterm VALUES (2616, 23, 'splice_donor_variant_NMD_triggering', 'A splice_donor_variant (SO:0001575) that is degraded by nonsense-mediated decay (NMD). [GenCC:AR]', 2884, 0, 0);
INSERT INTO chado.cvterm VALUES (2617, 23, 'splice_donor_variant_NMD_escaping', 'A splice_donor_variant (SO:0001575) that allows the transcript to escape nonsense-mediated decay (NMD). [GenCC:AR]', 2885, 0, 0);
INSERT INTO chado.cvterm VALUES (2618, 23, 'splice_acceptor_variant_NMD_triggering', 'A splice_acceptor_variant (SO:0001574) that is degraded by nonsense-mediated decay (NMD). [GenCC:AR]', 2886, 0, 0);
INSERT INTO chado.cvterm VALUES (2619, 23, 'splice_acceptor_variant_NMD_escaping', 'A splice_acceptor_variant (SO:0001574) that allows the transcript to escape nonsense-mediated decay (NMD). [GenCC:AR]', 2887, 0, 0);
INSERT INTO chado.cvterm VALUES (2620, 23, 'minus_1_translational_frameshift', 'The region of mRNA 1 base long that is included as part of two separate codons during the process of translational frameshifting (GO:0006452), causing the reading frame to be different. [SO:ds]', 2888, 0, 0);
INSERT INTO chado.cvterm VALUES (2621, 23, 'minus_2_translational_frameshift', 'The region of mRNA 2 bases long that is included as part of two separate codons during the process of translational frameshifting (GO:0006452), causing the reading frame to be different. [SO:ds]', 2889, 0, 0);
INSERT INTO chado.cvterm VALUES (2622, 23, 'epigenomically_modified_region', 'A biological region implicated in inherited changes caused by mechanisms other than changes in the underlying DNA sequence. [http://en.wikipedia.org/wiki/Epigenetics, SO:ds]', 2890, 0, 0);
INSERT INTO chado.cvterm VALUES (2623, 23, 'amber_stop_codon', 'A stop codon with the DNA sequence TAG. [https://en.wikipedia.org/wiki/Stop_codon]', 2892, 0, 0);
INSERT INTO chado.cvterm VALUES (2624, 23, 'ochre_stop_codon', 'A stop codon with the DNA sequence TAA. [https://en.wikipedia.org/wiki/Stop_codon]', 2893, 0, 0);
INSERT INTO chado.cvterm VALUES (2625, 23, 'opal_stop_codon', 'A stop codon with the DNA sequence TGA. [https://en.wikipedia.org/wiki/Stop_codon]', 2894, 0, 0);
INSERT INTO chado.cvterm VALUES (2626, 23, 'cytosolic_rRNA_2S_gene', 'A gene that encodes for 2S ribosomal RNA, which functions as a component of the large subunit of the ribosome in Drosophila and at least some other Diptera. [PMID: 118436, PMID: 29474379, PMID: 3136294, PMID:10788608, PMID:407103, PMID:4847940, PMID:768488]', 2895, 0, 0);
INSERT INTO chado.cvterm VALUES (2627, 23, 'cytosolic_2S_rRNA', 'Cytosolic 2S rRNA is a 30 nucleotide RNA component of the large subunit of cytosolic ribosomes in Drosophila and at least some other Diptera. It is homologous to the 3'' part of other 5.8S rRNA molecules. The 3'' end of the 5.8S molecule is able to base-pair with the 5'' end of the 2S rRNA to generate a helical region equivalent in position to the ''GC-rich hairpin'' found in all previously sequenced 5.8S molecules. [PMID: 118436, PMID: 29474379, PMID: 3136294, PMID:10788608, PMID:407103, PMID:4847940, PMID:768488]', 2896, 0, 0);
INSERT INTO chado.cvterm VALUES (2628, 23, 'U7_snRNA', 'A 57 to 71 nucleotide RNA that is a component of the U7 small nuclear ribonucleoprotein complex (U7 snRNP). The U7 snRNP is required for histone pre-mRNA processing. [PMID:15526162]', 2897, 0, 0);
INSERT INTO chado.cvterm VALUES (2629, 23, 'scaRNA_gene', 'A gene that encodes for a scaRNA (small Cajal body-specific RNA). [PMID:27775477, PMID:28869095]', 2898, 0, 0);
INSERT INTO chado.cvterm VALUES (2630, 23, 'RNA_7SK', 'An abundant small nuclear RNA that, together with associated cellular proteins, regulates the activity of the positive transcription elongation factor b (P-TEFb). It is often described in literature as similar to a snRNA, except of longer length. [PMID:19246988, PMID:21853533, PMID:27369380]', 2899, 0, 0);
INSERT INTO chado.cvterm VALUES (2631, 23, 'RNA_7SK_gene', 'A gene encoding a 7SK RNA (SO:0002340). [PMID:19246988, PMID:21853533, PMID:27369380]', 2900, 0, 0);
INSERT INTO chado.cvterm VALUES (2632, 23, 'mt_SSU_rRNA', 'Mitochondrial SSU rRNA is an RNA component of the small subunit of mitochondrial ribosomes. [PMID: 24572720, PMID:3044395]', 2901, 0, 0);
INSERT INTO chado.cvterm VALUES (2633, 23, 'mt_LSU_rRNA', 'Mitochondrial LSU rRNA is an RNA component of the large subunit of mitochondrial ribosomes. [PMID: 24572720, PMID:3044395]', 2902, 0, 0);
INSERT INTO chado.cvterm VALUES (2634, 23, 'plastid_rRNA', 'Plastid rRNA is an RNA component of the small or large subunits of plastid (such as chloroplast) ribosomes. [PMID: 24572720, PMID:3044395]', 2903, 0, 0);
INSERT INTO chado.cvterm VALUES (2635, 23, 'plastid_SSU_rRNA', 'Plastid SSU rRNA is an RNA component of the small subunit of plastid (such as chloroplast) ribosomes. [PMID: 24572720, PMID:3044395]', 2904, 0, 0);
INSERT INTO chado.cvterm VALUES (2636, 23, 'plastid_LSU_rRNA', 'Plastid LSU rRNA is an RNA component of the large subunit of plastid (such as chloroplast) ribosomes. [PMID: 24572720, PMID:3044395]', 2905, 0, 0);
INSERT INTO chado.cvterm VALUES (2637, 23, 'fragile_site', 'A heritable locus on a chromosome that is prone to DNA breakage. []', 2906, 0, 0);
INSERT INTO chado.cvterm VALUES (2638, 23, 'common_fragile_site', 'A fragile site considered part of the normal chromosomal structure. [PMID: 16236432, PMID: 17608616]', 2907, 0, 0);
INSERT INTO chado.cvterm VALUES (2639, 23, 'rare_fragile_site', 'A fragile site found in the chromosomes of less than five percent of the human population. [PMID:16236432, PMID:17608616]', 2908, 0, 0);
INSERT INTO chado.cvterm VALUES (2640, 23, 'sisRNA', 'A non-coding RNA typically derived from intronic sequence of the sense strand of a cognate host gene, that is not rapidly degraded. It may contain exonic sequences, 5 caps, and/or polyA tails. [PMID:27147469, PMID:29397203, PMID:30391089]', 2909, 0, 0);
INSERT INTO chado.cvterm VALUES (2641, 23, 'sbRNA_gene', 'A gene encoding a stem-bulge RNA. [PMID:25908866, PMID:30666901]', 2910, 0, 0);
INSERT INTO chado.cvterm VALUES (2642, 23, 'sbRNA', 'A small non-coding stem-loop RNA present in nematodes and insects, functionally and structurally related to vertebrate Y RNA. [PMID:25908866, PMID:30666901]', 2911, 0, 0);
INSERT INTO chado.cvterm VALUES (2643, 23, 'hpRNA_gene', 'A gene encoding a hpRNA. [PMID:18463630, PMID:18719707, PMID:25544562]', 2912, 0, 0);
INSERT INTO chado.cvterm VALUES (2644, 23, 'hpRNA', 'An RNA comprising an extended inverted repeat, the stem of which is typically much longer than that of miRNA precursors and can be up to 400 base pairs in length. hpRNAs are processed by Dicer-2 to generate endogenous short interfering RNAs (siRNAs). [PMID:18463630, PMID:18719707, PMID:25544562]', 2913, 0, 0);
INSERT INTO chado.cvterm VALUES (2645, 23, 'biosynthetic_gene_cluster', 'A physically clustered group of two or more genes in a particular genome that together encode a biosynthetic pathway for the production of a specialized metabolite (including its chemical variants). [PMID:26284661]', 2914, 0, 0);
INSERT INTO chado.cvterm VALUES (2646, 23, 'vault_RNA_gene', 'A gene that encodes a vault RNA. [PMID:19298825, PMID:19491402, PMID:22058117, PMID:22926522, PMID:30773316, PMID:9535882]', 2915, 0, 0);
INSERT INTO chado.cvterm VALUES (2647, 23, 'Y_RNA_gene', 'A gene that encodes a Y RNA. [PMID:1698620, PMID:6187471, PMID:6816230, PMID:7520568, PMID:7539809, PMID:8836182]', 2916, 0, 0);
INSERT INTO chado.cvterm VALUES (2648, 23, 'cytosolic_rRNA_gene', 'A gene that codes for cytosolic rRNA. []', 2917, 0, 0);
INSERT INTO chado.cvterm VALUES (2649, 23, 'mt_rRNA_gene', 'A gene that codes for mitochondrial rRNA. []', 2918, 0, 0);
INSERT INTO chado.cvterm VALUES (2650, 23, 'mt_LSU_rRNA_gene', 'A gene that codes for mitochondrial LSU rRNA. []', 2919, 0, 0);
INSERT INTO chado.cvterm VALUES (2651, 23, 'mt_SSU_rRNA_gene', 'A gene that codes for mitochondrial SSU rRNA. []', 2920, 0, 0);
INSERT INTO chado.cvterm VALUES (2652, 23, 'plastid_rRNA_gene', 'A gene that codes for plastid rRNA. []', 2921, 0, 0);
INSERT INTO chado.cvterm VALUES (2653, 23, 'plastid_LSU_rRNA_gene', 'A gene that codes for plastid LSU rRNA. []', 2922, 0, 0);
INSERT INTO chado.cvterm VALUES (2654, 23, 'plastid_SSU_rRNA_gene', 'A gene that codes for plastid SSU rRNA. []', 2923, 0, 0);
INSERT INTO chado.cvterm VALUES (2655, 23, 'C_D_box_scaRNA', 'A scaRNA possessing a box C/D sequence motif, guiding the methylation of snRNAs. [PMID:17099227, PMID:24659245]', 2924, 0, 0);
INSERT INTO chado.cvterm VALUES (2656, 23, 'H_ACA_box_scaRNA', 'A scaRNA possessing a box H/ACA sequence motif, guiding the pseudouridylation of snRNAs. [PMID:17099227, PMID:24659245]', 2925, 0, 0);
INSERT INTO chado.cvterm VALUES (2657, 23, 'C-D_H_ACA_box_scaRNA', 'A scaRNA possessing both box C/D and box H/ACA sequence motifs, guiding both the methylation and pseudouridylation of snRNAs. [PMID:17099227, PMID:24659245]', 2926, 0, 0);
INSERT INTO chado.cvterm VALUES (2658, 23, 'C_D_box_scaRNA_gene', 'A gene that codes for scaRNA possessing a box C/D sequence motif, guiding the methylation of snRNAs. [PMID:17099227, PMID:24659245]', 2927, 0, 0);
INSERT INTO chado.cvterm VALUES (2659, 23, 'H_ACA_box_scaRNA_gene', 'A gene that codes for scaRNA possessing a box H/ACA sequence motif, guiding the pseudouridylation of snRNAs. [PMID:17099227, PMID:24659245]', 2928, 0, 0);
INSERT INTO chado.cvterm VALUES (2660, 23, 'C-D_H_ACA_box_scaRNA_gene', 'A gene that codes for scaRNA possessing both box C/D and box H/ACA sequence motifs, guiding both the methylation and pseudouridylation of snRNAs. [PMID:17099227, PMID:24659245]', 2929, 0, 0);
INSERT INTO chado.cvterm VALUES (2661, 23, 'C_D_box_snoRNA_gene', 'A gene that codes a C_D_box_snoRNA. Most box C/D snoRNAs also contain long (>10 nt) sequences complementary to rRNA. Boxes C and D, as well as boxes C'' and D'', are usually located in close proximity, and form a structure known as the box C/D motif. This motif is important for snoRNA stability, processing, nucleolar targeting and function. A small number of box C/D snoRNAs are involved in rRNA processing; most, however, are known or predicted to serve as guide RNAs in ribose methylation of rRNA. Targeting involves direct base pairing of the snoRNA at the rRNA site to be modified and selection of a rRNA nucleotide a fixed distance from box D or D''. [PMID:12457565, PMID:22065625]', 2930, 0, 0);
INSERT INTO chado.cvterm VALUES (2662, 23, 'H_ACA_box_snoRNA_gene', 'A gene that codes for H_ACA_box_snoRNA. Members of the box H/ACA family contain an ACA triplet, exactly 3 nt upstream from the 3'' end and an H-box in a hinge region that links two structurally similar functional domains of the molecule. Both boxes are important for snoRNA biosynthesis and function. A few box H/ACA snoRNAs are involved in rRNA processing; most others are known or predicted to participate in selection of uridine nucleosides in rRNA to be converted to pseudouridines. Site selection is mediated by direct base pairing of the snoRNA with rRNA through one or both targeting domains. [PMID:12457565, PMID:22065625]', 2931, 0, 0);
INSERT INTO chado.cvterm VALUES (2663, 23, 'U14_snoRNA_gene', 'A gene that codes for U14_snoRNA. U14 small nucleolar RNA (U14 snoRNA) is required for early cleavages of eukaryotic precursor rRNAs. In yeasts, this molecule possess a stem-loop region (known as the Y-domain) which is essential for function. A similar structure, but with a different consensus sequence, is found in plants, but is absent in vertebrates. []', 2932, 0, 0);
INSERT INTO chado.cvterm VALUES (2664, 23, 'U3_snoRNA_gene', 'A gene that codes for U3_snoRNA. U3 snoRNA is a member of the box C/D class of small nucleolar RNAs. The U3 snoRNA secondary structure is characterised by a small 5'' domain (with boxes A and A''), and a larger 3'' domain (with boxes B, C, C'', and D), the two domains being linked by a single-stranded hinge. Boxes B and C form the B/C motif, which appears to be exclusive to U3 snoRNAs, and boxes C'' and D form the C''/D motif. The latter is functionally similar to the C/D motifs found in other snoRNAs. The 5'' domain and the hinge region act as a pre-rRNA-binding domain. The 3'' domain has conserved protein-binding sites. Both the box B/C and box C''/D motifs are sufficient for nuclear retention of U3 snoRNA. The box C''/D motif is also necessary for nucleolar localization, stability and hypermethylation of U3 snoRNA. Both box B/C and C''/D motifs are involved in specific protein interactions and are necessary for the rRNA processing functions of U3 snoRNA. []', 2933, 0, 0);
INSERT INTO chado.cvterm VALUES (2665, 23, 'methylation_guide_snoRNA_gene', 'A gene that codes for methylation_guide_snoRNA. A snoRNA that specifies the site of 2''-O-ribose methylation in an RNA molecule by base pairing with a short sequence around the target residue. [PMID:12457565]', 2934, 0, 0);
INSERT INTO chado.cvterm VALUES (2666, 23, 'pseudouridylation_guide_snoRNA_gene', 'A gene that codes for pseudouridylation_guide_snoRNA. A snoRNA that specifies the site of pseudouridylation in an RNA molecule by base pairing with a short sequence around the target residue. [PMID:12457565]', 2935, 0, 0);
INSERT INTO chado.cvterm VALUES (2667, 23, 'bidirectional_promoter_lncRNA', 'A long non-coding RNA which is produced using the promoter of a protein-coding gene but with transcription occurring in the opposite direction." [PMID:30175284, PMID:34956340] {comment="PMID:26578749}', 2936, 0, 0);
INSERT INTO chado.cvterm VALUES (2668, 23, 'methylation_guide_snoRNA', 'A snoRNA that specifies the site of 2''-O-ribose methylation in an RNA molecule by base pairing with a short sequence around the target residue. [GOC:mah, PMID:12457565]', 2937, 0, 0);
INSERT INTO chado.cvterm VALUES (2669, 23, 'rRNA_cleavage_RNA', 'An ncRNA that is part of a ribonucleoprotein that cleaves the primary pre-rRNA transcript in the process of producing mature rRNA molecules. [GOC:kgc]', 2938, 0, 0);
INSERT INTO chado.cvterm VALUES (2670, 23, 'exon_of_single_exon_gene', 'An exon that is the only exon in a gene. [RSC:cb]', 2939, 0, 0);
INSERT INTO chado.cvterm VALUES (2671, 23, 'cassette_array_member', 'A gene that is a member of a gene cassette, which is a mobile genetic element. []', 2940, 0, 0);
INSERT INTO chado.cvterm VALUES (2672, 23, 'gene_cassette_member', 'A gene that is a member of a gene cassette, which is a mobile genetic element. []', 2941, 0, 0);
INSERT INTO chado.cvterm VALUES (2673, 23, 'gene_subarray_member', 'A gene that is a member of a group of genes that are either regulated or transcribed together within a larger group of genes that are regulated or transcribed together. []', 2942, 0, 0);
INSERT INTO chado.cvterm VALUES (2674, 23, 'primer_binding_site', 'Non-covalent primer binding site for initiation of replication, transcription, or reverse transcription. [http://www.insdc.org/files/feature_table.html]', 2943, 0, 0);
INSERT INTO chado.cvterm VALUES (2675, 23, 'gene_array', 'An array includes two or more genes, or two or more gene subarrays, contiguously arranged where the individual genes, or subarrays, are either identical in sequence, or essentially so. [SO:ma]', 2944, 0, 0);
INSERT INTO chado.cvterm VALUES (2676, 23, 'gene_subarray', 'A subarray is, by defintition, a member of a gene array (SO:0005851); the members of a subarray may differ substantially in sequence, but are closely related in function. [SO:ma]', 2945, 0, 0);
INSERT INTO chado.cvterm VALUES (2677, 23, 'gene_cassette', 'A gene that can be substituted for a related gene at a different site in the genome. [SGD:se]', 2946, 0, 0);
INSERT INTO chado.cvterm VALUES (2678, 23, 'selenocysteine_tRNA_primary_transcript', 'A primary transcript encoding seryl tRNA (SO:000269). [SO:ke]', 2947, 0, 0);
INSERT INTO chado.cvterm VALUES (2679, 23, 'selenocysteinyl_tRNA', 'A tRNA sequence that has a selenocysteine anticodon, and a 3'' selenocysteine binding region. [SO:ke]', 2948, 0, 0);
INSERT INTO chado.cvterm VALUES (2680, 23, 'syntenic_region', 'A region in which two or more pairs of homologous markers occur on the same chromosome in two or more species. [http://www.informatics.jax.org/silverbook/glossary.shtml]', 2949, 0, 0);
INSERT INTO chado.cvterm VALUES (2681, 23, 'intrinsically_unstructured_polypeptide_region', 'A region of polypeptide chain with high conformational flexibility. [EBIBS:GAR]', 2950, 0, 0);
INSERT INTO chado.cvterm VALUES (2718, 23, 'interchromosomal_mutation', 'A chromosomal structure variation whereby more than one chromosome is involved. [SO:ke]', 2988, 0, 0);
INSERT INTO chado.cvterm VALUES (2953, 25, 'Department(TCONTACT:0000016)', 'The department of an institution or organization.', 3260, 0, 0);
INSERT INTO chado.cvterm VALUES (2682, 23, 'catmat_left_handed_three', 'A motif of 3 consecutive residues with dihedral angles as follows: res i: phi -90 bounds -120 to -60, res i: psi -10 bounds -50 to 30, res i+1: phi -75 bounds -100 to -50, res i+1: psi 140 bounds 110 to 170. An extra restriction of the length of the O to O distance would be useful, that it be less than 5 Angstrom. More precisely these two oxygens are the main chain carbonyl oxygen atoms of residues i-1 and i+1. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 2951, 0, 0);
INSERT INTO chado.cvterm VALUES (2683, 23, 'catmat_left_handed_four', 'A motif of 4 consecutive residues with dihedral angles as follows: res i: phi -90 bounds -120 to -60, res i psi -10 bounds -50 to 30, res i+1: phi -90 bounds -120 to -60, res i+1: psi -10 bounds -50 to 30, res i+2: phi -75 bounds -100 to -50, res i+2: psi 140 bounds 110 to 170. The extra restriction of the length of the O to O distance is similar, that it be less than 5 Angstrom. In this case these two Oxygen atoms are the main chain carbonyl oxygen atoms of residues i-1 and i+2. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 2952, 0, 0);
INSERT INTO chado.cvterm VALUES (2684, 23, 'catmat_right_handed_three', 'A motif of 3 consecutive residues with dihedral angles as follows: res i: phi -90 bounds -120 to -60, res i: psi -10 bounds -50 to 30, res i+1: phi -75 bounds -100 to -50, res i+1: psi 140 bounds 110 to 170. An extra restriction of the length of the O to O distance would be useful, that it be less than 5 Angstrom. More precisely these two oxygens are the main chain carbonyl oxygen atoms of residues i-1 and i+1. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 2953, 0, 0);
INSERT INTO chado.cvterm VALUES (2685, 23, 'catmat_right_handed_four', 'A motif of 4 consecutive residues with dihedral angles as follows: res i: phi -90 bounds -120 to -60, res i: psi -10 bounds -50 to 30, res i+1: phi -90 bounds -120 to -60, res i+1: psi -10 bounds -50 to 30, res i+2: phi -75 bounds -100 to -50, res i+2: psi 140 bounds 110 to 170. The extra restriction of the length of the O to O distance is similar, that it be less than 5 Angstrom. In this case these two Oxygen atoms are the main chain carbonyl oxygen atoms of residues i-1 and i+2. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 2954, 0, 0);
INSERT INTO chado.cvterm VALUES (2686, 23, 'alpha_beta_motif', 'A motif of five consecutive residues and two H-bonds in which: H-bond between CO of residue(i) and NH of residue(i+4), H-bond between CO of residue(i) and NH of residue(i+3),Phi angles of residues(i+1), (i+2) and (i+3) are negative. [EBIBS:GAR, http://www.ebi.ac.uk/msd-srv/msdmotif/]', 2955, 0, 0);
INSERT INTO chado.cvterm VALUES (2687, 23, 'lipoprotein_signal_peptide', 'A peptide that acts as a signal for both membrane translocation and lipid attachment in prokaryotes. [EBIBS:GAR]', 2956, 0, 0);
INSERT INTO chado.cvterm VALUES (2688, 23, 'no_output', 'An experimental region wherean analysis has been run and not produced any annotation. [EBIBS:GAR]', 2957, 0, 0);
INSERT INTO chado.cvterm VALUES (2689, 23, 'peptide_coil', 'Irregular, unstructured regions of a protein''s backbone, as distinct from the regular region (namely alpha helix and beta strand - characterised by specific patterns of main-chain hydrogen bonds). [EBIBS:GAR]', 2958, 0, 0);
INSERT INTO chado.cvterm VALUES (2690, 23, 'hydrophobic_region_of_peptide', 'Hydrophobic regions are regions with a low affinity for water. [EBIBS:GAR]', 2959, 0, 0);
INSERT INTO chado.cvterm VALUES (2691, 23, 'n_terminal_region', 'The amino-terminal positively-charged region of a signal peptide (approx 1-5 aa). [EBIBS:GAR]', 2960, 0, 0);
INSERT INTO chado.cvterm VALUES (2692, 23, 'c_terminal_region', 'The more polar, carboxy-terminal region of the signal peptide (approx 3-7 aa). [EBIBS:GAR]', 2961, 0, 0);
INSERT INTO chado.cvterm VALUES (2693, 23, 'central_hydrophobic_region_of_signal_peptide', 'The central, hydrophobic region of the signal peptide (approx 7-15 aa). [EBIBS:GAR]', 2962, 0, 0);
INSERT INTO chado.cvterm VALUES (2694, 23, 'polypeptide_binding_motif', 'A polypeptide binding motif is a short (up to 20 amino acids) polypeptide region of biological interest that contains one or more amino acids experimentally shown to bind to a ligand. [EBIBS:GAR]', 2963, 0, 0);
INSERT INTO chado.cvterm VALUES (2695, 23, 'polypeptide_DNA_contact', 'A binding site that, in the polypeptide molecule, interacts selectively and non-covalently with DNA. [EBIBS:GAR, SO:ke]', 2964, 0, 0);
INSERT INTO chado.cvterm VALUES (2696, 23, 'complex_substitution', 'When no simple or well defined DNA mutation event describes the observed DNA change, the keyword \"complex\" should be used. Usually there are multiple equally plausible explanations for the change. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 2966, 0, 0);
INSERT INTO chado.cvterm VALUES (2697, 23, 'point_mutation', 'A single nucleotide change which has occurred at the same position of a corresponding nucleotide in a reference sequence. [SO:immuno_workshop]', 2967, 0, 0);
INSERT INTO chado.cvterm VALUES (2698, 23, 'transition', 'Change of a pyrimidine nucleotide, C or T, into an other pyrimidine nucleotide, or change of a purine nucleotide, A or G, into an other purine nucleotide. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 2968, 0, 0);
INSERT INTO chado.cvterm VALUES (2699, 23, 'pyrimidine_transition', 'A substitution of a pyrimidine, C or T, for another pyrimidine. [SO:ke]', 2969, 0, 0);
INSERT INTO chado.cvterm VALUES (2700, 23, 'C_to_T_transition', 'A transition of a cytidine to a thymine. [SO:ke]', 2970, 0, 0);
INSERT INTO chado.cvterm VALUES (2701, 23, 'C_to_T_transition_at_pCpG_site', 'The transition of cytidine to thymine occurring at a pCpG site as a consequence of the spontaneous deamination of 5''-methylcytidine. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 2971, 0, 0);
INSERT INTO chado.cvterm VALUES (2702, 23, 'T_to_C_transition', 'A transition of a thymine to a cytidine. []', 2972, 0, 0);
INSERT INTO chado.cvterm VALUES (2703, 23, 'purine_transition', 'A substitution of a purine, A or G, for another purine. [SO:ke]', 2973, 0, 0);
INSERT INTO chado.cvterm VALUES (2704, 23, 'A_to_G_transition', 'A transition of an adenine to a guanine. [SO:ke]', 2974, 0, 0);
INSERT INTO chado.cvterm VALUES (2705, 23, 'G_to_A_transition', 'A transition of a guanine to an adenine. [SO:ke]', 2975, 0, 0);
INSERT INTO chado.cvterm VALUES (2706, 23, 'transversion', 'Change of a pyrimidine nucleotide, C or T, into a purine nucleotide, A or G, or vice versa. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 2976, 0, 0);
INSERT INTO chado.cvterm VALUES (2707, 23, 'pyrimidine_to_purine_transversion', 'Change of a pyrimidine nucleotide, C or T, into a purine nucleotide, A or G. [SO:ke]', 2977, 0, 0);
INSERT INTO chado.cvterm VALUES (2708, 23, 'C_to_A_transversion', 'A transversion from cytidine to adenine. [SO:ke]', 2978, 0, 0);
INSERT INTO chado.cvterm VALUES (2709, 23, 'C_to_G_transversion', 'A transversion of a cytidine to a guanine. []', 2979, 0, 0);
INSERT INTO chado.cvterm VALUES (2710, 23, 'T_to_A_transversion', 'A transversion from T to A. [SO:ke]', 2980, 0, 0);
INSERT INTO chado.cvterm VALUES (2711, 23, 'T_to_G_transversion', 'A transversion from T to G. [SO:ke]', 2981, 0, 0);
INSERT INTO chado.cvterm VALUES (2712, 23, 'purine_to_pyrimidine_transversion', 'Change of a purine nucleotide, A or G , into a pyrimidine nucleotide C or T. [SO:ke]', 2982, 0, 0);
INSERT INTO chado.cvterm VALUES (2713, 23, 'A_to_C_transversion', 'A transversion from adenine to cytidine. [SO:ke]', 2983, 0, 0);
INSERT INTO chado.cvterm VALUES (2714, 23, 'A_to_T_transversion', 'A transversion from adenine to thymine. [SO:ke]', 2984, 0, 0);
INSERT INTO chado.cvterm VALUES (2715, 23, 'G_to_C_transversion', 'A transversion from guanine to cytidine. [SO:ke]', 2985, 0, 0);
INSERT INTO chado.cvterm VALUES (2719, 23, 'delins', 'A sequence alteration which included an insertion and a deletion, affecting 2 or more bases. [http://varnomen.hgvs.org/recommendations/DNA/variant/delins/]', 2989, 0, 0);
INSERT INTO chado.cvterm VALUES (2720, 23, 'direct_tandem_duplication', 'A tandem duplication where the individual regions are in the same orientation. [SO:ke]', 2993, 0, 0);
INSERT INTO chado.cvterm VALUES (2721, 23, 'tandem_duplication', 'A duplication consisting of 2 identical adjacent regions. [SO:ke]', 2994, 0, 0);
INSERT INTO chado.cvterm VALUES (2722, 23, 'inverted_tandem_duplication', 'A tandem duplication where the individual regions are not in the same orientation. [SO:ke]', 2995, 0, 0);
INSERT INTO chado.cvterm VALUES (2723, 23, 'Robertsonian_fusion', 'A non reciprocal translocation whereby the participating chromosomes break at their centromeres and the long arms fuse to form a single chromosome with a single centromere. [http://en.wikipedia.org/wiki/Robertsonian_translocation]', 2996, 0, 0);
INSERT INTO chado.cvterm VALUES (2724, 23, 'pericentric_inversion', 'A chromosomal inversion that includes the centromere. [FB:reference_manual]', 2997, 0, 0);
INSERT INTO chado.cvterm VALUES (2725, 23, 'paracentric_inversion', 'A chromosomal inversion that does not include the centromere. [FB:reference_manual]', 2998, 0, 0);
INSERT INTO chado.cvterm VALUES (2726, 23, 'reciprocal_chromosomal_translocation', 'A chromosomal translocation with two breaks; two chromosome segments have simply been exchanged. [FB:reference_manual]', 2999, 0, 0);
INSERT INTO chado.cvterm VALUES (2727, 23, 'sequence_variation_affecting_transcript', 'Any change in mature, spliced and processed, RNA that results from a change in the corresponding DNA sequence. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3000, 1, 0);
INSERT INTO chado.cvterm VALUES (2728, 23, 'sequence_variant_causing_no_change_in_transcript', 'No effect on the state of the RNA. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3003, 1, 0);
INSERT INTO chado.cvterm VALUES (2729, 23, 'sequence_variation_affecting_coding_sequence', 'Any of the amino acid coding triplets of a gene are affected by the DNA mutation. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3004, 1, 0);
INSERT INTO chado.cvterm VALUES (2730, 23, 'sequence_variant_causing_initiator_codon_change_in_transcript', 'The DNA mutation changes, usually destroys, the first coding triplet of a gene. Usually prevents translation although another initiator codon may be used. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3005, 1, 0);
INSERT INTO chado.cvterm VALUES (2731, 23, 'sequence_variant_causing_amino_acid_coding_codon_change_in_transcript', 'The DNA mutation affects the amino acid coding sequence of a gene; this region includes both the initiator and terminator codons. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3006, 1, 0);
INSERT INTO chado.cvterm VALUES (2732, 23, 'sequence_variant_causing_synonymous_codon_change_in_transcript', 'The changed codon has the same translation product as the original codon. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3007, 1, 0);
INSERT INTO chado.cvterm VALUES (2733, 23, 'sequence_variant_causing_non_synonymous_codon_change_in_transcript', 'A DNA point mutation that causes a substitution of an amino acid by an other. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3008, 1, 0);
INSERT INTO chado.cvterm VALUES (2734, 23, 'sequence_variant_causing_missense_codon_change_in_transcript', 'The nucleotide change in the codon leads to a new codon coding for a new amino acid. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3009, 1, 0);
INSERT INTO chado.cvterm VALUES (2735, 23, 'sequence_variant_causing_conservative_missense_codon_change_in_transcript', 'The amino acid change following from the codon change does not change the gross properties (size, charge, hydrophobicity) of the amino acid at that position. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3010, 1, 0);
INSERT INTO chado.cvterm VALUES (2736, 23, 'sequence_variant_causing_nonconservative_missense_codon_change_in_transcript', 'The amino acid change following from the codon change changes the gross properties (size, charge, hydrophobicity) of the amino acid in that position. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3011, 1, 0);
INSERT INTO chado.cvterm VALUES (2737, 23, 'sequence_variant_causing_nonsense_codon_change_in_transcript', 'The nucleotide change in the codon triplet creates a terminator codon. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3012, 1, 0);
INSERT INTO chado.cvterm VALUES (2738, 23, 'sequence_variant_causing_terminator_codon_change_in_transcript', 'The nucleotide change in the codon triplet changes the stop codon, causing an elongated transcript sequence. [SO:ke]', 3013, 1, 0);
INSERT INTO chado.cvterm VALUES (2739, 23, 'sequence_variation_affecting_reading_frame', 'An umbrella term for terms describing an effect of a sequence variation on the frame of translation. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3014, 1, 0);
INSERT INTO chado.cvterm VALUES (2740, 23, 'frameshift_sequence_variation', 'A mutation causing a disruption of the translational reading frame, because the number of nucleotides inserted or deleted is not a multiple of three. [SO:ke]', 3015, 1, 0);
INSERT INTO chado.cvterm VALUES (2741, 23, 'sequence_variant_causing_plus_1_frameshift_mutation', 'A mutation causing a disruption of the translational reading frame, due to the insertion of a nucleotide. [SO:ke]', 3016, 1, 0);
INSERT INTO chado.cvterm VALUES (2742, 23, 'sequence_variant_causing_minus_1_frameshift', 'A mutation causing a disruption of the translational reading frame, due to the deletion of a nucleotide. [SO:ke]', 3017, 1, 0);
INSERT INTO chado.cvterm VALUES (2743, 23, 'sequence_variant_causing_plus_2_frameshift', 'A mutation causing a disruption of the translational reading frame, due to the insertion of two nucleotides. [SO:ke]', 3018, 1, 0);
INSERT INTO chado.cvterm VALUES (2744, 23, 'sequence_variant_causing_minus_2_frameshift', 'A mutation causing a disruption of the translational reading frame, due to the deletion of two nucleotides. [SO:ke]', 3019, 1, 0);
INSERT INTO chado.cvterm VALUES (2745, 23, 'sequence_variant_affecting_transcript_processing', 'Sequence variant affects the way in which the primary transcriptional product is processed to form the mature transcript. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3020, 1, 0);
INSERT INTO chado.cvterm VALUES (2746, 23, 'sequence_variant_affecting_splicing', 'A sequence_variant_effect where the way in which the primary transcriptional product is processed to form the mature transcript, specifically by the removal (splicing) of intron sequences is changed. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3021, 1, 0);
INSERT INTO chado.cvterm VALUES (2747, 23, 'sequence_variant_affecting_splice_donor', 'A sequence_variant_effect that changes the splice donor sequence. [SO:ke]', 3022, 1, 0);
INSERT INTO chado.cvterm VALUES (2748, 23, 'sequence_variant_affecting_splice_acceptor', 'A sequence_variant_effect that changes the splice acceptor sequence. [SO:ke]', 3023, 1, 0);
INSERT INTO chado.cvterm VALUES (2749, 23, 'sequence_variant_causing_cryptic_splice_activation', 'A sequence variant causing a new (functional) splice site. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3024, 1, 0);
INSERT INTO chado.cvterm VALUES (2750, 23, 'sequence_variant_affecting_editing', 'Sequence variant affects the editing of the transcript. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3025, 1, 0);
INSERT INTO chado.cvterm VALUES (2795, 23, 'sequence_variant_causing_gain_of_function_of_polypeptide', '', 3074, 1, 0);
INSERT INTO chado.cvterm VALUES (2751, 23, 'sequence_variant_affecting_transcription', 'Mutation affects the process of transcription, its initiation, progression or termination. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3026, 1, 0);
INSERT INTO chado.cvterm VALUES (2752, 23, 'sequence_variant_decreasing_rate_of_transcription', 'A sequence variation that decreases the rate a which transcription of the sequence occurs. [SO:ke]', 3027, 1, 0);
INSERT INTO chado.cvterm VALUES (2753, 23, 'sequence_variation_affecting_transcript_sequence', '', 3028, 1, 0);
INSERT INTO chado.cvterm VALUES (2754, 23, 'sequence_variant_increasing_rate_of_transcription', '', 3029, 1, 0);
INSERT INTO chado.cvterm VALUES (2755, 23, 'sequence_variant_affecting_rate_of_transcription', 'A mutation that alters the rate a which transcription of the sequence occurs. [SO:ke]', 3030, 1, 0);
INSERT INTO chado.cvterm VALUES (2756, 23, 'sequence variant_affecting_transcript_stability', 'Sequence variant affects the stability of the transcript. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3031, 1, 0);
INSERT INTO chado.cvterm VALUES (2757, 23, 'sequence_variant_increasing_transcript_stability', 'Sequence variant increases the stability (half-life) of the transcript. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3032, 1, 0);
INSERT INTO chado.cvterm VALUES (2758, 23, 'sequence_variant_decreasing_transcript_stability', 'Sequence variant decreases the stability (half-life) of the transcript. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3033, 1, 0);
INSERT INTO chado.cvterm VALUES (2759, 23, 'sequence_variation_affecting_level_of_transcript', 'A sequence variation that causes a change in the level of mature, spliced and processed RNA, resulting from a change in the corresponding DNA sequence. [SO:ke]', 3034, 1, 0);
INSERT INTO chado.cvterm VALUES (2760, 23, 'sequence_variation_decreasing_level_of_transcript', 'A sequence variation that causes a decrease in the level of mature, spliced and processed RNA, resulting from a change in the corresponding DNA sequence. [SO:ke]', 3035, 1, 0);
INSERT INTO chado.cvterm VALUES (2761, 23, 'sequence_variation_increasing_level_of_transcript', 'A sequence_variation that causes an increase in the level of mature, spliced and processed RNA, resulting from a change in the corresponding DNA sequence. [SO:ke]', 3036, 1, 0);
INSERT INTO chado.cvterm VALUES (2762, 23, 'sequence_variant_affecting_translational_product', 'A sequence variant causing a change in primary translation product of a transcript. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3037, 1, 0);
INSERT INTO chado.cvterm VALUES (2763, 23, 'sequence_variant_causing_no_change_of_translational_product', 'The sequence variant at RNA level does not lead to any change in polypeptide. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3040, 1, 0);
INSERT INTO chado.cvterm VALUES (2764, 23, 'sequence_variant_causing_complex_change_of_translational_product', 'Any sequence variant effect that is known at nucleotide level but cannot be explained by using other key terms. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3041, 1, 0);
INSERT INTO chado.cvterm VALUES (2765, 23, 'sequence_variant_causing_amino_acid_substitution', 'The replacement of a single amino acid by another. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3042, 1, 0);
INSERT INTO chado.cvterm VALUES (2766, 23, 'sequence_variant_causing_conservative_amino_acid_substitution', '', 3043, 1, 0);
INSERT INTO chado.cvterm VALUES (2767, 23, 'sequence_variant_causing_nonconservative_amino_acid_substitution', '', 3044, 1, 0);
INSERT INTO chado.cvterm VALUES (2768, 23, 'sequence_variant_causing_amino_acid_insertion', 'The insertion of one or more amino acids from the polypeptide, without affecting the surrounding sequence. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3045, 1, 0);
INSERT INTO chado.cvterm VALUES (2769, 23, 'sequence_variant_causing_amino_acid_deletion', 'The deletion of one or more amino acids from the polypeptide, without affecting the surrounding sequence. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3046, 1, 0);
INSERT INTO chado.cvterm VALUES (2770, 23, 'sequence_variant_causing_polypeptide_truncation', 'The translational product is truncated at its C-terminus, usually a result of a nonsense codon change in transcript (SO:1000062). [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3047, 1, 0);
INSERT INTO chado.cvterm VALUES (2771, 23, 'sequence_variant_causing_polypeptide_elongation', 'The extension of the translational product at either (or both) the N-terminus and/or the C-terminus. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3048, 1, 0);
INSERT INTO chado.cvterm VALUES (2772, 23, 'mutation_causing_polypeptide_N_terminal_elongation', '. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3049, 1, 0);
INSERT INTO chado.cvterm VALUES (2773, 23, 'mutation_causing_polypeptide_C_terminal_elongation', '. [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3050, 1, 0);
INSERT INTO chado.cvterm VALUES (2774, 23, 'sequence_variant_affecting_level_of_translational_product', '', 3051, 1, 0);
INSERT INTO chado.cvterm VALUES (2775, 23, 'sequence_variant_decreasing_level_of_translation_product', '', 3052, 1, 0);
INSERT INTO chado.cvterm VALUES (2776, 23, 'sequence_variant_increasing_level_of_translation_product', '', 3053, 1, 0);
INSERT INTO chado.cvterm VALUES (2777, 23, 'sequence_variant_affecting_polypeptide_amino_acid_sequence', '', 3054, 1, 0);
INSERT INTO chado.cvterm VALUES (2778, 23, 'mutation_causing_inframe_polypeptide_N_terminal_elongation', '', 3055, 1, 0);
INSERT INTO chado.cvterm VALUES (2779, 23, 'mutation_causing_out_of_frame_polypeptide_N_terminal_elongation', '', 3056, 1, 0);
INSERT INTO chado.cvterm VALUES (2780, 23, 'mutaton_causing_inframe_polypeptide_C_terminal_elongation', '', 3057, 1, 0);
INSERT INTO chado.cvterm VALUES (2781, 23, 'mutation_causing_out_of_frame_polypeptide_C_terminal_elongation', '', 3058, 1, 0);
INSERT INTO chado.cvterm VALUES (2782, 23, 'frame_restoring_sequence_variant', 'A mutation that reverts the sequence of a previous frameshift mutation back to the initial frame. [SO:ke]', 3059, 1, 0);
INSERT INTO chado.cvterm VALUES (2783, 23, 'sequence_variant_affecting_3D_structure_of_polypeptide', 'A mutation that changes the amino acid sequence of the peptide in such a way that it changes the 3D structure of the molecule. [SO:ke]', 3060, 1, 0);
INSERT INTO chado.cvterm VALUES (2784, 23, 'sequence_variant_causing_no_3D_structural_change', '', 3063, 1, 0);
INSERT INTO chado.cvterm VALUES (2785, 23, 'sequence_variant_causing_complex_3D_structural_change', '', 3064, 1, 0);
INSERT INTO chado.cvterm VALUES (2786, 23, 'sequence_variant_causing_conformational_change', '', 3065, 1, 0);
INSERT INTO chado.cvterm VALUES (2787, 23, 'sequence_variant_affecting_polypeptide_function', '', 3066, 1, 0);
INSERT INTO chado.cvterm VALUES (2788, 23, 'sequence_variant_causing_loss_of_function_of_polypeptide', '', 3067, 1, 0);
INSERT INTO chado.cvterm VALUES (2789, 23, 'sequence_variant_causing_inactive_ligand_binding_site', '', 3068, 1, 0);
INSERT INTO chado.cvterm VALUES (2790, 23, 'sequence_variant_causing_inactive_catalytic_site', '', 3069, 1, 0);
INSERT INTO chado.cvterm VALUES (2791, 23, 'sequence_variant_causing_polypeptide_localization_change', '', 3070, 1, 0);
INSERT INTO chado.cvterm VALUES (2792, 23, 'sequence_variant_causing_polypeptide_post_translational_processing_change', '', 3071, 1, 0);
INSERT INTO chado.cvterm VALUES (2793, 23, 'polypeptide_post_translational_processing_affected', '', 3072, 1, 0);
INSERT INTO chado.cvterm VALUES (2794, 23, 'sequence_variant_causing_partial_loss_of_function_of_polypeptide', '', 3073, 1, 0);
INSERT INTO chado.cvterm VALUES (2796, 23, 'sequence_variant_affecting_transcript_secondary_structure', 'A sequence variant that affects the secondary structure (folding) of the RNA transcript molecule. [SO:ke]', 3075, 1, 0);
INSERT INTO chado.cvterm VALUES (2797, 23, 'sequence_variant_causing_compensatory_transcript_secondary_structure_mutation', '', 3076, 1, 0);
INSERT INTO chado.cvterm VALUES (2798, 23, 'sequence_variant_effect', 'The effect of a change in nucleotide sequence. [SO:ke]', 3077, 1, 0);
INSERT INTO chado.cvterm VALUES (2799, 23, 'sequence_variant_causing_polypeptide_fusion', '', 3078, 1, 0);
INSERT INTO chado.cvterm VALUES (2800, 23, 'autosynaptic_chromosome', 'An autosynaptic chromosome is the aneuploid product of recombination between a pericentric inversion and a cytologically wild-type chromosome. [PMID:6804304]', 3079, 0, 0);
INSERT INTO chado.cvterm VALUES (2801, 23, 'homo_compound_chromosome', 'A compound chromosome whereby two copies of the same chromosomal arm attached to a common centromere. The chromosome is diploid for the arm involved. [SO:ke]', 3080, 0, 0);
INSERT INTO chado.cvterm VALUES (2802, 23, 'hetero_compound_chromosome', 'A compound chromosome whereby two arms from different chromosomes are connected through the centromere of one of them. [FB:reference_manual, SO:ke]', 3081, 0, 0);
INSERT INTO chado.cvterm VALUES (2803, 23, 'chromosome_fission', 'A chromosome that occurred by the division of a larger chromosome. [SO:ke]', 3082, 0, 0);
INSERT INTO chado.cvterm VALUES (2804, 23, 'dextrosynaptic_chromosome', 'An autosynaptic chromosome carrying the two right (D = dextro) telomeres. [FB:manual]', 3083, 0, 0);
INSERT INTO chado.cvterm VALUES (2805, 23, 'laevosynaptic_chromosome', 'LS is an autosynaptic chromosome carrying the two left (L = levo) telomeres. [FB:manual]', 3084, 0, 0);
INSERT INTO chado.cvterm VALUES (2806, 23, 'free_duplication', 'A chromosome structure variation whereby the duplicated sequences are carried as a free centric element. [FB:reference_manual]', 3085, 0, 0);
INSERT INTO chado.cvterm VALUES (2807, 23, 'free_ring_duplication', 'A ring chromosome which is a copy of another chromosome. [SO:ke]', 3086, 0, 0);
INSERT INTO chado.cvterm VALUES (2808, 23, 'deficient_translocation', 'A chromosomal deletion whereby a translocation occurs in which one of the four broken ends loses a segment before re-joining. [FB:reference_manual]', 3087, 0, 0);
INSERT INTO chado.cvterm VALUES (2809, 23, 'inversion_cum_translocation', 'A chromosomal translocation whereby the first two breaks are in the same chromosome, and the region between them is rejoined in inverted order to the other side of the first break, such that both sides of break one are present on the same chromosome. The remaining free ends are joined as a translocation with those resulting from the third break. [FB:reference_manual]', 3088, 0, 0);
INSERT INTO chado.cvterm VALUES (2810, 23, 'bipartite_duplication', 'An interchromosomal mutation whereby the (large) region between the first two breaks listed is lost, and the two flanking segments (one of them centric) are joined as a translocation to the free ends resulting from the third break. [FB:reference_manual]', 3089, 0, 0);
INSERT INTO chado.cvterm VALUES (2811, 23, 'cyclic_translocation', 'A chromosomal translocation whereby three breaks occurred in three different chromosomes. The centric segment resulting from the first break listed is joined to the acentric segment resulting from the second, rather than the third. [FB:reference_manual]', 3090, 0, 0);
INSERT INTO chado.cvterm VALUES (2812, 23, 'bipartite_inversion', 'A chromosomal inversion caused by three breaks in the same chromosome; both central segments are inverted in place (i.e., they are not transposed). [FB:reference_manual]', 3091, 0, 0);
INSERT INTO chado.cvterm VALUES (2813, 23, 'uninverted_insertional_duplication', 'An insertional duplication where a copy of the segment between the first two breaks listed is inserted at the third break; the insertion is in cytologically the same orientation as its flanking segments. [FB:reference_manual]', 3092, 0, 0);
INSERT INTO chado.cvterm VALUES (2814, 23, 'insertional_duplication', 'A chromosome duplication involving the insertion of a duplicated region (as opposed to a free duplication). [SO:ke]', 3093, 0, 0);
INSERT INTO chado.cvterm VALUES (2815, 23, 'inverted_insertional_duplication', 'An insertional duplication where a copy of the segment between the first two breaks listed is inserted at the third break; the insertion is in cytologically inverted orientation with respect to its flanking segments. [FB:reference_manual]', 3094, 0, 0);
INSERT INTO chado.cvterm VALUES (2816, 23, 'inverted_interchromosomal_transposition', 'An interchromosomal transposition whereby a copy of the segment between the first two breaks listed is inserted at the third break; the insertion is in cytologically inverted orientation with respect to its flanking segment. [FB:reference_manual]', 3095, 0, 0);
INSERT INTO chado.cvterm VALUES (2817, 23, 'uninverted_interchromosomal_transposition', 'An interchromosomal transition where the segment between the first two breaks listed is removed and inserted at the third break; the insertion is in cytologically the same orientation as its flanking segments. [FB:reference_manual]', 3096, 0, 0);
INSERT INTO chado.cvterm VALUES (2818, 23, 'inverted_intrachromosomal_transposition', 'An intrachromosomal transposition whereby the segment between the first two breaks listed is removed and inserted at the third break; the insertion is in cytologically inverted orientation with respect to its flanking segments. [FB:reference_manual]', 3097, 0, 0);
INSERT INTO chado.cvterm VALUES (2819, 23, 'uninverted_intrachromosomal_transposition', 'An intrachromosomal transposition whereby the segment between the first two breaks listed is removed and inserted at the third break; the insertion is in cytologically the same orientation as its flanking segments. [FB:reference_manual]', 3098, 0, 0);
INSERT INTO chado.cvterm VALUES (2820, 23, 'unoriented_insertional_duplication', 'An insertional duplication where a copy of the segment between the first two breaks listed is inserted at the third break; the orientation of the insertion with respect to its flanking segments is not recorded. [FB:reference_manual]', 3099, 0, 0);
INSERT INTO chado.cvterm VALUES (2821, 23, 'unoriented_interchromosomal_transposition', 'An interchromosomal transposition whereby a copy of the segment between the first two breaks listed is inserted at the third break; the orientation of the insertion with respect to its flanking segments is not recorded. [FB:reference_manual]', 3100, 0, 0);
INSERT INTO chado.cvterm VALUES (2822, 23, 'unoriented_intrachromosomal_transposition', 'An intrachromosomal transposition whereby the segment between the first two breaks listed is removed and inserted at the third break; the orientation of the insertion with respect to its flanking segments is not recorded. [FB:reference_manual]', 3101, 0, 0);
INSERT INTO chado.cvterm VALUES (2823, 23, 'uncharacterized_chromosomal_mutation', 'A chromosome structure variant that has not been characterized. []', 3102, 0, 0);
INSERT INTO chado.cvterm VALUES (2824, 23, 'deficient_inversion', 'A chromosomal deletion whereby three breaks occur in the same chromosome; one central region is lost, and the other is inverted. [FB:reference_manual, SO:ke]', 3103, 0, 0);
INSERT INTO chado.cvterm VALUES (2825, 23, 'partially_characterized_chromosomal_mutation', 'A chromosome structure variant that has not been characterized fully. []', 3104, 0, 0);
INSERT INTO chado.cvterm VALUES (2826, 23, 'sequence_variant_affecting_gene_structure', 'A sequence_variant_effect that changes the gene structure. [SO:ke]', 3105, 1, 0);
INSERT INTO chado.cvterm VALUES (2827, 23, 'sequence_variant_causing_gene_fusion', 'A sequence_variant_effect that changes the gene structure by causing a fusion to another gene. [SO:ke]', 3106, 1, 0);
INSERT INTO chado.cvterm VALUES (2828, 23, 'sequence_variant_causes_exon_loss', 'A sequence variant affecting splicing and causes an exon loss. [SO:ke]', 3107, 1, 0);
INSERT INTO chado.cvterm VALUES (2829, 23, 'sequence_variant_causes_intron_gain', 'A sequence variant effect, causing an intron to be gained by the processed transcript; usually a result of a donor acceptor mutation (SO:1000072). [EBI:www.ebi.ac.uk/mutations/recommendations/mutevent.html]', 3108, 1, 0);
INSERT INTO chado.cvterm VALUES (2830, 23, 'sequence_variant_causing_cryptic_splice_donor_activation', '', 3109, 1, 0);
INSERT INTO chado.cvterm VALUES (2831, 23, 'sequence_variant_causing_cryptic_splice_acceptor_activation', '', 3110, 1, 0);
INSERT INTO chado.cvterm VALUES (2832, 23, 'alternatively_spliced_transcript', 'A transcript that is alternatively spliced. [SO:xp]', 3111, 0, 0);
INSERT INTO chado.cvterm VALUES (2833, 23, 'encodes_1_polypeptide', 'A gene that is alternately spliced, but encodes only one polypeptide. [SO:ke]', 3112, 0, 0);
INSERT INTO chado.cvterm VALUES (2834, 23, 'encodes_greater_than_1_polypeptide', 'A gene that is alternately spliced, and encodes more than one polypeptide. [SO:ke]', 3113, 0, 0);
INSERT INTO chado.cvterm VALUES (2835, 23, 'encodes_different_polypeptides_different_stop', 'A gene that is alternately spliced, and encodes more than one polypeptide, that have overlapping peptide sequences, but use different stop codons. [SO:ke]', 3114, 0, 0);
INSERT INTO chado.cvterm VALUES (2836, 23, 'encodes_overlapping_peptides', 'A gene that is alternately spliced, and encodes more than one polypeptide, that have overlapping peptide sequences. [SO:ke]', 3115, 0, 0);
INSERT INTO chado.cvterm VALUES (2837, 23, 'encodes_overlapping_peptides_different_start', 'A gene that is alternately spliced, and encodes more than one polypeptide, that have overlapping peptide sequences, but use different start codons. [SO:ke]', 3116, 0, 0);
INSERT INTO chado.cvterm VALUES (2838, 23, 'encodes_disjoint_polypeptides', 'A gene that is alternately spliced, and encodes more than one polypeptide, that do not have overlapping peptide sequences. [SO:ke]', 3117, 0, 0);
INSERT INTO chado.cvterm VALUES (2839, 23, 'encodes_overlapping_polypeptides_different_start_and_stop', 'A gene that is alternately spliced, and encodes more than one polypeptide, that have overlapping peptide sequences, but use different start and stop codons. [SO:ke]', 3118, 0, 0);
INSERT INTO chado.cvterm VALUES (2840, 23, 'alternatively_spliced_gene_encoding_greater_than_1_polypeptide_coding_regions_overlapping', '', 3119, 1, 0);
INSERT INTO chado.cvterm VALUES (2841, 23, 'cryptogene', 'A maxicircle gene so extensively edited that it cannot be matched to its edited mRNA sequence. [SO:ma]', 3120, 0, 0);
INSERT INTO chado.cvterm VALUES (2842, 23, 'member_of_regulon', 'A gene that is a member of a group of genes that are either regulated or transcribed together. []', 3121, 0, 0);
INSERT INTO chado.cvterm VALUES (2843, 23, 'alternatively_spliced_transcript_encoding_greater_than_1_polypeptide_different_start_codon_different_stop_codon_coding_regions_non_overlapping', '', 3122, 1, 0);
INSERT INTO chado.cvterm VALUES (2844, 23, 'CDS_independently_known', 'A CDS with the evidence status of being independently known. [SO:xp]', 3123, 0, 0);
INSERT INTO chado.cvterm VALUES (2845, 23, 'orphan_CDS', 'A CDS whose predicted amino acid sequence is unsupported by any experimental evidence or by any match with any other known sequence. [SO:ma]', 3124, 0, 0);
INSERT INTO chado.cvterm VALUES (2846, 23, 'CDS_predicted', 'A CDS that is predicted. [SO:ke]', 3125, 0, 0);
INSERT INTO chado.cvterm VALUES (2847, 23, 'CDS_supported_by_domain_match_data', 'A CDS that is supported by domain similarity. [SO:xp]', 3126, 0, 0);
INSERT INTO chado.cvterm VALUES (2848, 23, 'status_of_coding_sequence', '', 3127, 1, 0);
INSERT INTO chado.cvterm VALUES (2849, 23, 'CDS_supported_by_EST_or_cDNA_data', 'A CDS that is supported by similarity to EST or cDNA data. [SO:xp]', 3128, 0, 0);
INSERT INTO chado.cvterm VALUES (2850, 23, 'internal_Shine_Dalgarno_sequence', 'A Shine-Dalgarno sequence that stimulates recoding through interactions with the anti-Shine-Dalgarno in the RNA of small ribosomal subunits of translating ribosomes. The signal is only operative in Bacteria. [PMID:12519954, SO:ke]', 3129, 0, 0);
INSERT INTO chado.cvterm VALUES (2851, 23, 'recoded_mRNA', 'The sequence of a mature mRNA transcript, modified before translation or during translation, usually by special cis-acting signals. [http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=8811194&dopt=Abstract]', 3130, 0, 0);
INSERT INTO chado.cvterm VALUES (2852, 23, 'minus_1_translationally_frameshifted', 'An attribute describing a translational frameshift of -1. [SO:ke]', 3131, 0, 0);
INSERT INTO chado.cvterm VALUES (2853, 23, 'plus_1_translationally_frameshifted', 'An attribute describing a translational frameshift of +1. [SO:ke]', 3132, 0, 0);
INSERT INTO chado.cvterm VALUES (2854, 23, 'mRNA_recoded_by_translational_bypass', 'A recoded_mRNA where translation was suspended at a particular codon and resumed at a particular non-overlapping downstream codon. [http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=8811194&dopt=Abstract]', 3133, 0, 0);
INSERT INTO chado.cvterm VALUES (2855, 23, 'mRNA_recoded_by_codon_redefinition', 'A recoded_mRNA that was modified by an alteration of codon meaning. [SO:ma]', 3134, 0, 0);
INSERT INTO chado.cvterm VALUES (2856, 23, 'stop_codon_redefinition_as_selenocysteine', '', 3135, 1, 0);
INSERT INTO chado.cvterm VALUES (2857, 23, 'stop_codon_readthrough', '', 3136, 1, 0);
INSERT INTO chado.cvterm VALUES (2858, 23, 'four_bp_start_codon', 'A non-canonical start codon with 4 base pairs. [SO:ke]', 3137, 0, 0);
INSERT INTO chado.cvterm VALUES (2859, 23, 'stop_codon_redefinition_as_pyrrolysine', '', 3138, 1, 0);
INSERT INTO chado.cvterm VALUES (2860, 23, 'archaeal_intron', 'An intron characteristic of Archaeal tRNA and rRNA genes, where intron transcript generates a bulge-helix-bulge motif that is recognised by a splicing endoribonuclease. [PMID:9301331, SO:ma]', 3139, 0, 0);
INSERT INTO chado.cvterm VALUES (2861, 23, 'tRNA_intron', 'An intron found in tRNA that is spliced via endonucleolytic cleavage and ligation rather than transesterification. [SO:ke]', 3140, 0, 0);
INSERT INTO chado.cvterm VALUES (2862, 23, 'CTG_start_codon', 'A non-canonical start codon of sequence CTG. [SO:ke]', 3141, 0, 0);
INSERT INTO chado.cvterm VALUES (2863, 23, 'SECIS_element', 'The incorporation of selenocysteine into a protein sequence is directed by an in-frame UGA codon (usually a stop codon) within the coding region of the mRNA. Selenoprotein mRNAs contain a conserved secondary structure in the 3'' UTR that is required for the distinction of UGA stop from UGA selenocysteine. The selenocysteine insertion sequence (SECIS) is around 60 nt in length and adopts a hairpin structure which is sufficiently well-defined and conserved to act as a computational screen for selenoprotein genes. [http://www.sanger.ac.uk/cgi-bin/Rfam/getacc?RF00031]', 3142, 0, 0);
INSERT INTO chado.cvterm VALUES (2864, 23, 'retron', 'Sequence coding for a short, single-stranded, DNA sequence via a retrotransposed RNA intermediate; characteristic of some microbial genomes. [SO:ma]', 3143, 0, 0);
INSERT INTO chado.cvterm VALUES (2865, 23, 'three_prime_recoding_site', 'The recoding stimulatory signal located downstream of the recoding site. [SO:ke]', 3144, 0, 0);
INSERT INTO chado.cvterm VALUES (2866, 23, 'three_prime_stem_loop_structure', 'A recoding stimulatory region, the stem-loop secondary structural element is downstream of the redefined region. [PMID:12519954, SO:ke]', 3145, 0, 0);
INSERT INTO chado.cvterm VALUES (2867, 23, 'five_prime_recoding_site', 'The recoding stimulatory signal located upstream of the recoding site. [SO:ke]', 3146, 0, 0);
INSERT INTO chado.cvterm VALUES (2868, 23, 'flanking_three_prime_quadruplet_recoding_signal', 'Four base pair sequence immediately downstream of the redefined region. The redefined region is a frameshift site. The quadruplet is 2 overlapping codons. [PMID:12519954, SO:ke]', 3147, 0, 0);
INSERT INTO chado.cvterm VALUES (2869, 23, 'UAG_stop_codon_signal', 'A stop codon signal for a UAG stop codon redefinition. [SO:ke]', 3148, 0, 0);
INSERT INTO chado.cvterm VALUES (2870, 23, 'stop_codon_signal', 'A recoding stimulatory signal that is a stop codon and has effect on efficiency of recoding. [PMID:12519954, SO:ke]', 3149, 0, 0);
INSERT INTO chado.cvterm VALUES (2871, 23, 'UAA_stop_codon_signal', 'A stop codon signal for a UAA stop codon redefinition. [SO:ke]', 3150, 0, 0);
INSERT INTO chado.cvterm VALUES (2872, 23, 'UGA_stop_codon_signal', 'A stop codon signal for a UGA stop codon redefinition. [SO:ke]', 3151, 0, 0);
INSERT INTO chado.cvterm VALUES (2873, 23, 'three_prime_repeat_recoding_signal', 'A recoding stimulatory signal, downstream sequence important for recoding that contains repetitive elements. [PMID:12519954, SO:ke]', 3152, 0, 0);
INSERT INTO chado.cvterm VALUES (2874, 23, 'distant_three_prime_recoding_signal', 'A recoding signal that is found many hundreds of nucleotides 3'' of a redefined stop codon. [http://www.ncbi.nlm.nih.gov\:80/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=8709208&dopt=Abstract]', 3153, 0, 0);
INSERT INTO chado.cvterm VALUES (2875, 23, 'databank_entry', 'The sequence referred to by an entry in a databank such as GenBank or SwissProt. [SO:ke]', 3154, 0, 0);
INSERT INTO chado.cvterm VALUES (2876, 24, 'has_rank', '', 3155, 0, 1);
INSERT INTO chado.cvterm VALUES (2877, 24, 'is_a', '', 3156, 0, 1);
INSERT INTO chado.cvterm VALUES (2878, 24, 'taxonomic_rank', 'A level of depth of a taxon in a taxonomic hierarchy. [TAXRANK:curator]', 3157, 0, 0);
INSERT INTO chado.cvterm VALUES (2879, 24, 'phylum', '', 3158, 0, 0);
INSERT INTO chado.cvterm VALUES (2880, 24, 'class', '', 3160, 0, 0);
INSERT INTO chado.cvterm VALUES (2881, 24, 'order', '', 3162, 0, 0);
INSERT INTO chado.cvterm VALUES (2882, 24, 'family', '', 3164, 0, 0);
INSERT INTO chado.cvterm VALUES (2883, 24, 'subclass', '', 3168, 0, 0);
INSERT INTO chado.cvterm VALUES (2884, 24, 'subphylum', '', 3170, 0, 0);
INSERT INTO chado.cvterm VALUES (2885, 24, 'subgenus', '', 3172, 0, 0);
INSERT INTO chado.cvterm VALUES (2886, 24, 'species_group', '', 3174, 0, 0);
INSERT INTO chado.cvterm VALUES (2887, 24, 'species_subgroup', '', 3176, 0, 0);
INSERT INTO chado.cvterm VALUES (2888, 24, 'species_complex', '', 3178, 0, 0);
INSERT INTO chado.cvterm VALUES (2889, 24, 'infraorder', '', 3179, 0, 0);
INSERT INTO chado.cvterm VALUES (2890, 24, 'suborder', '', 3181, 0, 0);
INSERT INTO chado.cvterm VALUES (2891, 24, 'superclass', '', 3183, 0, 0);
INSERT INTO chado.cvterm VALUES (2892, 24, 'varietas', '', 3185, 0, 0);
INSERT INTO chado.cvterm VALUES (2893, 24, 'kingdom', '', 3187, 0, 0);
INSERT INTO chado.cvterm VALUES (2894, 24, 'superfamily', '', 3189, 0, 0);
INSERT INTO chado.cvterm VALUES (2895, 24, 'infraclass', '', 3191, 0, 0);
INSERT INTO chado.cvterm VALUES (2896, 24, 'superorder', '', 3193, 0, 0);
INSERT INTO chado.cvterm VALUES (2897, 24, 'parvorder', '', 3195, 0, 0);
INSERT INTO chado.cvterm VALUES (2898, 24, 'superkingdom', '', 3197, 0, 0);
INSERT INTO chado.cvterm VALUES (2899, 24, 'subspecies', '', 3199, 0, 0);
INSERT INTO chado.cvterm VALUES (2900, 24, 'subfamily', '', 3201, 0, 0);
INSERT INTO chado.cvterm VALUES (2901, 24, 'tribe', '', 3203, 0, 0);
INSERT INTO chado.cvterm VALUES (2902, 24, 'forma', '', 3205, 0, 0);
INSERT INTO chado.cvterm VALUES (2903, 24, 'superphylum', '', 3207, 0, 0);
INSERT INTO chado.cvterm VALUES (2904, 24, 'subtribe', '', 3209, 0, 0);
INSERT INTO chado.cvterm VALUES (2905, 24, 'subkingdom', '', 3211, 0, 0);
INSERT INTO chado.cvterm VALUES (2906, 24, 'section', '', 3213, 0, 0);
INSERT INTO chado.cvterm VALUES (2907, 24, 'series', '', 3214, 0, 0);
INSERT INTO chado.cvterm VALUES (2908, 24, 'bio-variety', '', 3215, 0, 0);
INSERT INTO chado.cvterm VALUES (2909, 24, 'candidate', '', 3216, 0, 0);
INSERT INTO chado.cvterm VALUES (2910, 24, 'cultivar', '', 3217, 0, 0);
INSERT INTO chado.cvterm VALUES (2911, 24, 'cultivar-group', '', 3218, 0, 0);
INSERT INTO chado.cvterm VALUES (2912, 24, 'denominationclass', '', 3219, 0, 0);
INSERT INTO chado.cvterm VALUES (2913, 24, 'domain', '', 3220, 0, 0);
INSERT INTO chado.cvterm VALUES (2914, 24, 'graft-chimaera', '', 3221, 0, 0);
INSERT INTO chado.cvterm VALUES (2915, 24, 'grex', '', 3222, 0, 0);
INSERT INTO chado.cvterm VALUES (2916, 24, 'infraphylum', '', 3223, 0, 0);
INSERT INTO chado.cvterm VALUES (2917, 24, 'infrafamily', '', 3224, 0, 0);
INSERT INTO chado.cvterm VALUES (2918, 24, 'infragenerictaxon', '', 3225, 0, 0);
INSERT INTO chado.cvterm VALUES (2919, 24, 'infragenus', '', 3226, 0, 0);
INSERT INTO chado.cvterm VALUES (2920, 24, 'infrakingdom', '', 3227, 0, 0);
INSERT INTO chado.cvterm VALUES (2921, 24, 'infraspecificTaxon', '', 3228, 0, 0);
INSERT INTO chado.cvterm VALUES (2922, 24, 'infratribe', '', 3229, 0, 0);
INSERT INTO chado.cvterm VALUES (2923, 24, 'patho-variety', '', 3230, 0, 0);
INSERT INTO chado.cvterm VALUES (2924, 24, 'specialform', '', 3231, 0, 0);
INSERT INTO chado.cvterm VALUES (2925, 24, 'speciesaggregate', '', 3232, 0, 0);
INSERT INTO chado.cvterm VALUES (2926, 24, 'subvariety', '', 3233, 0, 0);
INSERT INTO chado.cvterm VALUES (2927, 24, 'subsubvariety', '', 3234, 0, 0);
INSERT INTO chado.cvterm VALUES (2928, 24, 'subsection', '', 3235, 0, 0);
INSERT INTO chado.cvterm VALUES (2929, 24, 'subseries', '', 3236, 0, 0);
INSERT INTO chado.cvterm VALUES (2930, 24, 'subspecificaggregate', '', 3237, 0, 0);
INSERT INTO chado.cvterm VALUES (2931, 24, 'subsubform', '', 3238, 0, 0);
INSERT INTO chado.cvterm VALUES (2932, 24, 'supertribe', '', 3239, 0, 0);
INSERT INTO chado.cvterm VALUES (2933, 24, 'supragenerictaxon', '', 3240, 0, 0);
INSERT INTO chado.cvterm VALUES (2934, 24, 'subform', '', 3241, 0, 0);
INSERT INTO chado.cvterm VALUES (2935, 24, 'no_rank', 'A token asserting that the taxon was not assigned a rank. [TAXRANK:curator]', 3242, 0, 0);
INSERT INTO chado.cvterm VALUES (229, 32, 'related', '', 229, 0, 0);
INSERT INTO chado.cvterm VALUES (2936, 25, 'is a', '', 3243, 0, 1);
INSERT INTO chado.cvterm VALUES (2937, 25, 'part of', '', 3244, 0, 1);
INSERT INTO chado.cvterm VALUES (2938, 25, 'Contact Type', '', 3245, 0, 0);
INSERT INTO chado.cvterm VALUES (2939, 25, 'Collective', 'Used when a contact is a collective of individuals rather than a person.', 3246, 0, 0);
INSERT INTO chado.cvterm VALUES (2940, 25, 'Person', '', 3247, 0, 0);
INSERT INTO chado.cvterm VALUES (2941, 25, 'Organization', '', 3248, 0, 0);
INSERT INTO chado.cvterm VALUES (2942, 25, 'University', '', 3249, 0, 0);
INSERT INTO chado.cvterm VALUES (2943, 25, 'Lab', '', 3250, 0, 0);
INSERT INTO chado.cvterm VALUES (2944, 25, 'Institute', '', 3251, 0, 0);
INSERT INTO chado.cvterm VALUES (2945, 25, 'Research Group', '', 3252, 0, 0);
INSERT INTO chado.cvterm VALUES (2946, 25, 'Department', '', 3253, 0, 0);
INSERT INTO chado.cvterm VALUES (2947, 25, 'First Initials', 'The first initials for the author including the initial for the first name and any middle names (not the initial for the last name).', 3254, 0, 0);
INSERT INTO chado.cvterm VALUES (2948, 25, 'Surname', '', 3255, 0, 0);
INSERT INTO chado.cvterm VALUES (2949, 25, 'Given Name', '', 3256, 0, 0);
INSERT INTO chado.cvterm VALUES (2950, 25, 'Middle Names', 'One or more middle names for this person.', 3257, 0, 0);
INSERT INTO chado.cvterm VALUES (2951, 25, 'Middle Initials', 'The middle initials for this person excluding the initial for the given name and the surname.', 3258, 0, 0);
INSERT INTO chado.cvterm VALUES (2952, 25, 'Affiliation', '', 3259, 0, 0);
INSERT INTO chado.cvterm VALUES (226, 32, 'exact', '', 226, 0, 0);
INSERT INTO chado.cvterm VALUES (2968, 26, 'Publication Dbxref', 'A unique identifer for the publication in a remote database.  The format is a database abbreviation and a unique accession separated by a colon.  (e.g. PMID:23493063)', 3275, 0, 0);
INSERT INTO chado.cvterm VALUES (2969, 26, 'Publication Details', '', 3276, 0, 0);
INSERT INTO chado.cvterm VALUES (194, 26, 'Publication', '', 194, 0, 0);
INSERT INTO chado.cvterm VALUES (195, 26, 'Citation', 'Biblographic reference for the publication.', 195, 0, 0);
INSERT INTO chado.cvterm VALUES (2970, 26, 'Book', '', 3277, 0, 0);
INSERT INTO chado.cvterm VALUES (2971, 26, 'Publication Accession', 'The accession number for a publication in a remote database.  This term is obsolete in favor of the ''Publication Dbxref'' term.', 3278, 1, 0);
INSERT INTO chado.cvterm VALUES (2972, 26, 'Collective', 'Used when an author is a collective of individuals rather than a person.', 3279, 0, 0);
INSERT INTO chado.cvterm VALUES (2973, 26, 'Author', '', 3280, 0, 0);
INSERT INTO chado.cvterm VALUES (2974, 26, 'Master''s Thesis', '', 3281, 0, 0);
INSERT INTO chado.cvterm VALUES (2975, 26, 'PhD Thesis', 'PhD thesis or dissertation.', 3282, 0, 0);
INSERT INTO chado.cvterm VALUES (2976, 26, 'Publication Database', 'The name of the database that houses the publication record. This term is obsolete in favor of the ''Publication Dbxref'' term.', 3283, 1, 0);
INSERT INTO chado.cvterm VALUES (2977, 26, 'Received Date', 'The date when the manuscript was first received by the editor for consideration for print. This should be in the format: YYYY Mon Day, where YYYY is a 4 digit year, Mon is a 3-letter English abbreviation for the month followed by the day.  The month and day are optional.', 3284, 0, 0);
INSERT INTO chado.cvterm VALUES (2978, 26, 'Publication Date', 'The date the work was published.  This should be in the format: YYYY Mon Day, where YYYY is a 4 digit year, Mon is a 3-letter English abbreviation for the month followed by the day. The month and day are optional.', 3285, 0, 0);
INSERT INTO chado.cvterm VALUES (2979, 26, 'Conference Name', 'The name of a conference from which presented works are published.', 3286, 0, 0);
INSERT INTO chado.cvterm VALUES (2980, 26, 'Book Chapter', '', 3287, 0, 0);
INSERT INTO chado.cvterm VALUES (2981, 26, 'Unknown Type', '', 3288, 0, 0);
INSERT INTO chado.cvterm VALUES (2982, 26, 'Web Page', '', 3289, 0, 0);
INSERT INTO chado.cvterm VALUES (2983, 26, 'Epub Date', 'The date when a manuscript for the publication was first published online.  This may not be the same date it was formally printed. This should be in the format: YYYY Mon Day, where YYYY is a 4 digit year, Mon is a 3-letter English abbreviation for the month followed by the day. The month and day are optional.', 3290, 0, 0);
INSERT INTO chado.cvterm VALUES (2984, 26, 'Accepted Date', 'The date when a manuscript for the publication was first accepted for publication by the editor. This should be in the format: YYYY Mon Day, where YYYY is a 4 digit year, Mon is a 3-letter English abbreviation for the month followed by the day. The month and day are optional.', 3291, 0, 0);
INSERT INTO chado.cvterm VALUES (2985, 26, 'Journal Abbreviation', 'The journal title ISO Abbreviation.', 3292, 0, 0);
INSERT INTO chado.cvterm VALUES (2986, 26, 'Series Abbreviation', 'An abbreviation for the series name.  (e.g. the journal title ISO Abbreviation).', 3293, 0, 0);
INSERT INTO chado.cvterm VALUES (2987, 26, 'Title', 'The title of the published work.', 3294, 0, 0);
INSERT INTO chado.cvterm VALUES (2988, 26, 'Journal', '', 3295, 0, 0);
INSERT INTO chado.cvterm VALUES (2989, 26, 'Patent', 'Works consisting of documents granted by a government giving exclusive rights to an inventor or assignee to manufacture, use, or sell an invention for a certain number of years. The plural version of this term', 3296, 0, 0);
INSERT INTO chado.cvterm VALUES (2990, 26, 'Volume', 'The volume of the journal where the publication was printed.', 3297, 0, 0);
INSERT INTO chado.cvterm VALUES (2991, 26, 'Issue', 'The issue of the journal where the publication was printed.', 3298, 0, 0);
INSERT INTO chado.cvterm VALUES (2992, 26, 'Pages', 'The pages in the published work where the cited information is found.', 3299, 0, 0);
INSERT INTO chado.cvterm VALUES (2993, 26, 'Start Page', 'The first page in the published work where the cited information is found.', 3300, 0, 0);
INSERT INTO chado.cvterm VALUES (2994, 26, 'Authors', 'The list of authors of the publication. For PubMed style citations list each author with the last name first, followed by initials. Each author should be separated by a comma.', 3301, 0, 0);
INSERT INTO chado.cvterm VALUES (2995, 26, 'ISSN', 'International Standard Serial Number (ISSN) is an eight-character value that uniquely identifies a periodicals in print or other media. There are two sub categories of ISSN: print, p-ISSN and electronic e-ISSN.', 3302, 0, 0);
INSERT INTO chado.cvterm VALUES (2996, 26, 'DOI', 'Digital Object Identifier.', 3303, 0, 0);
INSERT INTO chado.cvterm VALUES (2997, 26, 'Elocation', 'Provides an electronic location for the items. This includes Digital Object Identifiers (DOI) or Publisher Item Identifiers (PII).', 3304, 0, 0);
INSERT INTO chado.cvterm VALUES (2998, 26, 'Abstract', 'The fully printed abstract for the publication.', 3305, 0, 0);
INSERT INTO chado.cvterm VALUES (2999, 26, 'Comments', 'Comments regarding the content in the publication.', 3306, 0, 0);
INSERT INTO chado.cvterm VALUES (3000, 26, 'URL', 'A univeral resource locator (URL) reference where the publication can be found.  For publications found online, this would be the web address for the publication.', 3307, 0, 0);
INSERT INTO chado.cvterm VALUES (3001, 26, 'File Attachment', 'The names of a file associated with the publication (e.g. supplemental data).', 3308, 0, 0);
INSERT INTO chado.cvterm VALUES (3002, 26, 'Year', 'The year the work was published. This should be a 4 digit year.', 3309, 0, 0);
INSERT INTO chado.cvterm VALUES (3003, 26, 'Language', 'The full name of the languge of the publication (e.g. English).', 3310, 0, 0);
INSERT INTO chado.cvterm VALUES (3004, 26, 'Keywords', 'Contains controlled terms that describe the content of the article. Multiple keywords should be separated with a comma.  For keyworks with that exist in a formal ontology or vocabulary, the format can be the database abbreviation, followed by the term accession separated by a comma (e.g. GO:591743).', 3311, 0, 0);
INSERT INTO chado.cvterm VALUES (3005, 26, 'Original Title', '', 3312, 0, 0);
INSERT INTO chado.cvterm VALUES (3006, 26, 'Alias', 'A synonym or alternative name for this publication.', 3313, 0, 0);
INSERT INTO chado.cvterm VALUES (3007, 26, 'Journal Code', '', 3314, 0, 0);
INSERT INTO chado.cvterm VALUES (3008, 26, 'pISSN', 'International Standard Serial Number (ISSN) is an eight-character value that uniquely identifies a periodicals in print or other media. There are two sub categories of ISSN: print, p-ISSN and electronic e-ISSN.', 3315, 0, 0);
INSERT INTO chado.cvterm VALUES (3009, 26, 'Conference Proceedings', 'A generic term for any article, talk, workshop or poster that is part of a conference proceedings.', 3316, 0, 0);
INSERT INTO chado.cvterm VALUES (3010, 26, 'eISSN', 'International Standard Serial Number (ISSN) is an eight-character value that uniquely identifies a periodicals in print or other media. There are two sub categories of ISSN: print, p-ISSN and electronic e-ISSN.', 3317, 0, 0);
INSERT INTO chado.cvterm VALUES (3011, 26, 'Proceedings Talk', '', 3318, 0, 0);
INSERT INTO chado.cvterm VALUES (3012, 26, 'Proceedings Article', '', 3319, 0, 0);
INSERT INTO chado.cvterm VALUES (3013, 26, 'Journal Name', '', 3320, 0, 0);
INSERT INTO chado.cvterm VALUES (3014, 26, 'Series Name', 'The name media that produces a series of publications (e.g. journal, conference proceedings, etc.)', 3321, 0, 0);
INSERT INTO chado.cvterm VALUES (3015, 26, 'Proceedings Poster', '', 3322, 0, 0);
INSERT INTO chado.cvterm VALUES (3018, 26, 'Vernacular Title', 'The title of a publication in its original foreign language.', 3325, 0, 0);
INSERT INTO chado.cvterm VALUES (3019, 26, 'Publication Model', 'This term is used to identify the medium/media in which the item is published. There are four possible values which are the same as used by: print, print-electronic, electronic,  electronic-print.  Further explanation:  "print", the journal is published in print format only; "print-electronic",  the journal is published in both print and electronic format; "electronic", the journal is published in electronic format only; "electronic-print", the journal is published first in electronic format followed by print.', 3326, 0, 0);
INSERT INTO chado.cvterm VALUES (3020, 26, 'PII', 'Publisher Item Identifier.', 3327, 0, 0);
INSERT INTO chado.cvterm VALUES (3021, 26, 'Structured Abstract Part', 'A subset of an abstract.  For example, abstracts that have section headers such as ''Purpose'', ''Results'', etc., each of these sections would be an individual part of a structured abstract.', 3328, 0, 0);
INSERT INTO chado.cvterm VALUES (3022, 26, 'Copyright', 'Information regarding the copyright of the publication.', 3329, 0, 0);
INSERT INTO chado.cvterm VALUES (3023, 26, 'Suffix', 'Name suffix such as 2nd, 3rd, Jr, Sr., etc.', 3330, 0, 0);
INSERT INTO chado.cvterm VALUES (3024, 26, 'Language Abbr', 'An abbreviation for a language (e.g. 3 letters)', 3331, 0, 0);
INSERT INTO chado.cvterm VALUES (3025, 26, 'Journal Country', 'The country where the journal was published.', 3332, 0, 0);
INSERT INTO chado.cvterm VALUES (3026, 26, 'Abbreviations', 'Works consisting of lists of shortened forms of written words or phrases used for brevity. Acronyms are included here.', 3333, 0, 0);
INSERT INTO chado.cvterm VALUES (3027, 26, 'Abstracts', 'Works consisting of lists of publications on a subject and that provide full annotated bibliographical information together with substantive summaries or condensations of the facts, ideas, or opinions presented in each publication listed. (From LC Subject Cataloging Manual)', 3334, 0, 0);
INSERT INTO chado.cvterm VALUES (3028, 26, 'Academic Dissertations', 'Works consisting of formal presentations made usually to fulfill requirements for an academic degree.', 3335, 0, 0);
INSERT INTO chado.cvterm VALUES (3029, 26, 'Addresses', 'Works consisting of speeches, orations, or written statements, usually formal, directed to a particular group of persons. These are different from LECTURES that are usually delivered to classes for instructional purposes.', 3336, 0, 0);
INSERT INTO chado.cvterm VALUES (3030, 26, 'Almanacs', 'Works consisting of a calendar of days, weeks, and months, together with information such as astronomical data, various statistics, etc. (From Genre Terms: A Thesaurus for Use in Rare Book and Special Collections Cataloguing, 2d ed)', 3337, 0, 0);
INSERT INTO chado.cvterm VALUES (3031, 26, 'Anecdotes', 'Works consisting of brief accounts or narratives of incidents or events.', 3338, 0, 0);
INSERT INTO chado.cvterm VALUES (3032, 26, 'Animation', 'A film or video wholly or partially created by photographing drawings, sculptures, or other inanimate things in sequence to create the illusion of motion. Animations are also generated by computers. (From Moving Image Materials: Genre Terms, 1988)', 3339, 0, 0);
INSERT INTO chado.cvterm VALUES (3033, 26, 'Annual Reports', 'Works consisting of annual statements concerning the administrative and operational functions of an institution or organization.', 3340, 0, 0);
INSERT INTO chado.cvterm VALUES (3034, 26, 'Atlases', 'Works consisting of collections of illustrative plates, charts, etc., usually with explanatory captions.', 3341, 0, 0);
INSERT INTO chado.cvterm VALUES (3035, 26, 'Autobiography', 'Works consisting of self-described accounts.', 3342, 0, 0);
INSERT INTO chado.cvterm VALUES (3036, 26, 'Bibliography', 'A work consisting of a list of books, articles, documents, publications, and other items, usually on a single subject or related subjects.', 3343, 0, 0);
INSERT INTO chado.cvterm VALUES (3037, 26, 'Biobibliography', 'Works consisting of biographical information as well as lists of the writings of those persons.', 3344, 0, 0);
INSERT INTO chado.cvterm VALUES (3038, 26, 'Biography', 'Works consisting of an account of the events, works, and achievements, personal and professional, during a person''s life. It includes articles on the activities and accomplishments of living persons as well as the presentation of an obituary.', 3345, 0, 0);
INSERT INTO chado.cvterm VALUES (3039, 26, 'Book Illustrations', 'Works consisting of photographs, prints, drawings, portraits, plates, diagrams, facsimiles, maps, tables, or other representations or systematic arrangements of data designed to elucidate or decorate the contents of a publication. (From The ALA Glossary of Library and Information Science, 1983, p114)', 3346, 0, 0);
INSERT INTO chado.cvterm VALUES (3040, 26, 'Book Reviews', 'Works consisting of critical analyses of books or other monographic works.', 3347, 0, 0);
INSERT INTO chado.cvterm VALUES (3041, 26, 'Bookplates', 'Works consisting of book owner''s identification labels. They are usually intended for attaching inside a book or similar object. (From Thesaurus for Graphic Materials II: Genre and Physical Characteristic Terms, 1995)', 3348, 0, 0);
INSERT INTO chado.cvterm VALUES (3042, 26, 'Cartoons', 'Images used to comment on such things as contemporary events, social habits, or political trends; usually executed in a broad or abbreviated manner.', 3349, 0, 0);
INSERT INTO chado.cvterm VALUES (3043, 26, 'Case Reports', 'Clinical presentations that may be followed by evaluative studies that eventually lead to a diagnosis.', 3350, 0, 0);
INSERT INTO chado.cvterm VALUES (3044, 26, 'Catalogs', 'Works consisting of bibliographic records, created according to specific and uniform principles of construction and under the control of an authority file, which describe the materials contained in a collection, library, or group of libraries. Catalogs include also lists of materials prepared for a particular purpose, such as exhibition catalogs, sales catalogs, garden catalogs, medical supply catalogs. (From The ALA Glossary of Library and Information Sciences, 1983)', 3351, 0, 0);
INSERT INTO chado.cvterm VALUES (3045, 26, 'Charts', 'Information presented in graphic form, for example, graphs or diagrams.', 3352, 0, 0);
INSERT INTO chado.cvterm VALUES (3046, 26, 'Chronology', 'Works consisting of lists of events arranged in chronological order.', 3353, 0, 0);
INSERT INTO chado.cvterm VALUES (3047, 26, 'Classical Article', 'Works consisting of a current presentation of a previously printed seminal article marking a milestone in the history of medicine or science. It is usually accompanied by introductory remarks heralding its reprinting, often on the anniversary of its original publication or on an anniversary of the author''s birth or death. It is usually reprinted in full, with complete bibliographical reference to the original appearance.', 3354, 0, 0);
INSERT INTO chado.cvterm VALUES (3048, 26, 'Clinical Conference', 'Work that consists of a conference of physicians on their observations of a patient at the bedside, regarding the physical state, laboratory and other diagnostic findings, clinical manifestations, results of current therapy, etc. A clinical conference usually ends with a confirmation or correction of clinical findings by a pathological diagnosis performed by a pathologist. "Clinical conference" is often referred to as a "clinico-pathological conference."', 3355, 0, 0);
INSERT INTO chado.cvterm VALUES (3156, 26, 'Video-Audio Media', 'Used with articles which include video files or clips, or for articles which are entirely video.', 3463, 0, 0);
INSERT INTO chado.cvterm VALUES (3157, 26, 'Webcasts', 'Content from transmission of live or pre-recorded audio or video via connection or download from the INTERNET.', 3464, 0, 0);
INSERT INTO chado.cvterm VALUES (3049, 26, 'Clinical Trial', 'Work that is the report of a pre-planned clinical study of the safety, efficacy, or optimum dosage schedule of one or more diagnostic, therapeutic, or prophylactic drugs, devices, or techniques in humans selected according to predetermined criteria of eligibility and observed for predefined evidence of favorable and unfavorable effects. While most clinical trials concern humans, this publication type may be used for clinical veterinary articles meeting the requisites for humans. Specific headings for specific types and phases of clinical trials are also available.', 3356, 0, 0);
INSERT INTO chado.cvterm VALUES (3050, 26, 'Clinical Trial, Phase I', 'Work that is the report of a pre-planned, usually controlled, clinical study of the safety and efficacy of diagnostic, therapeutic, or prophylactic drugs, devices, or techniques based on a small number of healthy persons and conducted over the period of about a year in either the United States or a foreign country.', 3357, 0, 0);
INSERT INTO chado.cvterm VALUES (3051, 26, 'Clinical Trial, Phase II', 'Work that is a report of a pre-planned, usually controlled, clinical study of the safety and efficacy of diagnostic, therapeutic, or prophylactic drugs, devices, or techniques based on several hundred volunteers, including a limited number of patients, and conducted over a period of about two years in either the United States or a foreign country.', 3358, 0, 0);
INSERT INTO chado.cvterm VALUES (3052, 26, 'Clinical Trial, Phase III', 'Work that is a report of a pre-planned, usually controlled, clinical study of the safety and efficacy of diagnostic, therapeutic, or prophylactic drugs, devices, or techniques after phase II trials. A large enough group of patients is studied and closely monitored by physicians for adverse response to long-term exposure, over a period of about three years in either the United States or a foreign country.', 3359, 0, 0);
INSERT INTO chado.cvterm VALUES (3053, 26, 'Clinical Trial, Phase IV', 'Work that is a report of a planned post-marketing study of diagnostic, therapeutic, or prophylactic drugs, devices, or techniques that have been approved for general sale after clinical trials, phases I, II, and III. These studies, conducted in the United States or a foreign country, often garner additional data about the safety and efficacy of a product.', 3360, 0, 0);
INSERT INTO chado.cvterm VALUES (3054, 26, 'Collected Correspondence', 'Works consisting of collected letters by or about a person or on a subject.', 3361, 0, 0);
INSERT INTO chado.cvterm VALUES (3055, 26, 'Collected Works', 'Works consisting of collections of previously published works.', 3362, 0, 0);
INSERT INTO chado.cvterm VALUES (3056, 26, 'Collections', 'Works that consist of collections of objects.', 3363, 0, 0);
INSERT INTO chado.cvterm VALUES (3057, 26, 'Comment', 'Work consisting of a critical or explanatory note written to discuss, support, or dispute an article or other presentation previously published. It may take the form of an article, letter, editorial, etc. It appears in publications under a variety of names: comment, commentary, editorial comment, viewpoint, etc.', 3364, 0, 0);
INSERT INTO chado.cvterm VALUES (3058, 26, 'Comparative Study', 'Comparison of outcomes, results, responses, etc for different techniques, therapeutic approaches or other inputs.', 3365, 0, 0);
INSERT INTO chado.cvterm VALUES (3059, 26, 'Congresses', 'Published records of the papers delivered at or issued on the occasion of individual congresses, symposia, and meetings; abstracts of papers delivered at such congresses; reports of the officers and delegates of such congresses; combinations of the foregoing; or proceedings of the conference of a society if they are not limited to matters of internal organization.', 3366, 0, 0);
INSERT INTO chado.cvterm VALUES (3060, 26, 'Consensus Development Conference', 'A work that consists of summary statements representing the majority and current agreement of physicians, scientists, and other professionals meeting to reach a consensus on a selected subject.', 3367, 0, 0);
INSERT INTO chado.cvterm VALUES (3061, 26, 'Controlled Clinical Trial', 'Work consisting of a clinical trial involving one or more test treatments, at least one control treatment, specified outcome measures for evaluating the studied intervention, and a bias-free method for assigning patients to the test treatment. The treatment may be drugs, devices, or procedures studied for diagnostic, therapeutic, or prophylactic effectiveness. Control measures include placebos, active medicine, no-treatment, dosage forms and regimens, historical comparisons, etc. When randomization using mathematical techniques, such as the use of a random numbers table, is employed to assign patients to test or control treatments, the trial is characterized as a RANDOMIZED CONTROLLED TRIAL.', 3368, 0, 0);
INSERT INTO chado.cvterm VALUES (3062, 26, 'Cookbooks', 'Collections of recipes or instructions for preparation of food and organization of meals.', 3369, 0, 0);
INSERT INTO chado.cvterm VALUES (3063, 26, 'Corrected and Republished Article', 'Work that is the republication of an article to correct, amplify, or restore text and data of the originally published article.', 3370, 0, 0);
INSERT INTO chado.cvterm VALUES (3064, 26, 'Database', 'Work consisting of a structured file of information or a set of logically related data stored and retrieved using computer-based means.', 3371, 0, 0);
INSERT INTO chado.cvterm VALUES (3065, 26, 'Diaries', 'Works consisting of records, usually private, of writers'' experiences, observations, feelings, attitudes, etc. They may also be works marked in calendar order in which to note appointments and the like. (From Random House Unabridged Dictionary, 2d ed)', 3372, 0, 0);
INSERT INTO chado.cvterm VALUES (3066, 26, 'Dictionary', 'A reference book containing a list of words - usually in alphabetical order - giving information about form, pronunciation, etymology, grammar, and meaning. A foreign-language dictionary is an alphabetical list of words of one language with their meaning and equivalents in another language.', 3373, 0, 0);
INSERT INTO chado.cvterm VALUES (3067, 26, 'Directory', 'Work consisting of an alphabetical or classified list of names, organizations, subjects, etc., giving usually titles, addresses, affiliations, and other professional data.', 3374, 0, 0);
INSERT INTO chado.cvterm VALUES (3068, 26, 'Documentaries and Factual Films', 'Works consisting of films, videos, and programs which depict actual persons or actual events. They do not include frank historical re-creations and do not attempt to judge the truth of the depiction in a film purporting to be factual or documentary in character. (From Moving Image Materials: Genre Terms, 1988)', 3375, 0, 0);
INSERT INTO chado.cvterm VALUES (3069, 26, 'Drawings', 'Works consisting of graphic representations of objects or ideas by lines.', 3376, 0, 0);
INSERT INTO chado.cvterm VALUES (3070, 26, 'Duplicate Publication', 'Work consisting of an article or book of identical or nearly identical material published simultaneously or successively to material previously published elsewhere, without acknowledgment of the prior publication.', 3377, 0, 0);
INSERT INTO chado.cvterm VALUES (3071, 26, 'Editorial', 'Work consisting of a statement of the opinions, beliefs, and policy of the editor or publisher of a journal, usually on current matters of medical or scientific significance to the medical community or society at large. The editorials published by editors of journals representing the official organ of a society or organization are generally substantive.', 3378, 0, 0);
INSERT INTO chado.cvterm VALUES (3158, 26, 'Research Support, American Recovery and Reinvestment Act', '', 3465, 0, 0);
INSERT INTO chado.cvterm VALUES (3072, 26, 'Electronic Supplementary Materials', 'Supporting content or information, such as animation, datasets, multimedia files, video, movies, audio files, text files, or software, which is submitted for publication in an online journal or an online edition of a journal. This information may be referenced in the text of the article with a link to the supplementary data provided. CATALOG: do not use', 3379, 0, 0);
INSERT INTO chado.cvterm VALUES (3073, 26, 'Encyclopedias', 'Works containing informational articles on subjects in every field of knowledge, usually arranged in alphabetical order, or a similar work limited to a special field or subject. (From The ALA Glossary of Library and Information Science, 1983)', 3380, 0, 0);
INSERT INTO chado.cvterm VALUES (3074, 26, 'Ephemera', 'Works consisting of transient everyday items, usually printed on paper, that are produced for a specific limited use and then often thrown away. (From Genre Terms: A Thesaurus for Use in Rare Book and Special Collections Cataloguing, 2d ed & The ALA Glossary of Library and Information Science, 1983)', 3381, 0, 0);
INSERT INTO chado.cvterm VALUES (3075, 26, 'Essays', 'Works consisting of collections of papers or interpretive literary compositions not previously published.', 3382, 0, 0);
INSERT INTO chado.cvterm VALUES (3076, 26, 'Evaluation Studies', 'Works consisting of studies determining the effectiveness or utility of processes, personnel, and equipment.', 3383, 0, 0);
INSERT INTO chado.cvterm VALUES (3077, 26, 'Examination Questions', 'Works consisting of compilations of questions and answers pertaining to a particular subject, used for study and review.', 3384, 0, 0);
INSERT INTO chado.cvterm VALUES (3078, 26, 'Exhibitions', 'Public displays or items representative of a given subject.', 3385, 0, 0);
INSERT INTO chado.cvterm VALUES (3079, 26, 'Festschrift', 'Work consisting of a collection of essays or other writings contributed by students, teachers, colleagues, and associates to honor a person or institution, usually on the occasion of an anniversary celebration or other event of importance.', 3386, 0, 0);
INSERT INTO chado.cvterm VALUES (3080, 26, 'Fictional Works', 'Works consisting of creative writing, not presented as factual.', 3387, 0, 0);
INSERT INTO chado.cvterm VALUES (3081, 26, 'Forms', 'Works consisting of or containing a substantial number of blank forms.', 3388, 0, 0);
INSERT INTO chado.cvterm VALUES (3082, 26, 'Formularies', 'Works that consist of lists of drugs or collections of recipes, formulas, and prescriptions for the compounding of medicinal preparations.', 3389, 0, 0);
INSERT INTO chado.cvterm VALUES (3083, 26, 'Government Publications', 'Works consisting of documents issued by local, regional, or national governments or by their agencies or subdivisions.', 3390, 0, 0);
INSERT INTO chado.cvterm VALUES (3084, 26, 'Guidebooks', 'Works consisting of publications for travelers that give information about a city, region, or country, or similar handbooks about buildings, museums, etc. (The ALA Glossary of Library and Information Science, 1983)', 3391, 0, 0);
INSERT INTO chado.cvterm VALUES (3085, 26, 'Guideline', 'Work consisting of a set of statements, directions, or principles presenting current or future rules or policy. Guidelines may be developed by government agencies at any level, institutions, organizations such as professional societies or governing boards, or by the convening of expert panels. The text may be cursive or in outline form, but it is generally a comprehensive guide to problems and approaches in any discipline or activity. This concept relates to the general conduct and administration of health care activities rather than to specific decisions for a particular clinical condition. For that aspect, PRACTICE GUIDELINE is available.', 3392, 0, 0);
INSERT INTO chado.cvterm VALUES (3086, 26, 'Handbooks', 'Works consisting of concise reference works in which facts and information pertaining to a certain subject or field are arranged for ready reference and consultation rather than for continuous reading and study.', 3393, 0, 0);
INSERT INTO chado.cvterm VALUES (3087, 26, 'Herbals', 'Works such as books on herbs or plants usually describing their medicinal value. (Random House Unabridged Dictionary, 2d ed)', 3394, 0, 0);
INSERT INTO chado.cvterm VALUES (3088, 26, 'Historical Article', 'An article or portion of an article giving an account of past events or circumstances significant in a field of study, a profession, a discovery, an invention, etc. The concept of history is very wide, ranging from the dawn of time to the present. This publication type is often checked in conjunction with BIOGRAPHY.', 3395, 0, 0);
INSERT INTO chado.cvterm VALUES (3089, 26, 'Humor', 'Works consisting of jokes and facetiae relating to a subject.', 3396, 0, 0);
INSERT INTO chado.cvterm VALUES (3090, 26, 'In Vitro', 'Studies using excised tissues.', 3397, 0, 0);
INSERT INTO chado.cvterm VALUES (3091, 26, 'Incunabula', 'Books printed before 1501.', 3398, 0, 0);
INSERT INTO chado.cvterm VALUES (3092, 26, 'Indexes', 'Works providing an analytical subject approach to materials in a field of knowledge.', 3399, 0, 0);
INSERT INTO chado.cvterm VALUES (3093, 26, 'Instructional Films', 'Works consisting of nonfiction films and video designed to teach, instruct, or train. (From Moving Image Materials: Genre Terms, 1988)', 3400, 0, 0);
INSERT INTO chado.cvterm VALUES (3094, 26, 'Interactive Tutorial', 'Video recordings or other files in which the progress of the instruction or content is determined by user response.', 3401, 0, 0);
INSERT INTO chado.cvterm VALUES (3095, 26, 'Interview', 'Work consisting of a conversation with an individual regarding his or her background and other personal and professional details, opinions on specific subjects posed by the interviewer, etc.', 3402, 0, 0);
INSERT INTO chado.cvterm VALUES (3096, 26, 'Introductory Journal Article', 'Prefactory summary to a special issue or section of a journal devoted to a specific topic. This introductory text can be of varying length and substance.', 3403, 0, 0);
INSERT INTO chado.cvterm VALUES (3097, 26, 'Journal Article', 'The predominant publication type for articles and other items indexed for NLM databases.', 3404, 0, 0);
INSERT INTO chado.cvterm VALUES (3098, 26, 'Juvenile Literature', 'Works produced for children through age 15 or through the ninth grade.', 3405, 0, 0);
INSERT INTO chado.cvterm VALUES (3099, 26, 'Laboratory Manuals', 'Works containing concise background information and directions for activities, including conducting experiments or diagnostic tests in the laboratory.', 3406, 0, 0);
INSERT INTO chado.cvterm VALUES (3100, 26, 'Lecture Notes', 'Works consisting of notes taken at the delivery or reading of a speech before an audience or class, usually given to instruct. (From Random House Unabridged Dictionary, 2d ed)', 3407, 0, 0);
INSERT INTO chado.cvterm VALUES (3101, 26, 'Lectures', 'Works consisting of speeches read or delivered before an audience or class, especially for instruction or to set forth some subject. They are differentiated from ADDRESSES [PUBLICATION TYPE] which are less didactic and more informational, entertaining, inspirational, or polemic. (From Random House Unabridged Dictionary, 2d ed)', 3408, 0, 0);
INSERT INTO chado.cvterm VALUES (3102, 26, 'Legal Cases', 'Works consisting of collections of law reports or the published reports of decided cases and documents or filings related to those cases.', 3409, 0, 0);
INSERT INTO chado.cvterm VALUES (3103, 26, 'Legislation', 'Works consisting of the text of proposed or enacted legislation that may be in the form of bills, laws, statutes, ordinances, or government regulations.', 3410, 0, 0);
INSERT INTO chado.cvterm VALUES (3159, 26, 'Research Support, N.I.H., Extramural', 'A designation for publications of research resulting from extramural research funded by the National Institutes of Health.', 3466, 0, 0);
INSERT INTO chado.cvterm VALUES (3104, 26, 'Letter', 'Work consisting of written or printed communication between individuals or between persons and representatives of corporate bodies. The correspondence may be personal or professional. In medical and other scientific publications the letter is usually from one or more authors to the editor of the journal or book publishing the item being commented upon or discussed. LETTER is often accompanied by COMMENT.', 3411, 0, 0);
INSERT INTO chado.cvterm VALUES (3105, 26, 'Manuscripts', 'Works prepared by hand including handwritten or typescript drafts of pre-publication papers or works not otherwise reproduced in multiple copies.', 3412, 0, 0);
INSERT INTO chado.cvterm VALUES (3106, 26, 'Maps', 'Works consisting of representations, normally to scale and on a flat medium, of a selection of material or abstract features on the surface of the earth. They may be used also in delineating the heavens and celestial bodies. (From Anglo-American Cataloguing Rules, 2d ed, p619)', 3413, 0, 0);
INSERT INTO chado.cvterm VALUES (3107, 26, 'Meeting Abstracts', 'For individual abstracts of presentations at meetings, congresses, conferences, symposia, colloquia, seminars, workshops, round tables, and other professional gatherings.', 3414, 0, 0);
INSERT INTO chado.cvterm VALUES (3108, 26, 'Meta Analysis', 'Works consisting of studies using a quantitative method of combining the results of independent studies (usually drawn from the published literature) and synthesizing summaries and conclusions which may be used to evaluate therapeutic effectiveness, plan new studies, etc. It is often an overview of clinical trials. It is usually called a meta-analysis by the author or sponsoring body and should be differentiated from reviews of literature.', 3415, 0, 0);
INSERT INTO chado.cvterm VALUES (3109, 26, 'Monograph', 'Work that is any publication that is not a serial or integrating resource. In cataloging usage, It is usually on a single subject or related subjects and is complete in itself, whether constructed of chapters, sections, or parts. While any article encountered in indexing journals can be, strictly speaking, a monograph, as a publication type, a monograph will refer to a cataloging item.', 3416, 0, 0);
INSERT INTO chado.cvterm VALUES (3110, 26, 'Multicenter Study', 'Work consisting of a controlled study executed by several cooperating institutions.', 3417, 0, 0);
INSERT INTO chado.cvterm VALUES (3111, 26, 'News', 'Works consisting of an announcement or statement of recent or current events of new data and matters of interest in the field of medicine or science. In some publications, such as "Nature" or "Science," the news reports are substantively written and herald medical and scientific data of vital or controversial importance.', 3418, 0, 0);
INSERT INTO chado.cvterm VALUES (3112, 26, 'Newspaper Article', 'Work consisting of a news item appearing in a general-interest newspaper or other general news periodical, containing information of current and timely interest in the field of medicine or science. This publication type should not be confused with NEWS Publication Type, reserved for news reports published in various medical or other scientific journals, such as "Nature".', 3419, 0, 0);
INSERT INTO chado.cvterm VALUES (3113, 26, 'Nurses'' Instruction', 'Works consisting of materials developed for a nursing audience.', 3420, 0, 0);
INSERT INTO chado.cvterm VALUES (3114, 26, 'Outlines', 'Works consisting of brief statements of the principal elements of a subject, usually arranged by heads and subheads.', 3421, 0, 0);
INSERT INTO chado.cvterm VALUES (3115, 26, 'Overall', 'A single citation covering papers or abstracts presented at a meeting. The publication type may be used for a single citation with or without the additional indexing or cataloging of individual papers. The individual papers, however, are not labeled OVERALL.', 3422, 0, 0);
INSERT INTO chado.cvterm VALUES (3116, 26, 'Patents (obsolete)', 'This term is obsolete in favor of the existing term ''Patent'' (TPUB:0000041).', 3423, 1, 0);
INSERT INTO chado.cvterm VALUES (3117, 26, 'Patient Education Handout', 'Works consisting of a handout or self-contained informative material used to explain a procedure or a condition or the contents of a specific article in a biomedical journal and written in non-technical language for the patient or consumer.', 3424, 0, 0);
INSERT INTO chado.cvterm VALUES (3118, 26, 'Periodical Index', 'Work consisting of a subject approach to the contents of a periodical issuing an annual, biennial, quinquennial, decennial, etc., index. The heading is used for the overall body of articles published by a periodical in the same sense that BIBLIOGRAPHY is useful when published as a single article.', 3425, 0, 0);
INSERT INTO chado.cvterm VALUES (3119, 26, 'Periodicals', 'Publications intended to be issued on an ongoing basis, generally more frequently than annually, containing separate articles, stories, or writings.', 3426, 0, 0);
INSERT INTO chado.cvterm VALUES (3120, 26, 'Personal Narratives', 'Works consisting of accounts of individual experience in relation to a particular field or of participation in related activities.', 3427, 0, 0);
INSERT INTO chado.cvterm VALUES (3121, 26, 'Pharmacopoeias', 'Authoritative works containing lists of drugs and preparations, their description, formulation, analytic composition, main chemical properties, standards for strength, purity, and dosage, chemical tests for determining identity, etc. They have the status of a standard.', 3428, 0, 0);
INSERT INTO chado.cvterm VALUES (3122, 26, 'Photographs', 'Still images produced from radiation-sensitive materials (sensitive to light, electron beams, or nuclear radiation), generally by means of the chemical action of light on a sensitive film, paper, glass, or metal. Photographs may be positive or negative, opaque or transparent.', 3429, 0, 0);
INSERT INTO chado.cvterm VALUES (3123, 26, 'Phrases', 'Works consisting of common terms, phrases, idioms, and typical conversations, e.g., between health professional and patients. These are often intended for use by non-native speakers of a language.', 3430, 0, 0);
INSERT INTO chado.cvterm VALUES (3124, 26, 'Pictorial Works', 'Works consisting exclusively or mainly of pictures but not technical drawings.', 3431, 0, 0);
INSERT INTO chado.cvterm VALUES (3125, 26, 'Poetry', 'Works that consist of literary and oral genre expressing meaning via symbolism and following formal or informal patterns.', 3432, 0, 0);
INSERT INTO chado.cvterm VALUES (3126, 26, 'Popular Works', 'Works written for non-professional or lay audiences.', 3433, 0, 0);
INSERT INTO chado.cvterm VALUES (3127, 26, 'Portraits', 'Works consisting of graphic representations, especially of the face, of real persons, usually posed, living or dead. They are pictures whose purpose is the portrayal of an individual or group of individuals, not pictures which merely include people as part of an event or scene. (From Thesaurus for Graphic Materials II, p540, 1995)', 3434, 0, 0);
INSERT INTO chado.cvterm VALUES (3128, 26, 'Postcards', 'Cards on which a message may be written or printed for mailing without an envelope. Art & Architectural Thesaurus Online www.getty.edu/research/conducting_research/vocabularies/aat/ accessed 12/18/2008', 3435, 0, 0);
INSERT INTO chado.cvterm VALUES (3129, 26, 'Posters', 'Works consisting of single or multi-sheet notices made to attract attention to events, activities, causes, goods, or services. They are for posting, usually in a public place and are chiefly pictorial. They are intended to make an immediate impression from a distance. Posters do not include poster presentations at conferences and meetings. (From Thesaurus for Graphic Materials II: Genre and Physical Characteristic Headings, 1995)', 3436, 0, 0);
INSERT INTO chado.cvterm VALUES (3130, 26, 'Practice Guideline', 'Work consisting of a set of directions or principles to assist the health care practitioner with patient care decisions about appropriate diagnostic, therapeutic, or other clinical procedures for specific clinical circumstances. Practice guidelines may be developed by government agencies at any level, institutions, organizations such as professional societies or governing boards, or by the convening of expert panels. They can provide a foundation for assessing and evaluating the quality and effectiveness of health care in terms of measuring improved health, reduction of variation in services or procedures performed, and reduction of variation in outcomes of health care delivered.', 3437, 0, 0);
INSERT INTO chado.cvterm VALUES (3131, 26, 'Price Lists', 'Works consisting of lists giving the prices of items for sale, including drugs, equipment, books, etc. Price lists are less detailed than catalogs and not as long.', 3438, 0, 0);
INSERT INTO chado.cvterm VALUES (3132, 26, 'Problems and Exercises', 'Works consisting of collections of practice questions and drills, generally for instructional or review use.', 3439, 0, 0);
INSERT INTO chado.cvterm VALUES (3133, 26, 'Programmed Instruction', 'Works consisting of sequenced self-correction texts.', 3440, 0, 0);
INSERT INTO chado.cvterm VALUES (3134, 26, 'Programs', 'Works consisting of lists of the events, pieces, performers, speakers, etc., of an entertainment, ceremony, or the like. (From: Genre Terms: A Thesaurus for Use in Rare Book and Special Collections Cataloging, 2d ed)', 3441, 0, 0);
INSERT INTO chado.cvterm VALUES (3135, 26, 'Prospectuses', 'Works consisting of advertisements separately printed and distributed by a publisher to describe and solicit orders for a recent or forthcoming publication. In the case of books, they may include sample pages. (From: ALA Glossary of Library and Information Science, 1983)', 3442, 0, 0);
INSERT INTO chado.cvterm VALUES (3136, 26, 'Publication Components', 'Specific parts of publications.', 3443, 0, 0);
INSERT INTO chado.cvterm VALUES (3137, 26, 'Publication Formats', 'Specific genre of publication.', 3444, 0, 0);
INSERT INTO chado.cvterm VALUES (3138, 26, 'Published Erratum', 'Work consisting of an acknowledgment of an error, issued by a publisher, editor, or author. It customarily cites the source where the error occurred, giving complete bibliographic data for retrieval. In the case of books and monographs, author, title, imprint, paging, and other helpful references will be given; in the case of journal articles, the author, title, paging, and journal reference will be shown. An erratum notice is variously cited as Errata or Corrigenda.', 3445, 0, 0);
INSERT INTO chado.cvterm VALUES (3139, 26, 'Randomized Controlled Trial', 'Work consisting of a clinical trial that involves at least one test treatment and one control treatment, concurrent enrollment and follow-up of the test- and control-treated groups, and in which the treatments to be administered are selected by a random process, such as the use of a random-numbers table.', 3446, 0, 0);
INSERT INTO chado.cvterm VALUES (3140, 26, 'Resource guides', 'Works listing and describing various sources of information, from multiple media or in different formats, on a given subject.', 3447, 0, 0);
INSERT INTO chado.cvterm VALUES (3141, 26, 'Retracted Publication', 'Work consisting of the designation of an article or book as retracted in whole or in part by an author or authors or an authorized representative. It identifies a citation previously published and now retracted through a formal issuance from the author, publisher, or other authorized agent, and is distinguished from RETRACTION OF PUBLICATION, which identifies the citation retracting the original published item.', 3448, 0, 0);
INSERT INTO chado.cvterm VALUES (3142, 26, 'Retraction of Publication', 'Work consisting of a statement issued by one or more authors of an article or a book, withdrawing or disavowing acknowledgment of their participation in performing research or writing the results of their study. In indexing, the retraction is sent to the editor of the publication in which the article appeared and is published under the rubric "retraction" or in the form of a letter. This publication type designates the author''s statement of retraction: it should be differentiated from RETRACTED PUBLICATION which labels the retracted publication.', 3449, 0, 0);
INSERT INTO chado.cvterm VALUES (3143, 26, 'Review', 'An article or book published after examination of published material on a subject. It may be comprehensive to various degrees and the time range of material scrutinized may be broad or narrow, but the reviews most often desired are reviews of the current literature. The textual material examined may be equally broad and can encompass, in medicine specifically, clinical material as well as experimental research or case reports. State-of-the-art reviews tend to address more current matters. A review of the literature must be differentiated from HISTORICAL ARTICLE on the same subject, but a review of historical literature is also within the scope of this publication type.', 3450, 0, 0);
INSERT INTO chado.cvterm VALUES (3144, 26, 'Scientific Integrity Review', 'Work consisting of reports by the United States Office of Research Integrity, identifying questionable research published in articles or books. Notification of the questionable data is carried in the NIH Guide for Grants and Contracts.', 3451, 0, 0);
INSERT INTO chado.cvterm VALUES (3145, 26, 'Statistics', 'Works consisting of presentations of numerical data on particular subjects.', 3452, 0, 0);
INSERT INTO chado.cvterm VALUES (3146, 26, 'Support of Research', 'Organizational source for funding of research activity.', 3453, 0, 0);
INSERT INTO chado.cvterm VALUES (3147, 26, 'Tables', 'Presentations of nonstatistical data in tabular form.', 3454, 0, 0);
INSERT INTO chado.cvterm VALUES (3148, 26, 'Technical Report', 'Work consisting of a formal report giving details of the investigation and results of a medical or other scientific problem. When issued by a government agency or comparable official body, its contents may be classified, unclassified, or declassified with regard to security clearance. This publication type may also cover a scientific paper or article that records the current state or current position of scientific research and development. If so labeled by the editor or publisher, this publication type may be properly used for journal articles.', 3455, 0, 0);
INSERT INTO chado.cvterm VALUES (3149, 26, 'Terminology', 'Work consisting of lists of the technical terms or expressions used in a specific field. These lists may or may not be formally adopted or sanctioned by usage.', 3456, 0, 0);
INSERT INTO chado.cvterm VALUES (3150, 26, 'Textbooks', 'Books intended for use in the study of specific subjects, containing systematic presentation of the principles and essential knowledge of the subjects.', 3457, 0, 0);
INSERT INTO chado.cvterm VALUES (3151, 26, 'Twin Study', 'Work consisting of reporting using a method of detecting genetic causes in human traits and genetic factors in behavior using sets of twins.', 3458, 0, 0);
INSERT INTO chado.cvterm VALUES (3152, 26, 'Unedited Footage', 'Work consisting of untitled raw motion picture and video footage which has not been edited or assembled into a finished work. (From: Moving Image Materials: Genre Terms, 1988)', 3459, 0, 0);
INSERT INTO chado.cvterm VALUES (3153, 26, 'Union Lists', 'Works consisting of records of the holdings or items owned by two or more libraries.', 3460, 0, 0);
INSERT INTO chado.cvterm VALUES (3154, 26, 'Unpublished Works', 'Works that have not been formally published.', 3461, 0, 0);
INSERT INTO chado.cvterm VALUES (3155, 26, 'Validation Studies', 'Works consisting of research using processes by which the reliability and relevance of a procedure for a specific purpose are established.', 3462, 0, 0);
INSERT INTO chado.cvterm VALUES (3160, 26, 'Research Support, N.I.H., Intramural', 'A designation for publications of research resulting from intramural research at the National Institutes of Health.', 3467, 0, 0);
INSERT INTO chado.cvterm VALUES (3161, 26, 'Research Support, Non-U.S. Gov''t', '', 3468, 0, 0);
INSERT INTO chado.cvterm VALUES (3162, 26, 'Research Support, U.S. Gov''t, Non-P.H.S.', '', 3469, 0, 0);
INSERT INTO chado.cvterm VALUES (3163, 26, 'Research Support, U.S. Gov''t, P.H.S.', '', 3470, 0, 0);
INSERT INTO chado.cvterm VALUES (3164, 26, 'Research Support, U.S. Government', 'For publications noted as supported by US Government.', 3471, 0, 0);
INSERT INTO chado.cvterm VALUES (3165, 26, 'English Abstract', '', 3472, 0, 0);
INSERT INTO chado.cvterm VALUES (3166, 26, 'Meta-Analysis', 'Works consisting of studies using a quantitative method of combining the results of independent studies (usually drawn from the published literature) and synthesizing summaries and conclusions which may be used to evaluate therapeutic effectiveness, plan new studies, etc. It is often an overview of clinical trials. It is usually called a meta-analysis by the author or sponsoring body and should be differentiated from reviews of literature.', 3473, 0, 0);
INSERT INTO chado.cvterm VALUES (3167, 26, 'Publisher', '', 3474, 0, 0);
INSERT INTO chado.cvterm VALUES (3168, 26, 'Published Location', '', 3475, 0, 0);
INSERT INTO chado.cvterm VALUES (3169, 26, 'Prefix', 'A prefix for a name such as a title (e.g. Mr., Mrs., Dr., Chief, Esquire, etc.)', 3476, 0, 0);
INSERT INTO chado.cvterm VALUES (3170, 26, 'ISBN', 'Internaltional Standard Book Number', 3477, 0, 0);
INSERT INTO chado.cvterm VALUES (3171, 26, 'Notes', 'Information about the publication that is not classified using another term.', 3478, 0, 0);
INSERT INTO chado.cvterm VALUES (3172, 26, 'Thesis', 'A Master''s or PhD thesis.', 3479, 0, 0);
INSERT INTO chado.cvterm VALUES (3173, 26, 'Journal Alias', 'An alternate name for a journal', 3480, 0, 0);
INSERT INTO chado.cvterm VALUES (3174, 26, 'Book Name', 'The name of a book to which a book chapter belongs.', 3481, 0, 0);
INSERT INTO chado.cvterm VALUES (3175, 26, 'Media Alias', 'An alternate name for a journal, book, conference proceedings, etc.', 3482, 0, 0);
INSERT INTO chado.cvterm VALUES (3176, 26, 'Media Code', 'A unique special code for a journal, book, conference proceeding, etc', 3483, 0, 0);
INSERT INTO chado.cvterm VALUES (3177, 26, 'Publication Code', 'A unique special code for journal article, book, book chapter or any publication type.', 3484, 0, 0);
INSERT INTO chado.cvterm VALUES (3178, 26, 'Patent Number', 'A unique special code for journal article, book, book chapter or any publication type.', 3485, 0, 0);
INSERT INTO chado.cvterm VALUES (3179, 2, 'lineageex', '', 3486, 0, 0);
INSERT INTO chado.cvterm VALUES (3180, 19, 'Data Source', 'The person or authoritative body who provided the information.', 3487, 0, 0);
INSERT INTO chado.cvterm VALUES (3181, 30, 'versioned dataset', 'a versioned dataset is a dataset with a particular release date or release number.', 3488, 0, 0);
INSERT INTO chado.cvterm VALUES (3182, 7, 'Phylogenetic tree type', 'Phylogenetic tree type | A label (text token) describing the type of a phylogenetic tree. [http://edamontology.org]', 3489, 0, 0);
INSERT INTO chado.cvterm VALUES (3183, 8, 'germplasm', 'Germplasm is the living genetic resources such as seeds or tissue that is maintained for the purpose of animal and plant breeding, preservation, and other research uses. These resources may take the form of seed collections stored in seed banks, trees growing in nurseries, animal breeding lines maintained in animal breeding programs or gene banks, etc. Germplasm collections can range from collections of wild species to elite, domesticated breeding lines that have undergone extensive human selection.', 3490, 0, 0);
INSERT INTO chado.cvterm VALUES (3184, 8, 'cultivar', 'A cultivated plant variety selected and given a name because it has desirable characteristics that distinguish it from otherwise similar plants of the same species.', 3491, 0, 0);
INSERT INTO chado.cvterm VALUES (3185, 12, 'collection of specimens', 'A material entity that has two or more specimens as its parts.', 3492, 0, 0);
INSERT INTO chado.cvterm VALUES (3186, 33, 'progeny', '', 3493, 0, 0);
INSERT INTO chado.contact VALUES (1, NULL, 'null', 'null');
INSERT INTO chado.pub VALUES (1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'null', 'null', 1, false, NULL, NULL);
INSERT INTO chado.chadoprop VALUES (1, 2, '1.3', 0);
INSERT INTO chado.cv_root_mview VALUES ('sequence_attribute', 812, 23, 'sequence');
INSERT INTO chado.cv_root_mview VALUES ('taxonomic_rank', 2878, 24, 'taxonomic_rank');
INSERT INTO chado.cv_root_mview VALUES ('sequence_variant', 188, 23, 'sequence');
INSERT INTO chado.cv_root_mview VALUES ('sequence_feature', 184, 23, 'sequence');
INSERT INTO chado.cv_root_mview VALUES ('Publication', 194, 26, 'tripal_pub');
INSERT INTO chado.cv_root_mview VALUES ('Affiliation', 2952, 25, 'tripal_contact');
INSERT INTO chado.cv_root_mview VALUES ('sequence_collection', 1395, 23, 'sequence');
INSERT INTO chado.cv_root_mview VALUES ('Contact Type', 2938, 25, 'tripal_contact');
INSERT INTO chado.cv_root_mview VALUES ('Address', 2956, 25, 'tripal_contact');
INSERT INTO chado.cvterm_dbxref VALUES (1, 448, 449, 0);
INSERT INTO chado.cvterm_dbxref VALUES (2, 382, 525, 0);
INSERT INTO chado.cvterm_dbxref VALUES (3, 382, 526, 0);
INSERT INTO chado.cvterm_dbxref VALUES (4, 657, 661, 0);
INSERT INTO chado.cvterm_dbxref VALUES (5, 707, 712, 0);
INSERT INTO chado.cvterm_dbxref VALUES (6, 814, 820, 0);
INSERT INTO chado.cvterm_dbxref VALUES (7, 824, 831, 0);
INSERT INTO chado.cvterm_dbxref VALUES (8, 833, 841, 0);
INSERT INTO chado.cvterm_dbxref VALUES (9, 833, 842, 0);
INSERT INTO chado.cvterm_dbxref VALUES (10, 833, 843, 0);
INSERT INTO chado.cvterm_dbxref VALUES (11, 836, 847, 0);
INSERT INTO chado.cvterm_dbxref VALUES (12, 840, 852, 0);
INSERT INTO chado.cvterm_dbxref VALUES (13, 999, 1012, 0);
INSERT INTO chado.cvterm_dbxref VALUES (14, 1011, 1025, 0);
INSERT INTO chado.cvterm_dbxref VALUES (15, 1086, 1101, 0);
INSERT INTO chado.cvterm_dbxref VALUES (16, 1105, 1121, 0);
INSERT INTO chado.cvterm_dbxref VALUES (17, 1105, 1122, 0);
INSERT INTO chado.cvterm_dbxref VALUES (18, 1128, 1146, 0);
INSERT INTO chado.cvterm_dbxref VALUES (19, 1163, 1182, 0);
INSERT INTO chado.cvterm_dbxref VALUES (20, 418, 1193, 0);
INSERT INTO chado.cvterm_dbxref VALUES (21, 1093, 1196, 0);
INSERT INTO chado.cvterm_dbxref VALUES (22, 1235, 1257, 0);
INSERT INTO chado.cvterm_dbxref VALUES (23, 841, 1270, 0);
INSERT INTO chado.cvterm_dbxref VALUES (24, 841, 1271, 0);
INSERT INTO chado.cvterm_dbxref VALUES (25, 1284, 1309, 0);
INSERT INTO chado.cvterm_dbxref VALUES (26, 1175, 1374, 0);
INSERT INTO chado.cvterm_dbxref VALUES (27, 1385, 1412, 0);
INSERT INTO chado.cvterm_dbxref VALUES (28, 1390, 1418, 0);
INSERT INTO chado.cvterm_dbxref VALUES (29, 524, 1450, 0);
INSERT INTO chado.cvterm_dbxref VALUES (30, 524, 1451, 0);
INSERT INTO chado.cvterm_dbxref VALUES (31, 1423, 1454, 0);
INSERT INTO chado.cvterm_dbxref VALUES (32, 839, 1455, 0);
INSERT INTO chado.cvterm_dbxref VALUES (33, 843, 1457, 0);
INSERT INTO chado.cvterm_dbxref VALUES (34, 1425, 1459, 0);
INSERT INTO chado.cvterm_dbxref VALUES (35, 1426, 1461, 0);
INSERT INTO chado.cvterm_dbxref VALUES (36, 1427, 1463, 0);
INSERT INTO chado.cvterm_dbxref VALUES (37, 1428, 1465, 0);
INSERT INTO chado.cvterm_dbxref VALUES (38, 834, 1466, 0);
INSERT INTO chado.cvterm_dbxref VALUES (39, 1429, 1468, 0);
INSERT INTO chado.cvterm_dbxref VALUES (40, 1430, 1470, 0);
INSERT INTO chado.cvterm_dbxref VALUES (41, 1431, 1472, 0);
INSERT INTO chado.cvterm_dbxref VALUES (42, 1432, 1474, 0);
INSERT INTO chado.cvterm_dbxref VALUES (43, 1433, 1476, 0);
INSERT INTO chado.cvterm_dbxref VALUES (44, 1434, 1478, 0);
INSERT INTO chado.cvterm_dbxref VALUES (45, 1435, 1480, 0);
INSERT INTO chado.cvterm_dbxref VALUES (46, 1436, 1482, 0);
INSERT INTO chado.cvterm_dbxref VALUES (47, 1437, 1484, 0);
INSERT INTO chado.cvterm_dbxref VALUES (48, 1438, 1486, 0);
INSERT INTO chado.cvterm_dbxref VALUES (49, 1439, 1488, 0);
INSERT INTO chado.cvterm_dbxref VALUES (50, 1441, 1491, 0);
INSERT INTO chado.cvterm_dbxref VALUES (51, 1442, 1493, 0);
INSERT INTO chado.cvterm_dbxref VALUES (52, 1443, 1495, 0);
INSERT INTO chado.cvterm_dbxref VALUES (53, 1444, 1497, 0);
INSERT INTO chado.cvterm_dbxref VALUES (54, 1445, 1499, 0);
INSERT INTO chado.cvterm_dbxref VALUES (55, 1446, 1501, 0);
INSERT INTO chado.cvterm_dbxref VALUES (56, 1447, 1503, 0);
INSERT INTO chado.cvterm_dbxref VALUES (57, 1448, 1505, 0);
INSERT INTO chado.cvterm_dbxref VALUES (58, 1450, 1508, 0);
INSERT INTO chado.cvterm_dbxref VALUES (59, 1451, 1510, 0);
INSERT INTO chado.cvterm_dbxref VALUES (60, 1452, 1512, 0);
INSERT INTO chado.cvterm_dbxref VALUES (61, 1455, 1516, 0);
INSERT INTO chado.cvterm_dbxref VALUES (62, 1456, 1518, 0);
INSERT INTO chado.cvterm_dbxref VALUES (63, 1457, 1520, 0);
INSERT INTO chado.cvterm_dbxref VALUES (64, 1458, 1522, 0);
INSERT INTO chado.cvterm_dbxref VALUES (65, 1459, 1524, 0);
INSERT INTO chado.cvterm_dbxref VALUES (66, 1460, 1526, 0);
INSERT INTO chado.cvterm_dbxref VALUES (67, 1461, 1528, 0);
INSERT INTO chado.cvterm_dbxref VALUES (68, 1462, 1530, 0);
INSERT INTO chado.cvterm_dbxref VALUES (69, 1463, 1532, 0);
INSERT INTO chado.cvterm_dbxref VALUES (70, 1464, 1534, 0);
INSERT INTO chado.cvterm_dbxref VALUES (71, 1465, 1536, 0);
INSERT INTO chado.cvterm_dbxref VALUES (72, 1466, 1538, 0);
INSERT INTO chado.cvterm_dbxref VALUES (73, 1469, 1542, 0);
INSERT INTO chado.cvterm_dbxref VALUES (74, 1471, 1545, 0);
INSERT INTO chado.cvterm_dbxref VALUES (75, 1472, 1547, 0);
INSERT INTO chado.cvterm_dbxref VALUES (76, 1473, 1549, 0);
INSERT INTO chado.cvterm_dbxref VALUES (77, 1474, 1551, 0);
INSERT INTO chado.cvterm_dbxref VALUES (78, 1475, 1553, 0);
INSERT INTO chado.cvterm_dbxref VALUES (79, 1476, 1555, 0);
INSERT INTO chado.cvterm_dbxref VALUES (80, 1477, 1557, 0);
INSERT INTO chado.cvterm_dbxref VALUES (81, 1478, 1559, 0);
INSERT INTO chado.cvterm_dbxref VALUES (82, 1440, 1560, 0);
INSERT INTO chado.cvterm_dbxref VALUES (83, 1479, 1562, 0);
INSERT INTO chado.cvterm_dbxref VALUES (84, 1480, 1564, 0);
INSERT INTO chado.cvterm_dbxref VALUES (85, 1481, 1566, 0);
INSERT INTO chado.cvterm_dbxref VALUES (86, 1482, 1568, 0);
INSERT INTO chado.cvterm_dbxref VALUES (87, 1483, 1570, 0);
INSERT INTO chado.cvterm_dbxref VALUES (88, 1484, 1572, 0);
INSERT INTO chado.cvterm_dbxref VALUES (89, 1485, 1574, 0);
INSERT INTO chado.cvterm_dbxref VALUES (90, 1486, 1576, 0);
INSERT INTO chado.cvterm_dbxref VALUES (91, 1487, 1578, 0);
INSERT INTO chado.cvterm_dbxref VALUES (92, 1488, 1580, 0);
INSERT INTO chado.cvterm_dbxref VALUES (93, 1489, 1582, 0);
INSERT INTO chado.cvterm_dbxref VALUES (94, 1490, 1584, 0);
INSERT INTO chado.cvterm_dbxref VALUES (95, 1491, 1586, 0);
INSERT INTO chado.cvterm_dbxref VALUES (96, 1285, 1587, 0);
INSERT INTO chado.cvterm_dbxref VALUES (97, 1492, 1589, 0);
INSERT INTO chado.cvterm_dbxref VALUES (98, 1493, 1591, 0);
INSERT INTO chado.cvterm_dbxref VALUES (99, 1494, 1593, 0);
INSERT INTO chado.cvterm_dbxref VALUES (100, 1495, 1595, 0);
INSERT INTO chado.cvterm_dbxref VALUES (101, 1496, 1597, 0);
INSERT INTO chado.cvterm_dbxref VALUES (102, 1497, 1599, 0);
INSERT INTO chado.cvterm_dbxref VALUES (103, 1498, 1601, 0);
INSERT INTO chado.cvterm_dbxref VALUES (104, 1499, 1603, 0);
INSERT INTO chado.cvterm_dbxref VALUES (105, 1500, 1605, 0);
INSERT INTO chado.cvterm_dbxref VALUES (106, 1501, 1607, 0);
INSERT INTO chado.cvterm_dbxref VALUES (107, 1502, 1609, 0);
INSERT INTO chado.cvterm_dbxref VALUES (108, 1503, 1611, 0);
INSERT INTO chado.cvterm_dbxref VALUES (109, 1504, 1613, 0);
INSERT INTO chado.cvterm_dbxref VALUES (110, 1505, 1615, 0);
INSERT INTO chado.cvterm_dbxref VALUES (111, 1506, 1617, 0);
INSERT INTO chado.cvterm_dbxref VALUES (112, 1507, 1619, 0);
INSERT INTO chado.cvterm_dbxref VALUES (113, 1508, 1621, 0);
INSERT INTO chado.cvterm_dbxref VALUES (114, 1509, 1623, 0);
INSERT INTO chado.cvterm_dbxref VALUES (115, 1510, 1625, 0);
INSERT INTO chado.cvterm_dbxref VALUES (116, 1511, 1627, 0);
INSERT INTO chado.cvterm_dbxref VALUES (117, 1512, 1629, 0);
INSERT INTO chado.cvterm_dbxref VALUES (118, 1512, 1630, 0);
INSERT INTO chado.cvterm_dbxref VALUES (119, 1584, 1703, 0);
INSERT INTO chado.cvterm_dbxref VALUES (120, 1586, 1706, 0);
INSERT INTO chado.cvterm_dbxref VALUES (121, 1614, 1735, 0);
INSERT INTO chado.cvterm_dbxref VALUES (122, 1625, 1747, 0);
INSERT INTO chado.cvterm_dbxref VALUES (123, 1626, 1749, 0);
INSERT INTO chado.cvterm_dbxref VALUES (124, 1627, 1751, 0);
INSERT INTO chado.cvterm_dbxref VALUES (125, 1628, 1753, 0);
INSERT INTO chado.cvterm_dbxref VALUES (126, 1629, 1755, 0);
INSERT INTO chado.cvterm_dbxref VALUES (127, 1630, 1757, 0);
INSERT INTO chado.cvterm_dbxref VALUES (128, 1631, 1759, 0);
INSERT INTO chado.cvterm_dbxref VALUES (129, 1632, 1761, 0);
INSERT INTO chado.cvterm_dbxref VALUES (130, 1633, 1763, 0);
INSERT INTO chado.cvterm_dbxref VALUES (131, 1634, 1765, 0);
INSERT INTO chado.cvterm_dbxref VALUES (132, 1635, 1767, 0);
INSERT INTO chado.cvterm_dbxref VALUES (133, 1636, 1769, 0);
INSERT INTO chado.cvterm_dbxref VALUES (134, 1637, 1771, 0);
INSERT INTO chado.cvterm_dbxref VALUES (135, 1638, 1773, 0);
INSERT INTO chado.cvterm_dbxref VALUES (136, 1639, 1775, 0);
INSERT INTO chado.cvterm_dbxref VALUES (137, 1640, 1777, 0);
INSERT INTO chado.cvterm_dbxref VALUES (138, 1641, 1779, 0);
INSERT INTO chado.cvterm_dbxref VALUES (139, 1642, 1781, 0);
INSERT INTO chado.cvterm_dbxref VALUES (140, 1643, 1783, 0);
INSERT INTO chado.cvterm_dbxref VALUES (141, 1644, 1785, 0);
INSERT INTO chado.cvterm_dbxref VALUES (142, 1645, 1787, 0);
INSERT INTO chado.cvterm_dbxref VALUES (143, 1646, 1789, 0);
INSERT INTO chado.cvterm_dbxref VALUES (144, 1647, 1791, 0);
INSERT INTO chado.cvterm_dbxref VALUES (145, 1648, 1793, 0);
INSERT INTO chado.cvterm_dbxref VALUES (146, 1649, 1795, 0);
INSERT INTO chado.cvterm_dbxref VALUES (147, 1650, 1797, 0);
INSERT INTO chado.cvterm_dbxref VALUES (148, 1651, 1799, 0);
INSERT INTO chado.cvterm_dbxref VALUES (149, 1652, 1801, 0);
INSERT INTO chado.cvterm_dbxref VALUES (150, 1653, 1803, 0);
INSERT INTO chado.cvterm_dbxref VALUES (151, 1654, 1805, 0);
INSERT INTO chado.cvterm_dbxref VALUES (152, 1655, 1807, 0);
INSERT INTO chado.cvterm_dbxref VALUES (153, 1656, 1809, 0);
INSERT INTO chado.cvterm_dbxref VALUES (154, 1657, 1811, 0);
INSERT INTO chado.cvterm_dbxref VALUES (155, 1658, 1813, 0);
INSERT INTO chado.cvterm_dbxref VALUES (156, 1659, 1815, 0);
INSERT INTO chado.cvterm_dbxref VALUES (157, 1660, 1817, 0);
INSERT INTO chado.cvterm_dbxref VALUES (158, 1661, 1819, 0);
INSERT INTO chado.cvterm_dbxref VALUES (159, 1662, 1821, 0);
INSERT INTO chado.cvterm_dbxref VALUES (160, 1664, 1824, 0);
INSERT INTO chado.cvterm_dbxref VALUES (161, 1665, 1826, 0);
INSERT INTO chado.cvterm_dbxref VALUES (162, 1666, 1828, 0);
INSERT INTO chado.cvterm_dbxref VALUES (163, 1667, 1830, 0);
INSERT INTO chado.cvterm_dbxref VALUES (164, 1668, 1832, 0);
INSERT INTO chado.cvterm_dbxref VALUES (165, 1669, 1834, 0);
INSERT INTO chado.cvterm_dbxref VALUES (166, 1670, 1836, 0);
INSERT INTO chado.cvterm_dbxref VALUES (167, 1671, 1838, 0);
INSERT INTO chado.cvterm_dbxref VALUES (168, 1672, 1840, 0);
INSERT INTO chado.cvterm_dbxref VALUES (169, 1673, 1842, 0);
INSERT INTO chado.cvterm_dbxref VALUES (170, 1674, 1844, 0);
INSERT INTO chado.cvterm_dbxref VALUES (171, 1675, 1846, 0);
INSERT INTO chado.cvterm_dbxref VALUES (172, 1676, 1848, 0);
INSERT INTO chado.cvterm_dbxref VALUES (173, 1677, 1850, 0);
INSERT INTO chado.cvterm_dbxref VALUES (174, 1678, 1852, 0);
INSERT INTO chado.cvterm_dbxref VALUES (175, 1679, 1854, 0);
INSERT INTO chado.cvterm_dbxref VALUES (176, 1680, 1856, 0);
INSERT INTO chado.cvterm_dbxref VALUES (177, 1681, 1858, 0);
INSERT INTO chado.cvterm_dbxref VALUES (178, 1682, 1860, 0);
INSERT INTO chado.cvterm_dbxref VALUES (179, 1683, 1862, 0);
INSERT INTO chado.cvterm_dbxref VALUES (180, 1684, 1864, 0);
INSERT INTO chado.cvterm_dbxref VALUES (181, 1685, 1866, 0);
INSERT INTO chado.cvterm_dbxref VALUES (182, 1686, 1868, 0);
INSERT INTO chado.cvterm_dbxref VALUES (183, 1687, 1870, 0);
INSERT INTO chado.cvterm_dbxref VALUES (184, 1688, 1872, 0);
INSERT INTO chado.cvterm_dbxref VALUES (185, 1689, 1874, 0);
INSERT INTO chado.cvterm_dbxref VALUES (186, 1690, 1876, 0);
INSERT INTO chado.cvterm_dbxref VALUES (187, 1691, 1878, 0);
INSERT INTO chado.cvterm_dbxref VALUES (188, 1692, 1880, 0);
INSERT INTO chado.cvterm_dbxref VALUES (189, 1693, 1882, 0);
INSERT INTO chado.cvterm_dbxref VALUES (190, 1694, 1884, 0);
INSERT INTO chado.cvterm_dbxref VALUES (191, 1695, 1886, 0);
INSERT INTO chado.cvterm_dbxref VALUES (192, 1696, 1888, 0);
INSERT INTO chado.cvterm_dbxref VALUES (193, 1697, 1890, 0);
INSERT INTO chado.cvterm_dbxref VALUES (194, 1698, 1892, 0);
INSERT INTO chado.cvterm_dbxref VALUES (195, 1699, 1894, 0);
INSERT INTO chado.cvterm_dbxref VALUES (196, 1700, 1896, 0);
INSERT INTO chado.cvterm_dbxref VALUES (197, 1701, 1894, 0);
INSERT INTO chado.cvterm_dbxref VALUES (198, 1702, 1899, 0);
INSERT INTO chado.cvterm_dbxref VALUES (199, 1703, 1901, 0);
INSERT INTO chado.cvterm_dbxref VALUES (200, 1704, 1903, 0);
INSERT INTO chado.cvterm_dbxref VALUES (201, 1705, 1905, 0);
INSERT INTO chado.cvterm_dbxref VALUES (202, 1706, 1907, 0);
INSERT INTO chado.cvterm_dbxref VALUES (203, 1707, 1909, 0);
INSERT INTO chado.cvterm_dbxref VALUES (204, 1708, 1911, 0);
INSERT INTO chado.cvterm_dbxref VALUES (205, 1709, 1913, 0);
INSERT INTO chado.cvterm_dbxref VALUES (206, 1710, 1915, 0);
INSERT INTO chado.cvterm_dbxref VALUES (207, 1711, 1917, 0);
INSERT INTO chado.cvterm_dbxref VALUES (208, 1712, 1919, 0);
INSERT INTO chado.cvterm_dbxref VALUES (209, 1713, 1921, 0);
INSERT INTO chado.cvterm_dbxref VALUES (210, 1714, 1923, 0);
INSERT INTO chado.cvterm_dbxref VALUES (211, 1715, 1925, 0);
INSERT INTO chado.cvterm_dbxref VALUES (212, 1716, 1927, 0);
INSERT INTO chado.cvterm_dbxref VALUES (213, 1717, 1929, 0);
INSERT INTO chado.cvterm_dbxref VALUES (214, 1718, 1931, 0);
INSERT INTO chado.cvterm_dbxref VALUES (215, 1719, 1933, 0);
INSERT INTO chado.cvterm_dbxref VALUES (216, 1720, 1935, 0);
INSERT INTO chado.cvterm_dbxref VALUES (217, 1721, 1937, 0);
INSERT INTO chado.cvterm_dbxref VALUES (218, 1722, 1939, 0);
INSERT INTO chado.cvterm_dbxref VALUES (219, 1723, 1941, 0);
INSERT INTO chado.cvterm_dbxref VALUES (220, 1724, 1943, 0);
INSERT INTO chado.cvterm_dbxref VALUES (221, 1725, 1945, 0);
INSERT INTO chado.cvterm_dbxref VALUES (222, 1726, 1947, 0);
INSERT INTO chado.cvterm_dbxref VALUES (223, 1727, 1949, 0);
INSERT INTO chado.cvterm_dbxref VALUES (224, 1728, 1951, 0);
INSERT INTO chado.cvterm_dbxref VALUES (225, 1729, 1953, 0);
INSERT INTO chado.cvterm_dbxref VALUES (226, 1733, 1958, 0);
INSERT INTO chado.cvterm_dbxref VALUES (227, 1734, 1960, 0);
INSERT INTO chado.cvterm_dbxref VALUES (228, 1735, 1962, 0);
INSERT INTO chado.cvterm_dbxref VALUES (229, 1736, 1964, 0);
INSERT INTO chado.cvterm_dbxref VALUES (230, 1737, 1966, 0);
INSERT INTO chado.cvterm_dbxref VALUES (231, 1738, 1968, 0);
INSERT INTO chado.cvterm_dbxref VALUES (232, 1739, 1970, 0);
INSERT INTO chado.cvterm_dbxref VALUES (233, 1740, 1972, 0);
INSERT INTO chado.cvterm_dbxref VALUES (234, 1741, 1974, 0);
INSERT INTO chado.cvterm_dbxref VALUES (235, 1742, 1976, 0);
INSERT INTO chado.cvterm_dbxref VALUES (236, 1743, 1978, 0);
INSERT INTO chado.cvterm_dbxref VALUES (237, 1744, 1980, 0);
INSERT INTO chado.cvterm_dbxref VALUES (238, 1745, 1982, 0);
INSERT INTO chado.cvterm_dbxref VALUES (239, 1746, 1984, 0);
INSERT INTO chado.cvterm_dbxref VALUES (240, 1747, 1986, 0);
INSERT INTO chado.cvterm_dbxref VALUES (241, 1748, 1988, 0);
INSERT INTO chado.cvterm_dbxref VALUES (242, 1749, 1990, 0);
INSERT INTO chado.cvterm_dbxref VALUES (243, 1750, 1992, 0);
INSERT INTO chado.cvterm_dbxref VALUES (244, 1751, 1994, 0);
INSERT INTO chado.cvterm_dbxref VALUES (245, 1752, 1996, 0);
INSERT INTO chado.cvterm_dbxref VALUES (246, 1753, 1998, 0);
INSERT INTO chado.cvterm_dbxref VALUES (247, 1871, 2117, 0);
INSERT INTO chado.cvterm_dbxref VALUES (248, 1925, 2172, 0);
INSERT INTO chado.cvterm_dbxref VALUES (249, 1928, 2176, 0);
INSERT INTO chado.cvterm_dbxref VALUES (250, 1929, 2178, 0);
INSERT INTO chado.cvterm_dbxref VALUES (251, 1929, 2179, 0);
INSERT INTO chado.cvterm_dbxref VALUES (252, 1929, 2180, 0);
INSERT INTO chado.cvterm_dbxref VALUES (253, 1932, 2184, 0);
INSERT INTO chado.cvterm_dbxref VALUES (254, 1934, 2187, 0);
INSERT INTO chado.cvterm_dbxref VALUES (255, 1908, 2189, 0);
INSERT INTO chado.cvterm_dbxref VALUES (256, 1908, 2190, 0);
INSERT INTO chado.cvterm_dbxref VALUES (257, 2117, 2373, 0);
INSERT INTO chado.cvterm_dbxref VALUES (258, 1909, 2404, 0);
INSERT INTO chado.cvterm_dbxref VALUES (259, 2149, 2407, 0);
INSERT INTO chado.cvterm_dbxref VALUES (260, 2151, 2410, 0);
INSERT INTO chado.cvterm_dbxref VALUES (261, 2172, 2432, 0);
INSERT INTO chado.cvterm_dbxref VALUES (262, 2338, 2599, 0);
INSERT INTO chado.cvterm_dbxref VALUES (263, 2341, 2603, 0);
INSERT INTO chado.cvterm_dbxref VALUES (264, 2435, 2698, 0);
INSERT INTO chado.cvterm_dbxref VALUES (265, 2446, 2710, 0);
INSERT INTO chado.cvterm_dbxref VALUES (266, 2480, 2745, 0);
INSERT INTO chado.cvterm_dbxref VALUES (267, 2530, 2796, 0);
INSERT INTO chado.cvterm_dbxref VALUES (268, 2566, 2833, 0);
INSERT INTO chado.cvterm_dbxref VALUES (269, 2586, 2854, 0);
INSERT INTO chado.cvterm_dbxref VALUES (270, 2622, 2891, 0);
INSERT INTO chado.cvterm_dbxref VALUES (271, 1824, 2965, 0);
INSERT INTO chado.cvterm_dbxref VALUES (272, 2719, 2990, 0);
INSERT INTO chado.cvterm_dbxref VALUES (273, 2248, 2991, 0);
INSERT INTO chado.cvterm_dbxref VALUES (274, 780, 2992, 0);
INSERT INTO chado.cvterm_dbxref VALUES (275, 2727, 3001, 0);
INSERT INTO chado.cvterm_dbxref VALUES (276, 2727, 3002, 0);
INSERT INTO chado.cvterm_dbxref VALUES (277, 2762, 3038, 0);
INSERT INTO chado.cvterm_dbxref VALUES (278, 2762, 3039, 0);
INSERT INTO chado.cvterm_dbxref VALUES (279, 2783, 3061, 0);
INSERT INTO chado.cvterm_dbxref VALUES (280, 2783, 3062, 0);
INSERT INTO chado.cvterm_dbxref VALUES (281, 2879, 3159, 0);
INSERT INTO chado.cvterm_dbxref VALUES (282, 2880, 3161, 0);
INSERT INTO chado.cvterm_dbxref VALUES (283, 2881, 3163, 0);
INSERT INTO chado.cvterm_dbxref VALUES (284, 2882, 3165, 0);
INSERT INTO chado.cvterm_dbxref VALUES (285, 191, 3166, 0);
INSERT INTO chado.cvterm_dbxref VALUES (286, 192, 3167, 0);
INSERT INTO chado.cvterm_dbxref VALUES (287, 2883, 3169, 0);
INSERT INTO chado.cvterm_dbxref VALUES (288, 2884, 3171, 0);
INSERT INTO chado.cvterm_dbxref VALUES (289, 2885, 3173, 0);
INSERT INTO chado.cvterm_dbxref VALUES (290, 2886, 3175, 0);
INSERT INTO chado.cvterm_dbxref VALUES (291, 2887, 3177, 0);
INSERT INTO chado.cvterm_dbxref VALUES (292, 2889, 3180, 0);
INSERT INTO chado.cvterm_dbxref VALUES (293, 2890, 3182, 0);
INSERT INTO chado.cvterm_dbxref VALUES (294, 2891, 3184, 0);
INSERT INTO chado.cvterm_dbxref VALUES (295, 2892, 3186, 0);
INSERT INTO chado.cvterm_dbxref VALUES (296, 2893, 3188, 0);
INSERT INTO chado.cvterm_dbxref VALUES (297, 2894, 3190, 0);
INSERT INTO chado.cvterm_dbxref VALUES (298, 2895, 3192, 0);
INSERT INTO chado.cvterm_dbxref VALUES (299, 2896, 3194, 0);
INSERT INTO chado.cvterm_dbxref VALUES (300, 2897, 3196, 0);
INSERT INTO chado.cvterm_dbxref VALUES (301, 2898, 3198, 0);
INSERT INTO chado.cvterm_dbxref VALUES (302, 2899, 3200, 0);
INSERT INTO chado.cvterm_dbxref VALUES (303, 2900, 3202, 0);
INSERT INTO chado.cvterm_dbxref VALUES (304, 2901, 3204, 0);
INSERT INTO chado.cvterm_dbxref VALUES (305, 2902, 3206, 0);
INSERT INTO chado.cvterm_dbxref VALUES (306, 2903, 3208, 0);
INSERT INTO chado.cvterm_dbxref VALUES (307, 2904, 3210, 0);
INSERT INTO chado.cvterm_dbxref VALUES (308, 2905, 3212, 0);
INSERT INTO chado.cvterm_relationship VALUES (1, 233, 232, 234);
INSERT INTO chado.cvterm_relationship VALUES (2, 233, 249, 250);
INSERT INTO chado.cvterm_relationship VALUES (3, 233, 253, 254);
INSERT INTO chado.cvterm_relationship VALUES (4, 233, 255, 256);
INSERT INTO chado.cvterm_relationship VALUES (5, 233, 260, 256);
INSERT INTO chado.cvterm_relationship VALUES (6, 233, 261, 253);
INSERT INTO chado.cvterm_relationship VALUES (7, 233, 262, 253);
INSERT INTO chado.cvterm_relationship VALUES (8, 233, 264, 253);
INSERT INTO chado.cvterm_relationship VALUES (9, 233, 265, 234);
INSERT INTO chado.cvterm_relationship VALUES (10, 233, 282, 283);
INSERT INTO chado.cvterm_relationship VALUES (11, 233, 284, 184);
INSERT INTO chado.cvterm_relationship VALUES (12, 233, 285, 282);
INSERT INTO chado.cvterm_relationship VALUES (13, 233, 286, 287);
INSERT INTO chado.cvterm_relationship VALUES (14, 233, 288, 282);
INSERT INTO chado.cvterm_relationship VALUES (15, 233, 289, 286);
INSERT INTO chado.cvterm_relationship VALUES (16, 233, 290, 285);
INSERT INTO chado.cvterm_relationship VALUES (17, 233, 291, 292);
INSERT INTO chado.cvterm_relationship VALUES (18, 233, 293, 285);
INSERT INTO chado.cvterm_relationship VALUES (19, 233, 294, 295);
INSERT INTO chado.cvterm_relationship VALUES (20, 233, 296, 297);
INSERT INTO chado.cvterm_relationship VALUES (21, 233, 298, 299);
INSERT INTO chado.cvterm_relationship VALUES (22, 256, 298, 300);
INSERT INTO chado.cvterm_relationship VALUES (23, 256, 298, 301);
INSERT INTO chado.cvterm_relationship VALUES (24, 233, 304, 305);
INSERT INTO chado.cvterm_relationship VALUES (25, 233, 306, 305);
INSERT INTO chado.cvterm_relationship VALUES (26, 233, 307, 308);
INSERT INTO chado.cvterm_relationship VALUES (27, 233, 309, 310);
INSERT INTO chado.cvterm_relationship VALUES (28, 238, 309, 307);
INSERT INTO chado.cvterm_relationship VALUES (29, 233, 311, 312);
INSERT INTO chado.cvterm_relationship VALUES (30, 256, 311, 313);
INSERT INTO chado.cvterm_relationship VALUES (31, 233, 314, 312);
INSERT INTO chado.cvterm_relationship VALUES (32, 256, 314, 313);
INSERT INTO chado.cvterm_relationship VALUES (33, 233, 315, 312);
INSERT INTO chado.cvterm_relationship VALUES (34, 256, 315, 313);
INSERT INTO chado.cvterm_relationship VALUES (35, 233, 316, 317);
INSERT INTO chado.cvterm_relationship VALUES (36, 256, 316, 318);
INSERT INTO chado.cvterm_relationship VALUES (37, 233, 319, 287);
INSERT INTO chado.cvterm_relationship VALUES (38, 233, 320, 321);
INSERT INTO chado.cvterm_relationship VALUES (39, 233, 322, 320);
INSERT INTO chado.cvterm_relationship VALUES (40, 233, 323, 321);
INSERT INTO chado.cvterm_relationship VALUES (41, 233, 324, 322);
INSERT INTO chado.cvterm_relationship VALUES (42, 233, 325, 322);
INSERT INTO chado.cvterm_relationship VALUES (43, 233, 326, 320);
INSERT INTO chado.cvterm_relationship VALUES (44, 233, 327, 321);
INSERT INTO chado.cvterm_relationship VALUES (45, 233, 328, 327);
INSERT INTO chado.cvterm_relationship VALUES (46, 233, 329, 286);
INSERT INTO chado.cvterm_relationship VALUES (47, 233, 330, 329);
INSERT INTO chado.cvterm_relationship VALUES (48, 233, 331, 329);
INSERT INTO chado.cvterm_relationship VALUES (49, 233, 332, 333);
INSERT INTO chado.cvterm_relationship VALUES (50, 233, 334, 332);
INSERT INTO chado.cvterm_relationship VALUES (51, 233, 335, 332);
INSERT INTO chado.cvterm_relationship VALUES (52, 233, 336, 337);
INSERT INTO chado.cvterm_relationship VALUES (53, 252, 336, 338);
INSERT INTO chado.cvterm_relationship VALUES (54, 233, 339, 340);
INSERT INTO chado.cvterm_relationship VALUES (55, 256, 339, 186);
INSERT INTO chado.cvterm_relationship VALUES (56, 233, 341, 342);
INSERT INTO chado.cvterm_relationship VALUES (57, 233, 343, 344);
INSERT INTO chado.cvterm_relationship VALUES (58, 233, 346, 347);
INSERT INTO chado.cvterm_relationship VALUES (59, 256, 346, 348);
INSERT INTO chado.cvterm_relationship VALUES (60, 233, 349, 350);
INSERT INTO chado.cvterm_relationship VALUES (61, 252, 349, 351);
INSERT INTO chado.cvterm_relationship VALUES (62, 233, 354, 355);
INSERT INTO chado.cvterm_relationship VALUES (63, 233, 356, 357);
INSERT INTO chado.cvterm_relationship VALUES (64, 233, 364, 333);
INSERT INTO chado.cvterm_relationship VALUES (65, 233, 367, 368);
INSERT INTO chado.cvterm_relationship VALUES (66, 233, 369, 367);
INSERT INTO chado.cvterm_relationship VALUES (67, 233, 370, 367);
INSERT INTO chado.cvterm_relationship VALUES (68, 233, 371, 372);
INSERT INTO chado.cvterm_relationship VALUES (69, 233, 374, 375);
INSERT INTO chado.cvterm_relationship VALUES (70, 233, 376, 377);
INSERT INTO chado.cvterm_relationship VALUES (71, 233, 378, 374);
INSERT INTO chado.cvterm_relationship VALUES (72, 233, 379, 380);
INSERT INTO chado.cvterm_relationship VALUES (73, 233, 379, 381);
INSERT INTO chado.cvterm_relationship VALUES (74, 250, 379, 382);
INSERT INTO chado.cvterm_relationship VALUES (75, 233, 383, 384);
INSERT INTO chado.cvterm_relationship VALUES (76, 233, 386, 387);
INSERT INTO chado.cvterm_relationship VALUES (77, 233, 389, 305);
INSERT INTO chado.cvterm_relationship VALUES (78, 233, 390, 389);
INSERT INTO chado.cvterm_relationship VALUES (79, 233, 391, 390);
INSERT INTO chado.cvterm_relationship VALUES (80, 233, 392, 391);
INSERT INTO chado.cvterm_relationship VALUES (81, 233, 393, 391);
INSERT INTO chado.cvterm_relationship VALUES (82, 233, 395, 390);
INSERT INTO chado.cvterm_relationship VALUES (83, 233, 396, 390);
INSERT INTO chado.cvterm_relationship VALUES (84, 233, 397, 390);
INSERT INTO chado.cvterm_relationship VALUES (85, 233, 398, 390);
INSERT INTO chado.cvterm_relationship VALUES (86, 233, 399, 390);
INSERT INTO chado.cvterm_relationship VALUES (87, 233, 400, 401);
INSERT INTO chado.cvterm_relationship VALUES (88, 252, 400, 402);
INSERT INTO chado.cvterm_relationship VALUES (89, 233, 403, 400);
INSERT INTO chado.cvterm_relationship VALUES (90, 252, 403, 404);
INSERT INTO chado.cvterm_relationship VALUES (91, 233, 405, 406);
INSERT INTO chado.cvterm_relationship VALUES (92, 233, 406, 305);
INSERT INTO chado.cvterm_relationship VALUES (93, 233, 408, 409);
INSERT INTO chado.cvterm_relationship VALUES (94, 233, 410, 409);
INSERT INTO chado.cvterm_relationship VALUES (95, 233, 413, 185);
INSERT INTO chado.cvterm_relationship VALUES (96, 251, 413, 414);
INSERT INTO chado.cvterm_relationship VALUES (97, 233, 415, 185);
INSERT INTO chado.cvterm_relationship VALUES (98, 251, 415, 416);
INSERT INTO chado.cvterm_relationship VALUES (99, 233, 417, 415);
INSERT INTO chado.cvterm_relationship VALUES (100, 251, 417, 418);
INSERT INTO chado.cvterm_relationship VALUES (101, 233, 419, 185);
INSERT INTO chado.cvterm_relationship VALUES (102, 251, 419, 420);
INSERT INTO chado.cvterm_relationship VALUES (103, 233, 421, 419);
INSERT INTO chado.cvterm_relationship VALUES (104, 251, 421, 422);
INSERT INTO chado.cvterm_relationship VALUES (105, 233, 423, 419);
INSERT INTO chado.cvterm_relationship VALUES (106, 251, 423, 424);
INSERT INTO chado.cvterm_relationship VALUES (107, 233, 425, 419);
INSERT INTO chado.cvterm_relationship VALUES (108, 251, 425, 426);
INSERT INTO chado.cvterm_relationship VALUES (109, 233, 427, 419);
INSERT INTO chado.cvterm_relationship VALUES (110, 251, 427, 428);
INSERT INTO chado.cvterm_relationship VALUES (111, 233, 429, 419);
INSERT INTO chado.cvterm_relationship VALUES (112, 251, 429, 430);
INSERT INTO chado.cvterm_relationship VALUES (113, 233, 431, 419);
INSERT INTO chado.cvterm_relationship VALUES (114, 251, 431, 432);
INSERT INTO chado.cvterm_relationship VALUES (115, 233, 433, 185);
INSERT INTO chado.cvterm_relationship VALUES (116, 251, 433, 434);
INSERT INTO chado.cvterm_relationship VALUES (117, 233, 435, 185);
INSERT INTO chado.cvterm_relationship VALUES (118, 251, 435, 436);
INSERT INTO chado.cvterm_relationship VALUES (119, 233, 437, 185);
INSERT INTO chado.cvterm_relationship VALUES (120, 251, 437, 438);
INSERT INTO chado.cvterm_relationship VALUES (121, 233, 439, 437);
INSERT INTO chado.cvterm_relationship VALUES (122, 251, 439, 440);
INSERT INTO chado.cvterm_relationship VALUES (123, 233, 441, 442);
INSERT INTO chado.cvterm_relationship VALUES (124, 233, 443, 444);
INSERT INTO chado.cvterm_relationship VALUES (125, 233, 445, 446);
INSERT INTO chado.cvterm_relationship VALUES (126, 256, 445, 447);
INSERT INTO chado.cvterm_relationship VALUES (127, 233, 448, 287);
INSERT INTO chado.cvterm_relationship VALUES (128, 238, 448, 449);
INSERT INTO chado.cvterm_relationship VALUES (129, 233, 450, 451);
INSERT INTO chado.cvterm_relationship VALUES (130, 233, 453, 454);
INSERT INTO chado.cvterm_relationship VALUES (131, 233, 455, 186);
INSERT INTO chado.cvterm_relationship VALUES (132, 252, 455, 456);
INSERT INTO chado.cvterm_relationship VALUES (133, 233, 458, 185);
INSERT INTO chado.cvterm_relationship VALUES (134, 256, 458, 441);
INSERT INTO chado.cvterm_relationship VALUES (135, 233, 454, 459);
INSERT INTO chado.cvterm_relationship VALUES (136, 233, 460, 442);
INSERT INTO chado.cvterm_relationship VALUES (137, 233, 461, 462);
INSERT INTO chado.cvterm_relationship VALUES (138, 233, 461, 463);
INSERT INTO chado.cvterm_relationship VALUES (139, 233, 465, 466);
INSERT INTO chado.cvterm_relationship VALUES (140, 233, 468, 401);
INSERT INTO chado.cvterm_relationship VALUES (141, 252, 468, 469);
INSERT INTO chado.cvterm_relationship VALUES (142, 233, 470, 305);
INSERT INTO chado.cvterm_relationship VALUES (143, 233, 471, 472);
INSERT INTO chado.cvterm_relationship VALUES (144, 233, 473, 454);
INSERT INTO chado.cvterm_relationship VALUES (145, 252, 473, 474);
INSERT INTO chado.cvterm_relationship VALUES (146, 233, 475, 286);
INSERT INTO chado.cvterm_relationship VALUES (147, 233, 476, 470);
INSERT INTO chado.cvterm_relationship VALUES (148, 233, 477, 476);
INSERT INTO chado.cvterm_relationship VALUES (149, 233, 478, 476);
INSERT INTO chado.cvterm_relationship VALUES (150, 233, 479, 476);
INSERT INTO chado.cvterm_relationship VALUES (151, 233, 480, 185);
INSERT INTO chado.cvterm_relationship VALUES (152, 252, 480, 481);
INSERT INTO chado.cvterm_relationship VALUES (153, 233, 482, 480);
INSERT INTO chado.cvterm_relationship VALUES (154, 252, 482, 483);
INSERT INTO chado.cvterm_relationship VALUES (155, 233, 484, 482);
INSERT INTO chado.cvterm_relationship VALUES (156, 252, 484, 485);
INSERT INTO chado.cvterm_relationship VALUES (157, 233, 486, 470);
INSERT INTO chado.cvterm_relationship VALUES (158, 233, 487, 470);
INSERT INTO chado.cvterm_relationship VALUES (159, 233, 488, 454);
INSERT INTO chado.cvterm_relationship VALUES (160, 252, 488, 489);
INSERT INTO chado.cvterm_relationship VALUES (161, 233, 490, 305);
INSERT INTO chado.cvterm_relationship VALUES (162, 233, 491, 470);
INSERT INTO chado.cvterm_relationship VALUES (163, 233, 491, 490);
INSERT INTO chado.cvterm_relationship VALUES (164, 233, 492, 491);
INSERT INTO chado.cvterm_relationship VALUES (165, 233, 493, 491);
INSERT INTO chado.cvterm_relationship VALUES (166, 233, 494, 490);
INSERT INTO chado.cvterm_relationship VALUES (167, 233, 495, 496);
INSERT INTO chado.cvterm_relationship VALUES (168, 252, 495, 497);
INSERT INTO chado.cvterm_relationship VALUES (169, 233, 498, 340);
INSERT INTO chado.cvterm_relationship VALUES (170, 256, 498, 499);
INSERT INTO chado.cvterm_relationship VALUES (171, 233, 500, 501);
INSERT INTO chado.cvterm_relationship VALUES (172, 256, 500, 186);
INSERT INTO chado.cvterm_relationship VALUES (173, 233, 502, 372);
INSERT INTO chado.cvterm_relationship VALUES (174, 256, 502, 401);
INSERT INTO chado.cvterm_relationship VALUES (175, 233, 503, 286);
INSERT INTO chado.cvterm_relationship VALUES (176, 233, 504, 347);
INSERT INTO chado.cvterm_relationship VALUES (177, 233, 506, 507);
INSERT INTO chado.cvterm_relationship VALUES (178, 233, 508, 466);
INSERT INTO chado.cvterm_relationship VALUES (179, 233, 509, 510);
INSERT INTO chado.cvterm_relationship VALUES (180, 233, 511, 512);
INSERT INTO chado.cvterm_relationship VALUES (181, 256, 511, 513);
INSERT INTO chado.cvterm_relationship VALUES (182, 233, 300, 504);
INSERT INTO chado.cvterm_relationship VALUES (183, 233, 300, 514);
INSERT INTO chado.cvterm_relationship VALUES (184, 256, 300, 511);
INSERT INTO chado.cvterm_relationship VALUES (185, 233, 299, 504);
INSERT INTO chado.cvterm_relationship VALUES (186, 256, 299, 300);
INSERT INTO chado.cvterm_relationship VALUES (187, 233, 350, 297);
INSERT INTO chado.cvterm_relationship VALUES (188, 233, 515, 516);
INSERT INTO chado.cvterm_relationship VALUES (189, 233, 517, 516);
INSERT INTO chado.cvterm_relationship VALUES (190, 233, 518, 516);
INSERT INTO chado.cvterm_relationship VALUES (191, 233, 519, 520);
INSERT INTO chado.cvterm_relationship VALUES (192, 233, 521, 516);
INSERT INTO chado.cvterm_relationship VALUES (193, 233, 522, 516);
INSERT INTO chado.cvterm_relationship VALUES (194, 233, 523, 516);
INSERT INTO chado.cvterm_relationship VALUES (195, 233, 382, 524);
INSERT INTO chado.cvterm_relationship VALUES (196, 233, 382, 287);
INSERT INTO chado.cvterm_relationship VALUES (197, 233, 526, 462);
INSERT INTO chado.cvterm_relationship VALUES (198, 233, 526, 527);
INSERT INTO chado.cvterm_relationship VALUES (199, 233, 528, 529);
INSERT INTO chado.cvterm_relationship VALUES (200, 233, 530, 531);
INSERT INTO chado.cvterm_relationship VALUES (201, 233, 532, 531);
INSERT INTO chado.cvterm_relationship VALUES (202, 233, 533, 344);
INSERT INTO chado.cvterm_relationship VALUES (203, 233, 534, 533);
INSERT INTO chado.cvterm_relationship VALUES (204, 252, 534, 535);
INSERT INTO chado.cvterm_relationship VALUES (205, 233, 318, 536);
INSERT INTO chado.cvterm_relationship VALUES (206, 233, 318, 372);
INSERT INTO chado.cvterm_relationship VALUES (207, 233, 538, 539);
INSERT INTO chado.cvterm_relationship VALUES (208, 233, 540, 539);
INSERT INTO chado.cvterm_relationship VALUES (209, 233, 541, 539);
INSERT INTO chado.cvterm_relationship VALUES (210, 233, 542, 317);
INSERT INTO chado.cvterm_relationship VALUES (211, 256, 542, 540);
INSERT INTO chado.cvterm_relationship VALUES (212, 233, 543, 544);
INSERT INTO chado.cvterm_relationship VALUES (213, 256, 543, 540);
INSERT INTO chado.cvterm_relationship VALUES (214, 233, 545, 312);
INSERT INTO chado.cvterm_relationship VALUES (215, 233, 546, 317);
INSERT INTO chado.cvterm_relationship VALUES (216, 256, 546, 547);
INSERT INTO chado.cvterm_relationship VALUES (217, 256, 546, 548);
INSERT INTO chado.cvterm_relationship VALUES (218, 233, 549, 317);
INSERT INTO chado.cvterm_relationship VALUES (219, 256, 549, 547);
INSERT INTO chado.cvterm_relationship VALUES (220, 256, 549, 548);
INSERT INTO chado.cvterm_relationship VALUES (221, 233, 550, 444);
INSERT INTO chado.cvterm_relationship VALUES (222, 233, 551, 552);
INSERT INTO chado.cvterm_relationship VALUES (223, 233, 553, 446);
INSERT INTO chado.cvterm_relationship VALUES (224, 256, 553, 447);
INSERT INTO chado.cvterm_relationship VALUES (225, 233, 554, 441);
INSERT INTO chado.cvterm_relationship VALUES (226, 233, 555, 444);
INSERT INTO chado.cvterm_relationship VALUES (227, 233, 556, 441);
INSERT INTO chado.cvterm_relationship VALUES (228, 233, 557, 536);
INSERT INTO chado.cvterm_relationship VALUES (229, 233, 558, 559);
INSERT INTO chado.cvterm_relationship VALUES (230, 233, 472, 401);
INSERT INTO chado.cvterm_relationship VALUES (231, 233, 560, 554);
INSERT INTO chado.cvterm_relationship VALUES (232, 233, 562, 529);
INSERT INTO chado.cvterm_relationship VALUES (233, 233, 563, 554);
INSERT INTO chado.cvterm_relationship VALUES (234, 233, 564, 562);
INSERT INTO chado.cvterm_relationship VALUES (235, 233, 565, 562);
INSERT INTO chado.cvterm_relationship VALUES (236, 233, 566, 562);
INSERT INTO chado.cvterm_relationship VALUES (237, 233, 567, 568);
INSERT INTO chado.cvterm_relationship VALUES (238, 233, 569, 563);
INSERT INTO chado.cvterm_relationship VALUES (239, 233, 292, 509);
INSERT INTO chado.cvterm_relationship VALUES (240, 233, 570, 571);
INSERT INTO chado.cvterm_relationship VALUES (241, 256, 570, 572);
INSERT INTO chado.cvterm_relationship VALUES (242, 233, 573, 571);
INSERT INTO chado.cvterm_relationship VALUES (243, 256, 573, 574);
INSERT INTO chado.cvterm_relationship VALUES (244, 233, 575, 509);
INSERT INTO chado.cvterm_relationship VALUES (245, 233, 576, 577);
INSERT INTO chado.cvterm_relationship VALUES (246, 233, 572, 292);
INSERT INTO chado.cvterm_relationship VALUES (247, 233, 578, 509);
INSERT INTO chado.cvterm_relationship VALUES (248, 233, 574, 292);
INSERT INTO chado.cvterm_relationship VALUES (249, 233, 579, 340);
INSERT INTO chado.cvterm_relationship VALUES (250, 233, 499, 579);
INSERT INTO chado.cvterm_relationship VALUES (251, 233, 580, 579);
INSERT INTO chado.cvterm_relationship VALUES (252, 233, 581, 563);
INSERT INTO chado.cvterm_relationship VALUES (253, 233, 582, 583);
INSERT INTO chado.cvterm_relationship VALUES (254, 233, 584, 556);
INSERT INTO chado.cvterm_relationship VALUES (255, 233, 585, 308);
INSERT INTO chado.cvterm_relationship VALUES (256, 233, 586, 308);
INSERT INTO chado.cvterm_relationship VALUES (257, 233, 587, 586);
INSERT INTO chado.cvterm_relationship VALUES (258, 233, 588, 586);
INSERT INTO chado.cvterm_relationship VALUES (259, 233, 589, 586);
INSERT INTO chado.cvterm_relationship VALUES (260, 233, 590, 586);
INSERT INTO chado.cvterm_relationship VALUES (261, 233, 591, 586);
INSERT INTO chado.cvterm_relationship VALUES (262, 233, 592, 586);
INSERT INTO chado.cvterm_relationship VALUES (263, 233, 593, 586);
INSERT INTO chado.cvterm_relationship VALUES (264, 233, 594, 586);
INSERT INTO chado.cvterm_relationship VALUES (265, 233, 595, 586);
INSERT INTO chado.cvterm_relationship VALUES (266, 233, 596, 586);
INSERT INTO chado.cvterm_relationship VALUES (267, 233, 597, 586);
INSERT INTO chado.cvterm_relationship VALUES (268, 233, 598, 586);
INSERT INTO chado.cvterm_relationship VALUES (269, 233, 599, 586);
INSERT INTO chado.cvterm_relationship VALUES (270, 233, 600, 586);
INSERT INTO chado.cvterm_relationship VALUES (271, 233, 601, 586);
INSERT INTO chado.cvterm_relationship VALUES (272, 233, 602, 586);
INSERT INTO chado.cvterm_relationship VALUES (273, 233, 603, 586);
INSERT INTO chado.cvterm_relationship VALUES (274, 233, 604, 586);
INSERT INTO chado.cvterm_relationship VALUES (275, 233, 605, 586);
INSERT INTO chado.cvterm_relationship VALUES (276, 233, 606, 586);
INSERT INTO chado.cvterm_relationship VALUES (277, 233, 607, 308);
INSERT INTO chado.cvterm_relationship VALUES (278, 233, 608, 308);
INSERT INTO chado.cvterm_relationship VALUES (279, 233, 609, 401);
INSERT INTO chado.cvterm_relationship VALUES (280, 238, 609, 472);
INSERT INTO chado.cvterm_relationship VALUES (281, 233, 186, 609);
INSERT INTO chado.cvterm_relationship VALUES (282, 233, 610, 372);
INSERT INTO chado.cvterm_relationship VALUES (283, 233, 610, 375);
INSERT INTO chado.cvterm_relationship VALUES (284, 256, 610, 344);
INSERT INTO chado.cvterm_relationship VALUES (285, 233, 611, 612);
INSERT INTO chado.cvterm_relationship VALUES (286, 233, 466, 613);
INSERT INTO chado.cvterm_relationship VALUES (287, 233, 614, 556);
INSERT INTO chado.cvterm_relationship VALUES (288, 233, 615, 616);
INSERT INTO chado.cvterm_relationship VALUES (289, 233, 617, 618);
INSERT INTO chado.cvterm_relationship VALUES (290, 256, 617, 619);
INSERT INTO chado.cvterm_relationship VALUES (291, 233, 620, 579);
INSERT INTO chado.cvterm_relationship VALUES (292, 233, 621, 579);
INSERT INTO chado.cvterm_relationship VALUES (293, 233, 622, 498);
INSERT INTO chado.cvterm_relationship VALUES (294, 233, 625, 626);
INSERT INTO chado.cvterm_relationship VALUES (295, 233, 583, 524);
INSERT INTO chado.cvterm_relationship VALUES (296, 233, 629, 630);
INSERT INTO chado.cvterm_relationship VALUES (297, 233, 632, 310);
INSERT INTO chado.cvterm_relationship VALUES (298, 238, 632, 585);
INSERT INTO chado.cvterm_relationship VALUES (299, 233, 633, 634);
INSERT INTO chado.cvterm_relationship VALUES (300, 238, 633, 586);
INSERT INTO chado.cvterm_relationship VALUES (301, 233, 635, 633);
INSERT INTO chado.cvterm_relationship VALUES (302, 238, 635, 587);
INSERT INTO chado.cvterm_relationship VALUES (303, 233, 636, 585);
INSERT INTO chado.cvterm_relationship VALUES (304, 233, 637, 633);
INSERT INTO chado.cvterm_relationship VALUES (305, 238, 637, 589);
INSERT INTO chado.cvterm_relationship VALUES (306, 233, 638, 633);
INSERT INTO chado.cvterm_relationship VALUES (307, 238, 638, 590);
INSERT INTO chado.cvterm_relationship VALUES (308, 233, 639, 633);
INSERT INTO chado.cvterm_relationship VALUES (309, 238, 639, 591);
INSERT INTO chado.cvterm_relationship VALUES (310, 233, 640, 633);
INSERT INTO chado.cvterm_relationship VALUES (311, 238, 640, 592);
INSERT INTO chado.cvterm_relationship VALUES (312, 233, 641, 633);
INSERT INTO chado.cvterm_relationship VALUES (313, 238, 641, 593);
INSERT INTO chado.cvterm_relationship VALUES (314, 233, 642, 633);
INSERT INTO chado.cvterm_relationship VALUES (315, 238, 642, 594);
INSERT INTO chado.cvterm_relationship VALUES (316, 233, 643, 633);
INSERT INTO chado.cvterm_relationship VALUES (317, 238, 643, 595);
INSERT INTO chado.cvterm_relationship VALUES (318, 233, 644, 633);
INSERT INTO chado.cvterm_relationship VALUES (319, 238, 644, 596);
INSERT INTO chado.cvterm_relationship VALUES (320, 233, 645, 633);
INSERT INTO chado.cvterm_relationship VALUES (321, 238, 645, 597);
INSERT INTO chado.cvterm_relationship VALUES (322, 233, 646, 633);
INSERT INTO chado.cvterm_relationship VALUES (323, 238, 646, 598);
INSERT INTO chado.cvterm_relationship VALUES (324, 233, 647, 633);
INSERT INTO chado.cvterm_relationship VALUES (325, 238, 647, 599);
INSERT INTO chado.cvterm_relationship VALUES (326, 233, 648, 633);
INSERT INTO chado.cvterm_relationship VALUES (327, 238, 648, 600);
INSERT INTO chado.cvterm_relationship VALUES (328, 233, 649, 633);
INSERT INTO chado.cvterm_relationship VALUES (329, 238, 649, 601);
INSERT INTO chado.cvterm_relationship VALUES (330, 233, 650, 633);
INSERT INTO chado.cvterm_relationship VALUES (331, 238, 650, 602);
INSERT INTO chado.cvterm_relationship VALUES (332, 233, 651, 633);
INSERT INTO chado.cvterm_relationship VALUES (333, 238, 651, 603);
INSERT INTO chado.cvterm_relationship VALUES (334, 233, 652, 633);
INSERT INTO chado.cvterm_relationship VALUES (335, 238, 652, 604);
INSERT INTO chado.cvterm_relationship VALUES (336, 233, 653, 633);
INSERT INTO chado.cvterm_relationship VALUES (337, 238, 653, 605);
INSERT INTO chado.cvterm_relationship VALUES (338, 233, 654, 633);
INSERT INTO chado.cvterm_relationship VALUES (339, 238, 654, 606);
INSERT INTO chado.cvterm_relationship VALUES (340, 233, 655, 634);
INSERT INTO chado.cvterm_relationship VALUES (341, 238, 655, 607);
INSERT INTO chado.cvterm_relationship VALUES (342, 233, 656, 634);
INSERT INTO chado.cvterm_relationship VALUES (343, 238, 656, 608);
INSERT INTO chado.cvterm_relationship VALUES (344, 233, 657, 658);
INSERT INTO chado.cvterm_relationship VALUES (345, 238, 657, 659);
INSERT INTO chado.cvterm_relationship VALUES (346, 233, 535, 613);
INSERT INTO chado.cvterm_relationship VALUES (347, 233, 660, 401);
INSERT INTO chado.cvterm_relationship VALUES (348, 252, 660, 661);
INSERT INTO chado.cvterm_relationship VALUES (349, 233, 662, 401);
INSERT INTO chado.cvterm_relationship VALUES (350, 252, 662, 663);
INSERT INTO chado.cvterm_relationship VALUES (351, 233, 664, 185);
INSERT INTO chado.cvterm_relationship VALUES (352, 233, 664, 665);
INSERT INTO chado.cvterm_relationship VALUES (353, 252, 664, 666);
INSERT INTO chado.cvterm_relationship VALUES (354, 233, 667, 664);
INSERT INTO chado.cvterm_relationship VALUES (355, 233, 667, 668);
INSERT INTO chado.cvterm_relationship VALUES (356, 233, 667, 669);
INSERT INTO chado.cvterm_relationship VALUES (357, 252, 667, 666);
INSERT INTO chado.cvterm_relationship VALUES (358, 252, 667, 670);
INSERT INTO chado.cvterm_relationship VALUES (359, 233, 671, 455);
INSERT INTO chado.cvterm_relationship VALUES (360, 252, 671, 672);
INSERT INTO chado.cvterm_relationship VALUES (361, 233, 673, 458);
INSERT INTO chado.cvterm_relationship VALUES (362, 233, 673, 667);
INSERT INTO chado.cvterm_relationship VALUES (363, 252, 673, 666);
INSERT INTO chado.cvterm_relationship VALUES (364, 252, 673, 670);
INSERT INTO chado.cvterm_relationship VALUES (365, 233, 668, 185);
INSERT INTO chado.cvterm_relationship VALUES (366, 252, 668, 670);
INSERT INTO chado.cvterm_relationship VALUES (367, 233, 675, 676);
INSERT INTO chado.cvterm_relationship VALUES (368, 256, 675, 560);
INSERT INTO chado.cvterm_relationship VALUES (369, 233, 677, 185);
INSERT INTO chado.cvterm_relationship VALUES (370, 252, 677, 678);
INSERT INTO chado.cvterm_relationship VALUES (371, 233, 679, 664);
INSERT INTO chado.cvterm_relationship VALUES (372, 233, 679, 677);
INSERT INTO chado.cvterm_relationship VALUES (373, 252, 679, 666);
INSERT INTO chado.cvterm_relationship VALUES (374, 233, 680, 294);
INSERT INTO chado.cvterm_relationship VALUES (375, 233, 681, 680);
INSERT INTO chado.cvterm_relationship VALUES (376, 233, 682, 680);
INSERT INTO chado.cvterm_relationship VALUES (377, 233, 684, 676);
INSERT INTO chado.cvterm_relationship VALUES (378, 233, 684, 669);
INSERT INTO chado.cvterm_relationship VALUES (379, 252, 684, 666);
INSERT INTO chado.cvterm_relationship VALUES (380, 252, 684, 670);
INSERT INTO chado.cvterm_relationship VALUES (381, 233, 685, 676);
INSERT INTO chado.cvterm_relationship VALUES (382, 233, 686, 559);
INSERT INTO chado.cvterm_relationship VALUES (383, 233, 687, 287);
INSERT INTO chado.cvterm_relationship VALUES (384, 256, 687, 520);
INSERT INTO chado.cvterm_relationship VALUES (385, 233, 688, 287);
INSERT INTO chado.cvterm_relationship VALUES (386, 233, 689, 287);
INSERT INTO chado.cvterm_relationship VALUES (387, 233, 690, 691);
INSERT INTO chado.cvterm_relationship VALUES (388, 233, 692, 690);
INSERT INTO chado.cvterm_relationship VALUES (389, 233, 693, 692);
INSERT INTO chado.cvterm_relationship VALUES (390, 233, 694, 695);
INSERT INTO chado.cvterm_relationship VALUES (391, 233, 696, 529);
INSERT INTO chado.cvterm_relationship VALUES (392, 233, 698, 630);
INSERT INTO chado.cvterm_relationship VALUES (393, 233, 698, 699);
INSERT INTO chado.cvterm_relationship VALUES (394, 233, 462, 698);
INSERT INTO chado.cvterm_relationship VALUES (395, 233, 700, 287);
INSERT INTO chado.cvterm_relationship VALUES (396, 233, 705, 706);
INSERT INTO chado.cvterm_relationship VALUES (397, 233, 707, 475);
INSERT INTO chado.cvterm_relationship VALUES (398, 233, 708, 676);
INSERT INTO chado.cvterm_relationship VALUES (399, 233, 709, 529);
INSERT INTO chado.cvterm_relationship VALUES (400, 233, 709, 710);
INSERT INTO chado.cvterm_relationship VALUES (401, 233, 449, 340);
INSERT INTO chado.cvterm_relationship VALUES (402, 233, 711, 350);
INSERT INTO chado.cvterm_relationship VALUES (403, 252, 711, 712);
INSERT INTO chado.cvterm_relationship VALUES (404, 233, 713, 507);
INSERT INTO chado.cvterm_relationship VALUES (405, 233, 714, 507);
INSERT INTO chado.cvterm_relationship VALUES (406, 233, 715, 716);
INSERT INTO chado.cvterm_relationship VALUES (407, 256, 715, 717);
INSERT INTO chado.cvterm_relationship VALUES (408, 233, 718, 455);
INSERT INTO chado.cvterm_relationship VALUES (409, 252, 718, 719);
INSERT INTO chado.cvterm_relationship VALUES (410, 233, 720, 721);
INSERT INTO chado.cvterm_relationship VALUES (411, 233, 720, 722);
INSERT INTO chado.cvterm_relationship VALUES (412, 233, 723, 724);
INSERT INTO chado.cvterm_relationship VALUES (413, 233, 725, 333);
INSERT INTO chado.cvterm_relationship VALUES (414, 233, 726, 585);
INSERT INTO chado.cvterm_relationship VALUES (415, 233, 727, 725);
INSERT INTO chado.cvterm_relationship VALUES (416, 233, 728, 724);
INSERT INTO chado.cvterm_relationship VALUES (417, 233, 729, 364);
INSERT INTO chado.cvterm_relationship VALUES (418, 233, 730, 455);
INSERT INTO chado.cvterm_relationship VALUES (419, 252, 730, 731);
INSERT INTO chado.cvterm_relationship VALUES (420, 233, 732, 347);
INSERT INTO chado.cvterm_relationship VALUES (421, 233, 733, 725);
INSERT INTO chado.cvterm_relationship VALUES (422, 233, 734, 732);
INSERT INTO chado.cvterm_relationship VALUES (423, 233, 735, 446);
INSERT INTO chado.cvterm_relationship VALUES (424, 256, 735, 609);
INSERT INTO chado.cvterm_relationship VALUES (425, 233, 736, 732);
INSERT INTO chado.cvterm_relationship VALUES (426, 233, 737, 455);
INSERT INTO chado.cvterm_relationship VALUES (427, 252, 737, 738);
INSERT INTO chado.cvterm_relationship VALUES (428, 233, 355, 287);
INSERT INTO chado.cvterm_relationship VALUES (429, 261, 355, 185);
INSERT INTO chado.cvterm_relationship VALUES (430, 233, 739, 740);
INSERT INTO chado.cvterm_relationship VALUES (431, 233, 741, 584);
INSERT INTO chado.cvterm_relationship VALUES (432, 233, 742, 689);
INSERT INTO chado.cvterm_relationship VALUES (433, 233, 743, 520);
INSERT INTO chado.cvterm_relationship VALUES (434, 233, 744, 451);
INSERT INTO chado.cvterm_relationship VALUES (435, 233, 745, 690);
INSERT INTO chado.cvterm_relationship VALUES (436, 233, 348, 347);
INSERT INTO chado.cvterm_relationship VALUES (437, 233, 716, 746);
INSERT INTO chado.cvterm_relationship VALUES (438, 233, 747, 725);
INSERT INTO chado.cvterm_relationship VALUES (439, 238, 747, 186);
INSERT INTO chado.cvterm_relationship VALUES (440, 233, 748, 749);
INSERT INTO chado.cvterm_relationship VALUES (441, 233, 444, 348);
INSERT INTO chado.cvterm_relationship VALUES (442, 233, 750, 751);
INSERT INTO chado.cvterm_relationship VALUES (443, 233, 752, 348);
INSERT INTO chado.cvterm_relationship VALUES (444, 233, 753, 754);
INSERT INTO chado.cvterm_relationship VALUES (445, 233, 755, 751);
INSERT INTO chado.cvterm_relationship VALUES (446, 233, 756, 750);
INSERT INTO chado.cvterm_relationship VALUES (447, 233, 514, 757);
INSERT INTO chado.cvterm_relationship VALUES (448, 233, 758, 721);
INSERT INTO chado.cvterm_relationship VALUES (449, 233, 759, 689);
INSERT INTO chado.cvterm_relationship VALUES (450, 233, 760, 750);
INSERT INTO chado.cvterm_relationship VALUES (451, 233, 761, 613);
INSERT INTO chado.cvterm_relationship VALUES (452, 233, 762, 761);
INSERT INTO chado.cvterm_relationship VALUES (453, 233, 507, 724);
INSERT INTO chado.cvterm_relationship VALUES (454, 233, 763, 761);
INSERT INTO chado.cvterm_relationship VALUES (455, 233, 764, 765);
INSERT INTO chado.cvterm_relationship VALUES (456, 233, 766, 767);
INSERT INTO chado.cvterm_relationship VALUES (457, 252, 766, 762);
INSERT INTO chado.cvterm_relationship VALUES (458, 233, 768, 615);
INSERT INTO chado.cvterm_relationship VALUES (459, 233, 769, 442);
INSERT INTO chado.cvterm_relationship VALUES (460, 233, 770, 446);
INSERT INTO chado.cvterm_relationship VALUES (461, 233, 771, 772);
INSERT INTO chado.cvterm_relationship VALUES (462, 256, 771, 769);
INSERT INTO chado.cvterm_relationship VALUES (463, 233, 773, 770);
INSERT INTO chado.cvterm_relationship VALUES (464, 233, 658, 634);
INSERT INTO chado.cvterm_relationship VALUES (465, 233, 775, 556);
INSERT INTO chado.cvterm_relationship VALUES (466, 233, 776, 310);
INSERT INTO chado.cvterm_relationship VALUES (467, 252, 776, 777);
INSERT INTO chado.cvterm_relationship VALUES (468, 233, 778, 779);
INSERT INTO chado.cvterm_relationship VALUES (469, 252, 778, 780);
INSERT INTO chado.cvterm_relationship VALUES (470, 233, 781, 776);
INSERT INTO chado.cvterm_relationship VALUES (471, 252, 781, 782);
INSERT INTO chado.cvterm_relationship VALUES (472, 233, 783, 784);
INSERT INTO chado.cvterm_relationship VALUES (473, 238, 783, 785);
INSERT INTO chado.cvterm_relationship VALUES (474, 233, 786, 658);
INSERT INTO chado.cvterm_relationship VALUES (475, 233, 787, 658);
INSERT INTO chado.cvterm_relationship VALUES (476, 233, 788, 658);
INSERT INTO chado.cvterm_relationship VALUES (477, 233, 789, 788);
INSERT INTO chado.cvterm_relationship VALUES (478, 233, 790, 321);
INSERT INTO chado.cvterm_relationship VALUES (479, 252, 790, 782);
INSERT INTO chado.cvterm_relationship VALUES (480, 233, 791, 792);
INSERT INTO chado.cvterm_relationship VALUES (481, 233, 793, 792);
INSERT INTO chado.cvterm_relationship VALUES (482, 233, 794, 795);
INSERT INTO chado.cvterm_relationship VALUES (483, 233, 796, 658);
INSERT INTO chado.cvterm_relationship VALUES (484, 233, 797, 776);
INSERT INTO chado.cvterm_relationship VALUES (485, 233, 798, 776);
INSERT INTO chado.cvterm_relationship VALUES (486, 233, 799, 658);
INSERT INTO chado.cvterm_relationship VALUES (487, 233, 800, 658);
INSERT INTO chado.cvterm_relationship VALUES (488, 233, 801, 658);
INSERT INTO chado.cvterm_relationship VALUES (489, 233, 802, 310);
INSERT INTO chado.cvterm_relationship VALUES (490, 233, 803, 655);
INSERT INTO chado.cvterm_relationship VALUES (491, 233, 804, 655);
INSERT INTO chado.cvterm_relationship VALUES (492, 233, 805, 655);
INSERT INTO chado.cvterm_relationship VALUES (493, 233, 806, 655);
INSERT INTO chado.cvterm_relationship VALUES (494, 233, 807, 655);
INSERT INTO chado.cvterm_relationship VALUES (495, 233, 808, 655);
INSERT INTO chado.cvterm_relationship VALUES (496, 233, 809, 655);
INSERT INTO chado.cvterm_relationship VALUES (497, 233, 810, 655);
INSERT INTO chado.cvterm_relationship VALUES (498, 233, 811, 655);
INSERT INTO chado.cvterm_relationship VALUES (499, 233, 305, 613);
INSERT INTO chado.cvterm_relationship VALUES (500, 233, 814, 815);
INSERT INTO chado.cvterm_relationship VALUES (501, 238, 814, 816);
INSERT INTO chado.cvterm_relationship VALUES (502, 233, 817, 310);
INSERT INTO chado.cvterm_relationship VALUES (503, 233, 818, 310);
INSERT INTO chado.cvterm_relationship VALUES (504, 233, 819, 562);
INSERT INTO chado.cvterm_relationship VALUES (505, 233, 820, 821);
INSERT INTO chado.cvterm_relationship VALUES (506, 238, 820, 822);
INSERT INTO chado.cvterm_relationship VALUES (507, 233, 824, 287);
INSERT INTO chado.cvterm_relationship VALUES (508, 233, 825, 824);
INSERT INTO chado.cvterm_relationship VALUES (509, 233, 826, 297);
INSERT INTO chado.cvterm_relationship VALUES (510, 252, 826, 827);
INSERT INTO chado.cvterm_relationship VALUES (511, 233, 568, 504);
INSERT INTO chado.cvterm_relationship VALUES (512, 233, 828, 829);
INSERT INTO chado.cvterm_relationship VALUES (513, 233, 830, 765);
INSERT INTO chado.cvterm_relationship VALUES (514, 233, 831, 765);
INSERT INTO chado.cvterm_relationship VALUES (515, 233, 832, 765);
INSERT INTO chado.cvterm_relationship VALUES (516, 233, 833, 834);
INSERT INTO chado.cvterm_relationship VALUES (517, 233, 833, 835);
INSERT INTO chado.cvterm_relationship VALUES (518, 233, 836, 837);
INSERT INTO chado.cvterm_relationship VALUES (519, 238, 836, 838);
INSERT INTO chado.cvterm_relationship VALUES (520, 256, 836, 839);
INSERT INTO chado.cvterm_relationship VALUES (521, 233, 840, 841);
INSERT INTO chado.cvterm_relationship VALUES (522, 238, 840, 842);
INSERT INTO chado.cvterm_relationship VALUES (523, 256, 840, 843);
INSERT INTO chado.cvterm_relationship VALUES (524, 233, 844, 845);
INSERT INTO chado.cvterm_relationship VALUES (525, 233, 846, 845);
INSERT INTO chado.cvterm_relationship VALUES (526, 233, 847, 848);
INSERT INTO chado.cvterm_relationship VALUES (527, 233, 849, 848);
INSERT INTO chado.cvterm_relationship VALUES (528, 233, 850, 848);
INSERT INTO chado.cvterm_relationship VALUES (529, 233, 851, 675);
INSERT INTO chado.cvterm_relationship VALUES (530, 233, 852, 675);
INSERT INTO chado.cvterm_relationship VALUES (531, 233, 853, 849);
INSERT INTO chado.cvterm_relationship VALUES (532, 233, 853, 854);
INSERT INTO chado.cvterm_relationship VALUES (533, 233, 855, 847);
INSERT INTO chado.cvterm_relationship VALUES (534, 233, 855, 854);
INSERT INTO chado.cvterm_relationship VALUES (535, 233, 856, 850);
INSERT INTO chado.cvterm_relationship VALUES (536, 233, 856, 854);
INSERT INTO chado.cvterm_relationship VALUES (537, 233, 857, 858);
INSERT INTO chado.cvterm_relationship VALUES (538, 233, 859, 858);
INSERT INTO chado.cvterm_relationship VALUES (539, 233, 860, 858);
INSERT INTO chado.cvterm_relationship VALUES (540, 233, 861, 676);
INSERT INTO chado.cvterm_relationship VALUES (541, 233, 861, 862);
INSERT INTO chado.cvterm_relationship VALUES (542, 256, 861, 563);
INSERT INTO chado.cvterm_relationship VALUES (543, 233, 863, 708);
INSERT INTO chado.cvterm_relationship VALUES (544, 238, 863, 441);
INSERT INTO chado.cvterm_relationship VALUES (545, 233, 864, 732);
INSERT INTO chado.cvterm_relationship VALUES (546, 256, 864, 560);
INSERT INTO chado.cvterm_relationship VALUES (547, 233, 865, 687);
INSERT INTO chado.cvterm_relationship VALUES (548, 233, 868, 869);
INSERT INTO chado.cvterm_relationship VALUES (549, 233, 868, 870);
INSERT INTO chado.cvterm_relationship VALUES (550, 233, 516, 520);
INSERT INTO chado.cvterm_relationship VALUES (551, 256, 516, 350);
INSERT INTO chado.cvterm_relationship VALUES (552, 233, 459, 333);
INSERT INTO chado.cvterm_relationship VALUES (553, 233, 740, 333);
INSERT INTO chado.cvterm_relationship VALUES (554, 233, 751, 812);
INSERT INTO chado.cvterm_relationship VALUES (555, 233, 871, 575);
INSERT INTO chado.cvterm_relationship VALUES (556, 233, 872, 575);
INSERT INTO chado.cvterm_relationship VALUES (557, 233, 873, 562);
INSERT INTO chado.cvterm_relationship VALUES (558, 233, 874, 873);
INSERT INTO chado.cvterm_relationship VALUES (559, 233, 875, 873);
INSERT INTO chado.cvterm_relationship VALUES (560, 233, 876, 755);
INSERT INTO chado.cvterm_relationship VALUES (561, 233, 877, 451);
INSERT INTO chado.cvterm_relationship VALUES (562, 233, 878, 879);
INSERT INTO chado.cvterm_relationship VALUES (563, 277, 878, 880);
INSERT INTO chado.cvterm_relationship VALUES (564, 233, 882, 387);
INSERT INTO chado.cvterm_relationship VALUES (565, 233, 883, 884);
INSERT INTO chado.cvterm_relationship VALUES (566, 233, 885, 879);
INSERT INTO chado.cvterm_relationship VALUES (567, 252, 885, 456);
INSERT INTO chado.cvterm_relationship VALUES (568, 233, 779, 185);
INSERT INTO chado.cvterm_relationship VALUES (569, 252, 779, 886);
INSERT INTO chado.cvterm_relationship VALUES (570, 233, 887, 888);
INSERT INTO chado.cvterm_relationship VALUES (571, 233, 889, 890);
INSERT INTO chado.cvterm_relationship VALUES (572, 233, 891, 185);
INSERT INTO chado.cvterm_relationship VALUES (573, 277, 891, 892);
INSERT INTO chado.cvterm_relationship VALUES (574, 233, 890, 693);
INSERT INTO chado.cvterm_relationship VALUES (575, 233, 893, 380);
INSERT INTO chado.cvterm_relationship VALUES (576, 233, 894, 287);
INSERT INTO chado.cvterm_relationship VALUES (577, 233, 895, 305);
INSERT INTO chado.cvterm_relationship VALUES (578, 233, 896, 894);
INSERT INTO chado.cvterm_relationship VALUES (579, 261, 896, 509);
INSERT INTO chado.cvterm_relationship VALUES (580, 233, 897, 380);
INSERT INTO chado.cvterm_relationship VALUES (581, 233, 897, 898);
INSERT INTO chado.cvterm_relationship VALUES (582, 233, 899, 890);
INSERT INTO chado.cvterm_relationship VALUES (583, 233, 900, 486);
INSERT INTO chado.cvterm_relationship VALUES (584, 233, 901, 504);
INSERT INTO chado.cvterm_relationship VALUES (585, 256, 901, 902);
INSERT INTO chado.cvterm_relationship VALUES (586, 233, 903, 486);
INSERT INTO chado.cvterm_relationship VALUES (587, 233, 904, 890);
INSERT INTO chado.cvterm_relationship VALUES (588, 233, 905, 476);
INSERT INTO chado.cvterm_relationship VALUES (589, 233, 906, 514);
INSERT INTO chado.cvterm_relationship VALUES (590, 233, 907, 479);
INSERT INTO chado.cvterm_relationship VALUES (591, 233, 907, 905);
INSERT INTO chado.cvterm_relationship VALUES (592, 233, 908, 504);
INSERT INTO chado.cvterm_relationship VALUES (593, 256, 908, 906);
INSERT INTO chado.cvterm_relationship VALUES (594, 233, 909, 478);
INSERT INTO chado.cvterm_relationship VALUES (595, 233, 909, 905);
INSERT INTO chado.cvterm_relationship VALUES (596, 233, 910, 299);
INSERT INTO chado.cvterm_relationship VALUES (597, 233, 912, 890);
INSERT INTO chado.cvterm_relationship VALUES (598, 233, 892, 401);
INSERT INTO chado.cvterm_relationship VALUES (599, 252, 892, 913);
INSERT INTO chado.cvterm_relationship VALUES (600, 233, 914, 350);
INSERT INTO chado.cvterm_relationship VALUES (601, 233, 914, 908);
INSERT INTO chado.cvterm_relationship VALUES (602, 233, 845, 685);
INSERT INTO chado.cvterm_relationship VALUES (603, 256, 845, 584);
INSERT INTO chado.cvterm_relationship VALUES (604, 233, 915, 693);
INSERT INTO chado.cvterm_relationship VALUES (605, 233, 308, 472);
INSERT INTO chado.cvterm_relationship VALUES (606, 233, 916, 917);
INSERT INTO chado.cvterm_relationship VALUES (607, 256, 916, 574);
INSERT INTO chado.cvterm_relationship VALUES (608, 233, 918, 919);
INSERT INTO chado.cvterm_relationship VALUES (609, 250, 918, 904);
INSERT INTO chado.cvterm_relationship VALUES (610, 250, 918, 920);
INSERT INTO chado.cvterm_relationship VALUES (611, 233, 921, 917);
INSERT INTO chado.cvterm_relationship VALUES (612, 256, 921, 572);
INSERT INTO chado.cvterm_relationship VALUES (613, 233, 922, 919);
INSERT INTO chado.cvterm_relationship VALUES (614, 250, 922, 904);
INSERT INTO chado.cvterm_relationship VALUES (615, 250, 922, 912);
INSERT INTO chado.cvterm_relationship VALUES (616, 250, 922, 923);
INSERT INTO chado.cvterm_relationship VALUES (617, 233, 924, 919);
INSERT INTO chado.cvterm_relationship VALUES (618, 250, 924, 904);
INSERT INTO chado.cvterm_relationship VALUES (619, 250, 924, 923);
INSERT INTO chado.cvterm_relationship VALUES (620, 233, 925, 919);
INSERT INTO chado.cvterm_relationship VALUES (621, 250, 925, 912);
INSERT INTO chado.cvterm_relationship VALUES (622, 250, 925, 926);
INSERT INTO chado.cvterm_relationship VALUES (623, 233, 927, 919);
INSERT INTO chado.cvterm_relationship VALUES (624, 250, 927, 904);
INSERT INTO chado.cvterm_relationship VALUES (625, 250, 927, 912);
INSERT INTO chado.cvterm_relationship VALUES (626, 250, 927, 926);
INSERT INTO chado.cvterm_relationship VALUES (627, 233, 928, 919);
INSERT INTO chado.cvterm_relationship VALUES (628, 250, 928, 904);
INSERT INTO chado.cvterm_relationship VALUES (629, 250, 928, 926);
INSERT INTO chado.cvterm_relationship VALUES (630, 233, 929, 695);
INSERT INTO chado.cvterm_relationship VALUES (631, 233, 930, 931);
INSERT INTO chado.cvterm_relationship VALUES (632, 256, 930, 932);
INSERT INTO chado.cvterm_relationship VALUES (633, 233, 933, 934);
INSERT INTO chado.cvterm_relationship VALUES (634, 256, 933, 932);
INSERT INTO chado.cvterm_relationship VALUES (635, 233, 935, 936);
INSERT INTO chado.cvterm_relationship VALUES (636, 256, 935, 932);
INSERT INTO chado.cvterm_relationship VALUES (637, 233, 937, 931);
INSERT INTO chado.cvterm_relationship VALUES (638, 256, 937, 938);
INSERT INTO chado.cvterm_relationship VALUES (639, 233, 939, 934);
INSERT INTO chado.cvterm_relationship VALUES (640, 256, 939, 938);
INSERT INTO chado.cvterm_relationship VALUES (641, 233, 940, 936);
INSERT INTO chado.cvterm_relationship VALUES (642, 256, 940, 938);
INSERT INTO chado.cvterm_relationship VALUES (643, 233, 941, 514);
INSERT INTO chado.cvterm_relationship VALUES (644, 233, 942, 329);
INSERT INTO chado.cvterm_relationship VALUES (645, 233, 943, 329);
INSERT INTO chado.cvterm_relationship VALUES (646, 233, 946, 919);
INSERT INTO chado.cvterm_relationship VALUES (647, 250, 946, 889);
INSERT INTO chado.cvterm_relationship VALUES (648, 250, 946, 912);
INSERT INTO chado.cvterm_relationship VALUES (649, 250, 946, 920);
INSERT INTO chado.cvterm_relationship VALUES (650, 233, 947, 919);
INSERT INTO chado.cvterm_relationship VALUES (651, 250, 947, 889);
INSERT INTO chado.cvterm_relationship VALUES (652, 250, 947, 920);
INSERT INTO chado.cvterm_relationship VALUES (653, 233, 948, 919);
INSERT INTO chado.cvterm_relationship VALUES (654, 250, 948, 889);
INSERT INTO chado.cvterm_relationship VALUES (655, 250, 948, 904);
INSERT INTO chado.cvterm_relationship VALUES (656, 250, 948, 912);
INSERT INTO chado.cvterm_relationship VALUES (657, 250, 948, 920);
INSERT INTO chado.cvterm_relationship VALUES (658, 233, 949, 894);
INSERT INTO chado.cvterm_relationship VALUES (659, 261, 949, 509);
INSERT INTO chado.cvterm_relationship VALUES (660, 256, 949, 950);
INSERT INTO chado.cvterm_relationship VALUES (661, 233, 951, 919);
INSERT INTO chado.cvterm_relationship VALUES (662, 250, 951, 889);
INSERT INTO chado.cvterm_relationship VALUES (663, 250, 951, 904);
INSERT INTO chado.cvterm_relationship VALUES (664, 250, 951, 920);
INSERT INTO chado.cvterm_relationship VALUES (665, 233, 952, 915);
INSERT INTO chado.cvterm_relationship VALUES (666, 250, 952, 889);
INSERT INTO chado.cvterm_relationship VALUES (667, 250, 952, 904);
INSERT INTO chado.cvterm_relationship VALUES (668, 250, 952, 912);
INSERT INTO chado.cvterm_relationship VALUES (669, 233, 953, 954);
INSERT INTO chado.cvterm_relationship VALUES (670, 233, 955, 915);
INSERT INTO chado.cvterm_relationship VALUES (671, 250, 955, 904);
INSERT INTO chado.cvterm_relationship VALUES (672, 250, 955, 912);
INSERT INTO chado.cvterm_relationship VALUES (673, 233, 956, 380);
INSERT INTO chado.cvterm_relationship VALUES (674, 233, 957, 915);
INSERT INTO chado.cvterm_relationship VALUES (675, 250, 957, 904);
INSERT INTO chado.cvterm_relationship VALUES (676, 233, 958, 934);
INSERT INTO chado.cvterm_relationship VALUES (677, 256, 958, 694);
INSERT INTO chado.cvterm_relationship VALUES (678, 233, 959, 931);
INSERT INTO chado.cvterm_relationship VALUES (679, 256, 959, 694);
INSERT INTO chado.cvterm_relationship VALUES (680, 233, 950, 894);
INSERT INTO chado.cvterm_relationship VALUES (681, 261, 950, 401);
INSERT INTO chado.cvterm_relationship VALUES (682, 256, 950, 355);
INSERT INTO chado.cvterm_relationship VALUES (683, 233, 960, 936);
INSERT INTO chado.cvterm_relationship VALUES (684, 256, 960, 694);
INSERT INTO chado.cvterm_relationship VALUES (685, 233, 961, 919);
INSERT INTO chado.cvterm_relationship VALUES (686, 250, 961, 899);
INSERT INTO chado.cvterm_relationship VALUES (687, 250, 961, 920);
INSERT INTO chado.cvterm_relationship VALUES (688, 233, 962, 919);
INSERT INTO chado.cvterm_relationship VALUES (689, 250, 962, 899);
INSERT INTO chado.cvterm_relationship VALUES (690, 250, 962, 904);
INSERT INTO chado.cvterm_relationship VALUES (691, 250, 962, 920);
INSERT INTO chado.cvterm_relationship VALUES (692, 233, 963, 919);
INSERT INTO chado.cvterm_relationship VALUES (693, 250, 963, 899);
INSERT INTO chado.cvterm_relationship VALUES (694, 250, 963, 912);
INSERT INTO chado.cvterm_relationship VALUES (695, 250, 963, 923);
INSERT INTO chado.cvterm_relationship VALUES (696, 233, 964, 919);
INSERT INTO chado.cvterm_relationship VALUES (697, 250, 964, 899);
INSERT INTO chado.cvterm_relationship VALUES (698, 250, 964, 923);
INSERT INTO chado.cvterm_relationship VALUES (699, 233, 965, 919);
INSERT INTO chado.cvterm_relationship VALUES (700, 250, 965, 899);
INSERT INTO chado.cvterm_relationship VALUES (701, 250, 965, 904);
INSERT INTO chado.cvterm_relationship VALUES (702, 250, 965, 923);
INSERT INTO chado.cvterm_relationship VALUES (703, 233, 966, 919);
INSERT INTO chado.cvterm_relationship VALUES (704, 250, 966, 899);
INSERT INTO chado.cvterm_relationship VALUES (705, 250, 966, 912);
INSERT INTO chado.cvterm_relationship VALUES (706, 250, 966, 926);
INSERT INTO chado.cvterm_relationship VALUES (707, 233, 967, 919);
INSERT INTO chado.cvterm_relationship VALUES (708, 250, 967, 899);
INSERT INTO chado.cvterm_relationship VALUES (709, 250, 967, 926);
INSERT INTO chado.cvterm_relationship VALUES (710, 233, 968, 919);
INSERT INTO chado.cvterm_relationship VALUES (711, 250, 968, 899);
INSERT INTO chado.cvterm_relationship VALUES (712, 250, 968, 904);
INSERT INTO chado.cvterm_relationship VALUES (713, 250, 968, 926);
INSERT INTO chado.cvterm_relationship VALUES (714, 233, 969, 915);
INSERT INTO chado.cvterm_relationship VALUES (715, 250, 969, 899);
INSERT INTO chado.cvterm_relationship VALUES (716, 233, 970, 919);
INSERT INTO chado.cvterm_relationship VALUES (717, 250, 970, 889);
INSERT INTO chado.cvterm_relationship VALUES (718, 250, 970, 899);
INSERT INTO chado.cvterm_relationship VALUES (719, 250, 970, 912);
INSERT INTO chado.cvterm_relationship VALUES (720, 250, 970, 920);
INSERT INTO chado.cvterm_relationship VALUES (721, 233, 971, 919);
INSERT INTO chado.cvterm_relationship VALUES (722, 250, 971, 889);
INSERT INTO chado.cvterm_relationship VALUES (723, 250, 971, 899);
INSERT INTO chado.cvterm_relationship VALUES (724, 250, 971, 920);
INSERT INTO chado.cvterm_relationship VALUES (725, 233, 972, 919);
INSERT INTO chado.cvterm_relationship VALUES (726, 250, 972, 889);
INSERT INTO chado.cvterm_relationship VALUES (727, 250, 972, 899);
INSERT INTO chado.cvterm_relationship VALUES (728, 250, 972, 904);
INSERT INTO chado.cvterm_relationship VALUES (729, 250, 972, 912);
INSERT INTO chado.cvterm_relationship VALUES (730, 250, 972, 920);
INSERT INTO chado.cvterm_relationship VALUES (731, 233, 973, 919);
INSERT INTO chado.cvterm_relationship VALUES (732, 250, 973, 889);
INSERT INTO chado.cvterm_relationship VALUES (733, 250, 973, 899);
INSERT INTO chado.cvterm_relationship VALUES (734, 250, 973, 904);
INSERT INTO chado.cvterm_relationship VALUES (735, 250, 973, 920);
INSERT INTO chado.cvterm_relationship VALUES (736, 233, 974, 919);
INSERT INTO chado.cvterm_relationship VALUES (737, 250, 974, 889);
INSERT INTO chado.cvterm_relationship VALUES (738, 250, 974, 899);
INSERT INTO chado.cvterm_relationship VALUES (739, 250, 974, 904);
INSERT INTO chado.cvterm_relationship VALUES (740, 250, 974, 912);
INSERT INTO chado.cvterm_relationship VALUES (741, 233, 975, 919);
INSERT INTO chado.cvterm_relationship VALUES (742, 250, 975, 889);
INSERT INTO chado.cvterm_relationship VALUES (743, 250, 975, 899);
INSERT INTO chado.cvterm_relationship VALUES (744, 250, 975, 904);
INSERT INTO chado.cvterm_relationship VALUES (745, 233, 976, 931);
INSERT INTO chado.cvterm_relationship VALUES (746, 256, 976, 977);
INSERT INTO chado.cvterm_relationship VALUES (747, 233, 978, 915);
INSERT INTO chado.cvterm_relationship VALUES (748, 250, 978, 899);
INSERT INTO chado.cvterm_relationship VALUES (749, 250, 978, 904);
INSERT INTO chado.cvterm_relationship VALUES (750, 233, 979, 915);
INSERT INTO chado.cvterm_relationship VALUES (751, 250, 979, 899);
INSERT INTO chado.cvterm_relationship VALUES (752, 250, 979, 904);
INSERT INTO chado.cvterm_relationship VALUES (753, 250, 979, 912);
INSERT INTO chado.cvterm_relationship VALUES (754, 233, 980, 934);
INSERT INTO chado.cvterm_relationship VALUES (755, 256, 980, 977);
INSERT INTO chado.cvterm_relationship VALUES (756, 233, 981, 936);
INSERT INTO chado.cvterm_relationship VALUES (757, 256, 981, 977);
INSERT INTO chado.cvterm_relationship VALUES (758, 233, 977, 695);
INSERT INTO chado.cvterm_relationship VALUES (759, 233, 982, 919);
INSERT INTO chado.cvterm_relationship VALUES (760, 250, 982, 912);
INSERT INTO chado.cvterm_relationship VALUES (761, 250, 982, 920);
INSERT INTO chado.cvterm_relationship VALUES (762, 233, 983, 919);
INSERT INTO chado.cvterm_relationship VALUES (763, 250, 983, 904);
INSERT INTO chado.cvterm_relationship VALUES (764, 250, 983, 912);
INSERT INTO chado.cvterm_relationship VALUES (765, 250, 983, 920);
INSERT INTO chado.cvterm_relationship VALUES (766, 233, 984, 919);
INSERT INTO chado.cvterm_relationship VALUES (767, 250, 984, 912);
INSERT INTO chado.cvterm_relationship VALUES (768, 250, 984, 923);
INSERT INTO chado.cvterm_relationship VALUES (769, 233, 985, 919);
INSERT INTO chado.cvterm_relationship VALUES (770, 250, 985, 899);
INSERT INTO chado.cvterm_relationship VALUES (771, 250, 985, 912);
INSERT INTO chado.cvterm_relationship VALUES (772, 250, 985, 920);
INSERT INTO chado.cvterm_relationship VALUES (773, 233, 987, 556);
INSERT INTO chado.cvterm_relationship VALUES (774, 233, 988, 989);
INSERT INTO chado.cvterm_relationship VALUES (775, 256, 988, 990);
INSERT INTO chado.cvterm_relationship VALUES (776, 233, 991, 755);
INSERT INTO chado.cvterm_relationship VALUES (777, 233, 992, 898);
INSERT INTO chado.cvterm_relationship VALUES (778, 233, 993, 879);
INSERT INTO chado.cvterm_relationship VALUES (779, 277, 993, 994);
INSERT INTO chado.cvterm_relationship VALUES (780, 233, 995, 898);
INSERT INTO chado.cvterm_relationship VALUES (781, 233, 996, 387);
INSERT INTO chado.cvterm_relationship VALUES (782, 233, 997, 372);
INSERT INTO chado.cvterm_relationship VALUES (783, 233, 998, 498);
INSERT INTO chado.cvterm_relationship VALUES (784, 233, 999, 446);
INSERT INTO chado.cvterm_relationship VALUES (785, 256, 999, 580);
INSERT INTO chado.cvterm_relationship VALUES (786, 256, 999, 609);
INSERT INTO chado.cvterm_relationship VALUES (787, 233, 1001, 696);
INSERT INTO chado.cvterm_relationship VALUES (788, 233, 938, 929);
INSERT INTO chado.cvterm_relationship VALUES (789, 233, 1002, 696);
INSERT INTO chado.cvterm_relationship VALUES (790, 233, 1003, 915);
INSERT INTO chado.cvterm_relationship VALUES (791, 250, 1003, 912);
INSERT INTO chado.cvterm_relationship VALUES (792, 233, 1004, 915);
INSERT INTO chado.cvterm_relationship VALUES (793, 250, 1004, 889);
INSERT INTO chado.cvterm_relationship VALUES (794, 233, 1005, 915);
INSERT INTO chado.cvterm_relationship VALUES (795, 250, 1005, 889);
INSERT INTO chado.cvterm_relationship VALUES (796, 250, 1005, 904);
INSERT INTO chado.cvterm_relationship VALUES (797, 233, 931, 695);
INSERT INTO chado.cvterm_relationship VALUES (798, 233, 934, 695);
INSERT INTO chado.cvterm_relationship VALUES (799, 233, 936, 693);
INSERT INTO chado.cvterm_relationship VALUES (800, 233, 1006, 919);
INSERT INTO chado.cvterm_relationship VALUES (801, 250, 1006, 899);
INSERT INTO chado.cvterm_relationship VALUES (802, 250, 1006, 904);
INSERT INTO chado.cvterm_relationship VALUES (803, 250, 1006, 912);
INSERT INTO chado.cvterm_relationship VALUES (804, 250, 1006, 920);
INSERT INTO chado.cvterm_relationship VALUES (805, 233, 1007, 919);
INSERT INTO chado.cvterm_relationship VALUES (806, 250, 1007, 899);
INSERT INTO chado.cvterm_relationship VALUES (807, 250, 1007, 904);
INSERT INTO chado.cvterm_relationship VALUES (808, 250, 1007, 912);
INSERT INTO chado.cvterm_relationship VALUES (809, 250, 1007, 923);
INSERT INTO chado.cvterm_relationship VALUES (810, 233, 1008, 919);
INSERT INTO chado.cvterm_relationship VALUES (811, 250, 1008, 899);
INSERT INTO chado.cvterm_relationship VALUES (812, 250, 1008, 904);
INSERT INTO chado.cvterm_relationship VALUES (813, 250, 1008, 912);
INSERT INTO chado.cvterm_relationship VALUES (814, 250, 1008, 926);
INSERT INTO chado.cvterm_relationship VALUES (815, 233, 1009, 996);
INSERT INTO chado.cvterm_relationship VALUES (816, 233, 1010, 318);
INSERT INTO chado.cvterm_relationship VALUES (817, 233, 1011, 613);
INSERT INTO chado.cvterm_relationship VALUES (818, 233, 932, 929);
INSERT INTO chado.cvterm_relationship VALUES (819, 233, 1012, 306);
INSERT INTO chado.cvterm_relationship VALUES (820, 233, 920, 954);
INSERT INTO chado.cvterm_relationship VALUES (821, 233, 1013, 306);
INSERT INTO chado.cvterm_relationship VALUES (822, 233, 923, 954);
INSERT INTO chado.cvterm_relationship VALUES (823, 233, 1014, 306);
INSERT INTO chado.cvterm_relationship VALUES (824, 233, 926, 954);
INSERT INTO chado.cvterm_relationship VALUES (825, 233, 1015, 1016);
INSERT INTO chado.cvterm_relationship VALUES (826, 233, 1017, 306);
INSERT INTO chado.cvterm_relationship VALUES (827, 233, 1018, 510);
INSERT INTO chado.cvterm_relationship VALUES (828, 233, 1019, 608);
INSERT INTO chado.cvterm_relationship VALUES (829, 233, 1020, 287);
INSERT INTO chado.cvterm_relationship VALUES (830, 233, 1021, 608);
INSERT INTO chado.cvterm_relationship VALUES (831, 233, 1022, 1018);
INSERT INTO chado.cvterm_relationship VALUES (832, 233, 1023, 658);
INSERT INTO chado.cvterm_relationship VALUES (833, 233, 1024, 1017);
INSERT INTO chado.cvterm_relationship VALUES (834, 233, 1025, 308);
INSERT INTO chado.cvterm_relationship VALUES (835, 233, 1026, 1027);
INSERT INTO chado.cvterm_relationship VALUES (836, 233, 1027, 562);
INSERT INTO chado.cvterm_relationship VALUES (837, 252, 1027, 782);
INSERT INTO chado.cvterm_relationship VALUES (838, 233, 1028, 308);
INSERT INTO chado.cvterm_relationship VALUES (839, 233, 1029, 310);
INSERT INTO chado.cvterm_relationship VALUES (840, 238, 1029, 1028);
INSERT INTO chado.cvterm_relationship VALUES (841, 233, 989, 286);
INSERT INTO chado.cvterm_relationship VALUES (842, 233, 1030, 989);
INSERT INTO chado.cvterm_relationship VALUES (843, 233, 815, 656);
INSERT INTO chado.cvterm_relationship VALUES (844, 238, 815, 1031);
INSERT INTO chado.cvterm_relationship VALUES (845, 233, 1032, 656);
INSERT INTO chado.cvterm_relationship VALUES (846, 238, 1032, 1033);
INSERT INTO chado.cvterm_relationship VALUES (847, 233, 1031, 608);
INSERT INTO chado.cvterm_relationship VALUES (848, 233, 1033, 608);
INSERT INTO chado.cvterm_relationship VALUES (849, 233, 1039, 310);
INSERT INTO chado.cvterm_relationship VALUES (850, 233, 792, 1027);
INSERT INTO chado.cvterm_relationship VALUES (851, 233, 1040, 1018);
INSERT INTO chado.cvterm_relationship VALUES (852, 233, 1041, 287);
INSERT INTO chado.cvterm_relationship VALUES (853, 233, 1042, 1018);
INSERT INTO chado.cvterm_relationship VALUES (854, 233, 1043, 1018);
INSERT INTO chado.cvterm_relationship VALUES (855, 233, 1044, 1017);
INSERT INTO chado.cvterm_relationship VALUES (856, 233, 1045, 287);
INSERT INTO chado.cvterm_relationship VALUES (857, 230, 1045, 1039);
INSERT INTO chado.cvterm_relationship VALUES (858, 233, 1046, 287);
INSERT INTO chado.cvterm_relationship VALUES (859, 230, 1046, 186);
INSERT INTO chado.cvterm_relationship VALUES (860, 233, 1047, 717);
INSERT INTO chado.cvterm_relationship VALUES (861, 233, 1048, 717);
INSERT INTO chado.cvterm_relationship VALUES (862, 233, 1049, 1050);
INSERT INTO chado.cvterm_relationship VALUES (863, 233, 1051, 502);
INSERT INTO chado.cvterm_relationship VALUES (864, 233, 1052, 1053);
INSERT INTO chado.cvterm_relationship VALUES (865, 233, 1054, 529);
INSERT INTO chado.cvterm_relationship VALUES (866, 233, 1055, 541);
INSERT INTO chado.cvterm_relationship VALUES (867, 233, 1056, 541);
INSERT INTO chado.cvterm_relationship VALUES (868, 233, 1057, 312);
INSERT INTO chado.cvterm_relationship VALUES (869, 233, 1058, 312);
INSERT INTO chado.cvterm_relationship VALUES (870, 256, 1058, 1056);
INSERT INTO chado.cvterm_relationship VALUES (871, 233, 1059, 541);
INSERT INTO chado.cvterm_relationship VALUES (872, 233, 1060, 312);
INSERT INTO chado.cvterm_relationship VALUES (873, 256, 1060, 1055);
INSERT INTO chado.cvterm_relationship VALUES (874, 233, 1061, 306);
INSERT INTO chado.cvterm_relationship VALUES (875, 233, 1062, 1016);
INSERT INTO chado.cvterm_relationship VALUES (876, 233, 1063, 344);
INSERT INTO chado.cvterm_relationship VALUES (877, 233, 342, 451);
INSERT INTO chado.cvterm_relationship VALUES (878, 233, 1064, 344);
INSERT INTO chado.cvterm_relationship VALUES (879, 233, 1016, 451);
INSERT INTO chado.cvterm_relationship VALUES (880, 233, 1065, 340);
INSERT INTO chado.cvterm_relationship VALUES (881, 256, 1065, 499);
INSERT INTO chado.cvterm_relationship VALUES (882, 233, 1066, 1067);
INSERT INTO chado.cvterm_relationship VALUES (883, 256, 1066, 579);
INSERT INTO chado.cvterm_relationship VALUES (884, 233, 1068, 400);
INSERT INTO chado.cvterm_relationship VALUES (885, 233, 1068, 472);
INSERT INTO chado.cvterm_relationship VALUES (886, 252, 1068, 402);
INSERT INTO chado.cvterm_relationship VALUES (887, 233, 1069, 472);
INSERT INTO chado.cvterm_relationship VALUES (888, 233, 1069, 1070);
INSERT INTO chado.cvterm_relationship VALUES (889, 252, 1069, 1071);
INSERT INTO chado.cvterm_relationship VALUES (890, 233, 1072, 186);
INSERT INTO chado.cvterm_relationship VALUES (891, 233, 1072, 1070);
INSERT INTO chado.cvterm_relationship VALUES (892, 252, 1072, 1071);
INSERT INTO chado.cvterm_relationship VALUES (893, 233, 1073, 400);
INSERT INTO chado.cvterm_relationship VALUES (894, 233, 1073, 186);
INSERT INTO chado.cvterm_relationship VALUES (895, 252, 1073, 402);
INSERT INTO chado.cvterm_relationship VALUES (896, 233, 1074, 472);
INSERT INTO chado.cvterm_relationship VALUES (897, 233, 1075, 529);
INSERT INTO chado.cvterm_relationship VALUES (898, 256, 1075, 1074);
INSERT INTO chado.cvterm_relationship VALUES (899, 233, 1076, 519);
INSERT INTO chado.cvterm_relationship VALUES (900, 233, 1076, 665);
INSERT INTO chado.cvterm_relationship VALUES (901, 252, 1076, 666);
INSERT INTO chado.cvterm_relationship VALUES (902, 233, 1077, 1078);
INSERT INTO chado.cvterm_relationship VALUES (903, 233, 1079, 1077);
INSERT INTO chado.cvterm_relationship VALUES (904, 233, 1080, 1077);
INSERT INTO chado.cvterm_relationship VALUES (905, 233, 1081, 680);
INSERT INTO chado.cvterm_relationship VALUES (906, 233, 1082, 306);
INSERT INTO chado.cvterm_relationship VALUES (907, 233, 1083, 294);
INSERT INTO chado.cvterm_relationship VALUES (908, 233, 795, 310);
INSERT INTO chado.cvterm_relationship VALUES (909, 238, 795, 1084);
INSERT INTO chado.cvterm_relationship VALUES (910, 233, 1084, 472);
INSERT INTO chado.cvterm_relationship VALUES (911, 233, 1085, 658);
INSERT INTO chado.cvterm_relationship VALUES (912, 233, 1086, 308);
INSERT INTO chado.cvterm_relationship VALUES (913, 250, 1086, 659);
INSERT INTO chado.cvterm_relationship VALUES (914, 233, 821, 1087);
INSERT INTO chado.cvterm_relationship VALUES (915, 238, 821, 636);
INSERT INTO chado.cvterm_relationship VALUES (916, 233, 784, 1087);
INSERT INTO chado.cvterm_relationship VALUES (917, 238, 784, 726);
INSERT INTO chado.cvterm_relationship VALUES (918, 233, 1088, 784);
INSERT INTO chado.cvterm_relationship VALUES (919, 238, 1088, 1089);
INSERT INTO chado.cvterm_relationship VALUES (920, 233, 1090, 784);
INSERT INTO chado.cvterm_relationship VALUES (921, 238, 1090, 1091);
INSERT INTO chado.cvterm_relationship VALUES (922, 233, 1092, 417);
INSERT INTO chado.cvterm_relationship VALUES (923, 256, 1092, 1093);
INSERT INTO chado.cvterm_relationship VALUES (924, 233, 310, 609);
INSERT INTO chado.cvterm_relationship VALUES (925, 233, 1094, 306);
INSERT INTO chado.cvterm_relationship VALUES (926, 233, 676, 287);
INSERT INTO chado.cvterm_relationship VALUES (927, 250, 676, 1095);
INSERT INTO chado.cvterm_relationship VALUES (928, 233, 1096, 676);
INSERT INTO chado.cvterm_relationship VALUES (929, 233, 1097, 306);
INSERT INTO chado.cvterm_relationship VALUES (930, 233, 559, 562);
INSERT INTO chado.cvterm_relationship VALUES (931, 233, 1100, 306);
INSERT INTO chado.cvterm_relationship VALUES (932, 233, 1101, 451);
INSERT INTO chado.cvterm_relationship VALUES (933, 233, 1070, 401);
INSERT INTO chado.cvterm_relationship VALUES (934, 252, 1070, 1071);
INSERT INTO chado.cvterm_relationship VALUES (935, 233, 1102, 562);
INSERT INTO chado.cvterm_relationship VALUES (936, 233, 1102, 1103);
INSERT INTO chado.cvterm_relationship VALUES (937, 252, 1102, 1104);
INSERT INTO chado.cvterm_relationship VALUES (938, 233, 1105, 524);
INSERT INTO chado.cvterm_relationship VALUES (939, 233, 1105, 287);
INSERT INTO chado.cvterm_relationship VALUES (940, 233, 1106, 443);
INSERT INTO chado.cvterm_relationship VALUES (941, 233, 691, 689);
INSERT INTO chado.cvterm_relationship VALUES (942, 233, 1107, 691);
INSERT INTO chado.cvterm_relationship VALUES (943, 233, 1108, 691);
INSERT INTO chado.cvterm_relationship VALUES (944, 233, 1109, 691);
INSERT INTO chado.cvterm_relationship VALUES (945, 233, 401, 1110);
INSERT INTO chado.cvterm_relationship VALUES (946, 263, 401, 1111);
INSERT INTO chado.cvterm_relationship VALUES (947, 233, 1114, 532);
INSERT INTO chado.cvterm_relationship VALUES (948, 233, 1115, 530);
INSERT INTO chado.cvterm_relationship VALUES (949, 233, 1116, 532);
INSERT INTO chado.cvterm_relationship VALUES (950, 233, 1117, 530);
INSERT INTO chado.cvterm_relationship VALUES (951, 233, 1118, 713);
INSERT INTO chado.cvterm_relationship VALUES (952, 233, 1119, 401);
INSERT INTO chado.cvterm_relationship VALUES (953, 233, 1121, 716);
INSERT INTO chado.cvterm_relationship VALUES (954, 233, 721, 374);
INSERT INTO chado.cvterm_relationship VALUES (955, 233, 1122, 720);
INSERT INTO chado.cvterm_relationship VALUES (956, 233, 1123, 1124);
INSERT INTO chado.cvterm_relationship VALUES (957, 233, 1125, 446);
INSERT INTO chado.cvterm_relationship VALUES (958, 233, 902, 514);
INSERT INTO chado.cvterm_relationship VALUES (959, 233, 1126, 443);
INSERT INTO chado.cvterm_relationship VALUES (960, 233, 1127, 185);
INSERT INTO chado.cvterm_relationship VALUES (961, 277, 1127, 400);
INSERT INTO chado.cvterm_relationship VALUES (962, 233, 1128, 1129);
INSERT INTO chado.cvterm_relationship VALUES (963, 233, 1130, 1127);
INSERT INTO chado.cvterm_relationship VALUES (964, 277, 1130, 403);
INSERT INTO chado.cvterm_relationship VALUES (965, 233, 1131, 879);
INSERT INTO chado.cvterm_relationship VALUES (966, 252, 1131, 1132);
INSERT INTO chado.cvterm_relationship VALUES (967, 233, 1133, 1134);
INSERT INTO chado.cvterm_relationship VALUES (968, 233, 297, 1135);
INSERT INTO chado.cvterm_relationship VALUES (969, 233, 333, 297);
INSERT INTO chado.cvterm_relationship VALUES (970, 233, 1136, 1131);
INSERT INTO chado.cvterm_relationship VALUES (971, 250, 1136, 1137);
INSERT INTO chado.cvterm_relationship VALUES (972, 233, 1138, 1136);
INSERT INTO chado.cvterm_relationship VALUES (973, 250, 1138, 1139);
INSERT INTO chado.cvterm_relationship VALUES (974, 233, 446, 184);
INSERT INTO chado.cvterm_relationship VALUES (975, 233, 829, 347);
INSERT INTO chado.cvterm_relationship VALUES (976, 233, 1140, 828);
INSERT INTO chado.cvterm_relationship VALUES (977, 233, 1141, 828);
INSERT INTO chado.cvterm_relationship VALUES (978, 233, 1142, 829);
INSERT INTO chado.cvterm_relationship VALUES (979, 233, 185, 287);
INSERT INTO chado.cvterm_relationship VALUES (980, 260, 185, 552);
INSERT INTO chado.cvterm_relationship VALUES (981, 233, 295, 676);
INSERT INTO chado.cvterm_relationship VALUES (982, 233, 1143, 1144);
INSERT INTO chado.cvterm_relationship VALUES (983, 233, 1145, 1144);
INSERT INTO chado.cvterm_relationship VALUES (984, 233, 1146, 1143);
INSERT INTO chado.cvterm_relationship VALUES (985, 233, 1147, 1143);
INSERT INTO chado.cvterm_relationship VALUES (986, 233, 1148, 1136);
INSERT INTO chado.cvterm_relationship VALUES (987, 250, 1148, 1149);
INSERT INTO chado.cvterm_relationship VALUES (988, 233, 1150, 1131);
INSERT INTO chado.cvterm_relationship VALUES (989, 252, 1150, 1151);
INSERT INTO chado.cvterm_relationship VALUES (990, 233, 1152, 1131);
INSERT INTO chado.cvterm_relationship VALUES (991, 252, 1152, 469);
INSERT INTO chado.cvterm_relationship VALUES (992, 233, 317, 1153);
INSERT INTO chado.cvterm_relationship VALUES (993, 233, 1153, 1154);
INSERT INTO chado.cvterm_relationship VALUES (994, 233, 321, 1153);
INSERT INTO chado.cvterm_relationship VALUES (995, 233, 1155, 403);
INSERT INTO chado.cvterm_relationship VALUES (996, 233, 1155, 1073);
INSERT INTO chado.cvterm_relationship VALUES (997, 252, 1155, 404);
INSERT INTO chado.cvterm_relationship VALUES (998, 233, 612, 347);
INSERT INTO chado.cvterm_relationship VALUES (999, 233, 1156, 612);
INSERT INTO chado.cvterm_relationship VALUES (1000, 233, 513, 512);
INSERT INTO chado.cvterm_relationship VALUES (1001, 233, 1157, 441);
INSERT INTO chado.cvterm_relationship VALUES (1002, 252, 1157, 670);
INSERT INTO chado.cvterm_relationship VALUES (1003, 233, 1158, 1130);
INSERT INTO chado.cvterm_relationship VALUES (1004, 277, 1158, 1159);
INSERT INTO chado.cvterm_relationship VALUES (1005, 233, 1160, 1130);
INSERT INTO chado.cvterm_relationship VALUES (1006, 277, 1160, 1155);
INSERT INTO chado.cvterm_relationship VALUES (1007, 233, 1161, 689);
INSERT INTO chado.cvterm_relationship VALUES (1008, 233, 1162, 687);
INSERT INTO chado.cvterm_relationship VALUES (1009, 233, 1163, 837);
INSERT INTO chado.cvterm_relationship VALUES (1010, 238, 1163, 1164);
INSERT INTO chado.cvterm_relationship VALUES (1011, 233, 1095, 287);
INSERT INTO chado.cvterm_relationship VALUES (1012, 233, 344, 372);
INSERT INTO chado.cvterm_relationship VALUES (1013, 233, 1165, 1129);
INSERT INTO chado.cvterm_relationship VALUES (1014, 233, 1166, 304);
INSERT INTO chado.cvterm_relationship VALUES (1015, 233, 1167, 504);
INSERT INTO chado.cvterm_relationship VALUES (1016, 256, 1167, 514);
INSERT INTO chado.cvterm_relationship VALUES (1017, 233, 1168, 1169);
INSERT INTO chado.cvterm_relationship VALUES (1018, 233, 1170, 1169);
INSERT INTO chado.cvterm_relationship VALUES (1019, 233, 613, 812);
INSERT INTO chado.cvterm_relationship VALUES (1020, 233, 1171, 186);
INSERT INTO chado.cvterm_relationship VALUES (1021, 252, 1171, 1172);
INSERT INTO chado.cvterm_relationship VALUES (1022, 233, 1173, 812);
INSERT INTO chado.cvterm_relationship VALUES (1023, 233, 409, 1173);
INSERT INTO chado.cvterm_relationship VALUES (1024, 233, 416, 409);
INSERT INTO chado.cvterm_relationship VALUES (1025, 233, 414, 1173);
INSERT INTO chado.cvterm_relationship VALUES (1026, 233, 434, 409);
INSERT INTO chado.cvterm_relationship VALUES (1027, 233, 420, 409);
INSERT INTO chado.cvterm_relationship VALUES (1028, 233, 418, 1174);
INSERT INTO chado.cvterm_relationship VALUES (1029, 250, 418, 1093);
INSERT INTO chado.cvterm_relationship VALUES (1030, 250, 418, 1175);
INSERT INTO chado.cvterm_relationship VALUES (1031, 233, 1093, 520);
INSERT INTO chado.cvterm_relationship VALUES (1032, 233, 422, 420);
INSERT INTO chado.cvterm_relationship VALUES (1033, 233, 426, 420);
INSERT INTO chado.cvterm_relationship VALUES (1034, 233, 424, 420);
INSERT INTO chado.cvterm_relationship VALUES (1035, 233, 428, 420);
INSERT INTO chado.cvterm_relationship VALUES (1036, 233, 430, 420);
INSERT INTO chado.cvterm_relationship VALUES (1037, 233, 432, 420);
INSERT INTO chado.cvterm_relationship VALUES (1038, 233, 436, 1173);
INSERT INTO chado.cvterm_relationship VALUES (1039, 233, 1176, 687);
INSERT INTO chado.cvterm_relationship VALUES (1040, 233, 438, 1173);
INSERT INTO chado.cvterm_relationship VALUES (1041, 233, 447, 297);
INSERT INTO chado.cvterm_relationship VALUES (1042, 256, 447, 350);
INSERT INTO chado.cvterm_relationship VALUES (1043, 233, 1178, 516);
INSERT INTO chado.cvterm_relationship VALUES (1044, 233, 1179, 516);
INSERT INTO chado.cvterm_relationship VALUES (1045, 238, 1179, 519);
INSERT INTO chado.cvterm_relationship VALUES (1046, 233, 712, 756);
INSERT INTO chado.cvterm_relationship VALUES (1047, 233, 1180, 712);
INSERT INTO chado.cvterm_relationship VALUES (1048, 233, 1181, 712);
INSERT INTO chado.cvterm_relationship VALUES (1049, 233, 1189, 633);
INSERT INTO chado.cvterm_relationship VALUES (1050, 238, 1189, 1190);
INSERT INTO chado.cvterm_relationship VALUES (1051, 233, 1192, 519);
INSERT INTO chado.cvterm_relationship VALUES (1052, 233, 1193, 1194);
INSERT INTO chado.cvterm_relationship VALUES (1053, 233, 1195, 1194);
INSERT INTO chado.cvterm_relationship VALUES (1054, 233, 187, 287);
INSERT INTO chado.cvterm_relationship VALUES (1055, 233, 1196, 442);
INSERT INTO chado.cvterm_relationship VALUES (1056, 233, 1197, 1196);
INSERT INTO chado.cvterm_relationship VALUES (1057, 233, 1198, 1196);
INSERT INTO chado.cvterm_relationship VALUES (1058, 233, 1199, 1196);
INSERT INTO chado.cvterm_relationship VALUES (1059, 233, 1200, 1196);
INSERT INTO chado.cvterm_relationship VALUES (1060, 233, 1201, 950);
INSERT INTO chado.cvterm_relationship VALUES (1061, 233, 1202, 950);
INSERT INTO chado.cvterm_relationship VALUES (1062, 233, 1203, 1076);
INSERT INTO chado.cvterm_relationship VALUES (1063, 233, 1203, 1192);
INSERT INTO chado.cvterm_relationship VALUES (1064, 252, 1203, 666);
INSERT INTO chado.cvterm_relationship VALUES (1065, 233, 1205, 613);
INSERT INTO chado.cvterm_relationship VALUES (1066, 233, 1206, 613);
INSERT INTO chado.cvterm_relationship VALUES (1067, 233, 666, 613);
INSERT INTO chado.cvterm_relationship VALUES (1068, 233, 670, 613);
INSERT INTO chado.cvterm_relationship VALUES (1069, 233, 1207, 297);
INSERT INTO chado.cvterm_relationship VALUES (1070, 256, 1207, 447);
INSERT INTO chado.cvterm_relationship VALUES (1071, 233, 706, 1169);
INSERT INTO chado.cvterm_relationship VALUES (1072, 233, 765, 1169);
INSERT INTO chado.cvterm_relationship VALUES (1073, 233, 1214, 826);
INSERT INTO chado.cvterm_relationship VALUES (1074, 233, 1214, 665);
INSERT INTO chado.cvterm_relationship VALUES (1075, 252, 1214, 666);
INSERT INTO chado.cvterm_relationship VALUES (1076, 233, 1215, 1216);
INSERT INTO chado.cvterm_relationship VALUES (1077, 252, 1215, 827);
INSERT INTO chado.cvterm_relationship VALUES (1078, 233, 1217, 441);
INSERT INTO chado.cvterm_relationship VALUES (1079, 238, 1217, 350);
INSERT INTO chado.cvterm_relationship VALUES (1080, 252, 1217, 1205);
INSERT INTO chado.cvterm_relationship VALUES (1081, 233, 1218, 441);
INSERT INTO chado.cvterm_relationship VALUES (1082, 233, 1218, 1219);
INSERT INTO chado.cvterm_relationship VALUES (1083, 252, 1218, 1206);
INSERT INTO chado.cvterm_relationship VALUES (1084, 233, 1220, 441);
INSERT INTO chado.cvterm_relationship VALUES (1085, 233, 1220, 665);
INSERT INTO chado.cvterm_relationship VALUES (1086, 252, 1220, 666);
INSERT INTO chado.cvterm_relationship VALUES (1087, 233, 1221, 1157);
INSERT INTO chado.cvterm_relationship VALUES (1088, 233, 1221, 1220);
INSERT INTO chado.cvterm_relationship VALUES (1089, 233, 1221, 669);
INSERT INTO chado.cvterm_relationship VALUES (1090, 252, 1221, 666);
INSERT INTO chado.cvterm_relationship VALUES (1091, 252, 1221, 670);
INSERT INTO chado.cvterm_relationship VALUES (1092, 233, 1222, 1223);
INSERT INTO chado.cvterm_relationship VALUES (1093, 233, 1224, 1223);
INSERT INTO chado.cvterm_relationship VALUES (1094, 233, 1225, 1223);
INSERT INTO chado.cvterm_relationship VALUES (1095, 233, 1226, 1223);
INSERT INTO chado.cvterm_relationship VALUES (1096, 233, 665, 1135);
INSERT INTO chado.cvterm_relationship VALUES (1097, 252, 665, 666);
INSERT INTO chado.cvterm_relationship VALUES (1098, 233, 669, 665);
INSERT INTO chado.cvterm_relationship VALUES (1099, 252, 669, 666);
INSERT INTO chado.cvterm_relationship VALUES (1100, 252, 669, 670);
INSERT INTO chado.cvterm_relationship VALUES (1101, 233, 678, 613);
INSERT INTO chado.cvterm_relationship VALUES (1102, 233, 1227, 725);
INSERT INTO chado.cvterm_relationship VALUES (1103, 233, 1227, 665);
INSERT INTO chado.cvterm_relationship VALUES (1104, 252, 1227, 666);
INSERT INTO chado.cvterm_relationship VALUES (1105, 233, 1228, 711);
INSERT INTO chado.cvterm_relationship VALUES (1106, 252, 1228, 706);
INSERT INTO chado.cvterm_relationship VALUES (1107, 233, 1229, 711);
INSERT INTO chado.cvterm_relationship VALUES (1108, 252, 1229, 765);
INSERT INTO chado.cvterm_relationship VALUES (1109, 233, 1230, 1229);
INSERT INTO chado.cvterm_relationship VALUES (1110, 252, 1230, 764);
INSERT INTO chado.cvterm_relationship VALUES (1111, 233, 1231, 1229);
INSERT INTO chado.cvterm_relationship VALUES (1112, 252, 1231, 830);
INSERT INTO chado.cvterm_relationship VALUES (1113, 233, 1232, 1229);
INSERT INTO chado.cvterm_relationship VALUES (1114, 252, 1232, 831);
INSERT INTO chado.cvterm_relationship VALUES (1115, 233, 1233, 1229);
INSERT INTO chado.cvterm_relationship VALUES (1116, 252, 1233, 832);
INSERT INTO chado.cvterm_relationship VALUES (1117, 233, 827, 613);
INSERT INTO chado.cvterm_relationship VALUES (1118, 233, 1216, 611);
INSERT INTO chado.cvterm_relationship VALUES (1119, 233, 1234, 185);
INSERT INTO chado.cvterm_relationship VALUES (1120, 252, 1234, 827);
INSERT INTO chado.cvterm_relationship VALUES (1121, 233, 1235, 613);
INSERT INTO chado.cvterm_relationship VALUES (1122, 233, 1236, 1234);
INSERT INTO chado.cvterm_relationship VALUES (1123, 252, 1236, 1235);
INSERT INTO chado.cvterm_relationship VALUES (1124, 233, 1237, 743);
INSERT INTO chado.cvterm_relationship VALUES (1125, 251, 1237, 416);
INSERT INTO chado.cvterm_relationship VALUES (1126, 233, 1238, 743);
INSERT INTO chado.cvterm_relationship VALUES (1127, 251, 1238, 424);
INSERT INTO chado.cvterm_relationship VALUES (1128, 233, 1239, 743);
INSERT INTO chado.cvterm_relationship VALUES (1129, 251, 1239, 426);
INSERT INTO chado.cvterm_relationship VALUES (1130, 233, 1240, 743);
INSERT INTO chado.cvterm_relationship VALUES (1131, 251, 1240, 428);
INSERT INTO chado.cvterm_relationship VALUES (1132, 233, 1241, 743);
INSERT INTO chado.cvterm_relationship VALUES (1133, 251, 1241, 430);
INSERT INTO chado.cvterm_relationship VALUES (1134, 233, 1242, 743);
INSERT INTO chado.cvterm_relationship VALUES (1135, 251, 1242, 408);
INSERT INTO chado.cvterm_relationship VALUES (1136, 233, 1243, 743);
INSERT INTO chado.cvterm_relationship VALUES (1137, 251, 1243, 410);
INSERT INTO chado.cvterm_relationship VALUES (1138, 233, 1244, 743);
INSERT INTO chado.cvterm_relationship VALUES (1139, 251, 1244, 414);
INSERT INTO chado.cvterm_relationship VALUES (1140, 233, 1245, 743);
INSERT INTO chado.cvterm_relationship VALUES (1141, 251, 1245, 434);
INSERT INTO chado.cvterm_relationship VALUES (1142, 233, 451, 287);
INSERT INTO chado.cvterm_relationship VALUES (1143, 256, 451, 743);
INSERT INTO chado.cvterm_relationship VALUES (1144, 233, 1110, 287);
INSERT INTO chado.cvterm_relationship VALUES (1145, 260, 1110, 185);
INSERT INTO chado.cvterm_relationship VALUES (1146, 233, 510, 287);
INSERT INTO chado.cvterm_relationship VALUES (1147, 256, 510, 401);
INSERT INTO chado.cvterm_relationship VALUES (1148, 233, 1247, 510);
INSERT INTO chado.cvterm_relationship VALUES (1149, 233, 529, 510);
INSERT INTO chado.cvterm_relationship VALUES (1150, 256, 529, 472);
INSERT INTO chado.cvterm_relationship VALUES (1151, 233, 340, 1247);
INSERT INTO chado.cvterm_relationship VALUES (1152, 256, 340, 186);
INSERT INTO chado.cvterm_relationship VALUES (1153, 233, 1067, 340);
INSERT INTO chado.cvterm_relationship VALUES (1154, 233, 1078, 529);
INSERT INTO chado.cvterm_relationship VALUES (1155, 256, 1078, 585);
INSERT INTO chado.cvterm_relationship VALUES (1156, 233, 841, 287);
INSERT INTO chado.cvterm_relationship VALUES (1157, 256, 841, 448);
INSERT INTO chado.cvterm_relationship VALUES (1158, 233, 862, 616);
INSERT INTO chado.cvterm_relationship VALUES (1159, 233, 717, 529);
INSERT INTO chado.cvterm_relationship VALUES (1160, 256, 717, 559);
INSERT INTO chado.cvterm_relationship VALUES (1161, 233, 536, 287);
INSERT INTO chado.cvterm_relationship VALUES (1162, 256, 536, 185);
INSERT INTO chado.cvterm_relationship VALUES (1163, 233, 1194, 1247);
INSERT INTO chado.cvterm_relationship VALUES (1164, 256, 1194, 1023);
INSERT INTO chado.cvterm_relationship VALUES (1165, 233, 848, 862);
INSERT INTO chado.cvterm_relationship VALUES (1166, 256, 848, 675);
INSERT INTO chado.cvterm_relationship VALUES (1167, 233, 858, 848);
INSERT INTO chado.cvterm_relationship VALUES (1168, 256, 858, 852);
INSERT INTO chado.cvterm_relationship VALUES (1169, 233, 854, 848);
INSERT INTO chado.cvterm_relationship VALUES (1170, 256, 854, 851);
INSERT INTO chado.cvterm_relationship VALUES (1171, 233, 724, 340);
INSERT INTO chado.cvterm_relationship VALUES (1172, 256, 724, 449);
INSERT INTO chado.cvterm_relationship VALUES (1173, 233, 1252, 510);
INSERT INTO chado.cvterm_relationship VALUES (1174, 256, 1252, 509);
INSERT INTO chado.cvterm_relationship VALUES (1175, 233, 1253, 732);
INSERT INTO chado.cvterm_relationship VALUES (1176, 252, 1253, 1254);
INSERT INTO chado.cvterm_relationship VALUES (1177, 233, 1255, 1253);
INSERT INTO chado.cvterm_relationship VALUES (1178, 252, 1255, 1256);
INSERT INTO chado.cvterm_relationship VALUES (1179, 233, 1257, 1253);
INSERT INTO chado.cvterm_relationship VALUES (1180, 252, 1257, 1258);
INSERT INTO chado.cvterm_relationship VALUES (1181, 233, 1259, 613);
INSERT INTO chado.cvterm_relationship VALUES (1182, 233, 1254, 1259);
INSERT INTO chado.cvterm_relationship VALUES (1183, 233, 1258, 1254);
INSERT INTO chado.cvterm_relationship VALUES (1184, 233, 1256, 1254);
INSERT INTO chado.cvterm_relationship VALUES (1185, 233, 1260, 1259);
INSERT INTO chado.cvterm_relationship VALUES (1186, 233, 1261, 472);
INSERT INTO chado.cvterm_relationship VALUES (1187, 230, 1261, 1020);
INSERT INTO chado.cvterm_relationship VALUES (1188, 252, 1261, 508);
INSERT INTO chado.cvterm_relationship VALUES (1189, 233, 1262, 186);
INSERT INTO chado.cvterm_relationship VALUES (1190, 230, 1262, 1020);
INSERT INTO chado.cvterm_relationship VALUES (1191, 252, 1262, 508);
INSERT INTO chado.cvterm_relationship VALUES (1192, 233, 626, 466);
INSERT INTO chado.cvterm_relationship VALUES (1193, 233, 1172, 626);
INSERT INTO chado.cvterm_relationship VALUES (1194, 233, 456, 626);
INSERT INTO chado.cvterm_relationship VALUES (1195, 233, 672, 456);
INSERT INTO chado.cvterm_relationship VALUES (1196, 233, 738, 456);
INSERT INTO chado.cvterm_relationship VALUES (1197, 233, 719, 456);
INSERT INTO chado.cvterm_relationship VALUES (1198, 233, 731, 456);
INSERT INTO chado.cvterm_relationship VALUES (1199, 233, 913, 466);
INSERT INTO chado.cvterm_relationship VALUES (1200, 233, 880, 186);
INSERT INTO chado.cvterm_relationship VALUES (1201, 230, 880, 1046);
INSERT INTO chado.cvterm_relationship VALUES (1202, 252, 880, 625);
INSERT INTO chado.cvterm_relationship VALUES (1203, 233, 1263, 186);
INSERT INTO chado.cvterm_relationship VALUES (1204, 233, 1263, 892);
INSERT INTO chado.cvterm_relationship VALUES (1205, 230, 1263, 1075);
INSERT INTO chado.cvterm_relationship VALUES (1206, 252, 1263, 913);
INSERT INTO chado.cvterm_relationship VALUES (1207, 233, 994, 401);
INSERT INTO chado.cvterm_relationship VALUES (1208, 247, 994, 1039);
INSERT INTO chado.cvterm_relationship VALUES (1209, 250, 994, 1264);
INSERT INTO chado.cvterm_relationship VALUES (1210, 252, 994, 465);
INSERT INTO chado.cvterm_relationship VALUES (1211, 233, 1265, 994);
INSERT INTO chado.cvterm_relationship VALUES (1212, 233, 663, 535);
INSERT INTO chado.cvterm_relationship VALUES (1213, 233, 661, 535);
INSERT INTO chado.cvterm_relationship VALUES (1214, 233, 1266, 466);
INSERT INTO chado.cvterm_relationship VALUES (1215, 233, 1071, 466);
INSERT INTO chado.cvterm_relationship VALUES (1216, 233, 404, 402);
INSERT INTO chado.cvterm_relationship VALUES (1217, 233, 402, 466);
INSERT INTO chado.cvterm_relationship VALUES (1218, 233, 1132, 626);
INSERT INTO chado.cvterm_relationship VALUES (1219, 233, 1267, 1132);
INSERT INTO chado.cvterm_relationship VALUES (1220, 233, 1137, 506);
INSERT INTO chado.cvterm_relationship VALUES (1221, 233, 1139, 1137);
INSERT INTO chado.cvterm_relationship VALUES (1222, 233, 1149, 1137);
INSERT INTO chado.cvterm_relationship VALUES (1223, 233, 1151, 1132);
INSERT INTO chado.cvterm_relationship VALUES (1224, 233, 469, 1132);
INSERT INTO chado.cvterm_relationship VALUES (1225, 233, 1268, 496);
INSERT INTO chado.cvterm_relationship VALUES (1226, 252, 1268, 492);
INSERT INTO chado.cvterm_relationship VALUES (1227, 233, 1269, 496);
INSERT INTO chado.cvterm_relationship VALUES (1228, 252, 1269, 493);
INSERT INTO chado.cvterm_relationship VALUES (1229, 233, 1270, 185);
INSERT INTO chado.cvterm_relationship VALUES (1230, 252, 1270, 486);
INSERT INTO chado.cvterm_relationship VALUES (1231, 233, 1271, 185);
INSERT INTO chado.cvterm_relationship VALUES (1232, 252, 1271, 907);
INSERT INTO chado.cvterm_relationship VALUES (1233, 233, 1272, 185);
INSERT INTO chado.cvterm_relationship VALUES (1234, 252, 1272, 909);
INSERT INTO chado.cvterm_relationship VALUES (1235, 233, 481, 479);
INSERT INTO chado.cvterm_relationship VALUES (1236, 233, 483, 481);
INSERT INTO chado.cvterm_relationship VALUES (1237, 233, 485, 483);
INSERT INTO chado.cvterm_relationship VALUES (1238, 233, 1273, 185);
INSERT INTO chado.cvterm_relationship VALUES (1239, 252, 1273, 487);
INSERT INTO chado.cvterm_relationship VALUES (1240, 233, 1274, 496);
INSERT INTO chado.cvterm_relationship VALUES (1241, 252, 1274, 494);
INSERT INTO chado.cvterm_relationship VALUES (1242, 233, 496, 185);
INSERT INTO chado.cvterm_relationship VALUES (1243, 233, 496, 699);
INSERT INTO chado.cvterm_relationship VALUES (1244, 252, 496, 490);
INSERT INTO chado.cvterm_relationship VALUES (1245, 233, 767, 185);
INSERT INTO chado.cvterm_relationship VALUES (1246, 252, 767, 1205);
INSERT INTO chado.cvterm_relationship VALUES (1247, 233, 440, 438);
INSERT INTO chado.cvterm_relationship VALUES (1248, 233, 497, 490);
INSERT INTO chado.cvterm_relationship VALUES (1249, 233, 1169, 613);
INSERT INTO chado.cvterm_relationship VALUES (1250, 233, 1278, 1169);
INSERT INTO chado.cvterm_relationship VALUES (1251, 233, 1279, 1170);
INSERT INTO chado.cvterm_relationship VALUES (1252, 233, 1280, 1279);
INSERT INTO chado.cvterm_relationship VALUES (1253, 233, 1281, 1279);
INSERT INTO chado.cvterm_relationship VALUES (1254, 233, 1282, 1170);
INSERT INTO chado.cvterm_relationship VALUES (1255, 233, 1283, 1170);
INSERT INTO chado.cvterm_relationship VALUES (1256, 233, 1284, 1285);
INSERT INTO chado.cvterm_relationship VALUES (1257, 233, 1286, 447);
INSERT INTO chado.cvterm_relationship VALUES (1258, 252, 1286, 712);
INSERT INTO chado.cvterm_relationship VALUES (1259, 233, 1287, 447);
INSERT INTO chado.cvterm_relationship VALUES (1260, 252, 1287, 351);
INSERT INTO chado.cvterm_relationship VALUES (1261, 233, 1288, 447);
INSERT INTO chado.cvterm_relationship VALUES (1262, 233, 1288, 665);
INSERT INTO chado.cvterm_relationship VALUES (1263, 252, 1288, 666);
INSERT INTO chado.cvterm_relationship VALUES (1264, 233, 1302, 186);
INSERT INTO chado.cvterm_relationship VALUES (1265, 233, 1302, 994);
INSERT INTO chado.cvterm_relationship VALUES (1266, 252, 1302, 465);
INSERT INTO chado.cvterm_relationship VALUES (1267, 233, 1303, 1247);
INSERT INTO chado.cvterm_relationship VALUES (1268, 256, 1303, 1039);
INSERT INTO chado.cvterm_relationship VALUES (1269, 233, 1304, 1303);
INSERT INTO chado.cvterm_relationship VALUES (1270, 233, 1305, 471);
INSERT INTO chado.cvterm_relationship VALUES (1271, 233, 1306, 613);
INSERT INTO chado.cvterm_relationship VALUES (1272, 233, 1307, 1308);
INSERT INTO chado.cvterm_relationship VALUES (1273, 233, 1309, 449);
INSERT INTO chado.cvterm_relationship VALUES (1274, 252, 1309, 465);
INSERT INTO chado.cvterm_relationship VALUES (1275, 233, 954, 693);
INSERT INTO chado.cvterm_relationship VALUES (1276, 233, 919, 693);
INSERT INTO chado.cvterm_relationship VALUES (1277, 233, 695, 693);
INSERT INTO chado.cvterm_relationship VALUES (1278, 233, 886, 613);
INSERT INTO chado.cvterm_relationship VALUES (1279, 233, 1311, 779);
INSERT INTO chado.cvterm_relationship VALUES (1280, 233, 1312, 772);
INSERT INTO chado.cvterm_relationship VALUES (1281, 256, 1312, 1313);
INSERT INTO chado.cvterm_relationship VALUES (1282, 233, 1314, 772);
INSERT INTO chado.cvterm_relationship VALUES (1283, 233, 1315, 772);
INSERT INTO chado.cvterm_relationship VALUES (1284, 233, 1316, 772);
INSERT INTO chado.cvterm_relationship VALUES (1285, 233, 772, 745);
INSERT INTO chado.cvterm_relationship VALUES (1286, 233, 749, 745);
INSERT INTO chado.cvterm_relationship VALUES (1287, 233, 754, 745);
INSERT INTO chado.cvterm_relationship VALUES (1288, 233, 1317, 749);
INSERT INTO chado.cvterm_relationship VALUES (1289, 233, 1318, 772);
INSERT INTO chado.cvterm_relationship VALUES (1290, 256, 1318, 769);
INSERT INTO chado.cvterm_relationship VALUES (1291, 233, 1053, 502);
INSERT INTO chado.cvterm_relationship VALUES (1292, 233, 1319, 687);
INSERT INTO chado.cvterm_relationship VALUES (1293, 233, 1320, 687);
INSERT INTO chado.cvterm_relationship VALUES (1294, 233, 1321, 743);
INSERT INTO chado.cvterm_relationship VALUES (1295, 252, 1321, 756);
INSERT INTO chado.cvterm_relationship VALUES (1296, 233, 1322, 1321);
INSERT INTO chado.cvterm_relationship VALUES (1297, 252, 1322, 1323);
INSERT INTO chado.cvterm_relationship VALUES (1298, 233, 1324, 1321);
INSERT INTO chado.cvterm_relationship VALUES (1299, 252, 1324, 1325);
INSERT INTO chado.cvterm_relationship VALUES (1300, 233, 1326, 1322);
INSERT INTO chado.cvterm_relationship VALUES (1301, 252, 1326, 1327);
INSERT INTO chado.cvterm_relationship VALUES (1302, 233, 1328, 1322);
INSERT INTO chado.cvterm_relationship VALUES (1303, 252, 1328, 1329);
INSERT INTO chado.cvterm_relationship VALUES (1304, 233, 1330, 1324);
INSERT INTO chado.cvterm_relationship VALUES (1305, 252, 1330, 1327);
INSERT INTO chado.cvterm_relationship VALUES (1306, 233, 1331, 1324);
INSERT INTO chado.cvterm_relationship VALUES (1307, 252, 1331, 1329);
INSERT INTO chado.cvterm_relationship VALUES (1308, 233, 1332, 743);
INSERT INTO chado.cvterm_relationship VALUES (1309, 252, 1332, 760);
INSERT INTO chado.cvterm_relationship VALUES (1310, 233, 1333, 1332);
INSERT INTO chado.cvterm_relationship VALUES (1311, 252, 1333, 1325);
INSERT INTO chado.cvterm_relationship VALUES (1312, 233, 1334, 1333);
INSERT INTO chado.cvterm_relationship VALUES (1313, 252, 1334, 1327);
INSERT INTO chado.cvterm_relationship VALUES (1314, 233, 1335, 1336);
INSERT INTO chado.cvterm_relationship VALUES (1315, 252, 1335, 1327);
INSERT INTO chado.cvterm_relationship VALUES (1316, 233, 1336, 1332);
INSERT INTO chado.cvterm_relationship VALUES (1317, 252, 1336, 1323);
INSERT INTO chado.cvterm_relationship VALUES (1318, 233, 1337, 1333);
INSERT INTO chado.cvterm_relationship VALUES (1319, 252, 1337, 1329);
INSERT INTO chado.cvterm_relationship VALUES (1320, 233, 1338, 1336);
INSERT INTO chado.cvterm_relationship VALUES (1321, 252, 1338, 1329);
INSERT INTO chado.cvterm_relationship VALUES (1322, 233, 1344, 584);
INSERT INTO chado.cvterm_relationship VALUES (1323, 233, 1345, 417);
INSERT INTO chado.cvterm_relationship VALUES (1324, 256, 1345, 1175);
INSERT INTO chado.cvterm_relationship VALUES (1325, 233, 1346, 613);
INSERT INTO chado.cvterm_relationship VALUES (1326, 233, 1264, 510);
INSERT INTO chado.cvterm_relationship VALUES (1327, 233, 1347, 1303);
INSERT INTO chado.cvterm_relationship VALUES (1328, 233, 1348, 306);
INSERT INTO chado.cvterm_relationship VALUES (1329, 233, 1175, 520);
INSERT INTO chado.cvterm_rel