<?php

namespace Drupal\tripal_layout\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\Core\Entity\Attribute\ConfigEntityType;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines the Default Layout entity controlling the page display/layout.
 */
#[ConfigEntityType(
  id: 'tripal_layout_default_view',
  label: new TranslatableMarkup('Tripal Default Display Layout'),
  handlers: [
    'list_builder' => 'Drupal\tripal_layout\ListBuilders\TripalLayoutDefaultViewListBuilder',
    'form' => [
      'delete' => 'Drupal\tripal_layout\Form\TripalLayoutDefaultViewDeleteForm',
    ]
  ],
  config_prefix: 'tripal_layout_default_view',
  admin_permission: 'administer tripal',
  entity_keys: [
    'id' => 'id',
    'label' => 'label',
  ],
  config_export: [
    'id',
    'label',
    'description',
    'layouts'
  ],
  links: [
    'delete-form' => '/admin/tripal/config/tripal-layout-default-view/{tripal_layout_default_view}/delete',
    'layouts' => '/admin/tripal/config/tripal-layout-default-view'
  ],
)]
/**
 * @todo Remove this annotation when we no longer support Drupal 10.x.
 *
 * @ConfigEntityType(
 *   id = "tripal_layout_default_view",
 *   label = @Translation("Tripal Default Display Layout"),
 *   handlers = {
 *     "list_builder" = "Drupal\tripal_layout\ListBuilders\TripalLayoutDefaultViewListBuilder",
 *     "form" = {
 *       "delete" = "Drupal\tripal_layout\Form\TripalLayoutDefaultViewDeleteForm",
 *     }
 *   },
 *   config_prefix = "tripal_layout_default_view",
 *   admin_permission = "administer tripal",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "description",
 *     "layouts"
 *   },
 *   links = {
 *     "delete-form" = "/admin/tripal/config/tripal-layout-default-view/{tripal_layout_default_view}/delete",
 *     "layouts" = "/admin/tripal/config/tripal-layout-default-view"
 *   }
 * )
 */
class TripalLayoutDefaultView extends ConfigEntityBase implements TripalLayoutDefaultViewInterface {

  use TripalLayoutConfigEntityTrait;

  /**
   * A unique ID for this display layout entity.
   *
   * @var string
   */
  protected $id;

  /**
   * A label identifying this collection of display layouts.
   *
   * @var string
   */
  protected $label;

  /**
   * A description to provide to the admin describing this collection.
   *
   * @var string
   */
  protected $description;


  /**
   * The collection of display layouts itself directly from the YAML.
   *
   * @var array
   */
  protected $layouts;

  /**
   * Retrieves the description of this display layout collection.
   *
   * @return string
   *   The display layout collection description.
   */
  public function description() {
    return $this->description;
  }

}
