# Theme Switcher By User

## Description
The Drupal Theme Switcher module provides a block that allows users to switch between different themes. The available themes for selection are determined based on the entity's 'available themes' or the selected themes in the configuration for all users. The selected theme is recorded in the 'select theme' entity.

## Features
- **User-friendly Interface:** Easy-to-use block for switching themes.
- **Dynamic Theme Listing:** Themes are listed based on entity-specific availability or global configuration.
- **Theme Persistence:** User's theme selection is recorded for consistent user experience.

## Installation
Install as you would normally install a contributed Drupal module. Visit https://www.drupal.org/docs/extending-drupal/installing-modules for further information.

## Configuration
1. **Configuration:**
  - Go to `Administer > Appereance > Theme Switcher By User`.
2. **Configuring Available Themes:**
  - Select the themes you want to be available for switching.
3. **Configuring excluded pages:**
  - Select the pages you want to exclude from the theme switcher.
4. **Configuring select theme entity:**
  - Select the entity that will be used to store the selected theme.

## Usage
- **Add theme switcher block to block layout:**
  - For access to the theme switcher, configure permission 'Switch own select theme in theme switcher block'

## Contributing
Contributions to the Theme Switcher module are welcome. Please follow the standard Drupal contribution guidelines.
