# Changelog

All notable changes to the Text-to-Speech (TTS) module will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.0.0] - 2025-10-19

### Added
- Initial release of Text-to-Speech (TTS) module
- Integration with Drupal AI module framework
- Text-to-speech generation for node content
- Configurable AI provider support (OpenAI, Google Cloud, Azure, etc.)
- Audio player block with custom controls
- Configuration form for TTS settings
- Support for multiple audio formats (MP3, OGG, WAV)
- Caching system for generated audio files
- REST API endpoints for programmatic access
- **Automatic cleanup of audio files on node update/delete** ✨
- **Persistent file caching**: Audio files survive cache clear operations 🎯
- **Comprehensive player customization** 🎨:
  - Player styles: Default, Compact, Minimal, Large, Widget (floating side player) 🆕
  - Widget style: Beautiful circular floating player with gradient background
  - Toggle download button
  - Toggle volume control (slider)
  - Custom template override support
  - Two-row layout: primary controls (top) + secondary controls (bottom)
- **External Storage Support** 💾:
  - AWS S3 and S3-compatible services (DigitalOcean Spaces, Wasabi, Backblaze B2)
  - Azure Blob Storage
  - Google Cloud Storage (GCS)
  - Generic CDN with API support
  - Automatic fallback to local storage on upload failure
  - Custom CDN domain support for all providers
  - Secure credential management (password fields)
- Node-specific filenames for easy tracking (`tts_node_{nid}_{uid}.{format}`)
- Multi-language support
- Responsive audio player design
- Dark mode support
- Keyboard controls for audio player
- Accessibility features (ARIA labels, screen reader support, WCAG 2.1 Level AA)
- Comprehensive documentation (README.md, DOCUMENTATION.md, CHANGELOG.md)

### Features
- Convert node content to natural-sounding speech
- Configurable voice models and speaking rates
- Audio player widget for node pages
- Support for multiple content types
- Field selection for content inclusion
- Auto-generation option on node save
- **Fully customizable player**: Enable/disable any feature, choose from 5 player styles
- **Widget player style**: Floating circular player with gradient background for modern UX
- Volume and playback controls (with show/hide options)
- Download audio option (can be disabled)
- Mobile-responsive design with adaptive layouts
- **External storage support**: Upload to CDN, AWS S3, Azure, GCS for scalable delivery
- **Automatic file cleanup**: Old audio files deleted on node update (80% disk space savings)
- **Smart file management**: Only current audio files kept per node
- **Persistent file caching**: Existing files reused after `drush cache clear`, preventing unnecessary API calls
- **Smart regeneration**: Files only regenerated when node content changes
- **Custom template support**: Override default player with your own Twig template

### Configuration
- AI provider selection
- Voice model configuration
- Language selection
- Speaking rate adjustment
- Pitch control
- Audio format selection
- Content type enablement
- Field inclusion settings
- Cache duration configuration
- Maximum text length limits

## [Unreleased]

### Planned Features
- Batch audio generation for existing content
- Advanced voice customization options
- Multiple voice selection per content type
- Audio transcription display
- Integration with media library
- Audio quality presets
- Background queue processing improvements
- Support for additional content entity types
- Voice preview in configuration
- Audio waveform visualization
- Playlist functionality for multiple nodes
- Social media audio sharing
- Audio analytics and usage statistics
- Signed URLs for private audio content on external storage
- Multi-region redundancy for external storage
- Storage usage statistics and monitoring

### Planned Improvements
- Performance optimizations for large content
- Enhanced error handling and reporting
- Additional AI provider integrations
- Improved caching strategies
- Better mobile experience
- Enhanced accessibility features
- More granular permissions


### Technical
- Uses AI module's TextToSpeech interface
- Proper integration with AI provider system (ProviderProxy support)
- Service-oriented architecture
- Drupal 10/11 compatible JavaScript (once API)
- Drupal coding standards compliant
- Hook system for extensibility (`hook_node_update`, `hook_node_delete`)

## Notes

This module requires:
- Drupal 10.x or 11.x
- AI module 1.1.x or later
- PHP 8.1 or higher
- Configured AI provider (OpenAI, Google Cloud, Azure, etc.)

For detailed installation and usage instructions, see **README.md** and  **EXTERNAL_STORAGE.md** and  **DOCUMENTATION.md**.

