<?php

namespace Drupal\Tests\tugboat\Kernel;

use Drupal\Component\Serialization\Json;
use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceModifierInterface;
use Drupal\KernelTests\KernelTestBase;

/**
 * @group tugboat
 */
final class TugboatClientTest extends KernelTestBase implements ServiceModifierInterface {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'tugboat',
  ];

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    $container->removeDefinition('test.http_client.middleware');
  }

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();
    if (empty($_ENV['TUGBOAT_API_KEY'])) {
      self::markTestSkipped('No API key set for testing');
    }
    if (empty($_ENV['TUGBOAT_REPOSITORY_ID'])) {
      self::markTestSkipped('No repository ID set for testing');
    }
    $this->config('tugboat.settings')
      ->set('token', $_ENV['TUGBOAT_API_KEY'])
      ->set('repository_id', $_ENV['TUGBOAT_REPOSITORY_ID'])
      ->save();
  }

  /**
   * Tests we can hit the version endpoint.
   */
  public function testVersion() {
    $sut = $this->container->get('tugboat.client');
    $res = $sut->requestWithApiKey('GET', 'version');
    $output = Json::decode((string) $res->getBody());
    $this->assertArrayHasKey('api', $output);
    $this->assertArrayHasKey('server', $output);
  }

  /**
   * Tests an authenticated request.
   */
  public function testGetRepository() {
    $sut = $this->container->get('tugboat.client');
    $res = $sut->requestWithApiKey('GET', 'repos/' . $_ENV['TUGBOAT_REPOSITORY_ID']);
    $this->assertNotNull($res);
  }

}
