# Turbo SMS Notify

Модуль для Drupal 10/11, який відправляє SMS/Viber‑повідомлення через сервіс [TurboSMS](https://turbosms.ua/) під час надсилання вебформи (Webform). Також надає сторінку налаштувань із тестовою відправкою та вебхук для приймання статусів доставки (DLR).

## Можливості

- Відправка повідомлень із **Webform** (через Webform Handler).
- Канали: **SMS**, **Viber (transactional)**, **Viber (promotional)**.
- Підтримка **Token API** у шаблоні повідомлення: `[site:*]`, `[date:*]`, `[webform_submission:*]`, `[webform:*]`, `[current-user:*]` тощо.
- Сторінка налаштувань з блоком **Send test** (перевірка API).
- Вебхук `POST /turbosms/webhook` для фіксації статусів доставки.
- Логи у каналі `turbo_sms_notify` (Звіти → Журнал подій).

## Вимоги

- **Drupal**: `^10 || ^11`
- **Webform** (обов’язково)
- **Token** (необов’язково, але рекомендовано для шаблонів з токенами)
- Обліковий запис у **TurboSMS** (API‑токен, затверджений альфанейм відправника)

## Встановлення через Composer

1. Встановіть залежності та модуль:
   ```bash
   composer require drupal/webform:^6 drupal/token:^1 drupal/turbo_sms_notify:^1.0
   ```
2. Увімкніть модуль і почистіть кеш:
   ```bash
   drush en turbo_sms_notify -y
   drush cr
   ```

> Після встановлення перейдіть до **Адмін → Конфігурація → Система → TurboSMS** і налаштуйте API‑токен, альфанейм відправника та шаблон повідомлення. На потрібній вебформі підключіть **Settings → Handlers → Add handler → TurboSMS notify**.

## Налаштування

Перейдіть: **Адміністрування → Конфігурація → Система → TurboSMS**  
`/admin/config/system/turbo-sms`

Заповніть:
- **API token** — токен із кабінету TurboSMS.
- **Sender (alpha name)** — затверджене ім’я відправника (має бути погоджене в TurboSMS).
- **Webform machine ID** — машинна назва вебформи (для діагностики можна тимчасово вказати `*`).
- **Phone element key** — ключ елемента вебформи з номером телефону (наприклад, `phone`).
- **Message template** — шаблон повідомлення з підтримкою токенів.
- Параметри каналу **SMS/Viber** (для Viber: `image_url`, `button_caption`, `button_action`).
- **Webhook secret** (необов’язково) — секрет для перевірки підпису запитів вебхука.

Наприкінці сторінки доступний розділ **Send test** для тестової відправки.

## Підключення до конкретної форми (Webform Handler)

1. Відкрийте потрібну **Webform** → **Settings** → **Handlers** → **Add handler**.  
2. Оберіть **TurboSMS notify** → **Save**.

> **Webform Handler** — основний і стабільний тригер відправки на продакшені. Підписники подій та тимчасові «страхувальні» хуки у фінальній версії не використовуються, щоб уникнути дублювання.

## Токени в шаблоні повідомлення

Підтримуються токени **Token API**. Приклади:

- Сайт/користувач/дата:  
  `[site:name]`, `[current-user:name]`, `[date:custom:d.m.Y H:i]`
- Вебформа:  
  `[webform:title]`
- Сабміт вебформи (значення полів):  
  `[webform_submission:values:phone]`, `[webform_submission:values:order_id]`, `[webform_submission:url]`, тощо.

**Приклад короткого SMS‑шаблону:**
```
Вітаємо, [webform_submission:values:name_customer]!
Замовлення #[webform_submission:values:order_id] прийнято.
Товар: [webform_submission:values:select_product], к-сть: [webform_submission:values:quantity]
Дата: [date:custom:d.m.Y H:i]
```

> У кнопці **Send test** контекст `webform_submission` відсутній, тож токени `webform_submission:*` будуть очищені; інші (`site`, `current-user`, `date`) — підставляться. Повна підстановка виконується під час реального сабміту вебформи.

## Вебхук (DLR/status)

- Шлях: `POST /turbosms/webhook`
- Необов’язковий заголовок підпису: `X-TurboSMS-Signature` (має відповідати **Webhook secret**).
- Усі вхідні події логуються в канал `turbo_sms_notify`.

**Тест:**
```bash
curl -i -X POST 'https://example.com/turbosms/webhook'   -H 'Content-Type: application/json'   -H 'X-TurboSMS-Signature: YOUR_SECRET_IF_SET'   --data '{"ping":"ok"}'
```

## Журнали та налагодження

- Перевіряйте **Звіти → Журнал подій** (канал `turbo_sms_notify`).
- Переконайтеся, що **Sender (alpha name)** затверджено у TurboSMS.
- Телефон повинен бути у форматі **E.164** з `+` (напр., `+380671234567`).
- Якщо відправка не відбувається:
  - тимчасово встановіть **Webform machine ID = `*`** і повторіть;
  - перевірте правильність **Phone element key**;
  - перегляньте причину у журналі подій (там виводяться ключі доступних полів і коди помилок API).

## Архітектура

- **Service**: `\Drupal\turbo_sms_notify\Service\Sender` — єдина точка логіки відправки.
- **Webform Handler**: `\Drupal\turbo_sms_notify\Plugin\WebformHandler\TurboSmsHandler` — викликає сервіс у `postSave()`.
- **Settings form**: `\Drupal\turbo_sms_notify\Form\SettingsForm` — конфігурація та «Send test».
- **Webhook**: `\Drupal\turbo_sms_notify\Controller\WebhookController` — приймання подій доставки.

## Ліцензія

GPL‑2.0‑or‑later (сумісна з політиками drupal.org).

## Підтримка

Створюйте issues на сторінці проєкту або звертайтеся до мейнтейнера модуля.
