# Turbo SMS Notify

Drupal 10/11 module that sends SMS/Viber messages via [TurboSMS](https://turbosms.ua/) on Webform submission. It also provides an admin settings page with a **Send test** action and a webhook endpoint for delivery status (DLR) callbacks.

## Features

- Send messages from **Webform** (via Webform Handler).
- Channels: **SMS**, **Viber (transactional)**, **Viber (promotional)**.
- **Token API** support in message template: `[site:*]`, `[date:*]`, `[webform_submission:*]`, `[webform:*]`, `[current-user:*]`, etc.
- Settings page with **Send test**.
- Webhook `POST /turbosms/webhook` to log delivery status.
- Logs go to channel `turbo_sms_notify` (Reports → Recent log messages).

## Requirements

- **Drupal**: `^10 || ^11`
- **Webform** (required)
- **Token** (optional but recommended for tokenized templates)
- Active **TurboSMS** account (API token and approved sender alpha name)

## Install via Composer

1. Require dependencies and the module:
   ```bash
   composer require drupal/webform:^6 drupal/token:^1 drupal/turbo_sms_notify:^1.0
   ```
2. Enable and rebuild caches:
   ```bash
   drush en turbo_sms_notify -y
   drush cr
   ```

> After installation go to **Admin → Configuration → System → TurboSMS** to set your API token, alpha sender, and message template. On the target webform add **Settings → Handlers → Add handler → TurboSMS notify**.

## Configuration

Path: **Administration → Configuration → System → TurboSMS**  
`/admin/config/system/turbo-sms`

Fill in:
- **API token** — from TurboSMS dashboard.
- **Sender (alpha name)** — approved sender ID in TurboSMS.
- **Webform machine ID** — machine name of the form (use `*` temporarily for diagnostics).
- **Phone element key** — key of the webform element holding phone (e.g., `phone`).
- **Message template** — tokenized template (Token API).
- Channel options **SMS/Viber** (for Viber: `image_url`, `button_caption`, `button_action`).
- **Webhook secret** (optional) — secret to validate webhook signature header.

Use **Send test** at the bottom of the settings page to verify connectivity.

## Attach to a specific form (Webform Handler)

1. Open the target **Webform** → **Settings** → **Handlers** → **Add handler**.  
2. Select **TurboSMS notify** → **Save**.

The **Webform Handler** is the primary, production‑safe trigger. Event subscribers and ad‑hoc hooks are **not** used in the final version to avoid duplicates.

## Tokens in message template

Token API is supported. Common examples:

- Site/User/Date:  
  `[site:name]`, `[current-user:name]`, `[date:custom:d.m.Y H:i]`
- Webform:  
  `[webform:title]`
- Submission values:  
  `[webform_submission:values:phone]`, `[webform_submission:values:order_id]`, `[webform_submission:url]`, etc.

**Short SMS example:**
```
Вітаємо, [webform_submission:values:name_customer]!
Замовлення #[webform_submission:values:order_id] прийнято.
Товар: [webform_submission:values:select_product], к-сть: [webform_submission:values:quantity]
Дата: [date:custom:d.m.Y H:i]
```

> In **Send test**, there is no `webform_submission` context, so `webform_submission:*` tokens are cleared; other tokens (`site`, `current-user`, `date`) will render. Full token replacement happens on real webform submission.

## Webhook (DLR/status)

- Path: `POST /turbosms/webhook`
- Optional signature header: `X-TurboSMS-Signature` (must match **Webhook secret**).
- All incoming payloads are logged to `turbo_sms_notify` channel.

**Test:**
```bash
curl -i -X POST 'https://example.com/turbosms/webhook'   -H 'Content-Type: application/json'   -H 'X-TurboSMS-Signature: YOUR_SECRET_IF_SET'   --data '{"ping":"ok"}'
```

## Logging & Debugging

- Check **Reports → Recent log messages** (channel `turbo_sms_notify`).
- Ensure **Sender (alpha name)** is approved in TurboSMS.
- Phone must be **E.164** with leading `+` (e.g., `+380671234567`).
- If sending fails:
  - temporarily set **Webform machine ID = `*`** and retry;
  - verify **Phone element key**;
  - inspect logs for detailed reason (available field keys, API codes).

## Architecture

- **Service**: `\Drupal\turbo_sms_notify\Service\Sender` — single place for sending logic.
- **Webform Handler**: `\Drupal\turbo_sms_notify\Plugin\WebformHandler\TurboSmsHandler` — calls the service in `postSave()`.
- **Settings form**: `\Drupal\turbo_sms_notify\Form\SettingsForm` — config and “Send test”.
- **Webhook**: `\Drupal\turbo_sms_notify\Controller\WebhookController` — receives delivery callbacks.

## License

GPL‑2.0‑or‑later (compatible with drupal.org policies).

## Support

Open an issue on the project page or contact the module maintainer.
