/**
 * @file
 * JavaScript behaviors for Ajax.
 */

(function ($) {

  'use strict';

  /**
   * Command to render all Turnstile captchas in the page if they are empty.
   */
  Drupal.AjaxCommands.prototype.turnstileRender = function () {
    window.onloadTurnstileCallback();
  }

  window.onloadTurnstileCallback = function () {
    $('.cf-turnstile').each(function () {

      // Render Turnstile widget again for empty containers.
      if ($(this).is(':empty')) {
        const widget = this;
        const appearance = $(widget).data('appearance') || '';
        const setA11yVisibility = function (visible) {

          // 'inert' removes the element and its shadow DOM contents from the
          // tab order and prevents all descendant focus or interaction.
          // 'aria-hidden' ensures assistive technologies also ignore the widget
          // in browsers that do not yet fully support 'inert'.
          if (visible) {
            $(widget).removeAttr('inert');
            $(widget).removeAttr('aria-hidden');
          }
          else {
            $(widget).attr('inert', 'true');
            $(widget).attr('aria-hidden', 'true');
          }
        };

        turnstile.render(widget, {
          'before-interactive-callback': function () {
            if (appearance === 'interaction-only') {

              // Make the widget accessible when it becomes interactive.
              setA11yVisibility(true);
            }
          },
        });

        if (appearance === 'interaction-only') {

          // Stop the widget from being accessible until it becomes interactive.
          setA11yVisibility(false);
        }
      }
    });
  };
})(jQuery);
