import React from 'react';
import ReactDOM from 'react-dom/client';
import './index.css';
import TvContainer from './TvContainer';
import ErrorBoundary from './Components/ErrorBoundary';
import reportWebVitals from './reportWebVitals';

document.addEventListener('DOMContentLoaded', function () {
  const tvs = document.getElementsByClassName('tv');
  if (tvs.length === 0) {
    console.warn('No TV elements found - running in development mode');
    // For development, create a container and use default values
    const devContainer = document.createElement('div');
    devContainer.id = 'tv-dev-container';
    devContainer.style.width = '100%';
    devContainer.style.height = '100vh';
    document.body.appendChild(devContainer);

    ReactDOM.createRoot(devContainer).render(
      <React.StrictMode>
        <ErrorBoundary>
          <TvContainer root={devContainer} baseUrl="http://127.0.0.1:32890" channel="1" />
        </ErrorBoundary>
      </React.StrictMode>
    );
  } else {
    for (let tv of tvs) {
      let baseUrl = tv.dataset.baseUrl || '';
      let channel = tv.dataset.channel || 1;
      ReactDOM.createRoot(tv).render(
        <React.StrictMode>
          <ErrorBoundary>
            <TvContainer root={tv} baseUrl={baseUrl} channel={channel} />
          </ErrorBoundary>
        </React.StrictMode>
      );
    }
  }
});

// If you want to start measuring performance in your app, pass a function
// to log results (for example: reportWebVitals(console.log))
// or send to an analytics endpoint. Learn more: https://bit.ly/CRA-vitals
reportWebVitals();
