<?php

namespace Drupal\tv\Channel;

use Drupal\node\NodeInterface;

/**
 * Interface for TV Channel context providers.
 */
interface ChannelContextProviderInterface {
  /**
   * Returns TV Channel nodes or NULL if not available.
   *
   * @param array $context
   *   Optional context for determining the channels.
   *
   * @return \Drupal\node\NodeInterface[]
   *   The TV Channel nodes, if any.
   */
  public function getChannelNodes(array $context = []): array;
}
