<?php

namespace Drupal\tv\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\node\NodeInterface;
use Drupal\tv\Service\TvChannelServiceInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Returns responses for Node routes.
 */
class TvChannelController extends ControllerBase implements ContainerInjectionInterface {

    public function getChannel(NodeInterface $node): JsonResponse
    {
        /** @var TvChannelServiceInterface $channelService */
        $channelService = \Drupal::service('tv.channel');
        return new JsonResponse([
            'title' => $node->getTitle(),
            'method' => 'GET',
            'status'=> 200,
            'autoplay' => $channelService->getAutoPlayPreference(),
            'mute' => $channelService->getMutePreference(),
            'playlist' => $channelService->getItems($node),
        ], 200);
    }

    public function updateProgress(Request $request): JsonResponse
    {
        $data = json_decode($request->getContent(), true);
        $mediaId = $data['media_id'] ?? null;
        $progress = $data['progress'] ?? null;

        if (!$mediaId || !is_numeric($progress)) {
            return new JsonResponse(['error' => 'Invalid data'], 400);
        }

        /** @var TvChannelServiceInterface $channelService */
        $channelService = \Drupal::service('tv.channel');
        $channelService->updateProgress($mediaId, $progress);

        return new JsonResponse(['status' => 'ok'], 200);
    }

}
