import { useEffect } from 'react';
import AccordionMenu from './AccordionMenu';
import './Channels.css';

// Custom hook to fetch channels and set initial channel
export function useChannelsInit(getChannels, channels, currentChannelId, setCurrentChannelId) {
    // On mount, fetch channels
    useEffect(() => {
        try {
            getChannels();
        } catch (e) {
            console.error('[useChannelsInit] Error fetching channels:', e);
        }
    }, [getChannels]);

    // When channels are loaded, set the first channel as current if not set
    useEffect(() => {
        try {
            if (channels.length > 0 && !currentChannelId) {
                setCurrentChannelId(channels[0].id);
            }
        } catch (e) {
            console.error('[useChannelsInit] Error setting initial channel:', e);
        }
    }, [channels, currentChannelId, setCurrentChannelId]);
}

// Handler to select a channel (for use in TvContainer.js)
export const onChannelSelect = (setCurrentChannelId) => (id) => {
    setCurrentChannelId(id);
};

function ChannelList({ channels, currentChannelId, onChannelSelect, focused, headingRef, open, setOpen, scrollableHeight, getFocusState }) {
    const safeChannels = Array.isArray(channels) ? channels : [];
    return (
        <AccordionMenu heading="Channels" className="channels-menu" focused={focused} headingRef={headingRef} open={open} setOpen={setOpen} scrollableHeight={scrollableHeight}>
            <ul>
                {safeChannels.length === 0 && (
                    <li style={{color:'#888'}}>No channels available</li>
                )}
                {safeChannels.map((item, index) => (
                    <li key={item?.id || index} className={`${item?.id === currentChannelId ? 'current' : ''} ${getFocusState ? (getFocusState('channels', index, false) ? 'focused' : '') : ''}`}>
                        <a
                            href="/"
                            onClick={e => {
                                e.preventDefault();
                                onChannelSelect(item?.id);
                            }}
                            style={{ color: item?.id === currentChannelId ? '#fff' : '#ccc', fontWeight: item?.id === currentChannelId ? 600 : 400 }}
                        >
                            {item?.title || 'Untitled Channel'}
                        </a>
                    </li>
                ))}
            </ul>
        </AccordionMenu>
    );
}

export default ChannelList;
