import './AccordionMenu.css';

/**
 * AccordionMenu: A generic accordion menu section with dynamic scrollable height.
 * Props:
 * - open: boolean (expanded/collapsed)
 * - setOpen: function (toggle open state)
 * - heading: string or React node (menu heading)
 * - children: React node (menu content)
 * - className: string (for custom styling)
 */
function AccordionMenu({ open, setOpen, heading, children, className = '', headingRef, focused }) {
  const handleClick = () => {
    if (setOpen) {
      setOpen();
    } else {
      console.error('[AccordionMenu] setOpen function is not provided');
    }
  };

  return (
    <div className={`accordion-menu ${className}`.trim()}>
      <h3 ref={headingRef} onClick={handleClick} className={focused ? 'focused' : ''} style={{ cursor: 'pointer', userSelect: 'none' }}>
        {heading} {open ? <span style={{fontWeight:400}}>&#9660;</span> : <span style={{fontWeight:400}}>&#9654;</span>}
      </h3>
      <div
        className="scrollable"
        style={open ? { display: 'block', flex: 1 } : { display: 'none' }}
      >
        {children}
      </div>
    </div>
  );
}

export default AccordionMenu;
